;; This test tests same-component reading/writing of a stream and future
;; from the same component instance (which either traps or succeeds),
;; depending on the element type.

(component definition $Tester
  (core module $Memory (memory (export "mem") 1))
  (core instance $memory (instantiate $Memory))
  (core module $M
    (import "" "mem" (memory 1))
    (import "" "waitable.join" (func $waitable.join (param i32 i32)))
    (import "" "waitable-set.new" (func $waitable-set.new (result i32)))
    (import "" "waitable-set.wait" (func $waitable-set.wait (param i32 i32) (result i32)))
    (import "" "future.new" (func $future.new (result i64)))
    (import "" "future.read" (func $future.read (param i32 i32) (result i32)))
    (import "" "future.write" (func $future.write (param i32 i32) (result i32)))
    (import "" "stream.new" (func $stream.new (result i64)))
    (import "" "stream.read" (func $stream.read (param i32 i32 i32) (result i32)))
    (import "" "stream.write" (func $stream.write (param i32 i32 i32) (result i32)))
    (import "" "future.newc" (func $future.newc (result i64)))
    (import "" "future.readc" (func $future.readc (param i32 i32) (result i32)))
    (import "" "future.writec" (func $future.writec (param i32 i32) (result i32)))
    (import "" "stream.newc" (func $stream.newc (result i64)))
    (import "" "stream.readc" (func $stream.readc (param i32 i32 i32) (result i32)))
    (import "" "stream.writec" (func $stream.writec (param i32 i32 i32) (result i32)))

    (func (export "test-empty") (result i32)
      (local $ret i32) (local $ret64 i64)
      (local $rx i32) (local $tx i32)

      ;; test future reader then writer
      (local.set $ret64 (call $future.new))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $future.read (local.get $rx) (i32.const 0xdeadbeef)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (local.set $ret (call $future.write (local.get $tx) (i32.const 0xdeadbeef)))
      (if (i32.ne (i32.const 0 (; COMPLETED ;)) (local.get $ret))
        (then unreachable))

      ;; test future writer than reader
      (local.set $ret64 (call $future.new))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $future.write (local.get $tx) (i32.const 0xdeadbeef)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (local.set $ret (call $future.read (local.get $rx) (i32.const 0xdeadbeef)))
      (if (i32.ne (i32.const 0 (; COMPLETED ;)) (local.get $ret))
        (then unreachable))

      ;; test stream reader then writer
      (local.set $ret64 (call $stream.new))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $stream.read (local.get $rx) (i32.const 0xdeadbeef) (i32.const 1)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (local.set $ret (call $stream.write (local.get $tx) (i32.const 0xdeadbeef) (i32.const 1)))
      (if (i32.ne (i32.const 0x10 (; COMPLETED=0 | (1<<4) ;)) (local.get $ret))
        (then unreachable))

      ;; test stream writer than reader
      (local.set $ret64 (call $stream.new))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $stream.write (local.get $tx) (i32.const 0xdeadbeef) (i32.const 1)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (local.set $ret (call $stream.read (local.get $rx) (i32.const 0xdeadbeef) (i32.const 1)))
      (if (i32.ne (i32.const 0x10 (; COMPLETED=0 | (1<<4) ;)) (local.get $ret))
        (then unreachable))

      (i32.const 42)
    )

    (func (export "test-no-read-char")
      (local $ret i32) (local $ret64 i64)
      (local $rx i32) (local $tx i32)
      (local.set $ret64 (call $future.newc))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $future.readc (local.get $rx) (i32.const 0)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (call $future.writec (local.get $tx) (i32.const 0))
      unreachable
    )

    (func (export "test-no-write-char")
      (local $ret i32) (local $ret64 i64)
      (local $rx i32) (local $tx i32)
      (local.set $ret64 (call $future.newc))
      (local.set $rx (i32.wrap_i64 (local.get $ret64)))
      (local.set $tx (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))
      (local.set $ret (call $future.writec (local.get $tx) (i32.const 0)))
      (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
        (then unreachable))
      (call $future.readc (local.get $rx) (i32.const 0))
      unreachable
    )
  )
  (type $FT (future))
  (type $ST (stream))
  (type $FTC (future char))
  (type $STC (stream char))
  (canon waitable.join (core func $waitable.join))
  (canon waitable-set.wait (memory $memory "mem") (core func $waitable-set.wait))
  (canon waitable-set.new (core func $waitable-set.new))
  (canon future.new $FT (core func $future.new))
  (canon future.read $FT async (core func $future.read))
  (canon future.write $FT async (core func $future.write))
  (canon stream.new $ST (core func $stream.new))
  (canon stream.read $ST async (core func $stream.read))
  (canon stream.write $ST async (core func $stream.write))
  (canon future.new $FTC (core func $future.newc))
  (canon future.read $FTC async (memory $memory "mem") (core func $future.readc))
  (canon future.write $FTC async (memory $memory "mem") (core func $future.writec))
  (canon stream.new $STC (core func $stream.newc))
  (canon stream.read $STC async (memory $memory "mem") (core func $stream.readc))
  (canon stream.write $STC async (memory $memory "mem") (core func $stream.writec))
  (core instance $m (instantiate $M (with "" (instance
    (export "mem" (memory $memory "mem"))
    (export "waitable.join" (func $waitable.join))
    (export "waitable-set.new" (func $waitable-set.new))
    (export "waitable-set.wait" (func $waitable-set.wait))
    (export "future.new" (func $future.new))
    (export "future.read" (func $future.read))
    (export "future.write" (func $future.write))
    (export "stream.new" (func $stream.new))
    (export "stream.read" (func $stream.read))
    (export "stream.write" (func $stream.write))
    (export "future.newc" (func $future.newc))
    (export "future.readc" (func $future.readc))
    (export "future.writec" (func $future.writec))
    (export "stream.newc" (func $stream.newc))
    (export "stream.readc" (func $stream.readc))
    (export "stream.writec" (func $stream.writec))
  ))))
  (func (export "test-empty") (result u32) (canon lift (core func $m "test-empty")))
  (func (export "test-no-read-char") (canon lift (core func $m "test-no-read-char")))
  (func (export "test-no-write-char") (canon lift (core func $m "test-no-write-char")))
)
(component instance $i $Tester)
(assert_return (invoke "test-empty") (u32.const 42))
(component instance $i $Tester)
(assert_trap (invoke "test-no-read-char") "cannot read from and write to intra-component future")
(component instance $i $Tester)
(assert_trap (invoke "test-no-write-char") "cannot read from and write to intra-component future")
