(module
  (table $t2 i64 1 externref)
  (table $t3 i64 2 funcref)
  (elem (table $t3) (i64.const 1) func $dummy)
  (func $dummy)

  (func (export "get-externref") (param $i i64) (result externref)
    (table.get $t2 (local.get $i))
  )
  (func $f3 (export "get-funcref") (param $i i64) (result funcref)
    (table.get $t3 (local.get $i))
  )

  (func (export "set-externref") (param $i i64) (param $r externref)
    (table.set (local.get $i) (local.get $r))
  )
  (func (export "set-funcref") (param $i i64) (param $r funcref)
    (table.set $t3 (local.get $i) (local.get $r))
  )
  (func (export "set-funcref-from") (param $i i64) (param $j i64)
    (table.set $t3 (local.get $i) (table.get $t3 (local.get $j)))
  )

  (func (export "is_null-funcref") (param $i i64) (result i32)
    (ref.is_null (call $f3 (local.get $i)))
  )
)

(assert_return (invoke "get-externref" (i64.const 0)) (ref.null extern))
(assert_return (invoke "set-externref" (i64.const 0) (ref.extern 1)))
(assert_return (invoke "get-externref" (i64.const 0)) (ref.extern 1))
(assert_return (invoke "set-externref" (i64.const 0) (ref.null extern)))
(assert_return (invoke "get-externref" (i64.const 0)) (ref.null extern))

(assert_return (invoke "get-funcref" (i64.const 0)) (ref.null func))
(assert_return (invoke "set-funcref-from" (i64.const 0) (i64.const 1)))
(assert_return (invoke "is_null-funcref" (i64.const 0)) (i32.const 0))
(assert_return (invoke "set-funcref" (i64.const 0) (ref.null func)))
(assert_return (invoke "get-funcref" (i64.const 0)) (ref.null func))

(assert_trap (invoke "set-externref" (i64.const 2) (ref.null extern)) "out of bounds table access")
(assert_trap (invoke "set-funcref" (i64.const 3) (ref.null func)) "out of bounds table access")
(assert_trap (invoke "set-externref" (i64.const -1) (ref.null extern)) "out of bounds table access")
(assert_trap (invoke "set-funcref" (i64.const -1) (ref.null func)) "out of bounds table access")

(assert_trap (invoke "set-externref" (i64.const 2) (ref.extern 0)) "out of bounds table access")
(assert_trap (invoke "set-funcref-from" (i64.const 3) (i64.const 1)) "out of bounds table access")
(assert_trap (invoke "set-externref" (i64.const -1) (ref.extern 0)) "out of bounds table access")
(assert_trap (invoke "set-funcref-from" (i64.const -1) (i64.const 1)) "out of bounds table access")
