#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1261
#define LARGE_STATE_COUNT 12
#define SYMBOL_COUNT 191
#define ALIAS_COUNT 7
#define TOKEN_COUNT 104
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 80

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_template_content_token1 = 2,
  anon_sym_LBRACE_PERCENT_PERCENT = 3,
  anon_sym_LBRACE_LBRACE_LBRACE = 4,
  anon_sym_liquid = 5,
  aux_sym__liquid_node_token1 = 6,
  anon_sym_LBRACE_PERCENT = 7,
  anon_sym_LBRACE_PERCENT_DASH = 8,
  anon_sym_PERCENT_RBRACE = 9,
  anon_sym_DASH_PERCENT_RBRACE = 10,
  anon_sym_LBRACE_LBRACE = 11,
  anon_sym_LBRACE_LBRACE_DASH = 12,
  anon_sym_RBRACE_RBRACE = 13,
  anon_sym_DASH_RBRACE_RBRACE = 14,
  anon_sym_SQUOTE = 15,
  aux_sym_string_token1 = 16,
  anon_sym_DQUOTE = 17,
  aux_sym_string_token2 = 18,
  sym_number = 19,
  anon_sym_true = 20,
  anon_sym_false = 21,
  anon_sym_PLUS = 22,
  anon_sym_DASH = 23,
  anon_sym_STAR = 24,
  anon_sym_SLASH = 25,
  anon_sym_PERCENT = 26,
  anon_sym_CARET = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_LT = 29,
  anon_sym_LT_EQ = 30,
  anon_sym_BANG_EQ = 31,
  anon_sym_GT_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_and = 34,
  anon_sym_or = 35,
  anon_sym_contains = 36,
  sym_break_statement = 37,
  sym_continue_statement = 38,
  anon_sym_echo = 39,
  anon_sym_section = 40,
  anon_sym_sections = 41,
  anon_sym_increment = 42,
  anon_sym_decrement = 43,
  anon_sym_layout = 44,
  anon_sym_none = 45,
  anon_sym_assign = 46,
  anon_sym_EQ = 47,
  anon_sym_cycle = 48,
  anon_sym_COLON = 49,
  anon_sym_COMMA = 50,
  anon_sym_include = 51,
  anon_sym_include_relative = 52,
  aux_sym_include_statement_token1 = 53,
  anon_sym_EQ2 = 54,
  anon_sym_render = 55,
  anon_sym_for = 56,
  anon_sym_with = 57,
  anon_sym_as = 58,
  anon_sym_PIPE = 59,
  anon_sym_DOT = 60,
  anon_sym_LBRACK = 61,
  anon_sym_RBRACK = 62,
  anon_sym_LPAREN = 63,
  anon_sym_DOT_DOT = 64,
  anon_sym_RPAREN = 65,
  anon_sym_if = 66,
  anon_sym_endif = 67,
  anon_sym_elsif = 68,
  anon_sym_else = 69,
  anon_sym_in = 70,
  anon_sym_endfor = 71,
  anon_sym_case = 72,
  anon_sym_endcase = 73,
  anon_sym_when = 74,
  anon_sym_unless = 75,
  anon_sym_endunless = 76,
  anon_sym_capture = 77,
  anon_sym_endcapture = 78,
  anon_sym_form = 79,
  anon_sym_endform = 80,
  anon_sym_tablerow = 81,
  anon_sym_endtablerow = 82,
  anon_sym_paginate = 83,
  anon_sym_by = 84,
  anon_sym_endpaginate = 85,
  anon_sym_schema = 86,
  anon_sym_endschema = 87,
  anon_sym_style = 88,
  anon_sym_endstyle = 89,
  anon_sym_stylesheet = 90,
  anon_sym_endstylesheet = 91,
  anon_sym_javascript = 92,
  anon_sym_endjavascript = 93,
  anon_sym_raw = 94,
  anon_sym_endraw = 95,
  anon_sym_comment = 96,
  anon_sym_endcomment = 97,
  sym__inline_comment_content = 98,
  sym__paired_comment_content = 99,
  sym__paired_comment_content_liq = 100,
  sym_raw_content = 101,
  sym_front_matter = 102,
  sym_error_sentinel = 103,
  sym_program = 104,
  sym__node = 105,
  sym_template_content = 106,
  sym__statement = 107,
  sym_liquid_tag = 108,
  sym__liquid_node = 109,
  sym__tagged_unpaired_statement = 110,
  sym__output_statement = 111,
  sym__untagged_unpaired_statement = 112,
  sym__tagged_paired_statment = 113,
  sym__untagged_paired_statement = 114,
  sym__expression = 115,
  sym__literal = 116,
  sym_string = 117,
  sym_boolean = 118,
  sym_predicate = 119,
  sym_echo_statement = 120,
  sym_section_statement = 121,
  sym_sections_statement = 122,
  sym_increment_statement = 123,
  sym_decrement_statement = 124,
  sym_layout_statement = 125,
  sym_custom_unpaired_statement = 126,
  sym_assignment_statement = 127,
  sym_cycle_statement = 128,
  sym_include_statement = 129,
  sym__include_param = 130,
  sym_render_statement = 131,
  sym__render_param = 132,
  sym_filter = 133,
  sym_access = 134,
  sym_argument_list = 135,
  sym_argument = 136,
  sym_range = 137,
  sym_if_statement = 138,
  sym_elsif_clause = 139,
  sym_else_clause = 140,
  sym_for_loop_statement = 141,
  sym_case_statement = 142,
  sym_when_clause = 143,
  sym_unless_statement = 144,
  sym_capture_statement = 145,
  sym_form_statement = 146,
  sym_tablerow_statement = 147,
  sym_paginate_statement = 148,
  sym__if_liq = 149,
  sym__elsif_liq = 150,
  sym__else_liq = 151,
  sym__for_loop_liq = 152,
  sym__case_liq = 153,
  sym__when_liq = 154,
  sym__unless_liq = 155,
  sym__capture_liq = 156,
  sym__form_liq = 157,
  sym__tablerow_liq = 158,
  sym__paginate_liq = 159,
  sym__else_aliased = 160,
  sym__elsif_aliased = 161,
  sym__when_aliased = 162,
  sym__iterator = 163,
  sym__page_iterator = 164,
  sym_schema_statement = 165,
  sym_style_statement = 166,
  sym_stylesheet_statement = 167,
  sym_javascript_statement = 168,
  sym_raw_statement = 169,
  sym_comment = 170,
  sym_comment_liq = 171,
  sym__inline_comment = 172,
  sym__paired_comment = 173,
  sym__paired_comment_liq = 174,
  aux_sym_program_repeat1 = 175,
  aux_sym_template_content_repeat1 = 176,
  aux_sym_liquid_tag_repeat1 = 177,
  aux_sym_custom_unpaired_statement_repeat1 = 178,
  aux_sym_cycle_statement_repeat1 = 179,
  aux_sym_include_statement_repeat1 = 180,
  aux_sym_argument_list_repeat1 = 181,
  aux_sym_if_statement_repeat1 = 182,
  aux_sym_case_statement_repeat1 = 183,
  aux_sym__if_liq_repeat1 = 184,
  aux_sym__if_liq_repeat2 = 185,
  aux_sym__case_liq_repeat1 = 186,
  aux_sym_style_statement_repeat1 = 187,
  aux_sym_stylesheet_statement_repeat1 = 188,
  aux_sym_javascript_statement_repeat1 = 189,
  aux_sym__inline_comment_repeat1 = 190,
  anon_alias_sym_ = 191,
  alias_sym_block = 192,
  anon_alias_sym_custom_keyword = 193,
  alias_sym_js_content = 194,
  alias_sym_json_content = 195,
  alias_sym_style_content = 196,
  alias_sym_stylesheet_content = 197,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_template_content_token1] = "template_content_token1",
  [anon_sym_LBRACE_PERCENT_PERCENT] = "{%%",
  [anon_sym_LBRACE_LBRACE_LBRACE] = "{{{",
  [anon_sym_liquid] = "liquid",
  [aux_sym__liquid_node_token1] = "_liquid_node_token1",
  [anon_sym_LBRACE_PERCENT] = "{%",
  [anon_sym_LBRACE_PERCENT_DASH] = "{%-",
  [anon_sym_PERCENT_RBRACE] = "%}",
  [anon_sym_DASH_PERCENT_RBRACE] = "-%}",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_LBRACE_LBRACE_DASH] = "{{-",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_DASH_RBRACE_RBRACE] = "-}}",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token2] = "string_token2",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_contains] = "contains",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_echo] = "echo",
  [anon_sym_section] = "section",
  [anon_sym_sections] = "sections",
  [anon_sym_increment] = "increment",
  [anon_sym_decrement] = "decrement",
  [anon_sym_layout] = "layout",
  [anon_sym_none] = "none",
  [anon_sym_assign] = "assign",
  [anon_sym_EQ] = "=",
  [anon_sym_cycle] = "cycle",
  [anon_sym_COLON] = ":",
  [anon_sym_COMMA] = ",",
  [anon_sym_include] = "include",
  [anon_sym_include_relative] = "include_relative",
  [aux_sym_include_statement_token1] = "string",
  [anon_sym_EQ2] = "=",
  [anon_sym_render] = "render",
  [anon_sym_for] = "for",
  [anon_sym_with] = "with",
  [anon_sym_as] = "as",
  [anon_sym_PIPE] = "|",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_RPAREN] = ")",
  [anon_sym_if] = "if",
  [anon_sym_endif] = "endif",
  [anon_sym_elsif] = "elsif",
  [anon_sym_else] = "else",
  [anon_sym_in] = "in",
  [anon_sym_endfor] = "endfor",
  [anon_sym_case] = "case",
  [anon_sym_endcase] = "endcase",
  [anon_sym_when] = "when",
  [anon_sym_unless] = "unless",
  [anon_sym_endunless] = "endunless",
  [anon_sym_capture] = "capture",
  [anon_sym_endcapture] = "endcapture",
  [anon_sym_form] = "form",
  [anon_sym_endform] = "endform",
  [anon_sym_tablerow] = "tablerow",
  [anon_sym_endtablerow] = "endtablerow",
  [anon_sym_paginate] = "paginate",
  [anon_sym_by] = "by",
  [anon_sym_endpaginate] = "endpaginate",
  [anon_sym_schema] = "schema",
  [anon_sym_endschema] = "endschema",
  [anon_sym_style] = "style",
  [anon_sym_endstyle] = "endstyle",
  [anon_sym_stylesheet] = "stylesheet",
  [anon_sym_endstylesheet] = "endstylesheet",
  [anon_sym_javascript] = "javascript",
  [anon_sym_endjavascript] = "endjavascript",
  [anon_sym_raw] = "raw",
  [anon_sym_endraw] = "endraw",
  [anon_sym_comment] = "comment",
  [anon_sym_endcomment] = "endcomment",
  [sym__inline_comment_content] = "_inline_comment_content",
  [sym__paired_comment_content] = "_paired_comment_content",
  [sym__paired_comment_content_liq] = "_paired_comment_content_liq",
  [sym_raw_content] = "raw_content",
  [sym_front_matter] = "front_matter",
  [sym_error_sentinel] = "error_sentinel",
  [sym_program] = "program",
  [sym__node] = "_node",
  [sym_template_content] = "template_content",
  [sym__statement] = "_statement",
  [sym_liquid_tag] = "liquid_tag",
  [sym__liquid_node] = "_liquid_node",
  [sym__tagged_unpaired_statement] = "_tagged_unpaired_statement",
  [sym__output_statement] = "_output_statement",
  [sym__untagged_unpaired_statement] = "_untagged_unpaired_statement",
  [sym__tagged_paired_statment] = "_tagged_paired_statment",
  [sym__untagged_paired_statement] = "_untagged_paired_statement",
  [sym__expression] = "_expression",
  [sym__literal] = "_literal",
  [sym_string] = "string",
  [sym_boolean] = "boolean",
  [sym_predicate] = "predicate",
  [sym_echo_statement] = "echo_statement",
  [sym_section_statement] = "section_statement",
  [sym_sections_statement] = "sections_statement",
  [sym_increment_statement] = "increment_statement",
  [sym_decrement_statement] = "decrement_statement",
  [sym_layout_statement] = "layout_statement",
  [sym_custom_unpaired_statement] = "custom_unpaired_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_cycle_statement] = "cycle_statement",
  [sym_include_statement] = "include_statement",
  [sym__include_param] = "_include_param",
  [sym_render_statement] = "render_statement",
  [sym__render_param] = "_render_param",
  [sym_filter] = "filter",
  [sym_access] = "access",
  [sym_argument_list] = "argument_list",
  [sym_argument] = "argument",
  [sym_range] = "range",
  [sym_if_statement] = "if_statement",
  [sym_elsif_clause] = "elsif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_loop_statement] = "for_loop_statement",
  [sym_case_statement] = "case_statement",
  [sym_when_clause] = "when_clause",
  [sym_unless_statement] = "unless_statement",
  [sym_capture_statement] = "capture_statement",
  [sym_form_statement] = "form_statement",
  [sym_tablerow_statement] = "tablerow_statement",
  [sym_paginate_statement] = "paginate_statement",
  [sym__if_liq] = "if_statement",
  [sym__elsif_liq] = "elsif_clause",
  [sym__else_liq] = "else_clause",
  [sym__for_loop_liq] = "for_loop_statement",
  [sym__case_liq] = "case_statement",
  [sym__when_liq] = "when_clause",
  [sym__unless_liq] = "unless_statement",
  [sym__capture_liq] = "capture_statement",
  [sym__form_liq] = "form_statement",
  [sym__tablerow_liq] = "tablerow_statement",
  [sym__paginate_liq] = "paginate_statement",
  [sym__else_aliased] = "_else_aliased",
  [sym__elsif_aliased] = "_elsif_aliased",
  [sym__when_aliased] = "_when_aliased",
  [sym__iterator] = "_iterator",
  [sym__page_iterator] = "_page_iterator",
  [sym_schema_statement] = "schema_statement",
  [sym_style_statement] = "style_statement",
  [sym_stylesheet_statement] = "stylesheet_statement",
  [sym_javascript_statement] = "javascript_statement",
  [sym_raw_statement] = "raw_statement",
  [sym_comment] = "comment",
  [sym_comment_liq] = "comment",
  [sym__inline_comment] = "_inline_comment",
  [sym__paired_comment] = "_paired_comment",
  [sym__paired_comment_liq] = "_paired_comment_liq",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_template_content_repeat1] = "template_content_repeat1",
  [aux_sym_liquid_tag_repeat1] = "liquid_tag_repeat1",
  [aux_sym_custom_unpaired_statement_repeat1] = "custom_unpaired_statement_repeat1",
  [aux_sym_cycle_statement_repeat1] = "cycle_statement_repeat1",
  [aux_sym_include_statement_repeat1] = "include_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym__if_liq_repeat1] = "_if_liq_repeat1",
  [aux_sym__if_liq_repeat2] = "_if_liq_repeat2",
  [aux_sym__case_liq_repeat1] = "_case_liq_repeat1",
  [aux_sym_style_statement_repeat1] = "style_statement_repeat1",
  [aux_sym_stylesheet_statement_repeat1] = "stylesheet_statement_repeat1",
  [aux_sym_javascript_statement_repeat1] = "javascript_statement_repeat1",
  [aux_sym__inline_comment_repeat1] = "_inline_comment_repeat1",
  [anon_alias_sym_] = "",
  [alias_sym_block] = "block",
  [anon_alias_sym_custom_keyword] = "custom_keyword",
  [alias_sym_js_content] = "js_content",
  [alias_sym_json_content] = "json_content",
  [alias_sym_style_content] = "style_content",
  [alias_sym_stylesheet_content] = "stylesheet_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_template_content_token1] = aux_sym_template_content_token1,
  [anon_sym_LBRACE_PERCENT_PERCENT] = anon_sym_LBRACE_PERCENT_PERCENT,
  [anon_sym_LBRACE_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE_LBRACE,
  [anon_sym_liquid] = anon_sym_liquid,
  [aux_sym__liquid_node_token1] = aux_sym__liquid_node_token1,
  [anon_sym_LBRACE_PERCENT] = anon_sym_LBRACE_PERCENT,
  [anon_sym_LBRACE_PERCENT_DASH] = anon_sym_LBRACE_PERCENT_DASH,
  [anon_sym_PERCENT_RBRACE] = anon_sym_PERCENT_RBRACE,
  [anon_sym_DASH_PERCENT_RBRACE] = anon_sym_DASH_PERCENT_RBRACE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_LBRACE_LBRACE_DASH] = anon_sym_LBRACE_LBRACE_DASH,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_DASH_RBRACE_RBRACE] = anon_sym_DASH_RBRACE_RBRACE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_contains] = anon_sym_contains,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_section] = anon_sym_section,
  [anon_sym_sections] = anon_sym_sections,
  [anon_sym_increment] = anon_sym_increment,
  [anon_sym_decrement] = anon_sym_decrement,
  [anon_sym_layout] = anon_sym_layout,
  [anon_sym_none] = anon_sym_none,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_cycle] = anon_sym_cycle,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_include_relative] = anon_sym_include_relative,
  [aux_sym_include_statement_token1] = sym_string,
  [anon_sym_EQ2] = anon_sym_EQ,
  [anon_sym_render] = anon_sym_render,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_endfor] = anon_sym_endfor,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_endcase] = anon_sym_endcase,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_unless] = anon_sym_unless,
  [anon_sym_endunless] = anon_sym_endunless,
  [anon_sym_capture] = anon_sym_capture,
  [anon_sym_endcapture] = anon_sym_endcapture,
  [anon_sym_form] = anon_sym_form,
  [anon_sym_endform] = anon_sym_endform,
  [anon_sym_tablerow] = anon_sym_tablerow,
  [anon_sym_endtablerow] = anon_sym_endtablerow,
  [anon_sym_paginate] = anon_sym_paginate,
  [anon_sym_by] = anon_sym_by,
  [anon_sym_endpaginate] = anon_sym_endpaginate,
  [anon_sym_schema] = anon_sym_schema,
  [anon_sym_endschema] = anon_sym_endschema,
  [anon_sym_style] = anon_sym_style,
  [anon_sym_endstyle] = anon_sym_endstyle,
  [anon_sym_stylesheet] = anon_sym_stylesheet,
  [anon_sym_endstylesheet] = anon_sym_endstylesheet,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_endjavascript] = anon_sym_endjavascript,
  [anon_sym_raw] = anon_sym_raw,
  [anon_sym_endraw] = anon_sym_endraw,
  [anon_sym_comment] = anon_sym_comment,
  [anon_sym_endcomment] = anon_sym_endcomment,
  [sym__inline_comment_content] = sym__inline_comment_content,
  [sym__paired_comment_content] = sym__paired_comment_content,
  [sym__paired_comment_content_liq] = sym__paired_comment_content_liq,
  [sym_raw_content] = sym_raw_content,
  [sym_front_matter] = sym_front_matter,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_program] = sym_program,
  [sym__node] = sym__node,
  [sym_template_content] = sym_template_content,
  [sym__statement] = sym__statement,
  [sym_liquid_tag] = sym_liquid_tag,
  [sym__liquid_node] = sym__liquid_node,
  [sym__tagged_unpaired_statement] = sym__tagged_unpaired_statement,
  [sym__output_statement] = sym__output_statement,
  [sym__untagged_unpaired_statement] = sym__untagged_unpaired_statement,
  [sym__tagged_paired_statment] = sym__tagged_paired_statment,
  [sym__untagged_paired_statement] = sym__untagged_paired_statement,
  [sym__expression] = sym__expression,
  [sym__literal] = sym__literal,
  [sym_string] = sym_string,
  [sym_boolean] = sym_boolean,
  [sym_predicate] = sym_predicate,
  [sym_echo_statement] = sym_echo_statement,
  [sym_section_statement] = sym_section_statement,
  [sym_sections_statement] = sym_sections_statement,
  [sym_increment_statement] = sym_increment_statement,
  [sym_decrement_statement] = sym_decrement_statement,
  [sym_layout_statement] = sym_layout_statement,
  [sym_custom_unpaired_statement] = sym_custom_unpaired_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_cycle_statement] = sym_cycle_statement,
  [sym_include_statement] = sym_include_statement,
  [sym__include_param] = sym__include_param,
  [sym_render_statement] = sym_render_statement,
  [sym__render_param] = sym__render_param,
  [sym_filter] = sym_filter,
  [sym_access] = sym_access,
  [sym_argument_list] = sym_argument_list,
  [sym_argument] = sym_argument,
  [sym_range] = sym_range,
  [sym_if_statement] = sym_if_statement,
  [sym_elsif_clause] = sym_elsif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_loop_statement] = sym_for_loop_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_when_clause] = sym_when_clause,
  [sym_unless_statement] = sym_unless_statement,
  [sym_capture_statement] = sym_capture_statement,
  [sym_form_statement] = sym_form_statement,
  [sym_tablerow_statement] = sym_tablerow_statement,
  [sym_paginate_statement] = sym_paginate_statement,
  [sym__if_liq] = sym_if_statement,
  [sym__elsif_liq] = sym_elsif_clause,
  [sym__else_liq] = sym_else_clause,
  [sym__for_loop_liq] = sym_for_loop_statement,
  [sym__case_liq] = sym_case_statement,
  [sym__when_liq] = sym_when_clause,
  [sym__unless_liq] = sym_unless_statement,
  [sym__capture_liq] = sym_capture_statement,
  [sym__form_liq] = sym_form_statement,
  [sym__tablerow_liq] = sym_tablerow_statement,
  [sym__paginate_liq] = sym_paginate_statement,
  [sym__else_aliased] = sym__else_aliased,
  [sym__elsif_aliased] = sym__elsif_aliased,
  [sym__when_aliased] = sym__when_aliased,
  [sym__iterator] = sym__iterator,
  [sym__page_iterator] = sym__page_iterator,
  [sym_schema_statement] = sym_schema_statement,
  [sym_style_statement] = sym_style_statement,
  [sym_stylesheet_statement] = sym_stylesheet_statement,
  [sym_javascript_statement] = sym_javascript_statement,
  [sym_raw_statement] = sym_raw_statement,
  [sym_comment] = sym_comment,
  [sym_comment_liq] = sym_comment,
  [sym__inline_comment] = sym__inline_comment,
  [sym__paired_comment] = sym__paired_comment,
  [sym__paired_comment_liq] = sym__paired_comment_liq,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_template_content_repeat1] = aux_sym_template_content_repeat1,
  [aux_sym_liquid_tag_repeat1] = aux_sym_liquid_tag_repeat1,
  [aux_sym_custom_unpaired_statement_repeat1] = aux_sym_custom_unpaired_statement_repeat1,
  [aux_sym_cycle_statement_repeat1] = aux_sym_cycle_statement_repeat1,
  [aux_sym_include_statement_repeat1] = aux_sym_include_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym__if_liq_repeat1] = aux_sym__if_liq_repeat1,
  [aux_sym__if_liq_repeat2] = aux_sym__if_liq_repeat2,
  [aux_sym__case_liq_repeat1] = aux_sym__case_liq_repeat1,
  [aux_sym_style_statement_repeat1] = aux_sym_style_statement_repeat1,
  [aux_sym_stylesheet_statement_repeat1] = aux_sym_stylesheet_statement_repeat1,
  [aux_sym_javascript_statement_repeat1] = aux_sym_javascript_statement_repeat1,
  [aux_sym__inline_comment_repeat1] = aux_sym__inline_comment_repeat1,
  [anon_alias_sym_] = anon_alias_sym_,
  [alias_sym_block] = alias_sym_block,
  [anon_alias_sym_custom_keyword] = anon_alias_sym_custom_keyword,
  [alias_sym_js_content] = alias_sym_js_content,
  [alias_sym_json_content] = alias_sym_json_content,
  [alias_sym_style_content] = alias_sym_style_content,
  [alias_sym_stylesheet_content] = alias_sym_stylesheet_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_template_content_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_liquid] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__liquid_node_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contains] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_section] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sections] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_increment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decrement] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_layout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_none] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cycle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include_relative] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_include_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_render] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcase] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endunless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_capture] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcapture] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_form] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endform] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tablerow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endtablerow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_paginate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endpaginate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_schema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endschema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_style] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endstyle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stylesheet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endstylesheet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endjavascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endraw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endcomment] = {
    .visible = true,
    .named = false,
  },
  [sym__inline_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_content_liq] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_content] = {
    .visible = true,
    .named = true,
  },
  [sym_front_matter] = {
    .visible = true,
    .named = true,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym_template_content] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_liquid_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__liquid_node] = {
    .visible = false,
    .named = true,
  },
  [sym__tagged_unpaired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__output_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__untagged_unpaired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__tagged_paired_statment] = {
    .visible = false,
    .named = true,
  },
  [sym__untagged_paired_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_echo_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_section_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_sections_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_increment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decrement_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_layout_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_unpaired_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_cycle_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__include_param] = {
    .visible = false,
    .named = true,
  },
  [sym_render_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__render_param] = {
    .visible = false,
    .named = true,
  },
  [sym_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_access] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elsif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_when_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_unless_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_form_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_tablerow_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_paginate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__elsif_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__else_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__for_loop_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__case_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__when_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__unless_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__capture_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__form_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__tablerow_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__paginate_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__else_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__elsif_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__when_aliased] = {
    .visible = false,
    .named = true,
  },
  [sym__iterator] = {
    .visible = false,
    .named = true,
  },
  [sym__page_iterator] = {
    .visible = false,
    .named = true,
  },
  [sym_schema_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_style_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_stylesheet_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_javascript_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_liq] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_comment_liq] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_liquid_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_custom_unpaired_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cycle_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_include_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__if_liq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__if_liq_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__case_liq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_style_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_stylesheet_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_javascript_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_block] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_custom_keyword] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_js_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_json_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_style_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_stylesheet_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_conditions = 5,
  field_consequence = 6,
  field_end = 7,
  field_file = 8,
  field_group_item = 9,
  field_group_name = 10,
  field_item = 11,
  field_iteration = 12,
  field_iterator = 13,
  field_key = 14,
  field_left = 15,
  field_modifier = 16,
  field_name = 17,
  field_operator = 18,
  field_parameters = 19,
  field_property = 20,
  field_receiver = 21,
  field_right = 22,
  field_start = 23,
  field_type = 24,
  field_value = 25,
  field_variable = 26,
  field_variable_name = 27,
  field_with = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_conditions] = "conditions",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_file] = "file",
  [field_group_item] = "group_item",
  [field_group_name] = "group_name",
  [field_item] = "item",
  [field_iteration] = "iteration",
  [field_iterator] = "iterator",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifier] = "modifier",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_property] = "property",
  [field_receiver] = "receiver",
  [field_right] = "right",
  [field_start] = "start",
  [field_type] = "type",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_variable_name] = "variable_name",
  [field_with] = "with",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 3},
  [3] = {.index = 3, .length = 5},
  [4] = {.index = 8, .length = 3},
  [5] = {.index = 11, .length = 2},
  [6] = {.index = 13, .length = 2},
  [7] = {.index = 15, .length = 4},
  [8] = {.index = 19, .length = 1},
  [9] = {.index = 20, .length = 1},
  [10] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 2},
  [15] = {.index = 25, .length = 3},
  [16] = {.index = 28, .length = 2},
  [17] = {.index = 30, .length = 1},
  [18] = {.index = 31, .length = 1},
  [19] = {.index = 32, .length = 1},
  [20] = {.index = 33, .length = 1},
  [21] = {.index = 34, .length = 2},
  [22] = {.index = 36, .length = 1},
  [23] = {.index = 37, .length = 1},
  [24] = {.index = 38, .length = 2},
  [25] = {.index = 40, .length = 3},
  [26] = {.index = 43, .length = 3},
  [27] = {.index = 46, .length = 4},
  [28] = {.index = 50, .length = 4},
  [29] = {.index = 54, .length = 1},
  [31] = {.index = 55, .length = 2},
  [32] = {.index = 57, .length = 2},
  [33] = {.index = 59, .length = 2},
  [34] = {.index = 61, .length = 2},
  [35] = {.index = 63, .length = 2},
  [36] = {.index = 65, .length = 2},
  [37] = {.index = 67, .length = 2},
  [38] = {.index = 69, .length = 4},
  [39] = {.index = 73, .length = 2},
  [40] = {.index = 75, .length = 3},
  [41] = {.index = 30, .length = 1},
  [42] = {.index = 78, .length = 3},
  [43] = {.index = 81, .length = 3},
  [44] = {.index = 84, .length = 3},
  [45] = {.index = 87, .length = 3},
  [46] = {.index = 90, .length = 3},
  [47] = {.index = 93, .length = 2},
  [48] = {.index = 95, .length = 1},
  [49] = {.index = 96, .length = 1},
  [50] = {.index = 97, .length = 1},
  [51] = {.index = 98, .length = 1},
  [52] = {.index = 99, .length = 1},
  [53] = {.index = 100, .length = 3},
  [56] = {.index = 103, .length = 4},
  [57] = {.index = 107, .length = 4},
  [58] = {.index = 111, .length = 4},
  [60] = {.index = 115, .length = 2},
  [61] = {.index = 117, .length = 2},
  [62] = {.index = 119, .length = 2},
  [63] = {.index = 121, .length = 2},
  [64] = {.index = 123, .length = 2},
  [65] = {.index = 125, .length = 2},
  [67] = {.index = 127, .length = 5},
  [68] = {.index = 132, .length = 2},
  [69] = {.index = 134, .length = 3},
  [70] = {.index = 96, .length = 1},
  [71] = {.index = 137, .length = 3},
  [72] = {.index = 140, .length = 3},
  [73] = {.index = 143, .length = 3},
  [74] = {.index = 146, .length = 3},
  [75] = {.index = 149, .length = 3},
  [76] = {.index = 152, .length = 4},
  [77] = {.index = 156, .length = 4},
  [78] = {.index = 160, .length = 4},
  [79] = {.index = 164, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_alternative, 0, .inherited = true},
    {field_condition, 0, .inherited = true},
    {field_consequence, 0, .inherited = true},
  [3] =
    {field_alternative, 0, .inherited = true},
    {field_body, 0, .inherited = true},
    {field_item, 0, .inherited = true},
    {field_iterator, 0, .inherited = true},
    {field_modifier, 0, .inherited = true},
  [8] =
    {field_alternative, 0, .inherited = true},
    {field_conditions, 0, .inherited = true},
    {field_receiver, 0, .inherited = true},
  [11] =
    {field_value, 0, .inherited = true},
    {field_variable, 0, .inherited = true},
  [13] =
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [15] =
    {field_body, 0, .inherited = true},
    {field_item, 0, .inherited = true},
    {field_iterator, 0, .inherited = true},
    {field_modifier, 0, .inherited = true},
  [19] =
    {field_group_item, 1},
  [20] =
    {field_file, 1},
  [21] =
    {field_group_item, 1},
    {field_group_item, 2},
  [23] =
    {field_property, 2},
    {field_receiver, 0},
  [25] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [28] =
    {field_body, 0},
    {field_name, 2},
  [30] =
    {field_condition, 1},
  [31] =
    {field_condition, 0, .inherited = true},
  [32] =
    {field_alternative, 0},
  [33] =
    {field_receiver, 1},
  [34] =
    {field_condition, 0, .inherited = true},
    {field_consequence, 0, .inherited = true},
  [36] =
    {field_variable, 1},
  [37] =
    {field_type, 1},
  [38] =
    {field_value, 3},
    {field_variable_name, 1},
  [40] =
    {field_group_item, 3},
    {field_group_name, 1},
    {field_group_name, 2},
  [43] =
    {field_arguments, 2},
    {field_arguments, 3},
    {field_file, 1},
  [46] =
    {field_file, 1},
    {field_item, 3, .inherited = true},
    {field_iteration, 2},
    {field_iteration, 3},
  [50] =
    {field_file, 1},
    {field_item, 3, .inherited = true},
    {field_with, 2},
    {field_with, 3},
  [54] =
    {field_iterator, 0},
  [55] =
    {field_alternative, 2},
    {field_condition, 1},
  [57] =
    {field_condition, 1},
    {field_consequence, 2},
  [59] =
    {field_alternative, 2, .inherited = true},
    {field_condition, 1},
  [61] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [63] =
    {field_alternative, 2},
    {field_receiver, 1},
  [65] =
    {field_conditions, 2},
    {field_receiver, 1},
  [67] =
    {field_value, 2},
    {field_variable, 1},
  [69] =
    {field_group_item, 3},
    {field_group_item, 4},
    {field_group_name, 1},
    {field_group_name, 2},
  [73] =
    {field_iterator, 0},
    {field_modifier, 1},
  [75] =
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [78] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [81] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
    {field_consequence, 2},
  [84] =
    {field_alternative, 2, .inherited = true},
    {field_alternative, 3},
    {field_condition, 1},
  [87] =
    {field_alternative, 3},
    {field_conditions, 2},
    {field_receiver, 1},
  [90] =
    {field_parameters, 2},
    {field_parameters, 3},
    {field_type, 1},
  [93] =
    {field_key, 0},
    {field_value, 2},
  [95] =
    {field_item, 2},
  [96] =
    {field_condition, 2},
  [97] =
    {field_receiver, 2},
  [98] =
    {field_variable, 2},
  [99] =
    {field_type, 2},
  [100] =
    {field_iterator, 0},
    {field_modifier, 1},
    {field_modifier, 2},
  [103] =
    {field_alternative, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [107] =
    {field_body, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [111] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [115] =
    {field_alternative, 4},
    {field_condition, 2},
  [117] =
    {field_condition, 2},
    {field_consequence, 4},
  [119] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 2},
  [121] =
    {field_alternative, 4},
    {field_receiver, 2},
  [123] =
    {field_conditions, 4},
    {field_receiver, 2},
  [125] =
    {field_value, 4},
    {field_variable, 2},
  [127] =
    {field_alternative, 5},
    {field_body, 4},
    {field_item, 1},
    {field_iterator, 3, .inherited = true},
    {field_modifier, 3, .inherited = true},
  [132] =
    {field_end, 3},
    {field_start, 1},
  [134] =
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [137] =
    {field_alternative, 5},
    {field_condition, 2},
    {field_consequence, 4},
  [140] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 2},
    {field_consequence, 4},
  [143] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 2},
  [146] =
    {field_alternative, 5},
    {field_conditions, 4},
    {field_receiver, 2},
  [149] =
    {field_parameters, 3},
    {field_parameters, 4},
    {field_type, 2},
  [152] =
    {field_alternative, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [156] =
    {field_body, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
  [160] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [164] =
    {field_alternative, 7},
    {field_body, 6},
    {field_item, 2},
    {field_iterator, 4, .inherited = true},
    {field_modifier, 4, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_alias_sym_custom_keyword,
  },
  [11] = {
    [0] = alias_sym_style_content,
  },
  [12] = {
    [0] = alias_sym_stylesheet_content,
  },
  [13] = {
    [0] = alias_sym_js_content,
  },
  [30] = {
    [1] = alias_sym_block,
  },
  [32] = {
    [2] = alias_sym_block,
  },
  [36] = {
    [2] = alias_sym_block,
  },
  [37] = {
    [2] = alias_sym_block,
  },
  [41] = {
    [2] = alias_sym_block,
  },
  [42] = {
    [2] = alias_sym_block,
  },
  [43] = {
    [2] = alias_sym_block,
  },
  [45] = {
    [2] = alias_sym_block,
  },
  [54] = {
    [3] = alias_sym_json_content,
  },
  [55] = {
    [0] = anon_alias_sym_,
    [2] = anon_alias_sym_,
    [4] = anon_alias_sym_,
    [6] = anon_alias_sym_,
  },
  [57] = {
    [4] = alias_sym_block,
  },
  [58] = {
    [2] = alias_sym_block,
  },
  [59] = {
    [3] = alias_sym_block,
  },
  [61] = {
    [4] = alias_sym_block,
  },
  [64] = {
    [4] = alias_sym_block,
  },
  [65] = {
    [4] = alias_sym_block,
  },
  [66] = {
    [0] = anon_alias_sym_,
    [2] = anon_alias_sym_,
    [5] = anon_alias_sym_,
    [7] = anon_alias_sym_,
  },
  [67] = {
    [4] = alias_sym_block,
  },
  [70] = {
    [4] = alias_sym_block,
  },
  [71] = {
    [4] = alias_sym_block,
  },
  [72] = {
    [4] = alias_sym_block,
  },
  [74] = {
    [4] = alias_sym_block,
  },
  [77] = {
    [6] = alias_sym_block,
  },
  [78] = {
    [4] = alias_sym_block,
  },
  [79] = {
    [6] = alias_sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_template_content, 5,
    sym_template_content,
    alias_sym_js_content,
    alias_sym_json_content,
    alias_sym_style_content,
    alias_sym_stylesheet_content,
  aux_sym_program_repeat1, 2,
    aux_sym_program_repeat1,
    alias_sym_block,
  aux_sym_case_statement_repeat1, 2,
    aux_sym_case_statement_repeat1,
    alias_sym_block,
  aux_sym__if_liq_repeat1, 2,
    aux_sym__if_liq_repeat1,
    alias_sym_block,
  aux_sym__case_liq_repeat1, 2,
    aux_sym__case_liq_repeat1,
    alias_sym_block,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 57,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 59,
  [63] = 60,
  [64] = 61,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 69,
  [72] = 65,
  [73] = 70,
  [74] = 74,
  [75] = 75,
  [76] = 66,
  [77] = 68,
  [78] = 67,
  [79] = 74,
  [80] = 75,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 85,
  [102] = 82,
  [103] = 94,
  [104] = 104,
  [105] = 93,
  [106] = 95,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 83,
  [112] = 96,
  [113] = 107,
  [114] = 108,
  [115] = 115,
  [116] = 104,
  [117] = 92,
  [118] = 91,
  [119] = 119,
  [120] = 120,
  [121] = 90,
  [122] = 100,
  [123] = 89,
  [124] = 115,
  [125] = 110,
  [126] = 119,
  [127] = 88,
  [128] = 87,
  [129] = 109,
  [130] = 81,
  [131] = 86,
  [132] = 84,
  [133] = 120,
  [134] = 99,
  [135] = 98,
  [136] = 97,
  [137] = 137,
  [138] = 137,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 146,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 149,
  [153] = 145,
  [154] = 150,
  [155] = 155,
  [156] = 139,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 160,
  [168] = 162,
  [169] = 166,
  [170] = 161,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 179,
  [192] = 178,
  [193] = 176,
  [194] = 177,
  [195] = 186,
  [196] = 174,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 188,
  [201] = 183,
  [202] = 173,
  [203] = 171,
  [204] = 197,
  [205] = 185,
  [206] = 198,
  [207] = 187,
  [208] = 199,
  [209] = 25,
  [210] = 210,
  [211] = 211,
  [212] = 23,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 210,
  [217] = 38,
  [218] = 218,
  [219] = 218,
  [220] = 213,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 222,
  [225] = 215,
  [226] = 223,
  [227] = 22,
  [228] = 20,
  [229] = 23,
  [230] = 24,
  [231] = 25,
  [232] = 26,
  [233] = 37,
  [234] = 36,
  [235] = 44,
  [236] = 39,
  [237] = 41,
  [238] = 42,
  [239] = 43,
  [240] = 42,
  [241] = 40,
  [242] = 38,
  [243] = 243,
  [244] = 45,
  [245] = 49,
  [246] = 54,
  [247] = 46,
  [248] = 48,
  [249] = 52,
  [250] = 47,
  [251] = 53,
  [252] = 20,
  [253] = 51,
  [254] = 243,
  [255] = 22,
  [256] = 26,
  [257] = 24,
  [258] = 36,
  [259] = 37,
  [260] = 38,
  [261] = 39,
  [262] = 50,
  [263] = 44,
  [264] = 40,
  [265] = 55,
  [266] = 22,
  [267] = 20,
  [268] = 43,
  [269] = 41,
  [270] = 42,
  [271] = 45,
  [272] = 54,
  [273] = 24,
  [274] = 48,
  [275] = 23,
  [276] = 25,
  [277] = 46,
  [278] = 52,
  [279] = 51,
  [280] = 26,
  [281] = 53,
  [282] = 49,
  [283] = 47,
  [284] = 44,
  [285] = 36,
  [286] = 56,
  [287] = 39,
  [288] = 37,
  [289] = 45,
  [290] = 41,
  [291] = 43,
  [292] = 292,
  [293] = 40,
  [294] = 47,
  [295] = 295,
  [296] = 296,
  [297] = 46,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 295,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 51,
  [306] = 292,
  [307] = 307,
  [308] = 308,
  [309] = 295,
  [310] = 310,
  [311] = 300,
  [312] = 299,
  [313] = 53,
  [314] = 302,
  [315] = 315,
  [316] = 295,
  [317] = 308,
  [318] = 48,
  [319] = 52,
  [320] = 54,
  [321] = 49,
  [322] = 296,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 324,
  [327] = 315,
  [328] = 307,
  [329] = 310,
  [330] = 330,
  [331] = 141,
  [332] = 330,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 336,
  [342] = 336,
  [343] = 340,
  [344] = 338,
  [345] = 337,
  [346] = 346,
  [347] = 333,
  [348] = 340,
  [349] = 338,
  [350] = 350,
  [351] = 337,
  [352] = 352,
  [353] = 350,
  [354] = 339,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 355,
  [359] = 355,
  [360] = 360,
  [361] = 361,
  [362] = 346,
  [363] = 333,
  [364] = 335,
  [365] = 346,
  [366] = 361,
  [367] = 355,
  [368] = 368,
  [369] = 368,
  [370] = 336,
  [371] = 340,
  [372] = 338,
  [373] = 337,
  [374] = 346,
  [375] = 333,
  [376] = 357,
  [377] = 352,
  [378] = 378,
  [379] = 142,
  [380] = 380,
  [381] = 381,
  [382] = 381,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 380,
  [387] = 380,
  [388] = 383,
  [389] = 380,
  [390] = 385,
  [391] = 391,
  [392] = 391,
  [393] = 391,
  [394] = 391,
  [395] = 391,
  [396] = 396,
  [397] = 396,
  [398] = 396,
  [399] = 396,
  [400] = 400,
  [401] = 396,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 403,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 402,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 458,
  [542] = 439,
  [543] = 478,
  [544] = 483,
  [545] = 484,
  [546] = 485,
  [547] = 488,
  [548] = 491,
  [549] = 492,
  [550] = 493,
  [551] = 494,
  [552] = 495,
  [553] = 500,
  [554] = 501,
  [555] = 504,
  [556] = 505,
  [557] = 506,
  [558] = 507,
  [559] = 508,
  [560] = 509,
  [561] = 510,
  [562] = 511,
  [563] = 512,
  [564] = 513,
  [565] = 514,
  [566] = 515,
  [567] = 516,
  [568] = 517,
  [569] = 518,
  [570] = 519,
  [571] = 520,
  [572] = 521,
  [573] = 524,
  [574] = 525,
  [575] = 530,
  [576] = 531,
  [577] = 532,
  [578] = 533,
  [579] = 405,
  [580] = 540,
  [581] = 539,
  [582] = 538,
  [583] = 537,
  [584] = 536,
  [585] = 535,
  [586] = 534,
  [587] = 529,
  [588] = 528,
  [589] = 527,
  [590] = 526,
  [591] = 523,
  [592] = 522,
  [593] = 503,
  [594] = 502,
  [595] = 499,
  [596] = 498,
  [597] = 497,
  [598] = 496,
  [599] = 490,
  [600] = 489,
  [601] = 487,
  [602] = 486,
  [603] = 482,
  [604] = 481,
  [605] = 480,
  [606] = 479,
  [607] = 473,
  [608] = 472,
  [609] = 444,
  [610] = 442,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 441,
  [615] = 440,
  [616] = 477,
  [617] = 438,
  [618] = 476,
  [619] = 420,
  [620] = 418,
  [621] = 407,
  [622] = 433,
  [623] = 461,
  [624] = 475,
  [625] = 474,
  [626] = 471,
  [627] = 470,
  [628] = 469,
  [629] = 468,
  [630] = 467,
  [631] = 422,
  [632] = 421,
  [633] = 419,
  [634] = 466,
  [635] = 635,
  [636] = 465,
  [637] = 464,
  [638] = 463,
  [639] = 462,
  [640] = 460,
  [641] = 459,
  [642] = 38,
  [643] = 457,
  [644] = 143,
  [645] = 456,
  [646] = 455,
  [647] = 454,
  [648] = 453,
  [649] = 452,
  [650] = 406,
  [651] = 408,
  [652] = 451,
  [653] = 450,
  [654] = 404,
  [655] = 449,
  [656] = 448,
  [657] = 447,
  [658] = 446,
  [659] = 445,
  [660] = 660,
  [661] = 443,
  [662] = 424,
  [663] = 425,
  [664] = 426,
  [665] = 437,
  [666] = 436,
  [667] = 435,
  [668] = 434,
  [669] = 432,
  [670] = 409,
  [671] = 410,
  [672] = 411,
  [673] = 427,
  [674] = 428,
  [675] = 429,
  [676] = 430,
  [677] = 431,
  [678] = 403,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 682,
  [685] = 685,
  [686] = 680,
  [687] = 679,
  [688] = 681,
  [689] = 22,
  [690] = 20,
  [691] = 691,
  [692] = 24,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 695,
  [697] = 697,
  [698] = 697,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 683,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 699,
  [708] = 26,
  [709] = 709,
  [710] = 710,
  [711] = 155,
  [712] = 710,
  [713] = 713,
  [714] = 694,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 691,
  [719] = 719,
  [720] = 720,
  [721] = 700,
  [722] = 706,
  [723] = 709,
  [724] = 724,
  [725] = 693,
  [726] = 713,
  [727] = 727,
  [728] = 728,
  [729] = 720,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 37,
  [734] = 734,
  [735] = 703,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 719,
  [740] = 730,
  [741] = 741,
  [742] = 741,
  [743] = 743,
  [744] = 744,
  [745] = 39,
  [746] = 724,
  [747] = 744,
  [748] = 748,
  [749] = 734,
  [750] = 748,
  [751] = 705,
  [752] = 727,
  [753] = 716,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 715,
  [759] = 759,
  [760] = 717,
  [761] = 748,
  [762] = 36,
  [763] = 748,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 768,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 766,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 776,
  [784] = 784,
  [785] = 767,
  [786] = 786,
  [787] = 736,
  [788] = 788,
  [789] = 756,
  [790] = 755,
  [791] = 791,
  [792] = 765,
  [793] = 793,
  [794] = 791,
  [795] = 793,
  [796] = 769,
  [797] = 784,
  [798] = 775,
  [799] = 190,
  [800] = 800,
  [801] = 770,
  [802] = 771,
  [803] = 800,
  [804] = 765,
  [805] = 793,
  [806] = 806,
  [807] = 807,
  [808] = 779,
  [809] = 774,
  [810] = 807,
  [811] = 811,
  [812] = 757,
  [813] = 754,
  [814] = 811,
  [815] = 815,
  [816] = 764,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 820,
  [825] = 821,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 777,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 786,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 838,
  [874] = 827,
  [875] = 863,
  [876] = 876,
  [877] = 864,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 819,
  [883] = 829,
  [884] = 884,
  [885] = 848,
  [886] = 832,
  [887] = 833,
  [888] = 847,
  [889] = 889,
  [890] = 844,
  [891] = 891,
  [892] = 892,
  [893] = 839,
  [894] = 894,
  [895] = 895,
  [896] = 442,
  [897] = 444,
  [898] = 522,
  [899] = 523,
  [900] = 900,
  [901] = 835,
  [902] = 871,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 834,
  [909] = 826,
  [910] = 862,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 863,
  [918] = 864,
  [919] = 861,
  [920] = 860,
  [921] = 921,
  [922] = 922,
  [923] = 821,
  [924] = 889,
  [925] = 925,
  [926] = 926,
  [927] = 892,
  [928] = 928,
  [929] = 820,
  [930] = 870,
  [931] = 895,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 876,
  [940] = 940,
  [941] = 941,
  [942] = 932,
  [943] = 878,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 868,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 843,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 872,
  [966] = 934,
  [967] = 881,
  [968] = 880,
  [969] = 879,
  [970] = 970,
  [971] = 867,
  [972] = 972,
  [973] = 973,
  [974] = 830,
  [975] = 840,
  [976] = 845,
  [977] = 849,
  [978] = 850,
  [979] = 851,
  [980] = 853,
  [981] = 855,
  [982] = 857,
  [983] = 858,
  [984] = 859,
  [985] = 985,
  [986] = 959,
  [987] = 958,
  [988] = 988,
  [989] = 911,
  [990] = 854,
  [991] = 905,
  [992] = 907,
  [993] = 913,
  [994] = 914,
  [995] = 823,
  [996] = 996,
  [997] = 925,
  [998] = 922,
  [999] = 822,
  [1000] = 852,
  [1001] = 915,
  [1002] = 916,
  [1003] = 940,
  [1004] = 941,
  [1005] = 954,
  [1006] = 955,
  [1007] = 985,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 944,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 973,
  [1019] = 963,
  [1020] = 960,
  [1021] = 951,
  [1022] = 950,
  [1023] = 936,
  [1024] = 933,
  [1025] = 921,
  [1026] = 894,
  [1027] = 869,
  [1028] = 866,
  [1029] = 865,
  [1030] = 856,
  [1031] = 828,
  [1032] = 836,
  [1033] = 900,
  [1034] = 818,
  [1035] = 841,
  [1036] = 846,
  [1037] = 926,
  [1038] = 928,
  [1039] = 938,
  [1040] = 952,
  [1041] = 957,
  [1042] = 964,
  [1043] = 970,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 884,
  [1049] = 988,
  [1050] = 962,
  [1051] = 956,
  [1052] = 1017,
  [1053] = 1016,
  [1054] = 1044,
  [1055] = 1045,
  [1056] = 1015,
  [1057] = 1014,
  [1058] = 858,
  [1059] = 859,
  [1060] = 915,
  [1061] = 916,
  [1062] = 1008,
  [1063] = 1013,
  [1064] = 876,
  [1065] = 878,
  [1066] = 1046,
  [1067] = 1047,
  [1068] = 1009,
  [1069] = 1012,
  [1070] = 996,
  [1071] = 1011,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1075,
  [1089] = 1079,
  [1090] = 1082,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1083,
  [1094] = 1086,
  [1095] = 1095,
  [1096] = 1075,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1079,
  [1101] = 1101,
  [1102] = 1082,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1083,
  [1108] = 1086,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1092,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1116,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1075,
  [1125] = 1125,
  [1126] = 1079,
  [1127] = 1082,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1083,
  [1132] = 1086,
  [1133] = 1120,
  [1134] = 1117,
  [1135] = 1128,
  [1136] = 1136,
  [1137] = 1087,
  [1138] = 1080,
  [1139] = 1099,
  [1140] = 1105,
  [1141] = 1130,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1076,
  [1156] = 1073,
  [1157] = 1154,
  [1158] = 1158,
  [1159] = 1129,
  [1160] = 1103,
  [1161] = 1104,
  [1162] = 1074,
  [1163] = 1076,
  [1164] = 1073,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1073,
  [1174] = 1174,
  [1175] = 1076,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1103,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1121,
  [1193] = 1193,
  [1194] = 1113,
  [1195] = 1112,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1104,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1085,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1125,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 945,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1084,
  [1215] = 1215,
  [1216] = 1170,
  [1217] = 1217,
  [1218] = 946,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 947,
  [1223] = 1223,
  [1224] = 1118,
  [1225] = 948,
  [1226] = 1171,
  [1227] = 949,
  [1228] = 1109,
  [1229] = 1097,
  [1230] = 159,
  [1231] = 1095,
  [1232] = 906,
  [1233] = 1101,
  [1234] = 1098,
  [1235] = 904,
  [1236] = 903,
  [1237] = 1114,
  [1238] = 1091,
  [1239] = 1101,
  [1240] = 1098,
  [1241] = 1241,
  [1242] = 157,
  [1243] = 1243,
  [1244] = 1204,
  [1245] = 1151,
  [1246] = 1111,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1150,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1153,
  [1253] = 1253,
  [1254] = 1254,
  [1255] = 1122,
  [1256] = 1106,
  [1257] = 1152,
  [1258] = 1207,
  [1259] = 1202,
  [1260] = 972,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '(', 79,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 50,
        '.', 75,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 71,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '{', 6,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 27,
        '\r', 27,
        '!', 8,
        '"', 42,
        '%', 56,
        '\'', 38,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 53,
        '.', 76,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '{', 12,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 27,
        '\r', 27,
        '!', 8,
        '%', 56,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 49,
        '.', 73,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 51,
        '.', 76,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        '^', 58,
        '{', 12,
        '|', 72,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 8,
        '%', 57,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 52,
        '.', 74,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 9,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(43);
      if (lookahead == '\'') ADVANCE(39);
      if (lookahead == '{') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (lookahead != 0) ADVANCE(69);
      END_STATE();
    case 6:
      if (lookahead == '%') ADVANCE(28);
      if (lookahead == '{') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == '%') ADVANCE(28);
      if (lookahead == '{') ADVANCE(33);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(62);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(65);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '{') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == '{') ADVANCE(32);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '%') ADVANCE(69);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(31);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(36);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 18:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '%' &&
          lookahead != '{') ADVANCE(69);
      END_STATE();
    case 19:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 8,
        '"', 42,
        '%', 57,
        '\'', 38,
        '(', 79,
        ')', 81,
        '*', 54,
        '+', 48,
        ',', 68,
        '-', 50,
        '.', 75,
        '/', 55,
        ':', 67,
        '<', 60,
        '=', 66,
        '>', 64,
        '[', 77,
        ']', 78,
        '^', 58,
        '{', 6,
        '|', 72,
        '}', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 20:
      if (eof) ADVANCE(21);
      if (lookahead == '{') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      if (lookahead == '{') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(aux_sym_template_content_token1);
      if (lookahead != 0 &&
          lookahead != '{') ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT_PERCENT);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_LBRACE);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym__liquid_node_token1);
      if (lookahead == '\n') ADVANCE(27);
      if (lookahead == '\r') ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT);
      if (lookahead == '%') ADVANCE(25);
      if (lookahead == '-') ADVANCE(29);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT_DASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_PERCENT_RBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DASH_PERCENT_RBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '{') ADVANCE(26);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_RBRACE_RBRACE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(41);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '}') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(15);
      if (lookahead == '}') ADVANCE(16);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '}') ADVANCE(30);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(63);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_include_statement_token1);
      if (lookahead == '{') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ2);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ2);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'j', 8,
        'l', 9,
        'n', 10,
        'o', 11,
        'p', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'w', 17,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'c') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 14:
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(47);
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(52);
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 23:
      if (lookahead == 'm') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(58);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 33:
      if (lookahead == 'v') ADVANCE(64);
      END_STATE();
    case 34:
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 35:
      if (lookahead == 'q') ADVANCE(66);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 38:
      if (lookahead == 'g') ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == 'h') ADVANCE(71);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == 'b') ADVANCE(74);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 54:
      if (lookahead == 'm') ADVANCE(83);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(87);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        'c', 90,
        'f', 91,
        'i', 92,
        'j', 93,
        'p', 94,
        'r', 95,
        's', 96,
        't', 97,
        'u', 98,
      );
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(105);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_raw);
      END_STATE();
    case 70:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 78:
      if (lookahead == 'h') ADVANCE(116);
      END_STATE();
    case 79:
      if (lookahead == 'g') ADVANCE(117);
      END_STATE();
    case 80:
      if (lookahead == 'k') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(121);
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_echo);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(125);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(129);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(133);
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_form);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(138);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(140);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_none);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 109:
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 114:
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_cycle);
      END_STATE();
    case 124:
      if (lookahead == 'm') ADVANCE(155);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 126:
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 127:
      if (lookahead == 'm') ADVANCE(158);
      END_STATE();
    case 128:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(160);
      END_STATE();
    case 131:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 132:
      if (lookahead == 'w') ADVANCE(162);
      END_STATE();
    case 133:
      if (lookahead == 'h') ADVANCE(163);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(164);
      END_STATE();
    case 135:
      if (lookahead == 'b') ADVANCE(165);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 138:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 139:
      if (lookahead == 'm') ADVANCE(168);
      END_STATE();
    case 140:
      if (lookahead == 'c') ADVANCE(169);
      END_STATE();
    case 141:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 142:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 144:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 146:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_style);
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(178);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 154:
      if (lookahead == 'u') ADVANCE(182);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 158:
      if (lookahead == 'm') ADVANCE(186);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_endfor);
      if (lookahead == 'm') ADVANCE(187);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_endraw);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 164:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 165:
      if (lookahead == 'l') ADVANCE(192);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(193);
      END_STATE();
    case 167:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_layout);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_liquid);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_render);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_schema);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 176:
      if (lookahead == 'h') ADVANCE(199);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_capture);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_comment);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(201);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 184:
      if (lookahead == 'u') ADVANCE(204);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_endcase);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_endform);
      END_STATE();
    case 188:
      if (lookahead == 's') ADVANCE(206);
      END_STATE();
    case 189:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 190:
      if (lookahead == 'm') ADVANCE(208);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(211);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_include);
      if (lookahead == '_') ADVANCE(212);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(213);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(214);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_section);
      if (lookahead == 's') ADVANCE(216);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 200:
      if (lookahead == 'w') ADVANCE(218);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_contains);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 204:
      if (lookahead == 'r') ADVANCE(220);
      END_STATE();
    case 205:
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(222);
      END_STATE();
    case 207:
      if (lookahead == 'a') ADVANCE(223);
      END_STATE();
    case 208:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_endstyle);
      if (lookahead == 's') ADVANCE(225);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 211:
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 212:
      if (lookahead == 'r') ADVANCE(228);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 214:
      if (lookahead == 'p') ADVANCE(230);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_paginate);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_sections);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_tablerow);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_decrement);
      END_STATE();
    case 220:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 221:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 223:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_endschema);
      END_STATE();
    case 225:
      if (lookahead == 'h') ADVANCE(236);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(237);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_endunless);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(238);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_increment);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(239);
      END_STATE();
    case 231:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_endcapture);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_endcomment);
      END_STATE();
    case 234:
      if (lookahead == 'i') ADVANCE(241);
      END_STATE();
    case 235:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 237:
      if (lookahead == 'w') ADVANCE(244);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(245);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_stylesheet);
      END_STATE();
    case 241:
      if (lookahead == 'p') ADVANCE(246);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_endpaginate);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(247);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_endtablerow);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 246:
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 247:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_endjavascript);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_endstylesheet);
      END_STATE();
    case 251:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 252:
      if (lookahead == 'v') ADVANCE(253);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(254);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_include_relative);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 20, .external_lex_state = 2},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 3, .external_lex_state = 3},
  [10] = {.lex_state = 3, .external_lex_state = 3},
  [11] = {.lex_state = 3, .external_lex_state = 3},
  [12] = {.lex_state = 3},
  [13] = {.lex_state = 3},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 3},
  [16] = {.lex_state = 3},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 3},
  [25] = {.lex_state = 3},
  [26] = {.lex_state = 3},
  [27] = {.lex_state = 3},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 3},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 3},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 0, .external_lex_state = 3},
  [58] = {.lex_state = 0, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 3},
  [60] = {.lex_state = 0, .external_lex_state = 3},
  [61] = {.lex_state = 0, .external_lex_state = 3},
  [62] = {.lex_state = 0, .external_lex_state = 3},
  [63] = {.lex_state = 0, .external_lex_state = 3},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 3},
  [66] = {.lex_state = 0, .external_lex_state = 3},
  [67] = {.lex_state = 0, .external_lex_state = 3},
  [68] = {.lex_state = 0, .external_lex_state = 3},
  [69] = {.lex_state = 0, .external_lex_state = 3},
  [70] = {.lex_state = 0, .external_lex_state = 3},
  [71] = {.lex_state = 0, .external_lex_state = 3},
  [72] = {.lex_state = 0, .external_lex_state = 3},
  [73] = {.lex_state = 0, .external_lex_state = 3},
  [74] = {.lex_state = 0, .external_lex_state = 3},
  [75] = {.lex_state = 0, .external_lex_state = 3},
  [76] = {.lex_state = 0, .external_lex_state = 3},
  [77] = {.lex_state = 0, .external_lex_state = 3},
  [78] = {.lex_state = 0, .external_lex_state = 3},
  [79] = {.lex_state = 0, .external_lex_state = 3},
  [80] = {.lex_state = 0, .external_lex_state = 3},
  [81] = {.lex_state = 0, .external_lex_state = 3},
  [82] = {.lex_state = 0, .external_lex_state = 3},
  [83] = {.lex_state = 0, .external_lex_state = 3},
  [84] = {.lex_state = 0, .external_lex_state = 3},
  [85] = {.lex_state = 0, .external_lex_state = 3},
  [86] = {.lex_state = 0, .external_lex_state = 3},
  [87] = {.lex_state = 0, .external_lex_state = 3},
  [88] = {.lex_state = 0, .external_lex_state = 3},
  [89] = {.lex_state = 0, .external_lex_state = 3},
  [90] = {.lex_state = 0, .external_lex_state = 3},
  [91] = {.lex_state = 0, .external_lex_state = 3},
  [92] = {.lex_state = 0, .external_lex_state = 3},
  [93] = {.lex_state = 0, .external_lex_state = 3},
  [94] = {.lex_state = 0, .external_lex_state = 3},
  [95] = {.lex_state = 0, .external_lex_state = 3},
  [96] = {.lex_state = 0, .external_lex_state = 3},
  [97] = {.lex_state = 0, .external_lex_state = 3},
  [98] = {.lex_state = 0, .external_lex_state = 3},
  [99] = {.lex_state = 0, .external_lex_state = 3},
  [100] = {.lex_state = 0, .external_lex_state = 3},
  [101] = {.lex_state = 0, .external_lex_state = 3},
  [102] = {.lex_state = 0, .external_lex_state = 3},
  [103] = {.lex_state = 0, .external_lex_state = 3},
  [104] = {.lex_state = 0, .external_lex_state = 3},
  [105] = {.lex_state = 0, .external_lex_state = 3},
  [106] = {.lex_state = 0, .external_lex_state = 3},
  [107] = {.lex_state = 0, .external_lex_state = 3},
  [108] = {.lex_state = 0, .external_lex_state = 3},
  [109] = {.lex_state = 0, .external_lex_state = 3},
  [110] = {.lex_state = 0, .external_lex_state = 3},
  [111] = {.lex_state = 0, .external_lex_state = 3},
  [112] = {.lex_state = 0, .external_lex_state = 3},
  [113] = {.lex_state = 0, .external_lex_state = 3},
  [114] = {.lex_state = 0, .external_lex_state = 3},
  [115] = {.lex_state = 0, .external_lex_state = 3},
  [116] = {.lex_state = 0, .external_lex_state = 3},
  [117] = {.lex_state = 0, .external_lex_state = 3},
  [118] = {.lex_state = 0, .external_lex_state = 3},
  [119] = {.lex_state = 0, .external_lex_state = 3},
  [120] = {.lex_state = 0, .external_lex_state = 3},
  [121] = {.lex_state = 0, .external_lex_state = 3},
  [122] = {.lex_state = 0, .external_lex_state = 3},
  [123] = {.lex_state = 0, .external_lex_state = 3},
  [124] = {.lex_state = 0, .external_lex_state = 3},
  [125] = {.lex_state = 0, .external_lex_state = 3},
  [126] = {.lex_state = 0, .external_lex_state = 3},
  [127] = {.lex_state = 0, .external_lex_state = 3},
  [128] = {.lex_state = 0, .external_lex_state = 3},
  [129] = {.lex_state = 0, .external_lex_state = 3},
  [130] = {.lex_state = 0, .external_lex_state = 3},
  [131] = {.lex_state = 0, .external_lex_state = 3},
  [132] = {.lex_state = 0, .external_lex_state = 3},
  [133] = {.lex_state = 0, .external_lex_state = 3},
  [134] = {.lex_state = 0, .external_lex_state = 3},
  [135] = {.lex_state = 0, .external_lex_state = 3},
  [136] = {.lex_state = 0, .external_lex_state = 3},
  [137] = {.lex_state = 0, .external_lex_state = 3},
  [138] = {.lex_state = 0, .external_lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 20},
  [146] = {.lex_state = 20},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 20},
  [149] = {.lex_state = 20},
  [150] = {.lex_state = 20},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 20},
  [154] = {.lex_state = 20},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 3},
  [158] = {.lex_state = 3, .external_lex_state = 3},
  [159] = {.lex_state = 3, .external_lex_state = 3},
  [160] = {.lex_state = 20},
  [161] = {.lex_state = 20},
  [162] = {.lex_state = 20},
  [163] = {.lex_state = 20},
  [164] = {.lex_state = 20},
  [165] = {.lex_state = 20},
  [166] = {.lex_state = 20},
  [167] = {.lex_state = 20},
  [168] = {.lex_state = 20},
  [169] = {.lex_state = 20},
  [170] = {.lex_state = 20},
  [171] = {.lex_state = 20},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 20},
  [174] = {.lex_state = 20},
  [175] = {.lex_state = 20},
  [176] = {.lex_state = 20},
  [177] = {.lex_state = 20},
  [178] = {.lex_state = 20},
  [179] = {.lex_state = 20},
  [180] = {.lex_state = 20},
  [181] = {.lex_state = 20},
  [182] = {.lex_state = 20},
  [183] = {.lex_state = 20},
  [184] = {.lex_state = 20},
  [185] = {.lex_state = 20},
  [186] = {.lex_state = 20},
  [187] = {.lex_state = 20},
  [188] = {.lex_state = 20},
  [189] = {.lex_state = 20},
  [190] = {.lex_state = 3},
  [191] = {.lex_state = 20},
  [192] = {.lex_state = 20},
  [193] = {.lex_state = 20},
  [194] = {.lex_state = 20},
  [195] = {.lex_state = 20},
  [196] = {.lex_state = 20},
  [197] = {.lex_state = 20},
  [198] = {.lex_state = 20},
  [199] = {.lex_state = 20},
  [200] = {.lex_state = 20},
  [201] = {.lex_state = 20},
  [202] = {.lex_state = 20},
  [203] = {.lex_state = 20},
  [204] = {.lex_state = 20},
  [205] = {.lex_state = 20},
  [206] = {.lex_state = 20},
  [207] = {.lex_state = 20},
  [208] = {.lex_state = 20},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 20},
  [211] = {.lex_state = 20},
  [212] = {.lex_state = 4},
  [213] = {.lex_state = 20},
  [214] = {.lex_state = 20},
  [215] = {.lex_state = 20},
  [216] = {.lex_state = 20},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 20},
  [219] = {.lex_state = 20},
  [220] = {.lex_state = 20},
  [221] = {.lex_state = 20},
  [222] = {.lex_state = 20},
  [223] = {.lex_state = 20},
  [224] = {.lex_state = 20},
  [225] = {.lex_state = 20},
  [226] = {.lex_state = 20},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 4},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 4},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 4},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 4},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 4},
  [258] = {.lex_state = 4},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 4},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 4},
  [266] = {.lex_state = 2},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 4},
  [269] = {.lex_state = 4},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 4},
  [272] = {.lex_state = 4},
  [273] = {.lex_state = 2},
  [274] = {.lex_state = 4},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 2},
  [277] = {.lex_state = 4},
  [278] = {.lex_state = 4},
  [279] = {.lex_state = 4},
  [280] = {.lex_state = 2},
  [281] = {.lex_state = 4},
  [282] = {.lex_state = 4},
  [283] = {.lex_state = 4},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 2},
  [286] = {.lex_state = 4},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 2},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 2},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 4},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 4},
  [304] = {.lex_state = 4},
  [305] = {.lex_state = 2},
  [306] = {.lex_state = 2},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 4},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 2},
  [314] = {.lex_state = 4},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 4},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 2},
  [320] = {.lex_state = 2},
  [321] = {.lex_state = 2},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 2},
  [330] = {.lex_state = 4},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 3},
  [362] = {.lex_state = 3},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 3},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 3},
  [370] = {.lex_state = 3},
  [371] = {.lex_state = 3},
  [372] = {.lex_state = 3},
  [373] = {.lex_state = 3},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 3},
  [376] = {.lex_state = 3},
  [377] = {.lex_state = 3},
  [378] = {.lex_state = 3},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 20},
  [403] = {.lex_state = 20},
  [404] = {.lex_state = 20},
  [405] = {.lex_state = 20},
  [406] = {.lex_state = 20},
  [407] = {.lex_state = 20},
  [408] = {.lex_state = 20},
  [409] = {.lex_state = 20},
  [410] = {.lex_state = 20},
  [411] = {.lex_state = 20},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 20},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 20},
  [419] = {.lex_state = 20},
  [420] = {.lex_state = 20},
  [421] = {.lex_state = 20},
  [422] = {.lex_state = 20},
  [423] = {.lex_state = 20},
  [424] = {.lex_state = 20},
  [425] = {.lex_state = 20},
  [426] = {.lex_state = 20},
  [427] = {.lex_state = 20},
  [428] = {.lex_state = 20},
  [429] = {.lex_state = 20},
  [430] = {.lex_state = 20},
  [431] = {.lex_state = 20},
  [432] = {.lex_state = 20},
  [433] = {.lex_state = 20},
  [434] = {.lex_state = 20},
  [435] = {.lex_state = 20},
  [436] = {.lex_state = 20},
  [437] = {.lex_state = 20},
  [438] = {.lex_state = 20},
  [439] = {.lex_state = 20},
  [440] = {.lex_state = 20},
  [441] = {.lex_state = 20},
  [442] = {.lex_state = 20},
  [443] = {.lex_state = 20},
  [444] = {.lex_state = 20},
  [445] = {.lex_state = 20},
  [446] = {.lex_state = 20},
  [447] = {.lex_state = 20},
  [448] = {.lex_state = 20},
  [449] = {.lex_state = 20},
  [450] = {.lex_state = 20},
  [451] = {.lex_state = 20},
  [452] = {.lex_state = 20},
  [453] = {.lex_state = 20},
  [454] = {.lex_state = 20},
  [455] = {.lex_state = 20},
  [456] = {.lex_state = 20},
  [457] = {.lex_state = 20},
  [458] = {.lex_state = 20},
  [459] = {.lex_state = 20},
  [460] = {.lex_state = 20},
  [461] = {.lex_state = 20},
  [462] = {.lex_state = 20},
  [463] = {.lex_state = 20},
  [464] = {.lex_state = 20},
  [465] = {.lex_state = 20},
  [466] = {.lex_state = 20},
  [467] = {.lex_state = 20},
  [468] = {.lex_state = 20},
  [469] = {.lex_state = 20},
  [470] = {.lex_state = 20},
  [471] = {.lex_state = 20},
  [472] = {.lex_state = 20},
  [473] = {.lex_state = 20},
  [474] = {.lex_state = 20},
  [475] = {.lex_state = 20},
  [476] = {.lex_state = 20},
  [477] = {.lex_state = 20},
  [478] = {.lex_state = 20},
  [479] = {.lex_state = 20},
  [480] = {.lex_state = 20},
  [481] = {.lex_state = 20},
  [482] = {.lex_state = 20},
  [483] = {.lex_state = 20},
  [484] = {.lex_state = 20},
  [485] = {.lex_state = 20},
  [486] = {.lex_state = 20},
  [487] = {.lex_state = 20},
  [488] = {.lex_state = 20},
  [489] = {.lex_state = 20},
  [490] = {.lex_state = 20},
  [491] = {.lex_state = 20},
  [492] = {.lex_state = 20},
  [493] = {.lex_state = 20},
  [494] = {.lex_state = 20},
  [495] = {.lex_state = 20},
  [496] = {.lex_state = 20},
  [497] = {.lex_state = 20},
  [498] = {.lex_state = 20},
  [499] = {.lex_state = 20},
  [500] = {.lex_state = 20},
  [501] = {.lex_state = 20},
  [502] = {.lex_state = 20},
  [503] = {.lex_state = 20},
  [504] = {.lex_state = 20},
  [505] = {.lex_state = 20},
  [506] = {.lex_state = 20},
  [507] = {.lex_state = 20},
  [508] = {.lex_state = 20},
  [509] = {.lex_state = 20},
  [510] = {.lex_state = 20},
  [511] = {.lex_state = 20},
  [512] = {.lex_state = 20},
  [513] = {.lex_state = 20},
  [514] = {.lex_state = 20},
  [515] = {.lex_state = 20},
  [516] = {.lex_state = 20},
  [517] = {.lex_state = 20},
  [518] = {.lex_state = 20},
  [519] = {.lex_state = 20},
  [520] = {.lex_state = 20},
  [521] = {.lex_state = 20},
  [522] = {.lex_state = 20},
  [523] = {.lex_state = 20},
  [524] = {.lex_state = 20},
  [525] = {.lex_state = 20},
  [526] = {.lex_state = 20},
  [527] = {.lex_state = 20},
  [528] = {.lex_state = 20},
  [529] = {.lex_state = 20},
  [530] = {.lex_state = 20},
  [531] = {.lex_state = 20},
  [532] = {.lex_state = 20},
  [533] = {.lex_state = 20},
  [534] = {.lex_state = 20},
  [535] = {.lex_state = 20},
  [536] = {.lex_state = 20},
  [537] = {.lex_state = 20},
  [538] = {.lex_state = 20},
  [539] = {.lex_state = 20},
  [540] = {.lex_state = 20},
  [541] = {.lex_state = 20},
  [542] = {.lex_state = 20},
  [543] = {.lex_state = 20},
  [544] = {.lex_state = 20},
  [545] = {.lex_state = 20},
  [546] = {.lex_state = 20},
  [547] = {.lex_state = 20},
  [548] = {.lex_state = 20},
  [549] = {.lex_state = 20},
  [550] = {.lex_state = 20},
  [551] = {.lex_state = 20},
  [552] = {.lex_state = 20},
  [553] = {.lex_state = 20},
  [554] = {.lex_state = 20},
  [555] = {.lex_state = 20},
  [556] = {.lex_state = 20},
  [557] = {.lex_state = 20},
  [558] = {.lex_state = 20},
  [559] = {.lex_state = 20},
  [560] = {.lex_state = 20},
  [561] = {.lex_state = 20},
  [562] = {.lex_state = 20},
  [563] = {.lex_state = 20},
  [564] = {.lex_state = 20},
  [565] = {.lex_state = 20},
  [566] = {.lex_state = 20},
  [567] = {.lex_state = 20},
  [568] = {.lex_state = 20},
  [569] = {.lex_state = 20},
  [570] = {.lex_state = 20},
  [571] = {.lex_state = 20},
  [572] = {.lex_state = 20},
  [573] = {.lex_state = 20},
  [574] = {.lex_state = 20},
  [575] = {.lex_state = 20},
  [576] = {.lex_state = 20},
  [577] = {.lex_state = 20},
  [578] = {.lex_state = 20},
  [579] = {.lex_state = 20},
  [580] = {.lex_state = 20},
  [581] = {.lex_state = 20},
  [582] = {.lex_state = 20},
  [583] = {.lex_state = 20},
  [584] = {.lex_state = 20},
  [585] = {.lex_state = 20},
  [586] = {.lex_state = 20},
  [587] = {.lex_state = 20},
  [588] = {.lex_state = 20},
  [589] = {.lex_state = 20},
  [590] = {.lex_state = 20},
  [591] = {.lex_state = 20},
  [592] = {.lex_state = 20},
  [593] = {.lex_state = 20},
  [594] = {.lex_state = 20},
  [595] = {.lex_state = 20},
  [596] = {.lex_state = 20},
  [597] = {.lex_state = 20},
  [598] = {.lex_state = 20},
  [599] = {.lex_state = 20},
  [600] = {.lex_state = 20},
  [601] = {.lex_state = 20},
  [602] = {.lex_state = 20},
  [603] = {.lex_state = 20},
  [604] = {.lex_state = 20},
  [605] = {.lex_state = 20},
  [606] = {.lex_state = 20},
  [607] = {.lex_state = 20},
  [608] = {.lex_state = 20},
  [609] = {.lex_state = 20},
  [610] = {.lex_state = 20},
  [611] = {.lex_state = 20},
  [612] = {.lex_state = 20},
  [613] = {.lex_state = 20},
  [614] = {.lex_state = 20},
  [615] = {.lex_state = 20},
  [616] = {.lex_state = 20},
  [617] = {.lex_state = 20},
  [618] = {.lex_state = 20},
  [619] = {.lex_state = 20},
  [620] = {.lex_state = 20},
  [621] = {.lex_state = 20},
  [622] = {.lex_state = 20},
  [623] = {.lex_state = 20},
  [624] = {.lex_state = 20},
  [625] = {.lex_state = 20},
  [626] = {.lex_state = 20},
  [627] = {.lex_state = 20},
  [628] = {.lex_state = 20},
  [629] = {.lex_state = 20},
  [630] = {.lex_state = 20},
  [631] = {.lex_state = 20},
  [632] = {.lex_state = 20},
  [633] = {.lex_state = 20},
  [634] = {.lex_state = 20},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 20},
  [637] = {.lex_state = 20},
  [638] = {.lex_state = 20},
  [639] = {.lex_state = 20},
  [640] = {.lex_state = 20},
  [641] = {.lex_state = 20},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 20},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 20},
  [646] = {.lex_state = 20},
  [647] = {.lex_state = 20},
  [648] = {.lex_state = 20},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 20},
  [651] = {.lex_state = 20},
  [652] = {.lex_state = 20},
  [653] = {.lex_state = 20},
  [654] = {.lex_state = 20},
  [655] = {.lex_state = 20},
  [656] = {.lex_state = 20},
  [657] = {.lex_state = 20},
  [658] = {.lex_state = 20},
  [659] = {.lex_state = 20},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 20},
  [662] = {.lex_state = 20},
  [663] = {.lex_state = 20},
  [664] = {.lex_state = 20},
  [665] = {.lex_state = 20},
  [666] = {.lex_state = 20},
  [667] = {.lex_state = 20},
  [668] = {.lex_state = 20},
  [669] = {.lex_state = 20},
  [670] = {.lex_state = 20},
  [671] = {.lex_state = 20},
  [672] = {.lex_state = 20},
  [673] = {.lex_state = 20},
  [674] = {.lex_state = 20},
  [675] = {.lex_state = 20},
  [676] = {.lex_state = 20},
  [677] = {.lex_state = 20},
  [678] = {.lex_state = 20},
  [679] = {.lex_state = 5},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 5},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 20},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 1},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 1},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 20},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0, .external_lex_state = 3},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 1},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 1},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0, .external_lex_state = 3},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 1},
  [747] = {.lex_state = 0, .external_lex_state = 3},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 1},
  [752] = {.lex_state = 1},
  [753] = {.lex_state = 1},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 1},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 1},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 1},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 1},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 1},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 1},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 1},
  [1073] = {.lex_state = 44},
  [1074] = {.lex_state = 0, .external_lex_state = 4},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 40},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0, .external_lex_state = 5},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0, .external_lex_state = 6},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 1},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 10},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 11},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 11},
  [1136] = {.lex_state = 1},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 1},
  [1143] = {.lex_state = 1},
  [1144] = {.lex_state = 1},
  [1145] = {.lex_state = 1},
  [1146] = {.lex_state = 1},
  [1147] = {.lex_state = 1},
  [1148] = {.lex_state = 1},
  [1149] = {.lex_state = 1},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 1},
  [1155] = {.lex_state = 40},
  [1156] = {.lex_state = 44},
  [1157] = {.lex_state = 1},
  [1158] = {.lex_state = 1},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0, .external_lex_state = 4},
  [1163] = {.lex_state = 40},
  [1164] = {.lex_state = 44},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 1},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 1},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 44},
  [1174] = {.lex_state = 1},
  [1175] = {.lex_state = 40},
  [1176] = {.lex_state = 1},
  [1177] = {.lex_state = 1},
  [1178] = {.lex_state = 1},
  [1179] = {.lex_state = 1},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 1},
  [1182] = {.lex_state = 1},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 1},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 1},
  [1189] = {.lex_state = 1},
  [1190] = {.lex_state = 1},
  [1191] = {.lex_state = 1},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 1},
  [1197] = {.lex_state = 1},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 1},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 1},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 1},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 10},
  [1209] = {.lex_state = 1},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 1},
  [1212] = {.lex_state = 1},
  [1213] = {.lex_state = 1},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 1},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 1},
  [1219] = {.lex_state = 1},
  [1220] = {.lex_state = 1},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 1},
  [1223] = {.lex_state = 1},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 1},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 1},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 1},
  [1233] = {.lex_state = 0, .external_lex_state = 6},
  [1234] = {.lex_state = 0, .external_lex_state = 5},
  [1235] = {.lex_state = 1},
  [1236] = {.lex_state = 1},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0, .external_lex_state = 6},
  [1240] = {.lex_state = 0, .external_lex_state = 5},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 1},
  [1248] = {.lex_state = 1},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 1},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 1},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_liquid] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(1),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_contains] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_section] = ACTIONS(1),
    [anon_sym_sections] = ACTIONS(1),
    [anon_sym_increment] = ACTIONS(1),
    [anon_sym_decrement] = ACTIONS(1),
    [anon_sym_layout] = ACTIONS(1),
    [anon_sym_none] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_cycle] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_include_relative] = ACTIONS(1),
    [anon_sym_EQ2] = ACTIONS(1),
    [anon_sym_render] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_endfor] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_endcase] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_unless] = ACTIONS(1),
    [anon_sym_endunless] = ACTIONS(1),
    [anon_sym_capture] = ACTIONS(1),
    [anon_sym_endcapture] = ACTIONS(1),
    [anon_sym_form] = ACTIONS(1),
    [anon_sym_endform] = ACTIONS(1),
    [anon_sym_tablerow] = ACTIONS(1),
    [anon_sym_endtablerow] = ACTIONS(1),
    [anon_sym_paginate] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [anon_sym_endpaginate] = ACTIONS(1),
    [anon_sym_schema] = ACTIONS(1),
    [anon_sym_endschema] = ACTIONS(1),
    [anon_sym_style] = ACTIONS(1),
    [anon_sym_endstyle] = ACTIONS(1),
    [anon_sym_stylesheet] = ACTIONS(1),
    [anon_sym_endstylesheet] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_endjavascript] = ACTIONS(1),
    [anon_sym_raw] = ACTIONS(1),
    [anon_sym_endraw] = ACTIONS(1),
    [anon_sym_comment] = ACTIONS(1),
    [anon_sym_endcomment] = ACTIONS(1),
    [sym__inline_comment_content] = ACTIONS(1),
    [sym__paired_comment_content] = ACTIONS(1),
    [sym__paired_comment_content_liq] = ACTIONS(1),
    [sym_raw_content] = ACTIONS(1),
    [sym_front_matter] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1123),
    [sym__node] = STATE(406),
    [sym_template_content] = STATE(406),
    [sym__statement] = STATE(406),
    [sym__tagged_unpaired_statement] = STATE(406),
    [sym__output_statement] = STATE(406),
    [sym__tagged_paired_statment] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_for_loop_statement] = STATE(406),
    [sym_case_statement] = STATE(406),
    [sym_unless_statement] = STATE(406),
    [sym_capture_statement] = STATE(406),
    [sym_form_statement] = STATE(406),
    [sym_tablerow_statement] = STATE(406),
    [sym_paginate_statement] = STATE(406),
    [sym_schema_statement] = STATE(406),
    [sym_style_statement] = STATE(406),
    [sym_stylesheet_statement] = STATE(406),
    [sym_javascript_statement] = STATE(406),
    [sym_raw_statement] = STATE(406),
    [sym_comment] = STATE(406),
    [sym__inline_comment] = STATE(408),
    [sym__paired_comment] = STATE(408),
    [aux_sym_program_repeat1] = STATE(165),
    [aux_sym_template_content_repeat1] = STATE(403),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym_template_content_token1] = ACTIONS(5),
    [anon_sym_LBRACE_PERCENT_PERCENT] = ACTIONS(7),
    [anon_sym_LBRACE_LBRACE_LBRACE] = ACTIONS(7),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(9),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(9),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(11),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(11),
    [sym_front_matter] = ACTIONS(13),
  },
  [2] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__elsif_liq] = STATE(738),
    [sym__else_liq] = STATE(1180),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym__else_aliased] = STATE(1180),
    [sym__elsif_aliased] = STATE(737),
    [aux_sym__if_liq_repeat1] = STATE(8),
    [aux_sym__if_liq_repeat2] = STATE(412),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(73),
    [anon_sym_elsif] = ACTIONS(75),
    [anon_sym_else] = ACTIONS(77),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [3] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__elsif_liq] = STATE(738),
    [sym__else_liq] = STATE(1187),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym__else_aliased] = STATE(1187),
    [sym__elsif_aliased] = STATE(737),
    [aux_sym__if_liq_repeat1] = STATE(7),
    [aux_sym__if_liq_repeat2] = STATE(414),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_elsif] = ACTIONS(75),
    [anon_sym_else] = ACTIONS(77),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_endunless] = ACTIONS(91),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [4] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [aux_sym__if_liq_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_DASH] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_BANG_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(41),
    [anon_sym_or] = ACTIONS(41),
    [anon_sym_contains] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(93),
    [anon_sym_elsif] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(93),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_endunless] = ACTIONS(93),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [5] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [aux_sym__if_liq_repeat1] = STATE(19),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(95),
    [anon_sym_DASH] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_SLASH] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(95),
    [anon_sym_CARET] = ACTIONS(95),
    [anon_sym_EQ_EQ] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_GT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_and] = ACTIONS(97),
    [anon_sym_or] = ACTIONS(97),
    [anon_sym_contains] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_else] = ACTIONS(99),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_endcase] = ACTIONS(99),
    [anon_sym_when] = ACTIONS(99),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [6] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(104),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(110),
    [anon_sym_DQUOTE] = ACTIONS(113),
    [sym_number] = ACTIONS(116),
    [anon_sym_true] = ACTIONS(119),
    [anon_sym_false] = ACTIONS(119),
    [sym_break_statement] = ACTIONS(122),
    [sym_continue_statement] = ACTIONS(122),
    [anon_sym_echo] = ACTIONS(125),
    [anon_sym_section] = ACTIONS(128),
    [anon_sym_sections] = ACTIONS(131),
    [anon_sym_increment] = ACTIONS(134),
    [anon_sym_decrement] = ACTIONS(137),
    [anon_sym_layout] = ACTIONS(140),
    [anon_sym_assign] = ACTIONS(143),
    [anon_sym_cycle] = ACTIONS(146),
    [anon_sym_include] = ACTIONS(149),
    [anon_sym_include_relative] = ACTIONS(149),
    [anon_sym_render] = ACTIONS(152),
    [anon_sym_for] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_endif] = ACTIONS(161),
    [anon_sym_elsif] = ACTIONS(161),
    [anon_sym_else] = ACTIONS(161),
    [anon_sym_endfor] = ACTIONS(161),
    [anon_sym_case] = ACTIONS(163),
    [anon_sym_endcase] = ACTIONS(161),
    [anon_sym_when] = ACTIONS(161),
    [anon_sym_unless] = ACTIONS(166),
    [anon_sym_endunless] = ACTIONS(161),
    [anon_sym_capture] = ACTIONS(169),
    [anon_sym_endcapture] = ACTIONS(161),
    [anon_sym_form] = ACTIONS(172),
    [anon_sym_endform] = ACTIONS(161),
    [anon_sym_tablerow] = ACTIONS(175),
    [anon_sym_endtablerow] = ACTIONS(161),
    [anon_sym_paginate] = ACTIONS(178),
    [anon_sym_endpaginate] = ACTIONS(161),
  },
  [7] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__elsif_liq] = STATE(738),
    [sym__else_liq] = STATE(1254),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym__else_aliased] = STATE(1254),
    [sym__elsif_aliased] = STATE(737),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [aux_sym__if_liq_repeat2] = STATE(417),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_elsif] = ACTIONS(75),
    [anon_sym_else] = ACTIONS(77),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_endunless] = ACTIONS(181),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [8] = {
    [sym__liquid_node] = STATE(140),
    [sym__untagged_unpaired_statement] = STATE(1157),
    [sym__untagged_paired_statement] = STATE(1157),
    [sym__expression] = STATE(324),
    [sym__literal] = STATE(324),
    [sym_string] = STATE(324),
    [sym_boolean] = STATE(324),
    [sym_predicate] = STATE(324),
    [sym_echo_statement] = STATE(1157),
    [sym_section_statement] = STATE(1157),
    [sym_sections_statement] = STATE(1157),
    [sym_increment_statement] = STATE(1157),
    [sym_decrement_statement] = STATE(1157),
    [sym_layout_statement] = STATE(1157),
    [sym_custom_unpaired_statement] = STATE(1157),
    [sym_assignment_statement] = STATE(1157),
    [sym_cycle_statement] = STATE(1157),
    [sym_include_statement] = STATE(1157),
    [sym_render_statement] = STATE(1157),
    [sym_filter] = STATE(324),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__elsif_liq] = STATE(738),
    [sym__else_liq] = STATE(1210),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym__else_aliased] = STATE(1210),
    [sym__elsif_aliased] = STATE(737),
    [aux_sym__if_liq_repeat1] = STATE(6),
    [aux_sym__if_liq_repeat2] = STATE(415),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(25),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_endif] = ACTIONS(183),
    [anon_sym_elsif] = ACTIONS(75),
    [anon_sym_else] = ACTIONS(77),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
  },
  [9] = {
    [sym__liquid_node] = STATE(11),
    [sym__untagged_unpaired_statement] = STATE(1154),
    [sym__untagged_paired_statement] = STATE(1154),
    [sym__expression] = STATE(326),
    [sym__literal] = STATE(326),
    [sym_string] = STATE(326),
    [sym_boolean] = STATE(326),
    [sym_predicate] = STATE(326),
    [sym_echo_statement] = STATE(1154),
    [sym_section_statement] = STATE(1154),
    [sym_sections_statement] = STATE(1154),
    [sym_increment_statement] = STATE(1154),
    [sym_decrement_statement] = STATE(1154),
    [sym_layout_statement] = STATE(1154),
    [sym_custom_unpaired_statement] = STATE(1154),
    [sym_assignment_statement] = STATE(1154),
    [sym_cycle_statement] = STATE(1154),
    [sym_include_statement] = STATE(1154),
    [sym_render_statement] = STATE(1154),
    [sym_filter] = STATE(326),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym_comment_liq] = STATE(11),
    [sym__paired_comment_liq] = STATE(158),
    [aux_sym_liquid_tag_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(185),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(185),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(187),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(189),
    [sym_continue_statement] = ACTIONS(189),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
    [anon_sym_comment] = ACTIONS(191),
    [sym__inline_comment_content] = ACTIONS(193),
  },
  [10] = {
    [sym__liquid_node] = STATE(9),
    [sym__untagged_unpaired_statement] = STATE(1154),
    [sym__untagged_paired_statement] = STATE(1154),
    [sym__expression] = STATE(326),
    [sym__literal] = STATE(326),
    [sym_string] = STATE(326),
    [sym_boolean] = STATE(326),
    [sym_predicate] = STATE(326),
    [sym_echo_statement] = STATE(1154),
    [sym_section_statement] = STATE(1154),
    [sym_sections_statement] = STATE(1154),
    [sym_increment_statement] = STATE(1154),
    [sym_decrement_statement] = STATE(1154),
    [sym_layout_statement] = STATE(1154),
    [sym_custom_unpaired_statement] = STATE(1154),
    [sym_assignment_statement] = STATE(1154),
    [sym_cycle_statement] = STATE(1154),
    [sym_include_statement] = STATE(1154),
    [sym_render_statement] = STATE(1154),
    [sym_filter] = STATE(326),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym_comment_liq] = STATE(9),
    [sym__paired_comment_liq] = STATE(158),
    [aux_sym_liquid_tag_repeat1] = STATE(9),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(195),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(195),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(19),
    [anon_sym_SQUOTE] = ACTIONS(21),
    [anon_sym_DQUOTE] = ACTIONS(23),
    [sym_number] = ACTIONS(187),
    [anon_sym_true] = ACTIONS(27),
    [anon_sym_false] = ACTIONS(27),
    [sym_break_statement] = ACTIONS(189),
    [sym_continue_statement] = ACTIONS(189),
    [anon_sym_echo] = ACTIONS(47),
    [anon_sym_section] = ACTIONS(49),
    [anon_sym_sections] = ACTIONS(51),
    [anon_sym_increment] = ACTIONS(53),
    [anon_sym_decrement] = ACTIONS(55),
    [anon_sym_layout] = ACTIONS(57),
    [anon_sym_assign] = ACTIONS(59),
    [anon_sym_cycle] = ACTIONS(61),
    [anon_sym_include] = ACTIONS(63),
    [anon_sym_include_relative] = ACTIONS(63),
    [anon_sym_render] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(71),
    [anon_sym_case] = ACTIONS(79),
    [anon_sym_unless] = ACTIONS(81),
    [anon_sym_capture] = ACTIONS(83),
    [anon_sym_form] = ACTIONS(85),
    [anon_sym_tablerow] = ACTIONS(87),
    [anon_sym_paginate] = ACTIONS(89),
    [anon_sym_comment] = ACTIONS(191),
    [sym__inline_comment_content] = ACTIONS(193),
  },
  [11] = {
    [sym__liquid_node] = STATE(11),
    [sym__untagged_unpaired_statement] = STATE(1154),
    [sym__untagged_paired_statement] = STATE(1154),
    [sym__expression] = STATE(326),
    [sym__literal] = STATE(326),
    [sym_string] = STATE(326),
    [sym_boolean] = STATE(326),
    [sym_predicate] = STATE(326),
    [sym_echo_statement] = STATE(1154),
    [sym_section_statement] = STATE(1154),
    [sym_sections_statement] = STATE(1154),
    [sym_increment_statement] = STATE(1154),
    [sym_decrement_statement] = STATE(1154),
    [sym_layout_statement] = STATE(1154),
    [sym_custom_unpaired_statement] = STATE(1154),
    [sym_assignment_statement] = STATE(1154),
    [sym_cycle_statement] = STATE(1154),
    [sym_include_statement] = STATE(1154),
    [sym_render_statement] = STATE(1154),
    [sym_filter] = STATE(326),
    [sym_access] = STATE(284),
    [sym__if_liq] = STATE(1149),
    [sym__for_loop_liq] = STATE(1148),
    [sym__case_liq] = STATE(1147),
    [sym__unless_liq] = STATE(1146),
    [sym__capture_liq] = STATE(1145),
    [sym__form_liq] = STATE(1144),
    [sym__tablerow_liq] = STATE(1143),
    [sym__paginate_liq] = STATE(1142),
    [sym_comment_liq] = STATE(11),
    [sym__paired_comment_liq] = STATE(158),
    [aux_sym_liquid_tag_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(200),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(200),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(202),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(214),
    [anon_sym_true] = ACTIONS(217),
    [anon_sym_false] = ACTIONS(217),
    [sym_break_statement] = ACTIONS(220),
    [sym_continue_statement] = ACTIONS(220),
    [anon_sym_echo] = ACTIONS(223),
    [anon_sym_section] = ACTIONS(226),
    [anon_sym_sections] = ACTIONS(229),
    [anon_sym_increment] = ACTIONS(232),
    [anon_sym_decrement] = ACTIONS(235),
    [anon_sym_layout] = ACTIONS(238),
    [anon_sym_assign] = ACTIONS(241),
    [anon_sym_cycle] = ACTIONS(244),
    [anon_sym_include] = ACTIONS(247),
    [anon_sym_include_relative] = ACTIONS(247),
    [anon_sym_render] = ACTIONS(250),
    [anon_sym_for] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_case] = ACTIONS(259),
    [anon_sym_unless] = ACTIONS(262),
    [anon_sym_capture] = ACTIONS(265),
    [anon_sym_form] = ACTIONS(268),
    [anon_sym_tablerow] = ACTIONS(271),
    [anon_sym_paginate] = ACTIONS(274),
    [anon_sym_comment] = ACTIONS(277),
    [sym__inline_comment_content] = ACTIONS(280),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 42,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_else,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(283), 1,
      anon_sym_endfor,
    STATE(16), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(1198), 2,
      sym__else_liq,
      sym__else_aliased,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [148] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(285), 4,
      anon_sym_endif,
      anon_sym_endfor,
      anon_sym_endcase,
      anon_sym_endunless,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [292] = 43,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(287), 1,
      anon_sym_COMMA,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(293), 1,
      anon_sym_endform,
    STATE(30), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [442] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(13), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(295), 4,
      anon_sym_endif,
      anon_sym_endfor,
      anon_sym_endcase,
      anon_sym_endunless,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [586] = 42,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(77), 1,
      anon_sym_else,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(297), 1,
      anon_sym_endfor,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(1185), 2,
      sym__else_liq,
      sym__else_aliased,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [734] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(299), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [878] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(19), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(99), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1021] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(301), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1164] = 5,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COLON,
    ACTIONS(305), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1236] = 41,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(287), 1,
      anon_sym_COMMA,
    ACTIONS(293), 1,
      anon_sym_endform,
    STATE(30), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1380] = 6,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1454] = 2,
    ACTIONS(317), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
    ACTIONS(315), 43,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1519] = 4,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(319), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1588] = 2,
    ACTIONS(325), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
    ACTIONS(323), 43,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1653] = 4,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [1722] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(327), 1,
      anon_sym_endform,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [1863] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(329), 1,
      anon_sym_endtablerow,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2004] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(331), 1,
      anon_sym_endpaginate,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2145] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(333), 1,
      anon_sym_endform,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2286] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(335), 1,
      anon_sym_endform,
    STATE(27), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2427] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(337), 1,
      anon_sym_endcapture,
    STATE(6), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2568] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(339), 1,
      anon_sym_endcapture,
    STATE(32), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2709] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(341), 1,
      anon_sym_endtablerow,
    STATE(28), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2850] = 40,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_echo,
    ACTIONS(49), 1,
      anon_sym_section,
    ACTIONS(51), 1,
      anon_sym_sections,
    ACTIONS(53), 1,
      anon_sym_increment,
    ACTIONS(55), 1,
      anon_sym_decrement,
    ACTIONS(57), 1,
      anon_sym_layout,
    ACTIONS(59), 1,
      anon_sym_assign,
    ACTIONS(61), 1,
      anon_sym_cycle,
    ACTIONS(65), 1,
      anon_sym_render,
    ACTIONS(67), 1,
      anon_sym_for,
    ACTIONS(71), 1,
      anon_sym_if,
    ACTIONS(79), 1,
      anon_sym_case,
    ACTIONS(81), 1,
      anon_sym_unless,
    ACTIONS(83), 1,
      anon_sym_capture,
    ACTIONS(85), 1,
      anon_sym_form,
    ACTIONS(87), 1,
      anon_sym_tablerow,
    ACTIONS(89), 1,
      anon_sym_paginate,
    ACTIONS(343), 1,
      anon_sym_endpaginate,
    STATE(29), 1,
      aux_sym__if_liq_repeat1,
    STATE(140), 1,
      sym__liquid_node,
    STATE(284), 1,
      sym_access,
    STATE(1142), 1,
      sym__paginate_liq,
    STATE(1143), 1,
      sym__tablerow_liq,
    STATE(1144), 1,
      sym__form_liq,
    STATE(1145), 1,
      sym__capture_liq,
    STATE(1146), 1,
      sym__unless_liq,
    STATE(1147), 1,
      sym__case_liq,
    STATE(1148), 1,
      sym__for_loop_liq,
    STATE(1149), 1,
      sym__if_liq,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(63), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(324), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    STATE(1157), 13,
      sym__untagged_unpaired_statement,
      sym__untagged_paired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [2991] = 4,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3059] = 4,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(39), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(347), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(345), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3127] = 7,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COLON,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 39,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3201] = 4,
    ACTIONS(349), 1,
      anon_sym_COMMA,
    STATE(39), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3269] = 2,
    ACTIONS(354), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(352), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3332] = 2,
    ACTIONS(321), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(319), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3395] = 2,
    ACTIONS(358), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(356), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3458] = 2,
    ACTIONS(305), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
    ACTIONS(303), 42,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [3521] = 4,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(97), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3585] = 3,
    ACTIONS(364), 1,
      anon_sym_COLON,
    ACTIONS(362), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(360), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3646] = 2,
    ACTIONS(368), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(366), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3704] = 3,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(372), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3764] = 10,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 7,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PIPE,
    ACTIONS(370), 32,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3838] = 2,
    ACTIONS(372), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3896] = 9,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COLON,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [3968] = 2,
    ACTIONS(378), 15,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(376), 38,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4026] = 9,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 7,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PIPE,
    ACTIONS(370), 34,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4098] = 5,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(372), 12,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 37,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4162] = 7,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(372), 11,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(370), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4230] = 8,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4299] = 6,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(97), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 10,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(309), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
  [4362] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(410), 1,
      anon_sym_endif,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4476] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(442), 1,
      anon_sym_endif,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4590] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(444), 1,
      anon_sym_endif,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4704] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(446), 1,
      anon_sym_endunless,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4818] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(448), 1,
      anon_sym_endunless,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [4932] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(450), 1,
      anon_sym_endif,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5046] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(452), 1,
      anon_sym_endunless,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5160] = 33,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      anon_sym_elsif,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(454), 1,
      anon_sym_endunless,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5274] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(456), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5385] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(458), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5496] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(460), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5607] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(462), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5718] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(464), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5829] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(466), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [5940] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(468), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6051] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(470), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6162] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(472), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6273] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(474), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6384] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(476), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6495] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(478), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6606] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(480), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6717] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(482), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6828] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(484), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [6939] = 32,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(414), 1,
      anon_sym_else,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(486), 1,
      anon_sym_endfor,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7050] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(488), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7158] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(490), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7266] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(492), 1,
      anon_sym_endstyle,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7374] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(494), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7482] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(496), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7590] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(498), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7698] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(500), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7806] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(502), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [7914] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(504), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8022] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(506), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8130] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(508), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8238] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(510), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8346] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(512), 1,
      anon_sym_endcapture,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8454] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(514), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8562] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(516), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8670] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(518), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8778] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(520), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8886] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(522), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [8994] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(524), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9102] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(526), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9210] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(528), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9318] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(530), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9426] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(532), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9534] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(534), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9642] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(536), 1,
      anon_sym_endcapture,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9750] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(538), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9858] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(540), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [9966] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(542), 1,
      anon_sym_endcapture,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10074] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(544), 1,
      anon_sym_endjavascript,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10182] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(546), 1,
      anon_sym_endstylesheet,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10290] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(548), 1,
      anon_sym_endstyle,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10398] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(550), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10506] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(552), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10614] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(554), 1,
      anon_sym_endcapture,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10722] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(556), 1,
      anon_sym_endjavascript,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10830] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(558), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [10938] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(560), 1,
      anon_sym_endform,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11046] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(562), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11154] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(564), 1,
      anon_sym_endstylesheet,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11262] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(566), 1,
      anon_sym_endstyle,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11370] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(568), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11478] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(570), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11586] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(572), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11694] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(574), 1,
      anon_sym_endjavascript,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11802] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(576), 1,
      anon_sym_endstylesheet,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [11910] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(578), 1,
      anon_sym_endstylesheet,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12018] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(580), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12126] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(582), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12234] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(584), 1,
      anon_sym_endjavascript,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12342] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(586), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12450] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(588), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12558] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(590), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12666] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(592), 1,
      anon_sym_endstyle,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12774] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(594), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12882] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(596), 1,
      anon_sym_endtablerow,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [12990] = 31,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    ACTIONS(598), 1,
      anon_sym_endpaginate,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [13098] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(602), 1,
      anon_sym_for,
    ACTIONS(604), 1,
      anon_sym_if,
    ACTIONS(606), 1,
      anon_sym_case,
    ACTIONS(608), 1,
      anon_sym_unless,
    ACTIONS(610), 1,
      anon_sym_capture,
    ACTIONS(612), 1,
      anon_sym_form,
    ACTIONS(614), 1,
      anon_sym_tablerow,
    ACTIONS(616), 1,
      anon_sym_paginate,
    ACTIONS(618), 1,
      anon_sym_schema,
    ACTIONS(620), 1,
      anon_sym_style,
    ACTIONS(622), 1,
      anon_sym_stylesheet,
    ACTIONS(624), 1,
      anon_sym_javascript,
    ACTIONS(626), 1,
      anon_sym_raw,
    ACTIONS(628), 1,
      anon_sym_comment,
    ACTIONS(630), 1,
      sym__inline_comment_content,
    STATE(747), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    ACTIONS(600), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(932), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [13203] = 30,
    ACTIONS(380), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_liquid,
    ACTIONS(386), 1,
      anon_sym_echo,
    ACTIONS(388), 1,
      anon_sym_section,
    ACTIONS(390), 1,
      anon_sym_sections,
    ACTIONS(392), 1,
      anon_sym_increment,
    ACTIONS(394), 1,
      anon_sym_decrement,
    ACTIONS(396), 1,
      anon_sym_layout,
    ACTIONS(398), 1,
      anon_sym_assign,
    ACTIONS(400), 1,
      anon_sym_cycle,
    ACTIONS(404), 1,
      anon_sym_render,
    ACTIONS(406), 1,
      anon_sym_for,
    ACTIONS(408), 1,
      anon_sym_if,
    ACTIONS(416), 1,
      anon_sym_case,
    ACTIONS(418), 1,
      anon_sym_unless,
    ACTIONS(420), 1,
      anon_sym_capture,
    ACTIONS(422), 1,
      anon_sym_form,
    ACTIONS(424), 1,
      anon_sym_tablerow,
    ACTIONS(426), 1,
      anon_sym_paginate,
    ACTIONS(428), 1,
      anon_sym_schema,
    ACTIONS(430), 1,
      anon_sym_style,
    ACTIONS(432), 1,
      anon_sym_stylesheet,
    ACTIONS(434), 1,
      anon_sym_javascript,
    ACTIONS(436), 1,
      anon_sym_raw,
    ACTIONS(438), 1,
      anon_sym_comment,
    ACTIONS(440), 1,
      sym__inline_comment_content,
    STATE(744), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(384), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(402), 2,
      anon_sym_include,
      anon_sym_include_relative,
    STATE(942), 13,
      sym_liquid_tag,
      sym__untagged_unpaired_statement,
      sym_echo_statement,
      sym_section_statement,
      sym_sections_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_layout_statement,
      sym_custom_unpaired_statement,
      sym_assignment_statement,
      sym_cycle_statement,
      sym_include_statement,
      sym_render_statement,
  [13308] = 2,
    ACTIONS(634), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(632), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_endcapture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13353] = 2,
    ACTIONS(638), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(636), 36,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_unless,
      anon_sym_endunless,
      anon_sym_capture,
      anon_sym_endcapture,
      anon_sym_form,
      anon_sym_endform,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13398] = 7,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    STATE(22), 1,
      sym_access,
    STATE(147), 1,
      sym_argument_list,
    ACTIONS(642), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    STATE(36), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
    ACTIONS(640), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [13453] = 5,
    STATE(22), 1,
      sym_access,
    STATE(147), 1,
      sym_argument_list,
    ACTIONS(642), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    STATE(36), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
    ACTIONS(640), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [13502] = 7,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(307), 1,
      anon_sym_COLON,
    ACTIONS(313), 1,
      anon_sym_COMMA,
    STATE(37), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(646), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(644), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [13552] = 13,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(650), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(655), 1,
      anon_sym_SQUOTE,
    ACTIONS(657), 1,
      anon_sym_DQUOTE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(235), 1,
      sym_access,
    STATE(328), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(653), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(254), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
    ACTIONS(97), 16,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [13614] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(149), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(707), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(895), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(671), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13671] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(154), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(696), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(889), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(675), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13728] = 2,
    ACTIONS(679), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(677), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [13767] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(150), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(695), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(924), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(681), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13824] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(714), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(834), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(683), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13881] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(710), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(888), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(685), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [13938] = 2,
    ACTIONS(689), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(687), 28,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_else,
      anon_sym_endfor,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_endtablerow,
      anon_sym_paginate,
  [13977] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(694), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(908), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(691), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14034] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(152), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(699), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(931), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(693), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14091] = 11,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(712), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(847), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(695), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14148] = 5,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(701), 1,
      anon_sym_COMMA,
    ACTIONS(699), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(697), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [14192] = 2,
    ACTIONS(634), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(632), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [14230] = 2,
    ACTIONS(705), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(703), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [14268] = 2,
    ACTIONS(709), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(707), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [14306] = 2,
    ACTIONS(713), 7,
      sym__inline_comment_content,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(711), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_comment,
  [14344] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(715), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(717), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(868), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14397] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(719), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(721), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(160), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(873), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14450] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(723), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(725), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(166), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(872), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14503] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(727), 1,
      ts_builtin_sym_end,
    STATE(171), 1,
      aux_sym_program_repeat1,
    STATE(403), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(406), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14554] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(729), 1,
      ts_builtin_sym_end,
    STATE(163), 1,
      aux_sym_program_repeat1,
    STATE(403), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(406), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14605] = 9,
    ACTIONS(5), 1,
      aux_sym_template_content_token1,
    ACTIONS(729), 1,
      ts_builtin_sym_end,
    STATE(171), 1,
      aux_sym_program_repeat1,
    STATE(403), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(7), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(9), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(406), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14656] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(731), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(733), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(867), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14709] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(735), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(737), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(953), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14762] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(739), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(741), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(169), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(965), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14815] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(743), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(745), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(971), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14868] = 10,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(747), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(749), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(167), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(838), 1,
      sym_else_clause,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14921] = 9,
    ACTIONS(751), 1,
      ts_builtin_sym_end,
    ACTIONS(753), 1,
      aux_sym_template_content_token1,
    STATE(171), 1,
      aux_sym_program_repeat1,
    STATE(403), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(756), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(759), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(762), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(408), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(406), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [14972] = 2,
    ACTIONS(646), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(644), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [15009] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(765), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(767), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(174), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15059] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(769), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(771), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15109] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(182), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(773), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15157] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(776), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(778), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15207] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(780), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(782), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15257] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(784), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15305] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(786), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15353] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(788), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15401] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(184), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(791), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15449] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(794), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15497] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(797), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(799), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(206), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15547] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(801), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15595] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(804), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15643] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(179), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(806), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15691] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(178), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(808), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15739] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(185), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(810), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15787] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(180), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(812), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15835] = 3,
    ACTIONS(701), 1,
      anon_sym_COMMA,
    ACTIONS(699), 4,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
    ACTIONS(697), 26,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_echo,
      anon_sym_section,
      anon_sym_sections,
      anon_sym_increment,
      anon_sym_decrement,
      anon_sym_layout,
      anon_sym_assign,
      anon_sym_cycle,
      anon_sym_include,
      anon_sym_include_relative,
      anon_sym_render,
      anon_sym_for,
      anon_sym_if,
      anon_sym_case,
      anon_sym_unless,
      anon_sym_capture,
      anon_sym_form,
      anon_sym_tablerow,
      anon_sym_paginate,
      anon_sym_endpaginate,
  [15873] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(815), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15921] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(817), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [15969] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(819), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(821), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16019] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(823), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(825), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16069] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(191), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(827), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16117] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(829), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(831), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16167] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(833), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(835), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(177), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16217] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(837), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(839), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16267] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(841), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(843), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(176), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16317] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(205), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(845), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16365] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(847), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(849), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(198), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16415] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(851), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(853), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(196), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16465] = 8,
    ACTIONS(855), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(858), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(861), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(864), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16513] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(867), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(869), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(194), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16563] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(871), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16611] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(873), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(875), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(203), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16661] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(192), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(877), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16709] = 9,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    ACTIONS(879), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(881), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(193), 1,
      aux_sym_program_repeat1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(650), 20,
      sym__node,
      sym_template_content,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
  [16759] = 2,
    ACTIONS(323), 13,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_by,
    ACTIONS(325), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT,
      anon_sym_RPAREN,
  [16794] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(612), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(883), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(220), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_stylesheet_statement_repeat1,
  [16841] = 8,
    ACTIONS(885), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(611), 1,
      sym_template_content,
    ACTIONS(888), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(891), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(894), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(211), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [16888] = 2,
    ACTIONS(315), 13,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
      anon_sym_by,
    ACTIONS(317), 17,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT,
      anon_sym_RPAREN,
  [16923] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(612), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(897), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(214), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_stylesheet_statement_repeat1,
  [16970] = 8,
    ACTIONS(899), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(612), 1,
      sym_template_content,
    ACTIONS(902), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(905), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(908), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(214), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_stylesheet_statement_repeat1,
  [17017] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(611), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(911), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(222), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [17064] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(612), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(913), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(213), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_stylesheet_statement_repeat1,
  [17111] = 7,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(915), 1,
      anon_sym_COLON,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17156] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(613), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(923), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(221), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [17203] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(613), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(925), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(221), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [17250] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(612), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(927), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(214), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_stylesheet_statement_repeat1,
  [17297] = 8,
    ACTIONS(929), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(613), 1,
      sym_template_content,
    ACTIONS(932), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(935), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(938), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(221), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [17344] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(611), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(941), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(211), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [17391] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(613), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(943), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(219), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [17438] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(611), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(945), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(211), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [17485] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(611), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(947), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(224), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_style_statement_repeat1,
  [17532] = 8,
    ACTIONS(667), 1,
      aux_sym_template_content_token1,
    STATE(416), 1,
      aux_sym_template_content_repeat1,
    STATE(613), 1,
      sym_template_content,
    ACTIONS(669), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(673), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(949), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(651), 2,
      sym__inline_comment,
      sym__paired_comment,
    STATE(218), 19,
      sym__statement,
      sym__tagged_unpaired_statement,
      sym__output_statement,
      sym__tagged_paired_statment,
      sym_if_statement,
      sym_for_loop_statement,
      sym_case_statement,
      sym_unless_statement,
      sym_capture_statement,
      sym_form_statement,
      sym_tablerow_statement,
      sym_paginate_statement,
      sym_schema_statement,
      sym_style_statement,
      sym_stylesheet_statement,
      sym_javascript_statement,
      sym_raw_statement,
      sym_comment,
      aux_sym_javascript_statement_repeat1,
  [17579] = 6,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17621] = 5,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(915), 1,
      anon_sym_COLON,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17661] = 2,
    ACTIONS(317), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(315), 27,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [17694] = 4,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17731] = 2,
    ACTIONS(325), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(323), 27,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [17764] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17801] = 4,
    ACTIONS(347), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(236), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(345), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17837] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(233), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17873] = 4,
    ACTIONS(95), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(919), 1,
      anon_sym_DOT,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17909] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(951), 1,
      anon_sym_COMMA,
    STATE(236), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [17945] = 2,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(319), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [17976] = 2,
    ACTIONS(358), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(356), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18007] = 2,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(303), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18038] = 2,
    ACTIONS(356), 10,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_for,
      anon_sym_with,
    ACTIONS(358), 16,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_RBRACK,
  [18069] = 2,
    ACTIONS(354), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(352), 25,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18100] = 7,
    ACTIONS(954), 1,
      anon_sym_COLON,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18141] = 12,
    ACTIONS(29), 1,
      anon_sym_PLUS,
    ACTIONS(31), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(43), 1,
      anon_sym_contains,
    ACTIONS(69), 1,
      anon_sym_PIPE,
    ACTIONS(374), 1,
      anon_sym_PERCENT,
    ACTIONS(33), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(962), 4,
      anon_sym_LBRACE_LBRACE,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(964), 6,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
  [18192] = 3,
    ACTIONS(362), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(966), 1,
      anon_sym_COLON,
    ACTIONS(360), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18225] = 2,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(370), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18255] = 5,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(968), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(970), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 18,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18291] = 2,
    ACTIONS(368), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(366), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18321] = 7,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(968), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(976), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(970), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(974), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(370), 10,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_contains,
      anon_sym_PIPE,
  [18361] = 6,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(968), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(970), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(974), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(370), 12,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18399] = 3,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(370), 23,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18431] = 4,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(970), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 20,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18465] = 5,
    ACTIONS(954), 1,
      anon_sym_COLON,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18501] = 2,
    ACTIONS(378), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(376), 24,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18531] = 9,
    ACTIONS(964), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(972), 1,
      anon_sym_CARET,
    ACTIONS(978), 1,
      anon_sym_contains,
    ACTIONS(980), 1,
      anon_sym_PIPE,
    ACTIONS(968), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(976), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(970), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(974), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(962), 8,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [18575] = 6,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18613] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18646] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(321), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18679] = 4,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    STATE(259), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(311), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18711] = 4,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    STATE(261), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(345), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(347), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18743] = 7,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(982), 1,
      anon_sym_COLON,
    ACTIONS(984), 1,
      anon_sym_COMMA,
    STATE(288), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18781] = 4,
    ACTIONS(986), 1,
      anon_sym_COMMA,
    STATE(261), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18813] = 8,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18853] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(95), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [18885] = 2,
    ACTIONS(352), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(354), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [18912] = 7,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18949] = 6,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(984), 1,
      anon_sym_COMMA,
    STATE(288), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [18984] = 5,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(982), 1,
      anon_sym_COLON,
    ACTIONS(303), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19017] = 2,
    ACTIONS(303), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(305), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19044] = 2,
    ACTIONS(319), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(321), 14,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19071] = 2,
    ACTIONS(358), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(356), 21,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_for,
      anon_sym_with,
      anon_sym_PIPE,
  [19098] = 3,
    ACTIONS(993), 1,
      anon_sym_COLON,
    ACTIONS(360), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(362), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19127] = 7,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(370), 6,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 9,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19163] = 4,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19193] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(370), 2,
      sym_identifier,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1009), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 5,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PIPE,
  [19235] = 2,
    ACTIONS(317), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(315), 20,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [19261] = 2,
    ACTIONS(325), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(323), 20,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_LBRACK,
  [19287] = 2,
    ACTIONS(366), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(368), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19313] = 9,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(370), 4,
      sym_identifier,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 5,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PIPE,
  [19353] = 2,
    ACTIONS(376), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(378), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19379] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19409] = 5,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(370), 7,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 10,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19441] = 2,
    ACTIONS(370), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 13,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19467] = 3,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(370), 8,
      sym_identifier,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
    ACTIONS(372), 12,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [19495] = 4,
    ACTIONS(95), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19524] = 4,
    ACTIONS(311), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(984), 1,
      anon_sym_COMMA,
    STATE(288), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(309), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19553] = 5,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19584] = 4,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1011), 1,
      anon_sym_COMMA,
    STATE(287), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(303), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19613] = 4,
    ACTIONS(347), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(984), 1,
      anon_sym_COMMA,
    STATE(287), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(345), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19642] = 3,
    ACTIONS(362), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1014), 1,
      anon_sym_COLON,
    ACTIONS(360), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19668] = 2,
    ACTIONS(321), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(319), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19692] = 2,
    ACTIONS(305), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(303), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19716] = 12,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1020), 1,
      anon_sym_contains,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1009), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1018), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19760] = 2,
    ACTIONS(354), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(352), 18,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_COMMA,
      anon_sym_PIPE,
  [19784] = 3,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(370), 16,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19809] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1026), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19848] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1032), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19889] = 2,
    ACTIONS(368), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(366), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [19912] = 11,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1046), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(307), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1036), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(243), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [19953] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1050), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [19994] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1052), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20035] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1054), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20074] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1056), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20113] = 3,
    ACTIONS(1058), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(97), 4,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(95), 12,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [20138] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1060), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20179] = 2,
    ACTIONS(378), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(376), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [20202] = 9,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1070), 1,
      anon_sym_contains,
    ACTIONS(1072), 1,
      anon_sym_PIPE,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20239] = 11,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1046), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(315), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1074), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(243), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20280] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20319] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1078), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20358] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1080), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20399] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1082), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20440] = 11,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1001), 1,
      anon_sym_PERCENT,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1084), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20481] = 4,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 13,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [20508] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1086), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20547] = 11,
    ACTIONS(1088), 1,
      sym_identifier,
    ACTIONS(1093), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1096), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1099), 1,
      anon_sym_SQUOTE,
    ACTIONS(1102), 1,
      anon_sym_DQUOTE,
    ACTIONS(1105), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    STATE(315), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1091), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1108), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(243), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [20588] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1111), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20627] = 10,
    ACTIONS(995), 1,
      anon_sym_PLUS,
    ACTIONS(997), 1,
      anon_sym_DASH,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1113), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [20666] = 7,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(370), 3,
      sym_identifier,
      anon_sym_contains,
      anon_sym_PIPE,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20699] = 6,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 5,
      sym_identifier,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20730] = 5,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 11,
      sym_identifier,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [20759] = 2,
    ACTIONS(372), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(370), 17,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_contains,
      anon_sym_PIPE,
  [20782] = 8,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1032), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1070), 1,
      anon_sym_contains,
    ACTIONS(1072), 1,
      anon_sym_PIPE,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20816] = 13,
    ACTIONS(1115), 1,
      sym_identifier,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1125), 1,
      sym_number,
    STATE(265), 1,
      sym_access,
    STATE(303), 1,
      sym_predicate,
    STATE(762), 1,
      sym_argument,
    STATE(912), 1,
      sym_argument_list,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(330), 2,
      sym__expression,
      sym_filter,
    STATE(286), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [20860] = 8,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1070), 1,
      anon_sym_contains,
    ACTIONS(1072), 1,
      anon_sym_PIPE,
    ACTIONS(1129), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20894] = 13,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1133), 1,
      sym_number,
    STATE(5), 1,
      sym_predicate,
    STATE(18), 1,
      sym_argument_list,
    STATE(36), 1,
      sym_argument,
    STATE(55), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(332), 2,
      sym__expression,
      sym_filter,
    STATE(56), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [20938] = 8,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1070), 1,
      anon_sym_contains,
    ACTIONS(1072), 1,
      anon_sym_PIPE,
    ACTIONS(1135), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [20972] = 10,
    ACTIONS(1091), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1143), 1,
      anon_sym_SQUOTE,
    ACTIONS(1146), 1,
      anon_sym_DQUOTE,
    ACTIONS(1149), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    STATE(327), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(1140), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1152), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(254), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21010] = 10,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(655), 1,
      anon_sym_SQUOTE,
    ACTIONS(657), 1,
      anon_sym_DQUOTE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(1074), 1,
      aux_sym__liquid_node_token1,
    STATE(235), 1,
      sym_access,
    STATE(327), 1,
      aux_sym_custom_unpaired_statement_repeat1,
    ACTIONS(653), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(254), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21048] = 8,
    ACTIONS(1024), 1,
      anon_sym_CARET,
    ACTIONS(1070), 1,
      anon_sym_contains,
    ACTIONS(1072), 1,
      anon_sym_PIPE,
    ACTIONS(1080), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1062), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1068), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1064), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1066), 6,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [21082] = 8,
    ACTIONS(1003), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1030), 1,
      anon_sym_contains,
    ACTIONS(995), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1007), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1028), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(999), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1005), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [21115] = 11,
    ACTIONS(289), 1,
      anon_sym_DOT,
    ACTIONS(291), 1,
      anon_sym_LBRACK,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1155), 1,
      sym_identifier,
    ACTIONS(1157), 1,
      sym_number,
    STATE(147), 1,
      sym_argument_list,
    STATE(689), 1,
      sym_access,
    ACTIONS(642), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [21154] = 8,
    ACTIONS(35), 1,
      anon_sym_CARET,
    ACTIONS(1022), 1,
      anon_sym_PIPE,
    ACTIONS(1161), 1,
      anon_sym_contains,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1159), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(33), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(37), 4,
      anon_sym_EQ_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
  [21187] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1169), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(251), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21221] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1171), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21255] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1175), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(322), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21289] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1177), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(248), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21323] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1179), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(49), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21357] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1181), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(54), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21391] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1185), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(299), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21425] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1187), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(52), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21459] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1189), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(48), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21493] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1191), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(318), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21527] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1193), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(319), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21561] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1195), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(320), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21595] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1197), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(321), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21629] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1199), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(294), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21663] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1201), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(313), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21697] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1203), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(249), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21731] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1205), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21765] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1207), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(300), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21799] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1209), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(245), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21833] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1211), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(310), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21867] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1213), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(311), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21901] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(312), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21935] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(295), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [21969] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1219), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(2), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22003] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1221), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22037] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1223), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(316), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22071] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1225), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(309), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22105] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(304), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22139] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1229), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(302), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22173] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1231), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(47), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22207] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1233), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(53), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22241] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1235), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(296), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22275] = 9,
    ACTIONS(648), 1,
      sym_identifier,
    ACTIONS(653), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1163), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1237), 1,
      sym_number,
    STATE(235), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(250), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22309] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1239), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(314), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22343] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1241), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(301), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22377] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1243), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(308), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22411] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1245), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(317), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22445] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1247), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(274), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22479] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1249), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(278), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22513] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1251), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(272), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22547] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1253), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(282), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22581] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1255), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(283), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22615] = 9,
    ACTIONS(1117), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1119), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1183), 1,
      sym_identifier,
    ACTIONS(1257), 1,
      sym_number,
    STATE(263), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(281), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22649] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1259), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(306), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22683] = 9,
    ACTIONS(17), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(19), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1261), 1,
      sym_number,
    STATE(284), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(329), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22717] = 9,
    ACTIONS(1034), 1,
      sym_identifier,
    ACTIONS(1038), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1263), 1,
      sym_number,
    STATE(44), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 6,
      sym__expression,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_predicate,
      sym_filter,
  [22751] = 9,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1155), 1,
      sym_identifier,
    ACTIONS(1157), 1,
      sym_number,
    STATE(147), 1,
      sym_argument_list,
    STATE(689), 1,
      sym_access,
    ACTIONS(642), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22784] = 8,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1267), 1,
      sym_number,
    STATE(22), 1,
      sym_access,
    STATE(46), 1,
      sym_argument_list,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(36), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22813] = 8,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1267), 1,
      sym_number,
    ACTIONS(1269), 1,
      sym_identifier,
    STATE(22), 1,
      sym_access,
    STATE(172), 1,
      sym_argument_list,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(36), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22842] = 8,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1157), 1,
      sym_number,
    ACTIONS(1271), 1,
      sym_identifier,
    STATE(172), 1,
      sym_argument_list,
    STATE(689), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22871] = 8,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1157), 1,
      sym_number,
    ACTIONS(1273), 1,
      sym_identifier,
    STATE(689), 1,
      sym_access,
    STATE(906), 1,
      sym_argument_list,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22900] = 8,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1267), 1,
      sym_number,
    STATE(22), 1,
      sym_access,
    STATE(31), 1,
      sym_argument_list,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(36), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22929] = 8,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1157), 1,
      sym_number,
    ACTIONS(1273), 1,
      sym_identifier,
    STATE(689), 1,
      sym_access,
    STATE(833), 1,
      sym_argument_list,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22958] = 8,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1275), 1,
      sym_identifier,
    ACTIONS(1277), 1,
      sym_number,
    STATE(266), 1,
      sym_access,
    STATE(297), 1,
      sym_argument_list,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [22987] = 8,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1279), 1,
      sym_identifier,
    ACTIONS(1281), 1,
      sym_number,
    STATE(227), 1,
      sym_access,
    STATE(247), 1,
      sym_argument_list,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(234), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23016] = 8,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1275), 1,
      sym_identifier,
    ACTIONS(1277), 1,
      sym_number,
    STATE(266), 1,
      sym_access,
    STATE(1232), 1,
      sym_argument_list,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23045] = 8,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1283), 1,
      sym_identifier,
    ACTIONS(1285), 1,
      sym_number,
    STATE(255), 1,
      sym_access,
    STATE(277), 1,
      sym_argument_list,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(258), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23074] = 8,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1157), 1,
      sym_number,
    ACTIONS(1273), 1,
      sym_identifier,
    STATE(689), 1,
      sym_access,
    STATE(887), 1,
      sym_argument_list,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23103] = 7,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1287), 1,
      sym_identifier,
    ACTIONS(1289), 1,
      sym_number,
    STATE(256), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(268), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23129] = 7,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1291), 1,
      sym_identifier,
    ACTIONS(1293), 1,
      sym_number,
    STATE(708), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(43), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23155] = 7,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      sym_number,
    STATE(232), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23181] = 7,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1293), 1,
      sym_number,
    ACTIONS(1299), 1,
      sym_identifier,
    STATE(26), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(43), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23207] = 7,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1301), 1,
      sym_identifier,
    ACTIONS(1303), 1,
      sym_number,
    STATE(280), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(291), 4,
      sym__literal,
      sym_string,
      sym_boolean,
      sym_argument,
  [23233] = 7,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1305), 1,
      sym_identifier,
    ACTIONS(1307), 1,
      sym_number,
    STATE(257), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(269), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [23258] = 7,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1309), 1,
      sym_identifier,
    ACTIONS(1311), 1,
      sym_number,
    STATE(692), 1,
      sym_access,
    ACTIONS(1127), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(41), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [23283] = 7,
    ACTIONS(1165), 1,
      anon_sym_SQUOTE,
    ACTIONS(1167), 1,
      anon_sym_DQUOTE,
    ACTIONS(1313), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      sym_number,
    STATE(230), 1,
      sym_access,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(237), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [23308] = 7,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1317), 1,
      sym_identifier,
    ACTIONS(1319), 1,
      sym_number,
    STATE(273), 1,
      sym_access,
    ACTIONS(27), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(290), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [23333] = 9,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1323), 1,
      anon_sym_endcase,
    ACTIONS(1325), 1,
      anon_sym_when,
    STATE(413), 1,
      aux_sym__case_liq_repeat1,
    STATE(781), 1,
      sym__when_aliased,
    STATE(815), 1,
      sym__when_liq,
    STATE(1184), 2,
      sym__else_liq,
      sym__else_aliased,
  [23362] = 7,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1311), 1,
      sym_number,
    ACTIONS(1327), 1,
      sym_identifier,
    STATE(24), 1,
      sym_access,
    ACTIONS(1048), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(41), 3,
      sym__literal,
      sym_string,
      sym_boolean,
  [23387] = 5,
    ACTIONS(1329), 1,
      ts_builtin_sym_end,
    ACTIONS(1331), 1,
      aux_sym_template_content_token1,
    STATE(402), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1334), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1337), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23407] = 5,
    ACTIONS(1339), 1,
      ts_builtin_sym_end,
    ACTIONS(1341), 1,
      aux_sym_template_content_token1,
    STATE(402), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1344), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1347), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23427] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23440] = 2,
    ACTIONS(1353), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23453] = 2,
    ACTIONS(1357), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1359), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23466] = 2,
    ACTIONS(1361), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1363), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23479] = 2,
    ACTIONS(1365), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1367), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23492] = 2,
    ACTIONS(1369), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23505] = 2,
    ACTIONS(1373), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23518] = 2,
    ACTIONS(1377), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1379), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23531] = 7,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1381), 1,
      anon_sym_endif,
    ACTIONS(1383), 1,
      anon_sym_elsif,
    STATE(660), 1,
      aux_sym__if_liq_repeat2,
    STATE(737), 1,
      sym__elsif_aliased,
    STATE(738), 1,
      sym__elsif_liq,
    STATE(1217), 2,
      sym__else_liq,
      sym__else_aliased,
  [23554] = 7,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1325), 1,
      anon_sym_when,
    ACTIONS(1385), 1,
      anon_sym_endcase,
    STATE(685), 1,
      aux_sym__case_liq_repeat1,
    STATE(781), 1,
      sym__when_aliased,
    STATE(815), 1,
      sym__when_liq,
    STATE(1221), 2,
      sym__else_liq,
      sym__else_aliased,
  [23577] = 7,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1383), 1,
      anon_sym_elsif,
    ACTIONS(1387), 1,
      anon_sym_endunless,
    STATE(660), 1,
      aux_sym__if_liq_repeat2,
    STATE(737), 1,
      sym__elsif_aliased,
    STATE(738), 1,
      sym__elsif_liq,
    STATE(1250), 2,
      sym__else_liq,
      sym__else_aliased,
  [23600] = 7,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1383), 1,
      anon_sym_elsif,
    ACTIONS(1389), 1,
      anon_sym_endif,
    STATE(660), 1,
      aux_sym__if_liq_repeat2,
    STATE(737), 1,
      sym__elsif_aliased,
    STATE(738), 1,
      sym__elsif_liq,
    STATE(1081), 2,
      sym__else_liq,
      sym__else_aliased,
  [23623] = 4,
    ACTIONS(1391), 1,
      aux_sym_template_content_token1,
    STATE(423), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1394), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1347), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23640] = 7,
    ACTIONS(1321), 1,
      anon_sym_else,
    ACTIONS(1383), 1,
      anon_sym_elsif,
    ACTIONS(1397), 1,
      anon_sym_endunless,
    STATE(660), 1,
      aux_sym__if_liq_repeat2,
    STATE(737), 1,
      sym__elsif_aliased,
    STATE(738), 1,
      sym__elsif_liq,
    STATE(1199), 2,
      sym__else_liq,
      sym__else_aliased,
  [23663] = 2,
    ACTIONS(1399), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1401), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23676] = 2,
    ACTIONS(1403), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1405), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23689] = 2,
    ACTIONS(1407), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1409), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23702] = 2,
    ACTIONS(1411), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1413), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23715] = 2,
    ACTIONS(1415), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1417), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23728] = 4,
    ACTIONS(1419), 1,
      aux_sym_template_content_token1,
    STATE(423), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1422), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
    ACTIONS(1337), 4,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23745] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23758] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23771] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23784] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23797] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23810] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23823] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23836] = 2,
    ACTIONS(1425), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23849] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23862] = 2,
    ACTIONS(1433), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1435), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23875] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23888] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23901] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23914] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23927] = 2,
    ACTIONS(1437), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23940] = 2,
    ACTIONS(1441), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23953] = 2,
    ACTIONS(1445), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1447), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23966] = 2,
    ACTIONS(1449), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1451), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23979] = 2,
    ACTIONS(1453), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1455), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [23992] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24005] = 2,
    ACTIONS(1457), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1459), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24018] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24031] = 2,
    ACTIONS(1429), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24044] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24057] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24070] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24083] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24096] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24109] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24122] = 2,
    ACTIONS(1349), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24135] = 2,
    ACTIONS(1461), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24148] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24161] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24174] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24187] = 2,
    ACTIONS(1465), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24200] = 2,
    ACTIONS(1469), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24213] = 2,
    ACTIONS(1469), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24226] = 2,
    ACTIONS(1473), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1475), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24239] = 2,
    ACTIONS(1469), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24252] = 2,
    ACTIONS(1469), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24265] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24278] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24291] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24304] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24317] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24330] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24343] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24356] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24369] = 2,
    ACTIONS(1485), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24382] = 2,
    ACTIONS(1489), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1491), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24395] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24408] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24421] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24434] = 2,
    ACTIONS(1477), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24447] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24460] = 2,
    ACTIONS(1493), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24473] = 2,
    ACTIONS(1493), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24486] = 2,
    ACTIONS(1493), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24499] = 2,
    ACTIONS(1493), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24512] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24525] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24538] = 2,
    ACTIONS(1481), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24551] = 2,
    ACTIONS(1497), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1499), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24564] = 2,
    ACTIONS(1501), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1503), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24577] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24590] = 2,
    ACTIONS(1509), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1511), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24603] = 2,
    ACTIONS(1513), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1515), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24616] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24629] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24642] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24655] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24668] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24681] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24694] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24707] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24720] = 2,
    ACTIONS(1517), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24733] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24746] = 2,
    ACTIONS(1505), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24759] = 2,
    ACTIONS(1521), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24772] = 2,
    ACTIONS(1525), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1527), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24785] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24798] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24811] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24824] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24837] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24850] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24863] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24876] = 2,
    ACTIONS(1529), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24889] = 2,
    ACTIONS(1533), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1535), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24902] = 2,
    ACTIONS(1537), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24915] = 2,
    ACTIONS(1537), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24928] = 2,
    ACTIONS(1537), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24941] = 2,
    ACTIONS(1537), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24954] = 2,
    ACTIONS(1541), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24967] = 2,
    ACTIONS(1541), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24980] = 2,
    ACTIONS(1541), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [24993] = 2,
    ACTIONS(1541), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25006] = 2,
    ACTIONS(1545), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1547), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25019] = 2,
    ACTIONS(1549), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1551), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25032] = 2,
    ACTIONS(1553), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1555), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25045] = 2,
    ACTIONS(1557), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1559), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25058] = 2,
    ACTIONS(1561), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25071] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25084] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25097] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25110] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25123] = 2,
    ACTIONS(1561), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25136] = 2,
    ACTIONS(1561), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25149] = 2,
    ACTIONS(1561), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25162] = 2,
    ACTIONS(1353), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25175] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25188] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25201] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25214] = 2,
    ACTIONS(1565), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25227] = 2,
    ACTIONS(1569), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1571), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25240] = 2,
    ACTIONS(1353), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25253] = 2,
    ACTIONS(1353), 2,
      ts_builtin_sym_end,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25266] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25278] = 2,
    ACTIONS(1441), 1,
      aux_sym_template_content_token1,
    ACTIONS(1443), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25290] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25302] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25314] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25326] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25338] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25350] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25362] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25374] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25386] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25398] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25410] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25422] = 2,
    ACTIONS(1505), 1,
      aux_sym_template_content_token1,
    ACTIONS(1507), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25434] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25446] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25458] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25470] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25482] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25494] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25506] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25518] = 2,
    ACTIONS(1529), 1,
      aux_sym_template_content_token1,
    ACTIONS(1531), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25530] = 2,
    ACTIONS(1533), 1,
      aux_sym_template_content_token1,
    ACTIONS(1535), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25542] = 2,
    ACTIONS(1537), 1,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25554] = 2,
    ACTIONS(1537), 1,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25566] = 2,
    ACTIONS(1537), 1,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25578] = 2,
    ACTIONS(1537), 1,
      aux_sym_template_content_token1,
    ACTIONS(1539), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25590] = 2,
    ACTIONS(1541), 1,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25602] = 2,
    ACTIONS(1541), 1,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25614] = 2,
    ACTIONS(1541), 1,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25626] = 2,
    ACTIONS(1541), 1,
      aux_sym_template_content_token1,
    ACTIONS(1543), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25638] = 2,
    ACTIONS(1545), 1,
      aux_sym_template_content_token1,
    ACTIONS(1547), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25650] = 2,
    ACTIONS(1557), 1,
      aux_sym_template_content_token1,
    ACTIONS(1559), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25662] = 2,
    ACTIONS(1561), 1,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25674] = 2,
    ACTIONS(1561), 1,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25686] = 2,
    ACTIONS(1561), 1,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25698] = 2,
    ACTIONS(1561), 1,
      aux_sym_template_content_token1,
    ACTIONS(1563), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25710] = 2,
    ACTIONS(1353), 1,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25722] = 2,
    ACTIONS(1353), 1,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25734] = 2,
    ACTIONS(1353), 1,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25746] = 2,
    ACTIONS(1353), 1,
      aux_sym_template_content_token1,
    ACTIONS(1355), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25758] = 2,
    ACTIONS(1569), 1,
      aux_sym_template_content_token1,
    ACTIONS(1571), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25770] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25782] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25794] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25806] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25818] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25830] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25842] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25854] = 2,
    ACTIONS(1565), 1,
      aux_sym_template_content_token1,
    ACTIONS(1567), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25866] = 2,
    ACTIONS(1553), 1,
      aux_sym_template_content_token1,
    ACTIONS(1555), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25878] = 2,
    ACTIONS(1549), 1,
      aux_sym_template_content_token1,
    ACTIONS(1551), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25890] = 2,
    ACTIONS(1525), 1,
      aux_sym_template_content_token1,
    ACTIONS(1527), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25902] = 2,
    ACTIONS(1521), 1,
      aux_sym_template_content_token1,
    ACTIONS(1523), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25914] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25926] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25938] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25950] = 2,
    ACTIONS(1517), 1,
      aux_sym_template_content_token1,
    ACTIONS(1519), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25962] = 2,
    ACTIONS(1513), 1,
      aux_sym_template_content_token1,
    ACTIONS(1515), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25974] = 2,
    ACTIONS(1509), 1,
      aux_sym_template_content_token1,
    ACTIONS(1511), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25986] = 2,
    ACTIONS(1501), 1,
      aux_sym_template_content_token1,
    ACTIONS(1503), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [25998] = 2,
    ACTIONS(1497), 1,
      aux_sym_template_content_token1,
    ACTIONS(1499), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26010] = 2,
    ACTIONS(1493), 1,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26022] = 2,
    ACTIONS(1493), 1,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26034] = 2,
    ACTIONS(1493), 1,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26046] = 2,
    ACTIONS(1493), 1,
      aux_sym_template_content_token1,
    ACTIONS(1495), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26058] = 2,
    ACTIONS(1489), 1,
      aux_sym_template_content_token1,
    ACTIONS(1491), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26070] = 2,
    ACTIONS(1485), 1,
      aux_sym_template_content_token1,
    ACTIONS(1487), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26082] = 2,
    ACTIONS(1457), 1,
      aux_sym_template_content_token1,
    ACTIONS(1459), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26094] = 2,
    ACTIONS(1453), 1,
      aux_sym_template_content_token1,
    ACTIONS(1455), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26106] = 2,
    ACTIONS(1573), 1,
      aux_sym_template_content_token1,
    ACTIONS(1575), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26118] = 2,
    ACTIONS(1577), 1,
      aux_sym_template_content_token1,
    ACTIONS(1579), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26130] = 2,
    ACTIONS(1581), 1,
      aux_sym_template_content_token1,
    ACTIONS(1583), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26142] = 2,
    ACTIONS(1449), 1,
      aux_sym_template_content_token1,
    ACTIONS(1451), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26154] = 2,
    ACTIONS(1445), 1,
      aux_sym_template_content_token1,
    ACTIONS(1447), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26166] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26178] = 2,
    ACTIONS(1437), 1,
      aux_sym_template_content_token1,
    ACTIONS(1439), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26190] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26202] = 2,
    ACTIONS(1407), 1,
      aux_sym_template_content_token1,
    ACTIONS(1409), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26214] = 2,
    ACTIONS(1399), 1,
      aux_sym_template_content_token1,
    ACTIONS(1401), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26226] = 2,
    ACTIONS(1361), 1,
      aux_sym_template_content_token1,
    ACTIONS(1363), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26238] = 2,
    ACTIONS(1433), 1,
      aux_sym_template_content_token1,
    ACTIONS(1435), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26250] = 2,
    ACTIONS(1473), 1,
      aux_sym_template_content_token1,
    ACTIONS(1475), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26262] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26274] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26286] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26298] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26310] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26322] = 2,
    ACTIONS(1481), 1,
      aux_sym_template_content_token1,
    ACTIONS(1483), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26334] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26346] = 2,
    ACTIONS(1415), 1,
      aux_sym_template_content_token1,
    ACTIONS(1417), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26358] = 2,
    ACTIONS(1411), 1,
      aux_sym_template_content_token1,
    ACTIONS(1413), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26370] = 2,
    ACTIONS(1403), 1,
      aux_sym_template_content_token1,
    ACTIONS(1405), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26382] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26394] = 6,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(679), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26414] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26426] = 2,
    ACTIONS(1477), 1,
      aux_sym_template_content_token1,
    ACTIONS(1479), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26438] = 2,
    ACTIONS(1469), 1,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26450] = 2,
    ACTIONS(1469), 1,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26462] = 2,
    ACTIONS(1469), 1,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26474] = 2,
    ACTIONS(1469), 1,
      aux_sym_template_content_token1,
    ACTIONS(1471), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26486] = 6,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26506] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26518] = 6,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(646), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [26538] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26550] = 2,
    ACTIONS(1465), 1,
      aux_sym_template_content_token1,
    ACTIONS(1467), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26562] = 2,
    ACTIONS(1461), 1,
      aux_sym_template_content_token1,
    ACTIONS(1463), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26574] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26586] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26598] = 2,
    ACTIONS(1357), 1,
      aux_sym_template_content_token1,
    ACTIONS(1359), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26610] = 2,
    ACTIONS(1365), 1,
      aux_sym_template_content_token1,
    ACTIONS(1367), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26622] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26634] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26646] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26658] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26670] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26682] = 2,
    ACTIONS(1349), 1,
      aux_sym_template_content_token1,
    ACTIONS(1351), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26694] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26706] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26718] = 5,
    ACTIONS(1587), 1,
      anon_sym_elsif,
    STATE(660), 1,
      aux_sym__if_liq_repeat2,
    STATE(737), 1,
      sym__elsif_aliased,
    STATE(738), 1,
      sym__elsif_liq,
    ACTIONS(1585), 3,
      anon_sym_endif,
      anon_sym_else,
      anon_sym_endunless,
  [26736] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26748] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26760] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26772] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26784] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26796] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26808] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26820] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26832] = 2,
    ACTIONS(1429), 1,
      aux_sym_template_content_token1,
    ACTIONS(1431), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26844] = 2,
    ACTIONS(1369), 1,
      aux_sym_template_content_token1,
    ACTIONS(1371), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26856] = 2,
    ACTIONS(1373), 1,
      aux_sym_template_content_token1,
    ACTIONS(1375), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26868] = 2,
    ACTIONS(1377), 1,
      aux_sym_template_content_token1,
    ACTIONS(1379), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26880] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26892] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26904] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26916] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26928] = 2,
    ACTIONS(1425), 1,
      aux_sym_template_content_token1,
    ACTIONS(1427), 6,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_DASH,
  [26940] = 4,
    ACTIONS(1590), 1,
      aux_sym_template_content_token1,
    STATE(423), 1,
      aux_sym_template_content_repeat1,
    ACTIONS(1347), 2,
      anon_sym_LBRACE_PERCENT,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1592), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [26955] = 6,
    ACTIONS(1594), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1596), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1598), 1,
      anon_sym_SQUOTE,
    ACTIONS(1600), 1,
      anon_sym_DQUOTE,
    ACTIONS(1602), 1,
      aux_sym_include_statement_token1,
    STATE(751), 1,
      sym_string,
  [26974] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1604), 1,
      sym_identifier,
    ACTIONS(1606), 1,
      sym_number,
    STATE(718), 1,
      sym_access,
    STATE(735), 1,
      sym_string,
  [26993] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1608), 1,
      sym_identifier,
    ACTIONS(1610), 1,
      sym_number,
    STATE(746), 1,
      sym_access,
    STATE(842), 1,
      sym_string,
  [27012] = 6,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1612), 1,
      sym_identifier,
    ACTIONS(1614), 1,
      sym_number,
    STATE(702), 1,
      sym_access,
    STATE(789), 1,
      sym_string,
  [27031] = 5,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(736), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1616), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27048] = 6,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1620), 1,
      sym_identifier,
    ACTIONS(1622), 1,
      sym_number,
    STATE(683), 1,
      sym_access,
    STATE(756), 1,
      sym_string,
  [27067] = 5,
    ACTIONS(1626), 1,
      anon_sym_when,
    STATE(685), 1,
      aux_sym__case_liq_repeat1,
    STATE(781), 1,
      sym__when_aliased,
    STATE(815), 1,
      sym__when_liq,
    ACTIONS(1624), 2,
      anon_sym_else,
      anon_sym_endcase,
  [27084] = 6,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1629), 1,
      sym_identifier,
    ACTIONS(1631), 1,
      sym_number,
    STATE(691), 1,
      sym_access,
    STATE(703), 1,
      sym_string,
  [27103] = 6,
    ACTIONS(1633), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(1635), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(1637), 1,
      anon_sym_SQUOTE,
    ACTIONS(1639), 1,
      anon_sym_DQUOTE,
    ACTIONS(1641), 1,
      aux_sym_include_statement_token1,
    STATE(705), 1,
      sym_string,
  [27122] = 6,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1643), 1,
      sym_identifier,
    ACTIONS(1645), 1,
      sym_number,
    STATE(724), 1,
      sym_access,
    STATE(786), 1,
      sym_string,
  [27141] = 5,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27158] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(305), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [27173] = 5,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(757), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1647), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27190] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [27202] = 4,
    ACTIONS(1649), 1,
      aux_sym_template_content_token1,
    STATE(678), 1,
      aux_sym_template_content_repeat1,
    STATE(966), 1,
      sym_template_content,
    ACTIONS(1651), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [27216] = 5,
    ACTIONS(1653), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1655), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(871), 1,
      sym_else_clause,
  [27232] = 5,
    ACTIONS(1657), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1659), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(885), 1,
      sym_else_clause,
  [27248] = 5,
    ACTIONS(1661), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1663), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(848), 1,
      sym_else_clause,
  [27264] = 5,
    ACTIONS(1665), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1667), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(743), 1,
      aux_sym_case_statement_repeat1,
    STATE(844), 1,
      sym_else_clause,
    STATE(891), 1,
      sym_when_clause,
  [27280] = 5,
    ACTIONS(1669), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1671), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(743), 1,
      aux_sym_case_statement_repeat1,
    STATE(890), 1,
      sym_else_clause,
    STATE(891), 1,
      sym_when_clause,
  [27296] = 5,
    ACTIONS(1673), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1675), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(893), 1,
      sym_else_clause,
  [27312] = 5,
    ACTIONS(1677), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1679), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(698), 1,
      aux_sym_case_statement_repeat1,
    STATE(891), 1,
      sym_when_clause,
    STATE(927), 1,
      sym_else_clause,
  [27328] = 5,
    ACTIONS(1042), 1,
      anon_sym_SQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1681), 1,
      sym_identifier,
    STATE(14), 1,
      sym_access,
    STATE(21), 1,
      sym_string,
  [27344] = 5,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(1616), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    STATE(787), 1,
      aux_sym_cycle_statement_repeat1,
  [27360] = 4,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    ACTIONS(1685), 1,
      anon_sym_COLON,
    STATE(757), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1647), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27374] = 5,
    ACTIONS(1687), 1,
      sym_identifier,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      sym__iterator,
    STATE(141), 1,
      sym_access,
    STATE(142), 1,
      sym_range,
  [27390] = 3,
    ACTIONS(1691), 1,
      sym_identifier,
    ACTIONS(1693), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(719), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27402] = 5,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    ACTIONS(1695), 1,
      sym_identifier,
    STATE(331), 1,
      sym_access,
    STATE(379), 1,
      sym_range,
    STATE(832), 1,
      sym__iterator,
  [27418] = 5,
    ACTIONS(1697), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1699), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(839), 1,
      sym_else_clause,
  [27434] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [27446] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1703), 1,
      anon_sym_COMMA,
    ACTIONS(1701), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27460] = 5,
    ACTIONS(1705), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1707), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(870), 1,
      sym_else_clause,
  [27476] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1709), 1,
      anon_sym_COMMA,
    ACTIONS(699), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27490] = 5,
    ACTIONS(1711), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1713), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(930), 1,
      sym_else_clause,
  [27506] = 5,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1715), 1,
      sym_identifier,
    STATE(709), 1,
      sym_access,
    STATE(774), 1,
      sym_string,
  [27522] = 5,
    ACTIONS(1717), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1719), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
    STATE(902), 1,
      sym_else_clause,
  [27538] = 3,
    ACTIONS(1721), 1,
      sym_identifier,
    ACTIONS(1724), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(715), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27550] = 3,
    ACTIONS(1691), 1,
      sym_identifier,
    ACTIONS(1726), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(727), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27562] = 4,
    ACTIONS(1730), 1,
      anon_sym_COMMA,
    ACTIONS(1732), 1,
      anon_sym_for,
    ACTIONS(1734), 1,
      anon_sym_with,
    ACTIONS(1728), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27576] = 5,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(1647), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    STATE(812), 1,
      aux_sym_cycle_statement_repeat1,
  [27592] = 3,
    ACTIONS(1691), 1,
      sym_identifier,
    ACTIONS(1736), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(715), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27604] = 5,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    ACTIONS(1695), 1,
      sym_identifier,
    STATE(331), 1,
      sym_access,
    STATE(379), 1,
      sym_range,
    STATE(901), 1,
      sym__iterator,
  [27620] = 5,
    ACTIONS(1738), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1740), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(697), 1,
      aux_sym_case_statement_repeat1,
    STATE(891), 1,
      sym_when_clause,
    STATE(892), 1,
      sym_else_clause,
  [27636] = 5,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    ACTIONS(1695), 1,
      sym_identifier,
    STATE(331), 1,
      sym_access,
    STATE(379), 1,
      sym_range,
    STATE(886), 1,
      sym__iterator,
  [27652] = 4,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1744), 1,
      anon_sym_COMMA,
    ACTIONS(1742), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27666] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1746), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [27678] = 4,
    ACTIONS(1649), 1,
      aux_sym_template_content_token1,
    STATE(678), 1,
      aux_sym_template_content_repeat1,
    STATE(934), 1,
      sym_template_content,
    ACTIONS(1651), 2,
      anon_sym_LBRACE_PERCENT_PERCENT,
      anon_sym_LBRACE_LBRACE_LBRACE,
  [27692] = 5,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1748), 1,
      sym_identifier,
    STATE(723), 1,
      sym_access,
    STATE(809), 1,
      sym_string,
  [27708] = 3,
    ACTIONS(1691), 1,
      sym_identifier,
    ACTIONS(1750), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    STATE(715), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27720] = 5,
    ACTIONS(1687), 1,
      sym_identifier,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    STATE(34), 1,
      sym__iterator,
    STATE(141), 1,
      sym_access,
    STATE(142), 1,
      sym_range,
  [27736] = 5,
    ACTIONS(1689), 1,
      anon_sym_LPAREN,
    ACTIONS(1695), 1,
      sym_identifier,
    STATE(331), 1,
      sym_access,
    STATE(379), 1,
      sym_range,
    STATE(835), 1,
      sym__iterator,
  [27752] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1752), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27763] = 3,
    ACTIONS(1756), 1,
      sym__inline_comment_content,
    STATE(731), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1754), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27774] = 4,
    ACTIONS(1759), 1,
      sym_identifier,
    ACTIONS(1761), 1,
      sym_number,
    STATE(35), 1,
      sym__page_iterator,
    STATE(155), 1,
      sym_access,
  [27787] = 3,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(745), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(347), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27798] = 4,
    ACTIONS(1763), 1,
      sym_identifier,
    ACTIONS(1765), 1,
      sym_number,
    STATE(711), 1,
      sym_access,
    STATE(829), 1,
      sym__page_iterator,
  [27811] = 4,
    ACTIONS(1647), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    ACTIONS(1767), 1,
      anon_sym_COLON,
    STATE(812), 1,
      aux_sym_cycle_statement_repeat1,
  [27824] = 3,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(755), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1769), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27835] = 1,
    ACTIONS(1771), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
  [27842] = 1,
    ACTIONS(1773), 4,
      anon_sym_endif,
      anon_sym_elsif,
      anon_sym_else,
      anon_sym_endunless,
  [27849] = 3,
    ACTIONS(1736), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1775), 1,
      sym_identifier,
    STATE(758), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [27860] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1777), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27871] = 4,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1779), 1,
      anon_sym_none,
    STATE(949), 1,
      sym_string,
  [27884] = 4,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(1781), 1,
      anon_sym_none,
    STATE(1227), 1,
      sym_string,
  [27897] = 4,
    ACTIONS(1783), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1786), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(743), 1,
      aux_sym_case_statement_repeat1,
    STATE(891), 1,
      sym_when_clause,
  [27910] = 3,
    ACTIONS(1791), 1,
      sym__inline_comment_content,
    STATE(731), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1789), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27921] = 3,
    ACTIONS(1793), 1,
      anon_sym_COMMA,
    STATE(745), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(305), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27932] = 4,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(1746), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1796), 1,
      anon_sym_COMMA,
  [27945] = 3,
    ACTIONS(1791), 1,
      sym__inline_comment_content,
    STATE(731), 1,
      aux_sym__inline_comment_repeat1,
    ACTIONS(1798), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [27956] = 4,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1800), 1,
      sym_number,
    STATE(1088), 1,
      sym_string,
  [27969] = 4,
    ACTIONS(1763), 1,
      sym_identifier,
    ACTIONS(1765), 1,
      sym_number,
    STATE(711), 1,
      sym_access,
    STATE(883), 1,
      sym__page_iterator,
  [27982] = 4,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1802), 1,
      sym_number,
    STATE(1096), 1,
      sym_string,
  [27995] = 3,
    ACTIONS(1693), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1775), 1,
      sym_identifier,
    STATE(739), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [28006] = 3,
    ACTIONS(1750), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1775), 1,
      sym_identifier,
    STATE(758), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [28017] = 3,
    ACTIONS(1726), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1775), 1,
      sym_identifier,
    STATE(752), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [28028] = 3,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(757), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1647), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28039] = 3,
    ACTIONS(1804), 1,
      anon_sym_COMMA,
    STATE(755), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1746), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28050] = 3,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(736), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1616), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28061] = 3,
    ACTIONS(1618), 1,
      anon_sym_COMMA,
    STATE(755), 1,
      aux_sym_cycle_statement_repeat1,
    ACTIONS(1807), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28072] = 3,
    ACTIONS(1724), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1809), 1,
      sym_identifier,
    STATE(758), 2,
      sym__include_param,
      aux_sym_include_statement_repeat1,
  [28083] = 4,
    ACTIONS(1812), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1815), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(759), 1,
      aux_sym_if_statement_repeat1,
    STATE(817), 1,
      sym_elsif_clause,
  [28096] = 4,
    ACTIONS(1728), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1818), 1,
      anon_sym_COMMA,
    ACTIONS(1820), 1,
      anon_sym_for,
    ACTIONS(1822), 1,
      anon_sym_with,
  [28109] = 4,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1824), 1,
      sym_number,
    STATE(1124), 1,
      sym_string,
  [28122] = 3,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    STATE(733), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28133] = 4,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1826), 1,
      sym_number,
    STATE(1075), 1,
      sym_string,
  [28146] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1828), 1,
      anon_sym_by,
  [28156] = 3,
    ACTIONS(1830), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1832), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(877), 1,
      sym_raw_statement,
  [28166] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1838), 1,
      anon_sym_endunless,
  [28176] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1840), 1,
      anon_sym_endif,
  [28186] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1842), 1,
      anon_sym_endif,
  [28196] = 3,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1844), 1,
      anon_sym_endcase,
    ACTIONS(1846), 1,
      anon_sym_when,
  [28206] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1848), 1,
      anon_sym_endunless,
  [28216] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1850), 1,
      anon_sym_endunless,
  [28226] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1852), 1,
      anon_sym_endif,
  [28236] = 3,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1854), 1,
      anon_sym_DOT,
    ACTIONS(1856), 1,
      anon_sym_DOT_DOT,
  [28246] = 2,
    ACTIONS(1703), 1,
      anon_sym_COMMA,
    ACTIONS(1701), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28254] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1858), 1,
      anon_sym_endif,
  [28264] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1860), 1,
      anon_sym_endif,
  [28274] = 2,
    ACTIONS(1864), 1,
      anon_sym_as,
    ACTIONS(1862), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28282] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1866), 1,
      anon_sym_endunless,
  [28292] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1868), 1,
      anon_sym_endunless,
  [28302] = 3,
    ACTIONS(1870), 1,
      sym_identifier,
    ACTIONS(1872), 1,
      sym_number,
    STATE(773), 1,
      sym_access,
  [28312] = 1,
    ACTIONS(1874), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
  [28318] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1876), 1,
      anon_sym_by,
  [28328] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1878), 1,
      anon_sym_endif,
  [28338] = 3,
    ACTIONS(1880), 1,
      anon_sym_comment,
    ACTIONS(1882), 1,
      anon_sym_endcomment,
    STATE(1192), 1,
      sym__paired_comment_liq,
  [28348] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1884), 1,
      anon_sym_endif,
  [28358] = 1,
    ACTIONS(1746), 3,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_COMMA,
  [28364] = 3,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    ACTIONS(1769), 1,
      aux_sym__liquid_node_token1,
    STATE(790), 1,
      aux_sym_cycle_statement_repeat1,
  [28374] = 3,
    ACTIONS(1886), 1,
      sym_identifier,
    ACTIONS(1888), 1,
      sym_number,
    STATE(806), 1,
      sym_access,
  [28384] = 3,
    ACTIONS(1616), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    STATE(787), 1,
      aux_sym_cycle_statement_repeat1,
  [28394] = 3,
    ACTIONS(1746), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1890), 1,
      anon_sym_COMMA,
    STATE(790), 1,
      aux_sym_cycle_statement_repeat1,
  [28404] = 3,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1846), 1,
      anon_sym_when,
    ACTIONS(1893), 1,
      anon_sym_endcase,
  [28414] = 3,
    ACTIONS(1895), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1897), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(918), 1,
      sym_raw_statement,
  [28424] = 3,
    ACTIONS(1899), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1901), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(917), 1,
      sym__paired_comment,
  [28434] = 3,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1846), 1,
      anon_sym_when,
    ACTIONS(1903), 1,
      anon_sym_endcase,
  [28444] = 3,
    ACTIONS(1905), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1907), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(875), 1,
      sym__paired_comment,
  [28454] = 3,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1846), 1,
      anon_sym_when,
    ACTIONS(1909), 1,
      anon_sym_endcase,
  [28464] = 3,
    ACTIONS(1880), 1,
      anon_sym_comment,
    ACTIONS(1911), 1,
      anon_sym_endcomment,
    STATE(1121), 1,
      sym__paired_comment_liq,
  [28474] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1913), 1,
      anon_sym_endif,
  [28484] = 2,
    ACTIONS(1709), 1,
      anon_sym_COMMA,
    ACTIONS(699), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28492] = 3,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    STATE(717), 1,
      sym_string,
  [28502] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1915), 1,
      anon_sym_endunless,
  [28512] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1917), 1,
      anon_sym_endunless,
  [28522] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(760), 1,
      sym_string,
  [28532] = 3,
    ACTIONS(1919), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1921), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(864), 1,
      sym_raw_statement,
  [28542] = 3,
    ACTIONS(1923), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1925), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(863), 1,
      sym__paired_comment,
  [28552] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1927), 1,
      anon_sym_RPAREN,
  [28562] = 3,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    STATE(946), 1,
      sym_string,
  [28572] = 3,
    ACTIONS(1834), 1,
      anon_sym_elsif,
    ACTIONS(1836), 1,
      anon_sym_else,
    ACTIONS(1929), 1,
      anon_sym_endunless,
  [28582] = 2,
    ACTIONS(1744), 1,
      anon_sym_COMMA,
    ACTIONS(1742), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28590] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(1218), 1,
      sym_string,
  [28600] = 3,
    ACTIONS(1121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    STATE(945), 1,
      sym_string,
  [28610] = 3,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    ACTIONS(1807), 1,
      aux_sym__liquid_node_token1,
    STATE(790), 1,
      aux_sym_cycle_statement_repeat1,
  [28620] = 3,
    ACTIONS(1647), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    STATE(812), 1,
      aux_sym_cycle_statement_repeat1,
  [28630] = 3,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(1211), 1,
      sym_string,
  [28640] = 1,
    ACTIONS(1931), 3,
      anon_sym_else,
      anon_sym_endcase,
      anon_sym_when,
  [28646] = 3,
    ACTIONS(958), 1,
      anon_sym_DOT,
    ACTIONS(960), 1,
      anon_sym_LBRACK,
    ACTIONS(1933), 1,
      anon_sym_by,
  [28656] = 2,
    ACTIONS(1935), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1937), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28663] = 2,
    ACTIONS(1939), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1941), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28670] = 2,
    ACTIONS(1943), 1,
      sym_identifier,
    STATE(816), 1,
      sym_access,
  [28677] = 1,
    ACTIONS(1945), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28682] = 1,
    ACTIONS(1947), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28687] = 1,
    ACTIONS(1949), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28692] = 1,
    ACTIONS(1951), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28697] = 1,
    ACTIONS(1953), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28702] = 1,
    ACTIONS(1955), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28707] = 1,
    ACTIONS(1957), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28712] = 2,
    ACTIONS(1959), 1,
      sym_identifier,
    STATE(740), 1,
      sym_access,
  [28719] = 2,
    ACTIONS(1961), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1963), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28726] = 2,
    ACTIONS(1965), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1967), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28733] = 1,
    ACTIONS(1969), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28738] = 1,
    ACTIONS(1971), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28743] = 2,
    ACTIONS(1973), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1975), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28750] = 1,
    ACTIONS(1977), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28755] = 2,
    ACTIONS(1979), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1981), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28762] = 2,
    ACTIONS(1983), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1985), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28769] = 2,
    ACTIONS(1987), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(1989), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28776] = 2,
    ACTIONS(1862), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1991), 1,
      anon_sym_as,
  [28783] = 2,
    ACTIONS(1993), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1995), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28790] = 2,
    ACTIONS(1997), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1999), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28797] = 1,
    ACTIONS(2001), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28802] = 2,
    ACTIONS(2003), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2005), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28809] = 2,
    ACTIONS(1746), 1,
      aux_sym__liquid_node_token1,
    ACTIONS(1796), 1,
      anon_sym_COMMA,
  [28816] = 1,
    ACTIONS(2007), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28821] = 2,
    ACTIONS(2009), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2011), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28828] = 1,
    ACTIONS(2013), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28833] = 2,
    ACTIONS(2015), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2017), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28840] = 2,
    ACTIONS(2019), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2021), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28847] = 2,
    ACTIONS(2023), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2025), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28854] = 1,
    ACTIONS(2027), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28859] = 1,
    ACTIONS(2029), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28864] = 1,
    ACTIONS(2031), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28869] = 1,
    ACTIONS(2033), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28874] = 1,
    ACTIONS(2035), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28879] = 1,
    ACTIONS(2037), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28884] = 1,
    ACTIONS(2039), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28889] = 2,
    ACTIONS(2041), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2043), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28896] = 1,
    ACTIONS(2045), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28901] = 1,
    ACTIONS(2047), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28906] = 1,
    ACTIONS(2049), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28911] = 1,
    ACTIONS(2051), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28916] = 1,
    ACTIONS(2053), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28921] = 1,
    ACTIONS(2055), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [28926] = 2,
    ACTIONS(2057), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2059), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28933] = 2,
    ACTIONS(2061), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2063), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28940] = 2,
    ACTIONS(2065), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2067), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28947] = 2,
    ACTIONS(2069), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2071), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28954] = 2,
    ACTIONS(2073), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2075), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28961] = 2,
    ACTIONS(2077), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2079), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28968] = 2,
    ACTIONS(2081), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2083), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [28975] = 2,
    ACTIONS(2085), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2087), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28982] = 2,
    ACTIONS(2089), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2091), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28989] = 2,
    ACTIONS(2093), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2095), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [28996] = 2,
    ACTIONS(2097), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2099), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29003] = 2,
    ACTIONS(2101), 1,
      sym_identifier,
    STATE(730), 1,
      sym_access,
  [29010] = 2,
    ACTIONS(2103), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2105), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29017] = 2,
    ACTIONS(2107), 1,
      anon_sym_comment,
    ACTIONS(2109), 1,
      anon_sym_endcomment,
  [29024] = 2,
    ACTIONS(2111), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2113), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29031] = 2,
    ACTIONS(2115), 1,
      anon_sym_raw,
    ACTIONS(2117), 1,
      anon_sym_endraw,
  [29038] = 1,
    ACTIONS(2119), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29043] = 1,
    ACTIONS(2121), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29048] = 1,
    ACTIONS(2123), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29053] = 2,
    ACTIONS(2125), 1,
      sym_identifier,
    STATE(764), 1,
      sym_access,
  [29060] = 2,
    ACTIONS(2127), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2129), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29067] = 2,
    ACTIONS(2131), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2133), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29074] = 2,
    ACTIONS(2135), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2137), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29081] = 2,
    ACTIONS(2139), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2141), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29088] = 1,
    ACTIONS(2143), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29093] = 2,
    ACTIONS(2145), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2147), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29100] = 2,
    ACTIONS(2149), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2151), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29107] = 2,
    ACTIONS(2153), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2155), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29114] = 2,
    ACTIONS(2157), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2159), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29121] = 2,
    ACTIONS(2161), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2163), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29128] = 2,
    ACTIONS(2165), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2167), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29135] = 2,
    ACTIONS(2169), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2171), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29142] = 2,
    ACTIONS(2173), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2175), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29149] = 2,
    ACTIONS(1453), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1455), 1,
      anon_sym_LBRACE_PERCENT,
  [29156] = 2,
    ACTIONS(1457), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1459), 1,
      anon_sym_LBRACE_PERCENT,
  [29163] = 2,
    ACTIONS(1549), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1551), 1,
      anon_sym_LBRACE_PERCENT,
  [29170] = 2,
    ACTIONS(1553), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(1555), 1,
      anon_sym_LBRACE_PERCENT,
  [29177] = 2,
    ACTIONS(2177), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2179), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29184] = 2,
    ACTIONS(2181), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2183), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29191] = 2,
    ACTIONS(2185), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2187), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29198] = 1,
    ACTIONS(2189), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29203] = 1,
    ACTIONS(2191), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29208] = 2,
    ACTIONS(2193), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2195), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29215] = 1,
    ACTIONS(2197), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29220] = 2,
    ACTIONS(2199), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2201), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29227] = 2,
    ACTIONS(2203), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2205), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29234] = 1,
    ACTIONS(2207), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29239] = 1,
    ACTIONS(2209), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29244] = 1,
    ACTIONS(2211), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29249] = 1,
    ACTIONS(1058), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29254] = 1,
    ACTIONS(2213), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29259] = 1,
    ACTIONS(2215), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29264] = 1,
    ACTIONS(2217), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29269] = 1,
    ACTIONS(2219), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29274] = 2,
    ACTIONS(2221), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2223), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29281] = 2,
    ACTIONS(2225), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2227), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29288] = 1,
    ACTIONS(2229), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29293] = 1,
    ACTIONS(2231), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29298] = 2,
    ACTIONS(2233), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2235), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29305] = 2,
    ACTIONS(2237), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2239), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29312] = 1,
    ACTIONS(2241), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29317] = 2,
    ACTIONS(2243), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2245), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29324] = 2,
    ACTIONS(2247), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2249), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29331] = 2,
    ACTIONS(2251), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2253), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29338] = 2,
    ACTIONS(2255), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2257), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29345] = 2,
    ACTIONS(2259), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2261), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29352] = 1,
    ACTIONS(2263), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29357] = 2,
    ACTIONS(2265), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2267), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29364] = 2,
    ACTIONS(2269), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2271), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29371] = 1,
    ACTIONS(2273), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29376] = 2,
    ACTIONS(2275), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2277), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29383] = 2,
    ACTIONS(2279), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2281), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29390] = 2,
    ACTIONS(2283), 1,
      sym_identifier,
    STATE(400), 1,
      sym_access,
  [29397] = 2,
    ACTIONS(2285), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2287), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29404] = 2,
    ACTIONS(2289), 1,
      sym_identifier,
    STATE(782), 1,
      sym_access,
  [29411] = 1,
    ACTIONS(2291), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29416] = 2,
    ACTIONS(2107), 1,
      anon_sym_comment,
    ACTIONS(2293), 1,
      anon_sym_endcomment,
  [29423] = 2,
    ACTIONS(2295), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2297), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29430] = 2,
    ACTIONS(2299), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2301), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29437] = 1,
    ACTIONS(2303), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29442] = 2,
    ACTIONS(2115), 1,
      anon_sym_raw,
    ACTIONS(2305), 1,
      anon_sym_endraw,
  [29449] = 2,
    ACTIONS(2307), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2309), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29456] = 1,
    ACTIONS(2311), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29461] = 1,
    ACTIONS(2313), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29466] = 1,
    ACTIONS(2315), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29471] = 1,
    ACTIONS(2317), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29476] = 1,
    ACTIONS(2319), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29481] = 2,
    ACTIONS(2321), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2323), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29488] = 2,
    ACTIONS(2325), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2327), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29495] = 2,
    ACTIONS(2329), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2331), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29502] = 2,
    ACTIONS(2333), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2335), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29509] = 2,
    ACTIONS(2337), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2339), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29516] = 2,
    ACTIONS(2341), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2343), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29523] = 2,
    ACTIONS(2345), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2347), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29530] = 2,
    ACTIONS(2349), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2351), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29537] = 2,
    ACTIONS(2353), 1,
      sym_identifier,
    STATE(1235), 1,
      sym__render_param,
  [29544] = 2,
    ACTIONS(2353), 1,
      sym_identifier,
    STATE(1236), 1,
      sym__render_param,
  [29551] = 2,
    ACTIONS(2355), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2357), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29558] = 1,
    ACTIONS(2359), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29563] = 2,
    ACTIONS(2361), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2363), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29570] = 2,
    ACTIONS(2365), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2367), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29577] = 2,
    ACTIONS(2369), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2371), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29584] = 2,
    ACTIONS(2373), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2375), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29591] = 2,
    ACTIONS(2377), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2379), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29598] = 1,
    ACTIONS(2381), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29603] = 1,
    ACTIONS(2383), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29608] = 1,
    ACTIONS(2385), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29613] = 2,
    ACTIONS(2387), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2389), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29620] = 2,
    ACTIONS(2391), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(2393), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [29627] = 1,
    ACTIONS(2395), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29632] = 1,
    ACTIONS(2397), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29637] = 1,
    ACTIONS(2399), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29642] = 1,
    ACTIONS(2401), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29647] = 1,
    ACTIONS(2403), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29652] = 1,
    ACTIONS(2405), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29657] = 1,
    ACTIONS(2407), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29662] = 1,
    ACTIONS(2409), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29667] = 1,
    ACTIONS(2411), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29672] = 1,
    ACTIONS(2413), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29677] = 1,
    ACTIONS(2415), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29682] = 1,
    ACTIONS(2417), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29687] = 1,
    ACTIONS(2419), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29692] = 1,
    ACTIONS(2421), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29697] = 2,
    ACTIONS(2423), 1,
      sym_identifier,
    STATE(903), 1,
      sym__render_param,
  [29704] = 2,
    ACTIONS(2423), 1,
      sym_identifier,
    STATE(904), 1,
      sym__render_param,
  [29711] = 2,
    ACTIONS(2425), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2427), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29718] = 1,
    ACTIONS(2429), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29723] = 1,
    ACTIONS(2431), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29728] = 2,
    ACTIONS(2433), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2435), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29735] = 2,
    ACTIONS(2437), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2439), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29742] = 1,
    ACTIONS(2441), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29747] = 1,
    ACTIONS(2443), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29752] = 1,
    ACTIONS(2445), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29757] = 1,
    ACTIONS(2447), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29762] = 2,
    ACTIONS(2449), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2451), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29769] = 2,
    ACTIONS(2453), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2455), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29776] = 1,
    ACTIONS(2457), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29781] = 1,
    ACTIONS(2459), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29786] = 1,
    ACTIONS(2461), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29791] = 1,
    ACTIONS(2463), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29796] = 2,
    ACTIONS(2465), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2467), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29803] = 2,
    ACTIONS(2469), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2471), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29810] = 2,
    ACTIONS(2473), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2475), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29817] = 2,
    ACTIONS(2477), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2479), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29824] = 1,
    ACTIONS(2481), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29829] = 2,
    ACTIONS(2483), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2485), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29836] = 2,
    ACTIONS(2487), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2489), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29843] = 2,
    ACTIONS(2491), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2493), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29850] = 2,
    ACTIONS(2495), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2497), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29857] = 1,
    ACTIONS(2499), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29862] = 1,
    ACTIONS(2501), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29867] = 2,
    ACTIONS(2503), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2505), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29874] = 2,
    ACTIONS(2507), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2509), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29881] = 2,
    ACTIONS(2511), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2513), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29888] = 2,
    ACTIONS(2515), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2517), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29895] = 1,
    ACTIONS(2519), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [29900] = 2,
    ACTIONS(2521), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2523), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29907] = 2,
    ACTIONS(2525), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2527), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29914] = 2,
    ACTIONS(2529), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2531), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29921] = 2,
    ACTIONS(2533), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2535), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29928] = 2,
    ACTIONS(2537), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2539), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29935] = 2,
    ACTIONS(2541), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2543), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29942] = 2,
    ACTIONS(2545), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2547), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29949] = 2,
    ACTIONS(2549), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2551), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29956] = 2,
    ACTIONS(2553), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2555), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29963] = 2,
    ACTIONS(2557), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2559), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29970] = 2,
    ACTIONS(2561), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2563), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29977] = 2,
    ACTIONS(2565), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2567), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29984] = 2,
    ACTIONS(2569), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2571), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29991] = 2,
    ACTIONS(2573), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2575), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [29998] = 2,
    ACTIONS(2577), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2579), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30005] = 2,
    ACTIONS(2581), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2583), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30012] = 2,
    ACTIONS(2585), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2587), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30019] = 2,
    ACTIONS(2589), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2591), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30026] = 2,
    ACTIONS(2593), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2595), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30033] = 2,
    ACTIONS(2597), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2599), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30040] = 1,
    ACTIONS(2601), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30045] = 2,
    ACTIONS(2603), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2605), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30052] = 2,
    ACTIONS(2607), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2609), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30059] = 2,
    ACTIONS(2611), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2613), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30066] = 2,
    ACTIONS(2615), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2617), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30073] = 2,
    ACTIONS(2619), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2621), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30080] = 2,
    ACTIONS(2623), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2625), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30087] = 2,
    ACTIONS(2627), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2629), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30094] = 2,
    ACTIONS(2631), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2633), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30101] = 2,
    ACTIONS(2635), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2637), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30108] = 2,
    ACTIONS(2639), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2641), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30115] = 2,
    ACTIONS(2643), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2645), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30122] = 2,
    ACTIONS(2647), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2649), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30129] = 2,
    ACTIONS(2651), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2653), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30136] = 2,
    ACTIONS(2655), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2657), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30143] = 2,
    ACTIONS(2659), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2661), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30150] = 2,
    ACTIONS(2663), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2665), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30157] = 2,
    ACTIONS(2667), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2669), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30164] = 2,
    ACTIONS(2671), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2673), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30171] = 1,
    ACTIONS(2675), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30176] = 1,
    ACTIONS(2677), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30181] = 1,
    ACTIONS(2679), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30186] = 1,
    ACTIONS(2681), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30191] = 2,
    ACTIONS(2683), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2685), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30198] = 1,
    ACTIONS(2687), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30203] = 2,
    ACTIONS(2107), 1,
      anon_sym_comment,
    ACTIONS(2689), 1,
      anon_sym_endcomment,
  [30210] = 2,
    ACTIONS(2115), 1,
      anon_sym_raw,
    ACTIONS(2691), 1,
      anon_sym_endraw,
  [30217] = 2,
    ACTIONS(2693), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2695), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30224] = 2,
    ACTIONS(2697), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2699), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30231] = 2,
    ACTIONS(2701), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2703), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30238] = 1,
    ACTIONS(2705), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30243] = 1,
    ACTIONS(2707), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [30248] = 2,
    ACTIONS(2709), 1,
      anon_sym_PERCENT_RBRACE,
    ACTIONS(2711), 1,
      anon_sym_DASH_PERCENT_RBRACE,
  [30255] = 1,
    ACTIONS(2713), 1,
      aux_sym__liquid_node_token1,
  [30259] = 1,
    ACTIONS(2715), 1,
      aux_sym_string_token2,
  [30263] = 1,
    ACTIONS(2717), 1,
      sym__paired_comment_content_liq,
  [30267] = 1,
    ACTIONS(2719), 1,
      anon_sym_RBRACK,
  [30271] = 1,
    ACTIONS(2721), 1,
      aux_sym_string_token1,
  [30275] = 1,
    ACTIONS(2723), 1,
      anon_sym_in,
  [30279] = 1,
    ACTIONS(2725), 1,
      anon_sym_in,
  [30283] = 1,
    ACTIONS(2727), 1,
      sym_identifier,
  [30287] = 1,
    ACTIONS(2729), 1,
      anon_sym_endif,
  [30291] = 1,
    ACTIONS(2731), 1,
      anon_sym_endif,
  [30295] = 1,
    ACTIONS(2733), 1,
      anon_sym_DQUOTE,
  [30299] = 1,
    ACTIONS(2733), 1,
      anon_sym_SQUOTE,
  [30303] = 1,
    ACTIONS(2735), 1,
      sym_identifier,
  [30307] = 1,
    ACTIONS(2737), 1,
      anon_sym_endschema,
  [30311] = 1,
    ACTIONS(2739), 1,
      sym_identifier,
  [30315] = 1,
    ACTIONS(2741), 1,
      anon_sym_endif,
  [30319] = 1,
    ACTIONS(2743), 1,
      anon_sym_RBRACK,
  [30323] = 1,
    ACTIONS(2745), 1,
      sym_identifier,
  [30327] = 1,
    ACTIONS(2747), 1,
      anon_sym_DQUOTE,
  [30331] = 1,
    ACTIONS(2749), 1,
      anon_sym_endif,
  [30335] = 1,
    ACTIONS(2751), 1,
      anon_sym_endunless,
  [30339] = 1,
    ACTIONS(2747), 1,
      anon_sym_SQUOTE,
  [30343] = 1,
    ACTIONS(2753), 1,
      sym_identifier,
  [30347] = 1,
    ACTIONS(2755), 1,
      anon_sym_endcase,
  [30351] = 1,
    ACTIONS(2757), 1,
      anon_sym_RBRACK,
  [30355] = 1,
    ACTIONS(2759), 1,
      anon_sym_endunless,
  [30359] = 1,
    ACTIONS(2761), 1,
      sym__paired_comment_content,
  [30363] = 1,
    ACTIONS(2763), 1,
      anon_sym_endunless,
  [30367] = 1,
    ACTIONS(2765), 1,
      sym_identifier,
  [30371] = 1,
    ACTIONS(2767), 1,
      sym_raw_content,
  [30375] = 1,
    ACTIONS(2769), 1,
      anon_sym_DQUOTE,
  [30379] = 1,
    ACTIONS(2771), 1,
      anon_sym_endraw,
  [30383] = 1,
    ACTIONS(2773), 1,
      anon_sym_endcomment,
  [30387] = 1,
    ACTIONS(2775), 1,
      anon_sym_endunless,
  [30391] = 1,
    ACTIONS(2777), 1,
      anon_sym_in,
  [30395] = 1,
    ACTIONS(2769), 1,
      anon_sym_SQUOTE,
  [30399] = 1,
    ACTIONS(2779), 1,
      sym_identifier,
  [30403] = 1,
    ACTIONS(2781), 1,
      anon_sym_endif,
  [30407] = 1,
    ACTIONS(2783), 1,
      aux_sym__liquid_node_token1,
  [30411] = 1,
    ACTIONS(2785), 1,
      sym_identifier,
  [30415] = 1,
    ACTIONS(2787), 1,
      anon_sym_endif,
  [30419] = 1,
    ACTIONS(2789), 1,
      anon_sym_endif,
  [30423] = 1,
    ACTIONS(2791), 1,
      anon_sym_endcase,
  [30427] = 1,
    ACTIONS(2793), 1,
      anon_sym_endunless,
  [30431] = 1,
    ACTIONS(2795), 1,
      anon_sym_endunless,
  [30435] = 1,
    ACTIONS(2797), 1,
      anon_sym_endfor,
  [30439] = 1,
    ACTIONS(2799), 1,
      anon_sym_endunless,
  [30443] = 1,
    ACTIONS(2801), 1,
      anon_sym_endunless,
  [30447] = 1,
    ACTIONS(2803), 1,
      anon_sym_endfor,
  [30451] = 1,
    ACTIONS(2805), 1,
      anon_sym_endcomment,
  [30455] = 1,
    ACTIONS(2807), 1,
      anon_sym_in,
  [30459] = 1,
    ACTIONS(2809), 1,
      ts_builtin_sym_end,
  [30463] = 1,
    ACTIONS(2811), 1,
      anon_sym_RBRACK,
  [30467] = 1,
    ACTIONS(2813), 1,
      anon_sym_EQ2,
  [30471] = 1,
    ACTIONS(2815), 1,
      sym_identifier,
  [30475] = 1,
    ACTIONS(2817), 1,
      anon_sym_DQUOTE,
  [30479] = 1,
    ACTIONS(2819), 1,
      anon_sym_EQ,
  [30483] = 1,
    ACTIONS(2821), 1,
      anon_sym_endfor,
  [30487] = 1,
    ACTIONS(2823), 1,
      anon_sym_endfor,
  [30491] = 1,
    ACTIONS(2817), 1,
      anon_sym_SQUOTE,
  [30495] = 1,
    ACTIONS(2825), 1,
      sym_identifier,
  [30499] = 1,
    ACTIONS(2827), 1,
      anon_sym_endfor,
  [30503] = 1,
    ACTIONS(2829), 1,
      anon_sym_endfor,
  [30507] = 1,
    ACTIONS(2831), 1,
      anon_sym_EQ,
  [30511] = 1,
    ACTIONS(2833), 1,
      aux_sym__liquid_node_token1,
  [30515] = 1,
    ACTIONS(2835), 1,
      anon_sym_endif,
  [30519] = 1,
    ACTIONS(2837), 1,
      anon_sym_endif,
  [30523] = 1,
    ACTIONS(2839), 1,
      anon_sym_endunless,
  [30527] = 1,
    ACTIONS(2841), 1,
      anon_sym_endunless,
  [30531] = 1,
    ACTIONS(2843), 1,
      anon_sym_endfor,
  [30535] = 1,
    ACTIONS(2845), 1,
      aux_sym__liquid_node_token1,
  [30539] = 1,
    ACTIONS(2845), 1,
      aux_sym__liquid_node_token1,
  [30543] = 1,
    ACTIONS(2847), 1,
      aux_sym__liquid_node_token1,
  [30547] = 1,
    ACTIONS(2849), 1,
      aux_sym__liquid_node_token1,
  [30551] = 1,
    ACTIONS(2851), 1,
      aux_sym__liquid_node_token1,
  [30555] = 1,
    ACTIONS(2853), 1,
      aux_sym__liquid_node_token1,
  [30559] = 1,
    ACTIONS(2855), 1,
      aux_sym__liquid_node_token1,
  [30563] = 1,
    ACTIONS(2851), 1,
      aux_sym__liquid_node_token1,
  [30567] = 1,
    ACTIONS(2857), 1,
      anon_sym_endfor,
  [30571] = 1,
    ACTIONS(2859), 1,
      anon_sym_endfor,
  [30575] = 1,
    ACTIONS(2861), 1,
      anon_sym_endfor,
  [30579] = 1,
    ACTIONS(2863), 1,
      anon_sym_endfor,
  [30583] = 1,
    ACTIONS(1135), 1,
      aux_sym__liquid_node_token1,
  [30587] = 1,
    ACTIONS(2865), 1,
      aux_sym_string_token1,
  [30591] = 1,
    ACTIONS(2867), 1,
      aux_sym_string_token2,
  [30595] = 1,
    ACTIONS(1129), 1,
      aux_sym__liquid_node_token1,
  [30599] = 1,
    ACTIONS(2869), 1,
      aux_sym__liquid_node_token1,
  [30603] = 1,
    ACTIONS(2871), 1,
      anon_sym_endfor,
  [30607] = 1,
    ACTIONS(2873), 1,
      anon_sym_endraw,
  [30611] = 1,
    ACTIONS(2875), 1,
      anon_sym_endcomment,
  [30615] = 1,
    ACTIONS(2877), 1,
      sym__paired_comment_content_liq,
  [30619] = 1,
    ACTIONS(2879), 1,
      aux_sym_string_token1,
  [30623] = 1,
    ACTIONS(2881), 1,
      aux_sym_string_token2,
  [30627] = 1,
    ACTIONS(1927), 1,
      anon_sym_RPAREN,
  [30631] = 1,
    ACTIONS(2883), 1,
      aux_sym__liquid_node_token1,
  [30635] = 1,
    ACTIONS(2885), 1,
      sym_identifier,
  [30639] = 1,
    ACTIONS(2887), 1,
      aux_sym__liquid_node_token1,
  [30643] = 1,
    ACTIONS(2889), 1,
      sym_identifier,
  [30647] = 1,
    ACTIONS(2891), 1,
      sym_identifier,
  [30651] = 1,
    ACTIONS(2893), 1,
      sym_identifier,
  [30655] = 1,
    ACTIONS(2895), 1,
      sym_identifier,
  [30659] = 1,
    ACTIONS(2897), 1,
      aux_sym_string_token2,
  [30663] = 1,
    ACTIONS(2899), 1,
      aux_sym__liquid_node_token1,
  [30667] = 1,
    ACTIONS(2901), 1,
      aux_sym_string_token1,
  [30671] = 1,
    ACTIONS(2903), 1,
      aux_sym__liquid_node_token1,
  [30675] = 1,
    ACTIONS(2905), 1,
      aux_sym__liquid_node_token1,
  [30679] = 1,
    ACTIONS(2907), 1,
      aux_sym__liquid_node_token1,
  [30683] = 1,
    ACTIONS(2909), 1,
      aux_sym__liquid_node_token1,
  [30687] = 1,
    ACTIONS(2911), 1,
      anon_sym_endif,
  [30691] = 1,
    ACTIONS(2913), 1,
      aux_sym__liquid_node_token1,
  [30695] = 1,
    ACTIONS(2915), 1,
      aux_sym__liquid_node_token1,
  [30699] = 1,
    ACTIONS(2917), 1,
      anon_sym_endraw,
  [30703] = 1,
    ACTIONS(2919), 1,
      anon_sym_endcase,
  [30707] = 1,
    ACTIONS(2921), 1,
      anon_sym_endfor,
  [30711] = 1,
    ACTIONS(2923), 1,
      aux_sym__liquid_node_token1,
  [30715] = 1,
    ACTIONS(2925), 1,
      anon_sym_endunless,
  [30719] = 1,
    ACTIONS(2927), 1,
      aux_sym__liquid_node_token1,
  [30723] = 1,
    ACTIONS(2929), 1,
      aux_sym__liquid_node_token1,
  [30727] = 1,
    ACTIONS(2931), 1,
      aux_sym__liquid_node_token1,
  [30731] = 1,
    ACTIONS(2933), 1,
      aux_sym__liquid_node_token1,
  [30735] = 1,
    ACTIONS(2935), 1,
      anon_sym_endcomment,
  [30739] = 1,
    ACTIONS(1834), 1,
      anon_sym_elsif,
  [30743] = 1,
    ACTIONS(2937), 1,
      anon_sym_endif,
  [30747] = 1,
    ACTIONS(2939), 1,
      anon_sym_endif,
  [30751] = 1,
    ACTIONS(2941), 1,
      aux_sym__liquid_node_token1,
  [30755] = 1,
    ACTIONS(2943), 1,
      aux_sym__liquid_node_token1,
  [30759] = 1,
    ACTIONS(2945), 1,
      anon_sym_endfor,
  [30763] = 1,
    ACTIONS(2947), 1,
      anon_sym_endunless,
  [30767] = 1,
    ACTIONS(2949), 1,
      aux_sym__liquid_node_token1,
  [30771] = 1,
    ACTIONS(2951), 1,
      anon_sym_endcomment,
  [30775] = 1,
    ACTIONS(2953), 1,
      sym_identifier,
  [30779] = 1,
    ACTIONS(2955), 1,
      aux_sym__liquid_node_token1,
  [30783] = 1,
    ACTIONS(2957), 1,
      sym_identifier,
  [30787] = 1,
    ACTIONS(2959), 1,
      anon_sym_endschema,
  [30791] = 1,
    ACTIONS(2961), 1,
      aux_sym__liquid_node_token1,
  [30795] = 1,
    ACTIONS(2963), 1,
      sym_identifier,
  [30799] = 1,
    ACTIONS(2965), 1,
      anon_sym_EQ2,
  [30803] = 1,
    ACTIONS(2967), 1,
      aux_sym__liquid_node_token1,
  [30807] = 1,
    ACTIONS(2969), 1,
      anon_sym_endif,
  [30811] = 1,
    ACTIONS(2311), 1,
      aux_sym__liquid_node_token1,
  [30815] = 1,
    ACTIONS(2971), 1,
      aux_sym__liquid_node_token1,
  [30819] = 1,
    ACTIONS(2973), 1,
      aux_sym__liquid_node_token1,
  [30823] = 1,
    ACTIONS(2975), 1,
      sym_identifier,
  [30827] = 1,
    ACTIONS(2977), 1,
      aux_sym__liquid_node_token1,
  [30831] = 1,
    ACTIONS(2979), 1,
      sym_identifier,
  [30835] = 1,
    ACTIONS(2981), 1,
      anon_sym_endif,
  [30839] = 1,
    ACTIONS(2313), 1,
      aux_sym__liquid_node_token1,
  [30843] = 1,
    ACTIONS(2983), 1,
      aux_sym__liquid_node_token1,
  [30847] = 1,
    ACTIONS(2985), 1,
      aux_sym__liquid_node_token1,
  [30851] = 1,
    ACTIONS(2987), 1,
      anon_sym_endcase,
  [30855] = 1,
    ACTIONS(2315), 1,
      aux_sym__liquid_node_token1,
  [30859] = 1,
    ACTIONS(2989), 1,
      aux_sym__liquid_node_token1,
  [30863] = 1,
    ACTIONS(2991), 1,
      anon_sym_endunless,
  [30867] = 1,
    ACTIONS(2317), 1,
      aux_sym__liquid_node_token1,
  [30871] = 1,
    ACTIONS(2993), 1,
      sym_identifier,
  [30875] = 1,
    ACTIONS(2319), 1,
      aux_sym__liquid_node_token1,
  [30879] = 1,
    ACTIONS(2995), 1,
      anon_sym_endif,
  [30883] = 1,
    ACTIONS(2997), 1,
      anon_sym_endunless,
  [30887] = 1,
    ACTIONS(713), 1,
      anon_sym_endcomment,
  [30891] = 1,
    ACTIONS(2999), 1,
      anon_sym_endcase,
  [30895] = 1,
    ACTIONS(2197), 1,
      aux_sym__liquid_node_token1,
  [30899] = 1,
    ACTIONS(3001), 1,
      sym_raw_content,
  [30903] = 1,
    ACTIONS(3003), 1,
      sym__paired_comment_content,
  [30907] = 1,
    ACTIONS(2191), 1,
      aux_sym__liquid_node_token1,
  [30911] = 1,
    ACTIONS(2189), 1,
      aux_sym__liquid_node_token1,
  [30915] = 1,
    ACTIONS(3005), 1,
      anon_sym_endcase,
  [30919] = 1,
    ACTIONS(3007), 1,
      anon_sym_endif,
  [30923] = 1,
    ACTIONS(3009), 1,
      sym_raw_content,
  [30927] = 1,
    ACTIONS(3011), 1,
      sym__paired_comment_content,
  [30931] = 1,
    ACTIONS(1856), 1,
      anon_sym_DOT_DOT,
  [30935] = 1,
    ACTIONS(705), 1,
      anon_sym_endcomment,
  [30939] = 1,
    ACTIONS(1846), 1,
      anon_sym_when,
  [30943] = 1,
    ACTIONS(3013), 1,
      sym_identifier,
  [30947] = 1,
    ACTIONS(3015), 1,
      anon_sym_endfor,
  [30951] = 1,
    ACTIONS(3017), 1,
      sym_identifier,
  [30955] = 1,
    ACTIONS(3019), 1,
      aux_sym__liquid_node_token1,
  [30959] = 1,
    ACTIONS(3021), 1,
      aux_sym__liquid_node_token1,
  [30963] = 1,
    ACTIONS(3023), 1,
      anon_sym_endfor,
  [30967] = 1,
    ACTIONS(3025), 1,
      anon_sym_endunless,
  [30971] = 1,
    ACTIONS(3027), 1,
      aux_sym__liquid_node_token1,
  [30975] = 1,
    ACTIONS(3029), 1,
      anon_sym_endfor,
  [30979] = 1,
    ACTIONS(3031), 1,
      aux_sym__liquid_node_token1,
  [30983] = 1,
    ACTIONS(3033), 1,
      anon_sym_endunless,
  [30987] = 1,
    ACTIONS(3035), 1,
      anon_sym_in,
  [30991] = 1,
    ACTIONS(3037), 1,
      anon_sym_in,
  [30995] = 1,
    ACTIONS(3039), 1,
      anon_sym_endfor,
  [30999] = 1,
    ACTIONS(3041), 1,
      sym_identifier,
  [31003] = 1,
    ACTIONS(3043), 1,
      sym_identifier,
  [31007] = 1,
    ACTIONS(2395), 1,
      aux_sym__liquid_node_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(12)] = 0,
  [SMALL_STATE(13)] = 148,
  [SMALL_STATE(14)] = 292,
  [SMALL_STATE(15)] = 442,
  [SMALL_STATE(16)] = 586,
  [SMALL_STATE(17)] = 734,
  [SMALL_STATE(18)] = 878,
  [SMALL_STATE(19)] = 1021,
  [SMALL_STATE(20)] = 1164,
  [SMALL_STATE(21)] = 1236,
  [SMALL_STATE(22)] = 1380,
  [SMALL_STATE(23)] = 1454,
  [SMALL_STATE(24)] = 1519,
  [SMALL_STATE(25)] = 1588,
  [SMALL_STATE(26)] = 1653,
  [SMALL_STATE(27)] = 1722,
  [SMALL_STATE(28)] = 1863,
  [SMALL_STATE(29)] = 2004,
  [SMALL_STATE(30)] = 2145,
  [SMALL_STATE(31)] = 2286,
  [SMALL_STATE(32)] = 2427,
  [SMALL_STATE(33)] = 2568,
  [SMALL_STATE(34)] = 2709,
  [SMALL_STATE(35)] = 2850,
  [SMALL_STATE(36)] = 2991,
  [SMALL_STATE(37)] = 3059,
  [SMALL_STATE(38)] = 3127,
  [SMALL_STATE(39)] = 3201,
  [SMALL_STATE(40)] = 3269,
  [SMALL_STATE(41)] = 3332,
  [SMALL_STATE(42)] = 3395,
  [SMALL_STATE(43)] = 3458,
  [SMALL_STATE(44)] = 3521,
  [SMALL_STATE(45)] = 3585,
  [SMALL_STATE(46)] = 3646,
  [SMALL_STATE(47)] = 3704,
  [SMALL_STATE(48)] = 3764,
  [SMALL_STATE(49)] = 3838,
  [SMALL_STATE(50)] = 3896,
  [SMALL_STATE(51)] = 3968,
  [SMALL_STATE(52)] = 4026,
  [SMALL_STATE(53)] = 4098,
  [SMALL_STATE(54)] = 4162,
  [SMALL_STATE(55)] = 4230,
  [SMALL_STATE(56)] = 4299,
  [SMALL_STATE(57)] = 4362,
  [SMALL_STATE(58)] = 4476,
  [SMALL_STATE(59)] = 4590,
  [SMALL_STATE(60)] = 4704,
  [SMALL_STATE(61)] = 4818,
  [SMALL_STATE(62)] = 4932,
  [SMALL_STATE(63)] = 5046,
  [SMALL_STATE(64)] = 5160,
  [SMALL_STATE(65)] = 5274,
  [SMALL_STATE(66)] = 5385,
  [SMALL_STATE(67)] = 5496,
  [SMALL_STATE(68)] = 5607,
  [SMALL_STATE(69)] = 5718,
  [SMALL_STATE(70)] = 5829,
  [SMALL_STATE(71)] = 5940,
  [SMALL_STATE(72)] = 6051,
  [SMALL_STATE(73)] = 6162,
  [SMALL_STATE(74)] = 6273,
  [SMALL_STATE(75)] = 6384,
  [SMALL_STATE(76)] = 6495,
  [SMALL_STATE(77)] = 6606,
  [SMALL_STATE(78)] = 6717,
  [SMALL_STATE(79)] = 6828,
  [SMALL_STATE(80)] = 6939,
  [SMALL_STATE(81)] = 7050,
  [SMALL_STATE(82)] = 7158,
  [SMALL_STATE(83)] = 7266,
  [SMALL_STATE(84)] = 7374,
  [SMALL_STATE(85)] = 7482,
  [SMALL_STATE(86)] = 7590,
  [SMALL_STATE(87)] = 7698,
  [SMALL_STATE(88)] = 7806,
  [SMALL_STATE(89)] = 7914,
  [SMALL_STATE(90)] = 8022,
  [SMALL_STATE(91)] = 8130,
  [SMALL_STATE(92)] = 8238,
  [SMALL_STATE(93)] = 8346,
  [SMALL_STATE(94)] = 8454,
  [SMALL_STATE(95)] = 8562,
  [SMALL_STATE(96)] = 8670,
  [SMALL_STATE(97)] = 8778,
  [SMALL_STATE(98)] = 8886,
  [SMALL_STATE(99)] = 8994,
  [SMALL_STATE(100)] = 9102,
  [SMALL_STATE(101)] = 9210,
  [SMALL_STATE(102)] = 9318,
  [SMALL_STATE(103)] = 9426,
  [SMALL_STATE(104)] = 9534,
  [SMALL_STATE(105)] = 9642,
  [SMALL_STATE(106)] = 9750,
  [SMALL_STATE(107)] = 9858,
  [SMALL_STATE(108)] = 9966,
  [SMALL_STATE(109)] = 10074,
  [SMALL_STATE(110)] = 10182,
  [SMALL_STATE(111)] = 10290,
  [SMALL_STATE(112)] = 10398,
  [SMALL_STATE(113)] = 10506,
  [SMALL_STATE(114)] = 10614,
  [SMALL_STATE(115)] = 10722,
  [SMALL_STATE(116)] = 10830,
  [SMALL_STATE(117)] = 10938,
  [SMALL_STATE(118)] = 11046,
  [SMALL_STATE(119)] = 11154,
  [SMALL_STATE(120)] = 11262,
  [SMALL_STATE(121)] = 11370,
  [SMALL_STATE(122)] = 11478,
  [SMALL_STATE(123)] = 11586,
  [SMALL_STATE(124)] = 11694,
  [SMALL_STATE(125)] = 11802,
  [SMALL_STATE(126)] = 11910,
  [SMALL_STATE(127)] = 12018,
  [SMALL_STATE(128)] = 12126,
  [SMALL_STATE(129)] = 12234,
  [SMALL_STATE(130)] = 12342,
  [SMALL_STATE(131)] = 12450,
  [SMALL_STATE(132)] = 12558,
  [SMALL_STATE(133)] = 12666,
  [SMALL_STATE(134)] = 12774,
  [SMALL_STATE(135)] = 12882,
  [SMALL_STATE(136)] = 12990,
  [SMALL_STATE(137)] = 13098,
  [SMALL_STATE(138)] = 13203,
  [SMALL_STATE(139)] = 13308,
  [SMALL_STATE(140)] = 13353,
  [SMALL_STATE(141)] = 13398,
  [SMALL_STATE(142)] = 13453,
  [SMALL_STATE(143)] = 13502,
  [SMALL_STATE(144)] = 13552,
  [SMALL_STATE(145)] = 13614,
  [SMALL_STATE(146)] = 13671,
  [SMALL_STATE(147)] = 13728,
  [SMALL_STATE(148)] = 13767,
  [SMALL_STATE(149)] = 13824,
  [SMALL_STATE(150)] = 13881,
  [SMALL_STATE(151)] = 13938,
  [SMALL_STATE(152)] = 13977,
  [SMALL_STATE(153)] = 14034,
  [SMALL_STATE(154)] = 14091,
  [SMALL_STATE(155)] = 14148,
  [SMALL_STATE(156)] = 14192,
  [SMALL_STATE(157)] = 14230,
  [SMALL_STATE(158)] = 14268,
  [SMALL_STATE(159)] = 14306,
  [SMALL_STATE(160)] = 14344,
  [SMALL_STATE(161)] = 14397,
  [SMALL_STATE(162)] = 14450,
  [SMALL_STATE(163)] = 14503,
  [SMALL_STATE(164)] = 14554,
  [SMALL_STATE(165)] = 14605,
  [SMALL_STATE(166)] = 14656,
  [SMALL_STATE(167)] = 14709,
  [SMALL_STATE(168)] = 14762,
  [SMALL_STATE(169)] = 14815,
  [SMALL_STATE(170)] = 14868,
  [SMALL_STATE(171)] = 14921,
  [SMALL_STATE(172)] = 14972,
  [SMALL_STATE(173)] = 15009,
  [SMALL_STATE(174)] = 15059,
  [SMALL_STATE(175)] = 15109,
  [SMALL_STATE(176)] = 15157,
  [SMALL_STATE(177)] = 15207,
  [SMALL_STATE(178)] = 15257,
  [SMALL_STATE(179)] = 15305,
  [SMALL_STATE(180)] = 15353,
  [SMALL_STATE(181)] = 15401,
  [SMALL_STATE(182)] = 15449,
  [SMALL_STATE(183)] = 15497,
  [SMALL_STATE(184)] = 15547,
  [SMALL_STATE(185)] = 15595,
  [SMALL_STATE(186)] = 15643,
  [SMALL_STATE(187)] = 15691,
  [SMALL_STATE(188)] = 15739,
  [SMALL_STATE(189)] = 15787,
  [SMALL_STATE(190)] = 15835,
  [SMALL_STATE(191)] = 15873,
  [SMALL_STATE(192)] = 15921,
  [SMALL_STATE(193)] = 15969,
  [SMALL_STATE(194)] = 16019,
  [SMALL_STATE(195)] = 16069,
  [SMALL_STATE(196)] = 16117,
  [SMALL_STATE(197)] = 16167,
  [SMALL_STATE(198)] = 16217,
  [SMALL_STATE(199)] = 16267,
  [SMALL_STATE(200)] = 16317,
  [SMALL_STATE(201)] = 16365,
  [SMALL_STATE(202)] = 16415,
  [SMALL_STATE(203)] = 16465,
  [SMALL_STATE(204)] = 16513,
  [SMALL_STATE(205)] = 16563,
  [SMALL_STATE(206)] = 16611,
  [SMALL_STATE(207)] = 16661,
  [SMALL_STATE(208)] = 16709,
  [SMALL_STATE(209)] = 16759,
  [SMALL_STATE(210)] = 16794,
  [SMALL_STATE(211)] = 16841,
  [SMALL_STATE(212)] = 16888,
  [SMALL_STATE(213)] = 16923,
  [SMALL_STATE(214)] = 16970,
  [SMALL_STATE(215)] = 17017,
  [SMALL_STATE(216)] = 17064,
  [SMALL_STATE(217)] = 17111,
  [SMALL_STATE(218)] = 17156,
  [SMALL_STATE(219)] = 17203,
  [SMALL_STATE(220)] = 17250,
  [SMALL_STATE(221)] = 17297,
  [SMALL_STATE(222)] = 17344,
  [SMALL_STATE(223)] = 17391,
  [SMALL_STATE(224)] = 17438,
  [SMALL_STATE(225)] = 17485,
  [SMALL_STATE(226)] = 17532,
  [SMALL_STATE(227)] = 17579,
  [SMALL_STATE(228)] = 17621,
  [SMALL_STATE(229)] = 17661,
  [SMALL_STATE(230)] = 17694,
  [SMALL_STATE(231)] = 17731,
  [SMALL_STATE(232)] = 17764,
  [SMALL_STATE(233)] = 17801,
  [SMALL_STATE(234)] = 17837,
  [SMALL_STATE(235)] = 17873,
  [SMALL_STATE(236)] = 17909,
  [SMALL_STATE(237)] = 17945,
  [SMALL_STATE(238)] = 17976,
  [SMALL_STATE(239)] = 18007,
  [SMALL_STATE(240)] = 18038,
  [SMALL_STATE(241)] = 18069,
  [SMALL_STATE(242)] = 18100,
  [SMALL_STATE(243)] = 18141,
  [SMALL_STATE(244)] = 18192,
  [SMALL_STATE(245)] = 18225,
  [SMALL_STATE(246)] = 18255,
  [SMALL_STATE(247)] = 18291,
  [SMALL_STATE(248)] = 18321,
  [SMALL_STATE(249)] = 18361,
  [SMALL_STATE(250)] = 18399,
  [SMALL_STATE(251)] = 18431,
  [SMALL_STATE(252)] = 18465,
  [SMALL_STATE(253)] = 18501,
  [SMALL_STATE(254)] = 18531,
  [SMALL_STATE(255)] = 18575,
  [SMALL_STATE(256)] = 18613,
  [SMALL_STATE(257)] = 18646,
  [SMALL_STATE(258)] = 18679,
  [SMALL_STATE(259)] = 18711,
  [SMALL_STATE(260)] = 18743,
  [SMALL_STATE(261)] = 18781,
  [SMALL_STATE(262)] = 18813,
  [SMALL_STATE(263)] = 18853,
  [SMALL_STATE(264)] = 18885,
  [SMALL_STATE(265)] = 18912,
  [SMALL_STATE(266)] = 18949,
  [SMALL_STATE(267)] = 18984,
  [SMALL_STATE(268)] = 19017,
  [SMALL_STATE(269)] = 19044,
  [SMALL_STATE(270)] = 19071,
  [SMALL_STATE(271)] = 19098,
  [SMALL_STATE(272)] = 19127,
  [SMALL_STATE(273)] = 19163,
  [SMALL_STATE(274)] = 19193,
  [SMALL_STATE(275)] = 19235,
  [SMALL_STATE(276)] = 19261,
  [SMALL_STATE(277)] = 19287,
  [SMALL_STATE(278)] = 19313,
  [SMALL_STATE(279)] = 19353,
  [SMALL_STATE(280)] = 19379,
  [SMALL_STATE(281)] = 19409,
  [SMALL_STATE(282)] = 19441,
  [SMALL_STATE(283)] = 19467,
  [SMALL_STATE(284)] = 19495,
  [SMALL_STATE(285)] = 19524,
  [SMALL_STATE(286)] = 19553,
  [SMALL_STATE(287)] = 19584,
  [SMALL_STATE(288)] = 19613,
  [SMALL_STATE(289)] = 19642,
  [SMALL_STATE(290)] = 19668,
  [SMALL_STATE(291)] = 19692,
  [SMALL_STATE(292)] = 19716,
  [SMALL_STATE(293)] = 19760,
  [SMALL_STATE(294)] = 19784,
  [SMALL_STATE(295)] = 19809,
  [SMALL_STATE(296)] = 19848,
  [SMALL_STATE(297)] = 19889,
  [SMALL_STATE(298)] = 19912,
  [SMALL_STATE(299)] = 19953,
  [SMALL_STATE(300)] = 19994,
  [SMALL_STATE(301)] = 20035,
  [SMALL_STATE(302)] = 20074,
  [SMALL_STATE(303)] = 20113,
  [SMALL_STATE(304)] = 20138,
  [SMALL_STATE(305)] = 20179,
  [SMALL_STATE(306)] = 20202,
  [SMALL_STATE(307)] = 20239,
  [SMALL_STATE(308)] = 20280,
  [SMALL_STATE(309)] = 20319,
  [SMALL_STATE(310)] = 20358,
  [SMALL_STATE(311)] = 20399,
  [SMALL_STATE(312)] = 20440,
  [SMALL_STATE(313)] = 20481,
  [SMALL_STATE(314)] = 20508,
  [SMALL_STATE(315)] = 20547,
  [SMALL_STATE(316)] = 20588,
  [SMALL_STATE(317)] = 20627,
  [SMALL_STATE(318)] = 20666,
  [SMALL_STATE(319)] = 20699,
  [SMALL_STATE(320)] = 20730,
  [SMALL_STATE(321)] = 20759,
  [SMALL_STATE(322)] = 20782,
  [SMALL_STATE(323)] = 20816,
  [SMALL_STATE(324)] = 20860,
  [SMALL_STATE(325)] = 20894,
  [SMALL_STATE(326)] = 20938,
  [SMALL_STATE(327)] = 20972,
  [SMALL_STATE(328)] = 21010,
  [SMALL_STATE(329)] = 21048,
  [SMALL_STATE(330)] = 21082,
  [SMALL_STATE(331)] = 21115,
  [SMALL_STATE(332)] = 21154,
  [SMALL_STATE(333)] = 21187,
  [SMALL_STATE(334)] = 21221,
  [SMALL_STATE(335)] = 21255,
  [SMALL_STATE(336)] = 21289,
  [SMALL_STATE(337)] = 21323,
  [SMALL_STATE(338)] = 21357,
  [SMALL_STATE(339)] = 21391,
  [SMALL_STATE(340)] = 21425,
  [SMALL_STATE(341)] = 21459,
  [SMALL_STATE(342)] = 21493,
  [SMALL_STATE(343)] = 21527,
  [SMALL_STATE(344)] = 21561,
  [SMALL_STATE(345)] = 21595,
  [SMALL_STATE(346)] = 21629,
  [SMALL_STATE(347)] = 21663,
  [SMALL_STATE(348)] = 21697,
  [SMALL_STATE(349)] = 21731,
  [SMALL_STATE(350)] = 21765,
  [SMALL_STATE(351)] = 21799,
  [SMALL_STATE(352)] = 21833,
  [SMALL_STATE(353)] = 21867,
  [SMALL_STATE(354)] = 21901,
  [SMALL_STATE(355)] = 21935,
  [SMALL_STATE(356)] = 21969,
  [SMALL_STATE(357)] = 22003,
  [SMALL_STATE(358)] = 22037,
  [SMALL_STATE(359)] = 22071,
  [SMALL_STATE(360)] = 22105,
  [SMALL_STATE(361)] = 22139,
  [SMALL_STATE(362)] = 22173,
  [SMALL_STATE(363)] = 22207,
  [SMALL_STATE(364)] = 22241,
  [SMALL_STATE(365)] = 22275,
  [SMALL_STATE(366)] = 22309,
  [SMALL_STATE(367)] = 22343,
  [SMALL_STATE(368)] = 22377,
  [SMALL_STATE(369)] = 22411,
  [SMALL_STATE(370)] = 22445,
  [SMALL_STATE(371)] = 22479,
  [SMALL_STATE(372)] = 22513,
  [SMALL_STATE(373)] = 22547,
  [SMALL_STATE(374)] = 22581,
  [SMALL_STATE(375)] = 22615,
  [SMALL_STATE(376)] = 22649,
  [SMALL_STATE(377)] = 22683,
  [SMALL_STATE(378)] = 22717,
  [SMALL_STATE(379)] = 22751,
  [SMALL_STATE(380)] = 22784,
  [SMALL_STATE(381)] = 22813,
  [SMALL_STATE(382)] = 22842,
  [SMALL_STATE(383)] = 22871,
  [SMALL_STATE(384)] = 22900,
  [SMALL_STATE(385)] = 22929,
  [SMALL_STATE(386)] = 22958,
  [SMALL_STATE(387)] = 22987,
  [SMALL_STATE(388)] = 23016,
  [SMALL_STATE(389)] = 23045,
  [SMALL_STATE(390)] = 23074,
  [SMALL_STATE(391)] = 23103,
  [SMALL_STATE(392)] = 23129,
  [SMALL_STATE(393)] = 23155,
  [SMALL_STATE(394)] = 23181,
  [SMALL_STATE(395)] = 23207,
  [SMALL_STATE(396)] = 23233,
  [SMALL_STATE(397)] = 23258,
  [SMALL_STATE(398)] = 23283,
  [SMALL_STATE(399)] = 23308,
  [SMALL_STATE(400)] = 23333,
  [SMALL_STATE(401)] = 23362,
  [SMALL_STATE(402)] = 23387,
  [SMALL_STATE(403)] = 23407,
  [SMALL_STATE(404)] = 23427,
  [SMALL_STATE(405)] = 23440,
  [SMALL_STATE(406)] = 23453,
  [SMALL_STATE(407)] = 23466,
  [SMALL_STATE(408)] = 23479,
  [SMALL_STATE(409)] = 23492,
  [SMALL_STATE(410)] = 23505,
  [SMALL_STATE(411)] = 23518,
  [SMALL_STATE(412)] = 23531,
  [SMALL_STATE(413)] = 23554,
  [SMALL_STATE(414)] = 23577,
  [SMALL_STATE(415)] = 23600,
  [SMALL_STATE(416)] = 23623,
  [SMALL_STATE(417)] = 23640,
  [SMALL_STATE(418)] = 23663,
  [SMALL_STATE(419)] = 23676,
  [SMALL_STATE(420)] = 23689,
  [SMALL_STATE(421)] = 23702,
  [SMALL_STATE(422)] = 23715,
  [SMALL_STATE(423)] = 23728,
  [SMALL_STATE(424)] = 23745,
  [SMALL_STATE(425)] = 23758,
  [SMALL_STATE(426)] = 23771,
  [SMALL_STATE(427)] = 23784,
  [SMALL_STATE(428)] = 23797,
  [SMALL_STATE(429)] = 23810,
  [SMALL_STATE(430)] = 23823,
  [SMALL_STATE(431)] = 23836,
  [SMALL_STATE(432)] = 23849,
  [SMALL_STATE(433)] = 23862,
  [SMALL_STATE(434)] = 23875,
  [SMALL_STATE(435)] = 23888,
  [SMALL_STATE(436)] = 23901,
  [SMALL_STATE(437)] = 23914,
  [SMALL_STATE(438)] = 23927,
  [SMALL_STATE(439)] = 23940,
  [SMALL_STATE(440)] = 23953,
  [SMALL_STATE(441)] = 23966,
  [SMALL_STATE(442)] = 23979,
  [SMALL_STATE(443)] = 23992,
  [SMALL_STATE(444)] = 24005,
  [SMALL_STATE(445)] = 24018,
  [SMALL_STATE(446)] = 24031,
  [SMALL_STATE(447)] = 24044,
  [SMALL_STATE(448)] = 24057,
  [SMALL_STATE(449)] = 24070,
  [SMALL_STATE(450)] = 24083,
  [SMALL_STATE(451)] = 24096,
  [SMALL_STATE(452)] = 24109,
  [SMALL_STATE(453)] = 24122,
  [SMALL_STATE(454)] = 24135,
  [SMALL_STATE(455)] = 24148,
  [SMALL_STATE(456)] = 24161,
  [SMALL_STATE(457)] = 24174,
  [SMALL_STATE(458)] = 24187,
  [SMALL_STATE(459)] = 24200,
  [SMALL_STATE(460)] = 24213,
  [SMALL_STATE(461)] = 24226,
  [SMALL_STATE(462)] = 24239,
  [SMALL_STATE(463)] = 24252,
  [SMALL_STATE(464)] = 24265,
  [SMALL_STATE(465)] = 24278,
  [SMALL_STATE(466)] = 24291,
  [SMALL_STATE(467)] = 24304,
  [SMALL_STATE(468)] = 24317,
  [SMALL_STATE(469)] = 24330,
  [SMALL_STATE(470)] = 24343,
  [SMALL_STATE(471)] = 24356,
  [SMALL_STATE(472)] = 24369,
  [SMALL_STATE(473)] = 24382,
  [SMALL_STATE(474)] = 24395,
  [SMALL_STATE(475)] = 24408,
  [SMALL_STATE(476)] = 24421,
  [SMALL_STATE(477)] = 24434,
  [SMALL_STATE(478)] = 24447,
  [SMALL_STATE(479)] = 24460,
  [SMALL_STATE(480)] = 24473,
  [SMALL_STATE(481)] = 24486,
  [SMALL_STATE(482)] = 24499,
  [SMALL_STATE(483)] = 24512,
  [SMALL_STATE(484)] = 24525,
  [SMALL_STATE(485)] = 24538,
  [SMALL_STATE(486)] = 24551,
  [SMALL_STATE(487)] = 24564,
  [SMALL_STATE(488)] = 24577,
  [SMALL_STATE(489)] = 24590,
  [SMALL_STATE(490)] = 24603,
  [SMALL_STATE(491)] = 24616,
  [SMALL_STATE(492)] = 24629,
  [SMALL_STATE(493)] = 24642,
  [SMALL_STATE(494)] = 24655,
  [SMALL_STATE(495)] = 24668,
  [SMALL_STATE(496)] = 24681,
  [SMALL_STATE(497)] = 24694,
  [SMALL_STATE(498)] = 24707,
  [SMALL_STATE(499)] = 24720,
  [SMALL_STATE(500)] = 24733,
  [SMALL_STATE(501)] = 24746,
  [SMALL_STATE(502)] = 24759,
  [SMALL_STATE(503)] = 24772,
  [SMALL_STATE(504)] = 24785,
  [SMALL_STATE(505)] = 24798,
  [SMALL_STATE(506)] = 24811,
  [SMALL_STATE(507)] = 24824,
  [SMALL_STATE(508)] = 24837,
  [SMALL_STATE(509)] = 24850,
  [SMALL_STATE(510)] = 24863,
  [SMALL_STATE(511)] = 24876,
  [SMALL_STATE(512)] = 24889,
  [SMALL_STATE(513)] = 24902,
  [SMALL_STATE(514)] = 24915,
  [SMALL_STATE(515)] = 24928,
  [SMALL_STATE(516)] = 24941,
  [SMALL_STATE(517)] = 24954,
  [SMALL_STATE(518)] = 24967,
  [SMALL_STATE(519)] = 24980,
  [SMALL_STATE(520)] = 24993,
  [SMALL_STATE(521)] = 25006,
  [SMALL_STATE(522)] = 25019,
  [SMALL_STATE(523)] = 25032,
  [SMALL_STATE(524)] = 25045,
  [SMALL_STATE(525)] = 25058,
  [SMALL_STATE(526)] = 25071,
  [SMALL_STATE(527)] = 25084,
  [SMALL_STATE(528)] = 25097,
  [SMALL_STATE(529)] = 25110,
  [SMALL_STATE(530)] = 25123,
  [SMALL_STATE(531)] = 25136,
  [SMALL_STATE(532)] = 25149,
  [SMALL_STATE(533)] = 25162,
  [SMALL_STATE(534)] = 25175,
  [SMALL_STATE(535)] = 25188,
  [SMALL_STATE(536)] = 25201,
  [SMALL_STATE(537)] = 25214,
  [SMALL_STATE(538)] = 25227,
  [SMALL_STATE(539)] = 25240,
  [SMALL_STATE(540)] = 25253,
  [SMALL_STATE(541)] = 25266,
  [SMALL_STATE(542)] = 25278,
  [SMALL_STATE(543)] = 25290,
  [SMALL_STATE(544)] = 25302,
  [SMALL_STATE(545)] = 25314,
  [SMALL_STATE(546)] = 25326,
  [SMALL_STATE(547)] = 25338,
  [SMALL_STATE(548)] = 25350,
  [SMALL_STATE(549)] = 25362,
  [SMALL_STATE(550)] = 25374,
  [SMALL_STATE(551)] = 25386,
  [SMALL_STATE(552)] = 25398,
  [SMALL_STATE(553)] = 25410,
  [SMALL_STATE(554)] = 25422,
  [SMALL_STATE(555)] = 25434,
  [SMALL_STATE(556)] = 25446,
  [SMALL_STATE(557)] = 25458,
  [SMALL_STATE(558)] = 25470,
  [SMALL_STATE(559)] = 25482,
  [SMALL_STATE(560)] = 25494,
  [SMALL_STATE(561)] = 25506,
  [SMALL_STATE(562)] = 25518,
  [SMALL_STATE(563)] = 25530,
  [SMALL_STATE(564)] = 25542,
  [SMALL_STATE(565)] = 25554,
  [SMALL_STATE(566)] = 25566,
  [SMALL_STATE(567)] = 25578,
  [SMALL_STATE(568)] = 25590,
  [SMALL_STATE(569)] = 25602,
  [SMALL_STATE(570)] = 25614,
  [SMALL_STATE(571)] = 25626,
  [SMALL_STATE(572)] = 25638,
  [SMALL_STATE(573)] = 25650,
  [SMALL_STATE(574)] = 25662,
  [SMALL_STATE(575)] = 25674,
  [SMALL_STATE(576)] = 25686,
  [SMALL_STATE(577)] = 25698,
  [SMALL_STATE(578)] = 25710,
  [SMALL_STATE(579)] = 25722,
  [SMALL_STATE(580)] = 25734,
  [SMALL_STATE(581)] = 25746,
  [SMALL_STATE(582)] = 25758,
  [SMALL_STATE(583)] = 25770,
  [SMALL_STATE(584)] = 25782,
  [SMALL_STATE(585)] = 25794,
  [SMALL_STATE(586)] = 25806,
  [SMALL_STATE(587)] = 25818,
  [SMALL_STATE(588)] = 25830,
  [SMALL_STATE(589)] = 25842,
  [SMALL_STATE(590)] = 25854,
  [SMALL_STATE(591)] = 25866,
  [SMALL_STATE(592)] = 25878,
  [SMALL_STATE(593)] = 25890,
  [SMALL_STATE(594)] = 25902,
  [SMALL_STATE(595)] = 25914,
  [SMALL_STATE(596)] = 25926,
  [SMALL_STATE(597)] = 25938,
  [SMALL_STATE(598)] = 25950,
  [SMALL_STATE(599)] = 25962,
  [SMALL_STATE(600)] = 25974,
  [SMALL_STATE(601)] = 25986,
  [SMALL_STATE(602)] = 25998,
  [SMALL_STATE(603)] = 26010,
  [SMALL_STATE(604)] = 26022,
  [SMALL_STATE(605)] = 26034,
  [SMALL_STATE(606)] = 26046,
  [SMALL_STATE(607)] = 26058,
  [SMALL_STATE(608)] = 26070,
  [SMALL_STATE(609)] = 26082,
  [SMALL_STATE(610)] = 26094,
  [SMALL_STATE(611)] = 26106,
  [SMALL_STATE(612)] = 26118,
  [SMALL_STATE(613)] = 26130,
  [SMALL_STATE(614)] = 26142,
  [SMALL_STATE(615)] = 26154,
  [SMALL_STATE(616)] = 26166,
  [SMALL_STATE(617)] = 26178,
  [SMALL_STATE(618)] = 26190,
  [SMALL_STATE(619)] = 26202,
  [SMALL_STATE(620)] = 26214,
  [SMALL_STATE(621)] = 26226,
  [SMALL_STATE(622)] = 26238,
  [SMALL_STATE(623)] = 26250,
  [SMALL_STATE(624)] = 26262,
  [SMALL_STATE(625)] = 26274,
  [SMALL_STATE(626)] = 26286,
  [SMALL_STATE(627)] = 26298,
  [SMALL_STATE(628)] = 26310,
  [SMALL_STATE(629)] = 26322,
  [SMALL_STATE(630)] = 26334,
  [SMALL_STATE(631)] = 26346,
  [SMALL_STATE(632)] = 26358,
  [SMALL_STATE(633)] = 26370,
  [SMALL_STATE(634)] = 26382,
  [SMALL_STATE(635)] = 26394,
  [SMALL_STATE(636)] = 26414,
  [SMALL_STATE(637)] = 26426,
  [SMALL_STATE(638)] = 26438,
  [SMALL_STATE(639)] = 26450,
  [SMALL_STATE(640)] = 26462,
  [SMALL_STATE(641)] = 26474,
  [SMALL_STATE(642)] = 26486,
  [SMALL_STATE(643)] = 26506,
  [SMALL_STATE(644)] = 26518,
  [SMALL_STATE(645)] = 26538,
  [SMALL_STATE(646)] = 26550,
  [SMALL_STATE(647)] = 26562,
  [SMALL_STATE(648)] = 26574,
  [SMALL_STATE(649)] = 26586,
  [SMALL_STATE(650)] = 26598,
  [SMALL_STATE(651)] = 26610,
  [SMALL_STATE(652)] = 26622,
  [SMALL_STATE(653)] = 26634,
  [SMALL_STATE(654)] = 26646,
  [SMALL_STATE(655)] = 26658,
  [SMALL_STATE(656)] = 26670,
  [SMALL_STATE(657)] = 26682,
  [SMALL_STATE(658)] = 26694,
  [SMALL_STATE(659)] = 26706,
  [SMALL_STATE(660)] = 26718,
  [SMALL_STATE(661)] = 26736,
  [SMALL_STATE(662)] = 26748,
  [SMALL_STATE(663)] = 26760,
  [SMALL_STATE(664)] = 26772,
  [SMALL_STATE(665)] = 26784,
  [SMALL_STATE(666)] = 26796,
  [SMALL_STATE(667)] = 26808,
  [SMALL_STATE(668)] = 26820,
  [SMALL_STATE(669)] = 26832,
  [SMALL_STATE(670)] = 26844,
  [SMALL_STATE(671)] = 26856,
  [SMALL_STATE(672)] = 26868,
  [SMALL_STATE(673)] = 26880,
  [SMALL_STATE(674)] = 26892,
  [SMALL_STATE(675)] = 26904,
  [SMALL_STATE(676)] = 26916,
  [SMALL_STATE(677)] = 26928,
  [SMALL_STATE(678)] = 26940,
  [SMALL_STATE(679)] = 26955,
  [SMALL_STATE(680)] = 26974,
  [SMALL_STATE(681)] = 26993,
  [SMALL_STATE(682)] = 27012,
  [SMALL_STATE(683)] = 27031,
  [SMALL_STATE(684)] = 27048,
  [SMALL_STATE(685)] = 27067,
  [SMALL_STATE(686)] = 27084,
  [SMALL_STATE(687)] = 27103,
  [SMALL_STATE(688)] = 27122,
  [SMALL_STATE(689)] = 27141,
  [SMALL_STATE(690)] = 27158,
  [SMALL_STATE(691)] = 27173,
  [SMALL_STATE(692)] = 27190,
  [SMALL_STATE(693)] = 27202,
  [SMALL_STATE(694)] = 27216,
  [SMALL_STATE(695)] = 27232,
  [SMALL_STATE(696)] = 27248,
  [SMALL_STATE(697)] = 27264,
  [SMALL_STATE(698)] = 27280,
  [SMALL_STATE(699)] = 27296,
  [SMALL_STATE(700)] = 27312,
  [SMALL_STATE(701)] = 27328,
  [SMALL_STATE(702)] = 27344,
  [SMALL_STATE(703)] = 27360,
  [SMALL_STATE(704)] = 27374,
  [SMALL_STATE(705)] = 27390,
  [SMALL_STATE(706)] = 27402,
  [SMALL_STATE(707)] = 27418,
  [SMALL_STATE(708)] = 27434,
  [SMALL_STATE(709)] = 27446,
  [SMALL_STATE(710)] = 27460,
  [SMALL_STATE(711)] = 27476,
  [SMALL_STATE(712)] = 27490,
  [SMALL_STATE(713)] = 27506,
  [SMALL_STATE(714)] = 27522,
  [SMALL_STATE(715)] = 27538,
  [SMALL_STATE(716)] = 27550,
  [SMALL_STATE(717)] = 27562,
  [SMALL_STATE(718)] = 27576,
  [SMALL_STATE(719)] = 27592,
  [SMALL_STATE(720)] = 27604,
  [SMALL_STATE(721)] = 27620,
  [SMALL_STATE(722)] = 27636,
  [SMALL_STATE(723)] = 27652,
  [SMALL_STATE(724)] = 27666,
  [SMALL_STATE(725)] = 27678,
  [SMALL_STATE(726)] = 27692,
  [SMALL_STATE(727)] = 27708,
  [SMALL_STATE(728)] = 27720,
  [SMALL_STATE(729)] = 27736,
  [SMALL_STATE(730)] = 27752,
  [SMALL_STATE(731)] = 27763,
  [SMALL_STATE(732)] = 27774,
  [SMALL_STATE(733)] = 27787,
  [SMALL_STATE(734)] = 27798,
  [SMALL_STATE(735)] = 27811,
  [SMALL_STATE(736)] = 27824,
  [SMALL_STATE(737)] = 27835,
  [SMALL_STATE(738)] = 27842,
  [SMALL_STATE(739)] = 27849,
  [SMALL_STATE(740)] = 27860,
  [SMALL_STATE(741)] = 27871,
  [SMALL_STATE(742)] = 27884,
  [SMALL_STATE(743)] = 27897,
  [SMALL_STATE(744)] = 27910,
  [SMALL_STATE(745)] = 27921,
  [SMALL_STATE(746)] = 27932,
  [SMALL_STATE(747)] = 27945,
  [SMALL_STATE(748)] = 27956,
  [SMALL_STATE(749)] = 27969,
  [SMALL_STATE(750)] = 27982,
  [SMALL_STATE(751)] = 27995,
  [SMALL_STATE(752)] = 28006,
  [SMALL_STATE(753)] = 28017,
  [SMALL_STATE(754)] = 28028,
  [SMALL_STATE(755)] = 28039,
  [SMALL_STATE(756)] = 28050,
  [SMALL_STATE(757)] = 28061,
  [SMALL_STATE(758)] = 28072,
  [SMALL_STATE(759)] = 28083,
  [SMALL_STATE(760)] = 28096,
  [SMALL_STATE(761)] = 28109,
  [SMALL_STATE(762)] = 28122,
  [SMALL_STATE(763)] = 28133,
  [SMALL_STATE(764)] = 28146,
  [SMALL_STATE(765)] = 28156,
  [SMALL_STATE(766)] = 28166,
  [SMALL_STATE(767)] = 28176,
  [SMALL_STATE(768)] = 28186,
  [SMALL_STATE(769)] = 28196,
  [SMALL_STATE(770)] = 28206,
  [SMALL_STATE(771)] = 28216,
  [SMALL_STATE(772)] = 28226,
  [SMALL_STATE(773)] = 28236,
  [SMALL_STATE(774)] = 28246,
  [SMALL_STATE(775)] = 28254,
  [SMALL_STATE(776)] = 28264,
  [SMALL_STATE(777)] = 28274,
  [SMALL_STATE(778)] = 28282,
  [SMALL_STATE(779)] = 28292,
  [SMALL_STATE(780)] = 28302,
  [SMALL_STATE(781)] = 28312,
  [SMALL_STATE(782)] = 28318,
  [SMALL_STATE(783)] = 28328,
  [SMALL_STATE(784)] = 28338,
  [SMALL_STATE(785)] = 28348,
  [SMALL_STATE(786)] = 28358,
  [SMALL_STATE(787)] = 28364,
  [SMALL_STATE(788)] = 28374,
  [SMALL_STATE(789)] = 28384,
  [SMALL_STATE(790)] = 28394,
  [SMALL_STATE(791)] = 28404,
  [SMALL_STATE(792)] = 28414,
  [SMALL_STATE(793)] = 28424,
  [SMALL_STATE(794)] = 28434,
  [SMALL_STATE(795)] = 28444,
  [SMALL_STATE(796)] = 28454,
  [SMALL_STATE(797)] = 28464,
  [SMALL_STATE(798)] = 28474,
  [SMALL_STATE(799)] = 28484,
  [SMALL_STATE(800)] = 28492,
  [SMALL_STATE(801)] = 28502,
  [SMALL_STATE(802)] = 28512,
  [SMALL_STATE(803)] = 28522,
  [SMALL_STATE(804)] = 28532,
  [SMALL_STATE(805)] = 28542,
  [SMALL_STATE(806)] = 28552,
  [SMALL_STATE(807)] = 28562,
  [SMALL_STATE(808)] = 28572,
  [SMALL_STATE(809)] = 28582,
  [SMALL_STATE(810)] = 28590,
  [SMALL_STATE(811)] = 28600,
  [SMALL_STATE(812)] = 28610,
  [SMALL_STATE(813)] = 28620,
  [SMALL_STATE(814)] = 28630,
  [SMALL_STATE(815)] = 28640,
  [SMALL_STATE(816)] = 28646,
  [SMALL_STATE(817)] = 28656,
  [SMALL_STATE(818)] = 28663,
  [SMALL_STATE(819)] = 28670,
  [SMALL_STATE(820)] = 28677,
  [SMALL_STATE(821)] = 28682,
  [SMALL_STATE(822)] = 28687,
  [SMALL_STATE(823)] = 28692,
  [SMALL_STATE(824)] = 28697,
  [SMALL_STATE(825)] = 28702,
  [SMALL_STATE(826)] = 28707,
  [SMALL_STATE(827)] = 28712,
  [SMALL_STATE(828)] = 28719,
  [SMALL_STATE(829)] = 28726,
  [SMALL_STATE(830)] = 28733,
  [SMALL_STATE(831)] = 28738,
  [SMALL_STATE(832)] = 28743,
  [SMALL_STATE(833)] = 28750,
  [SMALL_STATE(834)] = 28755,
  [SMALL_STATE(835)] = 28762,
  [SMALL_STATE(836)] = 28769,
  [SMALL_STATE(837)] = 28776,
  [SMALL_STATE(838)] = 28783,
  [SMALL_STATE(839)] = 28790,
  [SMALL_STATE(840)] = 28797,
  [SMALL_STATE(841)] = 28802,
  [SMALL_STATE(842)] = 28809,
  [SMALL_STATE(843)] = 28816,
  [SMALL_STATE(844)] = 28821,
  [SMALL_STATE(845)] = 28828,
  [SMALL_STATE(846)] = 28833,
  [SMALL_STATE(847)] = 28840,
  [SMALL_STATE(848)] = 28847,
  [SMALL_STATE(849)] = 28854,
  [SMALL_STATE(850)] = 28859,
  [SMALL_STATE(851)] = 28864,
  [SMALL_STATE(852)] = 28869,
  [SMALL_STATE(853)] = 28874,
  [SMALL_STATE(854)] = 28879,
  [SMALL_STATE(855)] = 28884,
  [SMALL_STATE(856)] = 28889,
  [SMALL_STATE(857)] = 28896,
  [SMALL_STATE(858)] = 28901,
  [SMALL_STATE(859)] = 28906,
  [SMALL_STATE(860)] = 28911,
  [SMALL_STATE(861)] = 28916,
  [SMALL_STATE(862)] = 28921,
  [SMALL_STATE(863)] = 28926,
  [SMALL_STATE(864)] = 28933,
  [SMALL_STATE(865)] = 28940,
  [SMALL_STATE(866)] = 28947,
  [SMALL_STATE(867)] = 28954,
  [SMALL_STATE(868)] = 28961,
  [SMALL_STATE(869)] = 28968,
  [SMALL_STATE(870)] = 28975,
  [SMALL_STATE(871)] = 28982,
  [SMALL_STATE(872)] = 28989,
  [SMALL_STATE(873)] = 28996,
  [SMALL_STATE(874)] = 29003,
  [SMALL_STATE(875)] = 29010,
  [SMALL_STATE(876)] = 29017,
  [SMALL_STATE(877)] = 29024,
  [SMALL_STATE(878)] = 29031,
  [SMALL_STATE(879)] = 29038,
  [SMALL_STATE(880)] = 29043,
  [SMALL_STATE(881)] = 29048,
  [SMALL_STATE(882)] = 29053,
  [SMALL_STATE(883)] = 29060,
  [SMALL_STATE(884)] = 29067,
  [SMALL_STATE(885)] = 29074,
  [SMALL_STATE(886)] = 29081,
  [SMALL_STATE(887)] = 29088,
  [SMALL_STATE(888)] = 29093,
  [SMALL_STATE(889)] = 29100,
  [SMALL_STATE(890)] = 29107,
  [SMALL_STATE(891)] = 29114,
  [SMALL_STATE(892)] = 29121,
  [SMALL_STATE(893)] = 29128,
  [SMALL_STATE(894)] = 29135,
  [SMALL_STATE(895)] = 29142,
  [SMALL_STATE(896)] = 29149,
  [SMALL_STATE(897)] = 29156,
  [SMALL_STATE(898)] = 29163,
  [SMALL_STATE(899)] = 29170,
  [SMALL_STATE(900)] = 29177,
  [SMALL_STATE(901)] = 29184,
  [SMALL_STATE(902)] = 29191,
  [SMALL_STATE(903)] = 29198,
  [SMALL_STATE(904)] = 29203,
  [SMALL_STATE(905)] = 29208,
  [SMALL_STATE(906)] = 29215,
  [SMALL_STATE(907)] = 29220,
  [SMALL_STATE(908)] = 29227,
  [SMALL_STATE(909)] = 29234,
  [SMALL_STATE(910)] = 29239,
  [SMALL_STATE(911)] = 29244,
  [SMALL_STATE(912)] = 29249,
  [SMALL_STATE(913)] = 29254,
  [SMALL_STATE(914)] = 29259,
  [SMALL_STATE(915)] = 29264,
  [SMALL_STATE(916)] = 29269,
  [SMALL_STATE(917)] = 29274,
  [SMALL_STATE(918)] = 29281,
  [SMALL_STATE(919)] = 29288,
  [SMALL_STATE(920)] = 29293,
  [SMALL_STATE(921)] = 29298,
  [SMALL_STATE(922)] = 29305,
  [SMALL_STATE(923)] = 29312,
  [SMALL_STATE(924)] = 29317,
  [SMALL_STATE(925)] = 29324,
  [SMALL_STATE(926)] = 29331,
  [SMALL_STATE(927)] = 29338,
  [SMALL_STATE(928)] = 29345,
  [SMALL_STATE(929)] = 29352,
  [SMALL_STATE(930)] = 29357,
  [SMALL_STATE(931)] = 29364,
  [SMALL_STATE(932)] = 29371,
  [SMALL_STATE(933)] = 29376,
  [SMALL_STATE(934)] = 29383,
  [SMALL_STATE(935)] = 29390,
  [SMALL_STATE(936)] = 29397,
  [SMALL_STATE(937)] = 29404,
  [SMALL_STATE(938)] = 29411,
  [SMALL_STATE(939)] = 29416,
  [SMALL_STATE(940)] = 29423,
  [SMALL_STATE(941)] = 29430,
  [SMALL_STATE(942)] = 29437,
  [SMALL_STATE(943)] = 29442,
  [SMALL_STATE(944)] = 29449,
  [SMALL_STATE(945)] = 29456,
  [SMALL_STATE(946)] = 29461,
  [SMALL_STATE(947)] = 29466,
  [SMALL_STATE(948)] = 29471,
  [SMALL_STATE(949)] = 29476,
  [SMALL_STATE(950)] = 29481,
  [SMALL_STATE(951)] = 29488,
  [SMALL_STATE(952)] = 29495,
  [SMALL_STATE(953)] = 29502,
  [SMALL_STATE(954)] = 29509,
  [SMALL_STATE(955)] = 29516,
  [SMALL_STATE(956)] = 29523,
  [SMALL_STATE(957)] = 29530,
  [SMALL_STATE(958)] = 29537,
  [SMALL_STATE(959)] = 29544,
  [SMALL_STATE(960)] = 29551,
  [SMALL_STATE(961)] = 29558,
  [SMALL_STATE(962)] = 29563,
  [SMALL_STATE(963)] = 29570,
  [SMALL_STATE(964)] = 29577,
  [SMALL_STATE(965)] = 29584,
  [SMALL_STATE(966)] = 29591,
  [SMALL_STATE(967)] = 29598,
  [SMALL_STATE(968)] = 29603,
  [SMALL_STATE(969)] = 29608,
  [SMALL_STATE(970)] = 29613,
  [SMALL_STATE(971)] = 29620,
  [SMALL_STATE(972)] = 29627,
  [SMALL_STATE(973)] = 29632,
  [SMALL_STATE(974)] = 29637,
  [SMALL_STATE(975)] = 29642,
  [SMALL_STATE(976)] = 29647,
  [SMALL_STATE(977)] = 29652,
  [SMALL_STATE(978)] = 29657,
  [SMALL_STATE(979)] = 29662,
  [SMALL_STATE(980)] = 29667,
  [SMALL_STATE(981)] = 29672,
  [SMALL_STATE(982)] = 29677,
  [SMALL_STATE(983)] = 29682,
  [SMALL_STATE(984)] = 29687,
  [SMALL_STATE(985)] = 29692,
  [SMALL_STATE(986)] = 29697,
  [SMALL_STATE(987)] = 29704,
  [SMALL_STATE(988)] = 29711,
  [SMALL_STATE(989)] = 29718,
  [SMALL_STATE(990)] = 29723,
  [SMALL_STATE(991)] = 29728,
  [SMALL_STATE(992)] = 29735,
  [SMALL_STATE(993)] = 29742,
  [SMALL_STATE(994)] = 29747,
  [SMALL_STATE(995)] = 29752,
  [SMALL_STATE(996)] = 29757,
  [SMALL_STATE(997)] = 29762,
  [SMALL_STATE(998)] = 29769,
  [SMALL_STATE(999)] = 29776,
  [SMALL_STATE(1000)] = 29781,
  [SMALL_STATE(1001)] = 29786,
  [SMALL_STATE(1002)] = 29791,
  [SMALL_STATE(1003)] = 29796,
  [SMALL_STATE(1004)] = 29803,
  [SMALL_STATE(1005)] = 29810,
  [SMALL_STATE(1006)] = 29817,
  [SMALL_STATE(1007)] = 29824,
  [SMALL_STATE(1008)] = 29829,
  [SMALL_STATE(1009)] = 29836,
  [SMALL_STATE(1010)] = 29843,
  [SMALL_STATE(1011)] = 29850,
  [SMALL_STATE(1012)] = 29857,
  [SMALL_STATE(1013)] = 29862,
  [SMALL_STATE(1014)] = 29867,
  [SMALL_STATE(1015)] = 29874,
  [SMALL_STATE(1016)] = 29881,
  [SMALL_STATE(1017)] = 29888,
  [SMALL_STATE(1018)] = 29895,
  [SMALL_STATE(1019)] = 29900,
  [SMALL_STATE(1020)] = 29907,
  [SMALL_STATE(1021)] = 29914,
  [SMALL_STATE(1022)] = 29921,
  [SMALL_STATE(1023)] = 29928,
  [SMALL_STATE(1024)] = 29935,
  [SMALL_STATE(1025)] = 29942,
  [SMALL_STATE(1026)] = 29949,
  [SMALL_STATE(1027)] = 29956,
  [SMALL_STATE(1028)] = 29963,
  [SMALL_STATE(1029)] = 29970,
  [SMALL_STATE(1030)] = 29977,
  [SMALL_STATE(1031)] = 29984,
  [SMALL_STATE(1032)] = 29991,
  [SMALL_STATE(1033)] = 29998,
  [SMALL_STATE(1034)] = 30005,
  [SMALL_STATE(1035)] = 30012,
  [SMALL_STATE(1036)] = 30019,
  [SMALL_STATE(1037)] = 30026,
  [SMALL_STATE(1038)] = 30033,
  [SMALL_STATE(1039)] = 30040,
  [SMALL_STATE(1040)] = 30045,
  [SMALL_STATE(1041)] = 30052,
  [SMALL_STATE(1042)] = 30059,
  [SMALL_STATE(1043)] = 30066,
  [SMALL_STATE(1044)] = 30073,
  [SMALL_STATE(1045)] = 30080,
  [SMALL_STATE(1046)] = 30087,
  [SMALL_STATE(1047)] = 30094,
  [SMALL_STATE(1048)] = 30101,
  [SMALL_STATE(1049)] = 30108,
  [SMALL_STATE(1050)] = 30115,
  [SMALL_STATE(1051)] = 30122,
  [SMALL_STATE(1052)] = 30129,
  [SMALL_STATE(1053)] = 30136,
  [SMALL_STATE(1054)] = 30143,
  [SMALL_STATE(1055)] = 30150,
  [SMALL_STATE(1056)] = 30157,
  [SMALL_STATE(1057)] = 30164,
  [SMALL_STATE(1058)] = 30171,
  [SMALL_STATE(1059)] = 30176,
  [SMALL_STATE(1060)] = 30181,
  [SMALL_STATE(1061)] = 30186,
  [SMALL_STATE(1062)] = 30191,
  [SMALL_STATE(1063)] = 30198,
  [SMALL_STATE(1064)] = 30203,
  [SMALL_STATE(1065)] = 30210,
  [SMALL_STATE(1066)] = 30217,
  [SMALL_STATE(1067)] = 30224,
  [SMALL_STATE(1068)] = 30231,
  [SMALL_STATE(1069)] = 30238,
  [SMALL_STATE(1070)] = 30243,
  [SMALL_STATE(1071)] = 30248,
  [SMALL_STATE(1072)] = 30255,
  [SMALL_STATE(1073)] = 30259,
  [SMALL_STATE(1074)] = 30263,
  [SMALL_STATE(1075)] = 30267,
  [SMALL_STATE(1076)] = 30271,
  [SMALL_STATE(1077)] = 30275,
  [SMALL_STATE(1078)] = 30279,
  [SMALL_STATE(1079)] = 30283,
  [SMALL_STATE(1080)] = 30287,
  [SMALL_STATE(1081)] = 30291,
  [SMALL_STATE(1082)] = 30295,
  [SMALL_STATE(1083)] = 30299,
  [SMALL_STATE(1084)] = 30303,
  [SMALL_STATE(1085)] = 30307,
  [SMALL_STATE(1086)] = 30311,
  [SMALL_STATE(1087)] = 30315,
  [SMALL_STATE(1088)] = 30319,
  [SMALL_STATE(1089)] = 30323,
  [SMALL_STATE(1090)] = 30327,
  [SMALL_STATE(1091)] = 30331,
  [SMALL_STATE(1092)] = 30335,
  [SMALL_STATE(1093)] = 30339,
  [SMALL_STATE(1094)] = 30343,
  [SMALL_STATE(1095)] = 30347,
  [SMALL_STATE(1096)] = 30351,
  [SMALL_STATE(1097)] = 30355,
  [SMALL_STATE(1098)] = 30359,
  [SMALL_STATE(1099)] = 30363,
  [SMALL_STATE(1100)] = 30367,
  [SMALL_STATE(1101)] = 30371,
  [SMALL_STATE(1102)] = 30375,
  [SMALL_STATE(1103)] = 30379,
  [SMALL_STATE(1104)] = 30383,
  [SMALL_STATE(1105)] = 30387,
  [SMALL_STATE(1106)] = 30391,
  [SMALL_STATE(1107)] = 30395,
  [SMALL_STATE(1108)] = 30399,
  [SMALL_STATE(1109)] = 30403,
  [SMALL_STATE(1110)] = 30407,
  [SMALL_STATE(1111)] = 30411,
  [SMALL_STATE(1112)] = 30415,
  [SMALL_STATE(1113)] = 30419,
  [SMALL_STATE(1114)] = 30423,
  [SMALL_STATE(1115)] = 30427,
  [SMALL_STATE(1116)] = 30431,
  [SMALL_STATE(1117)] = 30435,
  [SMALL_STATE(1118)] = 30439,
  [SMALL_STATE(1119)] = 30443,
  [SMALL_STATE(1120)] = 30447,
  [SMALL_STATE(1121)] = 30451,
  [SMALL_STATE(1122)] = 30455,
  [SMALL_STATE(1123)] = 30459,
  [SMALL_STATE(1124)] = 30463,
  [SMALL_STATE(1125)] = 30467,
  [SMALL_STATE(1126)] = 30471,
  [SMALL_STATE(1127)] = 30475,
  [SMALL_STATE(1128)] = 30479,
  [SMALL_STATE(1129)] = 30483,
  [SMALL_STATE(1130)] = 30487,
  [SMALL_STATE(1131)] = 30491,
  [SMALL_STATE(1132)] = 30495,
  [SMALL_STATE(1133)] = 30499,
  [SMALL_STATE(1134)] = 30503,
  [SMALL_STATE(1135)] = 30507,
  [SMALL_STATE(1136)] = 30511,
  [SMALL_STATE(1137)] = 30515,
  [SMALL_STATE(1138)] = 30519,
  [SMALL_STATE(1139)] = 30523,
  [SMALL_STATE(1140)] = 30527,
  [SMALL_STATE(1141)] = 30531,
  [SMALL_STATE(1142)] = 30535,
  [SMALL_STATE(1143)] = 30539,
  [SMALL_STATE(1144)] = 30543,
  [SMALL_STATE(1145)] = 30547,
  [SMALL_STATE(1146)] = 30551,
  [SMALL_STATE(1147)] = 30555,
  [SMALL_STATE(1148)] = 30559,
  [SMALL_STATE(1149)] = 30563,
  [SMALL_STATE(1150)] = 30567,
  [SMALL_STATE(1151)] = 30571,
  [SMALL_STATE(1152)] = 30575,
  [SMALL_STATE(1153)] = 30579,
  [SMALL_STATE(1154)] = 30583,
  [SMALL_STATE(1155)] = 30587,
  [SMALL_STATE(1156)] = 30591,
  [SMALL_STATE(1157)] = 30595,
  [SMALL_STATE(1158)] = 30599,
  [SMALL_STATE(1159)] = 30603,
  [SMALL_STATE(1160)] = 30607,
  [SMALL_STATE(1161)] = 30611,
  [SMALL_STATE(1162)] = 30615,
  [SMALL_STATE(1163)] = 30619,
  [SMALL_STATE(1164)] = 30623,
  [SMALL_STATE(1165)] = 30627,
  [SMALL_STATE(1166)] = 30631,
  [SMALL_STATE(1167)] = 30635,
  [SMALL_STATE(1168)] = 30639,
  [SMALL_STATE(1169)] = 30643,
  [SMALL_STATE(1170)] = 30647,
  [SMALL_STATE(1171)] = 30651,
  [SMALL_STATE(1172)] = 30655,
  [SMALL_STATE(1173)] = 30659,
  [SMALL_STATE(1174)] = 30663,
  [SMALL_STATE(1175)] = 30667,
  [SMALL_STATE(1176)] = 30671,
  [SMALL_STATE(1177)] = 30675,
  [SMALL_STATE(1178)] = 30679,
  [SMALL_STATE(1179)] = 30683,
  [SMALL_STATE(1180)] = 30687,
  [SMALL_STATE(1181)] = 30691,
  [SMALL_STATE(1182)] = 30695,
  [SMALL_STATE(1183)] = 30699,
  [SMALL_STATE(1184)] = 30703,
  [SMALL_STATE(1185)] = 30707,
  [SMALL_STATE(1186)] = 30711,
  [SMALL_STATE(1187)] = 30715,
  [SMALL_STATE(1188)] = 30719,
  [SMALL_STATE(1189)] = 30723,
  [SMALL_STATE(1190)] = 30727,
  [SMALL_STATE(1191)] = 30731,
  [SMALL_STATE(1192)] = 30735,
  [SMALL_STATE(1193)] = 30739,
  [SMALL_STATE(1194)] = 30743,
  [SMALL_STATE(1195)] = 30747,
  [SMALL_STATE(1196)] = 30751,
  [SMALL_STATE(1197)] = 30755,
  [SMALL_STATE(1198)] = 30759,
  [SMALL_STATE(1199)] = 30763,
  [SMALL_STATE(1200)] = 30767,
  [SMALL_STATE(1201)] = 30771,
  [SMALL_STATE(1202)] = 30775,
  [SMALL_STATE(1203)] = 30779,
  [SMALL_STATE(1204)] = 30783,
  [SMALL_STATE(1205)] = 30787,
  [SMALL_STATE(1206)] = 30791,
  [SMALL_STATE(1207)] = 30795,
  [SMALL_STATE(1208)] = 30799,
  [SMALL_STATE(1209)] = 30803,
  [SMALL_STATE(1210)] = 30807,
  [SMALL_STATE(1211)] = 30811,
  [SMALL_STATE(1212)] = 30815,
  [SMALL_STATE(1213)] = 30819,
  [SMALL_STATE(1214)] = 30823,
  [SMALL_STATE(1215)] = 30827,
  [SMALL_STATE(1216)] = 30831,
  [SMALL_STATE(1217)] = 30835,
  [SMALL_STATE(1218)] = 30839,
  [SMALL_STATE(1219)] = 30843,
  [SMALL_STATE(1220)] = 30847,
  [SMALL_STATE(1221)] = 30851,
  [SMALL_STATE(1222)] = 30855,
  [SMALL_STATE(1223)] = 30859,
  [SMALL_STATE(1224)] = 30863,
  [SMALL_STATE(1225)] = 30867,
  [SMALL_STATE(1226)] = 30871,
  [SMALL_STATE(1227)] = 30875,
  [SMALL_STATE(1228)] = 30879,
  [SMALL_STATE(1229)] = 30883,
  [SMALL_STATE(1230)] = 30887,
  [SMALL_STATE(1231)] = 30891,
  [SMALL_STATE(1232)] = 30895,
  [SMALL_STATE(1233)] = 30899,
  [SMALL_STATE(1234)] = 30903,
  [SMALL_STATE(1235)] = 30907,
  [SMALL_STATE(1236)] = 30911,
  [SMALL_STATE(1237)] = 30915,
  [SMALL_STATE(1238)] = 30919,
  [SMALL_STATE(1239)] = 30923,
  [SMALL_STATE(1240)] = 30927,
  [SMALL_STATE(1241)] = 30931,
  [SMALL_STATE(1242)] = 30935,
  [SMALL_STATE(1243)] = 30939,
  [SMALL_STATE(1244)] = 30943,
  [SMALL_STATE(1245)] = 30947,
  [SMALL_STATE(1246)] = 30951,
  [SMALL_STATE(1247)] = 30955,
  [SMALL_STATE(1248)] = 30959,
  [SMALL_STATE(1249)] = 30963,
  [SMALL_STATE(1250)] = 30967,
  [SMALL_STATE(1251)] = 30971,
  [SMALL_STATE(1252)] = 30975,
  [SMALL_STATE(1253)] = 30979,
  [SMALL_STATE(1254)] = 30983,
  [SMALL_STATE(1255)] = 30987,
  [SMALL_STATE(1256)] = 30991,
  [SMALL_STATE(1257)] = 30995,
  [SMALL_STATE(1258)] = 30999,
  [SMALL_STATE(1259)] = 31003,
  [SMALL_STATE(1260)] = 31007,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1076),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1073),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1157),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(814),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(810),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1171),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1170),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(742),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1084),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(680),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(679),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(803),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1172),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1100),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1158),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(935),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1169),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(701),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1167),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(937),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1186),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__elsif_liq, 2, 1, 17),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__when_liq, 2, 1, 17),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(144),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1076),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1073),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(324),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(293),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1157),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(377),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(814),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(810),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1171),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1170),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(742),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1084),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(680),
  [149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(679),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(803),
  [155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1172),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(356),
  [161] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(935),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(334),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1169),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(701),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(1167),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(937),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1177),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1219),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_liquid_tag, 2, 0, 0),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1154),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1162),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_liquid_tag, 1, 0, 0),
  [197] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(144),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1076),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1073),
  [214] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(326),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(293),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1154),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(377),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(814),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(810),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1171),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1170),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(742),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1084),
  [244] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(680),
  [247] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(679),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(803),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1172),
  [256] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(356),
  [259] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(935),
  [262] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(334),
  [265] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1169),
  [268] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(701),
  [271] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1167),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(937),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(1162),
  [280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_liquid_tag_repeat1, 2, 0, 0), SHIFT_REPEAT(158),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1200),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__else_liq, 2, 2, 30),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1108),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(750),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1189),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__else_liq, 1, 2, 0),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1190),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__elsif_liq, 3, 1, 41),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__when_liq, 3, 1, 32),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_access, 3, 0, 14),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access, 3, 0, 14),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 3, 0, 47),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 3, 0, 47),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_access, 4, 0, 14),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access, 4, 0, 14),
  [327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1176),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1174),
  [331] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1166),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1247),
  [335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1178),
  [337] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1248),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1188),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1168),
  [343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1110),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [349] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(394),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 3, 0, 16),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 3, 0, 16),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 5, 0, 16),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 5, 0, 16),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 3, 0, 15),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 3, 0, 15),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 3, 0, 0),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 3, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(942),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(811),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(807),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1226),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1216),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(741),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1214),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(686),
  [402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(687),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(800),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1258),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [410] = {.entry = {.count = 1, .reusable = false}}, SHIFT(830),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(831),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1244),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(726),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1259),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(819),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(826),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(862),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(861),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(860),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(825),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(824),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(974),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(854),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(996),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(976),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(990),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1070),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(845),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(818),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1003),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1006),
  [462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1005),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1004),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(900),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(941),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1034),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1033),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1030),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1029),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(940),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(954),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(955),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(856),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(865),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1045),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(973),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(853),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1047),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(963),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1046),
  [500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1044),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1043),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1042),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1041),
  [508] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1040),
  [510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1039),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(822),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1026),
  [516] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1025),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1024),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1023),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1022),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1021),
  [526] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1020),
  [528] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1019),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1018),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(894),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1000),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(999),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(921),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(850),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(849),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(982),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(981),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(980),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(933),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(978),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(977),
  [556] = {.entry = {.count = 1, .reusable = false}}, SHIFT(969),
  [558] = {.entry = {.count = 1, .reusable = false}}, SHIFT(852),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(938),
  [562] = {.entry = {.count = 1, .reusable = false}}, SHIFT(952),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(968),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(967),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(957),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(960),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(964),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(879),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(855),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(880),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(970),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1054),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(857),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1055),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1066),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1067),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(881),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(951),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(950),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(936),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(932),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1207),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(874),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1204),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(713),
  [614] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1202),
  [616] = {.entry = {.count = 1, .reusable = false}}, SHIFT(882),
  [618] = {.entry = {.count = 1, .reusable = false}}, SHIFT(909),
  [620] = {.entry = {.count = 1, .reusable = false}}, SHIFT(910),
  [622] = {.entry = {.count = 1, .reusable = false}}, SHIFT(919),
  [624] = {.entry = {.count = 1, .reusable = false}}, SHIFT(920),
  [626] = {.entry = {.count = 1, .reusable = false}}, SHIFT(923),
  [628] = {.entry = {.count = 1, .reusable = false}}, SHIFT(929),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__liquid_node, 2, 0, 0),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__liquid_node, 2, 0, 0),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__if_liq_repeat1, 1, 0, 0),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat1, 1, 0, 0),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__iterator, 1, 0, 29),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__iterator, 1, 0, 29),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__page_iterator, 3, 0, 53),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__page_iterator, 3, 0, 53),
  [648] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [650] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0), REDUCE(sym_custom_unpaired_statement, 1, 0, 1),
  [653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1163),
  [657] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1164),
  [659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [663] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1132),
  [665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(761),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [671] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [677] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__iterator, 2, 0, 39),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__iterator, 2, 0, 39),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, 0, 68),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, 0, 68),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [695] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__page_iterator, 1, 0, 29),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__page_iterator, 1, 0, 29),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment_liq, 4, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment_liq, 4, 0, 0),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment_liq, 1, 0, 0),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment_liq, 1, 0, 0),
  [711] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment_liq, 3, 0, 0),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment_liq, 3, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 2, 0, 0),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1, 0, 0),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [745] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(403),
  [756] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(403),
  [759] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(137),
  [762] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(361),
  [765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [771] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [773] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_elsif_clause, 4, 1, 49), SHIFT(138),
  [776] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [778] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [780] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [782] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [784] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [786] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [788] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_clause, 4, 2, 59), SHIFT(138),
  [791] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_when_clause, 4, 1, 49), SHIFT(138),
  [794] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_elsif_clause, 5, 1, 70), SHIFT(138),
  [797] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [801] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_when_clause, 5, 1, 61), SHIFT(138),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [806] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [808] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [810] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [812] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_else_clause, 3, 2, 0), SHIFT(138),
  [815] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [817] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [819] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [821] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [823] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [825] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [827] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [831] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [833] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [835] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [837] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [839] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [845] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [855] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [858] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [861] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(138),
  [864] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(366),
  [867] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [869] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [871] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [873] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [877] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [881] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [885] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [888] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [891] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(138),
  [894] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(366),
  [897] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [899] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [902] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [905] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(138),
  [908] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(366),
  [911] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [913] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [915] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [917] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [919] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1094),
  [921] = {.entry = {.count = 1, .reusable = false}}, SHIFT(748),
  [923] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [925] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [927] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [929] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [932] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [935] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(138),
  [938] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(366),
  [941] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [943] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [945] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [947] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [949] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [951] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(393),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1086),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(763),
  [962] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 1, 0, 0),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 1, 0, 0),
  [966] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [968] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [970] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [972] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [974] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [976] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [978] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [980] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1089),
  [982] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [984] = {.entry = {.count = 1, .reusable = false}}, SHIFT(395),
  [986] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(391),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [1011] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(395),
  [1014] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [1016] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__include_param, 3, 0, 0),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__include_param, 3, 0, 0),
  [1020] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1079),
  [1024] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 4, 0, 24),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_unpaired_statement, 1, 0, 1),
  [1038] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1155),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1156),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1048] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1062] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [1064] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [1066] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [1068] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [1070] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [1072] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1126),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_unpaired_statement, 2, 0, 1),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(753),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_echo_statement, 2, 0, 0),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [1088] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(44),
  [1091] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0),
  [1093] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(359),
  [1096] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(359),
  [1099] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1155),
  [1102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1156),
  [1105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(243),
  [1108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(40),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(716),
  [1115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [1117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1175),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1173),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(235),
  [1140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(358),
  [1143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1163),
  [1146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1164),
  [1149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(254),
  [1152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_unpaired_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(241),
  [1155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(635),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(762),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1163),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1164),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [1271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(644),
  [1273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [1275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(690),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(692),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1182),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [1329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0),
  [1331] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(402),
  [1334] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(402),
  [1337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0),
  [1339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0),
  [1341] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(402),
  [1344] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(402),
  [1347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0),
  [1349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tablerow_statement, 10, 0, 77),
  [1351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tablerow_statement, 10, 0, 77),
  [1353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 72),
  [1355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 72),
  [1357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1, 0, 0),
  [1359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 1, 0, 0),
  [1361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 7, 0, 49),
  [1363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 7, 0, 49),
  [1365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1, 0, 0),
  [1367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1, 0, 0),
  [1369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tagged_unpaired_statement, 3, 0, 0),
  [1371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__tagged_unpaired_statement, 3, 0, 0),
  [1373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__inline_comment, 3, 0, 0),
  [1375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__inline_comment, 3, 0, 0),
  [1377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__output_statement, 3, 0, 0),
  [1379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__output_statement, 3, 0, 0),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1215),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1220),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1253),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1196),
  [1391] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(423),
  [1394] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_template_content, 1, 0, 0), SHIFT(423),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1203),
  [1399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture_statement, 7, 0, 51),
  [1401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture_statement, 7, 0, 51),
  [1403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_statement, 6, 0, 0),
  [1405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_statement, 6, 0, 0),
  [1407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 7, 0, 52),
  [1409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 7, 0, 52),
  [1411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet_statement, 6, 0, 0),
  [1413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stylesheet_statement, 6, 0, 0),
  [1415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_javascript_statement, 6, 0, 0),
  [1417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_javascript_statement, 6, 0, 0),
  [1419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(423),
  [1422] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_content_repeat1, 2, 0, 0), SHIFT_REPEAT(423),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 11, 0, 79),
  [1427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 11, 0, 79),
  [1429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paginate_statement, 10, 0, 77),
  [1431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paginate_statement, 10, 0, 77),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 7, 0, 50),
  [1435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 7, 0, 50),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_statement, 7, 0, 54),
  [1439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_statement, 7, 0, 54),
  [1441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_statement, 7, 0, 0),
  [1443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_statement, 7, 0, 0),
  [1445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet_statement, 7, 0, 0),
  [1447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_stylesheet_statement, 7, 0, 0),
  [1449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_javascript_statement, 7, 0, 0),
  [1451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_javascript_statement, 7, 0, 0),
  [1453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 7, 0, 0),
  [1455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 7, 0, 0),
  [1457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment, 7, 0, 55),
  [1459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment, 7, 0, 55),
  [1461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 10, 0, 75),
  [1463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 10, 0, 75),
  [1465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 10, 0, 78),
  [1467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 10, 0, 78),
  [1469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 10, 0, 78),
  [1471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 10, 0, 78),
  [1473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, 0, 49),
  [1475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, 0, 49),
  [1477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 10, 0, 77),
  [1479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 10, 0, 77),
  [1481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 10, 0, 76),
  [1483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 10, 0, 76),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 60),
  [1487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 60),
  [1489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 61),
  [1491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 61),
  [1493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 62),
  [1495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 62),
  [1497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 8, 0, 63),
  [1499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 8, 0, 63),
  [1501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 8, 0, 64),
  [1503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 8, 0, 64),
  [1505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paginate_statement, 9, 0, 69),
  [1507] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paginate_statement, 9, 0, 69),
  [1509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 60),
  [1511] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 60),
  [1513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 61),
  [1515] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 61),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 8, 0, 62),
  [1519] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 8, 0, 62),
  [1521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture_statement, 8, 0, 65),
  [1523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture_statement, 8, 0, 65),
  [1525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 8, 0, 52),
  [1527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 8, 0, 52),
  [1529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tablerow_statement, 9, 0, 69),
  [1531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tablerow_statement, 9, 0, 69),
  [1533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_form_statement, 9, 0, 75),
  [1535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_form_statement, 9, 0, 75),
  [1537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 73),
  [1539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 73),
  [1541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 72),
  [1543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 72),
  [1545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unless_statement, 9, 0, 71),
  [1547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unless_statement, 9, 0, 71),
  [1549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 8, 0, 0),
  [1551] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 8, 0, 0),
  [1553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_comment, 8, 0, 66),
  [1555] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paired_comment, 8, 0, 66),
  [1557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_statement, 9, 0, 74),
  [1559] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_statement, 9, 0, 74),
  [1561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 73),
  [1563] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 73),
  [1565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_loop_statement, 9, 0, 69),
  [1567] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_loop_statement, 9, 0, 69),
  [1569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 71),
  [1571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 71),
  [1573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_style_statement_repeat1, 1, 0, 11),
  [1575] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_style_statement_repeat1, 1, 0, 11),
  [1577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 1, 0, 12),
  [1579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_stylesheet_statement_repeat1, 1, 0, 12),
  [1581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_javascript_statement_repeat1, 1, 0, 13),
  [1583] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_javascript_statement_repeat1, 1, 0, 13),
  [1585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 2, 0, 34),
  [1587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 2, 0, 34), SHIFT_REPEAT(378),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [1594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1076),
  [1600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1073),
  [1602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(751),
  [1604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(813),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(746),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(842),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(789),
  [1616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 4, 0, 25),
  [1618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(688),
  [1620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [1622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(756),
  [1624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 2, 0, 0),
  [1626] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 2, 0, 0), SHIFT_REPEAT(325),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(691),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(754),
  [1633] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1637] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1175),
  [1639] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1173),
  [1641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(705),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(724),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(786),
  [1647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 2, 0, 8),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [1651] = {.entry = {.count = 1, .reusable = false}}, SHIFT(678),
  [1653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(775),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(776),
  [1657] = {.entry = {.count = 1, .reusable = false}}, SHIFT(770),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(771),
  [1661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(801),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(796),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(796),
  [1669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(769),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(769),
  [1673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(767),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(768),
  [1677] = {.entry = {.count = 1, .reusable = false}}, SHIFT(791),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1208),
  [1693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2, 0, 0),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(785),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(772),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1705] = {.entry = {.count = 1, .reusable = false}}, SHIFT(778),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(766),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(808),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [1717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(798),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(783),
  [1721] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1208),
  [1724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0),
  [1726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 4, 0, 0),
  [1728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 2, 0, 9),
  [1730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(987),
  [1734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [1736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 3, 0, 0),
  [1738] = {.entry = {.count = 1, .reusable = false}}, SHIFT(794),
  [1740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [1742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0),
  [1748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(723),
  [1750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 5, 0, 0),
  [1752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(721),
  [1754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__inline_comment_repeat1, 2, 0, 0),
  [1756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__inline_comment_repeat1, 2, 0, 0), SHIFT_REPEAT(731),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [1769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 5, 0, 38),
  [1771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__if_liq_repeat2, 1, 0, 19),
  [1773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__elsif_aliased, 1, 0, 18),
  [1775] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1125),
  [1777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [1779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(949),
  [1781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1227),
  [1783] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_case_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1243),
  [1786] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1243),
  [1789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1793] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(392),
  [1796] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0),
  [1798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1088),
  [1802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1096),
  [1804] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(688),
  [1807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cycle_statement, 3, 0, 10),
  [1809] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_include_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(1125),
  [1812] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 34), SHIFT_REPEAT(1193),
  [1815] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 34), SHIFT_REPEAT(1193),
  [1818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [1820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(958),
  [1822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(959),
  [1824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1124),
  [1826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1075),
  [1828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(749),
  [1830] = {.entry = {.count = 1, .reusable = false}}, SHIFT(878),
  [1832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(831),
  [1838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1057),
  [1840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(991),
  [1842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(992),
  [1844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(994),
  [1846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(997),
  [1850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(998),
  [1852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(907),
  [1854] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1086),
  [1856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(788),
  [1858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1008),
  [1860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1009),
  [1862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__render_param, 1, 0, 0),
  [1864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1246),
  [1866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1014),
  [1868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1015),
  [1870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(773),
  [1872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1241),
  [1874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__case_liq_repeat1, 1, 0, 0),
  [1876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(732),
  [1878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1068),
  [1880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1074),
  [1882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(905),
  [1886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(806),
  [1888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1165),
  [1890] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_cycle_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(681),
  [1893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(975),
  [1895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1065),
  [1897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1065),
  [1899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1064),
  [1901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1064),
  [1903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(840),
  [1905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(876),
  [1907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(876),
  [1909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(914),
  [1911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1230),
  [1913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1062),
  [1915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(925),
  [1917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(922),
  [1919] = {.entry = {.count = 1, .reusable = false}}, SHIFT(943),
  [1921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(943),
  [1923] = {.entry = {.count = 1, .reusable = false}}, SHIFT(939),
  [1925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(939),
  [1927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1056),
  [1931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__when_aliased, 1, 0, 21),
  [1933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(734),
  [1935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 19),
  [1937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 19),
  [1939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(816),
  [1945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1240),
  [1947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1239),
  [1949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1234),
  [1955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1233),
  [1957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(725),
  [1959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(740),
  [1961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1979] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1228),
  [1981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1228),
  [1983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1991] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1111),
  [1993] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1159),
  [1995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1141),
  [1997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1195),
  [1999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1194),
  [2001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [2003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [2005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [2007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [2009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1237),
  [2011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1237),
  [2013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [2015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [2017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [2019] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1092),
  [2021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1092),
  [2023] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1224),
  [2025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1116),
  [2027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [2029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [2031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [2033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [2035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [2037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [2039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [2041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [2043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [2045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [2047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [2049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [2051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [2053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [2055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [2057] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1161),
  [2059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1161),
  [2061] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1160),
  [2063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1160),
  [2065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [2067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [2069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [2071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [2073] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1152),
  [2075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1153),
  [2077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1150),
  [2079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1151),
  [2081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [2083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [2085] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1139),
  [2087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1140),
  [2089] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1137),
  [2091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1138),
  [2093] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1133),
  [2095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1134),
  [2097] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1129),
  [2099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1130),
  [2101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [2103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1201),
  [2105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1201),
  [2107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(820),
  [2109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(859),
  [2111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1183),
  [2113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1183),
  [2115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [2117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(858),
  [2119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [2121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [2123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [2125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(764),
  [2127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [2129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [2131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [2133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [2135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1118),
  [2137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1119),
  [2139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [2141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [2143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [2145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1115),
  [2147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1115),
  [2149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1229),
  [2151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1229),
  [2153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1114),
  [2155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1114),
  [2157] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_case_statement_repeat1, 1, 0, 0),
  [2159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_statement_repeat1, 1, 0, 0),
  [2161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1231),
  [2163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1231),
  [2165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1112),
  [2167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1113),
  [2169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [2171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [2173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1238),
  [2175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1238),
  [2177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [2179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [2181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [2183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [2185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1087),
  [2187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1080),
  [2189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 28),
  [2191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 27),
  [2193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [2195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [2197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_render_statement, 4, 0, 26),
  [2199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [2201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [2203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1109),
  [2205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1109),
  [2207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [2209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [2211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [2213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [2215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [2217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [2219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [2221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1104),
  [2223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1104),
  [2225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1103),
  [2227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1103),
  [2229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [2231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [2233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [2235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [2237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [2239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [2241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1101),
  [2243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1097),
  [2245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1097),
  [2247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [2249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [2251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [2253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [2255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1095),
  [2257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1095),
  [2259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [2261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [2263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1098),
  [2265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1099),
  [2267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1105),
  [2269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1091),
  [2271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1091),
  [2273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [2275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [2277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [2279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1085),
  [2281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1085),
  [2283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [2285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [2287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [2289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(782),
  [2291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [2293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1059),
  [2295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [2297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [2299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [2301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [2303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [2305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1058),
  [2307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [2309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [2311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section_statement, 2, 0, 0),
  [2313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sections_statement, 2, 0, 0),
  [2315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_increment_statement, 2, 0, 0),
  [2317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decrement_statement, 2, 0, 0),
  [2319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_layout_statement, 2, 0, 0),
  [2321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [2323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [2325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [2327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [2329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [2331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [2333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1249),
  [2335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1245),
  [2337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [2339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [2341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [2343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [2345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [2347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [2349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [2351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [2353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [2355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [2357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [2359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [2361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [2363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [2365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [2367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [2369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [2371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [2373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1120),
  [2375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1117),
  [2377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1205),
  [2379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1205),
  [2381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [2383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [2385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [2387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [2389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [2391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1257),
  [2393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1252),
  [2395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__render_param, 3, 0, 48),
  [2397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [2399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [2401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [2403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [2405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [2407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [2409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [2411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [2413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [2415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [2417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [2419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [2421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [2423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(777),
  [2425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [2427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [2429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [2431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [2433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [2435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [2437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [2439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [2441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [2443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [2445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [2447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [2449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [2451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [2453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [2455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [2457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [2459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [2461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [2463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [2465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [2467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [2469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [2471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [2473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [2475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [2477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [2479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [2481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [2483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [2485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [2487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [2489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [2491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [2493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [2495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [2497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [2499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [2501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [2503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [2505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [2507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [2509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [2511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [2513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [2515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [2517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [2519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [2521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [2523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [2525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [2527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [2529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [2531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [2533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [2535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [2537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [2539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [2541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [2543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [2545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [2547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [2549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [2551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [2553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [2555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [2557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [2559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [2561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [2563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [2565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [2567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [2569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [2571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [2573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [2575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [2577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [2579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [2581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [2583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [2585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [2587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [2589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [2591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [2593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [2595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [2597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(645),
  [2599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [2601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [2603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [2605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [2607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [2609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [2611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [2613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [2615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [2617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [2619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [2621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [2623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [2625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [2627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [2629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [2631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [2633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [2635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [2637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [2639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [2641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [2643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [2645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [2647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [2649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [2651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [2653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [2655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [2657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [2659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [2661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [2663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [2665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [2667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [2669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [2671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [2673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [2675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(896),
  [2677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(897),
  [2679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(898),
  [2681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(899),
  [2683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [2685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [2687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [2689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(984),
  [2691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(983),
  [2693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [2695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [2697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [2699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [2701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [2703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [2705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [2707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [2709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [2711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [2713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 6, 0, 58),
  [2715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1127),
  [2717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(797),
  [2719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [2721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1131),
  [2723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(728),
  [2725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(704),
  [2727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [2729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(846),
  [2731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1072),
  [2733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [2735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1135),
  [2737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(979),
  [2739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [2741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(841),
  [2743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [2745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [2747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [2749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(989),
  [2751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1063),
  [2753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [2755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(993),
  [2757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [2759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(995),
  [2761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(795),
  [2763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(926),
  [2765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [2767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [2769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [2771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1001),
  [2773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1002),
  [2775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(928),
  [2777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [2779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [2781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1007),
  [2783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paginate_liq, 5, 0, 40),
  [2785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1260),
  [2787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1010),
  [2789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1011),
  [2791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1012),
  [2793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1013),
  [2795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1052),
  [2797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(836),
  [2799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1016),
  [2801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1017),
  [2803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [2805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1242),
  [2807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(720),
  [2809] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [2811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [2813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [2815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [2817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [2819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [2821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1027),
  [2823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1028),
  [2825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [2827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1031),
  [2829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1032),
  [2831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [2833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 4, 0, 35),
  [2835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1035),
  [2837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1036),
  [2839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1037),
  [2841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1038),
  [2843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(866),
  [2845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 7),
  [2847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 6),
  [2849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 5),
  [2851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 2),
  [2853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 4),
  [2855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__untagged_paired_statement, 1, 0, 3),
  [2857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1048),
  [2859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1049),
  [2861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1050),
  [2863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1051),
  [2865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1107),
  [2867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1102),
  [2869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 3, 0, 17),
  [2871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(869),
  [2873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1060),
  [2875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1061),
  [2877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [2879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1093),
  [2881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1090),
  [2883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paginate_liq, 6, 0, 57),
  [2885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1077),
  [2887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tablerow_liq, 5, 0, 40),
  [2889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [2891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1225),
  [2893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1222),
  [2895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1078),
  [2897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1082),
  [2899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tablerow_liq, 6, 0, 57),
  [2901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1083),
  [2903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 6, 0, 46),
  [2905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 32),
  [2907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 5, 0, 46),
  [2909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 44),
  [2911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1206),
  [2913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 6, 0, 58),
  [2915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 3, 0, 20),
  [2917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(915),
  [2919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1136),
  [2921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1209),
  [2923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 3, 0, 17),
  [2925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1223),
  [2927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__capture_liq, 3, 0, 22),
  [2929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 3, 0, 23),
  [2931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 6, 0, 57),
  [2933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 6, 0, 56),
  [2935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [2937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1071),
  [2939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(944),
  [2941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 43),
  [2943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 42),
  [2945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1191),
  [2947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1181),
  [2949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 5, 0, 40),
  [2951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(916),
  [2953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1106),
  [2955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 43),
  [2957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(961),
  [2959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(851),
  [2961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 31),
  [2963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1122),
  [2965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [2967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_loop_liq, 7, 0, 67),
  [2969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1197),
  [2971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 5, 0, 42),
  [2973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 5, 0, 44),
  [2975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1128),
  [2977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 33),
  [2979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(948),
  [2981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1213),
  [2983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__if_liq, 4, 0, 32),
  [2985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 4, 0, 36),
  [2987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1251),
  [2989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 31),
  [2991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1053),
  [2993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(947),
  [2995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(985),
  [2997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(823),
  [2999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(913),
  [3001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(792),
  [3003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [3005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1069),
  [3007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(911),
  [3009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [3011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [3013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(843),
  [3015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(988),
  [3017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(972),
  [3019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__form_liq, 4, 0, 23),
  [3021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__capture_liq, 4, 0, 37),
  [3023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [3025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1179),
  [3027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_liq, 5, 0, 45),
  [3029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(956),
  [3031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unless_liq, 4, 0, 33),
  [3033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1212),
  [3035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(729),
  [3037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(706),
  [3039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(962),
  [3041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1255),
  [3043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1256),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__inline_comment_content = 0,
  ts_external_token__paired_comment_content = 1,
  ts_external_token__paired_comment_content_liq = 2,
  ts_external_token_raw_content = 3,
  ts_external_token_front_matter = 4,
  ts_external_token_error_sentinel = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__inline_comment_content] = sym__inline_comment_content,
  [ts_external_token__paired_comment_content] = sym__paired_comment_content,
  [ts_external_token__paired_comment_content_liq] = sym__paired_comment_content_liq,
  [ts_external_token_raw_content] = sym_raw_content,
  [ts_external_token_front_matter] = sym_front_matter,
  [ts_external_token_error_sentinel] = sym_error_sentinel,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__inline_comment_content] = true,
    [ts_external_token__paired_comment_content] = true,
    [ts_external_token__paired_comment_content_liq] = true,
    [ts_external_token_raw_content] = true,
    [ts_external_token_front_matter] = true,
    [ts_external_token_error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_front_matter] = true,
  },
  [3] = {
    [ts_external_token__inline_comment_content] = true,
  },
  [4] = {
    [ts_external_token__paired_comment_content_liq] = true,
  },
  [5] = {
    [ts_external_token__paired_comment_content] = true,
  },
  [6] = {
    [ts_external_token_raw_content] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_liquid_external_scanner_create(void);
void tree_sitter_liquid_external_scanner_destroy(void *);
bool tree_sitter_liquid_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_liquid_external_scanner_serialize(void *, char *);
void tree_sitter_liquid_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_liquid(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_liquid_external_scanner_create,
      tree_sitter_liquid_external_scanner_destroy,
      tree_sitter_liquid_external_scanner_scan,
      tree_sitter_liquid_external_scanner_serialize,
      tree_sitter_liquid_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
