/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
// Copyright (C) 2001-2026 German Aerospace Center (DLR) and others.
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0/
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License 2.0 are satisfied: GNU General Public License, version 2
// or later which is available at
// https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
/****************************************************************************/
/// @file    MSChargingStationExport.cpp
/// @author  Mirko Barthauer
/// @date    2024-07-24
///
// Realises dumping ChargingStation charging events
/****************************************************************************/
#include <config.h>

#include <microsim/MSEdgeControl.h>
#include <microsim/MSEdge.h>
#include <microsim/MSLane.h>
#include <microsim/MSGlobals.h>
#include <utils/iodevices/OutputDevice.h>
#include <microsim/MSNet.h>
#include <microsim/trigger/MSChargingStation.h>
#include <utils/options/OptionsCont.h>
#include "MSChargingStationExport.h"



// ===========================================================================
// method definitions
// ===========================================================================
void
MSChargingStationExport::write(OutputDevice& of, bool end) {
    // loop through charging stations
    bool includeUnfinished = end && OptionsCont::getOptions().getBool("chargingstations-output.aggregated.write-unfinished");
    for (const auto& stop : MSNet::getInstance()->getStoppingPlaces(SUMO_TAG_CHARGING_STATION)) {
        static_cast<MSChargingStation*>(stop.second)->writeAggregatedChargingStationOutput(of, includeUnfinished);
    }
}
