# Contributing

We welcome contributions to **zLMDB**! This guide explains how to get involved.

## Getting in Touch

- **GitHub Issues**: Report bugs or request features at
  https://github.com/crossbario/zlmdb/issues
- **GitHub Discussions**: Ask questions and discuss at
  https://github.com/crossbario/zlmdb/discussions

## Reporting Issues

When reporting issues, please include:

1. Python version (`python --version`)
2. zLMDB version (`python -c "import zlmdb; print(zlmdb.__version__)"`)
3. Operating system and version
4. LMDB version if relevant
5. Minimal code example reproducing the issue
6. Full traceback if applicable

## Contributing Code

1. **Fork the repository** on GitHub
2. **Create a feature branch** from `master`
3. **Make your changes** following the code style
4. **Add tests** for new functionality
5. **Run the test suite** to ensure nothing is broken
6. **Submit a pull request** referencing any related issues

## Development Setup

```bash
git clone https://github.com/crossbario/zlmdb.git
cd zlmdb
pip install -e .[dev]
```

## Running Tests

```bash
# Run all tests
just test

# Run tests in specific venv
just test cpy312
```

## Code Style

- Follow PEP 8
- Use meaningful variable and function names
- Add docstrings for public APIs
- Keep lines under 100 characters

## License

By contributing to zLMDB, you agree that your contributions will be
licensed under the MIT License.
