import { Widget } from '@lumino/widgets';
import { Message } from '@lumino/messaging';
import { ITranslator } from '@jupyterlab/translation';
/**
 * Placeholder widget options
 */
export interface IPlaceholderOptions {
    /**
     * Prompt element CSS class
     */
    promptClass?: string;
    /**
     * Ellipsis button callback
     */
    callback: (e: MouseEvent) => void;
    /**
     * Text to include with the placeholder
     */
    text?: string;
    /**
     * Translator object
     */
    translator?: ITranslator;
}
/**
 * An base class for placeholders
 *
 * ### Notes
 * A placeholder is the element that is shown when input/output
 * is hidden.
 */
export declare class Placeholder extends Widget {
    /**
     * Construct a new placeholder.
     */
    constructor(options: IPlaceholderOptions);
    /**
     * The text displayed in the placeholder.
     */
    set text(t: string);
    get text(): string;
    protected onAfterAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    private _callback;
    private _cell;
    private _textContent;
}
/**
 * The input placeholder class.
 */
export declare class InputPlaceholder extends Placeholder {
    /**
     * Construct a new input placeholder.
     */
    constructor(options: IPlaceholderOptions);
}
/**
 * The output placeholder class.
 */
export declare class OutputPlaceholder extends Placeholder {
    /**
     * Construct a new output placeholder.
     */
    constructor(options: IPlaceholderOptions);
}
