"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateCheckpointModel = exports.validateContentsModel = void 0;
const validate_1 = require("../validate");
/**
 * Validate an `Contents.IModel` object.
 */
function validateContentsModel(model) {
    (0, validate_1.validateProperty)(model, 'name', 'string');
    (0, validate_1.validateProperty)(model, 'path', 'string');
    (0, validate_1.validateProperty)(model, 'type', 'string');
    (0, validate_1.validateProperty)(model, 'created', 'string');
    (0, validate_1.validateProperty)(model, 'last_modified', 'string');
    (0, validate_1.validateProperty)(model, 'mimetype', 'object');
    (0, validate_1.validateProperty)(model, 'content', 'object');
    (0, validate_1.validateProperty)(model, 'format', 'object');
}
exports.validateContentsModel = validateContentsModel;
/**
 * Validate an `Contents.ICheckpointModel` object.
 */
function validateCheckpointModel(model) {
    (0, validate_1.validateProperty)(model, 'id', 'string');
    (0, validate_1.validateProperty)(model, 'last_modified', 'string');
}
exports.validateCheckpointModel = validateCheckpointModel;
//# sourceMappingURL=validate.js.map