amends ".../snippetTest.pkl"

import "pkl:Benchmark"

facts {
  ["run microbenchmark"] {
    local benchmark = new Benchmark.Microbenchmark {
      expression = IntSeq(1, 10).fold(0, (result, next) -> result + next)
      iterations = 3
      iterationTime = 1.ms
      isVerbose = false
    }
    local result = benchmark.run()
    
    result.iterations == 3
    result.repetitions >= 1
    result.samples == null
    result.min > 0.s
    result.max >= result.min
    result.mean >= result.min
    result.mean <= result.max
  }
  
  ["run output benchmark (in verbose mode)"] {
    local benchmark = new Benchmark.OutputBenchmark {
      sourceModule = import("../../input-helper/api/benchmark/moduleToBenchmark.pkl")
      iterations = 3
      iterationTime = 1.ms
      isVerbose = true
    }
    local result = benchmark.run()

    result.iterations == 3
    result.repetitions >= 1
    result.samples != null
    result.samples.length == 3
    result.min == result.samples.min
    result.max == result.samples.max
    result.mean >= result.min
    result.mean <= result.max
  }
  
  ["run parser benchmark"] {
    local benchmark = new Benchmark.ParserBenchmark {
      sourceText = "result = IntSeq(1, 10).fold(0, (result, next) -> result + next)"
      iterations = 3
      iterationTime = 1.ms
      isVerbose = false
    }
    local result = benchmark.run()

    result.iterations == 3
    result.repetitions >= 1
    result.samples == null
    result.min > 0.s
    result.max >= result.min
    result.mean >= result.min
    result.mean <= result.max
  }

  ["evaluate entire benchmark module"] {
    local benchmark = new Benchmark {
      iterations = 3
      iterationTime = 1.ms

      microbenchmarks {
        ["micro"] {
          expression = IntSeq(1, 10).fold(0, (result, next) -> result + next)
        }
      }

      outputBenchmarks {
        ["output"] {
          sourceModule = import("../../input-helper/api/benchmark/moduleToBenchmark.pkl")
        }
      }

      parserBenchmarks {
        ["parser"] {
          sourceText = "result = IntSeq(1, 10).fold(0, (result, next) -> result + next)"
        }
      }
    }

    local text = benchmark.output.text
    text.contains("[\"micro\"]")
    text.contains("[\"output\"]")
    text.contains("[\"parser\"]")
  }
}
