<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/httpcheck/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/httpcheck/metadata.yaml"
sidebar_label: "HTTP Endpoints"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HTTP Endpoints


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: httpcheck

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors HTTP servers availability status and response time.

Possible statuses:

| Status        | Description                                                                                                                                                                                  |
|---------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| success       | HTTP request completed successfully with a status code matching the configured `status_accepted` range (default: 200), and the response body and headers (if configured) match expectations. |
| timeout       | HTTP request timed out before receiving a response (default: 1 second).                                                                                                                      |
| no_connection | Failed to establish a connection to the target.                                                                                                                                              |
| redirect      | Received a redirect response (3xx status code) while `not_follow_redirects` is configured.                                                                                                   |
| bad_status    | HTTP request completed with a status code outside the configured `status_accepted` range (default: non-200).                                                                                 |
| bad_content   | HTTP request completed successfully but the response body does not match the expected content (when using `response_match`).                                                                 |
| bad_header    | HTTP request completed successfully but response headers do not match the expected values (when using `header_match`).                                                                      |




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per target

The metrics refer to the monitored target.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| url | url value that is set in the configuration file. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| httpcheck.response_time | time | ms |
| httpcheck.response_length | length | characters |
| httpcheck.status | success, timeout, redirect, no_connection, bad_content, bad_header, bad_status | boolean |
| httpcheck.in_state | time | boolean |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ httpcheck_web_service_up ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | HTTP check endpoint ${label:url} liveness status |
| [ httpcheck_web_service_bad_content ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | Percentage of HTTP responses from ${label:url} with unexpected content in the last 5 minutes |
| [ httpcheck_web_service_bad_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | Percentage of HTTP responses from ${label:url} with unexpected status in the last 5 minutes |
| [ httpcheck_web_service_bad_header ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | Percentage of HTTP responses from ${label:url} with unexpected header in the last 5 minutes |
| [ httpcheck_web_service_timeouts ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | Percentage of timed-out HTTP requests to ${label:url} in the last 5 minutes |
| [ httpcheck_web_service_no_connection ](https://github.com/netdata/netdata/blob/master/src/health/health.d/httpcheck.conf) | httpcheck.status | Percentage of failed HTTP requests to ${label:url} in the last 5 minutes |


## Setup


You can configure the **httpcheck** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **httpcheck**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/httpcheck.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 5 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. |  | yes |
|  | timeout | HTTP request timeout (seconds). | 1 | no |
| **Validation** | status_accepted | HTTP accepted response statuses. Anything else results in 'bad status' in the status chart. | [200] | no |
|  | response_match | If the status code is accepted, match the response body against this regular expression. |  | no |
|  | header_match | A set of rules to check for specific key-value pairs in response headers. | [] | no |
|  | header_match.exclude | When yes, the rule asserts the key-value pair must be absent. | no | no |
|  | header_match.key | Exact HTTP header name to check. |  | yes |
|  | header_match.value | The [pattern](https://github.com/netdata/netdata/tree/master/src/go/pkg/matcher#supported-format) to match against the header's value. |  | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | cookie_file | Path to cookie file. See [cookie file format](https://everything.curl.dev/http/cookies/fileformat). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **httpcheck** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the httpcheck data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _httpcheck_ (or scroll the list) to locate the **httpcheck** collector.
5. Click the **+** next to the **httpcheck** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/httpcheck.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/httpcheck.conf
```

##### Examples

###### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080

```
</details>

###### With HTTP request headers

Configuration with HTTP request headers that will be sent by the client.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    headers:
      Host: localhost:8080
      User-Agent: netdata/go.d.plugin
      Accept: */*

```
</details>

###### With `status_accepted`

A basic example configuration with non-default status_accepted.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    status_accepted:
      - 200
      - 204

```
</details>

###### With `header_match`

Example configurations with `header_match`. See the value [pattern](https://github.com/netdata/netdata/tree/master/src/go/pkg/matcher#supported-format) syntax.

<details open><summary>Config</summary>

```yaml
jobs:
    # The "X-Robots-Tag" header must be present in the HTTP response header,
    # but the value of the header does not matter.
    # This config checks for the presence of the header regardless of its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag

    # The "X-Robots-Tag" header must be present in the HTTP response header
    # only if its value is equal to "noindex, nofollow".
    # This config checks both the presence of the header and its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        value: '= noindex,nofollow'

    # The "X-Robots-Tag" header must not be present in the HTTP response header
    # but the value of the header does not matter.
    # This config checks for the presence of the header regardless of its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        exclude: yes

    # The "X-Robots-Tag" header must not be present in the HTTP response header
    # only if its value is equal to "noindex, nofollow".
    # This config checks both the presence of the header and its value.
  - name: local
    url: http://127.0.0.1:8080
    header_match:
      - key: X-Robots-Tag
        exclude: yes
        value: '= noindex,nofollow'

```
</details>

###### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080
    username: username
    password: password

```
</details>

###### HTTPS with self-signed certificate

Do not validate server certificate chain and hostname.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:8080
    tls_skip_verify: yes

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080

  - name: remote
    url: http://192.0.2.1:8080

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `httpcheck` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m httpcheck
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m httpcheck -j jobName
  ```

### Getting Logs

If you're encountering problems with the `httpcheck` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep httpcheck
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep httpcheck /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep httpcheck
```


