<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/sensors.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "Sensors"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Sensors


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: GetSensors

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors sensors on Windows systems.


It uses Sensors API to retrieve available data.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Sensor

These metrics refer to Sensors.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| name | Sensor friendly name. |
| manufacturer | The sensor manufacturer. |
| model | The sensor model. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.hw.sensor.temperature.input | input | Cel |
| system.hw.sensor.power.input | input | W |
| system.hw.sensor.current.input | input | A |
| system.hw.sensor.humidity.input | input | % |
| system.hw.sensor.lux.input | input | lx |
| system.hw.sensor.color.input | input | Cel |
| system.hw.sensor.voltage.input | input | V |
| system.hw.sensor.resistence.input | input | Ohms |
| system.hw.sensor.pressure.input | input | Pa |
| system.hw.sensor.latitude.input | input | Degrees |
| system.hw.sensor.longitude.input | input | Degrees |
| system.hw.sensor.force.input | input | N |
| system.hw.sensor.gauge_pressure.input | input | Pa |
| system.hw.sensor.distance.input | inputX, inputY, inputZ | m |
| system.hw.sensor.acceleration.input | inputX, inputY, inputZ | g |
| system.hw.sensor.state.input | ready, not_available, no_data, initializing, access_denied, error | status |
| system.hw.sensor.custom | inputN | nd |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

No action required.

### Configuration

#### Options





| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 1 | no |




#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:GetSensors]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples

###### Specific Sensors

You can add custom sensor information by creating a dedicated sensor section.

```yaml
[plugin:windows:GetSensors:Your Sensor Name]
  units = Speed
  multiplier = 100
  title = Current speed.

```

