<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/nfacct.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/nfacct.plugin/metadata.yaml"
sidebar_label: "Netfilter"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Firewall"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Netfilter


<img src="https://netdata.cloud/img/netfilter.png" width="150"/>


Plugin: nfacct.plugin
Module: nfacct.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Netfilter metrics for optimal packet filtering and manipulation. Keep tabs on packet counts, dropped packets, and error rates to secure network operations.

Netdata uses libmnl (https://www.netfilter.org/projects/libmnl/index.html) to collect information.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

This plugin needs setuid.

### Default Behavior

#### Auto-Detection

This plugin uses socket to connect with netfilter to collect data

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Netfilter instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| netfilter.netlink_new | new, ignore, invalid | connections/s |
| netfilter.netlink_changes | insert, delete, delete_list | changes/s |
| netfilter.netlink_search | searched, search_restart, found | searches/s |
| netfilter.netlink_errors | icmp_error, insert_failed, drop, early_drop | events/s |
| netfilter.netlink_expect | created, deleted, new | expectations/s |
| netfilter.nfacct_packets | a dimension per nfacct object | packets/s |
| netfilter.nfacct_bytes | a dimension per nfacct object | kilobytes/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

#### Install required packages

Install `libmnl-dev` and `libnetfilter-acct-dev` using the package manager of your system.



### Configuration

#### Options



<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 1 | no |
| command options | Additinal parameters for collector |  | no |


</details>



#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:nfacct]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


