/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class websphere_jmx_helper {
    private static MBeanServerConnection mbsc;
    private static JMXConnector jmxc;
    private static String protocolVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            block18: while (true) {
                String string;
                if ((string = bufferedReader.readLine()) == null) {
                    return;
                }
                Map<String, Object> map = websphere_jmx_helper.parseCommand(string);
                String string2 = (String)map.get("command");
                if (string2 == null) {
                    websphere_jmx_helper.sendError("Missing command field", "", true);
                    continue;
                }
                switch (string2) {
                    case "INIT": {
                        websphere_jmx_helper.handleInit(map);
                        continue block18;
                    }
                    case "SCRAPE": {
                        websphere_jmx_helper.handleScrape(map);
                        continue block18;
                    }
                    case "PING": {
                        websphere_jmx_helper.handlePing();
                        continue block18;
                    }
                    case "SHUTDOWN": {
                        websphere_jmx_helper.handleShutdown();
                        return;
                    }
                }
                websphere_jmx_helper.sendError("Unknown command: " + string2, "", true);
            }
        }
        catch (Exception exception) {
            websphere_jmx_helper.sendError("Unhandled exception in main loop", exception.toString(), false);
            return;
        }
        finally {
            websphere_jmx_helper.cleanup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Object> parseCommand(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            string = string.trim();
            if (!string.startsWith("{") || !string.endsWith("}")) {
                return hashMap;
            }
            string = string.substring(1, string.length() - 1);
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            for (int n3 : string.toCharArray()) {
                if (n3 == 34 && n2 != 92) {
                    bl = !bl;
                } else if (!bl) {
                    if (n3 == 123 || n3 == 91) {
                        ++n;
                    } else if (n3 == 125 || n3 == 93) {
                        --n;
                    } else if (n3 == 44 && n == 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        n2 = n3;
                        continue;
                    }
                }
                stringBuilder.append((char)n3);
                n2 = n3;
            }
            if (stringBuilder.length() > 0) {
                arrayList.add(stringBuilder.toString());
            }
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                void var10_15;
                String string2 = (String)object.next();
                int n4 = string2.indexOf(58);
                if (n4 == -1) continue;
                String string3 = string2.substring(0, n4).trim();
                String string4 = string2.substring(n4 + 1).trim();
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    String string5 = string3.substring(1, string3.length() - 1);
                }
                if (string4.startsWith("\"") && string4.endsWith("\"")) {
                    hashMap.put((String)var10_15, string4.substring(1, string4.length() - 1));
                    continue;
                }
                if (string4.equals("true") || string4.equals("false")) {
                    hashMap.put((String)var10_15, Boolean.parseBoolean(string4));
                    continue;
                }
                if (string4.matches("-?\\d+")) {
                    hashMap.put((String)var10_15, Integer.parseInt(string4));
                    continue;
                }
                if (string4.matches("-?\\d+\\.\\d+")) {
                    hashMap.put((String)var10_15, Double.parseDouble(string4));
                    continue;
                }
                if (string4.startsWith("{")) {
                    hashMap.put((String)var10_15, string4);
                    continue;
                }
                hashMap.put((String)var10_15, string4);
            }
        }
        catch (Exception exception) {
            websphere_jmx_helper.sendError("Failed to parse command", exception.toString(), true);
        }
        return hashMap;
    }

    private static void handleInit(Map<String, Object> map) {
        try {
            String string = (String)map.get("jmx_url");
            String string2 = (String)map.get("jmx_username");
            String string3 = (String)map.get("jmx_password");
            String string4 = (String)map.get("jmx_classpath");
            String string5 = (String)map.get("protocol_version");
            if (string5 != null) {
                protocolVersion = string5;
            }
            if (string == null || string.isEmpty()) {
                websphere_jmx_helper.sendError("JMX URL is required", "", false);
                return;
            }
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            if (string2 != null && !string2.isEmpty()) {
                String[] stringArray = new String[]{string2, string3};
                hashMap.put("jmx.remote.credentials", stringArray);
            }
            jmxc = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
            mbsc = jmxc.getMBeanServerConnection();
            websphere_jmx_helper.sendSuccess("JMX connection established", null);
        }
        catch (MalformedURLException malformedURLException) {
            websphere_jmx_helper.sendError("Invalid JMX URL", malformedURLException.toString(), false);
        }
        catch (SecurityException securityException) {
            websphere_jmx_helper.sendError("Authentication failed", securityException.toString(), false);
        }
        catch (IOException iOException) {
            websphere_jmx_helper.sendError("Connection failed", iOException.toString(), false);
        }
        catch (Exception exception) {
            websphere_jmx_helper.sendError("Initialization failed", exception.toString(), false);
        }
    }

    private static void handleScrape(Map<String, Object> map) {
        if (mbsc == null) {
            websphere_jmx_helper.sendError("Not connected to JMX server", "", true);
            return;
        }
        String string = (String)map.get("target");
        if (string == null) {
            websphere_jmx_helper.sendError("Target is required for SCRAPE command", "", true);
            return;
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, List<Map<String, Object>>>();
            switch (string) {
                case "JVM": {
                    hashMap = websphere_jmx_helper.collectJVMMetrics();
                    break;
                }
                case "THREADPOOLS": {
                    hashMap.put("threadPools", websphere_jmx_helper.collectThreadPools(map));
                    break;
                }
                case "JDBC": {
                    hashMap.put("jdbcPools", websphere_jmx_helper.collectJDBCPools(map));
                    break;
                }
                case "JMS": {
                    hashMap.put("jmsDestinations", websphere_jmx_helper.collectJMSDestinations(map));
                    break;
                }
                case "APPLICATIONS": {
                    hashMap.put("applications", websphere_jmx_helper.collectApplications(map));
                    break;
                }
                default: {
                    websphere_jmx_helper.sendError("Unknown scrape target: " + string, "", true);
                    return;
                }
            }
            websphere_jmx_helper.sendSuccess("Metrics collected", hashMap);
        }
        catch (Exception exception) {
            websphere_jmx_helper.sendError("Failed to collect metrics", exception.toString(), true);
        }
    }

    private static Map<String, Object> collectJVMMetrics() throws Exception {
        ObjectName objectName4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ObjectName objectName2 = new ObjectName("java.lang:type=Memory");
        CompositeData compositeData = (CompositeData)mbsc.getAttribute(objectName2, "HeapMemoryUsage");
        CompositeData compositeData2 = (CompositeData)mbsc.getAttribute(objectName2, "NonHeapMemoryUsage");
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("used", compositeData.get("used"));
        hashMap2.put("committed", compositeData.get("committed"));
        hashMap2.put("max", compositeData.get("max"));
        hashMap.put("heap", hashMap2);
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        hashMap3.put("used", compositeData2.get("used"));
        hashMap3.put("committed", compositeData2.get("committed"));
        hashMap.put("nonheap", hashMap3);
        ObjectName objectName3 = new ObjectName("java.lang:type=GarbageCollector,*");
        Set<ObjectName> set = mbsc.queryNames(objectName3, null);
        long l = 0L;
        long l2 = 0L;
        for (ObjectName objectName4 : set) {
            l += ((Long)mbsc.getAttribute(objectName4, "CollectionCount")).longValue();
            l2 += ((Long)mbsc.getAttribute(objectName4, "CollectionTime")).longValue();
        }
        HashMap hashMap4 = new HashMap();
        hashMap4.put("count", l);
        hashMap4.put("time", l2);
        hashMap.put("gc", hashMap4);
        objectName4 = new ObjectName("java.lang:type=Threading");
        HashMap<String, Object> hashMap5 = new HashMap<String, Object>();
        hashMap5.put("count", mbsc.getAttribute(objectName4, "ThreadCount"));
        hashMap5.put("daemon", mbsc.getAttribute(objectName4, "DaemonThreadCount"));
        hashMap5.put("peak", mbsc.getAttribute(objectName4, "PeakThreadCount"));
        hashMap5.put("totalStarted", mbsc.getAttribute(objectName4, "TotalStartedThreadCount"));
        hashMap.put("threads", hashMap5);
        ObjectName objectName5 = new ObjectName("java.lang:type=ClassLoading");
        HashMap<String, Object> hashMap6 = new HashMap<String, Object>();
        hashMap6.put("loaded", mbsc.getAttribute(objectName5, "LoadedClassCount"));
        hashMap6.put("unloaded", mbsc.getAttribute(objectName5, "UnloadedClassCount"));
        hashMap.put("classes", hashMap6);
        return hashMap;
    }

    private static List<Map<String, Object>> collectThreadPools(Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = websphere_jmx_helper.getMaxItems(map);
        ObjectName objectName = new ObjectName("WebSphere:type=ThreadPool,*");
        Set<ObjectName> set = mbsc.queryNames(objectName, null);
        int n2 = 0;
        for (ObjectName objectName2 : set) {
            if (n > 0 && n2 >= n) break;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", objectName2.getKeyProperty("name"));
            hashMap.put("poolSize", mbsc.getAttribute(objectName2, "poolSize"));
            hashMap.put("activeCount", mbsc.getAttribute(objectName2, "activeCount"));
            hashMap.put("maximumPoolSize", mbsc.getAttribute(objectName2, "maximumPoolSize"));
            arrayList.add(hashMap);
            ++n2;
        }
        return arrayList;
    }

    private static List<Map<String, Object>> collectJDBCPools(Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = websphere_jmx_helper.getMaxItems(map);
        ObjectName objectName = new ObjectName("WebSphere:type=ConnectionPool,*");
        Set<ObjectName> set = mbsc.queryNames(objectName, null);
        int n2 = 0;
        for (ObjectName objectName2 : set) {
            if (n > 0 && n2 >= n) break;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", objectName2.getKeyProperty("name"));
            hashMap.put("poolSize", mbsc.getAttribute(objectName2, "poolSize"));
            hashMap.put("numConnectionsUsed", mbsc.getAttribute(objectName2, "numConnectionsUsed"));
            hashMap.put("numConnectionsFree", mbsc.getAttribute(objectName2, "numConnectionsFree"));
            hashMap.put("avgWaitTime", mbsc.getAttribute(objectName2, "avgWaitTime"));
            hashMap.put("avgInUseTime", mbsc.getAttribute(objectName2, "avgInUseTime"));
            hashMap.put("numConnectionsCreated", mbsc.getAttribute(objectName2, "numConnectionsCreated"));
            hashMap.put("numConnectionsDestroyed", mbsc.getAttribute(objectName2, "numConnectionsDestroyed"));
            arrayList.add(hashMap);
            ++n2;
        }
        return arrayList;
    }

    private static List<Map<String, Object>> collectJMSDestinations(Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = websphere_jmx_helper.getMaxItems(map);
        ObjectName objectName = new ObjectName("WebSphere:type=JMSDestination,*");
        Set<ObjectName> set = mbsc.queryNames(objectName, null);
        int n2 = 0;
        for (ObjectName objectName2 : set) {
            if (n > 0 && n2 >= n) break;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", objectName2.getKeyProperty("name"));
            hashMap.put("type", objectName2.getKeyProperty("destinationType"));
            hashMap.put("messagesCurrentCount", mbsc.getAttribute(objectName2, "messagesCurrentCount"));
            hashMap.put("messagesPendingCount", mbsc.getAttribute(objectName2, "messagesPendingCount"));
            hashMap.put("messagesAddedCount", mbsc.getAttribute(objectName2, "messagesAddedCount"));
            hashMap.put("consumerCount", mbsc.getAttribute(objectName2, "consumerCount"));
            arrayList.add(hashMap);
            ++n2;
        }
        return arrayList;
    }

    private static List<Map<String, Object>> collectApplications(Map<String, Object> map) throws Exception {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        int n = websphere_jmx_helper.getMaxItems(map);
        Map map2 = (Map)map.get("collect_options");
        boolean bl = map2 != null && Boolean.TRUE.equals(map2.get("sessions"));
        boolean bl2 = map2 != null && Boolean.TRUE.equals(map2.get("transactions"));
        ObjectName objectName = new ObjectName("WebSphere:type=Application,*");
        Set<ObjectName> set = mbsc.queryNames(objectName, null);
        int n2 = 0;
        for (ObjectName objectName2 : set) {
            if (n > 0 && n2 >= n) break;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", objectName2.getKeyProperty("name"));
            hashMap.put("requestCount", mbsc.getAttribute(objectName2, "requestCount"));
            hashMap.put("errorCount", mbsc.getAttribute(objectName2, "errorCount"));
            hashMap.put("avgResponseTime", mbsc.getAttribute(objectName2, "avgResponseTime"));
            hashMap.put("maxResponseTime", mbsc.getAttribute(objectName2, "maxResponseTime"));
            if (bl) {
                hashMap.put("activeSessions", mbsc.getAttribute(objectName2, "activeSessions"));
                hashMap.put("liveSessions", mbsc.getAttribute(objectName2, "liveSessions"));
                hashMap.put("invalidatedSessions", mbsc.getAttribute(objectName2, "invalidatedSessions"));
            }
            if (bl2) {
                hashMap.put("activeTransactions", mbsc.getAttribute(objectName2, "activeTransactions"));
                hashMap.put("committedTransactions", mbsc.getAttribute(objectName2, "committedTransactions"));
                hashMap.put("rolledbackTransactions", mbsc.getAttribute(objectName2, "rolledbackTransactions"));
                hashMap.put("timedoutTransactions", mbsc.getAttribute(objectName2, "timedoutTransactions"));
            }
            arrayList.add(hashMap);
            ++n2;
        }
        return arrayList;
    }

    private static void handlePing() {
        if (mbsc == null) {
            websphere_jmx_helper.sendError("Not connected to JMX server", "", true);
            return;
        }
        try {
            String string = mbsc.getDefaultDomain();
            websphere_jmx_helper.sendSuccess("Connection is healthy", null);
        }
        catch (Exception exception) {
            websphere_jmx_helper.sendError("Connection test failed", exception.toString(), true);
        }
    }

    private static void handleShutdown() {
        websphere_jmx_helper.cleanup();
        websphere_jmx_helper.sendSuccess("Shutting down", null);
    }

    private static void cleanup() {
        if (jmxc != null) {
            try {
                jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        mbsc = null;
        jmxc = null;
    }

    private static int getMaxItems(Map<String, Object> map) {
        Object object = map.get("max_items");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    private static void sendSuccess(String string, Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("status", "OK");
        hashMap.put("message", string);
        if (map != null) {
            hashMap.put("data", map);
        }
        websphere_jmx_helper.sendResponse(hashMap);
    }

    private static void sendError(String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("status", "ERROR");
        hashMap.put("message", string);
        if (string2 != null && !string2.isEmpty()) {
            hashMap.put("details", string2);
        }
        hashMap.put("recoverable", bl);
        websphere_jmx_helper.sendResponse(hashMap);
    }

    private static void sendResponse(Map<String, Object> map) {
        try {
            System.out.println(websphere_jmx_helper.toJson(map));
            System.out.flush();
        }
        catch (Exception exception) {
            System.err.println("Failed to send response: " + exception.toString());
        }
    }

    private static String toJson(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + websphere_jmx_helper.escapeJson((String)object) + "\"";
        }
        if (object instanceof Number || object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            StringBuilder stringBuilder = new StringBuilder("{");
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\"").append(websphere_jmx_helper.escapeJson((String)entry.getKey())).append("\":");
                stringBuilder.append(websphere_jmx_helper.toJson(entry.getValue()));
                bl = false;
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        if (object instanceof List) {
            List list = (List)object;
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean bl = true;
            for (Object e : list) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(websphere_jmx_helper.toJson(e));
                bl = false;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return "\"" + websphere_jmx_helper.escapeJson(object.toString()) + "\"";
    }

    private static String escapeJson(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    static {
        protocolVersion = "1.0";
    }
}

