/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.handler.manager;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.Type;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;

@Named
@Singleton
public class DefaultArtifactHandlerManager
extends AbstractEventSpy
implements ArtifactHandlerManager {
    private final TypeRegistry typeRegistry;
    private final ConcurrentHashMap<String, ArtifactHandler> allHandlers;

    @Inject
    public DefaultArtifactHandlerManager(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "null typeRegistry");
        this.allHandlers = new ConcurrentHashMap();
    }

    @Override
    public void onEvent(Object event) {
        ExecutionEvent executionEvent;
        if (event instanceof ExecutionEvent && (executionEvent = (ExecutionEvent)event).getType() == ExecutionEvent.Type.SessionEnded) {
            this.allHandlers.clear();
        }
    }

    @Override
    public ArtifactHandler getArtifactHandler(String id) {
        return this.allHandlers.computeIfAbsent(id, k -> {
            Type type = this.typeRegistry.require(id);
            return new DefaultArtifactHandler(id, type.getExtension(), type.getClassifier(), null, null, type.isIncludesDependencies(), type.getLanguage().id(), type.getPathTypes().contains(JavaPathType.CLASSES));
        });
    }

    @Override
    public void addHandlers(Map<String, ArtifactHandler> handlers) {
        throw new UnsupportedOperationException("Adding handlers programmatically is not supported anymore");
    }

    @Deprecated
    public Set<String> getHandlerTypes() {
        throw new UnsupportedOperationException("Querying handlers programmatically is not supported anymore");
    }
}

