// init script created from
// - cc256xb_bt_sp_v1.8/initscripts-TIInit_6.7.16_bt_spec_4.1.bts
// - AKA TIInit_6.7.16.bts
// - cc256xb_bt_sp_v1.8/initscripts-TIInit_6.7.16_ble_add-on.bts
#include <stdint.h>
#include "btstack_chipset_cc256x.h"


const uint16_t cc256x_init_script_lmp_subversion = 0x1b90;

uint16_t btstack_chipset_cc256x_lmp_subversion(void){
    return cc256x_init_script_lmp_subversion;
}

#if defined(__GNUC__) && defined(__MSP430X__) && (__MSP430X__ > 0)
__attribute__((section (".fartext")))
#endif
#ifdef __AVR__
__attribute__((__progmem__))
#endif
const uint8_t cc256x_init_script[] = {

    // #--------------------------------------------------------------------------------
    // # Description : Orca L PG 2.0 ROM Initialization Script
    // #
    // # Compatibility: Orca, 7.0.16 ROM
    // #
    // # Last Updated: 10-Jun-2019  11:42:14.51
    // #
    // # Version     : TI_P7_16.42
    // #
    // #
    // #
    // #
    // # Notes       : Use this script on Orca L PG 2.0, 7.0.16 ROM device only (FW v7.0.16)
    // #--------------------------------------------------------------------------------
    // 
    // #################################################################
    // ## START of CC256x Add-On
    // #################################################################
    // 
    // ## Change UART baudrate
    // 
    // #################################################################
    // ## END of CC256x Add-On
    // #################################################################
    // 
    0x01, 0x37, 0xfe, 0x02, 0x07, 0x10, 

    // 
    // 
    0x01, 0x05, 0xff, 0xff, 0x40, 0x61, 0x08, 0x00, 0xfa, 0x07, 0x10, 0x47, 0x2a, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xb5, 0x00, 0x90, 0x47, 0x68, 0xff, 0x20, 0x26, 0x30, 0xc0, 
    0x5d, 0x00, 0x28, 0x26, 0xd0, 0x01, 0x38, 0x1d, 0xd0, 0x01, 0x38, 0x2a, 0xd1, 0xff, 0x24, 
    0x95, 0x34, 0xe5, 0x19, 0x29, 0x88, 0x08, 0x20, 0x01, 0x26, 0xb6, 0x46, 0x37, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0x00, 0x29, 0x01, 0xd1, 0x02, 0x20, 0x07, 0xe0, 0xe5, 0x19, 0x29, 0x88, 
    0x08, 0x20, 0xb6, 0x46, 0x31, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x48, 0x1c, 0xe9, 0x88, 0x0c, 
    0x1c, 0x44, 0x43, 0x60, 0x2c, 0x0f, 0xd9, 0x0f, 0xe0, 0xff, 0x20, 0x99, 0x30, 0xc0, 0x5b, 
    0x5e, 0x28, 0x09, 0xdb, 0xc4, 0x1c, 0x08, 0xe0, 0xff, 0x20, 0xed, 0x30, 0xc4, 0x5b, 0x10, 
    0x2c, 0x02, 0xdd, 0x06, 0x20, 0x44, 0x43, 0x00, 0xe0, 0x60, 0x24, 0x41, 0x20, 0x00, 0x21, 
    0x01, 0x22, 0x96, 0x46, 0x1c, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x01, 0x90, 0x61, 0x08, 0x40, 
    0x18, 0x01, 0x30, 0x80, 0x01, 0x80, 0x09, 0x02, 0x90, 0x18, 0x4d, 0x00, 0x26, 0xa8, 0x7b, 
    0x00, 0x28, 0x1f, 0xd0, 0x28, 0x7c, 0x39, 0x78, 0x81, 0x42, 0x1b, 0xd1, 0x15, 0x48, 0x00, 
    0x2e, 0x00, 0xd0, 0x14, 0x30, 0x00, 0x68, 0x80, 0x06, 0x80, 0x0e, 0x01, 0x99, 0x08, 0x18, 
    0x80, 0x01, 0x80, 0x09, 0x02, 0x99, 0x01, 0x22, 0x96, 0x46, 0x0f, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0x29, 0x7b, 0x03, 0x91, 0x01, 0x22, 0x96, 0x46, 0x0c, 0x4a, 0xfe, 0x44, 0x10, 0x47, 
    0x02, 0x28, 0x01, 0xda, 

    0x01, 0x05, 0xff, 0xff, 0x3a, 0x62, 0x08, 0x00, 0xfa, 0x03, 0x98, 0x04, 0x19, 0x28, 0x35, 
    0x01, 0x36, 0x02, 0x2e, 0xd8, 0xd3, 0x00, 0x98, 0x44, 0x60, 0x07, 0x48, 0x33, 0x30, 0x00, 
    0x90, 0xff, 0xbd, 0xc0, 0x46, 0x93, 0xe4, 0x04, 0x00, 0x38, 0x1d, 0x08, 0x00, 0x0c, 0x05, 
    0x1a, 0x00, 0x39, 0x7a, 0x04, 0x00, 0xad, 0x45, 0x05, 0x00, 0x7b, 0xbf, 0x02, 0x00, 0xad, 
    0x45, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xb5, 0x01, 0x24, 0xa6, 0x46, 0xdb, 0x48, 0xfe, 0x44, 
    0x00, 0x47, 0x06, 0x1c, 0xda, 0x4d, 0x28, 0x68, 0xda, 0x49, 0x09, 0x88, 0x08, 0x18, 0x80, 
    0x01, 0x80, 0x09, 0x31, 0x1c, 0xa6, 0x46, 0xd7, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 
    0x0c, 0xd4, 0xd6, 0x48, 0x00, 0x78, 0x04, 0x28, 0x08, 0xd1, 0xd5, 0x48, 0x00, 0x78, 0x03, 
    0x28, 0x04, 0xd1, 0x2e, 0x60, 0xa6, 0x46, 0xe4, 0x48, 0xfe, 0x44, 0x00, 0x47, 0xe3, 0x4d, 
    0x28, 0x68, 0x19, 0x21, 0x49, 0x01, 0x08, 0x18, 0x80, 0x01, 0x80, 0x09, 0x31, 0x1c, 0xa6, 
    0x46, 0xca, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0x4c, 0xd4, 0x2e, 0x60, 0xdd, 0x48, 
    0x01, 0x78, 0xdd, 0x48, 

    0x01, 0x05, 0xff, 0xff, 0x34, 0x63, 0x08, 0x00, 0xfa, 0x00, 0x88, 0x08, 0x43, 0x1a, 0xd0, 
    0x00, 0x29, 0x18, 0xd0, 0x22, 0x21, 0xe4, 0x48, 0x20, 0x22, 0x12, 0x5c, 0x01, 0x2a, 0x12, 
    0xd1, 0x09, 0x5c, 0x00, 0x29, 0x0f, 0xd0, 0x41, 0x7f, 0x08, 0x29, 0x0c, 0xd1, 0x09, 0x21, 
    0x41, 0x77, 0xdf, 0x48, 0x03, 0x21, 0xa6, 0x46, 0xde, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x04, 
    0x20, 0xa6, 0x46, 0xdd, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x00, 0x25, 0x68, 0x1c, 0x00, 0x04, 
    0x00, 0x0c, 0xa6, 0x46, 0xda, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x00, 0x28, 0x1d, 0xd0, 0x81, 
    0x7c, 0x0a, 0x02, 0xc1, 0x7c, 0x11, 0x43, 0x0a, 0x02, 0x01, 0x7d, 0x11, 0x43, 0x0a, 0x02, 
    0x41, 0x7d, 0x11, 0x43, 0x00, 0x91, 0x69, 0x1c, 0x00, 0x78, 0xa8, 0x22, 0x42, 0x43, 0xd2, 
    0x48, 0x80, 0x5c, 0x40, 0x00, 0xcf, 0x4a, 0x12, 0x5a, 0xd1, 0x48, 0x40, 0x5d, 0xcf, 0x4b, 
    0x1b, 0x56, 0x7b, 0x20, 0x80, 0x00, 0xa6, 0x46, 0xcf, 0x4e, 0xfe, 0x44, 0x30, 0x47, 0x01, 
    0x35, 0x07, 0x2d, 0xd5, 0xdb, 0xe5, 0x48, 0x00, 0x68, 0x50, 0x28, 0x05, 0xd9, 0xe4, 0x48, 
    0x00, 0x21, 0xa6, 0x46, 0xc1, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x78, 0xbd, 0x30, 0xb5, 0x05, 
    0x1c, 0x9c, 0x4c, 0x7e, 0x34, 0xa0, 0x78, 0x03, 0x28, 0x0f, 0xd1, 0x20, 0x88, 0x00, 0x28, 
    0x0c, 0xd1, 0xe8, 0x69, 0x02, 0x28, 0x09, 0xd1, 0x01, 0x20, 0x86, 0x46, 0xda, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0x02, 0x20, 0xa0, 0x70, 0xd8, 0x48, 0xca, 0x30, 0x28, 0x62, 0x30, 0xbd, 
    0xf8, 0xb5, 0x06, 0x1c, 0xb7, 0x69, 0xb0, 0x8a, 0x00, 0x90, 0xe4, 0x49, 0x40, 0x1a, 0x0a, 
    0xd0, 0x97, 0x38, 0x51, 0xd0, 0x8c, 0x38, 0x45, 0xd0, 0x01, 0x38, 0x3c, 0xd0, 0x22, 0x38, 
    0x2b, 0xd0, 0x01, 0x38, 

    0x01, 0x05, 0xff, 0xff, 0x2e, 0x64, 0x08, 0x00, 0xfa, 0x25, 0xd0, 0xf8, 0xbd, 0x21, 0x20, 
    0xc5, 0x5d, 0x38, 0x1c, 0x00, 0x21, 0x01, 0x24, 0xa6, 0x46, 0xdc, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0x7d, 0x21, 0xc9, 0x00, 0x41, 0x43, 0xd8, 0x48, 0x01, 0x60, 0x00, 0x2d, 0x41, 0xd0, 
    0xff, 0x2d, 0x3f, 0xd0, 0x38, 0x1c, 0x29, 0x1c, 0xa6, 0x46, 0xd5, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0xd5, 0x48, 0x02, 0x21, 0xa6, 0x46, 0xd4, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 
    0x0e, 0xd1, 0xce, 0x48, 0xd2, 0x49, 0x09, 0x68, 0x01, 0x60, 0x09, 0xe0, 0x01, 0x20, 0xd1, 
    0x49, 0x08, 0x80, 0x05, 0xe0, 0x38, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xe6, 0x49, 0xfe, 0x44, 
    0x08, 0x47, 0x38, 0x1c, 0x00, 0x99, 0x00, 0x22, 0x01, 0x23, 0x9e, 0x46, 0xe3, 0x4b, 0xfe, 
    0x44, 0x18, 0x47, 0x0c, 0xe0, 0x38, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xe0, 0x49, 0xfe, 0x44, 
    0x08, 0x47, 0x05, 0xe0, 0x38, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xde, 0x49, 0xfe, 0x44, 0x08, 
    0x47, 0xdd, 0x48, 0x9e, 0x30, 0x30, 0x62, 0xf8, 0xbd, 0x01, 0x24, 0xa6, 0x46, 0xdb, 0x48, 
    0xfe, 0x44, 0x00, 0x47, 0xa6, 0x46, 0xda, 0x48, 0xfe, 0x44, 0x00, 0x47, 0xf8, 0xbd, 0x70, 
    0xb5, 0x85, 0x69, 0x00, 0x7d, 0x44, 0x21, 0x40, 0x1a, 0x01, 0x28, 0x26, 0xd9, 0x0f, 0x38, 
    0x0c, 0xd0, 0x28, 0x38, 0x2b, 0xd1, 0x28, 0x78, 0x03, 0x28, 0x28, 0xd1, 0x3b, 0x20, 0xc0, 
    0x43, 0x05, 0x21, 0x49, 0x57, 0x81, 0x42, 0x22, 0xdd, 0x68, 0x71, 0x70, 0xbd, 0x28, 0x78, 
    0x00, 0x28, 0x1d, 0xd1, 0xcd, 0x4e, 0x30, 0x1c, 0x01, 0x24, 0xa6, 0x46, 0xcc, 0x49, 0xfe, 
    0x44, 0x08, 0x47, 0xa8, 0x70, 0xe8, 0x1c, 0x31, 0x1c, 0x0a, 0x22, 0xa6, 0x46, 0xc9, 0x4b, 
    0xfe, 0x44, 0x18, 0x47, 

    0x01, 0x05, 0xff, 0xff, 0x28, 0x65, 0x08, 0x00, 0xfa, 0x28, 0x1c, 0xa6, 0x46, 0xc7, 0x49, 
    0xfe, 0x44, 0x08, 0x47, 0x70, 0xbd, 0x46, 0x48, 0x00, 0x78, 0x04, 0x28, 0x04, 0xd1, 0x01, 
    0x20, 0x86, 0x46, 0xbe, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x70, 0xbd, 0x70, 0xb5, 0x04, 0x1c, 
    0x66, 0x69, 0x20, 0x7f, 0x17, 0x22, 0x80, 0x1a, 0x3e, 0x4d, 0x24, 0xd0, 0x68, 0x38, 0x34, 
    0xd1, 0xff, 0x20, 0x7d, 0x30, 0x80, 0x5d, 0x0d, 0x28, 0x2f, 0xd1, 0x20, 0x69, 0x01, 0x78, 
    0x30, 0x1c, 0x01, 0x24, 0xa6, 0x46, 0xda, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x01, 0x1c, 0x25, 
    0xd0, 0x08, 0x68, 0xb0, 0x42, 0x22, 0xd1, 0x77, 0x3d, 0x28, 0x78, 0x01, 0x28, 0x1e, 0xd0, 
    0x08, 0x79, 0x00, 0x28, 0x1b, 0xd0, 0xd4, 0x4d, 0x2c, 0x70, 0x4d, 0x20, 0xa6, 0x46, 0xd3, 
    0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x20, 0x28, 0x70, 0x70, 0xbd, 0x82, 0x3d, 0x28, 0x78, 
    0x05, 0x28, 0x0d, 0xdb, 0xff, 0x20, 0x79, 0x30, 0x81, 0x5d, 0x30, 0x1c, 0x24, 0x23, 0x01, 
    0x25, 0xae, 0x46, 0xcb, 0x4d, 0xfe, 0x44, 0x28, 0x47, 0xcc, 0x48, 0xca, 0x49, 0x08, 0x18, 
    0x20, 0x62, 0x70, 0xbd, 0x70, 0xb5, 0x05, 0x1c, 0x2c, 0x69, 0xa2, 0x8e, 0x23, 0x8f, 0x93, 
    0x42, 0x32, 0xdd, 0xc7, 0x48, 0x01, 0x78, 0x60, 0x8d, 0x01, 0x30, 0x41, 0x43, 0x08, 0x04, 
    0x00, 0x0c, 0x82, 0x42, 0x29, 0xda, 0xc6, 0x26, 0x31, 0x5d, 0xc9, 0x09, 0x25, 0xd1, 0x10, 
    0x1a, 0xc1, 0x49, 0x08, 0x18, 0x83, 0x42, 0x20, 0xdd, 0xc5, 0x20, 0x00, 0x5d, 0x01, 0x28, 
    0x01, 0xd0, 0x03, 0x28, 0x1a, 0xd1, 0x30, 0x5d, 0x01, 0x28, 0x05, 0xd1, 0xce, 0x21, 0x09, 
    0x5d, 0x10, 0x29, 0x04, 0xd0, 0x11, 0x29, 0x02, 0xd0, 0x02, 0x28, 0x0a, 0xd0, 0x70, 0xbd, 
    0xb5, 0x20, 0x00, 0x5d, 

    0x01, 0x05, 0xff, 0xff, 0x22, 0x66, 0x08, 0x00, 0xfa, 0x00, 0x21, 0x01, 0x22, 0x96, 0x46, 
    0xb4, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x02, 0x20, 0x30, 0x55, 0xb3, 0x49, 0x97, 0x20, 0xc0, 
    0x00, 0x40, 0x18, 0x28, 0x62, 0x70, 0xbd, 0xc0, 0x46, 0x47, 0x76, 0x04, 0x00, 0x5c, 0x61, 
    0x08, 0x00, 0x4a, 0x61, 0x08, 0x00, 0x39, 0x7a, 0x04, 0x00, 0x45, 0x10, 0x08, 0x00, 0x2c, 
    0x24, 0x08, 0x00, 0x70, 0xb5, 0x02, 0x69, 0xd4, 0x8e, 0x15, 0x8f, 0xa5, 0x42, 0x1a, 0xdd, 
    0xc8, 0x21, 0x8b, 0x5c, 0x40, 0x21, 0x19, 0x40, 0xde, 0x11, 0xf6, 0x01, 0x31, 0x43, 0x12, 
    0xd1, 0x2c, 0x1b, 0x52, 0x49, 0x86, 0x31, 0x09, 0x78, 0x09, 0x02, 0x8c, 0x42, 0x0b, 0xdd, 
    0x02, 0x2b, 0x09, 0xd1, 0xc7, 0x21, 0x89, 0x5c, 0x01, 0x29, 0x01, 0xd0, 0x03, 0x29, 0x03, 
    0xd1, 0xde, 0x49, 0xdc, 0x4a, 0x51, 0x18, 0x01, 0x62, 0x70, 0xbd, 0xc1, 0x6b, 0x08, 0x00, 
    0x58, 0x61, 0x08, 0x00, 0x84, 0x18, 0x08, 0x00, 0x46, 0x61, 0x08, 0x00, 0x30, 0xb5, 0xd8, 
    0x49, 0xd8, 0x4a, 0x13, 0x32, 0x1f, 0x20, 0x00, 0x23, 0x01, 0x24, 0xa6, 0x46, 0xd6, 0x4d, 
    0xfe, 0x44, 0x28, 0x47, 0xd7, 0x48, 0x00, 0x88, 0x40, 0x0a, 0x00, 0xd2, 0x00, 0x24, 0xd3, 
    0x48, 0x04, 0x70, 0x30, 0xbd, 0xc0, 0x46, 0x50, 0x17, 0x08, 0x00, 0x00, 0x04, 0x1a, 0x00, 
    0xb5, 0xf5, 0x04, 0x00, 0xf9, 0x15, 0x05, 0x00, 0xd9, 0x8f, 0x01, 0x00, 0x20, 0x0c, 0x1a, 
    0x00, 0xcd, 0x18, 0x08, 0x00, 0x78, 0x20, 0x08, 0x00, 0x59, 0x15, 0x08, 0x00, 0x85, 0x87, 
    0x04, 0x00, 0xf0, 0xb5, 0x06, 0x1c, 0x35, 0x69, 0x30, 0x7e, 0x00, 0x28, 0x1d, 0xd1, 0xc7, 
    0x27, 0x78, 0x5d, 0x01, 0x28, 0x19, 0xd1, 0x28, 0x1c, 0x01, 0x21, 0x0c, 0x1c, 0x8e, 0x46, 
    0xc2, 0x4a, 0xfe, 0x44, 

    0x01, 0x05, 0xff, 0xff, 0x1c, 0x67, 0x08, 0x00, 0xfa, 0x10, 0x47, 0x28, 0x1c, 0xa6, 0x46, 
    0xba, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xc8, 0x21, 0x48, 0x5d, 0x1b, 0x28, 0x06, 0xd1, 0xcd, 
    0x20, 0x40, 0x5d, 0x01, 0x28, 0x02, 0xd1, 0x00, 0x20, 0x78, 0x55, 0x48, 0x55, 0xe7, 0x48, 
    0x3a, 0x30, 0x30, 0x62, 0xe6, 0x49, 0xe5, 0x4a, 0x5d, 0x32, 0x1f, 0x20, 0x00, 0x23, 0x01, 
    0x24, 0xa6, 0x46, 0xb1, 0x4c, 0xfe, 0x44, 0x20, 0x47, 0xf0, 0xbd, 0xc0, 0x46, 0xc8, 0x62, 
    0x08, 0x00, 0xf8, 0x21, 0x19, 0x00, 0x3f, 0x83, 0x02, 0x00, 0x11, 0x24, 0x03, 0x00, 0x10, 
    0xb5, 0x61, 0x4b, 0x1b, 0x78, 0x40, 0x8d, 0x01, 0x30, 0x43, 0x43, 0x1c, 0x04, 0x24, 0x0c, 
    0x5e, 0x4b, 0x91, 0x42, 0x07, 0xdb, 0x88, 0x1a, 0x19, 0x1b, 0x88, 0x42, 0x0c, 0xdd, 0x01, 
    0x21, 0x09, 0x04, 0x40, 0x1a, 0x10, 0xbd, 0xa1, 0x42, 0x02, 0xda, 0x18, 0x1b, 0x82, 0x42, 
    0x01, 0xdc, 0x88, 0x1a, 0x10, 0xbd, 0x88, 0x1a, 0x18, 0x18, 0x10, 0xbd, 0xc0, 0x46, 0x06, 
    0xfd, 0x00, 0x00, 0xbc, 0x62, 0x08, 0x00, 0x51, 0x2a, 0x00, 0x00, 0xc9, 0x67, 0x08, 0x00, 
    0x04, 0x50, 0x1a, 0x00, 0x6b, 0xf7, 0x04, 0x00, 0x6c, 0x4f, 0x08, 0x00, 0x62, 0x61, 0x08, 
    0x00, 0xf8, 0xb5, 0x0d, 0x1c, 0x06, 0x1c, 0x00, 0x90, 0x01, 0x24, 0xa6, 0x46, 0xc3, 0x49, 
    0xfe, 0x44, 0x08, 0x47, 0x30, 0x1c, 0x03, 0x21, 0xa6, 0x46, 0xe5, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0x07, 0x1c, 0xe4, 0x4e, 0x35, 0x80, 0x00, 0x98, 0x07, 0x21, 0xa6, 0x46, 0xe9, 0x4a, 
    0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0x01, 0xd1, 0x68, 0x08, 0x70, 0x80, 0xe6, 0x48, 0x02, 
    0x21, 0xa6, 0x46, 0xe6, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0x07, 0xd1, 0x38, 0x1c, 
    0x68, 0x43, 0xe3, 0x49, 

    0x01, 0x05, 0xff, 0xff, 0x16, 0x68, 0x08, 0x00, 0xfa, 0x08, 0x60, 0xa6, 0x46, 0xde, 0x49, 
    0xfe, 0x44, 0x08, 0x47, 0xf8, 0xbd, 0xc0, 0x46, 0x81, 0x6b, 0x08, 0x00, 0xa9, 0x25, 0x05, 
    0x00, 0x71, 0x70, 0x08, 0x00, 0x05, 0x71, 0x08, 0x00, 0x7d, 0x5e, 0x00, 0x00, 0xc9, 0x6e, 
    0x08, 0x00, 0xfd, 0x6f, 0x08, 0x00, 0x60, 0x12, 0x08, 0x00, 0xed, 0x2f, 0x01, 0x00, 0x09, 
    0x59, 0x05, 0x00, 0x51, 0xbc, 0x04, 0x00, 0xf8, 0xb5, 0x00, 0x90, 0x45, 0x69, 0x68, 0x7c, 
    0x10, 0x28, 0x11, 0xd1, 0x28, 0x7c, 0xd2, 0x49, 0x06, 0x28, 0x0b, 0xd0, 0x0a, 0x88, 0x01, 
    0x2a, 0x0a, 0xd1, 0x01, 0x28, 0x01, 0xd0, 0x00, 0x20, 0x05, 0xe0, 0x00, 0x20, 0x08, 0x80, 
    0x03, 0x20, 0x28, 0x74, 0x01, 0xe0, 0x01, 0x20, 0x08, 0x80, 0x68, 0x7c, 0x0d, 0x28, 0x1b, 
    0xd1, 0x28, 0x7c, 0x00, 0x28, 0x18, 0xd1, 0xc7, 0x4f, 0x02, 0x26, 0x38, 0x1c, 0x01, 0x24, 
    0xa6, 0x46, 0xc6, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x03, 0xe0, 0xa6, 0x46, 0xc4, 0x49, 0xfe, 
    0x44, 0x08, 0x47, 0x00, 0x28, 0x06, 0xd0, 0x01, 0x7a, 0x0d, 0x29, 0xf6, 0xd1, 0xc1, 0x49, 
    0x4c, 0x31, 0x00, 0x98, 0x01, 0x62, 0x0c, 0x37, 0x01, 0x3e, 0xe8, 0xd1, 0x68, 0x7c, 0x06, 
    0x28, 0x0a, 0xd1, 0x28, 0x7c, 0xbd, 0x49, 0x06, 0x28, 0x04, 0xd0, 0x08, 0x88, 0x01, 0x28, 
    0x03, 0xd1, 0x00, 0x20, 0x00, 0xe0, 0x01, 0x20, 0x08, 0x80, 0xf8, 0xbd, 0x69, 0x7d, 0x02, 
    0x00, 0x64, 0x61, 0x08, 0x00, 0x93, 0xe4, 0x04, 0x00, 0x85, 0xf8, 0x00, 0x00, 0x18, 0x0f, 
    0x00, 0x00, 0x1d, 0xe4, 0x00, 0x00, 0x2e, 0x2e, 0x08, 0x00, 0xff, 0xff, 0x00, 0x00, 0xcb, 
    0xa3, 0x00, 0x00, 0xed, 0x92, 0x00, 0x00, 0xf8, 0xb5, 0x00, 0x90, 0x82, 0x69, 0x51, 0x78, 
    0xc7, 0x69, 0x0b, 0x1f, 

    0x01, 0x05, 0xff, 0xff, 0x10, 0x69, 0x08, 0x00, 0xfa, 0x70, 0xd0, 0x21, 0x3b, 0xe6, 0x48, 
    0x33, 0xd0, 0x01, 0x3b, 0x73, 0xd1, 0x04, 0x23, 0xbb, 0x80, 0x0c, 0x23, 0xde, 0x19, 0x49, 
    0x00, 0x12, 0x78, 0x0a, 0x43, 0x32, 0x70, 0x01, 0x36, 0x00, 0x78, 0x00, 0x28, 0x02, 0xd1, 
    0x06, 0x25, 0x28, 0x1c, 0x01, 0xe0, 0x07, 0x20, 0x06, 0x25, 0x30, 0x70, 0x01, 0x36, 0x30, 
    0x1c, 0x0d, 0x21, 0x01, 0x24, 0xa6, 0x46, 0xde, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x06, 0x1c, 
    0xa6, 0x46, 0xdd, 0x48, 0xfe, 0x44, 0x00, 0x47, 0xc0, 0x06, 0xc0, 0x0e, 0x81, 0x02, 0xd9, 
    0x48, 0x00, 0x78, 0x40, 0x06, 0x40, 0x0e, 0x08, 0x43, 0x07, 0x21, 0xc9, 0x01, 0x01, 0x43, 
    0x09, 0x04, 0x09, 0x0c, 0x30, 0x1c, 0xa6, 0x46, 0xd2, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x30, 
    0xe0, 0x04, 0x23, 0xbb, 0x80, 0x0c, 0x23, 0xde, 0x19, 0x49, 0x00, 0x12, 0x78, 0x0a, 0x43, 
    0x32, 0x70, 0x01, 0x36, 0x00, 0x78, 0x00, 0x28, 0x02, 0xd1, 0x06, 0x25, 0x28, 0x1c, 0x01, 
    0xe0, 0x07, 0x20, 0x06, 0x25, 0x30, 0x70, 0x01, 0x36, 0x30, 0x1c, 0x0d, 0x21, 0x01, 0x24, 
    0xa6, 0x46, 0xc5, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x06, 0x1c, 0xa6, 0x46, 0xc4, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0xc0, 0x06, 0xc0, 0x0e, 0x81, 0x02, 0xc0, 0x48, 0x00, 0x78, 0x40, 0x06, 
    0x40, 0x0e, 0x08, 0x43, 0x07, 0x21, 0xc9, 0x01, 0x01, 0x43, 0x09, 0x04, 0x09, 0x0c, 0x30, 
    0x1c, 0xa6, 0x46, 0xb9, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x7d, 0x80, 0x03, 0x20, 0x38, 0x80, 
    0xba, 0x48, 0xb9, 0x49, 0x09, 0x18, 0x00, 0x98, 0x01, 0x62, 0xf8, 0xbd, 0x10, 0x79, 0x27, 
    0x28, 0x04, 0xd1, 0x50, 0x79, 0x1e, 0x28, 0x01, 0xd1, 0x23, 0x20, 0x50, 0x71, 0xf8, 0xbd, 
    0xc0, 0x46, 0x82, 0x04, 

    0x01, 0x05, 0xff, 0xff, 0x0a, 0x6a, 0x08, 0x00, 0xfa, 0x00, 0x00, 0x45, 0x9f, 0x00, 0x00, 
    0x3f, 0x72, 0x08, 0x00, 0xa9, 0x86, 0x00, 0x00, 0x11, 0x72, 0x08, 0x00, 0x55, 0x31, 0x19, 
    0x00, 0x3e, 0xa6, 0x1b, 0x00, 0x89, 0x83, 0x00, 0x00, 0xf0, 0xb5, 0x06, 0x1c, 0xf4, 0x69, 
    0x22, 0x88, 0x10, 0x04, 0x00, 0x0e, 0x01, 0x02, 0x25, 0x20, 0x00, 0x02, 0x09, 0x1a, 0x9c, 
    0x48, 0x32, 0xd0, 0x05, 0x23, 0x9b, 0x02, 0xc9, 0x1a, 0x10, 0xd0, 0x1b, 0x20, 0x00, 0x02, 
    0x09, 0x1a, 0x43, 0xd1, 0x10, 0x06, 0x00, 0x0e, 0x04, 0x28, 0x3f, 0xd1, 0x60, 0x7a, 0x01, 
    0x21, 0x8e, 0x46, 0xcf, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x00, 0x28, 0x2d, 0xd0, 0xf0, 0xbd, 
    0xc0, 0x78, 0x00, 0x28, 0x33, 0xd0, 0x20, 0x1c, 0x01, 0x24, 0xa6, 0x46, 0xca, 0x49, 0xfe, 
    0x44, 0x08, 0x47, 0xc9, 0x4d, 0x2f, 0x1c, 0xc9, 0x48, 0x00, 0x78, 0x01, 0x28, 0x01, 0xd1, 
    0x00, 0x2f, 0x06, 0xd1, 0xaf, 0x42, 0x1f, 0xd2, 0xa6, 0x46, 0xc6, 0x48, 0xfe, 0x44, 0x00, 
    0x47, 0x1a, 0xe0, 0xa6, 0x46, 0xc6, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x01, 0x3f, 0xec, 0xe7, 
    0x21, 0x78, 0xa8, 0x22, 0x4a, 0x43, 0xc3, 0x4b, 0x9a, 0x5c, 0x00, 0x2a, 0x11, 0xd0, 0xc0, 
    0x38, 0x00, 0x78, 0x00, 0x28, 0x0d, 0xd1, 0xc0, 0x48, 0x40, 0x5c, 0x07, 0x28, 0x09, 0xdb, 
    0x20, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xbe, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xb8, 0x48, 0xb7, 
    0x49, 0x08, 0x18, 0x30, 0x62, 0xf0, 0xbd, 0xc0, 0x46, 0xad, 0x99, 0x00, 0x00, 0xff, 0x72, 
    0x08, 0x00, 0xb1, 0x2f, 0x00, 0x00, 0x30, 0xb5, 0x05, 0x69, 0xb7, 0x48, 0x00, 0x21, 0x01, 
    0x24, 0xa6, 0x46, 0x2a, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xb5, 0x49, 0x01, 0x28, 0x01, 0xd0, 
    0x00, 0x20, 0x01, 0xe0, 

    0x01, 0x05, 0xff, 0xff, 0x04, 0x6b, 0x08, 0x00, 0xfa, 0x08, 0x68, 0x01, 0x30, 0x08, 0x60, 
    0xa6, 0x46, 0xae, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x28, 0x08, 0xd0, 0xa6, 0x46, 0xe5, 
    0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x28, 0x02, 0xd0, 0x02, 0x20, 0xe3, 0x49, 0x08, 0x80, 
    0xe3, 0x49, 0xe8, 0x68, 0x88, 0x42, 0x22, 0xd1, 0xe2, 0x48, 0x00, 0x78, 0x80, 0x08, 0x1e, 
    0xd2, 0xe2, 0x48, 0x41, 0x7f, 0x05, 0x29, 0x1a, 0xd1, 0x02, 0x21, 0x41, 0x77, 0xde, 0x48, 
    0x00, 0x78, 0xe8, 0x70, 0x59, 0x48, 0xc1, 0x38, 0x00, 0x78, 0xff, 0x28, 0x05, 0xd1, 0xe6, 
    0x48, 0x03, 0x21, 0xa6, 0x46, 0xe6, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xe1, 0x4d, 0x2c, 0x80, 
    0xa6, 0x46, 0xe1, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x2c, 0x80, 0xa6, 0x46, 0xde, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0x30, 0xbd, 0x65, 0x2a, 0x00, 0x00, 0x00, 0x50, 0x1a, 0x00, 0x00, 0xb5, 
    0x00, 0x21, 0x01, 0x22, 0x96, 0x46, 0xdc, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xda, 0x49, 0x08, 
    0x80, 0x00, 0xbd, 0xcd, 0x16, 0x03, 0x00, 0x51, 0x2a, 0x00, 0x00, 0x04, 0x50, 0x1a, 0x00, 
    0x6b, 0xf7, 0x04, 0x00, 0x6c, 0x4f, 0x08, 0x00, 0x44, 0x61, 0x08, 0x00, 0x5c, 0x18, 0x08, 
    0x00, 0x4f, 0x0c, 0x04, 0x00, 0x5b, 0x0c, 0x04, 0x00, 0x89, 0x3f, 0x04, 0x00, 0x46, 0x61, 
    0x08, 0x00, 0xf8, 0xb5, 0xcf, 0x48, 0x00, 0x88, 0xc0, 0x08, 0xce, 0x4c, 0x22, 0x88, 0xd4, 
    0x49, 0x8a, 0x42, 0x39, 0xd0, 0xd4, 0x49, 0x09, 0x78, 0x03, 0x29, 0x35, 0xd1, 0x61, 0x88, 
    0x8d, 0x1a, 0xca, 0x4a, 0x83, 0x1a, 0x88, 0x42, 0x02, 0xd5, 0x00, 0x22, 0xd7, 0x43, 0x00, 
    0xe0, 0x01, 0x27, 0x00, 0x2d, 0x02, 0xd5, 0x00, 0x22, 0xd6, 0x43, 0x00, 0xe0, 0x01, 0x26, 
    0xc4, 0x4a, 0x12, 0x78, 

    0x01, 0x05, 0xff, 0xff, 0xfe, 0x6b, 0x08, 0x00, 0xfa, 0x96, 0x46, 0xc3, 0x4a, 0x12, 0x78, 
    0x94, 0x46, 0x01, 0x22, 0x00, 0x92, 0xc2, 0x4a, 0xb7, 0x42, 0x11, 0xd1, 0x76, 0x46, 0x36, 
    0x06, 0x36, 0x16, 0x5e, 0x43, 0x67, 0x46, 0x3e, 0x41, 0x00, 0x2d, 0x04, 0xdc, 0x00, 0x2b, 
    0x0b, 0xdd, 0x12, 0x78, 0x96, 0x19, 0x08, 0xe0, 0x00, 0x2b, 0x06, 0xdc, 0x12, 0x78, 0xb6, 
    0x1a, 0x03, 0xe0, 0x16, 0x78, 0x00, 0x2b, 0x00, 0xdc, 0x76, 0x42, 0xb7, 0x4a, 0x12, 0x78, 
    0xb5, 0x4b, 0x1a, 0x70, 0x02, 0xe0, 0x61, 0x88, 0x00, 0x26, 0x00, 0x96, 0xb6, 0x4a, 0x12, 
    0x68, 0x13, 0x1c, 0x73, 0x43, 0x1b, 0x15, 0x21, 0x80, 0x60, 0x80, 0xe2, 0x48, 0x00, 0x78, 
    0x31, 0x1c, 0x00, 0xda, 0x49, 0x42, 0x81, 0x42, 0x04, 0xdd, 0x00, 0x2e, 0x00, 0xd5, 0x40, 
    0x42, 0x50, 0x43, 0x03, 0x15, 0x0f, 0x4d, 0x41, 0x3d, 0xe8, 0x6f, 0x1e, 0x18, 0xdb, 0x48, 
    0x00, 0x78, 0x50, 0x43, 0x00, 0x0d, 0xb1, 0x1a, 0x00, 0xda, 0x49, 0x42, 0x81, 0x42, 0x19, 
    0xd8, 0x00, 0x98, 0x00, 0x28, 0x16, 0xd0, 0xd6, 0x48, 0x00, 0x78, 0x00, 0x28, 0x12, 0xd0, 
    0xd5, 0x48, 0x02, 0x21, 0x01, 0x24, 0xa6, 0x46, 0xd4, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 
    0x28, 0x09, 0xd1, 0x02, 0xe0, 0xc0, 0x46, 0x31, 0x4f, 0x08, 0x00, 0xee, 0x67, 0x30, 0x1c, 
    0xa6, 0x46, 0xcf, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xf8, 0xbd, 0xc0, 0x46, 0xe7, 0x2a, 0x00, 
    0x00, 0xfb, 0x4f, 0x08, 0x00, 0x89, 0x91, 0x04, 0x00, 0xca, 0x04, 0x00, 0x00, 0x61, 0xde, 
    0x00, 0x00, 0xf0, 0xb5, 0x05, 0x1c, 0xae, 0x69, 0xef, 0x69, 0x38, 0x88, 0xdf, 0x49, 0x40, 
    0x1a, 0x3e, 0xd0, 0xde, 0x49, 0x40, 0x1a, 0x01, 0x28, 0x2f, 0xd9, 0x25, 0x38, 0x51, 0xd1, 
    0xdd, 0x48, 0x00, 0x88, 

    0x01, 0x05, 0xff, 0xff, 0xf8, 0x6c, 0x08, 0x00, 0xfa, 0x00, 0x28, 0x4d, 0xd0, 0x30, 0x1c, 
    0x01, 0x24, 0xa6, 0x46, 0xd9, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xff, 0x20, 0x1c, 0x30, 0x81, 
    0x5d, 0x00, 0x29, 0x01, 0xd1, 0x02, 0x21, 0x81, 0x55, 0xff, 0x21, 0x1e, 0x31, 0x89, 0x5d, 
    0x00, 0x29, 0x04, 0xd1, 0x82, 0x5d, 0x01, 0x2a, 0x01, 0xd0, 0x00, 0x2a, 0x06, 0xd1, 0x01, 
    0x29, 0x0a, 0xd1, 0x80, 0x5d, 0x03, 0x28, 0x07, 0xd0, 0x02, 0x28, 0x05, 0xd0, 0x30, 0x1c, 
    0xa6, 0x46, 0xec, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x24, 0xe0, 0x30, 0x1c, 0xa6, 0x46, 0xea, 
    0x49, 0xfe, 0x44, 0x08, 0x47, 0x1e, 0xe0, 0x3a, 0x20, 0x80, 0x5d, 0x00, 0x28, 0x1f, 0xd0, 
    0x38, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0x19, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x13, 0xe0, 0xe1, 
    0x48, 0x00, 0x78, 0x05, 0x28, 0x14, 0xdb, 0xff, 0x20, 0x26, 0x30, 0x82, 0x5d, 0x30, 0x1c, 
    0x07, 0x21, 0x00, 0x23, 0x01, 0x24, 0xa6, 0x46, 0xdf, 0x4e, 0xfe, 0x44, 0x30, 0x47, 0x38, 
    0x1c, 0xa6, 0x46, 0x0e, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xda, 0x49, 0x5f, 0x20, 0x00, 0x01, 
    0x40, 0x18, 0x28, 0x62, 0xf0, 0xbd, 0xc0, 0x46, 0x0b, 0x34, 0x04, 0x00, 0xf3, 0x1a, 0x02, 
    0x00, 0xa0, 0x86, 0x01, 0x00, 0x0f, 0x54, 0x08, 0x00, 0x0f, 0x1a, 0x02, 0x00, 0x42, 0x05, 
    0x00, 0x00, 0xd9, 0xa3, 0x02, 0x00, 0x17, 0x8f, 0x03, 0x00, 0xc8, 0x18, 0x08, 0x00, 0x50, 
    0x15, 0x08, 0x00, 0x8d, 0x08, 0x04, 0x00, 0x19, 0xde, 0x01, 0x00, 0xf8, 0x21, 0x19, 0x00, 
    0xc8, 0x62, 0x08, 0x00, 0xf0, 0xb5, 0x85, 0xb0, 0x07, 0x1c, 0xb8, 0x69, 0x04, 0x90, 0xb9, 
    0x8a, 0xe9, 0x48, 0x08, 0x1a, 0x26, 0xd0, 0xe9, 0x49, 0x40, 0x1a, 0x5e, 0xd1, 0xe8, 0x4d, 
    0xc4, 0x48, 0x00, 0x78, 

    0x01, 0x05, 0xff, 0xff, 0xf2, 0x6d, 0x08, 0x00, 0xfa, 0x02, 0x28, 0x59, 0xd1, 0x01, 0x24, 
    0xa6, 0x46, 0xe6, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x28, 0x52, 0xd1, 0xa6, 0x46, 0xe4, 
    0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x28, 0x4c, 0xd1, 0xa6, 0x46, 0x27, 0x48, 0xfe, 0x44, 
    0x00, 0x47, 0x00, 0x28, 0x46, 0xd1, 0x28, 0x78, 0x00, 0x28, 0x43, 0xd1, 0xa8, 0x78, 0x00, 
    0x28, 0x40, 0xd1, 0xa6, 0x20, 0xa6, 0x46, 0xdb, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x3a, 0xe0, 
    0x04, 0x98, 0x00, 0x21, 0x6a, 0x46, 0x01, 0x24, 0xa6, 0x46, 0xd8, 0x4b, 0xfe, 0x44, 0x18, 
    0x47, 0x02, 0xa8, 0x00, 0x21, 0x06, 0x22, 0xa6, 0x46, 0xd5, 0x4b, 0xfe, 0x44, 0x18, 0x47, 
    0x00, 0x25, 0x02, 0xe0, 0x68, 0x1c, 0x05, 0x04, 0x2d, 0x0c, 0xd2, 0x48, 0x00, 0x78, 0x85, 
    0x42, 0x22, 0xda, 0x11, 0x20, 0x40, 0x01, 0x68, 0x43, 0xd0, 0x49, 0x0e, 0x18, 0x10, 0x20, 
    0x80, 0x19, 0x69, 0x46, 0xa6, 0x46, 0xce, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0xea, 
    0xd1, 0x68, 0x46, 0x02, 0xa9, 0xa6, 0x46, 0xca, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 
    0xe2, 0xd0, 0xb0, 0x78, 0x01, 0x28, 0xdf, 0xd0, 0x04, 0x98, 0xbb, 0x49, 0x3a, 0x22, 0xa6, 
    0x46, 0xc5, 0x4b, 0xfe, 0x44, 0x18, 0x47, 0xc4, 0x48, 0xe2, 0x30, 0x38, 0x62, 0x05, 0xb0, 
    0xf0, 0xbd, 0xc0, 0x46, 0xcd, 0x33, 0x04, 0x00, 0x4a, 0x24, 0x19, 0x00, 0x7b, 0x86, 0x03, 
    0x00, 0x11, 0x22, 0x08, 0x00, 0x4a, 0x56, 0x08, 0x00, 0x50, 0x17, 0x08, 0x00, 0x10, 0xb5, 
    0x15, 0x4c, 0x0c, 0x48, 0x04, 0x80, 0x01, 0x20, 0x86, 0x46, 0xb9, 0x48, 0xfe, 0x44, 0x00, 
    0x47, 0xb9, 0x49, 0x08, 0x60, 0x09, 0x48, 0x04, 0x80, 0x44, 0x80, 0x10, 0xbd, 0xc0, 0x46, 
    0x82, 0x07, 0x1a, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0xec, 0x6e, 0x08, 0x00, 0xfa, 0xf9, 0x8e, 0x03, 0x00, 0x00, 0x04, 
    0x1a, 0x00, 0xb5, 0xf5, 0x04, 0x00, 0x60, 0x61, 0x08, 0x00, 0x51, 0x2a, 0x00, 0x00, 0x50, 
    0x1d, 0x18, 0x00, 0x54, 0x61, 0x08, 0x00, 0x68, 0x10, 0x00, 0x00, 0x4e, 0x61, 0x08, 0x00, 
    0x4f, 0x61, 0x08, 0x00, 0x52, 0x61, 0x08, 0x00, 0x4d, 0x61, 0x08, 0x00, 0x4c, 0x61, 0x08, 
    0x00, 0xff, 0xff, 0x00, 0x00, 0x2c, 0x24, 0x08, 0x00, 0xbc, 0x62, 0x08, 0x00, 0xf0, 0xb5, 
    0x06, 0x1c, 0x35, 0x69, 0xd5, 0x27, 0x7f, 0x00, 0xb1, 0x69, 0x00, 0x29, 0x52, 0xd0, 0x8a, 
    0x88, 0x50, 0x18, 0x52, 0x18, 0x13, 0x7a, 0x5a, 0x08, 0xf8, 0x2b, 0x01, 0xd3, 0x43, 0x7a, 
    0x00, 0xe0, 0x00, 0x23, 0x00, 0x7a, 0xc0, 0x07, 0xc0, 0x0f, 0x84, 0x46, 0x39, 0x20, 0x40, 
    0x5d, 0x9c, 0x4c, 0x25, 0x28, 0x01, 0xd1, 0x13, 0x2a, 0x32, 0xd0, 0x0a, 0x28, 0x03, 0xd1, 
    0x0f, 0x2a, 0x25, 0xd0, 0x13, 0x2a, 0x23, 0xd0, 0x3a, 0x20, 0x40, 0x5d, 0x20, 0x28, 0x01, 
    0xd1, 0x19, 0x2b, 0x13, 0xd0, 0x18, 0x2a, 0x2f, 0xd1, 0x24, 0x28, 0x2d, 0xd1, 0x78, 0x5d, 
    0x02, 0x28, 0x05, 0xd1, 0x28, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0x8c, 0x49, 0xfe, 0x44, 0x08, 
    0x47, 0x28, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0x8a, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xf0, 0xbd, 
    0xff, 0x20, 0x6d, 0x30, 0x40, 0x19, 0x01, 0x22, 0x96, 0x46, 0x86, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0xf6, 0x34, 0x12, 0xe0, 0x28, 0x1c, 0x61, 0x46, 0x24, 0x23, 0x01, 0x25, 0xae, 0x46, 
    0x83, 0x4d, 0xfe, 0x44, 0x28, 0x47, 0x08, 0xe0, 0x28, 0x1c, 0x61, 0x46, 0x13, 0x22, 0x24, 
    0x23, 0x01, 0x25, 0xae, 0x46, 0x7e, 0x4d, 0xfe, 0x44, 0x28, 0x47, 0xec, 0x34, 0x34, 0x62, 
    0xf0, 0xbd, 0x51, 0x61, 

    0x01, 0x05, 0xff, 0xff, 0xe6, 0x6f, 0x08, 0x00, 0xfa, 0x08, 0x00, 0x53, 0x61, 0x08, 0x00, 
    0x50, 0x61, 0x08, 0x00, 0x04, 0x50, 0x1a, 0x00, 0x6b, 0xf7, 0x04, 0x00, 0xcd, 0x16, 0x03, 
    0x00, 0x78, 0xb5, 0x00, 0x26, 0x00, 0x96, 0x01, 0x24, 0xa6, 0x46, 0x74, 0x48, 0xfe, 0x44, 
    0x00, 0x47, 0x73, 0x4d, 0xa8, 0x6d, 0x69, 0x46, 0xa6, 0x46, 0x72, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0x17, 0x21, 0x00, 0x98, 0x01, 0x70, 0xa8, 0x6d, 0x00, 0x99, 0x32, 0x1c, 0xa6, 0x46, 
    0x6e, 0x4b, 0xfe, 0x44, 0x18, 0x47, 0x6e, 0x4d, 0x0c, 0x20, 0xa8, 0x81, 0x28, 0x69, 0x40, 
    0x88, 0x0c, 0x28, 0x0c, 0xd0, 0x01, 0x26, 0xb6, 0x02, 0x00, 0x2e, 0x08, 0xd0, 0xa6, 0x46, 
    0x69, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x01, 0x3e, 0x28, 0x69, 0x40, 0x88, 0x0c, 0x28, 0xf4, 
    0xd1, 0xa6, 0x46, 0x65, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x78, 0xbd, 0x03, 0x08, 0x00, 0x00, 
    0xf0, 0xf4, 0x00, 0x00, 0x05, 0x68, 0x03, 0x00, 0x62, 0x61, 0x08, 0x00, 0xf0, 0xb5, 0x87, 
    0xb0, 0x06, 0x90, 0x5f, 0x48, 0x07, 0x68, 0x01, 0x24, 0xa6, 0x46, 0x56, 0x48, 0xfe, 0x44, 
    0x00, 0x47, 0x5c, 0x4e, 0x30, 0x1c, 0x01, 0x30, 0xc0, 0x5d, 0x6d, 0x46, 0x28, 0x71, 0xf0, 
    0x5d, 0x68, 0x71, 0xa8, 0x1d, 0x0b, 0x21, 0xc9, 0x01, 0xc9, 0x59, 0xa6, 0x46, 0x57, 0x4a, 
    0xfe, 0x44, 0x10, 0x47, 0xaf, 0x21, 0xc9, 0x00, 0xc9, 0x59, 0xa6, 0x46, 0x53, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0x57, 0x21, 0x09, 0x01, 0xc9, 0x59, 0xa6, 0x46, 0x50, 0x4a, 0xfe, 0x44, 
    0x10, 0x47, 0x22, 0x3e, 0xf1, 0x59, 0xa6, 0x46, 0x4d, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xa6, 
    0x46, 0x48, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x12, 0x20, 0x28, 0x70, 0x06, 0x98, 0x49, 0x49, 
    0x00, 0x22, 0x01, 0xab, 

    0x01, 0x05, 0xff, 0xff, 0xe0, 0x70, 0x08, 0x00, 0xfa, 0xa6, 0x46, 0x48, 0x4c, 0xfe, 0x44, 
    0x20, 0x47, 0x07, 0xb0, 0xf0, 0xbd, 0xc3, 0x0f, 0x08, 0x00, 0x17, 0x08, 0x05, 0x00, 0x35, 
    0xf7, 0x01, 0x00, 0xd9, 0xe5, 0x01, 0x00, 0x1d, 0x42, 0x02, 0x00, 0x45, 0x10, 0x08, 0x00, 
    0xf8, 0xb5, 0x00, 0x90, 0x3a, 0x48, 0x07, 0x68, 0x01, 0x25, 0xae, 0x46, 0x31, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0x00, 0x24, 0x37, 0x4e, 0x30, 0x1c, 0x32, 0x38, 0xc4, 0x51, 0x30, 0x1c, 
    0x2a, 0x38, 0xc4, 0x51, 0x30, 0x1c, 0x22, 0x38, 0xc4, 0x51, 0xb1, 0x20, 0xc0, 0x00, 0xc4, 
    0x51, 0x30, 0x1c, 0x1a, 0x38, 0xc4, 0x51, 0x59, 0x20, 0x00, 0x01, 0xc4, 0x51, 0x30, 0x1c, 
    0x12, 0x38, 0xc4, 0x51, 0x08, 0x20, 0xc0, 0x19, 0x04, 0x21, 0xae, 0x46, 0x2e, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0xb3, 0x20, 0xc0, 0x00, 0xc4, 0x51, 0x57, 0x20, 0x00, 0x01, 0xc4, 0x51, 
    0xaf, 0x20, 0xc0, 0x00, 0xc4, 0x51, 0x0b, 0x20, 0xc0, 0x01, 0xc4, 0x51, 0x01, 0x3e, 0xf4, 
    0x55, 0xae, 0x46, 0x1f, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x98, 0x21, 0x49, 0x01, 0x39, 
    0x22, 0x1c, 0xae, 0x46, 0x22, 0x4b, 0xfe, 0x44, 0x18, 0x47, 0xf8, 0xbd, 0x05, 0x04, 0x00, 
    0x00, 0x19, 0x1c, 0x00, 0x00, 0xc1, 0x0f, 0x08, 0x00, 0x99, 0x51, 0x03, 0x00, 0x9b, 0x33, 
    0x03, 0x00, 0x89, 0xe4, 0x04, 0x00, 0x81, 0x2a, 0x00, 0x00, 0x15, 0x5f, 0x05, 0x00, 0x33, 
    0x4f, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x81, 0x94, 0x03, 0x00, 0xd9, 0x3e, 0x02, 0x00, 
    0x25, 0x00, 0x00, 0x00, 0x47, 0x76, 0x04, 0x00, 0x5c, 0x61, 0x08, 0x00, 0x91, 0x74, 0x04, 
    0x00, 0x91, 0xf7, 0x01, 0x00, 0x8b, 0x09, 0x04, 0x00, 0x8b, 0xf7, 0x00, 0x00, 0x85, 0xf8, 
    0x00, 0x00, 0x47, 0x15, 

    0x01, 0x05, 0xff, 0xff, 0xda, 0x71, 0x08, 0x00, 0xfa, 0x05, 0x00, 0x14, 0x54, 0x08, 0x00, 
    0xbd, 0x59, 0x05, 0x00, 0xe7, 0x59, 0x05, 0x00, 0x14, 0x24, 0x08, 0x00, 0x21, 0x8f, 0x03, 
    0x00, 0x85, 0x26, 0x04, 0x00, 0xdc, 0x50, 0x08, 0x00, 0xa6, 0x05, 0x00, 0x00, 0xd5, 0x2a, 
    0x00, 0x00, 0x2a, 0xfe, 0x00, 0x00, 0x1d, 0x26, 0x05, 0x00, 0x99, 0x94, 0x03, 0x00, 0xa9, 
    0x25, 0x05, 0x00, 0x40, 0x1e, 0x80, 0x00, 0xd8, 0x4b, 0x19, 0x50, 0xd6, 0x49, 0x0a, 0x50, 
    0xf7, 0x46, 0x00, 0xb5, 0xd6, 0x4a, 0x01, 0x8b, 0x91, 0x42, 0x07, 0xd0, 0x40, 0x69, 0x40, 
    0x30, 0x2c, 0x21, 0x01, 0x22, 0x96, 0x46, 0xec, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xeb, 0x48, 
    0x2b, 0x30, 0x00, 0xbd, 0xfc, 0xb5, 0x01, 0x90, 0x45, 0x69, 0x00, 0x24, 0xb8, 0x20, 0x40, 
    0x5d, 0x01, 0x28, 0x37, 0xd1, 0xc7, 0x26, 0x70, 0x5d, 0x01, 0x28, 0x0d, 0xd0, 0x03, 0x28, 
    0x0b, 0xd0, 0x28, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xea, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xbf, 
    0x20, 0x40, 0x5d, 0x01, 0x28, 0x27, 0xd1, 0x6c, 0x8d, 0x25, 0xe0, 0xc0, 0x20, 0x44, 0x55, 
    0x77, 0x5d, 0x74, 0x55, 0x28, 0x1c, 0x01, 0x21, 0x8e, 0x46, 0xe2, 0x49, 0xfe, 0x44, 0x08, 
    0x47, 0x77, 0x55, 0xbf, 0x26, 0x70, 0x5d, 0x01, 0x28, 0x16, 0xd1, 0xe9, 0x8e, 0x2a, 0x8f, 
    0x28, 0x1c, 0x01, 0x23, 0x9e, 0x46, 0xdd, 0x4b, 0xfe, 0x44, 0x18, 0x47, 0x00, 0x04, 0x00, 
    0x0c, 0x04, 0x28, 0x06, 0xdd, 0x6c, 0x8d, 0xc0, 0x1e, 0x84, 0x42, 0x06, 0xdb, 0x04, 0x04, 
    0x24, 0x0c, 0x03, 0xe0, 0x03, 0x21, 0xc0, 0x20, 0x41, 0x55, 0x74, 0x55, 0x28, 0x8d, 0x61, 
    0x1c, 0x41, 0x43, 0x08, 0x04, 0x00, 0x0c, 0x01, 0x99, 0x88, 0x61, 0xd1, 0x49, 0xfc, 0x39, 
    0x09, 0x78, 0xc9, 0x09, 

    0x01, 0x05, 0xff, 0xff, 0xd4, 0x72, 0x08, 0x00, 0xfa, 0x10, 0xd3, 0x2e, 0x8d, 0x31, 0x1c, 
    0x01, 0x24, 0xa6, 0x46, 0xec, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x96, 0xeb, 0x48, 0x02, 
    0x78, 0xbb, 0x20, 0x43, 0x5d, 0x3a, 0x20, 0xa6, 0x46, 0xee, 0x4c, 0xfe, 0x44, 0x20, 0x47, 
    0xed, 0x48, 0xb5, 0x30, 0xfc, 0xbd, 0x01, 0x1c, 0x0a, 0x7b, 0xec, 0x48, 0x00, 0x2a, 0x02, 
    0xd0, 0xc9, 0x69, 0x02, 0x29, 0x01, 0xd1, 0x63, 0x30, 0xf7, 0x46, 0xe9, 0x49, 0x43, 0x39, 
    0x08, 0x18, 0xf7, 0x46, 0x02, 0x8a, 0x01, 0x79, 0x0a, 0x29, 0x00, 0xdb, 0x0a, 0x21, 0xe5, 
    0x48, 0x8a, 0x42, 0x01, 0xdd, 0x65, 0x30, 0xf7, 0x46, 0x5b, 0x30, 0xf7, 0x46, 0x01, 0x6a, 
    0xc8, 0x7b, 0x00, 0x02, 0x89, 0x7b, 0x01, 0x43, 0xb5, 0x48, 0x52, 0x30, 0x02, 0x88, 0xdf, 
    0x48, 0x91, 0x42, 0x01, 0xd1, 0x2d, 0x30, 0xf7, 0x46, 0x29, 0x30, 0xf7, 0x46, 0xf0, 0xb5, 
    0xdc, 0x49, 0x00, 0x7f, 0xc0, 0x00, 0x40, 0x18, 0x02, 0x1f, 0x13, 0x88, 0x87, 0x48, 0xda, 
    0x38, 0x18, 0x40, 0x10, 0x80, 0x2f, 0x27, 0x3f, 0x02, 0xef, 0x4d, 0x2f, 0x82, 0x0c, 0x04, 
    0x24, 0x0c, 0x2c, 0x80, 0x14, 0x26, 0x08, 0xe0, 0x64, 0x20, 0x01, 0x21, 0x8e, 0x46, 0xeb, 
    0x49, 0xfe, 0x44, 0x08, 0x47, 0x70, 0x1e, 0x06, 0x06, 0x36, 0x0e, 0xa8, 0x89, 0x80, 0x0b, 
    0x01, 0xd2, 0x00, 0x2e, 0xf1, 0xd1, 0xa8, 0x89, 0x40, 0x05, 0x40, 0x0f, 0x17, 0xd0, 0x07, 
    0x20, 0x00, 0x02, 0x68, 0x81, 0x2f, 0x82, 0xeb, 0x48, 0x28, 0x81, 0x2c, 0x80, 0x14, 0x24, 
    0x08, 0xe0, 0x64, 0x20, 0x01, 0x21, 0x8e, 0x46, 0xdd, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x60, 
    0x1e, 0x04, 0x06, 0x24, 0x0e, 0xa8, 0x89, 0x80, 0x0b, 0x01, 0xd2, 0x00, 0x2c, 0xf1, 0xd1, 
    0xa8, 0x89, 0x68, 0x88, 

    0x01, 0x05, 0xff, 0xff, 0xce, 0x73, 0x08, 0x00, 0xfa, 0xbc, 0x48, 0xff, 0x30, 0x34, 0x30, 
    0xf0, 0xbd, 0x10, 0xb5, 0x01, 0x6a, 0xdf, 0x4a, 0x12, 0x68, 0x92, 0x88, 0x12, 0x13, 0x92, 
    0x07, 0x93, 0x0f, 0xdd, 0x4a, 0x02, 0x2b, 0x01, 0xd0, 0x13, 0x88, 0x00, 0xe0, 0x03, 0x8b, 
    0x44, 0x68, 0x0c, 0x19, 0x44, 0x60, 0x83, 0x61, 0x48, 0x88, 0x18, 0x1a, 0x10, 0x80, 0xaf, 
    0x48, 0xe7, 0x30, 0x10, 0xbd, 0x70, 0xb5, 0x05, 0x1c, 0x68, 0x68, 0x00, 0x28, 0x1a, 0xd1, 
    0xd3, 0x4e, 0x35, 0x20, 0x00, 0x01, 0x84, 0x19, 0x20, 0x68, 0x01, 0x21, 0x8e, 0x46, 0xd1, 
    0x49, 0xfe, 0x44, 0x08, 0x47, 0x20, 0x7f, 0x00, 0x28, 0x0d, 0xd0, 0xcf, 0x48, 0x00, 0x78, 
    0x02, 0x28, 0x09, 0xd0, 0xe0, 0x7f, 0x50, 0x21, 0x41, 0x43, 0x71, 0x18, 0x48, 0x8e, 0x01, 
    0x30, 0x48, 0x86, 0x60, 0x8a, 0x01, 0x38, 0x60, 0x82, 0x00, 0x20, 0xc3, 0x49, 0x08, 0x60, 
    0x01, 0x20, 0x86, 0x46, 0xc6, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x68, 0x60, 0xc5, 0x48, 0x65, 
    0x30, 0x70, 0xbd, 0xc5, 0x48, 0xd5, 0x30, 0xf7, 0x46, 0x00, 0xb5, 0x40, 0x69, 0x01, 0x21, 
    0x8e, 0x46, 0xc2, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xc2, 0x48, 0x35, 0x30, 0x00, 0xbd, 0x41, 
    0x69, 0x09, 0x7c, 0x06, 0x29, 0x02, 0xd1, 0x01, 0x21, 0xbf, 0x4a, 0x11, 0x80, 0x0f, 0x21, 
    0x81, 0x60, 0xbe, 0x48, 0x53, 0x30, 0xf7, 0x46, 0xc1, 0x68, 0x43, 0x68, 0x0a, 0x78, 0x0c, 
    0x2a, 0x07, 0xd1, 0xbb, 0x4a, 0x12, 0x78, 0x00, 0x2a, 0x01, 0xd1, 0x06, 0x22, 0x00, 0xe0, 
    0x07, 0x22, 0x4a, 0x70, 0x43, 0x61, 0xb7, 0x48, 0x09, 0x30, 0xf7, 0x46, 0x10, 0xb5, 0x80, 
    0x69, 0xb4, 0x49, 0x09, 0x78, 0x00, 0x29, 0x09, 0xd1, 0x06, 0x24, 0x04, 0x70, 0x01, 0x30, 
    0x00, 0x21, 0x01, 0x22, 

    0x01, 0x05, 0xff, 0xff, 0xc8, 0x74, 0x08, 0x00, 0xfa, 0x96, 0x46, 0xb1, 0x4a, 0xfe, 0x44, 
    0x10, 0x47, 0x08, 0xe0, 0x07, 0x24, 0x04, 0x70, 0x01, 0x30, 0x00, 0x21, 0x01, 0x22, 0x96, 
    0x46, 0xac, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x04, 0x70, 0x01, 0x30, 0x0d, 0x21, 0x01, 0x24, 
    0xa6, 0x46, 0xa8, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xe9, 0x49, 0xa6, 0x46, 0xa5, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0xe8, 0x48, 0x5d, 0x30, 0x10, 0xbd, 0x01, 0x1c, 0xe8, 0x48, 0x02, 0x78, 
    0xe6, 0x48, 0x00, 0x2a, 0x01, 0xd0, 0x5d, 0x30, 0xf7, 0x46, 0x28, 0x22, 0x8a, 0x60, 0xc0, 
    0x1c, 0xf7, 0x46, 0xe3, 0x49, 0x09, 0x78, 0x05, 0x29, 0x02, 0xd1, 0x01, 0x21, 0xe2, 0x4a, 
    0x11, 0x70, 0x23, 0x21, 0x81, 0x60, 0xe1, 0x48, 0x27, 0x30, 0xf7, 0x46, 0x10, 0xb5, 0x01, 
    0x7e, 0x00, 0x7d, 0x08, 0x43, 0xde, 0x4c, 0x0a, 0xd0, 0x00, 0x20, 0xed, 0x49, 0x08, 0x70, 
    0x01, 0x20, 0x86, 0x46, 0xec, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x20, 0x1c, 0x79, 0x30, 0x10, 
    0xbd, 0x20, 0x1c, 0x71, 0x30, 0x10, 0xbd, 0x81, 0x69, 0x4a, 0x78, 0xc2, 0x60, 0x49, 0x78, 
    0x18, 0x29, 0x01, 0xdb, 0x17, 0x21, 0xc1, 0x60, 0xe4, 0x48, 0x39, 0x30, 0xf7, 0x46, 0xc0, 
    0x46, 0x04, 0xf3, 0x1a, 0x00, 0x80, 0x7b, 0x08, 0x00, 0xd9, 0xfc, 0x00, 0x00, 0xf0, 0xb5, 
    0x45, 0x68, 0x87, 0x68, 0x01, 0x24, 0xa4, 0x02, 0x05, 0xe0, 0x01, 0x20, 0x86, 0x46, 0xe7, 
    0x48, 0xfe, 0x44, 0x00, 0x47, 0x01, 0x3c, 0xa8, 0x78, 0x69, 0x78, 0x09, 0x1a, 0xe5, 0x4e, 
    0x03, 0x29, 0x10, 0xd0, 0xc9, 0x1c, 0x0e, 0xd0, 0x00, 0x2c, 0x0e, 0xd0, 0x03, 0x28, 0x02, 
    0xdb, 0xc0, 0x1e, 0x00, 0x06, 0x00, 0x0e, 0x34, 0x21, 0x41, 0x43, 0x48, 0x19, 0x03, 0x30, 
    0x38, 0x60, 0x30, 0x1c, 

    0x01, 0x05, 0xff, 0xff, 0xc2, 0x75, 0x08, 0x00, 0xfa, 0x21, 0x30, 0xf0, 0xbd, 0x00, 0x2c, 
    0xe0, 0xd1, 0x04, 0x21, 0xda, 0x48, 0x0a, 0x1c, 0x23, 0x1c, 0x01, 0x24, 0xa6, 0x46, 0xd9, 
    0x4c, 0xfe, 0x44, 0x20, 0x47, 0x30, 0x1c, 0x25, 0x30, 0xf0, 0xbd, 0xc0, 0x46, 0x99, 0x94, 
    0x03, 0x00, 0xf9, 0x8c, 0x00, 0x00, 0x10, 0xb5, 0xd4, 0x4c, 0xa0, 0x88, 0x01, 0x21, 0x8e, 
    0x46, 0xd3, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x00, 0x28, 0x01, 0xd1, 0xec, 0x48, 0xa0, 0x80, 
    0xea, 0x48, 0xff, 0x30, 0x6e, 0x30, 0x10, 0xbd, 0x15, 0x86, 0x00, 0x00, 0x6d, 0x67, 0x08, 
    0x00, 0x62, 0x4f, 0x08, 0x00, 0xf8, 0xb5, 0x04, 0x1c, 0xa0, 0x69, 0x0e, 0x21, 0x0e, 0x18, 
    0x21, 0x7f, 0x00, 0x29, 0x2c, 0xd1, 0x30, 0x1c, 0x01, 0x25, 0xae, 0x46, 0xec, 0x49, 0xfe, 
    0x44, 0x08, 0x47, 0x00, 0x28, 0x01, 0xd1, 0x00, 0x27, 0x08, 0xe0, 0xae, 0x46, 0xe9, 0x49, 
    0xfe, 0x44, 0x08, 0x47, 0x00, 0x78, 0xa8, 0x21, 0x41, 0x43, 0xe7, 0x48, 0x47, 0x5c, 0x38, 
    0x1c, 0xae, 0x46, 0xea, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x80, 0x00, 0x00, 0x90, 0x38, 0x1c, 
    0xae, 0x46, 0xe2, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xae, 0x46, 0xe1, 0x49, 0xfe, 0x44, 0x08, 
    0x47, 0x02, 0x1c, 0x02, 0x36, 0x30, 0x1c, 0x00, 0x99, 0x51, 0x18, 0xae, 0x46, 0xde, 0x4a, 
    0xfe, 0x44, 0x10, 0x47, 0xa0, 0x69, 0x60, 0x60, 0xdc, 0x48, 0x81, 0x30, 0xf8, 0xbd, 0xdd, 
    0x48, 0x1b, 0x30, 0xf7, 0x46, 0xad, 0x45, 0x05, 0x00, 0xa5, 0x21, 0x08, 0x00, 0xda, 0x49, 
    0x0a, 0x1c, 0x3a, 0x32, 0x12, 0x78, 0x09, 0x78, 0x89, 0x18, 0x41, 0x60, 0xd8, 0x48, 0x83, 
    0x30, 0xf7, 0x46, 0xfb, 0x8b, 0x04, 0x00, 0xa9, 0x86, 0x00, 0x00, 0xad, 0x99, 0x00, 0x00, 
    0xc6, 0x05, 0x00, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0xbc, 0x76, 0x08, 0x00, 0xfa, 0x0f, 0xaa, 0x00, 0x00, 0x55, 0xde, 
    0x02, 0x00, 0x00, 0xa0, 0x1b, 0x00, 0xf8, 0xb5, 0x00, 0x25, 0x00, 0x95, 0xb9, 0x49, 0xd3, 
    0x48, 0x00, 0x88, 0x88, 0x42, 0x01, 0xd0, 0x01, 0x26, 0x06, 0xe0, 0x28, 0x1c, 0x01, 0x21, 
    0x8e, 0x46, 0xca, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x2e, 0x1c, 0x95, 0x4f, 0x01, 0x24, 0x3c, 
    0x76, 0xa6, 0x46, 0xc7, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x3d, 0x72, 0xc6, 0x4f, 0xb8, 0x6d, 
    0x69, 0x46, 0xa6, 0x46, 0x8c, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x15, 0x21, 0x00, 0x98, 0x01, 
    0x70, 0x00, 0x98, 0x46, 0x70, 0xb8, 0x6d, 0x00, 0x99, 0x2a, 0x1c, 0xa6, 0x46, 0xbf, 0x4b, 
    0xfe, 0x44, 0x18, 0x47, 0xbe, 0x48, 0x3b, 0x30, 0xf8, 0xbd, 0xc0, 0x46, 0x18, 0x80, 0x1b, 
    0x00, 0xc3, 0x8e, 0x03, 0x00, 0x10, 0xb5, 0x04, 0x1c, 0x9f, 0x49, 0xba, 0x48, 0x00, 0x88, 
    0x88, 0x42, 0x05, 0xd1, 0x00, 0x20, 0x01, 0x21, 0x8e, 0x46, 0xb1, 0x4a, 0xfe, 0x44, 0x10, 
    0x47, 0x01, 0x20, 0xa0, 0x60, 0xb5, 0x48, 0x57, 0x30, 0x10, 0xbd, 0x03, 0x13, 0x00, 0x00, 
    0xd4, 0x48, 0x08, 0x00, 0x48, 0x61, 0x08, 0x00, 0x84, 0x45, 0x08, 0x00, 0xa3, 0x56, 0x05, 
    0x00, 0xce, 0x0f, 0x08, 0x00, 0x29, 0x19, 0x02, 0x00, 0x0f, 0x1a, 0x02, 0x00, 0x81, 0x26, 
    0x01, 0x00, 0xdb, 0xef, 0x04, 0x00, 0xb9, 0x28, 0x05, 0x00, 0x44, 0x61, 0x08, 0x00, 0xdb, 
    0x22, 0x03, 0x00, 0x31, 0x4f, 0x08, 0x00, 0x5d, 0x86, 0x02, 0x00, 0xe7, 0x2a, 0x00, 0x00, 
    0xfe, 0xb5, 0x00, 0x90, 0x86, 0x69, 0x00, 0x6a, 0x01, 0x90, 0x30, 0x89, 0x00, 0x28, 0x01, 
    0xd1, 0x00, 0x24, 0x73, 0xe0, 0x31, 0x68, 0x2d, 0x24, 0x64, 0x4a, 0x2c, 0x20, 0x80, 0x18, 
    0x02, 0x90, 0x3e, 0x23, 

    0x01, 0x05, 0xff, 0xff, 0xb6, 0x77, 0x08, 0x00, 0xfa, 0x01, 0x9d, 0x5b, 0x5d, 0x00, 0x78, 
    0x83, 0x42, 0x06, 0xd0, 0xa0, 0x5c, 0x83, 0x42, 0x01, 0xd1, 0x01, 0x27, 0x02, 0xe0, 0x02, 
    0x27, 0x00, 0xe0, 0x00, 0x27, 0x48, 0x68, 0x00, 0x0f, 0x1d, 0xd2, 0x30, 0x1c, 0x01, 0x25, 
    0xae, 0x46, 0x93, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x04, 0x1c, 0x30, 0x68, 0x00, 0x28, 0x05, 
    0xd0, 0x00, 0x1f, 0x31, 0x1c, 0xae, 0x46, 0x8f, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x30, 0x89, 
    0x00, 0x28, 0x49, 0xd1, 0x4a, 0x21, 0x01, 0x98, 0x08, 0x5c, 0x00, 0x28, 0x44, 0xd1, 0x02, 
    0x2f, 0x42, 0xd0, 0xff, 0x21, 0x02, 0x98, 0x39, 0x54, 0x3e, 0xe0, 0x08, 0x25, 0x4c, 0x1b, 
    0x87, 0x48, 0x00, 0x2f, 0x11, 0xd1, 0x21, 0x88, 0x00, 0x29, 0x03, 0xd1, 0x00, 0x20, 0x30, 
    0x60, 0x70, 0x60, 0x07, 0xe0, 0x21, 0x88, 0x40, 0x18, 0x31, 0x1c, 0x01, 0x22, 0x96, 0x46, 
    0x7e, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x20, 0x20, 0x80, 0x11, 0xe0, 0x01, 0x2f, 0x0f, 
    0xd1, 0xa1, 0x88, 0x00, 0x29, 0x03, 0xd1, 0x00, 0x20, 0x30, 0x60, 0x70, 0x60, 0x06, 0xe0, 
    0x40, 0x18, 0x31, 0x1c, 0x01, 0x22, 0x96, 0x46, 0x75, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 
    0x20, 0xa0, 0x80, 0x30, 0x89, 0x01, 0x38, 0x30, 0x81, 0xe0, 0x78, 0x40, 0x07, 0x40, 0x0f, 
    0x05, 0x43, 0xe5, 0x70, 0x30, 0x89, 0x00, 0x28, 0x09, 0xd1, 0x4a, 0x21, 0x01, 0x98, 0x08, 
    0x5c, 0x00, 0x28, 0x04, 0xd1, 0x02, 0x2f, 0x02, 0xd0, 0xff, 0x21, 0x02, 0x98, 0x39, 0x54, 
    0x08, 0x34, 0x00, 0x98, 0x44, 0x60, 0x64, 0x48, 0x51, 0x30, 0xfe, 0xbd, 0xc0, 0x46, 0xaa, 
    0x1b, 0x00, 0x00, 0x5d, 0x15, 0x00, 0x00, 0xa5, 0xe0, 0x01, 0x00, 0x64, 0x61, 0x08, 0x00, 
    0x6d, 0x17, 0x08, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0xb0, 0x78, 0x08, 0x00, 0xfa, 0x29, 0x22, 0x08, 0x00, 0x2f, 0x85, 
    0x03, 0x00, 0xc1, 0xcb, 0x03, 0x00, 0xf0, 0xb5, 0x05, 0x1c, 0xae, 0x69, 0x00, 0x24, 0x6c, 
    0x60, 0x10, 0xe0, 0x11, 0x20, 0x40, 0x01, 0x60, 0x43, 0x5a, 0x49, 0x0f, 0x18, 0x10, 0x20, 
    0xc0, 0x19, 0x31, 0x1c, 0x01, 0x22, 0x96, 0x46, 0x57, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 
    0x28, 0x00, 0xd1, 0x6f, 0x60, 0x01, 0x34, 0x55, 0x48, 0x00, 0x78, 0x84, 0x42, 0xea, 0xdb, 
    0x54, 0x48, 0x47, 0x30, 0xf0, 0xbd, 0x1e, 0x17, 0x08, 0x00, 0xf1, 0xca, 0x03, 0x00, 0x91, 
    0x90, 0x03, 0x00, 0x30, 0xb5, 0x45, 0x69, 0x68, 0x7a, 0xff, 0x28, 0x0d, 0xd0, 0x01, 0x24, 
    0xa6, 0x46, 0x4d, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xc2, 0x21, 0x08, 0x5c, 0x02, 0x28, 0x04, 
    0xd0, 0x68, 0x7a, 0xa6, 0x46, 0x49, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x49, 0x48, 0xcf, 0x30, 
    0x30, 0xbd, 0x17, 0x8f, 0x03, 0x00, 0xbd, 0x59, 0x05, 0x00, 0x1f, 0x03, 0x00, 0x00, 0xdf, 
    0x87, 0x04, 0x00, 0x14, 0x24, 0x08, 0x00, 0x19, 0x90, 0x01, 0x00, 0xf0, 0xb5, 0x81, 0x68, 
    0x81, 0x61, 0x46, 0x68, 0xb8, 0x20, 0x80, 0x5d, 0x41, 0x4f, 0x02, 0x28, 0x0c, 0xd1, 0x01, 
    0x24, 0xa6, 0x46, 0x3d, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x00, 0x28, 0x05, 0xd0, 0xa6, 0x46, 
    0x3b, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x01, 0x28, 0x02, 0xd0, 0x38, 0x1c, 0xc0, 0x1c, 0xf0, 
    0xbd, 0x00, 0x25, 0x68, 0x1c, 0x00, 0x04, 0x00, 0x0c, 0xa6, 0x46, 0x17, 0x49, 0xfe, 0x44, 
    0x08, 0x47, 0x00, 0x28, 0x0a, 0xd0, 0xff, 0x21, 0xc1, 0x31, 0x08, 0x18, 0x01, 0x78, 0x02, 
    0x29, 0x02, 0xd0, 0x00, 0x7d, 0x02, 0x28, 0x01, 0xd1, 0xbc, 0x20, 0x84, 0x55, 0x01, 0x35, 
    0x07, 0x2d, 0xe8, 0xdb, 

    0x01, 0x05, 0xff, 0xff, 0xaa, 0x79, 0x08, 0x00, 0xfa, 0x38, 0x1c, 0x8f, 0x30, 0xf0, 0xbd, 
    0x89, 0x8d, 0x01, 0x00, 0xff, 0xff, 0x00, 0x00, 0x29, 0x49, 0x09, 0x78, 0x80, 0x69, 0xc1, 
    0x70, 0x28, 0x48, 0x63, 0x30, 0xf7, 0x46, 0x29, 0x48, 0x00, 0x78, 0x00, 0x07, 0x40, 0x0e, 
    0x89, 0x6b, 0x49, 0x06, 0x89, 0x0c, 0x08, 0x18, 0x24, 0x49, 0x08, 0x80, 0x25, 0x48, 0xc5, 
    0x30, 0xf7, 0x46, 0xf5, 0x2a, 0x00, 0x00, 0xd9, 0x8f, 0x01, 0x00, 0xcb, 0x18, 0x08, 0x00, 
    0xe9, 0x76, 0x04, 0x00, 0xc5, 0x76, 0x04, 0x00, 0xd5, 0x2a, 0x00, 0x00, 0x39, 0x14, 0x02, 
    0x00, 0xc5, 0x79, 0x04, 0x00, 0x9d, 0xb1, 0x03, 0x00, 0x87, 0x0f, 0x08, 0x00, 0x79, 0x95, 
    0x01, 0x00, 0x29, 0xd9, 0x00, 0x00, 0x11, 0xde, 0x02, 0x00, 0x14, 0x54, 0x08, 0x00, 0xe7, 
    0x59, 0x05, 0x00, 0x59, 0xdd, 0x02, 0x00, 0x60, 0x61, 0x08, 0x00, 0xd5, 0x44, 0x00, 0x00, 
    0xed, 0x20, 0x05, 0x00, 0x4d, 0x0b, 0x04, 0x00, 0x13, 0x22, 0x05, 0x00, 0x00, 0x00, 0x18, 
    0x00, 0x00, 0x00, 0x08, 0x00, 0x81, 0x94, 0x03, 0x00, 0x33, 0x4f, 0x08, 0x00, 0x8d, 0xd0, 
    0x03, 0x00, 0x0b, 0x34, 0x04, 0x00, 0x1f, 0x33, 0x04, 0x00, 0x5d, 0x27, 0x05, 0x00, 0x19, 
    0xde, 0x01, 0x00, 0xcd, 0x33, 0x04, 0x00, 0xbd, 0xa6, 0x00, 0x00, 0x5a, 0x56, 0x08, 0x00, 
    0xb1, 0x82, 0x00, 0x00, 0x1c, 0x30, 0x19, 0x00, 0x96, 0xa5, 0x1b, 0x00, 0xb1, 0x35, 0x03, 
    0x00, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0xee, 0xfd, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xfe, 0xf7, 0x13, 0xfe, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfd, 0xf0, 0x30, 0xfa, 0xff, 
    0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x97, 0xfd, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xfd, 0xf0, 0xb6, 0xfa, 

    0x01, 0x05, 0xff, 0x93, 0xa4, 0x7a, 0x08, 0x00, 0x8e, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xfd, 0xf0, 0xf9, 0xf9, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x22, 0xfe, 0xff, 
    0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x8d, 0xfc, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xff, 0xf7, 0x84, 0xf9, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x01, 0xfd, 0xff, 
    0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0xb8, 0xfe, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xfe, 0xf7, 0x2f, 0xfd, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0xec, 0xfb, 0xff, 
    0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x87, 0xfc, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xff, 0xf7, 0x12, 0xfa, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xff, 0xf7, 0xe3, 0xf8, 0xff, 
    0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0xe6, 0xff, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 
    0xfe, 0xf7, 0xef, 0xfe, 0xff, 0xbd, 0xff, 0xb5, 0x68, 0x46, 0xfe, 0xf7, 0x7c, 0xff, 0xff, 
    0xbd, 

    0x01, 0x05, 0xff, 0x8d, 0x78, 0x7b, 0x08, 0x00, 0x88, 0x00, 0xb5, 0xf8, 0xf0, 0x41, 0xfa, 
    0x00, 0xbd, 0x1f, 0x72, 0x08, 0x00, 0x79, 0x74, 0x08, 0x00, 0xd7, 0x73, 0x08, 0x00, 0x07, 
    0x74, 0x08, 0x00, 0x91, 0x74, 0x08, 0x00, 0x65, 0x74, 0x08, 0x00, 0xb3, 0x74, 0x08, 0x00, 
    0x05, 0x75, 0x08, 0x00, 0x1d, 0x75, 0x08, 0x00, 0x5f, 0x74, 0x08, 0x00, 0x69, 0x61, 0x08, 
    0x00, 0xc7, 0x79, 0x08, 0x00, 0x35, 0x75, 0x08, 0x00, 0x5d, 0x75, 0x08, 0x00, 0xed, 0x75, 
    0x08, 0x00, 0x05, 0x79, 0x08, 0x00, 0x81, 0x75, 0x08, 0x00, 0x33, 0x73, 0x08, 0x00, 0x51, 
    0x73, 0x08, 0x00, 0xc9, 0x76, 0x08, 0x00, 0x31, 0x77, 0x08, 0x00, 0x49, 0x79, 0x08, 0x00, 
    0xb9, 0x79, 0x08, 0x00, 0x19, 0x76, 0x08, 0x00, 0x8b, 0x76, 0x08, 0x00, 0x99, 0x76, 0x08, 
    0x00, 0x95, 0x77, 0x08, 0x00, 0xbd, 0x78, 0x08, 0x00, 0xa5, 0x50, 0x18, 0x00, 0xb9, 0x50, 
    0x18, 0x00, 0x3f, 0x72, 0x08, 0x00, 0x1b, 0x73, 0x08, 0x00, 

    0x01, 0x05, 0xff, 0x85, 0x04, 0xf3, 0x1a, 0x00, 0x80, 0x1e, 0x8d, 0x00, 0x00, 0x2c, 0x23, 
    0x03, 0x00, 0x3a, 0xdf, 0x02, 0x00, 0x3a, 0x1a, 0x02, 0x00, 0x64, 0x86, 0x02, 0x00, 0xe8, 
    0x28, 0x05, 0x00, 0x7e, 0x15, 0x00, 0x00, 0xa6, 0xe0, 0x01, 0x00, 0x54, 0x85, 0x03, 0x00, 
    0x52, 0x27, 0x01, 0x00, 0x7c, 0xbf, 0x02, 0x00, 0x6c, 0x36, 0x03, 0x00, 0x2e, 0xcc, 0x03, 
    0x00, 0xc8, 0x90, 0x03, 0x00, 0xf0, 0x8e, 0x01, 0x00, 0x22, 0x28, 0x05, 0x00, 0xbe, 0x59, 
    0x05, 0x00, 0x72, 0xde, 0x02, 0x00, 0x6e, 0xdf, 0x02, 0x00, 0x64, 0xdd, 0x02, 0x00, 0x22, 
    0x45, 0x00, 0x00, 0xbe, 0xa6, 0x00, 0x00, 0x08, 0x83, 0x00, 0x00, 0xb8, 0x14, 0x02, 0x00, 
    0xae, 0xb1, 0x03, 0x00, 0xf8, 0x95, 0x01, 0x00, 0xf4, 0x20, 0x05, 0x00, 0xce, 0xd0, 0x03, 
    0x00, 0xc6, 0x16, 0x02, 0x00, 0x70, 0xa5, 0x01, 0x00, 0xbc, 0x86, 0x00, 0x00, 0x66, 0xaa, 
    0x00, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0x00, 0x00, 0x18, 0x00, 0xfa, 0xf0, 0xb5, 0x64, 0x4e, 0x07, 0x22, 
    0x10, 0x1c, 0x30, 0x70, 0x10, 0x23, 0x73, 0x70, 0x47, 0x20, 0xb0, 0x70, 0x2a, 0x20, 0xf0, 
    0x70, 0x03, 0x25, 0x28, 0x1c, 0x60, 0x49, 0x01, 0x39, 0x01, 0x24, 0xa6, 0x46, 0x5d, 0x4f, 
    0xfe, 0x44, 0x38, 0x47, 0xb2, 0x78, 0xf3, 0x78, 0x28, 0x1c, 0x5b, 0x49, 0xa6, 0x46, 0x59, 
    0x4e, 0xfe, 0x44, 0x30, 0x47, 0x28, 0x1c, 0x58, 0x49, 0x01, 0x31, 0xa6, 0x46, 0x57, 0x4a, 
    0xfe, 0x44, 0x10, 0x47, 0x28, 0x1c, 0xb9, 0x21, 0xc9, 0x00, 0xa6, 0x46, 0x54, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0xa6, 0x46, 0x53, 0x48, 0xfe, 0x44, 0x00, 0x47, 0x52, 0x4b, 0x00, 0x21, 
    0x08, 0x1c, 0x1a, 0x68, 0x00, 0x2a, 0x04, 0xd0, 0x02, 0x07, 0x15, 0x0f, 0x22, 0x1c, 0xaa, 
    0x40, 0x11, 0x43, 0x02, 0x07, 0x12, 0x0f, 0x0f, 0x2a, 0x05, 0xd1, 0xc5, 0x08, 0x06, 0x22, 
    0x2a, 0x40, 0x4a, 0x4d, 0xa9, 0x52, 0x00, 0x21, 0x04, 0x33, 0x01, 0x30, 0x20, 0x28, 0xe9, 
    0xd3, 0x3f, 0x21, 0x68, 0x48, 0x41, 0x75, 0xa6, 0x46, 0x47, 0x48, 0xfe, 0x44, 0x00, 0x47, 
    0x44, 0x49, 0x08, 0x60, 0xc8, 0x20, 0x45, 0x49, 0x08, 0x80, 0x3c, 0x23, 0x44, 0x48, 0x03, 
    0x70, 0x02, 0x20, 0x44, 0x49, 0x08, 0x70, 0xff, 0x22, 0x43, 0x48, 0x02, 0x70, 0x43, 0x48, 
    0x04, 0x70, 0x43, 0x48, 0x04, 0x70, 0x43, 0x48, 0x04, 0x70, 0x43, 0x48, 0x03, 0x70, 0x28, 
    0x23, 0x43, 0x70, 0x14, 0x23, 0x83, 0x70, 0x08, 0x20, 0x41, 0x4b, 0x18, 0x70, 0x41, 0x48, 
    0x0c, 0x25, 0x05, 0x73, 0x0b, 0x23, 0x83, 0x73, 0x0d, 0x23, 0x43, 0x73, 0x81, 0x20, 0x00, 
    0x03, 0x3d, 0x4b, 0x18, 0x60, 0x40, 0x48, 0x03, 0x1c, 0x5a, 0x33, 0x1c, 0x60, 0x00, 0x27, 
    0x3b, 0x4b, 0x1f, 0x70, 

    0x01, 0x05, 0xff, 0xff, 0xfa, 0x00, 0x18, 0x00, 0xfa, 0x3c, 0x4b, 0x3a, 0x4e, 0x33, 0x80, 
    0x02, 0x70, 0x3c, 0x4a, 0x13, 0x80, 0x4f, 0x30, 0x04, 0x70, 0x09, 0x20, 0x21, 0x21, 0xc9, 
    0x00, 0x0f, 0x22, 0x39, 0x4b, 0xa6, 0x46, 0x39, 0x4e, 0xfe, 0x44, 0x30, 0x47, 0x3a, 0x4e, 
    0x30, 0x1c, 0x36, 0x38, 0x04, 0x21, 0xa6, 0x46, 0x36, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x20, 
    0x1c, 0xa6, 0x46, 0x34, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x30, 0x1c, 0x29, 0x1c, 0xa6, 0x46, 
    0x30, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x30, 0x1c, 0x29, 0x1c, 0xa6, 0x46, 0x30, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0x30, 0x4e, 0xa8, 0x19, 0xa6, 0x46, 0x2f, 0x49, 0xfe, 0x44, 0x08, 0x47, 
    0x30, 0x1c, 0xa6, 0x46, 0x2d, 0x49, 0xfe, 0x44, 0x08, 0x47, 0xa6, 0x46, 0x2c, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0x38, 0x1c, 0xa6, 0x46, 0x2b, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x29, 0x49, 
    0x08, 0x60, 0x2a, 0x48, 0x07, 0x60, 0x2a, 0x48, 0x07, 0x60, 0x2a, 0x48, 0x07, 0x80, 0x0a, 
    0x20, 0x29, 0x49, 0x08, 0x70, 0x29, 0x48, 0x07, 0x21, 0x01, 0x70, 0xf0, 0xbd, 0xf8, 0x4f, 
    0x08, 0x00, 0x7b, 0x88, 0x04, 0x00, 0xc6, 0x05, 0x00, 0x00, 0x65, 0x88, 0x04, 0x00, 0x6b, 
    0x02, 0x18, 0x00, 0x80, 0x7b, 0x08, 0x00, 0x84, 0xf3, 0x1a, 0x00, 0x58, 0x61, 0x08, 0x00, 
    0x47, 0x76, 0x04, 0x00, 0x4a, 0x61, 0x08, 0x00, 0x51, 0x61, 0x08, 0x00, 0x52, 0x61, 0x08, 
    0x00, 0x53, 0x61, 0x08, 0x00, 0x4e, 0x61, 0x08, 0x00, 0x4f, 0x61, 0x08, 0x00, 0x50, 0x61, 
    0x08, 0x00, 0x10, 0x31, 0x19, 0x00, 0x15, 0x13, 0x08, 0x00, 0xd8, 0x11, 0x08, 0x00, 0xf4, 
    0x20, 0x08, 0x00, 0x64, 0x61, 0x08, 0x00, 0x60, 0x61, 0x08, 0x00, 0xff, 0xff, 0x00, 0x00, 
    0x62, 0x4f, 0x08, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0xf4, 0x01, 0x18, 0x00, 0xfa, 0x18, 0x24, 0x08, 0x00, 0xb0, 0x3e, 
    0x18, 0x00, 0x31, 0x06, 0x04, 0x00, 0x9d, 0xf5, 0x04, 0x00, 0xc3, 0x8e, 0x03, 0x00, 0x36, 
    0x02, 0x1a, 0x00, 0xb5, 0xf5, 0x04, 0x00, 0xa0, 0x17, 0x08, 0x00, 0xcb, 0x07, 0x04, 0x00, 
    0x07, 0x58, 0x02, 0x00, 0xc0, 0x62, 0x08, 0x00, 0xc5, 0x79, 0x04, 0x00, 0xc4, 0x62, 0x08, 
    0x00, 0xc8, 0x62, 0x08, 0x00, 0x62, 0x61, 0x08, 0x00, 0x2d, 0x22, 0x08, 0x00, 0xaa, 0x11, 
    0x08, 0x00, 0x70, 0xb5, 0x45, 0x4d, 0xae, 0x7f, 0x01, 0x24, 0xa6, 0x46, 0x41, 0x48, 0xfe, 
    0x44, 0x00, 0x47, 0xb0, 0x42, 0xf8, 0xd1, 0x03, 0x20, 0x17, 0x21, 0x89, 0x01, 0xa6, 0x46, 
    0x3d, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xad, 0x7f, 0xa6, 0x46, 0x3a, 0x48, 0xfe, 0x44, 0x00, 
    0x47, 0xa8, 0x42, 0xf9, 0xd1, 0xfe, 0xe7, 0x70, 0xb5, 0x3a, 0x49, 0x08, 0x1f, 0x3a, 0x4a, 
    0x10, 0x60, 0x04, 0x24, 0x37, 0x48, 0x04, 0x70, 0x46, 0x48, 0x02, 0x1c, 0x70, 0x3a, 0x21, 
    0x23, 0x9b, 0x18, 0x01, 0x25, 0x1d, 0x70, 0x35, 0x4d, 0x0d, 0x60, 0x02, 0x25, 0x55, 0x71, 
    0x34, 0x4d, 0x4d, 0x60, 0x03, 0x25, 0x15, 0x70, 0x33, 0x4d, 0x8d, 0x60, 0x14, 0x71, 0x33, 
    0x4c, 0xcc, 0x60, 0x16, 0x24, 0xa4, 0x18, 0x05, 0x25, 0x25, 0x70, 0x31, 0x4d, 0x0d, 0x61, 
    0x06, 0x25, 0xd5, 0x74, 0x30, 0x4d, 0x4d, 0x61, 0x07, 0x25, 0x95, 0x71, 0x95, 0x1d, 0x2e, 
    0x4e, 0x8e, 0x61, 0x08, 0x26, 0xa6, 0x77, 0x2d, 0x4c, 0xcc, 0x61, 0x09, 0x24, 0x94, 0x70, 
    0x2c, 0x4c, 0x0c, 0x62, 0x0a, 0x24, 0xac, 0x77, 0x2b, 0x4c, 0x4c, 0x62, 0x0b, 0x24, 0x5c, 
    0x77, 0x2a, 0x4c, 0x8c, 0x62, 0x0c, 0x24, 0xd4, 0x71, 0x29, 0x4a, 0xca, 0x62, 0x0d, 0x22, 
    0x5a, 0x75, 0x28, 0x4a, 

    0x01, 0x05, 0xff, 0xe3, 0xee, 0x02, 0x18, 0x00, 0xde, 0x0a, 0x63, 0x0e, 0x22, 0x02, 0x70, 
    0x28, 0x4a, 0x4a, 0x63, 0x0f, 0x22, 0x42, 0x70, 0x27, 0x4a, 0x8a, 0x63, 0x10, 0x22, 0xc2, 
    0x73, 0x26, 0x4a, 0xca, 0x63, 0x01, 0x38, 0x11, 0x22, 0x02, 0x70, 0x25, 0x4a, 0x0a, 0x64, 
    0x12, 0x22, 0x02, 0x71, 0x24, 0x4a, 0x4a, 0x64, 0x13, 0x22, 0xc2, 0x77, 0x23, 0x48, 0x88, 
    0x64, 0x00, 0x20, 0x25, 0x49, 0x08, 0x80, 0x25, 0x49, 0x08, 0x80, 0x19, 0x21, 0x49, 0x01, 
    0x1f, 0x4a, 0x11, 0x80, 0x4b, 0x21, 0x09, 0x01, 0x1e, 0x4a, 0x11, 0x80, 0x21, 0x49, 0x22, 
    0x4a, 0x11, 0x80, 0x1d, 0x49, 0x08, 0x70, 0x70, 0xbd, 0xc5, 0x83, 0x04, 0x00, 0x65, 0x88, 
    0x04, 0x00, 0x3c, 0x4e, 0x08, 0x00, 0xf2, 0x4f, 0x08, 0x00, 0x70, 0x62, 0x08, 0x00, 0x70, 
    0x52, 0x08, 0x00, 0xe3, 0x7a, 0x08, 0x00, 0xcf, 0x7a, 0x08, 0x00, 0xed, 0x7a, 0x08, 0x00, 
    0xf7, 0x7a, 0x08, 0x00, 0xd9, 0x7a, 0x08, 0x00, 0x1f, 0x7b, 0x08, 0x00, 0x29, 0x7b, 0x08, 
    0x00, 0x15, 0x7b, 0x08, 0x00, 0x0b, 0x7b, 0x08, 0x00, 0x01, 0x7b, 0x08, 0x00, 0xc5, 0x7a, 
    0x08, 0x00, 0x89, 0x7a, 0x08, 0x00, 0xa7, 0x7a, 0x08, 0x00, 0xe4, 0x52, 0x08, 0x00, 0x93, 
    0x7a, 0x08, 0x00, 0x75, 0x7a, 0x08, 0x00, 0x7f, 0x7a, 0x08, 0x00, 0xb1, 0x7a, 0x08, 0x00, 
    0xbb, 0x7a, 0x08, 0x00, 0x9d, 0x7a, 0x08, 0x00, 0x98, 0x23, 0x08, 0x00, 0x32, 0x24, 0x08, 
    0x00, 0x54, 0x1d, 0x18, 0x00, 0x44, 0x61, 0x08, 0x00, 0x46, 0x61, 0x08, 0x00, 0xff, 0xff, 
    0x00, 0x00, 0x50, 0x1d, 0x18, 0x00, 

    0x01, 0x05, 0xff, 0xff, 0xa0, 0x4e, 0x18, 0x00, 0xfa, 0x70, 0xb5, 0x06, 0x1c, 0x68, 0x4c, 
    0xa0, 0x8a, 0x0f, 0x28, 0x1d, 0xda, 0x20, 0x89, 0x00, 0x28, 0x1a, 0xd0, 0x66, 0x48, 0x04, 
    0x21, 0x01, 0x25, 0xae, 0x46, 0x68, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0x11, 0xd1, 
    0x20, 0x1c, 0xae, 0x46, 0x61, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x01, 0x1c, 0x08, 0x30, 0x60, 
    0x4a, 0x10, 0x80, 0x0c, 0x20, 0x00, 0x19, 0xae, 0x46, 0x60, 0x4a, 0xfe, 0x44, 0x10, 0x47, 
    0xa0, 0x8a, 0x0f, 0x28, 0xe1, 0xdb, 0x5b, 0x48, 0x40, 0x30, 0x30, 0x62, 0x70, 0xbd, 0xf8, 
    0xb5, 0x80, 0x8a, 0xff, 0x21, 0x0b, 0x31, 0x88, 0x42, 0x5b, 0xd0, 0xff, 0x21, 0x45, 0x31, 
    0x88, 0x42, 0x16, 0xd1, 0x63, 0x48, 0x00, 0x78, 0x02, 0x28, 0x12, 0xd1, 0x62, 0x49, 0xff, 
    0x20, 0x3d, 0x30, 0x40, 0x18, 0x00, 0x90, 0x53, 0x48, 0x40, 0x5c, 0x00, 0x26, 0x86, 0x42, 
    0x10, 0xd3, 0x51, 0x25, 0xad, 0x00, 0x28, 0x1c, 0x01, 0x24, 0xa6, 0x46, 0x4f, 0x49, 0xfe, 
    0x44, 0x08, 0x47, 0x00, 0x28, 0x6c, 0xd1, 0x28, 0x1c, 0x4d, 0x49, 0xa6, 0x46, 0x4d, 0x4a, 
    0xfe, 0x44, 0x10, 0x47, 0xf8, 0xbd, 0xb1, 0x00, 0x00, 0x98, 0x45, 0x58, 0x00, 0x2d, 0x2f, 
    0xd0, 0xc2, 0x20, 0x40, 0x5d, 0x00, 0x28, 0x2b, 0xd0, 0xb6, 0x20, 0x41, 0x5d, 0x00, 0x29, 
    0x27, 0xd1, 0xc5, 0x20, 0x40, 0x5d, 0x01, 0x28, 0x23, 0xd0, 0x24, 0x20, 0x01, 0x24, 0xa6, 
    0x46, 0x4c, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x06, 0x00, 0x0e, 0xb7, 0x22, 0x51, 0x5d, 
    0x81, 0x42, 0x17, 0xd0, 0x50, 0x55, 0x00, 0x28, 0x14, 0xd1, 0x2f, 0x8d, 0x39, 0x1c, 0x3b, 
    0x48, 0xa6, 0x46, 0x3b, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x29, 0x8e, 0x79, 0x18, 0x08, 0x1a, 
    0x40, 0x1e, 0x39, 0x1c, 

    0x01, 0x05, 0xff, 0xff, 0x9a, 0x4f, 0x18, 0x00, 0xfa, 0xa6, 0x46, 0x36, 0x4a, 0xfe, 0x44, 
    0x10, 0x47, 0x40, 0x00, 0x28, 0x86, 0x28, 0x8e, 0x40, 0x08, 0x28, 0x86, 0x01, 0x36, 0x33, 
    0x48, 0x00, 0x78, 0xb3, 0xe7, 0x00, 0x20, 0x01, 0x24, 0xa6, 0x46, 0x31, 0x49, 0xfe, 0x44, 
    0x08, 0x47, 0x01, 0x1c, 0x00, 0x90, 0x2f, 0x4d, 0x28, 0x68, 0x01, 0x30, 0x28, 0x60, 0x2b, 
    0x27, 0xff, 0x00, 0x2d, 0x4e, 0x2e, 0x48, 0x00, 0x8c, 0x32, 0x68, 0x10, 0x18, 0x80, 0x01, 
    0x80, 0x09, 0xa6, 0x46, 0x2f, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x00, 0x28, 0x11, 0xdd, 0x00, 
    0x98, 0x30, 0x60, 0x28, 0x68, 0x03, 0x28, 0x0a, 0xd9, 0x00, 0x20, 0xa6, 0x46, 0x25, 0x49, 
    0xfe, 0x44, 0x08, 0x47, 0x23, 0x48, 0x38, 0x5c, 0xa6, 0x46, 0x22, 0x49, 0xfe, 0x44, 0x08, 
    0x47, 0x00, 0x20, 0x28, 0x60, 0xf8, 0xbd, 0x30, 0xb5, 0x85, 0x69, 0x24, 0x20, 0x00, 0x21, 
    0x01, 0x24, 0xa6, 0x46, 0x1f, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0xb7, 0x21, 0x48, 0x55, 0x51, 
    0x25, 0xad, 0x00, 0x28, 0x1c, 0xa6, 0x46, 0x0e, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x00, 0x28, 
    0x05, 0xd1, 0x28, 0x1c, 0x0c, 0x49, 0xa6, 0x46, 0x0c, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x30, 
    0xbd, 0xc0, 0x46, 0xa0, 0x17, 0x08, 0x00, 0x4a, 0x0c, 0x1a, 0x00, 0x4d, 0x0b, 0x04, 0x00, 
    0x32, 0x02, 0x1a, 0x00, 0xa5, 0x57, 0x02, 0x00, 0x6b, 0xf7, 0x04, 0x00, 0x8b, 0x09, 0x04, 
    0x00, 0x1b, 0x0a, 0x00, 0x00, 0xcb, 0xd7, 0x03, 0x00, 0x00, 0x66, 0xe3, 0x01, 0xc7, 0xd5, 
    0x03, 0x00, 0xff, 0xff, 0xff, 0x01, 0xad, 0x45, 0x05, 0x00, 0x2f, 0x2e, 0x08, 0x00, 0xc5, 
    0x79, 0x04, 0x00, 0xc4, 0x62, 0x08, 0x00, 0xc0, 0x62, 0x08, 0x00, 0x48, 0x10, 0x08, 0x00, 
    0x49, 0x11, 0x02, 0x00, 

    0x01, 0x05, 0xff, 0xfd, 0x94, 0x50, 0x18, 0x00, 0xf8, 0x45, 0x10, 0x08, 0x00, 0x14, 0x24, 
    0x08, 0x00, 0x93, 0xe4, 0x04, 0x00, 0x39, 0x7a, 0x04, 0x00, 0x00, 0xb5, 0x40, 0x68, 0x01, 
    0x21, 0x8e, 0x46, 0x2d, 0x49, 0xfe, 0x44, 0x08, 0x47, 0x2b, 0x48, 0x57, 0x30, 0x00, 0xbd, 
    0xfc, 0xb5, 0x00, 0x90, 0x2f, 0x48, 0xbe, 0x30, 0x00, 0x78, 0x02, 0x28, 0x42, 0xd1, 0x2e, 
    0x49, 0xff, 0x20, 0x3d, 0x30, 0x40, 0x18, 0x01, 0x90, 0x25, 0x48, 0x40, 0x5c, 0x00, 0x26, 
    0x37, 0xe0, 0xb1, 0x00, 0x01, 0x98, 0x45, 0x58, 0x00, 0x2d, 0x2f, 0xd0, 0xc2, 0x20, 0x40, 
    0x5d, 0x00, 0x28, 0x2b, 0xd0, 0xb6, 0x20, 0x41, 0x5d, 0x00, 0x29, 0x27, 0xd1, 0xc5, 0x20, 
    0x40, 0x5d, 0x01, 0x28, 0x23, 0xd0, 0x24, 0x20, 0x01, 0x24, 0xa6, 0x46, 0x20, 0x4a, 0xfe, 
    0x44, 0x10, 0x47, 0x00, 0x06, 0x00, 0x0e, 0xb7, 0x22, 0x51, 0x5d, 0x81, 0x42, 0x17, 0xd0, 
    0x50, 0x55, 0x00, 0x28, 0x14, 0xd1, 0x2f, 0x8d, 0x39, 0x1c, 0x13, 0x48, 0xa6, 0x46, 0x19, 
    0x4a, 0xfe, 0x44, 0x10, 0x47, 0x29, 0x8e, 0x79, 0x18, 0x08, 0x1a, 0x40, 0x1e, 0x39, 0x1c, 
    0xa6, 0x46, 0x15, 0x4a, 0xfe, 0x44, 0x10, 0x47, 0x40, 0x00, 0x28, 0x86, 0x28, 0x8e, 0x40, 
    0x08, 0x28, 0x86, 0x01, 0x36, 0x0a, 0x48, 0x00, 0x78, 0x86, 0x42, 0xc5, 0xd3, 0x00, 0x98, 
    0x41, 0x68, 0x81, 0x61, 0xff, 0x21, 0x41, 0x60, 0x08, 0x48, 0x06, 0x49, 0x08, 0x18, 0xfc, 
    0xbd, 0xc0, 0x46, 0x73, 0x16, 0x02, 0x00, 0xdb, 0xef, 0x04, 0x00, 0x1b, 0x0a, 0x00, 0x00, 
    0xff, 0xff, 0xff, 0x01, 0x2f, 0x2e, 0x08, 0x00, 0x77, 0x02, 0x00, 0x00, 0xfd, 0xa2, 0x01, 
    0x00, 0x87, 0x0f, 0x08, 0x00, 0x14, 0x24, 0x08, 0x00, 0x93, 0xe4, 0x04, 0x00, 0xad, 0x45, 
    0x05, 0x00, 

    0x01, 0x83, 0xff, 0x14, 0x79, 0x7b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

    // 
    // 
    // 
    // 
    0x01, 0x0c, 0xfd, 0x09, 0x01, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 

    0x01, 0x09, 0xfd, 0x08, 0x58, 0x60, 0x1a, 0x00, 0x00, 0x10, 0x00, 0x10, 

    0x01, 0x09, 0xfd, 0x08, 0x10, 0x60, 0x1a, 0x00, 0x10, 0x00, 0x10, 0x00, 

    0x01, 0x76, 0xfd, 0x31, 0x01, 0x21, 0x54, 0x00, 0x00, 0x61, 0x57, 0x00, 0x00, 0x14, 0x05, 
    0x0a, 0x05, 0x00, 0x07, 0x06, 0x0a, 0x04, 0x05, 0x08, 0x09, 0x0b, 0x0c, 0x0d, 0x0e, 0x10, 
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
    0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 

    // BTstack: added HCI_VS_SET_POWER_VECTOR(GFSK) 0xFD82 template
    0x01, 0x82, 0xfd, 0x14, 0x00, 0x9c, 0x18, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xdc,
    0xe6, 0xf0, 0xfa, 0x04, 0x0e, 0x18, 0xff, 0x00, 0x00,

    // BTstack: added HCI_VS_SET_POWER_VECTOR(EDR2) 0xFD82 template
    0x01, 0x82, 0xfd, 0x14, 0x01, 0x9c, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xd8, 
    0xe2, 0xec, 0xf6, 0x00, 0x0a, 0x14, 0xff, 0x00, 0x00,

    // BTstack: added HCI_VS_SET_POWER_VECTOR(EDR3) 0xFD82 for EDR3 template
    0x01, 0x82, 0xfd, 0x14, 0x02, 0x9c, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xd8,
    0xe2, 0xec, 0xf6, 0x00, 0x0a, 0x14, 0xff, 0x00, 0x00,

    // BTstack: added HCI_VS_SET_CLASS2_SINGLE_POWER 0xFD87 template
    0x01, 0x87, 0xfd, 0x03, 0x0d, 0x0d, 0x0d,

    0x01, 0x80, 0xfd, 0x06, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 

    0x01, 0x80, 0xfd, 0x06, 0x3c, 0xf0, 0x5f, 0x00, 0x00, 0x00, 

    0x01, 0x1c, 0xfd, 0x14, 0xff, 0x88, 0x13, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xff, 0xff, 
    0x01, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 

    // 
    // 
    // 
    0x01, 0x38, 0xfe, 0x00, 

    // 
    // #################################################################
    // ## START of CC2564 Adds-On
    // #################################################################
    // 
    // ## Enable fast clock XTAL support
    0x01, 0x1c, 0xfd, 0x14, 0x01, 0x88, 0x13, 0x00, 0x00, 0xd0, 0x07, 0x00, 0x00, 0xff, 0xff, 
    0x04, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 

    // 
    // ## Enable eHCILL
    0x01, 0x2b, 0xfd, 0x05, 0x10, 0x00, 0x50, 0x00, 0x96, 

    // 
    0x01, 0x0c, 0xfd, 0x09, 0x01, 0x01, 0x00, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 

    // 
    // #################################################################
    // ## END of CC2564 Adds-On
    // #################################################################
    // #--------------------------------------------------------------------------------
    // # Description:   BLE FW Initialization Script
    // #
    // # Compatibility: BL6450B
    // #
    // # Last Updated:  19-Oct-2014  13:57:11.15
    // #
    // # Version:       2.0
    // #
    // #--------------------------------------------------------------------------------
    // 
    // 
    // #LE Enable
    0x01, 0x5b, 0xfd, 0x02, 0x01, 0x01, 

    // 
    // # Disable Cortex Sleep
    0x01, 0xa8, 0xfd, 0x01, 0x01, 

    // 
    // 
    // # Cortex Reset (hold in reset while loading IMEM)
    0x01, 0x09, 0xfd, 0x08, 0x00, 0xc0, 0x1b, 0x00, 0x01, 0x00, 0x01, 0x00, 

    // ########################
    // # Patch Start
    // ########################
    // 
    0x01, 0x05, 0xff, 0x0d, 0xac, 0x4b, 0x1b, 0x00, 0x08, 0x91, 0xff, 0x47, 0xf2, 0x9b, 0x35, 
    0x47, 0xf2, 

    0x01, 0x05, 0xff, 0x55, 0x20, 0x63, 0x1b, 0x00, 0x50, 0x30, 0xbd, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

    0x01, 0x05, 0xff, 0x5d, 0x98, 0x73, 0x1b, 0x00, 0x58, 0x70, 0x47, 0x02, 0x46, 0x14, 0x3a, 
    0x1e, 0xd0, 0x52, 0x1e, 0x24, 0xd1, 0x8a, 0x78, 0x02, 0x2a, 0x11, 0xd9, 0x12, 0x1f, 0x02, 
    0x2a, 0x0e, 0xd9, 0x1d, 0x3a, 0x1c, 0xd0, 0x92, 0x1f, 0x02, 0x2a, 0x19, 0xd9, 0x09, 0x3a, 
    0x17, 0xd0, 0x89, 0x88, 0x40, 0xf2, 0x00, 0x00, 0xc2, 0xf2, 0x30, 0x00, 0x08, 0x43, 0xfd, 
    0xf7, 0x4b, 0xbe, 0x09, 0x89, 0x40, 0xf2, 0x00, 0x00, 0xc2, 0xf2, 0x30, 0x00, 0x08, 0x43, 
    0xfd, 0xf7, 0x43, 0xbe, 0x89, 0x88, 0x40, 0xf2, 0x00, 0x00, 0xc2, 0xf2, 0x30, 0x00, 0x08, 
    0x43, 0xfd, 0xf7, 0x3b, 0xbe, 0x70, 0x47, 

    // 
    // ########################
    // # Patch End
    // ########################
    // 
    // #release Cortex Reset
    0x01, 0x09, 0xfd, 0x08, 0x00, 0xc0, 0x1b, 0x00, 0x00, 0x00, 0x01, 0x00, 

    // 
    // # Enable Cortex Sleep
    0x01, 0xa8, 0xfd, 0x01, 0x00, 

    // 
    // #RESET BLE
    0x01, 0x5b, 0xfd, 0x02, 0x01, 0x00, 

    // 
    0x01, 0xdd, 0xfd, 0x01, 0x01, 

};

const uint32_t cc256x_init_script_size = 9497;

