/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleFinder;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000bj\b\u0012\u0004\u0012\u00020\b`\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bR\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "", "finder", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;", "<init>", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;)V", "module", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "getAllDependencies", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "moduleNames", "", "reads", "", "moduleName", "dependencyName", "cli-base"})
public final class JavaModuleGraph {
    @NotNull
    private final Function1<String, JavaModule> module;

    public JavaModuleGraph(@NotNull JavaModuleFinder finder) {
        Intrinsics.checkNotNullParameter(finder, "finder");
        this.module = LockBasedStorageManager.NO_LOCKS.createMemoizedFunctionWithNullableValues((Function1)new Function1<String, JavaModule>((Object)finder){

            public final JavaModule invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((JavaModuleFinder)this.receiver).findModule(p0);
            }
        });
    }

    @NotNull
    public final LinkedHashSet<String> getAllDependencies(@NotNull List<String> moduleNames) {
        Intrinsics.checkNotNullParameter(moduleNames, "moduleNames");
        LinkedHashSet<String> visited2 = new LinkedHashSet<String>((Collection)moduleNames);
        ((Collection)visited2).add("java.base");
        for (String moduleName2 : moduleNames) {
            JavaModule module2;
            JavaModule javaModule;
            if (this.module.invoke(moduleName2) == null || (javaModule = module2) instanceof JavaModule.Automatic) continue;
            if (javaModule instanceof JavaModule.Explicit) {
                for (JavaModuleInfo.Requires requires : ((JavaModule.Explicit)module2).getModuleInfo().getRequires()) {
                    boolean moduleExists;
                    String dependencyModuleName = requires.component1();
                    boolean isTransitive = requires.component2();
                    if (!visited2.add(dependencyModuleName) || (moduleExists = JavaModuleGraph.getAllDependencies$dfs(this, visited2, dependencyModuleName)) || isTransitive || !((JavaModule.Explicit)module2).isJdkModuleFromCtSym()) continue;
                    visited2.remove(dependencyModuleName);
                }
                continue;
            }
            throw new IllegalStateException(("Unknown module: " + module2 + " (" + module2.getClass() + ')').toString());
        }
        return visited2;
    }

    public final boolean reads(@NotNull String moduleName2, @NotNull String dependencyName) {
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        Intrinsics.checkNotNullParameter(dependencyName, "dependencyName");
        if (Intrinsics.areEqual(moduleName2, dependencyName) || Intrinsics.areEqual(dependencyName, "java.base")) {
            return true;
        }
        LinkedHashSet<String> visited2 = new LinkedHashSet<String>();
        JavaModule javaModule = this.module.invoke(moduleName2);
        if (javaModule == null) {
            return false;
        }
        JavaModule module2 = javaModule;
        JavaModule javaModule2 = module2;
        if (javaModule2 instanceof JavaModule.Automatic) {
            return true;
        }
        if (javaModule2 instanceof JavaModule.Explicit) {
            Iterator<JavaModuleInfo.Requires> iterator2 = ((JavaModule.Explicit)module2).getModuleInfo().getRequires().iterator();
            while (iterator2.hasNext()) {
                String dependencyModuleName = iterator2.next().component1();
                if (!JavaModuleGraph.reads$dfs(visited2, this, dependencyName, dependencyModuleName)) continue;
                return true;
            }
        }
        return JavaModuleGraph.reads$dfs(visited2, this, dependencyName, moduleName2);
    }

    private static final boolean getAllDependencies$dfs(JavaModuleGraph this$0, LinkedHashSet<String> visited2, String moduleName2) {
        JavaModule object3 = this$0.module.invoke(moduleName2);
        Object object = object3 instanceof JavaModule.Explicit ? (JavaModule.Explicit)object3 : null;
        if (object == null || (object = ((JavaModule.Explicit)object).getModuleInfo()) == null) {
            return false;
        }
        Object moduleInfo = object;
        for (JavaModuleInfo.Requires requires : ((JavaModuleInfo)moduleInfo).getRequires()) {
            String dependencyModuleName = requires.component1();
            boolean isTransitive = requires.component2();
            if (!isTransitive || !visited2.add(dependencyModuleName)) continue;
            JavaModuleGraph.getAllDependencies$dfs(this$0, visited2, dependencyModuleName);
        }
        return true;
    }

    private static final boolean reads$dfs(LinkedHashSet<String> visited2, JavaModuleGraph this$0, String $dependencyName, String name2) {
        if (!visited2.add(name2)) {
            return false;
        }
        JavaModule javaModule = this$0.module.invoke(name2);
        if (javaModule == null) {
            return false;
        }
        JavaModule module2 = javaModule;
        JavaModule javaModule2 = module2;
        if (javaModule2 instanceof JavaModule.Automatic) {
            return true;
        }
        if (javaModule2 instanceof JavaModule.Explicit) {
            for (JavaModuleInfo.Requires requires : ((JavaModule.Explicit)module2).getModuleInfo().getRequires()) {
                String dependencyModuleName = requires.component1();
                boolean isTransitive = requires.component2();
                if (Intrinsics.areEqual(dependencyModuleName, $dependencyName)) {
                    return true;
                }
                if (isTransitive && JavaModuleGraph.reads$dfs(visited2, this$0, $dependencyName, dependencyModuleName)) {
                    return true;
                }
                if (!isTransitive || !JavaModuleGraph.reads$dfs(visited2, this$0, $dependencyName, $dependencyName)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalStateException(("Unsupported module type: " + module2).toString());
    }
}

