/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.RubyClass;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.specialized.RubyObjectSpecializer;

public class RawFieldVariableAccessor
extends FieldVariableAccessor {
    public RawFieldVariableAccessor(RubyClass realClass, boolean unwrapInSet, Class<?> toJava, Class<?> returnType, String name2, int index2, int classId, MethodHandle getter, MethodHandle setter) {
        super(realClass, name2, index2, classId, RawFieldVariableAccessor.wrapGetter(getter, realClass, returnType), RawFieldVariableAccessor.wrapSetter(setter, realClass, unwrapInSet, toJava, returnType));
    }

    @Override
    protected MethodHandle wrapSetter(MethodHandle setter) {
        return setter;
    }

    protected static MethodHandle wrapSetter(MethodHandle setter, RubyClass realClass, boolean unwrap, Class<?> toJava, Class<?> basetype) {
        try {
            if (!unwrap) {
                if (realClass.getIsReifiedExtendedJavaClass() == Boolean.TRUE) {
                    MethodHandle cjpUnwrap = Binder.from(realClass.reifiedClass(), ConcreteJavaProxy.class, Object.class).dropLast().cast(Object.class, ConcreteJavaProxy.class).invokeVirtual(RubyObjectSpecializer.LOOKUP, "unwrap");
                    MethodHandle wrapperSetter = Binder.from(Object.class, realClass.reifiedClass(), ConcreteJavaProxy.class, Object.class).permute(0, 2).cast(Void.TYPE, realClass.reifiedClass(), basetype).invoke(setter);
                    MethodHandle temp = MethodHandles.foldArguments(wrapperSetter, cjpUnwrap);
                    return temp;
                }
                return setter;
            }
            if (realClass.getIsReifiedExtendedJavaClass() == Boolean.TRUE) {
                MethodHandle cjpUnwrap = Binder.from(realClass.reifiedClass(), ConcreteJavaProxy.class, Object.class).dropLast().cast(Object.class, ConcreteJavaProxy.class).invokeVirtual(RubyObjectSpecializer.LOOKUP, "unwrap");
                MethodHandle wrapperSetConvert = Binder.from(Object.class, realClass.reifiedClass(), ConcreteJavaProxy.class, Object.class).dropFirst(2).cast(Object.class, IRubyObject.class).insert(1, toJava).invokeVirtual(RubyObjectSpecializer.LOOKUP, "toJava");
                MethodHandle wrapperSetter = Binder.from(Object.class, Object.class, realClass.reifiedClass(), ConcreteJavaProxy.class, Object.class).permute(1, 0).cast(Void.TYPE, realClass.reifiedClass(), basetype).invoke(setter);
                MethodHandle temp = MethodHandles.foldArguments(wrapperSetter, wrapperSetConvert);
                temp = MethodHandles.foldArguments(temp, cjpUnwrap);
                return temp;
            }
            MethodHandle wrapperSetConvert = Binder.from(Object.class, realClass.reifiedClass(), Object.class).dropFirst().cast(Object.class, IRubyObject.class).insert(1, toJava).invokeVirtual(RubyObjectSpecializer.LOOKUP, "toJava");
            MethodHandle wrapperSetter = Binder.from(Object.class, Object.class, realClass.reifiedClass(), Object.class).permute(1, 0).cast(Void.TYPE, realClass.reifiedClass(), basetype).invoke(setter);
            MethodHandle temp = MethodHandles.foldArguments(wrapperSetter, wrapperSetConvert);
            return temp;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            RaiseException r = realClass.getClassRuntime().newRuntimeError("JRuby bug detected. Please file an issue if not already filed. Raw Field Accessor Setter gave errors: " + e.getMessage());
            r.initCause(e);
            throw r;
        }
    }

    protected static MethodHandle wrapGetter(MethodHandle getter, RubyClass realClass, Class<?> basetype) {
        try {
            MethodHandle wrapperGet = Binder.from(IRubyObject.class, basetype, new Class[0]).cast(IRubyObject.class, Object.class).insert(0, realClass.getRuntime()).invokeStatic(RubyObjectSpecializer.LOOKUP, JavaUtil.class, "convertJavaToUsableRubyObject");
            MethodHandle temp = MethodHandles.filterReturnValue(getter, wrapperGet);
            if (realClass.getIsReifiedExtendedJavaClass() == Boolean.TRUE) {
                MethodHandle cjpUnwrap = Binder.from(realClass.reifiedClass(), Object.class, new Class[0]).cast(Object.class, ConcreteJavaProxy.class).invokeVirtual(RubyObjectSpecializer.LOOKUP, "unwrap");
                temp = MethodHandles.filterReturnValue(cjpUnwrap, temp);
            }
            return temp;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            RaiseException r = realClass.getClassRuntime().newRuntimeError("JRuby bug detected. Please file an issue if not already filed. Raw Field Accessor getter gave errors: " + e.getMessage());
            r.initCause(e);
            throw r;
        }
    }
}

