!
subroutine uv_chop_comm(line,rname,error)
  use phys_const
  use gkernel_interfaces
  use gkernel_types
  use image_def
  use gbl_message
  use imager_interfaces, only : map_message
  !----------------------------------------------------------------------
  ! @ private
  !*
  !   IMAGER -- Support for command UV_CHOP  
  !     UV_CHOP UvData KEY UvFileGenericName
  !
  ! "Chop" into separate files a UV data file according to the specified
  ! KEY.  KEY can be
  !   DATES
  !   FIELDS
  !   PROPER_MOTION
  ! and more choices may come (e.g. STOKES ?)
  !----------------------------------------------------------------------
  character(len=*), intent(in)    :: rname  !! Command name
  character(len=*), intent(in)    :: line   !! Command line
  logical,          intent(inout) :: error  !! Errorflag
  !
  ! Constants
  integer(kind=4), parameter :: code_mosaic_phase=1  ! Mosaic UV table with phase offsets
  integer(kind=4), parameter :: code_mosaic_point=2  ! Mosaic UV table with pointing offsets
  integer(kind=4), parameter :: code_mosaic_field=3  ! Mosaic UV table with Fields ID 
  integer, parameter :: mkey=3
  character(len=16) :: vkey(mkey)
  data vkey /'DATES','FIELDS','PROPER_MOTION'/
  !
  ! Local ---
  type(gildas) :: chopped
  type(gildas) :: whole
  real(kind=4), allocatable :: dwhole(:,:)
  real(kind=4), allocatable :: dchopped(:,:)
  character(len=filename_length) :: name
  character(len=filename_length) :: generic
  !
  character(len=65) :: chain
  character(len=16) :: key, argum
  integer(kind=4) :: code,ier,n
  integer(kind=4) :: nlast,mvisi
  integer(kind=4) :: jv,iv,ifi,kfi,nfi,mfi
  integer(kind=4) :: xcol,ycol
  real(kind=8) :: doffx,doffy,ra,dec
  real(kind=8), allocatable :: doff(:,:),dtmp(:,:)
  type(projection_t) :: proj
  !
  ! Initialization
  call gildas_null(chopped,type='UVT')
  call gildas_null(whole,type='UVT')
  !
  ! Get whole header and copy it to the chopped header
  call sic_ch(line,0,1,generic,jv,.true.,error)
  if (error) return
  call sic_parse_file(generic,' ','.uvt',whole%file)
  call gdf_read_header(whole,error)
  if (error) then
    call map_message(seve%e,rname,'Cannot open '//trim(whole%file))
    return
  endif
  !
  ! Get the keyword
  call sic_ke(line,0,2,argum,n,.true.,error)
  if (error) return
  call sic_ambigs (rname,argum,key,n,vkey,mkey,error)
  if (error) return
  !
  ! Prepare the Field headers
  call gdf_copy_header(whole,chopped,error)
  if (error) return
  call sic_ch(line,0,3,generic,jv,.false.,error)
  if (error) return
  !
  ! Keep the trailing columns as they are.
  ! If they do not exist, the only good keyword is DATES
  xcol = 0
  ycol = 0
  code = 0
  if (chopped%gil%ntrail.eq.0) then
    if (key.ne.'DATES') then
      call map_message(seve%e,rname,'No extra column, only DATES keyword allowed')
      error = .true.
      return
    endif
    xcol = code_uvt_date
    ycol = 0
  else  
    !
    ! Check mosaic kind
    if (key.eq.'FIELDS') then
      if (chopped%gil%column_pointer(code_uvt_xoff).ne.0) then
        chain = 'Splitting a Pointing mosaic'
        xcol = chopped%gil%column_pointer(code_uvt_xoff)
        ycol = chopped%gil%column_pointer(code_uvt_yoff)
        code = code_mosaic_point
      else if (chopped%gil%column_pointer(code_uvt_loff).ne.0) then
        chain = 'Splitting a Phase mosaic'
        xcol = chopped%gil%column_pointer(code_uvt_loff)
        ycol = chopped%gil%column_pointer(code_uvt_moff)
        code = code_mosaic_phase
      else if (chopped%gil%column_pointer(code_uvt_id).ne.0) then
        chain = 'Splitting fields based on Source ID only'
        xcol = chopped%gil%column_pointer(code_uvt_id)        
        ycol = 0
        code = code_mosaic_field
      endif
      call map_message(seve%i,rname,chain)
    else if (key.eq.'DATES') then
      xcol = code_uvt_date
      ycol = 0
    else if (key.eq.'PROPER_MOTION') then
      ! Undefined yet...
      ! xcol = chopped%gil%column_pointer(code_uvt_pmra)
      ! ycol = chopped%gil%column_pointer(code_uvt_pmdec)
      call map_message(seve%e,rname,'PROPER_MOTION not yet supported')
      call map_message(seve%i,rname,'Use UV_SHIFT first to get a common reference',1)
      error = .true.
    endif
  endif
  nlast = chopped%gil%dim(1)
  !
  ! Read data
  allocate(dwhole(whole%gil%dim(1),whole%gil%dim(2)),stat=ier)
  if (failed_allocate(rname,'Mosaic uv table',ier,error)) return
  call gdf_read_data(whole,dwhole,error)
  if (error) return
  call map_message(seve%i,rname,'Finished reading data')
  !
  ! Scan the list of offset
  doffx = dwhole(xcol,1)
  if (ycol.ne.0) then
    doffy = dwhole(ycol,1)
  else
    doffy = 0
  endif
  !
  ! Allow up to MFI different values
  nfi = 1
  mfi = 100
  allocate(doff(3,mfi),stat=ier)
  doff(1,1) = doffx
  doff(2,1) = doffy
  doff(3,1) = 1
  !
  do iv=2,whole%gil%nvisi
    kfi = 0
    do ifi=1,nfi
      doffx = dwhole(xcol,iv)
      if (ycol.ne.0) doffy = dwhole(ycol,iv)
      if (doffx.eq.doff(1,ifi)) then
        if (doffy.eq.doff(2,ifi)) then
          kfi = ifi
          doff(3,kfi) = doff(3,kfi)+1
          exit
        endif
      endif
    enddo ! ifi
    ! New chopped => Initialize
    if (kfi.eq.0) then
      if (nfi.eq.mfi) then
        allocate(dtmp(3,2*mfi),stat=ier)
        dtmp(:,1:mfi) = doff(:,:)
        deallocate(doff)
        allocate(doff(3,2*mfi),stat=ier)
        doff(:,:) = dtmp
        deallocate(dtmp)
        mfi = 2*mfi
      endif
      nfi = nfi+1
      doff(1,nfi) = doffx
      doff(2,nfi) = doffy 
      doff(3,nfi) = 1
    endif
  enddo ! iv
  write(chain,'(A,I0,A)') 'Chopping file in ',nfi,' pieces'
  call map_message(seve%i,rname,chain)
  !
  ! Allocate enough space for chopped uv table
  mvisi = 0
  do ifi=1,nfi
    mvisi = max(nint(doff(3,ifi)),mvisi)
  enddo
  allocate(dchopped(nlast,mvisi),stat=ier)
  if (failed_allocate(rname,'Field uv table',ier,error)) return
  !
  ! Create, fill, and write the output UV tables
  call gwcs_projec(whole%gil%a0,whole%gil%d0,whole%gil%pang,whole%gil%ptyp,proj,error)
  if (error) return
  do ifi=1,nfi
    write(name,'(A,I0)') trim(generic)//'-',ifi
    call sic_parse_file(name,' ','.uvt',chopped%file)
    call map_message(seve%i,rname,'Writing '//chopped%file)
    chopped%gil%nvisi = doff(3,ifi)
    chopped%gil%dim(2) = chopped%gil%nvisi
    !
    ! No specific case for FIELDS: will end up with a degenerate Mosaic
    ! A specific case would be obtained by using FIELDS instead of NOTHING
    if (key.eq."NOTHING") then  ! Could be for FIELDS instead
      call rel_to_abs(proj,doff(1,ifi),doff(2,ifi),ra,dec,1)
      chopped%gil%ra = ra
      chopped%gil%dec = dec
      if (code.eq.code_mosaic_phase) then
        chopped%gil%a0 = ra
        chopped%gil%d0 = dec
      endif
    endif
    !
    jv = 0
    do iv=1,whole%gil%nvisi
      doffx = dwhole(xcol,iv)
      if (doffx.eq.doff(1,ifi)) then
        if (ycol.eq.0) then
          jv = jv+1
          dchopped(:,jv) = dwhole(:,iv)
        else if (dwhole(ycol,iv).eq.doff(2,ifi)) then
          jv = jv+1
          dchopped(:,jv) = dwhole(:,iv)
        endif
      endif
    enddo    
    chopped%gil%nvisi = jv
    !
    call gdf_create_image(chopped,error)
    if (error) return
    chopped%blc = 0
    chopped%trc = 0
    call gdf_write_data(chopped,dchopped,error)
    if (error) return
    call gdf_close_image(chopped,error)
    if (error) return
  enddo ! ifi
end subroutine uv_chop_comm
