/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.cli.Option;
import groovy.lang.Lazy;
import groovy.transform.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;
import org.codehaus.groovy.transform.LazyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class FieldASTTransformation
extends ClassCodeExpressionTransformer
implements ASTTransformation {
    private static final ClassNode MY_TYPE = ClassHelper.make(Field.class);
    private static final ClassNode LAZY_TYPE = ClassHelper.make(Lazy.class);
    private static final ClassNode OPTION_TYPE = ClassHelper.make(Option.class);
    private static final ClassNode ASTTRANSFORMCLASS_TYPE = ClassHelper.make(GroovyASTTransformationClass.class);
    private DeclarationExpression candidate;
    private FieldNode fieldNode;
    private String variableName;
    private ClosureExpression currentClosure;
    private boolean insideScriptBody;
    private SourceUnit sourceUnit;

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.toString(nodes));
        }
        if (!MY_TYPE.equals(((AnnotationNode)nodes[0]).getClassNode())) {
            return;
        }
        this.sourceUnit = source;
        if (nodes[1] instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)nodes[1];
            ClassNode declaringClass = de.getDeclaringClass();
            if (!declaringClass.isScript()) {
                this.addError("Annotation @" + MY_TYPE.getNameWithoutPackage() + " can only be used within a Script.", de);
                return;
            }
            if (de.isMultipleAssignmentDeclaration()) {
                this.addError("Annotation @" + MY_TYPE.getNameWithoutPackage() + " not supported with multiple assignment notation.", de);
                return;
            }
            VariableExpression ve = de.getVariableExpression();
            this.variableName = ve.getName();
            this.candidate = de;
            this.fieldNode = new FieldNode(this.variableName, ve.getModifiers(), ve.getType(), null, de.getRightExpression());
            this.fieldNode.setSourcePosition(de);
            declaringClass.addField(this.fieldNode);
            if (this.fieldNode.isFinal()) {
                if (!de.getAnnotations(OPTION_TYPE).isEmpty()) {
                    this.addError("Can't have a final field also annotated with @" + OPTION_TYPE.getNameWithoutPackage(), de);
                }
            } else {
                String setterName = GeneralUtils.getSetterName(this.variableName);
                declaringClass.addMethod(setterName, 4097, ClassHelper.VOID_TYPE, GeneralUtils.params(GeneralUtils.param(ve.getType(), this.variableName)), ClassNode.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), this.variableName), GeneralUtils.varX(this.variableName)))));
            }
            for (AnnotationNode annotation : de.getAnnotations()) {
                if (annotation.getClassNode().equals(LAZY_TYPE)) {
                    LazyASTTransformation.visitField(this, annotation, this.fieldNode);
                }
                if (!FieldASTTransformation.notTransform(annotation.getClassNode()) && !FieldASTTransformation.acceptableTransform(annotation)) continue;
                this.fieldNode.addAnnotation(annotation);
            }
            super.visitClass(declaringClass);
            new VariableScopeVisitor(source).visitClass(declaringClass);
        }
    }

    private static boolean notTransform(ClassNode annotationType) {
        return annotationType.getAnnotations(ASTTRANSFORMCLASS_TYPE).isEmpty();
    }

    private static boolean acceptableTransform(AnnotationNode annotation) {
        return !annotation.getClassNode().equals(MY_TYPE);
    }

    @Override
    public void visitMethod(MethodNode node) {
        boolean old = this.insideScriptBody;
        if (node.isScriptBody()) {
            this.insideScriptBody = true;
        }
        super.visitMethod(node);
        this.insideScriptBody = old;
    }

    @Override
    public Expression transform(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)expr;
            if (de.getLeftExpression() == this.candidate.getVariableExpression()) {
                if (this.insideScriptBody) {
                    return GeneralUtils.nullX();
                }
                this.addError("Annotation @" + MY_TYPE.getNameWithoutPackage() + " can only be used within a Script body.", expr);
                return expr;
            }
        } else if (expr instanceof ClosureExpression) {
            ClosureExpression old = this.currentClosure;
            this.currentClosure = (ClosureExpression)expr;
            this.visitClosureExpression(this.currentClosure);
            this.currentClosure = old;
        } else if (expr instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expr;
            if (this.insideScriptBody && this.currentClosure != null && ve.getName().equals(this.variableName)) {
                this.adjustToClassVar(ve);
            }
        } else if (expr instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)expr;
            if (this.insideScriptBody && cce.isUsingAnonymousInnerClass()) {
                List<Expression> arguments = ((ArgumentListExpression)cce.getArguments()).getExpressions();
                int n = arguments.size();
                for (int i = 0; i < n; ++i) {
                    Expression argument = arguments.get(i);
                    if (!this.matchesCandidate(argument)) continue;
                    this.adjustConstructorAndFields(i, cce.getType());
                    ConstructorCallExpression copy = new ConstructorCallExpression(cce.getType(), this.adjustedArgList(argument, arguments));
                    copy.setUsingAnonymousInnerClass(true);
                    copy.setSourcePosition(cce);
                    copy.copyNodeMetaData(cce);
                    return copy;
                }
            }
        }
        return expr.transformExpression(this);
    }

    private boolean matchesCandidate(Expression expr) {
        return expr instanceof VariableExpression && ((VariableExpression)expr).getAccessedVariable() == this.candidate.getVariableExpression().getAccessedVariable();
    }

    private void adjustToClassVar(VariableExpression expr) {
        expr.setAccessedVariable(this.fieldNode);
        VariableScope variableScope = this.currentClosure.getVariableScope();
        Iterator<Variable> iterator = variableScope.getReferencedLocalVariablesIterator();
        while (iterator.hasNext()) {
            Variable next = iterator.next();
            if (!next.getName().equals(this.variableName)) continue;
            iterator.remove();
        }
        variableScope.putReferencedClassVariable(this.fieldNode);
    }

    private void adjustConstructorAndFields(int skipIndex, ClassNode type) {
        List<ConstructorNode> constructors = type.getDeclaredConstructors();
        if (constructors.size() == 1) {
            ConstructorNode constructor = constructors.get(0);
            Parameter[] params = constructor.getParameters();
            Parameter[] newParams = new Parameter[params.length - 1];
            int to = 0;
            for (int from = 0; from < params.length; ++from) {
                if (from == skipIndex) continue;
                newParams[to++] = params[from];
            }
            type.removeConstructor(constructor);
            ClassNodeUtils.addGeneratedConstructor(type, constructor.getModifiers(), newParams, constructor.getExceptions(), constructor.getCode());
            type.removeField(this.variableName);
        }
    }

    private Expression adjustedArgList(Expression skip, List<Expression> origArgs) {
        ArrayList<Expression> newArgs = new ArrayList<Expression>(origArgs.size() - 1);
        for (Expression origArg : origArgs) {
            if (skip == origArg) continue;
            newArgs.add(this.transform(origArg));
        }
        return new ArgumentListExpression(newArgs);
    }
}

