/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImplKt;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.util.KlibMetadataHelpersKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"buildKotlinMetadataLibrary", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "serializedMetadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "destDir", "Ljava/io/File;", "cli"})
public final class MetadataUtilsKt {
    public static final void buildKotlinMetadataLibrary(@NotNull CompilerConfiguration configuration2, @NotNull SerializedMetadata serializedMetadata, @NotNull File destDir) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)serializedMetadata, (String)"serializedMetadata");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        KotlinAbiVersion kotlinAbiVersion = KotlinAbiVersion.Companion.getCURRENT();
        String string = KotlinCompilerVersion.getVersion();
        MetadataVersion metadataVersion = KlibMetadataHelpersKt.klibMetadataVersionOrDefault$default(configuration2, null, 1, null);
        KotlinLibraryVersioning versions2 = new KotlinLibraryVersioning(string, kotlinAbiVersion, metadataVersion, null, 8, null);
        List list = CollectionsKt.emptyList();
        String string2 = destDir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        String string3 = configuration2.get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string3);
        KotlinLibraryWriterImplKt.buildKotlinLibrary(list, serializedMetadata, null, versions2, string2, string3, true, null, BuiltInsPlatform.COMMON, CollectionsKt.emptyList());
    }
}

