# -*- coding: utf-8 -*- #
# Copyright 2024 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Command sub-group for Intercept Endpoint Groups."""


from googlecloudsdk.calliope import base


DETAILED_HELP = {
    'brief': 'Manage Intercept Endpoint Group resources.',
    'DESCRIPTION': """
        The gcloud intercept-endpoint-groups command group lets you create,
        delete and manage endpoint groups.
        """
}


@base.DefaultUniverseOnly
@base.ReleaseTracks(
    base.ReleaseTrack.ALPHA, base.ReleaseTrack.BETA, base.ReleaseTrack.GA
)
class InterceptEndpointGroups(base.Group):
  """Manage Intercept Endpoint Group resources."""
  category = base.NETWORK_SECURITY_CATEGORY

  detailed_help = DETAILED_HELP
