# -*- coding: utf-8 -*- #
# Copyright 2019 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Commands for reading and manipulating instant snapshots."""


from googlecloudsdk.calliope import base

DETAILED_HELP = {
    'brief': 'Create, list and delete Compute Engine instant snapshots',
}


@base.UniverseCompatible
@base.ReleaseTracks(base.ReleaseTrack.GA,
                    base.ReleaseTrack.BETA, base.ReleaseTrack.ALPHA)
class InstantSnapshots(base.Group):
  """List, create, and delete Compute Engine instant snapshots."""


InstantSnapshots.category = base.INSTANCES_CATEGORY

InstantSnapshots.detailed_help = {
    'brief': 'Create, list and delete Compute Engine instant snapshots',
    'DESCRIPTION': """\
        List, create, describe, and delete Compute Engine instant snapshots.

        See also: [Snapshots API](https://cloud.google.com/compute/docs/reference/rest/beta/instantSnapshots).
    """,
}
