"""Generated message classes for hypercomputecluster version v1.

The Cluster Director API allows you to deploy, manage, and monitor clusters
that run AI, ML, or HPC workloads.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'hypercomputecluster'


class BootDisk(_messages.Message):
  r"""A [Persistent disk](https://cloud.google.com/compute/docs/disks) used as
  the boot disk for a Compute Engine VM instance.

  Fields:
    sizeGb: Required. Immutable. Size of the disk in gigabytes. Must be at
      least 10GB.
    type: Required. Immutable. [Persistent disk
      type](https://cloud.google.com/compute/docs/disks#disk-types), in the
      format `projects/{project}/zones/{zone}/diskTypes/{disk_type}`.
  """

  sizeGb = _messages.IntegerField(1)
  type = _messages.StringField(2)


class BucketReference(_messages.Message):
  r"""A reference to a [Google Cloud
  Storage](https://cloud.google.com/storage) bucket.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CheckClusterHealth(_messages.Message):
  r"""When set in OperationStep, indicates that cluster health check should be
  performed.
  """



class Cluster(_messages.Message):
  r"""A collection of virtual machines and connected resources forming a high-
  performance computing cluster capable of running large-scale, tightly
  coupled workloads. A cluster combines a set a compute resources that perform
  computations, storage resources that contain inputs and store outputs, an
  orchestrator that is responsible for assigning jobs to compute resources,
  and network resources that connect everything together.

  Messages:
    ComputeResourcesValue: Optional. Compute resources available to the
      cluster. Keys specify the ID of the compute resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources)
      applied to the cluster. Labels can be used to organize clusters and to
      filter them in queries.
    NetworkResourcesValue: Optional. Network resources available to the
      cluster. Must contain at most one value. Keys specify the ID of the
      network resource by which it can be referenced elsewhere, and must
      conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
      (lower-case, alphanumeric, and at most 63 characters).
    StorageResourcesValue: Optional. Storage resources available to the
      cluster. Keys specify the ID of the storage resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).

  Fields:
    computeResources: Optional. Compute resources available to the cluster.
      Keys specify the ID of the compute resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    createTime: Output only. Time that the cluster was originally created.
    description: Optional. User-provided description of the cluster.
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) applied to the cluster. Labels can be used to organize
      clusters and to filter them in queries.
    name: Identifier. [Relative resource name](https://google.aip.dev/122) of
      the cluster, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    networkResources: Optional. Network resources available to the cluster.
      Must contain at most one value. Keys specify the ID of the network
      resource by which it can be referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    orchestrator: Optional. Orchestrator that is responsible for scheduling
      and running jobs on the cluster.
    reconciling: Output only. Indicates whether changes to the cluster are
      currently in flight. If this is `true`, then the current state might not
      match the cluster's intended state.
    storageResources: Optional. Storage resources available to the cluster.
      Keys specify the ID of the storage resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    updateTime: Output only. Time that the cluster was most recently updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ComputeResourcesValue(_messages.Message):
    r"""Optional. Compute resources available to the cluster. Keys specify the
    ID of the compute resource by which it can be referenced elsewhere, and
    must conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
    (lower-case, alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a ComputeResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ComputeResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ComputeResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A ComputeResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ComputeResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) applied to the cluster. Labels can be used to organize clusters
    and to filter them in queries.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NetworkResourcesValue(_messages.Message):
    r"""Optional. Network resources available to the cluster. Must contain at
    most one value. Keys specify the ID of the network resource by which it
    can be referenced elsewhere, and must conform to
    [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
    alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a NetworkResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        NetworkResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NetworkResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A NetworkResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('NetworkResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StorageResourcesValue(_messages.Message):
    r"""Optional. Storage resources available to the cluster. Keys specify the
    ID of the storage resource by which it can be referenced elsewhere, and
    must conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
    (lower-case, alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a StorageResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        StorageResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StorageResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A StorageResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('StorageResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  computeResources = _messages.MessageField('ComputeResourcesValue', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  networkResources = _messages.MessageField('NetworkResourcesValue', 6)
  orchestrator = _messages.MessageField('Orchestrator', 7)
  reconciling = _messages.BooleanField(8)
  storageResources = _messages.MessageField('StorageResourcesValue', 9)
  updateTime = _messages.StringField(10)


class ComputeInstance(_messages.Message):
  r"""Details about a Compute Engine
  [instance](https://cloud.google.com/compute/docs/instances).

  Fields:
    instance: Output only. Name of the VM instance, in the format
      `projects/{project}/zones/{zone}/instances/{instance}`.
  """

  instance = _messages.StringField(1)


class ComputeInstanceSlurmNodeSet(_messages.Message):
  r"""When set in a SlurmNodeSet, indicates that the nodeset should be backed
  by Compute Engine VM instances.

  Messages:
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
      should be applied to each VM instance in the nodeset.

  Fields:
    bootDisk: Optional. Boot disk for the compute instance
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) that should be applied to each VM instance in the nodeset.
    startupScript: Optional. [Startup
      script](https://cloud.google.com/compute/docs/instances/startup-
      scripts/linux) to be run on each VM instance in the nodeset. Max 256KB.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) that should be applied to each VM instance in the nodeset.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('BootDisk', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  startupScript = _messages.StringField(3)


class ComputeResource(_messages.Message):
  r"""A resource defining how virtual machines and accelerators should be
  provisioned for the cluster.

  Fields:
    config: Required. Immutable. Configuration for this compute resource,
      which describes how it should be created at runtime.
  """

  config = _messages.MessageField('ComputeResourceConfig', 1)


class ComputeResourceConfig(_messages.Message):
  r"""Describes how a compute resource should be created at runtime.

  Fields:
    newFlexStartInstances: Optional. Immutable. If set, indicates that this
      resource should use flex-start VMs.
    newOnDemandInstances: Optional. Immutable. If set, indicates that this
      resource should use on-demand VMs.
    newReservedInstances: Optional. Immutable. If set, indicates that this
      resource should use reserved VMs.
    newSpotInstances: Optional. Immutable. If set, indicates that this
      resource should use spot VMs.
  """

  newFlexStartInstances = _messages.MessageField('NewFlexStartInstancesConfig', 1)
  newOnDemandInstances = _messages.MessageField('NewOnDemandInstancesConfig', 2)
  newReservedInstances = _messages.MessageField('NewReservedInstancesConfig', 3)
  newSpotInstances = _messages.MessageField('NewSpotInstancesConfig', 4)


class CreateFilestoreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a new filestore instance
  should be created.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class CreateLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  created.
  """



class CreateLustreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a new lustre instance should
  be created.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class CreateNetwork(_messages.Message):
  r"""When set in OperationStep, indicates that a new network should be
  created.

  Fields:
    network: Output only. Name of the network to create, in the format
      `projects/{project}/global/networks/{network}`.
  """

  network = _messages.StringField(1)


class CreateNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be created.

  Fields:
    nodesets: Output only. Name of the nodeset to create
  """

  nodesets = _messages.StringField(1, repeated=True)


class CreateOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  created.
  """



class CreatePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be created.

  Fields:
    partitions: Output only. Name of the partition to create
  """

  partitions = _messages.StringField(1, repeated=True)


class CreatePrivateServiceAccess(_messages.Message):
  r"""When set in OperationStep, indicates that a new private service access
  should be created.
  """



class CreateStorageBucket(_messages.Message):
  r"""When set in OperationStep, indicates that a new storage bucket should be
  created.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class DeleteFilestoreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a Filestore instance should be
  deleted.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class DeleteLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  deleted.
  """



class DeleteLustreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a Lustre instance should be
  deleted.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class DeleteNetwork(_messages.Message):
  r"""When set in OperationStep, indicates network deletion step with the
  resource name.

  Fields:
    network: Output only. Name of the network to delete, in the format
      `projects/{project}/global/networks/{network}`.
  """

  network = _messages.StringField(1)


class DeleteNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be deleted.

  Fields:
    nodesets: Output only. Name of the nodeset to delete
  """

  nodesets = _messages.StringField(1, repeated=True)


class DeleteOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  deleted.
  """



class DeletePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be deleted.

  Fields:
    partitions: Output only. Name of the partition to delete
  """

  partitions = _messages.StringField(1, repeated=True)


class DeletePrivateServiceAccess(_messages.Message):
  r"""When set in OperationStep, indicates private service access deletion
  step.
  """



class DeleteStorageBucket(_messages.Message):
  r"""When set in OperationStep, indicates that Cloud Storage bucket should be
  deleted.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExistingBucketConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing [Google
  Cloud Storage](https://cloud.google.com/storage) bucket should be imported.

  Fields:
    bucket: Required. Immutable. Name of the Cloud Storage bucket to import.
  """

  bucket = _messages.StringField(1)


class ExistingFilestoreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing
  [Filestore](https://cloud.google.com/filestore) instance should be imported.

  Fields:
    filestore: Required. Immutable. Name of the Filestore instance to import,
      in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class ExistingLustreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance should be
  imported.

  Fields:
    lustre: Required. Immutable. Name of the Managed Lustre instance to
      import, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class ExistingNetworkConfig(_messages.Message):
  r"""When set in a NetworkResourceConfig, indicates that an existing network
  should be imported.

  Fields:
    network: Required. Immutable. Name of the network to import, in the format
      `projects/{project}/global/networks/{network}`.
    subnetwork: Required. Immutable. Particular subnetwork to use, in the
      format `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class FileShareConfig(_messages.Message):
  r"""Message describing filestore configuration

  Fields:
    capacityGb: Required. Size of the filestore in GB. Must be between 1024
      and 102400, and must meet scalability requirements described at
      https://cloud.google.com/filestore/docs/service-tiers.
    fileShare: Required. Filestore share location
  """

  capacityGb = _messages.IntegerField(1)
  fileShare = _messages.StringField(2)


class FilestoreReference(_messages.Message):
  r"""A reference to a [Filestore](https://cloud.google.com/filestore)
  instance.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class GcsAutoclassConfig(_messages.Message):
  r"""Message describing Google Cloud Storage autoclass configuration

  Enums:
    TerminalStorageClassValueValuesEnum: Optional. Terminal storage class of
      the autoclass bucket

  Fields:
    enabled: Required. Enables Auto-class feature.
    terminalStorageClass: Optional. Terminal storage class of the autoclass
      bucket
  """

  class TerminalStorageClassValueValuesEnum(_messages.Enum):
    r"""Optional. Terminal storage class of the autoclass bucket

    Values:
      TERMINAL_STORAGE_CLASS_UNSPECIFIED: Unspecified terminal storage class
    """
    TERMINAL_STORAGE_CLASS_UNSPECIFIED = 0

  enabled = _messages.BooleanField(1)
  terminalStorageClass = _messages.EnumField('TerminalStorageClassValueValuesEnum', 2)


class GcsHierarchicalNamespaceConfig(_messages.Message):
  r"""Message describing Google Cloud Storage hierarchical namespace
  configuration

  Fields:
    enabled: Required. Enables hierarchical namespace setup for the bucket.
  """

  enabled = _messages.BooleanField(1)


class HypercomputeclusterProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. ID of the cluster to create. Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    parent: Required. Parent location in which the cluster should be created,
      in the format `projects/{project}/locations/{location}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersDeleteRequest object.

  Fields:
    name: Required. Name of the cluster to delete, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class HypercomputeclusterProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. Name of the cluster to retrieve, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsClustersListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. [Filter](https://google.aip.dev/160) to apply to the
      returned results.
    orderBy: Optional. How to order the resulting clusters. Must be one of the
      following strings: * `name` * `name desc` * `create_time` * `create_time
      desc` If not specified, clusters will be returned in an arbitrary order.
    pageSize: Optional. Maximum number of clusters to return. The service may
      return fewer than this value.
    pageToken: Optional. A page token received from a previous `ListClusters`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListClusters` must match the call that
      provided the page token.
    parent: Required. Parent location of the clusters to list, in the format
      `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Identifier. [Relative resource name](https://google.aip.dev/122) of
      the cluster, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
    updateMask: Optional. Mask specifying which fields in the cluster to
      update. All paths must be specified explicitly - wildcards are not
      supported. At least one path must be provided.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class HypercomputeclusterProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class HypercomputeclusterProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ListClustersResponse(_messages.Message):
  r"""Response message for ListClusters.

  Fields:
    clusters: Clusters in the specified location.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is absent, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LustreReference(_messages.Message):
  r"""A reference to a [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class NetworkReference(_messages.Message):
  r"""A reference to a [VPC network](https://cloud.google.com/vpc/docs/vpc) in
  Google Compute Engine.

  Fields:
    network: Output only. Name of the network, in the format
      `projects/{project}/global/networks/{network}`.
    subnetwork: Output only. Name of the particular subnetwork being used by
      the cluster, in the format
      `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NetworkResource(_messages.Message):
  r"""A resource representing a network that connects the various components
  of a cluster together.

  Fields:
    config: Immutable. Configuration for this network resource, which
      describes how it should be created or imported. This field only controls
      how the network resource is initially created or imported. Subsequent
      changes to the network resource should be made via the resource's API
      and will not be reflected in the configuration.
    network: Reference to a network in Google Compute Engine.
  """

  config = _messages.MessageField('NetworkResourceConfig', 1)
  network = _messages.MessageField('NetworkReference', 2)


class NetworkResourceConfig(_messages.Message):
  r"""Describes how a network resource should be initialized. Each network
  resource can either be imported from an existing Google Cloud resource or
  initialized when the cluster is created.

  Fields:
    existingNetwork: Optional. Immutable. If set, indicates that an existing
      network should be imported.
    newNetwork: Optional. Immutable. If set, indicates that a new network
      should be created.
  """

  existingNetwork = _messages.MessageField('ExistingNetworkConfig', 1)
  newNetwork = _messages.MessageField('NewNetworkConfig', 2)


class NewBucketConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new [Google Cloud
  Storage](https://cloud.google.com/storage) bucket should be created.

  Enums:
    StorageClassValueValuesEnum: Optional. Immutable. If set, uses the
      provided storage class as the bucket's default storage class.

  Fields:
    autoclass: Optional. Immutable. If set, indicates that the bucket should
      use [Autoclass](https://cloud.google.com/storage/docs/autoclass).
    bucket: Required. Immutable. Name of the Cloud Storage bucket to create.
    hierarchicalNamespace: Optional. Immutable. If set, indicates that the
      bucket should use [hierarchical
      namespaces](https://cloud.google.com/storage/docs/hns-overview).
    storageClass: Optional. Immutable. If set, uses the provided storage class
      as the bucket's default storage class.
  """

  class StorageClassValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. If set, uses the provided storage class as the
    bucket's default storage class.

    Values:
      STORAGE_CLASS_UNSPECIFIED: Not set.
      STANDARD: Best for data that is frequently accessed.
      NEARLINE: Low-cost storage for data that is accessed less frequently.
      COLDLINE: Very low-cost storage for infrequently accessed data.
      ARCHIVE: Lowest-cost storage for data archiving, online backup, and
        disaster recovery.
    """
    STORAGE_CLASS_UNSPECIFIED = 0
    STANDARD = 1
    NEARLINE = 2
    COLDLINE = 3
    ARCHIVE = 4

  autoclass = _messages.MessageField('GcsAutoclassConfig', 1)
  bucket = _messages.StringField(2)
  hierarchicalNamespace = _messages.MessageField('GcsHierarchicalNamespaceConfig', 3)
  storageClass = _messages.EnumField('StorageClassValueValuesEnum', 4)


class NewFilestoreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new
  [Filestore](https://cloud.google.com/filestore) instance should be created.

  Enums:
    ProtocolValueValuesEnum: Optional. Immutable. Access protocol to use for
      all file shares in the instance. Defaults to NFS V3 if not set.
    TierValueValuesEnum: Required. Immutable. Service tier to use for the
      instance.

  Fields:
    description: Optional. Immutable. Description of the instance. Maximum of
      2048 characters.
    fileShares: Required. Immutable. File system shares on the instance.
      Exactly one file share must be specified.
    filestore: Required. Immutable. Name of the Filestore instance to create,
      in the format
      `projects/{project}/locations/{location}/instances/{instance}`
    protocol: Optional. Immutable. Access protocol to use for all file shares
      in the instance. Defaults to NFS V3 if not set.
    tier: Required. Immutable. Service tier to use for the instance.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. Access protocol to use for all file shares in the
    instance. Defaults to NFS V3 if not set.

    Values:
      PROTOCOL_UNSPECIFIED: Not set.
      NFSV3: NFS 3.0.
      NFSV41: NFS 4.1.
    """
    PROTOCOL_UNSPECIFIED = 0
    NFSV3 = 1
    NFSV41 = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Service tier to use for the instance.

    Values:
      TIER_UNSPECIFIED: Not set.
      ZONAL: Offers expanded capacity and performance scaling capabilities
        suitable for high-performance computing application requirements.
      REGIONAL: Offers features and availability needed for mission-critical,
        high-performance computing workloads.
    """
    TIER_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2

  description = _messages.StringField(1)
  fileShares = _messages.MessageField('FileShareConfig', 2, repeated=True)
  filestore = _messages.StringField(3)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class NewFlexStartInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that VM instances should
  be created using [Flex
  Start](https://cloud.google.com/compute/docs/instances/provisioning-models).

  Fields:
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    maxDuration: Required. Immutable. Specifies the time limit for created
      instances. Instances will be terminated at the end of this duration.
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  machineType = _messages.StringField(1)
  maxDuration = _messages.StringField(2)
  zone = _messages.StringField(3)


class NewLustreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance should be
  created.

  Fields:
    capacityGb: Required. Immutable. Storage capacity of the instance in
      gibibytes (GiB). Allowed values are between 18000 and 7632000.
    description: Optional. Immutable. Description of the Managed Lustre
      instance. Maximum of 2048 characters.
    filesystem: Required. Immutable. Filesystem name for this instance. This
      name is used by client-side tools, including when mounting the instance.
      Must be 8 characters or less and can only contain letters and numbers.
    lustre: Required. Immutable. Name of the Managed Lustre instance to
      create, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  capacityGb = _messages.IntegerField(1)
  description = _messages.StringField(2)
  filesystem = _messages.StringField(3)
  lustre = _messages.StringField(4)


class NewNetworkConfig(_messages.Message):
  r"""When set in a NetworkResourceConfig, indicates that a new network should
  be created.

  Fields:
    description: Optional. Immutable. Description of the network. Maximum of
      2048 characters.
    network: Required. Immutable. Name of the network to create, in the format
      `projects/{project}/global/networks/{network}`.
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NewOnDemandInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that on-demand (i.e.,
  using the standard provisioning model) VM instances should be created.

  Fields:
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  machineType = _messages.StringField(1)
  zone = _messages.StringField(2)


class NewReservedInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that VM instances should
  be created from a
  [reservation](https://cloud.google.com/compute/docs/instances/reservations-
  overview).

  Fields:
    reservation: Optional. Immutable. Name of the reservation from which VM
      instances should be created, in the format
      `projects/{project}/zones/{zone}/reservations/{reservation}`.
  """

  reservation = _messages.StringField(1)


class NewSpotInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that [spot
  VM](https://cloud.google.com/compute/docs/instances/spot) instances should
  be created.

  Enums:
    TerminationActionValueValuesEnum: Optional. Termination action for the
      instance. If not specified, Compute Engine sets the termination action
      to DELETE.

  Fields:
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    terminationAction: Optional. Termination action for the instance. If not
      specified, Compute Engine sets the termination action to DELETE.
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  class TerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Termination action for the instance. If not specified,
    Compute Engine sets the termination action to DELETE.

    Values:
      TERMINATION_ACTION_UNSPECIFIED: Not set.
      STOP: Compute Engine stops the Spot VM on preemption.
      DELETE: Compute Engine deletes the Spot VM on preemption.
    """
    TERMINATION_ACTION_UNSPECIFIED = 0
    STOP = 1
    DELETE = 2

  machineType = _messages.StringField(1)
  terminationAction = _messages.EnumField('TerminationActionValueValuesEnum', 2)
  zone = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    progress: Output only. Progress of the operation.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  progress = _messages.MessageField('OperationProgress', 4)
  requestedCancellation = _messages.BooleanField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OperationProgress(_messages.Message):
  r"""Message describing the progress of a cluster mutation long-running
  operation.

  Fields:
    steps: Output only. Steps and status of the operation.
  """

  steps = _messages.MessageField('OperationStep', 1, repeated=True)


class OperationStep(_messages.Message):
  r"""Message describing the status of a single step in a cluster mutation
  long-running operation.

  Enums:
    StateValueValuesEnum: Output only. State of the operation step.

  Fields:
    checkClusterHealth: Output only. If set, indicates that cluster health
      check is part of the operation.
    createFilestoreInstance: Output only. If set, indicates that new Filestore
      instance creation is part of the operation.
    createLoginNode: Output only. If set, indicates that new login node
      creation is part of the operation.
    createLustreInstance: Output only. If set, indicates that new Lustre
      instance creation is part of the operation.
    createNetwork: Output only. If set, indicates that new network creation is
      part of the operation.
    createNodeset: Output only. If set, indicates that new nodeset creation is
      part of the operation.
    createOrchestrator: Output only. If set, indicates that orchestrator
      creation is part of the operation.
    createPartition: Output only. If set, indicates that new partition
      creation is part of the operation.
    createPrivateServiceAccess: Output only. If set, indicates that new
      private service access creation is part of the operation.
    createStorageBucket: Output only. If set, indicates that new Cloud Storage
      bucket creation is part of the operation.
    deleteFilestoreInstance: Output only. If set, indicates that Filestore
      instance deletion is part of the operation.
    deleteLoginNode: Output only. If set, indicates that login node deletion
      is part of the operation.
    deleteLustreInstance: Output only. If set, indicates that Lustre instance
      deletion is part of the operation.
    deleteNetwork: Output only. If set, indicates that network deletion is
      part of the operation.
    deleteNodeset: Output only. If set, indicates that nodeset deletion is
      part of the operation.
    deleteOrchestrator: Output only. If set, indicates that orchestrator
      deletion is part of the operation.
    deletePartition: Output only. If set, indicates that partition deletion is
      part of the operation.
    deletePrivateServiceAccess: Output only. If set, indicates that private
      service access deletion is part of the operation.
    deleteStorageBucket: Output only. If set, indicates that Cloud Storage
      bucket deletion is part of the operation.
    state: Output only. State of the operation step.
    updateLoginNode: Output only. If set, indicates that login node update is
      part of the operation.
    updateNodeset: Output only. If set, indicates that nodeset update is part
      of the operation.
    updateOrchestrator: Output only. If set, indicates that an orchestrator
      update is part of the operation.
    updatePartition: Output only. If set, indicates that partition update is
      part of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the operation step.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      WAITING: Initial state before step execution starts.
      IN_PROGRESS: Step execution is running in progress.
      DONE: Step execution is completed.
    """
    STATE_UNSPECIFIED = 0
    WAITING = 1
    IN_PROGRESS = 2
    DONE = 3

  checkClusterHealth = _messages.MessageField('CheckClusterHealth', 1)
  createFilestoreInstance = _messages.MessageField('CreateFilestoreInstance', 2)
  createLoginNode = _messages.MessageField('CreateLoginNode', 3)
  createLustreInstance = _messages.MessageField('CreateLustreInstance', 4)
  createNetwork = _messages.MessageField('CreateNetwork', 5)
  createNodeset = _messages.MessageField('CreateNodeset', 6)
  createOrchestrator = _messages.MessageField('CreateOrchestrator', 7)
  createPartition = _messages.MessageField('CreatePartition', 8)
  createPrivateServiceAccess = _messages.MessageField('CreatePrivateServiceAccess', 9)
  createStorageBucket = _messages.MessageField('CreateStorageBucket', 10)
  deleteFilestoreInstance = _messages.MessageField('DeleteFilestoreInstance', 11)
  deleteLoginNode = _messages.MessageField('DeleteLoginNode', 12)
  deleteLustreInstance = _messages.MessageField('DeleteLustreInstance', 13)
  deleteNetwork = _messages.MessageField('DeleteNetwork', 14)
  deleteNodeset = _messages.MessageField('DeleteNodeset', 15)
  deleteOrchestrator = _messages.MessageField('DeleteOrchestrator', 16)
  deletePartition = _messages.MessageField('DeletePartition', 17)
  deletePrivateServiceAccess = _messages.MessageField('DeletePrivateServiceAccess', 18)
  deleteStorageBucket = _messages.MessageField('DeleteStorageBucket', 19)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  updateLoginNode = _messages.MessageField('UpdateLoginNode', 21)
  updateNodeset = _messages.MessageField('UpdateNodeset', 22)
  updateOrchestrator = _messages.MessageField('UpdateOrchestrator', 23)
  updatePartition = _messages.MessageField('UpdatePartition', 24)


class Orchestrator(_messages.Message):
  r"""The component responsible for scheduling and running workloads on the
  cluster as well as providing the user interface for interacting with the
  cluster at runtime.

  Fields:
    slurm: Optional. If set, indicates that the cluster should use Slurm as
      the orchestrator.
  """

  slurm = _messages.MessageField('SlurmOrchestrator', 1)


class SlurmLoginNodes(_messages.Message):
  r"""Configuration for Slurm [login
  nodes](https://slurm.schedmd.com/quickstart_admin.html#login) in the
  cluster. Login nodes are Compute Engine VM instances that allow users to
  access the cluster over SSH.

  Messages:
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
      should be applied to each login node instance.

  Fields:
    bootDisk: Optional. Boot disk for the login node.
    count: Required. Number of login node instances to create.
    enableOsLogin: Optional. Whether [OS
      Login](https://cloud.google.com/compute/docs/oslogin) should be enabled
      on login node instances.
    enablePublicIps: Optional. Whether login node instances should be assigned
      [external IP addresses](https://cloud.google.com/compute/docs/ip-
      addresses#externaladdresses).
    instances: Output only. Information about the login node instances that
      were created in Compute Engine.
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) that should be applied to each login node instance.
    machineType: Required. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use for
      login nodes, e.g. `n2-standard-2`.
    startupScript: Optional. [Startup
      script](https://cloud.google.com/compute/docs/instances/startup-
      scripts/linux) to be run on each login node instance. Max 256KB. The
      script must complete within the system-defined default timeout of 5
      minutes. For tasks that require more time, consider running them in the
      background using methods such as `&` or `nohup`.
    storageConfigs: Optional. How storage resources should be mounted on each
      login node.
    zone: Required. Name of the zone in which login nodes should run, e.g.,
      `us-central1-a`. Must be in the same region as the cluster, and must
      match the zone of any other resources specified in the cluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) that should be applied to each login node instance.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('BootDisk', 1)
  count = _messages.IntegerField(2)
  enableOsLogin = _messages.BooleanField(3)
  enablePublicIps = _messages.BooleanField(4)
  instances = _messages.MessageField('ComputeInstance', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  machineType = _messages.StringField(7)
  startupScript = _messages.StringField(8)
  storageConfigs = _messages.MessageField('StorageConfig', 9, repeated=True)
  zone = _messages.StringField(10)


class SlurmNodeSet(_messages.Message):
  r"""Configuration for Slurm nodesets in the cluster. Nodesets are groups of
  compute nodes used by Slurm that are responsible for running workloads
  submitted to the cluster.

  Fields:
    computeId: Optional. ID of the compute resource on which this nodeset will
      run. Must match a key in the cluster's compute_resources.
    computeInstance: Optional. If set, indicates that the nodeset should be
      backed by Compute Engine instances.
    id: Required. Identifier for the nodeset, which allows it to be referenced
      by partitions. Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    maxDynamicNodeCount: Optional. Controls how many additional nodes a
      cluster can bring online to handle workloads. Set this value to enable
      dynamic node creation and limit the number of additional nodes the
      cluster can bring online. Leave empty if you do not want the cluster to
      create nodes dynamically, and instead rely only on static nodes.
    staticNodeCount: Optional. Number of nodes to be statically created for
      this nodeset. The cluster will attempt to ensure that at least this many
      nodes exist at all times.
    storageConfigs: Optional. How storage resources should be mounted on each
      compute node.
  """

  computeId = _messages.StringField(1)
  computeInstance = _messages.MessageField('ComputeInstanceSlurmNodeSet', 2)
  id = _messages.StringField(3)
  maxDynamicNodeCount = _messages.IntegerField(4)
  staticNodeCount = _messages.IntegerField(5)
  storageConfigs = _messages.MessageField('StorageConfig', 6, repeated=True)


class SlurmOrchestrator(_messages.Message):
  r"""When set in Orchestrator, indicates that the cluster should use
  [Slurm](https://slurm.schedmd.com/) as the orchestrator.

  Fields:
    defaultPartition: Optional. Default partition to use for submitted jobs
      that do not explicitly specify a partition. Required if and only if
      there is more than one partition, in which case it must match the id of
      one of the partitions.
    epilogBashScripts: Optional. Slurm [epilog
      scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
      executed by compute nodes whenever a node finishes running a job. Values
      must not be empty.
    loginNodes: Required. Configuration for login nodes, which allow users to
      access the cluster over SSH.
    nodeSets: Optional. Compute resource configuration for the Slurm nodesets
      in your cluster. If not specified, the cluster won't create any nodes.
    partitions: Optional. Configuration for the Slurm partitions in your
      cluster. Each partition can contain one or more nodesets, and you can
      submit separate jobs on each partition. If you don't specify at least
      one partition in your cluster, you can't submit jobs to the cluster.
    prologBashScripts: Optional. Slurm [prolog
      scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
      executed by compute nodes before a node begins running a new job. Values
      must not be empty.
  """

  defaultPartition = _messages.StringField(1)
  epilogBashScripts = _messages.StringField(2, repeated=True)
  loginNodes = _messages.MessageField('SlurmLoginNodes', 3)
  nodeSets = _messages.MessageField('SlurmNodeSet', 4, repeated=True)
  partitions = _messages.MessageField('SlurmPartition', 5, repeated=True)
  prologBashScripts = _messages.StringField(6, repeated=True)


class SlurmPartition(_messages.Message):
  r"""Configuration for Slurm partitions in the cluster. Partitions are groups
  of nodesets, and are how clients specify where their workloads should be
  run.

  Fields:
    id: Required. ID of the partition, which is how users will identify it.
      Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    nodeSetIds: Required. IDs of the nodesets that make up this partition.
      Values must match SlurmNodeSet.id.
  """

  id = _messages.StringField(1)
  nodeSetIds = _messages.StringField(2, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageConfig(_messages.Message):
  r"""Description of how a storage resource should be mounted on a VM
  instance.

  Fields:
    id: Required. ID of the storage resource to mount, which must match a key
      in the cluster's storage_resources.
    localMount: Required. A directory inside the VM instance's file system
      where the storage resource should be mounted (e.g., `/mnt/share`).
  """

  id = _messages.StringField(1)
  localMount = _messages.StringField(2)


class StorageResource(_messages.Message):
  r"""A resource representing a form of persistent storage that is accessible
  to compute resources in the cluster.

  Fields:
    bucket: Reference to a Google Cloud Storage bucket. Populated if and only
      if the storage resource was configured to use Google Cloud Storage.
    config: Required. Immutable. Configuration for this storage resource,
      which describes how it should be created or imported. This field only
      controls how the storage resource is initially created or imported.
      Subsequent changes to the storage resource should be made via the
      resource's API and will not be reflected in the configuration.
    filestore: Reference to a Filestore instance. Populated if and only if the
      storage resource was configured to use Filestore.
    lustre: Reference to a Managed Lustre instance. Populated if and only if
      the storage resource was configured to use Managed Lustre.
  """

  bucket = _messages.MessageField('BucketReference', 1)
  config = _messages.MessageField('StorageResourceConfig', 2)
  filestore = _messages.MessageField('FilestoreReference', 3)
  lustre = _messages.MessageField('LustreReference', 4)


class StorageResourceConfig(_messages.Message):
  r"""Describes how a storage resource should be initialized. Each storage
  resource can either be imported from an existing Google Cloud resource or
  initialized when the cluster is created.

  Fields:
    existingBucket: Optional. Immutable. If set, indicates that an existing
      Cloud Storage bucket should be imported.
    existingFilestore: Optional. Immutable. If set, indicates that an existing
      Filestore instance should be imported.
    existingLustre: Optional. Immutable. If set, indicates that an existing
      Managed Lustre instance should be imported.
    newBucket: Optional. Immutable. If set, indicates that a new Cloud Storage
      bucket should be created.
    newFilestore: Optional. Immutable. If set, indicates that a new Filestore
      instance should be created.
    newLustre: Optional. Immutable. If set, indicates that a new Managed
      Lustre instance should be created.
  """

  existingBucket = _messages.MessageField('ExistingBucketConfig', 1)
  existingFilestore = _messages.MessageField('ExistingFilestoreConfig', 2)
  existingLustre = _messages.MessageField('ExistingLustreConfig', 3)
  newBucket = _messages.MessageField('NewBucketConfig', 4)
  newFilestore = _messages.MessageField('NewFilestoreConfig', 5)
  newLustre = _messages.MessageField('NewLustreConfig', 6)


class UpdateLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  updated.
  """



class UpdateNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be updated.

  Fields:
    nodesets: Output only. Name of the nodeset to update
  """

  nodesets = _messages.StringField(1, repeated=True)


class UpdateOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  updated.
  """



class UpdatePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be updated.

  Fields:
    partitions: Output only. Name of the partition to update
  """

  partitions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
