# -*- coding: utf-8 -*- #
# Copyright 2014 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""gcloud supplementary help topic command group."""


from googlecloudsdk.calliope import base


@base.UniverseCompatible
@base.ReleaseTracks(base.ReleaseTrack.GA, base.ReleaseTrack.BETA,
                    base.ReleaseTrack.ALPHA)
class Topic(base.Group):
  """gcloud supplementary help.

  The {command} command group provides supplementary help for topics not
  directly associated with individual commands.

  More information on {command} can be found by running:

    $ gcloud topic [TOPIC_NAME]

  For a list of available topics run:

    $ gcloud topic --help
  """

  category = base.SDK_TOOLS_CATEGORY
