# -*- coding: utf-8 -*- #
# Copyright 2022 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The command to enable the Cloud Deploy Feature."""


from googlecloudsdk.api_lib.services import enable_api
from googlecloudsdk.calliope import base as calliope_base
from googlecloudsdk.command_lib.container.fleet.features import base
from googlecloudsdk.command_lib.container.fleet.features import info


@calliope_base.Hidden
class Enable(base.EnableCommand):
  """Enable the Cloud Deploy Hybrid Feature.

  Enables the Cloud Deploy Hybrid Feature in the fleet.

  ## EXAMPLES

  To enable the Cloud Deploy Hybrid Feature, run:

    $ {command}
  """

  feature_name = 'clouddeploy'

  def Run(self, args):
    cloudbuild_api = info.Get('cloudbuild').api
    enable_api.EnableServiceIfDisabled(self.Project(), cloudbuild_api)
    self.Enable(self.messages.Feature())

