"""Generated message classes for biglake version v1beta.

The BigLake API provides access to BigLake Metastore, a serverless, fully
managed, and highly available metastore for open-source data that can be used
for querying Apache Iceberg tables in BigQuery.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'biglake'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BatchCreatePartitionsRequest(_messages.Message):
  r"""Request message for the BatchCreatePartitions method.

  Fields:
    requests: Required. Requests to add partitions to the table.
    skipExistingPartitions: Optional. Corresponds to the ifNotExists flag in
      the Hive Metastore APIs. If the flag is set to false, the server will
      return ALREADY_EXISTS if any partition already exists. If the flag is
      set to true, the server will skip existing partitions and insert only
      the non-existing partitions. A maximum of 900 partitions can be inserted
      in a batch.
  """

  requests = _messages.MessageField('CreatePartitionRequest', 1, repeated=True)
  skipExistingPartitions = _messages.BooleanField(2)


class BatchCreatePartitionsResponse(_messages.Message):
  r"""Response message for BatchCreatePartitions.

  Fields:
    partitions: The list of partitions that have been added.
  """

  partitions = _messages.MessageField('Partition', 1, repeated=True)


class BatchDeletePartitionsRequest(_messages.Message):
  r"""Request message for BatchDeletePartitions. The Partition is uniquely
  identified by values, which is an ordered list. Hence, there is no separate
  name or partition id field.

  Fields:
    partitionValues: Required. The list of partitions (identified by its
      values) to be deleted. A maximum of 900 partitions can be deleted in a
      batch.
  """

  partitionValues = _messages.MessageField('PartitionValues', 1, repeated=True)


class BatchUpdatePartitionsRequest(_messages.Message):
  r"""Request message for BatchUpdatePartitions.

  Fields:
    requests: Required. Requests to update partitions in the table.
  """

  requests = _messages.MessageField('UpdatePartitionRequest', 1, repeated=True)


class BatchUpdatePartitionsResponse(_messages.Message):
  r"""Response message for BatchUpdatePartitions.

  Fields:
    partitions: The list of partitions that have been updated. A maximum of
      900 partitions can be updated in a batch.
  """

  partitions = _messages.MessageField('Partition', 1, repeated=True)


class BiglakeHiveV1betaProjectsCatalogsCreateRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsCreateRequest object.

  Fields:
    hiveCatalog: A HiveCatalog resource to be passed as the request body.
    hiveCatalogId: Required. The Hive Catalog ID to use for the catalog that
      will become the final component of the catalog's resource name. The
      maximum length is 256 characters.
    parent: Required. The parent resource where this catalog will be created.
      Format: projects/{project_id_or_number}
    primaryLocation: Required. The GCP region that specifies where the catalog
      metadata is stored, e.g. us-central1, EU, etc.
  """

  hiveCatalog = _messages.MessageField('HiveCatalog', 1)
  hiveCatalogId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  primaryLocation = _messages.StringField(4)


class BiglakeHiveV1betaProjectsCatalogsDatabasesCreateRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesCreateRequest object.

  Fields:
    hiveDatabase: A HiveDatabase resource to be passed as the request body.
    hiveDatabaseId: Required. The ID to use for the Hive Database. The maximum
      length is 128 characters.
    parent: Required. The parent resource where this database will be created.
      Format: projects/{project_id_or_number}/catalogs/{catalog_id}
  """

  hiveDatabase = _messages.MessageField('HiveDatabase', 1)
  hiveDatabaseId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesDeleteRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesDeleteRequest object.

  Fields:
    name: Required. The name of the database to delete. Format: projects/{proj
      ect_id_or_number}/catalogs/{catalog_id}/databases/{database_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesGetRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesGetRequest object.

  Fields:
    name: Required. The name of the database to retrieve. Format: projects/{pr
      oject_id_or_number}/catalogs/{catalog_id}/databases/{database_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesListRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesListRequest object.

  Fields:
    pageSize: Optional. Page size for pagination.
    pageToken: Optional. PageToken for pagination.
    parent: Required. The hive catalog to list databases from. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesPatchRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesPatchRequest object.

  Fields:
    hiveDatabase: A HiveDatabase resource to be passed as the request body.
    name: Output only. The resource name. Format: projects/{project_id_or_numb
      er}/catalogs/{catalog_id}/databases/{database_id}
    updateMask: Optional. The list of fields to update.
  """

  hiveDatabase = _messages.MessageField('HiveDatabase', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesCreateRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesCreateRequest object.

  Fields:
    hiveTable: A HiveTable resource to be passed as the request body.
    hiveTableId: Required. The Hive Table ID to use for the table that will
      become the final component of the table's resource name. The maximum
      length is 256 characters.
    parent: Required. The parent resource for the table to be created. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}/databases/{databas
      e_id}
  """

  hiveTable = _messages.MessageField('HiveTable', 1)
  hiveTableId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesDeleteRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesDeleteRequest object.

  Fields:
    name: Required. The name of the database to delete. Format: projects/{proj
      ect_id_or_number}/catalogs/{catalog_id}/databases/{database_id}/tables/{
      table_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesGetRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesGetRequest object.

  Fields:
    name: Required. The name of the table to retrieve. Format: projects/{proje
      ct_id_or_number}/catalogs/{catalog_id}/databases/{database_id}/tables/{t
      able_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesListRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesListRequest object.

  Fields:
    pageSize: Optional. Page size for pagination.
    pageToken: Optional. PageToken for pagination.
    parent: Required. The database to list tables from. Format: projects/{proj
      ect_id_or_number}/catalogs/{catalog_id}/databases/{database_id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchCreateRequest(_messages.Message):
  r"""A
  BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchCreateRequest
  object.

  Fields:
    batchCreatePartitionsRequest: A BatchCreatePartitionsRequest resource to
      be passed as the request body.
    parent: Required. Reference to the table to where the partitions to be
      added, in the format of projects/{project}/catalogs/{catalogs}/databases
      /{database}/tables/{table}.
  """

  batchCreatePartitionsRequest = _messages.MessageField('BatchCreatePartitionsRequest', 1)
  parent = _messages.StringField(2, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchDeleteRequest(_messages.Message):
  r"""A
  BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchDeleteRequest
  object.

  Fields:
    batchDeletePartitionsRequest: A BatchDeletePartitionsRequest resource to
      be passed as the request body.
    parent: Required. Reference to the table to which these partitions belong,
      in the format of projects/{project}/catalogs/{catalogs}/databases/{datab
      ase}/tables/{table}.
  """

  batchDeletePartitionsRequest = _messages.MessageField('BatchDeletePartitionsRequest', 1)
  parent = _messages.StringField(2, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchUpdateRequest(_messages.Message):
  r"""A
  BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsBatchUpdateRequest
  object.

  Fields:
    batchUpdatePartitionsRequest: A BatchUpdatePartitionsRequest resource to
      be passed as the request body.
    parent: Required. Reference to the table to which these partitions belong,
      in the format of projects/{project}/catalogs/{catalogs}/databases/{datab
      ase}/tables/{table}.
  """

  batchUpdatePartitionsRequest = _messages.MessageField('BatchUpdatePartitionsRequest', 1)
  parent = _messages.StringField(2, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsListRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPartitionsListRequest
  object.

  Fields:
    filter: Optional. SQL text filtering statement, similar to a WHERE clause
      in a query. Only supports single-row expressions. Aggregate functions
      are not supported. Examples: * "int_field > 5" * "date_field =
      CAST('2014-9-27' as DATE)" * "nullable_field is not NULL" *
      "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))" * "numeric_field
      BETWEEN 1.0 AND 5.0" Restricted to a maximum length of 1 MB.
    parent: Required. Reference to the table to which these partitions belong,
      in the format of projects/{project}/catalogs/{catalogs}/databases/{datab
      ase}/tables/{table}.
  """

  filter = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPatchRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDatabasesTablesPatchRequest object.

  Fields:
    hiveTable: A HiveTable resource to be passed as the request body.
    name: Output only. The resource name. Format: projects/{project_id_or_numb
      er}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
    updateMask: Optional. The list of fields to update.
  """

  hiveTable = _messages.MessageField('HiveTable', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BiglakeHiveV1betaProjectsCatalogsDeleteRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsDeleteRequest object.

  Fields:
    name: Required. The name of the catalog to delete. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsGetRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsGetRequest object.

  Fields:
    name: Required. The name of the catalog to retrieve. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}
  """

  name = _messages.StringField(1, required=True)


class BiglakeHiveV1betaProjectsCatalogsListRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsListRequest object.

  Fields:
    pageSize: Optional. Page size for pagination.
    pageToken: Optional. Page token for pagination.
    parent: Required. The project to list catalogs from. Format:
      projects/{project_id_or_number}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BiglakeHiveV1betaProjectsCatalogsPatchRequest(_messages.Message):
  r"""A BiglakeHiveV1betaProjectsCatalogsPatchRequest object.

  Fields:
    hiveCatalog: A HiveCatalog resource to be passed as the request body.
    name: Output only. The resource name. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}
    updateMask: Optional. The list of fields to update. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask If not set, defaults to
      all of the fields that are allowed to update.
  """

  hiveCatalog = _messages.MessageField('HiveCatalog', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BiglakeProjectsCatalogsGetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BiglakeProjectsCatalogsNamespacesTablesTestIamPermissionsRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesTablesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BiglakeProjectsCatalogsNamespacesTestIamPermissionsRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsNamespacesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BiglakeProjectsCatalogsSetIamPolicyRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BiglakeProjectsCatalogsTestIamPermissionsRequest(_messages.Message):
  r"""A BiglakeProjectsCatalogsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CreatePartitionRequest(_messages.Message):
  r"""Request message for CreatePartition. The Partition is uniquely
  identified by values, which is an ordered list. Hence, there is no separate
  name or partition id field.

  Fields:
    parent: Required. Reference to the table to where the partition to be
      added, in the format of projects/{project}/catalogs/{catalogs}/databases
      /{databases}/tables/{table}.
    partition: Required. The partition to be added.
  """

  parent = _messages.StringField(1)
  partition = _messages.MessageField('Partition', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FieldSchema(_messages.Message):
  r"""Field schema information.

  Fields:
    comment: Optional. Comment of the field. The maximum length is 256
      characters.
    name: Required. Name of the field. The maximum length is 767 characters.
    type: Required. Type of the field. The maximum length is 128 characters.
  """

  comment = _messages.StringField(1)
  name = _messages.StringField(2)
  type = _messages.StringField(3)


class HiveCatalog(_messages.Message):
  r"""The HiveCatalog contains spark/hive databases and tables in the BigLake
  Metastore. While creating resources under a catalog, ideally ensure that the
  storage bucket location, spark / hive engine location or any other compute
  location match. Catalog can be viewed as the destination for migrating an
  on-prem Hive metastore to GCP.

  Fields:
    description: Optional. Stores the catalog description. The maximum length
      is 4000 characters.
    locationUri: Required. The Cloud Storage location path where the catalog
      exists. Format: gs://bucket/path/to/catalog The maximum length is 4000
      characters.
    name: Output only. The resource name. Format:
      projects/{project_id_or_number}/catalogs/{catalog_id}
  """

  description = _messages.StringField(1)
  locationUri = _messages.StringField(2)
  name = _messages.StringField(3)


class HiveDatabase(_messages.Message):
  r"""Stores the hive database information. It includes the database name,
  description, location and properties associated with the database.

  Messages:
    ParametersValue: Optional. Stores the properties associated with the
      database. The maximum size is 2 MiB.

  Fields:
    description: Optional. Stores the database description. The maximum length
      is 4000 characters.
    locationUri: Optional. The Cloud Storage location path where the database
      exists. Format: gs://bucket/path/to/database If unspecified, the
      database will be stored in the catalog location. The maximum length is
      4000 characters.
    name: Output only. The resource name. Format: projects/{project_id_or_numb
      er}/catalogs/{catalog_id}/databases/{database_id}
    parameters: Optional. Stores the properties associated with the database.
      The maximum size is 2 MiB.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Stores the properties associated with the database. The
    maximum size is 2 MiB.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  locationUri = _messages.StringField(2)
  name = _messages.StringField(3)
  parameters = _messages.MessageField('ParametersValue', 4)


class HiveTable(_messages.Message):
  r"""Stores the hive table information. It includes the table name, schema
  (column names and types), data location, storage format, serde info, etc.
  This message closely matches the Table object in the IMetastoreClient

  Messages:
    ParametersValue: Optional. Stores the properties associated with the
      table. The maximum size is 4MiB.

  Fields:
    createTime: Output only. The creation time of the table.
    description: Optional. Description of the table. The maximum length is
      4000 characters.
    name: Output only. The resource name. Format: projects/{project_id_or_numb
      er}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
    parameters: Optional. Stores the properties associated with the table. The
      maximum size is 4MiB.
    partitionKeys: Optional. The partition keys of the table.
    storageDescriptor: Required. Storage descriptor of the table.
    tableType: Output only. The type of the table. This is EXTERNAL for
      BigLake hive tables.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Stores the properties associated with the table. The maximum
    size is 4MiB.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  parameters = _messages.MessageField('ParametersValue', 4)
  partitionKeys = _messages.MessageField('FieldSchema', 5, repeated=True)
  storageDescriptor = _messages.MessageField('StorageDescriptor', 6)
  tableType = _messages.StringField(7)


class ListHiveCatalogsResponse(_messages.Message):
  r"""Response message for the ListHiveCatalogs method.

  Fields:
    catalogs: Output only. The catalogs from the specified project.
    nextPageToken: Output only. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    unreachable: Output only. The list of unreachable cloud regions. If non-
      empty, the result set might be incomplete.
  """

  catalogs = _messages.MessageField('HiveCatalog', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListHiveDatabasesResponse(_messages.Message):
  r"""Response message for the ListHiveDatabases method.

  Fields:
    databases: Output only. The databases from the specified project and
      catalog.
    nextPageToken: Output only. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
  """

  databases = _messages.MessageField('HiveDatabase', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHiveTablesResponse(_messages.Message):
  r"""Response message for the ListHiveTables method.

  Fields:
    nextPageToken: Output only. A token, which can be sent as `page_token` to
      retrieve the next page. If this field is omitted, there are no
      subsequent pages.
    tables: Output only. The tables from the specified project, catalog and
      database.
  """

  nextPageToken = _messages.StringField(1)
  tables = _messages.MessageField('HiveTable', 2, repeated=True)


class ListPartitionsResponse(_messages.Message):
  r"""Response message for ListPartitions.

  Fields:
    partitions: Output only. List of partitions.
  """

  partitions = _messages.MessageField('Partition', 1, repeated=True)


class Order(_messages.Message):
  r"""Sort order of the stored data per column.

  Fields:
    col: Required. The column name. The maximum length is 767 characters.
    order: Required. Defines the sort order of the column. Ascending if 1,
      descending if 0.
  """

  col = _messages.StringField(1)
  order = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Partition(_messages.Message):
  r"""Information about a Hive partition.

  Messages:
    ParametersValue: Optional. Additional parameters or metadata associated
      with the partition. Maximum size 10 KiB.

  Fields:
    createTime: Output only. The creation time of the partition.
    fields: Optional. List of columns.
    parameters: Optional. Additional parameters or metadata associated with
      the partition. Maximum size 10 KiB.
    storageDescriptor: Optional. Contains information about the physical
      storage of the data in the partition.
    values: Required. Represents the values of the partition keys, where each
      value corresponds to a specific partition key in the order in which the
      keys are defined. Each value is limited to 1024 characters.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Additional parameters or metadata associated with the
    partition. Maximum size 10 KiB.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  fields = _messages.MessageField('FieldSchema', 2, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 3)
  storageDescriptor = _messages.MessageField('StorageDescriptor', 4)
  values = _messages.StringField(5, repeated=True)


class PartitionValues(_messages.Message):
  r"""Represents the values of a partition.

  Fields:
    values: Required. The values of the partition keys, where each value
      corresponds to a specific partition key in the order in which the keys
      are defined.
  """

  values = _messages.StringField(1, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class SerdeInfo(_messages.Message):
  r"""Serialization and deserialization information.

  Enums:
    SerdeTypeValueValuesEnum: Optional. The serde type.

  Messages:
    ParametersValue: Optional. Parameters of the serde. The maximum size is
      10Kib.

  Fields:
    description: Optional. Description of the serde. The maximum length is
      4000 characters.
    deserializerClass: Optional. The fully qualified Java class name of the
      deserializer. The maximum length is 4000 characters.
    name: Required. Name of the SerDe. Table name by default. The maximum
      length is 128 characters.
    parameters: Optional. Parameters of the serde. The maximum size is 10Kib.
    serdeType: Optional. The serde type.
    serializationLib: Required. The fully qualified Java class name of the
      serialization library. The maximum length is 4000 characters.
    serializerClass: Optional. The fully qualified Java class name of the
      serializer. The maximum length is 4000 characters.
  """

  class SerdeTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The serde type.

    Values:
      SERDE_TYPE_UNSPECIFIED: The serde type is not specified.
      HIVE: Hive.
      SCHEMA_REGISTRY: Schema registry.
    """
    SERDE_TYPE_UNSPECIFIED = 0
    HIVE = 1
    SCHEMA_REGISTRY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Parameters of the serde. The maximum size is 10Kib.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  deserializerClass = _messages.StringField(2)
  name = _messages.StringField(3)
  parameters = _messages.MessageField('ParametersValue', 4)
  serdeType = _messages.EnumField('SerdeTypeValueValuesEnum', 5)
  serializationLib = _messages.StringField(6)
  serializerClass = _messages.StringField(7)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SkewedColumnValue(_messages.Message):
  r"""The skewed column values.

  Fields:
    values: Required. The skewed column values. The maximum length is 256
      characters per value.
  """

  values = _messages.StringField(1, repeated=True)


class SkewedInfo(_messages.Message):
  r"""Stores all the information about skewed table.

  Fields:
    skewedColNames: Required. The column names that are skewed. The maximum
      length is 256 characters per column name.
    skewedColValues: Required. The skewed column values.
    skewedKeyValuesLocations: Required. The skewed key values locations.
  """

  skewedColNames = _messages.StringField(1, repeated=True)
  skewedColValues = _messages.MessageField('SkewedColumnValue', 2, repeated=True)
  skewedKeyValuesLocations = _messages.MessageField('SkewedKeyValuesLocation', 3, repeated=True)


class SkewedKeyValuesLocation(_messages.Message):
  r"""The skewed key values and their corresponding location.

  Fields:
    location: Required. The location of the skewed column values. The maximum
      length is 4000 characters.
    values: Required. The skewed column values. The maximum length is 256
      characters per value.
  """

  location = _messages.StringField(1)
  values = _messages.StringField(2, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StorageDescriptor(_messages.Message):
  r"""Contains information about the physical storage of the table data.

  Messages:
    ParametersValue: Optional. Key-value pairs for the storage descriptor. The
      maximum size is 10Kib.

  Fields:
    bucketCols: Optional. Reducer grouping columns and clustering columns and
      bucketing columns
    columns: Required. Specifies the columns of the table.
    compressed: Optional. Whether the table is compressed.
    inputFormat: Optional. The fully qualified Java class name of the input
      format. The maximum length is 4000 characters.
    locationUri: Optional. The Cloud storage uri where the table is located.
      Defaults to /. The maximum length is 4000 characters.
    numBuckets: Optional. The number of buckets in the table.
    outputFormat: Optional. The fully qualified Java class name of the output
      format. The maximum length is 4000 characters.
    parameters: Optional. Key-value pairs for the storage descriptor. The
      maximum size is 10Kib.
    serdeInfo: Optional. Serialization and deserialization information.
    skewedInfo: Optional. Table data skew information.
    sortCols: Optional. Sort order of the data in each bucket
    storedAsSubDirs: Optional. Whether the table is stored as sub directories.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Key-value pairs for the storage descriptor. The maximum size
    is 10Kib.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bucketCols = _messages.StringField(1, repeated=True)
  columns = _messages.MessageField('FieldSchema', 2, repeated=True)
  compressed = _messages.BooleanField(3)
  inputFormat = _messages.StringField(4)
  locationUri = _messages.StringField(5)
  numBuckets = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  outputFormat = _messages.StringField(7)
  parameters = _messages.MessageField('ParametersValue', 8)
  serdeInfo = _messages.MessageField('SerdeInfo', 9)
  skewedInfo = _messages.MessageField('SkewedInfo', 10)
  sortCols = _messages.MessageField('Order', 11, repeated=True)
  storedAsSubDirs = _messages.BooleanField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UpdatePartitionRequest(_messages.Message):
  r"""Request message for UpdatePartition.

  Fields:
    partition: Required. The partition to be updated.
    updateMask: Optional. The list of fields to update.
  """

  partition = _messages.MessageField('Partition', 1)
  updateMask = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    BiglakeProjectsCatalogsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
encoding.AddCustomJsonFieldMapping(
    BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
