# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Apphub Command Lib Outputs."""


from googlecloudsdk.command_lib.apphub import consts


def GetDescribeTopologyOutput(get_topology_response):
  return {
      consts.Topology.NAME: get_topology_response.name,
      consts.Topology.PROJECT: get_topology_response.project,
      consts.Topology.ENABLED: bool(
          get_topology_response.enabled
      ),
  }


def GetDescribeTelemetryOutput(get_telemetry_response):
  return {
      consts.Telemetry.NAME: get_telemetry_response.name,
      consts.Telemetry.PROJECT: get_telemetry_response.project,
      consts.Telemetry.MONITORING_ENABLED: bool(
          get_telemetry_response.monitoringEnabled
      ),
  }
