"""Generated message classes for datapipelines version v1.

Data Pipelines provides an interface for creating, updating, and managing
recurring Data Analytics jobs.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datapipelines'


class DatapipelinesProjectsLocationsPipelinesCreateRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesCreateRequest object.

  Fields:
    googleCloudDatapipelinesV1Pipeline: A GoogleCloudDatapipelinesV1Pipeline
      resource to be passed as the request body.
    parent: Required. The location name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID`.
  """

  googleCloudDatapipelinesV1Pipeline = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 1)
  parent = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsPipelinesDeleteRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesDeleteRequest object.

  Fields:
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  name = _messages.StringField(1, required=True)


class DatapipelinesProjectsLocationsPipelinesGetRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesGetRequest object.

  Fields:
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  name = _messages.StringField(1, required=True)


class DatapipelinesProjectsLocationsPipelinesJobsListRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesJobsListRequest object.

  Fields:
    pageSize: The maximum number of entities to return. The service may return
      fewer than this value, even if there are additional pages. If
      unspecified, the max limit will be determined by the backend
      implementation.
    pageToken: A page token, received from a previous `ListJobs` call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListJobs` must match the call that provided the
      page token.
    parent: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatapipelinesProjectsLocationsPipelinesListRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. If
      unspecified, all pipelines will be returned. Multiple filters can be
      applied and must be comma separated. Fields eligible for filtering are:
      + `type`: The type of the pipeline (streaming or batch). Allowed values
      are `ALL`, `BATCH`, and `STREAMING`. + `status`: The activity status of
      the pipeline. Allowed values are `ALL`, `ACTIVE`, `ARCHIVED`, and
      `PAUSED`. For example, to limit results to active batch processing
      pipelines: type:BATCH,status:ACTIVE
    pageSize: The maximum number of entities to return. The service may return
      fewer than this value, even if there are additional pages. If
      unspecified, the max limit is yet to be determined by the backend
      implementation.
    pageToken: A page token, received from a previous `ListPipelines` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListPipelines` must match the call that provided
      the page token.
    parent: Required. The location name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DatapipelinesProjectsLocationsPipelinesPatchRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesPatchRequest object.

  Fields:
    googleCloudDatapipelinesV1Pipeline: A GoogleCloudDatapipelinesV1Pipeline
      resource to be passed as the request body.
    name: The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`. *
      `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens
      (-), colons (:), and periods (.). For more information, see [Identifying
      projects](https://cloud.google.com/resource-manager/docs/creating-
      managing-projects#identifying_projects). * `LOCATION_ID` is the
      canonical ID for the pipeline's location. The list of available
      locations can be obtained by calling
      `google.cloud.location.Locations.ListLocations`. Note that the Data
      Pipelines service is not available in all regions. It depends on Cloud
      Scheduler, an App Engine application, so it's only available in [App
      Engine regions](https://cloud.google.com/about/locations#region). *
      `PIPELINE_ID` is the ID of the pipeline. Must be unique for the selected
      project and location.
    updateMask: The list of fields to be updated.
  """

  googleCloudDatapipelinesV1Pipeline = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatapipelinesProjectsLocationsPipelinesRunRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesRunRequest object.

  Fields:
    googleCloudDatapipelinesV1RunPipelineRequest: A
      GoogleCloudDatapipelinesV1RunPipelineRequest resource to be passed as
      the request body.
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  googleCloudDatapipelinesV1RunPipelineRequest = _messages.MessageField('GoogleCloudDatapipelinesV1RunPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsPipelinesStopRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesStopRequest object.

  Fields:
    googleCloudDatapipelinesV1StopPipelineRequest: A
      GoogleCloudDatapipelinesV1StopPipelineRequest resource to be passed as
      the request body.
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  googleCloudDatapipelinesV1StopPipelineRequest = _messages.MessageField('GoogleCloudDatapipelinesV1StopPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class GoogleCloudDatapipelinesV1DataflowJobDetails(_messages.Message):
  r"""Pipeline job details specific to the Dataflow API. This is encapsulated
  here to allow for more executors to store their specific details separately.

  Messages:
    ResourceInfoValue: Cached version of all the metrics of interest for the
      job. This value gets stored here when the job is terminated. As long as
      the job is running, this field is populated from the Dataflow API.

  Fields:
    currentWorkers: Output only. The current number of workers used to run the
      jobs. Only set to a value if the job is still running.
    resourceInfo: Cached version of all the metrics of interest for the job.
      This value gets stored here when the job is terminated. As long as the
      job is running, this field is populated from the Dataflow API.
    sdkVersion: Output only. The SDK version used to run the job.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceInfoValue(_messages.Message):
    r"""Cached version of all the metrics of interest for the job. This value
    gets stored here when the job is terminated. As long as the job is
    running, this field is populated from the Dataflow API.

    Messages:
      AdditionalProperty: An additional property for a ResourceInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  currentWorkers = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resourceInfo = _messages.MessageField('ResourceInfoValue', 2)
  sdkVersion = _messages.MessageField('GoogleCloudDatapipelinesV1SdkVersion', 3)


class GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironment(_messages.Message):
  r"""The environment values to be set at runtime for a Flex Template.

  Enums:
    FlexrsGoalValueValuesEnum: Set FlexRS goal for the job.
      https://cloud.google.com/dataflow/docs/guides/flexrs
    IpConfigurationValueValuesEnum: Configuration for VM IPs.

  Messages:
    AdditionalUserLabelsValue: Additional user labels to be specified for the
      job. Keys and values must follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions). An object containing a list of key/value pairs.
      Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.

  Fields:
    additionalExperiments: Additional experiment flags for the job.
    additionalUserLabels: Additional user labels to be specified for the job.
      Keys and values must follow the restrictions specified in the [labeling
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions). An object containing a list of key/value pairs.
      Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
    enableStreamingEngine: Whether to enable Streaming Engine for the job.
    flexrsGoal: Set FlexRS goal for the job.
      https://cloud.google.com/dataflow/docs/guides/flexrs
    ipConfiguration: Configuration for VM IPs.
    kmsKeyName: Name for the Cloud KMS key for the job. Key format is:
      projects//locations//keyRings//cryptoKeys/
    machineType: The machine type to use for the job. Defaults to the value
      from the template if not specified.
    maxWorkers: The maximum number of Compute Engine instances to be made
      available to your pipeline during execution, from 1 to 1000.
    network: Network to which VMs will be assigned. If empty or unspecified,
      the service will use the network "default".
    numWorkers: The initial number of Compute Engine instances for the job.
    serviceAccountEmail: The email address of the service account to run the
      job as.
    subnetwork: Subnetwork to which VMs will be assigned, if desired. You can
      specify a subnetwork using either a complete URL or an abbreviated path.
      Expected to be of the form "https://www.googleapis.com/compute/v1/projec
      ts/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or
      "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
      a Shared VPC network, you must use the complete URL.
    tempLocation: The Cloud Storage path to use for temporary files. Must be a
      valid Cloud Storage URL, beginning with `gs://`.
    workerRegion: The Compute Engine region
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1". Mutually
      exclusive with worker_zone. If neither worker_region nor worker_zone is
      specified, defaults to the control plane region.
    workerZone: The Compute Engine zone
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1-a". Mutually
      exclusive with worker_region. If neither worker_region nor worker_zone
      is specified, a zone in the control plane region is chosen based on
      available capacity. If both `worker_zone` and `zone` are set,
      `worker_zone` takes precedence.
    zone: The Compute Engine [availability
      zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
      for launching worker instances to run your pipeline. In the future,
      worker_zone will take precedence.
  """

  class FlexrsGoalValueValuesEnum(_messages.Enum):
    r"""Set FlexRS goal for the job.
    https://cloud.google.com/dataflow/docs/guides/flexrs

    Values:
      FLEXRS_UNSPECIFIED: Run in the default mode.
      FLEXRS_SPEED_OPTIMIZED: Optimize for lower execution time.
      FLEXRS_COST_OPTIMIZED: Optimize for lower cost.
    """
    FLEXRS_UNSPECIFIED = 0
    FLEXRS_SPEED_OPTIMIZED = 1
    FLEXRS_COST_OPTIMIZED = 2

  class IpConfigurationValueValuesEnum(_messages.Enum):
    r"""Configuration for VM IPs.

    Values:
      WORKER_IP_UNSPECIFIED: The configuration is unknown, or unspecified.
      WORKER_IP_PUBLIC: Workers should have public IP addresses.
      WORKER_IP_PRIVATE: Workers should have private IP addresses.
    """
    WORKER_IP_UNSPECIFIED = 0
    WORKER_IP_PUBLIC = 1
    WORKER_IP_PRIVATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalUserLabelsValue(_messages.Message):
    r"""Additional user labels to be specified for the job. Keys and values
    must follow the restrictions specified in the [labeling
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions). An object containing a list of key/value pairs.
    Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.

    Messages:
      AdditionalProperty: An additional property for a
        AdditionalUserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AdditionalUserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalUserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalExperiments = _messages.StringField(1, repeated=True)
  additionalUserLabels = _messages.MessageField('AdditionalUserLabelsValue', 2)
  enableStreamingEngine = _messages.BooleanField(3)
  flexrsGoal = _messages.EnumField('FlexrsGoalValueValuesEnum', 4)
  ipConfiguration = _messages.EnumField('IpConfigurationValueValuesEnum', 5)
  kmsKeyName = _messages.StringField(6)
  machineType = _messages.StringField(7)
  maxWorkers = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  network = _messages.StringField(9)
  numWorkers = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  serviceAccountEmail = _messages.StringField(11)
  subnetwork = _messages.StringField(12)
  tempLocation = _messages.StringField(13)
  workerRegion = _messages.StringField(14)
  workerZone = _messages.StringField(15)
  zone = _messages.StringField(16)


class GoogleCloudDatapipelinesV1Job(_messages.Message):
  r"""Definition of the job information maintained by the pipeline. Fields in
  this entity are retrieved from the executor API (e.g. Dataflow API).

  Enums:
    StateValueValuesEnum: The current state of the job.

  Fields:
    createTime: Output only. The time of job creation.
    dataflowJobDetails: All the details that are specific to a Dataflow job.
    endTime: Output only. The time of job termination. This is absent if the
      job is still running.
    id: Output only. The internal ID for the job.
    name: Required. The fully qualified resource name for the job.
    state: The current state of the job.
    status: Status capturing any error code or message related to job creation
      or execution.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the job.

    Values:
      STATE_UNSPECIFIED: The job state isn't specified.
      STATE_PENDING: The job is waiting to start execution.
      STATE_RUNNING: The job is executing.
      STATE_DONE: The job has finished execution successfully.
      STATE_FAILED: The job has finished execution with a failure.
      STATE_CANCELLED: The job has been terminated upon user request.
    """
    STATE_UNSPECIFIED = 0
    STATE_PENDING = 1
    STATE_RUNNING = 2
    STATE_DONE = 3
    STATE_FAILED = 4
    STATE_CANCELLED = 5

  createTime = _messages.StringField(1)
  dataflowJobDetails = _messages.MessageField('GoogleCloudDatapipelinesV1DataflowJobDetails', 2)
  endTime = _messages.StringField(3)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  status = _messages.MessageField('GoogleRpcStatus', 7)


class GoogleCloudDatapipelinesV1LaunchFlexTemplateParameter(_messages.Message):
  r"""Launch Flex Template parameter.

  Messages:
    LaunchOptionsValue: Launch options for this Flex Template job. This is a
      common set of options across languages and templates. This should not be
      used to pass job parameters.
    ParametersValue: The parameters for the Flex Template. Example:
      `{"num_workers":"5"}`
    TransformNameMappingsValue: Use this to pass transform name mappings for
      streaming update jobs. Example:
      `{"oldTransformName":"newTransformName",...}`

  Fields:
    containerSpecGcsPath: Cloud Storage path to a file with a JSON-serialized
      ContainerSpec as content.
    environment: The runtime environment for the Flex Template job.
    jobName: Required. The job name to use for the created job. For an update
      job request, the job name should be the same as the existing running
      job.
    launchOptions: Launch options for this Flex Template job. This is a common
      set of options across languages and templates. This should not be used
      to pass job parameters.
    parameters: The parameters for the Flex Template. Example:
      `{"num_workers":"5"}`
    transformNameMappings: Use this to pass transform name mappings for
      streaming update jobs. Example:
      `{"oldTransformName":"newTransformName",...}`
    update: Set this to true if you are sending a request to update a running
      streaming job. When set, the job name should be the same as the running
      job.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LaunchOptionsValue(_messages.Message):
    r"""Launch options for this Flex Template job. This is a common set of
    options across languages and templates. This should not be used to pass
    job parameters.

    Messages:
      AdditionalProperty: An additional property for a LaunchOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LaunchOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LaunchOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The parameters for the Flex Template. Example: `{"num_workers":"5"}`

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TransformNameMappingsValue(_messages.Message):
    r"""Use this to pass transform name mappings for streaming update jobs.
    Example: `{"oldTransformName":"newTransformName",...}`

    Messages:
      AdditionalProperty: An additional property for a
        TransformNameMappingsValue object.

    Fields:
      additionalProperties: Additional properties of type
        TransformNameMappingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TransformNameMappingsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  containerSpecGcsPath = _messages.StringField(1)
  environment = _messages.MessageField('GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironment', 2)
  jobName = _messages.StringField(3)
  launchOptions = _messages.MessageField('LaunchOptionsValue', 4)
  parameters = _messages.MessageField('ParametersValue', 5)
  transformNameMappings = _messages.MessageField('TransformNameMappingsValue', 6)
  update = _messages.BooleanField(7)


class GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest(_messages.Message):
  r"""A request to launch a Dataflow job from a Flex Template.

  Fields:
    launchParameter: Required. Parameter to launch a job from a Flex Template.
    location: Required. The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
      which to direct the request. For example, `us-central1`, `us-west1`.
    projectId: Required. The ID of the Cloud Platform project that the job
      belongs to.
    validateOnly: If true, the request is validated but not actually executed.
      Defaults to false.
  """

  launchParameter = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchFlexTemplateParameter', 1)
  location = _messages.StringField(2)
  projectId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class GoogleCloudDatapipelinesV1LaunchTemplateParameters(_messages.Message):
  r"""Parameters to provide to the template being launched.

  Messages:
    ParametersValue: The runtime parameters to pass to the job.
    TransformNameMappingValue: Map of transform name prefixes of the job to be
      replaced to the corresponding name prefixes of the new job. Only
      applicable when updating a pipeline.

  Fields:
    environment: The runtime environment for the job.
    jobName: Required. The job name to use for the created job.
    parameters: The runtime parameters to pass to the job.
    transformNameMapping: Map of transform name prefixes of the job to be
      replaced to the corresponding name prefixes of the new job. Only
      applicable when updating a pipeline.
    update: If set, replace the existing pipeline with the name specified by
      jobName with this pipeline, preserving state.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The runtime parameters to pass to the job.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TransformNameMappingValue(_messages.Message):
    r"""Map of transform name prefixes of the job to be replaced to the
    corresponding name prefixes of the new job. Only applicable when updating
    a pipeline.

    Messages:
      AdditionalProperty: An additional property for a
        TransformNameMappingValue object.

    Fields:
      additionalProperties: Additional properties of type
        TransformNameMappingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TransformNameMappingValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  environment = _messages.MessageField('GoogleCloudDatapipelinesV1RuntimeEnvironment', 1)
  jobName = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)
  transformNameMapping = _messages.MessageField('TransformNameMappingValue', 4)
  update = _messages.BooleanField(5)


class GoogleCloudDatapipelinesV1LaunchTemplateRequest(_messages.Message):
  r"""A request to launch a template.

  Fields:
    gcsPath: A Cloud Storage path to the template from which to create the
      job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
    launchParameters: The parameters of the template to launch. This should be
      part of the body of the POST request.
    location: The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
      which to direct the request.
    projectId: Required. The ID of the Cloud Platform project that the job
      belongs to.
    validateOnly: If true, the request is validated but not actually executed.
      Defaults to false.
  """

  gcsPath = _messages.StringField(1)
  launchParameters = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchTemplateParameters', 2)
  location = _messages.StringField(3)
  projectId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class GoogleCloudDatapipelinesV1ListJobsResponse(_messages.Message):
  r"""Response message for ListJobs

  Fields:
    jobs: Results that were accessible to the caller. Results are always in
      descending order of job creation date.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  jobs = _messages.MessageField('GoogleCloudDatapipelinesV1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatapipelinesV1ListPipelinesResponse(_messages.Message):
  r"""Response message for ListPipelines.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    pipelines: Results that matched the filter criteria and were accessible to
      the caller. Results are always in descending order of pipeline creation
      date.
  """

  nextPageToken = _messages.StringField(1)
  pipelines = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 2, repeated=True)


class GoogleCloudDatapipelinesV1Pipeline(_messages.Message):
  r"""The main pipeline entity and all the necessary metadata for launching
  and managing linked jobs.

  Enums:
    StateValueValuesEnum: Required. The state of the pipeline. When the
      pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by
      default. State changes can be requested by setting the state to
      stopping, paused, or resuming. State cannot be changed through
      UpdatePipeline requests.
    TypeValueValuesEnum: Required. The type of the pipeline. This field
      affects the scheduling of the pipeline and the type of metrics to show
      for the pipeline.

  Messages:
    PipelineSourcesValue: Immutable. The sources of the pipeline (for example,
      Dataplex). The keys and values are set by the corresponding sources
      during pipeline creation.

  Fields:
    createTime: Output only. Immutable. The timestamp when the pipeline was
      initially created. Set by the Data Pipelines service.
    displayName: Required. The display name of the pipeline. It can contain
      only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores
      (_).
    jobCount: Output only. Number of jobs.
    lastUpdateTime: Output only. Immutable. The timestamp when the pipeline
      was last modified. Set by the Data Pipelines service.
    name: The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`. *
      `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens
      (-), colons (:), and periods (.). For more information, see [Identifying
      projects](https://cloud.google.com/resource-manager/docs/creating-
      managing-projects#identifying_projects). * `LOCATION_ID` is the
      canonical ID for the pipeline's location. The list of available
      locations can be obtained by calling
      `google.cloud.location.Locations.ListLocations`. Note that the Data
      Pipelines service is not available in all regions. It depends on Cloud
      Scheduler, an App Engine application, so it's only available in [App
      Engine regions](https://cloud.google.com/about/locations#region). *
      `PIPELINE_ID` is the ID of the pipeline. Must be unique for the selected
      project and location.
    pipelineSources: Immutable. The sources of the pipeline (for example,
      Dataplex). The keys and values are set by the corresponding sources
      during pipeline creation.
    scheduleInfo: Internal scheduling information for a pipeline. If this
      information is provided, periodic jobs will be created per the schedule.
      If not, users are responsible for creating jobs externally.
    schedulerServiceAccountEmail: Optional. A service account email to be used
      with the Cloud Scheduler job. If not specified, the default compute
      engine service account will be used.
    state: Required. The state of the pipeline. When the pipeline is created,
      the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes
      can be requested by setting the state to stopping, paused, or resuming.
      State cannot be changed through UpdatePipeline requests.
    type: Required. The type of the pipeline. This field affects the
      scheduling of the pipeline and the type of metrics to show for the
      pipeline.
    workload: Workload information for creating new jobs.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. The state of the pipeline. When the pipeline is created, the
    state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be
    requested by setting the state to stopping, paused, or resuming. State
    cannot be changed through UpdatePipeline requests.

    Values:
      STATE_UNSPECIFIED: The pipeline state isn't specified.
      STATE_RESUMING: The pipeline is getting started or resumed. When
        finished, the pipeline state will be 'PIPELINE_STATE_ACTIVE'.
      STATE_ACTIVE: The pipeline is actively running.
      STATE_STOPPING: The pipeline is in the process of stopping. When
        finished, the pipeline state will be 'PIPELINE_STATE_ARCHIVED'.
      STATE_ARCHIVED: The pipeline has been stopped. This is a terminal state
        and cannot be undone.
      STATE_PAUSED: The pipeline is paused. This is a non-terminal state. When
        the pipeline is paused, it will hold processing jobs, but can be
        resumed later. For a batch pipeline, this means pausing the scheduler
        job. For a streaming pipeline, creating a job snapshot to resume from
        will give the same effect.
    """
    STATE_UNSPECIFIED = 0
    STATE_RESUMING = 1
    STATE_ACTIVE = 2
    STATE_STOPPING = 3
    STATE_ARCHIVED = 4
    STATE_PAUSED = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the pipeline. This field affects the scheduling
    of the pipeline and the type of metrics to show for the pipeline.

    Values:
      PIPELINE_TYPE_UNSPECIFIED: The pipeline type isn't specified.
      PIPELINE_TYPE_BATCH: A batch pipeline. It runs jobs on a specific
        schedule, and each job will automatically terminate once execution is
        finished.
      PIPELINE_TYPE_STREAMING: A streaming pipeline. The underlying job is
        continuously running until it is manually terminated by the user. This
        type of pipeline doesn't have a schedule to run on, and the linked job
        gets created when the pipeline is created.
    """
    PIPELINE_TYPE_UNSPECIFIED = 0
    PIPELINE_TYPE_BATCH = 1
    PIPELINE_TYPE_STREAMING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PipelineSourcesValue(_messages.Message):
    r"""Immutable. The sources of the pipeline (for example, Dataplex). The
    keys and values are set by the corresponding sources during pipeline
    creation.

    Messages:
      AdditionalProperty: An additional property for a PipelineSourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type PipelineSourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PipelineSourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  jobCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  lastUpdateTime = _messages.StringField(4)
  name = _messages.StringField(5)
  pipelineSources = _messages.MessageField('PipelineSourcesValue', 6)
  scheduleInfo = _messages.MessageField('GoogleCloudDatapipelinesV1ScheduleSpec', 7)
  schedulerServiceAccountEmail = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  workload = _messages.MessageField('GoogleCloudDatapipelinesV1Workload', 11)


class GoogleCloudDatapipelinesV1RunPipelineRequest(_messages.Message):
  r"""Request message for RunPipeline"""


class GoogleCloudDatapipelinesV1RunPipelineResponse(_messages.Message):
  r"""Response message for RunPipeline

  Fields:
    job: Job that was created as part of RunPipeline operation.
  """

  job = _messages.MessageField('GoogleCloudDatapipelinesV1Job', 1)


class GoogleCloudDatapipelinesV1RuntimeEnvironment(_messages.Message):
  r"""The environment values to set at runtime.

  Enums:
    IpConfigurationValueValuesEnum: Configuration for VM IPs.

  Messages:
    AdditionalUserLabelsValue: Additional user labels to be specified for the
      job. Keys and values should follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) page. An object containing a list of key/value
      pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.

  Fields:
    additionalExperiments: Additional experiment flags for the job.
    additionalUserLabels: Additional user labels to be specified for the job.
      Keys and values should follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) page. An object containing a list of key/value
      pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
    bypassTempDirValidation: Whether to bypass the safety checks for the job's
      temporary directory. Use with caution.
    enableStreamingEngine: Whether to enable Streaming Engine for the job.
    ipConfiguration: Configuration for VM IPs.
    kmsKeyName: Name for the Cloud KMS key for the job. The key format is:
      projects//locations//keyRings//cryptoKeys/
    machineType: The machine type to use for the job. Defaults to the value
      from the template if not specified.
    maxWorkers: The maximum number of Compute Engine instances to be made
      available to your pipeline during execution, from 1 to 1000.
    network: Network to which VMs will be assigned. If empty or unspecified,
      the service will use the network "default".
    numWorkers: The initial number of Compute Engine instances for the job.
    serviceAccountEmail: The email address of the service account to run the
      job as.
    subnetwork: Subnetwork to which VMs will be assigned, if desired. You can
      specify a subnetwork using either a complete URL or an abbreviated path.
      Expected to be of the form "https://www.googleapis.com/compute/v1/projec
      ts/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or
      "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
      a Shared VPC network, you must use the complete URL.
    tempLocation: The Cloud Storage path to use for temporary files. Must be a
      valid Cloud Storage URL, beginning with `gs://`.
    workerRegion: The Compute Engine region
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1". Mutually
      exclusive with worker_zone. If neither worker_region nor worker_zone is
      specified, default to the control plane's region.
    workerZone: The Compute Engine zone
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1-a". Mutually
      exclusive with worker_region. If neither worker_region nor worker_zone
      is specified, a zone in the control plane's region is chosen based on
      available capacity. If both `worker_zone` and `zone` are set,
      `worker_zone` takes precedence.
    zone: The Compute Engine [availability
      zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
      for launching worker instances to run your pipeline. In the future,
      worker_zone will take precedence.
  """

  class IpConfigurationValueValuesEnum(_messages.Enum):
    r"""Configuration for VM IPs.

    Values:
      WORKER_IP_UNSPECIFIED: The configuration is unknown, or unspecified.
      WORKER_IP_PUBLIC: Workers should have public IP addresses.
      WORKER_IP_PRIVATE: Workers should have private IP addresses.
    """
    WORKER_IP_UNSPECIFIED = 0
    WORKER_IP_PUBLIC = 1
    WORKER_IP_PRIVATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalUserLabelsValue(_messages.Message):
    r"""Additional user labels to be specified for the job. Keys and values
    should follow the restrictions specified in the [labeling
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions) page. An object containing a list of key/value
    pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.

    Messages:
      AdditionalProperty: An additional property for a
        AdditionalUserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AdditionalUserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalUserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalExperiments = _messages.StringField(1, repeated=True)
  additionalUserLabels = _messages.MessageField('AdditionalUserLabelsValue', 2)
  bypassTempDirValidation = _messages.BooleanField(3)
  enableStreamingEngine = _messages.BooleanField(4)
  ipConfiguration = _messages.EnumField('IpConfigurationValueValuesEnum', 5)
  kmsKeyName = _messages.StringField(6)
  machineType = _messages.StringField(7)
  maxWorkers = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  network = _messages.StringField(9)
  numWorkers = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  serviceAccountEmail = _messages.StringField(11)
  subnetwork = _messages.StringField(12)
  tempLocation = _messages.StringField(13)
  workerRegion = _messages.StringField(14)
  workerZone = _messages.StringField(15)
  zone = _messages.StringField(16)


class GoogleCloudDatapipelinesV1ScheduleSpec(_messages.Message):
  r"""Details of the schedule the pipeline runs on.

  Fields:
    nextJobTime: Output only. When the next Scheduler job is going to run.
    schedule: Unix-cron format of the schedule. This information is retrieved
      from the linked Cloud Scheduler.
    timeZone: Timezone ID. This matches the timezone IDs used by the Cloud
      Scheduler API. If empty, UTC time is assumed.
  """

  nextJobTime = _messages.StringField(1)
  schedule = _messages.StringField(2)
  timeZone = _messages.StringField(3)


class GoogleCloudDatapipelinesV1SdkVersion(_messages.Message):
  r"""The version of the SDK used to run the job.

  Enums:
    SdkSupportStatusValueValuesEnum: The support status for this SDK version.

  Fields:
    sdkSupportStatus: The support status for this SDK version.
    version: The version of the SDK used to run the job.
    versionDisplayName: A readable string describing the version of the SDK.
  """

  class SdkSupportStatusValueValuesEnum(_messages.Enum):
    r"""The support status for this SDK version.

    Values:
      UNKNOWN: Dataflow is unaware of this version.
      SUPPORTED: This is a known version of an SDK, and is supported.
      STALE: A newer version of the SDK exists, and an update is recommended.
      DEPRECATED: This version of the SDK is deprecated and will eventually be
        unsupported.
      UNSUPPORTED: Support for this SDK version has ended and it should no
        longer be used.
    """
    UNKNOWN = 0
    SUPPORTED = 1
    STALE = 2
    DEPRECATED = 3
    UNSUPPORTED = 4

  sdkSupportStatus = _messages.EnumField('SdkSupportStatusValueValuesEnum', 1)
  version = _messages.StringField(2)
  versionDisplayName = _messages.StringField(3)


class GoogleCloudDatapipelinesV1StopPipelineRequest(_messages.Message):
  r"""Request message for StopPipeline."""


class GoogleCloudDatapipelinesV1Workload(_messages.Message):
  r"""Workload details for creating the pipeline jobs.

  Fields:
    dataflowFlexTemplateRequest: Template information and additional
      parameters needed to launch a Dataflow job using the flex launch API.
    dataflowLaunchTemplateRequest: Template information and additional
      parameters needed to launch a Dataflow job using the standard launch
      API.
  """

  dataflowFlexTemplateRequest = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest', 1)
  dataflowLaunchTemplateRequest = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchTemplateRequest', 2)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
