# Overview

[![Go Reference](https://pkg.go.dev/badge/github.com/aws/aws-lambda-go/events.svg)](https://pkg.go.dev/github.com/aws/aws-lambda-go/events)

This package provides input types for Lambda functions that process AWS events.

# Samples

[ALB Target Group Events](README_ALBTargetGroupEvents.md)

[API Gateway](README_ApiGatewayEvent.md)

[API Gateway Custom Authorizer](README_ApiGatewayCustomAuthorizer.md)

[AppSync](README_AppSync.md)

[AutoScaling](README_AutoScaling.md)

[ClientVPN Connection Handler](README_ClientVPN.md)

[CloudFormation Events](../cfn/README.md)

[CloudWatch Events](README_CloudWatch_Events.md)

[CloudWatch Logs](README_CloudWatch_Logs.md)

[Chime Bot Events](README_Chime_Bots.md)

[CodeBuild Events](README_CodeBuild.md)

[CodeCommit Events](README_CodeCommit.md)

[CodeDeploy Events](README_CodeDeploy.md)

[Cognito Events](README_Cognito.md)

[Cognito Custom Authentication](README_Cognito_UserPools_CustomAuthLambdaTriggers.md)

[Cognito PostConfirmation](README_Cognito_UserPools_PostConfirmation.md)

[Cognito PreAuthentication](README_Cognito_UserPools_PreAuthentication.md)

[Cognito PreSignup](README_Cognito_UserPools_PreSignup.md)

[Cognito PreTokenGen](README_Cognito_UserPools_PreTokenGen.md)

[Config Events](README_Config.md)

[Connect Events](README_Connect.md)

[DynamoDB Events](README_DynamoDB.md)

[Kinesis Events](README_Kinesis.md)

[Kinesis Data Analytics Events](README_KinesisDataAnalytics.md)

[Kinesis Firehose Events](README_KinesisFirehose.md)

[Lambda Events](README_Lambda.md)

[Lex Events](README_Lex.md)

[S3 Events](README_S3.md)

[S3 Batch Job Events](README_S3_Batch_Job.md)

[SES Events](README_SES.md)

[SNS Events](README_SNS.md)

[SQS Events](README_SQS.md)
