<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw file`
This API allows you to manage your File Storage resources.
  
- [Attachment management](#attachment-management)
  - [List filesystems attachments](#list-filesystems-attachments)
- [Filesystem management](#filesystem-management)
  - [Create a new filesystem](#create-a-new-filesystem)
  - [Delete a detached filesystem](#delete-a-detached-filesystem)
  - [Get filesystem details](#get-filesystem-details)
  - [List all filesystems](#list-all-filesystems)
  - [Update filesystem properties](#update-filesystem-properties)

  
## Attachment management

Attachment management.


### List filesystems attachments

List all existing attachments in a specified region.
By default, the attachments listed are ordered by creation date in ascending order. This can be modified using the `order_by` field.

**Usage:**

```
scw file attachment list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| filesystem-id |  | UUID of the File Storage volume |
| resource-id |  | Filter by resource ID |
| resource-type | One of: `unknown_resource_type`, `instance_server` | Filter by resource type |
| zone |  | Filter by resource zone |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



## Filesystem management

Filesystem management.


### Create a new filesystem

To create a new filesystem, you must specify a name, a size, and a project ID.

**Usage:**

```
scw file filesystem create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Name of the filesystem |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| size | Required | Filesystem size in bytes, with a granularity of 100 GB (10^11 bytes). |
| tags.{index} |  | List of tags assigned to the filesystem |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a detached filesystem

You must specify the `filesystem_id` of the filesystem you want to delete.

**Usage:**

```
scw file filesystem delete <filesystem-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| filesystem-id | Required | UUID of the filesystem |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get filesystem details

Retrieve all properties and current status of a specific filesystem identified by its ID.

**Usage:**

```
scw file filesystem get <filesystem-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| filesystem-id | Required | UUID of the filesystem |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List all filesystems

Retrieve all filesystems in the specified region. By default, the filesystems listed are ordered by creation date in ascending order. This can be modified using the `order_by` field.

**Usage:**

```
scw file filesystem list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Criteria to use when ordering the list |
| project-id |  | Filter by project ID |
| name |  | Filter the returned filesystems by their names |
| tags.{index} |  | Filter by tags. Only filesystems with one or more matching tags will be returned |
| organization-id |  | Filter by organization ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update filesystem properties

Update the technical details of a filesystem, such as its name, tags or its new size.

**Usage:**

```
scw file filesystem update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| filesystem-id | Required | UUID of the filesystem |
| name |  | When defined, is the new name of the filesystem |
| size |  | Optional field for increasing the size of the filesystem (must be larger than the current size) |
| tags.{index} |  | List of tags assigned to the filesystem |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



