package shell

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

var allFeatures = Tooltips | LineError | Transient | Jobs | Azure | PoshGit | FTCSMarks | Upgrade | Notice | PromptMark | RPrompt | CursorPositioning | KeyHandlers | Streaming

func TestPwshFeatures(t *testing.T) {
	got := allFeatures.Lines(PWSH).String("")

	want := `
$global:_ompJobCount = $true
$global:_ompAzure = $true
$global:_ompPoshGit = $true
Enable-PoshLineError
Enable-PoshTooltips
$global:_ompTransientPrompt = $true
$global:_ompFTCSMarks = $true
& $global:_ompExecutable upgrade --auto
& $global:_ompExecutable notice
$global:_ompStreaming = $true
Enable-KeyHandlers`

	assert.Equal(t, want, got)
}

func TestQuotePwshOrElvishStr(t *testing.T) {
	tests := []struct {
		str      string
		expected string
	}{
		{str: "", expected: "''"},
		{str: `/tmp/"omp's dir"/oh-my-posh`, expected: `'/tmp/"omp''s dir"/oh-my-posh'`},
		{str: `C:/tmp\omp's dir/oh-my-posh.exe`, expected: `'C:/tmp\omp''s dir/oh-my-posh.exe'`},
	}
	for _, tc := range tests {
		assert.Equal(t, tc.expected, quotePwshOrElvishStr(tc.str), fmt.Sprintf("quotePwshOrElvishStr: %s", tc.str))
	}
}
