## nsc generate profile

Generate a profile from nsc 'URL' that can be used by tooling

```
nsc generate profile [flags]
```

### Examples

```
profile nsc://operator
nsc profile nsc://operator/account
nsc profile nsc://operator/account/user
nsc profile nsc://operator/account/user?names&seeds&keys
nsc profile nsc://operator/account/user?operatorSeed&accountSeed&userSeed
nsc profile nsc://operator/account/user?operatorKey&accountKey&userKey
nsc profile nsc://operator?key&seed
nsc profile nsc://operator/account?key&seed
nsc profile nsc://operator/account/user?key&seed&name
nsc profile nsc://operator/account/user?store=/a/.nsc/nats&keystore=/foo/.nkeys

Output of the program looks like:
{
  "user_creds": "<filepath>",
  "operator" : {
     "service": "hostport"
   }
}
The user_creds is printed if an user is specified
Other options (as query string arguments):
keystore=<dir> that specifies the location of the keystore

store=<dir> that specifies a directory that contains the named operator

[user|account|operator]Key - includes the public key for user, account, 
operator, If no prefix (user/account/operator is provided, it targets 
the last object in the configuration path)

keys - includes the public keys for all entities (same as 
userKey&accountKey&operatorKey)

[user|account|operator]Seed=<optional public key> - include the seed for 
user, account, operator, if an argument is provided, the seed for the 
specified public key is provided - this allows targeting a signing key.
If no prefix (user/account/operator is provided, it targets the last 
object in the configuration path)

seeds - includes the private keys for all entities (same as
userSeed&accountSeed&operatorSeed)

[user|account|operator]Name - includes the friendly name for the for 
user, account, operator, If no prefix (user/account/operator is provided, 
it targets the last object in the configuration path)

names - includes the friendly names for all the entities (same as 
userName&accountName&operatorName)
		
```

### Options

```
  -h, --help                 help for profile
  -o, --output-file string   output file, '--' is stdout (default "--")
```

### Options inherited from parent commands

```
  -H, --all-dirs string       sets --config-dir, --data-dir, and --keystore-dir to the same value
      --config-dir string     nsc config directory
      --data-dir string       nsc data store directory
  -i, --interactive           ask questions for various settings
      --keystore-dir string   nsc keystore directory
  -K, --private-key string    Key used to sign. Can be specified as role (where applicable),
                              public key (private portion is retrieved)
                              or file path to a private key or private key 
```

### SEE ALSO

* [nsc generate](nsc_generate.md)	 - Generate activations, creds, configs or nkeys

###### Auto generated by spf13/cobra on 2-Jan-2025
