/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package handlers

import (
	mock "github.com/stretchr/testify/mock"
	"gopkg.in/go-jose/go-jose.v2"
)

// NewMockTokenHandler creates a new instance of MockTokenHandler. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockTokenHandler(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockTokenHandler {
	mock := &MockTokenHandler{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockTokenHandler is an autogenerated mock type for the TokenHandler type
type MockTokenHandler struct {
	mock.Mock
}

type MockTokenHandler_Expecter struct {
	mock *mock.Mock
}

func (_m *MockTokenHandler) EXPECT() *MockTokenHandler_Expecter {
	return &MockTokenHandler_Expecter{mock: &_m.Mock}
}

// Token provides a mock function for the type MockTokenHandler
func (_mock *MockTokenHandler) Token() (Token, error) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Token")
	}

	var r0 Token
	var r1 error
	if returnFunc, ok := ret.Get(0).(func() (Token, error)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() Token); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(Token)
	}
	if returnFunc, ok := ret.Get(1).(func() error); ok {
		r1 = returnFunc()
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockTokenHandler_Token_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Token'
type MockTokenHandler_Token_Call struct {
	*mock.Call
}

// Token is a helper method to define mock.On call
func (_e *MockTokenHandler_Expecter) Token() *MockTokenHandler_Token_Call {
	return &MockTokenHandler_Token_Call{Call: _e.mock.On("Token")}
}

func (_c *MockTokenHandler_Token_Call) Run(run func()) *MockTokenHandler_Token_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockTokenHandler_Token_Call) Return(token Token, err error) *MockTokenHandler_Token_Call {
	_c.Call.Return(token, err)
	return _c
}

func (_c *MockTokenHandler_Token_Call) RunAndReturn(run func() (Token, error)) *MockTokenHandler_Token_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockJWKsHandler creates a new instance of MockJWKsHandler. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockJWKsHandler(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockJWKsHandler {
	mock := &MockJWKsHandler{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockJWKsHandler is an autogenerated mock type for the JWKsHandler type
type MockJWKsHandler struct {
	mock.Mock
}

type MockJWKsHandler_Expecter struct {
	mock *mock.Mock
}

func (_m *MockJWKsHandler) EXPECT() *MockJWKsHandler_Expecter {
	return &MockJWKsHandler_Expecter{mock: &_m.Mock}
}

// KeySet provides a mock function for the type MockJWKsHandler
func (_mock *MockJWKsHandler) KeySet() jose.JSONWebKeySet {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for KeySet")
	}

	var r0 jose.JSONWebKeySet
	if returnFunc, ok := ret.Get(0).(func() jose.JSONWebKeySet); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(jose.JSONWebKeySet)
	}
	return r0
}

// MockJWKsHandler_KeySet_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'KeySet'
type MockJWKsHandler_KeySet_Call struct {
	*mock.Call
}

// KeySet is a helper method to define mock.On call
func (_e *MockJWKsHandler_Expecter) KeySet() *MockJWKsHandler_KeySet_Call {
	return &MockJWKsHandler_KeySet_Call{Call: _e.mock.On("KeySet")}
}

func (_c *MockJWKsHandler_KeySet_Call) Run(run func()) *MockJWKsHandler_KeySet_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockJWKsHandler_KeySet_Call) Return(jSONWebKeySet jose.JSONWebKeySet) *MockJWKsHandler_KeySet_Call {
	_c.Call.Return(jSONWebKeySet)
	return _c
}

func (_c *MockJWKsHandler_KeySet_Call) RunAndReturn(run func() jose.JSONWebKeySet) *MockJWKsHandler_KeySet_Call {
	_c.Call.Return(run)
	return _c
}
