/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-codegen.sh

// AUTO-GENERATED FUNCTIONS START HERE. DO NOT EDIT.
var map_BasicSchedulingPolicy = map[string]string{
	"": "BasicSchedulingPolicy indicates that standard Kubernetes scheduling behavior should be used.",
}

func (BasicSchedulingPolicy) SwaggerDoc() map[string]string {
	return map_BasicSchedulingPolicy
}

var map_GangSchedulingPolicy = map[string]string{
	"":         "GangSchedulingPolicy defines the parameters for gang scheduling.",
	"minCount": "MinCount is the minimum number of pods that must be schedulable or scheduled at the same time for the scheduler to admit the entire group. It must be a positive integer.",
}

func (GangSchedulingPolicy) SwaggerDoc() map[string]string {
	return map_GangSchedulingPolicy
}

var map_PodGroup = map[string]string{
	"":       "PodGroup represents a set of pods with a common scheduling policy.",
	"name":   "Name is a unique identifier for the PodGroup within the Workload. It must be a DNS label. This field is immutable.",
	"policy": "Policy defines the scheduling policy for this PodGroup.",
}

func (PodGroup) SwaggerDoc() map[string]string {
	return map_PodGroup
}

var map_PodGroupPolicy = map[string]string{
	"":      "PodGroupPolicy defines the scheduling configuration for a PodGroup.",
	"basic": "Basic specifies that the pods in this group should be scheduled using standard Kubernetes scheduling behavior.",
	"gang":  "Gang specifies that the pods in this group should be scheduled using all-or-nothing semantics.",
}

func (PodGroupPolicy) SwaggerDoc() map[string]string {
	return map_PodGroupPolicy
}

var map_PriorityClass = map[string]string{
	"":                 "DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.",
	"metadata":         "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"value":            "value represents the integer value of this priority class. This is the actual priority that pods receive when they have the name of this class in their pod spec.",
	"globalDefault":    "globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. Only one PriorityClass can be marked as `globalDefault`. However, if more than one PriorityClasses exists with their `globalDefault` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.",
	"description":      "description is an arbitrary string that usually provides guidelines on when this priority class should be used.",
	"preemptionPolicy": "preemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.",
}

func (PriorityClass) SwaggerDoc() map[string]string {
	return map_PriorityClass
}

var map_PriorityClassList = map[string]string{
	"":         "PriorityClassList is a collection of priority classes.",
	"metadata": "Standard list metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "items is the list of PriorityClasses",
}

func (PriorityClassList) SwaggerDoc() map[string]string {
	return map_PriorityClassList
}

var map_TypedLocalObjectReference = map[string]string{
	"":         "TypedLocalObjectReference allows to reference typed object inside the same namespace.",
	"apiGroup": "APIGroup is the group for the resource being referenced. If APIGroup is empty, the specified Kind must be in the core API group. For any other third-party types, setting APIGroup is required. It must be a DNS subdomain.",
	"kind":     "Kind is the type of resource being referenced. It must be a path segment name.",
	"name":     "Name is the name of resource being referenced. It must be a path segment name.",
}

func (TypedLocalObjectReference) SwaggerDoc() map[string]string {
	return map_TypedLocalObjectReference
}

var map_Workload = map[string]string{
	"":         "Workload allows for expressing scheduling constraints that should be used when managing lifecycle of workloads from scheduling perspective, including scheduling, preemption, eviction and other phases.",
	"metadata": "Standard object's metadata. Name must be a DNS subdomain.",
	"spec":     "Spec defines the desired behavior of a Workload.",
}

func (Workload) SwaggerDoc() map[string]string {
	return map_Workload
}

var map_WorkloadList = map[string]string{
	"":         "WorkloadList contains a list of Workload resources.",
	"metadata": "Standard list metadata.",
	"items":    "Items is the list of Workloads.",
}

func (WorkloadList) SwaggerDoc() map[string]string {
	return map_WorkloadList
}

var map_WorkloadSpec = map[string]string{
	"":              "WorkloadSpec defines the desired state of a Workload.",
	"controllerRef": "ControllerRef is an optional reference to the controlling object, such as a Deployment or Job. This field is intended for use by tools like CLIs to provide a link back to the original workload definition. When set, it cannot be changed.",
	"podGroups":     "PodGroups is the list of pod groups that make up the Workload. The maximum number of pod groups is 8. This field is immutable.",
}

func (WorkloadSpec) SwaggerDoc() map[string]string {
	return map_WorkloadSpec
}

// AUTO-GENERATED FUNCTIONS END HERE
