/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// TopologySelectorTermApplyConfiguration represents a declarative configuration of the TopologySelectorTerm type for use
// with apply.
//
// A topology selector term represents the result of label queries.
// A null or empty topology selector term matches no objects.
// The requirements of them are ANDed.
// It provides a subset of functionality as NodeSelectorTerm.
// This is an alpha feature and may change in the future.
type TopologySelectorTermApplyConfiguration struct {
	// A list of topology selector requirements by labels.
	MatchLabelExpressions []TopologySelectorLabelRequirementApplyConfiguration `json:"matchLabelExpressions,omitempty"`
}

// TopologySelectorTermApplyConfiguration constructs a declarative configuration of the TopologySelectorTerm type for use with
// apply.
func TopologySelectorTerm() *TopologySelectorTermApplyConfiguration {
	return &TopologySelectorTermApplyConfiguration{}
}

// WithMatchLabelExpressions adds the given value to the MatchLabelExpressions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the MatchLabelExpressions field.
func (b *TopologySelectorTermApplyConfiguration) WithMatchLabelExpressions(values ...*TopologySelectorLabelRequirementApplyConfiguration) *TopologySelectorTermApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMatchLabelExpressions")
		}
		b.MatchLabelExpressions = append(b.MatchLabelExpressions, *values[i])
	}
	return b
}
