/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	mock "github.com/stretchr/testify/mock"
	"k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
)

// NewMockPodStatusProvider creates a new instance of MockPodStatusProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockPodStatusProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockPodStatusProvider {
	mock := &MockPodStatusProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockPodStatusProvider is an autogenerated mock type for the PodStatusProvider type
type MockPodStatusProvider struct {
	mock.Mock
}

type MockPodStatusProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockPodStatusProvider) EXPECT() *MockPodStatusProvider_Expecter {
	return &MockPodStatusProvider_Expecter{mock: &_m.Mock}
}

// GetPodStatus provides a mock function for the type MockPodStatusProvider
func (_mock *MockPodStatusProvider) GetPodStatus(uid types.UID) (v1.PodStatus, bool) {
	ret := _mock.Called(uid)

	if len(ret) == 0 {
		panic("no return value specified for GetPodStatus")
	}

	var r0 v1.PodStatus
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(types.UID) (v1.PodStatus, bool)); ok {
		return returnFunc(uid)
	}
	if returnFunc, ok := ret.Get(0).(func(types.UID) v1.PodStatus); ok {
		r0 = returnFunc(uid)
	} else {
		r0 = ret.Get(0).(v1.PodStatus)
	}
	if returnFunc, ok := ret.Get(1).(func(types.UID) bool); ok {
		r1 = returnFunc(uid)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockPodStatusProvider_GetPodStatus_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodStatus'
type MockPodStatusProvider_GetPodStatus_Call struct {
	*mock.Call
}

// GetPodStatus is a helper method to define mock.On call
//   - uid types.UID
func (_e *MockPodStatusProvider_Expecter) GetPodStatus(uid interface{}) *MockPodStatusProvider_GetPodStatus_Call {
	return &MockPodStatusProvider_GetPodStatus_Call{Call: _e.mock.On("GetPodStatus", uid)}
}

func (_c *MockPodStatusProvider_GetPodStatus_Call) Run(run func(uid types.UID)) *MockPodStatusProvider_GetPodStatus_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 types.UID
		if args[0] != nil {
			arg0 = args[0].(types.UID)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockPodStatusProvider_GetPodStatus_Call) Return(podStatus v1.PodStatus, b bool) *MockPodStatusProvider_GetPodStatus_Call {
	_c.Call.Return(podStatus, b)
	return _c
}

func (_c *MockPodStatusProvider_GetPodStatus_Call) RunAndReturn(run func(uid types.UID) (v1.PodStatus, bool)) *MockPodStatusProvider_GetPodStatus_Call {
	_c.Call.Return(run)
	return _c
}
