// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains details about an API destination.
type ApiDestination struct {

	// The ARN of the API destination.
	ApiDestinationArn *string

	// The state of the API destination.
	ApiDestinationState ApiDestinationState

	// The ARN of the connection specified for the API destination.
	ConnectionArn *string

	// A time stamp for the time that the API destination was created.
	CreationTime *time.Time

	// The method to use to connect to the HTTP endpoint.
	HttpMethod ApiDestinationHttpMethod

	// The URL to the endpoint for the API destination.
	InvocationEndpoint *string

	// The maximum number of invocations per second to send to the HTTP endpoint.
	InvocationRateLimitPerSecond *int32

	// A time stamp for the time that the API destination was last modified.
	LastModifiedTime *time.Time

	// The name of the API destination.
	Name *string

	noSmithyDocumentSerde
}

// Contains the GraphQL operation to be parsed and executed, if the event target
// is an AppSync API.
type AppSyncParameters struct {

	// The GraphQL operation; that is, the query, mutation, or subscription to be
	// parsed and executed by the GraphQL service.
	//
	// For more information, see [Operations] in the AppSync User Guide.
	//
	// [Operations]: https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations
	GraphQLOperation *string

	noSmithyDocumentSerde
}

// An Archive object that contains details about an archive.
type Archive struct {

	// The name of the archive.
	ArchiveName *string

	// The time stamp for the time that the archive was created.
	CreationTime *time.Time

	// The number of events in the archive.
	EventCount int64

	// The ARN of the event bus associated with the archive. Only events from this
	// event bus are sent to the archive.
	EventSourceArn *string

	// The number of days to retain events in the archive before they are deleted.
	RetentionDays *int32

	// The size of the archive, in bytes.
	SizeBytes int64

	// The current state of the archive.
	State ArchiveState

	// A description for the reason that the archive is in the current state.
	StateReason *string

	noSmithyDocumentSerde
}

// This structure specifies the VPC subnets and security groups for the task, and
// whether a public IP address is to be used. This structure is relevant only for
// ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {

	// Specifies the subnets associated with the task. These subnets must all be in
	// the same VPC. You can specify as many as 16 subnets.
	//
	// This member is required.
	Subnets []string

	// Specifies whether the task's elastic network interface receives a public IP
	// address. You can specify ENABLED only when LaunchType in EcsParameters is set
	// to FARGATE .
	AssignPublicIp AssignPublicIp

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups. If
	// you do not specify a security group, the default security group for the VPC is
	// used.
	SecurityGroups []string

	noSmithyDocumentSerde
}

// The array properties for the submitted job, such as the size of the array. The
// array size can be between 2 and 10,000. If you specify array properties for a
// job, it becomes an array job. This parameter is used only if the target is an
// Batch job.
type BatchArrayProperties struct {

	// The size of the array, if this is an array batch job. Valid values are integers
	// between 2 and 10,000.
	Size int32

	noSmithyDocumentSerde
}

// The custom parameters to be used when the target is an Batch job.
type BatchParameters struct {

	// The ARN or name of the job definition to use if the event target is an Batch
	// job. This job definition must already exist.
	//
	// This member is required.
	JobDefinition *string

	// The name to use for this execution of the job, if the target is an Batch job.
	//
	// This member is required.
	JobName *string

	// The array properties for the submitted job, such as the size of the array. The
	// array size can be between 2 and 10,000. If you specify array properties for a
	// job, it becomes an array job. This parameter is used only if the target is an
	// Batch job.
	ArrayProperties *BatchArrayProperties

	// The retry strategy to use for failed jobs, if the target is an Batch job. The
	// retry strategy is the number of times to retry the failed job execution. Valid
	// values are 1–10. When you specify a retry strategy here, it overrides the retry
	// strategy defined in the job definition.
	RetryStrategy *BatchRetryStrategy

	noSmithyDocumentSerde
}

// The retry strategy to use for failed jobs, if the target is an Batch job. If
// you specify a retry strategy here, it overrides the retry strategy defined in
// the job definition.
type BatchRetryStrategy struct {

	// The number of times to attempt to retry, if the job fails. Valid values are
	// 1–10.
	Attempts int32

	noSmithyDocumentSerde
}

// The details of a capacity provider strategy. To learn more, see [CapacityProviderStrategyItem] in the Amazon
// ECS API Reference.
//
// [CapacityProviderStrategyItem]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html
type CapacityProviderStrategyItem struct {

	// The short name of the capacity provider.
	//
	// This member is required.
	CapacityProvider *string

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0 is
	// used.
	Base int32

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider. The weight value
	// is taken into consideration after the base value, if defined, is satisfied.
	Weight int32

	noSmithyDocumentSerde
}

// A JSON string which you can use to limit the event bus permissions you are
// granting to only accounts that fulfill the condition. Currently, the only
// supported condition is membership in a certain Amazon Web Services organization.
// The string must contain Type , Key , and Value fields. The Value field
// specifies the ID of the Amazon Web Services organization. Following is an
// example value for Condition :
//
//	'{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value":
//	"o-1234567890"}'
type Condition struct {

	// Specifies the key for the condition. Currently the only supported key is
	// aws:PrincipalOrgID .
	//
	// This member is required.
	Key *string

	// Specifies the type of condition. Currently the only supported value is
	// StringEquals .
	//
	// This member is required.
	Type *string

	// Specifies the value for the key. Currently, this must be the ID of the
	// organization.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about a connection.
type Connection struct {

	// The authorization type specified for the connection.
	//
	// OAUTH tokens are refreshed when a 401 or 407 response is returned.
	AuthorizationType ConnectionAuthorizationType

	// The ARN of the connection.
	ConnectionArn *string

	// The state of the connection.
	ConnectionState ConnectionState

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time

	// A time stamp for the time that the connection was last authorized.
	LastAuthorizedTime *time.Time

	// A time stamp for the time that the connection was last modified.
	LastModifiedTime *time.Time

	// The name of the connection.
	Name *string

	// The reason that the connection is in the connection state.
	StateReason *string

	noSmithyDocumentSerde
}

// Contains the authorization parameters for the connection if API Key is
// specified as the authorization type.
type ConnectionApiKeyAuthResponseParameters struct {

	// The name of the header to use for the APIKeyValue used for authorization.
	ApiKeyName *string

	noSmithyDocumentSerde
}

// Tthe authorization parameters to use for the connection.
type ConnectionAuthResponseParameters struct {

	// The API Key parameters to use for authorization.
	ApiKeyAuthParameters *ConnectionApiKeyAuthResponseParameters

	// The authorization parameters for Basic authorization.
	BasicAuthParameters *ConnectionBasicAuthResponseParameters

	// For private OAuth authentication endpoints. The parameters EventBridge uses to
	// authenticate against the endpoint.
	//
	// For more information, see [Authorization methods for connections] in the Amazon EventBridge User Guide .
	//
	// [Authorization methods for connections]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html
	ConnectivityParameters *DescribeConnectionConnectivityParameters

	// Additional parameters for the connection that are passed through with every
	// invocation to the HTTP endpoint.
	InvocationHttpParameters *ConnectionHttpParameters

	// The OAuth parameters to use for authorization.
	OAuthParameters *ConnectionOAuthResponseParameters

	noSmithyDocumentSerde
}

// The authorization parameters for the connection if Basic is specified as the
// authorization type.
type ConnectionBasicAuthResponseParameters struct {

	// The user name to use for Basic authorization.
	Username *string

	noSmithyDocumentSerde
}

// Additional parameter included in the body. You can include up to 100 additional
// body parameters per request. An event payload cannot exceed 64 KB.
type ConnectionBodyParameter struct {

	// Specifies whether the value is secret.
	IsValueSecret bool

	// The key for the parameter.
	Key *string

	// The value associated with the key.
	Value *string

	noSmithyDocumentSerde
}

// Additional parameter included in the header. You can include up to 100
// additional header parameters per request. An event payload cannot exceed 64 KB.
type ConnectionHeaderParameter struct {

	// Specifies whether the value is a secret.
	IsValueSecret bool

	// The key for the parameter.
	Key *string

	// The value associated with the key.
	Value *string

	noSmithyDocumentSerde
}

// Any additional parameters for the connection.
type ConnectionHttpParameters struct {

	// Any additional body string parameters for the connection.
	BodyParameters []ConnectionBodyParameter

	// Any additional header parameters for the connection.
	HeaderParameters []ConnectionHeaderParameter

	// Any additional query string parameters for the connection.
	QueryStringParameters []ConnectionQueryStringParameter

	noSmithyDocumentSerde
}

// The client response parameters for the connection when OAuth is specified as
// the authorization type.
type ConnectionOAuthClientResponseParameters struct {

	// The client ID associated with the response to the connection request.
	ClientID *string

	noSmithyDocumentSerde
}

// The response parameters when OAuth is specified as the authorization type.
type ConnectionOAuthResponseParameters struct {

	// The URL to the HTTP endpoint that authorized the request.
	AuthorizationEndpoint *string

	// Details about the client parameters returned when OAuth is specified as the
	// authorization type.
	ClientParameters *ConnectionOAuthClientResponseParameters

	// The method used to connect to the HTTP endpoint.
	HttpMethod ConnectionOAuthHttpMethod

	// The additional HTTP parameters used for the OAuth authorization request.
	OAuthHttpParameters *ConnectionHttpParameters

	noSmithyDocumentSerde
}

// Any additional query string parameter for the connection. You can include up to
// 100 additional query string parameters per request. Each additional parameter
// counts towards the event payload size, which cannot exceed 64 KB.
type ConnectionQueryStringParameter struct {

	// Specifies whether the value is secret.
	IsValueSecret bool

	// The key for a query string parameter.
	Key *string

	// The value associated with the key for the query string parameter.
	Value *string

	noSmithyDocumentSerde
}

// The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration
// for the resource endpoint.
type ConnectivityResourceConfigurationArn struct {

	// The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration
	// for the resource endpoint.
	//
	// This member is required.
	ResourceConfigurationArn *string

	noSmithyDocumentSerde
}

// The parameters for EventBridge to use when invoking the resource endpoint.
type ConnectivityResourceParameters struct {

	// The parameters for EventBridge to use when invoking the resource endpoint.
	//
	// This member is required.
	ResourceParameters *ConnectivityResourceConfigurationArn

	noSmithyDocumentSerde
}

// The API key authorization parameters for the connection.
type CreateConnectionApiKeyAuthRequestParameters struct {

	// The name of the API key to use for authorization.
	//
	// This member is required.
	ApiKeyName *string

	// The value for the API key to use for authorization.
	//
	// This member is required.
	ApiKeyValue *string

	noSmithyDocumentSerde
}

// The authorization parameters for the connection.
//
// You must include only authorization parameters for the AuthorizationType you
// specify.
type CreateConnectionAuthRequestParameters struct {

	// The API key authorization parameters to use for the connection.
	ApiKeyAuthParameters *CreateConnectionApiKeyAuthRequestParameters

	// The Basic authorization parameters to use for the connection.
	BasicAuthParameters *CreateConnectionBasicAuthRequestParameters

	// If you specify a private OAuth endpoint, the parameters for EventBridge to use
	// when authenticating against the endpoint.
	//
	// For more information, see [Authorization methods for connections] in the Amazon EventBridge User Guide .
	//
	// [Authorization methods for connections]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html
	ConnectivityParameters *ConnectivityResourceParameters

	// The API key authorization parameters to use for the connection. Note that if
	// you include additional parameters for the target of a rule via HttpParameters ,
	// including query strings, the parameters added for the connection take
	// precedence.
	InvocationHttpParameters *ConnectionHttpParameters

	// The OAuth authorization parameters to use for the connection.
	OAuthParameters *CreateConnectionOAuthRequestParameters

	noSmithyDocumentSerde
}

// Contains the Basic authorization parameters to use for the connection.
type CreateConnectionBasicAuthRequestParameters struct {

	// The password associated with the user name to use for Basic authorization.
	//
	// This member is required.
	Password *string

	// The user name to use for Basic authorization.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The Basic authorization parameters to use for the connection.
type CreateConnectionOAuthClientRequestParameters struct {

	// The client ID to use for OAuth authorization for the connection.
	//
	// This member is required.
	ClientID *string

	// The client secret associated with the client ID to use for OAuth authorization
	// for the connection.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Contains the OAuth authorization parameters to use for the connection.
type CreateConnectionOAuthRequestParameters struct {

	// The URL to the authorization endpoint when OAuth is specified as the
	// authorization type.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The client parameters for OAuth authorization.
	//
	// This member is required.
	ClientParameters *CreateConnectionOAuthClientRequestParameters

	// The method to use for the authorization request.
	//
	// This member is required.
	HttpMethod ConnectionOAuthHttpMethod

	// Details about the additional parameters to use for the connection.
	OAuthHttpParameters *ConnectionHttpParameters

	noSmithyDocumentSerde
}

// Configuration details of the Amazon SQS queue for EventBridge to use as a
// dead-letter queue (DLQ).
//
// For more information, see [Using dead-letter queues to process undelivered events] in the EventBridge User Guide.
//
// [Using dead-letter queues to process undelivered events]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-rule-event-delivery.html#eb-rule-dlq
type DeadLetterConfig struct {

	// The ARN of the SQS queue specified as the target for the dead-letter queue.
	Arn *string

	noSmithyDocumentSerde
}

// If the connection uses a private OAuth endpoint, the parameters for EventBridge
// to use when authenticating against the endpoint.
//
// For more information, see [Authorization methods for connections] in the Amazon EventBridge User Guide .
//
// [Authorization methods for connections]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html
type DescribeConnectionConnectivityParameters struct {

	// The parameters for EventBridge to use when invoking the resource endpoint.
	//
	// This member is required.
	ResourceParameters *DescribeConnectionResourceParameters

	noSmithyDocumentSerde
}

// The parameters for EventBridge to use when invoking the resource endpoint.
type DescribeConnectionResourceParameters struct {

	// For connections to private APIs, the Amazon Resource Name (ARN) of the resource
	// association EventBridge created between the connection and the private API's
	// resource configuration.
	//
	// For more information, see [Managing service network resource associations for connections] in the Amazon EventBridge User Guide .
	//
	// [Managing service network resource associations for connections]: https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html#connection-private-snra
	//
	// This member is required.
	ResourceAssociationArn *string

	// The Amazon Resource Name (ARN) of the resource configuration for the private
	// API.
	//
	// This member is required.
	ResourceConfigurationArn *string

	noSmithyDocumentSerde
}

// The custom parameters to be used when the target is an Amazon ECS task.
type EcsParameters struct {

	// The ARN of the task definition to use if the event target is an Amazon ECS
	// task.
	//
	// This member is required.
	TaskDefinitionArn *string

	// The capacity provider strategy to use for the task.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must be
	// omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	CapacityProviderStrategy []CapacityProviderStrategyItem

	// Specifies whether to enable Amazon ECS managed tags for the task. For more
	// information, see [Tagging Your Amazon ECS Resources]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Tagging Your Amazon ECS Resources]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html
	EnableECSManagedTags bool

	// Whether or not to enable the execute command functionality for the containers
	// in this task. If true, this enables execute command functionality on all
	// containers in the task.
	EnableExecuteCommand bool

	// Specifies an ECS task group for the task. The maximum length is 255 characters.
	Group *string

	// Specifies the launch type on which your task is running. The launch type that
	// you specify here must match one of the launch type (compatibilities) of the
	// target task. The FARGATE value is supported only in the Regions where Fargate
	// with Amazon ECS is supported. For more information, see [Fargate on Amazon ECS]in the Amazon Elastic
	// Container Service Developer Guide.
	//
	// [Fargate on Amazon ECS]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html
	LaunchType LaunchType

	// Use this structure if the Amazon ECS task uses the awsvpc network mode. This
	// structure specifies the VPC subnets and security groups associated with the
	// task, and whether a public IP address is to be used. This structure is required
	// if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks.
	//
	// If you specify NetworkConfiguration when the target ECS task does not use the
	// awsvpc network mode, the task fails.
	NetworkConfiguration *NetworkConfiguration

	// An array of placement constraint objects to use for the task. You can specify
	// up to 10 constraints per task (including constraints in the task definition and
	// those specified at runtime).
	PlacementConstraints []PlacementConstraint

	// The placement strategy objects to use for the task. You can specify a maximum
	// of five strategy rules per task.
	PlacementStrategy []PlacementStrategy

	// Specifies the platform version for the task. Specify only the numeric portion
	// of the platform version, such as 1.1.0 .
	//
	// This structure is used only if LaunchType is FARGATE . For more information
	// about valid platform versions, see [Fargate Platform Versions]in the Amazon Elastic Container Service
	// Developer Guide.
	//
	// [Fargate Platform Versions]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
	PlatformVersion *string

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags are not propagated. Tags can only be
	// propagated to the task during task creation. To add tags to a task after task
	// creation, use the TagResource API action.
	PropagateTags PropagateTags

	// The reference ID to use for the task.
	ReferenceId *string

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. To learn more, see [RunTask]in the Amazon ECS API Reference.
	//
	// [RunTask]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags
	Tags []Tag

	// The number of tasks to create based on TaskDefinition . The default is 1.
	TaskCount *int32

	noSmithyDocumentSerde
}

// A global endpoint used to improve your application's availability by making it
// regional-fault tolerant. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication]in
// the Amazon EventBridge User Guide .
//
// [Making applications Regional-fault tolerant with global endpoints and event replication]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html
type Endpoint struct {

	// The ARN of the endpoint.
	Arn *string

	// The time the endpoint was created.
	CreationTime *time.Time

	// A description for the endpoint.
	Description *string

	// The URL subdomain of the endpoint. For example, if the URL for Endpoint is
	// https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is
	// abcde.veo .
	EndpointId *string

	// The URL of the endpoint.
	EndpointUrl *string

	// The event buses being used by the endpoint.
	EventBuses []EndpointEventBus

	// The last time the endpoint was modified.
	LastModifiedTime *time.Time

	// The name of the endpoint.
	Name *string

	// Whether event replication was enabled or disabled for this endpoint. The
	// default state is ENABLED which means you must supply a RoleArn . If you don't
	// have a RoleArn or you don't want event replication enabled, set the state to
	// DISABLED .
	ReplicationConfig *ReplicationConfig

	// The ARN of the role used by event replication for the endpoint.
	RoleArn *string

	// The routing configuration of the endpoint.
	RoutingConfig *RoutingConfig

	// The current state of the endpoint.
	State EndpointState

	// The reason the endpoint is in its current state.
	StateReason *string

	noSmithyDocumentSerde
}

// The event buses the endpoint is associated with.
type EndpointEventBus struct {

	// The ARN of the event bus the endpoint is associated with.
	//
	// This member is required.
	EventBusArn *string

	noSmithyDocumentSerde
}

// An event bus receives events from a source, uses rules to evaluate them,
// applies any configured input transformation, and routes them to the appropriate
// target(s). Your account's default event bus receives events from Amazon Web
// Services services. A custom event bus can receive events from your custom
// applications and services. A partner event bus receives events from an event
// source created by an SaaS partner. These events come from the partners services
// or applications.
type EventBus struct {

	// The ARN of the event bus.
	Arn *string

	// The time the event bus was created.
	CreationTime *time.Time

	// The event bus description.
	Description *string

	// The time the event bus was last modified.
	LastModifiedTime *time.Time

	// The name of the event bus.
	Name *string

	// The permissions policy of the event bus, describing which other Amazon Web
	// Services accounts can write events to this event bus.
	Policy *string

	noSmithyDocumentSerde
}

// A partner event source is created by an SaaS partner. If a customer creates a
// partner event bus that matches this event source, that Amazon Web Services
// account can receive events from the partner's applications or services.
type EventSource struct {

	// The ARN of the event source.
	Arn *string

	// The name of the partner that created the event source.
	CreatedBy *string

	// The date and time the event source was created.
	CreationTime *time.Time

	// The date and time that the event source will expire, if the Amazon Web Services
	// account doesn't create a matching event bus for it.
	ExpirationTime *time.Time

	// The name of the event source.
	Name *string

	// The state of the event source. If it is ACTIVE, you have already created a
	// matching event bus for this event source, and that event bus is active. If it is
	// PENDING, either you haven't yet created a matching event bus, or that event bus
	// is deactivated. If it is DELETED, you have created a matching event bus, but the
	// event source has since been deleted.
	State EventSourceState

	noSmithyDocumentSerde
}

// The failover configuration for an endpoint. This includes what triggers
// failover and what happens when it's triggered.
type FailoverConfig struct {

	// The main Region of the endpoint.
	//
	// This member is required.
	Primary *Primary

	// The Region that events are routed to when failover is triggered or event
	// replication is enabled.
	//
	// This member is required.
	Secondary *Secondary

	noSmithyDocumentSerde
}

// These are custom parameter to be used when the target is an API Gateway APIs or
// EventBridge ApiDestinations. In the latter case, these are merged with any
// InvocationParameters specified on the Connection, with any values from the
// Connection taking precedence.
type HttpParameters struct {

	// The headers that need to be sent as part of request invoking the API Gateway
	// API or EventBridge ApiDestination.
	HeaderParameters map[string]string

	// The path parameter values to be used to populate API Gateway API or EventBridge
	// ApiDestination path wildcards ("*").
	PathParameterValues []string

	// The query string keys/values that need to be sent as part of request invoking
	// the API Gateway API or EventBridge ApiDestination.
	QueryStringParameters map[string]string

	noSmithyDocumentSerde
}

// Contains the parameters needed for you to provide custom input to a target
// based on one or more pieces of data extracted from the event.
type InputTransformer struct {

	// Input template where you specify placeholders that will be filled with the
	// values of the keys from InputPathsMap to customize the data sent to the target.
	// Enclose each InputPathsMaps value in brackets: <value>
	//
	// If InputTemplate is a JSON object (surrounded by curly braces), the following
	// restrictions apply:
	//
	//   - The placeholder cannot be used as an object key.
	//
	// The following example shows the syntax for using InputPathsMap and InputTemplate
	// .
	//
	//     "InputTransformer":
	//
	//     {
	//
	//     "InputPathsMap": {"instance": "$.detail.instance","status":
	//     "$.detail.status"},
	//
	//     "InputTemplate": " is in state "
	//
	//     }
	//
	// To have the InputTemplate include quote marks within a JSON string, escape each
	// quote marks with a slash, as in the following example:
	//
	//     "InputTransformer":
	//
	//     {
	//
	//     "InputPathsMap": {"instance": "$.detail.instance","status":
	//     "$.detail.status"},
	//
	//     "InputTemplate": " is in state \"\""
	//
	//     }
	//
	// The InputTemplate can also be valid JSON with varibles in quotes or out, as in
	// the following example:
	//
	//     "InputTransformer":
	//
	//     {
	//
	//     "InputPathsMap": {"instance": "$.detail.instance","status":
	//     "$.detail.status"},
	//
	//     "InputTemplate": '{"myInstance": ,"myStatus": " is in state \"\""}'
	//
	//     }
	//
	// This member is required.
	InputTemplate *string

	// Map of JSON paths to be extracted from the event. You can then insert these in
	// the template in InputTemplate to produce the output you want to be sent to the
	// target.
	//
	// InputPathsMap is an array key-value pairs, where each value is a valid JSON
	// path. You can have as many as 100 key-value pairs. You must use JSON dot
	// notation, not bracket notation.
	//
	// The keys cannot start with "Amazon Web Services."
	InputPathsMap map[string]string

	noSmithyDocumentSerde
}

// This object enables you to specify a JSON path to extract from the event and
// use as the partition key for the Amazon Kinesis data stream, so that you can
// control the shard to which the event goes. If you do not include this parameter,
// the default is to use the eventId as the partition key.
type KinesisParameters struct {

	// The JSON path to be extracted from the event and used as the partition key. For
	// more information, see [Amazon Kinesis Streams Key Concepts]in the Amazon Kinesis Streams Developer Guide.
	//
	// [Amazon Kinesis Streams Key Concepts]: https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key
	//
	// This member is required.
	PartitionKeyPath *string

	noSmithyDocumentSerde
}

// The logging configuration settings for the event bus.
//
// For more information, see [Configuring logs for event buses] in the EventBridge User Guide.
//
// [Configuring logs for event buses]: https://docs.aws.amazon.com/eb-event-bus-logs.html
type LogConfig struct {

	// Whether EventBridge include detailed event information in the records it
	// generates. Detailed data can be useful for troubleshooting and debugging. This
	// information includes details of the event itself, as well as target details.
	//
	// For more information, see [Including detail data in event bus logs] in the EventBridge User Guide.
	//
	// [Including detail data in event bus logs]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-logs-data
	IncludeDetail IncludeDetail

	// The level of logging detail to include. This applies to all log destinations
	// for the event bus.
	//
	// For more information, see [Specifying event bus log level] in the EventBridge User Guide.
	//
	// [Specifying event bus log level]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus-logs.html#eb-event-bus-logs-level
	Level Level

	noSmithyDocumentSerde
}

// This structure specifies the network configuration for an ECS task.
type NetworkConfiguration struct {

	// Use this structure to specify the VPC subnets and security groups for the task,
	// and whether a public IP address is to be used. This structure is relevant only
	// for ECS tasks that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration

	noSmithyDocumentSerde
}

// A partner event source is created by an SaaS partner. If a customer creates a
// partner event bus that matches this event source, that Amazon Web Services
// account can receive events from the partner's applications or services.
type PartnerEventSource struct {

	// The ARN of the partner event source.
	Arn *string

	// The name of the partner event source.
	Name *string

	noSmithyDocumentSerde
}

// The Amazon Web Services account that a partner event source has been offered to.
type PartnerEventSourceAccount struct {

	// The Amazon Web Services account ID that the partner event source was offered to.
	Account *string

	// The date and time the event source was created.
	CreationTime *time.Time

	// The date and time that the event source will expire, if the Amazon Web Services
	// account doesn't create a matching event bus for it.
	ExpirationTime *time.Time

	// The state of the event source. If it is ACTIVE, you have already created a
	// matching event bus for this event source, and that event bus is active. If it is
	// PENDING, either you haven't yet created a matching event bus, or that event bus
	// is deactivated. If it is DELETED, you have created a matching event bus, but the
	// event source has since been deleted.
	State EventSourceState

	noSmithyDocumentSerde
}

// An object representing a constraint on task placement. To learn more, see [Task Placement Constraints] in
// the Amazon Elastic Container Service Developer Guide.
//
// [Task Placement Constraints]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html
type PlacementConstraint struct {

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance . To learn
	// more, see [Cluster Query Language]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Cluster Query Language]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html
	Expression *string

	// The type of constraint. Use distinctInstance to ensure that each task in a
	// particular group is running on a different container instance. Use memberOf to
	// restrict the selection to a group of valid candidates.
	Type PlacementConstraintType

	noSmithyDocumentSerde
}

// The task placement strategy for a task or service. To learn more, see [Task Placement Strategies] in the
// Amazon Elastic Container Service Service Developer Guide.
//
// [Task Placement Strategies]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html
type PlacementStrategy struct {

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect), or
	// any platform or custom attribute that is applied to a container instance, such
	// as attribute:ecs.availability-zone. For the binpack placement strategy, valid
	// values are cpu and memory. For the random placement strategy, this field is not
	// used.
	Field *string

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least amount
	// of remaining memory (but still enough to run the task).
	Type PlacementStrategyType

	noSmithyDocumentSerde
}

// The primary Region of the endpoint.
type Primary struct {

	// The ARN of the health check used by the endpoint to determine whether failover
	// is triggered.
	//
	// This member is required.
	HealthCheck *string

	noSmithyDocumentSerde
}

// Represents an event to be submitted.
type PutEventsRequestEntry struct {

	// A valid JSON object. There is no other schema imposed. The JSON object may
	// contain fields and nested sub-objects.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	Detail *string

	// Free-form string, with a maximum of 128 characters, used to decide what fields
	// to expect in the event detail.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	DetailType *string

	// The name or ARN of the event bus to receive the event. Only the rules that are
	// associated with this event bus are used to match the event. If you omit this,
	// the default event bus is used.
	//
	// If you're using a global endpoint with a custom bus, you can enter either the
	// name or Amazon Resource Name (ARN) of the event bus in either the primary or
	// secondary Region here. EventBridge then determines the corresponding event bus
	// in the other Region based on the endpoint referenced by the EndpointId .
	// Specifying the event bus ARN is preferred.
	EventBusName *string

	// Amazon Web Services resources, identified by Amazon Resource Name (ARN), which
	// the event primarily concerns. Any number, including zero, may be present.
	Resources []string

	// The source of the event.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	Source *string

	// The time stamp of the event, per [RFC3339]. If no time stamp is provided, the time stamp
	// of the [PutEvents]call is used.
	//
	// [PutEvents]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html
	// [RFC3339]: https://www.rfc-editor.org/rfc/rfc3339.txt
	Time *time.Time

	// An X-Ray trace header, which is an http header (X-Amzn-Trace-Id) that contains
	// the trace-id associated with the event.
	//
	// To learn more about X-Ray trace headers, see [Tracing header] in the X-Ray Developer Guide.
	//
	// [Tracing header]: https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader
	TraceHeader *string

	noSmithyDocumentSerde
}

// Represents the results of an event submitted to an event bus.
//
// If the submission was successful, the entry has the event ID in it. Otherwise,
// you can use the error code and error message to identify the problem with the
// entry.
//
// For information about the errors that are common to all actions, see [Common Errors].
//
// [Common Errors]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html
type PutEventsResultEntry struct {

	// The error code that indicates why the event submission failed.
	//
	// Retryable errors include:
	//
	// [InternalFailure]
	//
	//   - The request processing has failed because of an unknown error, exception or
	//   failure.
	//
	// [ThrottlingException]
	//
	//   - The request was denied due to request throttling.
	//
	// Non-retryable errors include:
	//
	// [AccessDeniedException]
	//
	//   - You do not have sufficient access to perform this action.
	//
	//   - InvalidAccountIdException
	//
	// The account ID provided is not valid.
	//
	//   - InvalidArgument
	//
	// A specified parameter is not valid.
	//
	//   - MalformedDetail
	//
	// The JSON provided is not valid.
	//
	//   - RedactionFailure
	//
	// Redacting the CloudTrail event failed.
	//
	//   - NotAuthorizedForSourceException
	//
	// You do not have permissions to publish events with this source onto this event
	//   bus.
	//
	//   - NotAuthorizedForDetailTypeException
	//
	// You do not have permissions to publish events with this detail type onto this
	//   event bus.
	//
	// [AccessDeniedException]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html
	// [InternalFailure]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html
	// [ThrottlingException]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html
	ErrorCode *string

	// The error message that explains why the event submission failed.
	ErrorMessage *string

	// The ID of the event.
	EventId *string

	noSmithyDocumentSerde
}

// The details about an event generated by an SaaS partner.
type PutPartnerEventsRequestEntry struct {

	// A valid JSON string. There is no other schema imposed. The JSON string may
	// contain fields and nested sub-objects.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	Detail *string

	// A free-form string, with a maximum of 128 characters, used to decide what
	// fields to expect in the event detail.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	DetailType *string

	// Amazon Web Services resources, identified by Amazon Resource Name (ARN), which
	// the event primarily concerns. Any number, including zero, may be present.
	Resources []string

	// The event source that is generating the entry.
	//
	// Detail , DetailType , and Source are required for EventBridge to successfully
	// send an event to an event bus. If you include event entries in a request that do
	// not include each of those properties, EventBridge fails that entry. If you
	// submit a request in which none of the entries have each of these properties,
	// EventBridge fails the entire request.
	Source *string

	// The date and time of the event.
	Time *time.Time

	noSmithyDocumentSerde
}

// The result of an event entry the partner submitted in this request. If the
// event was successfully submitted, the entry has the event ID in it. Otherwise,
// you can use the error code and error message to identify the problem with the
// entry.
type PutPartnerEventsResultEntry struct {

	// The error code that indicates why the event submission failed.
	ErrorCode *string

	// The error message that explains why the event submission failed.
	ErrorMessage *string

	// The ID of the event.
	EventId *string

	noSmithyDocumentSerde
}

// Represents a target that failed to be added to a rule.
type PutTargetsResultEntry struct {

	// The error code that indicates why the target addition failed. If the value is
	// ConcurrentModificationException , too many requests were made at the same time.
	ErrorCode *string

	// The error message that explains why the target addition failed.
	ErrorMessage *string

	// The ID of the target.
	TargetId *string

	noSmithyDocumentSerde
}

// These are custom parameters to be used when the target is a Amazon Redshift
// cluster to invoke the Amazon Redshift Data API ExecuteStatement based on
// EventBridge events.
type RedshiftDataParameters struct {

	// The name of the database. Required when authenticating using temporary
	// credentials.
	//
	// This member is required.
	Database *string

	// The database user name. Required when authenticating using temporary
	// credentials.
	DbUser *string

	// The name or ARN of the secret that enables access to the database. Required
	// when authenticating using Amazon Web Services Secrets Manager.
	SecretManagerArn *string

	// The SQL statement text to run.
	Sql *string

	// One or more SQL statements to run. The SQL statements are run as a single
	// transaction. They run serially in the order of the array. Subsequent SQL
	// statements don't start until the previous statement in the array completes. If
	// any SQL statement fails, then because they are run as one transaction, all work
	// is rolled back.
	Sqls []string

	// The name of the SQL statement. You can name the SQL statement when you create
	// it to identify the query.
	StatementName *string

	// Indicates whether to send an event back to EventBridge after the SQL statement
	// runs.
	WithEvent bool

	noSmithyDocumentSerde
}

// Represents a target that failed to be removed from a rule.
type RemoveTargetsResultEntry struct {

	// The error code that indicates why the target removal failed. If the value is
	// ConcurrentModificationException , too many requests were made at the same time.
	ErrorCode *string

	// The error message that explains why the target removal failed.
	ErrorMessage *string

	// The ID of the target.
	TargetId *string

	noSmithyDocumentSerde
}

// A Replay object that contains details about a replay.
type Replay struct {

	// A time stamp for the time to start replaying events. Any event with a creation
	// time prior to the EventEndTime specified is replayed.
	EventEndTime *time.Time

	// A time stamp for the time that the last event was replayed.
	EventLastReplayedTime *time.Time

	// The ARN of the archive to replay event from.
	EventSourceArn *string

	// A time stamp for the time to start replaying events. This is determined by the
	// time in the event as described in [Time].
	//
	// [Time]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time
	EventStartTime *time.Time

	// A time stamp for the time that the replay completed.
	ReplayEndTime *time.Time

	// The name of the replay.
	ReplayName *string

	// A time stamp for the time that the replay started.
	ReplayStartTime *time.Time

	// The current state of the replay.
	State ReplayState

	// A description of why the replay is in the current state.
	StateReason *string

	noSmithyDocumentSerde
}

// A ReplayDestination object that contains details about a replay.
type ReplayDestination struct {

	// The ARN of the event bus to replay event to. You can replay events only to the
	// event bus specified to create the archive.
	//
	// This member is required.
	Arn *string

	// A list of ARNs for rules to replay events to.
	FilterArns []string

	noSmithyDocumentSerde
}

// Endpoints can replicate all events to the secondary Region.
type ReplicationConfig struct {

	// The state of event replication.
	State ReplicationState

	noSmithyDocumentSerde
}

// A RetryPolicy object that includes information about the retry policy settings.
type RetryPolicy struct {

	// The maximum amount of time, in seconds, to continue to make retry attempts.
	MaximumEventAgeInSeconds *int32

	// The maximum number of retry attempts to make before the request fails. Retry
	// attempts continue until either the maximum number of attempts is made or until
	// the duration of the MaximumEventAgeInSeconds is met.
	MaximumRetryAttempts *int32

	noSmithyDocumentSerde
}

// The routing configuration of the endpoint.
type RoutingConfig struct {

	// The failover configuration for an endpoint. This includes what triggers
	// failover and what happens when it's triggered.
	//
	// This member is required.
	FailoverConfig *FailoverConfig

	noSmithyDocumentSerde
}

// Contains information about a rule in Amazon EventBridge.
type Rule struct {

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string

	// The description of the rule.
	Description *string

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string

	// The event pattern of the rule. For more information, see [Events and Event Patterns] in the Amazon
	// EventBridge User Guide .
	//
	// [Events and Event Patterns]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html
	EventPattern *string

	// If the rule was created on behalf of your account by an Amazon Web Services
	// service, this field displays the principal name of the service that created the
	// rule.
	ManagedBy *string

	// The name of the rule.
	Name *string

	// The Amazon Resource Name (ARN) of the role that is used for target invocation.
	//
	// If you're setting an event bus in another account as the target and that
	// account granted permission to your account through an organization instead of
	// directly by the account ID, you must specify a RoleArn with proper permissions
	// in the Target structure, instead of here in this parameter.
	RoleArn *string

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5
	// minutes)". For more information, see [Creating an Amazon EventBridge rule that runs on a schedule].
	//
	// [Creating an Amazon EventBridge rule that runs on a schedule]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html
	ScheduleExpression *string

	// The state of the rule.
	//
	// Valid values include:
	//
	//   - DISABLED : The rule is disabled. EventBridge does not match any events
	//   against the rule.
	//
	//   - ENABLED : The rule is enabled. EventBridge matches events against the rule,
	//   except for Amazon Web Services management events delivered through CloudTrail.
	//
	//   - ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS : The rule is enabled for all
	//   events, including Amazon Web Services management events delivered through
	//   CloudTrail.
	//
	// Management events provide visibility into management operations that are
	//   performed on resources in your Amazon Web Services account. These are also known
	//   as control plane operations. For more information, see [Logging management events]in the CloudTrail User
	//   Guide, and [Filtering management events from Amazon Web Services services]in the Amazon EventBridge User Guide .
	//
	// This value is only valid for rules on the [default]event bus or [custom event buses]. It does not apply to [partner event buses].
	//
	// [Filtering management events from Amazon Web Services services]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-cloudtrail
	// [custom event buses]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-event-bus.html
	// [Logging management events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html#logging-management-events
	// [default]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is-how-it-works-concepts.html#eb-bus-concepts-buses
	// [partner event buses]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas.html
	State RuleState

	noSmithyDocumentSerde
}

// This parameter contains the criteria (either InstanceIds or a tag) used to
// specify which EC2 instances are to be sent the command.
type RunCommandParameters struct {

	// Currently, we support including only one RunCommandTarget block, which
	// specifies either an array of InstanceIds or a tag.
	//
	// This member is required.
	RunCommandTargets []RunCommandTarget

	noSmithyDocumentSerde
}

// Information about the EC2 instances that are to be sent the command, specified
// as key-value pairs. Each RunCommandTarget block can include only one key, but
// this key may specify multiple values.
type RunCommandTarget struct {

	// Can be either tag: tag-key or InstanceIds .
	//
	// This member is required.
	Key *string

	// If Key is tag: tag-key, Values is a list of tag values. If Key is InstanceIds ,
	// Values is a list of Amazon EC2 instance IDs.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Name/Value pair of a parameter to start execution of a SageMaker AI Model
// Building Pipeline.
type SageMakerPipelineParameter struct {

	// Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
	//
	// This member is required.
	Name *string

	// Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// These are custom parameters to use when the target is a SageMaker AI Model
// Building Pipeline that starts based on EventBridge events.
type SageMakerPipelineParameters struct {

	// List of Parameter names and values for SageMaker AI Model Building Pipeline
	// execution.
	PipelineParameterList []SageMakerPipelineParameter

	noSmithyDocumentSerde
}

// The secondary Region that processes events when failover is triggered or
// replication is enabled.
type Secondary struct {

	// Defines the secondary Region.
	//
	// This member is required.
	Route *string

	noSmithyDocumentSerde
}

// This structure includes the custom parameter to be used when the target is an
// SQS FIFO queue.
type SqsParameters struct {

	// The FIFO message group ID to use as the target.
	MessageGroupId *string

	noSmithyDocumentSerde
}

// A key-value pair associated with an Amazon Web Services resource. In
// EventBridge, rules and event buses support tagging.
type Tag struct {

	// A string you can use to assign a value. The combination of tag keys and values
	// can help you organize and categorize your resources.
	//
	// This member is required.
	Key *string

	// The value for the specified tag key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Targets are the resources to be invoked when a rule is triggered. For a
// complete list of services and resources that can be set as a target, see [PutTargets].
//
// If you are setting the event bus of another account as the target, and that
// account granted permission to your account through an organization instead of
// directly by the account ID, then you must specify a RoleArn with proper
// permissions in the Target structure. For more information, see [Sending and Receiving Events Between Amazon Web Services Accounts] in the Amazon
// EventBridge User Guide.
//
// [Sending and Receiving Events Between Amazon Web Services Accounts]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html
// [PutTargets]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html
type Target struct {

	// The Amazon Resource Name (ARN) of the target.
	//
	// This member is required.
	Arn *string

	// The ID of the target within the specified rule. Use this ID to reference the
	// target when updating the rule. We recommend using a memorable and unique string.
	//
	// This member is required.
	Id *string

	// Contains the GraphQL operation to be parsed and executed, if the event target
	// is an AppSync API.
	AppSyncParameters *AppSyncParameters

	// If the event target is an Batch job, this contains the job definition, job
	// name, and other parameters. For more information, see [Jobs]in the Batch User Guide.
	//
	// [Jobs]: https://docs.aws.amazon.com/batch/latest/userguide/jobs.html
	BatchParameters *BatchParameters

	// The DeadLetterConfig that defines the target queue to send dead-letter queue
	// events to.
	DeadLetterConfig *DeadLetterConfig

	// Contains the Amazon ECS task definition and task count to be used, if the event
	// target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions]
	// in the Amazon EC2 Container Service Developer Guide.
	//
	// [Task Definitions]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html
	EcsParameters *EcsParameters

	// Contains the HTTP parameters to use when the target is a API Gateway endpoint
	// or EventBridge ApiDestination.
	//
	// If you specify an API Gateway API or EventBridge ApiDestination as a target,
	// you can use this parameter to specify headers, path parameters, and query string
	// keys/values as part of your target invoking request. If you're using
	// ApiDestinations, the corresponding Connection can also have these values
	// configured. In case of any conflicting keys, values from the Connection take
	// precedence.
	HttpParameters *HttpParameters

	// Valid JSON text passed to the target. In this case, nothing from the event
	// itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format].
	//
	// [The JavaScript Object Notation (JSON) Data Interchange Format]: http://www.rfc-editor.org/rfc/rfc7159.txt
	Input *string

	// The value of the JSONPath that is used for extracting part of the matched event
	// when passing it to the target. You may use JSON dot notation or bracket
	// notation. For more information about JSON paths, see [JSONPath].
	//
	// [JSONPath]: http://goessner.net/articles/JsonPath/
	InputPath *string

	// Settings to enable you to provide custom input to a target based on certain
	// event data. You can extract one or more key-value pairs from the event and then
	// use that data to send customized input to the target.
	InputTransformer *InputTransformer

	// The custom parameter you can use to control the shard assignment, when the
	// target is a Kinesis data stream. If you do not include this parameter, the
	// default is to use the eventId as the partition key.
	KinesisParameters *KinesisParameters

	// Contains the Amazon Redshift Data API parameters to use when the target is a
	// Amazon Redshift cluster.
	//
	// If you specify a Amazon Redshift Cluster as a Target, you can use this to
	// specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based
	// on EventBridge events.
	RedshiftDataParameters *RedshiftDataParameters

	// The retry policy configuration to use for the dead-letter queue.
	RetryPolicy *RetryPolicy

	// The Amazon Resource Name (ARN) of the IAM role to be used for this target when
	// the rule is triggered. If one rule triggers multiple targets, you can use a
	// different IAM role for each target.
	RoleArn *string

	// Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
	RunCommandParameters *RunCommandParameters

	// Contains the SageMaker AI Model Building Pipeline parameters to start execution
	// of a SageMaker AI Model Building Pipeline.
	//
	// If you specify a SageMaker AI Model Building Pipeline as a target, you can use
	// this to specify parameters to start a pipeline execution based on EventBridge
	// events.
	SageMakerPipelineParameters *SageMakerPipelineParameters

	// Contains the message group ID to use when the target is a FIFO queue.
	//
	// If you specify an SQS FIFO queue as a target, the queue must have content-based
	// deduplication enabled.
	SqsParameters *SqsParameters

	noSmithyDocumentSerde
}

// Contains the API key authorization parameters to use to update the connection.
type UpdateConnectionApiKeyAuthRequestParameters struct {

	// The name of the API key to use for authorization.
	ApiKeyName *string

	// The value associated with the API key to use for authorization.
	ApiKeyValue *string

	noSmithyDocumentSerde
}

// Contains the additional parameters to use for the connection.
type UpdateConnectionAuthRequestParameters struct {

	// The authorization parameters for API key authorization.
	ApiKeyAuthParameters *UpdateConnectionApiKeyAuthRequestParameters

	// The authorization parameters for Basic authorization.
	BasicAuthParameters *UpdateConnectionBasicAuthRequestParameters

	// If you specify a private OAuth endpoint, the parameters for EventBridge to use
	// when authenticating against the endpoint.
	//
	// For more information, see [Authorization methods for connections] in the Amazon EventBridge User Guide .
	//
	// [Authorization methods for connections]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html
	ConnectivityParameters *ConnectivityResourceParameters

	// The additional parameters to use for the connection.
	InvocationHttpParameters *ConnectionHttpParameters

	// The authorization parameters for OAuth authorization.
	OAuthParameters *UpdateConnectionOAuthRequestParameters

	noSmithyDocumentSerde
}

// The Basic authorization parameters for the connection.
type UpdateConnectionBasicAuthRequestParameters struct {

	// The password associated with the user name to use for Basic authorization.
	Password *string

	// The user name to use for Basic authorization.
	Username *string

	noSmithyDocumentSerde
}

// The OAuth authorization parameters to use for the connection.
type UpdateConnectionOAuthClientRequestParameters struct {

	// The client ID to use for OAuth authorization.
	ClientID *string

	// The client secret assciated with the client ID to use for OAuth authorization.
	ClientSecret *string

	noSmithyDocumentSerde
}

// The OAuth request parameters to use for the connection.
type UpdateConnectionOAuthRequestParameters struct {

	// The URL to the authorization endpoint when OAuth is specified as the
	// authorization type.
	AuthorizationEndpoint *string

	// The client parameters to use for the connection when OAuth is specified as the
	// authorization type.
	ClientParameters *UpdateConnectionOAuthClientRequestParameters

	// The method used to connect to the HTTP endpoint.
	HttpMethod ConnectionOAuthHttpMethod

	// The additional HTTP parameters used for the OAuth authorization request.
	OAuthHttpParameters *ConnectionHttpParameters

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
