# Put the line below in your PowerShell profile (Microsoft.PowerShell_profile.ps1):
#
#   Invoke-Expression (&jump shell pwsh | Out-String)
#
# You can locate your profile by typing $PROFILE in PowerShell.
#
# The following lines are autogenerated:

function Set-Location {
    [CmdletBinding()]
    param(
        [Parameter(Position=0)]
        [System.Object]
        ${Path})

    $wrappedCmd = $ExecutionContext.InvokeCommand.GetCommand('Microsoft.PowerShell.Management\Set-Location', [System.Management.Automation.CommandTypes]::Function)
    & $wrappedCmd @PSBoundParameters
    jump chdir
}

function Push-Location {
    [CmdletBinding()]
    param(
        [Parameter(Position=0)]
        [System.Object]
        ${Path})

    $wrappedCmd = $ExecutionContext.InvokeCommand.GetCommand('Microsoft.PowerShell.Management\Push-Location', [System.Management.Automation.CommandTypes]::Function)
    & $wrappedCmd @PSBoundParameters
    jump chdir
}

function __jump_base_dir
{
    if ($env:JUMP_BASED_PATH) { return $env:JUMP_BASED_PATH }
    $result = git rev-parse --show-toplevel 2>$null
    if ($result) { $result.Trim() }
}

{{if eq .Bind "cd"}}
Remove-Item Alias:cd -Force -ErrorAction SilentlyContinue
{{end}}

function {{.Bind}}
{
    switch ($Args[0]) {
        '..' {
            Set-Location ..
        }
        '-' {
            Set-Location -
        }
        '.' {
            $BaseDir = __jump_base_dir
            if ($BaseDir) {
                $RemainingArgs = if ($Args.Length -gt 1) { $Args[1..($Args.Length - 1)] } else { @() }
                $Path = jump cd $BaseDir @RemainingArgs
                if (Test-Path $Path) { Set-Location $Path }
            }
        }
        default {
            $Path = jump cd $Args
            if (Test-Path $Path) { Set-Location $Path }
        }
    }
}

if (Get-Command Register-ArgumentCompleter -ErrorAction Ignore) {
    Register-ArgumentCompleter -CommandName '{{.Bind}}' -ScriptBlock {
        param ($commandName, $wordToComplete, $commandAst, $fakeBoundParameter)

        $word = if ($wordToComplete -match '^j\s+(.*)$') { $Matches[1] } else { $wordToComplete }
        $dirPrefix = if ($word -match '^(.+[/\\])[^/\\]*$') { $Matches[1] } else { "" }
        $localDirs = @(Get-ChildItem -Directory -Path "$word*" -ErrorAction SilentlyContinue)

        if ($localDirs) {
            $localDirs | ForEach-Object {
                [System.Management.Automation.CompletionResult]::new("$dirPrefix$($_.Name)/", "$dirPrefix$($_.Name)/", 'ParameterValue', $_.Name)
            }
        } elseif ($word -notmatch '[/\\]') {
            $hint = jump hint $word 2>$null | Select-Object -First 1
            if ($hint) {
                [System.Management.Automation.CompletionResult]::new($hint, $hint, 'ParameterValue', $hint)
            }
        }
    }
}
