{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='apiServiceSpec', url='', help='"APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification."'),
  '#service':: d.obj(help='"ServiceReference holds a reference to Service.legacy.k8s.io"'),
  service: {
    '#withName':: d.fn(help='"Name is the name of the service"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { service+: { name: name } },
    '#withNamespace':: d.fn(help='"Namespace is the namespace of the service"', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { service+: { namespace: namespace } },
    '#withPort':: d.fn(help='"If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive)."', args=[d.arg(name='port', type=d.T.integer)]),
    withPort(port): { service+: { port: port } },
  },
  '#withCaBundle':: d.fn(help="\"CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.\"", args=[d.arg(name='caBundle', type=d.T.string)]),
  withCaBundle(caBundle): { caBundle: caBundle },
  '#withGroup':: d.fn(help='"Group is the API group name this server hosts"', args=[d.arg(name='group', type=d.T.string)]),
  withGroup(group): { group: group },
  '#withGroupPriorityMinimum':: d.fn(help="\"GroupPriorityMinimum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMinimum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s\"", args=[d.arg(name='groupPriorityMinimum', type=d.T.integer)]),
  withGroupPriorityMinimum(groupPriorityMinimum): { groupPriorityMinimum: groupPriorityMinimum },
  '#withInsecureSkipTLSVerify':: d.fn(help='"InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead."', args=[d.arg(name='insecureSkipTLSVerify', type=d.T.boolean)]),
  withInsecureSkipTLSVerify(insecureSkipTLSVerify): { insecureSkipTLSVerify: insecureSkipTLSVerify },
  '#withVersion':: d.fn(help='"Version is the API version this server hosts.  For example, \\"v1\\', args=[d.arg(name='version', type=d.T.string)]),
  withVersion(version): { version: version },
  '#withVersionPriority':: d.fn(help="\"VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is \\\"kube-like\\\", it will sort above non \\\"kube-like\\\" version strings, which are ordered lexicographically. \\\"Kube-like\\\" versions start with a \\\"v\\\", then are followed by a number (the major version), then optionally the string \\\"alpha\\\" or \\\"beta\\\" and another number (the minor version). These are sorted first by GA \u003e beta \u003e alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.\"", args=[d.arg(name='versionPriority', type=d.T.integer)]),
  withVersionPriority(versionPriority): { versionPriority: versionPriority },
  '#mixin': 'ignore',
  mixin: self,
}
