// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

//go:build !go1.27

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "15.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 731 elements
	// Entry 0 - 1F
	0x00000001000d5930, 0x00010002f8000000, 0x0003f801080d5930, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80190286000, 0x002c68001829f000,
	0x002c8801b82a0800, 0x002e8000d82bc000, 0x002f7800302c9800, 0x00300008702cc800,
	0x00387801e0353800, 0x003a680328371800, 0x003e0001d83a4000, 0x003fe801883c1800,
	0x00418000783da000, 0x00420000e03e1800, 0x0042f000083ef800, 0x00430000583f0000,
	0x00438000f83f5800, 0x0044800010405000, 0x0044c00760406000, 0x004c28004047c000,
	0x004c780010480000, 0x004c9800b0481000, 0x004d50003848c000, 0x004d90000848f800,
	// Entry 20 - 3F
	0x004db00020490000, 0x004de00048492000, 0x004e380010496800, 0x004e580020497800,
	0x004eb80008499800, 0x004ee0001049a000, 0x004ef8002849b000, 0x004f30000849d800,
	0x004f3800c049e020, 0x00500800184aa020, 0x00502800304ab820, 0x00507800104ae820,
	0x00509800b04af820, 0x00515000384ba820, 0x00519000104be020, 0x0051a800104bf020,
	0x0051c000104c0020, 0x0051e000084c1020, 0x0051f000284c1820, 0x00523800104c4020,
	0x00525800184c5020, 0x00528800084c6820, 0x0052c800204c7020, 0x0052f000084c9020,
	0x00533000884c9820, 0x00540800184d2020, 0x00542800484d3820, 0x00547800184d8020,
	0x00549800b04d9820, 0x00555000384e4820, 0x00559000104e8020, 0x0055a800284e9020,
	// Entry 40 - 5F
	0x0055e000504eb820, 0x00563800184f0820, 0x00565800184f2020, 0x00568000084f3820,
	0x00570000204f4020, 0x00573000604f6020, 0x0057c800384fc020, 0x00580800184ff820,
	0x0058280040501020, 0x0058780010505020, 0x00589800b0506020, 0x0059500038511020,
	0x0059900010514820, 0x0059a80028515820, 0x0059e00048518020, 0x005a38001051c820,
	0x005a58001851d820, 0x005aa8001851f020, 0x005ae00010520820, 0x005af80028521820,
	0x005b300090524020, 0x005c10001052d020, 0x005c28003052e020, 0x005c700018531020,
	0x005c900020532820, 0x005cc80010534820, 0x005ce00008535820, 0x005cf00010536020,
	0x005d180010537020, 0x005d400018538020, 0x005d700060539820, 0x005df0002853f820,
	// Entry 60 - 7F
	0x005e300018542020, 0x005e500020543820, 0x005e800008545820, 0x005eb80008546020,
	0x005f3000a8546820, 0x0060000068551020, 0x0060700018557820, 0x00609000b8559020,
	0x0061500080564820, 0x0061e0004856c820, 0x0062300018571020, 0x0062500020572820,
	0x0062a80010574820, 0x0062c00018575820, 0x0062e80008577020, 0x0063000020577820,
	0x0063300050579820, 0x0063b800b057e820, 0x0064700018589820, 0x00649000b858b020,
	0x0065500050596820, 0x0065a8002859b820, 0x0065e0004859e020, 0x00663000185a2820,
	0x00665000205a4020, 0x0066a800105a6020, 0x0066e800105a7020, 0x00670000205a8020,
	0x00673000505aa020, 0x00678800185af020, 0x00680000685b0820, 0x00687000185b7020,
	// Entry 80 - 9F
	0x00689001985b8820, 0x006a3000185d2020, 0x006a5000305d3820, 0x006aa000805d6820,
	0x006b3000d05de820, 0x006c0800185eb820, 0x006c2800905ed020, 0x006cd000c05f6020,
	0x006d980048602020, 0x006de80008606820, 0x006e000038607020, 0x006e50000860a820,
	0x006e78003060b020, 0x006eb0000860e020, 0x006ec0004060e820, 0x006f300050612820,
	0x006f900018617820, 0x00700801d0619020, 0x0071f800e8636020, 0x0074080010644820,
	0x0074200008645820, 0x0074300028646020, 0x00746000c0648820, 0x0075280008654820,
	0x00753800b8655020, 0x0076000028660820, 0x0076300008663020, 0x0076400038663820,
	0x0076800050667020, 0x0076e0002066c020, 0x007800024066e020, 0x007a480120692020,
	// Entry A0 - BF
	0x007b8801386a4020, 0x007cc801206b7820, 0x007df000786c9820, 0x007e7000686d1020,
	0x00800006306d7820, 0x008638000873a820, 0x008668000873b020, 0x0086800bc873b820,
	0x00925000207f8020, 0x00928000387fa020, 0x0092c000087fd820, 0x0092d000207fe020,
	0x0093000148800020, 0x0094500020814820, 0x0094800108816820, 0x0095900020827020,
	0x0095c00038829020, 0x009600000882c820, 0x009610002082d020, 0x009640007882f020,
	0x0096c001c8836820, 0x0098900020853020, 0x0098c00218855020, 0x009ae80100876820,
	0x009c0000d0886820, 0x009d0002b0893820, 0x009fc000308be820, 0x00a00014e88c1820,
	0x00b50000e0a10020, 0x00b5e001e8a1e040, 0x00b80000b0a3c840, 0x00b8f800c0a47840,
	// Entry C0 - DF
	0x00ba0000a0a53840, 0x00bb000068a5d840, 0x00bb700018a64040, 0x00bb900010a65840,
	0x00bc0002f0a66840, 0x00bf000050a95840, 0x00bf800050a9a840, 0x00c00000d0a9f840,
	0x00c10002c8aac840, 0x00c4000158ad9040, 0x00c5800230aee840, 0x00c80000f8b11840,
	0x00c9000060b21040, 0x00c9800060b27040, 0x00ca000008b2d040, 0x00ca200150b2d840,
	0x00cb800028b42840, 0x00cc000160b45040, 0x00cd8000d0b5b040, 0x00ce800058b68040,
	0x00cef001f0b6d840, 0x00d0f00208b8c840, 0x00d30000e8bad040, 0x00d3f80058bbb840,
	0x00d4800050bc1040, 0x00d5000070bc6040, 0x00d58000f8bcd040, 0x00d8000268bdc840,
	0x00da800178c03040, 0x00dc0003a0c1a840, 0x00dfe001e0c54840, 0x00e1d80078c72840,
	// Entry E0 - FF
	0x00e26801e0c7a040, 0x00e4800158c98040, 0x00e5e80058cad840, 0x00e6800158cb3040,
	0x00e80010b0cc8840, 0x00f8c00030dd3840, 0x00f9000130dd6840, 0x00fa400030de9840,
	0x00fa800040dec840, 0x00fac80008df0840, 0x00fad80008df1040, 0x00fae80008df1840,
	0x00faf800f8df2040, 0x00fc0001a8e01840, 0x00fdb00078e1c040, 0x00fe300070e23840,
	0x00feb00030e2a840, 0x00fee80098e2d840, 0x00ff900018e37040, 0x00ffb00048e38840,
	0x0100000328e3d040, 0x0103300060e6f840, 0x0103a000d8e75840, 0x0104800068e83040,
	0x0105000108e89840, 0x0106800108e9a040, 0x01080000e8eaa840, 0x0108e80378eb9060,
	0x010c8014b8ef0860, 0x012200005903c060, 0x0123003579041860, 0x0158780329399080,
	// Entry 100 - 11F
	0x015bb001013cb880, 0x015cb80ae93db880, 0x0167c8016948a080, 0x01693800094a0880,
	0x01696800094a1080, 0x01698001c14a1880, 0x016b7800114bd880, 0x016bf800c14be880,
	0x016d0000394ca880, 0x016d4000394ce080, 0x016d8000394d1880, 0x016dc000394d5080,
	0x016e0000394d8880, 0x016e4000394dc080, 0x016e8000394df880, 0x016ec000394e3080,
	0x016f0003f14e6880, 0x01740000d1525880, 0x0174d802c9532880, 0x01780006b155f080,
	0x017f8000615ca080, 0x01800002015d0080, 0x01820802b15f0080, 0x0184c8033961b080,
	0x018828015964e880, 0x01898802f1664080, 0x018c8002a1693080, 0x018f8001796bd080,
	0x0191000f016d4880, 0x01a000ce00000370, 0x026e0002017c4880, 0x027002900006c1f0,
	// Entry 120 - 13F
	0x0500001a097e4880, 0x051a080a619850a0, 0x05248001b9a2b0a0, 0x0526800ae1a468a0,
	0x05320005c1af48a0, 0x0538000659b508a0, 0x053e800011bb60a0, 0x053e980009bb70a0,
	0x053ea80029bb78a0, 0x053f9001d9bba0a0, 0x0541800051bd78a0, 0x05420001c1bdc8a0,
	0x0544000231bf88a0, 0x0546700061c1b8a0, 0x05470003a1c218a0, 0x054af800f1c5b8a0,
	0x054c000271c6a8a0, 0x054e780059c918a0, 0x054ef00109c970a0, 0x05500001b9ca78a0,
	0x0552000071cc30a0, 0x0552800051cca0a0, 0x0552e00339ccf0a0, 0x0556d800e1d028a0,
	0x0558080031d108a0, 0x0558480031d138a0, 0x0558880031d168a0, 0x0559000039d198a0,
	0x0559400039d1d0a0, 0x05598001e1d208a0, 0x055b8003f1d3e8a0, 0x055f800051d7d8a0,
	// Entry 140 - 15F
	0x0560015d20073a30, 0x06bd8000b9d828a0, 0x06be580189d8e0a0, 0x06c0001c00083c10,
	0x06dc0004000a9b90, 0x06e000200007c1f0, 0x070000c8000b79b0, 0x07c8000b71da68a0,
	0x07d3800351e5d8a0, 0x07d8000039e928a0, 0x07d8980029e960a0, 0x07d8e800d1e988a0,
	0x07d9c00029ea58a0, 0x07d9f00009ea80a0, 0x07da000011ea88a0, 0x07da180011ea98a0,
	0x07da3002a9eaa8a0, 0x07dcd80141ed50c0, 0x07de980de9ee90c0, 0x07ec9001b1fc78c0,
	0x07ee780009fe28c0, 0x07ef800151fe30c0, 0x07f1000199ff80c0, 0x07f2a0009a0118c0,
	0x07f340002201b0c0, 0x07f380002a01d0c0, 0x07f3b0043a01f8c0, 0x07f7f8000a0630c0,
	0x07f80805f20638c0, 0x07fe1000320c28c0, 0x07fe5000320c58c0, 0x07fe9000320c88c0,
	// Entry 160 - 17F
	0x07fed0001a0cb8c0, 0x07ff00003a0cd0c0, 0x07ff40003a0d08c0, 0x07ffc8002a0d40c0,
	0x08000000620d68c0, 0x08006800d20dc8c0, 0x080140009a0e98c0, 0x0801e000120f30c0,
	0x0801f8007a0f40c0, 0x08028000720fb8c0, 0x08040003da1028c0, 0x080800001a1400c0,
	0x080838016a1418c0, 0x0809b802c21580c0, 0x080c80006a1840c0, 0x080d00000a18a8c0,
	0x080e80017218b0c0, 0x08140000ea1a20c0, 0x081500018a1b08c0, 0x08170000e21c90c0,
	0x08180001221d70c0, 0x08196800f21e90c0, 0x081a80015a1f80c0, 0x081c0000f220d8c0,
	0x081cf8012a21c8c0, 0x081e40007222f0c0, 0x08200004f22360c0, 0x08250000522850c0,
	0x082580012228a0c0, 0x0826c0012229c0c0, 0x08280001422ae0c0, 0x08298001a22c20c0,
	// Entry 180 - 19F
	0x082b7800622dc0c0, 0x082be0007a2e20c0, 0x082c60003a2e98c0, 0x082ca000122ed0c0,
	0x082cb8005a2ee0c0, 0x082d18007a2f38c0, 0x082d98003a2fb0c0, 0x082dd800122fe8c0,
	0x08300001222ff8c0, 0x083120089a3118e0, 0x083a0000b239b0e0, 0x083b0000423a60e0,
	0x083c0000323aa0e0, 0x083c3801523ad0e0, 0x083d90004a3c20e0, 0x08400000323c68e0,
	0x084040000a3c98e0, 0x08405001623ca0e0, 0x0841b800123e00e0, 0x0841e0000a3e10e0,
	0x0841f800ba3e18e0, 0x0842b802423ed0e0, 0x084538004a4110e0, 0x084700009a4158e0,
	0x0847a0001241f0e0, 0x0847d8010a4200e0, 0x0848f800da4308e0, 0x0849f8000a43e0e0,
	0x084c0001c243e8e0, 0x084de000a245a8e0, 0x084e9001924648e0, 0x085028001247d8e0,
	// Entry 1A0 - 1BF
	0x085060004247e8e0, 0x0850a8001a4828e0, 0x0850c800ea4840e0, 0x0851c0001a4928e0,
	0x0851f800524940e0, 0x085280004a4990e0, 0x085300020249d8e0, 0x085600013a4bd8e0,
	0x08575800624d10e0, 0x08580001b24d70e0, 0x0859c800ea4f20e0, 0x085ac000da5008e0,
	0x085bc000d250e0e0, 0x085cc8002251b0e0, 0x085d48003a51d0e0, 0x086000024a5208e0,
	0x086400019a5450e0, 0x086600019a55e8e0, 0x0867d001725780e0, 0x086980005258f0e0,
	0x08730000fa5940e0, 0x08740001525a38e0, 0x087558001a5b88e0, 0x08758000125ba0e0,
	0x0877e8015a5bb0e0, 0x08798001525d08e0, 0x087b8000d25e58e0, 0x087d8000e25f28e0,
	0x087f0000ba6008e0, 0x088000027260c0e0, 0x08829001226330e0, 0x0883f802226450e0,
	// Entry 1C0 - 1DF
	0x088668000a6670e0, 0x08868000ca6678e0, 0x08878000526740e0, 0x08880001aa6790e0,
	0x0889b000926938e0, 0x088a80013a69c8e0, 0x088c0003026b00e0, 0x088f0800a26e00e0,
	0x08900000926ea0e0, 0x089098017a6f30e0, 0x089400003a70a8e0, 0x089440000a70e0e0,
	0x089450002270e8e0, 0x089478007a7108e0, 0x0894f8005a7180e0, 0x08958001da71d8e0,
	0x089780005273b0e0, 0x08980000227400e0, 0x08982800427420e0, 0x08987800127460e0,
	0x08989800b27470e0, 0x089950003a7520e0, 0x08999000127558e0, 0x0899a8002a7568e0,
	0x0899d800527590e0, 0x089a38001275e0e0, 0x089a58001a75f0e0, 0x089a80000a7608e0,
	0x089ab8000a7610e0, 0x089ae8003a7618e0, 0x089b30003a7650e0, 0x089b80002a7688e0,
	// Entry 1E0 - 1FF
	0x08a00002e276b0e0, 0x08a2e8002a7990e0, 0x08a400024279b8e0, 0x08a68000527bf8e0,
	0x08ac0001b27c48e0, 0x08adc001327df8e0, 0x08b000022a7f28e0, 0x08b28000528150e0,
	0x08b300006a81a0e0, 0x08b40001d28208e0, 0x08b600005283d8e0, 0x08b80000da8428e0,
	0x08b8e8007a8500e0, 0x08b98000ba8578e0, 0x08c00001e28630e0, 0x08c500029a8810e0,
	0x08c7f800428aa8e0, 0x08c848000a8ae8e0, 0x08c86000428af0e0, 0x08c8a800128b30e0,
	0x08c8c000f28b40e0, 0x08c9b800128c30e0, 0x08c9d800628c40e0, 0x08ca8000528ca0e0,
	0x08cd00002a8cf0e0, 0x08cd28001a8d1900, 0x08cd5001728d3100, 0x08ced0005a8ea100,
	0x08d00002428ef900, 0x08d280029a913900, 0x08d580024a93d100, 0x08d8000052961900,
	// Entry 200 - 21F
	0x08e000004a966900, 0x08e050016a96b100, 0x08e1c00072981900, 0x08e28000ea988900,
	0x08e3800102997100, 0x08e49000b29a7100, 0x08e54800729b2100, 0x08e800003a9b9100,
	0x08e84000129bc900, 0x08e85801629bd900, 0x08e9d0000a9d3900, 0x08e9e000129d4100,
	0x08e9f8004a9d5100, 0x08ea8000529d9900, 0x08eb0000329de900, 0x08eb3800129e1900,
	0x08eb50012a9e2900, 0x08ec8000129f5100, 0x08ec9800329f6100, 0x08ed0000529f9100,
	0x08f70000ca9fe100, 0x08f800008aa0a900, 0x08f890014aa13100, 0x08f9f000e2a27900,
	0x08fd80000aa35900, 0x08fe000192a36100, 0x08fff81cdaa4f100, 0x092000037ac1c900,
	0x092380002ac54100, 0x0924000622c56900, 0x097c80031acb8900, 0x0980000daacea100,
	// Entry 220 - 23F
	0x098da8150adc4920, 0x0a2000123af15120, 0x0b400011cb038920, 0x0b520000fb155120,
	0x0b53000053164920, 0x0b5370028b169920, 0x0b56000053192120, 0x0b568000f3197120,
	0x0b578000331a6120, 0x0b580002331a9120, 0x0b5a8000531cc120, 0x0b5ad8003b1d1120,
	0x0b5b1800ab1d4920, 0x0b5be8009b1df120, 0x0b720002db1e8920, 0x0b7800025b216120,
	0x0b7a7801cb23b920, 0x0b7c78008b258120, 0x0b7f00002b260920, 0x0b7f800013263120,
	0x0b8000bfc00cca50, 0x0c40000bc3264120, 0x0c4bc01af3320140, 0x0c680000480be3b0,
	0x0d7f8000234cf140, 0x0d7fa8003b4d1140, 0x0d7fe800134d4940, 0x0d8000091b4d5940,
	0x0d8990000b567140, 0x0d8a80001b567940, 0x0d8aa8000b569140, 0x0d8b200023569940,
	// Entry 240 - 25F
	0x0d8b800c6356b940, 0x0de000035b631940, 0x0de380006b667140, 0x0de400004b66d940,
	0x0de4800053672140, 0x0de4e00043677140, 0x0e7800017367b140, 0x0e798000bb692140,
	0x0e7a8003a369d940, 0x0e800007b36d7940, 0x0e8800013b752940, 0x0e894804fb766140,
	0x0e8e40011b7b5960, 0x0e900002337c7160, 0x0e960000a37ea160, 0x0e970000a37f4160,
	0x0e980002bb7fe160, 0x0e9b0000cb829960, 0x0ea00002ab836160, 0x0ea2b0023b860960,
	0x0ea4f00013884160, 0x0ea510000b885160, 0x0ea5280013885960, 0x0ea5480023886960,
	0x0ea5700063888960, 0x0ea5d8000b88e960, 0x0ea5e8003b88f160, 0x0ea628020b892960,
	0x0ea83800238b3160, 0x0ea86800438b5160, 0x0ea8b0003b8b9160, 0x0ea8f000e38bc960,
	// Entry 260 - 27F
	0x0ea9d800238ca960, 0x0eaa00002b8cc960, 0x0eaa30000b8cf160, 0x0eaa50003b8cf960,
	0x0eaa900aa38d3160, 0x0eb540092397d160, 0x0ebe7012eba0f160, 0x0ed158030bb3d980,
	0x0ed4d8002bb6e180, 0x0ed508007bb70980, 0x0ef80000fbb78180, 0x0ef9280033b87980,
	0x0f0000003bb8a980, 0x0f0040008bb8e180, 0x0f00d8003bb96980, 0x0f01180013b9a180,
	0x0f0130002bb9b180, 0x0f018001f3b9d980, 0x0f0478000bbbc980, 0x0f0800016bbbd180,
	0x0f09800073bd3980, 0x0f0a000053bda980, 0x0f0a700013bdf980, 0x0f148000fbbe0980,
	0x0f160001d3bf0180, 0x0f17f8000bc0d180, 0x0f26800153c0d980, 0x0f3f00003bc22980,
	0x0f3f400023c26180, 0x0f3f680013c28180, 0x0f3f80007bc29180, 0x0f4000062bc30980,
	// Entry 280 - 29F
	0x0f46380083c93180, 0x0f48000263c9b180, 0x0f4a800053cc1180, 0x0f4af00013cc6180,
	0x0f63880223cc7180, 0x0f680801ebce9180, 0x0f70000023d07980, 0x0f702800dbd09980,
	0x0f71080013d17180, 0x0f7120000bd18180, 0x0f7138000bd18980, 0x0f71480053d19180,
	0x0f71a00023d1e180, 0x0f71c8000bd20180, 0x0f71d8000bd20980, 0x0f7210000bd21180,
	0x0f7238000bd21980, 0x0f7248000bd22180, 0x0f7258000bd22980, 0x0f7268001bd23180,
	0x0f72880013d24980, 0x0f72a0000bd25980, 0x0f72b8000bd26180, 0x0f72c8000bd26980,
	0x0f72d8000bd27180, 0x0f72e8000bd27980, 0x0f72f8000bd28180, 0x0f73080013d28980,
	0x0f7320000bd29980, 0x0f73380023d2a180, 0x0f7360003bd2c180, 0x0f73a00023d2f980,
	// Entry 2A0 - 2BF
	0x0f73c80023d31980, 0x0f73f0000bd33980, 0x0f74000053d34180, 0x0f7458008bd39180,
	0x0f7508001bd41980, 0x0f7528002bd43180, 0x0f7558008bd45980, 0x0f77800013d4e180,
	0x0f80000163d4f180, 0x0f81800323d65180, 0x0f8500007bd97180, 0x0f8588007bd9e980,
	0x0f8608007bda6180, 0x0f8688012bdad980, 0x0f88000573dc0180, 0x0f8f3000ebe17180,
	0x0f90800163e25980, 0x0f9200004be3b980, 0x0f92800013e40180, 0x0f93000033e41180,
	0x0f98001ec3e44180, 0x0fb6e0008c030180, 0x0fb780006c038980, 0x0fb80003bc03f180,
	0x0fbbd800a407a980, 0x0fbc78025c0849a0, 0x0fbf0000640aa1a0, 0x0fbf80000c0b01a0,
	0x0fc00000640b09a0, 0x0fc08001c40b69a0, 0x0fc28000540d29a0, 0x0fc30001440d79a0,
	// Entry 2C0 - 2DF
	0x0fc48000f40eb9a0, 0x0fc58000140fa9a0, 0x0fc8000aa40fb9a0, 0x0fd30000741a59a0,
	0x0fd380006c1ac9a0, 0x0fd400004c1b31a0, 0x0fd48001741b79a0, 0x0fd5f8003c1ce9a0,
	0x0fd67000741d21a0, 0x0fd700004c1d91a0, 0x0fd780004c1dd9a0, 0x0fd800049c1e21a0,
	0x0fdca001bc22b9a0, 0x0fdf8000542471a0, 0x100005370000db70, 0x15380081d001b370,
	0x15ba0006f0028b70, 0x15c100b410036370, 0x167580e988043b70, 0x17c00010f424c1a0,
	0x1800009a58051370, 0x189a80830005eb70, 0x700008000c35b1a0, 0x700100030435b9a0,
	0x700800078438b9a0, 0x780007fff0093ad0, 0x800007fff009ead0,
} // Size: 5872 bytes

var index = []uint16{ // 34824 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x969a, 0x96b3, 0x96cc, 0x96e5,
	0x96fd, 0x9716, 0x972e, 0x9746, 0x975e, 0x9776, 0x978f, 0x97a8,
	0x97c2, 0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9856, 0x9870,
	0x9889, 0x98a1, 0x98ba, 0x98d3, 0x98eb, 0x9904, 0x991d, 0x9937,
	0x994f, 0x9968, 0x9981, 0x999b, 0x99b4, 0x99cc, 0x99e6, 0x9a00,
	0x9a19, 0x9a31, 0x9a4a, 0x9a6a, 0x9a8e, 0x9aa0, 0x9aaf, 0x9ad2,
	// Entry 540 - 57F
	0x9af4, 0x9b06, 0x9b1b, 0x9b2e, 0x9b46, 0x9b5f, 0x9b78, 0x9b8c,
	0x9b9f, 0x9bb2, 0x9bc6, 0x9bd9, 0x9bec, 0x9c00, 0x9c1b, 0x9c32,
	0x9c4b, 0x9c67, 0x9c7a, 0x9c94, 0x9ca7, 0x9cbd, 0x9cd1, 0x9cec,
	0x9cff, 0x9d12, 0x9d2e, 0x9d4a, 0x9d5b, 0x9d6d, 0x9d7f, 0x9d92,
	0x9dab, 0x9dbd, 0x9dd5, 0x9ded, 0x9e06, 0x9e18, 0x9e2a, 0x9e3c,
	0x9e4e, 0x9e61, 0x9e73, 0x9e93, 0x9ea6, 0x9ec2, 0x9ed4, 0x9eec,
	0x9efd, 0x9f15, 0x9f2a, 0x9f3e, 0x9f5a, 0x9f6f, 0x9f84, 0x9fa2,
	0x9fbb, 0x9fcd, 0x9fde, 0x9ff1, 0xa004, 0xa014, 0xa025, 0xa038,
	// Entry 580 - 5BF
	0xa049, 0xa05a, 0xa06b, 0xa082, 0xa093, 0xa0a6, 0xa0bd, 0xa0ce,
	0xa0e5, 0xa0f6, 0xa10a, 0xa11c, 0xa132, 0xa142, 0xa15b, 0xa16e,
	0xa17f, 0xa191, 0xa1a3, 0xa1b4, 0xa1c7, 0xa1e9, 0xa208, 0xa22a,
	0xa243, 0xa25f, 0xa271, 0xa282, 0xa298, 0xa2a9, 0xa2bb, 0xa2d3,
	0xa2e9, 0xa301, 0xa30b, 0xa326, 0xa348, 0xa354, 0xa360, 0xa375,
	0xa38d, 0xa39e, 0xa3c6, 0xa3e1, 0xa3ff, 0xa41c, 0xa431, 0xa446,
	0xa477, 0xa48d, 0xa49f, 0xa4b1, 0xa4c3, 0xa4d3, 0xa4e5, 0xa4fc,
	0xa51e, 0xa532, 0xa54c, 0xa55f, 0xa582, 0xa5a5, 0xa5c7, 0xa5ea,
	// Entry 5C0 - 5FF
	0xa60c, 0xa61e, 0xa62f, 0xa648, 0xa659, 0xa66b, 0xa67d, 0xa68e,
	0xa6a0, 0xa6b1, 0xa6c3, 0xa6d4, 0xa6e6, 0xa6f8, 0xa70b, 0xa71c,
	0xa72d, 0xa73e, 0xa74f, 0xa760, 0xa773, 0xa79a, 0xa7c3, 0xa7ea,
	0xa815, 0xa842, 0xa850, 0xa861, 0xa872, 0xa883, 0xa894, 0xa8a6,
	0xa8b8, 0xa8c9, 0xa8da, 0xa8f4, 0xa905, 0xa914, 0xa923, 0xa932,
	0xa93e, 0xa94a, 0xa956, 0xa963, 0xa96f, 0xa982, 0xa994, 0xa9a6,
	0xa9bb, 0xa9d0, 0xa9e7, 0xa9f6, 0xaa15, 0xaa3d, 0xaa58, 0xaa6d,
	0xaa87, 0xaa9e, 0xaab5, 0xaacb, 0xaae1, 0xaaf9, 0xab10, 0xab27,
	// Entry 600 - 63F
	0xab3d, 0xab55, 0xab6d, 0xab84, 0xab97, 0xabaf, 0xabc9, 0xabe1,
	0xabfa, 0xac13, 0xac31, 0xac49, 0xac71, 0xac99, 0xacb1, 0xacce,
	0xacea, 0xad0a, 0xad26, 0xad38, 0xad4c, 0xad5e, 0xad79, 0xadaa,
	0xadbb, 0xadce, 0xade1, 0xae03, 0xae31, 0xae43, 0xae55, 0xae7c,
	0xae8f, 0xaea4, 0xaeb6, 0xaed1, 0xaef1, 0xaf1f, 0xaf32, 0xaf46,
	0xaf57, 0xaf88, 0xafae, 0xafc0, 0xafde, 0xaff9, 0xb019, 0xb03d,
	0xb06b, 0xb090, 0xb0a1, 0xb0c7, 0xb0f6, 0xb11e, 0xb15b, 0xb180,
	0xb1a7, 0xb1ce, 0xb1f5, 0xb20e, 0xb234, 0xb254, 0xb265, 0xb28c,
	// Entry 640 - 67F
	0xb29f, 0xb2bf, 0xb2e6, 0xb2f9, 0xb310, 0xb32b, 0xb34b, 0xb35b,
	0xb382, 0xb393, 0xb3ae, 0xb3c1, 0xb3e6, 0xb3f8, 0xb41f, 0xb43d,
	0xb45d, 0xb484, 0xb4ab, 0xb4cc, 0xb4e5, 0xb4f8, 0xb514, 0xb53c,
	0xb559, 0xb57b, 0xb59b, 0xb5b1, 0xb5d8, 0xb5f6, 0xb611, 0xb629,
	0xb639, 0xb648, 0xb658, 0xb670, 0xb695, 0xb6a5, 0xb6bc, 0xb6d7,
	0xb6f5, 0xb715, 0xb724, 0xb74b, 0xb763, 0xb78c, 0xb79c, 0xb7ac,
	0xb7e5, 0xb81e, 0xb841, 0xb85b, 0xb871, 0xb88d, 0xb8a3, 0xb8b5,
	0xb8d0, 0xb8ee, 0xb918, 0xb93e, 0xb962, 0xb977, 0xb98e, 0xb99e,
	// Entry 680 - 6BF
	0xb9ae, 0xb9c3, 0xb9d9, 0xb9ef, 0xba0b, 0xba28, 0xba53, 0xba68,
	0xba89, 0xbaaa, 0xbaca, 0xbae9, 0xbb08, 0xbb29, 0xbb49, 0xbb69,
	0xbb88, 0xbba9, 0xbbca, 0xbbea, 0xbc0c, 0xbc2c, 0xbc4e, 0xbc6a,
	0xbc8d, 0xbcae, 0xbcc5, 0xbce1, 0xbcfb, 0xbd13, 0xbd29, 0xbd40,
	0xbd58, 0xbd71, 0xbd95, 0xbdb8, 0xbdca, 0xbde0, 0xbdf9, 0xbe13,
	0xbe2b, 0xbe3e, 0xbe5d, 0xbe6f, 0xbe82, 0xbe9e, 0xbeb2, 0xbed3,
	0xbee3, 0xbef4, 0xbf06, 0xbf18, 0xbf2a, 0xbf45, 0xbf57, 0xbf6c,
	0xbf7e, 0xbf92, 0xbfa3, 0xbfb4, 0xbfc9, 0xbfe4, 0xbff3, 0xc003,
	// Entry 6C0 - 6FF
	0xc01c, 0xc02f, 0xc041, 0xc053, 0xc065, 0xc076, 0xc091, 0xc0ad,
	0xc0ca, 0xc0dd, 0xc0f0, 0xc104, 0xc117, 0xc12a, 0xc13e, 0xc150,
	0xc162, 0xc180, 0xc19b, 0xc1ad, 0xc1bf, 0xc1d8, 0xc1ea, 0xc1fc,
	0xc208, 0xc21b, 0xc22b, 0xc23a, 0xc258, 0xc276, 0xc28d, 0xc2a4,
	0xc2bd, 0xc2d6, 0xc2e2, 0xc2f0, 0xc30b, 0xc326, 0xc33e, 0xc372,
	0xc3a7, 0xc3df, 0xc42a, 0xc45d, 0xc48a, 0xc4a8, 0xc4cd, 0xc505,
	0xc543, 0xc570, 0xc58d, 0xc5b4, 0xc5d9, 0xc613, 0xc643, 0xc668,
	0xc6a0, 0xc6c2, 0xc6eb, 0xc725, 0xc746, 0xc767, 0xc78d, 0xc7ae,
	// Entry 700 - 73F
	0xc7cd, 0xc7e7, 0xc817, 0xc839, 0xc86a, 0xc89e, 0xc8d9, 0xc915,
	0xc950, 0xc984, 0xc9c1, 0xca00, 0xca42, 0xca86, 0xcac9, 0xcb05,
	0xcb43, 0xcb86, 0xcbcb, 0xcc08, 0xcc46, 0xcc68, 0xcc8d, 0xcc9e,
	0xccb5, 0xccc8, 0xccd9, 0xccea, 0xcd01, 0xcd14, 0xcd27, 0xcd3a,
	0xcd4d, 0xcd60, 0xcd74, 0xcd86, 0xcd99, 0xcdac, 0xcdc3, 0xcdd6,
	0xcdec, 0xce02, 0xce18, 0xce29, 0xce3f, 0xce55, 0xce6c, 0xce7e,
	0xce90, 0xcea2, 0xceb6, 0xcec7, 0xcedb, 0xceef, 0xcf03, 0xcf13,
	0xcf23, 0xcf35, 0xcf49, 0xcf5c, 0xcf6f, 0xcf7d, 0xcf8d, 0xcf9b,
	// Entry 740 - 77F
	0xcfab, 0xcfb9, 0xcfc9, 0xcfd7, 0xcfe7, 0xcff5, 0xd005, 0xd011,
	0xd022, 0xd030, 0xd03d, 0xd04a, 0xd059, 0xd067, 0xd075, 0xd082,
	0xd091, 0xd0a0, 0xd0ae, 0xd0ba, 0xd0c7, 0xd0d3, 0xd0df, 0xd0eb,
	0xd0f8, 0xd104, 0xd119, 0xd125, 0xd132, 0xd13f, 0xd14c, 0xd159,
	0xd167, 0xd174, 0xd181, 0xd18f, 0xd19c, 0xd1aa, 0xd1b7, 0xd1c4,
	0xd1d1, 0xd1e5, 0xd1f2, 0xd200, 0xd20d, 0xd21a, 0xd227, 0xd234,
	0xd249, 0xd25b, 0xd26e, 0xd280, 0xd29d, 0xd2b9, 0xd2d8, 0xd2fa,
	0xd316, 0xd331, 0xd34f, 0xd36e, 0xd38c, 0xd3a4, 0xd3bb, 0xd3cf,
	// Entry 780 - 7BF
	0xd3e4, 0xd3ed, 0xd401, 0xd40f, 0xd41d, 0xd42c, 0xd43a, 0xd44f,
	0xd463, 0xd479, 0xd48f, 0xd4a2, 0xd4b6, 0xd4ca, 0xd4dd, 0xd4f1,
	0xd505, 0xd51a, 0xd530, 0xd544, 0xd558, 0xd570, 0xd583, 0xd596,
	0xd5ae, 0xd5c2, 0xd5d7, 0xd5ec, 0xd601, 0xd612, 0xd628, 0xd640,
	0xd655, 0xd67d, 0xd69a, 0xd6b5, 0xd6cb, 0xd6eb, 0xd707, 0xd71e,
	0xd73d, 0xd758, 0xd76e, 0xd78f, 0xd7ab, 0xd7c6, 0xd7dc, 0xd7f7,
	0xd812, 0xd828, 0xd83e, 0xd858, 0xd86e, 0xd88b, 0xd8a7, 0xd8c2,
	0xd8db, 0xd8f7, 0xd917, 0xd932, 0xd955, 0xd970, 0xd98b, 0xd9a5,
	// Entry 7C0 - 7FF
	0xd9bf, 0xd9dc, 0xd9fe, 0xda1a, 0xda2e, 0xda3f, 0xda50, 0xda61,
	0xda72, 0xda88, 0xda99, 0xdaaa, 0xdabc, 0xdacf, 0xdae0, 0xdaf1,
	0xdb02, 0xdb13, 0xdb24, 0xdb35, 0xdb46, 0xdb58, 0xdb69, 0xdb7a,
	0xdb8c, 0xdb9d, 0xdbb4, 0xdbc6, 0xdbd8, 0xdbf0, 0xdc09, 0xdc20,
	0xdc33, 0xdc4e, 0xdc68, 0xdc83, 0xdc9e, 0xdcb9, 0xdcd5, 0xdcf0,
	0xdd0a, 0xdd25, 0xdd41, 0xdd5c, 0xdd82, 0xddb2, 0xdddd, 0xde07,
	0xde2d, 0xde60, 0xde90, 0xdec0, 0xdeef, 0xdf1f, 0xdf40, 0xdf7e,
	0xdfb7, 0xdff8, 0xe036, 0xe06f, 0xe0b0, 0xe0dc, 0xe107, 0xe12b,
	// Entry 800 - 83F
	0xe14d, 0xe16f, 0xe185, 0xe19e, 0xe1b5, 0xe1dd, 0xe20a, 0xe22a,
	0xe251, 0xe283, 0xe297, 0xe2ae, 0xe2c7, 0xe2e4, 0xe301, 0xe31d,
	0xe33a, 0xe34d, 0xe36e, 0xe382, 0xe39e, 0xe3c2, 0xe3e4, 0xe40a,
	0xe42f, 0xe464, 0xe484, 0xe4a5, 0xe4cd, 0xe502, 0xe535, 0xe550,
	0xe571, 0xe58b, 0xe5a1, 0xe5c8, 0xe5ef, 0xe615, 0xe62f, 0xe657,
	0xe67e, 0xe69e, 0xe6d0, 0xe6f7, 0xe71e, 0xe744, 0xe76b, 0xe7a5,
	0xe7be, 0xe7d7, 0xe7f1, 0xe80f, 0xe82d, 0xe84c, 0xe86c, 0xe88c,
	0xe8b5, 0xe8e4, 0xe90c, 0xe934, 0xe968, 0xe97a, 0xe990, 0xe9ab,
	// Entry 840 - 87F
	0xe9db, 0xe9f5, 0xea0a, 0xea26, 0xea42, 0xea54, 0xea6d, 0xea97,
	0xeaab, 0xeac8, 0xeadd, 0xeaf2, 0xeb07, 0xeb28, 0xeb48, 0xeb6b,
	0xeb8a, 0xeba8, 0xebc4, 0xebde, 0xebfa, 0xec1b, 0xec37, 0xec52,
	0xec6b, 0xec7d, 0xec8f, 0xeca1, 0xecb6, 0xeccb, 0xece0, 0xecf9,
	0xed13, 0xed29, 0xed42, 0xed5c, 0xed72, 0xed86, 0xed9a, 0xedae,
	0xedc3, 0xedd9, 0xedf4, 0xee0f, 0xee2a, 0xee46, 0xee61, 0xee7d,
	0xeea0, 0xeecc, 0xeef1, 0xef06, 0xef26, 0xef4a, 0xef65, 0xef7d,
	0xef94, 0xefad, 0xefc0, 0xefd4, 0xefe7, 0xeffb, 0xf00e, 0xf022,
	// Entry 880 - 8BF
	0xf03d, 0xf058, 0xf072, 0xf08b, 0xf09e, 0xf0b2, 0xf0cc, 0xf0e5,
	0xf0f8, 0xf10c, 0xf120, 0xf135, 0xf149, 0xf15e, 0xf173, 0xf187,
	0xf19c, 0xf1b0, 0xf1c5, 0xf1da, 0xf1ef, 0xf205, 0xf21a, 0xf230,
	0xf245, 0xf259, 0xf26e, 0xf282, 0xf297, 0xf2ab, 0xf2c1, 0xf2d5,
	0xf2ea, 0xf2fe, 0xf313, 0xf327, 0xf33b, 0xf34f, 0xf364, 0xf378,
	0xf38d, 0xf3a3, 0xf3b7, 0xf3cc, 0xf3e1, 0xf3f5, 0xf409, 0xf421,
	0xf43a, 0xf44f, 0xf467, 0xf47f, 0xf496, 0xf4ae, 0xf4c5, 0xf4dd,
	0xf4fc, 0xf51c, 0xf53a, 0xf557, 0xf56e, 0xf586, 0xf5a4, 0xf5c1,
	// Entry 8C0 - 8FF
	0xf5d8, 0xf5f0, 0xf606, 0xf62b, 0xf643, 0xf650, 0xf66d, 0xf68c,
	0xf6a3, 0xf6ba, 0xf6dd, 0xf6f5, 0xf70e, 0xf722, 0xf738, 0xf74e,
	0xf762, 0xf779, 0xf78e, 0xf7a2, 0xf7b7, 0xf7d3, 0xf7ef, 0xf80e,
	0xf82e, 0xf83e, 0xf855, 0xf86a, 0xf87e, 0xf892, 0xf8a8, 0xf8bd,
	0xf8d2, 0xf8e6, 0xf8fc, 0xf912, 0xf927, 0xf943, 0xf963, 0xf97d,
	0xf991, 0xf9a6, 0xf9ba, 0xf9ce, 0xf9e3, 0xfa00, 0xfa15, 0xfa2f,
	0xfa44, 0xfa59, 0xfa77, 0xfa8d, 0xfaa2, 0xfaae, 0xfac6, 0xfadb,
	0xfaef, 0xfaff, 0xfb10, 0xfb20, 0xfb31, 0xfb41, 0xfb52, 0xfb6a,
	// Entry 900 - 93F
	0xfb82, 0xfb92, 0xfba3, 0xfbb3, 0xfbc4, 0xfbd5, 0xfbe7, 0xfbf8,
	0xfc0a, 0xfc1c, 0xfc2d, 0xfc3f, 0xfc50, 0xfc62, 0xfc74, 0xfc86,
	0xfc99, 0xfcab, 0xfcbe, 0xfcd0, 0xfce1, 0xfcf3, 0xfd04, 0xfd16,
	0xfd27, 0xfd38, 0xfd4a, 0xfd5b, 0xfd6d, 0xfd7e, 0xfd8f, 0xfda0,
	0xfdb1, 0xfdc3, 0xfdd5, 0xfde6, 0xfdf7, 0xfe09, 0xfe1e, 0xfe33,
	0xfe47, 0xfe5c, 0xfe70, 0xfe85, 0xfea1, 0xfebe, 0xfed2, 0xfee7,
	0xfefb, 0xff10, 0xff23, 0xff3b, 0xff51, 0xff63, 0xff75, 0xff87,
	0xffa0, 0xffb9, 0xffd5, 0xfff2, 0x0004, 0x0015, 0x0026, 0x0039,
	// Entry 940 - 97F
	0x004b, 0x005d, 0x006e, 0x0081, 0x0094, 0x00a6, 0x00cc, 0x00f1,
	0x0103, 0x0115, 0x0133, 0x0151, 0x0171, 0x0190, 0x01c8, 0x01ec,
	0x01fa, 0x020c, 0x0229, 0x0242, 0x0255, 0x026d, 0x0280, 0x0295,
	0x02a6, 0x02b8, 0x02c9, 0x02db, 0x02ec, 0x02fe, 0x0310, 0x0322,
	0x0334, 0x0346, 0x0358, 0x036b, 0x037d, 0x0390, 0x03a3, 0x03b5,
	0x03c8, 0x03da, 0x03ed, 0x0400, 0x0413, 0x0427, 0x043a, 0x044e,
	0x0461, 0x0473, 0x0486, 0x0498, 0x04ab, 0x04bd, 0x04cf, 0x04e2,
	0x04f4, 0x0507, 0x0519, 0x052b, 0x053d, 0x054f, 0x0562, 0x0574,
	// Entry 980 - 9BF
	0x0587, 0x0599, 0x05ab, 0x05be, 0x05d4, 0x05e9, 0x05ff, 0x0614,
	0x062a, 0x0640, 0x0656, 0x066c, 0x0682, 0x0696, 0x06a9, 0x06bd,
	0x06d1, 0x06e3, 0x06f6, 0x0708, 0x071b, 0x072d, 0x073f, 0x0753,
	0x0766, 0x0779, 0x078b, 0x079f, 0x07b3, 0x07c6, 0x07d4, 0x07e2,
	0x07ee, 0x07fa, 0x080b, 0x081f, 0x0839, 0x0852, 0x0868, 0x087d,
	0x088e, 0x08a0, 0x08b1, 0x08c3, 0x08d4, 0x08e6, 0x08ff, 0x0918,
	0x092f, 0x0940, 0x0952, 0x0969, 0x097a, 0x098c, 0x099e, 0x09b1,
	0x09c3, 0x09d6, 0x09e9, 0x09fb, 0x0a0e, 0x0a20, 0x0a33, 0x0a46,
	// Entry 9C0 - 9FF
	0x0a59, 0x0a6d, 0x0a80, 0x0a94, 0x0aa7, 0x0ab9, 0x0acc, 0x0ade,
	0x0af1, 0x0b03, 0x0b15, 0x0b28, 0x0b3a, 0x0b4d, 0x0b5f, 0x0b71,
	0x0b83, 0x0b95, 0x0ba8, 0x0bba, 0x0bcd, 0x0be0, 0x0bf2, 0x0c04,
	0x0c17, 0x0c2d, 0x0c43, 0x0c58, 0x0c6e, 0x0c83, 0x0c99, 0x0cb6,
	0x0cd4, 0x0cf0, 0x0d05, 0x0d1b, 0x0d37, 0x0d4c, 0x0d62, 0x0d76,
	0x0d81, 0x0d9b, 0x0db5, 0x0dd2, 0x0df0, 0x0e03, 0x0e15, 0x0e27,
	0x0e3b, 0x0e4e, 0x0e61, 0x0e73, 0x0e87, 0x0e9b, 0x0eae, 0x0ec8,
	0x0edb, 0x0eee, 0x0f01, 0x0f15, 0x0f29, 0x0f4c, 0x0f6c, 0x0f90,
	// Entry A00 - A3F
	0x0fa6, 0x0fb9, 0x0fcb, 0x0fd9, 0x0fe8, 0x0ff6, 0x1005, 0x1013,
	0x1022, 0x1038, 0x104e, 0x105c, 0x106b, 0x1079, 0x1088, 0x1097,
	0x10a7, 0x10b6, 0x10c6, 0x10d6, 0x10e5, 0x10f5, 0x1104, 0x1114,
	0x1124, 0x1134, 0x1145, 0x1155, 0x1166, 0x1176, 0x1185, 0x1195,
	0x11a4, 0x11b4, 0x11c3, 0x11d2, 0x11e2, 0x11f1, 0x1201, 0x1210,
	0x121f, 0x122e, 0x123d, 0x124d, 0x125c, 0x126c, 0x127c, 0x128b,
	0x129a, 0x12aa, 0x12bd, 0x12d0, 0x12e2, 0x12f5, 0x1307, 0x131a,
	0x1334, 0x134f, 0x1361, 0x1374, 0x1386, 0x1399, 0x13aa, 0x13bd,
	// Entry A40 - A7F
	0x13d1, 0x13e5, 0x13f5, 0x1405, 0x1415, 0x142c, 0x1443, 0x145d,
	0x1478, 0x1488, 0x1497, 0x14a6, 0x14b7, 0x14c7, 0x14d7, 0x14e6,
	0x14f7, 0x1508, 0x1518, 0x1524, 0x1533, 0x154d, 0x1564, 0x1581,
	0x159d, 0x15b6, 0x15d5, 0x15e8, 0x15fa, 0x1608, 0x1617, 0x1625,
	0x1634, 0x1642, 0x1651, 0x165f, 0x166e, 0x167d, 0x168b, 0x169a,
	0x16a9, 0x16b8, 0x16c8, 0x16d7, 0x16e6, 0x16f6, 0x1706, 0x1716,
	0x1725, 0x1734, 0x1745, 0x1754, 0x1763, 0x1772, 0x1781, 0x1791,
	0x17a0, 0x17b0, 0x17c1, 0x17d0, 0x17e0, 0x17f0, 0x17ff, 0x180e,
	// Entry A80 - ABF
	0x1821, 0x1833, 0x1846, 0x1858, 0x186b, 0x187d, 0x1890, 0x18a3,
	0x18b5, 0x18c8, 0x18db, 0x18ec, 0x18f4, 0x1908, 0x1918, 0x1927,
	0x1936, 0x1947, 0x1957, 0x1967, 0x1976, 0x1987, 0x1998, 0x19a8,
	0x19b8, 0x19d0, 0x19e9, 0x19f7, 0x1a07, 0x1a16, 0x1a26, 0x1a37,
	0x1a4a, 0x1a5a, 0x1a6b, 0x1a92, 0x1aa9, 0x1abd, 0x1ad0, 0x1af4,
	0x1b03, 0x1b13, 0x1b22, 0x1b32, 0x1b41, 0x1b51, 0x1b68, 0x1b7f,
	0x1b8e, 0x1b9e, 0x1bae, 0x1bbd, 0x1bcd, 0x1bdd, 0x1bed, 0x1bfe,
	0x1c0e, 0x1c1f, 0x1c30, 0x1c40, 0x1c51, 0x1c61, 0x1c72, 0x1c83,
	// Entry AC0 - AFF
	0x1c94, 0x1ca6, 0x1cb7, 0x1cc9, 0x1cda, 0x1cea, 0x1cfb, 0x1d0b,
	0x1d1c, 0x1d2c, 0x1d3c, 0x1d4d, 0x1d5d, 0x1d6e, 0x1d7e, 0x1d8e,
	0x1d9e, 0x1daf, 0x1dbf, 0x1dd0, 0x1de2, 0x1df2, 0x1e03, 0x1e14,
	0x1e24, 0x1e34, 0x1e45, 0x1e59, 0x1e6d, 0x1e80, 0x1e94, 0x1ea7,
	0x1ebb, 0x1ed6, 0x1ef2, 0x1f05, 0x1f19, 0x1f2d, 0x1f40, 0x1f54,
	0x1f68, 0x1f7a, 0x1f8c, 0x1fa1, 0x1fb2, 0x1fc3, 0x1fd5, 0x1ff0,
	0x2008, 0x2020, 0x203b, 0x2057, 0x2068, 0x2078, 0x2088, 0x209a,
	0x20ab, 0x20bc, 0x20cc, 0x20de, 0x20f0, 0x2101, 0x2114, 0x2145,
	// Entry B00 - B3F
	0x2175, 0x21a5, 0x21d7, 0x2208, 0x2239, 0x226c, 0x227d, 0x229d,
	0x22b5, 0x22ca, 0x22de, 0x22f2, 0x2302, 0x2313, 0x2323, 0x2334,
	0x2344, 0x2355, 0x236d, 0x2385, 0x2395, 0x23a6, 0x23b7, 0x23c7,
	0x23d8, 0x23e9, 0x23fa, 0x240c, 0x241d, 0x242f, 0x2441, 0x2452,
	0x2464, 0x2475, 0x2487, 0x2499, 0x24ab, 0x24be, 0x24d0, 0x24e3,
	0x24f5, 0x2506, 0x2518, 0x2529, 0x253b, 0x254c, 0x255d, 0x256f,
	0x2580, 0x2592, 0x25a3, 0x25b4, 0x25c5, 0x25d7, 0x25e8, 0x25fa,
	0x260b, 0x261d, 0x262f, 0x2640, 0x2651, 0x2663, 0x2678, 0x268d,
	// Entry B40 - B7F
	0x26a1, 0x26b6, 0x26ca, 0x26df, 0x26fb, 0x2718, 0x272c, 0x2741,
	0x2756, 0x276a, 0x277f, 0x2794, 0x27a7, 0x27ba, 0x27d0, 0x27ec,
	0x27fd, 0x2816, 0x282f, 0x284b, 0x2868, 0x287a, 0x288b, 0x289c,
	0x28af, 0x28c1, 0x28d3, 0x28e4, 0x28f7, 0x290a, 0x291c, 0x2934,
	0x294c, 0x2977, 0x299e, 0x29b8, 0x29cf, 0x29e5, 0x2a04, 0x2a16,
	0x2a29, 0x2a3b, 0x2a4e, 0x2a60, 0x2a73, 0x2a8d, 0x2aa7, 0x2ab9,
	0x2acc, 0x2adf, 0x2af1, 0x2b04, 0x2b17, 0x2b2a, 0x2b3e, 0x2b51,
	0x2b65, 0x2b79, 0x2b8c, 0x2ba0, 0x2bb3, 0x2bc7, 0x2bdb, 0x2bef,
	// Entry B80 - BBF
	0x2c04, 0x2c18, 0x2c2d, 0x2c41, 0x2c54, 0x2c68, 0x2c7b, 0x2c8f,
	0x2ca2, 0x2cb7, 0x2cca, 0x2cde, 0x2cf1, 0x2d05, 0x2d18, 0x2d2b,
	0x2d3e, 0x2d52, 0x2d65, 0x2d79, 0x2d8e, 0x2da1, 0x2db5, 0x2dc9,
	0x2ddc, 0x2def, 0x2e04, 0x2e26, 0x2e44, 0x2e5b, 0x2e72, 0x2e88,
	0x2e9f, 0x2eb5, 0x2ecc, 0x2eea, 0x2f09, 0x2f1f, 0x2f36, 0x2f4d,
	0x2f63, 0x2f7a, 0x2f91, 0x2fa6, 0x2fbf, 0x2fd2, 0x2feb, 0x3004,
	0x301f, 0x3037, 0x3066, 0x3085, 0x30a8, 0x30c8, 0x30e4, 0x3107,
	0x3123, 0x313e, 0x3159, 0x3174, 0x3192, 0x31b1, 0x31c5, 0x31d8,
	// Entry BC0 - BFF
	0x31eb, 0x3200, 0x3214, 0x3228, 0x323b, 0x3250, 0x3265, 0x3279,
	0x328d, 0x32a9, 0x32c6, 0x32e4, 0x32ff, 0x3320, 0x3340, 0x335d,
	0x3380, 0x3393, 0x33ad, 0x33c6, 0x33e0, 0x33f9, 0x3413, 0x342c,
	0x3444, 0x345b, 0x3471, 0x3486, 0x349c, 0x34b2, 0x34c9, 0x34de,
	0x34f4, 0x3509, 0x351f, 0x3536, 0x354e, 0x3565, 0x357d, 0x3592,
	0x35a8, 0x35be, 0x35d3, 0x35e9, 0x35ff, 0x3620, 0x3642, 0x3663,
	0x3685, 0x36a6, 0x36c4, 0x36e5, 0x3707, 0x3728, 0x374a, 0x376b,
	0x3796, 0x37b4, 0x37d6, 0x37f9, 0x381b, 0x383e, 0x385e, 0x387d,
	// Entry C00 - C3F
	0x389e, 0x38c0, 0x38e1, 0x3903, 0x3921, 0x393f, 0x3960, 0x3982,
	0x39a3, 0x39c5, 0x39db, 0x39f6, 0x3a0c, 0x3a22, 0x3a40, 0x3a56,
	0x3a74, 0x3a94, 0x3ab2, 0x3ac8, 0x3ae8, 0x3afe, 0x3b14, 0x3b31,
	0x3b54, 0x3b76, 0x3b97, 0x3bb7, 0x3bd9, 0x3bfa, 0x3c19, 0x3c33,
	0x3c52, 0x3c6f, 0x3c98, 0x3cc6, 0x3cf0, 0x3d0e, 0x3d25, 0x3d3b,
	0x3d51, 0x3d69, 0x3d80, 0x3d97, 0x3dad, 0x3dc5, 0x3ddd, 0x3df4,
	0x3e18, 0x3e3b, 0x3e59, 0x3e6e, 0x3e85, 0x3e9d, 0x3eb5, 0x3ecc,
	0x3ee6, 0x3efc, 0x3f13, 0x3f2b, 0x3f43, 0x3f57, 0x3f6e, 0x3f84,
	// Entry C40 - C7F
	0x3f9b, 0x3fb2, 0x3fc9, 0x3fe6, 0x4000, 0x4015, 0x402a, 0x403f,
	0x4057, 0x4070, 0x4088, 0x409c, 0x40b4, 0x40c9, 0x40e1, 0x40f5,
	0x410c, 0x4121, 0x413b, 0x414f, 0x4164, 0x4179, 0x418a, 0x41a0,
	0x41b1, 0x41c7, 0x41dd, 0x41f3, 0x4208, 0x421d, 0x4234, 0x4248,
	0x4260, 0x4278, 0x428d, 0x42a8, 0x42be, 0x42d4, 0x42e9, 0x42ff,
	0x4315, 0x432c, 0x4341, 0x4357, 0x436d, 0x4386, 0x439b, 0x43b1,
	0x43c6, 0x43e4, 0x4403, 0x441d, 0x4434, 0x444c, 0x4461, 0x4477,
	0x448d, 0x44a8, 0x44c2, 0x44d9, 0x44f0, 0x4506, 0x4515, 0x4523,
	// Entry C80 - CBF
	0x4531, 0x4541, 0x4550, 0x455f, 0x456d, 0x457d, 0x458d, 0x459c,
	0x45b5, 0x45ca, 0x45d7, 0x45ea, 0x45fc, 0x460f, 0x461d, 0x462a,
	0x463d, 0x464e, 0x4661, 0x466f, 0x4682, 0x4695, 0x46a9, 0x46bc,
	0x46d0, 0x46e3, 0x46f0, 0x46fd, 0x4710, 0x4722, 0x4735, 0x4742,
	0x474f, 0x475c, 0x476f, 0x4780, 0x4792, 0x47a4, 0x47b7, 0x47c4,
	0x47d1, 0x47e3, 0x47f5, 0x4802, 0x4819, 0x4830, 0x4842, 0x4854,
	0x4867, 0x4873, 0x4884, 0x4890, 0x48a0, 0x48b6, 0x48c7, 0x48d8,
	0x48e8, 0x48f9, 0x4909, 0x491a, 0x492a, 0x493b, 0x494f, 0x4965,
	// Entry CC0 - CFF
	0x497a, 0x4990, 0x49a0, 0x49b1, 0x49c1, 0x49d2, 0x49e3, 0x49ec,
	0x49fb, 0x4a0b, 0x4a1a, 0x4a2d, 0x4a42, 0x4a4f, 0x4a5b, 0x4a69,
	0x4a76, 0x4a83, 0x4a92, 0x4aa0, 0x4aae, 0x4abb, 0x4aca, 0x4ad9,
	0x4ae7, 0x4af0, 0x4af9, 0x4b0b, 0x4b1e, 0x4b31, 0x4b56, 0x4b80,
	0x4bab, 0x4bcf, 0x4bf3, 0x4c1a, 0x4c3c, 0x4c53, 0x4c6d, 0x4c8b,
	0x4cab, 0x4ccd, 0x4cde, 0x4cf4, 0x4d0b, 0x4d27, 0x4d48, 0x4d63,
	0x4d8d, 0x4da4, 0x4dc4, 0x4de4, 0x4e13, 0x4e36, 0x4e5c, 0x4e77,
	0x4e93, 0x4eae, 0x4ec8, 0x4ee3, 0x4f02, 0x4f14, 0x4f25, 0x4f36,
	// Entry D00 - D3F
	0x4f49, 0x4f5b, 0x4f6d, 0x4f7e, 0x4f91, 0x4fa4, 0x4fb6, 0x4fcc,
	0x4fe2, 0x4ffa, 0x5011, 0x5028, 0x503e, 0x5056, 0x506e, 0x5085,
	0x509c, 0x50b4, 0x50d3, 0x50fe, 0x5120, 0x5134, 0x514a, 0x5165,
	0x5180, 0x519b, 0x51b6, 0x51cc, 0x51e2, 0x51f3, 0x5205, 0x5216,
	0x5228, 0x523a, 0x524b, 0x525d, 0x526e, 0x5280, 0x5292, 0x52a5,
	0x52b7, 0x52ca, 0x52dc, 0x52ed, 0x52ff, 0x5310, 0x5322, 0x5333,
	0x5344, 0x5356, 0x5367, 0x5379, 0x538a, 0x539c, 0x53af, 0x53c1,
	0x53d4, 0x53e5, 0x53f7, 0x5408, 0x5419, 0x542a, 0x543b, 0x544c,
	// Entry D40 - D7F
	0x545e, 0x5470, 0x5481, 0x5492, 0x54a2, 0x54b5, 0x54d1, 0x54e3,
	0x54f5, 0x550a, 0x551e, 0x5533, 0x5547, 0x555c, 0x5578, 0x5595,
	0x55b1, 0x55ce, 0x55e2, 0x55f7, 0x560b, 0x5620, 0x563b, 0x5651,
	0x566e, 0x568c, 0x56a7, 0x56bc, 0x56d0, 0x56e3, 0x56f9, 0x5710,
	0x5728, 0x573d, 0x5759, 0x5775, 0x5793, 0x57b5, 0x57d4, 0x57fc,
	0x5817, 0x5833, 0x584e, 0x586a, 0x5886, 0x58a1, 0x58bd, 0x58d8,
	0x58f4, 0x5910, 0x592d, 0x5949, 0x5966, 0x5982, 0x599d, 0x59b9,
	0x59d4, 0x59f0, 0x5a0b, 0x5a26, 0x5a42, 0x5a5d, 0x5a79, 0x5a94,
	// Entry D80 - DBF
	0x5ab0, 0x5acd, 0x5ae9, 0x5b06, 0x5b21, 0x5b3d, 0x5b58, 0x5b73,
	0x5b8e, 0x5ba9, 0x5bc4, 0x5be0, 0x5bfc, 0x5c17, 0x5c32, 0x5c4c,
	0x5c69, 0x5c8f, 0x5cb5, 0x5cdb, 0x5cec, 0x5d0a, 0x5d2e, 0x5d52,
	0x5d75, 0x5d99, 0x5daf, 0x5dc5, 0x5dde, 0x5dfe, 0x5e14, 0x5e29,
	0x5e4a, 0x5e6b, 0x5e8c, 0x5eab, 0x5ec5, 0x5ee9, 0x5f0c, 0x5f23,
	0x5f53, 0x5f83, 0x5f9b, 0x5fb2, 0x5fd4, 0x5ff5, 0x6015, 0x6036,
	0x6047, 0x6059, 0x606a, 0x607c, 0x608e, 0x609f, 0x60b1, 0x60c2,
	0x60d4, 0x60e6, 0x60f9, 0x610b, 0x611e, 0x6130, 0x6143, 0x6155,
	// Entry DC0 - DFF
	0x6166, 0x6178, 0x6189, 0x619b, 0x61ac, 0x61bd, 0x61cf, 0x61e0,
	0x61f2, 0x6203, 0x6214, 0x6225, 0x6236, 0x6247, 0x6258, 0x6269,
	0x627b, 0x628b, 0x62a0, 0x62b0, 0x62c1, 0x62d1, 0x62e2, 0x62f2,
	0x6306, 0x6316, 0x6327, 0x6341, 0x6356, 0x636a, 0x637f, 0x6393,
	0x63a8, 0x63bc, 0x63d1, 0x63ea, 0x6402, 0x641c, 0x6431, 0x6447,
	0x645b, 0x646e, 0x647f, 0x649f, 0x64bf, 0x64df, 0x64ff, 0x6516,
	0x6528, 0x6539, 0x654a, 0x655d, 0x656f, 0x6581, 0x6592, 0x65a5,
	0x65b8, 0x65ca, 0x65e5, 0x65f9, 0x6610, 0x6628, 0x6645, 0x665c,
	// Entry E00 - E3F
	0x666e, 0x6680, 0x6698, 0x66b1, 0x66c9, 0x66e2, 0x66fe, 0x671b,
	0x6737, 0x6754, 0x676a, 0x6780, 0x6796, 0x67ac, 0x67d0, 0x67f4,
	0x6818, 0x6835, 0x6855, 0x6877, 0x689a, 0x68be, 0x68e2, 0x6909,
	0x6930, 0x6955, 0x697a, 0x699f, 0x69c4, 0x69e9, 0x6a0d, 0x6a31,
	0x6a56, 0x6a75, 0x6a90, 0x6aaa, 0x6ac5, 0x6adb, 0x6af2, 0x6b08,
	0x6b1e, 0x6b34, 0x6b4b, 0x6b61, 0x6b77, 0x6b8e, 0x6ba4, 0x6bba,
	0x6bd1, 0x6be7, 0x6c0c, 0x6c26, 0x6c3f, 0x6c5e, 0x6c7d, 0x6c95,
	0x6cad, 0x6cc5, 0x6cdd, 0x6cfd, 0x6d1d, 0x6d44, 0x6d63, 0x6d84,
	// Entry E40 - E7F
	0x6d9b, 0x6db1, 0x6dc7, 0x6ddf, 0x6df6, 0x6e0d, 0x6e23, 0x6e3b,
	0x6e53, 0x6e6a, 0x6e84, 0x6e9e, 0x6eb8, 0x6ed3, 0x6eea, 0x6f09,
	0x6f23, 0x6f3e, 0x6f59, 0x6f74, 0x6f8e, 0x6fa9, 0x6fc4, 0x6fdf,
	0x6ff9, 0x7014, 0x702f, 0x704a, 0x7065, 0x707f, 0x709a, 0x70b6,
	0x70d1, 0x70ec, 0x7107, 0x7121, 0x713d, 0x7159, 0x7175, 0x7190,
	0x71ac, 0x71c8, 0x71e3, 0x71fe, 0x7219, 0x7235, 0x7250, 0x726c,
	0x7287, 0x72a1, 0x72bc, 0x72d6, 0x72f1, 0x730c, 0x7326, 0x7341,
	0x7353, 0x7366, 0x7379, 0x738c, 0x739e, 0x73b1, 0x73c4, 0x73d7,
	// Entry E80 - EBF
	0x73e9, 0x73fc, 0x740f, 0x7422, 0x7435, 0x7447, 0x745a, 0x746e,
	0x7481, 0x7494, 0x74a7, 0x74b9, 0x74cd, 0x74e1, 0x74f5, 0x7508,
	0x751c, 0x7530, 0x7543, 0x7556, 0x7569, 0x757d, 0x7590, 0x75a4,
	0x75b7, 0x75c9, 0x75dc, 0x75ee, 0x7601, 0x7614, 0x7626, 0x7638,
	0x764d, 0x7667, 0x767a, 0x7696, 0x76b2, 0x76c5, 0x76de, 0x76f9,
	0x770f, 0x772a, 0x773f, 0x7755, 0x7770, 0x7785, 0x779a, 0x77af,
	0x77c9, 0x77dd, 0x77f6, 0x780b, 0x7820, 0x783a, 0x7851, 0x7868,
	0x787f, 0x7896, 0x78ab, 0x78c7, 0x78e1, 0x78fd, 0x7918, 0x7935,
	// Entry EC0 - EFF
	0x7950, 0x796a, 0x7985, 0x79a2, 0x79bd, 0x79da, 0x79f6, 0x7a11,
	0x7a2d, 0x7a47, 0x7a68, 0x7a89, 0x7aa9, 0x7ac8, 0x7ae8, 0x7b03,
	0x7b20, 0x7b3d, 0x7b5a, 0x7b77, 0x7b99, 0x7bb4, 0x7bce, 0x7be9,
	0x7c03, 0x7c1d, 0x7c37, 0x7c58, 0x7c76, 0x7c90, 0x7caa, 0x7cc6,
	0x7ce2, 0x7cfe, 0x7d1a, 0x7d34, 0x7d50, 0x7d71, 0x7d90, 0x7db4,
	0x7dcb, 0x7de7, 0x7e03, 0x7e1e, 0x7e39, 0x7e53, 0x7e70, 0x7e8a,
	0x7ea5, 0x7ec2, 0x7edf, 0x7efc, 0x7f14, 0x7f2f, 0x7f4c, 0x7f6e,
	0x7f8e, 0x7fb3, 0x7fd2, 0x7fef, 0x800e, 0x8030, 0x804d, 0x806c,
	// Entry F00 - F3F
	0x8086, 0x80a1, 0x80be, 0x80d8, 0x80f3, 0x810e, 0x812a, 0x8140,
	0x8157, 0x8169, 0x817c, 0x818f, 0x81a3, 0x81b6, 0x81c8, 0x81dc,
	0x81ef, 0x8201, 0x8214, 0x8228, 0x823b, 0x824e, 0x8260, 0x8274,
	0x8287, 0x829a, 0x82ad, 0x82c0, 0x82d3, 0x82e5, 0x82f9, 0x830d,
	0x8322, 0x8338, 0x834d, 0x8362, 0x8378, 0x838e, 0x83a4, 0x83b9,
	0x83cd, 0x83e2, 0x83f6, 0x840a, 0x8420, 0x8437, 0x844e, 0x8463,
	0x8478, 0x848c, 0x84a1, 0x84b9, 0x84ce, 0x84e2, 0x84f7, 0x850d,
	0x8522, 0x8539, 0x854f, 0x8564, 0x8579, 0x858e, 0x85a4, 0x85b9,
	// Entry F40 - F7F
	0x85cd, 0x85e2, 0x85f6, 0x860a, 0x861f, 0x8637, 0x864d, 0x8666,
	0x867e, 0x8696, 0x86b1, 0x86c6, 0x86db, 0x86f2, 0x8707, 0x871d,
	0x8734, 0x8750, 0x876c, 0x8782, 0x879e, 0x87ba, 0x87d1, 0x87e7,
	0x8804, 0x8820, 0x883c, 0x8857, 0x8875, 0x8893, 0x88af, 0x88c5,
	0x88db, 0x88f6, 0x890b, 0x8925, 0x893b, 0x8951, 0x8969, 0x8981,
	0x8999, 0x89b1, 0x89c7, 0x89e4, 0x8a07, 0x8a24, 0x8a41, 0x8a5c,
	0x8a7a, 0x8a98, 0x8ab6, 0x8ad3, 0x8af5, 0x8b11, 0x8b2e, 0x8b51,
	0x8b6c, 0x8b8f, 0x8bb0, 0x8bd1, 0x8bf3, 0x8c17, 0x8c37, 0x8c55,
	// Entry F80 - FBF
	0x8c73, 0x8c95, 0x8cb2, 0x8cce, 0x8cea, 0x8d05, 0x8d25, 0x8d43,
	0x8d61, 0x8d7d, 0x8d9b, 0x8db7, 0x8dd5, 0x8df1, 0x8e0f, 0x8e2b,
	0x8e47, 0x8e62, 0x8e7d, 0x8e95, 0x8eb2, 0x8ed4, 0x8eef, 0x8f0d,
	0x8f26, 0x8f44, 0x8f65, 0x8f83, 0x8fa3, 0x8fbf, 0x8fdb, 0x8ff7,
	0x9013, 0x902f, 0x904c, 0x9069, 0x9088, 0x90a7, 0x90c4, 0x90df,
	0x90f3, 0x9107, 0x911b, 0x9130, 0x9145, 0x9159, 0x916d, 0x9182,
	0x9196, 0x91aa, 0x91be, 0x91d3, 0x91e8, 0x91fc, 0x9210, 0x9225,
	0x923a, 0x924f, 0x9264, 0x927a, 0x9290, 0x92a5, 0x92ba, 0x92d0,
	// Entry FC0 - FFF
	0x92e4, 0x92f8, 0x930c, 0x9321, 0x9336, 0x934a, 0x935e, 0x9373,
	0x9388, 0x939d, 0x93b2, 0x93c8, 0x93de, 0x93f3, 0x9408, 0x941e,
	0x9432, 0x9446, 0x945a, 0x946f, 0x9484, 0x9498, 0x94ac, 0x94c1,
	0x94d5, 0x94e9, 0x94fd, 0x9512, 0x9527, 0x953b, 0x954f, 0x9564,
	0x9579, 0x958e, 0x95a3, 0x95b9, 0x95cf, 0x95e4, 0x95f9, 0x960f,
	0x9623, 0x9637, 0x964b, 0x9660, 0x9675, 0x9689, 0x969d, 0x96b2,
	0x96c7, 0x96dc, 0x96f2, 0x9708, 0x971d, 0x9732, 0x9747, 0x975c,
	0x9772, 0x9788, 0x979d, 0x97b2, 0x97c8, 0x97de, 0x97f5, 0x980c,
	// Entry 1000 - 103F
	0x9822, 0x9836, 0x984a, 0x985e, 0x9873, 0x9888, 0x989c, 0x98b0,
	0x98c5, 0x98d9, 0x98ed, 0x9901, 0x9916, 0x992b, 0x993f, 0x9953,
	0x9968, 0x997c, 0x9990, 0x99a4, 0x99b9, 0x99ce, 0x99e2, 0x99f6,
	0x9a0b, 0x9a1f, 0x9a33, 0x9a47, 0x9a5c, 0x9a71, 0x9a85, 0x9a99,
	0x9aae, 0x9ac2, 0x9ad6, 0x9aea, 0x9aff, 0x9b14, 0x9b28, 0x9b3c,
	0x9b51, 0x9b66, 0x9b7b, 0x9b91, 0x9ba7, 0x9bbc, 0x9bd0, 0x9be4,
	0x9bf8, 0x9c0d, 0x9c22, 0x9c36, 0x9c4a, 0x9c5f, 0x9c74, 0x9c89,
	0x9c9e, 0x9cb4, 0x9cca, 0x9cdf, 0x9cf4, 0x9d0a, 0x9d25, 0x9d40,
	// Entry 1040 - 107F
	0x9d5b, 0x9d77, 0x9d93, 0x9dae, 0x9dc9, 0x9de5, 0x9df9, 0x9e0d,
	0x9e21, 0x9e36, 0x9e4b, 0x9e5f, 0x9e73, 0x9e88, 0x9e9d, 0x9eb2,
	0x9ec8, 0x9ede, 0x9ef3, 0x9f08, 0x9f1d, 0x9f32, 0x9f48, 0x9f5e,
	0x9f73, 0x9f88, 0x9f9e, 0x9fb4, 0x9fcb, 0x9fe2, 0x9ff8, 0xa00c,
	0xa020, 0xa034, 0xa049, 0xa05e, 0xa072, 0xa086, 0xa09b, 0xa0b9,
	0xa0d7, 0xa0f5, 0xa114, 0xa133, 0xa151, 0xa16f, 0xa183, 0xa197,
	0xa1ab, 0xa1c0, 0xa1d5, 0xa1e9, 0xa1fd, 0xa212, 0xa227, 0xa23c,
	0xa251, 0xa267, 0xa27d, 0xa292, 0xa2a7, 0xa2bd, 0xa2d1, 0xa2e5,
	// Entry 1080 - 10BF
	0xa2f9, 0xa30e, 0xa323, 0xa337, 0xa34b, 0xa360, 0xa374, 0xa388,
	0xa39c, 0xa3b1, 0xa3c6, 0xa3da, 0xa3ee, 0xa403, 0xa418, 0xa42d,
	0xa442, 0xa458, 0xa46e, 0xa483, 0xa498, 0xa4ae, 0xa4c2, 0xa4d6,
	0xa4ea, 0xa4ff, 0xa514, 0xa528, 0xa53c, 0xa551, 0xa565, 0xa579,
	0xa58d, 0xa5a2, 0xa5b7, 0xa5cb, 0xa5df, 0xa5f4, 0xa609, 0xa61e,
	0xa634, 0xa64a, 0xa65f, 0xa674, 0xa689, 0xa69e, 0xa6b4, 0xa6ca,
	0xa6df, 0xa6f4, 0xa70b, 0xa720, 0xa735, 0xa74a, 0xa760, 0xa776,
	0xa78b, 0xa7a0, 0xa7b6, 0xa7cb, 0xa7e0, 0xa7f5, 0xa80b, 0xa821,
	// Entry 10C0 - 10FF
	0xa836, 0xa84b, 0xa861, 0xa876, 0xa88b, 0xa8a0, 0xa8b6, 0xa8cc,
	0xa8e1, 0xa8f6, 0xa90c, 0xa921, 0xa936, 0xa94b, 0xa961, 0xa977,
	0xa98c, 0xa9a1, 0xa9b7, 0xa9cc, 0xa9e1, 0xa9f6, 0xaa0c, 0xaa22,
	0xaa37, 0xaa4c, 0xaa62, 0xaa76, 0xaa8a, 0xaa9e, 0xaab3, 0xaac8,
	0xaadc, 0xaaf0, 0xab05, 0xab19, 0xab2d, 0xab41, 0xab56, 0xab6b,
	0xab7f, 0xab93, 0xaba8, 0xabbd, 0xabd2, 0xabe7, 0xac1a, 0xac3e,
	0xac60, 0xac75, 0xac87, 0xac99, 0xaca7, 0xacb9, 0xacc7, 0xacdd,
	0xacf3, 0xad0f, 0xad21, 0xad33, 0xad47, 0xad5a, 0xad6d, 0xad7f,
	// Entry 1100 - 113F
	0xad93, 0xada7, 0xadba, 0xadcd, 0xade3, 0xadf9, 0xae0e, 0xae23,
	0xae38, 0xae4f, 0xae65, 0xae7b, 0xae92, 0xaeae, 0xaecd, 0xaee2,
	0xaef8, 0xaf0d, 0xaf2c, 0xaf41, 0xaf57, 0xaf6c, 0xaf8b, 0xafa0,
	0xafb6, 0xafcb, 0xafea, 0xafff, 0xb015, 0xb02a, 0xb043, 0xb05c,
	0xb076, 0xb096, 0xb0af, 0xb0c8, 0xb0e2, 0xb0fb, 0xb11a, 0xb132,
	0xb143, 0xb154, 0xb165, 0xb176, 0xb187, 0xb198, 0xb1aa, 0xb1bc,
	0xb1ce, 0xb1e0, 0xb1f2, 0xb204, 0xb216, 0xb228, 0xb23a, 0xb24c,
	0xb25e, 0xb270, 0xb282, 0xb294, 0xb2a6, 0xb2b8, 0xb2ca, 0xb2dc,
	// Entry 1140 - 117F
	0xb2ee, 0xb300, 0xb312, 0xb324, 0xb336, 0xb348, 0xb35a, 0xb36d,
	0xb380, 0xb392, 0xb3a4, 0xb3b6, 0xb3c8, 0xb3da, 0xb3ed, 0xb400,
	0xb413, 0xb426, 0xb439, 0xb44c, 0xb45e, 0xb46f, 0xb481, 0xb493,
	0xb4a5, 0xb4b7, 0xb4c9, 0xb4db, 0xb4ed, 0xb4ff, 0xb511, 0xb523,
	0xb535, 0xb547, 0xb559, 0xb56b, 0xb57e, 0xb591, 0xb5a4, 0xb5b7,
	0xb5ca, 0xb5dd, 0xb5f0, 0xb603, 0xb616, 0xb629, 0xb63c, 0xb64f,
	0xb662, 0xb674, 0xb686, 0xb698, 0xb6aa, 0xb6bc, 0xb6ce, 0xb6e0,
	0xb6f2, 0xb704, 0xb716, 0xb728, 0xb73a, 0xb74c, 0xb764, 0xb77c,
	// Entry 1180 - 11BF
	0xb794, 0xb7ac, 0xb7c4, 0xb7dc, 0xb7f5, 0xb809, 0xb81f, 0xb833,
	0xb848, 0xb85c, 0xb871, 0xb88d, 0xb8aa, 0xb8c6, 0xb8da, 0xb8ef,
	0xb904, 0xb923, 0xb938, 0xb957, 0xb96d, 0xb98d, 0xb9a2, 0xb9c1,
	0xb9d7, 0xb9f7, 0xba15, 0xba2a, 0xba49, 0xba5f, 0xba7f, 0xba9d,
	0xbab2, 0xbacd, 0xbaec, 0xbb0a, 0xbb28, 0xbb51, 0xbb77, 0xbb9f,
	0xbbbc, 0xbbe1, 0xbc17, 0xbc3a, 0xbc6a, 0xbc87, 0xbca9, 0xbcbe,
	0xbcd3, 0xbce8, 0xbcfd, 0xbd12, 0xbd29, 0xbd3e, 0xbd54, 0xbd69,
	0xbd7f, 0xbd9c, 0xbdba, 0xbdd7, 0xbdec, 0xbe02, 0xbe18, 0xbe38,
	// Entry 11C0 - 11FF
	0xbe4e, 0xbe6e, 0xbe85, 0xbea6, 0xbebc, 0xbedc, 0xbef3, 0xbf14,
	0xbf2a, 0xbf4a, 0xbf61, 0xbf82, 0xbfa0, 0xbfb4, 0xbfd2, 0xbfee,
	0xc003, 0xc01a, 0xc02f, 0xc045, 0xc05a, 0xc070, 0xc08d, 0xc0ab,
	0xc0c8, 0xc0dd, 0xc0f3, 0xc109, 0xc129, 0xc13f, 0xc15f, 0xc176,
	0xc197, 0xc1ad, 0xc1cd, 0xc1e4, 0xc205, 0xc21b, 0xc23b, 0xc252,
	0xc273, 0xc292, 0xc2a6, 0xc2bc, 0xc2d2, 0xc2e8, 0xc2fe, 0xc313,
	0xc32a, 0xc33f, 0xc355, 0xc36a, 0xc380, 0xc39d, 0xc3b2, 0xc3c8,
	0xc3de, 0xc3fe, 0xc414, 0xc434, 0xc44b, 0xc46c, 0xc482, 0xc4a2,
	// Entry 1200 - 123F
	0xc4b9, 0xc4da, 0xc4f0, 0xc510, 0xc527, 0xc548, 0xc567, 0xc57b,
	0xc590, 0xc5b3, 0xc5d6, 0xc5f9, 0xc61c, 0xc631, 0xc648, 0xc65d,
	0xc673, 0xc688, 0xc69e, 0xc6bb, 0xc6d0, 0xc6e6, 0xc6fc, 0xc71c,
	0xc732, 0xc752, 0xc769, 0xc78a, 0xc7a0, 0xc7c0, 0xc7d7, 0xc7f8,
	0xc80e, 0xc82e, 0xc845, 0xc866, 0xc885, 0xc899, 0xc8b5, 0xc8ca,
	0xc8e1, 0xc8f6, 0xc90c, 0xc921, 0xc937, 0xc954, 0xc969, 0xc97f,
	0xc995, 0xc9b5, 0xc9cb, 0xc9eb, 0xca02, 0xca23, 0xca39, 0xca59,
	0xca70, 0xca91, 0xcaa7, 0xcac7, 0xcade, 0xcaff, 0xcb1e, 0xcb32,
	// Entry 1240 - 127F
	0xcb50, 0xcb65, 0xcb84, 0xcb9f, 0xcbb4, 0xcbcb, 0xcbe0, 0xcbf6,
	0xcc0b, 0xcc21, 0xcc3e, 0xcc53, 0xcc69, 0xcc7f, 0xcc9f, 0xccb5,
	0xccd5, 0xccec, 0xcd0d, 0xcd2c, 0xcd40, 0xcd5d, 0xcd72, 0xcd87,
	0xcd9e, 0xcdb3, 0xcdc9, 0xcdde, 0xcdf4, 0xce11, 0xce26, 0xce3c,
	0xce52, 0xce72, 0xce88, 0xcea8, 0xcebf, 0xcee0, 0xcef6, 0xcf16,
	0xcf2d, 0xcf4e, 0xcf64, 0xcf84, 0xcf9b, 0xcfbc, 0xcfd0, 0xcfee,
	0xd009, 0xd01e, 0xd035, 0xd04a, 0xd060, 0xd075, 0xd08b, 0xd0a8,
	0xd0bd, 0xd0d3, 0xd0e9, 0xd109, 0xd11f, 0xd13f, 0xd156, 0xd177,
	// Entry 1280 - 12BF
	0xd18d, 0xd1ad, 0xd1c4, 0xd1e5, 0xd1fb, 0xd21b, 0xd232, 0xd253,
	0xd272, 0xd286, 0xd2a5, 0xd2ba, 0xd2d8, 0xd2f8, 0xd316, 0xd334,
	0xd353, 0xd372, 0xd391, 0xd3b0, 0xd3c6, 0xd3dc, 0xd3f3, 0xd409,
	0xd420, 0xd436, 0xd44d, 0xd464, 0xd485, 0xd49c, 0xd4bd, 0xd4d5,
	0xd4f7, 0xd50e, 0xd52f, 0xd547, 0xd569, 0xd580, 0xd5a1, 0xd5b9,
	0xd5db, 0xd5f0, 0xd605, 0xd61c, 0xd631, 0xd647, 0xd65c, 0xd672,
	0xd68f, 0xd6a4, 0xd6ba, 0xd6d0, 0xd6f0, 0xd706, 0xd726, 0xd73d,
	0xd75e, 0xd774, 0xd794, 0xd7ab, 0xd7cc, 0xd7e2, 0xd802, 0xd819,
	// Entry 12C0 - 12FF
	0xd83a, 0xd859, 0xd86d, 0xd88c, 0xd8aa, 0xd8c6, 0xd8db, 0xd8f7,
	0xd916, 0xd92d, 0xd942, 0xd958, 0xd96d, 0xd983, 0xd9a2, 0xd9b7,
	0xd9cd, 0xd9ec, 0xda03, 0xda24, 0xda38, 0xda56, 0xda71, 0xda86,
	0xda9d, 0xdab2, 0xdac8, 0xdadd, 0xdaf3, 0xdb08, 0xdb1e, 0xdb35,
	0xdb56, 0xdb6a, 0xdb80, 0xdb9d, 0xdbb3, 0xdbd0, 0xdbe7, 0xdc05,
	0xdc1b, 0xdc32, 0xdc48, 0xdc5f, 0xdc77, 0xdc99, 0xdcae, 0xdcc5,
	0xdcdc, 0xdcf3, 0xdd0a, 0xdd20, 0xdd36, 0xdd4c, 0xdd62, 0xdd78,
	0xdd95, 0xddb2, 0xddd0, 0xdded, 0xde0b, 0xde28, 0xde46, 0xde62,
	// Entry 1300 - 133F
	0xde7e, 0xde93, 0xdeaa, 0xdebf, 0xded5, 0xdeea, 0xdf00, 0xdf15,
	0xdf2b, 0xdf3f, 0xdf56, 0xdf6d, 0xdf84, 0xdf9b, 0xdfba, 0xdfd9,
	0xdff8, 0xe017, 0xe02f, 0xe045, 0xe05c, 0xe072, 0xe089, 0xe09f,
	0xe0b6, 0xe0cb, 0xe0e1, 0xe0fe, 0xe11b, 0xe138, 0xe155, 0xe176,
	0xe197, 0xe1b8, 0xe1d9, 0xe1f9, 0xe20f, 0xe226, 0xe23c, 0xe253,
	0xe269, 0xe280, 0xe295, 0xe2b3, 0xe2d1, 0xe2f0, 0xe30e, 0xe32d,
	0xe34b, 0xe36a, 0xe387, 0xe3a3, 0xe3c1, 0xe3df, 0xe3fd, 0xe41b,
	0xe43a, 0xe459, 0xe478, 0xe497, 0xe4b6, 0xe4d5, 0xe4f4, 0xe513,
	// Entry 1340 - 137F
	0xe532, 0xe551, 0xe570, 0xe58f, 0xe5ab, 0xe5c7, 0xe5e3, 0xe5ff,
	0xe61d, 0xe63b, 0xe659, 0xe678, 0xe696, 0xe6b4, 0xe6d1, 0xe6ee,
	0xe70b, 0xe729, 0xe746, 0xe763, 0xe780, 0xe79d, 0xe7ba, 0xe7d8,
	0xe7f5, 0xe812, 0xe830, 0xe84e, 0xe86c, 0xe88b, 0xe8a9, 0xe8c7,
	0xe8e5, 0xe903, 0xe921, 0xe940, 0xe95e, 0xe97c, 0xe99a, 0xe9b8,
	0xe9d6, 0xe9f5, 0xea13, 0xea31, 0xea4e, 0xea6b, 0xea88, 0xeaa6,
	0xeac3, 0xeae0, 0xeafc, 0xeb19, 0xeb36, 0xeb53, 0xeb71, 0xeb8e,
	0xebab, 0xebc9, 0xebe7, 0xec05, 0xec24, 0xec42, 0xec60, 0xec7e,
	// Entry 1380 - 13BF
	0xec9c, 0xecba, 0xecd9, 0xecf7, 0xed15, 0xed32, 0xed4f, 0xed6c,
	0xed89, 0xeda7, 0xedc4, 0xede1, 0xedfe, 0xee1b, 0xee38, 0xee56,
	0xee73, 0xee90, 0xeead, 0xeeca, 0xeee7, 0xef05, 0xef22, 0xef3f,
	0xef5c, 0xef78, 0xef95, 0xefb2, 0xefd0, 0xefed, 0xf009, 0xf026,
	0xf044, 0xf062, 0xf080, 0xf09f, 0xf0bd, 0xf0db, 0xf0f8, 0xf115,
	0xf132, 0xf150, 0xf16d, 0xf18a, 0xf1a8, 0xf1c6, 0xf1e4, 0xf203,
	0xf221, 0xf23f, 0xf25d, 0xf27b, 0xf299, 0xf2b8, 0xf2d6, 0xf2f4,
	0xf313, 0xf332, 0xf351, 0xf371, 0xf390, 0xf3af, 0xf3cd, 0xf3eb,
	// Entry 13C0 - 13FF
	0xf409, 0xf428, 0xf446, 0xf464, 0xf481, 0xf49e, 0xf4bb, 0xf4d9,
	0xf4f6, 0xf513, 0xf52f, 0xf553, 0xf571, 0xf58f, 0xf5ad, 0xf5cc,
	0xf5ea, 0xf608, 0xf625, 0xf642, 0xf65f, 0xf67d, 0xf69a, 0xf6b7,
	0xf6d5, 0xf6f3, 0xf711, 0xf730, 0xf74e, 0xf76c, 0xf789, 0xf7a7,
	0xf7c5, 0xf7e3, 0xf802, 0xf820, 0xf83e, 0xf85c, 0xf87a, 0xf898,
	0xf8b7, 0xf8d5, 0xf8f3, 0xf912, 0xf931, 0xf950, 0xf970, 0xf98f,
	0xf9ae, 0xf9c9, 0xf9e5, 0xf9fb, 0xfa12, 0xfa29, 0xfa41, 0xfa58,
	0xfa70, 0xfa87, 0xfa9f, 0xfac2, 0xfae4, 0xfb07, 0xfb29, 0xfb4c,
	// Entry 1400 - 143F
	0xfb6e, 0xfb91, 0xfbb7, 0xfbd5, 0xfbe5, 0xfbf7, 0xfc08, 0xfc1a,
	0xfc2b, 0xfc3c, 0xfc4d, 0xfc5e, 0xfc70, 0xfc81, 0xfc93, 0xfca4,
	0xfcb5, 0xfcc9, 0xfcdc, 0xfced, 0xfcfe, 0xfd0e, 0xfd1d, 0xfd31,
	0xfd45, 0xfd59, 0xfd68, 0xfd7d, 0xfd8e, 0xfda6, 0xfdb8, 0xfdca,
	0xfde5, 0xfe00, 0xfe0e, 0xfe24, 0xfe33, 0xfe41, 0xfe4f, 0xfe70,
	0xfe80, 0xfe94, 0xfea5, 0xfeb6, 0xfec7, 0xfee5, 0xff02, 0xff10,
	0xff1f, 0xff2e, 0xff4b, 0xff5d, 0xff6d, 0xff80, 0xff8e, 0xff9e,
	0xffb6, 0xffc6, 0xffdf, 0xfff4, 0x0008, 0x0029, 0x0049, 0x0067,
	// Entry 1440 - 147F
	0x0085, 0x009a, 0x00b4, 0x00c2, 0x00d6, 0x00e6, 0x0104, 0x0120,
	0x0135, 0x0151, 0x0169, 0x017e, 0x01a2, 0x01bf, 0x01cd, 0x01db,
	0x01f7, 0x0214, 0x0222, 0x0247, 0x0268, 0x027d, 0x0290, 0x02a7,
	0x02c0, 0x02df, 0x02fd, 0x031c, 0x0331, 0x0344, 0x0354, 0x036d,
	0x0389, 0x0399, 0x03a9, 0x03bd, 0x03ce, 0x03e0, 0x03f1, 0x040c,
	0x0426, 0x043f, 0x044d, 0x045b, 0x0473, 0x048d, 0x04a4, 0x04b7,
	0x04cc, 0x04e1, 0x04ef, 0x04fe, 0x050d, 0x052a, 0x0547, 0x0564,
	0x0581, 0x05a0, 0x05b0, 0x05c0, 0x05d0, 0x05e1, 0x05f2, 0x0604,
	// Entry 1480 - 14BF
	0x0615, 0x0626, 0x0637, 0x0648, 0x0659, 0x066a, 0x067b, 0x068c,
	0x069d, 0x06ae, 0x06bf, 0x06d0, 0x06e4, 0x06f8, 0x070b, 0x0720,
	0x0739, 0x0749, 0x0759, 0x0769, 0x077a, 0x078b, 0x079d, 0x07ae,
	0x07bf, 0x07d0, 0x07e1, 0x07f2, 0x0803, 0x0814, 0x0825, 0x0836,
	0x0847, 0x0858, 0x0869, 0x087d, 0x0891, 0x08a6, 0x08c3, 0x08e0,
	0x08ee, 0x08fc, 0x090a, 0x0919, 0x0928, 0x0938, 0x0947, 0x0956,
	0x0965, 0x0974, 0x0983, 0x0992, 0x09a1, 0x09b0, 0x09bf, 0x09ce,
	0x09dd, 0x09ec, 0x09fe, 0x0a10, 0x0a21, 0x0a32, 0x0a43, 0x0a55,
	// Entry 14C0 - 14FF
	0x0a67, 0x0a7a, 0x0a8c, 0x0a9e, 0x0ab0, 0x0ac2, 0x0ad4, 0x0ae6,
	0x0af8, 0x0b0a, 0x0b1c, 0x0b2e, 0x0b43, 0x0b58, 0x0b67, 0x0b77,
	0x0b86, 0x0b96, 0x0ba6, 0x0bb5, 0x0bc5, 0x0bd4, 0x0be4, 0x0bf4,
	0x0c03, 0x0c14, 0x0c23, 0x0c34, 0x0c44, 0x0c53, 0x0c63, 0x0c72,
	0x0c82, 0x0c91, 0x0ca0, 0x0cb0, 0x0cbf, 0x0ccf, 0x0cde, 0x0ced,
	0x0cfc, 0x0d0b, 0x0d1a, 0x0d2a, 0x0d3a, 0x0d49, 0x0d58, 0x0d67,
	0x0d76, 0x0d91, 0x0dac, 0x0dc6, 0x0de1, 0x0dfb, 0x0e16, 0x0e31,
	0x0e4d, 0x0e67, 0x0e82, 0x0e9c, 0x0eb7, 0x0ed1, 0x0eec, 0x0f10,
	// Entry 1500 - 153F
	0x0f34, 0x0f4f, 0x0f66, 0x0f7d, 0x0f90, 0x0fa2, 0x0fb5, 0x0fc7,
	0x0fda, 0x0fec, 0x0fff, 0x1012, 0x1025, 0x1038, 0x104b, 0x105d,
	0x1070, 0x1083, 0x1096, 0x10a9, 0x10bb, 0x10cd, 0x10e5, 0x10fb,
	0x110d, 0x111e, 0x112e, 0x1144, 0x1156, 0x1166, 0x117e, 0x118f,
	0x119f, 0x11b4, 0x11c3, 0x11d8, 0x11f2, 0x1204, 0x1215, 0x122b,
	0x123d, 0x1257, 0x126f, 0x1282, 0x1292, 0x12a1, 0x12b0, 0x12c1,
	0x12d1, 0x12e1, 0x12f0, 0x1301, 0x1312, 0x1322, 0x133c, 0x1357,
	0x1371, 0x138b, 0x13a6, 0x13c1, 0x13e1, 0x1400, 0x141f, 0x143f,
	// Entry 1540 - 157F
	0x144e, 0x1460, 0x146f, 0x1482, 0x1491, 0x14a4, 0x14be, 0x14e5,
	0x14fb, 0x1515, 0x1525, 0x154a, 0x156f, 0x1596, 0x15af, 0x15d5,
	0x15e9, 0x15fc, 0x160f, 0x1624, 0x1638, 0x164c, 0x165f, 0x1674,
	0x1689, 0x169d, 0x16af, 0x16c1, 0x16d3, 0x16e5, 0x16f7, 0x170a,
	0x171d, 0x1730, 0x1743, 0x1757, 0x176a, 0x177d, 0x1790, 0x17a3,
	0x17b6, 0x17c9, 0x17dc, 0x17f0, 0x1803, 0x1816, 0x182a, 0x183d,
	0x1850, 0x1863, 0x1876, 0x1889, 0x189c, 0x18b0, 0x18c4, 0x18d7,
	0x18eb, 0x18ff, 0x1913, 0x1927, 0x193b, 0x1960, 0x1977, 0x198e,
	// Entry 1580 - 15BF
	0x19a5, 0x19bc, 0x19d4, 0x19ec, 0x1a05, 0x1a1d, 0x1a35, 0x1a4d,
	0x1a65, 0x1a7d, 0x1a95, 0x1aad, 0x1ac6, 0x1ade, 0x1af7, 0x1b0f,
	0x1b27, 0x1b3f, 0x1b58, 0x1b71, 0x1b8a, 0x1ba3, 0x1bbc, 0x1bd3,
	0x1bea, 0x1c02, 0x1c1a, 0x1c31, 0x1c4a, 0x1c62, 0x1c7a, 0x1c92,
	0x1caa, 0x1cc3, 0x1cdb, 0x1cf3, 0x1d0b, 0x1d23, 0x1d3c, 0x1d55,
	0x1d6e, 0x1d86, 0x1d9f, 0x1db8, 0x1dd1, 0x1dea, 0x1e04, 0x1e1e,
	0x1e38, 0x1e53, 0x1e75, 0x1e9b, 0x1ec0, 0x1ee0, 0x1f01, 0x1f2b,
	0x1f4b, 0x1f71, 0x1f8c, 0x1fa7, 0x1fc3, 0x1fe0, 0x1ffc, 0x2019,
	// Entry 15C0 - 15FF
	0x2037, 0x2054, 0x2071, 0x208d, 0x20a9, 0x20c5, 0x20e2, 0x20ff,
	0x211c, 0x2138, 0x2154, 0x2175, 0x2197, 0x21bb, 0x21df, 0x2202,
	0x2226, 0x224a, 0x226f, 0x2292, 0x22b6, 0x22da, 0x22fe, 0x2322,
	0x2345, 0x2365, 0x2386, 0x23aa, 0x23cb, 0x23ef, 0x2404, 0x2419,
	0x242f, 0x2445, 0x245b, 0x2471, 0x2488, 0x249e, 0x24b4, 0x24cb,
	0x24e1, 0x24f7, 0x250d, 0x2523, 0x2539, 0x254f, 0x2566, 0x257d,
	0x2595, 0x25ab, 0x25c1, 0x25d7, 0x25ed, 0x260b, 0x2622, 0x2641,
	0x2657, 0x2675, 0x268c, 0x26ab, 0x26c2, 0x26d8, 0x26ef, 0x2705,
	// Entry 1600 - 163F
	0x271c, 0x2732, 0x274e, 0x276a, 0x2786, 0x27a2, 0x27be, 0x27da,
	0x27f6, 0x2813, 0x282f, 0x284b, 0x286e, 0x2891, 0x28ae, 0x28ce,
	0x28ee, 0x2905, 0x291c, 0x2934, 0x294c, 0x2964, 0x297c, 0x2994,
	0x29b2, 0x29d0, 0x29ed, 0x2a0b, 0x2a2e, 0x2a4c, 0x2a6a, 0x2a87,
	0x2aa5, 0x2ac5, 0x2ae5, 0x2b08, 0x2b22, 0x2b31, 0x2b41, 0x2b50,
	0x2b60, 0x2b70, 0x2b7f, 0x2b8f, 0x2b9e, 0x2bae, 0x2bbe, 0x2bcd,
	0x2bdd, 0x2bec, 0x2bfc, 0x2c0b, 0x2c1a, 0x2c2a, 0x2c39, 0x2c49,
	0x2c58, 0x2c67, 0x2c76, 0x2c85, 0x2c94, 0x2ca4, 0x2cb4, 0x2cc3,
	// Entry 1640 - 167F
	0x2cd2, 0x2ce3, 0x2cf3, 0x2d05, 0x2d17, 0x2d29, 0x2d3c, 0x2d4f,
	0x2d62, 0x2d75, 0x2d87, 0x2d99, 0x2db2, 0x2dcb, 0x2de4, 0x2df9,
	0x2e0f, 0x2e2a, 0x2e3f, 0x2e54, 0x2e69, 0x2e7e, 0x2e93, 0x2ea8,
	0x2ebc, 0x2ed0, 0x2edf, 0x2eed, 0x2f03, 0x2f16, 0x2f26, 0x2f35,
	0x2f44, 0x2f55, 0x2f65, 0x2f75, 0x2f84, 0x2f95, 0x2fa6, 0x2fb6,
	0x2fc6, 0x2fd6, 0x2fe7, 0x2ff8, 0x3008, 0x3018, 0x3028, 0x3039,
	0x3049, 0x3059, 0x306a, 0x307a, 0x308a, 0x309a, 0x30aa, 0x30ba,
	0x30cb, 0x30dd, 0x30ed, 0x30fc, 0x310b, 0x311b, 0x312b, 0x313a,
	// Entry 1680 - 16BF
	0x314a, 0x3159, 0x3169, 0x3178, 0x3189, 0x3199, 0x31ad, 0x31c1,
	0x31d5, 0x31e9, 0x31fd, 0x3217, 0x3230, 0x324a, 0x3264, 0x327f,
	0x3298, 0x32b1, 0x32cb, 0x32e6, 0x3300, 0x331a, 0x3334, 0x334d,
	0x3366, 0x3380, 0x339b, 0x33b5, 0x33ce, 0x33e8, 0x3401, 0x341b,
	0x3436, 0x3450, 0x3469, 0x3483, 0x349c, 0x34b6, 0x34d0, 0x34ea,
	0x3503, 0x351c, 0x3535, 0x354f, 0x3569, 0x3583, 0x359c, 0x35b5,
	0x35ce, 0x35e9, 0x3604, 0x361e, 0x3638, 0x3653, 0x366d, 0x3693,
	0x36ac, 0x36c5, 0x36dd, 0x36f6, 0x370e, 0x3727, 0x373f, 0x3758,
	// Entry 16C0 - 16FF
	0x3771, 0x378a, 0x37a4, 0x37bd, 0x37d6, 0x37f0, 0x380a, 0x3823,
	0x383d, 0x3858, 0x3872, 0x388c, 0x38a6, 0x38c0, 0x38da, 0x38f1,
	0x3908, 0x391e, 0x3933, 0x3948, 0x395f, 0x3975, 0x398b, 0x39a0,
	0x39b7, 0x39ce, 0x39e4, 0x39fe, 0x3a12, 0x3a27, 0x3a3e, 0x3a54,
	0x3a69, 0x3a7e, 0x3a94, 0x3aaa, 0x3ac5, 0x3adf, 0x3af9, 0x3b14,
	0x3b29, 0x3b43, 0x3b5c, 0x3b75, 0x3b8f, 0x3ba9, 0x3bbf, 0x3bd4,
	0x3be8, 0x3bfc, 0x3c11, 0x3c26, 0x3c40, 0x3c59, 0x3c72, 0x3c8c,
	0x3ca0, 0x3cb9, 0x3cd1, 0x3ce9, 0x3d02, 0x3d1b, 0x3d2d, 0x3d3f,
	// Entry 1700 - 173F
	0x3d52, 0x3d66, 0x3d78, 0x3d8a, 0x3d9c, 0x3daf, 0x3dc1, 0x3dd3,
	0x3de5, 0x3df8, 0x3e0a, 0x3e1c, 0x3e2f, 0x3e43, 0x3e55, 0x3e67,
	0x3e79, 0x3e8b, 0x3e9d, 0x3eae, 0x3ec0, 0x3ed5, 0x3eea, 0x3eff,
	0x3f14, 0x3f2a, 0x3f3a, 0x3f51, 0x3f68, 0x3f80, 0x3f98, 0x3fae,
	0x3fc5, 0x3fdc, 0x3fef, 0x4006, 0x401e, 0x4034, 0x404a, 0x4061,
	0x4074, 0x4088, 0x40a2, 0x40b4, 0x40cd, 0x40e1, 0x40f8, 0x4110,
	0x4126, 0x413d, 0x414f, 0x4161, 0x4178, 0x4190, 0x41a7, 0x41bd,
	0x41d3, 0x41ea, 0x41fc, 0x4212, 0x4229, 0x423b, 0x424e, 0x4260,
	// Entry 1740 - 177F
	0x4273, 0x4285, 0x429d, 0x42b5, 0x42cc, 0x42e3, 0x42f6, 0x4307,
	0x431d, 0x432e, 0x4340, 0x4351, 0x4363, 0x4375, 0x4387, 0x439a,
	0x43b2, 0x43d3, 0x43f4, 0x4417, 0x4431, 0x4452, 0x4470, 0x449c,
	0x44b6, 0x44d0, 0x44ea, 0x44fd, 0x4512, 0x452d, 0x4543, 0x455e,
	0x4573, 0x4589, 0x459f, 0x45b6, 0x45cb, 0x45e1, 0x45f6, 0x4612,
	0x4628, 0x463d, 0x4653, 0x4669, 0x467f, 0x469a, 0x46b6, 0x46cc,
	0x46e0, 0x46f4, 0x470e, 0x4728, 0x4742, 0x4757, 0x476c, 0x4789,
	0x47ad, 0x47c5, 0x47dc, 0x47f3, 0x480c, 0x4824, 0x483c, 0x4853,
	// Entry 1780 - 17BF
	0x486c, 0x4885, 0x489d, 0x48b5, 0x48cc, 0x48e3, 0x48fc, 0x4914,
	0x492c, 0x4943, 0x495c, 0x4975, 0x498d, 0x49a0, 0x49b7, 0x49ca,
	0x49dc, 0x49ed, 0x4a01, 0x4a24, 0x4a3b, 0x4a4d, 0x4a62, 0x4a77,
	0x4a8f, 0x4aa1, 0x4ab4, 0x4ad7, 0x4aef, 0x4b01, 0x4b1a, 0x4b2e,
	0x4b41, 0x4b5c, 0x4b75, 0x4b95, 0x4bc0, 0x4bec, 0x4c07, 0x4c29,
	0x4c44, 0x4c61, 0x4c85, 0x4cb0, 0x4cd5, 0x4cfc, 0x4d21, 0x4d48,
	0x4d67, 0x4d82, 0x4da6, 0x4dbf, 0x4ddf, 0x4dff, 0x4e1c, 0x4e42,
	0x4e68, 0x4e8e, 0x4ea5, 0x4ebd, 0x4ed0, 0x4ee4, 0x4ef7, 0x4f0c,
	// Entry 17C0 - 17FF
	0x4f28, 0x4f3d, 0x4f59, 0x4f6e, 0x4f8a, 0x4fa1, 0x4fbf, 0x4fd7,
	0x4ff6, 0x500b, 0x5021, 0x5036, 0x5052, 0x5064, 0x5080, 0x5092,
	0x50a9, 0x50bc, 0x50ce, 0x50e5, 0x50f7, 0x510e, 0x5121, 0x5139,
	0x515b, 0x517d, 0x519f, 0x51b8, 0x51ca, 0x51e1, 0x51f3, 0x520a,
	0x521c, 0x522e, 0x5246, 0x5258, 0x5272, 0x5284, 0x5296, 0x52a8,
	0x52ba, 0x52cc, 0x52e3, 0x52fa, 0x530c, 0x531e, 0x5333, 0x534d,
	0x5364, 0x5380, 0x5398, 0x53b5, 0x53d0, 0x53f2, 0x540e, 0x5431,
	0x544b, 0x546a, 0x548b, 0x54b1, 0x54ca, 0x54ea, 0x54fc, 0x5515,
	// Entry 1800 - 183F
	0x552f, 0x5549, 0x5561, 0x5579, 0x5592, 0x55ae, 0x55ca, 0x55dd,
	0x55ef, 0x5601, 0x5615, 0x5628, 0x563b, 0x564d, 0x5661, 0x5675,
	0x5688, 0x5696, 0x56a5, 0x56b3, 0x56cb, 0x56de, 0x56f4, 0x5705,
	0x5721, 0x573d, 0x5759, 0x5775, 0x5798, 0x57b4, 0x57d1, 0x57ee,
	0x580b, 0x582c, 0x5853, 0x587a, 0x58a2, 0x58ca, 0x58f3, 0x5928,
	0x595d, 0x5984, 0x59aa, 0x59d5, 0x5a00, 0x5a2d, 0x5a5a, 0x5a85,
	0x5ab0, 0x5add, 0x5b0a, 0x5b35, 0x5b4b, 0x5b62, 0x5b79, 0x5b91,
	0x5ba9, 0x5bbb, 0x5bcd, 0x5bdf, 0x5bf2, 0x5c04, 0x5c16, 0x5c29,
	// Entry 1840 - 187F
	0x5c3c, 0x5c4f, 0x5c62, 0x5c76, 0x5c89, 0x5c9c, 0x5caf, 0x5cc3,
	0x5cd6, 0x5ce9, 0x5cfc, 0x5d0f, 0x5d22, 0x5d35, 0x5d48, 0x5d5b,
	0x5d6e, 0x5d81, 0x5d94, 0x5da7, 0x5dba, 0x5dcd, 0x5de0, 0x5e02,
	0x5e23, 0x5e43, 0x5e60, 0x5e7c, 0x5e9b, 0x5eb8, 0x5ed4, 0x5ef3,
	0x5f09, 0x5f1e, 0x5f42, 0x5f66, 0x5f7a, 0x5f8e, 0x5fa2, 0x5fb5,
	0x5fc8, 0x5fdd, 0x5ff1, 0x6005, 0x6018, 0x602d, 0x6042, 0x6056,
	0x6068, 0x607c, 0x6090, 0x60a4, 0x60bc, 0x60d4, 0x60e2, 0x60fb,
	0x610a, 0x6124, 0x613e, 0x614d, 0x6161, 0x6170, 0x618a, 0x6199,
	// Entry 1880 - 18BF
	0x61b3, 0x61c2, 0x61dc, 0x61f2, 0x6201, 0x621b, 0x622a, 0x6239,
	0x6248, 0x6262, 0x6271, 0x628b, 0x62a3, 0x62bb, 0x62ca, 0x62e4,
	0x62fe, 0x630d, 0x6327, 0x6337, 0x6346, 0x6360, 0x6370, 0x637f,
	0x638f, 0x639f, 0x63ad, 0x63bb, 0x63cb, 0x63dd, 0x63f6, 0x6409,
	0x641b, 0x6432, 0x6444, 0x645b, 0x646d, 0x6491, 0x64a8, 0x64be,
	0x64cc, 0x64dc, 0x64f7, 0x6514, 0x652c, 0x6547, 0x6557, 0x6568,
	0x6579, 0x6589, 0x659a, 0x65ab, 0x65bb, 0x65cc, 0x65dc, 0x65ed,
	0x65fd, 0x660e, 0x661e, 0x662e, 0x663e, 0x664f, 0x6660, 0x6670,
	// Entry 18C0 - 18FF
	0x6681, 0x6691, 0x66a2, 0x66b2, 0x66c3, 0x66d4, 0x66e6, 0x66f7,
	0x6707, 0x6717, 0x6727, 0x6737, 0x6748, 0x6758, 0x6768, 0x6779,
	0x6789, 0x6798, 0x67b2, 0x67cc, 0x67e0, 0x67f3, 0x6806, 0x681a,
	0x682d, 0x6841, 0x6854, 0x686b, 0x6882, 0x6899, 0x68b0, 0x68c7,
	0x68de, 0x68f5, 0x6912, 0x692c, 0x693b, 0x694c, 0x6965, 0x698a,
	0x69a3, 0x69c3, 0x69dc, 0x69ed, 0x69fd, 0x6a0d, 0x6a1f, 0x6a30,
	0x6a41, 0x6a51, 0x6a63, 0x6a75, 0x6a86, 0x6a97, 0x6aa9, 0x6aba,
	0x6acd, 0x6adf, 0x6af1, 0x6b05, 0x6b18, 0x6b2b, 0x6b3d, 0x6b51,
	// Entry 1900 - 193F
	0x6b65, 0x6b78, 0x6b8a, 0x6b9c, 0x6bae, 0x6bc1, 0x6bd3, 0x6be6,
	0x6bf9, 0x6c0c, 0x6c1f, 0x6c32, 0x6c44, 0x6c56, 0x6c68, 0x6c7b,
	0x6c8d, 0x6c9f, 0x6cb1, 0x6cc3, 0x6cd6, 0x6ce8, 0x6cfa, 0x6d0c,
	0x6d1f, 0x6d31, 0x6d44, 0x6d56, 0x6d69, 0x6d7b, 0x6d8d, 0x6d9f,
	0x6db2, 0x6dcb, 0x6de7, 0x6df5, 0x6e06, 0x6e13, 0x6e2e, 0x6e50,
	0x6e70, 0x6e94, 0x6eb2, 0x6ecf, 0x6eec, 0x6f11, 0x6f35, 0x6f53,
	0x6f75, 0x6f98, 0x6fbc, 0x6fe0, 0x7004, 0x7027, 0x704b, 0x706f,
	0x7093, 0x70b6, 0x70da, 0x70fe, 0x7122, 0x7146, 0x7169, 0x718d,
	// Entry 1940 - 197F
	0x71b2, 0x71d6, 0x71fa, 0x721e, 0x7241, 0x7266, 0x728b, 0x72b0,
	0x72d4, 0x72f9, 0x731e, 0x7342, 0x7366, 0x738a, 0x73af, 0x73d3,
	0x73f8, 0x741c, 0x743f, 0x7463, 0x7486, 0x74aa, 0x74ce, 0x74f1,
	0x7514, 0x753a, 0x7565, 0x7589, 0x75ad, 0x75d7, 0x7603, 0x7624,
	0x7648, 0x766b, 0x768c, 0x76b3, 0x76d9, 0x76ff, 0x7725, 0x7738,
	0x7748, 0x775a, 0x776e, 0x7793, 0x77c7, 0x77f0, 0x7821, 0x7838,
	0x7873, 0x788c, 0x78a5, 0x78c0, 0x78d4, 0x78ed, 0x7908, 0x7938,
	0x7963, 0x797d, 0x7996, 0x79b8, 0x79d3, 0x79f7, 0x7a1a, 0x7a3f,
	// Entry 1980 - 19BF
	0x7a5f, 0x7a7f, 0x7a9e, 0x7ac7, 0x7ad8, 0x7af9, 0x7b11, 0x7b30,
	0x7b52, 0x7b69, 0x7b88, 0x7b9f, 0x7bb5, 0x7bcb, 0x7bde, 0x7bf3,
	0x7c0f, 0x7c36, 0x7c52, 0x7c6f, 0x7c8b, 0x7cae, 0x7cca, 0x7ce6,
	0x7d04, 0x7d20, 0x7d40, 0x7d5b, 0x7d77, 0x7d93, 0x7dbb, 0x7dd7,
	0x7dfc, 0x7e18, 0x7e39, 0x7e56, 0x7e78, 0x7ea1, 0x7ebd, 0x7eda,
	0x7ef7, 0x7f17, 0x7f33, 0x7f58, 0x7f7b, 0x7f97, 0x7fb3, 0x7fd0,
	0x7ff9, 0x801d, 0x8039, 0x8055, 0x8071, 0x808f, 0x80b4, 0x80c4,
	0x80e4, 0x8104, 0x8121, 0x813f, 0x815d, 0x817d, 0x8196, 0x81b0,
	// Entry 19C0 - 19FF
	0x81c9, 0x81e9, 0x8202, 0x821b, 0x823d, 0x8256, 0x826f, 0x8288,
	0x82a1, 0x82ba, 0x82d3, 0x82ec, 0x8305, 0x8327, 0x8340, 0x835a,
	0x8373, 0x838c, 0x83a5, 0x83be, 0x83d7, 0x83ee, 0x840c, 0x8427,
	0x8446, 0x845d, 0x8474, 0x848b, 0x84a6, 0x84c2, 0x84e5, 0x84fc,
	0x851a, 0x8531, 0x8548, 0x8561, 0x8578, 0x8594, 0x85b4, 0x85d7,
	0x85ee, 0x8605, 0x861c, 0x863c, 0x865a, 0x8671, 0x868a, 0x86a4,
	0x86c5, 0x86e0, 0x86ff, 0x8718, 0x8736, 0x8754, 0x8772, 0x8790,
	0x87b1, 0x87d3, 0x87f3, 0x8813, 0x8833, 0x8848, 0x886e, 0x8894,
	// Entry 1A00 - 1A3F
	0x88ba, 0x88e0, 0x8906, 0x892c, 0x8952, 0x8985, 0x89ab, 0x89d1,
	0x89f7, 0x8a12, 0x8a2d, 0x8a49, 0x8a71, 0x8a99, 0x8abc, 0x8adc,
	0x8b04, 0x8b2a, 0x8b50, 0x8b76, 0x8b9c, 0x8bc2, 0x8be8, 0x8c0e,
	0x8c34, 0x8c5a, 0x8c80, 0x8ca6, 0x8ccc, 0x8cf4, 0x8d1a, 0x8d40,
	0x8d66, 0x8d8e, 0x8dba, 0x8de1, 0x8e09, 0x8e36, 0x8e6c, 0x8e98,
	0x8ec0, 0x8eed, 0x8f17, 0x8f3f, 0x8f69, 0x8f8b, 0x8fa2, 0x8fc3,
	0x8fdc, 0x9001, 0x9018, 0x9043, 0x9061, 0x907f, 0x90a2, 0x90bc,
	0x90db, 0x9106, 0x912f, 0x915a, 0x9183, 0x91a2, 0x91c3, 0x91ef,
	// Entry 1A40 - 1A7F
	0x9215, 0x9240, 0x925f, 0x927d, 0x9296, 0x92b7, 0x92d0, 0x92f9,
	0x9314, 0x9331, 0x9350, 0x9371, 0x938f, 0x93a6, 0x93d1, 0x93f2,
	0x940b, 0x9426, 0x9443, 0x9460, 0x9475, 0x948e, 0x94a4, 0x94ba,
	0x94d0, 0x94e6, 0x9501, 0x951c, 0x9540, 0x9556, 0x956c, 0x958d,
	0x95a3, 0x95b9, 0x95cb, 0x95dd, 0x95ef, 0x9622, 0x9641, 0x9660,
	0x967f, 0x96a5, 0x96cb, 0x96eb, 0x9709, 0x972f, 0x974d, 0x976b,
	0x9791, 0x97b7, 0x97d5, 0x97fb, 0x9821, 0x9847, 0x9865, 0x9888,
	0x98a6, 0x98c8, 0x98e6, 0x9907, 0x9929, 0x9947, 0x997e, 0x99bd,
	// Entry 1A80 - 1ABF
	0x99db, 0x99fb, 0x9a3a, 0x9a58, 0x9a85, 0x9ab2, 0x9adf, 0x9af6,
	0x9b12, 0x9b2d, 0x9b45, 0x9b69, 0x9b81, 0x9b98, 0x9bbd, 0x9bdc,
	0x9bfa, 0x9c2c, 0x9c52, 0x9c76, 0x9c9b, 0x9cbe, 0x9ce3, 0x9d06,
	0x9d2c, 0x9d50, 0x9d7d, 0x9da8, 0x9dcd, 0x9df0, 0x9e15, 0x9e38,
	0x9e5e, 0x9e82, 0x9ea5, 0x9ec6, 0x9ef2, 0x9f1c, 0x9f48, 0x9f72,
	0x9f9e, 0x9fc8, 0x9ff4, 0xa01e, 0xa045, 0xa06a, 0xa097, 0xa0c2,
	0xa0e7, 0xa10a, 0xa12c, 0xa14c, 0xa171, 0xa194, 0xa1b9, 0xa1dc,
	0xa201, 0xa224, 0xa247, 0xa268, 0xa28f, 0xa2b4, 0xa2db, 0xa300,
	// Entry 1AC0 - 1AFF
	0xa32f, 0xa35c, 0xa37d, 0xa39c, 0xa3c1, 0xa3e4, 0xa40a, 0xa42e,
	0xa453, 0xa476, 0xa4a6, 0xa4d4, 0xa4fa, 0xa51e, 0xa54a, 0xa574,
	0xa595, 0xa5b4, 0xa5d9, 0xa5fc, 0xa621, 0xa644, 0xa669, 0xa68c,
	0xa6b1, 0xa6d4, 0xa6fa, 0xa71e, 0xa74a, 0xa774, 0xa79f, 0xa7c8,
	0xa7f7, 0xa824, 0xa850, 0xa87a, 0xa8a6, 0xa8d0, 0xa8f1, 0xa910,
	0xa935, 0xa958, 0xa97d, 0xa9a0, 0xa9c5, 0xa9e8, 0xaa18, 0xaa46,
	0xaa6c, 0xaa90, 0xaab5, 0xaad8, 0xaafd, 0xab20, 0xab4f, 0xab7c,
	0xabab, 0xabd8, 0xac0b, 0xac3c, 0xac61, 0xac84, 0xaca9, 0xaccc,
	// Entry 1B00 - 1B3F
	0xacf2, 0xad16, 0xad42, 0xad6c, 0xad97, 0xadc0, 0xade7, 0xae0c,
	0xae38, 0xae62, 0xae8d, 0xaeb6, 0xaee6, 0xaf14, 0xaf35, 0xaf54,
	0xaf79, 0xaf9c, 0xafbd, 0xafdc, 0xaffd, 0xb01c, 0xb041, 0xb064,
	0xb089, 0xb0ac, 0xb0d1, 0xb0f4, 0xb119, 0xb13c, 0xb161, 0xb184,
	0xb1a9, 0xb1cc, 0xb1f2, 0xb216, 0xb23b, 0xb25e, 0xb284, 0xb2a8,
	0xb2cc, 0xb2ef, 0xb313, 0xb337, 0xb360, 0xb388, 0xb3b6, 0xb3e0,
	0xb3fc, 0xb414, 0xb439, 0xb45c, 0xb482, 0xb4a6, 0xb4d6, 0xb504,
	0xb534, 0xb562, 0xb597, 0xb5ca, 0xb5fa, 0xb628, 0xb65c, 0xb68e,
	// Entry 1B40 - 1B7F
	0xb6b9, 0xb6e2, 0xb70d, 0xb736, 0xb766, 0xb794, 0xb7bf, 0xb7e8,
	0xb817, 0xb844, 0xb869, 0xb88c, 0xb8b2, 0xb8d6, 0xb8f7, 0xb916,
	0xb946, 0xb974, 0xb9a4, 0xb9d2, 0xba07, 0xba3a, 0xba6a, 0xba98,
	0xbacc, 0xbafe, 0xbb24, 0xbb48, 0xbb6d, 0xbb90, 0xbbb5, 0xbbd8,
	0xbbfe, 0xbc22, 0xbc52, 0xbc80, 0xbcb0, 0xbcde, 0xbd13, 0xbd46,
	0xbd76, 0xbda4, 0xbdd8, 0xbe0a, 0xbe34, 0xbe5c, 0xbe86, 0xbeae,
	0xbedd, 0xbf0a, 0xbf34, 0xbf5c, 0xbf8a, 0xbfb6, 0xbfdb, 0xbffe,
	0xc024, 0xc048, 0xc072, 0xc09a, 0xc0c4, 0xc0ec, 0xc11b, 0xc148,
	// Entry 1B80 - 1BBF
	0xc172, 0xc19a, 0xc1c8, 0xc1f4, 0xc215, 0xc234, 0xc259, 0xc27c,
	0xc2a2, 0xc2c6, 0xc2e7, 0xc306, 0xc32a, 0xc34c, 0xc36f, 0xc390,
	0xc3b0, 0xc3ce, 0xc3f1, 0xc414, 0xc441, 0xc46e, 0xc49a, 0xc4c6,
	0xc4f9, 0xc52c, 0xc551, 0xc576, 0xc5a5, 0xc5d4, 0xc602, 0xc630,
	0xc665, 0xc69a, 0xc6bf, 0xc6e4, 0xc713, 0xc742, 0xc770, 0xc79e,
	0xc7c5, 0xc7ec, 0xc81d, 0xc84e, 0xc87e, 0xc8ae, 0xc8cf, 0xc8f0,
	0xc91b, 0xc946, 0xc970, 0xc99a, 0xc9cb, 0xc9fc, 0xca1f, 0xca42,
	0xca6f, 0xca9c, 0xcac8, 0xcaf4, 0xcb27, 0xcb5a, 0xcb7c, 0xcb9e,
	// Entry 1BC0 - 1BFF
	0xcbca, 0xcbf6, 0xcc21, 0xcc4c, 0xcc7e, 0xccb0, 0xccd4, 0xccf8,
	0xcd26, 0xcd54, 0xcd81, 0xcdae, 0xcde2, 0xce16, 0xce3b, 0xce60,
	0xce8f, 0xcebe, 0xceec, 0xcf1a, 0xcf41, 0xcf68, 0xcf99, 0xcfca,
	0xcffa, 0xd02a, 0xd04f, 0xd074, 0xd0a3, 0xd0d2, 0xd100, 0xd12e,
	0xd163, 0xd198, 0xd1bf, 0xd1f0, 0xd220, 0xd257, 0xd27a, 0xd29d,
	0xd2ca, 0xd2f7, 0xd323, 0xd34f, 0xd382, 0xd3b5, 0xd3da, 0xd3ff,
	0xd42e, 0xd45d, 0xd48b, 0xd4b9, 0xd4ee, 0xd523, 0xd546, 0xd568,
	0xd58d, 0xd5b1, 0xd5d2, 0xd5f2, 0xd614, 0xd635, 0xd65a, 0xd67e,
	// Entry 1C00 - 1C3F
	0xd6a3, 0xd6c7, 0xd6ea, 0xd70c, 0xd741, 0xd776, 0xd7b5, 0xd7f4,
	0xd832, 0xd870, 0xd8b5, 0xd8fa, 0xd932, 0xd96a, 0xd9ac, 0xd9ee,
	0xda2f, 0xda70, 0xdab8, 0xdb00, 0xdb33, 0xdb66, 0xdba3, 0xdbe0,
	0xdc1c, 0xdc58, 0xdc9b, 0xdcde, 0xdd14, 0xdd4a, 0xdd8a, 0xddca,
	0xde09, 0xde48, 0xde8e, 0xded4, 0xdf09, 0xdf3e, 0xdf7d, 0xdfbc,
	0xdffa, 0xe038, 0xe07d, 0xe0c2, 0xe0fa, 0xe132, 0xe174, 0xe1b6,
	0xe1f7, 0xe238, 0xe280, 0xe2c8, 0xe2ec, 0xe310, 0xe345, 0xe370,
	0xe3a4, 0xe3cd, 0xe408, 0xe42e, 0xe454, 0xe479, 0xe49d, 0xe4cb,
	// Entry 1C40 - 1C7F
	0xe4d8, 0xe4ec, 0xe4f7, 0xe508, 0xe527, 0xe55a, 0xe583, 0xe5b5,
	0xe5dc, 0xe615, 0xe63c, 0xe662, 0xe685, 0xe6a7, 0xe6d3, 0xe6e8,
	0xe6fc, 0xe717, 0xe73a, 0xe75d, 0xe78d, 0xe7bc, 0xe7e4, 0xe81a,
	0xe83f, 0xe864, 0xe888, 0xe8ab, 0xe8c0, 0xe8d4, 0xe8ef, 0xe915,
	0xe93b, 0xe96e, 0xe9a0, 0xe9c1, 0xe9e2, 0xea0d, 0xea46, 0xea6e,
	0xea96, 0xeabd, 0xeae3, 0xeb06, 0xeb1f, 0xeb37, 0xeb42, 0xeb77,
	0xeba2, 0xebd6, 0xebff, 0xec3a, 0xec61, 0xec87, 0xecac, 0xecd0,
	0xecfe, 0xed08, 0xed13, 0xed1a, 0xed21, 0xed29, 0xed31, 0xed43,
	// Entry 1C80 - 1CBF
	0xed54, 0xed64, 0xed70, 0xed81, 0xed8b, 0xed95, 0xeda5, 0xedba,
	0xedcb, 0xeddd, 0xedef, 0xedf5, 0xee08, 0xee13, 0xee1a, 0xee21,
	0xee2f, 0xee43, 0xee52, 0xee6c, 0xee87, 0xeea2, 0xeec7, 0xeee1,
	0xeefc, 0xef17, 0xef3c, 0xef42, 0xef4f, 0xef55, 0xef66, 0xef74,
	0xef82, 0xef95, 0xefa6, 0xefb4, 0xefc7, 0xefde, 0xeff5, 0xf00f,
	0xf025, 0xf03b, 0xf050, 0xf05e, 0xf073, 0xf078, 0xf084, 0xf090,
	0xf09e, 0xf0b3, 0xf0c8, 0xf0cd, 0xf0f6, 0xf120, 0xf12e, 0xf145,
	0xf150, 0xf158, 0xf160, 0xf16d, 0xf182, 0xf18a, 0xf197, 0xf1a5,
	// Entry 1CC0 - 1CFF
	0xf1c3, 0xf1e2, 0xf1f6, 0xf20f, 0xf228, 0xf238, 0xf24d, 0xf263,
	0xf27a, 0xf286, 0xf298, 0xf2a0, 0xf2c0, 0xf2d5, 0xf2df, 0xf2f0,
	0xf307, 0xf31c, 0xf32b, 0xf33f, 0xf353, 0xf366, 0xf373, 0xf37f,
	0xf387, 0xf399, 0xf3b2, 0xf3bd, 0xf3d1, 0xf3e0, 0xf3f3, 0xf401,
	0xf416, 0xf42b, 0xf43f, 0xf456, 0xf470, 0xf48b, 0xf4a6, 0xf4c2,
	0xf4d7, 0xf4eb, 0xf4fb, 0xf51b, 0xf52b, 0xf53b, 0xf54a, 0xf55b,
	0xf56c, 0xf57c, 0xf591, 0xf5a2, 0xf5b9, 0xf5d5, 0xf5f2, 0xf612,
	0xf620, 0xf62d, 0xf63a, 0xf649, 0xf657, 0xf665, 0xf672, 0xf681,
	// Entry 1D00 - 1D3F
	0xf690, 0xf69e, 0xf6b1, 0xf6c0, 0xf6d5, 0xf6ef, 0xf70a, 0xf728,
	0xf746, 0xf764, 0xf782, 0xf7a4, 0xf7c2, 0xf7e0, 0xf7fe, 0xf81c,
	0xf83a, 0xf858, 0xf876, 0xf894, 0xf8a6, 0xf8b0, 0xf8bd, 0xf8ce,
	0xf8d7, 0xf8e0, 0xf8ea, 0xf8f5, 0xf8ff, 0xf907, 0xf916, 0xf91f,
	0xf928, 0xf930, 0xf93b, 0xf947, 0xf958, 0xf961, 0xf96d, 0xf979,
	0xf985, 0xf98e, 0xf9a1, 0xf9ae, 0xf9b8, 0xf9c9, 0xf9da, 0xf9ea,
	0xf9f4, 0xf9fe, 0xfa07, 0xfa13, 0xfa1b, 0xfa37, 0xfa54, 0xfa78,
	0xfa9d, 0xfac0, 0xfadf, 0xfaf9, 0xfb14, 0xfb2a, 0xfb4a, 0xfb6e,
	// Entry 1D40 - 1D7F
	0xfb88, 0xfba1, 0xfbbb, 0xfbd5, 0xfbf0, 0xfc14, 0xfc34, 0xfc4e,
	0xfc68, 0xfc94, 0xfcb5, 0xfcdd, 0xfcf5, 0xfd0e, 0xfd29, 0xfd4a,
	0xfd6f, 0xfd9f, 0xfdce, 0xfde8, 0xfe03, 0xfe1b, 0xfe25, 0xfe3d,
	0xfe54, 0xfe62, 0xfe74, 0xfe7b, 0xfe83, 0xfe91, 0xfe98, 0xfea9,
	0xfeb7, 0xfec7, 0xfedd, 0xfef4, 0xff03, 0xff1e, 0xff2e, 0xff44,
	0xff54, 0xff62, 0xff70, 0xff87, 0xff92, 0xffab, 0xffbb, 0xffd2,
	0xffe9, 0xfff9, 0x000f, 0x0026, 0x0037, 0x003f, 0x004b, 0x0059,
	0x0068, 0x0070, 0x0087, 0x0091, 0x0099, 0x00aa, 0x00c0, 0x00de,
	// Entry 1D80 - 1DBF
	0x00e9, 0x00f6, 0x0106, 0x011c, 0x012c, 0x013a, 0x014a, 0x015a,
	0x016a, 0x017a, 0x0188, 0x0193, 0x019d, 0x01a9, 0x01b5, 0x01c7,
	0x01d8, 0x01e6, 0x01fc, 0x0215, 0x0230, 0x0248, 0x0265, 0x0280,
	0x029b, 0x02b8, 0x02d3, 0x02f1, 0x030d, 0x0329, 0x0345, 0x0361,
	0x036e, 0x037e, 0x0386, 0x0392, 0x03a0, 0x03bb, 0x03d6, 0x03ef,
	0x0408, 0x0421, 0x043b, 0x0454, 0x046e, 0x048a, 0x04a5, 0x04be,
	0x04d9, 0x04f3, 0x0510, 0x052c, 0x0549, 0x055f, 0x0570, 0x0581,
	0x0594, 0x05a6, 0x05b8, 0x05c9, 0x05dc, 0x05ef, 0x0601, 0x0612,
	// Entry 1DC0 - 1DFF
	0x0626, 0x063a, 0x064d, 0x0666, 0x0680, 0x069a, 0x06b1, 0x06c8,
	0x06e1, 0x06f9, 0x0711, 0x0728, 0x0741, 0x075a, 0x0772, 0x0789,
	0x07a3, 0x07bd, 0x07d6, 0x07f5, 0x0815, 0x0835, 0x0853, 0x086e,
	0x0888, 0x08aa, 0x08c7, 0x08e2, 0x0900, 0x091c, 0x093e, 0x0959,
	0x0969, 0x097b, 0x098a, 0x0997, 0x09a7, 0x09b6, 0x09c6, 0x09d3,
	0x09e3, 0x09f3, 0x0a03, 0x0a13, 0x0a2e, 0x0a4a, 0x0a5e, 0x0a73,
	0x0a8d, 0x0aa5, 0x0ac0, 0x0ada, 0x0af3, 0x0b0d, 0x0b25, 0x0b3b,
	0x0b54, 0x0b6c, 0x0b83, 0x0b9c, 0x0bb6, 0x0bcf, 0x0be9, 0x0bfe,
	// Entry 1E00 - 1E3F
	0x0c1a, 0x0c30, 0x0c50, 0x0c71, 0x0c93, 0x0cb6, 0x0cdc, 0x0d01,
	0x0d23, 0x0d41, 0x0d5d, 0x0d90, 0x0daf, 0x0dca, 0x0ded, 0x0e12,
	0x0e36, 0x0e59, 0x0e7d, 0x0ea3, 0x0ec9, 0x0eee, 0x0f13, 0x0f3d,
	0x0f62, 0x0f79, 0x0f8e, 0x0fa6, 0x0fbd, 0x0fe6, 0x100f, 0x1031,
	0x1054, 0x1077, 0x108d, 0x10a1, 0x10b8, 0x10ce, 0x10e5, 0x10f9,
	0x1110, 0x1127, 0x113e, 0x1155, 0x116b, 0x1182, 0x119a, 0x11b3,
	0x11d3, 0x11f5, 0x120b, 0x121f, 0x1236, 0x124c, 0x1262, 0x1279,
	0x128e, 0x12a1, 0x12b7, 0x12cc, 0x12e8, 0x1307, 0x133a, 0x136b,
	// Entry 1E40 - 1E7F
	0x1385, 0x13ab, 0x13cb, 0x13e5, 0x13ff, 0x1412, 0x142f, 0x1459,
	0x1470, 0x1494, 0x14b9, 0x14de, 0x1509, 0x1535, 0x1561, 0x157c,
	0x1598, 0x15b4, 0x15bb, 0x15c5, 0x15d9, 0x15e5, 0x15f9, 0x1602,
	0x160b, 0x1610, 0x161a, 0x162b, 0x163b, 0x164d, 0x1667, 0x167f,
	0x168b, 0x1698, 0x16a7, 0x16b6, 0x16c0, 0x16d2, 0x16da, 0x16e8,
	0x16f1, 0x1702, 0x170f, 0x171e, 0x1729, 0x1732, 0x173d, 0x174c,
	0x1754, 0x175f, 0x1764, 0x1772, 0x1781, 0x1788, 0x1797, 0x17a2,
	0x17b1, 0x17bc, 0x17c6, 0x17d2, 0x17d7, 0x17df, 0x17ee, 0x17fd,
	// Entry 1E80 - 1EBF
	0x180d, 0x181d, 0x182c, 0x183e, 0x1858, 0x1876, 0x187f, 0x1886,
	0x188b, 0x1895, 0x189e, 0x18a4, 0x18b8, 0x18c2, 0x18d0, 0x18de,
	0x18ed, 0x18f6, 0x1904, 0x190d, 0x1918, 0x192f, 0x194a, 0x1960,
	0x1987, 0x19b2, 0x19c1, 0x19d4, 0x19ec, 0x19f8, 0x1a04, 0x1a11,
	0x1a2c, 0x1a3e, 0x1a52, 0x1a68, 0x1a8e, 0x1ab0, 0x1abc, 0x1ac8,
	0x1ad8, 0x1ae5, 0x1af3, 0x1afc, 0x1b0a, 0x1b15, 0x1b23, 0x1b39,
	0x1b44, 0x1b57, 0x1b63, 0x1b6f, 0x1b7f, 0x1b95, 0x1baa, 0x1bc2,
	0x1bd9, 0x1bf3, 0x1c0d, 0x1c2a, 0x1c38, 0x1c49, 0x1c50, 0x1c61,
	// Entry 1EC0 - 1EFF
	0x1c6e, 0x1c7e, 0x1c9c, 0x1cbd, 0x1cd7, 0x1cf4, 0x1d17, 0x1d3d,
	0x1d56, 0x1d6f, 0x1d91, 0x1db3, 0x1dbb, 0x1dc3, 0x1dd7, 0x1deb,
	0x1e04, 0x1e1d, 0x1e2d, 0x1e3d, 0x1e46, 0x1e51, 0x1e60, 0x1e71,
	0x1e86, 0x1e9d, 0x1ebd, 0x1edf, 0x1efa, 0x1f17, 0x1f1f, 0x1f36,
	0x1f44, 0x1f53, 0x1f65, 0x1f80, 0x1f9e, 0x1fa8, 0x1fb2, 0x1fbe,
	0x1fcb, 0x1fd8, 0x1fee, 0x2002, 0x2017, 0x2030, 0x203e, 0x204a,
	0x2056, 0x2063, 0x2070, 0x2084, 0x208e, 0x2097, 0x20a0, 0x20a7,
	0x20b0, 0x20b6, 0x20ba, 0x20c0, 0x20e3, 0x210d, 0x211b, 0x2123,
	// Entry 1F00 - 1F3F
	0x2131, 0x2163, 0x217a, 0x2191, 0x21a3, 0x21be, 0x21dc, 0x2203,
	0x220e, 0x2216, 0x221e, 0x2238, 0x2243, 0x2246, 0x224a, 0x224d,
	0x2261, 0x226f, 0x2280, 0x2290, 0x22a2, 0x22ad, 0x22bd, 0x22c9,
	0x22d6, 0x22e4, 0x22ea, 0x230f, 0x2335, 0x234c, 0x2364, 0x2379,
	0x2389, 0x239a, 0x23a7, 0x23b6, 0x23c9, 0x23d5, 0x23de, 0x23f3,
	0x2405, 0x241a, 0x242d, 0x2443, 0x2465, 0x2487, 0x249c, 0x24b4,
	0x24c8, 0x24dc, 0x24f5, 0x250e, 0x252d, 0x254f, 0x256e, 0x2590,
	0x25af, 0x25d1, 0x25ef, 0x260d, 0x2623, 0x2646, 0x2668, 0x2694,
	// Entry 1F40 - 1F7F
	0x26a5, 0x26c0, 0x26da, 0x26f6, 0x271c, 0x2754, 0x2792, 0x27ab,
	0x27c2, 0x27df, 0x27f7, 0x281d, 0x2841, 0x2877, 0x28b3, 0x28c8,
	0x28e3, 0x28fc, 0x2909, 0x2917, 0x291c, 0x2928, 0x2936, 0x2940,
	0x294b, 0x2954, 0x2960, 0x296d, 0x2977, 0x2982, 0x2993, 0x29a3,
	0x29b1, 0x29be, 0x29cf, 0x29dd, 0x29e0, 0x29e7, 0x29ed, 0x29ff,
	0x2a11, 0x2a20, 0x2a36, 0x2a45, 0x2a4a, 0x2a53, 0x2a62, 0x2a72,
	0x2a84, 0x2a97, 0x2aa8, 0x2abc, 0x2ac1, 0x2ac6, 0x2aee, 0x2af8,
	0x2b0a, 0x2b1e, 0x2b26, 0x2b41, 0x2b5d, 0x2b6e, 0x2b7a, 0x2b86,
	// Entry 1F80 - 1FBF
	0x2b98, 0x2ba0, 0x2bac, 0x2bbc, 0x2bc9, 0x2bce, 0x2bd9, 0x2be4,
	0x2c00, 0x2c21, 0x2c41, 0x2c62, 0x2c84, 0x2ca2, 0x2cc3, 0x2ce5,
	0x2d05, 0x2d24, 0x2d47, 0x2d67, 0x2d8b, 0x2daf, 0x2dd6, 0x2dfa,
	0x2e1f, 0x2e49, 0x2e74, 0x2e9a, 0x2ec2, 0x2ee3, 0x2f08, 0x2f28,
	0x2f4b, 0x2f6d, 0x2f95, 0x2fba, 0x2fd9, 0x2ffc, 0x301a, 0x303b,
	0x305f, 0x3089, 0x30ad, 0x30d1, 0x30f7, 0x3119, 0x313e, 0x315f,
	0x317f, 0x31a0, 0x31c0, 0x31e7, 0x320a, 0x322e, 0x3251, 0x3277,
	0x329c, 0x32c1, 0x32e6, 0x3312, 0x3331, 0x3350, 0x336b, 0x338c,
	// Entry 1FC0 - 1FFF
	0x33b4, 0x33d8, 0x33fb, 0x3421, 0x3445, 0x345f, 0x3478, 0x3493,
	0x34b7, 0x34dd, 0x3500, 0x3524, 0x353f, 0x354d, 0x3574, 0x3587,
	0x3592, 0x35af, 0x35bf, 0x35da, 0x35f8, 0x3607, 0x3619, 0x363f,
	0x364b, 0x3661, 0x366c, 0x368d, 0x36a2, 0x36c4, 0x36cf, 0x36e0,
	0x36f1, 0x3712, 0x3733, 0x3752, 0x376f, 0x378d, 0x37a5, 0x37bf,
	0x37db, 0x37e8, 0x37f1, 0x3804, 0x3817, 0x3832, 0x384c, 0x3867,
	0x3883, 0x389e, 0x38ba, 0x38da, 0x38f7, 0x3917, 0x3938, 0x3956,
	0x3977, 0x3994, 0x39b3, 0x39d0, 0x39e7, 0x3a05, 0x3a25, 0x3a43,
	// Entry 2000 - 203F
	0x3a55, 0x3a6e, 0x3a9d, 0x3acc, 0x3ad9, 0x3ae9, 0x3afb, 0x3b10,
	0x3b3d, 0x3b52, 0x3b68, 0x3b7f, 0x3b95, 0x3bab, 0x3bc1, 0x3bd7,
	0x3c04, 0x3c34, 0x3c5f, 0x3c95, 0x3cc9, 0x3cf6, 0x3d2e, 0x3d64,
	0x3d8c, 0x3dc0, 0x3df2, 0x3e1c, 0x3e44, 0x3e70, 0x3e9f, 0x3eaa,
	0x3eb7, 0x3ec3, 0x3eda, 0x3ee8, 0x3f00, 0x3f18, 0x3f35, 0x3f52,
	0x3f6c, 0x3f7c, 0x3f8e, 0x3fa0, 0x3fac, 0x3fb0, 0x3fbf, 0x3fd1,
	0x3fe2, 0x3ff6, 0x4010, 0x402d, 0x403c, 0x4054, 0x4060, 0x4068,
	0x4072, 0x4089, 0x40a0, 0x40c4, 0x40e7, 0x4108, 0x412b, 0x4161,
	// Entry 2040 - 207F
	0x4196, 0x41cc, 0x41d7, 0x41e0, 0x41eb, 0x4206, 0x4229, 0x424d,
	0x426e, 0x4291, 0x42a4, 0x42b9, 0x42d0, 0x42dc, 0x42ef, 0x42fe,
	0x4310, 0x4323, 0x4332, 0x434d, 0x4365, 0x437b, 0x4399, 0x43ab,
	0x43c1, 0x43d0, 0x43e4, 0x4404, 0x4418, 0x4436, 0x444a, 0x4464,
	0x4478, 0x448b, 0x44a6, 0x44c3, 0x44e0, 0x44ff, 0x451d, 0x453c,
	0x4557, 0x457b, 0x458c, 0x45a4, 0x45b9, 0x45ca, 0x45e3, 0x45fd,
	0x4618, 0x4631, 0x4641, 0x4652, 0x465e, 0x4666, 0x4678, 0x4692,
	0x46b0, 0x46b8, 0x46c1, 0x46c9, 0x46da, 0x46e9, 0x46f4, 0x4712,
	// Entry 2080 - 20BF
	0x4725, 0x472d, 0x4748, 0x475c, 0x476d, 0x477e, 0x4791, 0x47a3,
	0x47b5, 0x47c6, 0x47d9, 0x47ec, 0x47fe, 0x4810, 0x4825, 0x483a,
	0x4851, 0x4868, 0x487e, 0x4894, 0x48ac, 0x48c3, 0x48da, 0x48ef,
	0x4906, 0x491d, 0x4936, 0x494e, 0x4966, 0x497d, 0x4996, 0x49af,
	0x49c7, 0x49df, 0x49fa, 0x4a15, 0x4a32, 0x4a4f, 0x4a6b, 0x4a87,
	0x4aa5, 0x4ac2, 0x4adf, 0x4afa, 0x4b0d, 0x4b20, 0x4b35, 0x4b49,
	0x4b5d, 0x4b70, 0x4b85, 0x4b9a, 0x4bae, 0x4bc2, 0x4bd9, 0x4bf0,
	0x4c09, 0x4c22, 0x4c3a, 0x4c52, 0x4c6c, 0x4c85, 0x4c9e, 0x4cb5,
	// Entry 20C0 - 20FF
	0x4cd7, 0x4cf9, 0x4d1b, 0x4d3d, 0x4d5f, 0x4d81, 0x4da3, 0x4dc5,
	0x4de7, 0x4e09, 0x4e2b, 0x4e4d, 0x4e6f, 0x4e91, 0x4eb3, 0x4ed5,
	0x4ef7, 0x4f19, 0x4f3b, 0x4f5d, 0x4f7f, 0x4fa1, 0x4fc3, 0x4fe5,
	0x5007, 0x5029, 0x5047, 0x5065, 0x5083, 0x50a1, 0x50bf, 0x50dd,
	0x50fb, 0x5119, 0x5137, 0x5155, 0x5173, 0x5191, 0x51af, 0x51cd,
	0x51eb, 0x5209, 0x5227, 0x5245, 0x5263, 0x5281, 0x529f, 0x52bd,
	0x52db, 0x52f9, 0x5317, 0x5335, 0x5351, 0x536d, 0x5389, 0x53a5,
	0x53c1, 0x53dd, 0x53f9, 0x5415, 0x5431, 0x544d, 0x5469, 0x5485,
	// Entry 2100 - 213F
	0x54a1, 0x54bd, 0x54d9, 0x54f5, 0x5511, 0x552d, 0x5549, 0x5565,
	0x5581, 0x559d, 0x55b9, 0x55d5, 0x55f1, 0x560d, 0x561f, 0x563d,
	0x565b, 0x567b, 0x569b, 0x56ba, 0x56d9, 0x56fa, 0x571a, 0x573a,
	0x5758, 0x5770, 0x5788, 0x57a2, 0x57bb, 0x57d4, 0x57ec, 0x5806,
	0x5820, 0x5839, 0x5852, 0x586d, 0x588a, 0x58a7, 0x58c2, 0x58dd,
	0x5906, 0x592f, 0x5956, 0x597d, 0x59a9, 0x59d5, 0x59ff, 0x5a29,
	0x5a4a, 0x5a71, 0x5a98, 0x5ab9, 0x5ad9, 0x5aff, 0x5b25, 0x5b45,
	0x5b64, 0x5b89, 0x5bae, 0x5bcd, 0x5beb, 0x5c0f, 0x5c33, 0x5c51,
	// Entry 2140 - 217F
	0x5c76, 0x5ca1, 0x5ccb, 0x5cf5, 0x5d20, 0x5d4a, 0x5d74, 0x5d99,
	0x5dbd, 0x5de7, 0x5e10, 0x5e39, 0x5e63, 0x5e8c, 0x5eb5, 0x5ed9,
	0x5eff, 0x5f2b, 0x5f57, 0x5f83, 0x5faf, 0x5fdb, 0x6007, 0x602d,
	0x6051, 0x607b, 0x60a5, 0x60cf, 0x60f9, 0x6123, 0x614d, 0x6171,
	0x619b, 0x61cb, 0x61fb, 0x622b, 0x625a, 0x6289, 0x62b9, 0x62e8,
	0x6317, 0x6346, 0x6375, 0x63a4, 0x63d3, 0x6403, 0x6433, 0x645d,
	0x6486, 0x64af, 0x64d6, 0x64fd, 0x651b, 0x6537, 0x6560, 0x6589,
	0x65ab, 0x65d3, 0x65fb, 0x661c, 0x6643, 0x666a, 0x668a, 0x66b0,
	// Entry 2180 - 21BF
	0x66d6, 0x66f5, 0x6722, 0x674f, 0x6775, 0x67a1, 0x67cd, 0x67f2,
	0x6820, 0x684e, 0x6875, 0x68a1, 0x68cd, 0x68f2, 0x6924, 0x6956,
	0x6981, 0x69a6, 0x69ca, 0x69ec, 0x6a0f, 0x6a44, 0x6a79, 0x6a9a,
	0x6ab1, 0x6ac6, 0x6ade, 0x6af5, 0x6b0c, 0x6b21, 0x6b39, 0x6b50,
	0x6b77, 0x6b9b, 0x6bc2, 0x6be6, 0x6bf6, 0x6c0c, 0x6c23, 0x6c3c,
	0x6c4c, 0x6c64, 0x6c7e, 0x6c97, 0x6ca1, 0x6cb9, 0x6cd2, 0x6ce9,
	0x6cf8, 0x6d10, 0x6d26, 0x6d3b, 0x6d4b, 0x6d56, 0x6d62, 0x6d6c,
	0x6d82, 0x6d98, 0x6dab, 0x6dbf, 0x6dd2, 0x6e04, 0x6e27, 0x6e59,
	// Entry 21C0 - 21FF
	0x6e8c, 0x6ea0, 0x6ec3, 0x6ef6, 0x6f02, 0x6f0e, 0x6f2f, 0x6f59,
	0x6f74, 0x6f8d, 0x6fb3, 0x6fdd, 0x7007, 0x702b, 0x703d, 0x704f,
	0x705e, 0x706d, 0x7085, 0x709d, 0x70b0, 0x70c3, 0x70dd, 0x70f7,
	0x7117, 0x7137, 0x7154, 0x7171, 0x7194, 0x71b7, 0x71d3, 0x71ef,
	0x720b, 0x7227, 0x7249, 0x726b, 0x7287, 0x72a3, 0x72c5, 0x72e7,
	0x7302, 0x731d, 0x732a, 0x7337, 0x7363, 0x736a, 0x7371, 0x737d,
	0x738a, 0x73a3, 0x73ab, 0x73b7, 0x73d2, 0x73ee, 0x740a, 0x7426,
	0x744c, 0x7479, 0x748f, 0x74a6, 0x74b4, 0x74c8, 0x74e7, 0x7506,
	// Entry 2200 - 223F
	0x7526, 0x7547, 0x7568, 0x7588, 0x7599, 0x75aa, 0x75c4, 0x75dd,
	0x75f6, 0x7610, 0x761c, 0x7637, 0x7653, 0x767d, 0x76a8, 0x76d1,
	0x76f4, 0x771d, 0x7747, 0x7753, 0x7778, 0x779d, 0x77c3, 0x77e9,
	0x780e, 0x7833, 0x7859, 0x787f, 0x7892, 0x78a6, 0x78b9, 0x78cc,
	0x78df, 0x78f8, 0x7911, 0x7925, 0x7938, 0x793d, 0x7945, 0x794c,
	0x7951, 0x795b, 0x7965, 0x796e, 0x797a, 0x797d, 0x798b, 0x799a,
	0x79a5, 0x79af, 0x79be, 0x79cd, 0x79d7, 0x79ec, 0x79fd, 0x7a04,
	0x7a1c, 0x7a28, 0x7a39, 0x7a4a, 0x7a52, 0x7a76, 0x7a8f, 0x7aa9,
	// Entry 2240 - 227F
	0x7ac2, 0x7ad9, 0x7af3, 0x7b0c, 0x7b20, 0x7b2c, 0x7b3c, 0x7b4a,
	0x7b52, 0x7b56, 0x7b64, 0x7b6b, 0x7b7c, 0x7b8e, 0x7b9f, 0x7bab,
	0x7bb5, 0x7bc6, 0x7bd2, 0x7bda, 0x7bec, 0x7bfc, 0x7c0c, 0x7c1f,
	0x7c2f, 0x7c40, 0x7c54, 0x7c65, 0x7c74, 0x7c87, 0x7c99, 0x7cab,
	0x7cbe, 0x7cd0, 0x7ce1, 0x7ce8, 0x7cf3, 0x7cf8, 0x7d01, 0x7d08,
	0x7d0e, 0x7d14, 0x7d1b, 0x7d20, 0x7d25, 0x7d2b, 0x7d31, 0x7d37,
	0x7d3a, 0x7d3f, 0x7d44, 0x7d4c, 0x7d57, 0x7d60, 0x7d68, 0x7d6e,
	0x7d7e, 0x7d8f, 0x7d9f, 0x7db1, 0x7dc3, 0x7dd3, 0x7de3, 0x7df4,
	// Entry 2280 - 22BF
	0x7e04, 0x7e16, 0x7e28, 0x7e38, 0x7e48, 0x7e58, 0x7e6a, 0x7e79,
	0x7e89, 0x7e99, 0x7eab, 0x7eba, 0x7ec5, 0x7ed1, 0x7edc, 0x7eef,
	0x7f05, 0x7f14, 0x7f26, 0x7f36, 0x7f47, 0x7f58, 0x7f72, 0x7f96,
	0x7fba, 0x7fde, 0x8002, 0x8026, 0x804a, 0x806e, 0x8094, 0x80b4,
	0x80c9, 0x80e8, 0x80fc, 0x810d, 0x8117, 0x8121, 0x812b, 0x8135,
	0x813f, 0x8149, 0x8164, 0x817e, 0x819f, 0x81bf, 0x81d0, 0x81e0,
	0x81f7, 0x820c, 0x8222, 0x8238, 0x8242, 0x824c, 0x825b, 0x8261,
	0x826f, 0x8283, 0x8289, 0x8290, 0x8296, 0x829a, 0x82a9, 0x82b4,
	// Entry 22C0 - 22FF
	0x82c0, 0x82d3, 0x82ef, 0x830a, 0x8316, 0x8327, 0x833a, 0x834b,
	0x836b, 0x837f, 0x8394, 0x83bd, 0x83db, 0x83fb, 0x840e, 0x8421,
	0x843a, 0x8449, 0x8457, 0x8473, 0x8479, 0x8484, 0x848a, 0x848f,
	0x8495, 0x8499, 0x849e, 0x84a4, 0x84b5, 0x84bc, 0x84c7, 0x84cf,
	0x84dd, 0x84e8, 0x84f0, 0x84fb, 0x850d, 0x8520, 0x8532, 0x8545,
	0x8559, 0x8569, 0x856d, 0x857a, 0x8590, 0x85a8, 0x85c0, 0x85d7,
	0x85e5, 0x85f1, 0x85fa, 0x85fe, 0x8609, 0x8620, 0x8636, 0x863c,
	0x8644, 0x8666, 0x8684, 0x86a2, 0x86b7, 0x86cc, 0x86db, 0x86fd,
	// Entry 2300 - 233F
	0x870e, 0x871d, 0x874d, 0x8758, 0x876f, 0x8786, 0x87a4, 0x87cf,
	0x87d8, 0x87f9, 0x8819, 0x882b, 0x8840, 0x884d, 0x8853, 0x8859,
	0x8866, 0x8876, 0x8887, 0x88a0, 0x88a8, 0x88ba, 0x88c2, 0x88ce,
	0x88d3, 0x88db, 0x88ee, 0x88f3, 0x88fc, 0x890c, 0x8910, 0x8924,
	0x893e, 0x8947, 0x895a, 0x8988, 0x899d, 0x89b1, 0x89bf, 0x89d3,
	0x89e1, 0x89f7, 0x8a0e, 0x8a18, 0x8a20, 0x8a28, 0x8a33, 0x8a3e,
	0x8a4a, 0x8a56, 0x8a68, 0x8a6e, 0x8a80, 0x8a89, 0x8a92, 0x8a9c,
	0x8aac, 0x8abc, 0x8ad2, 0x8ada, 0x8ae8, 0x8afc, 0x8b0d, 0x8b1e,
	// Entry 2340 - 237F
	0x8b35, 0x8b40, 0x8b5a, 0x8b6e, 0x8b7b, 0x8b88, 0x8ba5, 0x8bc1,
	0x8be3, 0x8bfc, 0x8c13, 0x8c2a, 0x8c32, 0x8c4c, 0x8c5e, 0x8c74,
	0x8c8b, 0x8c9e, 0x8cb7, 0x8cc4, 0x8cd7, 0x8ce5, 0x8cf9, 0x8d0e,
	0x8d26, 0x8d41, 0x8d57, 0x8d7b, 0x8da5, 0x8dbe, 0x8dd6, 0x8dee,
	0x8e12, 0x8e30, 0x8e55, 0x8e63, 0x8e71, 0x8e97, 0x8ebd, 0x8ee4,
	0x8eed, 0x8f07, 0x8f1e, 0x8f25, 0x8f32, 0x8f49, 0x8f71, 0x8f9f,
	0x8fa9, 0x8fbe, 0x8fd9, 0x8fff, 0x9025, 0x9046, 0x9067, 0x9083,
	0x909f, 0x90be, 0x90d9, 0x90f6, 0x9108, 0x911b, 0x912d, 0x915e,
	// Entry 2380 - 23BF
	0x9188, 0x91b9, 0x91e3, 0x9211, 0x923f, 0x9262, 0x9281, 0x92a6,
	0x92b7, 0x92d7, 0x92e3, 0x92fe, 0x931e, 0x933f, 0x9369, 0x9394,
	0x93bf, 0x93eb, 0x941c, 0x944e, 0x9478, 0x94a3, 0x94cd, 0x94f8,
	0x951a, 0x953d, 0x955f, 0x9581, 0x95a5, 0x95c8, 0x95eb, 0x960d,
	0x9631, 0x9655, 0x9678, 0x969b, 0x96bf, 0x96e3, 0x9709, 0x972e,
	0x9753, 0x9777, 0x979d, 0x97c3, 0x97e8, 0x980d, 0x983a, 0x9867,
	0x9896, 0x98c4, 0x98f2, 0x991f, 0x994e, 0x997d, 0x99ab, 0x99d9,
	0x99fb, 0x9a0a, 0x9a1a, 0x9a2d, 0x9a43, 0x9a59, 0x9a6f, 0x9a8e,
	// Entry 23C0 - 23FF
	0x9ab1, 0x9ad1, 0x9af7, 0x9b1e, 0x9b4b, 0x9b61, 0x9b89, 0x9bb4,
	0x9bce, 0x9bff, 0x9c2e, 0x9c4a, 0x9c76, 0x9c99, 0x9cbb, 0x9ce6,
	0x9d12, 0x9d43, 0x9d74, 0x9da7, 0x9db1, 0x9de4, 0x9e08, 0x9e28,
	0x9e48, 0x9e68, 0x9e88, 0x9eae, 0x9ed4, 0x9efa, 0x9f1a, 0x9f41,
	0x9f5e, 0x9f81, 0x9f9f, 0x9fb0, 0x9fc7, 0x9ff5, 0xa002, 0xa00d,
	0xa01a, 0xa035, 0xa051, 0xa063, 0xa083, 0xa09d, 0xa0c0, 0xa0dc,
	0xa0e9, 0xa106, 0xa119, 0xa12b, 0xa149, 0xa155, 0xa16f, 0xa18a,
	0xa1a4, 0xa1b3, 0xa1c3, 0xa1d2, 0xa1df, 0xa1ee, 0xa20d, 0xa220,
	// Entry 2400 - 243F
	0xa22d, 0xa23c, 0xa24a, 0xa263, 0xa285, 0xa2a0, 0xa2cf, 0xa2ff,
	0xa31f, 0xa340, 0xa366, 0xa38d, 0xa3ac, 0xa3cc, 0xa3f2, 0xa419,
	0xa447, 0xa476, 0xa49d, 0xa4c5, 0xa4dc, 0xa4f5, 0xa516, 0xa533,
	0xa550, 0xa564, 0xa579, 0xa58e, 0xa5a9, 0xa5c5, 0xa5e1, 0xa5fe,
	0xa61c, 0xa640, 0xa665, 0xa683, 0xa698, 0xa6ae, 0xa6c4, 0xa6db,
	0xa6f1, 0xa708, 0xa71f, 0xa737, 0xa74d, 0xa764, 0xa77b, 0xa793,
	0xa7aa, 0xa7c2, 0xa7da, 0xa7f3, 0xa809, 0xa820, 0xa837, 0xa84f,
	0xa866, 0xa87e, 0xa896, 0xa8af, 0xa8c6, 0xa8de, 0xa8f6, 0xa90f,
	// Entry 2440 - 247F
	0xa927, 0xa940, 0xa959, 0xa973, 0xa989, 0xa9a0, 0xa9b7, 0xa9cf,
	0xa9e6, 0xa9fe, 0xaa16, 0xaa2f, 0xaa46, 0xaa5e, 0xaa76, 0xaa8f,
	0xaaa7, 0xaac0, 0xaad9, 0xaaf3, 0xab0a, 0xab22, 0xab3a, 0xab53,
	0xab6b, 0xab84, 0xab9d, 0xabb7, 0xabcf, 0xabe8, 0xac01, 0xac1b,
	0xac34, 0xac4e, 0xac68, 0xac83, 0xac99, 0xacb0, 0xacc7, 0xacdf,
	0xacf6, 0xad0e, 0xad26, 0xad3f, 0xad56, 0xad6e, 0xad86, 0xad9f,
	0xadb7, 0xadd0, 0xade9, 0xae03, 0xae1a, 0xae32, 0xae4a, 0xae63,
	0xae7b, 0xae94, 0xaead, 0xaec7, 0xaedf, 0xaef8, 0xaf11, 0xaf2b,
	// Entry 2480 - 24BF
	0xaf44, 0xaf5e, 0xaf78, 0xaf93, 0xafaa, 0xafc2, 0xafda, 0xaff3,
	0xb00b, 0xb024, 0xb03d, 0xb057, 0xb06f, 0xb088, 0xb0a1, 0xb0bb,
	0xb0d4, 0xb0ee, 0xb108, 0xb123, 0xb13b, 0xb154, 0xb16d, 0xb187,
	0xb1a0, 0xb1ba, 0xb1d4, 0xb1ef, 0xb208, 0xb222, 0xb23c, 0xb257,
	0xb271, 0xb28c, 0xb2a7, 0xb2c3, 0xb2d9, 0xb2f0, 0xb307, 0xb31f,
	0xb336, 0xb34e, 0xb366, 0xb37f, 0xb396, 0xb3ae, 0xb3c6, 0xb3df,
	0xb3f7, 0xb410, 0xb429, 0xb443, 0xb45a, 0xb472, 0xb48a, 0xb4a3,
	0xb4bb, 0xb4d4, 0xb4ed, 0xb507, 0xb51f, 0xb538, 0xb551, 0xb56b,
	// Entry 24C0 - 24FF
	0xb584, 0xb59e, 0xb5b8, 0xb5d3, 0xb5ea, 0xb602, 0xb61a, 0xb633,
	0xb64b, 0xb664, 0xb67d, 0xb697, 0xb6af, 0xb6c8, 0xb6e1, 0xb6fb,
	0xb714, 0xb72e, 0xb748, 0xb763, 0xb77b, 0xb794, 0xb7ad, 0xb7c7,
	0xb7e0, 0xb7fa, 0xb814, 0xb82f, 0xb848, 0xb862, 0xb87c, 0xb897,
	0xb8b1, 0xb8cc, 0xb8e7, 0xb903, 0xb91a, 0xb932, 0xb94a, 0xb963,
	0xb97b, 0xb994, 0xb9ad, 0xb9c7, 0xb9df, 0xb9f8, 0xba11, 0xba2b,
	0xba44, 0xba5e, 0xba78, 0xba93, 0xbaab, 0xbac4, 0xbadd, 0xbaf7,
	0xbb10, 0xbb2a, 0xbb44, 0xbb5f, 0xbb78, 0xbb92, 0xbbac, 0xbbc7,
	// Entry 2500 - 253F
	0xbbe1, 0xbbfc, 0xbc17, 0xbc33, 0xbc4b, 0xbc64, 0xbc7d, 0xbc97,
	0xbcb0, 0xbcca, 0xbce4, 0xbcff, 0xbd18, 0xbd32, 0xbd4c, 0xbd67,
	0xbd81, 0xbd9c, 0xbdb7, 0xbdd3, 0xbdec, 0xbe06, 0xbe20, 0xbe3b,
	0xbe55, 0xbe70, 0xbe8b, 0xbea7, 0xbec1, 0xbedc, 0xbef7, 0xbf13,
	0xbf2e, 0xbf4a, 0xbf66, 0xbf83, 0xbfb3, 0xbfea, 0xc015, 0xc041,
	0xc06d, 0xc091, 0xc0b0, 0xc0d0, 0xc0f6, 0xc11a, 0xc12e, 0xc144,
	0xc15f, 0xc17b, 0xc196, 0xc1b2, 0xc1d9, 0xc1fa, 0xc20e, 0xc224,
	0xc253, 0xc289, 0xc2ae, 0xc2e8, 0xc329, 0xc33d, 0xc352, 0xc36d,
	// Entry 2540 - 257F
	0xc389, 0xc3a9, 0xc3ca, 0xc3f3, 0xc41d, 0xc43c, 0xc45b, 0xc475,
	0xc48f, 0xc4a9, 0xc4c3, 0xc4e8, 0xc50d, 0xc532, 0xc557, 0xc580,
	0xc5a9, 0xc5d3, 0xc5fd, 0xc627, 0xc650, 0xc67a, 0xc6a4, 0xc6c6,
	0xc6f4, 0xc724, 0xc753, 0xc783, 0xc7a1, 0xc7c2, 0xc7dd, 0xc7fb,
	0xc81d, 0xc842, 0xc86a, 0xc895, 0xc8b6, 0xc8d3, 0xc8ff, 0xc92b,
	0xc957, 0xc977, 0xc996, 0xc9b0, 0xc9d5, 0xc9ff, 0xca23, 0xca47,
	0xca6b, 0xca8f, 0xcab1, 0xcad6, 0xcafc, 0xcb1f, 0xcb44, 0xcb6a,
	0xcb90, 0xcbb8, 0xcbdf, 0xcc07, 0xcc2c, 0xcc53, 0xcc7a, 0xcca2,
	// Entry 2580 - 25BF
	0xccca, 0xccf4, 0xcd1d, 0xcd47, 0xcd6e, 0xcd97, 0xcddc, 0xce21,
	0xce68, 0xceb1, 0xcef5, 0xcf3d, 0xcf81, 0xcfc9, 0xcff7, 0xd027,
	0xd056, 0xd087, 0xd0ce, 0xd115, 0xd139, 0xd15b, 0xd180, 0xd1a4,
	0xd1c9, 0xd1ef, 0xd20e, 0xd22f, 0xd252, 0xd26f, 0xd28d, 0xd2ab,
	0xd2b9, 0xd2c8, 0xd2d4, 0xd2e2, 0xd2ff, 0xd30e, 0xd323, 0xd33b,
	0xd354, 0xd36a, 0xd381, 0xd39e, 0xd3bc, 0xd3db, 0xd3fb, 0xd41c,
	0xd43e, 0xd469, 0xd498, 0xd4c6, 0xd4f2, 0xd50d, 0xd529, 0xd543,
	0xd561, 0xd585, 0xd5a7, 0xd5c8, 0xd5ea, 0xd5f6, 0xd60a, 0xd625,
	// Entry 25C0 - 25FF
	0xd644, 0xd661, 0xd674, 0xd67f, 0xd69b, 0xd6b5, 0xd6c1, 0xd6cf,
	0xd6e2, 0xd6fe, 0xd716, 0xd730, 0xd772, 0xd7b3, 0xd7f7, 0xd83a,
	0xd87c, 0xd8bd, 0xd901, 0xd944, 0xd956, 0xd96c, 0xd98d, 0xd9ad,
	0xd9cc, 0xd9e6, 0xd9fa, 0xda0a, 0xda21, 0xda36, 0xda7b, 0xda95,
	0xdac0, 0xdad7, 0xdaeb, 0xdaf9, 0xdb0a, 0xdb1e, 0xdb43, 0xdb72,
	0xdb8f, 0xdbad, 0xdbbd, 0xdbd1, 0xdbdf, 0xdbf1, 0xdc08, 0xdc1e,
	0xdc2b, 0xdc49, 0xdc6b, 0xdc8c, 0xdcae, 0xdcc9, 0xdce5, 0xdcf1,
	0xdd0b, 0xdd26, 0xdd35, 0xdd44, 0xdd55, 0xdd67, 0xdd7f, 0xdd98,
	// Entry 2600 - 263F
	0xddab, 0xddbc, 0xddde, 0xddf3, 0xde10, 0xde1c, 0xde2b, 0xde4b,
	0xde7c, 0xde9d, 0xdea9, 0xdeb6, 0xdee1, 0xdf0d, 0xdf2a, 0xdf37,
	0xdf53, 0xdf6f, 0xdf88, 0xdfa1, 0xdfbb, 0xdfd5, 0xdfee, 0xe007,
	0xe013, 0xe02b, 0xe03f, 0xe065, 0xe070, 0xe083, 0xe08e, 0xe099,
	0xe0bb, 0xe0de, 0xe0e2, 0xe0e6, 0xe100, 0xe11b, 0xe137, 0xe154,
	0xe172, 0xe194, 0xe1af, 0xe1c7, 0xe1de, 0xe1f2, 0xe200, 0xe217,
	0xe232, 0xe246, 0xe261, 0xe27c, 0xe290, 0xe2a9, 0xe2db, 0xe30e,
	0xe335, 0xe355, 0xe371, 0xe398, 0xe3b0, 0xe3ca, 0xe3dd, 0xe3f2,
	// Entry 2640 - 267F
	0xe408, 0xe40c, 0xe428, 0xe445, 0xe45d, 0xe479, 0xe49a, 0xe4c0,
	0xe4da, 0xe4f2, 0xe50c, 0xe528, 0xe545, 0xe560, 0xe579, 0xe595,
	0xe5b0, 0xe5cd, 0xe5eb, 0xe602, 0xe624, 0xe645, 0xe66a, 0xe677,
	0xe69e, 0xe6c6, 0xe6f8, 0xe71c, 0xe731, 0xe746, 0xe75c, 0xe77b,
	0xe78b, 0xe7a5, 0xe7c6, 0xe7df, 0xe7f4, 0xe809, 0xe81b, 0xe834,
	0xe851, 0xe866, 0xe87e, 0xe896, 0xe8b8, 0xe8da, 0xe8fc, 0xe92c,
	0xe944, 0xe963, 0xe97d, 0xe990, 0xe9ba, 0xe9d4, 0xe9ed, 0xe9ff,
	0xea10, 0xea2c, 0xea47, 0xea57, 0xea68, 0xea8a, 0xeaa6, 0xeac1,
	// Entry 2680 - 26BF
	0xeae1, 0xeb00, 0xeb1f, 0xeb38, 0xeb58, 0xeb6f, 0xeb8d, 0xebac,
	0xebcd, 0xebed, 0xec07, 0xec1f, 0xec50, 0xec81, 0xec9e, 0xecbd,
	0xecd2, 0xecea, 0xecfe, 0xed24, 0xed43, 0xed5e, 0xed79, 0xed99,
	0xedab, 0xedc7, 0xede5, 0xee17, 0xee36, 0xee52, 0xee71, 0xee93,
	0xeeb8, 0xeed5, 0xeef5, 0xef22, 0xef52, 0xef7e, 0xefad, 0xefdf,
	0xf013, 0xf02b, 0xf046, 0xf06c, 0xf095, 0xf0b2, 0xf0d2, 0xf106,
	0xf13a, 0xf15a, 0xf17d, 0xf1a7, 0xf1d1, 0xf205, 0xf239, 0xf27d,
	0xf2c1, 0xf2de, 0xf2fe, 0xf32b, 0xf35b, 0xf37c, 0xf3a0, 0xf3c9,
	// Entry 26C0 - 26FF
	0xf3f5, 0xf409, 0xf420, 0xf449, 0xf475, 0xf48c, 0xf4a6, 0xf4cb,
	0xf4ed, 0xf50a, 0xf523, 0xf53f, 0xf56c, 0xf59c, 0xf5a8, 0xf5b3,
	0xf5cb, 0xf5e2, 0xf5fe, 0xf624, 0xf64a, 0xf671, 0xf698, 0xf6b2,
	0xf6cc, 0xf6e7, 0xf702, 0xf720, 0xf73e, 0xf760, 0xf782, 0xf791,
	0xf7a0, 0xf7af, 0xf7c0, 0xf7db, 0xf7f8, 0xf81d, 0xf844, 0xf868,
	0xf88e, 0xf8a9, 0xf8c6, 0xf8e4, 0xf904, 0xf923, 0xf944, 0xf960,
	0xf97e, 0xf99b, 0xf9b9, 0xf9c6, 0xf9d5, 0xf9ee, 0xfa09, 0xfa1e,
	0xfa33, 0xfa46, 0xfa5d, 0xfa73, 0xfaa1, 0xfabd, 0xfad3, 0xfaeb,
	// Entry 2700 - 273F
	0xfaf2, 0xfafc, 0xfb0b, 0xfb1a, 0xfb27, 0xfb3b, 0xfb5e, 0xfb80,
	0xfba2, 0xfbcb, 0xfbf8, 0xfc14, 0xfc2f, 0xfc52, 0xfc62, 0xfc70,
	0xfc86, 0xfca5, 0xfcd1, 0xfcf0, 0xfd0f, 0xfd2a, 0xfd49, 0xfd65,
	0xfd88, 0xfdb2, 0xfdc7, 0xfdde, 0xfdf8, 0xfe21, 0xfe4d, 0xfe6b,
	0xfe8d, 0xfea4, 0xfeb6, 0xfece, 0xfee4, 0xfefa, 0xff10, 0xff26,
	0xff3c, 0xff51, 0xff64, 0xff79, 0xff8f, 0xffa5, 0xffbb, 0xffd1,
	0xffe7, 0xfffa, 0x001d, 0x003e, 0x0060, 0x0080, 0x009a, 0x00b7,
	0x00e2, 0x010c, 0x0128, 0x0145, 0x0160, 0x017e, 0x018b, 0x019d,
	// Entry 2740 - 277F
	0x01af, 0x01c6, 0x01dd, 0x01eb, 0x01f9, 0x0206, 0x0213, 0x022b,
	0x023d, 0x0251, 0x0265, 0x0279, 0x028d, 0x02a0, 0x02b3, 0x02c6,
	0x02de, 0x02f6, 0x030c, 0x0322, 0x033e, 0x0354, 0x0370, 0x038d,
	0x03bc, 0x03f2, 0x0415, 0x043b, 0x045b, 0x0489, 0x04be, 0x04e2,
	0x051b, 0x055b, 0x0574, 0x0595, 0x05b6, 0x05e2, 0x060f, 0x0634,
	0x0655, 0x066e, 0x0688, 0x06b5, 0x06e3, 0x0707, 0x072c, 0x0758,
	0x0785, 0x07ab, 0x07c4, 0x07e1, 0x07f2, 0x0802, 0x0812, 0x082f,
	0x084c, 0x085e, 0x0879, 0x0898, 0x08a4, 0x08b9, 0x08dd, 0x0905,
	// Entry 2780 - 27BF
	0x092d, 0x0959, 0x0986, 0x09b9, 0x09d8, 0x09f5, 0x0a15, 0x0a34,
	0x0a54, 0x0a71, 0x0a91, 0x0ab1, 0x0ad1, 0x0af1, 0x0b17, 0x0b3b,
	0x0b62, 0x0b88, 0x0bb3, 0x0be2, 0x0c08, 0x0c2c, 0x0c53, 0x0c79,
	0x0ca0, 0x0cc7, 0x0cee, 0x0d15, 0x0d52, 0x0d8d, 0x0dcb, 0x0e08,
	0x0e1a, 0x0e2a, 0x0e6f, 0x0eb9, 0x0efe, 0x0f48, 0x0f6f, 0x0f94,
	0x0fbc, 0x0fe3, 0x1006, 0x1027, 0x104b, 0x106e, 0x10a0, 0x10d3,
	0x1104, 0x1134, 0x113f, 0x114b, 0x1157, 0x1164, 0x118d, 0x11a3,
	0x11c0, 0x11f3, 0x1226, 0x125a, 0x128e, 0x12b3, 0x12d6, 0x12fc,
	// Entry 27C0 - 27FF
	0x1321, 0x1358, 0x1390, 0x13c5, 0x13fb, 0x1430, 0x1466, 0x149d,
	0x14d5, 0x14ff, 0x152a, 0x1552, 0x157b, 0x15a3, 0x15cc, 0x15f6,
	0x1621, 0x1637, 0x164e, 0x1662, 0x1677, 0x168b, 0x16a0, 0x16b6,
	0x16cd, 0x16fd, 0x171c, 0x1735, 0x1758, 0x1771, 0x1788, 0x1791,
	0x179f, 0x17b3, 0x17c8, 0x17dd, 0x17f5, 0x1802, 0x182b, 0x1856,
	0x1881, 0x18ad, 0x18bd, 0x18d2, 0x18ea, 0x1907, 0x192c, 0x1943,
	0x1962, 0x197b, 0x198b, 0x1995, 0x19a3, 0x19b3, 0x19c2, 0x19d1,
	0x19db, 0x19e5, 0x19ec, 0x19f2, 0x19f8, 0x19fe, 0x1a0f, 0x1a25,
	// Entry 2800 - 283F
	0x1a39, 0x1a3f, 0x1a44, 0x1a48, 0x1a4e, 0x1a55, 0x1a5c, 0x1a64,
	0x1a6c, 0x1a80, 0x1a95, 0x1aae, 0x1ac8, 0x1afb, 0x1b2c, 0x1b60,
	0x1b93, 0x1ba0, 0x1bad, 0x1bb2, 0x1bd7, 0x1bf9, 0x1c1d, 0x1c41,
	0x1c65, 0x1c8a, 0x1ca9, 0x1cb6, 0x1cc6, 0x1cd4, 0x1ce1, 0x1cf5,
	0x1d0f, 0x1d2c, 0x1d4a, 0x1d68, 0x1d89, 0x1da8, 0x1dc7, 0x1de8,
	0x1e07, 0x1e27, 0x1e45, 0x1e6b, 0x1e86, 0x1ea6, 0x1ec4, 0x1ee5,
	0x1f06, 0x1f25, 0x1f42, 0x1f62, 0x1f81, 0x1fa0, 0x1fc0, 0x1fdd,
	0x1ffc, 0x201a, 0x2037, 0x2053, 0x2071, 0x208e, 0x20ae, 0x20cb,
	// Entry 2840 - 287F
	0x20e9, 0x2107, 0x2125, 0x2149, 0x2165, 0x2188, 0x21b5, 0x21d1,
	0x21fc, 0x221d, 0x2246, 0x2264, 0x2285, 0x22a6, 0x22cc, 0x22f6,
	0x231e, 0x2339, 0x2355, 0x2371, 0x2390, 0x23ad, 0x23ca, 0x23e9,
	0x2406, 0x2424, 0x2440, 0x2464, 0x247d, 0x249b, 0x24b7, 0x24d6,
	0x24f5, 0x2512, 0x252d, 0x254b, 0x2568, 0x2585, 0x25a3, 0x25be,
	0x25db, 0x25f7, 0x2612, 0x262c, 0x2648, 0x2663, 0x2681, 0x269c,
	0x26b8, 0x26d4, 0x26f0, 0x2712, 0x272c, 0x274d, 0x2778, 0x2792,
	0x27bb, 0x27da, 0x2801, 0x281d, 0x283c, 0x285b, 0x287f, 0x28a7,
	// Entry 2880 - 28BF
	0x28cd, 0x28f3, 0x2917, 0x293f, 0x2961, 0x2981, 0x29a1, 0x29ca,
	0x29ef, 0x2a12, 0x2a37, 0x2a5a, 0x2a7f, 0x2aa2, 0x2abc, 0x2adc,
	0x2af9, 0x2b1a, 0x2b3e, 0x2b5e, 0x2b7c, 0x2b9a, 0x2bb5, 0x2bce,
	0x2bed, 0x2c0c, 0x2c31, 0x2c5a, 0x2c7d, 0x2c9b, 0x2cb4, 0x2cda,
	0x2d00, 0x2d1a, 0x2d32, 0x2d4c, 0x2d64, 0x2d7f, 0x2d98, 0x2db3,
	0x2dcc, 0x2de5, 0x2dfc, 0x2e15, 0x2e2c, 0x2e46, 0x2e5e, 0x2e78,
	0x2e90, 0x2eac, 0x2ec6, 0x2ee1, 0x2efa, 0x2f14, 0x2f2c, 0x2f47,
	0x2f60, 0x2f78, 0x2f8e, 0x2fa6, 0x2fbc, 0x2fd5, 0x2fec, 0x3003,
	// Entry 28C0 - 28FF
	0x3018, 0x3030, 0x3046, 0x305e, 0x3074, 0x308e, 0x30a6, 0x30bf,
	0x30d6, 0x30ee, 0x3104, 0x311c, 0x3132, 0x314b, 0x3162, 0x317b,
	0x3192, 0x31ab, 0x31c2, 0x31e6, 0x3208, 0x322c, 0x324e, 0x3275,
	0x329a, 0x32be, 0x32e0, 0x3302, 0x3322, 0x3348, 0x336c, 0x3390,
	0x33b2, 0x33cd, 0x33e6, 0x3408, 0x3428, 0x344d, 0x3470, 0x3494,
	0x34b6, 0x34d9, 0x34fa, 0x351e, 0x3540, 0x3565, 0x3588, 0x35ab,
	0x35cc, 0x35ed, 0x360c, 0x3630, 0x3652, 0x3676, 0x3698, 0x36bf,
	0x36e4, 0x3708, 0x372a, 0x3750, 0x3774, 0x379a, 0x37be, 0x37e2,
	// Entry 2900 - 293F
	0x3804, 0x3828, 0x384a, 0x386e, 0x3890, 0x38a1, 0x38b4, 0x38c7,
	0x38dc, 0x38f0, 0x3904, 0x391c, 0x3944, 0x396a, 0x3994, 0x39bc,
	0x39d5, 0x39f4, 0x3a13, 0x3a36, 0x3a57, 0x3a72, 0x3a98, 0x3ac0,
	0x3adf, 0x3af7, 0x3b07, 0x3b23, 0x3b3b, 0x3b54, 0x3b6d, 0x3b86,
	0x3b9e, 0x3bb7, 0x3bd0, 0x3be9, 0x3c01, 0x3c1a, 0x3c33, 0x3c4c,
	0x3c65, 0x3c7d, 0x3c96, 0x3cb0, 0x3cc9, 0x3ce2, 0x3cfb, 0x3d13,
	0x3d2d, 0x3d47, 0x3d61, 0x3d7a, 0x3d94, 0x3dae, 0x3dc7, 0x3de0,
	0x3df9, 0x3e13, 0x3e2c, 0x3e46, 0x3e5f, 0x3e77, 0x3e90, 0x3ea8,
	// Entry 2940 - 297F
	0x3ec1, 0x3eda, 0x3ef2, 0x3f0b, 0x3f1d, 0x3f30, 0x3f44, 0x3f57,
	0x3f6c, 0x3f8e, 0x3fa1, 0x3fb4, 0x3fc8, 0x3fdc, 0x3ff1, 0x4004,
	0x4017, 0x402a, 0x4044, 0x4059, 0x406c, 0x408e, 0x40a8, 0x40bc,
	0x40cf, 0x40e3, 0x40fe, 0x4111, 0x412b, 0x413d, 0x4151, 0x416d,
	0x4188, 0x419b, 0x41ae, 0x41c1, 0x41dc, 0x41f7, 0x420a, 0x421c,
	0x422f, 0x4243, 0x4257, 0x4272, 0x428b, 0x429e, 0x42b2, 0x42c6,
	0x42d9, 0x42ed, 0x4301, 0x4315, 0x4328, 0x433b, 0x434e, 0x4361,
	0x437f, 0x4393, 0x43a5, 0x43b7, 0x43e2, 0x43f9, 0x4412, 0x4427,
	// Entry 2980 - 29BF
	0x443c, 0x4451, 0x4466, 0x447c, 0x4491, 0x44a6, 0x44bb, 0x44d0,
	0x44e6, 0x4502, 0x4517, 0x452c, 0x4542, 0x4557, 0x456d, 0x4583,
	0x4599, 0x45ae, 0x45c4, 0x45da, 0x45f1, 0x4607, 0x461c, 0x4631,
	0x4646, 0x465c, 0x4672, 0x4687, 0x469c, 0x46b1, 0x46c6, 0x46db,
	0x46f1, 0x4707, 0x471c, 0x4731, 0x4746, 0x475b, 0x4770, 0x4786,
	0x479c, 0x47b1, 0x47c6, 0x47dc, 0x47f2, 0x4808, 0x481f, 0x4836,
	0x484c, 0x4862, 0x4877, 0x488c, 0x48a1, 0x48b7, 0x48cd, 0x48e2,
	0x48f7, 0x490c, 0x4921, 0x4936, 0x494c, 0x4962, 0x4977, 0x498c,
	// Entry 29C0 - 29FF
	0x49a1, 0x49b6, 0x49cb, 0x49e1, 0x49f7, 0x4a0c, 0x4a21, 0x4a36,
	0x4a4b, 0x4a60, 0x4a76, 0x4a8c, 0x4aa1, 0x4ab6, 0x4ad2, 0x4aee,
	0x4b0b, 0x4b27, 0x4b44, 0x4b60, 0x4b7c, 0x4b98, 0x4bb4, 0x4bd0,
	0x4beb, 0x4c07, 0x4c23, 0x4c3f, 0x4c5b, 0x4c77, 0x4c94, 0x4cb1,
	0x4cce, 0x4ced, 0x4d0b, 0x4d2a, 0x4d45, 0x4d61, 0x4d80, 0x4da6,
	0x4dc3, 0x4ddf, 0x4e03, 0x4e27, 0x4e48, 0x4e72, 0x4e91, 0x4eb7,
	0x4ed0, 0x4eea, 0x4f0a, 0x4f2b, 0x4f46, 0x4f68, 0x4f83, 0x4f9d,
	0x4fb8, 0x4fc5, 0x4fe1, 0x4ffe, 0x500f, 0x501a, 0x502c, 0x5047,
	// Entry 2A00 - 2A3F
	0x5053, 0x5060, 0x5070, 0x507e, 0x5099, 0x50ae, 0x50c2, 0x50cd,
	0x50e2, 0x50f7, 0x5112, 0x512e, 0x5142, 0x5156, 0x5172, 0x518f,
	0x51a4, 0x51ba, 0x51d2, 0x51eb, 0x5202, 0x521a, 0x5231, 0x5249,
	0x526a, 0x528b, 0x52a7, 0x52b4, 0x52ca, 0x52d8, 0x52e2, 0x52fb,
	0x5307, 0x5311, 0x531d, 0x532d, 0x5343, 0x535a, 0x5367, 0x537c,
	0x5387, 0x5394, 0x53aa, 0x53bb, 0x53cf, 0x53d8, 0x53e5, 0x53f3,
	0x5417, 0x542c, 0x5442, 0x5455, 0x547a, 0x5484, 0x5497, 0x54ab,
	0x54b9, 0x54c6, 0x54d4, 0x54e4, 0x54f9, 0x550e, 0x552d, 0x554b,
	// Entry 2A40 - 2A7F
	0x5563, 0x557c, 0x5592, 0x55b1, 0x55d1, 0x55f7, 0x561e, 0x5637,
	0x5651, 0x566d, 0x568a, 0x5698, 0x56aa, 0x56bb, 0x56d1, 0x56e7,
	0x56ff, 0x5711, 0x5720, 0x5731, 0x5746, 0x575b, 0x5771, 0x5781,
	0x5796, 0x57ab, 0x57bf, 0x57d3, 0x57e9, 0x57fe, 0x580f, 0x5821,
	0x5836, 0x584b, 0x5860, 0x5875, 0x5885, 0x5894, 0x58a5, 0x58b4,
	0x58c4, 0x58d5, 0x58e7, 0x58fb, 0x5910, 0x5925, 0x5935, 0x5948,
	0x595b, 0x5981, 0x5990, 0x599f, 0x59af, 0x59c8, 0x59d7, 0x59ed,
	0x5a03, 0x5a15, 0x5a25, 0x5a42, 0x5a55, 0x5a68, 0x5a7d, 0x5a91,
	// Entry 2A80 - 2ABF
	0x5aa1, 0x5ab2, 0x5ac1, 0x5ad0, 0x5adf, 0x5af4, 0x5b09, 0x5b19,
	0x5b2b, 0x5b40, 0x5b55, 0x5b6c, 0x5b7d, 0x5b90, 0x5ba4, 0x5bb8,
	0x5bd4, 0x5bef, 0x5bff, 0x5c1e, 0x5c3c, 0x5c4c, 0x5c69, 0x5c84,
	0x5c98, 0x5cac, 0x5cbc, 0x5cd9, 0x5ced, 0x5d01, 0x5d1e, 0x5d3b,
	0x5d50, 0x5d65, 0x5d75, 0x5d85, 0x5dac, 0x5dc9, 0x5de6, 0x5e02,
	0x5e15, 0x5e28, 0x5e3d, 0x5e59, 0x5e69, 0x5e87, 0x5e97, 0x5ea8,
	0x5ec5, 0x5ee2, 0x5eff, 0x5f1b, 0x5f38, 0x5f55, 0x5f72, 0x5f8f,
	0x5fad, 0x5fcb, 0x5fea, 0x6009, 0x601b, 0x603a, 0x6059, 0x606b,
	// Entry 2AC0 - 2AFF
	0x607e, 0x6090, 0x60a4, 0x60b9, 0x60cc, 0x60de, 0x60f0, 0x6102,
	0x6115, 0x6129, 0x613d, 0x6154, 0x6168, 0x617a, 0x618e, 0x61a5,
	0x61b9, 0x61cd, 0x61e0, 0x61f4, 0x6211, 0x6230, 0x6242, 0x625b,
	0x626e, 0x6282, 0x6298, 0x62ac, 0x62c0, 0x62d8, 0x62ec, 0x6302,
	0x6313, 0x632b, 0x6341, 0x6353, 0x6367, 0x637b, 0x638e, 0x63a1,
	0x63b5, 0x63c8, 0x63dd, 0x63f2, 0x6409, 0x641d, 0x6430, 0x6446,
	0x645b, 0x646d, 0x6488, 0x64a3, 0x64bd, 0x64d5, 0x64e9, 0x64fb,
	0x650f, 0x6525, 0x6538, 0x654c, 0x6562, 0x6575, 0x6588, 0x659d,
	// Entry 2B00 - 2B3F
	0x65af, 0x65c4, 0x65d9, 0x65eb, 0x6600, 0x6612, 0x6624, 0x6636,
	0x6649, 0x665c, 0x666f, 0x6682, 0x6696, 0x66ab, 0x66c0, 0x66d6,
	0x66e8, 0x66fb, 0x670f, 0x6723, 0x6736, 0x6749, 0x675e, 0x6775,
	0x6793, 0x67a7, 0x67ba, 0x67cc, 0x67de, 0x67f5, 0x6808, 0x681c,
	0x682f, 0x6843, 0x6856, 0x6868, 0x687c, 0x6898, 0x68af, 0x68c9,
	0x68dd, 0x68f0, 0x6903, 0x6915, 0x6929, 0x693d, 0x6951, 0x6966,
	0x697a, 0x698e, 0x69a1, 0x69b5, 0x69ca, 0x69dd, 0x69f0, 0x6a02,
	0x6a14, 0x6a28, 0x6a3e, 0x6a50, 0x6a62, 0x6a75, 0x6a87, 0x6a9b,
	// Entry 2B40 - 2B7F
	0x6aae, 0x6ac5, 0x6ad8, 0x6aed, 0x6b02, 0x6b17, 0x6b2c, 0x6b3f,
	0x6b56, 0x6b6a, 0x6b7e, 0x6b92, 0x6ba7, 0x6bbb, 0x6bd8, 0x6bee,
	0x6c01, 0x6c13, 0x6c26, 0x6c3b, 0x6c50, 0x6c63, 0x6c75, 0x6c8a,
	0x6c9e, 0x6cb0, 0x6cc2, 0x6cd5, 0x6ce8, 0x6cfb, 0x6d10, 0x6d26,
	0x6d39, 0x6d4c, 0x6d5f, 0x6d79, 0x6d8f, 0x6da2, 0x6db5, 0x6dc8,
	0x6ddc, 0x6df0, 0x6e10, 0x6e23, 0x6e36, 0x6e4a, 0x6e5d, 0x6e73,
	0x6e90, 0x6ea3, 0x6eb7, 0x6eca, 0x6edd, 0x6eef, 0x6f01, 0x6f14,
	0x6f2b, 0x6f3f, 0x6f52, 0x6f65, 0x6f78, 0x6f8c, 0x6fab, 0x6fc2,
	// Entry 2B80 - 2BBF
	0x6fd6, 0x6fe9, 0x6ffc, 0x700f, 0x7022, 0x7036, 0x7049, 0x705e,
	0x7073, 0x7087, 0x70a0, 0x70b3, 0x70c8, 0x70db, 0x70ed, 0x7100,
	0x7113, 0x7127, 0x713c, 0x7151, 0x7165, 0x7194, 0x71c4, 0x71fe,
	0x7239, 0x7268, 0x729d, 0x72d2, 0x7306, 0x7340, 0x737b, 0x73b5,
	0x73df, 0x73f0, 0x7401, 0x7416, 0x7420, 0x7443, 0x745d, 0x7475,
	0x748c, 0x749e, 0x74b1, 0x74ca, 0x74e4, 0x74f7, 0x750b, 0x7524,
	0x753e, 0x755b, 0x7579, 0x7584, 0x758d, 0x75a8, 0x75c4, 0x75e1,
	0x75ff, 0x7620, 0x7642, 0x765b, 0x7675, 0x767e, 0x76a2, 0x76bd,
	// Entry 2BC0 - 2BFF
	0x76dc, 0x76ec, 0x7700, 0x7714, 0x772a, 0x773f, 0x7754, 0x7768,
	0x777e, 0x7794, 0x77a9, 0x77c4, 0x77e0, 0x77ff, 0x781d, 0x7838,
	0x7853, 0x785c, 0x7875, 0x78a0, 0x78c4, 0x78fa, 0x791e, 0x7931,
	0x7961, 0x7975, 0x798c, 0x79a3, 0x79c6, 0x79cf, 0x79e4, 0x7a03,
	0x7a1e, 0x7a35, 0x7a46, 0x7a5d, 0x7a6e, 0x7a85, 0x7a96, 0x7aad,
	0x7abe, 0x7ad5, 0x7ae6, 0x7af8, 0x7b0a, 0x7b1c, 0x7b2e, 0x7b40,
	0x7b52, 0x7b64, 0x7b76, 0x7b88, 0x7b9a, 0x7bac, 0x7bbe, 0x7bd0,
	0x7be2, 0x7bf4, 0x7c06, 0x7c18, 0x7c2a, 0x7c3c, 0x7c4e, 0x7c60,
	// Entry 2C00 - 2C3F
	0x7c72, 0x7c84, 0x7c96, 0x7cae, 0x7cc0, 0x7cd2, 0x7ce4, 0x7cf6,
	0x7d08, 0x7d1a, 0x7d2c, 0x7d3e, 0x7d50, 0x7d62, 0x7d74, 0x7d86,
	0x7d98, 0x7daa, 0x7dbc, 0x7dce, 0x7de0, 0x7df2, 0x7e04, 0x7e16,
	0x7e28, 0x7e3a, 0x7e4c, 0x7e5e, 0x7e70, 0x7e82, 0x7e94, 0x7ea6,
	0x7eb8, 0x7eca, 0x7edc, 0x7ef4, 0x7f06, 0x7f1e, 0x7f30, 0x7f48,
	0x7f5a, 0x7f6c, 0x7f7e, 0x7f90, 0x7fa2, 0x7fb4, 0x7fcc, 0x7fde,
	0x7ff0, 0x8002, 0x8014, 0x8025, 0x8037, 0x804f, 0x8067, 0x8094,
	0x80c6, 0x80e9, 0x8111, 0x8128, 0x8146, 0x815b, 0x817a, 0x8191,
	// Entry 2C40 - 2C7F
	0x81a2, 0x81b9, 0x81ca, 0x81e1, 0x81f2, 0x8209, 0x821a, 0x8231,
	0x8242, 0x8254, 0x8266, 0x8278, 0x828a, 0x829c, 0x82ae, 0x82c0,
	0x82d2, 0x82e4, 0x82f6, 0x8308, 0x831a, 0x832c, 0x833e, 0x8350,
	0x8362, 0x8374, 0x8386, 0x8398, 0x83aa, 0x83bc, 0x83ce, 0x83e0,
	0x83f2, 0x840a, 0x841c, 0x842e, 0x8440, 0x8452, 0x8464, 0x8476,
	0x8488, 0x849a, 0x84ac, 0x84be, 0x84d0, 0x84e2, 0x84f4, 0x8506,
	0x8518, 0x852a, 0x853c, 0x854e, 0x8560, 0x8572, 0x8584, 0x8596,
	0x85a8, 0x85ba, 0x85cc, 0x85de, 0x85f0, 0x8602, 0x8614, 0x8626,
	// Entry 2C80 - 2CBF
	0x8638, 0x8650, 0x8662, 0x867a, 0x868c, 0x86a4, 0x86b6, 0x86c8,
	0x86da, 0x86ec, 0x86fe, 0x8710, 0x8728, 0x873a, 0x874c, 0x875e,
	0x8770, 0x8781, 0x8793, 0x87ab, 0x87c3, 0x87d5, 0x87e7, 0x87f9,
	0x880b, 0x881e, 0x8844, 0x885b, 0x8879, 0x888e, 0x889f, 0x88b0,
	0x88c1, 0x88d2, 0x88e3, 0x88f4, 0x8905, 0x8916, 0x8927, 0x8938,
	0x8949, 0x895a, 0x896b, 0x897c, 0x898e, 0x89a0, 0x89b2, 0x89c3,
	0x89d4, 0x89e5, 0x89f6, 0x8a07, 0x8a18, 0x8a29, 0x8a3b, 0x8a4d,
	0x8a5f, 0x8a71, 0x8a83, 0x8a95, 0x8aa7, 0x8aba, 0x8acd, 0x8adf,
	// Entry 2CC0 - 2CFF
	0x8af0, 0x8b01, 0x8b13, 0x8b24, 0x8b36, 0x8b48, 0x8b5a, 0x8b7a,
	0x8b8c, 0x8ba0, 0x8bb9, 0x8bd2, 0x8be5, 0x8bfe, 0x8c17, 0x8c2b,
	0x8c44, 0x8c57, 0x8c71, 0x8c8a, 0x8ca3, 0x8cbb, 0x8cd6, 0x8cf1,
	0x8d0a, 0x8d1d, 0x8d30, 0x8d48, 0x8d60, 0x8d72, 0x8d89, 0x8d9c,
	0x8daf, 0x8dc7, 0x8ddc, 0x8df1, 0x8e06, 0x8e1b, 0x8e2e, 0x8e3d,
	0x8e4d, 0x8e5d, 0x8e6e, 0x8e7e, 0x8e8d, 0x8e9e, 0x8eae, 0x8ebd,
	0x8ecd, 0x8ede, 0x8eee, 0x8efe, 0x8f0d, 0x8f1e, 0x8f2e, 0x8f3e,
	0x8f4e, 0x8f5e, 0x8f6e, 0x8f7d, 0x8f8a, 0x8fa2, 0x8fbc, 0x8fd4,
	// Entry 2D00 - 2D3F
	0x8fef, 0x900e, 0x9028, 0x9046, 0x9061, 0x9080, 0x9099, 0x90b1,
	0x90cc, 0x90e7, 0x9101, 0x911b, 0x913a, 0x9159, 0x9172, 0x918d,
	0x91a8, 0x91c8, 0x91e1, 0x91f9, 0x9212, 0x922a, 0x9242, 0x9257,
	0x926f, 0x9285, 0x92a0, 0x92be, 0x92db, 0x92f3, 0x930c, 0x931f,
	0x9333, 0x9345, 0x9359, 0x936c, 0x937e, 0x9391, 0x93a5, 0x93c8,
	0x93eb, 0x940a, 0x9429, 0x944a, 0x946a, 0x9489, 0x94ab, 0x94cd,
	0x94ee, 0x9510, 0x9531, 0x9553, 0x9575, 0x9596, 0x95b5, 0x95c7,
	0x95d9, 0x95eb, 0x95fd, 0x960f, 0x9622, 0x9634, 0x9647, 0x9659,
	// Entry 2D40 - 2D7F
	0x966c, 0x967f, 0x9692, 0x96a4, 0x96b7, 0x96cb, 0x96df, 0x96f1,
	0x9703, 0x9716, 0x972a, 0x9741, 0x9758, 0x976f, 0x9786, 0x9798,
	0x97aa, 0x97bc, 0x97d3, 0x97e5, 0x97f7, 0x9809, 0x981b, 0x9827,
	0x9834, 0x9841, 0x984f, 0x985c, 0x986a, 0x9878, 0x9885, 0x9894,
	0x98a3, 0x98b1, 0x98c0, 0x98cf, 0x98dd, 0x98ec, 0x98f8, 0x9904,
	0x9910, 0x991c, 0x9929, 0x9935, 0x9942, 0x994f, 0x995c, 0x996a,
	0x9977, 0x9984, 0x9991, 0x999e, 0x99ab, 0x99b9, 0x99c7, 0x99d6,
	0x99e6, 0x99f3, 0x99ff, 0x9a17, 0x9a2f, 0x9a47, 0x9a5f, 0x9a77,
	// Entry 2D80 - 2DBF
	0x9a8f, 0x9aa7, 0x9abf, 0x9ad7, 0x9aef, 0x9b07, 0x9b1f, 0x9b37,
	0x9b4f, 0x9b67, 0x9b7f, 0x9b9a, 0x9bb4, 0x9bcf, 0x9be9, 0x9c03,
	0x9c1d, 0x9c36, 0x9c50, 0x9c6a, 0x9c86, 0x9ca2, 0x9cbe, 0x9cda,
	0x9cf4, 0x9d11, 0x9d2d, 0x9d4a, 0x9d66, 0x9d82, 0x9d9e, 0x9db9,
	0x9dd5, 0x9df1, 0x9e0f, 0x9e2d, 0x9e4b, 0x9e69, 0x9e85, 0x9ea1,
	0x9ec5, 0x9ee8, 0x9f03, 0x9f1e, 0x9f3b, 0x9f57, 0x9f73, 0x9f8e,
	0x9fab, 0x9fc8, 0x9fe4, 0x9fff, 0xa01b, 0xa037, 0xa054, 0xa070,
	0xa08d, 0xa0aa, 0xa0c5, 0xa0e2, 0xa0fe, 0xa11d, 0xa139, 0xa158,
	// Entry 2DC0 - 2DFF
	0xa179, 0xa19f, 0xa1bc, 0xa1dd, 0xa1f9, 0xa216, 0xa237, 0xa259,
	0xa279, 0xa299, 0xa2b9, 0xa2d5, 0xa2f1, 0xa30e, 0xa328, 0xa346,
	0xa35e, 0xa374, 0xa396, 0xa3bb, 0xa3e0, 0xa404, 0xa428, 0xa44c,
	0xa472, 0xa497, 0xa4a7, 0xa4c0, 0xa4d9, 0xa4f4, 0xa50e, 0xa528,
	0xa541, 0xa55c, 0xa577, 0xa591, 0xa5a6, 0xa5bf, 0xa5d8, 0xa5f3,
	0xa60d, 0xa627, 0xa63c, 0xa650, 0xa665, 0xa679, 0xa68d, 0xa6a1,
	0xa6b4, 0xa6c8, 0xa6dc, 0xa6f2, 0xa708, 0xa71e, 0xa734, 0xa748,
	0xa75f, 0xa775, 0xa78c, 0xa7a2, 0xa7b8, 0xa7ce, 0xa7e3, 0xa7f9,
	// Entry 2E00 - 2E3F
	0xa80f, 0xa827, 0xa83f, 0xa857, 0xa86f, 0xa885, 0xa8a4, 0xa8c2,
	0xa8d8, 0xa8ee, 0xa903, 0xa918, 0xa92f, 0xa945, 0xa95b, 0xa970,
	0xa987, 0xa99e, 0xa9b4, 0xa9c9, 0xa9df, 0xa9f5, 0xaa0c, 0xaa22,
	0xaa39, 0xaa50, 0xaa65, 0xaa7c, 0xaa92, 0xaaab, 0xaac1, 0xaada,
	0xaaf5, 0xab15, 0xab2c, 0xab44, 0xab5a, 0xab72, 0xab8c, 0xaba7,
	0xabbe, 0xabd9, 0xabef, 0xac05, 0xac1b, 0xac34, 0xac4a, 0xac62,
	0xac77, 0xac8d, 0xaca4, 0xacbe, 0xacd8, 0xacef, 0xad0a, 0xad26,
	0xad40, 0xad5a, 0xad71, 0xad8a, 0xada5, 0xadc0, 0xadda, 0xadee,
	// Entry 2E40 - 2E7F
	0xae06, 0xae1e, 0xae38, 0xae51, 0xae6a, 0xae82, 0xae9c, 0xaeb6,
	0xaecf, 0xaee3, 0xaf0b, 0xaf34, 0xaf5a, 0xaf80, 0xafa4, 0xafc9,
	0xafee, 0xb015, 0xb03f, 0xb067, 0xb090, 0xb0b9, 0xb0c2, 0xb0cc,
	0xb0d5, 0xb0eb, 0xb0fd, 0xb10f, 0xb121, 0xb133, 0xb145, 0xb158,
	0xb16b, 0xb17e, 0xb191, 0xb1a4, 0xb1b7, 0xb1ca, 0xb1dd, 0xb1f0,
	0xb203, 0xb216, 0xb229, 0xb23c, 0xb24f, 0xb262, 0xb275, 0xb288,
	0xb29b, 0xb2ae, 0xb2c1, 0xb2d4, 0xb2e7, 0xb2fa, 0xb30d, 0xb320,
	0xb333, 0xb346, 0xb359, 0xb36c, 0xb37f, 0xb392, 0xb3a5, 0xb3b8,
	// Entry 2E80 - 2EBF
	0xb3cb, 0xb3de, 0xb3f1, 0xb404, 0xb417, 0xb42a, 0xb43d, 0xb450,
	0xb463, 0xb478, 0xb485, 0xb492, 0xb49e, 0xb4a9, 0xb4b6, 0xb4c1,
	0xb4cb, 0xb4da, 0xb4e6, 0xb4f1, 0xb4fc, 0xb508, 0xb516, 0xb524,
	0xb530, 0xb53c, 0xb547, 0xb553, 0xb560, 0xb56e, 0xb579, 0xb58a,
	0xb59c, 0xb5ac, 0xb5b9, 0xb5c9, 0xb5d9, 0xb5e7, 0xb5f3, 0xb600,
	0xb60c, 0xb61a, 0xb629, 0xb637, 0xb643, 0xb64f, 0xb65b, 0xb666,
	0xb671, 0xb67b, 0xb686, 0xb692, 0xb69e, 0xb6ad, 0xb6b9, 0xb6c7,
	0xb6d7, 0xb6e4, 0xb6ef, 0xb6fa, 0xb709, 0xb716, 0xb725, 0xb731,
	// Entry 2EC0 - 2EFF
	0xb741, 0xb74c, 0xb759, 0xb766, 0xb772, 0xb77e, 0xb78a, 0xb797,
	0xb7a4, 0xb7ae, 0xb7ba, 0xb7c6, 0xb7d1, 0xb7df, 0xb7eb, 0xb7f7,
	0xb804, 0xb812, 0xb820, 0xb82b, 0xb83b, 0xb846, 0xb854, 0xb862,
	0xb86e, 0xb87a, 0xb885, 0xb893, 0xb89e, 0xb8aa, 0xb8b8, 0xb8c3,
	0xb8d2, 0xb8de, 0xb908, 0xb931, 0xb95a, 0xb985, 0xb9af, 0xb9d9,
	0xba02, 0xba2d, 0xba58, 0xba82, 0xbaab, 0xbad7, 0xbb03, 0xbb31,
	0xbb5f, 0xbb8c, 0xbbb9, 0xbbe8, 0xbc16, 0xbc44, 0xbc70, 0xbca0,
	0xbcd0, 0xbd02, 0xbd33, 0xbd3d, 0xbd46, 0xbd4f, 0xbd59, 0xbd62,
	// Entry 2F00 - 2F3F
	0xbd6b, 0xbd74, 0xbd85, 0xbd94, 0xbd9d, 0xbdb3, 0xbdc9, 0xbde0,
	0xbdf5, 0xbe07, 0xbe15, 0xbe1e, 0xbe29, 0xbe32, 0xbe3b, 0xbe44,
	0xbe4d, 0xbe56, 0xbe60, 0xbe6b, 0xbe74, 0xbe7d, 0xbe88, 0xbe93,
	0xbe9c, 0xbea5, 0xbeae, 0xbeb8, 0xbec2, 0xbecc, 0xbed6, 0xbee1,
	0xbeea, 0xbef3, 0xbefc, 0xbf05, 0xbf0e, 0xbf19, 0xbf22, 0xbf2b,
	0xbf34, 0xbf45, 0xbf56, 0xbf66, 0xbf77, 0xbf86, 0xbf95, 0xbfa3,
	0xbfb2, 0xbfc1, 0xbfd8, 0xbfe1, 0xbfeb, 0xbff5, 0xbfff, 0xc009,
	0xc01a, 0xc033, 0xc03c, 0xc045, 0xc050, 0xc059, 0xc062, 0xc06b,
	// Entry 2F40 - 2F7F
	0xc076, 0xc07f, 0xc088, 0xc096, 0xc09f, 0xc0a8, 0xc0b3, 0xc0bc,
	0xc0c5, 0xc0d3, 0xc0df, 0xc0eb, 0xc0f4, 0xc0fd, 0xc106, 0xc10f,
	0xc11f, 0xc128, 0xc131, 0xc13a, 0xc143, 0xc14c, 0xc155, 0xc15e,
	0xc16f, 0xc178, 0xc181, 0xc18a, 0xc194, 0xc19d, 0xc1ac, 0xc1b6,
	0xc1c0, 0xc1c9, 0xc1d2, 0xc1dc, 0xc1e5, 0xc1ee, 0xc1f7, 0xc200,
	0xc20f, 0xc21e, 0xc246, 0xc26e, 0xc298, 0xc2c1, 0xc2ea, 0xc312,
	0xc33c, 0xc366, 0xc38f, 0xc3b7, 0xc3e2, 0xc40d, 0xc43a, 0xc467,
	0xc493, 0xc4bf, 0xc4ed, 0xc51a, 0xc547, 0xc572, 0xc5a1, 0xc5d0,
	// Entry 2F80 - 2FBF
	0xc601, 0xc631, 0xc661, 0xc690, 0xc6c1, 0xc6f2, 0xc722, 0xc74d,
	0xc77c, 0xc786, 0xc7a6, 0xc7c6, 0xc7ee, 0xc809, 0xc81d, 0xc832,
	0xc847, 0xc864, 0xc87d, 0xc892, 0xc8a4, 0xc8bb, 0xc8d2, 0xc8ef,
	0xc903, 0xc91a, 0xc930, 0xc950, 0xc965, 0xc97f, 0xc99a, 0xc9ac,
	0xc9c8, 0xc9db, 0xc9f1, 0xca0a, 0xca24, 0xca44, 0xca62, 0xca80,
	0xca96, 0xcaab, 0xcabf, 0xcad7, 0xcaec, 0xcb0f, 0xcb26, 0xcb3d,
	0xcb55, 0xcb6d, 0xcb82, 0xcb97, 0xcbb0, 0xcbcb, 0xcbea, 0xcc05,
	0xcc1c, 0xcc31, 0xcc48, 0xcc61, 0xcc82, 0xcca9, 0xccc1, 0xcce1,
	// Entry 2FC0 - 2FFF
	0xccf7, 0xcd10, 0xcd2c, 0xcd48, 0xcd5f, 0xcd76, 0xcd8e, 0xcdae,
	0xcdcb, 0xcde9, 0xcdf7, 0xce05, 0xce12, 0xce20, 0xce2f, 0xce3e,
	0xce4c, 0xce5b, 0xce69, 0xce77, 0xce84, 0xce92, 0xcea1, 0xceaf,
	0xcebe, 0xcecc, 0xceda, 0xcee7, 0xcef5, 0xcf03, 0xcf10, 0xcf1e,
	0xcf2d, 0xcf3c, 0xcf4a, 0xcf59, 0xcf69, 0xcf79, 0xcf88, 0xcf98,
	0xcfa7, 0xcfb6, 0xcfc4, 0xcfd3, 0xcfe3, 0xcff2, 0xd002, 0xd011,
	0xd020, 0xd02e, 0xd03d, 0xd04c, 0xd05a, 0xd069, 0xd078, 0xd087,
	0xd095, 0xd0a4, 0xd0b4, 0xd0c3, 0xd0d2, 0xd0e1, 0xd0ef, 0xd0fe,
	// Entry 3000 - 303F
	0xd10e, 0xd11d, 0xd12c, 0xd13b, 0xd149, 0xd158, 0xd168, 0xd177,
	0xd187, 0xd196, 0xd1a5, 0xd1b3, 0xd1c2, 0xd1d2, 0xd1e1, 0xd1f1,
	0xd200, 0xd20f, 0xd21d, 0xd22c, 0xd23b, 0xd24a, 0xd258, 0xd267,
	0xd277, 0xd286, 0xd295, 0xd2a4, 0xd2b2, 0xd2c1, 0xd2d1, 0xd2e0,
	0xd2f0, 0xd300, 0xd30f, 0xd31f, 0xd330, 0xd341, 0xd351, 0xd362,
	0xd372, 0xd382, 0xd391, 0xd3a1, 0xd3b2, 0xd3c2, 0xd3d3, 0xd3e3,
	0xd3f3, 0xd402, 0xd412, 0xd422, 0xd431, 0xd441, 0xd451, 0xd461,
	0xd470, 0xd480, 0xd491, 0xd4a1, 0xd4b1, 0xd4c1, 0xd4d0, 0xd4e0,
	// Entry 3040 - 307F
	0xd4f0, 0xd500, 0xd50f, 0xd51f, 0xd530, 0xd540, 0xd551, 0xd561,
	0xd571, 0xd580, 0xd590, 0xd5a0, 0xd5b0, 0xd5bf, 0xd5cf, 0xd5df,
	0xd5ef, 0xd5fe, 0xd60e, 0xd61f, 0xd62f, 0xd63f, 0xd64f, 0xd65e,
	0xd66e, 0xd67f, 0xd68f, 0xd69f, 0xd6af, 0xd6be, 0xd6ce, 0xd6df,
	0xd6ef, 0xd700, 0xd710, 0xd720, 0xd72f, 0xd73f, 0xd750, 0xd760,
	0xd771, 0xd781, 0xd791, 0xd7a0, 0xd7b0, 0xd7c0, 0xd7d0, 0xd7df,
	0xd7ef, 0xd800, 0xd810, 0xd820, 0xd82f, 0xd83f, 0xd850, 0xd860,
	0xd86f, 0xd87e, 0xd88c, 0xd89b, 0xd8ab, 0xd8ba, 0xd8ca, 0xd8d9,
	// Entry 3080 - 30BF
	0xd8e8, 0xd8f6, 0xd905, 0xd915, 0xd925, 0xd934, 0xd944, 0xd953,
	0xd962, 0xd970, 0xd97f, 0xd98e, 0xd99c, 0xd9ab, 0xd9ba, 0xd9c8,
	0xd9d7, 0xd9e7, 0xd9f6, 0xda05, 0xda14, 0xda22, 0xda31, 0xda40,
	0xda4f, 0xda5d, 0xda6c, 0xda7b, 0xda8a, 0xda98, 0xdaa7, 0xdab6,
	0xdac4, 0xdad3, 0xdae2, 0xdaf1, 0xdaff, 0xdb0e, 0xdb1e, 0xdb2d,
	0xdb3c, 0xdb4b, 0xdb59, 0xdb68, 0xdb77, 0xdb86, 0xdb94, 0xdba3,
	0xdbb3, 0xdbc3, 0xdbd2, 0xdbe2, 0xdbf1, 0xdc00, 0xdc0e, 0xdc1d,
	0xdc2c, 0xdc3b, 0xdc49, 0xdc58, 0xdc67, 0xdc76, 0xdc85, 0xdc94,
	// Entry 30C0 - 30FF
	0xdca2, 0xdcb1, 0xdcc1, 0xdcd0, 0xdcdf, 0xdcee, 0xdcfc, 0xdd0b,
	0xdd1b, 0xdd2a, 0xdd39, 0xdd48, 0xdd56, 0xdd65, 0xdd75, 0xdd84,
	0xdd94, 0xdda3, 0xddb2, 0xddc0, 0xddcf, 0xdddf, 0xddee, 0xddfd,
	0xde0c, 0xde1a, 0xde29, 0xde38, 0xde46, 0xde55, 0xde64, 0xde73,
	0xde81, 0xde90, 0xdea0, 0xdeaf, 0xdebe, 0xdecd, 0xdedb, 0xdeea,
	0xdefa, 0xdf09, 0xdf19, 0xdf28, 0xdf37, 0xdf45, 0xdf54, 0xdf64,
	0xdf74, 0xdf83, 0xdf93, 0xdfa2, 0xdfb1, 0xdfbf, 0xdfce, 0xdfdd,
	0xdfeb, 0xdffa, 0xe009, 0xe018, 0xe026, 0xe035, 0xe045, 0xe054,
	// Entry 3100 - 313F
	0xe064, 0xe074, 0xe083, 0xe093, 0xe0a4, 0xe0b4, 0xe0c5, 0xe0d5,
	0xe0e5, 0xe0f4, 0xe104, 0xe115, 0xe125, 0xe136, 0xe146, 0xe156,
	0xe165, 0xe175, 0xe185, 0xe194, 0xe1a4, 0xe1b4, 0xe1c4, 0xe1d3,
	0xe1e3, 0xe1f4, 0xe204, 0xe214, 0xe224, 0xe233, 0xe243, 0xe254,
	0xe264, 0xe274, 0xe284, 0xe293, 0xe2a3, 0xe2b3, 0xe2c3, 0xe2d2,
	0xe2e2, 0xe2f2, 0xe301, 0xe311, 0xe321, 0xe331, 0xe340, 0xe350,
	0xe361, 0xe371, 0xe381, 0xe391, 0xe3a0, 0xe3b0, 0xe3c1, 0xe3d2,
	0xe3e2, 0xe3f3, 0xe403, 0xe413, 0xe422, 0xe432, 0xe443, 0xe453,
	// Entry 3140 - 317F
	0xe463, 0xe473, 0xe483, 0xe493, 0xe4a2, 0xe4b2, 0xe4c2, 0xe4d1,
	0xe4e0, 0xe4ee, 0xe4fd, 0xe50d, 0xe51c, 0xe52c, 0xe53b, 0xe549,
	0xe558, 0xe568, 0xe577, 0xe587, 0xe596, 0xe5a5, 0xe5b3, 0xe5c2,
	0xe5d1, 0xe5df, 0xe5ee, 0xe5fd, 0xe60c, 0xe61a, 0xe629, 0xe639,
	0xe648, 0xe658, 0xe668, 0xe677, 0xe687, 0xe698, 0xe6a8, 0xe6b9,
	0xe6c9, 0xe6d9, 0xe6e8, 0xe6f8, 0xe709, 0xe719, 0xe72a, 0xe73a,
	0xe749, 0xe759, 0xe769, 0xe778, 0xe788, 0xe798, 0xe7a8, 0xe7b7,
	0xe7c7, 0xe7d8, 0xe7e8, 0xe7f8, 0xe808, 0xe817, 0xe827, 0xe838,
	// Entry 3180 - 31BF
	0xe848, 0xe857, 0xe866, 0xe874, 0xe883, 0xe893, 0xe8a3, 0xe8b2,
	0xe8c2, 0xe8d1, 0xe8e0, 0xe8ee, 0xe8fd, 0xe90d, 0xe91d, 0xe92c,
	0xe93c, 0xe94b, 0xe95a, 0xe968, 0xe977, 0xe986, 0xe994, 0xe9a3,
	0xe9b2, 0xe9c1, 0xe9cf, 0xe9de, 0xe9ee, 0xe9fd, 0xea0c, 0xea1b,
	0xea29, 0xea38, 0xea48, 0xea57, 0xea66, 0xea75, 0xea83, 0xea92,
	0xeaa2, 0xeab2, 0xeac1, 0xead1, 0xeae0, 0xeaef, 0xeafd, 0xeb0c,
	0xeb1c, 0xeb2c, 0xeb3b, 0xeb4b, 0xeb5a, 0xeb69, 0xeb77, 0xeb86,
	0xeb95, 0xeba4, 0xebb2, 0xebc1, 0xebd0, 0xebdf, 0xebed, 0xebfc,
	// Entry 31C0 - 31FF
	0xec0c, 0xec1b, 0xec2a, 0xec39, 0xec47, 0xec56, 0xec66, 0xec75,
	0xec85, 0xec94, 0xeca3, 0xecb1, 0xecc0, 0xecd0, 0xecdf, 0xecef,
	0xecfe, 0xed0d, 0xed1b, 0xed2a, 0xed39, 0xed48, 0xed56, 0xed65,
	0xed74, 0xed83, 0xed91, 0xeda0, 0xedb0, 0xedbf, 0xedcf, 0xeddf,
	0xedee, 0xedff, 0xee0f, 0xee20, 0xee30, 0xee40, 0xee4f, 0xee5f,
	0xee70, 0xee81, 0xee91, 0xeea2, 0xeeb2, 0xeec2, 0xeed1, 0xeee1,
	0xeef1, 0xef01, 0xef10, 0xef20, 0xef30, 0xef40, 0xef4f, 0xef5f,
	0xef70, 0xef80, 0xef91, 0xefa1, 0xefb1, 0xefc1, 0xefd0, 0xefe0,
	// Entry 3200 - 323F
	0xeff1, 0xf001, 0xf012, 0xf022, 0xf032, 0xf041, 0xf051, 0xf061,
	0xf070, 0xf080, 0xf090, 0xf0a0, 0xf0af, 0xf0bf, 0xf0d0, 0xf0e0,
	0xf0f0, 0xf100, 0xf10f, 0xf11f, 0xf130, 0xf141, 0xf151, 0xf162,
	0xf172, 0xf182, 0xf191, 0xf1a1, 0xf1b2, 0xf1c3, 0xf1d3, 0xf1e4,
	0xf1f4, 0xf204, 0xf213, 0xf223, 0xf233, 0xf242, 0xf252, 0xf263,
	0xf273, 0xf284, 0xf294, 0xf2a4, 0xf2b3, 0xf2c3, 0xf2d4, 0xf2e5,
	0xf2f5, 0xf305, 0xf315, 0xf324, 0xf334, 0xf344, 0xf353, 0xf363,
	0xf372, 0xf382, 0xf391, 0xf3a0, 0xf3af, 0xf3bd, 0xf3cc, 0xf3dc,
	// Entry 3240 - 327F
	0xf3ec, 0xf3fb, 0xf40b, 0xf41a, 0xf429, 0xf437, 0xf446, 0xf455,
	0xf463, 0xf472, 0xf481, 0xf490, 0xf49e, 0xf4ad, 0xf4bd, 0xf4cc,
	0xf4dc, 0xf4eb, 0xf4f9, 0xf508, 0xf517, 0xf525, 0xf534, 0xf543,
	0xf552, 0xf560, 0xf56f, 0xf57f, 0xf58e, 0xf59e, 0xf5ad, 0xf5bc,
	0xf5ca, 0xf5d9, 0xf5e9, 0xf5f8, 0xf608, 0xf617, 0xf626, 0xf634,
	0xf643, 0xf652, 0xf660, 0xf66f, 0xf67e, 0xf68d, 0xf69b, 0xf6aa,
	0xf6ba, 0xf6c9, 0xf6d8, 0xf6e7, 0xf6f5, 0xf704, 0xf714, 0xf723,
	0xf732, 0xf741, 0xf74f, 0xf75e, 0xf76e, 0xf77e, 0xf78d, 0xf79d,
	// Entry 3280 - 32BF
	0xf7ac, 0xf7bb, 0xf7c9, 0xf7d8, 0xf7e8, 0xf7f7, 0xf807, 0xf816,
	0xf825, 0xf833, 0xf842, 0xf851, 0xf85f, 0xf86e, 0xf87d, 0xf88c,
	0xf89a, 0xf8a9, 0xf8b9, 0xf8c8, 0xf8d7, 0xf8e6, 0xf8f4, 0xf903,
	0xf913, 0xf922, 0xf932, 0xf942, 0xf951, 0xf961, 0xf972, 0xf983,
	0xf993, 0xf9a4, 0xf9b4, 0xf9c4, 0xf9d3, 0xf9e3, 0xf9f3, 0xfa02,
	0xfa12, 0xfa22, 0xfa31, 0xfa41, 0xfa51, 0xfa60, 0xfa70, 0xfa81,
	0xfa91, 0xfaa1, 0xfab1, 0xfac0, 0xfad0, 0xfae1, 0xfaf1, 0xfb01,
	0xfb11, 0xfb20, 0xfb30, 0xfb41, 0xfb51, 0xfb62, 0xfb72, 0xfb82,
	// Entry 32C0 - 32FF
	0xfb91, 0xfba1, 0xfbb2, 0xfbc2, 0xfbd2, 0xfbe2, 0xfbf2, 0xfc01,
	0xfc11, 0xfc20, 0xfc30, 0xfc41, 0xfc51, 0xfc61, 0xfc71, 0xfc80,
	0xfc90, 0xfca1, 0xfcb1, 0xfcc0, 0xfccf, 0xfcdd, 0xfcec, 0xfcfc,
	0xfd0b, 0xfd1b, 0xfd2a, 0xfd39, 0xfd47, 0xfd56, 0xfd66, 0xfd75,
	0xfd85, 0xfd94, 0xfda3, 0xfdb1, 0xfdc0, 0xfdcf, 0xfddd, 0xfdec,
	0xfdfb, 0xfe0a, 0xfe18, 0xfe27, 0xfe37, 0xfe46, 0xfe55, 0xfe64,
	0xfe72, 0xfe81, 0xfe91, 0xfea0, 0xfeb0, 0xfec0, 0xfecf, 0xfedf,
	0xfef0, 0xff00, 0xff11, 0xff21, 0xff31, 0xff40, 0xff50, 0xff60,
	// Entry 3300 - 333F
	0xff70, 0xff7f, 0xff8f, 0xff9f, 0xffae, 0xffbe, 0xffce, 0xffde,
	0xffed, 0xfffd, 0x000d, 0x001d, 0x002c, 0x003c, 0x004d, 0x005d,
	0x006d, 0x007d, 0x008c, 0x009c, 0x00ad, 0x00bd, 0x00ce, 0x00de,
	0x00ee, 0x00fd, 0x010d, 0x011d, 0x012d, 0x013c, 0x014c, 0x015c,
	0x016c, 0x017b, 0x018b, 0x019c, 0x01ac, 0x01bc, 0x01cc, 0x01db,
	0x01eb, 0x01fc, 0x020c, 0x021c, 0x022c, 0x023b, 0x024b, 0x025c,
	0x026d, 0x027d, 0x028e, 0x029e, 0x02ae, 0x02bd, 0x02cd, 0x02dd,
	0x02ed, 0x02fc, 0x030c, 0x031c, 0x032b, 0x033b, 0x034c, 0x035c,
	// Entry 3340 - 337F
	0x036c, 0x037c, 0x038b, 0x039b, 0x03ac, 0x03bc, 0x03cc, 0x03db,
	0x03ec, 0x03fc, 0x040c, 0x041c, 0x042b, 0x043b, 0x044b, 0x045b,
	0x046a, 0x047a, 0x048a, 0x049a, 0x04a9, 0x04b9, 0x04ca, 0x04da,
	0x04ea, 0x04fa, 0x0509, 0x0519, 0x052a, 0x053a, 0x054a, 0x055a,
	0x0569, 0x0579, 0x0589, 0x0598, 0x05a8, 0x05b8, 0x05c8, 0x05d7,
	0x05e7, 0x05f7, 0x0607, 0x0616, 0x0626, 0x0637, 0x0647, 0x0657,
	0x0667, 0x0676, 0x0686, 0x0697, 0x06a7, 0x06b7, 0x06c7, 0x06d6,
	0x06e6, 0x06f7, 0x0707, 0x0718, 0x0728, 0x0738, 0x0747, 0x0757,
	// Entry 3380 - 33BF
	0x0767, 0x0777, 0x0786, 0x0796, 0x07a6, 0x07b6, 0x07c5, 0x07d5,
	0x07e6, 0x07f6, 0x0806, 0x0816, 0x0825, 0x0835, 0x0846, 0x0856,
	0x0865, 0x0874, 0x0882, 0x0891, 0x08a1, 0x08b0, 0x08c0, 0x08cf,
	0x08de, 0x08ec, 0x08fb, 0x090a, 0x0918, 0x0927, 0x0936, 0x0945,
	0x0953, 0x0962, 0x0972, 0x0981, 0x0990, 0x099f, 0x09ad, 0x09bc,
	0x09cc, 0x09db, 0x09ea, 0x09f9, 0x0a07, 0x0a16, 0x0a26, 0x0a36,
	0x0a45, 0x0a55, 0x0a65, 0x0a75, 0x0a84, 0x0a94, 0x0aa3, 0x0ab2,
	0x0ac0, 0x0acf, 0x0ade, 0x0aed, 0x0afb, 0x0b0a, 0x0b1a, 0x0b29,
	// Entry 33C0 - 33FF
	0x0b38, 0x0b47, 0x0b55, 0x0b64, 0x0b74, 0x0b83, 0x0b92, 0x0ba1,
	0x0baf, 0x0bbe, 0x0bce, 0x0bde, 0x0bed, 0x0bfd, 0x0c0d, 0x0c1d,
	0x0c2c, 0x0c3c, 0x0c4b, 0x0c5a, 0x0c68, 0x0c77, 0x0c86, 0x0c95,
	0x0ca3, 0x0cb2, 0x0cc2, 0x0cd1, 0x0ce0, 0x0cef, 0x0cfd, 0x0d0c,
	0x0d1c, 0x0d2b, 0x0d3b, 0x0d4b, 0x0d5a, 0x0d6a, 0x0d7b, 0x0d8c,
	0x0d9c, 0x0dad, 0x0dbe, 0x0dce, 0x0ddf, 0x0def, 0x0dff, 0x0e0e,
	0x0e1e, 0x0e2e, 0x0e3e, 0x0e4d, 0x0e5d, 0x0e6e, 0x0e7e, 0x0e8e,
	0x0e9e, 0x0ead, 0x0ebd, 0x0ecd, 0x0edd, 0x0eec, 0x0efc, 0x0f0d,
	// Entry 3400 - 343F
	0x0f1e, 0x0f2e, 0x0f3f, 0x0f50, 0x0f60, 0x0f70, 0x0f80, 0x0f8f,
	0x0f9f, 0x0faf, 0x0fbe, 0x0fce, 0x0fdf, 0x0fef, 0x0fff, 0x100f,
	0x101e, 0x102e, 0x103f, 0x104f, 0x105f, 0x106f, 0x107e, 0x108e,
	0x109f, 0x10b0, 0x10c0, 0x10d1, 0x10e2, 0x10f2, 0x1103, 0x1113,
	0x1123, 0x1132, 0x1142, 0x1152, 0x1162, 0x1171, 0x1181, 0x1190,
	0x119f, 0x11ad, 0x11bc, 0x11cc, 0x11dc, 0x11eb, 0x11fb, 0x120b,
	0x121a, 0x1229, 0x1238, 0x1246, 0x1255, 0x1264, 0x1273, 0x1281,
	0x1290, 0x12a0, 0x12af, 0x12be, 0x12cd, 0x12db, 0x12ea, 0x12fa,
	// Entry 3440 - 347F
	0x130a, 0x1319, 0x1329, 0x1339, 0x1349, 0x1358, 0x1368, 0x1377,
	0x1386, 0x1394, 0x13a3, 0x13b2, 0x13c1, 0x13cf, 0x13de, 0x13ee,
	0x13fd, 0x140c, 0x141b, 0x1429, 0x1438, 0x1448, 0x1457, 0x1465,
	0x1472, 0x1480, 0x148f, 0x149d, 0x14ab, 0x14ba, 0x14c8, 0x14d5,
	0x14e4, 0x14f2, 0x1501, 0x150f, 0x151c, 0x152a, 0x1539, 0x1547,
	0x1554, 0x1562, 0x1570, 0x157f, 0x158d, 0x159c, 0x15ab, 0x15b8,
	0x15c5, 0x15d4, 0x15e2, 0x15f0, 0x15fe, 0x160c, 0x161a, 0x1628,
	0x1636, 0x1643, 0x1650, 0x165f, 0x166d, 0x167b, 0x168a, 0x1697,
	// Entry 3480 - 34BF
	0x16a4, 0x16b3, 0x16c1, 0x16ce, 0x16dd, 0x16eb, 0x16fa, 0x1709,
	0x1717, 0x1726, 0x1734, 0x1744, 0x1753, 0x1760, 0x176e, 0x177c,
	0x178b, 0x1799, 0x17a7, 0x17b6, 0x17c4, 0x17d2, 0x17e1, 0x17ef,
	0x17fd, 0x180c, 0x181b, 0x182a, 0x183a, 0x1848, 0x1856, 0x1864,
	0x1872, 0x1881, 0x188f, 0x189e, 0x18ac, 0x18ba, 0x18c9, 0x18d7,
	0x18e5, 0x18f4, 0x1902, 0x1911, 0x191e, 0x192c, 0x1939, 0x1947,
	0x1954, 0x1961, 0x196e, 0x197c, 0x198a, 0x1998, 0x19af, 0x19c5,
	0x19dd, 0x19f4, 0x1a0b, 0x1a23, 0x1a39, 0x1a53, 0x1a62, 0x1a72,
	// Entry 34C0 - 34FF
	0x1a82, 0x1a92, 0x1aa3, 0x1ab3, 0x1ac4, 0x1ad4, 0x1ae5, 0x1af6,
	0x1b08, 0x1b19, 0x1b29, 0x1b39, 0x1b49, 0x1b5a, 0x1b6b, 0x1b7d,
	0x1b8d, 0x1b9d, 0x1bad, 0x1bbe, 0x1bce, 0x1bdf, 0x1bef, 0x1c00,
	0x1c10, 0x1c20, 0x1c31, 0x1c41, 0x1c51, 0x1c63, 0x1c73, 0x1c83,
	0x1c93, 0x1ca4, 0x1cb2, 0x1cc1, 0x1cd0, 0x1ce0, 0x1cef, 0x1cff,
	0x1d0e, 0x1d1e, 0x1d2d, 0x1d3d, 0x1d4d, 0x1d5e, 0x1d6e, 0x1d7d,
	0x1d8c, 0x1d9b, 0x1dab, 0x1dbb, 0x1dcc, 0x1ddb, 0x1dea, 0x1df9,
	0x1e09, 0x1e18, 0x1e28, 0x1e37, 0x1e47, 0x1e56, 0x1e65, 0x1e75,
	// Entry 3500 - 353F
	0x1e84, 0x1e93, 0x1ea4, 0x1eb3, 0x1ec2, 0x1ed1, 0x1ee1, 0x1eef,
	0x1efe, 0x1f0f, 0x1f1e, 0x1f2e, 0x1f3d, 0x1f4d, 0x1f5c, 0x1f6c,
	0x1f7b, 0x1f8b, 0x1f9b, 0x1fac, 0x1fbd, 0x1fcd, 0x1fdc, 0x1feb,
	0x1ffa, 0x200a, 0x201a, 0x202b, 0x203a, 0x2049, 0x2058, 0x2068,
	0x2077, 0x2087, 0x2096, 0x20a6, 0x20b5, 0x20c4, 0x20d4, 0x20e3,
	0x20f2, 0x2102, 0x2113, 0x2122, 0x2131, 0x2140, 0x2150, 0x215f,
	0x216f, 0x217f, 0x218f, 0x21a0, 0x21b0, 0x21c1, 0x21d1, 0x21e2,
	0x21f3, 0x2205, 0x2216, 0x2226, 0x2236, 0x2246, 0x2257, 0x2268,
	// Entry 3540 - 357F
	0x227a, 0x228a, 0x229a, 0x22aa, 0x22bb, 0x22cb, 0x22dc, 0x22ec,
	0x22fd, 0x230d, 0x231d, 0x232e, 0x233e, 0x234e, 0x2360, 0x2370,
	0x2380, 0x2390, 0x23a1, 0x23af, 0x23be, 0x23cd, 0x23dd, 0x23ec,
	0x23fc, 0x240b, 0x241b, 0x242a, 0x243a, 0x244a, 0x245b, 0x246b,
	0x247a, 0x2489, 0x2498, 0x24a8, 0x24b8, 0x24c9, 0x24d8, 0x24e7,
	0x24f6, 0x2506, 0x2515, 0x2525, 0x2534, 0x2544, 0x2553, 0x2562,
	0x2572, 0x2581, 0x2590, 0x25a1, 0x25b0, 0x25bf, 0x25ce, 0x25de,
	0x25ec, 0x25fb, 0x260c, 0x261b, 0x262b, 0x263a, 0x264a, 0x2659,
	// Entry 3580 - 35BF
	0x2669, 0x2678, 0x2688, 0x2698, 0x26a9, 0x26b9, 0x26ca, 0x26d9,
	0x26e8, 0x26f7, 0x2707, 0x2717, 0x2728, 0x2737, 0x2746, 0x2755,
	0x2765, 0x2774, 0x2784, 0x2793, 0x27a3, 0x27b2, 0x27c1, 0x27d1,
	0x27e0, 0x27ef, 0x2800, 0x280f, 0x281e, 0x282d, 0x283d, 0x284b,
	0x285a, 0x286b, 0x287a, 0x288a, 0x2899, 0x28a9, 0x28b8, 0x28c8,
	0x28d7, 0x28e7, 0x28f7, 0x2908, 0x2919, 0x2929, 0x293a, 0x2949,
	0x2958, 0x2967, 0x2977, 0x2987, 0x2998, 0x29a7, 0x29b6, 0x29c5,
	0x29d5, 0x29e4, 0x29f4, 0x2a03, 0x2a13, 0x2a22, 0x2a31, 0x2a41,
	// Entry 35C0 - 35FF
	0x2a50, 0x2a5f, 0x2a70, 0x2a82, 0x2a91, 0x2aa1, 0x2ab0, 0x2abf,
	0x2acf, 0x2ade, 0x2af5, 0x2afe, 0x2b0b, 0x2b1c, 0x2b31, 0x2b46,
	0x2b5c, 0x2b6c, 0x2b7c, 0x2b8b, 0x2b99, 0x2ba8, 0x2bb6, 0x2bc4,
	0x2bd3, 0x2be3, 0x2bf2, 0x2c01, 0x2c10, 0x2c1f, 0x2c2d, 0x2c3a,
	0x2c47, 0x2c56, 0x2c64, 0x2c72, 0x2c7f, 0x2c8e, 0x2c9d, 0x2cab,
	0x2cc0, 0x2cd5, 0x2cf3, 0x2d0f, 0x2d2c, 0x2d47, 0x2d6b, 0x2d8d,
	0x2da9, 0x2dc3, 0x2de0, 0x2dfb, 0x2e1f, 0x2e41, 0x2e64, 0x2e85,
	0x2ea8, 0x2ec9, 0x2ef3, 0x2f1b, 0x2f3f, 0x2f61, 0x2f84, 0x2fa5,
	// Entry 3600 - 363F
	0x2fc7, 0x2fe7, 0x3010, 0x3037, 0x305a, 0x307b, 0x30ad, 0x30dd,
	0x30f7, 0x310f, 0x3133, 0x3155, 0x3174, 0x3191, 0x31b0, 0x31cd,
	0x31ec, 0x3209, 0x322c, 0x324d, 0x3270, 0x3291, 0x32bb, 0x32e3,
	0x3300, 0x3318, 0x333c, 0x3364, 0x338d, 0x339e, 0x33c4, 0x33df,
	0x33fb, 0x3416, 0x3439, 0x3457, 0x347a, 0x3499, 0x34b2, 0x34cc,
	0x34db, 0x34eb, 0x3506, 0x351f, 0x353b, 0x3555, 0x3571, 0x358b,
	0x35a7, 0x35c1, 0x35dd, 0x35f7, 0x3622, 0x364b, 0x3666, 0x367f,
	0x369b, 0x36b5, 0x36d1, 0x36eb, 0x3707, 0x3721, 0x373c, 0x3755,
	// Entry 3640 - 367F
	0x3771, 0x378b, 0x37ab, 0x37c9, 0x37ea, 0x3809, 0x382b, 0x384d,
	0x3869, 0x388d, 0x389b, 0x38aa, 0x38b8, 0x38c7, 0x38d6, 0x38e6,
	0x38f6, 0x3904, 0x3914, 0x3922, 0x3931, 0x3940, 0x3950, 0x3961,
	0x3973, 0x3985, 0x3995, 0x39a6, 0x39b8, 0x39c6, 0x39d6, 0x39e5,
	0x39f6, 0x3a05, 0x3a17, 0x3a28, 0x3a39, 0x3a49, 0x3a5a, 0x3a69,
	0x3a7b, 0x3a8b, 0x3a9b, 0x3aab, 0x3aba, 0x3acb, 0x3adc, 0x3aed,
	0x3afe, 0x3b0f, 0x3b1f, 0x3b2f, 0x3b3f, 0x3b4f, 0x3b5e, 0x3b6d,
	0x3b7c, 0x3b8b, 0x3b9c, 0x3bac, 0x3bbc, 0x3bd0, 0x3be1, 0x3bf1,
	// Entry 3680 - 36BF
	0x3c01, 0x3c12, 0x3c21, 0x3c31, 0x3c40, 0x3c4f, 0x3c5e, 0x3c6d,
	0x3c7d, 0x3c8c, 0x3c9d, 0x3cad, 0x3cbd, 0x3ccc, 0x3cdb, 0x3cea,
	0x3cf9, 0x3d0a, 0x3d1a, 0x3d2a, 0x3d3a, 0x3d4b, 0x3d5d, 0x3d70,
	0x3d82, 0x3d95, 0x3db1, 0x3dcf, 0x3ddc, 0x3deb, 0x3df6, 0x3e01,
	0x3e10, 0x3e23, 0x3e48, 0x3e6e, 0x3e94, 0x3ebb, 0x3ede, 0x3f02,
	0x3f25, 0x3f49, 0x3f73, 0x3f97, 0x3fba, 0x3fdd, 0x4006, 0x403a,
	0x4068, 0x4095, 0x40c2, 0x40f5, 0x4122, 0x4149, 0x416f, 0x4195,
	0x41c1, 0x41e1, 0x41fa, 0x421c, 0x4244, 0x4263, 0x4284, 0x42ab,
	// Entry 36C0 - 36FF
	0x42db, 0x4308, 0x432c, 0x434f, 0x4376, 0x439b, 0x43c1, 0x43e5,
	0x43fe, 0x4415, 0x442c, 0x4441, 0x445e, 0x4479, 0x4497, 0x44b3,
	0x44dc, 0x4503, 0x451f, 0x453b, 0x4552, 0x4567, 0x457e, 0x4593,
	0x45aa, 0x45bf, 0x45d6, 0x45eb, 0x4616, 0x463f, 0x4656, 0x466b,
	0x4693, 0x46b9, 0x46db, 0x46fb, 0x4726, 0x474f, 0x4785, 0x47b9,
	0x47d6, 0x47f1, 0x4818, 0x483d, 0x486c, 0x4899, 0x48b9, 0x48d7,
	0x48ee, 0x4903, 0x4937, 0x4969, 0x498d, 0x49af, 0x49d8, 0x49ff,
	0x4a33, 0x4a65, 0x4a90, 0x4ab9, 0x4ad7, 0x4af3, 0x4b13, 0x4b31,
	// Entry 3700 - 373F
	0x4b5c, 0x4b85, 0x4b9c, 0x4bb1, 0x4bd2, 0x4bf1, 0x4c17, 0x4c3b,
	0x4c73, 0x4ca9, 0x4cc2, 0x4cd9, 0x4cf0, 0x4d05, 0x4d1c, 0x4d31,
	0x4d49, 0x4d5f, 0x4d71, 0x4d87, 0x4d9d, 0x4db3, 0x4dc9, 0x4ddf,
	0x4dfd, 0x4e13, 0x4e28, 0x4e46, 0x4e62, 0x4e80, 0x4e9c, 0x4eba,
	0x4edf, 0x4f02, 0x4f1f, 0x4f3a, 0x4f58, 0x4f74, 0x4f92, 0x4fae,
	0x4fcc, 0x4fe8, 0x500d, 0x5022, 0x5043, 0x5060, 0x507b, 0x5098,
	0x50c9, 0x50e5, 0x510a, 0x512d, 0x514c, 0x5169, 0x518f, 0x51b5,
	0x51d9, 0x51fb, 0x521d, 0x523d, 0x525c, 0x5279, 0x5298, 0x52b5,
	// Entry 3740 - 377F
	0x52d4, 0x52f1, 0x531b, 0x5343, 0x536d, 0x5395, 0x53bf, 0x53e7,
	0x5411, 0x5439, 0x5463, 0x548b, 0x54ab, 0x54cf, 0x54ec, 0x550c,
	0x5530, 0x554c, 0x5569, 0x5586, 0x55ae, 0x55c6, 0x55df, 0x55f6,
	0x5610, 0x5628, 0x564a, 0x566a, 0x5688, 0x56a4, 0x56c2, 0x56de,
	0x56fc, 0x5718, 0x5739, 0x5758, 0x5778, 0x5796, 0x57be, 0x57de,
	0x5806, 0x5836, 0x5864, 0x5894, 0x58c2, 0x58e7, 0x590a, 0x5929,
	0x5947, 0x596a, 0x598b, 0x59a9, 0x59c5, 0x59de, 0x59f7, 0x5a10,
	0x5a34, 0x5a56, 0x5a78, 0x5a9d, 0x5abe, 0x5ae1, 0x5b03, 0x5b25,
	// Entry 3780 - 37BF
	0x5b47, 0x5b66, 0x5b87, 0x5b9c, 0x5bb1, 0x5bcb, 0x5be0, 0x5bf5,
	0x5c0a, 0x5c23, 0x5c39, 0x5c50, 0x5c66, 0x5c7d, 0x5c97, 0x5cad,
	0x5cc4, 0x5cda, 0x5cf1, 0x5d08, 0x5d20, 0x5d37, 0x5d4f, 0x5d65,
	0x5d7c, 0x5d92, 0x5da9, 0x5dbf, 0x5dd5, 0x5dec, 0x5e02, 0x5e19,
	0x5e2f, 0x5e45, 0x5e5b, 0x5e72, 0x5e88, 0x5e9e, 0x5eb7, 0x5ed0,
	0x5ee9, 0x5f02, 0x5f1c, 0x5f36, 0x5f50, 0x5f6a, 0x5f84, 0x5fa7,
	0x5fc7, 0x5fe4, 0x6007, 0x6029, 0x6048, 0x606d, 0x6085, 0x60a1,
	0x60b7, 0x60d0, 0x60e2, 0x60f5, 0x6107, 0x611a, 0x612c, 0x613f,
	// Entry 37C0 - 37FF
	0x6151, 0x6164, 0x6176, 0x6189, 0x619b, 0x61ad, 0x61bf, 0x61d2,
	0x61e4, 0x61f6, 0x6209, 0x621d, 0x6230, 0x6242, 0x6255, 0x6267,
	0x627e, 0x6290, 0x62a2, 0x62b4, 0x62c7, 0x62d9, 0x62eb, 0x62fc,
	0x630d, 0x631e, 0x632f, 0x6340, 0x6352, 0x6364, 0x6376, 0x6389,
	0x639b, 0x63b7, 0x63d3, 0x63e6, 0x63fa, 0x640d, 0x6420, 0x643c,
	0x6459, 0x6472, 0x648e, 0x64aa, 0x64c7, 0x64e2, 0x64fb, 0x6514,
	0x6526, 0x653f, 0x6557, 0x656e, 0x6581, 0x6595, 0x65a8, 0x65bc,
	0x65cf, 0x65e3, 0x65fe, 0x661a, 0x6635, 0x6651, 0x6664, 0x6678,
	// Entry 3800 - 383F
	0x668c, 0x669f, 0x66b3, 0x66c7, 0x66db, 0x66f0, 0x6704, 0x6719,
	0x672e, 0x6742, 0x6757, 0x676b, 0x6780, 0x6795, 0x67aa, 0x67c0,
	0x67d5, 0x67eb, 0x6800, 0x6814, 0x6829, 0x683d, 0x6852, 0x6866,
	0x687a, 0x688f, 0x68a3, 0x68b8, 0x68cc, 0x68e0, 0x68f4, 0x6908,
	0x691c, 0x6931, 0x6946, 0x695a, 0x696e, 0x6983, 0x69a2, 0x69ba,
	0x69d1, 0x69e9, 0x6a00, 0x6a18, 0x6a37, 0x6a57, 0x6a76, 0x6a96,
	0x6aad, 0x6ac5, 0x6add, 0x6af4, 0x6b0c, 0x6b24, 0x6b3a, 0x6b55,
	0x6b65, 0x6b7c, 0x6b91, 0x6ba5, 0x6bb9, 0x6bcf, 0x6be4, 0x6bf9,
	// Entry 3840 - 387F
	0x6c0d, 0x6c23, 0x6c39, 0x6c4e, 0x6c6d, 0x6c8b, 0x6ca9, 0x6cc9,
	0x6ce8, 0x6d07, 0x6d25, 0x6d45, 0x6d65, 0x6d84, 0x6da1, 0x6dbe,
	0x6ddc, 0x6dfa, 0x6e18, 0x6e36, 0x6e54, 0x6e76, 0x6e99, 0x6ebb,
	0x6ee4, 0x6f03, 0x6f24, 0x6f48, 0x6f60, 0x6f75, 0x6f85, 0x6f9a,
	0x6fb1, 0x6fc3, 0x6fd7, 0x6fef, 0x7002, 0x7014, 0x7026, 0x703a,
	0x704d, 0x7060, 0x7072, 0x7086, 0x709a, 0x70ad, 0x70bf, 0x70d2,
	0x70e4, 0x70f7, 0x7109, 0x711c, 0x712e, 0x7141, 0x7153, 0x7166,
	0x7178, 0x718a, 0x719d, 0x71af, 0x71c1, 0x71d3, 0x71e5, 0x71f7,
	// Entry 3880 - 38BF
	0x7209, 0x721b, 0x722e, 0x7240, 0x7252, 0x7264, 0x7275, 0x7287,
	0x7298, 0x72aa, 0x72bb, 0x72cb, 0x72db, 0x72ec, 0x72fc, 0x7310,
	0x7323, 0x733d, 0x734e, 0x7360, 0x7370, 0x7380, 0x7391, 0x73a1,
	0x73b1, 0x73c1, 0x73d1, 0x73e1, 0x73f1, 0x7401, 0x7411, 0x7422,
	0x7432, 0x7442, 0x7452, 0x7462, 0x7472, 0x7482, 0x7493, 0x74a5,
	0x74b6, 0x74c8, 0x74d7, 0x74ea, 0x74fd, 0x7510, 0x7524, 0x7537,
	0x754b, 0x755f, 0x7573, 0x758b, 0x75a2, 0x75b9, 0x75d0, 0x75dd,
	0x75f0, 0x760c, 0x7628, 0x7643, 0x765f, 0x767b, 0x769c, 0x76b8,
	// Entry 38C0 - 38FF
	0x76d9, 0x76f4, 0x770f, 0x772f, 0x7752, 0x776c, 0x7787, 0x77a4,
	0x77c0, 0x77dc, 0x77f6, 0x7818, 0x7835, 0x7850, 0x786f, 0x788a,
	0x78a5, 0x78c5, 0x78e1, 0x78fe, 0x7918, 0x7938, 0x794f, 0x7962,
	0x7975, 0x798a, 0x799b, 0x79b1, 0x79c2, 0x79d4, 0x79e5, 0x79fd,
	0x7a16, 0x7a37, 0x7a48, 0x7a5a, 0x7a6b, 0x7a7d, 0x7a95, 0x7aad,
	0x7abf, 0x7ad7, 0x7aea, 0x7afc, 0x7b14, 0x7b26, 0x7b3f, 0x7b5b,
	0x7b6e, 0x7b81, 0x7b9e, 0x7bb1, 0x7bce, 0x7be6, 0x7bf8, 0x7c10,
	0x7c22, 0x7c3e, 0x7c50, 0x7c62, 0x7c7a, 0x7c8c, 0x7ca4, 0x7cb6,
	// Entry 3900 - 393F
	0x7cc8, 0x7cda, 0x7cf2, 0x7d04, 0x7d16, 0x7d2e, 0x7d4a, 0x7d5c,
	0x7d6e, 0x7d86, 0x7da0, 0x7dba, 0x7dd2, 0x7df0, 0x7e08, 0x7e27,
	0x7e41, 0x7e5f, 0x7e78, 0x7e95, 0x7eb4, 0x7ed1, 0x7ee1, 0x7ef8,
	0x7f10, 0x7f23, 0x7f36, 0x7f49, 0x7f5c, 0x7f71, 0x7f85, 0x7f99,
	0x7fab, 0x7fc2, 0x7fd7, 0x7ff3, 0x8007, 0x801a, 0x802c, 0x803e,
	0x8052, 0x8065, 0x8078, 0x808a, 0x809e, 0x80b2, 0x80c5, 0x80e0,
	0x80f7, 0x810e, 0x8125, 0x813c, 0x8153, 0x816a, 0x817f, 0x81a9,
	0x81c5, 0x81e0, 0x81fb, 0x8217, 0x8232, 0x824e, 0x826a, 0x8287,
	// Entry 3940 - 397F
	0x82a3, 0x82bf, 0x82da, 0x82f5, 0x8312, 0x832e, 0x834a, 0x8365,
	0x8382, 0x839f, 0x83bb, 0x83d7, 0x83f2, 0x840e, 0x8429, 0x8445,
	0x8452, 0x845f, 0x846c, 0x8479, 0x8487, 0x8494, 0x84a2, 0x84b1,
	0x84bf, 0x84ce, 0x84de, 0x84ed, 0x84fc, 0x850c, 0x851a, 0x8529,
	0x8539, 0x8548, 0x8558, 0x8566, 0x8575, 0x8583, 0x8592, 0x85a1,
	0x85af, 0x85be, 0x85cc, 0x85db, 0x85ea, 0x85f8, 0x8607, 0x8616,
	0x8624, 0x8633, 0x8641, 0x864f, 0x865d, 0x866b, 0x867a, 0x8688,
	0x8696, 0x86a8, 0x86b9, 0x86cb, 0x86dd, 0x86ee, 0x8700, 0x8711,
	// Entry 3980 - 39BF
	0x8723, 0x8735, 0x8747, 0x875d, 0x8773, 0x8789, 0x879f, 0x87b2,
	0x87c5, 0x87d9, 0x87f5, 0x8809, 0x881c, 0x882f, 0x8842, 0x8855,
	0x8868, 0x887b, 0x888f, 0x88aa, 0x88c5, 0x88d4, 0x88e2, 0x88f0,
	0x8900, 0x890f, 0x891e, 0x892c, 0x893c, 0x894c, 0x895b, 0x8972,
	0x8988, 0x89a5, 0x89c2, 0x89da, 0x89f2, 0x8a0b, 0x8a23, 0x8a3c,
	0x8a55, 0x8a6e, 0x8a88, 0x8aa1, 0x8abb, 0x8ad4, 0x8aec, 0x8b04,
	0x8b1c, 0x8b35, 0x8b4d, 0x8b79, 0x8b91, 0x8ba9, 0x8bc1, 0x8bdc,
	0x8bf6, 0x8c10, 0x8c30, 0x8c48, 0x8c60, 0x8c77, 0x8c92, 0x8caf,
	// Entry 39C0 - 39FF
	0x8ccc, 0x8ceb, 0x8d0a, 0x8d20, 0x8d37, 0x8d4e, 0x8d66, 0x8d7e,
	0x8d97, 0x8dad, 0x8dc4, 0x8ddb, 0x8df3, 0x8e09, 0x8e20, 0x8e37,
	0x8e4f, 0x8e65, 0x8e7c, 0x8e93, 0x8eab, 0x8ec1, 0x8ed8, 0x8eee,
	0x8f05, 0x8f1c, 0x8f34, 0x8f4a, 0x8f61, 0x8f77, 0x8f8e, 0x8fa4,
	0x8fbb, 0x8fd2, 0x8fea, 0x9000, 0x9017, 0x902d, 0x9044, 0x905a,
	0x9071, 0x9087, 0x909e, 0x90b4, 0x90cb, 0x90e1, 0x90f8, 0x910e,
	0x9125, 0x913a, 0x9150, 0x9161, 0x9172, 0x9182, 0x9193, 0x91a3,
	0x91b3, 0x91c3, 0x91d4, 0x91e5, 0x91f7, 0x9208, 0x921a, 0x922b,
	// Entry 3A00 - 3A3F
	0x923c, 0x924d, 0x9261, 0x9278, 0x928d, 0x92a3, 0x92b6, 0x92cb,
	0x92de, 0x92f4, 0x930b, 0x9320, 0x9335, 0x934c, 0x9363, 0x937a,
	0x9392, 0x93a9, 0x93c1, 0x93d8, 0x93ef, 0x9406, 0x9420, 0x943a,
	0x9455, 0x946f, 0x948a, 0x949f, 0x94b8, 0x94c9, 0x94ee, 0x950f,
	0x952e, 0x9541, 0x9557, 0x956d, 0x9584, 0x959b, 0x95b1, 0x95c7,
	0x95dd, 0x95f3, 0x960a, 0x9621, 0x9637, 0x964d, 0x9662, 0x9677,
	0x968d, 0x96a3, 0x96b8, 0x96cd, 0x96e4, 0x96fb, 0x9712, 0x972a,
	0x9742, 0x9759, 0x9770, 0x9785, 0x979a, 0x97af, 0x97c5, 0x97db,
	// Entry 3A40 - 3A7F
	0x97f0, 0x9805, 0x9824, 0x9847, 0x9867, 0x9882, 0x98a4, 0x98be,
	0x98eb, 0x9914, 0x9941, 0x9966, 0x998c, 0x99b2, 0x99da, 0x99fa,
	0x9a26, 0x9a4b, 0x9a69, 0x9a91, 0x9ac4, 0x9ae6, 0x9b14, 0x9b30,
	0x9b5b, 0x9b7e, 0x9b99, 0x9bbf, 0x9bec, 0x9c07, 0x9c2c, 0x9c4b,
	0x9c74, 0x9ca1, 0x9cb6, 0x9cd2, 0x9cf5, 0x9d0b, 0x9d35, 0x9d5f,
	0x9d87, 0x9dae, 0x9de8, 0x9e1a, 0x9e43, 0x9e65, 0x9e7f, 0x9eab,
	0x9ed4, 0x9efa, 0x9f16, 0x9f33, 0x9f4d, 0x9f62, 0x9f83, 0x9fa3,
	0x9fd4, 0xa005, 0xa032, 0xa050, 0xa069, 0xa083, 0xa09a, 0xa0b1,
	// Entry 3A80 - 3ABF
	0xa0c8, 0xa0df, 0xa0f6, 0xa10d, 0xa125, 0xa13d, 0xa155, 0xa16d,
	0xa185, 0xa19d, 0xa1b5, 0xa1cd, 0xa1e5, 0xa1fd, 0xa215, 0xa22d,
	0xa245, 0xa25d, 0xa275, 0xa28d, 0xa2a5, 0xa2bd, 0xa2d5, 0xa2ed,
	0xa305, 0xa31d, 0xa335, 0xa34d, 0xa365, 0xa37e, 0xa397, 0xa3af,
	0xa3c7, 0xa3df, 0xa3f7, 0xa40f, 0xa428, 0xa441, 0xa45a, 0xa473,
	0xa48c, 0xa4a5, 0xa4bd, 0xa4d4, 0xa4ec, 0xa504, 0xa51c, 0xa534,
	0xa54c, 0xa564, 0xa57c, 0xa594, 0xa5ac, 0xa5c4, 0xa5dc, 0xa5f4,
	0xa60c, 0xa624, 0xa63d, 0xa656, 0xa66f, 0xa688, 0xa6a1, 0xa6ba,
	// Entry 3AC0 - 3AFF
	0xa6d3, 0xa6ec, 0xa705, 0xa71e, 0xa737, 0xa750, 0xa769, 0xa781,
	0xa799, 0xa7b1, 0xa7c9, 0xa7e1, 0xa7f9, 0xa811, 0xa828, 0xa83f,
	0xa856, 0xa86d, 0xa883, 0xa899, 0xa8b1, 0xa8c8, 0xa8e0, 0xa8f8,
	0xa910, 0xa927, 0xa93f, 0xa956, 0xa96c, 0xa981, 0xa999, 0xa9b2,
	0xa9c9, 0xa9e1, 0xa9f8, 0xaa0e, 0xaa25, 0xaa3c, 0xaa54, 0xaa6c,
	0xaa84, 0xaaa2, 0xaac0, 0xaade, 0xaafb, 0xab18, 0xab36, 0xab55,
	0xab71, 0xab8d, 0xaba9, 0xabc5, 0xabe2, 0xac00, 0xac1c, 0xac3b,
	0xac57, 0xac6c, 0xac81, 0xac97, 0xacae, 0xacc4, 0xacda, 0xacf2,
	// Entry 3B00 - 3B3F
	0xad09, 0xad20, 0xad36, 0xad4e, 0xad66, 0xad7d, 0xad93, 0xada9,
	0xadbe, 0xadd4, 0xadea, 0xae00, 0xae16, 0xae2c, 0xae41, 0xae56,
	0xae6c, 0xae81, 0xae96, 0xaead, 0xaec3, 0xaed9, 0xaeee, 0xaf04,
	0xaf19, 0xaf2e, 0xaf42, 0xaf5a, 0xaf72, 0xaf8e, 0xafac, 0xafc8,
	0xafea, 0xb007, 0xb023, 0xb046, 0xb063, 0xb082, 0xb0a1, 0xb0c3,
	0xb0e6, 0xb109, 0xb12b, 0xb14e, 0xb172, 0xb191, 0xb1b9, 0xb1d7,
	0xb1f3, 0xb214, 0xb22f, 0xb250, 0xb26c, 0xb289, 0xb2ad, 0xb2c9,
	0xb2e4, 0xb306, 0xb322, 0xb340, 0xb35b, 0xb37e, 0xb39f, 0xb3c0,
	// Entry 3B40 - 3B7F
	0xb3dd, 0xb3f8, 0xb415, 0xb432, 0xb44d, 0xb46b, 0xb491, 0xb4b0,
	0xb4cf, 0xb4eb, 0xb50c, 0xb527, 0xb544, 0xb564, 0xb584, 0xb5a4,
	0xb5c4, 0xb5e4, 0xb604, 0xb624, 0xb644, 0xb664, 0xb684, 0xb6a4,
	0xb6c4, 0xb6e4, 0xb704, 0xb724, 0xb744, 0xb764, 0xb784, 0xb7a4,
	0xb7c4, 0xb7e4, 0xb804, 0xb824, 0xb844, 0xb864, 0xb884, 0xb8a4,
	0xb8c4, 0xb8e4, 0xb904, 0xb924, 0xb944, 0xb964, 0xb984, 0xb9a4,
	0xb9c4, 0xb9e4, 0xba04, 0xba24, 0xba44, 0xba64, 0xba84, 0xbaa4,
	0xbac4, 0xbae4, 0xbb04, 0xbb24, 0xbb44, 0xbb64, 0xbb84, 0xbba4,
	// Entry 3B80 - 3BBF
	0xbbc4, 0xbbe4, 0xbc04, 0xbc24, 0xbc44, 0xbc64, 0xbc84, 0xbca4,
	0xbcc4, 0xbce4, 0xbd04, 0xbd24, 0xbd44, 0xbd64, 0xbd84, 0xbda4,
	0xbdc4, 0xbde4, 0xbe04, 0xbe24, 0xbe44, 0xbe64, 0xbe84, 0xbea4,
	0xbec4, 0xbee4, 0xbf04, 0xbf24, 0xbf44, 0xbf64, 0xbf84, 0xbfa4,
	0xbfc4, 0xbfe4, 0xc004, 0xc024, 0xc044, 0xc064, 0xc084, 0xc0a4,
	0xc0c4, 0xc0e4, 0xc104, 0xc124, 0xc144, 0xc164, 0xc184, 0xc1a4,
	0xc1c4, 0xc1e4, 0xc204, 0xc224, 0xc244, 0xc264, 0xc284, 0xc2a4,
	0xc2c4, 0xc2e4, 0xc304, 0xc324, 0xc344, 0xc364, 0xc384, 0xc3a4,
	// Entry 3BC0 - 3BFF
	0xc3c4, 0xc3e4, 0xc404, 0xc424, 0xc444, 0xc464, 0xc484, 0xc4a4,
	0xc4c4, 0xc4e4, 0xc504, 0xc524, 0xc544, 0xc564, 0xc584, 0xc5a4,
	0xc5c4, 0xc5e4, 0xc604, 0xc624, 0xc644, 0xc664, 0xc684, 0xc6a4,
	0xc6c4, 0xc6e4, 0xc704, 0xc724, 0xc744, 0xc764, 0xc784, 0xc7a4,
	0xc7c4, 0xc7e4, 0xc804, 0xc824, 0xc844, 0xc864, 0xc884, 0xc8a4,
	0xc8c4, 0xc8e4, 0xc904, 0xc924, 0xc944, 0xc964, 0xc984, 0xc9a4,
	0xc9c4, 0xc9e4, 0xca04, 0xca24, 0xca44, 0xca64, 0xca84, 0xcaa4,
	0xcac4, 0xcae4, 0xcb04, 0xcb24, 0xcb44, 0xcb64, 0xcb84, 0xcba4,
	// Entry 3C00 - 3C3F
	0xcbc4, 0xcbe4, 0xcc04, 0xcc24, 0xcc44, 0xcc64, 0xcc84, 0xcca4,
	0xccc4, 0xcce4, 0xcd04, 0xcd24, 0xcd44, 0xcd64, 0xcd84, 0xcda4,
	0xcdc4, 0xcde4, 0xce04, 0xce24, 0xce44, 0xce64, 0xce84, 0xcea4,
	0xcec4, 0xcee4, 0xcf04, 0xcf24, 0xcf44, 0xcf64, 0xcf84, 0xcfa4,
	0xcfc4, 0xcfe4, 0xd004, 0xd024, 0xd044, 0xd064, 0xd084, 0xd0a4,
	0xd0c4, 0xd0e4, 0xd104, 0xd124, 0xd144, 0xd164, 0xd184, 0xd1a4,
	0xd1c4, 0xd1e4, 0xd204, 0xd224, 0xd244, 0xd264, 0xd284, 0xd2a4,
	0xd2c4, 0xd2e4, 0xd304, 0xd324, 0xd344, 0xd364, 0xd384, 0xd3a4,
	// Entry 3C40 - 3C7F
	0xd3c4, 0xd3e4, 0xd404, 0xd424, 0xd444, 0xd464, 0xd484, 0xd4a4,
	0xd4c4, 0xd4e4, 0xd504, 0xd524, 0xd544, 0xd564, 0xd584, 0xd5a4,
	0xd5c4, 0xd5e4, 0xd604, 0xd624, 0xd644, 0xd664, 0xd684, 0xd6a4,
	0xd6c4, 0xd6e4, 0xd704, 0xd724, 0xd744, 0xd764, 0xd784, 0xd7a4,
	0xd7c4, 0xd7e4, 0xd804, 0xd824, 0xd844, 0xd864, 0xd884, 0xd8a4,
	0xd8c4, 0xd8e4, 0xd904, 0xd924, 0xd944, 0xd964, 0xd984, 0xd9a4,
	0xd9c4, 0xd9e4, 0xda04, 0xda24, 0xda44, 0xda64, 0xda84, 0xdaa4,
	0xdac4, 0xdae4, 0xdb04, 0xdb24, 0xdb44, 0xdb64, 0xdb84, 0xdba4,
	// Entry 3C80 - 3CBF
	0xdbc4, 0xdbe4, 0xdc04, 0xdc24, 0xdc44, 0xdc64, 0xdc84, 0xdca4,
	0xdcc4, 0xdce4, 0xdd04, 0xdd24, 0xdd44, 0xdd64, 0xdd84, 0xdda4,
	0xddc4, 0xdde4, 0xde04, 0xde24, 0xde44, 0xde64, 0xde84, 0xdea4,
	0xdec4, 0xdee4, 0xdf04, 0xdf24, 0xdf44, 0xdf64, 0xdf84, 0xdfa4,
	0xdfc4, 0xdfe4, 0xe004, 0xe024, 0xe044, 0xe064, 0xe084, 0xe0a4,
	0xe0c4, 0xe0e4, 0xe104, 0xe124, 0xe144, 0xe164, 0xe184, 0xe1a4,
	0xe1c4, 0xe1e4, 0xe204, 0xe224, 0xe244, 0xe264, 0xe284, 0xe2a4,
	0xe2c4, 0xe2e4, 0xe304, 0xe324, 0xe344, 0xe364, 0xe384, 0xe3a4,
	// Entry 3CC0 - 3CFF
	0xe3c4, 0xe3e4, 0xe404, 0xe424, 0xe444, 0xe464, 0xe484, 0xe4a4,
	0xe4c4, 0xe4e4, 0xe504, 0xe524, 0xe544, 0xe564, 0xe584, 0xe5a4,
	0xe5c4, 0xe5e4, 0xe604, 0xe624, 0xe644, 0xe664, 0xe684, 0xe6a4,
	0xe6c4, 0xe6e4, 0xe704, 0xe724, 0xe744, 0xe764, 0xe784, 0xe7a4,
	0xe7c4, 0xe7e4, 0xe804, 0xe824, 0xe844, 0xe864, 0xe884, 0xe8a4,
	0xe8c4, 0xe8e4, 0xe904, 0xe924, 0xe944, 0xe964, 0xe984, 0xe9a4,
	0xe9c4, 0xe9e4, 0xea04, 0xea24, 0xea44, 0xea64, 0xea84, 0xeaa4,
	0xeac4, 0xeae4, 0xeb04, 0xeb24, 0xeb44, 0xeb64, 0xeb84, 0xeba4,
	// Entry 3D00 - 3D3F
	0xebc4, 0xebe4, 0xec04, 0xec24, 0xec44, 0xec64, 0xec84, 0xeca4,
	0xecc4, 0xece4, 0xed04, 0xed24, 0xed44, 0xed64, 0xed84, 0xeda4,
	0xedc4, 0xede4, 0xee04, 0xee24, 0xee44, 0xee64, 0xee84, 0xeea4,
	0xeec4, 0xeee4, 0xef04, 0xef24, 0xef44, 0xef64, 0xef84, 0xefa4,
	0xefc4, 0xefe4, 0xf004, 0xf024, 0xf044, 0xf064, 0xf07b, 0xf092,
	0xf0a9, 0xf0c1, 0xf0d9, 0xf0f6, 0xf10d, 0xf12c, 0xf14b, 0xf16a,
	0xf189, 0xf1a8, 0xf1c4, 0xf1e5, 0xf20a, 0xf228, 0xf23f, 0xf257,
	0xf26c, 0xf282, 0xf29a, 0xf2b6, 0xf2cd, 0xf2e3, 0xf306, 0xf326,
	// Entry 3D40 - 3D7F
	0xf345, 0xf370, 0xf39a, 0xf3b7, 0xf3d5, 0xf3f2, 0xf40f, 0xf42e,
	0xf44d, 0xf468, 0xf485, 0xf4a4, 0xf4c1, 0xf4de, 0xf501, 0xf51e,
	0xf53d, 0xf55a, 0xf577, 0xf597, 0xf5b9, 0xf5d5, 0xf5f4, 0xf611,
	0xf62f, 0xf64d, 0xf66a, 0xf686, 0xf6a1, 0xf6bc, 0xf6d6, 0xf6f0,
	0xf716, 0xf739, 0xf759, 0xf776, 0xf795, 0xf7b3, 0xf7d2, 0xf7ee,
	0xf80c, 0xf829, 0xf84a, 0xf868, 0xf888, 0xf8a7, 0xf8c9, 0xf8e8,
	0xf909, 0xf929, 0xf94a, 0xf968, 0xf988, 0xf9a7, 0xf9c7, 0xf9e4,
	0xfa03, 0xfa21, 0xfa40, 0xfa5c, 0xfa7a, 0xfa97, 0xfab8, 0xfad6,
	// Entry 3D80 - 3DBF
	0xfaf6, 0xfb15, 0xfb35, 0xfb52, 0xfb71, 0xfb8f, 0xfbaf, 0xfbcc,
	0xfbeb, 0xfc09, 0xfc2a, 0xfc48, 0xfc68, 0xfc87, 0xfcaa, 0xfcca,
	0xfcec, 0xfd0d, 0xfd2f, 0xfd4e, 0xfd6f, 0xfd8d, 0xfdac, 0xfdc8,
	0xfde8, 0xfe05, 0xfe24, 0xfe40, 0xfe60, 0xfe7d, 0xfe9e, 0xfebc,
	0xfedc, 0xfefb, 0xff1a, 0xff36, 0xff54, 0xff71, 0xff91, 0xffae,
	0xffcd, 0xffeb, 0x000c, 0x002a, 0x004a, 0x0069, 0x0090, 0x00b4,
	0x00d5, 0x00f3, 0x0113, 0x0132, 0x0160, 0x018b, 0x01af, 0x01d0,
	0x01f3, 0x0215, 0x0240, 0x0268, 0x0292, 0x02bb, 0x02e1, 0x0304,
	// Entry 3DC0 - 3DFF
	0x033b, 0x036f, 0x0386, 0x039d, 0x03b9, 0x03d5, 0x03f3, 0x0411,
	0x0442, 0x0473, 0x0490, 0x04ad, 0x04d4, 0x04fb, 0x0522, 0x0534,
	0x0551, 0x056e, 0x0587, 0x05a5, 0x05c0, 0x05dd, 0x05f9, 0x0616,
	0x0630, 0x064e, 0x0669, 0x0687, 0x06a2, 0x06d0, 0x06ee, 0x0709,
	0x072f, 0x0752, 0x0778, 0x079b, 0x07b8, 0x07d2, 0x07ee, 0x0809,
	0x0846, 0x0882, 0x08be, 0x08f7, 0x0931, 0x0968, 0x09a3, 0x09db,
	0x0a14, 0x0a4a, 0x0a84, 0x0abb, 0x0af5, 0x0b2c, 0x0b65, 0x0b9b,
	0x0bd3, 0x0c26, 0x0c76, 0x0cc8, 0x0ced, 0x0d0f, 0x0d33, 0x0d56,
	// Entry 3E00 - 3E3F
	0x0d92, 0x0dcd, 0x0e09, 0x0e4d, 0x0e88, 0x0eb3, 0x0edd, 0x0f08,
	0x0f33, 0x0f66, 0x0f90, 0x0fbb, 0x0fe5, 0x1010, 0x103b, 0x106e,
	0x1098, 0x10c4, 0x10f0, 0x1124, 0x114f, 0x117a, 0x11a6, 0x11d1,
	0x11fc, 0x1228, 0x1253, 0x127f, 0x12ab, 0x12d6, 0x1302, 0x132e,
	0x1358, 0x1383, 0x13ae, 0x13d8, 0x1403, 0x142e, 0x1458, 0x1483,
	0x14ae, 0x14d9, 0x1504, 0x1531, 0x155e, 0x1589, 0x15b3, 0x15de,
	0x1609, 0x163c, 0x1666, 0x1690, 0x16bb, 0x16ee, 0x1718, 0x1743,
	0x176e, 0x1798, 0x17c3, 0x17ed, 0x1818, 0x184b, 0x1875, 0x18a0,
	// Entry 3E40 - 3E7F
	0x18ca, 0x18f5, 0x1920, 0x1953, 0x197d, 0x19a9, 0x19d4, 0x1a00,
	0x1a2c, 0x1a60, 0x1a8b, 0x1ab7, 0x1ae2, 0x1b0e, 0x1b3a, 0x1b6e,
	0x1b99, 0x1bc4, 0x1bef, 0x1c22, 0x1c4c, 0x1c77, 0x1ca1, 0x1ccc,
	0x1cf7, 0x1d2a, 0x1d54, 0x1d8c, 0x1dc3, 0x1e03, 0x1e35, 0x1e67,
	0x1e96, 0x1ec5, 0x1ef4, 0x1f2e, 0x1f66, 0x1f9f, 0x1fd8, 0x2011,
	0x2052, 0x208a, 0x20b1, 0x20d9, 0x2101, 0x2129, 0x2159, 0x2180,
	0x21a7, 0x21cf, 0x21f7, 0x221f, 0x224f, 0x2276, 0x229e, 0x22c7,
	0x22f0, 0x2319, 0x234a, 0x2372, 0x23a2, 0x23c9, 0x23f9, 0x2420,
	// Entry 3E80 - 3EBF
	0x2448, 0x246f, 0x2497, 0x24c7, 0x24ee, 0x2516, 0x2546, 0x256d,
	0x2596, 0x25bf, 0x25e7, 0x2610, 0x2639, 0x2662, 0x2693, 0x26bb,
	0x26f8, 0x271f, 0x2747, 0x276f, 0x2797, 0x27c7, 0x27ee, 0x2829,
	0x2863, 0x289e, 0x28d9, 0x2913, 0x293d, 0x2966, 0x2990, 0x29ba,
	0x29e3, 0x2a0d, 0x2a36, 0x2a60, 0x2a8a, 0x2ab3, 0x2ade, 0x2b08,
	0x2b33, 0x2b5d, 0x2b87, 0x2bb2, 0x2bdd, 0x2c08, 0x2c32, 0x2c5d,
	0x2c88, 0x2cb1, 0x2cdb, 0x2d05, 0x2d2f, 0x2d58, 0x2d82, 0x2dac,
	0x2dd5, 0x2dff, 0x2e29, 0x2e53, 0x2e7f, 0x2eab, 0x2ed5, 0x2efe,
	// Entry 3EC0 - 3EFF
	0x2f28, 0x2f52, 0x2f7b, 0x2fa5, 0x2fcf, 0x2ff8, 0x3022, 0x304b,
	0x3075, 0x309f, 0x30c8, 0x30f2, 0x311c, 0x3145, 0x3170, 0x319a,
	0x31c5, 0x31f0, 0x321b, 0x3245, 0x3270, 0x329b, 0x32c5, 0x32ef,
	0x3319, 0x334f, 0x3379, 0x33a2, 0x33cc, 0x33f6, 0x341f, 0x3459,
	0x3492, 0x34bb, 0x34e3, 0x350c, 0x3534, 0x355e, 0x3587, 0x35b1,
	0x35da, 0x3605, 0x362f, 0x3657, 0x3680, 0x36a9, 0x36d3, 0x36fc,
	0x3725, 0x374d, 0x377a, 0x37a7, 0x37d4, 0x3807, 0x3831, 0x3864,
	0x388e, 0x38c3, 0x38ef, 0x3923, 0x394e, 0x3983, 0x39af, 0x39e2,
	// Entry 3F00 - 3F3F
	0x3a0c, 0x3a40, 0x3a6b, 0x3a9f, 0x3aca, 0x3afd, 0x3b27, 0x3b5a,
	0x3b84, 0x3bb1, 0x3bdd, 0x3c0a, 0x3c37, 0x3c63, 0x3c8e, 0x3cb8,
	0x3ce2, 0x3d12, 0x3d39, 0x3d69, 0x3d90, 0x3dc2, 0x3deb, 0x3e1c,
	0x3e44, 0x3e76, 0x3e9f, 0x3ecf, 0x3ef6, 0x3f27, 0x3f4f, 0x3f80,
	0x3fa8, 0x3fd8, 0x3fff, 0x402f, 0x4056, 0x4080, 0x40a9, 0x40d3,
	0x40fd, 0x4126, 0x414e, 0x4175, 0x419c, 0x41c8, 0x41f3, 0x421f,
	0x424b, 0x4275, 0x42a0, 0x42ca, 0x42f4, 0x431d, 0x4347, 0x4372,
	0x439c, 0x43c7, 0x43f0, 0x4419, 0x4446, 0x4476, 0x448d, 0x44a5,
	// Entry 3F40 - 3F7F
	0x44c4, 0x44e4, 0x4506, 0x4528, 0x454c, 0x4570, 0x459b, 0x45bb,
	0x45dc, 0x45ff, 0x462b, 0x4649, 0x467e, 0x469f, 0x46c3, 0x46e3,
	0x4717, 0x4748, 0x477b, 0x47ae, 0x47e2, 0x4816, 0x4849, 0x487d,
	0x48af, 0x48e3, 0x4914, 0x494e, 0x4982, 0x49b6, 0x49f1, 0x4a23,
	0x4a57, 0x4a8c, 0x4abf, 0x4af4, 0x4b24, 0x4b56, 0x4b88, 0x4bbb,
	0x4bf0, 0x4c23, 0x4c57, 0x4c8d, 0x4cc1, 0x4cf7, 0x4d30, 0x4d62,
	0x4d96, 0x4dc7, 0x4dfa, 0x4e2e, 0x4e5f, 0x4e91, 0x4ec3, 0x4ef7,
	0x4f31, 0x4f65, 0x4f98, 0x4fd4, 0x5006, 0x503a, 0x506b, 0x509d,
	// Entry 3F80 - 3FBF
	0x50ce, 0x50fe, 0x5137, 0x516b, 0x519d, 0x51cf, 0x5203, 0x5234,
	0x5267, 0x529b, 0x52cf, 0x5300, 0x5334, 0x5369, 0x539e, 0x53d3,
	0x5408, 0x543c, 0x5470, 0x54a4, 0x54de, 0x5511, 0x5546, 0x5581,
	0x55b3, 0x55ee, 0x5620, 0x5654, 0x5685, 0x56b6, 0x56f0, 0x5721,
	0x575b, 0x578c, 0x57c6, 0x57f8, 0x5832, 0x586d, 0x58a8, 0x58d8,
	0x590a, 0x593a, 0x596b, 0x599c, 0x59cc, 0x59fd, 0x5a2e, 0x5a60,
	0x5a91, 0x5ac2, 0x5af5, 0x5b28, 0x5b59, 0x5b8a, 0x5bbe, 0x5bf0,
	0x5c24, 0x5c56, 0x5c88, 0x5cba, 0x5ceb, 0x5d1c, 0x5d4e, 0x5d7f,
	// Entry 3FC0 - 3FFF
	0x5daf, 0x5de3, 0x5e17, 0x5e4b, 0x5e7d, 0x5eaf, 0x5ed0, 0x5f0d,
	0x5f49, 0x5f6c, 0x5f8f, 0x5fb5, 0x5fd8, 0x5ffc, 0x6020, 0x6046,
	0x6069, 0x6094, 0x60b3, 0x60bc, 0x60e9, 0x610e, 0x612a, 0x613e,
	0x6152, 0x6166, 0x617a, 0x618e, 0x61a2, 0x61b6, 0x61ca, 0x61de,
	0x61f3, 0x6208, 0x621d, 0x6232, 0x6247, 0x625c, 0x6271, 0x6295,
	0x62c5, 0x62f9, 0x631d, 0x6345, 0x6374, 0x63a0, 0x63dc, 0x6419,
	0x644b, 0x6467, 0x6484, 0x64a4, 0x64c5, 0x64df, 0x64fa, 0x6515,
	0x6537, 0x655a, 0x6579, 0x6599, 0x65b9, 0x65da, 0x65fb, 0x661d,
	// Entry 4000 - 403F
	0x6640, 0x666d, 0x6693, 0x66b9, 0x66e0, 0x670c, 0x673b, 0x676b,
	0x679c, 0x67ce, 0x6808, 0x6843, 0x687f, 0x68bc, 0x68f4, 0x692d,
	0x695e, 0x6990, 0x69c2, 0x69f5, 0x6a2d, 0x6a66, 0x6a70, 0x6a80,
	0x6ab2, 0x6ae5, 0x6af4, 0x6b07, 0x6b14, 0x6b28, 0x6b37, 0x6b4a,
	0x6b57, 0x6b62, 0x6b79, 0x6b88, 0x6b97, 0x6ba2, 0x6bb5, 0x6bcb,
	0x6bd8, 0x6bee, 0x6c05, 0x6c1d, 0x6c36, 0x6c57, 0x6c79, 0x6c8a,
	0x6c99, 0x6ca7, 0x6cb6, 0x6cc8, 0x6cdc, 0x6cf3, 0x6d04, 0x6d19,
	0x6d2a, 0x6d3c, 0x6d4f, 0x6d6c, 0x6d8e, 0x6dab, 0x6dbf, 0x6ddc,
	// Entry 4040 - 407F
	0x6df6, 0x6e0e, 0x6e28, 0x6e40, 0x6e5a, 0x6e72, 0x6e8d, 0x6ea6,
	0x6ec0, 0x6ed8, 0x6ef9, 0x6f2a, 0x6f58, 0x6f89, 0x6fb7, 0x6fe7,
	0x7014, 0x7045, 0x7073, 0x70a3, 0x70d0, 0x70ff, 0x712d, 0x714d,
	0x716a, 0x7189, 0x71a5, 0x71c3, 0x71e0, 0x7207, 0x722b, 0x724a,
	0x7266, 0x7284, 0x72a1, 0x72c1, 0x72de, 0x72fd, 0x731b, 0x733b,
	0x7358, 0x7377, 0x7395, 0x73b4, 0x73d0, 0x73ee, 0x740b, 0x742b,
	0x7448, 0x7467, 0x7485, 0x74a4, 0x74c0, 0x74e0, 0x74fd, 0x751c,
	0x7538, 0x7558, 0x7575, 0x7595, 0x75b2, 0x75d1, 0x75ef, 0x7610,
	// Entry 4080 - 40BF
	0x762e, 0x764e, 0x766d, 0x768c, 0x76a8, 0x76c6, 0x76e3, 0x7702,
	0x771e, 0x773c, 0x7759, 0x7778, 0x7794, 0x77b2, 0x77cf, 0x77ee,
	0x780a, 0x7828, 0x7845, 0x7864, 0x7880, 0x789e, 0x78bb, 0x78dc,
	0x78fa, 0x791a, 0x7939, 0x7958, 0x7974, 0x7992, 0x79af, 0x79ce,
	0x79ea, 0x7a08, 0x7a25, 0x7a44, 0x7a60, 0x7a7e, 0x7a9b, 0x7aba,
	0x7ad6, 0x7af4, 0x7b11, 0x7b31, 0x7b4e, 0x7b6d, 0x7b8b, 0x7bab,
	0x7bc8, 0x7be7, 0x7c05, 0x7c24, 0x7c40, 0x7c5e, 0x7c7b, 0x7c9a,
	0x7cb6, 0x7cde, 0x7d03, 0x7d22, 0x7d3e, 0x7d5c, 0x7d79, 0x7db5,
	// Entry 40C0 - 40FF
	0x7dee, 0x7e2a, 0x7e63, 0x7e9f, 0x7ed8, 0x7f03, 0x7f2b, 0x7f44,
	0x7f5e, 0x7f76, 0x7f8b, 0x7fa0, 0x7fb6, 0x7fc9, 0x7fdd, 0x7ff7,
	0x8012, 0x8024, 0x8037, 0x8046, 0x805c, 0x806f, 0x8080, 0x8094,
	0x80a7, 0x80ba, 0x80cf, 0x80e3, 0x80f7, 0x810a, 0x811f, 0x8134,
	0x8148, 0x8157, 0x816a, 0x8182, 0x8197, 0x81b2, 0x81c9, 0x81e0,
	0x8200, 0x8220, 0x8240, 0x8260, 0x8280, 0x82a0, 0x82c0, 0x82e0,
	0x8300, 0x8320, 0x8340, 0x8360, 0x8380, 0x83a0, 0x83c0, 0x83e0,
	0x8400, 0x8420, 0x8440, 0x8460, 0x8480, 0x84a0, 0x84c0, 0x84e0,
	// Entry 4100 - 413F
	0x8500, 0x8520, 0x853d, 0x8556, 0x8574, 0x858f, 0x85a1, 0x85b7,
	0x85d5, 0x85f3, 0x8611, 0x862f, 0x864d, 0x866b, 0x8689, 0x86a7,
	0x86c5, 0x86e3, 0x8701, 0x871f, 0x873d, 0x875b, 0x8779, 0x8797,
	0x87b5, 0x87d3, 0x87f1, 0x880f, 0x882d, 0x884b, 0x8869, 0x8887,
	0x88a5, 0x88c3, 0x88df, 0x88f6, 0x8913, 0x8922, 0x8942, 0x8963,
	0x8982, 0x899f, 0x89bd, 0x89d8, 0x89f5, 0x8a11, 0x8a32, 0x8a53,
	0x8a74, 0x8a95, 0x8ab6, 0x8ad8, 0x8afa, 0x8b1c, 0x8b3e, 0x8b6e,
	0x8b89, 0x8ba4, 0x8bbf, 0x8bda, 0x8bf5, 0x8c11, 0x8c2d, 0x8c49,
	// Entry 4140 - 417F
	0x8c65, 0x8c81, 0x8c9d, 0x8cb9, 0x8cd5, 0x8cf1, 0x8d0d, 0x8d29,
	0x8d45, 0x8d61, 0x8d7d, 0x8d99, 0x8db5, 0x8dd1, 0x8ded, 0x8e09,
	0x8e25, 0x8e41, 0x8e5d, 0x8e79, 0x8e95, 0x8eb1, 0x8ecd, 0x8ee9,
	0x8f05, 0x8f21, 0x8f3d, 0x8f59, 0x8f75, 0x8f91, 0x8fad, 0x8fc9,
	0x8fe5, 0x9001, 0x901d, 0x9039, 0x9054, 0x9078, 0x90a1, 0x90b8,
	0x90d6, 0x90f9, 0x911c, 0x9139, 0x915c, 0x917f, 0x919d, 0x91c0,
	0x91dd, 0x9201, 0x9224, 0x9247, 0x9269, 0x928e, 0x92b3, 0x92d6,
	0x92f3, 0x9310, 0x9332, 0x9354, 0x9370, 0x9391, 0x93ae, 0x93cb,
	// Entry 4180 - 41BF
	0x93ed, 0x940c, 0x942b, 0x944a, 0x9469, 0x9486, 0x949f, 0x94b9,
	0x94d3, 0x94ee, 0x9508, 0x9521, 0x953c, 0x9556, 0x956f, 0x9589,
	0x95a4, 0x95be, 0x95d8, 0x95f1, 0x960c, 0x9626, 0x9640, 0x965a,
	0x9674, 0x968e, 0x96a7, 0x96ba, 0x96ce, 0x96e0, 0x96f0, 0x9704,
	0x9716, 0x9728, 0x9746, 0x975f, 0x9776, 0x9790, 0x97a9, 0x97bf,
	0x97d5, 0x97f2, 0x9812, 0x9833, 0x984f, 0x9864, 0x987c, 0x9894,
	0x98ac, 0x98c4, 0x98dc, 0x98f5, 0x990e, 0x9927, 0x9940, 0x9959,
	0x9972, 0x998b, 0x99a4, 0x99bd, 0x99d6, 0x99ef, 0x9a08, 0x9a21,
	// Entry 41C0 - 41FF
	0x9a3a, 0x9a53, 0x9a6c, 0x9a85, 0x9a9e, 0x9ab7, 0x9ad0, 0x9ae9,
	0x9b02, 0x9b1b, 0x9b34, 0x9b4d, 0x9b66, 0x9b7f, 0x9b98, 0x9bb1,
	0x9bca, 0x9be3, 0x9bfc, 0x9c15, 0x9c2e, 0x9c47, 0x9c60, 0x9c79,
	0x9c92, 0x9cab, 0x9cc4, 0x9cdd, 0x9cf6, 0x9d0f, 0x9d28, 0x9d41,
	0x9d5a, 0x9d73, 0x9d8c, 0x9da5, 0x9dbe, 0x9dd7, 0x9df0, 0x9e09,
	0x9e22, 0x9e3b, 0x9e54, 0x9e6d, 0x9e86, 0x9ea0, 0x9eba, 0x9ed4,
	0x9eee, 0x9f08, 0x9f22, 0x9f3c, 0x9f56, 0x9f70, 0x9f8a, 0x9fa4,
	0x9fb8, 0x9fcc, 0x9fe0, 0x9ff4, 0xa008, 0xa01c, 0xa030, 0xa044,
	// Entry 4200 - 423F
	0xa058, 0xa06c, 0xa080, 0xa094, 0xa0a8, 0xa0bc, 0xa0d6, 0xa0f2,
	0xa10d, 0xa129, 0xa145, 0xa165, 0xa180, 0xa19b, 0xa1bb, 0xa1da,
	0xa1f5, 0xa211, 0xa22c, 0xa248, 0xa264, 0xa281, 0xa29d, 0xa2b9,
	0xa2d7, 0xa2f2, 0xa30f, 0xa329, 0xa344, 0xa35a, 0xa376, 0xa391,
	0xa3ae, 0xa3c9, 0xa3df, 0xa3fa, 0xa410, 0xa426, 0xa441, 0xa457,
	0xa46d, 0xa483, 0xa49f, 0xa4b5, 0xa4cb, 0xa4e7, 0xa4fd, 0xa513,
	0xa531, 0xa54e, 0xa564, 0xa57a, 0xa590, 0xa5a6, 0xa5bc, 0xa5d2,
	0xa5e8, 0xa5fe, 0xa614, 0xa630, 0xa646, 0xa661, 0xa677, 0xa68d,
	// Entry 4240 - 427F
	0xa6a3, 0xa6b9, 0xa6cf, 0xa6e5, 0xa6fb, 0xa711, 0xa727, 0xa73d,
	0xa753, 0xa770, 0xa790, 0xa7ae, 0xa7ca, 0xa7e6, 0xa7fc, 0xa818,
	0xa82e, 0xa844, 0xa86a, 0xa888, 0xa8ac, 0xa8c8, 0xa8de, 0xa8f4,
	0xa910, 0xa926, 0xa93c, 0xa952, 0xa968, 0xa97e, 0xa999, 0xa9af,
	0xa9c5, 0xa9db, 0xa9f1, 0xaa07, 0xaa24, 0xaa41, 0xaa5e, 0xaa7b,
	0xaa98, 0xaab5, 0xaad2, 0xaaef, 0xab0c, 0xab29, 0xab46, 0xab63,
	0xab80, 0xab9d, 0xabba, 0xabd7, 0xabf4, 0xac11, 0xac2e, 0xac4b,
	0xac68, 0xac85, 0xaca2, 0xacbf, 0xacdc, 0xacf9, 0xad16, 0xad33,
	// Entry 4280 - 42BF
	0xad50, 0xad6a, 0xad83, 0xad94, 0xada5, 0xadb6, 0xadc9, 0xaddb,
	0xaded, 0xadfe, 0xae11, 0xae24, 0xae36, 0xae47, 0xae5b, 0xae6f,
	0xae82, 0xae95, 0xaea8, 0xaebd, 0xaed1, 0xaee5, 0xaefe, 0xaf17,
	0xaf32, 0xaf4c, 0xaf66, 0xaf7f, 0xaf9a, 0xafb5, 0xafcf, 0xafe9,
	0xb003, 0xb01f, 0xb03a, 0xb055, 0xb06f, 0xb08b, 0xb0a7, 0xb0c2,
	0xb0dc, 0xb0f9, 0xb116, 0xb132, 0xb14e, 0xb16a, 0xb188, 0xb1a5,
	0xb1c2, 0xb1d9, 0xb1f4, 0xb210, 0xb22b, 0xb247, 0xb267, 0xb28a,
	0xb2a7, 0xb2c3, 0xb2e5, 0xb304, 0xb326, 0xb341, 0xb35d, 0xb380,
	// Entry 42C0 - 42FF
	0xb3a4, 0xb3c9, 0xb3ec, 0xb40e, 0xb432, 0xb45c, 0xb487, 0xb4b2,
	0xb4de, 0xb501, 0xb523, 0xb547, 0xb571, 0xb59c, 0xb5c7, 0xb5f2,
	0xb61f, 0xb63e, 0xb663, 0xb680, 0xb69f, 0xb6be, 0xb6db, 0xb701,
	0xb729, 0xb749, 0xb768, 0xb796, 0xb7b5, 0xb7d3, 0xb7f0, 0xb810,
	0xb831, 0xb861, 0xb882, 0xb8a1, 0xb8c6, 0xb8ed, 0xb915, 0xb93d,
	0xb963, 0xb98a, 0xb9ae, 0xb9d4, 0xb9fb, 0xba1d, 0xba41, 0xba54,
	0xba76, 0xba8b, 0xbaa4, 0xbab3, 0xbac4, 0xbad6, 0xbae5, 0xbaf9,
	0xbb0f, 0xbb24, 0xbb39, 0xbb4c, 0xbb63, 0xbb73, 0xbb84, 0xbb95,
	// Entry 4300 - 433F
	0xbba6, 0xbbb7, 0xbbc8, 0xbbe0, 0xbbef, 0xbc05, 0xbc18, 0xbc2c,
	0xbc38, 0xbc4a, 0xbc5a, 0xbc6d, 0xbc7f, 0xbc99, 0xbcab, 0xbcbe,
	0xbcd2, 0xbce7, 0xbcfb, 0xbd08, 0xbd1c, 0xbd28, 0xbd3c, 0xbd59,
	0xbd77, 0xbd97, 0xbdb1, 0xbdc9, 0xbde1, 0xbdfa, 0xbe15, 0xbe2d,
	0xbe45, 0xbe5b, 0xbe74, 0xbe8b, 0xbea6, 0xbec0, 0xbed6, 0xbeec,
	0xbf08, 0xbf2a, 0xbf43, 0xbf5a, 0xbf72, 0xbf8b, 0xbfa5, 0xbfbc,
	0xbfd3, 0xbfea, 0xc006, 0xc01c, 0xc032, 0xc04a, 0xc061, 0xc079,
	0xc08f, 0xc0ac, 0xc0c3, 0xc0dd, 0xc0f7, 0xc10e, 0xc128, 0xc140,
	// Entry 4340 - 437F
	0xc159, 0xc174, 0xc190, 0xc1ac, 0xc1d7, 0xc1e6, 0xc1f5, 0xc204,
	0xc214, 0xc223, 0xc232, 0xc241, 0xc250, 0xc25f, 0xc26f, 0xc27e,
	0xc28d, 0xc29c, 0xc2ab, 0xc2ba, 0xc2c9, 0xc2d9, 0xc2e9, 0xc2f8,
	0xc307, 0xc317, 0xc326, 0xc335, 0xc344, 0xc354, 0xc364, 0xc374,
	0xc383, 0xc392, 0xc3a1, 0xc3b1, 0xc3c0, 0xc3cf, 0xc3e0, 0xc3ef,
	0xc3ff, 0xc40f, 0xc41e, 0xc42d, 0xc43c, 0xc44b, 0xc45b, 0xc46a,
	0xc47a, 0xc48b, 0xc49a, 0xc4ac, 0xc4bb, 0xc4cb, 0xc4da, 0xc4e9,
	0xc4fa, 0xc509, 0xc519, 0xc528, 0xc537, 0xc549, 0xc558, 0xc568,
	// Entry 4380 - 43BF
	0xc578, 0xc588, 0xc597, 0xc5a7, 0xc5b7, 0xc5c8, 0xc5d8, 0xc5e8,
	0xc5fa, 0xc60a, 0xc61c, 0xc62c, 0xc63c, 0xc64d, 0xc65e, 0xc66f,
	0xc680, 0xc690, 0xc6a2, 0xc6bd, 0xc6d3, 0xc6e9, 0xc701, 0xc718,
	0xc72f, 0xc745, 0xc75d, 0xc775, 0xc78c, 0xc7a3, 0xc7bd, 0xc7d7,
	0xc7f0, 0xc809, 0xc822, 0xc83d, 0xc857, 0xc871, 0xc890, 0xc8af,
	0xc8d0, 0xc8f0, 0xc910, 0xc92f, 0xc950, 0xc971, 0xc991, 0xc9a4,
	0xc9b8, 0xc9cc, 0xc9e0, 0xc9f3, 0xca07, 0xca1b, 0xca2f, 0xca44,
	0xca57, 0xca6b, 0xca7f, 0xca93, 0xcaa7, 0xcabc, 0xcacf, 0xcae3,
	// Entry 43C0 - 43FF
	0xcaf8, 0xcb0c, 0xcb20, 0xcb34, 0xcb48, 0xcb5b, 0xcb70, 0xcb85,
	0xcb9a, 0xcbae, 0xcbc3, 0xcbd8, 0xcbec, 0xcc00, 0xcc15, 0xcc2b,
	0xcc42, 0xcc58, 0xcc70, 0xcc84, 0xcca2, 0xccc0, 0xccd2, 0xcce7,
	0xccf9, 0xcd0b, 0xcd1f, 0xcd35, 0xcd47, 0xcd59, 0xcd6d, 0xcd7e,
	0xcd91, 0xcda4, 0xcdb7, 0xcdcb, 0xcddc, 0xcdee, 0xce04, 0xce18,
	0xce2b, 0xce3e, 0xce51, 0xce64, 0xce77, 0xce8a, 0xce9d, 0xceb0,
	0xceca, 0xcede, 0xcef3, 0xcf08, 0xcf1d, 0xcf30, 0xcf46, 0xcf5d,
	0xcf73, 0xcf8a, 0xcf9d, 0xcfb3, 0xcfc8, 0xcfdf, 0xcff6, 0xd00c,
	// Entry 4400 - 443F
	0xd022, 0xd037, 0xd04c, 0xd061, 0xd074, 0xd08b, 0xd0a2, 0xd0bb,
	0xd0d0, 0xd0e6, 0xd0f9, 0xd10d, 0xd121, 0xd135, 0xd14b, 0xd160,
	0xd175, 0xd18b, 0xd1a0, 0xd1b4, 0xd1c8, 0xd1dc, 0xd1f0, 0xd20e,
	0xd22d, 0xd24d, 0xd26e, 0xd28d, 0xd2a1, 0xd2b5, 0xd2ca, 0xd2dd,
	0xd2f2, 0xd304, 0xd316, 0xd32a, 0xd33e, 0xd351, 0xd364, 0xd377,
	0xd38b, 0xd3a0, 0xd3b3, 0xd3c7, 0xd3da, 0xd3ec, 0xd401, 0xd414,
	0xd426, 0xd43a, 0xd44e, 0xd463, 0xd479, 0xd48e, 0xd4a0, 0xd4b1,
	0xd4c2, 0xd4d5, 0xd4ea, 0xd4fc, 0xd50e, 0xd520, 0xd533, 0xd546,
	// Entry 4440 - 447F
	0xd559, 0xd56c, 0xd57f, 0xd592, 0xd5a5, 0xd5b8, 0xd5cb, 0xd5de,
	0xd5f1, 0xd604, 0xd617, 0xd62b, 0xd63e, 0xd651, 0xd664, 0xd677,
	0xd68a, 0xd69d, 0xd6b0, 0xd6c3, 0xd6d6, 0xd6e9, 0xd6fc, 0xd70f,
	0xd722, 0xd735, 0xd748, 0xd75b, 0xd76f, 0xd783, 0xd796, 0xd7b1,
	0xd7ce, 0xd7eb, 0xd808, 0xd822, 0xd83e, 0xd853, 0xd86b, 0xd883,
	0xd899, 0xd8af, 0xd8c5, 0xd8de, 0xd8f8, 0xd915, 0xd932, 0xd94f,
	0xd96d, 0xd98a, 0xd9a8, 0xd9c6, 0xd9e4, 0xda02, 0xda21, 0xda3f,
	0xda5e, 0xda77, 0xda90, 0xdaa9, 0xdac3, 0xdadb, 0xdaf5, 0xdb0f,
	// Entry 4480 - 44BF
	0xdb29, 0xdb43, 0xdb5e, 0xdb78, 0xdb92, 0xdbac, 0xdbc5, 0xdbdf,
	0xdbf9, 0xdc14, 0xdc2d, 0xdc47, 0xdc61, 0xdc7c, 0xdc95, 0xdcae,
	0xdcc7, 0xdce0, 0xdcfa, 0xdd13, 0xdd2c, 0xdd47, 0xdd62, 0xdd7d,
	0xdd99, 0xddb4, 0xddd0, 0xddec, 0xde08, 0xde24, 0xde41, 0xde5d,
	0xde7a, 0xde91, 0xdea8, 0xdebf, 0xded7, 0xdeed, 0xdf05, 0xdf1d,
	0xdf35, 0xdf4d, 0xdf66, 0xdf7e, 0xdf96, 0xdfae, 0xdfc5, 0xdfdd,
	0xdff5, 0xe00e, 0xe025, 0xe03d, 0xe055, 0xe06e, 0xe085, 0xe09c,
	0xe0b3, 0xe0ca, 0xe0e2, 0xe0f9, 0xe110, 0xe123, 0xe135, 0xe148,
	// Entry 44C0 - 44FF
	0xe15a, 0xe16e, 0xe17f, 0xe192, 0xe1a7, 0xe1b9, 0xe1cc, 0xe1de,
	0xe1f1, 0xe203, 0xe215, 0xe228, 0xe23a, 0xe250, 0xe264, 0xe276,
	0xe28a, 0xe29d, 0xe2b0, 0xe2c1, 0xe2d3, 0xe2e5, 0xe2f7, 0xe308,
	0xe31b, 0xe32d, 0xe33e, 0xe351, 0xe363, 0xe375, 0xe387, 0xe399,
	0xe3aa, 0xe3bc, 0xe3cf, 0xe3e1, 0xe3f3, 0xe405, 0xe416, 0xe428,
	0xe43a, 0xe44e, 0xe460, 0xe472, 0xe484, 0xe497, 0xe4a8, 0xe4b9,
	0xe4ca, 0xe4db, 0xe4ed, 0xe500, 0xe511, 0xe522, 0xe536, 0xe548,
	0xe55b, 0xe56c, 0xe57d, 0xe590, 0xe5a3, 0xe5b6, 0xe5c9, 0xe5dc,
	// Entry 4500 - 453F
	0xe5ee, 0xe5ff, 0xe610, 0xe620, 0xe630, 0xe640, 0xe650, 0xe660,
	0xe671, 0xe682, 0xe693, 0xe6a5, 0xe6b6, 0xe6c7, 0xe6da, 0xe6ec,
	0xe6fe, 0xe70f, 0xe722, 0xe735, 0xe747, 0xe75d, 0xe774, 0xe78c,
	0xe7a3, 0xe7bb, 0xe7d3, 0xe7ed, 0xe803, 0xe81b, 0xe832, 0xe84a,
	0xe860, 0xe877, 0xe890, 0xe8a8, 0xe8bf, 0xe8d6, 0xe8ed, 0xe903,
	0xe91b, 0xe932, 0xe94b, 0xe962, 0xe97a, 0xe991, 0xe9aa, 0xe9c2,
	0xe9dc, 0xe9f5, 0xea0d, 0xea23, 0xea3a, 0xea52, 0xea6a, 0xea81,
	0xea99, 0xeaad, 0xeac2, 0xead8, 0xeaed, 0xeb03, 0xeb19, 0xeb31,
	// Entry 4540 - 457F
	0xeb45, 0xeb5b, 0xeb70, 0xeb86, 0xeb9a, 0xebaf, 0xebc6, 0xebdc,
	0xebf1, 0xec06, 0xec1b, 0xec2f, 0xec45, 0xec5a, 0xec71, 0xec86,
	0xec9c, 0xecb1, 0xecc8, 0xecde, 0xecf6, 0xed0d, 0xed23, 0xed37,
	0xed4c, 0xed62, 0xed78, 0xed8d, 0xeda3, 0xedb3, 0xedc4, 0xedd5,
	0xede7, 0xedf8, 0xee0a, 0xee1c, 0xee2d, 0xee3d, 0xee4e, 0xee5f,
	0xee71, 0xee82, 0xee92, 0xeea3, 0xeeb4, 0xeec5, 0xeed7, 0xeee8,
	0xeef9, 0xef0a, 0xef1c, 0xef2c, 0xef3d, 0xef4e, 0xef5f, 0xef71,
	0xef82, 0xef94, 0xefa5, 0xefb7, 0xefc7, 0xefd8, 0xefe9, 0xeff9,
	// Entry 4580 - 45BF
	0xf00a, 0xf01c, 0xf02e, 0xf043, 0xf055, 0xf072, 0xf08f, 0xf0ac,
	0xf0c9, 0xf0e5, 0xf103, 0xf120, 0xf13e, 0xf15b, 0xf178, 0xf196,
	0xf1b3, 0xf1d0, 0xf1ed, 0xf20a, 0xf228, 0xf246, 0xf264, 0xf281,
	0xf29f, 0xf2bc, 0xf2da, 0xf2f8, 0xf315, 0xf332, 0xf350, 0xf36d,
	0xf38b, 0xf3a8, 0xf3c5, 0xf3e3, 0xf402, 0xf420, 0xf43e, 0xf45a,
	0xf478, 0xf495, 0xf4b3, 0xf4d1, 0xf4ee, 0xf50d, 0xf52a, 0xf548,
	0xf566, 0xf584, 0xf5a2, 0xf5bf, 0xf5dd, 0xf5fb, 0xf619, 0xf637,
	0xf654, 0xf674, 0xf68d, 0xf6a8, 0xf6c2, 0xf6dc, 0xf6f7, 0xf711,
	// Entry 45C0 - 45FF
	0xf72c, 0xf746, 0xf75f, 0xf779, 0xf793, 0xf7ad, 0xf7c8, 0xf7e1,
	0xf7fc, 0xf816, 0xf830, 0xf84a, 0xf865, 0xf87f, 0xf899, 0xf8b4,
	0xf8cd, 0xf8e7, 0xf901, 0xf91b, 0xf935, 0xf950, 0xf96a, 0xf985,
	0xf99e, 0xf9b8, 0xf9d2, 0xf9eb, 0xfa05, 0xfa1c, 0xfa35, 0xfa4d,
	0xfa65, 0xfa7e, 0xfa96, 0xfaaf, 0xfac7, 0xfade, 0xfaf6, 0xfb0e,
	0xfb26, 0xfb3f, 0xfb56, 0xfb6f, 0xfb87, 0xfb9f, 0xfbb7, 0xfbd0,
	0xfbe8, 0xfc00, 0xfc19, 0xfc30, 0xfc48, 0xfc60, 0xfc78, 0xfc90,
	0xfca9, 0xfcc1, 0xfcda, 0xfcf1, 0xfd09, 0xfd21, 0xfd38, 0xfd50,
	// Entry 4600 - 463F
	0xfd63, 0xfd76, 0xfd89, 0xfd9c, 0xfdaf, 0xfdc2, 0xfdd5, 0xfde8,
	0xfdfb, 0xfe0e, 0xfe21, 0xfe34, 0xfe47, 0xfe5a, 0xfe6d, 0xfe80,
	0xfe94, 0xfea8, 0xfebb, 0xfecf, 0xfee3, 0xfef6, 0xff0a, 0xff1d,
	0xff30, 0xff43, 0xff56, 0xff69, 0xff7c, 0xff8f, 0xffa2, 0xffb5,
	0xffc8, 0xffdb, 0xffee, 0x0001, 0x0014, 0x0027, 0x003a, 0x004d,
	0x0060, 0x0073, 0x0086, 0x0099, 0x00ac, 0x00bf, 0x00d2, 0x00e5,
	0x00f8, 0x010b, 0x011e, 0x0131, 0x0144, 0x0157, 0x016a, 0x017d,
	0x0190, 0x01a3, 0x01b6, 0x01c9, 0x01dc, 0x01ef, 0x0202, 0x0215,
	// Entry 4640 - 467F
	0x0228, 0x023b, 0x024e, 0x0261, 0x0274, 0x0287, 0x029a, 0x02b0,
	0x02c3, 0x02d6, 0x02e9, 0x02fc, 0x030f, 0x0323, 0x0337, 0x034a,
	0x035d, 0x0370, 0x0383, 0x0396, 0x03a9, 0x03bb, 0x03cd, 0x03df,
	0x03f1, 0x0403, 0x0415, 0x0427, 0x0439, 0x044c, 0x045f, 0x0472,
	0x0484, 0x0496, 0x04a8, 0x04bb, 0x04ce, 0x04e1, 0x04f3, 0x0505,
	0x0517, 0x0529, 0x053b, 0x054d, 0x055f, 0x0571, 0x0583, 0x0595,
	0x05a7, 0x05b9, 0x05cb, 0x05dd, 0x05ef, 0x0601, 0x0613, 0x0625,
	0x0637, 0x0649, 0x065b, 0x066d, 0x067f, 0x0691, 0x06a3, 0x06b5,
	// Entry 4680 - 46BF
	0x06c7, 0x06d9, 0x06eb, 0x06fd, 0x070f, 0x0721, 0x0733, 0x0745,
	0x0757, 0x0769, 0x077b, 0x078d, 0x079f, 0x07b1, 0x07c3, 0x07d5,
	0x07e7, 0x07f9, 0x080b, 0x081d, 0x082f, 0x0841, 0x0853, 0x0865,
	0x0877, 0x0889, 0x089b, 0x08ad, 0x08bf, 0x08d1, 0x08e3, 0x08f5,
	0x090b, 0x0921, 0x0937, 0x094d, 0x0963, 0x0979, 0x098f, 0x09a5,
	0x09bb, 0x09d1, 0x09e7, 0x09fd, 0x0a13, 0x0a29, 0x0a3f, 0x0a55,
	0x0a6b, 0x0a81, 0x0a97, 0x0aa9, 0x0abb, 0x0acd, 0x0adf, 0x0af1,
	0x0b03, 0x0b15, 0x0b27, 0x0b39, 0x0b4b, 0x0b5d, 0x0b6f, 0x0b81,
	// Entry 46C0 - 46FF
	0x0b93, 0x0ba5, 0x0bb7, 0x0bc9, 0x0bdb, 0x0bed, 0x0bff, 0x0c11,
	0x0c23, 0x0c35, 0x0c47, 0x0c59, 0x0c6b, 0x0c7d, 0x0c8f, 0x0ca1,
	0x0cb3, 0x0cc5, 0x0cd7, 0x0ce9, 0x0cfb, 0x0d0d, 0x0d1f, 0x0d31,
	0x0d43, 0x0d55, 0x0d67, 0x0d79, 0x0d8b, 0x0d9d, 0x0daf, 0x0dc1,
	0x0dd3, 0x0de5, 0x0df7, 0x0e09, 0x0e1b, 0x0e2d, 0x0e3f, 0x0e51,
	0x0e63, 0x0e75, 0x0e87, 0x0e99, 0x0eab, 0x0ebd, 0x0ecf, 0x0ee1,
	0x0ef3, 0x0f05, 0x0f17, 0x0f29, 0x0f3b, 0x0f4d, 0x0f5f, 0x0f71,
	0x0f83, 0x0f95, 0x0fa7, 0x0fb9, 0x0fcb, 0x0fdd, 0x0fef, 0x1001,
	// Entry 4700 - 473F
	0x1013, 0x1025, 0x1037, 0x1049, 0x105b, 0x106d, 0x107f, 0x1091,
	0x10a3, 0x10b5, 0x10c7, 0x10d9, 0x10eb, 0x10fd, 0x110f, 0x1121,
	0x1133, 0x1145, 0x1157, 0x1169, 0x117b, 0x118d, 0x119f, 0x11b1,
	0x11c3, 0x11d5, 0x11e7, 0x11f9, 0x120b, 0x121d, 0x122f, 0x1241,
	0x1253, 0x1265, 0x1277, 0x1289, 0x129b, 0x12ad, 0x12bf, 0x12d1,
	0x12e3, 0x12f5, 0x1307, 0x1319, 0x132b, 0x133d, 0x134f, 0x1361,
	0x1373, 0x1385, 0x1397, 0x13a9, 0x13bb, 0x13cd, 0x13df, 0x13f3,
	0x1407, 0x141b, 0x142f, 0x1443, 0x1457, 0x146b, 0x147f, 0x1493,
	// Entry 4740 - 477F
	0x14aa, 0x14c1, 0x14d8, 0x14ef, 0x1503, 0x1517, 0x152b, 0x1543,
	0x1559, 0x156e, 0x1583, 0x159a, 0x15af, 0x15c1, 0x15d3, 0x15e5,
	0x15f7, 0x1609, 0x161b, 0x162d, 0x163f, 0x165f, 0x168b, 0x16bc,
	0x16d4, 0x16f3, 0x1714, 0x1734, 0x1768, 0x1792, 0x17b4, 0x17d5,
	0x17f6, 0x1820, 0x1840, 0x186c, 0x188e, 0x18ad, 0x18cc, 0x18ed,
	0x1916, 0x1939, 0x1958, 0x197c, 0x19b0, 0x19d0, 0x19f0, 0x1a11,
	0x1a3a, 0x1a6e, 0x1a88, 0x1ab6, 0x1ad4, 0x1afc, 0x1b1f, 0x1b3f,
	0x1b61, 0x1b78, 0x1ba4, 0x1be3, 0x1c04, 0x1c29, 0x1c48, 0x1c72,
	// Entry 4780 - 47BF
	0x1c92, 0x1cc6, 0x1ce8, 0x1d13, 0x1d3a, 0x1d59, 0x1d81, 0x1db2,
	0x1dd0, 0x1dec, 0x1e09, 0x1e27, 0x1e5a, 0x1e7b, 0x1e8d, 0x1e9f,
	0x1eb1, 0x1ec3, 0x1ed5, 0x1ee8, 0x1efb, 0x1f0e, 0x1f21, 0x1f34,
	0x1f47, 0x1f5a, 0x1f6d, 0x1f80, 0x1f93, 0x1fa6, 0x1fb9, 0x1fcc,
	0x1fdf, 0x1ff2, 0x2005, 0x2018, 0x202b, 0x203e, 0x2051, 0x2064,
	0x2077, 0x208a, 0x209d, 0x20b0, 0x20c3, 0x20d6, 0x20e9, 0x20fc,
	0x210f, 0x2122, 0x2135, 0x2148, 0x215b, 0x216e, 0x2181, 0x2194,
	0x21a7, 0x21ba, 0x21cd, 0x21e0, 0x21f3, 0x2206, 0x2219, 0x222c,
	// Entry 47C0 - 47FF
	0x223f, 0x2252, 0x2265, 0x2278, 0x228b, 0x22a8, 0x22c4, 0x22e1,
	0x22ff, 0x2319, 0x2334, 0x2351, 0x236d, 0x2389, 0x23a5, 0x23c1,
	0x23df, 0x23fa, 0x2415, 0x2433, 0x244f, 0x2469, 0x2486, 0x24a2,
	0x24be, 0x24da, 0x24f5, 0x2512, 0x252d, 0x2548, 0x2565, 0x2580,
	0x259e, 0x25c1, 0x25e5, 0x2609, 0x261f, 0x2634, 0x264a, 0x2661,
	0x2674, 0x2688, 0x269e, 0x26b3, 0x26c8, 0x26dd, 0x26f2, 0x2709,
	0x271d, 0x2737, 0x274b, 0x2762, 0x2777, 0x278a, 0x27a0, 0x27b5,
	0x27ca, 0x27df, 0x27f3, 0x2812, 0x2832, 0x2846, 0x285a, 0x2870,
	// Entry 4800 - 483F
	0x2885, 0x289a, 0x28ae, 0x28c5, 0x28e1, 0x28f7, 0x2912, 0x2927,
	0x293d, 0x2954, 0x296d, 0x2980, 0x2994, 0x29aa, 0x29bf, 0x29d4,
	0x29ef, 0x2a04, 0x2a1f, 0x2a34, 0x2a51, 0x2a68, 0x2a82, 0x2a96,
	0x2ab0, 0x2ac4, 0x2adb, 0x2af0, 0x2b03, 0x2b19, 0x2b2e, 0x2b43,
	0x2b5e, 0x2b73, 0x2b87, 0x2b9b, 0x2baf, 0x2bc5, 0x2bda, 0x2bf9,
	0x2c0e, 0x2c22, 0x2c39, 0x2c55, 0x2c68, 0x2c7a, 0x2c8d, 0x2ca6,
	0x2cb6, 0x2cc7, 0x2cd9, 0x2ceb, 0x2cfd, 0x2d0f, 0x2d21, 0x2d35,
	0x2d46, 0x2d57, 0x2d6b, 0x2d7c, 0x2d8c, 0x2d9f, 0x2db1, 0x2dc3,
	// Entry 4840 - 487F
	0x2dd4, 0x2de5, 0x2df7, 0x2e08, 0x2e1c, 0x2e35, 0x2e4a, 0x2e5f,
	0x2e75, 0x2e8b, 0x2e9f, 0x2eb4, 0x2ec9, 0x2ede, 0x2ef3, 0x2f08,
	0x2f1d, 0x2f33, 0x2f48, 0x2f5d, 0x2f73, 0x2f88, 0x2f9c, 0x2fb2,
	0x2fc7, 0x2fdd, 0x2ff3, 0x3008, 0x301d, 0x3032, 0x304a, 0x3067,
	0x307c, 0x3093, 0x30ac, 0x30bb, 0x30ca, 0x30d9, 0x30e8, 0x30f7,
	0x3106, 0x3115, 0x3124, 0x3133, 0x3142, 0x3151, 0x3160, 0x316f,
	0x317e, 0x318e, 0x319d, 0x31ac, 0x31bb, 0x31ca, 0x31d9, 0x31e9,
	0x31f9, 0x3209, 0x3219, 0x3229, 0x3238, 0x324e, 0x326c, 0x328a,
	// Entry 4880 - 48BF
	0x32a8, 0x32c6, 0x32e5, 0x3304, 0x3323, 0x3344, 0x3363, 0x3382,
	0x33a1, 0x33c2, 0x33e1, 0x3402, 0x3421, 0x3442, 0x3461, 0x3481,
	0x34a1, 0x34c0, 0x34e1, 0x3500, 0x351f, 0x353e, 0x355d, 0x357e,
	0x359d, 0x35be, 0x35dd, 0x35fc, 0x361d, 0x3640, 0x3659, 0x3672,
	0x368b, 0x36a4, 0x36be, 0x36d8, 0x36f2, 0x370c, 0x3726, 0x3740,
	0x375a, 0x3774, 0x378e, 0x37a9, 0x37c4, 0x37de, 0x3800, 0x381a,
	0x3834, 0x384e, 0x3868, 0x3882, 0x389c, 0x38b6, 0x38df, 0x3901,
	0x391e, 0x393b, 0x3956, 0x3971, 0x398e, 0x39aa, 0x39c6, 0x39e1,
	// Entry 48C0 - 48FF
	0x39fe, 0x3a1b, 0x3a37, 0x3a52, 0x3a70, 0x3a8e, 0x3aab, 0x3ac8,
	0x3ae5, 0x3b04, 0x3b27, 0x3b4a, 0x3b6f, 0x3b93, 0x3bb7, 0x3bda,
	0x3bff, 0x3c24, 0x3c48, 0x3c6c, 0x3c90, 0x3cb6, 0x3cdb, 0x3d00,
	0x3d24, 0x3d4a, 0x3d70, 0x3d95, 0x3db9, 0x3de0, 0x3e07, 0x3e2d,
	0x3e53, 0x3e79, 0x3ea1, 0x3ec8, 0x3eef, 0x3f1b, 0x3f47, 0x3f75,
	0x3fa2, 0x3fcf, 0x3ffb, 0x4029, 0x4057, 0x4084, 0x40a9, 0x40cf,
	0x40f7, 0x411e, 0x4145, 0x416b, 0x4193, 0x41bb, 0x41e2, 0x4208,
	0x421b, 0x4232, 0x4249, 0x4268, 0x427f, 0x4296, 0x42b2, 0x42d3,
	// Entry 4900 - 493F
	0x42eb, 0x4302, 0x4316, 0x432b, 0x433f, 0x4354, 0x4368, 0x437d,
	0x4391, 0x43a6, 0x43bb, 0x43d1, 0x43e6, 0x43fc, 0x4411, 0x4425,
	0x443a, 0x444e, 0x4463, 0x4477, 0x448b, 0x44a0, 0x44b4, 0x44c9,
	0x44dd, 0x44f1, 0x4505, 0x4519, 0x452d, 0x4542, 0x4557, 0x456b,
	0x457f, 0x4593, 0x45a8, 0x45bf, 0x45d5, 0x45ea, 0x4603, 0x4618,
	0x4631, 0x4642, 0x4656, 0x466a, 0x4680, 0x4695, 0x46aa, 0x46c2,
	0x46df, 0x46fd, 0x4719, 0x4733, 0x4756, 0x4773, 0x4796, 0x47b5,
	0x47d1, 0x47ed, 0x4810, 0x482c, 0x4847, 0x4866, 0x4883, 0x489f,
	// Entry 4940 - 497F
	0x48bc, 0x48d8, 0x48f5, 0x4912, 0x492f, 0x494b, 0x4967, 0x4984,
	0x49a0, 0x49be, 0x49dc, 0x49fb, 0x4a16, 0x4a33, 0x4a4f, 0x4a6e,
	0x4a8c, 0x4aab, 0x4ac9, 0x4ae6, 0x4b03, 0x4b23, 0x4b40, 0x4b5d,
	0x4b7b, 0x4b97, 0x4bb5, 0x4bd8, 0x4bf4, 0x4c10, 0x4c2c, 0x4c49,
	0x4c65, 0x4c81, 0x4c9e, 0x4cba, 0x4cd6, 0x4cf2, 0x4d0f, 0x4d2b,
	0x4d48, 0x4d65, 0x4d81, 0x4d9e, 0x4dba, 0x4dd7, 0x4df3, 0x4e0f,
	0x4e2c, 0x4e48, 0x4e66, 0x4e82, 0x4e9f, 0x4ebc, 0x4ed8, 0x4ef5,
	0x4f11, 0x4f2d, 0x4f49, 0x4f68, 0x4f7f, 0x4f95, 0x4fac, 0x4fc3,
	// Entry 4980 - 49BF
	0x4fdb, 0x4ff3, 0x5007, 0x501c, 0x502e, 0x5045, 0x505d, 0x5074,
	0x508c, 0x50a2, 0x50b8, 0x50ce, 0x50e4, 0x50fa, 0x5111, 0x5129,
	0x5142, 0x515b, 0x5170, 0x5185, 0x519d, 0x51b3, 0x51ca, 0x51de,
	0x51f2, 0x5209, 0x521f, 0x5235, 0x524c, 0x5262, 0x5278, 0x528f,
	0x52a4, 0x52c6, 0x52e8, 0x52fd, 0x5313, 0x5328, 0x5340, 0x535d,
	0x5378, 0x5396, 0x53c2, 0x53e7, 0x5401, 0x5420, 0x5442, 0x5452,
	0x5463, 0x5474, 0x5486, 0x5497, 0x54a9, 0x54ba, 0x54cc, 0x54dc,
	0x54ed, 0x54fd, 0x550e, 0x551e, 0x552f, 0x553f, 0x5550, 0x5561,
	// Entry 49C0 - 49FF
	0x5572, 0x5584, 0x5596, 0x55a7, 0x55b9, 0x55cb, 0x55dc, 0x55ed,
	0x55fe, 0x5610, 0x5621, 0x5633, 0x5645, 0x5656, 0x5667, 0x5678,
	0x568a, 0x569c, 0x56af, 0x56c2, 0x56d3, 0x56e5, 0x56f7, 0x5708,
	0x571a, 0x572c, 0x573d, 0x574e, 0x575f, 0x5770, 0x5781, 0x5792,
	0x57a4, 0x57b6, 0x57c9, 0x57dc, 0x57ed, 0x5806, 0x582c, 0x5853,
	0x587a, 0x58a1, 0x58ca, 0x58f3, 0x5916, 0x5938, 0x595b, 0x597f,
	0x599f, 0x59c0, 0x59e3, 0x5a05, 0x5a27, 0x5a49, 0x5a6b, 0x5a8f,
	0x5ab0, 0x5ad1, 0x5af5, 0x5b17, 0x5b37, 0x5b5a, 0x5b7c, 0x5b9e,
	// Entry 4A00 - 4A3F
	0x5bc0, 0x5be1, 0x5c02, 0x5c23, 0x5c46, 0x5c68, 0x5c89, 0x5cad,
	0x5cd6, 0x5d00, 0x5d22, 0x5d43, 0x5d65, 0x5d88, 0x5da7, 0x5dd1,
	0x5df3, 0x5e14, 0x5e35, 0x5e56, 0x5e77, 0x5e9a, 0x5ebf, 0x5edf,
	0x5f02, 0x5f21, 0x5f43, 0x5f64, 0x5f84, 0x5fa4, 0x5fc4, 0x5fe6,
	0x6007, 0x6027, 0x604a, 0x6072, 0x609b, 0x60b7, 0x60d2, 0x60ee,
	0x610b, 0x6124, 0x6148, 0x6164, 0x617f, 0x619a, 0x61b5, 0x61d2,
	0x61f1, 0x620b, 0x6228, 0x6241, 0x625d, 0x6278, 0x6292, 0x62ae,
	0x62d1, 0x62f5, 0x6317, 0x6331, 0x634b, 0x6367, 0x6382, 0x639c,
	// Entry 4A40 - 4A7F
	0x63b9, 0x63db, 0x63f5, 0x6410, 0x642c, 0x6446, 0x6461, 0x647c,
	0x6496, 0x64b1, 0x64cd, 0x64e8, 0x6504, 0x6520, 0x653d, 0x6558,
	0x6574, 0x6590, 0x65ad, 0x65c8, 0x65e4, 0x6600, 0x661b, 0x6637,
	0x6652, 0x666e, 0x668a, 0x66a7, 0x66c3, 0x66e0, 0x66fc, 0x6719,
	0x6734, 0x6750, 0x676c, 0x6788, 0x67a3, 0x67be, 0x67da, 0x67f7,
	0x6813, 0x6830, 0x684c, 0x6869, 0x6885, 0x68a2, 0x68bf, 0x68db,
	0x68f9, 0x6914, 0x692f, 0x694a, 0x6965, 0x6981, 0x699c, 0x69b8,
	0x69d3, 0x69ef, 0x6a0a, 0x6a26, 0x6a41, 0x6a5d, 0x6a79, 0x6a94,
	// Entry 4A80 - 4ABF
	0x6ab0, 0x6acc, 0x6ae9, 0x6b05, 0x6b22, 0x6b3d, 0x6b59, 0x6b75,
	0x6b92, 0x6bad, 0x6bca, 0x6be8, 0x6c07, 0x6c26, 0x6c46, 0x6c65,
	0x6c85, 0x6ca5, 0x6cc4, 0x6ce4, 0x6d02, 0x6d26, 0x6d45, 0x6d64,
	0x6d83, 0x6da3, 0x6dc2, 0x6de0, 0x6dff, 0x6e1e, 0x6e3d, 0x6e5c,
	0x6e7c, 0x6e9b, 0x6ebb, 0x6eda, 0x6ef9, 0x6f19, 0x6f37, 0x6f56,
	0x6f80, 0x6fa9, 0x6fc9, 0x6fe8, 0x7008, 0x7027, 0x704c, 0x706b,
	0x708b, 0x70aa, 0x70ca, 0x70ea, 0x710a, 0x7128, 0x7147, 0x7171,
	0x719a, 0x71b9, 0x71d8, 0x71f8, 0x7224, 0x7243, 0x725f, 0x727c,
	// Entry 4AC0 - 4AFF
	0x7299, 0x72b7, 0x72d4, 0x72f2, 0x7310, 0x732d, 0x734b, 0x7367,
	0x7389, 0x73a6, 0x73c3, 0x73e0, 0x73fe, 0x741b, 0x7437, 0x7454,
	0x7471, 0x748e, 0x74ab, 0x74c9, 0x74e6, 0x7504, 0x7521, 0x753e,
	0x755c, 0x7578, 0x7595, 0x75bd, 0x75e4, 0x7602, 0x761f, 0x763d,
	0x765a, 0x767d, 0x769a, 0x76b8, 0x76d5, 0x76f3, 0x7711, 0x772f,
	0x774b, 0x7768, 0x7790, 0x77b7, 0x77d4, 0x77f1, 0x780f, 0x7839,
	0x7856, 0x786e, 0x7887, 0x789f, 0x78b9, 0x78d9, 0x78fa, 0x7912,
	0x792b, 0x7944, 0x795d, 0x7977, 0x7990, 0x79a9, 0x79c2, 0x79dc,
	// Entry 4B00 - 4B3F
	0x79f5, 0x7a0e, 0x7a28, 0x7a41, 0x7a5b, 0x7a74, 0x7a8d, 0x7aa7,
	0x7ac0, 0x7ad9, 0x7af2, 0x7b0b, 0x7b24, 0x7b3d, 0x7b5c, 0x7b75,
	0x7b94, 0x7bae, 0x7bc8, 0x7be1, 0x7bf8, 0x7c0f, 0x7c26, 0x7c3d,
	0x7c54, 0x7c6e, 0x7c8c, 0x7ca9, 0x7cc4, 0x7cdd, 0x7cf7, 0x7d11,
	0x7d2a, 0x7d43, 0x7d5e, 0x7d78, 0x7d92, 0x7dab, 0x7dc6, 0x7de1,
	0x7dfb, 0x7e09, 0x7e17, 0x7e27, 0x7e36, 0x7e45, 0x7e53, 0x7e63,
	0x7e73, 0x7e82, 0x7e91, 0x7ea3, 0x7eb5, 0x7ec6, 0x7ed7, 0x7ee8,
	0x7efb, 0x7f0d, 0x7f1f, 0x7f36, 0x7f4d, 0x7f66, 0x7f7e, 0x7f96,
	// Entry 4B40 - 4B7F
	0x7fad, 0x7fc6, 0x7fdf, 0x7ff7, 0x800d, 0x8026, 0x803d, 0x8055,
	0x8067, 0x8077, 0x8087, 0x8098, 0x80a9, 0x80b9, 0x80ca, 0x80dc,
	0x80ef, 0x8100, 0x8110, 0x8121, 0x8132, 0x8142, 0x8153, 0x8163,
	0x8173, 0x8184, 0x8196, 0x81a7, 0x81b8, 0x81c8, 0x81d8, 0x81e9,
	0x81fc, 0x820c, 0x821c, 0x823b, 0x824c, 0x825d, 0x826f, 0x8280,
	0x8291, 0x82a2, 0x82b3, 0x82c3, 0x82d4, 0x82e4, 0x82f4, 0x8305,
	0x8316, 0x8326, 0x8341, 0x835c, 0x8373, 0x8393, 0x83ba, 0x83d5,
	0x83ef, 0x840a, 0x8422, 0x8440, 0x8457, 0x8474, 0x848c, 0x84a1,
	// Entry 4B80 - 4BBF
	0x84bc, 0x84d2, 0x84ea, 0x8501, 0x8518, 0x852f, 0x8548, 0x855e,
	0x8574, 0x8590, 0x85bf, 0x85d8, 0x85ef, 0x8610, 0x8625, 0x863d,
	0x865b, 0x868c, 0x86af, 0x86c6, 0x86dc, 0x86f8, 0x8727, 0x873d,
	0x8753, 0x876b, 0x8782, 0x8799, 0x87af, 0x87c8, 0x87e1, 0x87ff,
	0x881c, 0x883c, 0x8850, 0x8863, 0x8877, 0x8888, 0x889a, 0x88ae,
	0x88c1, 0x88d4, 0x88e7, 0x88fc, 0x890e, 0x8920, 0x8935, 0x8948,
	0x8959, 0x896d, 0x8985, 0x8998, 0x89aa, 0x89bd, 0x89d0, 0x89e8,
	0x8a03, 0x8a23, 0x8a3e, 0x8a5e, 0x8a7b, 0x8a98, 0x8ab4, 0x8ad0,
	// Entry 4BC0 - 4BFF
	0x8af1, 0x8b0d, 0x8b2b, 0x8b3d, 0x8b4f, 0x8b64, 0x8b7e, 0x8ba3,
	0x8bd2, 0x8bf5, 0x8c1e, 0x8c46, 0x8c5d, 0x8c73, 0x8c8f, 0x8ca4,
	0x8cbb, 0x8cd7, 0x8ced, 0x8d03, 0x8d1b, 0x8d30, 0x8d45, 0x8d5d,
	0x8d71, 0x8d88, 0x8d9e, 0x8db4, 0x8dc9, 0x8ddf, 0x8dfd, 0x8e1b,
	0x8e3e, 0x8e61, 0x8e7b, 0x8e9a, 0x8eb9, 0x8ed9, 0x8ef0, 0x8f0d,
	0x8f23, 0x8f3a, 0x8f52, 0x8f66, 0x8f7b, 0x8f97, 0x8fae, 0x8fc4,
	0x8fda, 0x8ff0, 0x9008, 0x901d, 0x9032, 0x904a, 0x9060, 0x9074,
	0x908a, 0x90a0, 0x90b5, 0x90ca, 0x90df, 0x90f6, 0x910c, 0x9121,
	// Entry 4C00 - 4C3F
	0x9139, 0x9156, 0x916a, 0x917d, 0x9191, 0x91a6, 0x91b7, 0x91c9,
	0x91dd, 0x91f0, 0x9203, 0x9216, 0x9229, 0x923e, 0x9250, 0x9262,
	0x9277, 0x928a, 0x929b, 0x92af, 0x92c2, 0x92d5, 0x92e8, 0x92fa,
	0x9315, 0x932c, 0x9340, 0x9353, 0x936a, 0x9381, 0x9390, 0x93a0,
	0x93af, 0x93bf, 0x93ce, 0x93de, 0x93f5, 0x940d, 0x9424, 0x943c,
	0x944b, 0x945b, 0x946a, 0x947a, 0x948a, 0x949b, 0x94ab, 0x94bc,
	0x94cd, 0x94dd, 0x94ee, 0x94fe, 0x950f, 0x9520, 0x9531, 0x9543,
	0x9554, 0x9566, 0x9577, 0x9587, 0x9598, 0x95a8, 0x95b9, 0x95c9,
	// Entry 4C40 - 4C7F
	0x95d9, 0x95ea, 0x95fa, 0x960b, 0x961b, 0x962b, 0x963b, 0x964b,
	0x965b, 0x966c, 0x967d, 0x968d, 0x969d, 0x96ae, 0x96ca, 0x96e5,
	0x9701, 0x9715, 0x9735, 0x9748, 0x975c, 0x976f, 0x9783, 0x979e,
	0x97ba, 0x97d5, 0x97f1, 0x9804, 0x9818, 0x982b, 0x983f, 0x984c,
	0x9858, 0x986b, 0x9881, 0x989e, 0x98b5, 0x98d4, 0x98ec, 0x98fd,
	0x990e, 0x9921, 0x9933, 0x9945, 0x9956, 0x9969, 0x997c, 0x998e,
	0x999f, 0x99b3, 0x99c7, 0x99da, 0x99ed, 0x9a00, 0x9a15, 0x9a29,
	0x9a3d, 0x9a56, 0x9a70, 0x9a81, 0x9a91, 0x9aa1, 0x9ab3, 0x9ac4,
	// Entry 4C80 - 4CBF
	0x9ad5, 0x9ae5, 0x9af7, 0x9b09, 0x9b1a, 0x9b36, 0x9b55, 0x9b74,
	0x9b97, 0x9bba, 0x9bd5, 0x9be9, 0x9c00, 0x9c14, 0x9c27, 0x9c36,
	0x9c46, 0x9c55, 0x9c65, 0x9c74, 0x9c84, 0x9c93, 0x9ca3, 0x9cb2,
	0x9cc2, 0x9cd2, 0x9ce3, 0x9cf3, 0x9d04, 0x9d15, 0x9d25, 0x9d36,
	0x9d46, 0x9d57, 0x9d68, 0x9d79, 0x9d8b, 0x9d9c, 0x9daf, 0x9dc1,
	0x9dd2, 0x9de3, 0x9df3, 0x9e04, 0x9e14, 0x9e25, 0x9e35, 0x9e45,
	0x9e56, 0x9e66, 0x9e77, 0x9e87, 0x9e97, 0x9ea7, 0x9eb7, 0x9ec7,
	0x9ed8, 0x9ee9, 0x9ef9, 0x9f09, 0x9f1d, 0x9f30, 0x9f44, 0x9f57,
	// Entry 4CC0 - 4CFF
	0x9f6b, 0x9f7e, 0x9f92, 0x9fa5, 0x9fb9, 0x9fcb, 0x9fdc, 0x9ff4,
	0xa00b, 0xa01d, 0xa030, 0xa04a, 0xa056, 0xa069, 0xa084, 0xa09c,
	0xa0b3, 0xa0ca, 0xa0e1, 0xa0f8, 0xa10f, 0xa126, 0xa13d, 0xa155,
	0xa16c, 0xa183, 0xa19a, 0xa1b1, 0xa1c8, 0xa1df, 0xa1f6, 0xa20d,
	0xa224, 0xa23c, 0xa252, 0xa269, 0xa27f, 0xa295, 0xa2ab, 0xa2c1,
	0xa2d8, 0xa2ef, 0xa305, 0xa31b, 0xa333, 0xa34a, 0xa361, 0xa377,
	0xa38f, 0xa3a7, 0xa3be, 0xa3d5, 0xa3e9, 0xa3fc, 0xa40c, 0xa41b,
	0xa42a, 0xa439, 0xa44a, 0xa45c, 0xa46d, 0xa47f, 0xa491, 0xa4a2,
	// Entry 4D00 - 4D3F
	0xa4b4, 0xa4c5, 0xa4d7, 0xa4e9, 0xa4fb, 0xa50e, 0xa520, 0xa533,
	0xa545, 0xa556, 0xa568, 0xa579, 0xa58b, 0xa59c, 0xa5ad, 0xa5bf,
	0xa5d0, 0xa5e2, 0xa5f3, 0xa605, 0xa616, 0xa627, 0xa638, 0xa649,
	0xa65a, 0xa66b, 0xa67e, 0xa691, 0xa6a5, 0xa6b8, 0xa6cc, 0xa6df,
	0xa6f3, 0xa706, 0xa71a, 0xa72e, 0xa73b, 0xa749, 0xa756, 0xa764,
	0xa775, 0xa785, 0xa795, 0xa7a7, 0xa7b8, 0xa7c9, 0xa7d9, 0xa7eb,
	0xa7fd, 0xa80e, 0xa821, 0xa82d, 0xa840, 0xa854, 0xa866, 0xa87a,
	0xa88e, 0xa89f, 0xa8b0, 0xa8c1, 0xa8d2, 0xa8e3, 0xa8f4, 0xa906,
	// Entry 4D40 - 4D7F
	0xa919, 0xa92b, 0xa93e, 0xa950, 0xa963, 0xa975, 0xa988, 0xa99b,
	0xa9ae, 0xa9c2, 0xa9d5, 0xa9e9, 0xa9fc, 0xaa0e, 0xaa21, 0xaa33,
	0xaa46, 0xaa58, 0xaa6a, 0xaa7d, 0xaa8f, 0xaaa2, 0xaab4, 0xaac6,
	0xaad8, 0xaaea, 0xaafc, 0xab0e, 0xab21, 0xab34, 0xab4e, 0xab63,
	0xab79, 0xab91, 0xaba6, 0xabba, 0xabca, 0xabdb, 0xabeb, 0xabfc,
	0xac0c, 0xac1d, 0xac35, 0xac4e, 0xac66, 0xac7f, 0xac8f, 0xaca0,
	0xacb0, 0xacc1, 0xacd2, 0xace4, 0xacf5, 0xad07, 0xad19, 0xad2a,
	0xad3c, 0xad4d, 0xad5f, 0xad71, 0xad83, 0xad96, 0xada8, 0xadbb,
	// Entry 4D80 - 4DBF
	0xadcd, 0xadde, 0xadf0, 0xae01, 0xae13, 0xae24, 0xae35, 0xae47,
	0xae58, 0xae6a, 0xae7b, 0xae8c, 0xae9d, 0xaeae, 0xaec0, 0xaed1,
	0xaee3, 0xaef5, 0xaf06, 0xaf17, 0xaf2c, 0xaf40, 0xaf55, 0xaf69,
	0xaf7e, 0xaf9a, 0xafb7, 0xafd3, 0xaff0, 0xb004, 0xb019, 0xb02d,
	0xb042, 0xb055, 0xb06a, 0xb082, 0xb09a, 0xb0a4, 0xb0b1, 0xb0c5,
	0xb0de, 0xb0ef, 0xb102, 0xb114, 0xb12f, 0xb14d, 0xb15f, 0xb181,
	0xb1a2, 0xb1b4, 0xb1c5, 0xb1d6, 0xb1e9, 0xb1fb, 0xb20d, 0xb21e,
	0xb231, 0xb244, 0xb256, 0xb262, 0xb276, 0xb288, 0xb2a1, 0xb2b7,
	// Entry 4DC0 - 4DFF
	0xb2cd, 0xb2e6, 0xb2ff, 0xb31a, 0xb334, 0xb34e, 0xb367, 0xb382,
	0xb39d, 0xb3b7, 0xb3d1, 0xb3ee, 0xb40b, 0xb427, 0xb443, 0xb45f,
	0xb47d, 0xb49a, 0xb4b7, 0xb4d9, 0xb4fc, 0xb50b, 0xb51b, 0xb52a,
	0xb539, 0xb548, 0xb558, 0xb567, 0xb577, 0xb587, 0xb598, 0xb5a8,
	0xb5b9, 0xb5ca, 0xb5db, 0xb5eb, 0xb5fc, 0xb60c, 0xb61d, 0xb62e,
	0xb63f, 0xb651, 0xb662, 0xb674, 0xb685, 0xb695, 0xb6a6, 0xb6b6,
	0xb6c8, 0xb6d9, 0xb6e9, 0xb6f9, 0xb70a, 0xb71a, 0xb72b, 0xb73c,
	0xb74c, 0xb75c, 0xb76c, 0xb77c, 0xb78c, 0xb79c, 0xb7ac, 0xb7bd,
	// Entry 4E00 - 4E3F
	0xb7d1, 0xb7e4, 0xb7f8, 0xb80b, 0xb81e, 0xb832, 0xb845, 0xb859,
	0xb86d, 0xb87f, 0xb890, 0xb8a2, 0xb8ae, 0xb8c1, 0xb8d6, 0xb8e9,
	0xb903, 0xb91b, 0xb92c, 0xb93c, 0xb951, 0xb96c, 0xb97c, 0xb98c,
	0xb99c, 0xb9ac, 0xb9bd, 0xb9cf, 0xb9e0, 0xb9f2, 0xba03, 0xba15,
	0xba26, 0xba38, 0xba4a, 0xba5c, 0xba6f, 0xba81, 0xba94, 0xbaa7,
	0xbab9, 0xbaca, 0xbadc, 0xbaed, 0xbaff, 0xbb10, 0xbb21, 0xbb33,
	0xbb44, 0xbb56, 0xbb67, 0xbb78, 0xbb89, 0xbb9a, 0xbbab, 0xbbbc,
	0xbbcd, 0xbbdf, 0xbbf1, 0xbc05, 0xbc17, 0xbc2a, 0xbc3c, 0xbc4f,
	// Entry 4E40 - 4E7F
	0xbc61, 0xbc74, 0xbc86, 0xbc99, 0xbcab, 0xbcbe, 0xbcd1, 0xbce5,
	0xbcf8, 0xbd0c, 0xbd20, 0xbd34, 0xbd47, 0xbd5b, 0xbd6e, 0xbd82,
	0xbd96, 0xbdaa, 0xbdbe, 0xbdd3, 0xbde7, 0xbdfc, 0xbe10, 0xbe25,
	0xbe39, 0xbe4c, 0xbe60, 0xbe73, 0xbe87, 0xbe9a, 0xbead, 0xbec1,
	0xbed4, 0xbee8, 0xbefc, 0xbf0f, 0xbf22, 0xbf35, 0xbf48, 0xbf5b,
	0xbf6f, 0xbf82, 0xbf95, 0xbfac, 0xbfc3, 0xbfd9, 0xbff0, 0xc006,
	0xc01d, 0xc033, 0xc04a, 0xc060, 0xc077, 0xc08b, 0xc0a0, 0xc0b4,
	0xc0c7, 0xc0da, 0xc0ef, 0xc103, 0xc117, 0xc12a, 0xc13f, 0xc154,
	// Entry 4E80 - 4EBF
	0xc168, 0xc18d, 0xc1a5, 0xc1ba, 0xc1ce, 0xc1de, 0xc1ef, 0xc1ff,
	0xc210, 0xc220, 0xc231, 0xc249, 0xc261, 0xc272, 0xc283, 0xc294,
	0xc2a5, 0xc2b6, 0xc2c8, 0xc2d9, 0xc2eb, 0xc2fd, 0xc30e, 0xc320,
	0xc331, 0xc343, 0xc355, 0xc367, 0xc37a, 0xc38c, 0xc39f, 0xc3b1,
	0xc3c2, 0xc3d4, 0xc3e5, 0xc3f7, 0xc408, 0xc419, 0xc42b, 0xc43c,
	0xc44e, 0xc45f, 0xc470, 0xc481, 0xc492, 0xc4a4, 0xc4b5, 0xc4c7,
	0xc4d9, 0xc4ea, 0xc4fb, 0xc510, 0xc522, 0xc537, 0xc54c, 0xc560,
	0xc575, 0xc589, 0xc59e, 0xc5ba, 0xc5d7, 0xc5ec, 0xc601, 0xc616,
	// Entry 4EC0 - 4EFF
	0xc62b, 0xc63e, 0xc648, 0xc65e, 0xc670, 0xc68d, 0xc6b1, 0xc6ca,
	0xc6e3, 0xc6ff, 0xc71c, 0xc738, 0xc753, 0xc76e, 0xc78b, 0xc7a7,
	0xc7c3, 0xc7de, 0xc7f8, 0xc813, 0xc82e, 0xc849, 0xc864, 0xc871,
	0xc87f, 0xc88c, 0xc89a, 0xc8a7, 0xc8b5, 0xc8ca, 0xc8e0, 0xc8f5,
	0xc90b, 0xc918, 0xc926, 0xc933, 0xc941, 0xc94f, 0xc95e, 0xc96c,
	0xc97b, 0xc98a, 0xc99a, 0xc9a8, 0xc9b7, 0xc9c5, 0xc9d4, 0xc9e3,
	0xc9f3, 0xca02, 0xca12, 0xca21, 0xca31, 0xca40, 0xca4e, 0xca5d,
	0xca6b, 0xca7a, 0xca88, 0xca97, 0xcaa5, 0xcab4, 0xcac2, 0xcad1,
	// Entry 4F00 - 4F3F
	0xcadf, 0xcaee, 0xcafc, 0xcb0a, 0xcb19, 0xcb27, 0xcb36, 0xcb44,
	0xcb53, 0xcb62, 0xcb70, 0xcb7e, 0xcb90, 0xcba1, 0xcbb3, 0xcbc4,
	0xcbd6, 0xcbef, 0xcc09, 0xcc22, 0xcc3c, 0xcc4d, 0xcc5f, 0xcc70,
	0xcc82, 0xcc92, 0xcca7, 0xccb9, 0xccca, 0xccd9, 0xcceb, 0xcd03,
	0xcd0a, 0xcd15, 0xcd1f, 0xcd30, 0xcd3a, 0xcd49, 0xcd5f, 0xcd6e,
	0xcd7c, 0xcd8a, 0xcd9a, 0xcda9, 0xcdb8, 0xcdc6, 0xcdd6, 0xcde6,
	0xcdf5, 0xce06, 0xce1b, 0xce2e, 0xce3e, 0xce58, 0xce6d, 0xce82,
	0xce8e, 0xce9e, 0xceaf, 0xcebf, 0xced0, 0xcee0, 0xcef1, 0xcf09,
	// Entry 4F40 - 4F7F
	0xcf22, 0xcf3a, 0xcf53, 0xcf63, 0xcf74, 0xcf84, 0xcf95, 0xcfa6,
	0xcfb8, 0xcfc9, 0xcfdb, 0xcfed, 0xcffe, 0xd010, 0xd021, 0xd033,
	0xd045, 0xd057, 0xd06a, 0xd07c, 0xd08f, 0xd0a1, 0xd0b2, 0xd0c4,
	0xd0d5, 0xd0e7, 0xd0f8, 0xd109, 0xd11b, 0xd12c, 0xd13e, 0xd14f,
	0xd160, 0xd171, 0xd182, 0xd193, 0xd1a5, 0xd1b7, 0xd1c8, 0xd1d9,
	0xd1ee, 0xd202, 0xd217, 0xd22b, 0xd240, 0xd25c, 0xd279, 0xd295,
	0xd2b2, 0xd2c6, 0xd2e0, 0xd2f5, 0xd309, 0xd323, 0xd338, 0xd350,
	0xd365, 0xd379, 0xd38c, 0xd39e, 0xd3b3, 0xd3c0, 0xd3d9, 0xd3e3,
	// Entry 4F80 - 4FBF
	0xd3f5, 0xd406, 0xd417, 0xd42a, 0xd43c, 0xd44e, 0xd45f, 0xd472,
	0xd485, 0xd497, 0xd4a7, 0xd4b8, 0xd4c8, 0xd4d9, 0xd4e9, 0xd4fa,
	0xd512, 0xd52b, 0xd543, 0xd55c, 0xd56c, 0xd57d, 0xd58d, 0xd59e,
	0xd5af, 0xd5c1, 0xd5d2, 0xd5e4, 0xd5f6, 0xd607, 0xd619, 0xd62a,
	0xd63c, 0xd64e, 0xd660, 0xd673, 0xd685, 0xd698, 0xd6aa, 0xd6bb,
	0xd6cd, 0xd6de, 0xd6f0, 0xd701, 0xd712, 0xd724, 0xd735, 0xd747,
	0xd758, 0xd769, 0xd77a, 0xd78b, 0xd79c, 0xd7ae, 0xd7c0, 0xd7d1,
	0xd7e2, 0xd7f7, 0xd80b, 0xd820, 0xd834, 0xd849, 0xd865, 0xd882,
	// Entry 4FC0 - 4FFF
	0xd896, 0xd8ab, 0xd8bf, 0xd8d4, 0xd8ec, 0xd901, 0xd915, 0xd928,
	0xd93a, 0xd94e, 0xd95b, 0xd96f, 0xd984, 0xd999, 0xd9b2, 0xd9cb,
	0xd9e4, 0xd9fc, 0xda34, 0xda6a, 0xda9d, 0xdad7, 0xdb11, 0xdb31,
	0xdb5b, 0xdb85, 0xdbaf, 0xdbdc, 0xdc08, 0xdc32, 0xdc66, 0xdc9b,
	0xdcc2, 0xdce7, 0xdd0d, 0xdd27, 0xdd45, 0xdd64, 0xdd71, 0xdd7f,
	0xdd8c, 0xdd9a, 0xdda7, 0xddb5, 0xddca, 0xdde0, 0xddf5, 0xde0b,
	0xde18, 0xde26, 0xde33, 0xde41, 0xde4f, 0xde5e, 0xde6c, 0xde7b,
	0xde8a, 0xde98, 0xdea7, 0xdeb5, 0xdec4, 0xded3, 0xdee2, 0xdef2,
	// Entry 5000 - 503F
	0xdf01, 0xdf11, 0xdf20, 0xdf2e, 0xdf3d, 0xdf4b, 0xdf5a, 0xdf68,
	0xdf76, 0xdf85, 0xdf93, 0xdfa2, 0xdfb0, 0xdfbe, 0xdfcc, 0xdfda,
	0xdfe8, 0xdff7, 0xe006, 0xe014, 0xe022, 0xe031, 0xe043, 0xe054,
	0xe066, 0xe077, 0xe089, 0xe0a2, 0xe0bc, 0xe0d5, 0xe0ef, 0xe100,
	0xe112, 0xe123, 0xe135, 0xe147, 0xe158, 0xe168, 0xe17d, 0xe187,
	0xe198, 0xe1ae, 0xe1bc, 0xe1cb, 0xe1d9, 0xe1e7, 0xe1f7, 0xe206,
	0xe215, 0xe223, 0xe233, 0xe243, 0xe252, 0xe26f, 0xe286, 0xe2aa,
	0xe2ce, 0xe2f2, 0xe317, 0xe343, 0xe35b, 0xe388, 0xe39d, 0xe3c0,
	// Entry 5040 - 507F
	0xe3ea, 0xe41b, 0xe429, 0xe438, 0xe446, 0xe455, 0xe463, 0xe472,
	0xe480, 0xe48f, 0xe49d, 0xe4ac, 0xe4bb, 0xe4cb, 0xe4da, 0xe4ea,
	0xe4fa, 0xe509, 0xe519, 0xe528, 0xe538, 0xe548, 0xe558, 0xe569,
	0xe579, 0xe58a, 0xe59a, 0xe5a9, 0xe5b9, 0xe5c8, 0xe5d8, 0xe5e7,
	0xe5f6, 0xe606, 0xe615, 0xe625, 0xe634, 0xe643, 0xe652, 0xe661,
	0xe670, 0xe680, 0xe68f, 0xe69e, 0xe6ae, 0xe6c1, 0xe6d3, 0xe6e6,
	0xe6f8, 0xe70b, 0xe71d, 0xe730, 0xe742, 0xe755, 0xe767, 0xe77a,
	0xe78b, 0xe79b, 0xe7b3, 0xe7ca, 0xe7da, 0xe7e9, 0xe7f8, 0xe809,
	// Entry 5080 - 50BF
	0xe819, 0xe829, 0xe838, 0xe849, 0xe85a, 0xe86a, 0xe878, 0xe887,
	0xe896, 0xe8a4, 0xe8b2, 0xe8ca, 0xe8d8, 0xe8e7, 0xe8f5, 0xe903,
	0xe911, 0xe920, 0xe92f, 0xe93d, 0xe94b, 0xe959, 0xe968, 0xe976,
	0xe983, 0xe991, 0xe9a0, 0xe9ae, 0xe9c6, 0xe9d5, 0xe9e4, 0xe9f3,
	0xea0b, 0xea28, 0xea45, 0xea6b, 0xea7c, 0xea8e, 0xea9f, 0xeab1,
	0xeac2, 0xead4, 0xeae5, 0xeaf7, 0xeb08, 0xeb1a, 0xeb2c, 0xeb3c,
	0xeb4b, 0xeb59, 0xeb67, 0xeb77, 0xeb86, 0xeb95, 0xeba3, 0xebb3,
	0xebc3, 0xebd2, 0xebe1, 0xebf3, 0xec0a, 0xec1b, 0xec2a, 0xec38,
	// Entry 50C0 - 50FF
	0xec46, 0xec55, 0xec65, 0xec74, 0xec84, 0xec93, 0xeca2, 0xecb0,
	0xecbf, 0xeccd, 0xecdc, 0xecea, 0xecf9, 0xed07, 0xed16, 0xed24,
	0xed33, 0xed42, 0xed52, 0xed61, 0xed71, 0xed81, 0xed90, 0xeda0,
	0xedaf, 0xedbf, 0xedcf, 0xeddf, 0xedf0, 0xee00, 0xee11, 0xee21,
	0xee30, 0xee40, 0xee4f, 0xee5f, 0xee6e, 0xee7d, 0xee8d, 0xee9c,
	0xeeac, 0xeebb, 0xeeca, 0xeed9, 0xeee8, 0xeef7, 0xef07, 0xef17,
	0xef26, 0xef35, 0xef45, 0xef58, 0xef6a, 0xef7d, 0xef8f, 0xefa2,
	0xefbc, 0xefd7, 0xefe9, 0xeffc, 0xf00e, 0xf021, 0xf034, 0xf046,
	// Entry 5100 - 513F
	0xf057, 0xf067, 0xf07e, 0xf09d, 0xf0b9, 0xf0d6, 0xf0f3, 0xf110,
	0xf12d, 0xf14a, 0xf167, 0xf183, 0xf19f, 0xf1bd, 0xf1da, 0xf1f7,
	0xf215, 0xf233, 0xf250, 0xf26e, 0xf28c, 0xf2aa, 0xf2c9, 0xf2e6,
	0xf303, 0xf320, 0xf33d, 0xf35a, 0xf379, 0xf398, 0xf3b7, 0xf3d5,
	0xf3f4, 0xf412, 0xf431, 0xf44e, 0xf468, 0xf483, 0xf49e, 0xf4b9,
	0xf4d4, 0xf4ef, 0xf50a, 0xf524, 0xf53e, 0xf55a, 0xf575, 0xf590,
	0xf5ac, 0xf5c8, 0xf5e3, 0xf5ff, 0xf61b, 0xf637, 0xf654, 0xf66f,
	0xf68a, 0xf6a5, 0xf6c0, 0xf6db, 0xf6f8, 0xf715, 0xf732, 0xf74e,
	// Entry 5140 - 517F
	0xf76b, 0xf787, 0xf7a4, 0xf7ba, 0xf7cf, 0xf7e4, 0xf7fb, 0xf811,
	0xf827, 0xf83c, 0xf853, 0xf86a, 0xf880, 0xf896, 0xf8af, 0xf8c8,
	0xf8e0, 0xf8f8, 0xf910, 0xf92a, 0xf943, 0xf95c, 0xf96a, 0xf97e,
	0xf993, 0xf9a7, 0xf9bc, 0xf9d0, 0xf9e5, 0xf9f9, 0xfa0d, 0xfa22,
	0xfa38, 0xfa4d, 0xfa63, 0xfa79, 0xfa8e, 0xfaa4, 0xfab9, 0xfacf,
	0xfae5, 0xfafb, 0xfb12, 0xfb28, 0xfb3d, 0xfb53, 0xfb68, 0xfb7e,
	0xfb93, 0xfba8, 0xfbbe, 0xfbd3, 0xfbe9, 0xfbfe, 0xfc13, 0xfc29,
	0xfc3e, 0xfc53, 0xfc68, 0xfc7e, 0xfc94, 0xfca9, 0xfcbe, 0xfcd4,
	// Entry 5180 - 51BF
	0xfce9, 0xfd02, 0xfd1a, 0xfd33, 0xfd4b, 0xfd64, 0xfd7c, 0xfd95,
	0xfdad, 0xfdc6, 0xfde2, 0xfdfa, 0xfe0c, 0xfe2b, 0xfe40, 0xfe56,
	0xfe6b, 0xfe81, 0xfe99, 0xfeaf, 0xfecb, 0xfee1, 0xfef6, 0xff0b,
	0xff22, 0xff38, 0xff4e, 0xff63, 0xff7a, 0xff91, 0xffa7, 0xffbb,
	0xffd0, 0xffe4, 0xfff9, 0x000d, 0x0022, 0x003e, 0x005b, 0x006f,
	0x0084, 0x0098, 0x00ad, 0x00c2, 0x00d8, 0x00ed, 0x0103, 0x0119,
	0x012e, 0x0144, 0x0159, 0x016f, 0x0185, 0x019b, 0x01b2, 0x01c8,
	0x01df, 0x01f5, 0x020a, 0x0220, 0x0235, 0x024b, 0x0260, 0x0275,
	// Entry 51C0 - 51FF
	0x028b, 0x02a0, 0x02b6, 0x02cb, 0x02e0, 0x02f5, 0x030a, 0x031f,
	0x0335, 0x034b, 0x0360, 0x0375, 0x038b, 0x03a1, 0x03ba, 0x03d2,
	0x03eb, 0x0403, 0x041c, 0x043c, 0x045d, 0x0475, 0x048e, 0x04a6,
	0x04bf, 0x04d8, 0x04f0, 0x0507, 0x0520, 0x0538, 0x054e, 0x0574,
	0x058d, 0x05aa, 0x05c8, 0x05e5, 0x0602, 0x0620, 0x063d, 0x065b,
	0x0679, 0x069f, 0x06c1, 0x06db, 0x06f6, 0x0710, 0x072b, 0x0746,
	0x0760, 0x077b, 0x0795, 0x07b0, 0x07cb, 0x07e7, 0x0802, 0x081e,
	0x0839, 0x0853, 0x086e, 0x0888, 0x08a3, 0x08bd, 0x08d7, 0x08f2,
	// Entry 5200 - 523F
	0x090c, 0x0927, 0x0941, 0x095c, 0x0978, 0x0993, 0x09af, 0x09ca,
	0x09e4, 0x09fe, 0x0a18, 0x0a32, 0x0a4c, 0x0a66, 0x0a81, 0x0a9c,
	0x0ab6, 0x0ad0, 0x0aec, 0x0b11, 0x0b2d, 0x0b4e, 0x0b7d, 0x0ba7,
	0x0bc5, 0x0be2, 0x0c0c, 0x0c34, 0x0c5c, 0x0c84, 0x0cac, 0x0cce,
	0x0cf0, 0x0d0b, 0x0d25, 0x0d46, 0x0d66, 0x0d95, 0x0dc4, 0x0dde,
	0x0dee, 0x0e02, 0x0e17, 0x0e2b, 0x0e3f, 0x0e53, 0x0e68, 0x0e7d,
	0x0e92, 0x0eae, 0x0eca, 0x0ee3, 0x0ef4, 0x0f06, 0x0f17, 0x0f29,
	0x0f3b, 0x0f4c, 0x0f5e, 0x0f6f, 0x0f81, 0x0f93, 0x0fa5, 0x0fb8,
	// Entry 5240 - 527F
	0x0fca, 0x0fdd, 0x0fef, 0x1000, 0x1012, 0x1023, 0x1035, 0x1046,
	0x1057, 0x1069, 0x107a, 0x108c, 0x109d, 0x10af, 0x10c2, 0x10d4,
	0x10e6, 0x10f7, 0x1108, 0x1119, 0x112a, 0x113b, 0x114c, 0x115e,
	0x1170, 0x1181, 0x1192, 0x11a5, 0x11bd, 0x11d5, 0x11f6, 0x1217,
	0x1239, 0x125a, 0x1278, 0x1296, 0x12b5, 0x12d3, 0x12f1, 0x130f,
	0x132d, 0x134b, 0x1369, 0x1388, 0x13a6, 0x13c5, 0x13da, 0x13ee,
	0x1405, 0x1416, 0x1428, 0x1439, 0x1451, 0x1463, 0x1497, 0x14c4,
	0x14e7, 0x14fe, 0x1515, 0x1533, 0x1552, 0x1570, 0x158f, 0x15ad,
	// Entry 5280 - 52BF
	0x15cc, 0x15ec, 0x160d, 0x162d, 0x164e, 0x166e, 0x168f, 0x16a5,
	0x16bb, 0x16d1, 0x16e7, 0x16fc, 0x1711, 0x1726, 0x173b, 0x1750,
	0x1765, 0x177a, 0x1790, 0x17a5, 0x17ba, 0x17d0, 0x17e5, 0x17fa,
	0x180f, 0x1824, 0x183a, 0x184f, 0x1865, 0x187a, 0x188f, 0x18a5,
	0x18b9, 0x18cd, 0x18e1, 0x18f5, 0x1909, 0x191e, 0x1933, 0x194d,
	0x1967, 0x1981, 0x199b, 0x19b5, 0x19cf, 0x19e9, 0x1a04, 0x1a1e,
	0x1a3a, 0x1a51, 0x1a70, 0x1a92, 0x1aaf, 0x1ad4, 0x1af0, 0x1b07,
	0x1b29, 0x1b46, 0x1b60, 0x1b80, 0x1ba5, 0x1bc5, 0x1be6, 0x1c02,
	// Entry 52C0 - 52FF
	0x1c1a, 0x1c41, 0x1c63, 0x1c81, 0x1c95, 0x1cb9, 0x1cce, 0x1ced,
	0x1d0b, 0x1d33, 0x1d5a, 0x1d81, 0x1da9, 0x1dbe, 0x1dd0, 0x1de3,
	0x1df5, 0x1e08, 0x1e1a, 0x1e2d, 0x1e47, 0x1e62, 0x1e7c, 0x1e8e,
	0x1ea1, 0x1eb3, 0x1ec6, 0x1ed9, 0x1eed, 0x1f00, 0x1f14, 0x1f28,
	0x1f3b, 0x1f4f, 0x1f62, 0x1f76, 0x1f8a, 0x1f9e, 0x1fb3, 0x1fc7,
	0x1fdc, 0x1ff0, 0x2003, 0x2017, 0x202a, 0x203e, 0x2051, 0x2064,
	0x2078, 0x208b, 0x209f, 0x20b2, 0x20c5, 0x20d8, 0x20eb, 0x20fe,
	0x2112, 0x2126, 0x2139, 0x214c, 0x2163, 0x2179, 0x2190, 0x21a6,
	// Entry 5300 - 533F
	0x21bd, 0x21db, 0x21fa, 0x2218, 0x222e, 0x2245, 0x225b, 0x2272,
	0x228c, 0x22a3, 0x22b9, 0x22ce, 0x22e5, 0x22f4, 0x230a, 0x2322,
	0x2338, 0x234e, 0x2362, 0x2375, 0x2388, 0x239d, 0x23b1, 0x23c5,
	0x23d8, 0x23ed, 0x2402, 0x2416, 0x242a, 0x243e, 0x2454, 0x2469,
	0x247e, 0x2492, 0x24a8, 0x24be, 0x24d3, 0x24e7, 0x24fe, 0x2515,
	0x252b, 0x2541, 0x2557, 0x256f, 0x2586, 0x259d, 0x25b9, 0x25ca,
	0x25db, 0x25ec, 0x25fe, 0x260f, 0x2621, 0x2632, 0x2644, 0x2655,
	0x2667, 0x2678, 0x268a, 0x269b, 0x26ac, 0x26bd, 0x26cf, 0x26e0,
	// Entry 5340 - 537F
	0x26f1, 0x2703, 0x2716, 0x2728, 0x2739, 0x274b, 0x275c, 0x276d,
	0x277e, 0x278f, 0x27a0, 0x27b2, 0x27c3, 0x27d4, 0x27e4, 0x27ff,
	0x281b, 0x2836, 0x2852, 0x286d, 0x2889, 0x28a4, 0x28c0, 0x28db,
	0x28f7, 0x2912, 0x292d, 0x2948, 0x2964, 0x297f, 0x299a, 0x29b6,
	0x29d3, 0x29ef, 0x2a0a, 0x2a26, 0x2a41, 0x2a5c, 0x2a77, 0x2a92,
	0x2aae, 0x2ac9, 0x2ae4, 0x2afe, 0x2b13, 0x2b27, 0x2b3b, 0x2b4f,
	0x2b63, 0x2b78, 0x2b90, 0x2ba6, 0x2bbd, 0x2bd3, 0x2bea, 0x2c00,
	0x2c17, 0x2c2d, 0x2c44, 0x2c5a, 0x2c71, 0x2c88, 0x2ca0, 0x2cb7,
	// Entry 5380 - 53BF
	0x2ccf, 0x2ce7, 0x2cfe, 0x2d16, 0x2d2d, 0x2d45, 0x2d5d, 0x2d75,
	0x2d8e, 0x2da6, 0x2dbf, 0x2dd7, 0x2dee, 0x2e06, 0x2e1d, 0x2e35,
	0x2e4c, 0x2e63, 0x2e7b, 0x2e92, 0x2eaa, 0x2ec1, 0x2ed8, 0x2eef,
	0x2f06, 0x2f1d, 0x2f35, 0x2f4d, 0x2f64, 0x2f7b, 0x2f93, 0x2fac,
	0x2fc5, 0x2fdd, 0x2ff8, 0x3012, 0x302d, 0x3047, 0x3062, 0x3084,
	0x309e, 0x30b9, 0x30d3, 0x30ee, 0x3109, 0x3123, 0x313b, 0x3154,
	0x316e, 0x3182, 0x3195, 0x31aa, 0x31c2, 0x31d9, 0x31f0, 0x3209,
	0x3221, 0x3239, 0x3250, 0x3269, 0x3282, 0x329a, 0x32b0, 0x32c7,
	// Entry 53C0 - 53FF
	0x32dd, 0x32f4, 0x330a, 0x3321, 0x3338, 0x334f, 0x3366, 0x337d,
	0x3394, 0x33ab, 0x33c2, 0x33da, 0x33f1, 0x3408, 0x3420, 0x3437,
	0x344f, 0x3466, 0x347d, 0x3495, 0x34ac, 0x34c4, 0x34db, 0x34f2,
	0x350a, 0x3522, 0x353b, 0x3553, 0x356a, 0x3582, 0x359a, 0x35b3,
	0x35cb, 0x35e2, 0x35fa, 0x3611, 0x3628, 0x363f, 0x365a, 0x3674,
	0x368f, 0x36a9, 0x36c4, 0x36df, 0x36fa, 0x3715, 0x3730, 0x374b,
	0x3765, 0x3779, 0x3789, 0x37a1, 0x37b8, 0x37cf, 0x37e8, 0x3800,
	0x3818, 0x382f, 0x3848, 0x3861, 0x3879, 0x388a, 0x389b, 0x38ad,
	// Entry 5400 - 543F
	0x38be, 0x38cf, 0x38e0, 0x38f1, 0x3902, 0x3913, 0x3924, 0x3935,
	0x3947, 0x3958, 0x3969, 0x397a, 0x398b, 0x399c, 0x39ac, 0x39b9,
	0x39cd, 0x39e1, 0x39f5, 0x3a09, 0x3a1b, 0x3a31, 0x3a46, 0x3a58,
	0x3a67, 0x3a78, 0x3a85, 0x3a93, 0x3aa0, 0x3aae, 0x3abb, 0x3ac9,
	0x3ade, 0x3af4, 0x3b09, 0x3b1f, 0x3b2c, 0x3b3a, 0x3b47, 0x3b55,
	0x3b64, 0x3b72, 0x3b81, 0x3b90, 0x3b9e, 0x3bad, 0x3bbb, 0x3bca,
	0x3bd9, 0x3be8, 0x3bf8, 0x3c07, 0x3c17, 0x3c26, 0x3c34, 0x3c43,
	0x3c51, 0x3c60, 0x3c6e, 0x3c7c, 0x3c8b, 0x3c99, 0x3ca8, 0x3cb6,
	// Entry 5440 - 547F
	0x3cc4, 0x3cd2, 0x3ce0, 0x3cee, 0x3cfd, 0x3d0c, 0x3d1a, 0x3d28,
	0x3d38, 0x3d4a, 0x3d66, 0x3d77, 0x3d89, 0x3d9a, 0x3dac, 0x3dc5,
	0x3dd6, 0x3de8, 0x3dfa, 0x3e0a, 0x3e18, 0x3e22, 0x3e33, 0x3e52,
	0x3e7b, 0x3e92, 0x3eaf, 0x3ec3, 0x3ede, 0x3ef9, 0x3f10, 0x3f2e,
	0x3f45, 0x3f64, 0x3f73, 0x3f81, 0x3f8f, 0x3f9f, 0x3fae, 0x3fbd,
	0x3fcb, 0x3fdb, 0x3feb, 0x3ffa, 0x4009, 0x4037, 0x4062, 0x407e,
	0x409d, 0x40b8, 0x40d8, 0x40f7, 0x4119, 0x4135, 0x4153, 0x4171,
	0x4189, 0x41a2, 0x41c1, 0x41e0, 0x41f8, 0x4212, 0x422b, 0x4244,
	// Entry 5480 - 54BF
	0x4261, 0x4288, 0x4296, 0x42a7, 0x42bb, 0x42cd, 0x42e3, 0x42f4,
	0x4307, 0x431b, 0x432b, 0x433b, 0x4349, 0x435c, 0x436d, 0x437d,
	0x438c, 0x43a6, 0x43c0, 0x43cf, 0x43e2, 0x43ff, 0x441c, 0x442e,
	0x4440, 0x4450, 0x4460, 0x4478, 0x4490, 0x44a4, 0x44b9, 0x44d6,
	0x44e6, 0x44fe, 0x4518, 0x4538, 0x4551, 0x456b, 0x458c, 0x45a7,
	0x45c1, 0x45d2, 0x45e3, 0x45ff, 0x4620, 0x463b, 0x465c, 0x4676,
	0x4696, 0x46b2, 0x46cf, 0x46ec, 0x4713, 0x4729, 0x473b, 0x4759,
	0x477b, 0x479e, 0x47bb, 0x47d8, 0x47e9, 0x47fa, 0x4817, 0x483e,
	// Entry 54C0 - 54FF
	0x484f, 0x4869, 0x4885, 0x48a1, 0x48bb, 0x48d7, 0x48f1, 0x490c,
	0x4927, 0x493a, 0x494e, 0x4961, 0x497e, 0x498f, 0x49a8, 0x49c5,
	0x49f6, 0x4a19, 0x4a2d, 0x4a40, 0x4a53, 0x4a70, 0x4a84, 0x4a98,
	0x4aaa, 0x4ac6, 0x4ae2, 0x4b1f, 0x4b43, 0x4b86, 0x4b99, 0x4bae,
	0x4bbf, 0x4bd1, 0x4be4, 0x4bf9, 0x4c0b, 0x4c26, 0x4c3a, 0x4c4c,
	0x4c60, 0x4c71, 0x4c8a, 0x4ca5, 0x4cc5, 0x4cd6, 0x4cf2, 0x4d0e,
	0x4d2b, 0x4d3f, 0x4d5e, 0x4d70, 0x4d83, 0x4d94, 0x4da6, 0x4dd1,
	0x4df5, 0x4e1a, 0x4e3c, 0x4e5e, 0x4e8a, 0x4eac, 0x4ed0, 0x4ef3,
	// Entry 5500 - 553F
	0x4f15, 0x4f37, 0x4f61, 0x4f84, 0x4fa6, 0x4fc8, 0x4ff5, 0x5018,
	0x503a, 0x5066, 0x5088, 0x50ac, 0x50d8, 0x50fb, 0x510d, 0x511f,
	0x5133, 0x5147, 0x5158, 0x516a, 0x517c, 0x5198, 0x51ab, 0x51bd,
	0x51e2, 0x51f5, 0x5206, 0x521f, 0x5235, 0x524e, 0x5260, 0x527d,
	0x5290, 0x52a2, 0x52b6, 0x52c8, 0x52da, 0x52ed, 0x5305, 0x5322,
	0x5335, 0x5348, 0x5358, 0x5372, 0x5396, 0x53a7, 0x53d0, 0x53eb,
	0x5405, 0x5420, 0x543b, 0x5454, 0x5467, 0x547a, 0x548b, 0x549c,
	0x54b8, 0x54d9, 0x54f3, 0x5510, 0x552d, 0x5546, 0x5559, 0x556d,
	// Entry 5540 - 557F
	0x5580, 0x5593, 0x55ae, 0x55d2, 0x5600, 0x561c, 0x5639, 0x565c,
	0x5684, 0x56a0, 0x56c1, 0x56e3, 0x5703, 0x572b, 0x5748, 0x5764,
	0x578b, 0x57a7, 0x57c3, 0x57df, 0x57fb, 0x580c, 0x5822, 0x5834,
	0x585e, 0x5880, 0x58a3, 0x58cd, 0x58e8, 0x5904, 0x592a, 0x5946,
	0x596a, 0x5986, 0x59aa, 0x59c5, 0x59e0, 0x5a06, 0x5a22, 0x5a3d,
	0x5a60, 0x5a7b, 0x5aa6, 0x5ac8, 0x5ae4, 0x5aff, 0x5b1b, 0x5b3e,
	0x5b63, 0x5b90, 0x5bac, 0x5bd0, 0x5bf3, 0x5c10, 0x5c31, 0x5c5e,
	0x5c7a, 0x5c99, 0x5cb5, 0x5cda, 0x5cfe, 0x5d19, 0x5d3c, 0x5d57,
	// Entry 5580 - 55BF
	0x5d73, 0x5d98, 0x5db3, 0x5dcf, 0x5deb, 0x5e07, 0x5e2c, 0x5e49,
	0x5e65, 0x5e82, 0x5e9c, 0x5eb7, 0x5eda, 0x5ef5, 0x5f08, 0x5f29,
	0x5f3b, 0x5f63, 0x5f75, 0x5fa1, 0x5fb5, 0x5fc7, 0x5fd9, 0x5fec,
	0x6004, 0x6021, 0x6042, 0x6054, 0x6067, 0x607c, 0x6092, 0x60b2,
	0x60c3, 0x60dc, 0x60f5, 0x6112, 0x6124, 0x613f, 0x615e, 0x6172,
	0x6185, 0x619d, 0x61b0, 0x61d4, 0x61f7, 0x6214, 0x6239, 0x6255,
	0x6269, 0x627c, 0x629d, 0x62ba, 0x62d8, 0x62f0, 0x6301, 0x631e,
	0x6330, 0x634c, 0x6377, 0x6393, 0x63b9, 0x63d0, 0x63e2, 0x6405,
	// Entry 55C0 - 55FF
	0x6421, 0x6442, 0x6454, 0x6466, 0x6482, 0x6494, 0x64a7, 0x64bb,
	0x64d0, 0x64e1, 0x64f7, 0x650d, 0x651f, 0x6530, 0x654b, 0x6567,
	0x6582, 0x659e, 0x65b9, 0x65d4, 0x65ef, 0x660a, 0x6623, 0x6634,
	0x6647, 0x6663, 0x6680, 0x66a0, 0x66be, 0x66da, 0x66ed, 0x66fd,
	0x670f, 0x6720, 0x6733, 0x6754, 0x6779, 0x678a, 0x679c, 0x67b2,
	0x67c7, 0x67fc, 0x6813, 0x6824, 0x6845, 0x6857, 0x6868, 0x6884,
	0x68a1, 0x68be, 0x68d7, 0x68ea, 0x68fb, 0x690c, 0x691e, 0x692f,
	0x6948, 0x6962, 0x6985, 0x69a1, 0x69bc, 0x69d9, 0x69f4, 0x6a0e,
	// Entry 5600 - 563F
	0x6a2b, 0x6a47, 0x6a61, 0x6a7c, 0x6a9d, 0x6ab8, 0x6ae4, 0x6afe,
	0x6b1a, 0x6b3f, 0x6b69, 0x6b83, 0x6b9f, 0x6bba, 0x6bd4, 0x6bef,
	0x6c09, 0x6c24, 0x6c3e, 0x6c58, 0x6c72, 0x6c94, 0x6cb6, 0x6cd8,
	0x6cf2, 0x6d17, 0x6d31, 0x6d4c, 0x6d66, 0x6d80, 0x6d9a, 0x6db5,
	0x6dd0, 0x6deb, 0x6e07, 0x6e22, 0x6e3d, 0x6e5a, 0x6e75, 0x6e8e,
	0x6ea8, 0x6ec2, 0x6ee7, 0x6f02, 0x6f1c, 0x6f2e, 0x6f4d, 0x6f5f,
	0x6f72, 0x6f85, 0x6f98, 0x6fab, 0x6fc8, 0x6fda, 0x6ffb, 0x700d,
	0x7029, 0x7048, 0x705b, 0x706e, 0x7083, 0x70b9, 0x70fb, 0x710f,
	// Entry 5640 - 567F
	0x7120, 0x713b, 0x7154, 0x716e, 0x7180, 0x7192, 0x71a6, 0x71b9,
	0x71ce, 0x71ef, 0x7200, 0x723a, 0x724c, 0x725e, 0x727d, 0x728f,
	0x72a1, 0x72b8, 0x72ca, 0x72dc, 0x72fb, 0x7310, 0x7325, 0x7336,
	0x734a, 0x7366, 0x7392, 0x73b7, 0x73dc, 0x73f9, 0x7416, 0x743e,
	0x745c, 0x7479, 0x7497, 0x74b4, 0x74d1, 0x74ef, 0x750d, 0x7534,
	0x7551, 0x756f, 0x7596, 0x75b9, 0x75d6, 0x75fb, 0x7620, 0x763d,
	0x765b, 0x7679, 0x7697, 0x76c4, 0x76e4, 0x7703, 0x7720, 0x773e,
	0x775b, 0x7780, 0x779f, 0x77bc, 0x77e3, 0x7818, 0x7847, 0x7866,
	// Entry 5680 - 56BF
	0x788f, 0x78ad, 0x78cb, 0x78ea, 0x791e, 0x793a, 0x795d, 0x7987,
	0x79ad, 0x79ca, 0x79e8, 0x7a04, 0x7a18, 0x7a36, 0x7a5d, 0x7a76,
	0x7aa3, 0x7ab8, 0x7aca, 0x7ae6, 0x7af8, 0x7b14, 0x7b38, 0x7b49,
	0x7b5b, 0x7b70, 0x7b83, 0x7b94, 0x7baf, 0x7bc1, 0x7bdc, 0x7bf8,
	0x7c15, 0x7c37, 0x7c59, 0x7c7e, 0x7c99, 0x7cb6, 0x7cd3, 0x7cf9,
	0x7d14, 0x7d38, 0x7d56, 0x7d79, 0x7d94, 0x7daf, 0x7dd3, 0x7df8,
	0x7e15, 0x7e2c, 0x7e4b, 0x7e6a, 0x7e84, 0x7e9e, 0x7eb0, 0x7ec4,
	0x7ee3, 0x7f06, 0x7f22, 0x7f34, 0x7f46, 0x7f58, 0x7f73, 0x7f9b,
	// Entry 56C0 - 56FF
	0x7fac, 0x7fc8, 0x7fde, 0x7ff0, 0x8002, 0x8014, 0x8027, 0x803b,
	0x804c, 0x805e, 0x806f, 0x8081, 0x8092, 0x80ab, 0x80bd, 0x80d4,
	0x80e9, 0x80fe, 0x8111, 0x812c, 0x8149, 0x8165, 0x8182, 0x81af,
	0x81d0, 0x81e4, 0x8200, 0x8224, 0x8241, 0x825a, 0x826b, 0x827d,
	0x8290, 0x82ac, 0x82ce, 0x82ef, 0x8303, 0x831d, 0x832f, 0x8342,
	0x8353, 0x836c, 0x8386, 0x839f, 0x83b0, 0x83c9, 0x83db, 0x83ed,
	0x840f, 0x843a, 0x844f, 0x846d, 0x848c, 0x84b4, 0x84d3, 0x8500,
	0x851e, 0x853d, 0x855c, 0x8585, 0x85ad, 0x85de, 0x8605, 0x8624,
	// Entry 5700 - 573F
	0x8638, 0x8649, 0x865c, 0x866e, 0x8690, 0x86b3, 0x86d5, 0x8710,
	0x8732, 0x8749, 0x8764, 0x8783, 0x87b3, 0x87c7, 0x87ec, 0x880d,
	0x882f, 0x8851, 0x8878, 0x889b, 0x88bc, 0x88dd, 0x8901, 0x8922,
	0x8946, 0x896c, 0x897d, 0x898f, 0x89a1, 0x89b3, 0x89c7, 0x89d8,
	0x89f1, 0x8a0b, 0x8a25, 0x8a3f, 0x8a58, 0x8a71, 0x8a8b, 0x8aa4,
	0x8abe, 0x8adb, 0x8aef, 0x8b0d, 0x8b2a, 0x8b47, 0x8b6a, 0x8b7b,
	0x8b8d, 0x8b9e, 0x8baf, 0x8bc0, 0x8bda, 0x8bec, 0x8c06, 0x8c21,
	0x8c3d, 0x8c58, 0x8c74, 0x8c90, 0x8cac, 0x8cc7, 0x8ce3, 0x8cff,
	// Entry 5740 - 577F
	0x8d1c, 0x8d38, 0x8d53, 0x8d6e, 0x8d89, 0x8da4, 0x8dc0, 0x8ddb,
	0x8df2, 0x8e04, 0x8e27, 0x8e3c, 0x8e4e, 0x8e60, 0x8e73, 0x8e8e,
	0x8eab, 0x8ec9, 0x8ee5, 0x8f03, 0x8f20, 0x8f3b, 0x8f5d, 0x8f70,
	0x8f84, 0x8f98, 0x8faa, 0x8fbf, 0x8ff4, 0x9029, 0x903d, 0x9050,
	0x9064, 0x9079, 0x9090, 0x90a3, 0x90be, 0x90da, 0x90ed, 0x9108,
	0x9125, 0x9144, 0x9161, 0x917e, 0x919b, 0x91bd, 0x91dd, 0x91fa,
	0x9217, 0x9234, 0x9249, 0x925c, 0x9274, 0x929e, 0x92b2, 0x92c4,
	0x92e8, 0x92fb, 0x9310, 0x9321, 0x9337, 0x9349, 0x935c, 0x937e,
	// Entry 5780 - 57BF
	0x9391, 0x93a5, 0x93b6, 0x93cf, 0x93e1, 0x93f4, 0x9408, 0x941a,
	0x942f, 0x9441, 0x9454, 0x9465, 0x947f, 0x9499, 0x94b3, 0x94c9,
	0x94db, 0x9510, 0x952a, 0x953c, 0x9557, 0x9573, 0x958f, 0x95ab,
	0x95c8, 0x95e3, 0x95f6, 0x9608, 0x9619, 0x962f, 0x9640, 0x9656,
	0x9668, 0x967a, 0x9697, 0x96b2, 0x96e7, 0x96f8, 0x970b, 0x971d,
	0x972f, 0x9741, 0x9767, 0x9777, 0x978b, 0x979f, 0x97ce, 0x97f2,
	0x9824, 0x9835, 0x9846, 0x9857, 0x986f, 0x988a, 0x98a4, 0x98cb,
	0x98f7, 0x990d, 0x9926, 0x9949, 0x995c, 0x996d, 0x998a, 0x99ac,
	// Entry 57C0 - 57FF
	0x99c8, 0x99e1, 0x99f5, 0x9a08, 0x9a28, 0x9a44, 0x9a55, 0x9a6b,
	0x9a7c, 0x9a99, 0x9ab2, 0x9ac4, 0x9ae6, 0x9b08, 0x9b23, 0x9b3e,
	0x9b5a, 0x9b75, 0x9b99, 0x9bbc, 0x9bce, 0x9be0, 0x9bf3, 0x9c05,
	0x9c1f, 0x9c3e, 0x9c5a, 0x9c76, 0x9c91, 0x9cad, 0x9ccf, 0x9ceb,
	0x9d06, 0x9d21, 0x9d3d, 0x9d58, 0x9d74, 0x9d8f, 0x9dab, 0x9dc7,
	0x9de2, 0x9dfe, 0x9e1b, 0x9e36, 0x9e59, 0x9e74, 0x9e92, 0x9ea6,
	0x9ec2, 0x9ed4, 0x9eee, 0x9f09, 0x9f25, 0x9f42, 0x9f55, 0x9f68,
	0x9f7d, 0x9f91, 0x9fa3, 0x9fc2, 0x9fd4, 0x9fe5, 0x9ffb, 0xa01e,
	// Entry 5800 - 583F
	0xa030, 0xa043, 0xa055, 0xa066, 0xa07f, 0xa091, 0xa0a3, 0xa0bf,
	0xa0d1, 0xa0e4, 0xa0f5, 0xa107, 0xa121, 0xa135, 0xa147, 0xa161,
	0xa17c, 0xa196, 0xa1b3, 0xa1df, 0xa1f2, 0xa20e, 0xa22a, 0xa247,
	0xa264, 0xa28f, 0xa2ac, 0xa2bf, 0xa2d1, 0xa2e4, 0xa301, 0xa31d,
	0xa339, 0xa354, 0xa379, 0xa394, 0xa3ae, 0xa3ca, 0xa3e4, 0xa3ff,
	0xa41c, 0xa440, 0xa466, 0xa482, 0xa495, 0xa4b2, 0xa4c4, 0xa4d6,
	0xa4e9, 0xa508, 0xa526, 0xa550, 0xa56d, 0xa580, 0xa5a1, 0xa5b3,
	0xa5cd, 0xa5df, 0xa5fd, 0xa61d, 0xa63c, 0xa65b, 0xa679, 0xa699,
	// Entry 5840 - 587F
	0xa6b9, 0xa6d8, 0xa6f9, 0xa719, 0xa739, 0xa758, 0xa779, 0xa79a,
	0xa7ba, 0xa7d7, 0xa7f4, 0xa810, 0xa82e, 0xa84c, 0xa869, 0xa889,
	0xa8a9, 0xa8cb, 0xa8ec, 0xa90d, 0xa92d, 0xa94f, 0xa971, 0xa992,
	0xa9b2, 0xa9d2, 0xa9f4, 0xaa15, 0xaa36, 0xaa56, 0xaa78, 0xaaa7,
	0xaac8, 0xaae9, 0xab09, 0xab2b, 0xab4d, 0xab6e, 0xab8e, 0xabae,
	0xabd0, 0xabff, 0xac20, 0xac41, 0xac71, 0xaca0, 0xacbf, 0xacde,
	0xacff, 0xad2d, 0xad4d, 0xad6d, 0xad9c, 0xadcb, 0xadf9, 0xae28,
	0xae58, 0xae88, 0xaeb4, 0xaee3, 0xaf13, 0xaf43, 0xaf71, 0xafa0,
	// Entry 5880 - 58BF
	0xafcf, 0xafff, 0xb02f, 0xb060, 0xb083, 0xb0a8, 0xb0cc, 0xb0f0,
	0xb113, 0xb132, 0xb151, 0xb172, 0xb192, 0xb1bf, 0xb1df, 0xb20c,
	0xb22c, 0xb24c, 0xb26c, 0xb28c, 0xb2b1, 0xb2d7, 0xb2fe, 0xb32d,
	0xb35d, 0xb382, 0xb3a8, 0xb3d5, 0xb404, 0xb42a, 0xb44d, 0xb475,
	0xb49e, 0xb4c2, 0xb4e6, 0xb510, 0xb53a, 0xb563, 0xb58e, 0xb5b9,
	0xb5e3, 0xb617, 0xb640, 0xb669, 0xb695, 0xb6c2, 0xb6e2, 0xb6fe,
	0xb71a, 0xb73c, 0xb75b, 0xb779, 0xb797, 0xb7ba, 0xb7d6, 0xb7f2,
	0xb80e, 0xb82c, 0xb848, 0xb866, 0xb882, 0xb8a6, 0xb8c2, 0xb8de,
	// Entry 58C0 - 58FF
	0xb8fc, 0xb917, 0xb932, 0xb954, 0xb971, 0xb98c, 0xb9a7, 0xb9c8,
	0xb9e7, 0xba03, 0xba22, 0xba4d, 0xba6d, 0xba89, 0xbaaf, 0xbad5,
	0xbaf2, 0xbb0e, 0xbb29, 0xbb44, 0xbb5f, 0xbb7b, 0xbb9b, 0xbbb6,
	0xbbd1, 0xbbe7, 0xbc08, 0xbc2d, 0xbc51, 0xbc7b, 0xbc9f, 0xbcc4,
	0xbce8, 0xbd0d, 0xbd31, 0xbd4d, 0xbd6c, 0xbd8d, 0xbdb8, 0xbde1,
	0xbdfe, 0xbe19, 0xbe3d, 0xbe61, 0xbe83, 0xbeae, 0xbeca, 0xbef0,
	0xbf0c, 0xbf29, 0xbf44, 0xbf67, 0xbf8a, 0xbfa7, 0xbfc4, 0xbfee,
	0xc00c, 0xc038, 0xc059, 0xc080, 0xc09b, 0xc0c8, 0xc0e2, 0xc0fc,
	// Entry 5900 - 593F
	0xc119, 0xc133, 0xc158, 0xc16e, 0xc184, 0xc19a, 0xc1b0, 0xc1c6,
	0xc1dc, 0xc1f2, 0xc21a, 0xc230, 0xc253, 0xc269, 0xc27f, 0xc295,
	0xc2ab, 0xc2c1, 0xc2d7, 0xc2ed, 0xc303, 0xc319, 0xc32f, 0xc345,
	0xc35b, 0xc371, 0xc387, 0xc39d, 0xc3b3, 0xc3c9, 0xc3df, 0xc3f5,
	0xc414, 0xc434, 0xc45d, 0xc48f, 0xc4b6, 0xc4cc, 0xc4e2, 0xc4f8,
	0xc50e, 0xc524, 0xc53a, 0xc550, 0xc566, 0xc57c, 0xc592, 0xc5a8,
	0xc5c8, 0xc5e8, 0xc613, 0xc633, 0xc652, 0xc672, 0xc691, 0xc6b0,
	0xc6cf, 0xc6f1, 0xc707, 0xc71d, 0xc73d, 0xc75c, 0xc77c, 0xc7a1,
	// Entry 5940 - 597F
	0xc7c0, 0xc7f2, 0xc81c, 0xc83b, 0xc85d, 0xc873, 0xc889, 0xc8aa,
	0xc8c7, 0xc8e3, 0xc8ff, 0xc92d, 0xc94a, 0xc964, 0xc98a, 0xc9b1,
	0xc9d5, 0xc9f5, 0xca14, 0xca32, 0xca53, 0xca76, 0xca96, 0xcabe,
	0xcadb, 0xcaff, 0xcb20, 0xcb40, 0xcb5b, 0xcb7f, 0xcb9c, 0xcbb4,
	0xcbcf, 0xcbeb, 0xcc07, 0xcc22, 0xcc47, 0xcc6b, 0xcc87, 0xcca3,
	0xccc5, 0xcce8, 0xcd03, 0xcd1e, 0xcd3c, 0xcd5c, 0xcd78, 0xcd8a,
	0xcdac, 0xcdd4, 0xcdeb, 0xce02, 0xce19, 0xce30, 0xce47, 0xce5e,
	0xce75, 0xce8c, 0xcea3, 0xceba, 0xced1, 0xcee9, 0xcf00, 0xcf17,
	// Entry 5980 - 59BF
	0xcf2e, 0xcf45, 0xcf5c, 0xcf73, 0xcf8a, 0xcfa1, 0xcfb8, 0xcfcf,
	0xcfe6, 0xcffd, 0xd014, 0xd02b, 0xd042, 0xd059, 0xd070, 0xd087,
	0xd09e, 0xd0b5, 0xd0cc, 0xd0e3, 0xd0fa, 0xd111, 0xd128, 0xd13f,
	0xd156, 0xd16d, 0xd184, 0xd19b, 0xd1b2, 0xd1c9, 0xd1e0, 0xd1f7,
	0xd20e, 0xd225, 0xd23c, 0xd253, 0xd26a, 0xd281, 0xd298, 0xd2af,
	0xd2c6, 0xd2dd, 0xd2f4, 0xd30b, 0xd322, 0xd339, 0xd350, 0xd367,
	0xd37f, 0xd396, 0xd3ad, 0xd3c4, 0xd3db, 0xd3f2, 0xd409, 0xd420,
	0xd437, 0xd44e, 0xd465, 0xd47c, 0xd493, 0xd4aa, 0xd4c1, 0xd4d8,
	// Entry 59C0 - 59FF
	0xd4ef, 0xd506, 0xd51d, 0xd534, 0xd54b, 0xd562, 0xd579, 0xd590,
	0xd5a7, 0xd5be, 0xd5d5, 0xd5ec, 0xd603, 0xd61a, 0xd631, 0xd648,
	0xd65f, 0xd676, 0xd68d, 0xd6a4, 0xd6bb, 0xd6d3, 0xd6eb, 0xd703,
	0xd71b, 0xd733, 0xd74c, 0xd764, 0xd77d, 0xd796, 0xd7ae, 0xd7c6,
	0xd7de, 0xd7f6, 0xd80e, 0xd826, 0xd83e, 0xd856, 0xd86f, 0xd887,
	0xd89f, 0xd8b7, 0xd8d0, 0xd8e8, 0xd900, 0xd918, 0xd930, 0xd948,
	0xd960, 0xd978, 0xd990, 0xd9a8, 0xd9c0, 0xd9d8, 0xd9f0, 0xda08,
	0xda20, 0xda38, 0xda51, 0xda69, 0xda81, 0xda99, 0xdab1, 0xdac9,
	// Entry 5A00 - 5A3F
	0xdae1, 0xdaf9, 0xdb11, 0xdb2a, 0xdb42, 0xdb5a, 0xdb73, 0xdb8b,
	0xdba4, 0xdbbc, 0xdbd4, 0xdbed, 0xdc05, 0xdc1d, 0xdc35, 0xdc4d,
	0xdc65, 0xdc7d, 0xdc95, 0xdcad, 0xdcc5, 0xdcdd, 0xdcf5, 0xdd0d,
	0xdd25, 0xdd3d, 0xdd55, 0xdd6d, 0xdd85, 0xdd9d, 0xddb5, 0xddcd,
	0xdde5, 0xddfd, 0xde15, 0xde2d, 0xde45, 0xde5d, 0xde75, 0xde8d,
	0xdea5, 0xdebd, 0xded6, 0xdeee, 0xdf06, 0xdf1e, 0xdf36, 0xdf4e,
	0xdf66, 0xdf7f, 0xdf98, 0xdfb1, 0xdfc9, 0xdfe1, 0xdff9, 0xe011,
	0xe029, 0xe041, 0xe059, 0xe071, 0xe08a, 0xe0a2, 0xe0ba, 0xe0d2,
	// Entry 5A40 - 5A7F
	0xe0ea, 0xe102, 0xe11a, 0xe132, 0xe14a, 0xe162, 0xe17a, 0xe192,
	0xe1aa, 0xe1c2, 0xe1da, 0xe1f2, 0xe20a, 0xe222, 0xe23a, 0xe252,
	0xe26a, 0xe282, 0xe29a, 0xe2b3, 0xe2cb, 0xe2e3, 0xe2fb, 0xe313,
	0xe32b, 0xe343, 0xe35b, 0xe373, 0xe38b, 0xe3a3, 0xe3bb, 0xe3d3,
	0xe3eb, 0xe403, 0xe41b, 0xe433, 0xe44b, 0xe463, 0xe47b, 0xe494,
	0xe4ac, 0xe4c4, 0xe4dc, 0xe4f4, 0xe50d, 0xe525, 0xe53d, 0xe555,
	0xe56e, 0xe586, 0xe59e, 0xe5b6, 0xe5ce, 0xe5e6, 0xe5fe, 0xe616,
	0xe62e, 0xe646, 0xe65e, 0xe676, 0xe68e, 0xe6a7, 0xe6bf, 0xe6d7,
	// Entry 5A80 - 5ABF
	0xe6f0, 0xe708, 0xe720, 0xe739, 0xe752, 0xe76b, 0xe784, 0xe79d,
	0xe7b6, 0xe7cf, 0xe7e8, 0xe801, 0xe819, 0xe831, 0xe84a, 0xe862,
	0xe87a, 0xe893, 0xe8ab, 0xe8c3, 0xe8db, 0xe8f3, 0xe90b, 0xe923,
	0xe93b, 0xe953, 0xe96b, 0xe983, 0xe99b, 0xe9b3, 0xe9cb, 0xe9e4,
	0xe9fd, 0xea16, 0xea2f, 0xea48, 0xea61, 0xea7a, 0xea93, 0xeaab,
	0xeac3, 0xeadb, 0xeaf3, 0xeb0b, 0xeb23, 0xeb3b, 0xeb53, 0xeb6c,
	0xeb84, 0xeb9d, 0xebb5, 0xebcd, 0xebe5, 0xebfd, 0xec15, 0xec2d,
	0xec45, 0xec5e, 0xec76, 0xec8f, 0xeca7, 0xecbf, 0xecd7, 0xecf0,
	// Entry 5AC0 - 5AFF
	0xed08, 0xed20, 0xed38, 0xed50, 0xed68, 0xed80, 0xed98, 0xedb0,
	0xedc9, 0xede1, 0xedf9, 0xee11, 0xee29, 0xee41, 0xee59, 0xee72,
	0xee8a, 0xeea2, 0xeeba, 0xeed2, 0xeeeb, 0xef03, 0xef1b, 0xef33,
	0xef4b, 0xef63, 0xef7b, 0xef93, 0xefab, 0xefc3, 0xefdb, 0xeff3,
	0xf00b, 0xf024, 0xf03c, 0xf054, 0xf06c, 0xf084, 0xf09c, 0xf0b4,
	0xf0cc, 0xf0e4, 0xf0fd, 0xf115, 0xf12d, 0xf145, 0xf15d, 0xf175,
	0xf18d, 0xf1a5, 0xf1bd, 0xf1d5, 0xf1ed, 0xf206, 0xf21e, 0xf236,
	0xf24e, 0xf266, 0xf27e, 0xf296, 0xf2af, 0xf2c7, 0xf2e0, 0xf2f8,
	// Entry 5B00 - 5B3F
	0xf310, 0xf328, 0xf340, 0xf358, 0xf370, 0xf388, 0xf3a1, 0xf3b9,
	0xf3d2, 0xf3ea, 0xf403, 0xf41b, 0xf433, 0xf44b, 0xf463, 0xf47c,
	0xf495, 0xf4ae, 0xf4c6, 0xf4de, 0xf4f6, 0xf50e, 0xf526, 0xf53e,
	0xf556, 0xf56e, 0xf587, 0xf59f, 0xf5b8, 0xf5d1, 0xf5e9, 0xf601,
	0xf619, 0xf631, 0xf64a, 0xf662, 0xf67a, 0xf692, 0xf6aa, 0xf6c2,
	0xf6da, 0xf6f2, 0xf70a, 0xf722, 0xf73b, 0xf753, 0xf76b, 0xf783,
	0xf79b, 0xf7b3, 0xf7cb, 0xf7e4, 0xf7fc, 0xf814, 0xf82c, 0xf844,
	0xf85c, 0xf874, 0xf88c, 0xf8a4, 0xf8bc, 0xf8d4, 0xf8ed, 0xf905,
	// Entry 5B40 - 5B7F
	0xf91e, 0xf936, 0xf94e, 0xf966, 0xf97e, 0xf996, 0xf9ae, 0xf9c7,
	0xf9df, 0xf9f7, 0xfa10, 0xfa28, 0xfa40, 0xfa58, 0xfa70, 0xfa88,
	0xfaa0, 0xfab8, 0xfad0, 0xfae8, 0xfb00, 0xfb18, 0xfb30, 0xfb48,
	0xfb60, 0xfb78, 0xfb91, 0xfba9, 0xfbc1, 0xfbd9, 0xfbf1, 0xfc09,
	0xfc21, 0xfc39, 0xfc52, 0xfc6a, 0xfc82, 0xfc9a, 0xfcb2, 0xfccb,
	0xfce3, 0xfcfc, 0xfd14, 0xfd2d, 0xfd45, 0xfd5d, 0xfd75, 0xfd8d,
	0xfda5, 0xfdbd, 0xfdd5, 0xfded, 0xfe05, 0xfe1d, 0xfe35, 0xfe4d,
	0xfe65, 0xfe7d, 0xfe96, 0xfeae, 0xfec6, 0xfede, 0xfef6, 0xff0f,
	// Entry 5B80 - 5BBF
	0xff27, 0xff3f, 0xff57, 0xff70, 0xff89, 0xffa1, 0xffb9, 0xffd2,
	0xffea, 0x0002, 0x001a, 0x0032, 0x004a, 0x0062, 0x007a, 0x0093,
	0x00ab, 0x00c3, 0x00dc, 0x00f5, 0x010e, 0x0127, 0x0140, 0x0159,
	0x0172, 0x018b, 0x01a3, 0x01bb, 0x01d3, 0x01ec, 0x0204, 0x021d,
	0x0235, 0x024e, 0x0266, 0x027e, 0x0296, 0x02ae, 0x02c6, 0x02df,
	0x02f7, 0x030f, 0x0328, 0x0340, 0x0358, 0x0370, 0x0388, 0x03a1,
	0x03b9, 0x03d1, 0x03e9, 0x0402, 0x041a, 0x0432, 0x044b, 0x0464,
	0x047c, 0x0494, 0x04ac, 0x04c4, 0x04dc, 0x04f4, 0x050c, 0x0525,
	// Entry 5BC0 - 5BFF
	0x053d, 0x0555, 0x056d, 0x0585, 0x059d, 0x05b5, 0x05cd, 0x05e5,
	0x05fd, 0x0615, 0x062d, 0x0645, 0x065d, 0x0675, 0x068d, 0x06a5,
	0x06bd, 0x06d5, 0x06ed, 0x0705, 0x071d, 0x0735, 0x074e, 0x0767,
	0x077f, 0x0797, 0x07af, 0x07c7, 0x07df, 0x07f7, 0x080f, 0x0828,
	0x0840, 0x0858, 0x0870, 0x0888, 0x08a0, 0x08b8, 0x08d0, 0x08e8,
	0x0901, 0x0919, 0x0932, 0x094a, 0x0963, 0x097b, 0x0993, 0x09ac,
	0x09c4, 0x09dc, 0x09f4, 0x0a0c, 0x0a24, 0x0a3d, 0x0a56, 0x0a6f,
	0x0a88, 0x0aa1, 0x0abb, 0x0ad4, 0x0aed, 0x0b06, 0x0b1f, 0x0b38,
	// Entry 5C00 - 5C3F
	0x0b51, 0x0b6a, 0x0b83, 0x0b9c, 0x0bb5, 0x0bce, 0x0be7, 0x0c01,
	0x0c1a, 0x0c33, 0x0c4c, 0x0c65, 0x0c7e, 0x0c97, 0x0cb0, 0x0cc9,
	0x0ce2, 0x0cfb, 0x0d14, 0x0d2d, 0x0d46, 0x0d60, 0x0d79, 0x0d93,
	0x0dac, 0x0dc5, 0x0dde, 0x0df7, 0x0e10, 0x0e29, 0x0e42, 0x0e5c,
	0x0e75, 0x0e8e, 0x0ea7, 0x0ec0, 0x0eda, 0x0ef2, 0x0f0b, 0x0f23,
	0x0f3b, 0x0f53, 0x0f6b, 0x0f84, 0x0f9c, 0x0fb5, 0x0fce, 0x0fe7,
	0x1000, 0x1019, 0x1032, 0x104a, 0x1062, 0x107a, 0x1092, 0x10ab,
	0x10c4, 0x10dd, 0x10f5, 0x110d, 0x1125, 0x113d, 0x1155, 0x116d,
	// Entry 5C40 - 5C7F
	0x1185, 0x119d, 0x11b5, 0x11ce, 0x11e6, 0x11ff, 0x1217, 0x122f,
	0x1247, 0x125f, 0x1278, 0x1290, 0x12a9, 0x12c1, 0x12d9, 0x12f1,
	0x1309, 0x1322, 0x133a, 0x1353, 0x136b, 0x1383, 0x139b, 0x13b4,
	0x13cc, 0x13e4, 0x13fc, 0x1415, 0x142e, 0x1447, 0x1460, 0x1478,
	0x1490, 0x14a8, 0x14c0, 0x14d8, 0x14f0, 0x1508, 0x1520, 0x1538,
	0x1550, 0x1568, 0x1580, 0x1598, 0x15b0, 0x15c9, 0x15e2, 0x15fa,
	0x1612, 0x162b, 0x1643, 0x165b, 0x1674, 0x168c, 0x16a4, 0x16bc,
	0x16d4, 0x16ec, 0x1704, 0x171c, 0x1734, 0x174c, 0x1764, 0x177c,
	// Entry 5C80 - 5CBF
	0x1794, 0x17ac, 0x17c4, 0x17dc, 0x17f4, 0x180c, 0x1825, 0x183d,
	0x1856, 0x186f, 0x1887, 0x189f, 0x18b7, 0x18cf, 0x18e7, 0x18ff,
	0x1917, 0x1930, 0x1948, 0x1960, 0x1978, 0x1990, 0x19a8, 0x19c0,
	0x19d9, 0x19f1, 0x1a09, 0x1a21, 0x1a39, 0x1a51, 0x1a69, 0x1a81,
	0x1a99, 0x1ab1, 0x1ac9, 0x1ae1, 0x1af9, 0x1b11, 0x1b29, 0x1b41,
	0x1b5a, 0x1b72, 0x1b8a, 0x1ba2, 0x1bba, 0x1bd3, 0x1beb, 0x1c03,
	0x1c1b, 0x1c33, 0x1c4b, 0x1c63, 0x1c7b, 0x1c93, 0x1cac, 0x1cc5,
	0x1cdd, 0x1cf5, 0x1d0d, 0x1d26, 0x1d3e, 0x1d56, 0x1d6e, 0x1d86,
	// Entry 5CC0 - 5CFF
	0x1d9e, 0x1db6, 0x1dce, 0x1de6, 0x1dfe, 0x1e17, 0x1e30, 0x1e48,
	0x1e60, 0x1e78, 0x1e90, 0x1ea8, 0x1ec0, 0x1ed8, 0x1ef0, 0x1f08,
	0x1f21, 0x1f39, 0x1f51, 0x1f69, 0x1f81, 0x1f99, 0x1fb1, 0x1fc9,
	0x1fe1, 0x1ff9, 0x2011, 0x2029, 0x2041, 0x2059, 0x2071, 0x208a,
	0x20a2, 0x20ba, 0x20d2, 0x20ea, 0x2103, 0x211b, 0x2134, 0x214c,
	0x2165, 0x217d, 0x2195, 0x21ae, 0x21c6, 0x21de, 0x21f6, 0x220e,
	0x2226, 0x223f, 0x2257, 0x226f, 0x2287, 0x229f, 0x22b7, 0x22cf,
	0x22e7, 0x22ff, 0x2317, 0x232f, 0x2347, 0x235f, 0x2377, 0x238f,
	// Entry 5D00 - 5D3F
	0x23a7, 0x23bf, 0x23d8, 0x23f0, 0x2409, 0x2421, 0x2439, 0x2451,
	0x2469, 0x2481, 0x2499, 0x24b1, 0x24c9, 0x24e1, 0x24fa, 0x2513,
	0x252b, 0x2543, 0x255b, 0x2573, 0x258b, 0x25a3, 0x25bb, 0x25d3,
	0x25eb, 0x2603, 0x261b, 0x2633, 0x264b, 0x2663, 0x267b, 0x2693,
	0x26ab, 0x26c4, 0x26dc, 0x26f4, 0x270c, 0x2724, 0x273c, 0x2754,
	0x276d, 0x2785, 0x279d, 0x27b5, 0x27ce, 0x27e6, 0x27fe, 0x2816,
	0x282e, 0x2846, 0x285e, 0x2876, 0x288e, 0x28a6, 0x28be, 0x28d6,
	0x28ef, 0x2908, 0x2921, 0x293a, 0x2953, 0x296c, 0x2985, 0x299e,
	// Entry 5D40 - 5D7F
	0x29b7, 0x29cf, 0x29e8, 0x2a00, 0x2a18, 0x2a30, 0x2a48, 0x2a60,
	0x2a79, 0x2a92, 0x2aaa, 0x2ac2, 0x2ada, 0x2af2, 0x2b0b, 0x2b24,
	0x2b3d, 0x2b55, 0x2b6e, 0x2b87, 0x2b9f, 0x2bb7, 0x2bcf, 0x2be7,
	0x2bff, 0x2c17, 0x2c2f, 0x2c47, 0x2c60, 0x2c79, 0x2c92, 0x2cab,
	0x2cc4, 0x2cdd, 0x2cf6, 0x2d0f, 0x2d28, 0x2d41, 0x2d5a, 0x2d73,
	0x2d8b, 0x2da3, 0x2dbb, 0x2dd4, 0x2dec, 0x2e04, 0x2e1c, 0x2e34,
	0x2e4c, 0x2e65, 0x2e7d, 0x2e96, 0x2eae, 0x2ec7, 0x2edf, 0x2ef8,
	0x2f10, 0x2f28, 0x2f41, 0x2f59, 0x2f71, 0x2f89, 0x2fa1, 0x2fba,
	// Entry 5D80 - 5DBF
	0x2fd2, 0x2fea, 0x3002, 0x301b, 0x3033, 0x304b, 0x3063, 0x307c,
	0x3094, 0x30ac, 0x30c4, 0x30dc, 0x30f4, 0x310c, 0x3125, 0x313d,
	0x3156, 0x316e, 0x3186, 0x319e, 0x31b6, 0x31cf, 0x31e7, 0x31ff,
	0x3217, 0x3230, 0x3248, 0x3261, 0x3279, 0x3291, 0x32a9, 0x32c1,
	0x32d9, 0x32f1, 0x330a, 0x3322, 0x333a, 0x3352, 0x336a, 0x3382,
	0x339b, 0x33b4, 0x33cc, 0x33e4, 0x33fd, 0x3415, 0x342d, 0x3446,
	0x345e, 0x3477, 0x348f, 0x34a7, 0x34bf, 0x34d7, 0x34ef, 0x3507,
	0x351f, 0x3537, 0x354f, 0x3568, 0x3581, 0x359a, 0x35b3, 0x35cb,
	// Entry 5DC0 - 5DFF
	0x35e4, 0x35fd, 0x3615, 0x362e, 0x3646, 0x365f, 0x3677, 0x368f,
	0x36a7, 0x36bf, 0x36d7, 0x36ef, 0x3707, 0x371f, 0x3737, 0x374f,
	0x3768, 0x3781, 0x379a, 0x37b3, 0x37cc, 0x37e5, 0x37fe, 0x3817,
	0x3830, 0x3848, 0x3861, 0x387a, 0x3893, 0x38ac, 0x38c5, 0x38de,
	0x38f7, 0x3910, 0x3929, 0x3942, 0x395b, 0x3974, 0x398d, 0x39a6,
	0x39bf, 0x39d9, 0x39f3, 0x3a0c, 0x3a25, 0x3a3e, 0x3a57, 0x3a70,
	0x3a89, 0x3aa2, 0x3abb, 0x3ad4, 0x3aed, 0x3b06, 0x3b1f, 0x3b38,
	0x3b51, 0x3b6a, 0x3b83, 0x3b9c, 0x3bb5, 0x3bce, 0x3be7, 0x3c00,
	// Entry 5E00 - 5E3F
	0x3c19, 0x3c32, 0x3c4b, 0x3c64, 0x3c7d, 0x3ca0, 0x3cc5, 0x3cec,
	0x3d16, 0x3d3b, 0x3d63, 0x3d85, 0x3da6, 0x3dc5, 0x3de9, 0x3e0a,
	0x3e2e, 0x3e51, 0x3e72, 0x3e9c, 0x3ec4, 0x3eeb, 0x3f09, 0x3f27,
	0x3f44, 0x3f66, 0x3f88, 0x3faa, 0x3fdb, 0x400f, 0x403c, 0x406b,
	0x4096, 0x40d6, 0x410b, 0x413d, 0x417d, 0x41ab, 0x41e3, 0x420e,
	0x4241, 0x4277, 0x429b, 0x42b4, 0x42cd, 0x42e6, 0x42ff, 0x4318,
	0x4331, 0x434a, 0x4363, 0x437c, 0x4395, 0x43af, 0x43c8, 0x43e1,
	0x43fa, 0x4413, 0x442c, 0x4445, 0x445e, 0x4477, 0x4490, 0x44a9,
	// Entry 5E40 - 5E7F
	0x44c2, 0x44db, 0x44f4, 0x450d, 0x4526, 0x453f, 0x4559, 0x4572,
	0x458b, 0x45a4, 0x45bd, 0x45d6, 0x45ef, 0x4608, 0x4621, 0x463a,
	0x4653, 0x466c, 0x4685, 0x469e, 0x46b8, 0x46d1, 0x46ea, 0x4704,
	0x471d, 0x4736, 0x474f, 0x4768, 0x4782, 0x479b, 0x47b5, 0x47cf,
	0x47e8, 0x4801, 0x481a, 0x4833, 0x484c, 0x4865, 0x487e, 0x4897,
	0x48b0, 0x48c9, 0x48e2, 0x48fb, 0x4914, 0x492d, 0x4946, 0x495f,
	0x4978, 0x4991, 0x49aa, 0x49c3, 0x49dd, 0x49f7, 0x4a11, 0x4a2a,
	0x4a43, 0x4a5c, 0x4a75, 0x4a8e, 0x4aa7, 0x4ac0, 0x4ad9, 0x4af2,
	// Entry 5E80 - 5EBF
	0x4b0b, 0x4b24, 0x4b3d, 0x4b56, 0x4b6f, 0x4b88, 0x4ba1, 0x4bba,
	0x4bd3, 0x4bec, 0x4c05, 0x4c1e, 0x4c37, 0x4c50, 0x4c69, 0x4c82,
	0x4c9b, 0x4cb4, 0x4ccd, 0x4ce6, 0x4cff, 0x4d18, 0x4d32, 0x4d4b,
	0x4d65, 0x4d7e, 0x4d97, 0x4db1, 0x4dca, 0x4de4, 0x4dfd, 0x4e17,
	0x4e30, 0x4e49, 0x4e63, 0x4e7d, 0x4e97, 0x4eb0, 0x4eca, 0x4ee4,
	0x4efd, 0x4f16, 0x4f30, 0x4f4a, 0x4f64, 0x4f7d, 0x4f96, 0x4faf,
	0x4fc9, 0x4fe3, 0x4ffc, 0x5015, 0x502e, 0x5047, 0x5060, 0x507a,
	0x5093, 0x50ac, 0x50c5, 0x50de, 0x50f7, 0x5110, 0x5129, 0x5142,
	// Entry 5EC0 - 5EFF
	0x515b, 0x5174, 0x518e, 0x51a7, 0x51c0, 0x51d9, 0x51f2, 0x520b,
	0x5224, 0x523d, 0x5256, 0x526f, 0x5288, 0x52a2, 0x52bb, 0x52d4,
	0x52ed, 0x5306, 0x531f, 0x5338, 0x5351, 0x536a, 0x5383, 0x539c,
	0x53b5, 0x53ce, 0x53e7, 0x5400, 0x5419, 0x5432, 0x544b, 0x5464,
	0x547d, 0x5496, 0x54af, 0x54c8, 0x54e1, 0x54fa, 0x5513, 0x552c,
	0x5545, 0x555e, 0x5577, 0x5590, 0x55a9, 0x55c2, 0x55db, 0x55f4,
	0x560d, 0x5626, 0x563f, 0x5658, 0x5671, 0x568a, 0x56a3, 0x56bc,
	0x56d5, 0x56ee, 0x5707, 0x5720, 0x5739, 0x5752, 0x576b, 0x5784,
	// Entry 5F00 - 5F3F
	0x579d, 0x57b6, 0x57cf, 0x57e8, 0x5801, 0x581a, 0x5833, 0x584c,
	0x5865, 0x587e, 0x5897, 0x58b0, 0x58c9, 0x58e2, 0x58fb, 0x5914,
	0x592d, 0x5947, 0x5961, 0x597a, 0x5993, 0x59ac, 0x59c5, 0x59de,
	0x59f8, 0x5a11, 0x5a2a, 0x5a44, 0x5a5d, 0x5a76, 0x5a8f, 0x5aa8,
	0x5ac1, 0x5ada, 0x5af4, 0x5b0d, 0x5b27, 0x5b40, 0x5b59, 0x5b72,
	0x5b8b, 0x5ba4, 0x5bbd, 0x5bd6, 0x5bef, 0x5c08, 0x5c21, 0x5c3a,
	0x5c54, 0x5c6d, 0x5c86, 0x5c9f, 0x5cb8, 0x5cd1, 0x5cea, 0x5d03,
	0x5d1c, 0x5d35, 0x5d4e, 0x5d67, 0x5d80, 0x5d99, 0x5db2, 0x5dcb,
	// Entry 5F40 - 5F7F
	0x5de4, 0x5dfd, 0x5e16, 0x5e2f, 0x5e48, 0x5e61, 0x5e7a, 0x5e93,
	0x5eac, 0x5ec5, 0x5ede, 0x5ef7, 0x5f10, 0x5f29, 0x5f42, 0x5f5b,
	0x5f74, 0x5f8d, 0x5fa6, 0x5fbf, 0x5fd8, 0x5ff1, 0x600a, 0x6023,
	0x603c, 0x6056, 0x606f, 0x6088, 0x60a1, 0x60ba, 0x60d3, 0x60ec,
	0x6105, 0x611e, 0x6137, 0x6150, 0x6169, 0x6182, 0x619b, 0x61b4,
	0x61cd, 0x61e6, 0x61ff, 0x6218, 0x6231, 0x624a, 0x6263, 0x627c,
	0x6296, 0x62af, 0x62c8, 0x62e1, 0x62fa, 0x6313, 0x632d, 0x6346,
	0x635f, 0x6378, 0x6391, 0x63aa, 0x63c4, 0x63dd, 0x63f6, 0x640f,
	// Entry 5F80 - 5FBF
	0x6428, 0x6441, 0x645a, 0x6473, 0x648c, 0x64a5, 0x64be, 0x64d8,
	0x64f1, 0x650a, 0x6523, 0x653c, 0x6555, 0x656e, 0x6587, 0x65a0,
	0x65b9, 0x65d2, 0x65eb, 0x6604, 0x661d, 0x6636, 0x664f, 0x6668,
	0x6681, 0x669a, 0x66b3, 0x66cc, 0x66e6, 0x66ff, 0x6718, 0x6732,
	0x674c, 0x6766, 0x677f, 0x6798, 0x67b1, 0x67ca, 0x67e4, 0x67fe,
	0x6818, 0x6831, 0x684a, 0x6863, 0x687c, 0x6895, 0x68ae, 0x68c7,
	0x68e0, 0x68f9, 0x6912, 0x692b, 0x6944, 0x695d, 0x6976, 0x698f,
	0x69a8, 0x69c1, 0x69da, 0x69f3, 0x6a0c, 0x6a25, 0x6a3e, 0x6a57,
	// Entry 5FC0 - 5FFF
	0x6a71, 0x6a8a, 0x6aa3, 0x6abc, 0x6ad5, 0x6aee, 0x6b08, 0x6b21,
	0x6b3a, 0x6b53, 0x6b6c, 0x6b86, 0x6b9f, 0x6bb8, 0x6bd1, 0x6beb,
	0x6c04, 0x6c1d, 0x6c36, 0x6c4f, 0x6c68, 0x6c81, 0x6c9a, 0x6cb3,
	0x6ccc, 0x6ce5, 0x6cff, 0x6d18, 0x6d3a, 0x6d54, 0x6d6d, 0x6d86,
	0x6d9f, 0x6db9, 0x6dd2, 0x6deb, 0x6e04, 0x6e1d, 0x6e36, 0x6e4f,
	0x6e6e, 0x6e87, 0x6ea0, 0x6eb9, 0x6ed2, 0x6eeb, 0x6f04, 0x6f1d,
	0x6f36, 0x6f4f, 0x6f68, 0x6f81, 0x6f9a, 0x6fb3, 0x6fcc, 0x6fe5,
	0x6ffe, 0x702b, 0x7057, 0x7070, 0x7089, 0x70a2, 0x70bb, 0x70d4,
	// Entry 6000 - 603F
	0x70ed, 0x7106, 0x711f, 0x7138, 0x7151, 0x716a, 0x7183, 0x719c,
	0x71b5, 0x71ce, 0x71e7, 0x7200, 0x7219, 0x7232, 0x724b, 0x7264,
	0x727d, 0x7296, 0x72af, 0x72c8, 0x72e1, 0x72fa, 0x7313, 0x732c,
	0x7345, 0x735e, 0x7377, 0x7390, 0x73a9, 0x73c2, 0x73db, 0x73f4,
	0x740d, 0x7426, 0x743f, 0x7459, 0x7472, 0x748b, 0x74a4, 0x74bd,
	0x74d6, 0x74ef, 0x7508, 0x7522, 0x753b, 0x7554, 0x756d, 0x7586,
	0x759f, 0x75b8, 0x75d1, 0x75ea, 0x7603, 0x761c, 0x7635, 0x764e,
	0x7667, 0x7680, 0x7699, 0x76b2, 0x76cb, 0x76e4, 0x76fd, 0x7716,
	// Entry 6040 - 607F
	0x772f, 0x7748, 0x7761, 0x777a, 0x7793, 0x77ac, 0x77c5, 0x77de,
	0x77f7, 0x7810, 0x7829, 0x7842, 0x785b, 0x7874, 0x788d, 0x78a6,
	0x78bf, 0x78d8, 0x78f1, 0x790a, 0x7923, 0x793c, 0x7955, 0x796e,
	0x7987, 0x79a0, 0x79b9, 0x79d2, 0x79eb, 0x7a04, 0x7a1d, 0x7a36,
	0x7a4f, 0x7a68, 0x7a81, 0x7a9a, 0x7ab3, 0x7acc, 0x7ae5, 0x7afe,
	0x7b17, 0x7b30, 0x7b49, 0x7b62, 0x7b7b, 0x7b94, 0x7bad, 0x7bc6,
	0x7bdf, 0x7bf8, 0x7c17, 0x7c35, 0x7c5e, 0x7c84, 0x7ca1, 0x7cc0,
	0x7cde, 0x7cfb, 0x7d1d, 0x7d48, 0x7d70, 0x7d8f, 0x7dad, 0x7dc8,
	// Entry 6080 - 60BF
	0x7de5, 0x7e01, 0x7e20, 0x7e3c, 0x7e58, 0x7e77, 0x7e92, 0x7eaa,
	0x7ec9, 0x7ee3, 0x7eff, 0x7f1d, 0x7f39, 0x7f54, 0x7f72, 0x7f8e,
	0x7faf, 0x7fcd, 0x7feb, 0x800c, 0x802a, 0x8043, 0x805e, 0x807f,
	0x809b, 0x80b4, 0x80d4, 0x80f5, 0x810d, 0x812a, 0x8143, 0x815b,
	0x8175, 0x818f, 0x81aa, 0x81c8, 0x81e3, 0x81fb, 0x821c, 0x8235,
	0x8251, 0x826a, 0x8285, 0x829e, 0x82b6, 0x82cf, 0x82e7, 0x8305,
	0x8320, 0x8339, 0x835c, 0x8380, 0x839b, 0x83b7, 0x83d3, 0x83ed,
	0x8407, 0x8420, 0x843b, 0x8454, 0x846f, 0x8487, 0x84a0, 0x84bb,
	// Entry 60C0 - 60FF
	0x84d4, 0x84ec, 0x8504, 0x851d, 0x8535, 0x854c, 0x8564, 0x857c,
	0x8595, 0x85b0, 0x85d1, 0x85ea, 0x8605, 0x8623, 0x8642, 0x865c,
	0x8677, 0x8693, 0x86ab, 0x86c6, 0x86e8, 0x870b, 0x872c, 0x8749,
	0x8769, 0x8781, 0x879e, 0x87bc, 0x87da, 0x87fa, 0x881b, 0x8839,
	0x8854, 0x8871, 0x888d, 0x88a8, 0x88c2, 0x88db, 0x88fc, 0x891a,
	0x8934, 0x8950, 0x8969, 0x8982, 0x899d, 0x89be, 0x89d9, 0x89f1,
	0x8a0c, 0x8a29, 0x8a45, 0x8a61, 0x8a81, 0x8a9a, 0x8ab4, 0x8acc,
	0x8ae7, 0x8b07, 0x8b24, 0x8b3c, 0x8b57, 0x8b70, 0x8b87, 0x8b9f,
	// Entry 6100 - 613F
	0x8bb8, 0x8bd9, 0x8bf1, 0x8c09, 0x8c26, 0x8c40, 0x8c5e, 0x8c78,
	0x8c93, 0x8cb0, 0x8cca, 0x8cf0, 0x8d0d, 0x8d27, 0x8d43, 0x8d5e,
	0x8d84, 0x8da3, 0x8dbc, 0x8dd7, 0x8df5, 0x8e0f, 0x8e28, 0x8e44,
	0x8e5d, 0x8e76, 0x8e91, 0x8ea9, 0x8ec2, 0x8edc, 0x8ef8, 0x8f12,
	0x8f2f, 0x8f49, 0x8f6a, 0x8f83, 0x8fa0, 0x8fbf, 0x8fd8, 0x8ff3,
	0x900b, 0x9028, 0x9044, 0x9061, 0x907d, 0x9097, 0x90af, 0x90c9,
	0x90e1, 0x90fb, 0x9114, 0x9131, 0x914c, 0x9163, 0x917d, 0x9195,
	0x91b1, 0x91d0, 0x91eb, 0x9203, 0x921c, 0x9236, 0x9251, 0x9268,
	// Entry 6140 - 617F
	0x9280, 0x9299, 0x92b2, 0x92ca, 0x92e6, 0x92ff, 0x9318, 0x9339,
	0x9352, 0x936b, 0x9388, 0x93a0, 0x93b9, 0x93d3, 0x93ee, 0x9406,
	0x9421, 0x943c, 0x9458, 0x9472, 0x948b, 0x94ab, 0x94c5, 0x94df,
	0x94f8, 0x9511, 0x952a, 0x9546, 0x9566, 0x957f, 0x9597, 0x95af,
	0x95c7, 0x95df, 0x95f7, 0x9610, 0x9628, 0x9640, 0x9659, 0x9673,
	0x968c, 0x96a6, 0x96c0, 0x96dd, 0x96f6, 0x9710, 0x972a, 0x9743,
	0x975d, 0x977c, 0x9795, 0x97b0, 0x97c9, 0x97e1, 0x97f9, 0x9815,
	0x982e, 0x9846, 0x9860, 0x987a, 0x9896, 0x98af, 0x98ca, 0x98e2,
	// Entry 6180 - 61BF
	0x98fe, 0x991e, 0x993a, 0x9951, 0x996a, 0x9985, 0x99a3, 0x99bc,
	0x99d8, 0x99f3, 0x9a0c, 0x9a25, 0x9a40, 0x9a59, 0x9a74, 0x9a8c,
	0x9aa4, 0x9abf, 0x9ad8, 0x9af2, 0x9b0b, 0x9b26, 0x9b3e, 0x9b58,
	0x9b71, 0x9b8a, 0x9ba4, 0x9bc1, 0x9bdc, 0x9bf7, 0x9c10, 0x9c28,
	0x9c43, 0x9c5c, 0x9c74, 0x9c8f, 0x9ca9, 0x9cc5, 0x9cde, 0x9cf6,
	0x9d0f, 0x9d28, 0x9d42, 0x9d5b, 0x9d73, 0x9d8e, 0x9da9, 0x9dc2,
	0x9ddb, 0x9df3, 0x9e0c, 0x9e25, 0x9e41, 0x9e5b, 0x9e74, 0x9e8f,
	0x9ea9, 0x9ec3, 0x9ede, 0x9ef5, 0x9f11, 0x9f29, 0x9f41, 0x9f59,
	// Entry 61C0 - 61FF
	0x9f71, 0x9f8b, 0x9fa5, 0x9fbb, 0x9fd3, 0x9fea, 0xa003, 0xa01d,
	0xa036, 0xa04d, 0xa065, 0xa07e, 0xa096, 0xa0ad, 0xa0c6, 0xa0de,
	0xa0f7, 0xa10f, 0xa12c, 0xa143, 0xa15c, 0xa17b, 0xa193, 0xa1ab,
	0xa1c4, 0xa1dd, 0xa1f7, 0xa20f, 0xa227, 0xa240, 0xa258, 0xa270,
	0xa288, 0xa2a3, 0xa2bc, 0xa2d5, 0xa2ed, 0xa306, 0xa320, 0xa338,
	0xa350, 0xa36d, 0xa386, 0xa39e, 0xa3b7, 0xa3cf, 0xa3ea, 0xa403,
	0xa41c, 0xa437, 0xa450, 0xa46a, 0xa485, 0xa49f, 0xa4b8, 0xa4d0,
	0xa4ec, 0xa505, 0xa51f, 0xa53c, 0xa558, 0xa570, 0xa589, 0xa5a5,
	// Entry 6200 - 623F
	0xa5be, 0xa5dd, 0xa5f5, 0xa60d, 0xa62f, 0xa653, 0xa66c, 0xa686,
	0xa69f, 0xa6b9, 0xa6d0, 0xa6ea, 0xa704, 0xa71e, 0xa739, 0xa753,
	0xa76c, 0xa785, 0xa79c, 0xa7b5, 0xa7d1, 0xa7ee, 0xa80a, 0xa824,
	0xa83d, 0xa856, 0xa86f, 0xa888, 0xa8a0, 0xa8b9, 0xa8d1, 0xa8f1,
	0xa909, 0xa923, 0xa93d, 0xa957, 0xa970, 0xa98b, 0xa9a3, 0xa9bd,
	0xa9d7, 0xa9ef, 0xaa07, 0xaa23, 0xaa3c, 0xaa53, 0xaa6c, 0xaa85,
	0xaa9e, 0xaaba, 0xaada, 0xaaf3, 0xab0c, 0xab25, 0xab3e, 0xab56,
	0xab6f, 0xab8a, 0xaba3, 0xabbb, 0xabd4, 0xabee, 0xac06, 0xac1f,
	// Entry 6240 - 627F
	0xac38, 0xac53, 0xac6d, 0xac8b, 0xaca7, 0xacbf, 0xacd8, 0xacee,
	0xad06, 0xad1c, 0xad32, 0xad4a, 0xad68, 0xad80, 0xad98, 0xadba,
	0xadd3, 0xadec, 0xae06, 0xae20, 0xae41, 0xae5f, 0xae77, 0xae8f,
	0xaea8, 0xaec1, 0xaee0, 0xaef8, 0xaf10, 0xaf28, 0xaf40, 0xaf57,
	0xaf6e, 0xaf87, 0xaf9f, 0xafba, 0xafd2, 0xafea, 0xb003, 0xb021,
	0xb038, 0xb04f, 0xb067, 0xb07e, 0xb096, 0xb0ad, 0xb0c5, 0xb0dd,
	0xb0f4, 0xb10c, 0xb124, 0xb13c, 0xb155, 0xb16c, 0xb182, 0xb199,
	0xb1b0, 0xb1c8, 0xb1e0, 0xb1f8, 0xb20f, 0xb227, 0xb240, 0xb25a,
	// Entry 6280 - 62BF
	0xb272, 0xb28b, 0xb2a5, 0xb2bb, 0xb2d3, 0xb2ec, 0xb303, 0xb31c,
	0xb335, 0xb34d, 0xb366, 0xb37d, 0xb397, 0xb3af, 0xb3c7, 0xb3de,
	0xb3f7, 0xb410, 0xb429, 0xb441, 0xb459, 0xb470, 0xb487, 0xb4a0,
	0xb4b8, 0xb4d4, 0xb4ed, 0xb505, 0xb51e, 0xb536, 0xb54d, 0xb564,
	0xb57c, 0xb593, 0xb5ac, 0xb5c4, 0xb5db, 0xb5f2, 0xb60b, 0xb623,
	0xb63b, 0xb655, 0xb66e, 0xb67b, 0xb689, 0xb696, 0xb6a4, 0xb6b1,
	0xb6be, 0xb6ca, 0xb6d8, 0xb6e7, 0xb6f5, 0xb703, 0xb711, 0xb721,
	0xb72e, 0xb73d, 0xb74b, 0xb758, 0xb765, 0xb771, 0xb77e, 0xb78c,
	// Entry 62C0 - 62FF
	0xb79b, 0xb7a8, 0xb7b5, 0xb7c1, 0xb7ce, 0xb7dc, 0xb7e9, 0xb7f7,
	0xb804, 0xb812, 0xb820, 0xb82d, 0xb83a, 0xb849, 0xb857, 0xb865,
	0xb872, 0xb881, 0xb890, 0xb89e, 0xb8a7, 0xb8b7, 0xb8c7, 0xb8d7,
	0xb8e7, 0xb8f7, 0xb907, 0xb917, 0xb927, 0xb937, 0xb947, 0xb957,
	0xb967, 0xb977, 0xb987, 0xb997, 0xb9a7, 0xb9b7, 0xb9c7, 0xb9d7,
	0xb9e7, 0xb9f7, 0xba07, 0xba17, 0xba27, 0xba37, 0xba48, 0xba59,
	0xba6a, 0xba7b, 0xba8c, 0xba9d, 0xbaae, 0xbabf, 0xbad5, 0xbaeb,
	0xbb02, 0xbb19, 0xbb2a, 0xbb3b, 0xbb4c, 0xbb5d, 0xbb6f, 0xbb81,
	// Entry 6300 - 633F
	0xbb93, 0xbba5, 0xbbb5, 0xbbc5, 0xbbd5, 0xbbe5, 0xbbf5, 0xbc06,
	0xbc16, 0xbc27, 0xbc37, 0xbc47, 0xbc57, 0xbc67, 0xbc78, 0xbc89,
	0xbc99, 0xbca9, 0xbcb9, 0xbcc9, 0xbcd9, 0xbcea, 0xbcfa, 0xbd0a,
	0xbd1a, 0xbd2b, 0xbd3c, 0xbd4c, 0xbd5d, 0xbd6e, 0xbd80, 0xbd91,
	0xbda1, 0xbdb1, 0xbdc2, 0xbdd3, 0xbde3, 0xbdf4, 0xbe04, 0xbe14,
	0xbe26, 0xbe37, 0xbe48, 0xbe58, 0xbe6a, 0xbe7c, 0xbe8d, 0xbea2,
	0xbeb5, 0xbec8, 0xbedb, 0xbeef, 0xbf03, 0xbf17, 0xbf2c, 0xbf41,
	0xbf54, 0xbf69, 0xbf7c, 0xbf8f, 0xbfa3, 0xbfb6, 0xbfc9, 0xbfdd,
	// Entry 6340 - 637F
	0xbff0, 0xc003, 0xc016, 0xc02b, 0xc03e, 0xc054, 0xc066, 0xc078,
	0xc08b, 0xc09d, 0xc0b0, 0xc0c2, 0xc0d4, 0xc0f1, 0xc10d, 0xc129,
	0xc149, 0xc16a, 0xc17d, 0xc194, 0xc1ab, 0xc1c1, 0xc1d7, 0xc1ee,
	0xc205, 0xc21b, 0xc231, 0xc247, 0xc25d, 0xc274, 0xc28b, 0xc2a2,
	0xc2b9, 0xc2d0, 0xc2e7, 0xc2fe, 0xc315, 0xc32b, 0xc341, 0xc358,
	0xc36f, 0xc385, 0xc39b, 0xc3b1, 0xc3c7, 0xc3de, 0xc3f5, 0xc40f,
	0xc42b, 0xc445, 0xc45f, 0xc47a, 0xc494, 0xc4af, 0xc4ca, 0xc4e4,
	0xc4ff, 0xc519, 0xc534, 0xc550, 0xc56b, 0xc587, 0xc5a3, 0xc5bd,
	// Entry 6380 - 63BF
	0xc5d6, 0xc5f0, 0xc60a, 0xc623, 0xc63b, 0xc654, 0xc66e, 0xc688,
	0xc6a1, 0xc6bb, 0xc6d5, 0xc6f5, 0xc710, 0xc72b, 0xc745, 0xc762,
	0xc77d, 0xc798, 0xc7b4, 0xc7ce, 0xc7e9, 0xc803, 0xc81b, 0xc831,
	0xc84f, 0xc866, 0xc87c, 0xc892, 0xc8aa, 0xc8c1, 0xc8d8, 0xc8ee,
	0xc906, 0xc91e, 0xc935, 0xc94d, 0xc969, 0xc98a, 0xc9a6, 0xc9ca,
	0xc9ea, 0xca07, 0xca20, 0xca36, 0xca4b, 0xca6c, 0xca86, 0xca9c,
	0xcab2, 0xcac8, 0xcade, 0xcaf2, 0xcb0f, 0xcb2b, 0xcb40, 0xcb55,
	0xcb6a, 0xcb92, 0xcbb3, 0xcbcd, 0xcbec, 0xcc0a, 0xcc28, 0xcc45,
	// Entry 63C0 - 63FF
	0xcc60, 0xcc7a, 0xcc95, 0xccb1, 0xcccb, 0xcce6, 0xcd01, 0xcd1c,
	0xcd37, 0xcd52, 0xcd6d, 0xcd87, 0xcda1, 0xcdbb, 0xcdd5, 0xcdf0,
	0xce0a, 0xce24, 0xce40, 0xce5c, 0xce78, 0xce94, 0xceb3, 0xcecf,
	0xceec, 0xcf08, 0xcf24, 0xcf40, 0xcf5c, 0xcf78, 0xcf94, 0xcfb0,
	0xcfcc, 0xcfe8, 0xd004, 0xd020, 0xd03c, 0xd059, 0xd075, 0xd091,
	0xd0ae, 0xd0cb, 0xd0e7, 0xd103, 0xd120, 0xd13c, 0xd158, 0xd174,
	0xd191, 0xd1ad, 0xd1c7, 0xd1e1, 0xd1fb, 0xd215, 0xd232, 0xd24c,
	0xd267, 0xd281, 0xd29b, 0xd2b5, 0xd2cf, 0xd2e9, 0xd303, 0xd31d,
	// Entry 6400 - 643F
	0xd337, 0xd351, 0xd36b, 0xd385, 0xd39f, 0xd3ba, 0xd3d4, 0xd3ee,
	0xd409, 0xd424, 0xd43e, 0xd458, 0xd473, 0xd48d, 0xd4a7, 0xd4c1,
	0xd4dc, 0xd4f6, 0xd50c, 0xd521, 0xd536, 0xd54d, 0xd563, 0xd579,
	0xd58e, 0xd5a5, 0xd5bc, 0xd5d2, 0xd5e8, 0xd601, 0xd61a, 0xd635,
	0xd650, 0xd66a, 0xd684, 0xd6a0, 0xd6bb, 0xd6d6, 0xd6fa, 0xd71e,
	0xd744, 0xd755, 0xd76a, 0xd781, 0xd79b, 0xd7a9, 0xd7b7, 0xd7c8,
	0xd7d7, 0xd7e5, 0xd7f4, 0xd80a, 0xd818, 0xd826, 0xd835, 0xd843,
	0xd851, 0xd863, 0xd874, 0xd883, 0xd892, 0xd8a0, 0xd8af, 0xd8c1,
	// Entry 6440 - 647F
	0xd8d7, 0xd8e6, 0xd8f6, 0xd904, 0xd913, 0xd922, 0xd932, 0xd942,
	0xd952, 0xd963, 0xd974, 0xd982, 0xd990, 0xd9a1, 0xd9af, 0xd9be,
	0xd9cd, 0xd9dd, 0xd9f4, 0xda02, 0xda10, 0xda1f, 0xda2f, 0xda3f,
	0xda4f, 0xda5e, 0xda6e, 0xda7e, 0xda8e, 0xdaa1, 0xdab4, 0xdacd,
	0xdadc, 0xdaeb, 0xdafa, 0xdb0a, 0xdb19, 0xdb28, 0xdb3a, 0xdb48,
	0xdb56, 0xdb65, 0xdb74, 0xdb84, 0xdb9b, 0xdbab, 0xdbbc, 0xdbca,
	0xdbd8, 0xdbe7, 0xdbf6, 0xdc05, 0xdc15, 0xdc23, 0xdc32, 0xdc41,
	0xdc61, 0xdc79, 0xdc8d, 0xdca7, 0xdcc4, 0xdcd5, 0xdce7, 0xdcfa,
	// Entry 6480 - 64BF
	0xdd0c, 0xdd1f, 0xdd30, 0xdd42, 0xdd54, 0xdd65, 0xdd76, 0xdd88,
	0xdd9b, 0xddae, 0xddbf, 0xddd1, 0xdde4, 0xddf8, 0xde0a, 0xde1c,
	0xde2e, 0xde40, 0xde53, 0xde64, 0xde76, 0xde89, 0xde9d, 0xdeaf,
	0xdec2, 0xded5, 0xdee6, 0xdef8, 0xdf0a, 0xdf1d, 0xdf30, 0xdf4b,
	0xdf5d, 0xdf77, 0xdf89, 0xdf9b, 0xdfad, 0xdfbf, 0xdfd0, 0xdfe2,
	0xdff5, 0xe008, 0xe01a, 0xe02d, 0xe03f, 0xe051, 0xe063, 0xe077,
	0xe089, 0xe098, 0xe0ab, 0xe0ba, 0xe0c9, 0xe0db, 0xe0ed, 0xe0ff,
	0xe111, 0xe123, 0xe135, 0xe147, 0xe162, 0xe17d, 0xe198, 0xe1b3,
	// Entry 64C0 - 64FF
	0xe1ce, 0xe1e9, 0xe1fe, 0xe212, 0xe227, 0xe241, 0xe25b, 0xe27f,
	0xe2a5, 0xe2b9, 0xe2cd, 0xe2e1, 0xe2f5, 0xe309, 0xe31d, 0xe331,
	0xe345, 0xe359, 0xe36d, 0xe381, 0xe395, 0xe3a9, 0xe3bd, 0xe3d1,
	0xe3e5, 0xe3f9, 0xe40d, 0xe421, 0xe435, 0xe449, 0xe45d, 0xe471,
	0xe485, 0xe499, 0xe4ad, 0xe4c1, 0xe4d5, 0xe4e9, 0xe4fd, 0xe511,
	0xe525, 0xe539, 0xe54d, 0xe561, 0xe575, 0xe589, 0xe59d, 0xe5b1,
	0xe5c5, 0xe5d9, 0xe5ed, 0xe601, 0xe615, 0xe629, 0xe63d, 0xe651,
	0xe665, 0xe679, 0xe68d, 0xe6a1, 0xe6b5, 0xe6c9, 0xe6dd, 0xe6f1,
	// Entry 6500 - 653F
	0xe705, 0xe719, 0xe72d, 0xe741, 0xe755, 0xe769, 0xe77d, 0xe791,
	0xe7a5, 0xe7b9, 0xe7cd, 0xe7e1, 0xe7f5, 0xe809, 0xe81d, 0xe831,
	0xe845, 0xe859, 0xe86d, 0xe881, 0xe895, 0xe8a9, 0xe8bd, 0xe8d1,
	0xe8e5, 0xe8f9, 0xe90d, 0xe921, 0xe935, 0xe949, 0xe95d, 0xe971,
	0xe985, 0xe999, 0xe9ad, 0xe9c1, 0xe9d5, 0xe9e9, 0xe9fd, 0xea11,
	0xea25, 0xea39, 0xea4d, 0xea61, 0xea75, 0xea89, 0xea9d, 0xeab1,
	0xeac5, 0xead9, 0xeaed, 0xeb01, 0xeb15, 0xeb29, 0xeb3d, 0xeb51,
	0xeb65, 0xeb79, 0xeb8d, 0xeba1, 0xebb5, 0xebc9, 0xebdd, 0xebf1,
	// Entry 6540 - 657F
	0xec05, 0xec19, 0xec2d, 0xec41, 0xec55, 0xec69, 0xec7d, 0xec91,
	0xeca5, 0xecb9, 0xeccd, 0xece1, 0xecf5, 0xed09, 0xed1d, 0xed31,
	0xed45, 0xed59, 0xed6d, 0xed81, 0xed95, 0xeda9, 0xedbd, 0xedd1,
	0xede5, 0xedf9, 0xee0d, 0xee21, 0xee35, 0xee49, 0xee5d, 0xee71,
	0xee85, 0xee99, 0xeead, 0xeec1, 0xeed5, 0xeee9, 0xeefd, 0xef11,
	0xef25, 0xef39, 0xef4d, 0xef61, 0xef75, 0xef89, 0xef9d, 0xefb1,
	0xefc5, 0xefd9, 0xefed, 0xf001, 0xf015, 0xf029, 0xf03d, 0xf051,
	0xf065, 0xf079, 0xf08d, 0xf0a1, 0xf0b5, 0xf0c9, 0xf0dd, 0xf0f1,
	// Entry 6580 - 65BF
	0xf105, 0xf119, 0xf12d, 0xf141, 0xf155, 0xf169, 0xf17d, 0xf191,
	0xf1a5, 0xf1b9, 0xf1cd, 0xf1e1, 0xf1f5, 0xf209, 0xf21d, 0xf231,
	0xf245, 0xf259, 0xf26d, 0xf281, 0xf295, 0xf2a9, 0xf2bd, 0xf2d1,
	0xf2e5, 0xf2f9, 0xf30d, 0xf321, 0xf335, 0xf349, 0xf35d, 0xf371,
	0xf385, 0xf399, 0xf3ad, 0xf3c1, 0xf3d5, 0xf3e9, 0xf3fd, 0xf411,
	0xf425, 0xf439, 0xf44d, 0xf461, 0xf475, 0xf489, 0xf49d, 0xf4b1,
	0xf4c5, 0xf4d9, 0xf4ed, 0xf501, 0xf515, 0xf529, 0xf53d, 0xf551,
	0xf565, 0xf579, 0xf58d, 0xf5a1, 0xf5b5, 0xf5c9, 0xf5dd, 0xf5f1,
	// Entry 65C0 - 65FF
	0xf605, 0xf619, 0xf62d, 0xf641, 0xf655, 0xf669, 0xf67d, 0xf691,
	0xf6a5, 0xf6b9, 0xf6cd, 0xf6e1, 0xf6f5, 0xf709, 0xf71d, 0xf731,
	0xf745, 0xf759, 0xf76d, 0xf781, 0xf795, 0xf7a9, 0xf7bd, 0xf7d1,
	0xf7e5, 0xf7f9, 0xf80d, 0xf821, 0xf835, 0xf849, 0xf85d, 0xf871,
	0xf885, 0xf899, 0xf8ad, 0xf8c1, 0xf8d5, 0xf8e9, 0xf8fd, 0xf911,
	0xf925, 0xf939, 0xf94d, 0xf961, 0xf975, 0xf989, 0xf99d, 0xf9b1,
	0xf9c5, 0xf9d9, 0xf9ed, 0xfa01, 0xfa15, 0xfa29, 0xfa3d, 0xfa51,
	0xfa65, 0xfa79, 0xfa8d, 0xfaa1, 0xfab5, 0xfac9, 0xfadd, 0xfaf1,
	// Entry 6600 - 663F
	0xfb05, 0xfb19, 0xfb2d, 0xfb41, 0xfb55, 0xfb69, 0xfb7d, 0xfb91,
	0xfba5, 0xfbb9, 0xfbcd, 0xfbe1, 0xfbf5, 0xfc09, 0xfc1d, 0xfc31,
	0xfc45, 0xfc59, 0xfc6d, 0xfc81, 0xfc95, 0xfca9, 0xfcbd, 0xfcd1,
	0xfce5, 0xfcf9, 0xfd0d, 0xfd21, 0xfd35, 0xfd49, 0xfd5d, 0xfd71,
	0xfd85, 0xfd99, 0xfdad, 0xfdc1, 0xfdd5, 0xfde9, 0xfdfd, 0xfe11,
	0xfe25, 0xfe39, 0xfe4d, 0xfe61, 0xfe75, 0xfe89, 0xfe9d, 0xfeb1,
	0xfec5, 0xfed9, 0xfeed, 0xff01, 0xff15, 0xff29, 0xff3d, 0xff51,
	0xff65, 0xff79, 0xff8d, 0xffa1, 0xffb5, 0xffc9, 0xffdd, 0xfff1,
	// Entry 6640 - 667F
	0x0005, 0x0019, 0x002d, 0x0041, 0x0055, 0x0069, 0x007d, 0x0091,
	0x00a5, 0x00b9, 0x00cd, 0x00e1, 0x00f5, 0x0109, 0x011d, 0x0131,
	0x0145, 0x0159, 0x016d, 0x0181, 0x0195, 0x01a9, 0x01bd, 0x01d1,
	0x01e5, 0x01f9, 0x020d, 0x0221, 0x0235, 0x0249, 0x025d, 0x0271,
	0x0285, 0x0299, 0x02ad, 0x02c1, 0x02d5, 0x02e9, 0x02fd, 0x0311,
	0x0325, 0x0339, 0x034d, 0x0361, 0x0375, 0x0389, 0x039d, 0x03b1,
	0x03c5, 0x03d9, 0x03ed, 0x0401, 0x0415, 0x0429, 0x043d, 0x0451,
	0x0465, 0x0479, 0x048d, 0x04a1, 0x04b5, 0x04c9, 0x04dd, 0x04f1,
	// Entry 6680 - 66BF
	0x0505, 0x0519, 0x052d, 0x0541, 0x0555, 0x0569, 0x057d, 0x0591,
	0x05a5, 0x05b9, 0x05cd, 0x05e1, 0x05f5, 0x0609, 0x061d, 0x0631,
	0x0645, 0x0659, 0x066d, 0x0681, 0x0695, 0x06a9, 0x06bd, 0x06d1,
	0x06e5, 0x06f9, 0x070d, 0x0721, 0x0735, 0x0749, 0x075d, 0x0771,
	0x0785, 0x0799, 0x07ad, 0x07c1, 0x07d5, 0x07e9, 0x07fd, 0x0811,
	0x0825, 0x0839, 0x084d, 0x0861, 0x0875, 0x0889, 0x089d, 0x08b1,
	0x08c5, 0x08d9, 0x08ed, 0x0901, 0x0915, 0x0929, 0x093d, 0x0951,
	0x0965, 0x0979, 0x098d, 0x09a1, 0x09b5, 0x09c9, 0x09dd, 0x09f1,
	// Entry 66C0 - 66FF
	0x0a05, 0x0a19, 0x0a2d, 0x0a41, 0x0a55, 0x0a69, 0x0a7d, 0x0a91,
	0x0aa5, 0x0ab9, 0x0acd, 0x0ae1, 0x0af5, 0x0b09, 0x0b1d, 0x0b31,
	0x0b45, 0x0b59, 0x0b6d, 0x0b81, 0x0b95, 0x0ba9, 0x0bbd, 0x0bd1,
	0x0be5, 0x0bf9, 0x0c0d, 0x0c21, 0x0c35, 0x0c49, 0x0c5d, 0x0c71,
	0x0c85, 0x0c99, 0x0cad, 0x0cc1, 0x0cd5, 0x0ce9, 0x0cfd, 0x0d11,
	0x0d25, 0x0d39, 0x0d4d, 0x0d61, 0x0d75, 0x0d89, 0x0d9d, 0x0db1,
	0x0dc5, 0x0dd9, 0x0ded, 0x0e01, 0x0e15, 0x0e29, 0x0e3d, 0x0e51,
	0x0e65, 0x0e79, 0x0e8d, 0x0ea1, 0x0eb5, 0x0ec9, 0x0edd, 0x0ef1,
	// Entry 6700 - 673F
	0x0f05, 0x0f19, 0x0f2d, 0x0f41, 0x0f55, 0x0f69, 0x0f7d, 0x0f91,
	0x0fa5, 0x0fb9, 0x0fcd, 0x0fe1, 0x0ff5, 0x1009, 0x101d, 0x1031,
	0x1045, 0x1059, 0x106d, 0x1081, 0x1095, 0x10a9, 0x10bd, 0x10d1,
	0x10e5, 0x10f9, 0x110d, 0x1121, 0x1135, 0x1149, 0x115d, 0x1171,
	0x1185, 0x1199, 0x11ad, 0x11c1, 0x11d5, 0x11e9, 0x11fd, 0x1211,
	0x1225, 0x1239, 0x124d, 0x1261, 0x1275, 0x1289, 0x129d, 0x12b1,
	0x12c5, 0x12d9, 0x12ed, 0x1301, 0x1315, 0x1329, 0x133d, 0x1351,
	0x1365, 0x1379, 0x138d, 0x13a1, 0x13b5, 0x13c9, 0x13dd, 0x13f1,
	// Entry 6740 - 677F
	0x1405, 0x1419, 0x142d, 0x1441, 0x1455, 0x1469, 0x147d, 0x1491,
	0x14a5, 0x14b9, 0x14cd, 0x14e1, 0x14f5, 0x1509, 0x151d, 0x1531,
	0x1545, 0x1559, 0x156d, 0x1581, 0x1595, 0x15a9, 0x15bd, 0x15d1,
	0x15e5, 0x15f9, 0x160d, 0x1621, 0x1635, 0x1649, 0x165d, 0x1671,
	0x1685, 0x1699, 0x16ad, 0x16c1, 0x16d5, 0x16e9, 0x16fd, 0x1711,
	0x1725, 0x1739, 0x174d, 0x1761, 0x1775, 0x1789, 0x179d, 0x17b1,
	0x17c5, 0x17d9, 0x17ed, 0x1801, 0x1815, 0x1829, 0x183d, 0x1851,
	0x1865, 0x1879, 0x188d, 0x18a1, 0x18b5, 0x18c9, 0x18dd, 0x18f1,
	// Entry 6780 - 67BF
	0x1905, 0x1919, 0x192d, 0x1941, 0x1955, 0x1969, 0x197d, 0x1991,
	0x19a5, 0x19b9, 0x19cd, 0x19e1, 0x19f5, 0x1a09, 0x1a1d, 0x1a31,
	0x1a45, 0x1a59, 0x1a6d, 0x1a81, 0x1a95, 0x1aa9, 0x1abd, 0x1ad1,
	0x1ae5, 0x1af9, 0x1b0d, 0x1b21, 0x1b35, 0x1b49, 0x1b5d, 0x1b71,
	0x1b85, 0x1b99, 0x1bad, 0x1bc1, 0x1bd5, 0x1be9, 0x1bfd, 0x1c11,
	0x1c25, 0x1c39, 0x1c4d, 0x1c61, 0x1c75, 0x1c89, 0x1c9d, 0x1cb1,
	0x1cc5, 0x1cd9, 0x1ced, 0x1d01, 0x1d15, 0x1d29, 0x1d3d, 0x1d51,
	0x1d65, 0x1d79, 0x1d8d, 0x1da1, 0x1db5, 0x1dc9, 0x1ddd, 0x1df1,
	// Entry 67C0 - 67FF
	0x1e05, 0x1e19, 0x1e2d, 0x1e41, 0x1e55, 0x1e69, 0x1e7d, 0x1e91,
	0x1ea5, 0x1ec8, 0x1eeb, 0x1f0e, 0x1f31, 0x1f54, 0x1f77, 0x1f9a,
	0x1fbd, 0x1fe0, 0x2003, 0x2026, 0x2049, 0x206c, 0x208f, 0x20b2,
	0x20d5, 0x20f8, 0x211b, 0x213e, 0x2161, 0x2184, 0x21a7, 0x21ca,
	0x21ed, 0x2210, 0x2233, 0x2256, 0x2279, 0x229c, 0x22bf, 0x22e2,
	0x2305, 0x2328, 0x234b, 0x236e, 0x2391, 0x23b4, 0x23d7, 0x23fa,
	0x241d, 0x2440, 0x2463, 0x2486, 0x24a9, 0x24cc, 0x24ef, 0x2512,
	0x2535, 0x2558, 0x257b, 0x259e, 0x25c1, 0x25e4, 0x2607, 0x262a,
	// Entry 6800 - 683F
	0x264d, 0x2670, 0x2693, 0x26b6, 0x26d9, 0x26fc, 0x271f, 0x2742,
	0x2765, 0x2788, 0x27ab, 0x27ce, 0x27f1, 0x2814, 0x2837, 0x285a,
	0x287d, 0x28a0, 0x28c3, 0x28e6, 0x2909, 0x292c, 0x294f, 0x2972,
	0x2995, 0x29b8, 0x29db, 0x29fe, 0x2a21, 0x2a44, 0x2a67, 0x2a8a,
	0x2aad, 0x2ad0, 0x2af3, 0x2b16, 0x2b39, 0x2b5c, 0x2b7f, 0x2ba2,
	0x2bc5, 0x2be8, 0x2c0b, 0x2c2e, 0x2c51, 0x2c74, 0x2c97, 0x2cba,
	0x2cdd, 0x2d00, 0x2d23, 0x2d46, 0x2d69, 0x2d8c, 0x2daf, 0x2dd2,
	0x2df5, 0x2e18, 0x2e3b, 0x2e5e, 0x2e81, 0x2ea4, 0x2ec7, 0x2eea,
	// Entry 6840 - 687F
	0x2f0d, 0x2f30, 0x2f53, 0x2f76, 0x2f99, 0x2fbc, 0x2fdf, 0x3002,
	0x3025, 0x3048, 0x306b, 0x308e, 0x30b1, 0x30d4, 0x30f7, 0x311a,
	0x313d, 0x3160, 0x3183, 0x31a6, 0x31c9, 0x31ec, 0x320f, 0x3232,
	0x3255, 0x3278, 0x329b, 0x32be, 0x32e1, 0x3304, 0x3327, 0x334a,
	0x336d, 0x3390, 0x33b3, 0x33d6, 0x33f9, 0x341c, 0x343f, 0x3462,
	0x3485, 0x34a8, 0x34cb, 0x34ee, 0x3511, 0x3534, 0x3557, 0x357a,
	0x359d, 0x35c0, 0x35e3, 0x3606, 0x3629, 0x364c, 0x366f, 0x3692,
	0x36b5, 0x36d8, 0x36fb, 0x371e, 0x3741, 0x3764, 0x3787, 0x37aa,
	// Entry 6880 - 68BF
	0x37cd, 0x37f0, 0x3813, 0x3836, 0x3859, 0x387c, 0x389f, 0x38c2,
	0x38e5, 0x3908, 0x392b, 0x394e, 0x3971, 0x3994, 0x39b7, 0x39da,
	0x39fd, 0x3a20, 0x3a43, 0x3a66, 0x3a89, 0x3aac, 0x3acf, 0x3af2,
	0x3b15, 0x3b38, 0x3b5b, 0x3b7e, 0x3ba1, 0x3bc4, 0x3be7, 0x3c0a,
	0x3c2d, 0x3c50, 0x3c73, 0x3c96, 0x3cb9, 0x3cdc, 0x3cff, 0x3d22,
	0x3d45, 0x3d68, 0x3d8b, 0x3dae, 0x3dd1, 0x3df4, 0x3e17, 0x3e3a,
	0x3e5d, 0x3e80, 0x3ea3, 0x3ec6, 0x3ee9, 0x3f0c, 0x3f2f, 0x3f52,
	0x3f75, 0x3f98, 0x3fbb, 0x3fde, 0x4001, 0x4024, 0x4047, 0x406a,
	// Entry 68C0 - 68FF
	0x408d, 0x40b0, 0x40d3, 0x40f6, 0x4119, 0x413c, 0x415f, 0x4182,
	0x41a5, 0x41c8, 0x41eb, 0x420e, 0x4231, 0x4254, 0x4277, 0x429a,
	0x42bd, 0x42e0, 0x4303, 0x4326, 0x4349, 0x436c, 0x438f, 0x43b2,
	0x43d5, 0x43f8, 0x441b, 0x443e, 0x4461, 0x4484, 0x44a7, 0x44ca,
	0x44ed, 0x4510, 0x4533, 0x4556, 0x4579, 0x459c, 0x45bf, 0x45e2,
	0x4605, 0x4628, 0x464b, 0x466e, 0x4691, 0x46b4, 0x46d7, 0x46fa,
	0x471d, 0x4740, 0x4763, 0x4786, 0x47a9, 0x47cc, 0x47ef, 0x4812,
	0x4835, 0x4858, 0x487b, 0x489e, 0x48c1, 0x48e4, 0x4907, 0x492a,
	// Entry 6900 - 693F
	0x494d, 0x4970, 0x4993, 0x49b6, 0x49d9, 0x49fc, 0x4a1f, 0x4a42,
	0x4a65, 0x4a88, 0x4aab, 0x4ace, 0x4af1, 0x4b14, 0x4b37, 0x4b5a,
	0x4b7d, 0x4ba0, 0x4bc3, 0x4be6, 0x4c09, 0x4c2c, 0x4c4f, 0x4c72,
	0x4c95, 0x4cb8, 0x4cdb, 0x4cfe, 0x4d21, 0x4d44, 0x4d67, 0x4d8a,
	0x4dad, 0x4dd0, 0x4df3, 0x4e16, 0x4e39, 0x4e5c, 0x4e7f, 0x4ea2,
	0x4ec5, 0x4ee8, 0x4f0b, 0x4f2e, 0x4f51, 0x4f74, 0x4f97, 0x4fba,
	0x4fdd, 0x5000, 0x5023, 0x5046, 0x5069, 0x508c, 0x50af, 0x50d2,
	0x50f5, 0x5118, 0x513b, 0x515e, 0x5181, 0x51a4, 0x51c7, 0x51ea,
	// Entry 6940 - 697F
	0x520d, 0x5230, 0x5253, 0x5276, 0x5299, 0x52bc, 0x52df, 0x5302,
	0x5325, 0x5348, 0x536b, 0x538e, 0x53b1, 0x53d4, 0x53f7, 0x541a,
	0x543d, 0x5460, 0x5483, 0x54a6, 0x54c9, 0x54ec, 0x550f, 0x5532,
	0x5555, 0x5578, 0x559b, 0x55be, 0x55e1, 0x5604, 0x5627, 0x564a,
	0x566d, 0x5690, 0x56b3, 0x56d6, 0x56f9, 0x571c, 0x573f, 0x5762,
	0x5785, 0x57a8, 0x57cb, 0x57ee, 0x5811, 0x5834, 0x5857, 0x587a,
	0x589d, 0x58c0, 0x58e3, 0x5906, 0x5929, 0x594c, 0x596f, 0x5992,
	0x59b5, 0x59d8, 0x59fb, 0x5a1e, 0x5a41, 0x5a64, 0x5a87, 0x5aaa,
	// Entry 6980 - 69BF
	0x5acd, 0x5af0, 0x5b13, 0x5b36, 0x5b59, 0x5b7c, 0x5b9f, 0x5bc2,
	0x5be5, 0x5c08, 0x5c2b, 0x5c4e, 0x5c71, 0x5c94, 0x5cb7, 0x5cda,
	0x5cfd, 0x5d20, 0x5d43, 0x5d66, 0x5d89, 0x5dac, 0x5dcf, 0x5df2,
	0x5e15, 0x5e38, 0x5e5b, 0x5e7e, 0x5ea1, 0x5ec4, 0x5ee7, 0x5f04,
	0x5f21, 0x5f3e, 0x5f5b, 0x5f78, 0x5f95, 0x5fbc, 0x5fe3, 0x600a,
	0x6031, 0x6058, 0x607f, 0x60a6, 0x60bf, 0x60d9, 0x60ee, 0x6103,
	0x6118, 0x612e, 0x6143, 0x6158, 0x616d, 0x6182, 0x6197, 0x61ac,
	0x61c1, 0x61d6, 0x61eb, 0x6200, 0x6215, 0x622a, 0x623f, 0x6254,
	// Entry 69C0 - 69FF
	0x6269, 0x627e, 0x6293, 0x62a9, 0x62bf, 0x62d5, 0x62eb, 0x6301,
	0x6317, 0x632d, 0x6343, 0x6359, 0x6370, 0x6387, 0x639e, 0x63b4,
	0x63ca, 0x63e0, 0x63f6, 0x640c, 0x6422, 0x6438, 0x644e, 0x6464,
	0x647a, 0x6490, 0x64a6, 0x64bc, 0x64d2, 0x64e8, 0x64fe, 0x6514,
	0x652a, 0x6540, 0x6556, 0x656c, 0x6582, 0x6598, 0x65ae, 0x65c5,
	0x65db, 0x65f1, 0x6607, 0x661d, 0x6633, 0x6649, 0x665f, 0x6675,
	0x668b, 0x66a1, 0x66b7, 0x66cd, 0x66e3, 0x66f9, 0x670f, 0x6725,
	0x673b, 0x6751, 0x6767, 0x677d, 0x6793, 0x67a9, 0x67bf, 0x67d5,
	// Entry 6A00 - 6A3F
	0x67eb, 0x6801, 0x6817, 0x682d, 0x6843, 0x6859, 0x686f, 0x6885,
	0x689b, 0x68b1, 0x68c7, 0x68dd, 0x68f3, 0x6909, 0x691f, 0x6935,
	0x694b, 0x6961, 0x6977, 0x698d, 0x69a3, 0x69b9, 0x69cf, 0x69e5,
	0x69fb, 0x6a12, 0x6a28, 0x6a3e, 0x6a54, 0x6a6a, 0x6a80, 0x6a96,
	0x6aac, 0x6ac2, 0x6ad8, 0x6aee, 0x6b04, 0x6b1a, 0x6b30, 0x6b46,
	0x6b5c, 0x6b73, 0x6b89, 0x6b9f, 0x6bb5, 0x6bcb, 0x6be1, 0x6bf7,
	0x6c0d, 0x6c23, 0x6c39, 0x6c4f, 0x6c65, 0x6c7b, 0x6c91, 0x6ca7,
	0x6cbd, 0x6cd3, 0x6cea, 0x6d00, 0x6d16, 0x6d2c, 0x6d42, 0x6d58,
	// Entry 6A40 - 6A7F
	0x6d6e, 0x6d84, 0x6d9a, 0x6db0, 0x6dc7, 0x6ddd, 0x6df3, 0x6e09,
	0x6e1f, 0x6e35, 0x6e4b, 0x6e61, 0x6e77, 0x6e8d, 0x6ea3, 0x6eb9,
	0x6ecf, 0x6ee5, 0x6efb, 0x6f12, 0x6f29, 0x6f3f, 0x6f55, 0x6f6b,
	0x6f81, 0x6f97, 0x6fad, 0x6fc3, 0x6fd9, 0x6fef, 0x7005, 0x701b,
	0x7031, 0x7047, 0x705d, 0x7073, 0x7089, 0x709f, 0x70b5, 0x70cb,
	0x70e1, 0x70f7, 0x710d, 0x7123, 0x7139, 0x714f, 0x7165, 0x717b,
	0x7191, 0x71a7, 0x71bd, 0x71d3, 0x71e9, 0x71ff, 0x7215, 0x722b,
	0x7241, 0x7257, 0x726d, 0x7283, 0x7299, 0x72af, 0x72c5, 0x72db,
	// Entry 6A80 - 6ABF
	0x72f1, 0x7307, 0x731e, 0x7334, 0x734a, 0x7360, 0x7376, 0x738c,
	0x73a2, 0x73b8, 0x73ce, 0x73e4, 0x73fa, 0x7410, 0x7427, 0x743d,
	0x7453, 0x7469, 0x747f, 0x7495, 0x74ab, 0x74c1, 0x74d7, 0x74ed,
	0x7503, 0x7519, 0x752f, 0x7545, 0x755b, 0x7571, 0x7587, 0x759d,
	0x75b3, 0x75c9, 0x75df, 0x75f5, 0x760b, 0x7621, 0x7637, 0x764d,
	0x7663, 0x7679, 0x768f, 0x76a5, 0x76bb, 0x76d1, 0x76e7, 0x76fd,
	0x7713, 0x7729, 0x773f, 0x7755, 0x776b, 0x7781, 0x7797, 0x77ad,
	0x77c3, 0x77d9, 0x77ef, 0x7805, 0x781b, 0x7831, 0x7847, 0x785d,
	// Entry 6AC0 - 6AFF
	0x7873, 0x7889, 0x789f, 0x78b5, 0x78cb, 0x78e1, 0x78f7, 0x790d,
	0x7923, 0x793e, 0x7959, 0x7973, 0x798d, 0x79a7, 0x79c1, 0x79d9,
	0x79f1, 0x7a09, 0x7a21, 0x7a39, 0x7a51, 0x7a69, 0x7a81, 0x7a98,
	0x7aad, 0x7ac2, 0x7ad7, 0x7aec, 0x7b01, 0x7b16, 0x7b2b, 0x7b40,
	0x7b55, 0x7b6a, 0x7b7f, 0x7b94, 0x7ba9, 0x7bbe, 0x7bd3, 0x7be8,
	0x7bfd, 0x7c12, 0x7c27, 0x7c3c, 0x7c51, 0x7c66, 0x7c7b, 0x7c90,
	0x7ca5, 0x7cba, 0x7ccf, 0x7ce4, 0x7cf9, 0x7d0e, 0x7d23, 0x7d38,
	0x7d4d, 0x7d62, 0x7d77, 0x7d8c, 0x7da1, 0x7db6, 0x7dcb, 0x7de0,
	// Entry 6B00 - 6B3F
	0x7df5, 0x7e0a, 0x7e1f, 0x7e34, 0x7e49, 0x7e5e, 0x7e73, 0x7e88,
	0x7e9d, 0x7eb2, 0x7ec7, 0x7edc, 0x7ef1, 0x7f06, 0x7f1b, 0x7f30,
	0x7f45, 0x7f5a, 0x7f6f, 0x7f84, 0x7f99, 0x7fae, 0x7fc3, 0x7fd8,
	0x7fed, 0x8002, 0x8017, 0x802c, 0x8041, 0x8056, 0x806b, 0x8080,
	0x8095, 0x80aa, 0x80bf, 0x80d4, 0x80e9, 0x80fe, 0x8113, 0x8128,
	0x813d, 0x8152, 0x8167, 0x817c, 0x8191, 0x81a6, 0x81bb, 0x81d0,
	0x81e5, 0x81fa, 0x820f, 0x8224, 0x8239, 0x824e, 0x8263, 0x8278,
	0x828d, 0x82a2, 0x82b7, 0x82cc, 0x82e1, 0x82f6, 0x830b, 0x8320,
	// Entry 6B40 - 6B7F
	0x8335, 0x834a, 0x835f, 0x8374, 0x8389, 0x839e, 0x83b3, 0x83c8,
	0x83dd, 0x83f2, 0x8407, 0x841c, 0x8431, 0x8446, 0x845b, 0x8470,
	0x8485, 0x849a, 0x84af, 0x84c4, 0x84d9, 0x84ee, 0x8503, 0x8518,
	0x852d, 0x8542, 0x8557, 0x856c, 0x8581, 0x8596, 0x85ab, 0x85c0,
	0x85d5, 0x85ea, 0x85ff, 0x8614, 0x8629, 0x863e, 0x8653, 0x8668,
	0x867d, 0x8692, 0x86a7, 0x86bc, 0x86d1, 0x86e6, 0x86fb, 0x8710,
	0x8725, 0x873a, 0x874f, 0x8764, 0x8779, 0x878e, 0x87a3, 0x87b8,
	0x87cd, 0x87e2, 0x87f7, 0x880c, 0x8821, 0x8836, 0x884b, 0x8860,
	// Entry 6B80 - 6BBF
	0x8875, 0x888a, 0x889f, 0x88b4, 0x88c9, 0x88de, 0x88f3, 0x8908,
	0x891d, 0x8932, 0x8947, 0x895c, 0x8971, 0x8986, 0x899b, 0x89b0,
	0x89c5, 0x89da, 0x89ef, 0x8a04, 0x8a19, 0x8a2e, 0x8a43, 0x8a58,
	0x8a6d, 0x8a82, 0x8a97, 0x8aac, 0x8ac1, 0x8ad6, 0x8aeb, 0x8b00,
	0x8b15, 0x8b2a, 0x8b3f, 0x8b54, 0x8b69, 0x8b7e, 0x8b93, 0x8ba8,
	0x8bbd, 0x8bd2, 0x8be7, 0x8bfc, 0x8c11, 0x8c26, 0x8c3b, 0x8c50,
	0x8c65, 0x8c7a, 0x8c8f, 0x8ca4, 0x8cb9, 0x8cce, 0x8ce3, 0x8cf8,
	0x8d0d, 0x8d22, 0x8d37, 0x8d4c, 0x8d61, 0x8d76, 0x8d8b, 0x8da0,
	// Entry 6BC0 - 6BFF
	0x8db5, 0x8dca, 0x8ddf, 0x8df4, 0x8e09, 0x8e1e, 0x8e33, 0x8e48,
	0x8e5d, 0x8e72, 0x8e87, 0x8e9c, 0x8eb1, 0x8ec6, 0x8edb, 0x8ef0,
	0x8f05, 0x8f1a, 0x8f2f, 0x8f44, 0x8f59, 0x8f6e, 0x8f83, 0x8f98,
	0x8fad, 0x8fc2, 0x8fd7, 0x8fec, 0x9001, 0x9016, 0x902b, 0x9040,
	0x9055, 0x906a, 0x907f, 0x9094, 0x90a9, 0x90be, 0x90d3, 0x90e8,
	0x90fd, 0x9112, 0x9127, 0x913c, 0x9151, 0x9166, 0x917b, 0x9190,
	0x91a5, 0x91ba, 0x91cf, 0x91e4, 0x91f9, 0x920e, 0x9223, 0x9238,
	0x924d, 0x9262, 0x9277, 0x928c, 0x92a1, 0x92b6, 0x92cb, 0x92e0,
	// Entry 6C00 - 6C3F
	0x92f5, 0x930a, 0x931f, 0x9334, 0x9349, 0x935e, 0x9373, 0x9388,
	0x939d, 0x93b2, 0x93c7, 0x93dc, 0x93f1, 0x9406, 0x941b, 0x9430,
	0x9445, 0x945a, 0x946f, 0x9484, 0x9499, 0x94ae, 0x94c3, 0x94d8,
	0x94ed, 0x9502, 0x9517, 0x952c, 0x9541, 0x9556, 0x956b, 0x9580,
	0x9595, 0x95aa, 0x95bf, 0x95d4, 0x95e9, 0x95fe, 0x9613, 0x9628,
	0x963d, 0x9652, 0x9667, 0x967c, 0x9691, 0x96a6, 0x96bb, 0x96d0,
	0x96e5, 0x96fa, 0x970f, 0x9724, 0x9739, 0x974e, 0x9763, 0x9778,
	0x978d, 0x97a2, 0x97b7, 0x97cc, 0x97e1, 0x97f6, 0x980b, 0x9820,
	// Entry 6C40 - 6C7F
	0x9835, 0x984a, 0x985f, 0x9874, 0x9889, 0x989e, 0x98b3, 0x98c8,
	0x98dd, 0x98f2, 0x9907, 0x991c, 0x9931, 0x9946, 0x995b, 0x9970,
	0x9985, 0x999a, 0x99af, 0x99c4, 0x99d9, 0x99ee, 0x9a03, 0x9a18,
	0x9a2d, 0x9a42, 0x9a57, 0x9a6c, 0x9a81, 0x9a96, 0x9aab, 0x9ac0,
	0x9ad5, 0x9aea, 0x9aff, 0x9b14, 0x9b25, 0x9b36, 0x9b47, 0x9b58,
	0x9b69, 0x9b7a, 0x9b8b, 0x9b9c, 0x9bad, 0x9bbe, 0x9bcf, 0x9be0,
	0x9bf3, 0x9c06, 0x9c19, 0x9c2c, 0x9c3f, 0x9c51, 0x9c69, 0x9c7b,
	0x9c8d, 0x9ca4, 0x9cb6, 0x9cc8, 0x9cda, 0x9ceb, 0x9cfc, 0x9d0d,
	// Entry 6C80 - 6CBF
	0x9d1e, 0x9d31, 0x9d44, 0x9d57, 0x9d6a, 0x9d84, 0x9d9e, 0x9db8,
	0x9de4, 0x9dfe, 0x9e1e, 0x9e31, 0x9e44, 0x9e57, 0x9e6a, 0x9e7f,
	0x9e94, 0x9ea9, 0x9ebe, 0x9eda, 0x9eed, 0x9f02, 0x9f15, 0x9f2a,
	0x9f3d, 0x9f52, 0x9f65, 0x9f7a, 0x9f8b, 0x9f9d, 0x9fb0, 0x9fc3,
	0x9fd6, 0x9feb, 0xa000, 0xa013, 0xa028, 0xa039, 0xa051, 0xa063,
	0xa074, 0xa087, 0xa098, 0xa0a9, 0xa0bb, 0xa0d2, 0xa0e4, 0xa0f6,
	0xa10e, 0xa128, 0xa140, 0xa156, 0xa168, 0xa179, 0xa18b, 0xa19d,
	0xa1b0, 0xa1c6, 0xa1e0, 0xa1f2, 0xa209, 0xa21c, 0xa22e, 0xa240,
	// Entry 6CC0 - 6CFF
	0xa252, 0xa264, 0xa276, 0xa289, 0xa29c, 0xa2b3, 0xa2ca, 0xa2e1,
	0xa2f8, 0xa311, 0xa32a, 0xa342, 0xa35a, 0xa372, 0xa38b, 0xa3b0,
	0xa3d4, 0xa3fa, 0xa41c, 0xa43e, 0xa461, 0xa47f, 0xa4ab, 0xa4ca,
	0xa4e6, 0xa504, 0xa522, 0xa546, 0xa55f, 0xa57e, 0xa597, 0xa5b5,
	0xa5cc, 0xa5e6, 0xa5fe, 0xa616, 0xa632, 0xa64a, 0xa668, 0xa680,
	0xa69d, 0xa6b3, 0xa6cc, 0xa6e3, 0xa6fa, 0xa715, 0xa72d, 0xa747,
	0xa765, 0xa779, 0xa79f, 0xa7be, 0xa7e1, 0xa7fb, 0xa813, 0xa84a,
	0xa879, 0xa89e, 0xa8cb, 0xa8f0, 0xa916, 0xa942, 0xa969, 0xa98f,
	// Entry 6D00 - 6D3F
	0xa9c6, 0xa9f8, 0xaa29, 0xaa61, 0xaa91, 0xaab7, 0xaae5, 0xab0b,
	0xab32, 0xab5f, 0xab87, 0xabae, 0xabe6, 0xac19, 0xac4b, 0xac72,
	0xaca0, 0xaccc, 0xacf5, 0xad1c, 0xad44, 0xad70, 0xad96, 0xadb2,
	0xadcc, 0xade9, 0xae08, 0xae27, 0xae45, 0xae66, 0xae83, 0xaea2,
	0xaec0, 0xaedd, 0xaefa, 0xaf19, 0xaf3e, 0xaf69, 0xaf93, 0xafc0,
	0xafe1, 0xb00e, 0xb02e, 0xb050, 0xb087, 0xb0a6, 0xb0cd, 0xb0ed,
	0xb114, 0xb132, 0xb154, 0xb17e, 0xb1a1, 0xb1be, 0xb1ec, 0xb20d,
	0xb22e, 0xb256, 0xb275, 0xb292, 0xb2a6, 0xb2c0, 0xb2d7, 0xb2f2,
	// Entry 6D40 - 6D7F
	0xb307, 0xb31e, 0xb335, 0xb355, 0xb36d, 0xb394, 0xb3c0, 0xb3d9,
	0xb3ed, 0xb405, 0xb423, 0xb441, 0xb461, 0xb480, 0xb4a2, 0xb4c2,
	0xb4e3, 0xb503, 0xb526, 0xb552, 0xb57f, 0xb5ab, 0xb5da, 0xb5f9,
	0xb61b, 0xb632, 0xb648, 0xb65e, 0xb677, 0xb699, 0xb6ba, 0xb6de,
	0xb6fe, 0xb71f, 0xb74c, 0xb77a, 0xb7a6, 0xb7d4, 0xb802, 0xb836,
	0xb867, 0xb87f, 0xb8a2, 0xb8c3, 0xb8e5, 0xb8f9, 0xb90b, 0xb91e,
	0xb933, 0xb949, 0xb95e, 0xb97e, 0xb99d, 0xb9c7, 0xb9f1, 0xba10,
	0xba3a, 0xba57, 0xba7f, 0xbaad, 0xbac6, 0xbaea, 0xbb08, 0xbb2c,
	// Entry 6D80 - 6DBF
	0xbb4c, 0xbb6f, 0xbb8e, 0xbbb2, 0xbbd8, 0xbc03, 0xbc28, 0xbc4a,
	0xbc74, 0xbc9d, 0xbccb, 0xbd00, 0xbd34, 0xbd6e, 0xbd8c, 0xbdb0,
	0xbdea, 0xbe0f, 0xbe3e, 0xbe53, 0xbe70, 0xbe90, 0xbeb4, 0xbedd,
	0xbf01, 0xbf26, 0xbf4b, 0xbf5f, 0xbf7c, 0xbf9c, 0xbfc4, 0xbfed,
	0xc01c, 0xc03c, 0xc066, 0xc0a5, 0xc0ea, 0xc113, 0xc142, 0xc187,
	0xc1b7, 0xc1f1, 0xc219, 0xc22f, 0xc244, 0xc257, 0xc26b, 0xc27e,
	0xc29c, 0xc2bb, 0xc2df, 0xc309, 0xc32d, 0xc358, 0xc37d, 0xc39e,
	0xc3c0, 0xc3e4, 0xc406, 0xc42e, 0xc44f, 0xc479, 0xc4a1, 0xc4c0,
	// Entry 6DC0 - 6DFF
	0xc4e2, 0xc505, 0xc52e, 0xc54e, 0xc56c, 0xc594, 0xc5bc, 0xc5db,
	0xc5fc, 0xc61a, 0xc640, 0xc669, 0xc694, 0xc6b5, 0xc6d6, 0xc6ff,
	0xc727, 0xc750, 0xc77a, 0xc79b, 0xc7ba, 0xc7d8, 0xc800, 0xc820,
	0xc845, 0xc864, 0xc88d, 0xc8ba, 0xc8e5, 0xc903, 0xc921, 0xc93d,
	0xc95a, 0xc97a, 0xc99c, 0xc9c2, 0xc9ea, 0xca0c, 0xca36, 0xca5e,
	0xca7f, 0xcaa1, 0xcac2, 0xcaec, 0xcb0c, 0xcb39, 0xcb66, 0xcb86,
	0xcba3, 0xcbc3, 0xcbe9, 0xcc0f, 0xcc34, 0xcc59, 0xcc7a, 0xcc9d,
	0xccbf, 0xccdf, 0xcd00, 0xcd28, 0xcd50, 0xcd75, 0xcd9f, 0xcdc7,
	// Entry 6E00 - 6E3F
	0xcde6, 0xce0d, 0xce3e, 0xce5e, 0xce86, 0xcea6, 0xcec6, 0xceea,
	0xcf0d, 0xcf30, 0xcf56, 0xcf75, 0xcf98, 0xcfb8, 0xcfe0, 0xd008,
	0xd033, 0xd053, 0xd07b, 0xd0a0, 0xd0c3, 0xd0e7, 0xd105, 0xd12a,
	0xd14b, 0xd16e, 0xd193, 0xd1bc, 0xd1e4, 0xd20b, 0xd236, 0xd262,
	0xd289, 0xd2b1, 0xd2d8, 0xd2fe, 0xd32b, 0xd351, 0xd379, 0xd3a1,
	0xd3c6, 0xd3ef, 0xd411, 0xd433, 0xd455, 0xd476, 0xd496, 0xd4b9,
	0xd4e0, 0xd509, 0xd52e, 0xd552, 0xd577, 0xd594, 0xd5b2, 0xd5d1,
	0xd5f2, 0xd612, 0xd63e, 0xd669, 0xd696, 0xd6c6, 0xd6f5, 0xd71c,
	// Entry 6E40 - 6E7F
	0xd752, 0xd785, 0xd7a6, 0xd7e3, 0xd81f, 0xd854, 0xd876, 0xd894,
	0xd8b7, 0xd8d7, 0xd8ff, 0xd926, 0xd949, 0xd96e, 0xd991, 0xd9b5,
	0xd9dd, 0xda06, 0xda34, 0xda67, 0xda97, 0xdacc, 0xdafa, 0xdb25,
	0xdb55, 0xdb8d, 0xdbbc, 0xdbeb, 0xdc1b, 0xdc4f, 0xdc7d, 0xdcaa,
	0xdcd5, 0xdd02, 0xdd34, 0xdd6c, 0xdd98, 0xddc5, 0xddf4, 0xde15,
	0xde38, 0xde6f, 0xde9b, 0xdec9, 0xdef3, 0xdf1f, 0xdf52, 0xdf7e,
	0xdfaa, 0xdfdb, 0xe00b, 0xe042, 0xe07b, 0xe0af, 0xe0e4, 0xe10a,
	0xe12e, 0xe153, 0xe178, 0xe1ae, 0xe1e2, 0xe20d, 0xe238, 0xe265,
	// Entry 6E80 - 6EBF
	0xe296, 0xe2d2, 0xe307, 0xe33f, 0xe370, 0xe3ac, 0xe3e1, 0xe419,
	0xe43f, 0xe465, 0xe491, 0xe4be, 0xe4e5, 0xe50e, 0xe537, 0xe568,
	0xe59a, 0xe5ce, 0xe5f6, 0xe626, 0xe657, 0xe68a, 0xe6ae, 0xe6d3,
	0xe6f2, 0xe715, 0xe739, 0xe75c, 0xe77f, 0xe7a2, 0xe7c5, 0xe7e8,
	0xe813, 0xe83c, 0xe867, 0xe890, 0xe8b4, 0xe8dc, 0xe8f9, 0xe916,
	0xe932, 0xe956, 0xe973, 0xe98f, 0xe9ae, 0xe9ce, 0xe9e8, 0xea00,
	0xea16, 0xea2a, 0xea3d, 0xea5d, 0xea7d, 0xea9d, 0xeab3, 0xeacf,
	0xeae9, 0xeaff, 0xeb13, 0xeb29, 0xeb46, 0xeb63, 0xeb82, 0xeba0,
	// Entry 6EC0 - 6EFF
	0xebbe, 0xebdb, 0xebfe, 0xec22, 0xec37, 0xec58, 0xec7a, 0xec8f,
	0xeca4, 0xecc5, 0xece7, 0xed01, 0xed1b, 0xed3f, 0xed5a, 0xed74,
	0xed8a, 0xeda2, 0xedbb, 0xedd6, 0xeded, 0xee06, 0xee27, 0xee47,
	0xee61, 0xee78, 0xee92, 0xeead, 0xeecd, 0xeeee, 0xef07, 0xef20,
	0xef38, 0xef53, 0xef6d, 0xef8a, 0xefab, 0xefcb, 0xeff8, 0xf011,
	0xf02d, 0xf04d, 0xf071, 0xf095, 0xf0be, 0xf0e7, 0xf112, 0xf13d,
	0xf169, 0xf195, 0xf1c0, 0xf1eb, 0xf21a, 0xf249, 0xf26b, 0xf28d,
	0xf2be, 0xf2ef, 0xf312, 0xf32e, 0xf34b, 0xf367, 0xf38c, 0xf3b1,
	// Entry 6F00 - 6F3F
	0xf3c5, 0xf3de, 0xf3f6, 0xf411, 0xf42b, 0xf448, 0xf469, 0xf489,
	0xf4b6, 0xf4d3, 0xf4fd, 0xf51f, 0xf541, 0xf563, 0xf584, 0xf5a5,
	0xf5c6, 0xf5ef, 0xf60e, 0xf62d, 0xf64c, 0xf66b, 0xf68a, 0xf6a3,
	0xf6ba, 0xf6d2, 0xf6e8, 0xf701, 0xf718, 0xf733, 0xf74c, 0xf76b,
	0xf78c, 0xf7ab, 0xf7d1, 0xf7f1, 0xf81a, 0xf842, 0xf860, 0xf87c,
	0xf89a, 0xf8b7, 0xf8d3, 0xf8f0, 0xf90e, 0xf92b, 0xf951, 0xf977,
	0xf991, 0xf9a6, 0xf9b6, 0xf9ca, 0xf9de, 0xf9f2, 0xfa0a, 0xfa24,
	0xfa43, 0xfa65, 0xfa76, 0xfa89, 0xfaa5, 0xfabe, 0xfad4, 0xfaf4,
	// Entry 6F40 - 6F7F
	0xfb14, 0xfb34, 0xfb54, 0xfb74, 0xfb94, 0xfbb4, 0xfbd4, 0xfbf4,
	0xfc15, 0xfc36, 0xfc50, 0xfc6a, 0xfc86, 0xfca1, 0xfcc2, 0xfce1,
	0xfd02, 0xfd29, 0xfd42, 0xfd5e, 0xfd7c, 0xfd97, 0xfdb4, 0xfdd3,
	0xfde6, 0xfdfd, 0xfe12, 0xfe26, 0xfe3b, 0xfe5a, 0xfe79, 0xfe8e,
	0xfea9, 0xfec8, 0xfee7, 0xff00, 0xff19, 0xff3b, 0xff5f, 0xff79,
	0xff97, 0xffb1, 0xffcf, 0x0006, 0x003f, 0x0083, 0x00bc, 0x00f7,
	0x013f, 0x0187, 0x01cf, 0x01e3, 0x0202, 0x0221, 0x0238, 0x024c,
	0x0262, 0x0277, 0x028f, 0x02a6, 0x02bd, 0x02d5, 0x02f4, 0x0313,
	// Entry 6F80 - 6FBF
	0x0334, 0x0351, 0x036d, 0x038f, 0x03af, 0x03d4, 0x03f4, 0x0413,
	0x043f, 0x0469, 0x0494, 0x04bd, 0x04dc, 0x04ef, 0x0503, 0x0520,
	0x053d, 0x055a, 0x0577, 0x0594, 0x05b1, 0x05ce, 0x05eb, 0x0608,
	0x0626, 0x0644, 0x0662, 0x0680, 0x069e, 0x06bc, 0x06da, 0x06f8,
	0x0716, 0x0734, 0x0752, 0x0770, 0x078e, 0x07ac, 0x07ca, 0x07e8,
	0x0806, 0x0824, 0x0842, 0x0860, 0x0884, 0x08a8, 0x08cc, 0x08f0,
	0x0914, 0x0938, 0x095d, 0x0982, 0x09a7, 0x09cc, 0x09f1, 0x0a16,
	0x0a3b, 0x0a60, 0x0a85, 0x0aaa, 0x0acf, 0x0af4, 0x0b19, 0x0b3e,
	// Entry 6FC0 - 6FFF
	0x0b63, 0x0b88, 0x0bad, 0x0bd2, 0x0bf7, 0x0c1c, 0x0c41, 0x0c66,
	0x0c8b, 0x0cb0, 0x0cd5, 0x0cfa, 0x0d1f, 0x0d44, 0x0d69, 0x0d8e,
	0x0db3, 0x0dd2, 0x0df3, 0x0e14, 0x0e28, 0x0e3d, 0x0e51, 0x0e65,
	0x0e7b, 0x0e90, 0x0ea5, 0x0eb9, 0x0ecf, 0x0ee5, 0x0efa, 0x0f0e,
	0x0f25, 0x0f3c, 0x0f55, 0x0f6e, 0x0f86, 0x0f9e, 0x0fb8, 0x0fd1,
	0x0fea, 0x0ffc, 0x100d, 0x101e, 0x1031, 0x1043, 0x1055, 0x1066,
	0x1079, 0x108c, 0x109e, 0x10af, 0x10c3, 0x10d7, 0x10ed, 0x1103,
	0x1118, 0x112d, 0x1144, 0x115a, 0x1170, 0x1182, 0x119b, 0x11b1,
	// Entry 7000 - 703F
	0x11ca, 0x11e2, 0x11f2, 0x1206, 0x121f, 0x1232, 0x1247, 0x1262,
	0x127b, 0x128f, 0x12a7, 0x12c2, 0x12eb, 0x1303, 0x131d, 0x1333,
	0x134c, 0x135f, 0x1374, 0x138e, 0x13a3, 0x13ba, 0x13cf, 0x13e4,
	0x13fc, 0x140e, 0x141f, 0x1437, 0x144e, 0x1462, 0x1476, 0x1490,
	0x14ad, 0x14c2, 0x14d6, 0x14ed, 0x1502, 0x1519, 0x152f, 0x1543,
	0x1559, 0x1570, 0x158a, 0x15a0, 0x15bb, 0x15d3, 0x15e6, 0x15fd,
	0x1616, 0x162b, 0x163f, 0x1653, 0x1674, 0x168b, 0x16a0, 0x16b6,
	0x16c9, 0x16e3, 0x16fd, 0x1716, 0x1730, 0x1745, 0x175f, 0x177a,
	// Entry 7040 - 707F
	0x178d, 0x17a0, 0x17b5, 0x17c8, 0x17df, 0x17f6, 0x180b, 0x1823,
	0x183a, 0x1850, 0x1866, 0x187e, 0x1893, 0x18a8, 0x18c1, 0x18d9,
	0x18f3, 0x190d, 0x1924, 0x193b, 0x1956, 0x1971, 0x198e, 0x19aa,
	0x19c6, 0x19e1, 0x19fe, 0x1a1b, 0x1a37, 0x1a52, 0x1a6d, 0x1a8a,
	0x1aa6, 0x1ac2, 0x1add, 0x1afa, 0x1b17, 0x1b33, 0x1b4d, 0x1b67,
	0x1b83, 0x1b9e, 0x1bb9, 0x1bc7, 0x1bd6, 0x1bf1, 0x1c0c, 0x1c27,
	0x1c42, 0x1c5d, 0x1c78, 0x1c93, 0x1cae, 0x1cc9, 0x1ce4, 0x1cff,
	0x1d1a, 0x1d35, 0x1d50, 0x1d6b, 0x1d86, 0x1da1, 0x1dbc, 0x1dd7,
	// Entry 7080 - 70BF
	0x1df2, 0x1e0d, 0x1e28, 0x1e43, 0x1e5e, 0x1e79, 0x1e94, 0x1ead,
	0x1ec6, 0x1edf, 0x1ef8, 0x1f11, 0x1f2a, 0x1f43, 0x1f5c, 0x1f75,
	0x1f8e, 0x1fa7, 0x1fc0, 0x1fd9, 0x1ff2, 0x200b, 0x2024, 0x203d,
	0x2056, 0x206f, 0x2088, 0x20a1, 0x20ba, 0x20d3, 0x20ec, 0x2105,
	0x211e, 0x213b, 0x2158, 0x2175, 0x2192, 0x21af, 0x21cc, 0x21e9,
	0x2206, 0x2223, 0x2240, 0x225d, 0x227a, 0x2297, 0x22b4, 0x22d1,
	0x22ee, 0x230b, 0x2328, 0x2345, 0x2362, 0x237f, 0x239c, 0x23b9,
	0x23d6, 0x23f3, 0x2410, 0x242b, 0x2446, 0x2461, 0x247c, 0x2497,
	// Entry 70C0 - 70FF
	0x24b2, 0x24cd, 0x24e8, 0x2503, 0x251e, 0x2539, 0x2554, 0x256f,
	0x258a, 0x25a5, 0x25c0, 0x25db, 0x25f6, 0x2611, 0x262c, 0x2647,
	0x2662, 0x267d, 0x2698, 0x26b3, 0x26d5, 0x26f7, 0x2719, 0x273b,
	0x275d, 0x277f, 0x27a1, 0x27c3, 0x27e5, 0x2807, 0x2829, 0x284b,
	0x286d, 0x288f, 0x28b1, 0x28d3, 0x28f5, 0x2917, 0x2939, 0x295b,
	0x297d, 0x299f, 0x29c1, 0x29e3, 0x2a05, 0x2a27, 0x2a47, 0x2a67,
	0x2a87, 0x2aa7, 0x2ac7, 0x2ae7, 0x2b07, 0x2b27, 0x2b47, 0x2b67,
	0x2b87, 0x2ba7, 0x2bc7, 0x2be7, 0x2c07, 0x2c27, 0x2c47, 0x2c67,
	// Entry 7100 - 713F
	0x2c87, 0x2ca7, 0x2cc7, 0x2ce7, 0x2d07, 0x2d27, 0x2d47, 0x2d67,
	0x2d84, 0x2da1, 0x2dbe, 0x2ddb, 0x2df8, 0x2e15, 0x2e32, 0x2e4f,
	0x2e6c, 0x2e89, 0x2ea6, 0x2ec3, 0x2ee0, 0x2efd, 0x2f1a, 0x2f37,
	0x2f54, 0x2f71, 0x2f8c, 0x2fa7, 0x2fc2, 0x2fdd, 0x2ff8, 0x3013,
	0x302e, 0x3049, 0x3064, 0x307f, 0x309a, 0x30b5, 0x30d0, 0x30eb,
	0x3106, 0x3121, 0x313c, 0x3157, 0x3172, 0x318d, 0x31a8, 0x31c3,
	0x31de, 0x3200, 0x3222, 0x3244, 0x3266, 0x3288, 0x32aa, 0x32cc,
	0x32ee, 0x3310, 0x3332, 0x3354, 0x3376, 0x3398, 0x33ba, 0x33dc,
	// Entry 7140 - 717F
	0x33fe, 0x3420, 0x3442, 0x3464, 0x3486, 0x34a8, 0x34ca, 0x34ec,
	0x350e, 0x3530, 0x3552, 0x3572, 0x3592, 0x35b2, 0x35d2, 0x35f2,
	0x3612, 0x3632, 0x3652, 0x3672, 0x3692, 0x36b2, 0x36d2, 0x36f2,
	0x3712, 0x3732, 0x3752, 0x3772, 0x3792, 0x37b2, 0x37d2, 0x37f2,
	0x3812, 0x3832, 0x3852, 0x3872, 0x3892, 0x38b0, 0x38ce, 0x38ec,
	0x390a, 0x3928, 0x3946, 0x3964, 0x3982, 0x39a0, 0x39be, 0x39dc,
	0x39fa, 0x3a18, 0x3a36, 0x3a54, 0x3a72, 0x3a90, 0x3aae, 0x3acc,
	0x3aea, 0x3b08, 0x3b24, 0x3b40, 0x3b5c, 0x3b78, 0x3b94, 0x3bb0,
	// Entry 7180 - 71BF
	0x3bcc, 0x3be8, 0x3c04, 0x3c20, 0x3c3c, 0x3c58, 0x3c74, 0x3c90,
	0x3cac, 0x3cc8, 0x3ce4, 0x3d00, 0x3d1c, 0x3d38, 0x3d54, 0x3d70,
	0x3d8c, 0x3da8, 0x3dc4, 0x3de0, 0x3e04, 0x3e28, 0x3e4c, 0x3e70,
	0x3e94, 0x3eb8, 0x3edc, 0x3f00, 0x3f24, 0x3f48, 0x3f6c, 0x3f90,
	0x3fb4, 0x3fd8, 0x3ffc, 0x4020, 0x4044, 0x4068, 0x408c, 0x40ae,
	0x40d0, 0x40f2, 0x4114, 0x4136, 0x4158, 0x417a, 0x419c, 0x41be,
	0x41e0, 0x4202, 0x4224, 0x4246, 0x4268, 0x428a, 0x42ac, 0x42ce,
	0x42f0, 0x4312, 0x4334, 0x4356, 0x4378, 0x439a, 0x43bc, 0x43de,
	// Entry 71C0 - 71FF
	0x4400, 0x4423, 0x4446, 0x4469, 0x448c, 0x44af, 0x44d2, 0x44f5,
	0x4518, 0x453b, 0x455e, 0x4581, 0x45a4, 0x45c7, 0x45ea, 0x460d,
	0x4630, 0x4653, 0x4676, 0x4699, 0x46bc, 0x46df, 0x4702, 0x4725,
	0x4748, 0x476b, 0x478e, 0x47af, 0x47d0, 0x47f1, 0x4812, 0x4833,
	0x4854, 0x4875, 0x4896, 0x48b7, 0x48d8, 0x48f9, 0x491a, 0x493b,
	0x495c, 0x497d, 0x499e, 0x49bf, 0x49e0, 0x4a01, 0x4a22, 0x4a43,
	0x4a64, 0x4a85, 0x4aa6, 0x4ac7, 0x4ae8, 0x4b09, 0x4b2a, 0x4b4b,
	0x4b6c, 0x4b8d, 0x4bae, 0x4bcf, 0x4bf0, 0x4c11, 0x4c32, 0x4c53,
	// Entry 7200 - 723F
	0x4c74, 0x4c95, 0x4cb6, 0x4cd7, 0x4cf8, 0x4d19, 0x4d3a, 0x4d5b,
	0x4d7c, 0x4d9d, 0x4dbe, 0x4ddf, 0x4e00, 0x4e21, 0x4e42, 0x4e61,
	0x4e80, 0x4e9f, 0x4ebe, 0x4edd, 0x4efc, 0x4f1b, 0x4f3a, 0x4f59,
	0x4f78, 0x4f97, 0x4fb6, 0x4fd5, 0x4ff4, 0x5013, 0x5032, 0x5051,
	0x5070, 0x508f, 0x50ae, 0x50cd, 0x50ec, 0x510b, 0x512a, 0x5149,
	0x5168, 0x518e, 0x51b4, 0x51da, 0x5200, 0x5226, 0x524c, 0x5272,
	0x5298, 0x52be, 0x52e4, 0x530a, 0x5330, 0x5356, 0x537c, 0x53a2,
	0x53c8, 0x53ee, 0x5414, 0x543a, 0x5460, 0x5486, 0x54ac, 0x54d2,
	// Entry 7240 - 727F
	0x54f8, 0x551e, 0x5544, 0x5568, 0x558c, 0x55b0, 0x55d4, 0x55f8,
	0x561c, 0x5640, 0x5664, 0x5688, 0x56ac, 0x56d0, 0x56f4, 0x5718,
	0x573c, 0x5760, 0x5784, 0x57a8, 0x57cc, 0x57f0, 0x5814, 0x5838,
	0x585c, 0x5880, 0x58a4, 0x58c8, 0x58ec, 0x5914, 0x593c, 0x5964,
	0x598c, 0x59b4, 0x59dc, 0x5a04, 0x5a2c, 0x5a54, 0x5a7c, 0x5aa4,
	0x5acc, 0x5af4, 0x5b1c, 0x5b44, 0x5b6c, 0x5b94, 0x5bbc, 0x5be4,
	0x5c0c, 0x5c34, 0x5c5c, 0x5c84, 0x5cac, 0x5cd4, 0x5cfc, 0x5d22,
	0x5d48, 0x5d6e, 0x5d94, 0x5dba, 0x5de0, 0x5e06, 0x5e2c, 0x5e52,
	// Entry 7280 - 72BF
	0x5e78, 0x5e9e, 0x5ec4, 0x5eea, 0x5f10, 0x5f36, 0x5f5c, 0x5f82,
	0x5fa8, 0x5fce, 0x5ff4, 0x601a, 0x6040, 0x6066, 0x608c, 0x60b2,
	0x60d8, 0x6105, 0x6132, 0x615f, 0x618c, 0x61b9, 0x61e6, 0x6213,
	0x6240, 0x626d, 0x629a, 0x62c7, 0x62f4, 0x6321, 0x634e, 0x637b,
	0x63a8, 0x63d5, 0x6402, 0x642f, 0x645c, 0x6489, 0x64b6, 0x64e3,
	0x6510, 0x653d, 0x656a, 0x6595, 0x65c0, 0x65eb, 0x6616, 0x6641,
	0x666c, 0x6697, 0x66c2, 0x66ed, 0x6718, 0x6743, 0x676e, 0x6799,
	0x67c4, 0x67ef, 0x681a, 0x6845, 0x6870, 0x689b, 0x68c6, 0x68f1,
	// Entry 72C0 - 72FF
	0x691c, 0x6947, 0x6972, 0x699d, 0x69c8, 0x69e8, 0x6a08, 0x6a28,
	0x6a48, 0x6a68, 0x6a88, 0x6aa8, 0x6ac8, 0x6ae8, 0x6b08, 0x6b28,
	0x6b48, 0x6b68, 0x6b88, 0x6ba8, 0x6bc8, 0x6be8, 0x6c08, 0x6c28,
	0x6c48, 0x6c68, 0x6c88, 0x6ca8, 0x6cc8, 0x6ce8, 0x6d08, 0x6d26,
	0x6d44, 0x6d62, 0x6d80, 0x6d9e, 0x6dbc, 0x6dda, 0x6df8, 0x6e16,
	0x6e34, 0x6e52, 0x6e70, 0x6e8e, 0x6eac, 0x6eca, 0x6ee8, 0x6f06,
	0x6f24, 0x6f42, 0x6f60, 0x6f7e, 0x6f9c, 0x6fba, 0x6fd8, 0x6ff6,
	0x7014, 0x7037, 0x705a, 0x7079, 0x7097, 0x70b6, 0x70d5, 0x70f6,
	// Entry 7300 - 733F
	0x7114, 0x7131, 0x7150, 0x716e, 0x718d, 0x71ac, 0x71c8, 0x71e4,
	0x7200, 0x7221, 0x723d, 0x725a, 0x7280, 0x729f, 0x72bc, 0x72dd,
	0x72fa, 0x7317, 0x7334, 0x7353, 0x736a, 0x7387, 0x73a3, 0x73c0,
	0x73dd, 0x73fc, 0x7418, 0x7433, 0x7450, 0x746c, 0x7489, 0x74a6,
	0x74c0, 0x74da, 0x74f4, 0x7513, 0x752d, 0x7548, 0x756b, 0x7588,
	0x75a3, 0x75c2, 0x75dd, 0x75f8, 0x7613, 0x7630, 0x7656, 0x7676,
	0x7694, 0x76b2, 0x76ce, 0x76ea, 0x7705, 0x7726, 0x7746, 0x7767,
	0x7788, 0x77ab, 0x77cb, 0x77ea, 0x780b, 0x782b, 0x784c, 0x786d,
	// Entry 7340 - 737F
	0x788b, 0x78a9, 0x78c7, 0x78ea, 0x7908, 0x7927, 0x794f, 0x7970,
	0x798f, 0x79b2, 0x79d1, 0x79f0, 0x7a0f, 0x7a30, 0x7a49, 0x7a68,
	0x7a86, 0x7aa5, 0x7ac4, 0x7ae5, 0x7b03, 0x7b20, 0x7b3f, 0x7b5d,
	0x7b7c, 0x7b9b, 0x7bb7, 0x7bd3, 0x7bef, 0x7c10, 0x7c2c, 0x7c49,
	0x7c6e, 0x7c8d, 0x7caa, 0x7ccb, 0x7ce8, 0x7d05, 0x7d22, 0x7d41,
	0x7d69, 0x7d8b, 0x7dab, 0x7dcb, 0x7de9, 0x7e07, 0x7e24, 0x7e4a,
	0x7e6f, 0x7e95, 0x7ebb, 0x7ee3, 0x7f08, 0x7f2c, 0x7f52, 0x7f77,
	0x7f9d, 0x7fc3, 0x7fe6, 0x8009, 0x802c, 0x8054, 0x8077, 0x809b,
	// Entry 7380 - 73BF
	0x80c8, 0x80ee, 0x8112, 0x813a, 0x815e, 0x8182, 0x81a6, 0x81cc,
	0x81ea, 0x820e, 0x8231, 0x8255, 0x8279, 0x829f, 0x82c2, 0x82e4,
	0x8308, 0x832b, 0x834f, 0x8373, 0x8394, 0x83b5, 0x83d6, 0x83fc,
	0x841d, 0x843f, 0x8469, 0x848d, 0x84af, 0x84d5, 0x84f7, 0x8519,
	0x853b, 0x855f, 0x858c, 0x85b3, 0x85d8, 0x85fd, 0x8620, 0x8643,
	0x8665, 0x868f, 0x86b8, 0x86e2, 0x870c, 0x8738, 0x8761, 0x8789,
	0x87b3, 0x87dc, 0x8806, 0x8830, 0x8857, 0x887e, 0x88a5, 0x88d1,
	0x88f8, 0x8920, 0x8951, 0x897b, 0x89a3, 0x89cf, 0x89f7, 0x8a1f,
	// Entry 73C0 - 73FF
	0x8a47, 0x8a71, 0x8a93, 0x8abb, 0x8ae2, 0x8b0a, 0x8b32, 0x8b5c,
	0x8b83, 0x8ba9, 0x8bd1, 0x8bf8, 0x8c20, 0x8c48, 0x8c6d, 0x8c92,
	0x8cb7, 0x8ce1, 0x8d06, 0x8d2c, 0x8d5a, 0x8d82, 0x8da8, 0x8dd2,
	0x8df8, 0x8e1e, 0x8e44, 0x8e6c, 0x8e9d, 0x8ec8, 0x8ef1, 0x8f1a,
	0x8f41, 0x8f68, 0x8f8e, 0x8fbf, 0x8fef, 0x9020, 0x9051, 0x9084,
	0x90b4, 0x90e3, 0x9114, 0x9144, 0x9175, 0x91a6, 0x91d4, 0x9202,
	0x9230, 0x9263, 0x9291, 0x92c0, 0x92f8, 0x9329, 0x9358, 0x938b,
	0x93ba, 0x93e9, 0x9418, 0x9449, 0x9472, 0x94a1, 0x94cf, 0x94fe,
	// Entry 7400 - 743F
	0x952d, 0x955e, 0x958c, 0x95b9, 0x95e8, 0x9616, 0x9645, 0x9674,
	0x96a0, 0x96cc, 0x96f8, 0x9729, 0x9755, 0x9782, 0x97b7, 0x97e6,
	0x9813, 0x9844, 0x9871, 0x989e, 0x98cb, 0x98fa, 0x9932, 0x9964,
	0x9994, 0x99c4, 0x99f2, 0x9a20, 0x9a4d, 0x9a6e, 0x9a8d, 0x9aa9,
	0x9ac4, 0x9adf, 0x9afc, 0x9b18, 0x9b34, 0x9b4f, 0x9b6c, 0x9b89,
	0x9ba5, 0x9bca, 0x9bee, 0x9c12, 0x9c38, 0x9c5d, 0x9c82, 0x9ca6,
	0x9ccc, 0x9cf2, 0x9d17, 0x9d39, 0x9d5a, 0x9d7b, 0x9d9e, 0x9dc0,
	0x9de2, 0x9e03, 0x9e26, 0x9e49, 0x9e6b, 0x9e92, 0x9eb8, 0x9ede,
	// Entry 7440 - 747F
	0x9f06, 0x9f2d, 0x9f54, 0x9f7a, 0x9fa2, 0x9fca, 0x9ff1, 0xa012,
	0xa032, 0xa052, 0xa074, 0xa095, 0xa0b6, 0xa0d6, 0xa0f8, 0xa11a,
	0xa13b, 0xa156, 0xa173, 0xa18d, 0xa1a8, 0xa1c4, 0xa1e0, 0xa200,
	0xa222, 0xa24e, 0xa278, 0xa29a, 0xa2bc, 0xa2e2, 0xa305, 0xa327,
	0xa34b, 0xa372, 0xa3a4, 0xa3cd, 0xa3f9, 0xa425, 0xa451, 0xa488,
	0xa4c0, 0xa4f3, 0xa526, 0xa550, 0xa57c, 0xa5a8, 0xa5d4, 0xa5fc,
	0xa626, 0xa65c, 0xa692, 0xa6bf, 0xa6fa, 0xa731, 0xa76d, 0xa7a4,
	0xa7de, 0xa80d, 0xa83d, 0xa86c, 0xa89b, 0xa8d4, 0xa90b, 0xa94c,
	// Entry 7480 - 74BF
	0xa988, 0xa9ba, 0xa9ec, 0xaa2a, 0xaa5f, 0xaa99, 0xaada, 0xab0c,
	0xab3e, 0xab71, 0xaba8, 0xabde, 0xac13, 0xac46, 0xac7f, 0xacb2,
	0xace1, 0xad17, 0xad52, 0xad84, 0xadba, 0xaddc, 0xae03, 0xae2c,
	0xae58, 0xae8a, 0xaeb6, 0xaee7, 0xaf14, 0xaf3d, 0xaf6b, 0xaf9e,
	0xafd6, 0xb004, 0xb037, 0xb06e, 0xb096, 0xb0c3, 0xb0f2, 0xb11b,
	0xb14b, 0xb186, 0xb1bf, 0xb1d4, 0xb1fe, 0xb218, 0xb238, 0xb25d,
	0xb27d, 0xb2a0, 0xb2cc, 0xb2ee, 0xb31b, 0xb34d, 0xb36f, 0xb384,
	0xb3a4, 0xb3c2, 0xb3e5, 0xb403, 0xb418, 0xb431, 0xb445, 0xb469,
	// Entry 74C0 - 74FF
	0xb488, 0xb4aa, 0xb4c7, 0xb4ee, 0xb510, 0xb52e, 0xb547, 0xb55e,
	0xb573, 0xb593, 0xb5b1, 0xb5d4, 0xb5ef, 0xb618, 0xb62e, 0xb64a,
	0xb670, 0xb691, 0xb6b5, 0xb6d4, 0xb704, 0xb734, 0xb74a, 0xb771,
	0xb79a, 0xb7c2, 0xb7ea, 0xb807, 0xb833, 0xb864, 0xb896, 0xb8b7,
	0xb8e8, 0xb917, 0xb947, 0xb966, 0xb991, 0xb9b2, 0xb9d1, 0xb9f1,
	0xba1c, 0xba3d, 0xba67, 0xba89, 0xbaac, 0xbad4, 0xbafd, 0xbb36,
	0xbb6b, 0xbb8d, 0xbbb1, 0xbbd4, 0xbbf7, 0xbc20, 0xbc4b, 0xbc75,
	0xbc90, 0xbcba, 0xbce9, 0xbd1a, 0xbd39, 0xbd71, 0xbdaa, 0xbdc7,
	// Entry 7500 - 753F
	0xbdf0, 0xbe11, 0xbe34, 0xbe55, 0xbe77, 0xbe98, 0xbec3, 0xbef4,
	0xbf14, 0xbf34, 0xbf54, 0xbf7b, 0xbfa4, 0xbfd2, 0xbffd, 0xc027,
	0xc054, 0xc07a, 0xc0a2, 0xc0ce, 0xc0f6, 0xc117, 0xc134, 0xc153,
	0xc174, 0xc19f, 0xc1c9, 0xc1eb, 0xc214, 0xc237, 0xc25f, 0xc289,
	0xc2b8, 0xc2df, 0xc308, 0xc335, 0xc361, 0xc38a, 0xc3b9, 0xc3eb,
	0xc422, 0xc458, 0xc48d, 0xc4bf, 0xc4e2, 0xc508, 0xc52f, 0xc564,
	0xc59a, 0xc5cb, 0xc5fc, 0xc62c, 0xc65e, 0xc696, 0xc6ca, 0xc6f0,
	0xc71a, 0xc74e, 0xc782, 0xc7b5, 0xc7dd, 0xc7fd, 0xc822, 0xc849,
	// Entry 7540 - 757F
	0xc871, 0xc893, 0xc8bb, 0xc8e1, 0xc906, 0xc928, 0xc943, 0xc963,
	0xc98c, 0xc9b6, 0xc9db, 0xc9fe, 0xca2e, 0xca5d, 0xca8c, 0xcab9,
	0xcae5, 0xcb14, 0xcb42, 0xcb77, 0xcb8c, 0xcba6, 0xcbbe, 0xcbd8,
	0xcbf1, 0xcc09, 0xcc23, 0xcc3c, 0xcc55, 0xcc70, 0xcc8a, 0xcca2,
	0xccbc, 0xccd5, 0xcceb, 0xcd03, 0xcd1a, 0xcd35, 0xcd50, 0xcd70,
	0xcd90, 0xcdb2, 0xcdd4, 0xcdf2, 0xce10, 0xce2e, 0xce4e, 0xce6e,
	0xce8a, 0xceaf, 0xced7, 0xceff, 0xcf27, 0xcf51, 0xcf85, 0xcfb9,
	0xcfe9, 0xd016, 0xd044, 0xd078, 0xd0ad, 0xd0e1, 0xd117, 0xd147,
	// Entry 7580 - 75BF
	0xd175, 0xd1a5, 0xd1d6, 0xd212, 0xd236, 0xd26d, 0xd29d, 0xd2ce,
	0xd30a, 0xd333, 0xd35d, 0xd386, 0xd3b1, 0xd3dd, 0xd408, 0xd436,
	0xd460, 0xd48b, 0xd4b5, 0xd4dd, 0xd506, 0xd52e, 0xd559, 0xd585,
	0xd5b0, 0xd5da, 0xd605, 0xd62f, 0xd665, 0xd69b, 0xd6d6, 0xd70d,
	0xd744, 0xd780, 0xd7a4, 0xd7d2, 0xd800, 0xd82e, 0xd856, 0xd87f,
	0xd8a7, 0xd8d1, 0xd8fc, 0xd928, 0xd953, 0xd980, 0xd9b0, 0xd9e1,
	0xda11, 0xda43, 0xda76, 0xdaaa, 0xdadd, 0xdb12, 0xdb47, 0xdb7d,
	0xdbb2, 0xdbe9, 0xdc1a, 0xdc49, 0xdc7a, 0xdcac, 0xdce9, 0xdd0e,
	// Entry 75C0 - 75FF
	0xdd46, 0xdd77, 0xddb2, 0xddef, 0xde13, 0xde3f, 0xde6c, 0xde98,
	0xdebd, 0xdee6, 0xdf10, 0xdf39, 0xdf65, 0xdf92, 0xdfbe, 0xdfe9,
	0xe015, 0xe040, 0xe078, 0xe0b0, 0xe0ed, 0xe124, 0xe15b, 0xe197,
	0xe1bc, 0xe1ee, 0xe221, 0xe253, 0xe287, 0xe2bd, 0xe2f4, 0xe32a,
	0xe362, 0xe3a1, 0xe3e1, 0xe40a, 0xe434, 0xe45d, 0xe486, 0xe4b0,
	0xe4d9, 0xe509, 0xe53f, 0xe576, 0xe5ac, 0xe5e2, 0xe619, 0xe64f,
	0xe681, 0xe6b2, 0xe6e4, 0xe709, 0xe72e, 0xe756, 0xe77c, 0xe7b3,
	0xe7e9, 0xe81f, 0xe855, 0xe88d, 0xe8c5, 0xe902, 0xe934, 0xe965,
	// Entry 7600 - 763F
	0xe996, 0xe9c7, 0xe9fa, 0xea2d, 0xea65, 0xea9c, 0xead4, 0xeb0b,
	0xeb46, 0xeb81, 0xebc2, 0xec03, 0xec44, 0xec85, 0xecc6, 0xed07,
	0xed48, 0xed89, 0xedc3, 0xedfd, 0xee33, 0xee69, 0xeea4, 0xeedd,
	0xef16, 0xef55, 0xef94, 0xefda, 0xf020, 0xf05f, 0xf09e, 0xf0dd,
	0xf11c, 0xf154, 0xf18c, 0xf1c0, 0xf1f4, 0xf22d, 0xf258, 0xf284,
	0xf2af, 0xf2dc, 0xf30a, 0xf334, 0xf35e, 0xf388, 0xf3b2, 0xf3dc,
	0xf402, 0xf428, 0xf453, 0xf483, 0xf4b9, 0xf4f0, 0xf526, 0xf55d,
	0xf5a1, 0xf5e6, 0xf62a, 0xf66e, 0xf6b3, 0xf6f7, 0xf72f, 0xf767,
	// Entry 7640 - 767F
	0xf7a7, 0xf7e7, 0xf81b, 0xf84f, 0xf891, 0xf8d3, 0xf8f6, 0xf919,
	0xf931, 0xf949, 0xf962, 0xf97d, 0xf99d, 0xf9c9, 0xf9ed, 0xfa08,
	0xfa18, 0xfa2c, 0xfa58, 0xfa80, 0xfaad, 0xfad6, 0xfb00, 0xfb20,
	0xfb58, 0xfb8b, 0xfbc6, 0xfbe6, 0xfc0b, 0xfc2d, 0xfc55, 0xfc7d,
	0xfca3, 0xfcc9, 0xfce5, 0xfd01, 0xfd1e, 0xfd33, 0xfd4c, 0xfd63,
	0xfd7f, 0xfd9d, 0xfdb7, 0xfdd1, 0xfded, 0xfe0f, 0xfe23, 0xfe3b,
	0xfe55, 0xfe75, 0xfe9b, 0xfec8, 0xfefa, 0xff21, 0xff4f, 0xff82,
	0xffa6, 0xffcb, 0xfff1, 0x000a, 0x0024, 0x003d, 0x005a, 0x0079,
	// Entry 7680 - 76BF
	0x0095, 0x00a5, 0x00bd, 0x00d5, 0x00ee, 0x0106, 0x0121, 0x013b,
	0x015f, 0x0183, 0x019c, 0x01b5, 0x01d5, 0x01f5, 0x0215, 0x022c,
	0x024c, 0x0268, 0x027f, 0x029f, 0x02bb, 0x02d8, 0x02f6, 0x0315,
	0x0330, 0x0354, 0x0374, 0x0394, 0x03bd, 0x03e2, 0x03f8, 0x0416,
	0x0435, 0x044c, 0x046b, 0x0489, 0x04aa, 0x04ca, 0x04ea, 0x0503,
	0x0524, 0x0545, 0x0568, 0x0587, 0x05aa, 0x05d6, 0x05fd, 0x0623,
	0x0649, 0x066f, 0x0680, 0x069a, 0x06b5, 0x06d9, 0x06f2, 0x0714,
	0x072f, 0x0751, 0x0774, 0x0784, 0x0794, 0x07aa, 0x07c8, 0x07ea,
	// Entry 76C0 - 76FF
	0x0811, 0x0839, 0x0860, 0x088c, 0x08b3, 0x08d8, 0x0906, 0x0922,
	0x093b, 0x0954, 0x096d, 0x0986, 0x099f, 0x09b8, 0x09d1, 0x09e3,
	0x0a07, 0x0a2c, 0x0a47, 0x0a61, 0x0a7b, 0x0a99, 0x0ab3, 0x0ad4,
	0x0ae5, 0x0afa, 0x0b0f, 0x0b20, 0x0b37, 0x0b52, 0x0b6d, 0x0b88,
	0x0ba3, 0x0bbe, 0x0bdd, 0x0bfc, 0x0c1b, 0x0c3a, 0x0c59, 0x0c78,
	0x0c97, 0x0cb6, 0x0cd6, 0x0cf6, 0x0d16, 0x0d36, 0x0d56, 0x0d76,
	0x0d96, 0x0dc0, 0x0de4, 0x0e07, 0x0e24, 0x0e4a, 0x0e75, 0x0e9a,
	0x0eb9, 0x0ef5, 0x0f26, 0x0f56, 0x0f7c, 0x0fab, 0x0fd0, 0x0ffc,
	// Entry 7700 - 773F
	0x101e, 0x1041, 0x1063, 0x1094, 0x10c3, 0x10eb, 0x1118, 0x114b,
	0x117c, 0x11a4, 0x11d7, 0x120a, 0x1232, 0x1265, 0x128d, 0x12ab,
	0x12d9, 0x1307, 0x1335, 0x1363, 0x1391, 0x13bf, 0x13de, 0x13fe,
	0x141e, 0x1441, 0x1462, 0x1483, 0x14a6, 0x14c8, 0x14e8, 0x1510,
	0x152d, 0x154f, 0x156f, 0x1592, 0x15b5, 0x15d6, 0x15f5, 0x1617,
	0x1638, 0x1659, 0x167b, 0x169a, 0x16bb, 0x16db, 0x16fb, 0x171a,
	0x173c, 0x175b, 0x177b, 0x179b, 0x17bb, 0x17d9, 0x17fe, 0x181c,
	0x1849, 0x186c, 0x1897, 0x18b7, 0x18d7, 0x18f8, 0x1919, 0x193b,
	// Entry 7740 - 777F
	0x195c, 0x197d, 0x199f, 0x19c0, 0x19e0, 0x1a01, 0x1a22, 0x1a43,
	0x1a63, 0x1a84, 0x1aa5, 0x1ac6, 0x1ae7, 0x1b07, 0x1b28, 0x1b49,
	0x1b6b, 0x1b8d, 0x1baf, 0x1bd2, 0x1bf2, 0x1c13, 0x1c36, 0x1c5a,
	0x1c91, 0x1cb2, 0x1cd9, 0x1d02, 0x1d29, 0x1d4a, 0x1d6c, 0x1d8e,
	0x1db1, 0x1dd3, 0x1df5, 0x1e18, 0x1e3a, 0x1e5b, 0x1e7d, 0x1e9f,
	0x1ec0, 0x1ee2, 0x1f04, 0x1f25, 0x1f47, 0x1f69, 0x1f8c, 0x1faf,
	0x1fd2, 0x1ffb, 0x201f, 0x204e, 0x2086, 0x20a9, 0x20cd, 0x20fd,
	0x212e, 0x2163, 0x219b, 0x21bb, 0x21dc, 0x21fd, 0x221d, 0x223d,
	// Entry 7780 - 77BF
	0x225d, 0x227d, 0x229e, 0x22be, 0x22de, 0x22fe, 0x231e, 0x233f,
	0x2361, 0x2381, 0x23a1, 0x23c2, 0x23e3, 0x2403, 0x2425, 0x2446,
	0x2466, 0x2486, 0x24a6, 0x24c6, 0x24e7, 0x2507, 0x2528, 0x2549,
	0x256a, 0x258c, 0x25ad, 0x25ce, 0x25ef, 0x260f, 0x2630, 0x264f,
	0x266f, 0x268e, 0x26ad, 0x26cc, 0x26ec, 0x270b, 0x272b, 0x274a,
	0x2767, 0x2784, 0x27a1, 0x27be, 0x27db, 0x27f8, 0x2815, 0x283b,
	0x2860, 0x2888, 0x28ae, 0x28da, 0x28fb, 0x2925, 0x2946, 0x2966,
	0x2986, 0x29a8, 0x29c9, 0x29ea, 0x2a0a, 0x2a2c, 0x2a4e, 0x2a6f,
	// Entry 77C0 - 77FF
	0x2a93, 0x2ab4, 0x2ac2, 0x2ad0, 0x2ade, 0x2aec, 0x2afa, 0x2b08,
	0x2b16, 0x2b24, 0x2b33, 0x2b41, 0x2b50, 0x2b5e, 0x2b6c, 0x2b7a,
	0x2b88, 0x2b96, 0x2ba4, 0x2bb1, 0x2bc6, 0x2bd4, 0x2bea, 0x2bf7,
	0x2c04, 0x2c19, 0x2c27, 0x2c3d, 0x2c4a, 0x2c58, 0x2c6e, 0x2c7b,
	0x2c90, 0x2ca0, 0x2caf, 0x2cbf, 0x2ccf, 0x2cdf, 0x2cef, 0x2cff,
	0x2d10, 0x2d20, 0x2d30, 0x2d40, 0x2d50, 0x2d61, 0x2d71, 0x2d81,
	0x2d92, 0x2da2, 0x2db2, 0x2dc2, 0x2dd2, 0x2de2, 0x2df1, 0x2e01,
	0x2e11, 0x2e21, 0x2e32, 0x2e42, 0x2e51, 0x2e60, 0x2e71, 0x2e80,
	// Entry 7800 - 783F
	0x2e92, 0x2ea3, 0x2eb4, 0x2ec5, 0x2ed7, 0x2ee8, 0x2ef9, 0x2f09,
	0x2f19, 0x2f2a, 0x2f3b, 0x2f4c, 0x2f5d, 0x2f6c, 0x2f7d, 0x2f8c,
	0x2f9d, 0x2fae, 0x2fbe, 0x2fce, 0x2fe0, 0x2ff1, 0x3002, 0x3012,
	0x3024, 0x3036, 0x3047, 0x3057, 0x306b, 0x3080, 0x3095, 0x30aa,
	0x30c0, 0x30d4, 0x30e9, 0x30fe, 0x3114, 0x3129, 0x313d, 0x3152,
	0x3168, 0x317d, 0x3192, 0x31a6, 0x31bb, 0x31d0, 0x31e5, 0x31fa,
	0x320e, 0x3224, 0x3239, 0x324e, 0x3263, 0x3279, 0x328f, 0x32a4,
	0x32ba, 0x32d0, 0x32e5, 0x32fb, 0x3311, 0x3326, 0x333b, 0x3352,
	// Entry 7840 - 787F
	0x3368, 0x337e, 0x3393, 0x33aa, 0x33c1, 0x33d7, 0x33ed, 0x3403,
	0x3419, 0x3430, 0x3447, 0x345d, 0x3473, 0x3490, 0x34a6, 0x34bd,
	0x34d3, 0x34ef, 0x350c, 0x3528, 0x3545, 0x3561, 0x357d, 0x359a,
	0x35b6, 0x35d3, 0x35ef, 0x360b, 0x3628, 0x3644, 0x3660, 0x367d,
	0x3699, 0x36b6, 0x36d4, 0x36f2, 0x3710, 0x372f, 0x374d, 0x376c,
	0x378a, 0x37a9, 0x37c7, 0x37e5, 0x3803, 0x3822, 0x3840, 0x385f,
	0x387d, 0x389c, 0x38bb, 0x38da, 0x38f9, 0x3918, 0x3937, 0x3956,
	0x3975, 0x3994, 0x39b3, 0x39d3, 0x39f3, 0x3a11, 0x3a2f, 0x3a4d,
	// Entry 7880 - 78BF
	0x3a6c, 0x3a8a, 0x3aa9, 0x3ac7, 0x3ae4, 0x3b01, 0x3b1e, 0x3b3c,
	0x3b59, 0x3b77, 0x3b94, 0x3bb2, 0x3bd0, 0x3bee, 0x3c0c, 0x3c2a,
	0x3c48, 0x3c66, 0x3c84, 0x3ca3, 0x3cc1, 0x3ce0, 0x3cfe, 0x3d1d,
	0x3d3b, 0x3d59, 0x3d77, 0x3d96, 0x3db4, 0x3dd3, 0x3df1, 0x3e14,
	0x3e32, 0x3e50, 0x3e6e, 0x3e8d, 0x3eac, 0x3eca, 0x3ee8, 0x3f06,
	0x3f24, 0x3f43, 0x3f61, 0x3f80, 0x3f9e, 0x3fbc, 0x3fda, 0x3ff8,
	0x4017, 0x4035, 0x4054, 0x4072, 0x4095, 0x40b3, 0x40d1, 0x40ef,
	0x410e, 0x412c, 0x414b, 0x4169, 0x4187, 0x41a5, 0x41c3, 0x41e2,
	// Entry 78C0 - 78FF
	0x4200, 0x421f, 0x423d, 0x425c, 0x427b, 0x429a, 0x42b9, 0x42d8,
	0x42f7, 0x4316, 0x4334, 0x4352, 0x4370, 0x438f, 0x43ad, 0x43cc,
	0x43ea, 0x440a, 0x442a, 0x4449, 0x4468, 0x4487, 0x44a6, 0x44c5,
	0x44e5, 0x4505, 0x4525, 0x4545, 0x4566, 0x4586, 0x45a7, 0x45c7,
	0x45e8, 0x4609, 0x462e, 0x4654, 0x4679, 0x4697, 0x46b5, 0x46d3,
	0x46f2, 0x4712, 0x4732, 0x4752, 0x4772, 0x4793, 0x47b1, 0x47cf,
	0x47ed, 0x480c, 0x482a, 0x4849, 0x4867, 0x4886, 0x48a5, 0x48c4,
	0x48e4, 0x4904, 0x4923, 0x4943, 0x4962, 0x4982, 0x49a6, 0x49cb,
	// Entry 7900 - 793F
	0x49ef, 0x4a0e, 0x4a2d, 0x4a4c, 0x4a6c, 0x4a8b, 0x4aab, 0x4aca,
	0x4ae9, 0x4b08, 0x4b27, 0x4b47, 0x4b66, 0x4b86, 0x4ba5, 0x4bc3,
	0x4be2, 0x4c01, 0x4c20, 0x4c40, 0x4c5f, 0x4c7f, 0x4c9e, 0x4cbd,
	0x4cdc, 0x4cfc, 0x4d1c, 0x4d3a, 0x4d58, 0x4d76, 0x4d95, 0x4db3,
	0x4dd2, 0x4df0, 0x4e10, 0x4e30, 0x4e50, 0x4e70, 0x4e90, 0x4ea7,
	0x4ebe, 0x4ed7, 0x4eef, 0x4f07, 0x4f1e, 0x4f37, 0x4f50, 0x4f68,
	0x4f8c, 0x4faf, 0x4fd6, 0x4ffe, 0x502a, 0x505a, 0x5081, 0x509a,
	0x50b4, 0x50cd, 0x50e6, 0x50fd, 0x511c, 0x5133, 0x514b, 0x5162,
	// Entry 7940 - 797F
	0x5178, 0x518f, 0x51a5, 0x51bb, 0x51d3, 0x51eb, 0x5203, 0x521b,
	0x5233, 0x524a, 0x5260, 0x5279, 0x5291, 0x52a8, 0x52c1, 0x52d8,
	0x52f0, 0x5307, 0x531f, 0x5336, 0x534e, 0x5366, 0x537e, 0x5396,
	0x53ae, 0x53c5, 0x53dd, 0x53f4, 0x540b, 0x5420, 0x543d, 0x5452,
	0x5468, 0x547d, 0x5491, 0x54a6, 0x54ba, 0x54ce, 0x54e4, 0x54fa,
	0x5510, 0x5526, 0x553c, 0x5551, 0x5565, 0x557c, 0x5592, 0x55a7,
	0x55be, 0x55d3, 0x55e9, 0x55fe, 0x5614, 0x5629, 0x563f, 0x5655,
	0x566b, 0x5681, 0x5697, 0x56ac, 0x56c2, 0x56d7, 0x56e2, 0x56fa,
	// Entry 7980 - 79BF
	0x571b, 0x5726, 0x573d, 0x574d, 0x575c, 0x576b, 0x577c, 0x578c,
	0x579c, 0x57ab, 0x57bc, 0x57cd, 0x57dd, 0x57fb, 0x5816, 0x582c,
	0x5842, 0x585a, 0x5871, 0x5888, 0x589e, 0x58b6, 0x58ce, 0x58e5,
	0x58fb, 0x5914, 0x592d, 0x5945, 0x595d, 0x5975, 0x598f, 0x59a8,
	0x59c1, 0x59df, 0x59fd, 0x5a1d, 0x5a3c, 0x5a5b, 0x5a79, 0x5a99,
	0x5ab9, 0x5ad8, 0x5af7, 0x5b16, 0x5b37, 0x5b57, 0x5b77, 0x5b96,
	0x5bb7, 0x5bd8, 0x5bf8, 0x5c17, 0x5c39, 0x5c5b, 0x5c7c, 0x5c9d,
	0x5cbe, 0x5ce1, 0x5d03, 0x5d25, 0x5d3c, 0x5d55, 0x5d6a, 0x5d82,
	// Entry 79C0 - 79FF
	0x5d9c, 0x5dbb, 0x5dda, 0x5dfb, 0x5e1b, 0x5e3b, 0x5e5a, 0x5e7b,
	0x5e9c, 0x5ebc, 0x5ed3, 0x5ef3, 0x5f10, 0x5f33, 0x5f49, 0x5f69,
	0x5f89, 0x5fb2, 0x5fd1, 0x5fe9, 0x6001, 0x601b, 0x6034, 0x604d,
	0x6065, 0x607f, 0x6099, 0x60b2, 0x60ca, 0x60e5, 0x6100, 0x611a,
	0x6134, 0x614e, 0x616a, 0x6185, 0x61a0, 0x61c0, 0x61e0, 0x6202,
	0x6223, 0x6244, 0x6264, 0x6286, 0x62a8, 0x62c9, 0x62ea, 0x630b,
	0x632e, 0x6350, 0x6372, 0x6393, 0x63b6, 0x63d9, 0x63fb, 0x641c,
	0x6440, 0x6464, 0x6487, 0x64aa, 0x64cd, 0x64f2, 0x6516, 0x653a,
	// Entry 7A00 - 7A3F
	0x6550, 0x6572, 0x6596, 0x65b9, 0x65dc, 0x65fe, 0x6622, 0x6646,
	0x6669, 0x668b, 0x66b6, 0x66e0, 0x670b, 0x6736, 0x6755, 0x6775,
	0x678d, 0x67a4, 0x67bc, 0x67d3, 0x67ea, 0x6802, 0x6819, 0x6830,
	0x6847, 0x685e, 0x6875, 0x688d, 0x68a5, 0x68bd, 0x68d4, 0x68eb,
	0x6902, 0x6919, 0x6930, 0x6949, 0x6960, 0x6978, 0x6990, 0x69a8,
	0x69bf, 0x69d6, 0x69ef, 0x6a0e, 0x6a2e, 0x6a4d, 0x6a6c, 0x6a8b,
	0x6aab, 0x6aca, 0x6ae9, 0x6b08, 0x6b27, 0x6b46, 0x6b66, 0x6b86,
	0x6ba6, 0x6bc5, 0x6be4, 0x6c03, 0x6c22, 0x6c43, 0x6c62, 0x6c82,
	// Entry 7A40 - 7A7F
	0x6ca2, 0x6cc1, 0x6ce2, 0x6d01, 0x6d1f, 0x6d3d, 0x6d5b, 0x6d7a,
	0x6d99, 0x6db7, 0x6dd5, 0x6df3, 0x6e13, 0x6e32, 0x6e50, 0x6e70,
	0x6e97, 0x6ebd, 0x6ede, 0x6f00, 0x6f21, 0x6f42, 0x6f63, 0x6f84,
	0x6fa5, 0x6fc7, 0x6fe9, 0x700b, 0x702c, 0x704d, 0x706e, 0x708f,
	0x70b2, 0x70d3, 0x70f5, 0x7117, 0x7138, 0x7159, 0x717c, 0x71a5,
	0x71ce, 0x71ed, 0x720b, 0x722a, 0x7248, 0x7266, 0x7284, 0x72a3,
	0x72c1, 0x72df, 0x72fd, 0x731b, 0x733a, 0x7359, 0x7378, 0x7396,
	0x73b4, 0x73d2, 0x73f0, 0x740e, 0x742e, 0x744c, 0x746b, 0x748a,
	// Entry 7A80 - 7ABF
	0x74a9, 0x74c7, 0x74e5, 0x7505, 0x752a, 0x7550, 0x7575, 0x759a,
	0x75c0, 0x75e5, 0x760a, 0x762f, 0x7654, 0x767a, 0x76a0, 0x76c6,
	0x76eb, 0x7710, 0x7735, 0x775a, 0x777f, 0x77a6, 0x77cb, 0x77f1,
	0x7817, 0x783d, 0x7862, 0x7887, 0x78ae, 0x78e5, 0x790e, 0x7924,
	0x793b, 0x7951, 0x7968, 0x797f, 0x7998, 0x79b1, 0x79cf, 0x79ed,
	0x7a0d, 0x7a2c, 0x7a4b, 0x7a69, 0x7a89, 0x7aa9, 0x7ac8, 0x7ae3,
	0x7afe, 0x7b1b, 0x7b37, 0x7b53, 0x7b6e, 0x7b8b, 0x7ba8, 0x7bc4,
	0x7bdf, 0x7bfa, 0x7c17, 0x7c33, 0x7c4f, 0x7c6a, 0x7c87, 0x7ca4,
	// Entry 7AC0 - 7AFF
	0x7cc0, 0x7cd1, 0x7ce4, 0x7cf7, 0x7d11, 0x7d24, 0x7d37, 0x7d4a,
	0x7d5d, 0x7d6f, 0x7d80, 0x7d9b, 0x7db7, 0x7dd3, 0x7def, 0x7e0b,
	0x7e27, 0x7e43, 0x7e5f, 0x7e7b, 0x7e97, 0x7eb3, 0x7ecf, 0x7eeb,
	0x7f07, 0x7f23, 0x7f3f, 0x7f5b, 0x7f77, 0x7f93, 0x7faf, 0x7fcb,
	0x7fe7, 0x8003, 0x801f, 0x803b, 0x8057, 0x8073, 0x808f, 0x80ab,
	0x80c7, 0x80e3, 0x80ff, 0x811b, 0x8137, 0x8153, 0x816f, 0x818b,
	0x81a7, 0x81c3, 0x81df, 0x81fb, 0x8217, 0x8233, 0x824f, 0x826b,
	0x8287, 0x82a3, 0x82bf, 0x82db, 0x82f7, 0x8310, 0x832a, 0x8344,
	// Entry 7B00 - 7B3F
	0x835e, 0x8378, 0x8392, 0x83ac, 0x83c6, 0x83e0, 0x83fa, 0x8414,
	0x842e, 0x8448, 0x8462, 0x847c, 0x8496, 0x84b0, 0x84ca, 0x84e4,
	0x84fe, 0x8518, 0x8532, 0x854c, 0x8566, 0x8580, 0x859a, 0x85b4,
	0x85ce, 0x85e8, 0x8602, 0x861c, 0x8636, 0x8650, 0x866a, 0x8684,
	0x869e, 0x86b8, 0x86d2, 0x86ec, 0x8706, 0x8720, 0x873a, 0x8754,
	0x876e, 0x8788, 0x87a2, 0x87bc, 0x87d6, 0x87f0, 0x880a, 0x881b,
	0x8835, 0x884f, 0x886b, 0x8886, 0x88a1, 0x88bb, 0x88d7, 0x88f3,
	0x890e, 0x8928, 0x8943, 0x8960, 0x897c, 0x8997, 0x89b1, 0x89cb,
	// Entry 7B40 - 7B7F
	0x89e7, 0x8a02, 0x8a1d, 0x8a37, 0x8a53, 0x8a6f, 0x8a8a, 0x8aa4,
	0x8abf, 0x8adc, 0x8af8, 0x8b13, 0x8b29, 0x8b45, 0x8b61, 0x8b7f,
	0x8b9c, 0x8bb9, 0x8bd5, 0x8bf3, 0x8c11, 0x8c2e, 0x8c4a, 0x8c67,
	0x8c86, 0x8ca4, 0x8cc1, 0x8cd9, 0x8cf2, 0x8d0b, 0x8d26, 0x8d40,
	0x8d5a, 0x8d73, 0x8d8e, 0x8da9, 0x8dc3, 0x8ddc, 0x8df6, 0x8e12,
	0x8e2d, 0x8e47, 0x8e5f, 0x8e70, 0x8e84, 0x8e98, 0x8eac, 0x8ec0,
	0x8ed4, 0x8ee8, 0x8efc, 0x8f10, 0x8f24, 0x8f39, 0x8f4e, 0x8f63,
	0x8f78, 0x8f8d, 0x8fa2, 0x8fb7, 0x8fcc, 0x8fe1, 0x8ff6, 0x900b,
	// Entry 7B80 - 7BBF
	0x9020, 0x9034, 0x9044, 0x9053, 0x9062, 0x9073, 0x9083, 0x9093,
	0x90a2, 0x90b3, 0x90c4, 0x90d4, 0x90f9, 0x9127, 0x913e, 0x9159,
	0x9184, 0x91a8, 0x91cc, 0x91f0, 0x9214, 0x9238, 0x925c, 0x9280,
	0x92a4, 0x92c8, 0x92ec, 0x9310, 0x9334, 0x9358, 0x937c, 0x93a0,
	0x93c4, 0x93e8, 0x940c, 0x9430, 0x9454, 0x9478, 0x949c, 0x94c0,
	0x94e4, 0x9508, 0x952c, 0x955b, 0x9580, 0x95a5, 0x95af, 0x95b9,
	0x95c8, 0x95e6, 0x9604, 0x9622, 0x9640, 0x965e, 0x967c, 0x969a,
	0x96b8, 0x96d6, 0x96f4, 0x9712, 0x9730, 0x974e, 0x976c, 0x978a,
	// Entry 7BC0 - 7BFF
	0x97a8, 0x97c6, 0x97e4, 0x9802, 0x9820, 0x983e, 0x985c, 0x987a,
	0x9898, 0x98b6, 0x98d4, 0x98de, 0x98e8, 0x98f2, 0x98fc, 0x9907,
	0x9911, 0x9938, 0x995f, 0x9986, 0x99ad, 0x99d4, 0x99fb, 0x9a22,
	0x9a49, 0x9a70, 0x9a97, 0x9abe, 0x9ae5, 0x9b0c, 0x9b33, 0x9b5a,
	0x9b81, 0x9ba8, 0x9bcf, 0x9bf6, 0x9c1d, 0x9c44, 0x9c6b, 0x9c92,
	0x9cb9, 0x9ce0, 0x9d07, 0x9d15, 0x9d23, 0x9d31, 0x9d3b, 0x9d5c,
	0x9d70, 0x9d97, 0x9dbe, 0x9de5, 0x9e0c, 0x9e33, 0x9e5a, 0x9e81,
	0x9ea8, 0x9ecf, 0x9ef6, 0x9f1d, 0x9f44, 0x9f6b, 0x9f92, 0x9fb9,
	// Entry 7C00 - 7C3F
	0x9fe0, 0xa007, 0xa02e, 0xa055, 0xa07c, 0xa0a3, 0xa0ca, 0xa0f1,
	0xa118, 0xa13f, 0xa166, 0xa195, 0xa1a8, 0xa1bb, 0xa1ce, 0xa1e1,
	0xa1f4, 0xa1fd, 0xa207, 0xa213, 0xa21f, 0xa229, 0xa234, 0xa23e,
	0xa248, 0xa253, 0xa273, 0xa27d, 0xa28c, 0xa2a1, 0xa2ae, 0xa2bc,
	0xa2cb, 0xa2e1, 0xa2f8, 0xa314, 0xa323, 0xa33f, 0xa35b, 0xa365,
	0xa370, 0xa37e, 0xa38e, 0xa399, 0xa3a4, 0xa3af, 0xa3bf, 0xa3e1,
	0xa403, 0xa425, 0xa447, 0xa469, 0xa48b, 0xa4ad, 0xa4cf, 0xa4f1,
	0xa513, 0xa535, 0xa557, 0xa579, 0xa59b, 0xa5bd, 0xa5df, 0xa601,
	// Entry 7C40 - 7C7F
	0xa623, 0xa645, 0xa667, 0xa689, 0xa6ab, 0xa6cd, 0xa6ef, 0xa711,
	0xa733, 0xa747, 0xa75c, 0xa76f, 0xa791, 0xa7b3, 0xa7d5, 0xa7e8,
	0xa80a, 0xa82c, 0xa84e, 0xa870, 0xa892, 0xa8b4, 0xa8d6, 0xa8f8,
	0xa91a, 0xa93c, 0xa95e, 0xa980, 0xa9a2, 0xa9c4, 0xa9e6, 0xaa08,
	0xaa2a, 0xaa4c, 0xaa6e, 0xaa90, 0xaab2, 0xaad4, 0xaaf6, 0xab18,
	0xab3a, 0xab5c, 0xab7e, 0xaba0, 0xabc2, 0xabe4, 0xac06, 0xac28,
	0xac4a, 0xac6c, 0xac8e, 0xacb0, 0xacd2, 0xacf4, 0xad16, 0xad38,
	0xad6b, 0xad9e, 0xadd1, 0xae04, 0xae37, 0xae6a, 0xae9d, 0xaed0,
	// Entry 7C80 - 7CBF
	0xaf03, 0xaf1e, 0xaf36, 0xaf4b, 0xaf60, 0xaf77, 0xaf8c, 0xafa7,
	0xafbd, 0xafc4, 0xafc9, 0xafd8, 0xafe8, 0xaffe, 0xb005, 0xb016,
	0xb02b, 0xb032, 0xb041, 0xb04b, 0xb052, 0xb05b, 0xb074, 0xb088,
	0xb0a2, 0xb0b6, 0xb0c5, 0xb0e0, 0xb0f9, 0xb113, 0xb123, 0xb13d,
	0xb155, 0xb170, 0xb17d, 0xb18f, 0xb1ab, 0xb1c6, 0xb1d9, 0xb1e6,
	0xb1f2, 0xb1ff, 0xb20a, 0xb217, 0xb220, 0xb23a, 0xb250, 0xb270,
	0xb27f, 0xb28e, 0xb2a2, 0xb2b4, 0xb2b7, 0xb2c8, 0xb2cf, 0xb2d3,
	0xb2da, 0xb2e2, 0xb2ea, 0xb2f8, 0xb306, 0xb30f, 0xb315, 0xb31f,
	// Entry 7CC0 - 7CFF
	0xb324, 0xb332, 0xb336, 0xb33e, 0xb347, 0xb34e, 0xb35a, 0xb365,
	0xb369, 0xb379, 0xb383, 0xb38e, 0xb3a5, 0xb3ad, 0xb3b3, 0xb3bc,
	0xb3c2, 0xb3c7, 0xb3d1, 0xb3da, 0xb3df, 0xb3e5, 0xb3ee, 0xb3f7,
	0xb402, 0xb406, 0xb40b, 0xb413, 0xb41d, 0xb426, 0xb434, 0xb440,
	0xb44b, 0xb457, 0xb460, 0xb46b, 0xb479, 0xb486, 0xb48f, 0xb494,
	0xb4a0, 0xb4b4, 0xb4b9, 0xb4bd, 0xb4c2, 0xb4ce, 0xb4e9, 0xb4f7,
	0xb501, 0xb50a, 0xb512, 0xb518, 0xb525, 0xb52a, 0xb532, 0xb539,
	0xb542, 0xb54b, 0xb554, 0xb55f, 0xb566, 0xb574, 0xb589, 0xb59c,
	// Entry 7D00 - 7D3F
	0xb5a6, 0xb5b4, 0xb5c2, 0xb5ca, 0xb5dc, 0xb5e7, 0xb600, 0xb618,
	0xb61f, 0xb625, 0xb634, 0xb641, 0xb64f, 0xb65d, 0xb66d, 0xb676,
	0xb687, 0xb68e, 0xb69a, 0xb6a7, 0xb6b4, 0xb6c1, 0xb6d0, 0xb6de,
	0xb6eb, 0xb6f5, 0xb70a, 0xb718, 0xb726, 0xb740, 0xb752, 0xb760,
	0xb76f, 0xb78a, 0xb79b, 0xb7a7, 0xb7b4, 0xb7d2, 0xb7f1, 0xb7fc,
	0xb80d, 0xb81b, 0xb827, 0xb835, 0xb84a, 0xb854, 0xb860, 0xb866,
	0xb86f, 0xb87d, 0xb884, 0xb88f, 0xb895, 0xb8a2, 0xb8b1, 0xb8bb,
	0xb8c5, 0xb8d1, 0xb8da, 0xb8e2, 0xb8e9, 0xb8fd, 0xb909, 0xb91f,
	// Entry 7D40 - 7D7F
	0xb928, 0xb92e, 0xb93e, 0xb945, 0xb94b, 0xb958, 0xb96f, 0xb986,
	0xb996, 0xb9a9, 0xb9b7, 0xb9c2, 0xb9c8, 0xb9ce, 0xb9da, 0xb9e0,
	0xb9ec, 0xb9fd, 0xba0b, 0xba12, 0xba1f, 0xba25, 0xba36, 0xba40,
	0xba54, 0xba5e, 0xba79, 0xba92, 0xbaae, 0xbac2, 0xbac9, 0xbadc,
	0xbaf1, 0xbb00, 0xbb09, 0xbb20, 0xbb32, 0xbb38, 0xbb45, 0xbb52,
	0xbb59, 0xbb67, 0xbb78, 0xbb87, 0xbb9b, 0xbbaf, 0xbbb7, 0xbbbb,
	0xbbd3, 0xbbd8, 0xbbe2, 0xbbf3, 0xbbf9, 0xbc09, 0xbc10, 0xbc1f,
	0xbc2e, 0xbc3d, 0xbc4a, 0xbc57, 0xbc68, 0xbc79, 0xbc80, 0xbc8d,
	// Entry 7D80 - 7DBF
	0xbc92, 0xbcb3, 0xbcc0, 0xbcc7, 0xbcea, 0xbd0b, 0xbd2c, 0xbd4d,
	0xbd6e, 0xbd71, 0xbd76, 0xbd78, 0xbd85, 0xbd88, 0xbd8d, 0xbd94,
	0xbd9a, 0xbd9d, 0xbda3, 0xbdac, 0xbdb1, 0xbdb6, 0xbdbb, 0xbdc0,
	0xbdc3, 0xbdc7, 0xbdcc, 0xbdd2, 0xbdd9, 0xbde0, 0xbde3, 0xbde6,
	0xbdea, 0xbdf2, 0xbdf9, 0xbe05, 0xbe08, 0xbe0b, 0xbe13, 0xbe1e,
	0xbe22, 0xbe2f, 0xbe37, 0xbe3d, 0xbe4b, 0xbe55, 0xbe6c, 0xbe70,
	0xbe77, 0xbe7c, 0xbe82, 0xbe91, 0xbe9f, 0xbea6, 0xbeb0, 0xbeb8,
	0xbec2, 0xbecd, 0xbed5, 0xbee0, 0xbeee, 0xbef8, 0xbf03, 0xbf0b,
	// Entry 7DC0 - 7DFF
	0xbf13, 0xbf1c, 0xbf28, 0xbf31, 0xbf3a, 0xbf44, 0xbf4c, 0xbf56,
	0xbf5e, 0xbf62, 0xbf65, 0xbf68, 0xbf6c, 0xbf71, 0xbf77, 0xbf97,
	0xbfb9, 0xbfdb, 0xbffe, 0xc00e, 0xc01e, 0xc02a, 0xc038, 0xc048,
	0xc05b, 0xc06a, 0xc06f, 0xc079, 0xc083, 0xc08a, 0xc091, 0xc096,
	0xc09b, 0xc0a1, 0xc0a7, 0xc0b5, 0xc0ba, 0xc0c1, 0xc0c6, 0xc0cf,
	0xc0dc, 0xc0ec, 0xc0f9, 0xc105, 0xc10f, 0xc121, 0xc134, 0xc137,
	0xc13b, 0xc13e, 0xc143, 0xc149, 0xc164, 0xc179, 0xc190, 0xc19e,
	0xc1b3, 0xc1c2, 0xc1d8, 0xc1eb, 0xc1fa, 0xc203, 0xc20e, 0xc212,
	// Entry 7E00 - 7E3F
	0xc225, 0xc22d, 0xc23a, 0xc249, 0xc24e, 0xc258, 0xc26e, 0xc27b,
	0xc27e, 0xc283, 0xc29a, 0xc2a3, 0xc2a9, 0xc2b1, 0xc2bc, 0xc2c8,
	0xc2cf, 0xc2da, 0xc2e1, 0xc2e5, 0xc2ee, 0xc2f9, 0xc2fd, 0xc306,
	0xc30a, 0xc311, 0xc322, 0xc329, 0xc336, 0xc342, 0xc34c, 0xc35b,
	0xc368, 0xc378, 0xc382, 0xc38d, 0xc399, 0xc3a5, 0xc3b6, 0xc3c6,
	0xc3d6, 0xc3f5, 0xc408, 0xc414, 0xc418, 0xc427, 0xc437, 0xc44d,
	0xc454, 0xc45f, 0xc46a, 0xc477, 0xc483, 0xc491, 0xc4a0, 0xc4ac,
	0xc4c1, 0xc4ca, 0xc4db, 0xc4ec, 0xc4f7, 0xc50d, 0xc526, 0xc53d,
	// Entry 7E40 - 7E7F
	0xc555, 0xc565, 0xc58a, 0xc58e, 0xc59f, 0xc5a8, 0xc5b0, 0xc5bb,
	0xc5c7, 0xc5ca, 0xc5d5, 0xc5e5, 0xc5f3, 0xc601, 0xc609, 0xc61a,
	0xc624, 0xc63c, 0xc656, 0xc65f, 0xc668, 0xc66f, 0xc67c, 0xc685,
	0xc693, 0xc6a3, 0xc6b0, 0xc6b6, 0xc6be, 0xc6dc, 0xc6e7, 0xc6f0,
	0xc6fa, 0xc703, 0xc70e, 0xc713, 0xc71d, 0xc723, 0xc727, 0xc739,
	0xc73e, 0xc749, 0xc75a, 0xc774, 0xc786, 0xc791, 0xc79b, 0xc7a2,
	0xc7af, 0xc7c0, 0xc7e3, 0xc803, 0xc822, 0xc83f, 0xc85d, 0xc864,
	0xc86f, 0xc878, 0xc884, 0xc8ae, 0xc8bc, 0xc8cc, 0xc8dc, 0xc8ed,
	// Entry 7E80 - 7EBF
	0xc8f3, 0xc904, 0xc910, 0xc91a, 0xc91f, 0xc92c, 0xc93a, 0xc949,
	0xc955, 0xc96e, 0xc9a3, 0xc9f1, 0xca23, 0xca59, 0xca6e, 0xca84,
	0xcaa4, 0xcaab, 0xcac6, 0xcae4, 0xcaeb, 0xcaf8, 0xcb16, 0xcb35,
	0xcb46, 0xcb5a, 0xcb5d, 0xcb61, 0xcb6a, 0xcb6e, 0xcb8b, 0xcb93,
	0xcb9e, 0xcbaa, 0xcbc9, 0xcbe7, 0xcc1b, 0xcc3b, 0xcc57, 0xcc73,
	0xcc7d, 0xcca3, 0xccc7, 0xccdf, 0xccf7, 0xcd15, 0xcd19, 0xcd27,
	0xcd2d, 0xcd33, 0xcd3f, 0xcd44, 0xcd4a, 0xcd54, 0xcd5d, 0xcd69,
	0xcd89, 0xcda5, 0xcdb3, 0xcdc6, 0xcdd9, 0xcde9, 0xcdfa, 0xce0e,
	// Entry 7EC0 - 7EFF
	0xce20, 0xce34, 0xce46, 0xce5e, 0xce78, 0xce96, 0xceb6, 0xced7,
	0xcef8, 0xcf0c, 0xcf2f, 0xcf3b, 0xcf62, 0xcf8a, 0xcfa2, 0xcfb3,
	0xcfc4, 0xcfd0, 0xcfd9, 0xcfe6, 0xcfeb, 0xcff1, 0xcffa, 0xd014,
	0xd023, 0xd038, 0xd04d, 0xd064, 0xd07a, 0xd090, 0xd0a5, 0xd0bc,
	0xd0d3, 0xd0e9, 0xd0fe, 0xd116, 0xd12e, 0xd143, 0xd158, 0xd16f,
	0xd185, 0xd19b, 0xd1b0, 0xd1c7, 0xd1de, 0xd1f4, 0xd209, 0xd221,
	0xd239, 0xd246, 0xd267, 0xd28b, 0xd293, 0xd2ac, 0xd2b8, 0xd2bc,
	0xd2c2, 0xd2d3, 0xd2ed, 0xd2f6, 0xd2fa, 0xd319, 0xd326, 0xd335,
	// Entry 7F00 - 7F3F
	0xd33b, 0xd345, 0xd34d, 0xd358, 0xd374, 0xd390, 0xd3ad, 0xd3c6,
	0xd3df, 0xd3f8, 0xd40e, 0xd41e, 0xd42e, 0xd445, 0xd454, 0xd46d,
	0xd47e, 0xd48b, 0xd49c, 0xd4b4, 0xd4cb, 0xd4e0, 0xd4f1, 0xd502,
	0xd515, 0xd535, 0xd55e, 0xd575, 0xd58e, 0xd5a3, 0xd5cc, 0xd601,
	0xd624, 0xd646, 0xd669, 0xd68b, 0xd6ae, 0xd6d0, 0xd6f3, 0xd713,
	0xd735, 0xd755, 0xd777, 0xd797, 0xd7b9, 0xd7c4, 0xd7d4, 0xd7e6,
	0xd7ff, 0xd806, 0xd817, 0xd833, 0xd84f, 0xd865, 0xd873, 0xd881,
	0xd891, 0xd8a1, 0xd8b3, 0xd8bc, 0xd8d1, 0xd8da, 0xd8e0, 0xd8ec,
	// Entry 7F40 - 7F7F
	0xd8f4, 0xd905, 0xd917, 0xd935, 0xd94a, 0xd95c, 0xd96c, 0xd97b,
	0xd987, 0xd98d, 0xd998, 0xd9ab, 0xd9b8, 0xd9c4, 0xd9ce, 0xd9dd,
	0xd9eb, 0xd9ef, 0xd9f8, 0xda00, 0xda0e, 0xda18, 0xda23, 0xda2b,
	0xda2f, 0xda34, 0xda3f, 0xda4e, 0xda61, 0xda6f, 0xda77, 0xda7f,
	0xda86, 0xdab0, 0xdabe, 0xdad7, 0xdaf0, 0xdafb, 0xdb02, 0xdb15,
	0xdb2b, 0xdb36, 0xdb42, 0xdb46, 0xdb61, 0xdb71, 0xdb81, 0xdb90,
	0xdba0, 0xdbb2, 0xdbc5, 0xdbd7, 0xdbeb, 0xdbfe, 0xdc12, 0xdc23,
	0xdc35, 0xdc40, 0xdc55, 0xdc63, 0xdc79, 0xdc88, 0xdca0, 0xdcb4,
	// Entry 7F80 - 7FBF
	0xdcd1, 0xdce1, 0xdcfb, 0xdd04, 0xdd0e, 0xdd19, 0xdd2a, 0xdd3d,
	0xdd42, 0xdd4f, 0xdd6e, 0xdd84, 0xdda0, 0xddcd, 0xddf8, 0xde2c,
	0xde42, 0xde59, 0xde65, 0xde83, 0xdea0, 0xdead, 0xded0, 0xdeec,
	0xdef9, 0xdf05, 0xdf18, 0xdf25, 0xdf39, 0xdf45, 0xdf52, 0xdf61,
	0xdf6d, 0xdf81, 0xdf9f, 0xdfbc, 0xdfd6, 0xe000, 0xe032, 0xe043,
	0xe04f, 0xe059, 0xe065, 0xe070, 0xe080, 0xe099, 0xe0b7, 0xe0d4,
	0xe0e2, 0xe0ee, 0xe0f8, 0xe103, 0xe10d, 0xe11b, 0xe12d, 0xe141,
	0xe14c, 0xe16f, 0xe185, 0xe194, 0xe1a0, 0xe1ad, 0xe1b7, 0xe1c9,
	// Entry 7FC0 - 7FFF
	0xe1df, 0xe202, 0xe21c, 0xe23c, 0xe263, 0xe27a, 0xe29b, 0xe2ab,
	0xe2ba, 0xe2c8, 0xe2de, 0xe2f3, 0xe303, 0xe319, 0xe332, 0xe346,
	0xe35a, 0xe36c, 0xe37f, 0xe393, 0xe3b0, 0xe3d8, 0xe3e7, 0xe3ff,
	0xe417, 0xe42f, 0xe447, 0xe45f, 0xe477, 0xe496, 0xe4b5, 0xe4d4,
	0xe4f3, 0xe510, 0xe52d, 0xe54a, 0xe567, 0xe58a, 0xe5ad, 0xe5d0,
	0xe5f3, 0xe60a, 0xe621, 0xe638, 0xe64f, 0xe66c, 0xe689, 0xe6a6,
	0xe6c3, 0xe6df, 0xe70b, 0xe726, 0xe751, 0xe761, 0xe76f, 0xe780,
	0xe790, 0xe7ab, 0xe7cc, 0xe7e5, 0xe804, 0xe81c, 0xe834, 0xe870,
	// Entry 8000 - 803F
	0xe8a5, 0xe8de, 0xe8f8, 0xe917, 0xe93c, 0xe94e, 0xe968, 0xe975,
	0xe98a, 0xe990, 0xe99a, 0xe9aa, 0xe9b5, 0xe9c5, 0xe9e6, 0xe9eb,
	0xe9f0, 0xe9fa, 0xea01, 0xea05, 0xea0d, 0xea10, 0xea1c, 0xea26,
	0xea2e, 0xea35, 0xea3e, 0xea49, 0xea53, 0xea66, 0xea6a, 0xea77,
	0xea81, 0xea94, 0xeaa8, 0xeab6, 0xeac7, 0xeace, 0xead6, 0xeae6,
	0xeaf8, 0xeb09, 0xeb17, 0xeb1b, 0xeb22, 0xeb2b, 0xeb43, 0xeb59,
	0xeb6a, 0xeb85, 0xeb9c, 0xeba0, 0xebad, 0xebbb, 0xebcc, 0xebea,
	0xebfe, 0xec12, 0xec2a, 0xec31, 0xec3c, 0xec45, 0xec57, 0xec61,
	// Entry 8040 - 807F
	0xec6f, 0xec80, 0xec8b, 0xec98, 0xeca0, 0xecab, 0xecb1, 0xecbd,
	0xecc3, 0xecc7, 0xecce, 0xecde, 0xece5, 0xecf2, 0xecfe, 0xed1b,
	0xed2a, 0xed44, 0xed4f, 0xed5b, 0xed69, 0xed7f, 0xed8c, 0xed98,
	0xed9b, 0xedab, 0xedb9, 0xedc9, 0xedce, 0xedd4, 0xede0, 0xede3,
	0xedeb, 0xedf3, 0xee03, 0xee08, 0xee11, 0xee22, 0xee28, 0xee30,
	0xee38, 0xee45, 0xee4f, 0xee6c, 0xee80, 0xee9a, 0xeea8, 0xeec3,
	0xeed5, 0xeee6, 0xeeef, 0xef03, 0xef14, 0xef22, 0xef29, 0xef36,
	0xef3b, 0xef3f, 0xef4c, 0xef56, 0xef63, 0xef6f, 0xef7b, 0xef9d,
	// Entry 8080 - 80BF
	0xefb6, 0xefd0, 0xefeb, 0xf006, 0xf026, 0xf046, 0xf068, 0xf088,
	0xf0aa, 0xf0c7, 0xf0e6, 0xf105, 0xf121, 0xf14a, 0xf16c, 0xf193,
	0xf1bc, 0xf1e5, 0xf203, 0xf21d, 0xf238, 0xf255, 0xf274, 0xf293,
	0xf2b4, 0xf2ce, 0xf2ea, 0xf308, 0xf328, 0xf34c, 0xf371, 0xf391,
	0xf3b6, 0xf3df, 0xf405, 0xf42d, 0xf455, 0xf485, 0xf4b6, 0xf4d5,
	0xf4f2, 0xf510, 0xf532, 0xf55d, 0xf583, 0xf5b6, 0xf5df, 0xf608,
	0xf633, 0xf650, 0xf66f, 0xf68e, 0xf6ad, 0xf6c9, 0xf6e7, 0xf706,
	0xf728, 0xf745, 0xf762, 0xf781, 0xf7a2, 0xf7c3, 0xf7df, 0xf7fd,
	// Entry 80C0 - 80FF
	0xf81d, 0xf838, 0xf855, 0xf872, 0xf88c, 0xf8a5, 0xf8c1, 0xf8df,
	0xf8f8, 0xf911, 0xf92d, 0xf947, 0xf962, 0xf985, 0xf9aa, 0xf9c8,
	0xf9e5, 0xfa0a, 0xfa29, 0xfa43, 0xfa5e, 0xfa7e, 0xfa99, 0xfab8,
	0xfad3, 0xfaf7, 0xfb14, 0xfb3f, 0xfb6c, 0xfb8d, 0xfbae, 0xfbcb,
	0xfbe9, 0xfc09, 0xfc25, 0xfc47, 0xfc65, 0xfc85, 0xfca5, 0xfcc5,
	0xfce5, 0xfd02, 0xfd24, 0xfd49, 0xfd65, 0xfd7f, 0xfd9a, 0xfdb9,
	0xfdd4, 0xfdf3, 0xfe13, 0xfe21, 0xfe2c, 0xfe39, 0xfe3f, 0xfe47,
	0xfe4f, 0xfe55, 0xfe5a, 0xfe86, 0xfeb0, 0xfedd, 0xff09, 0xff24,
	// Entry 8100 - 813F
	0xff3c, 0xff4d, 0xff5f, 0xff76, 0xff92, 0xffbc, 0xffc8, 0xffd9,
	0xfff4, 0x0006, 0x0019, 0x002a, 0x003c, 0x0053, 0x006f, 0x009e,
	0x00c9, 0x00d6, 0x00e8, 0x0100, 0x011a, 0x014b, 0x0178, 0x0186,
	0x0198, 0x01b0, 0x01ca, 0x01f6, 0x0206, 0x0217, 0x0229, 0x0239,
	0x024e, 0x0264, 0x027f, 0x028b, 0x0298, 0x02a6, 0x02b2, 0x02bf,
	0x02d1, 0x02e8, 0x0302, 0x031d, 0x0336, 0x0350, 0x036f, 0x0393,
	0x03ac, 0x03c6, 0x03de, 0x03f7, 0x0415, 0x0438, 0x0453, 0x046f,
	0x0489, 0x04a4, 0x04c4, 0x04e2, 0x0501, 0x0519, 0x053b, 0x0558,
	// Entry 8140 - 817F
	0x0576, 0x058d, 0x05ae, 0x05d6, 0x05f3, 0x0610, 0x062d, 0x0649,
	0x0662, 0x0681, 0x069f, 0x06c2, 0x06e3, 0x0702, 0x0721, 0x0743,
	0x0753, 0x076c, 0x077a, 0x0791, 0x07a8, 0x07bb, 0x07ce, 0x07e0,
	0x07f3, 0x0805, 0x0815, 0x0826, 0x0839, 0x084c, 0x085e, 0x0871,
	0x0883, 0x0894, 0x08c1, 0x08ec, 0x091a, 0x0947, 0x0975, 0x09a1,
	0x09d0, 0x09fe, 0x0a2b, 0x0a56, 0x0a84, 0x0ab1, 0x0ae1, 0x0b0f,
	0x0b40, 0x0b70, 0x0b9a, 0x0bc2, 0x0bed, 0x0c17, 0x0c47, 0x0c75,
	0x0ca6, 0x0cd6, 0x0d0c, 0x0d40, 0x0d77, 0x0dad, 0x0dde, 0x0e0d,
	// Entry 8180 - 81BF
	0x0e3f, 0x0e70, 0x0ea1, 0x0ed0, 0x0f02, 0x0f33, 0x0f62, 0x0f8f,
	0x0fbf, 0x0fee, 0x101e, 0x104c, 0x107d, 0x10ad, 0x10e2, 0x1115,
	0x114b, 0x1180, 0x119b, 0x11b4, 0x11d0, 0x11eb, 0x1202, 0x1217,
	0x122f, 0x1246, 0x1260, 0x1278, 0x1293, 0x12ad, 0x12cd, 0x12eb,
	0x130c, 0x132c, 0x1341, 0x1354, 0x136a, 0x137f, 0x1399, 0x13b1,
	0x13cc, 0x13e6, 0x1401, 0x141c, 0x1437, 0x1452, 0x146d, 0x1485,
	0x14ab, 0x14cf, 0x14f6, 0x151c, 0x1543, 0x156a, 0x1591, 0x15b8,
	0x15d8, 0x15f6, 0x1617, 0x1637, 0x1658, 0x1679, 0x169a, 0x16bb,
	// Entry 81C0 - 81FF
	0x16e2, 0x1707, 0x172f, 0x1756, 0x177e, 0x17a6, 0x17ce, 0x17f6,
	0x181c, 0x1840, 0x1867, 0x188d, 0x18b4, 0x18db, 0x1902, 0x1929,
	0x1954, 0x197d, 0x19a9, 0x19d4, 0x1a00, 0x1a2c, 0x1a58, 0x1a84,
	0x1aa0, 0x1aba, 0x1ad7, 0x1af3, 0x1b22, 0x1b4f, 0x1b7f, 0x1bae,
	0x1bcf, 0x1bee, 0x1c10, 0x1c31, 0x1c4c, 0x1c6e, 0x1c8e, 0x1caf,
	0x1cd2, 0x1cf6, 0x1d16, 0x1d37, 0x1d58, 0x1d7b, 0x1d9d, 0x1dbf,
	0x1de9, 0x1e14, 0x1e3f, 0x1e6b, 0x1e86, 0x1ea8, 0x1ece, 0x1eff,
	0x1f22, 0x1f44, 0x1f58, 0x1f77, 0x1f97, 0x1fb5, 0x1fce, 0x1fde,
	// Entry 8200 - 823F
	0x1ff2, 0x200e, 0x202b, 0x2050, 0x205f, 0x206a, 0x2075, 0x2082,
	0x2093, 0x20a3, 0x20b8, 0x20c1, 0x20ce, 0x20e4, 0x20ee, 0x20fa,
	0x210b, 0x2117, 0x212a, 0x213a, 0x214b, 0x2154, 0x217e, 0x2192,
	0x21a6, 0x21b0, 0x21be, 0x21db, 0x21e8, 0x21f2, 0x21fb, 0x2208,
	0x2224, 0x2240, 0x226e, 0x2293, 0x22bb, 0x22f1, 0x230e, 0x232e,
	0x233c, 0x234a, 0x235b, 0x2361, 0x2367, 0x2374, 0x2384, 0x2389,
	0x239f, 0x23a7, 0x23ad, 0x23be, 0x23c7, 0x23d1, 0x23d9, 0x23e4,
	0x23f1, 0x2405, 0x2415, 0x2422, 0x2427, 0x242f, 0x2434, 0x2445,
	// Entry 8240 - 827F
	0x2457, 0x2468, 0x2474, 0x2488, 0x2495, 0x24ac, 0x24b4, 0x24bf,
	0x24c8, 0x24cf, 0x24d7, 0x24dc, 0x24e2, 0x24e8, 0x24f6, 0x2501,
	0x2514, 0x2525, 0x2528, 0x2535, 0x253c, 0x2545, 0x254d, 0x2555,
	0x2563, 0x256e, 0x2578, 0x2587, 0x2595, 0x259c, 0x25a4, 0x25a7,
	0x25ae, 0x25b9, 0x25c1, 0x25cc, 0x25d7, 0x25dc, 0x25e5, 0x25ea,
	0x2619, 0x2625, 0x263b, 0x265d, 0x2681, 0x2690, 0x269d, 0x26a2,
	0x26b0, 0x26c7, 0x26de, 0x26e2, 0x26ea, 0x26f1, 0x26fc, 0x2705,
	0x2709, 0x2712, 0x271a, 0x2720, 0x272c, 0x2731, 0x2735, 0x2738,
	// Entry 8280 - 82BF
	0x273d, 0x2740, 0x2748, 0x2751, 0x2755, 0x275c, 0x2762, 0x276c,
	0x2772, 0x2777, 0x2783, 0x278d, 0x2795, 0x279d, 0x27a2, 0x27a9,
	0x27b1, 0x27b6, 0x27bd, 0x27c9, 0x27cf, 0x27d6, 0x27dd, 0x27e5,
	0x27ec, 0x27f2, 0x27f6, 0x27fd, 0x2801, 0x2806, 0x280b, 0x2814,
	0x2819, 0x2821, 0x2827, 0x282d, 0x2832, 0x2836, 0x283f, 0x284b,
	0x2863, 0x287d, 0x2891, 0x28ab, 0x28af, 0x28b2, 0x28b6, 0x28bb,
	0x28c4, 0x28d0, 0x28db, 0x28ef, 0x2903, 0x2914, 0x2922, 0x2930,
	0x293c, 0x2943, 0x294e, 0x295a, 0x2960, 0x2965, 0x296c, 0x2972,
	// Entry 82C0 - 82FF
	0x2978, 0x2982, 0x298a, 0x2994, 0x2999, 0x29a8, 0x29b7, 0x29c2,
	0x29d3, 0x29d8, 0x29dd, 0x29e8, 0x29f6, 0x2a0b, 0x2a20, 0x2a2f,
	0x2a47, 0x2a4b, 0x2a50, 0x2a57, 0x2a60, 0x2a63, 0x2a68, 0x2a6e,
	0x2a73, 0x2a7f, 0x2a89, 0x2a8e, 0x2a94, 0x2a98, 0x2a9d, 0x2aae,
	0x2ab9, 0x2acc, 0x2ad5, 0x2adf, 0x2aef, 0x2af6, 0x2afc, 0x2b0d,
	0x2b14, 0x2b19, 0x2b1f, 0x2b26, 0x2b33, 0x2b42, 0x2b4e, 0x2b58,
	0x2b62, 0x2b67, 0x2b6d, 0x2b7a, 0x2b85, 0x2b8b, 0x2b92, 0x2b9e,
	0x2bb0, 0x2bc3, 0x2bd5, 0x2be9, 0x2bfd, 0x2c0f, 0x2c3c, 0x2c69,
	// Entry 8300 - 833F
	0x2c98, 0x2cbf, 0x2ce7, 0x2d0e, 0x2d37, 0x2d60, 0x2d87, 0x2dae,
	0x2dd6, 0x2dfd, 0x2e26, 0x2e4f, 0x2e76, 0x2e9f, 0x2ec9, 0x2ef2,
	0x2f1d, 0x2f48, 0x2f71, 0x2fab, 0x2fe5, 0x3021, 0x3038, 0x3050,
	0x3067, 0x3080, 0x3099, 0x30b0, 0x30c7, 0x30df, 0x30f6, 0x310f,
	0x3128, 0x313f, 0x3158, 0x3172, 0x318b, 0x31a6, 0x31c1, 0x31da,
	0x3214, 0x324e, 0x328a, 0x32be, 0x32f3, 0x3327, 0x335d, 0x3393,
	0x33c7, 0x33fb, 0x3430, 0x3464, 0x349a, 0x34d0, 0x3504, 0x353a,
	0x3571, 0x35a7, 0x35df, 0x3617, 0x364d, 0x3685, 0x36bd, 0x36f7,
	// Entry 8340 - 837F
	0x370d, 0x3723, 0x373b, 0x3768, 0x3795, 0x37c4, 0x37dc, 0x37f3,
	0x380c, 0x3824, 0x383b, 0x3854, 0x3867, 0x387b, 0x388f, 0x38a0,
	0x38b3, 0x38c5, 0x38d8, 0x38ed, 0x3903, 0x3919, 0x392c, 0x3941,
	0x3955, 0x396a, 0x3976, 0x3988, 0x398e, 0x3994, 0x39a0, 0x39b0,
	0x39ba, 0x39c4, 0x39d1, 0x39e1, 0x39ec, 0x39f1, 0x39f7, 0x39fc,
	0x3a00, 0x3a09, 0x3a12, 0x3a1c, 0x3a22, 0x3a2f, 0x3a36, 0x3a3b,
	0x3a48, 0x3a4d, 0x3a52, 0x3a55, 0x3a5e, 0x3a63, 0x3a72, 0x3a7b,
	0x3a84, 0x3a88, 0x3a95, 0x3aa0, 0x3aa6, 0x3aaa, 0x3ab0, 0x3ab6,
	// Entry 8380 - 83BF
	0x3abd, 0x3aca, 0x3ace, 0x3ad4, 0x3ade, 0x3ae8, 0x3af1, 0x3af8,
	0x3afc, 0x3b07, 0x3b1a, 0x3b25, 0x3b2a, 0x3b3a, 0x3b43, 0x3b49,
	0x3b4c, 0x3b50, 0x3b56, 0x3b5f, 0x3b6b, 0x3b6f, 0x3b76, 0x3b7b,
	0x3b80, 0x3b8a, 0x3b98, 0x3ba0, 0x3ba9, 0x3bad, 0x3bb2, 0x3bc2,
	0x3bc7, 0x3bd5, 0x3be1, 0x3bf0, 0x3c01, 0x3c06, 0x3c0c, 0x3c17,
	0x3c22, 0x3c27, 0x3c30, 0x3c36, 0x3c3c, 0x3c42, 0x3c50, 0x3c55,
	0x3c58, 0x3c63, 0x3c6a, 0x3c76, 0x3c83, 0x3caa, 0x3cbf, 0x3cd7,
	0x3ce7, 0x3cf1, 0x3cf8, 0x3d04, 0x3d2c, 0x3d3b, 0x3d49, 0x3d57,
	// Entry 83C0 - 83FF
	0x3d63, 0x3d7f, 0x3d8a, 0x3da0, 0x3db7, 0x3dc6, 0x3dd5, 0x3de5,
	0x3df4, 0x3e04, 0x3e14, 0x3e25, 0x3e34, 0x3e44, 0x3e54, 0x3e65,
	0x3e75, 0x3e86, 0x3e97, 0x3ea9, 0x3eb8, 0x3ec8, 0x3ed8, 0x3ee9,
	0x3ef9, 0x3f0a, 0x3f1c, 0x3f2c, 0x3f3d, 0x3f4e, 0x3f60, 0x3f71,
	0x3f83, 0x3f95, 0x3fa8, 0x3fb7, 0x3fc7, 0x3fd7, 0x3fe8, 0x3ff8,
	0x4009, 0x401a, 0x402c, 0x403c, 0x404d, 0x405f, 0x4070, 0x4082,
	0x4094, 0x40a7, 0x40b7, 0x40c8, 0x40d9, 0x40eb, 0x40fc, 0x410e,
	0x4120, 0x4133, 0x4144, 0x4156, 0x4168, 0x417b, 0x418d, 0x41a0,
	// Entry 8400 - 843F
	0x41b3, 0x41ee, 0x4228, 0x4263, 0x429d, 0x42d1, 0x430d, 0x4348,
	0x4384, 0x43bf, 0x43f4, 0x4436, 0x4473, 0x44ae, 0x44eb, 0x4526,
	0x455c, 0x4598, 0x45d2, 0x460e, 0x4648, 0x467d, 0x46be, 0x46fa,
	0x4735, 0x4771, 0x47ac, 0x47e1, 0x481c, 0x4856, 0x4891, 0x48cb,
	0x48ff, 0x4940, 0x497c, 0x49b6, 0x49f2, 0x4a2c, 0x4a61, 0x4a9e,
	0x4ad9, 0x4b16, 0x4b51, 0x4b87, 0x4bc9, 0x4c02, 0x4c3a, 0x4c72,
	0x4caa, 0x4ccb, 0x4ced, 0x4d0f, 0x4d31, 0x4d4c, 0x4d67, 0x4d82,
	0x4d9d, 0x4db8, 0x4dd3, 0x4df0, 0x4e0d, 0x4e2a, 0x4e47, 0x4e64,
	// Entry 8440 - 847F
	0x4e81, 0x4ea0, 0x4ebf, 0x4edf, 0x4eff, 0x4f1f, 0x4f3f, 0x4f56,
	0x4f6f, 0x4f87, 0x4fa1, 0x4fba, 0x4fd1, 0x4fea, 0x5002, 0x501c,
	0x5035, 0x504b, 0x5062, 0x5079, 0x5090, 0x50a4, 0x50d8, 0x510c,
	0x513f, 0x5151, 0x516b, 0x5180, 0x519e, 0x51bc, 0x51e1, 0x5205,
	0x5227, 0x524a, 0x526d, 0x528f, 0x52c6, 0x52fe, 0x5335, 0x536d,
	0x53b4, 0x53fc, 0x5443, 0x548a, 0x54e2, 0x553a, 0x5591, 0x55e8,
	0x563f, 0x5696, 0x56b9, 0x56eb, 0x5703, 0x5715, 0x572a, 0x5740,
	0x576a, 0x579e, 0x57d3, 0x57fd, 0x5825, 0x5835, 0x5846, 0x5858,
	// Entry 8480 - 84BF
	0x586e, 0x5885, 0x58b3, 0x58cc, 0x58f4, 0x5919, 0x5940, 0x5966,
	0x5984, 0x5990, 0x59ad, 0x59c6, 0x59e0, 0x59f7, 0x5a10, 0x5a24,
	0x5a37, 0x5a4a, 0x5a5f, 0x5a73, 0x5a87, 0x5a9a, 0x5aaf, 0x5ac4,
	0x5ad8, 0x5af9, 0x5b1a, 0x5b3b, 0x5b5c, 0x5b7d, 0x5b9e, 0x5bbf,
	0x5be0, 0x5c01, 0x5c22, 0x5c43, 0x5c64, 0x5c85, 0x5ca6, 0x5cc7,
	0x5ce8, 0x5d09, 0x5d2a, 0x5d4b, 0x5d6c, 0x5d8d, 0x5dae, 0x5dcf,
	0x5df0, 0x5e11, 0x5e32, 0x5e53, 0x5e74, 0x5e95, 0x5eb6, 0x5ed7,
	0x5ef8, 0x5f19, 0x5f3a, 0x5f5b, 0x5f7c, 0x5f9d, 0x5fbe, 0x5fdf,
	// Entry 84C0 - 84FF
	0x6000, 0x6021, 0x6042, 0x6063, 0x6084, 0x60a5, 0x60c6, 0x60e7,
	0x6108, 0x6129, 0x614a, 0x616b, 0x618c, 0x61ad, 0x61ce, 0x61ef,
	0x6210, 0x6231, 0x6252, 0x6273, 0x6294, 0x62b5, 0x62d6, 0x62f7,
	0x6318, 0x6339, 0x635a, 0x637b, 0x639c, 0x63bd, 0x63de, 0x63ff,
	0x6420, 0x6441, 0x6462, 0x6483, 0x64a4, 0x64c5, 0x64e6, 0x6507,
	0x6528, 0x6549, 0x656a, 0x658b, 0x65ac, 0x65cd, 0x65ee, 0x660f,
	0x6630, 0x6651, 0x6672, 0x6693, 0x66b4, 0x66d5, 0x66f6, 0x6717,
	0x6738, 0x6759, 0x677a, 0x679b, 0x67bc, 0x67dd, 0x67fe, 0x681f,
	// Entry 8500 - 853F
	0x6840, 0x6861, 0x6882, 0x68a3, 0x68c4, 0x68e5, 0x6906, 0x6927,
	0x6948, 0x6969, 0x698a, 0x69ab, 0x69cc, 0x69ed, 0x6a0e, 0x6a2f,
	0x6a50, 0x6a71, 0x6a92, 0x6ab3, 0x6ad4, 0x6af5, 0x6b16, 0x6b37,
	0x6b58, 0x6b79, 0x6b9a, 0x6bbb, 0x6bdc, 0x6bfd, 0x6c1e, 0x6c3f,
	0x6c60, 0x6c81, 0x6ca2, 0x6cc3, 0x6ce4, 0x6d05, 0x6d26, 0x6d47,
	0x6d68, 0x6d89, 0x6daa, 0x6dcb, 0x6dec, 0x6e0d, 0x6e2e, 0x6e4f,
	0x6e70, 0x6e91, 0x6eb2, 0x6ed3, 0x6ef4, 0x6f15, 0x6f36, 0x6f57,
	0x6f78, 0x6f99, 0x6fba, 0x6fdb, 0x6ffc, 0x701d, 0x703e, 0x705f,
	// Entry 8540 - 857F
	0x7080, 0x70a1, 0x70c2, 0x70e3, 0x7104, 0x7125, 0x7146, 0x7167,
	0x7188, 0x71a9, 0x71ca, 0x71eb, 0x720c, 0x722d, 0x724e, 0x726f,
	0x7290, 0x72b1, 0x72d2, 0x72f3, 0x7314, 0x7335, 0x7356, 0x7377,
	0x7398, 0x73b9, 0x73da, 0x73fb, 0x741c, 0x743d, 0x745e, 0x747f,
	0x74a0, 0x74c1, 0x74e2, 0x7503, 0x7524, 0x7545, 0x7566, 0x7587,
	0x75a8, 0x75c9, 0x75ea, 0x760b, 0x762c, 0x764d, 0x766e, 0x768f,
	0x76b0, 0x76d1, 0x76f2, 0x7713, 0x7734, 0x7755, 0x7776, 0x7797,
	0x77b8, 0x77d9, 0x77fa, 0x781b, 0x783c, 0x785d, 0x787e, 0x789f,
	// Entry 8580 - 85BF
	0x78c0, 0x78e1, 0x7902, 0x7923, 0x7944, 0x7965, 0x7986, 0x79a7,
	0x79c8, 0x79e9, 0x7a0a, 0x7a2b, 0x7a4c, 0x7a6d, 0x7a8e, 0x7aaf,
	0x7ad0, 0x7af1, 0x7b12, 0x7b33, 0x7b54, 0x7b75, 0x7b96, 0x7bb7,
	0x7bd8, 0x7bf9, 0x7c1a, 0x7c3b, 0x7c5c, 0x7c7d, 0x7c9e, 0x7cbf,
	0x7ce0, 0x7d01, 0x7d22, 0x7d43, 0x7d64, 0x7d85, 0x7da6, 0x7dc7,
	0x7de8, 0x7e09, 0x7e2a, 0x7e4b, 0x7e6c, 0x7e8d, 0x7eae, 0x7ecf,
	0x7ef0, 0x7f11, 0x7f32, 0x7f53, 0x7f74, 0x7f95, 0x7fb6, 0x7fd7,
	0x7ff8, 0x8019, 0x803a, 0x805b, 0x807c, 0x809d, 0x80be, 0x80df,
	// Entry 85C0 - 85FF
	0x8100, 0x8121, 0x8142, 0x8163, 0x8184, 0x81a5, 0x81c6, 0x81e7,
	0x8208, 0x8229, 0x824a, 0x826b, 0x828c, 0x82ad, 0x82ce, 0x82ef,
	0x8310, 0x8331, 0x8352, 0x8373, 0x8394, 0x83b5, 0x83d6, 0x83f7,
	0x8418, 0x8439, 0x845a, 0x847b, 0x849c, 0x84bd, 0x84de, 0x84ff,
	0x8520, 0x8541, 0x8562, 0x8583, 0x85a4, 0x85c5, 0x85e6, 0x8607,
	0x8628, 0x8649, 0x866a, 0x868b, 0x86ac, 0x86cd, 0x86ee, 0x870f,
	0x8730, 0x8751, 0x8772, 0x8793, 0x87b4, 0x87d5, 0x87f6, 0x8817,
	0x8838, 0x8859, 0x887a, 0x889b, 0x88bc, 0x88dd, 0x88fe, 0x891f,
	// Entry 8600 - 863F
	0x8940, 0x8961, 0x8982, 0x89a3, 0x89c4, 0x89e5, 0x8a06, 0x8a27,
	0x8a48, 0x8a69, 0x8a8a, 0x8aab, 0x8acc, 0x8aed, 0x8b0e, 0x8b2f,
	0x8b50, 0x8b71, 0x8b92, 0x8bb3, 0x8bd4, 0x8bf5, 0x8c16, 0x8c37,
	0x8c58, 0x8c79, 0x8c9a, 0x8cbb, 0x8cdc, 0x8cfd, 0x8d1e, 0x8d3f,
	0x8d60, 0x8d81, 0x8da2, 0x8dc3, 0x8de4, 0x8e05, 0x8e26, 0x8e47,
	0x8e68, 0x8e89, 0x8eaa, 0x8ecb, 0x8eec, 0x8f0d, 0x8f2e, 0x8f4f,
	0x8f70, 0x8f91, 0x8fb2, 0x8fd3, 0x8ff4, 0x9015, 0x9036, 0x9057,
	0x9078, 0x9099, 0x90ba, 0x90db, 0x90fc, 0x911d, 0x913e, 0x915f,
	// Entry 8640 - 867F
	0x9180, 0x91a1, 0x91c2, 0x91e3, 0x9204, 0x9225, 0x9246, 0x9267,
	0x9288, 0x92a9, 0x92ca, 0x92eb, 0x930c, 0x932d, 0x934e, 0x936f,
	0x9390, 0x93b1, 0x93d2, 0x93f3, 0x9414, 0x9435, 0x9456, 0x9477,
	0x9498, 0x94b9, 0x94da, 0x94fb, 0x951c, 0x953d, 0x955e, 0x957f,
	0x95a0, 0x95c1, 0x95e2, 0x9603, 0x9624, 0x9645, 0x9666, 0x9687,
	0x96a8, 0x96c9, 0x96ea, 0x970b, 0x972c, 0x974d, 0x976e, 0x978f,
	0x97b0, 0x97d1, 0x97f2, 0x9813, 0x9834, 0x9855, 0x9876, 0x9897,
	0x98b8, 0x98d9, 0x98fa, 0x991b, 0x993c, 0x995d, 0x997e, 0x999f,
	// Entry 8680 - 86BF
	0x99c0, 0x99e1, 0x9a02, 0x9a23, 0x9a44, 0x9a65, 0x9a86, 0x9aa7,
	0x9ac8, 0x9ae9, 0x9b0a, 0x9b2b, 0x9b4c, 0x9b6d, 0x9b8e, 0x9baf,
	0x9bd0, 0x9bf1, 0x9c12, 0x9c33, 0x9c54, 0x9c75, 0x9c96, 0x9cb7,
	0x9cd8, 0x9cf9, 0x9d1a, 0x9d3b, 0x9d5c, 0x9d7d, 0x9d9e, 0x9dbf,
	0x9de0, 0x9e01, 0x9e22, 0x9e43, 0x9e64, 0x9e85, 0x9ea6, 0x9ec7,
	0x9ee8, 0x9f09, 0x9f2a, 0x9f4b, 0x9f6c, 0x9f8d, 0x9fae, 0x9fcf,
	0x9ff0, 0xa011, 0xa032, 0xa053, 0xa074, 0xa095, 0xa0b6, 0xa0c2,
	0xa0cb, 0xa0df, 0xa0f1, 0xa100, 0xa10f, 0xa11f, 0xa12c, 0xa13a,
	// Entry 86C0 - 86FF
	0xa14e, 0xa163, 0xa16f, 0xa17c, 0xa185, 0xa195, 0xa1a2, 0xa1ad,
	0xa1bb, 0xa1c8, 0xa1d5, 0xa1e4, 0xa1f2, 0xa200, 0xa20d, 0xa21c,
	0xa22b, 0xa239, 0xa242, 0xa24f, 0xa261, 0xa270, 0xa285, 0xa296,
	0xa2a7, 0xa2c1, 0xa2db, 0xa2f5, 0xa30f, 0xa329, 0xa343, 0xa35d,
	0xa377, 0xa391, 0xa3ab, 0xa3c5, 0xa3df, 0xa3f9, 0xa413, 0xa42d,
	0xa447, 0xa461, 0xa47b, 0xa495, 0xa4af, 0xa4c9, 0xa4e3, 0xa4fd,
	0xa517, 0xa531, 0xa54b, 0xa562, 0xa575, 0xa58d, 0xa5a2, 0xa5ae,
	0xa5be, 0xa5d6, 0xa5ee, 0xa606, 0xa61e, 0xa636, 0xa64e, 0xa666,
	// Entry 8700 - 873F
	0xa67e, 0xa696, 0xa6ae, 0xa6c6, 0xa6de, 0xa6f6, 0xa70e, 0xa726,
	0xa73e, 0xa756, 0xa76e, 0xa786, 0xa79e, 0xa7b6, 0xa7ce, 0xa7e6,
	0xa7fe, 0xa816, 0xa82e, 0xa844, 0xa855, 0xa86c, 0xa875, 0xa87f,
	0xa894, 0xa8a9, 0xa8be, 0xa8d3, 0xa8e8, 0xa8fd, 0xa912, 0xa927,
	0xa93c, 0xa951, 0xa966, 0xa97b, 0xa990, 0xa9a5, 0xa9ba, 0xa9cf,
	0xa9e4, 0xa9f9, 0xaa0e, 0xaa23, 0xaa38, 0xaa4d, 0xaa62, 0xaa77,
	0xaa8c, 0xaaa1, 0xaab6, 0xaacb, 0xaae0, 0xaaf5, 0xab0a, 0xab1f,
	0xab34, 0xab49, 0xab5e, 0xab73, 0xab88, 0xab9d, 0xabb2, 0xabc7,
	// Entry 8740 - 877F
	0xabdc, 0xabf1, 0xac06, 0xac1b, 0xac30, 0xac45, 0xac5a, 0xac6f,
	0xac84, 0xac99, 0xacae, 0xacc3, 0xacd8, 0xaced, 0xad02, 0xad17,
	0xad2c, 0xad41, 0xad56, 0xad6b, 0xad80, 0xad95, 0xadaa, 0xadbf,
	0xadd4, 0xade9, 0xadfe, 0xae13, 0xae28, 0xae3d, 0xae52, 0xae67,
	0xae7c, 0xae91, 0xaea6, 0xaebb, 0xaed0, 0xaee5, 0xaefa, 0xaf0f,
	0xaf24, 0xaf39, 0xaf4e, 0xaf64, 0xaf7a, 0xaf90, 0xafa6, 0xafbc,
	0xafd2, 0xafe8, 0xaffe, 0xb014, 0xb02a, 0xb040, 0xb056, 0xb06c,
	0xb082, 0xb098, 0xb0ae, 0xb0c4, 0xb0da, 0xb0f0, 0xb106, 0xb11c,
	// Entry 8780 - 87BF
	0xb132, 0xb148, 0xb15e, 0xb174, 0xb18a, 0xb1a0, 0xb1b6, 0xb1cc,
	0xb1e2, 0xb1f8, 0xb20e, 0xb224, 0xb23a, 0xb250, 0xb266, 0xb27c,
	0xb292, 0xb2a8, 0xb2be, 0xb2d4, 0xb2ea, 0xb300, 0xb316, 0xb32c,
	0xb342, 0xb358, 0xb36e, 0xb384, 0xb39a, 0xb3b0, 0xb3c6, 0xb3dc,
	0xb3f2, 0xb408, 0xb41e, 0xb434, 0xb44a, 0xb460, 0xb476, 0xb48c,
	0xb4a2, 0xb4b8, 0xb4ce, 0xb4e4, 0xb4fa, 0xb510, 0xb526, 0xb53c,
	0xb552, 0xb568, 0xb57e, 0xb594, 0xb5aa, 0xb5c0, 0xb5d6, 0xb5ec,
	0xb602, 0xb618, 0xb62e, 0xb644, 0xb65a, 0xb670, 0xb686, 0xb69c,
	// Entry 87C0 - 87FF
	0xb6b2, 0xb6c8, 0xb6de, 0xb6f4, 0xb70a, 0xb720, 0xb736, 0xb74c,
	0xb762, 0xb778, 0xb78e, 0xb7a4, 0xb7ba, 0xb7d0, 0xb7e6, 0xb7fc,
	0xb812, 0xb828, 0xb83e, 0xb854, 0xb86a, 0xb880, 0xb896, 0xb8ac,
	0xb8c2, 0xb8d8, 0xb8ee, 0xb904, 0xb91a, 0xb930, 0xb946, 0xb95c,
	0xb972, 0xb988, 0xb99e, 0xb9b4, 0xb9ca, 0xb9e0, 0xb9f6, 0xba0c,
	0xba22, 0xba38, 0xba4e, 0xba64, 0xba7a, 0xba90, 0xbaa6, 0xbabc,
	0xbad2, 0xbae8, 0xbafe, 0xbb14, 0xbb2a, 0xbb40, 0xbb56, 0xbb6c,
	0xbb82, 0xbb98, 0xbbae, 0xbbc4, 0xbbda, 0xbbf0, 0xbc06, 0xbc1c,
	// Entry 8800 - 883F
	0xbc32, 0xbc48, 0xbc5e, 0xbc74, 0xbc8a, 0xbca0, 0xbcb6, 0xbccc,
} // Size: 69672 bytes

const directData string = "" + // Size: 436 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph Extension G><CJK Ideograph Extension H>" +
	"<CJK Ideograph><Hangul Syllable><Low Surrogate><Non Private Use High Sur" +
	"rogate><Plane 15 Private Use><Plane 16 Private Use><Private Use High Sur" +
	"rogate><Private Use><Tangut Ideograph Supplement><Tangut Ideograph><cont" +
	"rol>"

const singleData string = ("" + // Size: 900300 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER TURNED AYBARMENIAN SMALL LETTER AYBARMENIAN SMAL" +
	"L LETTER BENARMENIAN SMALL LETTER GIMARMENIAN SMALL LETTER DAARMENIAN SM" +
	"ALL LETTER ECHARMENIAN SMALL LETTER ZAARMENIAN SMALL LETTER EHARMENIAN S" +
	"MALL LETTER ETARMENIAN SMALL LETTER TOARMENIAN SMALL LETTER ZHEARMENIAN " +
	"SMALL LETTER INIARMENIAN SMALL LETTER LIWNARMENIAN SMALL LETTER XEHARMEN" +
	"IAN SMALL LETTER CAARMENIAN SMALL LETTER KENARMENIAN SMALL LETTER HOARME" +
	"NIAN SMALL LETTER JAARMENIAN SMALL LETTER GHADARMENIAN SMALL LETTER CHEH" +
	"ARMENIAN SMALL LETTER MENARMENIAN SMALL LETTER YIARMENIAN SMALL LETTER N" +
	"OWARMENIAN SMALL LETTER SHAARMENIAN SMALL LETTER VOARMENIAN SMALL LETTER" +
	" CHAARMENIAN SMALL LETTER PEHARMENIAN SMALL LETTER JHEHARMENIAN SMALL LE" +
	"TTER RAARMENIAN SMALL LETTER SEHARMENIAN SMALL LETTER VEWARMENIAN SMALL " +
	"LETTER TIWNARMENIAN SMALL LETTER REHARMENIAN SMALL LETTER COARMENIAN SMA" +
	"LL LETTER YIWNARMENIAN SMALL LETTER PIWRARMENIAN SMALL LETTER KEHARMENIA" +
	"N SMALL LETTER OHARMENIAN SMALL LETTER FEHARMENIAN SMALL LIGATURE ECH YI" +
	"WNARMENIAN SMALL LETTER YI WITH STROKEARMENIAN FULL STOPARMENIAN HYPHENR" +
	"IGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGNARME" +
	"NIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT SHAL" +
	"SHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCENT TI" +
	"PEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW ACC" +
	"ENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH MUQ" +
	"DAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TELISHA" +
	" GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MUNAHH" +
	"EBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULAHEBR" +
	"EW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW ACC" +
	"ENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT DEHIH" +
	"EBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW POIN" +
	"T HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW POI" +
	"NT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW POI" +
	"NT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW POINT " +
	"QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATION M" +
	"AQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHEBREW" +
	" POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBREW MA" +
	"RK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANHEBRE" +
	"W LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALETHEBR" +
	"EW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEBREW " +
	"LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFHEBRE" +
	"W LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER FINA" +
	"L NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW LETTE" +
	"R FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSADIHE" +
	"BREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAVHEBR") + ("" +
	"EW YOD TRIANGLEHEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH" +
	" VAV YODHEBREW LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBRE" +
	"W PUNCTUATION GERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOT" +
	"E MARKERARABIC SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABI" +
	"C-INDIC CUBE ROOTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILL" +
	"E SIGNARABIC-INDIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC D" +
	"ATE SEPARATORARABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLAL" +
	"LAHOU ALAYHE WASSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH" +
	" ALAYHEARABIC SIGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HI" +
	"GH TAHARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH" +
	" ZAINARABIC SMALL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICO" +
	"LONARABIC LETTER MARKARABIC END OF TEXT MARKARABIC TRIPLE DOT PUNCTUATIO" +
	"N MARKARABIC QUESTION MARKARABIC LETTER KASHMIRI YEHARABIC LETTER HAMZAA" +
	"RABIC LETTER ALEF WITH MADDA ABOVEARABIC LETTER ALEF WITH HAMZA ABOVEARA" +
	"BIC LETTER WAW WITH HAMZA ABOVEARABIC LETTER ALEF WITH HAMZA BELOWARABIC" +
	" LETTER YEH WITH HAMZA ABOVEARABIC LETTER ALEFARABIC LETTER BEHARABIC LE" +
	"TTER TEH MARBUTAARABIC LETTER TEHARABIC LETTER THEHARABIC LETTER JEEMARA" +
	"BIC LETTER HAHARABIC LETTER KHAHARABIC LETTER DALARABIC LETTER THALARABI" +
	"C LETTER REHARABIC LETTER ZAINARABIC LETTER SEENARABIC LETTER SHEENARABI" +
	"C LETTER SADARABIC LETTER DADARABIC LETTER TAHARABIC LETTER ZAHARABIC LE" +
	"TTER AINARABIC LETTER GHAINARABIC LETTER KEHEH WITH TWO DOTS ABOVEARABIC" +
	" LETTER KEHEH WITH THREE DOTS BELOWARABIC LETTER FARSI YEH WITH INVERTED" +
	" VARABIC LETTER FARSI YEH WITH TWO DOTS ABOVEARABIC LETTER FARSI YEH WIT" +
	"H THREE DOTS ABOVEARABIC TATWEELARABIC LETTER FEHARABIC LETTER QAFARABIC" +
	" LETTER KAFARABIC LETTER LAMARABIC LETTER MEEMARABIC LETTER NOONARABIC L" +
	"ETTER HEHARABIC LETTER WAWARABIC LETTER ALEF MAKSURAARABIC LETTER YEHARA" +
	"BIC FATHATANARABIC DAMMATANARABIC KASRATANARABIC FATHAARABIC DAMMAARABIC" +
	" KASRAARABIC SHADDAARABIC SUKUNARABIC MADDAH ABOVEARABIC HAMZA ABOVEARAB" +
	"IC HAMZA BELOWARABIC SUBSCRIPT ALEFARABIC INVERTED DAMMAARABIC MARK NOON" +
	" GHUNNAARABIC ZWARAKAYARABIC VOWEL SIGN SMALL V ABOVEARABIC VOWEL SIGN I" +
	"NVERTED SMALL V ABOVEARABIC VOWEL SIGN DOT BELOWARABIC REVERSED DAMMAARA" +
	"BIC FATHA WITH TWO DOTSARABIC WAVY HAMZA BELOWARABIC-INDIC DIGIT ZEROARA" +
	"BIC-INDIC DIGIT ONEARABIC-INDIC DIGIT TWOARABIC-INDIC DIGIT THREEARABIC-" +
	"INDIC DIGIT FOURARABIC-INDIC DIGIT FIVEARABIC-INDIC DIGIT SIXARABIC-INDI" +
	"C DIGIT SEVENARABIC-INDIC DIGIT EIGHTARABIC-INDIC DIGIT NINEARABIC PERCE" +
	"NT SIGNARABIC DECIMAL SEPARATORARABIC THOUSANDS SEPARATORARABIC FIVE POI" +
	"NTED STARARABIC LETTER DOTLESS BEHARABIC LETTER DOTLESS QAFARABIC LETTER" +
	" SUPERSCRIPT ALEFARABIC LETTER ALEF WASLAARABIC LETTER ALEF WITH WAVY HA" +
	"MZA ABOVEARABIC LETTER ALEF WITH WAVY HAMZA BELOWARABIC LETTER HIGH HAMZ" +
	"AARABIC LETTER HIGH HAMZA ALEFARABIC LETTER HIGH HAMZA WAWARABIC LETTER " +
	"U WITH HAMZA ABOVEARABIC LETTER HIGH HAMZA YEHARABIC LETTER TTEHARABIC L" +
	"ETTER TTEHEHARABIC LETTER BEEHARABIC LETTER TEH WITH RINGARABIC LETTER T" +
	"EH WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER PEHARABIC LETTER TEHEHAR" +
	"ABIC LETTER BEHEHARABIC LETTER HAH WITH HAMZA ABOVEARABIC LETTER HAH WIT" +
	"H TWO DOTS VERTICAL ABOVEARABIC LETTER NYEHARABIC LETTER DYEHARABIC LETT" +
	"ER HAH WITH THREE DOTS ABOVEARABIC LETTER TCHEHARABIC LETTER TCHEHEHARAB" +
	"IC LETTER DDALARABIC LETTER DAL WITH RINGARABIC LETTER DAL WITH DOT BELO" +
	"WARABIC LETTER DAL WITH DOT BELOW AND SMALL TAHARABIC LETTER DAHALARABIC" +
	" LETTER DDAHALARABIC LETTER DULARABIC LETTER DAL WITH THREE DOTS ABOVE D" +
	"OWNWARDSARABIC LETTER DAL WITH FOUR DOTS ABOVEARABIC LETTER RREHARABIC L" +
	"ETTER REH WITH SMALL VARABIC LETTER REH WITH RINGARABIC LETTER REH WITH " +
	"DOT BELOWARABIC LETTER REH WITH SMALL V BELOWARABIC LETTER REH WITH DOT " +
	"BELOW AND DOT ABOVEARABIC LETTER REH WITH TWO DOTS ABOVEARABIC LETTER JE" +
	"HARABIC LETTER REH WITH FOUR DOTS ABOVEARABIC LETTER SEEN WITH DOT BELOW" +
	" AND DOT ABOVEARABIC LETTER SEEN WITH THREE DOTS BELOWARABIC LETTER SEEN" +
	" WITH THREE DOTS BELOW AND THREE DOTS ABOVEARABIC LETTER SAD WITH TWO DO" +
	"TS BELOWARABIC LETTER SAD WITH THREE DOTS ABOVEARABIC LETTER TAH WITH TH" +
	"REE DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS ABOVEARABIC LETTER DOTLE" +
	"SS FEHARABIC LETTER FEH WITH DOT MOVED BELOWARABIC LETTER FEH WITH DOT B" +
	"ELOWARABIC LETTER VEHARABIC LETTER FEH WITH THREE DOTS BELOWARABIC LETTE" +
	"R PEHEHARABIC LETTER QAF WITH DOT ABOVEARABIC LETTER QAF WITH THREE DOTS" +
	" ABOVEARABIC LETTER KEHEHARABIC LETTER SWASH KAFARABIC LETTER KAF WITH R" +
	"INGARABIC LETTER KAF WITH DOT ABOVEARABIC LETTER NGARABIC LETTER KAF WIT" +
	"H THREE DOTS BELOWARABIC LETTER GAFARABIC LETTER GAF WITH RINGARABIC LET") + ("" +
	"TER NGOEHARABIC LETTER GAF WITH TWO DOTS BELOWARABIC LETTER GUEHARABIC L" +
	"ETTER GAF WITH THREE DOTS ABOVEARABIC LETTER LAM WITH SMALL VARABIC LETT" +
	"ER LAM WITH DOT ABOVEARABIC LETTER LAM WITH THREE DOTS ABOVEARABIC LETTE" +
	"R LAM WITH THREE DOTS BELOWARABIC LETTER NOON WITH DOT BELOWARABIC LETTE" +
	"R NOON GHUNNAARABIC LETTER RNOONARABIC LETTER NOON WITH RINGARABIC LETTE" +
	"R NOON WITH THREE DOTS ABOVEARABIC LETTER HEH DOACHASHMEEARABIC LETTER T" +
	"CHEH WITH DOT ABOVEARABIC LETTER HEH WITH YEH ABOVEARABIC LETTER HEH GOA" +
	"LARABIC LETTER HEH GOAL WITH HAMZA ABOVEARABIC LETTER TEH MARBUTA GOALAR" +
	"ABIC LETTER WAW WITH RINGARABIC LETTER KIRGHIZ OEARABIC LETTER OEARABIC " +
	"LETTER UARABIC LETTER YUARABIC LETTER KIRGHIZ YUARABIC LETTER WAW WITH T" +
	"WO DOTS ABOVEARABIC LETTER VEARABIC LETTER FARSI YEHARABIC LETTER YEH WI" +
	"TH TAILARABIC LETTER YEH WITH SMALL VARABIC LETTER WAW WITH DOT ABOVEARA" +
	"BIC LETTER EARABIC LETTER YEH WITH THREE DOTS BELOWARABIC LETTER YEH BAR" +
	"REEARABIC LETTER YEH BARREE WITH HAMZA ABOVEARABIC FULL STOPARABIC LETTE" +
	"R AEARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURAARABIC SMAL" +
	"L HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURAARABIC SMALL HIGH MEEM INI" +
	"TIAL FORMARABIC SMALL HIGH LAM ALEFARABIC SMALL HIGH JEEMARABIC SMALL HI" +
	"GH THREE DOTSARABIC SMALL HIGH SEENARABIC END OF AYAHARABIC START OF RUB" +
	" EL HIZBARABIC SMALL HIGH ROUNDED ZEROARABIC SMALL HIGH UPRIGHT RECTANGU" +
	"LAR ZEROARABIC SMALL HIGH DOTLESS HEAD OF KHAHARABIC SMALL HIGH MEEM ISO" +
	"LATED FORMARABIC SMALL LOW SEENARABIC SMALL HIGH MADDAARABIC SMALL WAWAR" +
	"ABIC SMALL YEHARABIC SMALL HIGH YEHARABIC SMALL HIGH NOONARABIC PLACE OF" +
	" SAJDAHARABIC EMPTY CENTRE LOW STOPARABIC EMPTY CENTRE HIGH STOPARABIC R" +
	"OUNDED HIGH STOP WITH FILLED CENTREARABIC SMALL LOW MEEMARABIC LETTER DA" +
	"L WITH INVERTED VARABIC LETTER REH WITH INVERTED VEXTENDED ARABIC-INDIC " +
	"DIGIT ZEROEXTENDED ARABIC-INDIC DIGIT ONEEXTENDED ARABIC-INDIC DIGIT TWO" +
	"EXTENDED ARABIC-INDIC DIGIT THREEEXTENDED ARABIC-INDIC DIGIT FOUREXTENDE" +
	"D ARABIC-INDIC DIGIT FIVEEXTENDED ARABIC-INDIC DIGIT SIXEXTENDED ARABIC-" +
	"INDIC DIGIT SEVENEXTENDED ARABIC-INDIC DIGIT EIGHTEXTENDED ARABIC-INDIC " +
	"DIGIT NINEARABIC LETTER SHEEN WITH DOT BELOWARABIC LETTER DAD WITH DOT B" +
	"ELOWARABIC LETTER GHAIN WITH DOT BELOWARABIC SIGN SINDHI AMPERSANDARABIC" +
	" SIGN SINDHI POSTPOSITION MENARABIC LETTER HEH WITH INVERTED VSYRIAC END" +
	" OF PARAGRAPHSYRIAC SUPRALINEAR FULL STOPSYRIAC SUBLINEAR FULL STOPSYRIA" +
	"C SUPRALINEAR COLONSYRIAC SUBLINEAR COLONSYRIAC HORIZONTAL COLONSYRIAC C" +
	"OLON SKEWED LEFTSYRIAC COLON SKEWED RIGHTSYRIAC SUPRALINEAR COLON SKEWED" +
	" LEFTSYRIAC SUBLINEAR COLON SKEWED RIGHTSYRIAC CONTRACTIONSYRIAC HARKLEA" +
	"N OBELUSSYRIAC HARKLEAN METOBELUSSYRIAC HARKLEAN ASTERISCUSSYRIAC ABBREV" +
	"IATION MARKSYRIAC LETTER ALAPHSYRIAC LETTER SUPERSCRIPT ALAPHSYRIAC LETT" +
	"ER BETHSYRIAC LETTER GAMALSYRIAC LETTER GAMAL GARSHUNISYRIAC LETTER DALA" +
	"THSYRIAC LETTER DOTLESS DALATH RISHSYRIAC LETTER HESYRIAC LETTER WAWSYRI" +
	"AC LETTER ZAINSYRIAC LETTER HETHSYRIAC LETTER TETHSYRIAC LETTER TETH GAR" +
	"SHUNISYRIAC LETTER YUDHSYRIAC LETTER YUDH HESYRIAC LETTER KAPHSYRIAC LET" +
	"TER LAMADHSYRIAC LETTER MIMSYRIAC LETTER NUNSYRIAC LETTER SEMKATHSYRIAC " +
	"LETTER FINAL SEMKATHSYRIAC LETTER ESYRIAC LETTER PESYRIAC LETTER REVERSE" +
	"D PESYRIAC LETTER SADHESYRIAC LETTER QAPHSYRIAC LETTER RISHSYRIAC LETTER" +
	" SHINSYRIAC LETTER TAWSYRIAC LETTER PERSIAN BHETHSYRIAC LETTER PERSIAN G" +
	"HAMALSYRIAC LETTER PERSIAN DHALATHSYRIAC PTHAHA ABOVESYRIAC PTHAHA BELOW" +
	"SYRIAC PTHAHA DOTTEDSYRIAC ZQAPHA ABOVESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA " +
	"DOTTEDSYRIAC RBASA ABOVESYRIAC RBASA BELOWSYRIAC DOTTED ZLAMA HORIZONTAL" +
	"SYRIAC DOTTED ZLAMA ANGULARSYRIAC HBASA ABOVESYRIAC HBASA BELOWSYRIAC HB" +
	"ASA-ESASA DOTTEDSYRIAC ESASA ABOVESYRIAC ESASA BELOWSYRIAC RWAHASYRIAC F" +
	"EMININE DOTSYRIAC QUSHSHAYASYRIAC RUKKAKHASYRIAC TWO VERTICAL DOTS ABOVE" +
	"SYRIAC TWO VERTICAL DOTS BELOWSYRIAC THREE DOTS ABOVESYRIAC THREE DOTS B" +
	"ELOWSYRIAC OBLIQUE LINE ABOVESYRIAC OBLIQUE LINE BELOWSYRIAC MUSICSYRIAC" +
	" BARREKHSYRIAC LETTER SOGDIAN ZHAINSYRIAC LETTER SOGDIAN KHAPHSYRIAC LET" +
	"TER SOGDIAN FEARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOWARABIC" +
	" LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER BEH WITH TH" +
	"REE DOTS POINTING UPWARDS BELOWARABIC LETTER BEH WITH THREE DOTS POINTIN" +
	"G UPWARDS BELOW AND TWO DOTS ABOVEARABIC LETTER BEH WITH TWO DOTS BELOW " +
	"AND DOT ABOVEARABIC LETTER BEH WITH INVERTED SMALL V BELOWARABIC LETTER " +
	"BEH WITH SMALL VARABIC LETTER HAH WITH TWO DOTS ABOVEARABIC LETTER HAH W" +
	"ITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER DAL WITH TWO DOTS VER" +
	"TICALLY BELOW AND SMALL TAHARABIC LETTER DAL WITH INVERTED SMALL V BELOW" +
	"ARABIC LETTER REH WITH STROKEARABIC LETTER SEEN WITH FOUR DOTS ABOVEARAB") + ("" +
	"IC LETTER AIN WITH TWO DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS POINT" +
	"ING DOWNWARDS ABOVEARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVEARABI" +
	"C LETTER FEH WITH TWO DOTS BELOWARABIC LETTER FEH WITH THREE DOTS POINTI" +
	"NG UPWARDS BELOWARABIC LETTER KEHEH WITH DOT ABOVEARABIC LETTER KEHEH WI" +
	"TH THREE DOTS ABOVEARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS " +
	"BELOWARABIC LETTER MEEM WITH DOT ABOVEARABIC LETTER MEEM WITH DOT BELOWA" +
	"RABIC LETTER NOON WITH TWO DOTS BELOWARABIC LETTER NOON WITH SMALL TAHAR" +
	"ABIC LETTER NOON WITH SMALL VARABIC LETTER LAM WITH BARARABIC LETTER REH" +
	" WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER REH WITH HAMZA ABOVEARABIC " +
	"LETTER SEEN WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER HAH WITH SMALL A" +
	"RABIC LETTER TAH BELOWARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND" +
	" TWO DOTSARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTSARA" +
	"BIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER HA" +
	"H WITH SMALL ARABIC LETTER TAH ABOVEARABIC LETTER ALEF WITH EXTENDED ARA" +
	"BIC-INDIC DIGIT TWO ABOVEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC D" +
	"IGIT THREE ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT" +
	" TWO ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE" +
	" ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELO" +
	"WARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETT" +
	"ER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER YEH BAR" +
	"REE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER YEH BARREE W" +
	"ITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER HAH WITH EXTEND" +
	"ED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER SEEN WITH EXTENDED ARABIC-" +
	"INDIC DIGIT FOUR ABOVEARABIC LETTER SEEN WITH INVERTED VARABIC LETTER KA" +
	"F WITH TWO DOTS ABOVETHAANA LETTER HAATHAANA LETTER SHAVIYANITHAANA LETT" +
	"ER NOONUTHAANA LETTER RAATHAANA LETTER BAATHAANA LETTER LHAVIYANITHAANA " +
	"LETTER KAAFUTHAANA LETTER ALIFUTHAANA LETTER VAAVUTHAANA LETTER MEEMUTHA" +
	"ANA LETTER FAAFUTHAANA LETTER DHAALUTHAANA LETTER THAATHAANA LETTER LAAM" +
	"UTHAANA LETTER GAAFUTHAANA LETTER GNAVIYANITHAANA LETTER SEENUTHAANA LET" +
	"TER DAVIYANITHAANA LETTER ZAVIYANITHAANA LETTER TAVIYANITHAANA LETTER YA" +
	"ATHAANA LETTER PAVIYANITHAANA LETTER JAVIYANITHAANA LETTER CHAVIYANITHAA" +
	"NA LETTER TTAATHAANA LETTER HHAATHAANA LETTER KHAATHAANA LETTER THAALUTH" +
	"AANA LETTER ZAATHAANA LETTER SHEENUTHAANA LETTER SAADHUTHAANA LETTER DAA" +
	"DHUTHAANA LETTER TOTHAANA LETTER ZOTHAANA LETTER AINUTHAANA LETTER GHAIN" +
	"UTHAANA LETTER QAAFUTHAANA LETTER WAAVUTHAANA ABAFILITHAANA AABAAFILITHA" +
	"ANA IBIFILITHAANA EEBEEFILITHAANA UBUFILITHAANA OOBOOFILITHAANA EBEFILIT" +
	"HAANA EYBEYFILITHAANA OBOFILITHAANA OABOAFILITHAANA SUKUNTHAANA LETTER N" +
	"AANKO DIGIT ZERONKO DIGIT ONENKO DIGIT TWONKO DIGIT THREENKO DIGIT FOURN" +
	"KO DIGIT FIVENKO DIGIT SIXNKO DIGIT SEVENNKO DIGIT EIGHTNKO DIGIT NINENK" +
	"O LETTER ANKO LETTER EENKO LETTER INKO LETTER ENKO LETTER UNKO LETTER OO" +
	"NKO LETTER ONKO LETTER DAGBASINNANKO LETTER NNKO LETTER BANKO LETTER PAN" +
	"KO LETTER TANKO LETTER JANKO LETTER CHANKO LETTER DANKO LETTER RANKO LET" +
	"TER RRANKO LETTER SANKO LETTER GBANKO LETTER FANKO LETTER KANKO LETTER L" +
	"ANKO LETTER NA WOLOSONKO LETTER MANKO LETTER NYANKO LETTER NANKO LETTER " +
	"HANKO LETTER WANKO LETTER YANKO LETTER NYA WOLOSONKO LETTER JONA JANKO L" +
	"ETTER JONA CHANKO LETTER JONA RANKO COMBINING SHORT HIGH TONENKO COMBINI" +
	"NG SHORT LOW TONENKO COMBINING SHORT RISING TONENKO COMBINING LONG DESCE" +
	"NDING TONENKO COMBINING LONG HIGH TONENKO COMBINING LONG LOW TONENKO COM" +
	"BINING LONG RISING TONENKO COMBINING NASALIZATION MARKNKO COMBINING DOUB" +
	"LE DOT ABOVENKO HIGH TONE APOSTROPHENKO LOW TONE APOSTROPHENKO SYMBOL OO" +
	" DENNENNKO SYMBOL GBAKURUNENNKO COMMANKO EXCLAMATION MARKNKO LAJANYALANN" +
	"KO DANTAYALANNKO DOROME SIGNNKO TAMAN SIGNSAMARITAN LETTER ALAFSAMARITAN" +
	" LETTER BITSAMARITAN LETTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER " +
	"IYSAMARITAN LETTER BAASAMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN L" +
	"ETTER TITSAMARITAN LETTER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABAT" +
	"SAMARITAN LETTER MIMSAMARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITA" +
	"N LETTER INSAMARITAN LETTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER Q" +
	"UFSAMARITAN LETTER RISHSAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARIT" +
	"AN MARK INSAMARITAN MARK IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK D" +
	"AGESHSAMARITAN MODIFIER LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC Y" +
	"UTSAMARITAN VOWEL SIGN LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN " +
	"OVERLONG AASAMARITAN VOWEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN " +
	"VOWEL SIGN OVERLONG ASAMARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASA" +
	"MARITAN MODIFIER LETTER SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOW") + ("" +
	"EL SIGN LONG USAMARITAN VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN" +
	" VOWEL SIGN LONG ISAMARITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN " +
	"VOWEL SIGN SUKUNSAMARITAN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMAR" +
	"ITAN PUNCTUATION AFSAAQSAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION " +
	"BAUSAMARITAN PUNCTUATION ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN" +
	" ABBREVIATION MARKSAMARITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATI" +
	"ON ZIQAASAMARITAN PUNCTUATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN P" +
	"UNCTUATION TURUSAMARITAN PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MA" +
	"SHFAATSAMARITAN PUNCTUATION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABM" +
	"ANDAIC LETTER AGMANDAIC LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNA" +
	"MANDAIC LETTER AZMANDAIC LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAM" +
	"ANDAIC LETTER AKMANDAIC LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDA" +
	"IC LETTER ASMANDAIC LETTER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC " +
	"LETTER AQMANDAIC LETTER ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LET" +
	"TER DUSHENNAMANDAIC LETTER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARK" +
	"MANDAIC VOCALIZATION MARKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIA" +
	"C LETTER MALAYALAM NGASYRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM " +
	"NYASYRIAC LETTER MALAYALAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER M" +
	"ALAYALAM NNNASYRIAC LETTER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC" +
	" LETTER MALAYALAM LLASYRIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM" +
	" SSAARABIC LETTER ALEF WITH ATTACHED FATHAARABIC LETTER ALEF WITH ATTACH" +
	"ED TOP RIGHT FATHAARABIC LETTER ALEF WITH RIGHT MIDDLE STROKEARABIC LETT" +
	"ER ALEF WITH LEFT MIDDLE STROKEARABIC LETTER ALEF WITH ATTACHED KASRAARA" +
	"BIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRAARABIC LETTER ALEF WITH " +
	"ATTACHED ROUND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED RIGHT ROUND DOT" +
	"ARABIC LETTER ALEF WITH ATTACHED LEFT ROUND DOTARABIC LETTER ALEF WITH A" +
	"TTACHED ROUND DOT BELOWARABIC LETTER ALEF WITH DOT ABOVEARABIC LETTER AL" +
	"EF WITH ATTACHED TOP RIGHT FATHA AND DOT ABOVEARABIC LETTER ALEF WITH RI" +
	"GHT MIDDLE STROKE AND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED BOTTOM R" +
	"IGHT KASRA AND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA" +
	" AND LEFT RINGARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND LEFT RINGA" +
	"RABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND LEFT RINGARABIC L" +
	"ETTER ALEF WITH ATTACHED RIGHT HAMZAARABIC LETTER ALEF WITH ATTACHED LEF" +
	"T HAMZAARABIC TATWEEL WITH OVERSTRUCK HAMZAARABIC TATWEEL WITH OVERSTRUC" +
	"K WAWARABIC TATWEEL WITH TWO DOTS BELOWARABIC LETTER THIN YEHARABIC BASE" +
	"LINE ROUND DOTARABIC RAISED ROUND DOTARABIC LETTER NOON WITH INVERTED SM" +
	"ALL VARABIC LETTER HAH WITH INVERTED SMALL V BELOWARABIC LETTER TAH WITH" +
	" DOT BELOWARABIC LETTER TAH WITH THREE DOTS BELOWARABIC LETTER KEHEH WIT" +
	"H TWO DOTS VERTICALLY BELOWARABIC VERTICAL TAILARABIC POUND MARK ABOVEAR" +
	"ABIC PIASTRE MARK ABOVEARABIC SMALL HIGH WORD AL-JUZARABIC SMALL LOW WOR" +
	"D ISHMAAMARABIC SMALL LOW WORD IMAALAARABIC SMALL LOW WORD TASHEELARABIC" +
	" MADDA WAAJIBARABIC SUPERSCRIPT ALEF MOKHASSASARABIC DOUBLED MADDAARABIC" +
	" HALF MADDA OVER MADDAARABIC LETTER BEH WITH SMALL V BELOWARABIC LETTER " +
	"BEH WITH HAMZA ABOVEARABIC LETTER JEEM WITH TWO DOTS ABOVEARABIC LETTER " +
	"TAH WITH TWO DOTS ABOVEARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS A" +
	"BOVEARABIC LETTER QAF WITH DOT BELOWARABIC LETTER LAM WITH DOUBLE BARARA" +
	"BIC LETTER MEEM WITH THREE DOTS ABOVEARABIC LETTER YEH WITH TWO DOTS BEL" +
	"OW AND HAMZA ABOVEARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVEARA" +
	"BIC LETTER REH WITH LOOPARABIC LETTER WAW WITH DOT WITHINARABIC LETTER R" +
	"OHINGYA YEHARABIC LETTER LOW ALEFARABIC LETTER DAL WITH THREE DOTS BELOW" +
	"ARABIC LETTER SAD WITH THREE DOTS BELOWARABIC LETTER GAF WITH INVERTED S" +
	"TROKEARABIC LETTER STRAIGHT WAWARABIC LETTER ZAIN WITH INVERTED V ABOVEA" +
	"RABIC LETTER AIN WITH THREE DOTS BELOWARABIC LETTER KAF WITH DOT BELOWAR" +
	"ABIC LETTER QAF WITH DOT BELOW AND NO DOTS ABOVEARABIC LETTER BEH WITH S" +
	"MALL MEEM ABOVEARABIC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH " +
	"WITH SMALL TEH ABOVEARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER" +
	" YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHAR" +
	"ABIC LETTER AFRICAN QAFARABIC LETTER AFRICAN NOONARABIC LETTER PEH WITH " +
	"SMALL VARABIC LETTER TEH WITH SMALL VARABIC LETTER TTEH WITH SMALL VARAB" +
	"IC LETTER TCHEH WITH SMALL VARABIC LETTER KEHEH WITH SMALL VARABIC LETTE" +
	"R GHAIN WITH THREE DOTS ABOVEARABIC LETTER AFRICAN QAF WITH THREE DOTS A" +
	"BOVEARABIC LETTER JEEM WITH THREE DOTS ABOVEARABIC LETTER JEEM WITH THRE" +
	"E DOTS BELOWARABIC LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVEARABIC L" +
	"ETTER GRAFARABIC SMALL FARSI YEHARABIC SMALL HIGH FARSI YEHARABIC SMALL ") + ("" +
	"HIGH YEH BARREE WITH TWO DOTS BELOWARABIC SMALL HIGH WORD SAHARABIC SMAL" +
	"L HIGH ZAHARABIC LARGE ROUND DOT ABOVEARABIC LARGE ROUND DOT BELOWARABIC" +
	" SUKUN BELOWARABIC LARGE CIRCLE BELOWARABIC LARGE ROUND DOT INSIDE CIRCL" +
	"E BELOWARABIC SMALL LOW WAWARABIC SMALL HIGH WORD AR-RUBARABIC SMALL HIG" +
	"H SADARABIC SMALL HIGH AINARABIC SMALL HIGH QAFARABIC SMALL HIGH NOON WI" +
	"TH KASRAARABIC SMALL LOW NOON WITH KASRAARABIC SMALL HIGH WORD ATH-THALA" +
	"THAARABIC SMALL HIGH WORD AS-SAJDAARABIC SMALL HIGH WORD AN-NISFARABIC S" +
	"MALL HIGH WORD SAKTAARABIC SMALL HIGH WORD QIFARABIC SMALL HIGH WORD WAQ" +
	"FAARABIC SMALL HIGH FOOTNOTE MARKERARABIC SMALL HIGH SIGN SAFHAARABIC DI" +
	"SPUTED END OF AYAHARABIC TURNED DAMMA BELOWARABIC CURLY FATHAARABIC CURL" +
	"Y DAMMAARABIC CURLY KASRAARABIC CURLY FATHATANARABIC CURLY DAMMATANARABI" +
	"C CURLY KASRATANARABIC TONE ONE DOT ABOVEARABIC TONE TWO DOTS ABOVEARABI" +
	"C TONE LOOP ABOVEARABIC TONE ONE DOT BELOWARABIC TONE TWO DOTS BELOWARAB" +
	"IC TONE LOOP BELOWARABIC OPEN FATHATANARABIC OPEN DAMMATANARABIC OPEN KA" +
	"SRATANARABIC SMALL HIGH WAWARABIC FATHA WITH RINGARABIC FATHA WITH DOT A" +
	"BOVEARABIC KASRA WITH DOT BELOWARABIC LEFT ARROWHEAD ABOVEARABIC RIGHT A" +
	"RROWHEAD ABOVEARABIC LEFT ARROWHEAD BELOWARABIC RIGHT ARROWHEAD BELOWARA" +
	"BIC DOUBLE RIGHT ARROWHEAD ABOVEARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH" +
	" DOTARABIC RIGHT ARROWHEAD ABOVE WITH DOTARABIC DAMMA WITH DOTARABIC MAR" +
	"K SIDEWAYS NOON GHUNNADEVANAGARI SIGN INVERTED CANDRABINDUDEVANAGARI SIG" +
	"N CANDRABINDUDEVANAGARI SIGN ANUSVARADEVANAGARI SIGN VISARGADEVANAGARI L" +
	"ETTER SHORT ADEVANAGARI LETTER ADEVANAGARI LETTER AADEVANAGARI LETTER ID" +
	"EVANAGARI LETTER IIDEVANAGARI LETTER UDEVANAGARI LETTER UUDEVANAGARI LET" +
	"TER VOCALIC RDEVANAGARI LETTER VOCALIC LDEVANAGARI LETTER CANDRA EDEVANA" +
	"GARI LETTER SHORT EDEVANAGARI LETTER EDEVANAGARI LETTER AIDEVANAGARI LET" +
	"TER CANDRA ODEVANAGARI LETTER SHORT ODEVANAGARI LETTER ODEVANAGARI LETTE" +
	"R AUDEVANAGARI LETTER KADEVANAGARI LETTER KHADEVANAGARI LETTER GADEVANAG" +
	"ARI LETTER GHADEVANAGARI LETTER NGADEVANAGARI LETTER CADEVANAGARI LETTER" +
	" CHADEVANAGARI LETTER JADEVANAGARI LETTER JHADEVANAGARI LETTER NYADEVANA" +
	"GARI LETTER TTADEVANAGARI LETTER TTHADEVANAGARI LETTER DDADEVANAGARI LET" +
	"TER DDHADEVANAGARI LETTER NNADEVANAGARI LETTER TADEVANAGARI LETTER THADE" +
	"VANAGARI LETTER DADEVANAGARI LETTER DHADEVANAGARI LETTER NADEVANAGARI LE" +
	"TTER NNNADEVANAGARI LETTER PADEVANAGARI LETTER PHADEVANAGARI LETTER BADE" +
	"VANAGARI LETTER BHADEVANAGARI LETTER MADEVANAGARI LETTER YADEVANAGARI LE" +
	"TTER RADEVANAGARI LETTER RRADEVANAGARI LETTER LADEVANAGARI LETTER LLADEV" +
	"ANAGARI LETTER LLLADEVANAGARI LETTER VADEVANAGARI LETTER SHADEVANAGARI L" +
	"ETTER SSADEVANAGARI LETTER SADEVANAGARI LETTER HADEVANAGARI VOWEL SIGN O" +
	"EDEVANAGARI VOWEL SIGN OOEDEVANAGARI SIGN NUKTADEVANAGARI SIGN AVAGRAHAD" +
	"EVANAGARI VOWEL SIGN AADEVANAGARI VOWEL SIGN IDEVANAGARI VOWEL SIGN IIDE" +
	"VANAGARI VOWEL SIGN UDEVANAGARI VOWEL SIGN UUDEVANAGARI VOWEL SIGN VOCAL" +
	"IC RDEVANAGARI VOWEL SIGN VOCALIC RRDEVANAGARI VOWEL SIGN CANDRA EDEVANA" +
	"GARI VOWEL SIGN SHORT EDEVANAGARI VOWEL SIGN EDEVANAGARI VOWEL SIGN AIDE" +
	"VANAGARI VOWEL SIGN CANDRA ODEVANAGARI VOWEL SIGN SHORT ODEVANAGARI VOWE" +
	"L SIGN ODEVANAGARI VOWEL SIGN AUDEVANAGARI SIGN VIRAMADEVANAGARI VOWEL S" +
	"IGN PRISHTHAMATRA EDEVANAGARI VOWEL SIGN AWDEVANAGARI OMDEVANAGARI STRES" +
	"S SIGN UDATTADEVANAGARI STRESS SIGN ANUDATTADEVANAGARI GRAVE ACCENTDEVAN" +
	"AGARI ACUTE ACCENTDEVANAGARI VOWEL SIGN CANDRA LONG EDEVANAGARI VOWEL SI" +
	"GN UEDEVANAGARI VOWEL SIGN UUEDEVANAGARI LETTER QADEVANAGARI LETTER KHHA" +
	"DEVANAGARI LETTER GHHADEVANAGARI LETTER ZADEVANAGARI LETTER DDDHADEVANAG" +
	"ARI LETTER RHADEVANAGARI LETTER FADEVANAGARI LETTER YYADEVANAGARI LETTER" +
	" VOCALIC RRDEVANAGARI LETTER VOCALIC LLDEVANAGARI VOWEL SIGN VOCALIC LDE" +
	"VANAGARI VOWEL SIGN VOCALIC LLDEVANAGARI DANDADEVANAGARI DOUBLE DANDADEV" +
	"ANAGARI DIGIT ZERODEVANAGARI DIGIT ONEDEVANAGARI DIGIT TWODEVANAGARI DIG" +
	"IT THREEDEVANAGARI DIGIT FOURDEVANAGARI DIGIT FIVEDEVANAGARI DIGIT SIXDE" +
	"VANAGARI DIGIT SEVENDEVANAGARI DIGIT EIGHTDEVANAGARI DIGIT NINEDEVANAGAR" +
	"I ABBREVIATION SIGNDEVANAGARI SIGN HIGH SPACING DOTDEVANAGARI LETTER CAN" +
	"DRA ADEVANAGARI LETTER OEDEVANAGARI LETTER OOEDEVANAGARI LETTER AWDEVANA" +
	"GARI LETTER UEDEVANAGARI LETTER UUEDEVANAGARI LETTER MARWARI DDADEVANAGA" +
	"RI LETTER ZHADEVANAGARI LETTER HEAVY YADEVANAGARI LETTER GGADEVANAGARI L" +
	"ETTER JJADEVANAGARI LETTER GLOTTAL STOPDEVANAGARI LETTER DDDADEVANAGARI " +
	"LETTER BBABENGALI ANJIBENGALI SIGN CANDRABINDUBENGALI SIGN ANUSVARABENGA" +
	"LI SIGN VISARGABENGALI LETTER ABENGALI LETTER AABENGALI LETTER IBENGALI " +
	"LETTER IIBENGALI LETTER UBENGALI LETTER UUBENGALI LETTER VOCALIC RBENGAL" +
	"I LETTER VOCALIC LBENGALI LETTER EBENGALI LETTER AIBENGALI LETTER OBENGA") + ("" +
	"LI LETTER AUBENGALI LETTER KABENGALI LETTER KHABENGALI LETTER GABENGALI " +
	"LETTER GHABENGALI LETTER NGABENGALI LETTER CABENGALI LETTER CHABENGALI L" +
	"ETTER JABENGALI LETTER JHABENGALI LETTER NYABENGALI LETTER TTABENGALI LE" +
	"TTER TTHABENGALI LETTER DDABENGALI LETTER DDHABENGALI LETTER NNABENGALI " +
	"LETTER TABENGALI LETTER THABENGALI LETTER DABENGALI LETTER DHABENGALI LE" +
	"TTER NABENGALI LETTER PABENGALI LETTER PHABENGALI LETTER BABENGALI LETTE" +
	"R BHABENGALI LETTER MABENGALI LETTER YABENGALI LETTER RABENGALI LETTER L" +
	"ABENGALI LETTER SHABENGALI LETTER SSABENGALI LETTER SABENGALI LETTER HAB" +
	"ENGALI SIGN NUKTABENGALI SIGN AVAGRAHABENGALI VOWEL SIGN AABENGALI VOWEL" +
	" SIGN IBENGALI VOWEL SIGN IIBENGALI VOWEL SIGN UBENGALI VOWEL SIGN UUBEN" +
	"GALI VOWEL SIGN VOCALIC RBENGALI VOWEL SIGN VOCALIC RRBENGALI VOWEL SIGN" +
	" EBENGALI VOWEL SIGN AIBENGALI VOWEL SIGN OBENGALI VOWEL SIGN AUBENGALI " +
	"SIGN VIRAMABENGALI LETTER KHANDA TABENGALI AU LENGTH MARKBENGALI LETTER " +
	"RRABENGALI LETTER RHABENGALI LETTER YYABENGALI LETTER VOCALIC RRBENGALI " +
	"LETTER VOCALIC LLBENGALI VOWEL SIGN VOCALIC LBENGALI VOWEL SIGN VOCALIC " +
	"LLBENGALI DIGIT ZEROBENGALI DIGIT ONEBENGALI DIGIT TWOBENGALI DIGIT THRE" +
	"EBENGALI DIGIT FOURBENGALI DIGIT FIVEBENGALI DIGIT SIXBENGALI DIGIT SEVE" +
	"NBENGALI DIGIT EIGHTBENGALI DIGIT NINEBENGALI LETTER RA WITH MIDDLE DIAG" +
	"ONALBENGALI LETTER RA WITH LOWER DIAGONALBENGALI RUPEE MARKBENGALI RUPEE" +
	" SIGNBENGALI CURRENCY NUMERATOR ONEBENGALI CURRENCY NUMERATOR TWOBENGALI" +
	" CURRENCY NUMERATOR THREEBENGALI CURRENCY NUMERATOR FOURBENGALI CURRENCY" +
	" NUMERATOR ONE LESS THAN THE DENOMINATORBENGALI CURRENCY DENOMINATOR SIX" +
	"TEENBENGALI ISSHARBENGALI GANDA MARKBENGALI LETTER VEDIC ANUSVARABENGALI" +
	" ABBREVIATION SIGNBENGALI SANDHI MARKGURMUKHI SIGN ADAK BINDIGURMUKHI SI" +
	"GN BINDIGURMUKHI SIGN VISARGAGURMUKHI LETTER AGURMUKHI LETTER AAGURMUKHI" +
	" LETTER IGURMUKHI LETTER IIGURMUKHI LETTER UGURMUKHI LETTER UUGURMUKHI L" +
	"ETTER EEGURMUKHI LETTER AIGURMUKHI LETTER OOGURMUKHI LETTER AUGURMUKHI L" +
	"ETTER KAGURMUKHI LETTER KHAGURMUKHI LETTER GAGURMUKHI LETTER GHAGURMUKHI" +
	" LETTER NGAGURMUKHI LETTER CAGURMUKHI LETTER CHAGURMUKHI LETTER JAGURMUK" +
	"HI LETTER JHAGURMUKHI LETTER NYAGURMUKHI LETTER TTAGURMUKHI LETTER TTHAG" +
	"URMUKHI LETTER DDAGURMUKHI LETTER DDHAGURMUKHI LETTER NNAGURMUKHI LETTER" +
	" TAGURMUKHI LETTER THAGURMUKHI LETTER DAGURMUKHI LETTER DHAGURMUKHI LETT" +
	"ER NAGURMUKHI LETTER PAGURMUKHI LETTER PHAGURMUKHI LETTER BAGURMUKHI LET" +
	"TER BHAGURMUKHI LETTER MAGURMUKHI LETTER YAGURMUKHI LETTER RAGURMUKHI LE" +
	"TTER LAGURMUKHI LETTER LLAGURMUKHI LETTER VAGURMUKHI LETTER SHAGURMUKHI " +
	"LETTER SAGURMUKHI LETTER HAGURMUKHI SIGN NUKTAGURMUKHI VOWEL SIGN AAGURM" +
	"UKHI VOWEL SIGN IGURMUKHI VOWEL SIGN IIGURMUKHI VOWEL SIGN UGURMUKHI VOW" +
	"EL SIGN UUGURMUKHI VOWEL SIGN EEGURMUKHI VOWEL SIGN AIGURMUKHI VOWEL SIG" +
	"N OOGURMUKHI VOWEL SIGN AUGURMUKHI SIGN VIRAMAGURMUKHI SIGN UDAATGURMUKH" +
	"I LETTER KHHAGURMUKHI LETTER GHHAGURMUKHI LETTER ZAGURMUKHI LETTER RRAGU" +
	"RMUKHI LETTER FAGURMUKHI DIGIT ZEROGURMUKHI DIGIT ONEGURMUKHI DIGIT TWOG" +
	"URMUKHI DIGIT THREEGURMUKHI DIGIT FOURGURMUKHI DIGIT FIVEGURMUKHI DIGIT " +
	"SIXGURMUKHI DIGIT SEVENGURMUKHI DIGIT EIGHTGURMUKHI DIGIT NINEGURMUKHI T" +
	"IPPIGURMUKHI ADDAKGURMUKHI IRIGURMUKHI URAGURMUKHI EK ONKARGURMUKHI SIGN" +
	" YAKASHGURMUKHI ABBREVIATION SIGNGUJARATI SIGN CANDRABINDUGUJARATI SIGN " +
	"ANUSVARAGUJARATI SIGN VISARGAGUJARATI LETTER AGUJARATI LETTER AAGUJARATI" +
	" LETTER IGUJARATI LETTER IIGUJARATI LETTER UGUJARATI LETTER UUGUJARATI L" +
	"ETTER VOCALIC RGUJARATI LETTER VOCALIC LGUJARATI VOWEL CANDRA EGUJARATI " +
	"LETTER EGUJARATI LETTER AIGUJARATI VOWEL CANDRA OGUJARATI LETTER OGUJARA" +
	"TI LETTER AUGUJARATI LETTER KAGUJARATI LETTER KHAGUJARATI LETTER GAGUJAR" +
	"ATI LETTER GHAGUJARATI LETTER NGAGUJARATI LETTER CAGUJARATI LETTER CHAGU" +
	"JARATI LETTER JAGUJARATI LETTER JHAGUJARATI LETTER NYAGUJARATI LETTER TT" +
	"AGUJARATI LETTER TTHAGUJARATI LETTER DDAGUJARATI LETTER DDHAGUJARATI LET" +
	"TER NNAGUJARATI LETTER TAGUJARATI LETTER THAGUJARATI LETTER DAGUJARATI L" +
	"ETTER DHAGUJARATI LETTER NAGUJARATI LETTER PAGUJARATI LETTER PHAGUJARATI" +
	" LETTER BAGUJARATI LETTER BHAGUJARATI LETTER MAGUJARATI LETTER YAGUJARAT" +
	"I LETTER RAGUJARATI LETTER LAGUJARATI LETTER LLAGUJARATI LETTER VAGUJARA" +
	"TI LETTER SHAGUJARATI LETTER SSAGUJARATI LETTER SAGUJARATI LETTER HAGUJA" +
	"RATI SIGN NUKTAGUJARATI SIGN AVAGRAHAGUJARATI VOWEL SIGN AAGUJARATI VOWE" +
	"L SIGN IGUJARATI VOWEL SIGN IIGUJARATI VOWEL SIGN UGUJARATI VOWEL SIGN U" +
	"UGUJARATI VOWEL SIGN VOCALIC RGUJARATI VOWEL SIGN VOCALIC RRGUJARATI VOW" +
	"EL SIGN CANDRA EGUJARATI VOWEL SIGN EGUJARATI VOWEL SIGN AIGUJARATI VOWE" +
	"L SIGN CANDRA OGUJARATI VOWEL SIGN OGUJARATI VOWEL SIGN AUGUJARATI SIGN " +
	"VIRAMAGUJARATI OMGUJARATI LETTER VOCALIC RRGUJARATI LETTER VOCALIC LLGUJ") + ("" +
	"ARATI VOWEL SIGN VOCALIC LGUJARATI VOWEL SIGN VOCALIC LLGUJARATI DIGIT Z" +
	"EROGUJARATI DIGIT ONEGUJARATI DIGIT TWOGUJARATI DIGIT THREEGUJARATI DIGI" +
	"T FOURGUJARATI DIGIT FIVEGUJARATI DIGIT SIXGUJARATI DIGIT SEVENGUJARATI " +
	"DIGIT EIGHTGUJARATI DIGIT NINEGUJARATI ABBREVIATION SIGNGUJARATI RUPEE S" +
	"IGNGUJARATI LETTER ZHAGUJARATI SIGN SUKUNGUJARATI SIGN SHADDAGUJARATI SI" +
	"GN MADDAHGUJARATI SIGN THREE-DOT NUKTA ABOVEGUJARATI SIGN CIRCLE NUKTA A" +
	"BOVEGUJARATI SIGN TWO-CIRCLE NUKTA ABOVEORIYA SIGN CANDRABINDUORIYA SIGN" +
	" ANUSVARAORIYA SIGN VISARGAORIYA LETTER AORIYA LETTER AAORIYA LETTER IOR" +
	"IYA LETTER IIORIYA LETTER UORIYA LETTER UUORIYA LETTER VOCALIC RORIYA LE" +
	"TTER VOCALIC LORIYA LETTER EORIYA LETTER AIORIYA LETTER OORIYA LETTER AU" +
	"ORIYA LETTER KAORIYA LETTER KHAORIYA LETTER GAORIYA LETTER GHAORIYA LETT" +
	"ER NGAORIYA LETTER CAORIYA LETTER CHAORIYA LETTER JAORIYA LETTER JHAORIY" +
	"A LETTER NYAORIYA LETTER TTAORIYA LETTER TTHAORIYA LETTER DDAORIYA LETTE" +
	"R DDHAORIYA LETTER NNAORIYA LETTER TAORIYA LETTER THAORIYA LETTER DAORIY" +
	"A LETTER DHAORIYA LETTER NAORIYA LETTER PAORIYA LETTER PHAORIYA LETTER B" +
	"AORIYA LETTER BHAORIYA LETTER MAORIYA LETTER YAORIYA LETTER RAORIYA LETT" +
	"ER LAORIYA LETTER LLAORIYA LETTER VAORIYA LETTER SHAORIYA LETTER SSAORIY" +
	"A LETTER SAORIYA LETTER HAORIYA SIGN NUKTAORIYA SIGN AVAGRAHAORIYA VOWEL" +
	" SIGN AAORIYA VOWEL SIGN IORIYA VOWEL SIGN IIORIYA VOWEL SIGN UORIYA VOW" +
	"EL SIGN UUORIYA VOWEL SIGN VOCALIC RORIYA VOWEL SIGN VOCALIC RRORIYA VOW" +
	"EL SIGN EORIYA VOWEL SIGN AIORIYA VOWEL SIGN OORIYA VOWEL SIGN AUORIYA S" +
	"IGN VIRAMAORIYA SIGN OVERLINEORIYA AI LENGTH MARKORIYA AU LENGTH MARKORI" +
	"YA LETTER RRAORIYA LETTER RHAORIYA LETTER YYAORIYA LETTER VOCALIC RRORIY" +
	"A LETTER VOCALIC LLORIYA VOWEL SIGN VOCALIC LORIYA VOWEL SIGN VOCALIC LL" +
	"ORIYA DIGIT ZEROORIYA DIGIT ONEORIYA DIGIT TWOORIYA DIGIT THREEORIYA DIG" +
	"IT FOURORIYA DIGIT FIVEORIYA DIGIT SIXORIYA DIGIT SEVENORIYA DIGIT EIGHT" +
	"ORIYA DIGIT NINEORIYA ISSHARORIYA LETTER WAORIYA FRACTION ONE QUARTERORI" +
	"YA FRACTION ONE HALFORIYA FRACTION THREE QUARTERSORIYA FRACTION ONE SIXT" +
	"EENTHORIYA FRACTION ONE EIGHTHORIYA FRACTION THREE SIXTEENTHSTAMIL SIGN " +
	"ANUSVARATAMIL SIGN VISARGATAMIL LETTER ATAMIL LETTER AATAMIL LETTER ITAM" +
	"IL LETTER IITAMIL LETTER UTAMIL LETTER UUTAMIL LETTER ETAMIL LETTER EETA" +
	"MIL LETTER AITAMIL LETTER OTAMIL LETTER OOTAMIL LETTER AUTAMIL LETTER KA" +
	"TAMIL LETTER NGATAMIL LETTER CATAMIL LETTER JATAMIL LETTER NYATAMIL LETT" +
	"ER TTATAMIL LETTER NNATAMIL LETTER TATAMIL LETTER NATAMIL LETTER NNNATAM" +
	"IL LETTER PATAMIL LETTER MATAMIL LETTER YATAMIL LETTER RATAMIL LETTER RR" +
	"ATAMIL LETTER LATAMIL LETTER LLATAMIL LETTER LLLATAMIL LETTER VATAMIL LE" +
	"TTER SHATAMIL LETTER SSATAMIL LETTER SATAMIL LETTER HATAMIL VOWEL SIGN A" +
	"ATAMIL VOWEL SIGN ITAMIL VOWEL SIGN IITAMIL VOWEL SIGN UTAMIL VOWEL SIGN" +
	" UUTAMIL VOWEL SIGN ETAMIL VOWEL SIGN EETAMIL VOWEL SIGN AITAMIL VOWEL S" +
	"IGN OTAMIL VOWEL SIGN OOTAMIL VOWEL SIGN AUTAMIL SIGN VIRAMATAMIL OMTAMI" +
	"L AU LENGTH MARKTAMIL DIGIT ZEROTAMIL DIGIT ONETAMIL DIGIT TWOTAMIL DIGI" +
	"T THREETAMIL DIGIT FOURTAMIL DIGIT FIVETAMIL DIGIT SIXTAMIL DIGIT SEVENT" +
	"AMIL DIGIT EIGHTTAMIL DIGIT NINETAMIL NUMBER TENTAMIL NUMBER ONE HUNDRED" +
	"TAMIL NUMBER ONE THOUSANDTAMIL DAY SIGNTAMIL MONTH SIGNTAMIL YEAR SIGNTA" +
	"MIL DEBIT SIGNTAMIL CREDIT SIGNTAMIL AS ABOVE SIGNTAMIL RUPEE SIGNTAMIL " +
	"NUMBER SIGNTELUGU SIGN COMBINING CANDRABINDU ABOVETELUGU SIGN CANDRABIND" +
	"UTELUGU SIGN ANUSVARATELUGU SIGN VISARGATELUGU SIGN COMBINING ANUSVARA A" +
	"BOVETELUGU LETTER ATELUGU LETTER AATELUGU LETTER ITELUGU LETTER IITELUGU" +
	" LETTER UTELUGU LETTER UUTELUGU LETTER VOCALIC RTELUGU LETTER VOCALIC LT" +
	"ELUGU LETTER ETELUGU LETTER EETELUGU LETTER AITELUGU LETTER OTELUGU LETT" +
	"ER OOTELUGU LETTER AUTELUGU LETTER KATELUGU LETTER KHATELUGU LETTER GATE" +
	"LUGU LETTER GHATELUGU LETTER NGATELUGU LETTER CATELUGU LETTER CHATELUGU " +
	"LETTER JATELUGU LETTER JHATELUGU LETTER NYATELUGU LETTER TTATELUGU LETTE" +
	"R TTHATELUGU LETTER DDATELUGU LETTER DDHATELUGU LETTER NNATELUGU LETTER " +
	"TATELUGU LETTER THATELUGU LETTER DATELUGU LETTER DHATELUGU LETTER NATELU" +
	"GU LETTER PATELUGU LETTER PHATELUGU LETTER BATELUGU LETTER BHATELUGU LET" +
	"TER MATELUGU LETTER YATELUGU LETTER RATELUGU LETTER RRATELUGU LETTER LAT" +
	"ELUGU LETTER LLATELUGU LETTER LLLATELUGU LETTER VATELUGU LETTER SHATELUG" +
	"U LETTER SSATELUGU LETTER SATELUGU LETTER HATELUGU SIGN NUKTATELUGU SIGN" +
	" AVAGRAHATELUGU VOWEL SIGN AATELUGU VOWEL SIGN ITELUGU VOWEL SIGN IITELU" +
	"GU VOWEL SIGN UTELUGU VOWEL SIGN UUTELUGU VOWEL SIGN VOCALIC RTELUGU VOW" +
	"EL SIGN VOCALIC RRTELUGU VOWEL SIGN ETELUGU VOWEL SIGN EETELUGU VOWEL SI" +
	"GN AITELUGU VOWEL SIGN OTELUGU VOWEL SIGN OOTELUGU VOWEL SIGN AUTELUGU S" +
	"IGN VIRAMATELUGU LENGTH MARKTELUGU AI LENGTH MARKTELUGU LETTER TSATELUGU") + ("" +
	" LETTER DZATELUGU LETTER RRRATELUGU LETTER NAKAARA POLLUTELUGU LETTER VO" +
	"CALIC RRTELUGU LETTER VOCALIC LLTELUGU VOWEL SIGN VOCALIC LTELUGU VOWEL " +
	"SIGN VOCALIC LLTELUGU DIGIT ZEROTELUGU DIGIT ONETELUGU DIGIT TWOTELUGU D" +
	"IGIT THREETELUGU DIGIT FOURTELUGU DIGIT FIVETELUGU DIGIT SIXTELUGU DIGIT" +
	" SEVENTELUGU DIGIT EIGHTTELUGU DIGIT NINETELUGU SIGN SIDDHAMTELUGU FRACT" +
	"ION DIGIT ZERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR ODD P" +
	"OWERS OF FOURTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOURTELUGU FRAC" +
	"TION DIGIT THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR EVE" +
	"N POWERS OF FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOURTELUGU " +
	"FRACTION DIGIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUUMUKANNADA SIG" +
	"N SPACING CANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN ANUSVARAKANNAD" +
	"A SIGN VISARGAKANNADA SIGN SIDDHAMKANNADA LETTER AKANNADA LETTER AAKANNA" +
	"DA LETTER IKANNADA LETTER IIKANNADA LETTER UKANNADA LETTER UUKANNADA LET" +
	"TER VOCALIC RKANNADA LETTER VOCALIC LKANNADA LETTER EKANNADA LETTER EEKA" +
	"NNADA LETTER AIKANNADA LETTER OKANNADA LETTER OOKANNADA LETTER AUKANNADA" +
	" LETTER KAKANNADA LETTER KHAKANNADA LETTER GAKANNADA LETTER GHAKANNADA L" +
	"ETTER NGAKANNADA LETTER CAKANNADA LETTER CHAKANNADA LETTER JAKANNADA LET" +
	"TER JHAKANNADA LETTER NYAKANNADA LETTER TTAKANNADA LETTER TTHAKANNADA LE" +
	"TTER DDAKANNADA LETTER DDHAKANNADA LETTER NNAKANNADA LETTER TAKANNADA LE" +
	"TTER THAKANNADA LETTER DAKANNADA LETTER DHAKANNADA LETTER NAKANNADA LETT" +
	"ER PAKANNADA LETTER PHAKANNADA LETTER BAKANNADA LETTER BHAKANNADA LETTER" +
	" MAKANNADA LETTER YAKANNADA LETTER RAKANNADA LETTER RRAKANNADA LETTER LA" +
	"KANNADA LETTER LLAKANNADA LETTER VAKANNADA LETTER SHAKANNADA LETTER SSAK" +
	"ANNADA LETTER SAKANNADA LETTER HAKANNADA SIGN NUKTAKANNADA SIGN AVAGRAHA" +
	"KANNADA VOWEL SIGN AAKANNADA VOWEL SIGN IKANNADA VOWEL SIGN IIKANNADA VO" +
	"WEL SIGN UKANNADA VOWEL SIGN UUKANNADA VOWEL SIGN VOCALIC RKANNADA VOWEL" +
	" SIGN VOCALIC RRKANNADA VOWEL SIGN EKANNADA VOWEL SIGN EEKANNADA VOWEL S" +
	"IGN AIKANNADA VOWEL SIGN OKANNADA VOWEL SIGN OOKANNADA VOWEL SIGN AUKANN" +
	"ADA SIGN VIRAMAKANNADA LENGTH MARKKANNADA AI LENGTH MARKKANNADA LETTER N" +
	"AKAARA POLLUKANNADA LETTER FAKANNADA LETTER VOCALIC RRKANNADA LETTER VOC" +
	"ALIC LLKANNADA VOWEL SIGN VOCALIC LKANNADA VOWEL SIGN VOCALIC LLKANNADA " +
	"DIGIT ZEROKANNADA DIGIT ONEKANNADA DIGIT TWOKANNADA DIGIT THREEKANNADA D" +
	"IGIT FOURKANNADA DIGIT FIVEKANNADA DIGIT SIXKANNADA DIGIT SEVENKANNADA D" +
	"IGIT EIGHTKANNADA DIGIT NINEKANNADA SIGN JIHVAMULIYAKANNADA SIGN UPADHMA" +
	"NIYAKANNADA SIGN COMBINING ANUSVARA ABOVE RIGHTMALAYALAM SIGN COMBINING " +
	"ANUSVARA ABOVEMALAYALAM SIGN CANDRABINDUMALAYALAM SIGN ANUSVARAMALAYALAM" +
	" SIGN VISARGAMALAYALAM LETTER VEDIC ANUSVARAMALAYALAM LETTER AMALAYALAM " +
	"LETTER AAMALAYALAM LETTER IMALAYALAM LETTER IIMALAYALAM LETTER UMALAYALA" +
	"M LETTER UUMALAYALAM LETTER VOCALIC RMALAYALAM LETTER VOCALIC LMALAYALAM" +
	" LETTER EMALAYALAM LETTER EEMALAYALAM LETTER AIMALAYALAM LETTER OMALAYAL" +
	"AM LETTER OOMALAYALAM LETTER AUMALAYALAM LETTER KAMALAYALAM LETTER KHAMA" +
	"LAYALAM LETTER GAMALAYALAM LETTER GHAMALAYALAM LETTER NGAMALAYALAM LETTE" +
	"R CAMALAYALAM LETTER CHAMALAYALAM LETTER JAMALAYALAM LETTER JHAMALAYALAM" +
	" LETTER NYAMALAYALAM LETTER TTAMALAYALAM LETTER TTHAMALAYALAM LETTER DDA" +
	"MALAYALAM LETTER DDHAMALAYALAM LETTER NNAMALAYALAM LETTER TAMALAYALAM LE" +
	"TTER THAMALAYALAM LETTER DAMALAYALAM LETTER DHAMALAYALAM LETTER NAMALAYA" +
	"LAM LETTER NNNAMALAYALAM LETTER PAMALAYALAM LETTER PHAMALAYALAM LETTER B" +
	"AMALAYALAM LETTER BHAMALAYALAM LETTER MAMALAYALAM LETTER YAMALAYALAM LET" +
	"TER RAMALAYALAM LETTER RRAMALAYALAM LETTER LAMALAYALAM LETTER LLAMALAYAL" +
	"AM LETTER LLLAMALAYALAM LETTER VAMALAYALAM LETTER SHAMALAYALAM LETTER SS" +
	"AMALAYALAM LETTER SAMALAYALAM LETTER HAMALAYALAM LETTER TTTAMALAYALAM SI" +
	"GN VERTICAL BAR VIRAMAMALAYALAM SIGN CIRCULAR VIRAMAMALAYALAM SIGN AVAGR" +
	"AHAMALAYALAM VOWEL SIGN AAMALAYALAM VOWEL SIGN IMALAYALAM VOWEL SIGN IIM" +
	"ALAYALAM VOWEL SIGN UMALAYALAM VOWEL SIGN UUMALAYALAM VOWEL SIGN VOCALIC" +
	" RMALAYALAM VOWEL SIGN VOCALIC RRMALAYALAM VOWEL SIGN EMALAYALAM VOWEL S" +
	"IGN EEMALAYALAM VOWEL SIGN AIMALAYALAM VOWEL SIGN OMALAYALAM VOWEL SIGN " +
	"OOMALAYALAM VOWEL SIGN AUMALAYALAM SIGN VIRAMAMALAYALAM LETTER DOT REPHM" +
	"ALAYALAM SIGN PARAMALAYALAM LETTER CHILLU MMALAYALAM LETTER CHILLU YMALA" +
	"YALAM LETTER CHILLU LLLMALAYALAM AU LENGTH MARKMALAYALAM FRACTION ONE ON" +
	"E-HUNDRED-AND-SIXTIETHMALAYALAM FRACTION ONE FORTIETHMALAYALAM FRACTION " +
	"THREE EIGHTIETHSMALAYALAM FRACTION ONE TWENTIETHMALAYALAM FRACTION ONE T" +
	"ENTHMALAYALAM FRACTION THREE TWENTIETHSMALAYALAM FRACTION ONE FIFTHMALAY" +
	"ALAM LETTER ARCHAIC IIMALAYALAM LETTER VOCALIC RRMALAYALAM LETTER VOCALI" +
	"C LLMALAYALAM VOWEL SIGN VOCALIC LMALAYALAM VOWEL SIGN VOCALIC LLMALAYAL") + ("" +
	"AM DIGIT ZEROMALAYALAM DIGIT ONEMALAYALAM DIGIT TWOMALAYALAM DIGIT THREE" +
	"MALAYALAM DIGIT FOURMALAYALAM DIGIT FIVEMALAYALAM DIGIT SIXMALAYALAM DIG" +
	"IT SEVENMALAYALAM DIGIT EIGHTMALAYALAM DIGIT NINEMALAYALAM NUMBER TENMAL" +
	"AYALAM NUMBER ONE HUNDREDMALAYALAM NUMBER ONE THOUSANDMALAYALAM FRACTION" +
	" ONE QUARTERMALAYALAM FRACTION ONE HALFMALAYALAM FRACTION THREE QUARTERS" +
	"MALAYALAM FRACTION ONE SIXTEENTHMALAYALAM FRACTION ONE EIGHTHMALAYALAM F" +
	"RACTION THREE SIXTEENTHSMALAYALAM DATE MARKMALAYALAM LETTER CHILLU NNMAL" +
	"AYALAM LETTER CHILLU NMALAYALAM LETTER CHILLU RRMALAYALAM LETTER CHILLU " +
	"LMALAYALAM LETTER CHILLU LLMALAYALAM LETTER CHILLU KSINHALA SIGN CANDRAB" +
	"INDUSINHALA SIGN ANUSVARAYASINHALA SIGN VISARGAYASINHALA LETTER AYANNASI" +
	"NHALA LETTER AAYANNASINHALA LETTER AEYANNASINHALA LETTER AEEYANNASINHALA" +
	" LETTER IYANNASINHALA LETTER IIYANNASINHALA LETTER UYANNASINHALA LETTER " +
	"UUYANNASINHALA LETTER IRUYANNASINHALA LETTER IRUUYANNASINHALA LETTER ILU" +
	"YANNASINHALA LETTER ILUUYANNASINHALA LETTER EYANNASINHALA LETTER EEYANNA" +
	"SINHALA LETTER AIYANNASINHALA LETTER OYANNASINHALA LETTER OOYANNASINHALA" +
	" LETTER AUYANNASINHALA LETTER ALPAPRAANA KAYANNASINHALA LETTER MAHAAPRAA" +
	"NA KAYANNASINHALA LETTER ALPAPRAANA GAYANNASINHALA LETTER MAHAAPRAANA GA" +
	"YANNASINHALA LETTER KANTAJA NAASIKYAYASINHALA LETTER SANYAKA GAYANNASINH" +
	"ALA LETTER ALPAPRAANA CAYANNASINHALA LETTER MAHAAPRAANA CAYANNASINHALA L" +
	"ETTER ALPAPRAANA JAYANNASINHALA LETTER MAHAAPRAANA JAYANNASINHALA LETTER" +
	" TAALUJA NAASIKYAYASINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYASINHALA LE" +
	"TTER SANYAKA JAYANNASINHALA LETTER ALPAPRAANA TTAYANNASINHALA LETTER MAH" +
	"AAPRAANA TTAYANNASINHALA LETTER ALPAPRAANA DDAYANNASINHALA LETTER MAHAAP" +
	"RAANA DDAYANNASINHALA LETTER MUURDHAJA NAYANNASINHALA LETTER SANYAKA DDA" +
	"YANNASINHALA LETTER ALPAPRAANA TAYANNASINHALA LETTER MAHAAPRAANA TAYANNA" +
	"SINHALA LETTER ALPAPRAANA DAYANNASINHALA LETTER MAHAAPRAANA DAYANNASINHA" +
	"LA LETTER DANTAJA NAYANNASINHALA LETTER SANYAKA DAYANNASINHALA LETTER AL" +
	"PAPRAANA PAYANNASINHALA LETTER MAHAAPRAANA PAYANNASINHALA LETTER ALPAPRA" +
	"ANA BAYANNASINHALA LETTER MAHAAPRAANA BAYANNASINHALA LETTER MAYANNASINHA" +
	"LA LETTER AMBA BAYANNASINHALA LETTER YAYANNASINHALA LETTER RAYANNASINHAL" +
	"A LETTER DANTAJA LAYANNASINHALA LETTER VAYANNASINHALA LETTER TAALUJA SAY" +
	"ANNASINHALA LETTER MUURDHAJA SAYANNASINHALA LETTER DANTAJA SAYANNASINHAL" +
	"A LETTER HAYANNASINHALA LETTER MUURDHAJA LAYANNASINHALA LETTER FAYANNASI" +
	"NHALA SIGN AL-LAKUNASINHALA VOWEL SIGN AELA-PILLASINHALA VOWEL SIGN KETT" +
	"I AEDA-PILLASINHALA VOWEL SIGN DIGA AEDA-PILLASINHALA VOWEL SIGN KETTI I" +
	"S-PILLASINHALA VOWEL SIGN DIGA IS-PILLASINHALA VOWEL SIGN KETTI PAA-PILL" +
	"ASINHALA VOWEL SIGN DIGA PAA-PILLASINHALA VOWEL SIGN GAETTA-PILLASINHALA" +
	" VOWEL SIGN KOMBUVASINHALA VOWEL SIGN DIGA KOMBUVASINHALA VOWEL SIGN KOM" +
	"BU DEKASINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLASINHALA VOWEL SIGN KOMBU" +
	"VA HAA DIGA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTASINHALA " +
	"VOWEL SIGN GAYANUKITTASINHALA LITH DIGIT ZEROSINHALA LITH DIGIT ONESINHA" +
	"LA LITH DIGIT TWOSINHALA LITH DIGIT THREESINHALA LITH DIGIT FOURSINHALA " +
	"LITH DIGIT FIVESINHALA LITH DIGIT SIXSINHALA LITH DIGIT SEVENSINHALA LIT" +
	"H DIGIT EIGHTSINHALA LITH DIGIT NINESINHALA VOWEL SIGN DIGA GAETTA-PILLA" +
	"SINHALA VOWEL SIGN DIGA GAYANUKITTASINHALA PUNCTUATION KUNDDALIYATHAI CH" +
	"ARACTER KO KAITHAI CHARACTER KHO KHAITHAI CHARACTER KHO KHUATTHAI CHARAC" +
	"TER KHO KHWAITHAI CHARACTER KHO KHONTHAI CHARACTER KHO RAKHANGTHAI CHARA" +
	"CTER NGO NGUTHAI CHARACTER CHO CHANTHAI CHARACTER CHO CHINGTHAI CHARACTE" +
	"R CHO CHANGTHAI CHARACTER SO SOTHAI CHARACTER CHO CHOETHAI CHARACTER YO " +
	"YINGTHAI CHARACTER DO CHADATHAI CHARACTER TO PATAKTHAI CHARACTER THO THA" +
	"NTHAI CHARACTER THO NANGMONTHOTHAI CHARACTER THO PHUTHAOTHAI CHARACTER N" +
	"O NENTHAI CHARACTER DO DEKTHAI CHARACTER TO TAOTHAI CHARACTER THO THUNGT" +
	"HAI CHARACTER THO THAHANTHAI CHARACTER THO THONGTHAI CHARACTER NO NUTHAI" +
	" CHARACTER BO BAIMAITHAI CHARACTER PO PLATHAI CHARACTER PHO PHUNGTHAI CH" +
	"ARACTER FO FATHAI CHARACTER PHO PHANTHAI CHARACTER FO FANTHAI CHARACTER " +
	"PHO SAMPHAOTHAI CHARACTER MO MATHAI CHARACTER YO YAKTHAI CHARACTER RO RU" +
	"ATHAI CHARACTER RUTHAI CHARACTER LO LINGTHAI CHARACTER LUTHAI CHARACTER " +
	"WO WAENTHAI CHARACTER SO SALATHAI CHARACTER SO RUSITHAI CHARACTER SO SUA" +
	"THAI CHARACTER HO HIPTHAI CHARACTER LO CHULATHAI CHARACTER O ANGTHAI CHA" +
	"RACTER HO NOKHUKTHAI CHARACTER PAIYANNOITHAI CHARACTER SARA ATHAI CHARAC" +
	"TER MAI HAN-AKATTHAI CHARACTER SARA AATHAI CHARACTER SARA AMTHAI CHARACT" +
	"ER SARA ITHAI CHARACTER SARA IITHAI CHARACTER SARA UETHAI CHARACTER SARA" +
	" UEETHAI CHARACTER SARA UTHAI CHARACTER SARA UUTHAI CHARACTER PHINTHUTHA" +
	"I CURRENCY SYMBOL BAHTTHAI CHARACTER SARA ETHAI CHARACTER SARA AETHAI CH") + ("" +
	"ARACTER SARA OTHAI CHARACTER SARA AI MAIMUANTHAI CHARACTER SARA AI MAIMA" +
	"LAITHAI CHARACTER LAKKHANGYAOTHAI CHARACTER MAIYAMOKTHAI CHARACTER MAITA" +
	"IKHUTHAI CHARACTER MAI EKTHAI CHARACTER MAI THOTHAI CHARACTER MAI TRITHA" +
	"I CHARACTER MAI CHATTAWATHAI CHARACTER THANTHAKHATTHAI CHARACTER NIKHAHI" +
	"TTHAI CHARACTER YAMAKKANTHAI CHARACTER FONGMANTHAI DIGIT ZEROTHAI DIGIT " +
	"ONETHAI DIGIT TWOTHAI DIGIT THREETHAI DIGIT FOURTHAI DIGIT FIVETHAI DIGI" +
	"T SIXTHAI DIGIT SEVENTHAI DIGIT EIGHTTHAI DIGIT NINETHAI CHARACTER ANGKH" +
	"ANKHUTHAI CHARACTER KHOMUTLAO LETTER KOLAO LETTER KHO SUNGLAO LETTER KHO" +
	" TAMLAO LETTER PALI GHALAO LETTER NGOLAO LETTER COLAO LETTER PALI CHALAO" +
	" LETTER SO TAMLAO LETTER PALI JHALAO LETTER NYOLAO LETTER PALI NYALAO LE" +
	"TTER PALI TTALAO LETTER PALI TTHALAO LETTER PALI DDALAO LETTER PALI DDHA" +
	"LAO LETTER PALI NNALAO LETTER DOLAO LETTER TOLAO LETTER THO SUNGLAO LETT" +
	"ER THO TAMLAO LETTER PALI DHALAO LETTER NOLAO LETTER BOLAO LETTER POLAO " +
	"LETTER PHO SUNGLAO LETTER FO TAMLAO LETTER PHO TAMLAO LETTER FO SUNGLAO " +
	"LETTER PALI BHALAO LETTER MOLAO LETTER YOLAO LETTER LO LINGLAO LETTER LO" +
	" LOOTLAO LETTER WOLAO LETTER SANSKRIT SHALAO LETTER SANSKRIT SSALAO LETT" +
	"ER SO SUNGLAO LETTER HO SUNGLAO LETTER PALI LLALAO LETTER OLAO LETTER HO" +
	" TAMLAO ELLIPSISLAO VOWEL SIGN ALAO VOWEL SIGN MAI KANLAO VOWEL SIGN AAL" +
	"AO VOWEL SIGN AMLAO VOWEL SIGN ILAO VOWEL SIGN IILAO VOWEL SIGN YLAO VOW" +
	"EL SIGN YYLAO VOWEL SIGN ULAO VOWEL SIGN UULAO SIGN PALI VIRAMALAO VOWEL" +
	" SIGN MAI KONLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL SIGN NYOLAO VOWEL SIGN E" +
	"LAO VOWEL SIGN EILAO VOWEL SIGN OLAO VOWEL SIGN AYLAO VOWEL SIGN AILAO K" +
	"O LALAO TONE MAI EKLAO TONE MAI THOLAO TONE MAI TILAO TONE MAI CATAWALAO" +
	" CANCELLATION MARKLAO NIGGAHITALAO YAMAKKANLAO DIGIT ZEROLAO DIGIT ONELA" +
	"O DIGIT TWOLAO DIGIT THREELAO DIGIT FOURLAO DIGIT FIVELAO DIGIT SIXLAO D" +
	"IGIT SEVENLAO DIGIT EIGHTLAO DIGIT NINELAO HO NOLAO HO MOLAO LETTER KHMU" +
	" GOLAO LETTER KHMU NYOTIBETAN SYLLABLE OMTIBETAN MARK GTER YIG MGO TRUNC" +
	"ATED ATIBETAN MARK GTER YIG MGO -UM RNAM BCAD MATIBETAN MARK GTER YIG MG" +
	"O -UM GTER TSHEG MATIBETAN MARK INITIAL YIG MGO MDUN MATIBETAN MARK CLOS" +
	"ING YIG MGO SGAB MATIBETAN MARK CARET YIG MGO PHUR SHAD MATIBETAN MARK Y" +
	"IG MGO TSHEG SHAD MATIBETAN MARK SBRUL SHADTIBETAN MARK BSKUR YIG MGOTIB" +
	"ETAN MARK BKA- SHOG YIG MGOTIBETAN MARK INTERSYLLABIC TSHEGTIBETAN MARK " +
	"DELIMITER TSHEG BSTARTIBETAN MARK SHADTIBETAN MARK NYIS SHADTIBETAN MARK" +
	" TSHEG SHADTIBETAN MARK NYIS TSHEG SHADTIBETAN MARK RIN CHEN SPUNGS SHAD" +
	"TIBETAN MARK RGYA GRAM SHADTIBETAN MARK CARET -DZUD RTAGS ME LONG CANTIB" +
	"ETAN MARK GTER TSHEGTIBETAN LOGOTYPE SIGN CHAD RTAGSTIBETAN LOGOTYPE SIG" +
	"N LHAG RTAGSTIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGSTIBETAN ASTRO" +
	"LOGICAL SIGN -KHYUD PATIBETAN ASTROLOGICAL SIGN SDONG TSHUGSTIBETAN SIGN" +
	" RDEL DKAR GCIGTIBETAN SIGN RDEL DKAR GNYISTIBETAN SIGN RDEL DKAR GSUMTI" +
	"BETAN SIGN RDEL NAG GCIGTIBETAN SIGN RDEL NAG GNYISTIBETAN SIGN RDEL DKA" +
	"R RDEL NAGTIBETAN DIGIT ZEROTIBETAN DIGIT ONETIBETAN DIGIT TWOTIBETAN DI" +
	"GIT THREETIBETAN DIGIT FOURTIBETAN DIGIT FIVETIBETAN DIGIT SIXTIBETAN DI" +
	"GIT SEVENTIBETAN DIGIT EIGHTTIBETAN DIGIT NINETIBETAN DIGIT HALF ONETIBE" +
	"TAN DIGIT HALF TWOTIBETAN DIGIT HALF THREETIBETAN DIGIT HALF FOURTIBETAN" +
	" DIGIT HALF FIVETIBETAN DIGIT HALF SIXTIBETAN DIGIT HALF SEVENTIBETAN DI" +
	"GIT HALF EIGHTTIBETAN DIGIT HALF NINETIBETAN DIGIT HALF ZEROTIBETAN MARK" +
	" BSDUS RTAGSTIBETAN MARK NGAS BZUNG NYI ZLATIBETAN MARK CARET -DZUD RTAG" +
	"S BZHI MIG CANTIBETAN MARK NGAS BZUNG SGOR RTAGSTIBETAN MARK CHE MGOTIBE" +
	"TAN MARK TSA -PHRUTIBETAN MARK GUG RTAGS GYONTIBETAN MARK GUG RTAGS GYAS" +
	"TIBETAN MARK ANG KHANG GYONTIBETAN MARK ANG KHANG GYASTIBETAN SIGN YAR T" +
	"SHESTIBETAN SIGN MAR TSHESTIBETAN LETTER KATIBETAN LETTER KHATIBETAN LET" +
	"TER GATIBETAN LETTER GHATIBETAN LETTER NGATIBETAN LETTER CATIBETAN LETTE" +
	"R CHATIBETAN LETTER JATIBETAN LETTER NYATIBETAN LETTER TTATIBETAN LETTER" +
	" TTHATIBETAN LETTER DDATIBETAN LETTER DDHATIBETAN LETTER NNATIBETAN LETT" +
	"ER TATIBETAN LETTER THATIBETAN LETTER DATIBETAN LETTER DHATIBETAN LETTER" +
	" NATIBETAN LETTER PATIBETAN LETTER PHATIBETAN LETTER BATIBETAN LETTER BH" +
	"ATIBETAN LETTER MATIBETAN LETTER TSATIBETAN LETTER TSHATIBETAN LETTER DZ" +
	"ATIBETAN LETTER DZHATIBETAN LETTER WATIBETAN LETTER ZHATIBETAN LETTER ZA" +
	"TIBETAN LETTER -ATIBETAN LETTER YATIBETAN LETTER RATIBETAN LETTER LATIBE" +
	"TAN LETTER SHATIBETAN LETTER SSATIBETAN LETTER SATIBETAN LETTER HATIBETA" +
	"N LETTER ATIBETAN LETTER KSSATIBETAN LETTER FIXED-FORM RATIBETAN LETTER " +
	"KKATIBETAN LETTER RRATIBETAN VOWEL SIGN AATIBETAN VOWEL SIGN ITIBETAN VO" +
	"WEL SIGN IITIBETAN VOWEL SIGN UTIBETAN VOWEL SIGN UUTIBETAN VOWEL SIGN V" +
	"OCALIC RTIBETAN VOWEL SIGN VOCALIC RRTIBETAN VOWEL SIGN VOCALIC LTIBETAN") + ("" +
	" VOWEL SIGN VOCALIC LLTIBETAN VOWEL SIGN ETIBETAN VOWEL SIGN EETIBETAN V" +
	"OWEL SIGN OTIBETAN VOWEL SIGN OOTIBETAN SIGN RJES SU NGA ROTIBETAN SIGN " +
	"RNAM BCADTIBETAN VOWEL SIGN REVERSED ITIBETAN VOWEL SIGN REVERSED IITIBE" +
	"TAN SIGN NYI ZLA NAA DATIBETAN SIGN SNA LDANTIBETAN MARK HALANTATIBETAN " +
	"MARK PALUTATIBETAN SIGN LCI RTAGSTIBETAN SIGN YANG RTAGSTIBETAN SIGN LCE" +
	" TSA CANTIBETAN SIGN MCHU CANTIBETAN SIGN GRU CAN RGYINGSTIBETAN SIGN GR" +
	"U MED RGYINGSTIBETAN SIGN INVERTED MCHU CANTIBETAN SUBJOINED SIGN LCE TS" +
	"A CANTIBETAN SUBJOINED SIGN MCHU CANTIBETAN SUBJOINED SIGN INVERTED MCHU" +
	" CANTIBETAN SUBJOINED LETTER KATIBETAN SUBJOINED LETTER KHATIBETAN SUBJO" +
	"INED LETTER GATIBETAN SUBJOINED LETTER GHATIBETAN SUBJOINED LETTER NGATI" +
	"BETAN SUBJOINED LETTER CATIBETAN SUBJOINED LETTER CHATIBETAN SUBJOINED L" +
	"ETTER JATIBETAN SUBJOINED LETTER NYATIBETAN SUBJOINED LETTER TTATIBETAN " +
	"SUBJOINED LETTER TTHATIBETAN SUBJOINED LETTER DDATIBETAN SUBJOINED LETTE" +
	"R DDHATIBETAN SUBJOINED LETTER NNATIBETAN SUBJOINED LETTER TATIBETAN SUB" +
	"JOINED LETTER THATIBETAN SUBJOINED LETTER DATIBETAN SUBJOINED LETTER DHA" +
	"TIBETAN SUBJOINED LETTER NATIBETAN SUBJOINED LETTER PATIBETAN SUBJOINED " +
	"LETTER PHATIBETAN SUBJOINED LETTER BATIBETAN SUBJOINED LETTER BHATIBETAN" +
	" SUBJOINED LETTER MATIBETAN SUBJOINED LETTER TSATIBETAN SUBJOINED LETTER" +
	" TSHATIBETAN SUBJOINED LETTER DZATIBETAN SUBJOINED LETTER DZHATIBETAN SU" +
	"BJOINED LETTER WATIBETAN SUBJOINED LETTER ZHATIBETAN SUBJOINED LETTER ZA" +
	"TIBETAN SUBJOINED LETTER -ATIBETAN SUBJOINED LETTER YATIBETAN SUBJOINED " +
	"LETTER RATIBETAN SUBJOINED LETTER LATIBETAN SUBJOINED LETTER SHATIBETAN " +
	"SUBJOINED LETTER SSATIBETAN SUBJOINED LETTER SATIBETAN SUBJOINED LETTER " +
	"HATIBETAN SUBJOINED LETTER ATIBETAN SUBJOINED LETTER KSSATIBETAN SUBJOIN" +
	"ED LETTER FIXED-FORM WATIBETAN SUBJOINED LETTER FIXED-FORM YATIBETAN SUB" +
	"JOINED LETTER FIXED-FORM RATIBETAN KU RU KHATIBETAN KU RU KHA BZHI MIG C" +
	"ANTIBETAN CANTILLATION SIGN HEAVY BEATTIBETAN CANTILLATION SIGN LIGHT BE" +
	"ATTIBETAN CANTILLATION SIGN CANG TE-UTIBETAN CANTILLATION SIGN SBUB -CHA" +
	"LTIBETAN SYMBOL DRIL BUTIBETAN SYMBOL RDO RJETIBETAN SYMBOL PADMA GDANTI" +
	"BETAN SYMBOL RDO RJE RGYA GRAMTIBETAN SYMBOL PHUR PATIBETAN SYMBOL NOR B" +
	"UTIBETAN SYMBOL NOR BU NYIS -KHYILTIBETAN SYMBOL NOR BU GSUM -KHYILTIBET" +
	"AN SYMBOL NOR BU BZHI -KHYILTIBETAN SIGN RDEL NAG RDEL DKARTIBETAN SIGN " +
	"RDEL NAG GSUMTIBETAN MARK BSKA- SHOG GI MGO RGYANTIBETAN MARK MNYAM YIG " +
	"GI MGO RGYANTIBETAN MARK NYIS TSHEGTIBETAN MARK INITIAL BRDA RNYING YIG " +
	"MGO MDUN MATIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MARIGHT-FACING " +
	"SVASTI SIGNLEFT-FACING SVASTI SIGNRIGHT-FACING SVASTI SIGN WITH DOTSLEFT" +
	"-FACING SVASTI SIGN WITH DOTSTIBETAN MARK LEADING MCHAN RTAGSTIBETAN MAR" +
	"K TRAILING MCHAN RTAGSMYANMAR LETTER KAMYANMAR LETTER KHAMYANMAR LETTER " +
	"GAMYANMAR LETTER GHAMYANMAR LETTER NGAMYANMAR LETTER CAMYANMAR LETTER CH" +
	"AMYANMAR LETTER JAMYANMAR LETTER JHAMYANMAR LETTER NYAMYANMAR LETTER NNY" +
	"AMYANMAR LETTER TTAMYANMAR LETTER TTHAMYANMAR LETTER DDAMYANMAR LETTER D" +
	"DHAMYANMAR LETTER NNAMYANMAR LETTER TAMYANMAR LETTER THAMYANMAR LETTER D" +
	"AMYANMAR LETTER DHAMYANMAR LETTER NAMYANMAR LETTER PAMYANMAR LETTER PHAM" +
	"YANMAR LETTER BAMYANMAR LETTER BHAMYANMAR LETTER MAMYANMAR LETTER YAMYAN" +
	"MAR LETTER RAMYANMAR LETTER LAMYANMAR LETTER WAMYANMAR LETTER SAMYANMAR " +
	"LETTER HAMYANMAR LETTER LLAMYANMAR LETTER AMYANMAR LETTER SHAN AMYANMAR " +
	"LETTER IMYANMAR LETTER IIMYANMAR LETTER UMYANMAR LETTER UUMYANMAR LETTER" +
	" EMYANMAR LETTER MON EMYANMAR LETTER OMYANMAR LETTER AUMYANMAR VOWEL SIG" +
	"N TALL AAMYANMAR VOWEL SIGN AAMYANMAR VOWEL SIGN IMYANMAR VOWEL SIGN IIM" +
	"YANMAR VOWEL SIGN UMYANMAR VOWEL SIGN UUMYANMAR VOWEL SIGN EMYANMAR VOWE" +
	"L SIGN AIMYANMAR VOWEL SIGN MON IIMYANMAR VOWEL SIGN MON OMYANMAR VOWEL " +
	"SIGN E ABOVEMYANMAR SIGN ANUSVARAMYANMAR SIGN DOT BELOWMYANMAR SIGN VISA" +
	"RGAMYANMAR SIGN VIRAMAMYANMAR SIGN ASATMYANMAR CONSONANT SIGN MEDIAL YAM" +
	"YANMAR CONSONANT SIGN MEDIAL RAMYANMAR CONSONANT SIGN MEDIAL WAMYANMAR C" +
	"ONSONANT SIGN MEDIAL HAMYANMAR LETTER GREAT SAMYANMAR DIGIT ZEROMYANMAR " +
	"DIGIT ONEMYANMAR DIGIT TWOMYANMAR DIGIT THREEMYANMAR DIGIT FOURMYANMAR D" +
	"IGIT FIVEMYANMAR DIGIT SIXMYANMAR DIGIT SEVENMYANMAR DIGIT EIGHTMYANMAR " +
	"DIGIT NINEMYANMAR SIGN LITTLE SECTIONMYANMAR SIGN SECTIONMYANMAR SYMBOL " +
	"LOCATIVEMYANMAR SYMBOL COMPLETEDMYANMAR SYMBOL AFOREMENTIONEDMYANMAR SYM" +
	"BOL GENITIVEMYANMAR LETTER SHAMYANMAR LETTER SSAMYANMAR LETTER VOCALIC R" +
	"MYANMAR LETTER VOCALIC RRMYANMAR LETTER VOCALIC LMYANMAR LETTER VOCALIC " +
	"LLMYANMAR VOWEL SIGN VOCALIC RMYANMAR VOWEL SIGN VOCALIC RRMYANMAR VOWEL" +
	" SIGN VOCALIC LMYANMAR VOWEL SIGN VOCALIC LLMYANMAR LETTER MON NGAMYANMA" +
	"R LETTER MON JHAMYANMAR LETTER MON BBAMYANMAR LETTER MON BBEMYANMAR CONS") + ("" +
	"ONANT SIGN MON MEDIAL NAMYANMAR CONSONANT SIGN MON MEDIAL MAMYANMAR CONS" +
	"ONANT SIGN MON MEDIAL LAMYANMAR LETTER SGAW KAREN SHAMYANMAR VOWEL SIGN " +
	"SGAW KAREN EUMYANMAR TONE MARK SGAW KAREN HATHIMYANMAR TONE MARK SGAW KA" +
	"REN KE PHOMYANMAR LETTER WESTERN PWO KAREN THAMYANMAR LETTER WESTERN PWO" +
	" KAREN PWAMYANMAR VOWEL SIGN WESTERN PWO KAREN EUMYANMAR VOWEL SIGN WEST" +
	"ERN PWO KAREN UEMYANMAR SIGN WESTERN PWO KAREN TONE-1MYANMAR SIGN WESTER" +
	"N PWO KAREN TONE-2MYANMAR SIGN WESTERN PWO KAREN TONE-3MYANMAR SIGN WEST" +
	"ERN PWO KAREN TONE-4MYANMAR SIGN WESTERN PWO KAREN TONE-5MYANMAR LETTER " +
	"EASTERN PWO KAREN NNAMYANMAR LETTER EASTERN PWO KAREN YWAMYANMAR LETTER " +
	"EASTERN PWO KAREN GHWAMYANMAR VOWEL SIGN GEBA KAREN IMYANMAR VOWEL SIGN " +
	"KAYAH OEMYANMAR VOWEL SIGN KAYAH UMYANMAR VOWEL SIGN KAYAH EEMYANMAR LET" +
	"TER SHAN KAMYANMAR LETTER SHAN KHAMYANMAR LETTER SHAN GAMYANMAR LETTER S" +
	"HAN CAMYANMAR LETTER SHAN ZAMYANMAR LETTER SHAN NYAMYANMAR LETTER SHAN D" +
	"AMYANMAR LETTER SHAN NAMYANMAR LETTER SHAN PHAMYANMAR LETTER SHAN FAMYAN" +
	"MAR LETTER SHAN BAMYANMAR LETTER SHAN THAMYANMAR LETTER SHAN HAMYANMAR C" +
	"ONSONANT SIGN SHAN MEDIAL WAMYANMAR VOWEL SIGN SHAN AAMYANMAR VOWEL SIGN" +
	" SHAN EMYANMAR VOWEL SIGN SHAN E ABOVEMYANMAR VOWEL SIGN SHAN FINAL YMYA" +
	"NMAR SIGN SHAN TONE-2MYANMAR SIGN SHAN TONE-3MYANMAR SIGN SHAN TONE-5MYA" +
	"NMAR SIGN SHAN TONE-6MYANMAR SIGN SHAN COUNCIL TONE-2MYANMAR SIGN SHAN C" +
	"OUNCIL TONE-3MYANMAR SIGN SHAN COUNCIL EMPHATIC TONEMYANMAR LETTER RUMAI" +
	" PALAUNG FAMYANMAR SIGN RUMAI PALAUNG TONE-5MYANMAR SHAN DIGIT ZEROMYANM" +
	"AR SHAN DIGIT ONEMYANMAR SHAN DIGIT TWOMYANMAR SHAN DIGIT THREEMYANMAR S" +
	"HAN DIGIT FOURMYANMAR SHAN DIGIT FIVEMYANMAR SHAN DIGIT SIXMYANMAR SHAN " +
	"DIGIT SEVENMYANMAR SHAN DIGIT EIGHTMYANMAR SHAN DIGIT NINEMYANMAR SIGN K" +
	"HAMTI TONE-1MYANMAR SIGN KHAMTI TONE-3MYANMAR VOWEL SIGN AITON AMYANMAR " +
	"VOWEL SIGN AITON AIMYANMAR SYMBOL SHAN ONEMYANMAR SYMBOL SHAN EXCLAMATIO" +
	"NGEORGIAN CAPITAL LETTER ANGEORGIAN CAPITAL LETTER BANGEORGIAN CAPITAL L" +
	"ETTER GANGEORGIAN CAPITAL LETTER DONGEORGIAN CAPITAL LETTER ENGEORGIAN C" +
	"APITAL LETTER VINGEORGIAN CAPITAL LETTER ZENGEORGIAN CAPITAL LETTER TANG" +
	"EORGIAN CAPITAL LETTER INGEORGIAN CAPITAL LETTER KANGEORGIAN CAPITAL LET" +
	"TER LASGEORGIAN CAPITAL LETTER MANGEORGIAN CAPITAL LETTER NARGEORGIAN CA" +
	"PITAL LETTER ONGEORGIAN CAPITAL LETTER PARGEORGIAN CAPITAL LETTER ZHARGE" +
	"ORGIAN CAPITAL LETTER RAEGEORGIAN CAPITAL LETTER SANGEORGIAN CAPITAL LET" +
	"TER TARGEORGIAN CAPITAL LETTER UNGEORGIAN CAPITAL LETTER PHARGEORGIAN CA" +
	"PITAL LETTER KHARGEORGIAN CAPITAL LETTER GHANGEORGIAN CAPITAL LETTER QAR" +
	"GEORGIAN CAPITAL LETTER SHINGEORGIAN CAPITAL LETTER CHINGEORGIAN CAPITAL" +
	" LETTER CANGEORGIAN CAPITAL LETTER JILGEORGIAN CAPITAL LETTER CILGEORGIA" +
	"N CAPITAL LETTER CHARGEORGIAN CAPITAL LETTER XANGEORGIAN CAPITAL LETTER " +
	"JHANGEORGIAN CAPITAL LETTER HAEGEORGIAN CAPITAL LETTER HEGEORGIAN CAPITA" +
	"L LETTER HIEGEORGIAN CAPITAL LETTER WEGEORGIAN CAPITAL LETTER HARGEORGIA" +
	"N CAPITAL LETTER HOEGEORGIAN CAPITAL LETTER YNGEORGIAN CAPITAL LETTER AE" +
	"NGEORGIAN LETTER ANGEORGIAN LETTER BANGEORGIAN LETTER GANGEORGIAN LETTER" +
	" DONGEORGIAN LETTER ENGEORGIAN LETTER VINGEORGIAN LETTER ZENGEORGIAN LET" +
	"TER TANGEORGIAN LETTER INGEORGIAN LETTER KANGEORGIAN LETTER LASGEORGIAN " +
	"LETTER MANGEORGIAN LETTER NARGEORGIAN LETTER ONGEORGIAN LETTER PARGEORGI" +
	"AN LETTER ZHARGEORGIAN LETTER RAEGEORGIAN LETTER SANGEORGIAN LETTER TARG" +
	"EORGIAN LETTER UNGEORGIAN LETTER PHARGEORGIAN LETTER KHARGEORGIAN LETTER" +
	" GHANGEORGIAN LETTER QARGEORGIAN LETTER SHINGEORGIAN LETTER CHINGEORGIAN" +
	" LETTER CANGEORGIAN LETTER JILGEORGIAN LETTER CILGEORGIAN LETTER CHARGEO" +
	"RGIAN LETTER XANGEORGIAN LETTER JHANGEORGIAN LETTER HAEGEORGIAN LETTER H" +
	"EGEORGIAN LETTER HIEGEORGIAN LETTER WEGEORGIAN LETTER HARGEORGIAN LETTER" +
	" HOEGEORGIAN LETTER FIGEORGIAN LETTER YNGEORGIAN LETTER ELIFIGEORGIAN LE" +
	"TTER TURNED GANGEORGIAN LETTER AINGEORGIAN PARAGRAPH SEPARATORMODIFIER L" +
	"ETTER GEORGIAN NARGEORGIAN LETTER AENGEORGIAN LETTER HARD SIGNGEORGIAN L" +
	"ETTER LABIAL SIGNHANGUL CHOSEONG KIYEOKHANGUL CHOSEONG SSANGKIYEOKHANGUL" +
	" CHOSEONG NIEUNHANGUL CHOSEONG TIKEUTHANGUL CHOSEONG SSANGTIKEUTHANGUL C" +
	"HOSEONG RIEULHANGUL CHOSEONG MIEUMHANGUL CHOSEONG PIEUPHANGUL CHOSEONG S" +
	"SANGPIEUPHANGUL CHOSEONG SIOSHANGUL CHOSEONG SSANGSIOSHANGUL CHOSEONG IE" +
	"UNGHANGUL CHOSEONG CIEUCHANGUL CHOSEONG SSANGCIEUCHANGUL CHOSEONG CHIEUC" +
	"HHANGUL CHOSEONG KHIEUKHHANGUL CHOSEONG THIEUTHHANGUL CHOSEONG PHIEUPHHA" +
	"NGUL CHOSEONG HIEUHHANGUL CHOSEONG NIEUN-KIYEOKHANGUL CHOSEONG SSANGNIEU" +
	"NHANGUL CHOSEONG NIEUN-TIKEUTHANGUL CHOSEONG NIEUN-PIEUPHANGUL CHOSEONG " +
	"TIKEUT-KIYEOKHANGUL CHOSEONG RIEUL-NIEUNHANGUL CHOSEONG SSANGRIEULHANGUL" +
	" CHOSEONG RIEUL-HIEUHHANGUL CHOSEONG KAPYEOUNRIEULHANGUL CHOSEONG MIEUM-") + ("" +
	"PIEUPHANGUL CHOSEONG KAPYEOUNMIEUMHANGUL CHOSEONG PIEUP-KIYEOKHANGUL CHO" +
	"SEONG PIEUP-NIEUNHANGUL CHOSEONG PIEUP-TIKEUTHANGUL CHOSEONG PIEUP-SIOSH" +
	"ANGUL CHOSEONG PIEUP-SIOS-KIYEOKHANGUL CHOSEONG PIEUP-SIOS-TIKEUTHANGUL " +
	"CHOSEONG PIEUP-SIOS-PIEUPHANGUL CHOSEONG PIEUP-SSANGSIOSHANGUL CHOSEONG " +
	"PIEUP-SIOS-CIEUCHANGUL CHOSEONG PIEUP-CIEUCHANGUL CHOSEONG PIEUP-CHIEUCH" +
	"HANGUL CHOSEONG PIEUP-THIEUTHHANGUL CHOSEONG PIEUP-PHIEUPHHANGUL CHOSEON" +
	"G KAPYEOUNPIEUPHANGUL CHOSEONG KAPYEOUNSSANGPIEUPHANGUL CHOSEONG SIOS-KI" +
	"YEOKHANGUL CHOSEONG SIOS-NIEUNHANGUL CHOSEONG SIOS-TIKEUTHANGUL CHOSEONG" +
	" SIOS-RIEULHANGUL CHOSEONG SIOS-MIEUMHANGUL CHOSEONG SIOS-PIEUPHANGUL CH" +
	"OSEONG SIOS-PIEUP-KIYEOKHANGUL CHOSEONG SIOS-SSANGSIOSHANGUL CHOSEONG SI" +
	"OS-IEUNGHANGUL CHOSEONG SIOS-CIEUCHANGUL CHOSEONG SIOS-CHIEUCHHANGUL CHO" +
	"SEONG SIOS-KHIEUKHHANGUL CHOSEONG SIOS-THIEUTHHANGUL CHOSEONG SIOS-PHIEU" +
	"PHHANGUL CHOSEONG SIOS-HIEUHHANGUL CHOSEONG CHITUEUMSIOSHANGUL CHOSEONG " +
	"CHITUEUMSSANGSIOSHANGUL CHOSEONG CEONGCHIEUMSIOSHANGUL CHOSEONG CEONGCHI" +
	"EUMSSANGSIOSHANGUL CHOSEONG PANSIOSHANGUL CHOSEONG IEUNG-KIYEOKHANGUL CH" +
	"OSEONG IEUNG-TIKEUTHANGUL CHOSEONG IEUNG-MIEUMHANGUL CHOSEONG IEUNG-PIEU" +
	"PHANGUL CHOSEONG IEUNG-SIOSHANGUL CHOSEONG IEUNG-PANSIOSHANGUL CHOSEONG " +
	"SSANGIEUNGHANGUL CHOSEONG IEUNG-CIEUCHANGUL CHOSEONG IEUNG-CHIEUCHHANGUL" +
	" CHOSEONG IEUNG-THIEUTHHANGUL CHOSEONG IEUNG-PHIEUPHHANGUL CHOSEONG YESI" +
	"EUNGHANGUL CHOSEONG CIEUC-IEUNGHANGUL CHOSEONG CHITUEUMCIEUCHANGUL CHOSE" +
	"ONG CHITUEUMSSANGCIEUCHANGUL CHOSEONG CEONGCHIEUMCIEUCHANGUL CHOSEONG CE" +
	"ONGCHIEUMSSANGCIEUCHANGUL CHOSEONG CHIEUCH-KHIEUKHHANGUL CHOSEONG CHIEUC" +
	"H-HIEUHHANGUL CHOSEONG CHITUEUMCHIEUCHHANGUL CHOSEONG CEONGCHIEUMCHIEUCH" +
	"HANGUL CHOSEONG PHIEUPH-PIEUPHANGUL CHOSEONG KAPYEOUNPHIEUPHHANGUL CHOSE" +
	"ONG SSANGHIEUHHANGUL CHOSEONG YEORINHIEUHHANGUL CHOSEONG KIYEOK-TIKEUTHA" +
	"NGUL CHOSEONG NIEUN-SIOSHANGUL CHOSEONG NIEUN-CIEUCHANGUL CHOSEONG NIEUN" +
	"-HIEUHHANGUL CHOSEONG TIKEUT-RIEULHANGUL CHOSEONG FILLERHANGUL JUNGSEONG" +
	" FILLERHANGUL JUNGSEONG AHANGUL JUNGSEONG AEHANGUL JUNGSEONG YAHANGUL JU" +
	"NGSEONG YAEHANGUL JUNGSEONG EOHANGUL JUNGSEONG EHANGUL JUNGSEONG YEOHANG" +
	"UL JUNGSEONG YEHANGUL JUNGSEONG OHANGUL JUNGSEONG WAHANGUL JUNGSEONG WAE" +
	"HANGUL JUNGSEONG OEHANGUL JUNGSEONG YOHANGUL JUNGSEONG UHANGUL JUNGSEONG" +
	" WEOHANGUL JUNGSEONG WEHANGUL JUNGSEONG WIHANGUL JUNGSEONG YUHANGUL JUNG" +
	"SEONG EUHANGUL JUNGSEONG YIHANGUL JUNGSEONG IHANGUL JUNGSEONG A-OHANGUL " +
	"JUNGSEONG A-UHANGUL JUNGSEONG YA-OHANGUL JUNGSEONG YA-YOHANGUL JUNGSEONG" +
	" EO-OHANGUL JUNGSEONG EO-UHANGUL JUNGSEONG EO-EUHANGUL JUNGSEONG YEO-OHA" +
	"NGUL JUNGSEONG YEO-UHANGUL JUNGSEONG O-EOHANGUL JUNGSEONG O-EHANGUL JUNG" +
	"SEONG O-YEHANGUL JUNGSEONG O-OHANGUL JUNGSEONG O-UHANGUL JUNGSEONG YO-YA" +
	"HANGUL JUNGSEONG YO-YAEHANGUL JUNGSEONG YO-YEOHANGUL JUNGSEONG YO-OHANGU" +
	"L JUNGSEONG YO-IHANGUL JUNGSEONG U-AHANGUL JUNGSEONG U-AEHANGUL JUNGSEON" +
	"G U-EO-EUHANGUL JUNGSEONG U-YEHANGUL JUNGSEONG U-UHANGUL JUNGSEONG YU-AH" +
	"ANGUL JUNGSEONG YU-EOHANGUL JUNGSEONG YU-EHANGUL JUNGSEONG YU-YEOHANGUL " +
	"JUNGSEONG YU-YEHANGUL JUNGSEONG YU-UHANGUL JUNGSEONG YU-IHANGUL JUNGSEON" +
	"G EU-UHANGUL JUNGSEONG EU-EUHANGUL JUNGSEONG YI-UHANGUL JUNGSEONG I-AHAN" +
	"GUL JUNGSEONG I-YAHANGUL JUNGSEONG I-OHANGUL JUNGSEONG I-UHANGUL JUNGSEO" +
	"NG I-EUHANGUL JUNGSEONG I-ARAEAHANGUL JUNGSEONG ARAEAHANGUL JUNGSEONG AR" +
	"AEA-EOHANGUL JUNGSEONG ARAEA-UHANGUL JUNGSEONG ARAEA-IHANGUL JUNGSEONG S" +
	"SANGARAEAHANGUL JUNGSEONG A-EUHANGUL JUNGSEONG YA-UHANGUL JUNGSEONG YEO-" +
	"YAHANGUL JUNGSEONG O-YAHANGUL JUNGSEONG O-YAEHANGUL JONGSEONG KIYEOKHANG" +
	"UL JONGSEONG SSANGKIYEOKHANGUL JONGSEONG KIYEOK-SIOSHANGUL JONGSEONG NIE" +
	"UNHANGUL JONGSEONG NIEUN-CIEUCHANGUL JONGSEONG NIEUN-HIEUHHANGUL JONGSEO" +
	"NG TIKEUTHANGUL JONGSEONG RIEULHANGUL JONGSEONG RIEUL-KIYEOKHANGUL JONGS" +
	"EONG RIEUL-MIEUMHANGUL JONGSEONG RIEUL-PIEUPHANGUL JONGSEONG RIEUL-SIOSH" +
	"ANGUL JONGSEONG RIEUL-THIEUTHHANGUL JONGSEONG RIEUL-PHIEUPHHANGUL JONGSE" +
	"ONG RIEUL-HIEUHHANGUL JONGSEONG MIEUMHANGUL JONGSEONG PIEUPHANGUL JONGSE" +
	"ONG PIEUP-SIOSHANGUL JONGSEONG SIOSHANGUL JONGSEONG SSANGSIOSHANGUL JONG" +
	"SEONG IEUNGHANGUL JONGSEONG CIEUCHANGUL JONGSEONG CHIEUCHHANGUL JONGSEON" +
	"G KHIEUKHHANGUL JONGSEONG THIEUTHHANGUL JONGSEONG PHIEUPHHANGUL JONGSEON" +
	"G HIEUHHANGUL JONGSEONG KIYEOK-RIEULHANGUL JONGSEONG KIYEOK-SIOS-KIYEOKH" +
	"ANGUL JONGSEONG NIEUN-KIYEOKHANGUL JONGSEONG NIEUN-TIKEUTHANGUL JONGSEON" +
	"G NIEUN-SIOSHANGUL JONGSEONG NIEUN-PANSIOSHANGUL JONGSEONG NIEUN-THIEUTH" +
	"HANGUL JONGSEONG TIKEUT-KIYEOKHANGUL JONGSEONG TIKEUT-RIEULHANGUL JONGSE" +
	"ONG RIEUL-KIYEOK-SIOSHANGUL JONGSEONG RIEUL-NIEUNHANGUL JONGSEONG RIEUL-" +
	"TIKEUTHANGUL JONGSEONG RIEUL-TIKEUT-HIEUHHANGUL JONGSEONG SSANGRIEULHANG" +
	"UL JONGSEONG RIEUL-MIEUM-KIYEOKHANGUL JONGSEONG RIEUL-MIEUM-SIOSHANGUL J") + ("" +
	"ONGSEONG RIEUL-PIEUP-SIOSHANGUL JONGSEONG RIEUL-PIEUP-HIEUHHANGUL JONGSE" +
	"ONG RIEUL-KAPYEOUNPIEUPHANGUL JONGSEONG RIEUL-SSANGSIOSHANGUL JONGSEONG " +
	"RIEUL-PANSIOSHANGUL JONGSEONG RIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-YEORIN" +
	"HIEUHHANGUL JONGSEONG MIEUM-KIYEOKHANGUL JONGSEONG MIEUM-RIEULHANGUL JON" +
	"GSEONG MIEUM-PIEUPHANGUL JONGSEONG MIEUM-SIOSHANGUL JONGSEONG MIEUM-SSAN" +
	"GSIOSHANGUL JONGSEONG MIEUM-PANSIOSHANGUL JONGSEONG MIEUM-CHIEUCHHANGUL " +
	"JONGSEONG MIEUM-HIEUHHANGUL JONGSEONG KAPYEOUNMIEUMHANGUL JONGSEONG PIEU" +
	"P-RIEULHANGUL JONGSEONG PIEUP-PHIEUPHHANGUL JONGSEONG PIEUP-HIEUHHANGUL " +
	"JONGSEONG KAPYEOUNPIEUPHANGUL JONGSEONG SIOS-KIYEOKHANGUL JONGSEONG SIOS" +
	"-TIKEUTHANGUL JONGSEONG SIOS-RIEULHANGUL JONGSEONG SIOS-PIEUPHANGUL JONG" +
	"SEONG PANSIOSHANGUL JONGSEONG IEUNG-KIYEOKHANGUL JONGSEONG IEUNG-SSANGKI" +
	"YEOKHANGUL JONGSEONG SSANGIEUNGHANGUL JONGSEONG IEUNG-KHIEUKHHANGUL JONG" +
	"SEONG YESIEUNGHANGUL JONGSEONG YESIEUNG-SIOSHANGUL JONGSEONG YESIEUNG-PA" +
	"NSIOSHANGUL JONGSEONG PHIEUPH-PIEUPHANGUL JONGSEONG KAPYEOUNPHIEUPHHANGU" +
	"L JONGSEONG HIEUH-NIEUNHANGUL JONGSEONG HIEUH-RIEULHANGUL JONGSEONG HIEU" +
	"H-MIEUMHANGUL JONGSEONG HIEUH-PIEUPHANGUL JONGSEONG YEORINHIEUHHANGUL JO" +
	"NGSEONG KIYEOK-NIEUNHANGUL JONGSEONG KIYEOK-PIEUPHANGUL JONGSEONG KIYEOK" +
	"-CHIEUCHHANGUL JONGSEONG KIYEOK-KHIEUKHHANGUL JONGSEONG KIYEOK-HIEUHHANG" +
	"UL JONGSEONG SSANGNIEUNETHIOPIC SYLLABLE HAETHIOPIC SYLLABLE HUETHIOPIC " +
	"SYLLABLE HIETHIOPIC SYLLABLE HAAETHIOPIC SYLLABLE HEEETHIOPIC SYLLABLE H" +
	"EETHIOPIC SYLLABLE HOETHIOPIC SYLLABLE HOAETHIOPIC SYLLABLE LAETHIOPIC S" +
	"YLLABLE LUETHIOPIC SYLLABLE LIETHIOPIC SYLLABLE LAAETHIOPIC SYLLABLE LEE" +
	"ETHIOPIC SYLLABLE LEETHIOPIC SYLLABLE LOETHIOPIC SYLLABLE LWAETHIOPIC SY" +
	"LLABLE HHAETHIOPIC SYLLABLE HHUETHIOPIC SYLLABLE HHIETHIOPIC SYLLABLE HH" +
	"AAETHIOPIC SYLLABLE HHEEETHIOPIC SYLLABLE HHEETHIOPIC SYLLABLE HHOETHIOP" +
	"IC SYLLABLE HHWAETHIOPIC SYLLABLE MAETHIOPIC SYLLABLE MUETHIOPIC SYLLABL" +
	"E MIETHIOPIC SYLLABLE MAAETHIOPIC SYLLABLE MEEETHIOPIC SYLLABLE MEETHIOP" +
	"IC SYLLABLE MOETHIOPIC SYLLABLE MWAETHIOPIC SYLLABLE SZAETHIOPIC SYLLABL" +
	"E SZUETHIOPIC SYLLABLE SZIETHIOPIC SYLLABLE SZAAETHIOPIC SYLLABLE SZEEET" +
	"HIOPIC SYLLABLE SZEETHIOPIC SYLLABLE SZOETHIOPIC SYLLABLE SZWAETHIOPIC S" +
	"YLLABLE RAETHIOPIC SYLLABLE RUETHIOPIC SYLLABLE RIETHIOPIC SYLLABLE RAAE" +
	"THIOPIC SYLLABLE REEETHIOPIC SYLLABLE REETHIOPIC SYLLABLE ROETHIOPIC SYL" +
	"LABLE RWAETHIOPIC SYLLABLE SAETHIOPIC SYLLABLE SUETHIOPIC SYLLABLE SIETH" +
	"IOPIC SYLLABLE SAAETHIOPIC SYLLABLE SEEETHIOPIC SYLLABLE SEETHIOPIC SYLL" +
	"ABLE SOETHIOPIC SYLLABLE SWAETHIOPIC SYLLABLE SHAETHIOPIC SYLLABLE SHUET" +
	"HIOPIC SYLLABLE SHIETHIOPIC SYLLABLE SHAAETHIOPIC SYLLABLE SHEEETHIOPIC " +
	"SYLLABLE SHEETHIOPIC SYLLABLE SHOETHIOPIC SYLLABLE SHWAETHIOPIC SYLLABLE" +
	" QAETHIOPIC SYLLABLE QUETHIOPIC SYLLABLE QIETHIOPIC SYLLABLE QAAETHIOPIC" +
	" SYLLABLE QEEETHIOPIC SYLLABLE QEETHIOPIC SYLLABLE QOETHIOPIC SYLLABLE Q" +
	"OAETHIOPIC SYLLABLE QWAETHIOPIC SYLLABLE QWIETHIOPIC SYLLABLE QWAAETHIOP" +
	"IC SYLLABLE QWEEETHIOPIC SYLLABLE QWEETHIOPIC SYLLABLE QHAETHIOPIC SYLLA" +
	"BLE QHUETHIOPIC SYLLABLE QHIETHIOPIC SYLLABLE QHAAETHIOPIC SYLLABLE QHEE" +
	"ETHIOPIC SYLLABLE QHEETHIOPIC SYLLABLE QHOETHIOPIC SYLLABLE QHWAETHIOPIC" +
	" SYLLABLE QHWIETHIOPIC SYLLABLE QHWAAETHIOPIC SYLLABLE QHWEEETHIOPIC SYL" +
	"LABLE QHWEETHIOPIC SYLLABLE BAETHIOPIC SYLLABLE BUETHIOPIC SYLLABLE BIET" +
	"HIOPIC SYLLABLE BAAETHIOPIC SYLLABLE BEEETHIOPIC SYLLABLE BEETHIOPIC SYL" +
	"LABLE BOETHIOPIC SYLLABLE BWAETHIOPIC SYLLABLE VAETHIOPIC SYLLABLE VUETH" +
	"IOPIC SYLLABLE VIETHIOPIC SYLLABLE VAAETHIOPIC SYLLABLE VEEETHIOPIC SYLL" +
	"ABLE VEETHIOPIC SYLLABLE VOETHIOPIC SYLLABLE VWAETHIOPIC SYLLABLE TAETHI" +
	"OPIC SYLLABLE TUETHIOPIC SYLLABLE TIETHIOPIC SYLLABLE TAAETHIOPIC SYLLAB" +
	"LE TEEETHIOPIC SYLLABLE TEETHIOPIC SYLLABLE TOETHIOPIC SYLLABLE TWAETHIO" +
	"PIC SYLLABLE CAETHIOPIC SYLLABLE CUETHIOPIC SYLLABLE CIETHIOPIC SYLLABLE" +
	" CAAETHIOPIC SYLLABLE CEEETHIOPIC SYLLABLE CEETHIOPIC SYLLABLE COETHIOPI" +
	"C SYLLABLE CWAETHIOPIC SYLLABLE XAETHIOPIC SYLLABLE XUETHIOPIC SYLLABLE " +
	"XIETHIOPIC SYLLABLE XAAETHIOPIC SYLLABLE XEEETHIOPIC SYLLABLE XEETHIOPIC" +
	" SYLLABLE XOETHIOPIC SYLLABLE XOAETHIOPIC SYLLABLE XWAETHIOPIC SYLLABLE " +
	"XWIETHIOPIC SYLLABLE XWAAETHIOPIC SYLLABLE XWEEETHIOPIC SYLLABLE XWEETHI" +
	"OPIC SYLLABLE NAETHIOPIC SYLLABLE NUETHIOPIC SYLLABLE NIETHIOPIC SYLLABL" +
	"E NAAETHIOPIC SYLLABLE NEEETHIOPIC SYLLABLE NEETHIOPIC SYLLABLE NOETHIOP" +
	"IC SYLLABLE NWAETHIOPIC SYLLABLE NYAETHIOPIC SYLLABLE NYUETHIOPIC SYLLAB" +
	"LE NYIETHIOPIC SYLLABLE NYAAETHIOPIC SYLLABLE NYEEETHIOPIC SYLLABLE NYEE" +
	"THIOPIC SYLLABLE NYOETHIOPIC SYLLABLE NYWAETHIOPIC SYLLABLE GLOTTAL AETH" +
	"IOPIC SYLLABLE GLOTTAL UETHIOPIC SYLLABLE GLOTTAL IETHIOPIC SYLLABLE GLO" +
	"TTAL AAETHIOPIC SYLLABLE GLOTTAL EEETHIOPIC SYLLABLE GLOTTAL EETHIOPIC S") + ("" +
	"YLLABLE GLOTTAL OETHIOPIC SYLLABLE GLOTTAL WAETHIOPIC SYLLABLE KAETHIOPI" +
	"C SYLLABLE KUETHIOPIC SYLLABLE KIETHIOPIC SYLLABLE KAAETHIOPIC SYLLABLE " +
	"KEEETHIOPIC SYLLABLE KEETHIOPIC SYLLABLE KOETHIOPIC SYLLABLE KOAETHIOPIC" +
	" SYLLABLE KWAETHIOPIC SYLLABLE KWIETHIOPIC SYLLABLE KWAAETHIOPIC SYLLABL" +
	"E KWEEETHIOPIC SYLLABLE KWEETHIOPIC SYLLABLE KXAETHIOPIC SYLLABLE KXUETH" +
	"IOPIC SYLLABLE KXIETHIOPIC SYLLABLE KXAAETHIOPIC SYLLABLE KXEEETHIOPIC S" +
	"YLLABLE KXEETHIOPIC SYLLABLE KXOETHIOPIC SYLLABLE KXWAETHIOPIC SYLLABLE " +
	"KXWIETHIOPIC SYLLABLE KXWAAETHIOPIC SYLLABLE KXWEEETHIOPIC SYLLABLE KXWE" +
	"ETHIOPIC SYLLABLE WAETHIOPIC SYLLABLE WUETHIOPIC SYLLABLE WIETHIOPIC SYL" +
	"LABLE WAAETHIOPIC SYLLABLE WEEETHIOPIC SYLLABLE WEETHIOPIC SYLLABLE WOET" +
	"HIOPIC SYLLABLE WOAETHIOPIC SYLLABLE PHARYNGEAL AETHIOPIC SYLLABLE PHARY" +
	"NGEAL UETHIOPIC SYLLABLE PHARYNGEAL IETHIOPIC SYLLABLE PHARYNGEAL AAETHI" +
	"OPIC SYLLABLE PHARYNGEAL EEETHIOPIC SYLLABLE PHARYNGEAL EETHIOPIC SYLLAB" +
	"LE PHARYNGEAL OETHIOPIC SYLLABLE ZAETHIOPIC SYLLABLE ZUETHIOPIC SYLLABLE" +
	" ZIETHIOPIC SYLLABLE ZAAETHIOPIC SYLLABLE ZEEETHIOPIC SYLLABLE ZEETHIOPI" +
	"C SYLLABLE ZOETHIOPIC SYLLABLE ZWAETHIOPIC SYLLABLE ZHAETHIOPIC SYLLABLE" +
	" ZHUETHIOPIC SYLLABLE ZHIETHIOPIC SYLLABLE ZHAAETHIOPIC SYLLABLE ZHEEETH" +
	"IOPIC SYLLABLE ZHEETHIOPIC SYLLABLE ZHOETHIOPIC SYLLABLE ZHWAETHIOPIC SY" +
	"LLABLE YAETHIOPIC SYLLABLE YUETHIOPIC SYLLABLE YIETHIOPIC SYLLABLE YAAET" +
	"HIOPIC SYLLABLE YEEETHIOPIC SYLLABLE YEETHIOPIC SYLLABLE YOETHIOPIC SYLL" +
	"ABLE YOAETHIOPIC SYLLABLE DAETHIOPIC SYLLABLE DUETHIOPIC SYLLABLE DIETHI" +
	"OPIC SYLLABLE DAAETHIOPIC SYLLABLE DEEETHIOPIC SYLLABLE DEETHIOPIC SYLLA" +
	"BLE DOETHIOPIC SYLLABLE DWAETHIOPIC SYLLABLE DDAETHIOPIC SYLLABLE DDUETH" +
	"IOPIC SYLLABLE DDIETHIOPIC SYLLABLE DDAAETHIOPIC SYLLABLE DDEEETHIOPIC S" +
	"YLLABLE DDEETHIOPIC SYLLABLE DDOETHIOPIC SYLLABLE DDWAETHIOPIC SYLLABLE " +
	"JAETHIOPIC SYLLABLE JUETHIOPIC SYLLABLE JIETHIOPIC SYLLABLE JAAETHIOPIC " +
	"SYLLABLE JEEETHIOPIC SYLLABLE JEETHIOPIC SYLLABLE JOETHIOPIC SYLLABLE JW" +
	"AETHIOPIC SYLLABLE GAETHIOPIC SYLLABLE GUETHIOPIC SYLLABLE GIETHIOPIC SY" +
	"LLABLE GAAETHIOPIC SYLLABLE GEEETHIOPIC SYLLABLE GEETHIOPIC SYLLABLE GOE" +
	"THIOPIC SYLLABLE GOAETHIOPIC SYLLABLE GWAETHIOPIC SYLLABLE GWIETHIOPIC S" +
	"YLLABLE GWAAETHIOPIC SYLLABLE GWEEETHIOPIC SYLLABLE GWEETHIOPIC SYLLABLE" +
	" GGAETHIOPIC SYLLABLE GGUETHIOPIC SYLLABLE GGIETHIOPIC SYLLABLE GGAAETHI" +
	"OPIC SYLLABLE GGEEETHIOPIC SYLLABLE GGEETHIOPIC SYLLABLE GGOETHIOPIC SYL" +
	"LABLE GGWAAETHIOPIC SYLLABLE THAETHIOPIC SYLLABLE THUETHIOPIC SYLLABLE T" +
	"HIETHIOPIC SYLLABLE THAAETHIOPIC SYLLABLE THEEETHIOPIC SYLLABLE THEETHIO" +
	"PIC SYLLABLE THOETHIOPIC SYLLABLE THWAETHIOPIC SYLLABLE CHAETHIOPIC SYLL" +
	"ABLE CHUETHIOPIC SYLLABLE CHIETHIOPIC SYLLABLE CHAAETHIOPIC SYLLABLE CHE" +
	"EETHIOPIC SYLLABLE CHEETHIOPIC SYLLABLE CHOETHIOPIC SYLLABLE CHWAETHIOPI" +
	"C SYLLABLE PHAETHIOPIC SYLLABLE PHUETHIOPIC SYLLABLE PHIETHIOPIC SYLLABL" +
	"E PHAAETHIOPIC SYLLABLE PHEEETHIOPIC SYLLABLE PHEETHIOPIC SYLLABLE PHOET" +
	"HIOPIC SYLLABLE PHWAETHIOPIC SYLLABLE TSAETHIOPIC SYLLABLE TSUETHIOPIC S" +
	"YLLABLE TSIETHIOPIC SYLLABLE TSAAETHIOPIC SYLLABLE TSEEETHIOPIC SYLLABLE" +
	" TSEETHIOPIC SYLLABLE TSOETHIOPIC SYLLABLE TSWAETHIOPIC SYLLABLE TZAETHI" +
	"OPIC SYLLABLE TZUETHIOPIC SYLLABLE TZIETHIOPIC SYLLABLE TZAAETHIOPIC SYL" +
	"LABLE TZEEETHIOPIC SYLLABLE TZEETHIOPIC SYLLABLE TZOETHIOPIC SYLLABLE TZ" +
	"OAETHIOPIC SYLLABLE FAETHIOPIC SYLLABLE FUETHIOPIC SYLLABLE FIETHIOPIC S" +
	"YLLABLE FAAETHIOPIC SYLLABLE FEEETHIOPIC SYLLABLE FEETHIOPIC SYLLABLE FO" +
	"ETHIOPIC SYLLABLE FWAETHIOPIC SYLLABLE PAETHIOPIC SYLLABLE PUETHIOPIC SY" +
	"LLABLE PIETHIOPIC SYLLABLE PAAETHIOPIC SYLLABLE PEEETHIOPIC SYLLABLE PEE" +
	"THIOPIC SYLLABLE POETHIOPIC SYLLABLE PWAETHIOPIC SYLLABLE RYAETHIOPIC SY" +
	"LLABLE MYAETHIOPIC SYLLABLE FYAETHIOPIC COMBINING GEMINATION AND VOWEL L" +
	"ENGTH MARKETHIOPIC COMBINING VOWEL LENGTH MARKETHIOPIC COMBINING GEMINAT" +
	"ION MARKETHIOPIC SECTION MARKETHIOPIC WORDSPACEETHIOPIC FULL STOPETHIOPI" +
	"C COMMAETHIOPIC SEMICOLONETHIOPIC COLONETHIOPIC PREFACE COLONETHIOPIC QU" +
	"ESTION MARKETHIOPIC PARAGRAPH SEPARATORETHIOPIC DIGIT ONEETHIOPIC DIGIT " +
	"TWOETHIOPIC DIGIT THREEETHIOPIC DIGIT FOURETHIOPIC DIGIT FIVEETHIOPIC DI" +
	"GIT SIXETHIOPIC DIGIT SEVENETHIOPIC DIGIT EIGHTETHIOPIC DIGIT NINEETHIOP" +
	"IC NUMBER TENETHIOPIC NUMBER TWENTYETHIOPIC NUMBER THIRTYETHIOPIC NUMBER" +
	" FORTYETHIOPIC NUMBER FIFTYETHIOPIC NUMBER SIXTYETHIOPIC NUMBER SEVENTYE" +
	"THIOPIC NUMBER EIGHTYETHIOPIC NUMBER NINETYETHIOPIC NUMBER HUNDREDETHIOP" +
	"IC NUMBER TEN THOUSANDETHIOPIC SYLLABLE SEBATBEIT MWAETHIOPIC SYLLABLE M" +
	"WIETHIOPIC SYLLABLE MWEEETHIOPIC SYLLABLE MWEETHIOPIC SYLLABLE SEBATBEIT" +
	" BWAETHIOPIC SYLLABLE BWIETHIOPIC SYLLABLE BWEEETHIOPIC SYLLABLE BWEETHI" +
	"OPIC SYLLABLE SEBATBEIT FWAETHIOPIC SYLLABLE FWIETHIOPIC SYLLABLE FWEEET") + ("" +
	"HIOPIC SYLLABLE FWEETHIOPIC SYLLABLE SEBATBEIT PWAETHIOPIC SYLLABLE PWIE" +
	"THIOPIC SYLLABLE PWEEETHIOPIC SYLLABLE PWEETHIOPIC TONAL MARK YIZETETHIO" +
	"PIC TONAL MARK DERETETHIOPIC TONAL MARK RIKRIKETHIOPIC TONAL MARK SHORT " +
	"RIKRIKETHIOPIC TONAL MARK DIFATETHIOPIC TONAL MARK KENATETHIOPIC TONAL M" +
	"ARK CHIRETETHIOPIC TONAL MARK HIDETETHIOPIC TONAL MARK DERET-HIDETETHIOP" +
	"IC TONAL MARK KURTCHEROKEE LETTER ACHEROKEE LETTER ECHEROKEE LETTER ICHE" +
	"ROKEE LETTER OCHEROKEE LETTER UCHEROKEE LETTER VCHEROKEE LETTER GACHEROK" +
	"EE LETTER KACHEROKEE LETTER GECHEROKEE LETTER GICHEROKEE LETTER GOCHEROK" +
	"EE LETTER GUCHEROKEE LETTER GVCHEROKEE LETTER HACHEROKEE LETTER HECHEROK" +
	"EE LETTER HICHEROKEE LETTER HOCHEROKEE LETTER HUCHEROKEE LETTER HVCHEROK" +
	"EE LETTER LACHEROKEE LETTER LECHEROKEE LETTER LICHEROKEE LETTER LOCHEROK" +
	"EE LETTER LUCHEROKEE LETTER LVCHEROKEE LETTER MACHEROKEE LETTER MECHEROK" +
	"EE LETTER MICHEROKEE LETTER MOCHEROKEE LETTER MUCHEROKEE LETTER NACHEROK" +
	"EE LETTER HNACHEROKEE LETTER NAHCHEROKEE LETTER NECHEROKEE LETTER NICHER" +
	"OKEE LETTER NOCHEROKEE LETTER NUCHEROKEE LETTER NVCHEROKEE LETTER QUACHE" +
	"ROKEE LETTER QUECHEROKEE LETTER QUICHEROKEE LETTER QUOCHEROKEE LETTER QU" +
	"UCHEROKEE LETTER QUVCHEROKEE LETTER SACHEROKEE LETTER SCHEROKEE LETTER S" +
	"ECHEROKEE LETTER SICHEROKEE LETTER SOCHEROKEE LETTER SUCHEROKEE LETTER S" +
	"VCHEROKEE LETTER DACHEROKEE LETTER TACHEROKEE LETTER DECHEROKEE LETTER T" +
	"ECHEROKEE LETTER DICHEROKEE LETTER TICHEROKEE LETTER DOCHEROKEE LETTER D" +
	"UCHEROKEE LETTER DVCHEROKEE LETTER DLACHEROKEE LETTER TLACHEROKEE LETTER" +
	" TLECHEROKEE LETTER TLICHEROKEE LETTER TLOCHEROKEE LETTER TLUCHEROKEE LE" +
	"TTER TLVCHEROKEE LETTER TSACHEROKEE LETTER TSECHEROKEE LETTER TSICHEROKE" +
	"E LETTER TSOCHEROKEE LETTER TSUCHEROKEE LETTER TSVCHEROKEE LETTER WACHER" +
	"OKEE LETTER WECHEROKEE LETTER WICHEROKEE LETTER WOCHEROKEE LETTER WUCHER" +
	"OKEE LETTER WVCHEROKEE LETTER YACHEROKEE LETTER YECHEROKEE LETTER YICHER" +
	"OKEE LETTER YOCHEROKEE LETTER YUCHEROKEE LETTER YVCHEROKEE LETTER MVCHER" +
	"OKEE SMALL LETTER YECHEROKEE SMALL LETTER YICHEROKEE SMALL LETTER YOCHER" +
	"OKEE SMALL LETTER YUCHEROKEE SMALL LETTER YVCHEROKEE SMALL LETTER MVCANA" +
	"DIAN SYLLABICS HYPHENCANADIAN SYLLABICS ECANADIAN SYLLABICS AAICANADIAN " +
	"SYLLABICS ICANADIAN SYLLABICS IICANADIAN SYLLABICS OCANADIAN SYLLABICS O" +
	"OCANADIAN SYLLABICS Y-CREE OOCANADIAN SYLLABICS CARRIER EECANADIAN SYLLA" +
	"BICS CARRIER ICANADIAN SYLLABICS ACANADIAN SYLLABICS AACANADIAN SYLLABIC" +
	"S WECANADIAN SYLLABICS WEST-CREE WECANADIAN SYLLABICS WICANADIAN SYLLABI" +
	"CS WEST-CREE WICANADIAN SYLLABICS WIICANADIAN SYLLABICS WEST-CREE WIICAN" +
	"ADIAN SYLLABICS WOCANADIAN SYLLABICS WEST-CREE WOCANADIAN SYLLABICS WOOC" +
	"ANADIAN SYLLABICS WEST-CREE WOOCANADIAN SYLLABICS NASKAPI WOOCANADIAN SY" +
	"LLABICS WACANADIAN SYLLABICS WEST-CREE WACANADIAN SYLLABICS WAACANADIAN " +
	"SYLLABICS WEST-CREE WAACANADIAN SYLLABICS NASKAPI WAACANADIAN SYLLABICS " +
	"AICANADIAN SYLLABICS Y-CREE WCANADIAN SYLLABICS GLOTTAL STOPCANADIAN SYL" +
	"LABICS FINAL ACUTECANADIAN SYLLABICS FINAL GRAVECANADIAN SYLLABICS FINAL" +
	" BOTTOM HALF RINGCANADIAN SYLLABICS FINAL TOP HALF RINGCANADIAN SYLLABIC" +
	"S FINAL RIGHT HALF RINGCANADIAN SYLLABICS FINAL RINGCANADIAN SYLLABICS F" +
	"INAL DOUBLE ACUTECANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKESC" +
	"ANADIAN SYLLABICS FINAL MIDDLE DOTCANADIAN SYLLABICS FINAL SHORT HORIZON" +
	"TAL STROKECANADIAN SYLLABICS FINAL PLUSCANADIAN SYLLABICS FINAL DOWN TAC" +
	"KCANADIAN SYLLABICS ENCANADIAN SYLLABICS INCANADIAN SYLLABICS ONCANADIAN" +
	" SYLLABICS ANCANADIAN SYLLABICS PECANADIAN SYLLABICS PAAICANADIAN SYLLAB" +
	"ICS PICANADIAN SYLLABICS PIICANADIAN SYLLABICS POCANADIAN SYLLABICS POOC" +
	"ANADIAN SYLLABICS Y-CREE POOCANADIAN SYLLABICS CARRIER HEECANADIAN SYLLA" +
	"BICS CARRIER HICANADIAN SYLLABICS PACANADIAN SYLLABICS PAACANADIAN SYLLA" +
	"BICS PWECANADIAN SYLLABICS WEST-CREE PWECANADIAN SYLLABICS PWICANADIAN S" +
	"YLLABICS WEST-CREE PWICANADIAN SYLLABICS PWIICANADIAN SYLLABICS WEST-CRE" +
	"E PWIICANADIAN SYLLABICS PWOCANADIAN SYLLABICS WEST-CREE PWOCANADIAN SYL" +
	"LABICS PWOOCANADIAN SYLLABICS WEST-CREE PWOOCANADIAN SYLLABICS PWACANADI" +
	"AN SYLLABICS WEST-CREE PWACANADIAN SYLLABICS PWAACANADIAN SYLLABICS WEST" +
	"-CREE PWAACANADIAN SYLLABICS Y-CREE PWAACANADIAN SYLLABICS PCANADIAN SYL" +
	"LABICS WEST-CREE PCANADIAN SYLLABICS CARRIER HCANADIAN SYLLABICS TECANAD" +
	"IAN SYLLABICS TAAICANADIAN SYLLABICS TICANADIAN SYLLABICS TIICANADIAN SY" +
	"LLABICS TOCANADIAN SYLLABICS TOOCANADIAN SYLLABICS Y-CREE TOOCANADIAN SY" +
	"LLABICS CARRIER DEECANADIAN SYLLABICS CARRIER DICANADIAN SYLLABICS TACAN" +
	"ADIAN SYLLABICS TAACANADIAN SYLLABICS TWECANADIAN SYLLABICS WEST-CREE TW" +
	"ECANADIAN SYLLABICS TWICANADIAN SYLLABICS WEST-CREE TWICANADIAN SYLLABIC" +
	"S TWIICANADIAN SYLLABICS WEST-CREE TWIICANADIAN SYLLABICS TWOCANADIAN SY") + ("" +
	"LLABICS WEST-CREE TWOCANADIAN SYLLABICS TWOOCANADIAN SYLLABICS WEST-CREE" +
	" TWOOCANADIAN SYLLABICS TWACANADIAN SYLLABICS WEST-CREE TWACANADIAN SYLL" +
	"ABICS TWAACANADIAN SYLLABICS WEST-CREE TWAACANADIAN SYLLABICS NASKAPI TW" +
	"AACANADIAN SYLLABICS TCANADIAN SYLLABICS TTECANADIAN SYLLABICS TTICANADI" +
	"AN SYLLABICS TTOCANADIAN SYLLABICS TTACANADIAN SYLLABICS KECANADIAN SYLL" +
	"ABICS KAAICANADIAN SYLLABICS KICANADIAN SYLLABICS KIICANADIAN SYLLABICS " +
	"KOCANADIAN SYLLABICS KOOCANADIAN SYLLABICS Y-CREE KOOCANADIAN SYLLABICS " +
	"KACANADIAN SYLLABICS KAACANADIAN SYLLABICS KWECANADIAN SYLLABICS WEST-CR" +
	"EE KWECANADIAN SYLLABICS KWICANADIAN SYLLABICS WEST-CREE KWICANADIAN SYL" +
	"LABICS KWIICANADIAN SYLLABICS WEST-CREE KWIICANADIAN SYLLABICS KWOCANADI" +
	"AN SYLLABICS WEST-CREE KWOCANADIAN SYLLABICS KWOOCANADIAN SYLLABICS WEST" +
	"-CREE KWOOCANADIAN SYLLABICS KWACANADIAN SYLLABICS WEST-CREE KWACANADIAN" +
	" SYLLABICS KWAACANADIAN SYLLABICS WEST-CREE KWAACANADIAN SYLLABICS NASKA" +
	"PI KWAACANADIAN SYLLABICS KCANADIAN SYLLABICS KWCANADIAN SYLLABICS SOUTH" +
	"-SLAVEY KEHCANADIAN SYLLABICS SOUTH-SLAVEY KIHCANADIAN SYLLABICS SOUTH-S" +
	"LAVEY KOHCANADIAN SYLLABICS SOUTH-SLAVEY KAHCANADIAN SYLLABICS CECANADIA" +
	"N SYLLABICS CAAICANADIAN SYLLABICS CICANADIAN SYLLABICS CIICANADIAN SYLL" +
	"ABICS COCANADIAN SYLLABICS COOCANADIAN SYLLABICS Y-CREE COOCANADIAN SYLL" +
	"ABICS CACANADIAN SYLLABICS CAACANADIAN SYLLABICS CWECANADIAN SYLLABICS W" +
	"EST-CREE CWECANADIAN SYLLABICS CWICANADIAN SYLLABICS WEST-CREE CWICANADI" +
	"AN SYLLABICS CWIICANADIAN SYLLABICS WEST-CREE CWIICANADIAN SYLLABICS CWO" +
	"CANADIAN SYLLABICS WEST-CREE CWOCANADIAN SYLLABICS CWOOCANADIAN SYLLABIC" +
	"S WEST-CREE CWOOCANADIAN SYLLABICS CWACANADIAN SYLLABICS WEST-CREE CWACA" +
	"NADIAN SYLLABICS CWAACANADIAN SYLLABICS WEST-CREE CWAACANADIAN SYLLABICS" +
	" NASKAPI CWAACANADIAN SYLLABICS CCANADIAN SYLLABICS SAYISI THCANADIAN SY" +
	"LLABICS MECANADIAN SYLLABICS MAAICANADIAN SYLLABICS MICANADIAN SYLLABICS" +
	" MIICANADIAN SYLLABICS MOCANADIAN SYLLABICS MOOCANADIAN SYLLABICS Y-CREE" +
	" MOOCANADIAN SYLLABICS MACANADIAN SYLLABICS MAACANADIAN SYLLABICS MWECAN" +
	"ADIAN SYLLABICS WEST-CREE MWECANADIAN SYLLABICS MWICANADIAN SYLLABICS WE" +
	"ST-CREE MWICANADIAN SYLLABICS MWIICANADIAN SYLLABICS WEST-CREE MWIICANAD" +
	"IAN SYLLABICS MWOCANADIAN SYLLABICS WEST-CREE MWOCANADIAN SYLLABICS MWOO" +
	"CANADIAN SYLLABICS WEST-CREE MWOOCANADIAN SYLLABICS MWACANADIAN SYLLABIC" +
	"S WEST-CREE MWACANADIAN SYLLABICS MWAACANADIAN SYLLABICS WEST-CREE MWAAC" +
	"ANADIAN SYLLABICS NASKAPI MWAACANADIAN SYLLABICS MCANADIAN SYLLABICS WES" +
	"T-CREE MCANADIAN SYLLABICS MHCANADIAN SYLLABICS ATHAPASCAN MCANADIAN SYL" +
	"LABICS SAYISI MCANADIAN SYLLABICS NECANADIAN SYLLABICS NAAICANADIAN SYLL" +
	"ABICS NICANADIAN SYLLABICS NIICANADIAN SYLLABICS NOCANADIAN SYLLABICS NO" +
	"OCANADIAN SYLLABICS Y-CREE NOOCANADIAN SYLLABICS NACANADIAN SYLLABICS NA" +
	"ACANADIAN SYLLABICS NWECANADIAN SYLLABICS WEST-CREE NWECANADIAN SYLLABIC" +
	"S NWACANADIAN SYLLABICS WEST-CREE NWACANADIAN SYLLABICS NWAACANADIAN SYL" +
	"LABICS WEST-CREE NWAACANADIAN SYLLABICS NASKAPI NWAACANADIAN SYLLABICS N" +
	"CANADIAN SYLLABICS CARRIER NGCANADIAN SYLLABICS NHCANADIAN SYLLABICS LEC" +
	"ANADIAN SYLLABICS LAAICANADIAN SYLLABICS LICANADIAN SYLLABICS LIICANADIA" +
	"N SYLLABICS LOCANADIAN SYLLABICS LOOCANADIAN SYLLABICS Y-CREE LOOCANADIA" +
	"N SYLLABICS LACANADIAN SYLLABICS LAACANADIAN SYLLABICS LWECANADIAN SYLLA" +
	"BICS WEST-CREE LWECANADIAN SYLLABICS LWICANADIAN SYLLABICS WEST-CREE LWI" +
	"CANADIAN SYLLABICS LWIICANADIAN SYLLABICS WEST-CREE LWIICANADIAN SYLLABI" +
	"CS LWOCANADIAN SYLLABICS WEST-CREE LWOCANADIAN SYLLABICS LWOOCANADIAN SY" +
	"LLABICS WEST-CREE LWOOCANADIAN SYLLABICS LWACANADIAN SYLLABICS WEST-CREE" +
	" LWACANADIAN SYLLABICS LWAACANADIAN SYLLABICS WEST-CREE LWAACANADIAN SYL" +
	"LABICS LCANADIAN SYLLABICS WEST-CREE LCANADIAN SYLLABICS MEDIAL LCANADIA" +
	"N SYLLABICS SECANADIAN SYLLABICS SAAICANADIAN SYLLABICS SICANADIAN SYLLA" +
	"BICS SIICANADIAN SYLLABICS SOCANADIAN SYLLABICS SOOCANADIAN SYLLABICS Y-" +
	"CREE SOOCANADIAN SYLLABICS SACANADIAN SYLLABICS SAACANADIAN SYLLABICS SW" +
	"ECANADIAN SYLLABICS WEST-CREE SWECANADIAN SYLLABICS SWICANADIAN SYLLABIC" +
	"S WEST-CREE SWICANADIAN SYLLABICS SWIICANADIAN SYLLABICS WEST-CREE SWIIC" +
	"ANADIAN SYLLABICS SWOCANADIAN SYLLABICS WEST-CREE SWOCANADIAN SYLLABICS " +
	"SWOOCANADIAN SYLLABICS WEST-CREE SWOOCANADIAN SYLLABICS SWACANADIAN SYLL" +
	"ABICS WEST-CREE SWACANADIAN SYLLABICS SWAACANADIAN SYLLABICS WEST-CREE S" +
	"WAACANADIAN SYLLABICS NASKAPI SWAACANADIAN SYLLABICS SCANADIAN SYLLABICS" +
	" ATHAPASCAN SCANADIAN SYLLABICS SWCANADIAN SYLLABICS BLACKFOOT SCANADIAN" +
	" SYLLABICS MOOSE-CREE SKCANADIAN SYLLABICS NASKAPI SKWCANADIAN SYLLABICS" +
	" NASKAPI S-WCANADIAN SYLLABICS NASKAPI SPWACANADIAN SYLLABICS NASKAPI ST" +
	"WACANADIAN SYLLABICS NASKAPI SKWACANADIAN SYLLABICS NASKAPI SCWACANADIAN") + ("" +
	" SYLLABICS SHECANADIAN SYLLABICS SHICANADIAN SYLLABICS SHIICANADIAN SYLL" +
	"ABICS SHOCANADIAN SYLLABICS SHOOCANADIAN SYLLABICS SHACANADIAN SYLLABICS" +
	" SHAACANADIAN SYLLABICS SHWECANADIAN SYLLABICS WEST-CREE SHWECANADIAN SY" +
	"LLABICS SHWICANADIAN SYLLABICS WEST-CREE SHWICANADIAN SYLLABICS SHWIICAN" +
	"ADIAN SYLLABICS WEST-CREE SHWIICANADIAN SYLLABICS SHWOCANADIAN SYLLABICS" +
	" WEST-CREE SHWOCANADIAN SYLLABICS SHWOOCANADIAN SYLLABICS WEST-CREE SHWO" +
	"OCANADIAN SYLLABICS SHWACANADIAN SYLLABICS WEST-CREE SHWACANADIAN SYLLAB" +
	"ICS SHWAACANADIAN SYLLABICS WEST-CREE SHWAACANADIAN SYLLABICS SHCANADIAN" +
	" SYLLABICS YECANADIAN SYLLABICS YAAICANADIAN SYLLABICS YICANADIAN SYLLAB" +
	"ICS YIICANADIAN SYLLABICS YOCANADIAN SYLLABICS YOOCANADIAN SYLLABICS Y-C" +
	"REE YOOCANADIAN SYLLABICS YACANADIAN SYLLABICS YAACANADIAN SYLLABICS YWE" +
	"CANADIAN SYLLABICS WEST-CREE YWECANADIAN SYLLABICS YWICANADIAN SYLLABICS" +
	" WEST-CREE YWICANADIAN SYLLABICS YWIICANADIAN SYLLABICS WEST-CREE YWIICA" +
	"NADIAN SYLLABICS YWOCANADIAN SYLLABICS WEST-CREE YWOCANADIAN SYLLABICS Y" +
	"WOOCANADIAN SYLLABICS WEST-CREE YWOOCANADIAN SYLLABICS YWACANADIAN SYLLA" +
	"BICS WEST-CREE YWACANADIAN SYLLABICS YWAACANADIAN SYLLABICS WEST-CREE YW" +
	"AACANADIAN SYLLABICS NASKAPI YWAACANADIAN SYLLABICS YCANADIAN SYLLABICS " +
	"BIBLE-CREE YCANADIAN SYLLABICS WEST-CREE YCANADIAN SYLLABICS SAYISI YICA" +
	"NADIAN SYLLABICS RECANADIAN SYLLABICS R-CREE RECANADIAN SYLLABICS WEST-C" +
	"REE LECANADIAN SYLLABICS RAAICANADIAN SYLLABICS RICANADIAN SYLLABICS RII" +
	"CANADIAN SYLLABICS ROCANADIAN SYLLABICS ROOCANADIAN SYLLABICS WEST-CREE " +
	"LOCANADIAN SYLLABICS RACANADIAN SYLLABICS RAACANADIAN SYLLABICS WEST-CRE" +
	"E LACANADIAN SYLLABICS RWAACANADIAN SYLLABICS WEST-CREE RWAACANADIAN SYL" +
	"LABICS RCANADIAN SYLLABICS WEST-CREE RCANADIAN SYLLABICS MEDIAL RCANADIA" +
	"N SYLLABICS FECANADIAN SYLLABICS FAAICANADIAN SYLLABICS FICANADIAN SYLLA" +
	"BICS FIICANADIAN SYLLABICS FOCANADIAN SYLLABICS FOOCANADIAN SYLLABICS FA" +
	"CANADIAN SYLLABICS FAACANADIAN SYLLABICS FWAACANADIAN SYLLABICS WEST-CRE" +
	"E FWAACANADIAN SYLLABICS FCANADIAN SYLLABICS THECANADIAN SYLLABICS N-CRE" +
	"E THECANADIAN SYLLABICS THICANADIAN SYLLABICS N-CREE THICANADIAN SYLLABI" +
	"CS THIICANADIAN SYLLABICS N-CREE THIICANADIAN SYLLABICS THOCANADIAN SYLL" +
	"ABICS THOOCANADIAN SYLLABICS THACANADIAN SYLLABICS THAACANADIAN SYLLABIC" +
	"S THWAACANADIAN SYLLABICS WEST-CREE THWAACANADIAN SYLLABICS THCANADIAN S" +
	"YLLABICS TTHECANADIAN SYLLABICS TTHICANADIAN SYLLABICS TTHOCANADIAN SYLL" +
	"ABICS TTHACANADIAN SYLLABICS TTHCANADIAN SYLLABICS TYECANADIAN SYLLABICS" +
	" TYICANADIAN SYLLABICS TYOCANADIAN SYLLABICS TYACANADIAN SYLLABICS NUNAV" +
	"IK HECANADIAN SYLLABICS NUNAVIK HICANADIAN SYLLABICS NUNAVIK HIICANADIAN" +
	" SYLLABICS NUNAVIK HOCANADIAN SYLLABICS NUNAVIK HOOCANADIAN SYLLABICS NU" +
	"NAVIK HACANADIAN SYLLABICS NUNAVIK HAACANADIAN SYLLABICS NUNAVIK HCANADI" +
	"AN SYLLABICS NUNAVUT HCANADIAN SYLLABICS HKCANADIAN SYLLABICS QAAICANADI" +
	"AN SYLLABICS QICANADIAN SYLLABICS QIICANADIAN SYLLABICS QOCANADIAN SYLLA" +
	"BICS QOOCANADIAN SYLLABICS QACANADIAN SYLLABICS QAACANADIAN SYLLABICS QC" +
	"ANADIAN SYLLABICS TLHECANADIAN SYLLABICS TLHICANADIAN SYLLABICS TLHOCANA" +
	"DIAN SYLLABICS TLHACANADIAN SYLLABICS WEST-CREE RECANADIAN SYLLABICS WES" +
	"T-CREE RICANADIAN SYLLABICS WEST-CREE ROCANADIAN SYLLABICS WEST-CREE RAC" +
	"ANADIAN SYLLABICS NGAAICANADIAN SYLLABICS NGICANADIAN SYLLABICS NGIICANA" +
	"DIAN SYLLABICS NGOCANADIAN SYLLABICS NGOOCANADIAN SYLLABICS NGACANADIAN " +
	"SYLLABICS NGAACANADIAN SYLLABICS NGCANADIAN SYLLABICS NNGCANADIAN SYLLAB" +
	"ICS SAYISI SHECANADIAN SYLLABICS SAYISI SHICANADIAN SYLLABICS SAYISI SHO" +
	"CANADIAN SYLLABICS SAYISI SHACANADIAN SYLLABICS WOODS-CREE THECANADIAN S" +
	"YLLABICS WOODS-CREE THICANADIAN SYLLABICS WOODS-CREE THOCANADIAN SYLLABI" +
	"CS WOODS-CREE THACANADIAN SYLLABICS WOODS-CREE THCANADIAN SYLLABICS LHIC" +
	"ANADIAN SYLLABICS LHIICANADIAN SYLLABICS LHOCANADIAN SYLLABICS LHOOCANAD" +
	"IAN SYLLABICS LHACANADIAN SYLLABICS LHAACANADIAN SYLLABICS LHCANADIAN SY" +
	"LLABICS TH-CREE THECANADIAN SYLLABICS TH-CREE THICANADIAN SYLLABICS TH-C" +
	"REE THIICANADIAN SYLLABICS TH-CREE THOCANADIAN SYLLABICS TH-CREE THOOCAN" +
	"ADIAN SYLLABICS TH-CREE THACANADIAN SYLLABICS TH-CREE THAACANADIAN SYLLA" +
	"BICS TH-CREE THCANADIAN SYLLABICS AIVILIK BCANADIAN SYLLABICS BLACKFOOT " +
	"ECANADIAN SYLLABICS BLACKFOOT ICANADIAN SYLLABICS BLACKFOOT OCANADIAN SY" +
	"LLABICS BLACKFOOT ACANADIAN SYLLABICS BLACKFOOT WECANADIAN SYLLABICS BLA" +
	"CKFOOT WICANADIAN SYLLABICS BLACKFOOT WOCANADIAN SYLLABICS BLACKFOOT WAC" +
	"ANADIAN SYLLABICS BLACKFOOT NECANADIAN SYLLABICS BLACKFOOT NICANADIAN SY" +
	"LLABICS BLACKFOOT NOCANADIAN SYLLABICS BLACKFOOT NACANADIAN SYLLABICS BL" +
	"ACKFOOT KECANADIAN SYLLABICS BLACKFOOT KICANADIAN SYLLABICS BLACKFOOT KO" +
	"CANADIAN SYLLABICS BLACKFOOT KACANADIAN SYLLABICS SAYISI HECANADIAN SYLL") + ("" +
	"ABICS SAYISI HICANADIAN SYLLABICS SAYISI HOCANADIAN SYLLABICS SAYISI HAC" +
	"ANADIAN SYLLABICS CARRIER GHUCANADIAN SYLLABICS CARRIER GHOCANADIAN SYLL" +
	"ABICS CARRIER GHECANADIAN SYLLABICS CARRIER GHEECANADIAN SYLLABICS CARRI" +
	"ER GHICANADIAN SYLLABICS CARRIER GHACANADIAN SYLLABICS CARRIER RUCANADIA" +
	"N SYLLABICS CARRIER ROCANADIAN SYLLABICS CARRIER RECANADIAN SYLLABICS CA" +
	"RRIER REECANADIAN SYLLABICS CARRIER RICANADIAN SYLLABICS CARRIER RACANAD" +
	"IAN SYLLABICS CARRIER WUCANADIAN SYLLABICS CARRIER WOCANADIAN SYLLABICS " +
	"CARRIER WECANADIAN SYLLABICS CARRIER WEECANADIAN SYLLABICS CARRIER WICAN" +
	"ADIAN SYLLABICS CARRIER WACANADIAN SYLLABICS CARRIER HWUCANADIAN SYLLABI" +
	"CS CARRIER HWOCANADIAN SYLLABICS CARRIER HWECANADIAN SYLLABICS CARRIER H" +
	"WEECANADIAN SYLLABICS CARRIER HWICANADIAN SYLLABICS CARRIER HWACANADIAN " +
	"SYLLABICS CARRIER THUCANADIAN SYLLABICS CARRIER THOCANADIAN SYLLABICS CA" +
	"RRIER THECANADIAN SYLLABICS CARRIER THEECANADIAN SYLLABICS CARRIER THICA" +
	"NADIAN SYLLABICS CARRIER THACANADIAN SYLLABICS CARRIER TTUCANADIAN SYLLA" +
	"BICS CARRIER TTOCANADIAN SYLLABICS CARRIER TTECANADIAN SYLLABICS CARRIER" +
	" TTEECANADIAN SYLLABICS CARRIER TTICANADIAN SYLLABICS CARRIER TTACANADIA" +
	"N SYLLABICS CARRIER PUCANADIAN SYLLABICS CARRIER POCANADIAN SYLLABICS CA" +
	"RRIER PECANADIAN SYLLABICS CARRIER PEECANADIAN SYLLABICS CARRIER PICANAD" +
	"IAN SYLLABICS CARRIER PACANADIAN SYLLABICS CARRIER PCANADIAN SYLLABICS C" +
	"ARRIER GUCANADIAN SYLLABICS CARRIER GOCANADIAN SYLLABICS CARRIER GECANAD" +
	"IAN SYLLABICS CARRIER GEECANADIAN SYLLABICS CARRIER GICANADIAN SYLLABICS" +
	" CARRIER GACANADIAN SYLLABICS CARRIER KHUCANADIAN SYLLABICS CARRIER KHOC" +
	"ANADIAN SYLLABICS CARRIER KHECANADIAN SYLLABICS CARRIER KHEECANADIAN SYL" +
	"LABICS CARRIER KHICANADIAN SYLLABICS CARRIER KHACANADIAN SYLLABICS CARRI" +
	"ER KKUCANADIAN SYLLABICS CARRIER KKOCANADIAN SYLLABICS CARRIER KKECANADI" +
	"AN SYLLABICS CARRIER KKEECANADIAN SYLLABICS CARRIER KKICANADIAN SYLLABIC" +
	"S CARRIER KKACANADIAN SYLLABICS CARRIER KKCANADIAN SYLLABICS CARRIER NUC" +
	"ANADIAN SYLLABICS CARRIER NOCANADIAN SYLLABICS CARRIER NECANADIAN SYLLAB" +
	"ICS CARRIER NEECANADIAN SYLLABICS CARRIER NICANADIAN SYLLABICS CARRIER N" +
	"ACANADIAN SYLLABICS CARRIER MUCANADIAN SYLLABICS CARRIER MOCANADIAN SYLL" +
	"ABICS CARRIER MECANADIAN SYLLABICS CARRIER MEECANADIAN SYLLABICS CARRIER" +
	" MICANADIAN SYLLABICS CARRIER MACANADIAN SYLLABICS CARRIER YUCANADIAN SY" +
	"LLABICS CARRIER YOCANADIAN SYLLABICS CARRIER YECANADIAN SYLLABICS CARRIE" +
	"R YEECANADIAN SYLLABICS CARRIER YICANADIAN SYLLABICS CARRIER YACANADIAN " +
	"SYLLABICS CARRIER JUCANADIAN SYLLABICS SAYISI JUCANADIAN SYLLABICS CARRI" +
	"ER JOCANADIAN SYLLABICS CARRIER JECANADIAN SYLLABICS CARRIER JEECANADIAN" +
	" SYLLABICS CARRIER JICANADIAN SYLLABICS SAYISI JICANADIAN SYLLABICS CARR" +
	"IER JACANADIAN SYLLABICS CARRIER JJUCANADIAN SYLLABICS CARRIER JJOCANADI" +
	"AN SYLLABICS CARRIER JJECANADIAN SYLLABICS CARRIER JJEECANADIAN SYLLABIC" +
	"S CARRIER JJICANADIAN SYLLABICS CARRIER JJACANADIAN SYLLABICS CARRIER LU" +
	"CANADIAN SYLLABICS CARRIER LOCANADIAN SYLLABICS CARRIER LECANADIAN SYLLA" +
	"BICS CARRIER LEECANADIAN SYLLABICS CARRIER LICANADIAN SYLLABICS CARRIER " +
	"LACANADIAN SYLLABICS CARRIER DLUCANADIAN SYLLABICS CARRIER DLOCANADIAN S" +
	"YLLABICS CARRIER DLECANADIAN SYLLABICS CARRIER DLEECANADIAN SYLLABICS CA" +
	"RRIER DLICANADIAN SYLLABICS CARRIER DLACANADIAN SYLLABICS CARRIER LHUCAN" +
	"ADIAN SYLLABICS CARRIER LHOCANADIAN SYLLABICS CARRIER LHECANADIAN SYLLAB" +
	"ICS CARRIER LHEECANADIAN SYLLABICS CARRIER LHICANADIAN SYLLABICS CARRIER" +
	" LHACANADIAN SYLLABICS CARRIER TLHUCANADIAN SYLLABICS CARRIER TLHOCANADI" +
	"AN SYLLABICS CARRIER TLHECANADIAN SYLLABICS CARRIER TLHEECANADIAN SYLLAB" +
	"ICS CARRIER TLHICANADIAN SYLLABICS CARRIER TLHACANADIAN SYLLABICS CARRIE" +
	"R TLUCANADIAN SYLLABICS CARRIER TLOCANADIAN SYLLABICS CARRIER TLECANADIA" +
	"N SYLLABICS CARRIER TLEECANADIAN SYLLABICS CARRIER TLICANADIAN SYLLABICS" +
	" CARRIER TLACANADIAN SYLLABICS CARRIER ZUCANADIAN SYLLABICS CARRIER ZOCA" +
	"NADIAN SYLLABICS CARRIER ZECANADIAN SYLLABICS CARRIER ZEECANADIAN SYLLAB" +
	"ICS CARRIER ZICANADIAN SYLLABICS CARRIER ZACANADIAN SYLLABICS CARRIER ZC" +
	"ANADIAN SYLLABICS CARRIER INITIAL ZCANADIAN SYLLABICS CARRIER DZUCANADIA" +
	"N SYLLABICS CARRIER DZOCANADIAN SYLLABICS CARRIER DZECANADIAN SYLLABICS " +
	"CARRIER DZEECANADIAN SYLLABICS CARRIER DZICANADIAN SYLLABICS CARRIER DZA" +
	"CANADIAN SYLLABICS CARRIER SUCANADIAN SYLLABICS CARRIER SOCANADIAN SYLLA" +
	"BICS CARRIER SECANADIAN SYLLABICS CARRIER SEECANADIAN SYLLABICS CARRIER " +
	"SICANADIAN SYLLABICS CARRIER SACANADIAN SYLLABICS CARRIER SHUCANADIAN SY" +
	"LLABICS CARRIER SHOCANADIAN SYLLABICS CARRIER SHECANADIAN SYLLABICS CARR" +
	"IER SHEECANADIAN SYLLABICS CARRIER SHICANADIAN SYLLABICS CARRIER SHACANA" +
	"DIAN SYLLABICS CARRIER SHCANADIAN SYLLABICS CARRIER TSUCANADIAN SYLLABIC") + ("" +
	"S CARRIER TSOCANADIAN SYLLABICS CARRIER TSECANADIAN SYLLABICS CARRIER TS" +
	"EECANADIAN SYLLABICS CARRIER TSICANADIAN SYLLABICS CARRIER TSACANADIAN S" +
	"YLLABICS CARRIER CHUCANADIAN SYLLABICS CARRIER CHOCANADIAN SYLLABICS CAR" +
	"RIER CHECANADIAN SYLLABICS CARRIER CHEECANADIAN SYLLABICS CARRIER CHICAN" +
	"ADIAN SYLLABICS CARRIER CHACANADIAN SYLLABICS CARRIER TTSUCANADIAN SYLLA" +
	"BICS CARRIER TTSOCANADIAN SYLLABICS CARRIER TTSECANADIAN SYLLABICS CARRI" +
	"ER TTSEECANADIAN SYLLABICS CARRIER TTSICANADIAN SYLLABICS CARRIER TTSACA" +
	"NADIAN SYLLABICS CHI SIGNCANADIAN SYLLABICS FULL STOPCANADIAN SYLLABICS " +
	"QAICANADIAN SYLLABICS NGAICANADIAN SYLLABICS NNGICANADIAN SYLLABICS NNGI" +
	"ICANADIAN SYLLABICS NNGOCANADIAN SYLLABICS NNGOOCANADIAN SYLLABICS NNGAC" +
	"ANADIAN SYLLABICS NNGAACANADIAN SYLLABICS WOODS-CREE THWEECANADIAN SYLLA" +
	"BICS WOODS-CREE THWICANADIAN SYLLABICS WOODS-CREE THWIICANADIAN SYLLABIC" +
	"S WOODS-CREE THWOCANADIAN SYLLABICS WOODS-CREE THWOOCANADIAN SYLLABICS W" +
	"OODS-CREE THWACANADIAN SYLLABICS WOODS-CREE THWAACANADIAN SYLLABICS WOOD" +
	"S-CREE FINAL THCANADIAN SYLLABICS BLACKFOOT WOGHAM SPACE MARKOGHAM LETTE" +
	"R BEITHOGHAM LETTER LUISOGHAM LETTER FEARNOGHAM LETTER SAILOGHAM LETTER " +
	"NIONOGHAM LETTER UATHOGHAM LETTER DAIROGHAM LETTER TINNEOGHAM LETTER COL" +
	"LOGHAM LETTER CEIRTOGHAM LETTER MUINOGHAM LETTER GORTOGHAM LETTER NGEADA" +
	"LOGHAM LETTER STRAIFOGHAM LETTER RUISOGHAM LETTER AILMOGHAM LETTER ONNOG" +
	"HAM LETTER UROGHAM LETTER EADHADHOGHAM LETTER IODHADHOGHAM LETTER EABHAD" +
	"HOGHAM LETTER OROGHAM LETTER UILLEANNOGHAM LETTER IFINOGHAM LETTER EAMHA" +
	"NCHOLLOGHAM LETTER PEITHOGHAM FEATHER MARKOGHAM REVERSED FEATHER MARKRUN" +
	"IC LETTER FEHU FEOH FE FRUNIC LETTER VRUNIC LETTER URUZ UR URUNIC LETTER" +
	" YRRUNIC LETTER YRUNIC LETTER WRUNIC LETTER THURISAZ THURS THORNRUNIC LE" +
	"TTER ETHRUNIC LETTER ANSUZ ARUNIC LETTER OS ORUNIC LETTER AC ARUNIC LETT" +
	"ER AESCRUNIC LETTER LONG-BRANCH-OSS ORUNIC LETTER SHORT-TWIG-OSS ORUNIC " +
	"LETTER ORUNIC LETTER OERUNIC LETTER ONRUNIC LETTER RAIDO RAD REID RRUNIC" +
	" LETTER KAUNARUNIC LETTER CENRUNIC LETTER KAUN KRUNIC LETTER GRUNIC LETT" +
	"ER ENGRUNIC LETTER GEBO GYFU GRUNIC LETTER GARRUNIC LETTER WUNJO WYNN WR" +
	"UNIC LETTER HAGLAZ HRUNIC LETTER HAEGL HRUNIC LETTER LONG-BRANCH-HAGALL " +
	"HRUNIC LETTER SHORT-TWIG-HAGALL HRUNIC LETTER NAUDIZ NYD NAUD NRUNIC LET" +
	"TER SHORT-TWIG-NAUD NRUNIC LETTER DOTTED-NRUNIC LETTER ISAZ IS ISS IRUNI" +
	"C LETTER ERUNIC LETTER JERAN JRUNIC LETTER GERRUNIC LETTER LONG-BRANCH-A" +
	"R AERUNIC LETTER SHORT-TWIG-AR ARUNIC LETTER IWAZ EOHRUNIC LETTER PERTHO" +
	" PEORTH PRUNIC LETTER ALGIZ EOLHXRUNIC LETTER SOWILO SRUNIC LETTER SIGEL" +
	" LONG-BRANCH-SOL SRUNIC LETTER SHORT-TWIG-SOL SRUNIC LETTER CRUNIC LETTE" +
	"R ZRUNIC LETTER TIWAZ TIR TYR TRUNIC LETTER SHORT-TWIG-TYR TRUNIC LETTER" +
	" DRUNIC LETTER BERKANAN BEORC BJARKAN BRUNIC LETTER SHORT-TWIG-BJARKAN B" +
	"RUNIC LETTER DOTTED-PRUNIC LETTER OPEN-PRUNIC LETTER EHWAZ EH ERUNIC LET" +
	"TER MANNAZ MAN MRUNIC LETTER LONG-BRANCH-MADR MRUNIC LETTER SHORT-TWIG-M" +
	"ADR MRUNIC LETTER LAUKAZ LAGU LOGR LRUNIC LETTER DOTTED-LRUNIC LETTER IN" +
	"GWAZRUNIC LETTER INGRUNIC LETTER DAGAZ DAEG DRUNIC LETTER OTHALAN ETHEL " +
	"ORUNIC LETTER EARRUNIC LETTER IORRUNIC LETTER CWEORTHRUNIC LETTER CALCRU" +
	"NIC LETTER CEALCRUNIC LETTER STANRUNIC LETTER LONG-BRANCH-YRRUNIC LETTER" +
	" SHORT-TWIG-YRRUNIC LETTER ICELANDIC-YRRUNIC LETTER QRUNIC LETTER XRUNIC" +
	" SINGLE PUNCTUATIONRUNIC MULTIPLE PUNCTUATIONRUNIC CROSS PUNCTUATIONRUNI" +
	"C ARLAUG SYMBOLRUNIC TVIMADUR SYMBOLRUNIC BELGTHOR SYMBOLRUNIC LETTER KR" +
	"UNIC LETTER SHRUNIC LETTER OORUNIC LETTER FRANKS CASKET OSRUNIC LETTER F" +
	"RANKS CASKET ISRUNIC LETTER FRANKS CASKET EHRUNIC LETTER FRANKS CASKET A" +
	"CRUNIC LETTER FRANKS CASKET AESCTAGALOG LETTER ATAGALOG LETTER ITAGALOG " +
	"LETTER UTAGALOG LETTER KATAGALOG LETTER GATAGALOG LETTER NGATAGALOG LETT" +
	"ER TATAGALOG LETTER DATAGALOG LETTER NATAGALOG LETTER PATAGALOG LETTER B" +
	"ATAGALOG LETTER MATAGALOG LETTER YATAGALOG LETTER RATAGALOG LETTER LATAG" +
	"ALOG LETTER WATAGALOG LETTER SATAGALOG LETTER HATAGALOG VOWEL SIGN ITAGA" +
	"LOG VOWEL SIGN UTAGALOG SIGN VIRAMATAGALOG SIGN PAMUDPODTAGALOG LETTER A" +
	"RCHAIC RAHANUNOO LETTER AHANUNOO LETTER IHANUNOO LETTER UHANUNOO LETTER " +
	"KAHANUNOO LETTER GAHANUNOO LETTER NGAHANUNOO LETTER TAHANUNOO LETTER DAH" +
	"ANUNOO LETTER NAHANUNOO LETTER PAHANUNOO LETTER BAHANUNOO LETTER MAHANUN" +
	"OO LETTER YAHANUNOO LETTER RAHANUNOO LETTER LAHANUNOO LETTER WAHANUNOO L" +
	"ETTER SAHANUNOO LETTER HAHANUNOO VOWEL SIGN IHANUNOO VOWEL SIGN UHANUNOO" +
	" SIGN PAMUDPODPHILIPPINE SINGLE PUNCTUATIONPHILIPPINE DOUBLE PUNCTUATION" +
	"BUHID LETTER ABUHID LETTER IBUHID LETTER UBUHID LETTER KABUHID LETTER GA" +
	"BUHID LETTER NGABUHID LETTER TABUHID LETTER DABUHID LETTER NABUHID LETTE" +
	"R PABUHID LETTER BABUHID LETTER MABUHID LETTER YABUHID LETTER RABUHID LE") + ("" +
	"TTER LABUHID LETTER WABUHID LETTER SABUHID LETTER HABUHID VOWEL SIGN IBU" +
	"HID VOWEL SIGN UTAGBANWA LETTER ATAGBANWA LETTER ITAGBANWA LETTER UTAGBA" +
	"NWA LETTER KATAGBANWA LETTER GATAGBANWA LETTER NGATAGBANWA LETTER TATAGB" +
	"ANWA LETTER DATAGBANWA LETTER NATAGBANWA LETTER PATAGBANWA LETTER BATAGB" +
	"ANWA LETTER MATAGBANWA LETTER YATAGBANWA LETTER LATAGBANWA LETTER WATAGB" +
	"ANWA LETTER SATAGBANWA VOWEL SIGN ITAGBANWA VOWEL SIGN UKHMER LETTER KAK" +
	"HMER LETTER KHAKHMER LETTER KOKHMER LETTER KHOKHMER LETTER NGOKHMER LETT" +
	"ER CAKHMER LETTER CHAKHMER LETTER COKHMER LETTER CHOKHMER LETTER NYOKHME" +
	"R LETTER DAKHMER LETTER TTHAKHMER LETTER DOKHMER LETTER TTHOKHMER LETTER" +
	" NNOKHMER LETTER TAKHMER LETTER THAKHMER LETTER TOKHMER LETTER THOKHMER " +
	"LETTER NOKHMER LETTER BAKHMER LETTER PHAKHMER LETTER POKHMER LETTER PHOK" +
	"HMER LETTER MOKHMER LETTER YOKHMER LETTER ROKHMER LETTER LOKHMER LETTER " +
	"VOKHMER LETTER SHAKHMER LETTER SSOKHMER LETTER SAKHMER LETTER HAKHMER LE" +
	"TTER LAKHMER LETTER QAKHMER INDEPENDENT VOWEL QAQKHMER INDEPENDENT VOWEL" +
	" QAAKHMER INDEPENDENT VOWEL QIKHMER INDEPENDENT VOWEL QIIKHMER INDEPENDE" +
	"NT VOWEL QUKHMER INDEPENDENT VOWEL QUKKHMER INDEPENDENT VOWEL QUUKHMER I" +
	"NDEPENDENT VOWEL QUUVKHMER INDEPENDENT VOWEL RYKHMER INDEPENDENT VOWEL R" +
	"YYKHMER INDEPENDENT VOWEL LYKHMER INDEPENDENT VOWEL LYYKHMER INDEPENDENT" +
	" VOWEL QEKHMER INDEPENDENT VOWEL QAIKHMER INDEPENDENT VOWEL QOO TYPE ONE" +
	"KHMER INDEPENDENT VOWEL QOO TYPE TWOKHMER INDEPENDENT VOWEL QAUKHMER VOW" +
	"EL INHERENT AQKHMER VOWEL INHERENT AAKHMER VOWEL SIGN AAKHMER VOWEL SIGN" +
	" IKHMER VOWEL SIGN IIKHMER VOWEL SIGN YKHMER VOWEL SIGN YYKHMER VOWEL SI" +
	"GN UKHMER VOWEL SIGN UUKHMER VOWEL SIGN UAKHMER VOWEL SIGN OEKHMER VOWEL" +
	" SIGN YAKHMER VOWEL SIGN IEKHMER VOWEL SIGN EKHMER VOWEL SIGN AEKHMER VO" +
	"WEL SIGN AIKHMER VOWEL SIGN OOKHMER VOWEL SIGN AUKHMER SIGN NIKAHITKHMER" +
	" SIGN REAHMUKKHMER SIGN YUUKALEAPINTUKHMER SIGN MUUSIKATOANKHMER SIGN TR" +
	"IISAPKHMER SIGN BANTOCKHMER SIGN ROBATKHMER SIGN TOANDAKHIATKHMER SIGN K" +
	"AKABATKHMER SIGN AHSDAKHMER SIGN SAMYOK SANNYAKHMER SIGN VIRIAMKHMER SIG" +
	"N COENGKHMER SIGN BATHAMASATKHMER SIGN KHANKHMER SIGN BARIYOOSANKHMER SI" +
	"GN CAMNUC PII KUUHKHMER SIGN LEK TOOKHMER SIGN BEYYALKHMER SIGN PHNAEK M" +
	"UANKHMER SIGN KOOMUUTKHMER CURRENCY SYMBOL RIELKHMER SIGN AVAKRAHASANYAK" +
	"HMER SIGN ATTHACANKHMER DIGIT ZEROKHMER DIGIT ONEKHMER DIGIT TWOKHMER DI" +
	"GIT THREEKHMER DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT SIXKHMER DIGIT SEVE" +
	"NKHMER DIGIT EIGHTKHMER DIGIT NINEKHMER SYMBOL LEK ATTAK SONKHMER SYMBOL" +
	" LEK ATTAK MUOYKHMER SYMBOL LEK ATTAK PIIKHMER SYMBOL LEK ATTAK BEIKHMER" +
	" SYMBOL LEK ATTAK BUONKHMER SYMBOL LEK ATTAK PRAMKHMER SYMBOL LEK ATTAK " +
	"PRAM-MUOYKHMER SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL LEK ATTAK PRAM-BEIK" +
	"HMER SYMBOL LEK ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOLIAN ELLIPSISMONGOLIA" +
	"N COMMAMONGOLIAN FULL STOPMONGOLIAN COLONMONGOLIAN FOUR DOTSMONGOLIAN TO" +
	"DO SOFT HYPHENMONGOLIAN SIBE SYLLABLE BOUNDARY MARKERMONGOLIAN MANCHU CO" +
	"MMAMONGOLIAN MANCHU FULL STOPMONGOLIAN NIRUGUMONGOLIAN FREE VARIATION SE" +
	"LECTOR ONEMONGOLIAN FREE VARIATION SELECTOR TWOMONGOLIAN FREE VARIATION " +
	"SELECTOR THREEMONGOLIAN VOWEL SEPARATORMONGOLIAN FREE VARIATION SELECTOR" +
	" FOURMONGOLIAN DIGIT ZEROMONGOLIAN DIGIT ONEMONGOLIAN DIGIT TWOMONGOLIAN" +
	" DIGIT THREEMONGOLIAN DIGIT FOURMONGOLIAN DIGIT FIVEMONGOLIAN DIGIT SIXM" +
	"ONGOLIAN DIGIT SEVENMONGOLIAN DIGIT EIGHTMONGOLIAN DIGIT NINEMONGOLIAN L" +
	"ETTER AMONGOLIAN LETTER EMONGOLIAN LETTER IMONGOLIAN LETTER OMONGOLIAN L" +
	"ETTER UMONGOLIAN LETTER OEMONGOLIAN LETTER UEMONGOLIAN LETTER EEMONGOLIA" +
	"N LETTER NAMONGOLIAN LETTER ANGMONGOLIAN LETTER BAMONGOLIAN LETTER PAMON" +
	"GOLIAN LETTER QAMONGOLIAN LETTER GAMONGOLIAN LETTER MAMONGOLIAN LETTER L" +
	"AMONGOLIAN LETTER SAMONGOLIAN LETTER SHAMONGOLIAN LETTER TAMONGOLIAN LET" +
	"TER DAMONGOLIAN LETTER CHAMONGOLIAN LETTER JAMONGOLIAN LETTER YAMONGOLIA" +
	"N LETTER RAMONGOLIAN LETTER WAMONGOLIAN LETTER FAMONGOLIAN LETTER KAMONG" +
	"OLIAN LETTER KHAMONGOLIAN LETTER TSAMONGOLIAN LETTER ZAMONGOLIAN LETTER " +
	"HAAMONGOLIAN LETTER ZRAMONGOLIAN LETTER LHAMONGOLIAN LETTER ZHIMONGOLIAN" +
	" LETTER CHIMONGOLIAN LETTER TODO LONG VOWEL SIGNMONGOLIAN LETTER TODO EM" +
	"ONGOLIAN LETTER TODO IMONGOLIAN LETTER TODO OMONGOLIAN LETTER TODO UMONG" +
	"OLIAN LETTER TODO OEMONGOLIAN LETTER TODO UEMONGOLIAN LETTER TODO ANGMON" +
	"GOLIAN LETTER TODO BAMONGOLIAN LETTER TODO PAMONGOLIAN LETTER TODO QAMON" +
	"GOLIAN LETTER TODO GAMONGOLIAN LETTER TODO MAMONGOLIAN LETTER TODO TAMON" +
	"GOLIAN LETTER TODO DAMONGOLIAN LETTER TODO CHAMONGOLIAN LETTER TODO JAMO" +
	"NGOLIAN LETTER TODO TSAMONGOLIAN LETTER TODO YAMONGOLIAN LETTER TODO WAM" +
	"ONGOLIAN LETTER TODO KAMONGOLIAN LETTER TODO GAAMONGOLIAN LETTER TODO HA" +
	"AMONGOLIAN LETTER TODO JIAMONGOLIAN LETTER TODO NIAMONGOLIAN LETTER TODO") + ("" +
	" DZAMONGOLIAN LETTER SIBE EMONGOLIAN LETTER SIBE IMONGOLIAN LETTER SIBE " +
	"IYMONGOLIAN LETTER SIBE UEMONGOLIAN LETTER SIBE UMONGOLIAN LETTER SIBE A" +
	"NGMONGOLIAN LETTER SIBE KAMONGOLIAN LETTER SIBE GAMONGOLIAN LETTER SIBE " +
	"HAMONGOLIAN LETTER SIBE PAMONGOLIAN LETTER SIBE SHAMONGOLIAN LETTER SIBE" +
	" TAMONGOLIAN LETTER SIBE DAMONGOLIAN LETTER SIBE JAMONGOLIAN LETTER SIBE" +
	" FAMONGOLIAN LETTER SIBE GAAMONGOLIAN LETTER SIBE HAAMONGOLIAN LETTER SI" +
	"BE TSAMONGOLIAN LETTER SIBE ZAMONGOLIAN LETTER SIBE RAAMONGOLIAN LETTER " +
	"SIBE CHAMONGOLIAN LETTER SIBE ZHAMONGOLIAN LETTER MANCHU IMONGOLIAN LETT" +
	"ER MANCHU KAMONGOLIAN LETTER MANCHU RAMONGOLIAN LETTER MANCHU FAMONGOLIA" +
	"N LETTER MANCHU ZHAMONGOLIAN LETTER CHA WITH TWO DOTSMONGOLIAN LETTER AL" +
	"I GALI ANUSVARA ONEMONGOLIAN LETTER ALI GALI VISARGA ONEMONGOLIAN LETTER" +
	" ALI GALI DAMARUMONGOLIAN LETTER ALI GALI UBADAMAMONGOLIAN LETTER ALI GA" +
	"LI INVERTED UBADAMAMONGOLIAN LETTER ALI GALI BALUDAMONGOLIAN LETTER ALI " +
	"GALI THREE BALUDAMONGOLIAN LETTER ALI GALI AMONGOLIAN LETTER ALI GALI IM" +
	"ONGOLIAN LETTER ALI GALI KAMONGOLIAN LETTER ALI GALI NGAMONGOLIAN LETTER" +
	" ALI GALI CAMONGOLIAN LETTER ALI GALI TTAMONGOLIAN LETTER ALI GALI TTHAM" +
	"ONGOLIAN LETTER ALI GALI DDAMONGOLIAN LETTER ALI GALI NNAMONGOLIAN LETTE" +
	"R ALI GALI TAMONGOLIAN LETTER ALI GALI DAMONGOLIAN LETTER ALI GALI PAMON" +
	"GOLIAN LETTER ALI GALI PHAMONGOLIAN LETTER ALI GALI SSAMONGOLIAN LETTER " +
	"ALI GALI ZHAMONGOLIAN LETTER ALI GALI ZAMONGOLIAN LETTER ALI GALI AHMONG" +
	"OLIAN LETTER TODO ALI GALI TAMONGOLIAN LETTER TODO ALI GALI ZHAMONGOLIAN" +
	" LETTER MANCHU ALI GALI GHAMONGOLIAN LETTER MANCHU ALI GALI NGAMONGOLIAN" +
	" LETTER MANCHU ALI GALI CAMONGOLIAN LETTER MANCHU ALI GALI JHAMONGOLIAN " +
	"LETTER MANCHU ALI GALI TTAMONGOLIAN LETTER MANCHU ALI GALI DDHAMONGOLIAN" +
	" LETTER MANCHU ALI GALI TAMONGOLIAN LETTER MANCHU ALI GALI DHAMONGOLIAN " +
	"LETTER MANCHU ALI GALI SSAMONGOLIAN LETTER MANCHU ALI GALI CYAMONGOLIAN " +
	"LETTER MANCHU ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI ZAMONGOLIAN L" +
	"ETTER ALI GALI HALF UMONGOLIAN LETTER ALI GALI HALF YAMONGOLIAN LETTER M" +
	"ANCHU ALI GALI BHAMONGOLIAN LETTER ALI GALI DAGALGAMONGOLIAN LETTER MANC" +
	"HU ALI GALI LHACANADIAN SYLLABICS OYCANADIAN SYLLABICS AYCANADIAN SYLLAB" +
	"ICS AAYCANADIAN SYLLABICS WAYCANADIAN SYLLABICS POYCANADIAN SYLLABICS PA" +
	"YCANADIAN SYLLABICS PWOYCANADIAN SYLLABICS TAYCANADIAN SYLLABICS KAYCANA" +
	"DIAN SYLLABICS KWAYCANADIAN SYLLABICS MAYCANADIAN SYLLABICS NOYCANADIAN " +
	"SYLLABICS NAYCANADIAN SYLLABICS LAYCANADIAN SYLLABICS SOYCANADIAN SYLLAB" +
	"ICS SAYCANADIAN SYLLABICS SHOYCANADIAN SYLLABICS SHAYCANADIAN SYLLABICS " +
	"SHWOYCANADIAN SYLLABICS YOYCANADIAN SYLLABICS YAYCANADIAN SYLLABICS RAYC" +
	"ANADIAN SYLLABICS NWICANADIAN SYLLABICS OJIBWAY NWICANADIAN SYLLABICS NW" +
	"IICANADIAN SYLLABICS OJIBWAY NWIICANADIAN SYLLABICS NWOCANADIAN SYLLABIC" +
	"S OJIBWAY NWOCANADIAN SYLLABICS NWOOCANADIAN SYLLABICS OJIBWAY NWOOCANAD" +
	"IAN SYLLABICS RWEECANADIAN SYLLABICS RWICANADIAN SYLLABICS RWIICANADIAN " +
	"SYLLABICS RWOCANADIAN SYLLABICS RWOOCANADIAN SYLLABICS RWACANADIAN SYLLA" +
	"BICS OJIBWAY PCANADIAN SYLLABICS OJIBWAY TCANADIAN SYLLABICS OJIBWAY KCA" +
	"NADIAN SYLLABICS OJIBWAY CCANADIAN SYLLABICS OJIBWAY MCANADIAN SYLLABICS" +
	" OJIBWAY NCANADIAN SYLLABICS OJIBWAY SCANADIAN SYLLABICS OJIBWAY SHCANAD" +
	"IAN SYLLABICS EASTERN WCANADIAN SYLLABICS WESTERN WCANADIAN SYLLABICS FI" +
	"NAL SMALL RINGCANADIAN SYLLABICS FINAL RAISED DOTCANADIAN SYLLABICS R-CR" +
	"EE RWECANADIAN SYLLABICS WEST-CREE LOOCANADIAN SYLLABICS WEST-CREE LAACA" +
	"NADIAN SYLLABICS THWECANADIAN SYLLABICS THWACANADIAN SYLLABICS TTHWECANA" +
	"DIAN SYLLABICS TTHOOCANADIAN SYLLABICS TTHAACANADIAN SYLLABICS TLHWECANA" +
	"DIAN SYLLABICS TLHOOCANADIAN SYLLABICS SAYISI SHWECANADIAN SYLLABICS SAY" +
	"ISI SHOOCANADIAN SYLLABICS SAYISI HOOCANADIAN SYLLABICS CARRIER GWUCANAD" +
	"IAN SYLLABICS CARRIER DENE GEECANADIAN SYLLABICS CARRIER GAACANADIAN SYL" +
	"LABICS CARRIER GWACANADIAN SYLLABICS SAYISI JUUCANADIAN SYLLABICS CARRIE" +
	"R JWACANADIAN SYLLABICS BEAVER DENE LCANADIAN SYLLABICS BEAVER DENE RCAN" +
	"ADIAN SYLLABICS CARRIER DENTAL SLIMBU VOWEL-CARRIER LETTERLIMBU LETTER K" +
	"ALIMBU LETTER KHALIMBU LETTER GALIMBU LETTER GHALIMBU LETTER NGALIMBU LE" +
	"TTER CALIMBU LETTER CHALIMBU LETTER JALIMBU LETTER JHALIMBU LETTER YANLI" +
	"MBU LETTER TALIMBU LETTER THALIMBU LETTER DALIMBU LETTER DHALIMBU LETTER" +
	" NALIMBU LETTER PALIMBU LETTER PHALIMBU LETTER BALIMBU LETTER BHALIMBU L" +
	"ETTER MALIMBU LETTER YALIMBU LETTER RALIMBU LETTER LALIMBU LETTER WALIMB" +
	"U LETTER SHALIMBU LETTER SSALIMBU LETTER SALIMBU LETTER HALIMBU LETTER G" +
	"YANLIMBU LETTER TRALIMBU VOWEL SIGN ALIMBU VOWEL SIGN ILIMBU VOWEL SIGN " +
	"ULIMBU VOWEL SIGN EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN OOLIMBU VOWEL SI" +
	"GN AULIMBU VOWEL SIGN ELIMBU VOWEL SIGN OLIMBU SUBJOINED LETTER YALIMBU ") + ("" +
	"SUBJOINED LETTER RALIMBU SUBJOINED LETTER WALIMBU SMALL LETTER KALIMBU S" +
	"MALL LETTER NGALIMBU SMALL LETTER ANUSVARALIMBU SMALL LETTER TALIMBU SMA" +
	"LL LETTER NALIMBU SMALL LETTER PALIMBU SMALL LETTER MALIMBU SMALL LETTER" +
	" RALIMBU SMALL LETTER LALIMBU SIGN MUKPHRENGLIMBU SIGN KEMPHRENGLIMBU SI" +
	"GN SA-ILIMBU SIGN LOOLIMBU EXCLAMATION MARKLIMBU QUESTION MARKLIMBU DIGI" +
	"T ZEROLIMBU DIGIT ONELIMBU DIGIT TWOLIMBU DIGIT THREELIMBU DIGIT FOURLIM" +
	"BU DIGIT FIVELIMBU DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGIT EIGHTLIMBU DIGI" +
	"T NINETAI LE LETTER KATAI LE LETTER XATAI LE LETTER NGATAI LE LETTER TSA" +
	"TAI LE LETTER SATAI LE LETTER YATAI LE LETTER TATAI LE LETTER THATAI LE " +
	"LETTER LATAI LE LETTER PATAI LE LETTER PHATAI LE LETTER MATAI LE LETTER " +
	"FATAI LE LETTER VATAI LE LETTER HATAI LE LETTER QATAI LE LETTER KHATAI L" +
	"E LETTER TSHATAI LE LETTER NATAI LE LETTER ATAI LE LETTER ITAI LE LETTER" +
	" EETAI LE LETTER EHTAI LE LETTER UTAI LE LETTER OOTAI LE LETTER OTAI LE " +
	"LETTER UETAI LE LETTER ETAI LE LETTER AUETAI LE LETTER AITAI LE LETTER T" +
	"ONE-2TAI LE LETTER TONE-3TAI LE LETTER TONE-4TAI LE LETTER TONE-5TAI LE " +
	"LETTER TONE-6NEW TAI LUE LETTER HIGH QANEW TAI LUE LETTER LOW QANEW TAI " +
	"LUE LETTER HIGH KANEW TAI LUE LETTER HIGH XANEW TAI LUE LETTER HIGH NGAN" +
	"EW TAI LUE LETTER LOW KANEW TAI LUE LETTER LOW XANEW TAI LUE LETTER LOW " +
	"NGANEW TAI LUE LETTER HIGH TSANEW TAI LUE LETTER HIGH SANEW TAI LUE LETT" +
	"ER HIGH YANEW TAI LUE LETTER LOW TSANEW TAI LUE LETTER LOW SANEW TAI LUE" +
	" LETTER LOW YANEW TAI LUE LETTER HIGH TANEW TAI LUE LETTER HIGH THANEW T" +
	"AI LUE LETTER HIGH NANEW TAI LUE LETTER LOW TANEW TAI LUE LETTER LOW THA" +
	"NEW TAI LUE LETTER LOW NANEW TAI LUE LETTER HIGH PANEW TAI LUE LETTER HI" +
	"GH PHANEW TAI LUE LETTER HIGH MANEW TAI LUE LETTER LOW PANEW TAI LUE LET" +
	"TER LOW PHANEW TAI LUE LETTER LOW MANEW TAI LUE LETTER HIGH FANEW TAI LU" +
	"E LETTER HIGH VANEW TAI LUE LETTER HIGH LANEW TAI LUE LETTER LOW FANEW T" +
	"AI LUE LETTER LOW VANEW TAI LUE LETTER LOW LANEW TAI LUE LETTER HIGH HAN" +
	"EW TAI LUE LETTER HIGH DANEW TAI LUE LETTER HIGH BANEW TAI LUE LETTER LO" +
	"W HANEW TAI LUE LETTER LOW DANEW TAI LUE LETTER LOW BANEW TAI LUE LETTER" +
	" HIGH KVANEW TAI LUE LETTER HIGH XVANEW TAI LUE LETTER LOW KVANEW TAI LU" +
	"E LETTER LOW XVANEW TAI LUE LETTER HIGH SUANEW TAI LUE LETTER LOW SUANEW" +
	" TAI LUE VOWEL SIGN VOWEL SHORTENERNEW TAI LUE VOWEL SIGN AANEW TAI LUE " +
	"VOWEL SIGN IINEW TAI LUE VOWEL SIGN UNEW TAI LUE VOWEL SIGN UUNEW TAI LU" +
	"E VOWEL SIGN ENEW TAI LUE VOWEL SIGN AENEW TAI LUE VOWEL SIGN ONEW TAI L" +
	"UE VOWEL SIGN OANEW TAI LUE VOWEL SIGN UENEW TAI LUE VOWEL SIGN AYNEW TA" +
	"I LUE VOWEL SIGN AAYNEW TAI LUE VOWEL SIGN UYNEW TAI LUE VOWEL SIGN OYNE" +
	"W TAI LUE VOWEL SIGN OAYNEW TAI LUE VOWEL SIGN UEYNEW TAI LUE VOWEL SIGN" +
	" IYNEW TAI LUE LETTER FINAL VNEW TAI LUE LETTER FINAL NGNEW TAI LUE LETT" +
	"ER FINAL NNEW TAI LUE LETTER FINAL MNEW TAI LUE LETTER FINAL KNEW TAI LU" +
	"E LETTER FINAL DNEW TAI LUE LETTER FINAL BNEW TAI LUE TONE MARK-1NEW TAI" +
	" LUE TONE MARK-2NEW TAI LUE DIGIT ZERONEW TAI LUE DIGIT ONENEW TAI LUE D" +
	"IGIT TWONEW TAI LUE DIGIT THREENEW TAI LUE DIGIT FOURNEW TAI LUE DIGIT F" +
	"IVENEW TAI LUE DIGIT SIXNEW TAI LUE DIGIT SEVENNEW TAI LUE DIGIT EIGHTNE" +
	"W TAI LUE DIGIT NINENEW TAI LUE THAM DIGIT ONENEW TAI LUE SIGN LAENEW TA" +
	"I LUE SIGN LAEVKHMER SYMBOL PATHAMASATKHMER SYMBOL MUOY KOETKHMER SYMBOL" +
	" PII KOETKHMER SYMBOL BEI KOETKHMER SYMBOL BUON KOETKHMER SYMBOL PRAM KO" +
	"ETKHMER SYMBOL PRAM-MUOY KOETKHMER SYMBOL PRAM-PII KOETKHMER SYMBOL PRAM" +
	"-BEI KOETKHMER SYMBOL PRAM-BUON KOETKHMER SYMBOL DAP KOETKHMER SYMBOL DA" +
	"P-MUOY KOETKHMER SYMBOL DAP-PII KOETKHMER SYMBOL DAP-BEI KOETKHMER SYMBO" +
	"L DAP-BUON KOETKHMER SYMBOL DAP-PRAM KOETKHMER SYMBOL TUTEYASATKHMER SYM" +
	"BOL MUOY ROCKHMER SYMBOL PII ROCKHMER SYMBOL BEI ROCKHMER SYMBOL BUON RO" +
	"CKHMER SYMBOL PRAM ROCKHMER SYMBOL PRAM-MUOY ROCKHMER SYMBOL PRAM-PII RO" +
	"CKHMER SYMBOL PRAM-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHMER SYMBOL DAP ROC" +
	"KHMER SYMBOL DAP-MUOY ROCKHMER SYMBOL DAP-PII ROCKHMER SYMBOL DAP-BEI RO" +
	"CKHMER SYMBOL DAP-BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGINESE LETTER KABUG" +
	"INESE LETTER GABUGINESE LETTER NGABUGINESE LETTER NGKABUGINESE LETTER PA" +
	"BUGINESE LETTER BABUGINESE LETTER MABUGINESE LETTER MPABUGINESE LETTER T" +
	"ABUGINESE LETTER DABUGINESE LETTER NABUGINESE LETTER NRABUGINESE LETTER " +
	"CABUGINESE LETTER JABUGINESE LETTER NYABUGINESE LETTER NYCABUGINESE LETT" +
	"ER YABUGINESE LETTER RABUGINESE LETTER LABUGINESE LETTER VABUGINESE LETT" +
	"ER SABUGINESE LETTER ABUGINESE LETTER HABUGINESE VOWEL SIGN IBUGINESE VO" +
	"WEL SIGN UBUGINESE VOWEL SIGN EBUGINESE VOWEL SIGN OBUGINESE VOWEL SIGN " +
	"AEBUGINESE PALLAWABUGINESE END OF SECTIONTAI THAM LETTER HIGH KATAI THAM" +
	" LETTER HIGH KHATAI THAM LETTER HIGH KXATAI THAM LETTER LOW KATAI THAM L") + ("" +
	"ETTER LOW KXATAI THAM LETTER LOW KHATAI THAM LETTER NGATAI THAM LETTER H" +
	"IGH CATAI THAM LETTER HIGH CHATAI THAM LETTER LOW CATAI THAM LETTER LOW " +
	"SATAI THAM LETTER LOW CHATAI THAM LETTER NYATAI THAM LETTER RATATAI THAM" +
	" LETTER HIGH RATHATAI THAM LETTER DATAI THAM LETTER LOW RATHATAI THAM LE" +
	"TTER RANATAI THAM LETTER HIGH TATAI THAM LETTER HIGH THATAI THAM LETTER " +
	"LOW TATAI THAM LETTER LOW THATAI THAM LETTER NATAI THAM LETTER BATAI THA" +
	"M LETTER HIGH PATAI THAM LETTER HIGH PHATAI THAM LETTER HIGH FATAI THAM " +
	"LETTER LOW PATAI THAM LETTER LOW FATAI THAM LETTER LOW PHATAI THAM LETTE" +
	"R MATAI THAM LETTER LOW YATAI THAM LETTER HIGH YATAI THAM LETTER RATAI T" +
	"HAM LETTER RUETAI THAM LETTER LATAI THAM LETTER LUETAI THAM LETTER WATAI" +
	" THAM LETTER HIGH SHATAI THAM LETTER HIGH SSATAI THAM LETTER HIGH SATAI " +
	"THAM LETTER HIGH HATAI THAM LETTER LLATAI THAM LETTER ATAI THAM LETTER L" +
	"OW HATAI THAM LETTER ITAI THAM LETTER IITAI THAM LETTER UTAI THAM LETTER" +
	" UUTAI THAM LETTER EETAI THAM LETTER OOTAI THAM LETTER LAETAI THAM LETTE" +
	"R GREAT SATAI THAM CONSONANT SIGN MEDIAL RATAI THAM CONSONANT SIGN MEDIA" +
	"L LATAI THAM CONSONANT SIGN LA TANG LAITAI THAM SIGN MAI KANG LAITAI THA" +
	"M CONSONANT SIGN FINAL NGATAI THAM CONSONANT SIGN LOW PATAI THAM CONSONA" +
	"NT SIGN HIGH RATHA OR LOW PATAI THAM CONSONANT SIGN MATAI THAM CONSONANT" +
	" SIGN BATAI THAM CONSONANT SIGN SATAI THAM SIGN SAKOTTAI THAM VOWEL SIGN" +
	" ATAI THAM VOWEL SIGN MAI SATTAI THAM VOWEL SIGN AATAI THAM VOWEL SIGN T" +
	"ALL AATAI THAM VOWEL SIGN ITAI THAM VOWEL SIGN IITAI THAM VOWEL SIGN UET" +
	"AI THAM VOWEL SIGN UUETAI THAM VOWEL SIGN UTAI THAM VOWEL SIGN UUTAI THA" +
	"M VOWEL SIGN OTAI THAM VOWEL SIGN OA BELOWTAI THAM VOWEL SIGN OYTAI THAM" +
	" VOWEL SIGN ETAI THAM VOWEL SIGN AETAI THAM VOWEL SIGN OOTAI THAM VOWEL " +
	"SIGN AITAI THAM VOWEL SIGN THAM AITAI THAM VOWEL SIGN OA ABOVETAI THAM S" +
	"IGN MAI KANGTAI THAM SIGN TONE-1TAI THAM SIGN TONE-2TAI THAM SIGN KHUEN " +
	"TONE-3TAI THAM SIGN KHUEN TONE-4TAI THAM SIGN KHUEN TONE-5TAI THAM SIGN " +
	"RA HAAMTAI THAM SIGN MAI SAMTAI THAM SIGN KHUEN-LUE KARANTAI THAM COMBIN" +
	"ING CRYPTOGRAMMIC DOTTAI THAM HORA DIGIT ZEROTAI THAM HORA DIGIT ONETAI " +
	"THAM HORA DIGIT TWOTAI THAM HORA DIGIT THREETAI THAM HORA DIGIT FOURTAI " +
	"THAM HORA DIGIT FIVETAI THAM HORA DIGIT SIXTAI THAM HORA DIGIT SEVENTAI " +
	"THAM HORA DIGIT EIGHTTAI THAM HORA DIGIT NINETAI THAM THAM DIGIT ZEROTAI" +
	" THAM THAM DIGIT ONETAI THAM THAM DIGIT TWOTAI THAM THAM DIGIT THREETAI " +
	"THAM THAM DIGIT FOURTAI THAM THAM DIGIT FIVETAI THAM THAM DIGIT SIXTAI T" +
	"HAM THAM DIGIT SEVENTAI THAM THAM DIGIT EIGHTTAI THAM THAM DIGIT NINETAI" +
	" THAM SIGN WIANGTAI THAM SIGN WIANGWAAKTAI THAM SIGN SAWANTAI THAM SIGN " +
	"KEOWTAI THAM SIGN HOYTAI THAM SIGN DOKMAITAI THAM SIGN REVERSED ROTATED " +
	"RANATAI THAM SIGN MAI YAMOKTAI THAM SIGN KAANTAI THAM SIGN KAANKUUTAI TH" +
	"AM SIGN SATKAANTAI THAM SIGN SATKAANKUUTAI THAM SIGN HANGTAI THAM SIGN C" +
	"AANGCOMBINING DOUBLED CIRCUMFLEX ACCENTCOMBINING DIAERESIS-RINGCOMBINING" +
	" INFINITYCOMBINING DOWNWARDS ARROWCOMBINING TRIPLE DOTCOMBINING X-X BELO" +
	"WCOMBINING WIGGLY LINE BELOWCOMBINING OPEN MARK BELOWCOMBINING DOUBLE OP" +
	"EN MARK BELOWCOMBINING LIGHT CENTRALIZATION STROKE BELOWCOMBINING STRONG" +
	" CENTRALIZATION STROKE BELOWCOMBINING PARENTHESES ABOVECOMBINING DOUBLE " +
	"PARENTHESES ABOVECOMBINING PARENTHESES BELOWCOMBINING PARENTHESES OVERLA" +
	"YCOMBINING LATIN SMALL LETTER W BELOWCOMBINING LATIN SMALL LETTER TURNED" +
	" W BELOWCOMBINING LEFT PARENTHESIS ABOVE LEFTCOMBINING RIGHT PARENTHESIS" +
	" ABOVE RIGHTCOMBINING LEFT PARENTHESIS BELOW LEFTCOMBINING RIGHT PARENTH" +
	"ESIS BELOW RIGHTCOMBINING SQUARE BRACKETS ABOVECOMBINING NUMBER SIGN ABO" +
	"VECOMBINING INVERTED DOUBLE ARCH ABOVECOMBINING PLUS SIGN ABOVECOMBINING" +
	" DOUBLE PLUS SIGN ABOVECOMBINING DOUBLE PLUS SIGN BELOWCOMBINING TRIPLE " +
	"ACUTE ACCENTCOMBINING LATIN SMALL LETTER INSULAR GCOMBINING LATIN SMALL " +
	"LETTER INSULAR RCOMBINING LATIN SMALL LETTER INSULAR TBALINESE SIGN ULU " +
	"RICEMBALINESE SIGN ULU CANDRABALINESE SIGN CECEKBALINESE SIGN SURANGBALI" +
	"NESE SIGN BISAHBALINESE LETTER AKARABALINESE LETTER AKARA TEDUNGBALINESE" +
	" LETTER IKARABALINESE LETTER IKARA TEDUNGBALINESE LETTER UKARABALINESE L" +
	"ETTER UKARA TEDUNGBALINESE LETTER RA REPABALINESE LETTER RA REPA TEDUNGB" +
	"ALINESE LETTER LA LENGABALINESE LETTER LA LENGA TEDUNGBALINESE LETTER EK" +
	"ARABALINESE LETTER AIKARABALINESE LETTER OKARABALINESE LETTER OKARA TEDU" +
	"NGBALINESE LETTER KABALINESE LETTER KA MAHAPRANABALINESE LETTER GABALINE" +
	"SE LETTER GA GORABALINESE LETTER NGABALINESE LETTER CABALINESE LETTER CA" +
	" LACABALINESE LETTER JABALINESE LETTER JA JERABALINESE LETTER NYABALINES" +
	"E LETTER TA LATIKBALINESE LETTER TA MURDA MAHAPRANABALINESE LETTER DA MU" +
	"RDA ALPAPRANABALINESE LETTER DA MURDA MAHAPRANABALINESE LETTER NA RAMBAT") + ("" +
	"BALINESE LETTER TABALINESE LETTER TA TAWABALINESE LETTER DABALINESE LETT" +
	"ER DA MADUBALINESE LETTER NABALINESE LETTER PABALINESE LETTER PA KAPALBA" +
	"LINESE LETTER BABALINESE LETTER BA KEMBANGBALINESE LETTER MABALINESE LET" +
	"TER YABALINESE LETTER RABALINESE LETTER LABALINESE LETTER WABALINESE LET" +
	"TER SA SAGABALINESE LETTER SA SAPABALINESE LETTER SABALINESE LETTER HABA" +
	"LINESE SIGN REREKANBALINESE VOWEL SIGN TEDUNGBALINESE VOWEL SIGN ULUBALI" +
	"NESE VOWEL SIGN ULU SARIBALINESE VOWEL SIGN SUKUBALINESE VOWEL SIGN SUKU" +
	" ILUTBALINESE VOWEL SIGN RA REPABALINESE VOWEL SIGN RA REPA TEDUNGBALINE" +
	"SE VOWEL SIGN LA LENGABALINESE VOWEL SIGN LA LENGA TEDUNGBALINESE VOWEL " +
	"SIGN TALINGBALINESE VOWEL SIGN TALING REPABALINESE VOWEL SIGN TALING TED" +
	"UNGBALINESE VOWEL SIGN TALING REPA TEDUNGBALINESE VOWEL SIGN PEPETBALINE" +
	"SE VOWEL SIGN PEPET TEDUNGBALINESE ADEG ADEGBALINESE LETTER KAF SASAKBAL" +
	"INESE LETTER KHOT SASAKBALINESE LETTER TZIR SASAKBALINESE LETTER EF SASA" +
	"KBALINESE LETTER VE SASAKBALINESE LETTER ZAL SASAKBALINESE LETTER ASYURA" +
	" SASAKBALINESE LETTER ARCHAIC JNYABALINESE DIGIT ZEROBALINESE DIGIT ONEB" +
	"ALINESE DIGIT TWOBALINESE DIGIT THREEBALINESE DIGIT FOURBALINESE DIGIT F" +
	"IVEBALINESE DIGIT SIXBALINESE DIGIT SEVENBALINESE DIGIT EIGHTBALINESE DI" +
	"GIT NINEBALINESE PANTIBALINESE PAMADABALINESE WINDUBALINESE CARIK PAMUNG" +
	"KAHBALINESE CARIK SIKIBALINESE CARIK PARERENBALINESE PAMENENGBALINESE MU" +
	"SICAL SYMBOL DONGBALINESE MUSICAL SYMBOL DENGBALINESE MUSICAL SYMBOL DUN" +
	"GBALINESE MUSICAL SYMBOL DANGBALINESE MUSICAL SYMBOL DANG SURANGBALINESE" +
	" MUSICAL SYMBOL DINGBALINESE MUSICAL SYMBOL DAENGBALINESE MUSICAL SYMBOL" +
	" DEUNGBALINESE MUSICAL SYMBOL DAINGBALINESE MUSICAL SYMBOL DANG GEDEBALI" +
	"NESE MUSICAL SYMBOL COMBINING TEGEHBALINESE MUSICAL SYMBOL COMBINING END" +
	"EPBALINESE MUSICAL SYMBOL COMBINING KEMPULBALINESE MUSICAL SYMBOL COMBIN" +
	"ING KEMPLIBALINESE MUSICAL SYMBOL COMBINING JEGOGANBALINESE MUSICAL SYMB" +
	"OL COMBINING KEMPUL WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPLI" +
	" WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING BENDEBALINESE MUSICAL SYM" +
	"BOL COMBINING GONGBALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUGBALINESE MU" +
	"SICAL SYMBOL RIGHT-HAND OPEN DAGBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSE" +
	"D TUKBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAKBALINESE MUSICAL SYMBO" +
	"L LEFT-HAND OPEN PANGBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNGBALINESE" +
	" MUSICAL SYMBOL LEFT-HAND CLOSED PLAKBALINESE MUSICAL SYMBOL LEFT-HAND C" +
	"LOSED PLUKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PINGBALINESE PANTI LANT" +
	"ANGBALINESE PAMADA LANTANGSUNDANESE SIGN PANYECEKSUNDANESE SIGN PANGLAYA" +
	"RSUNDANESE SIGN PANGWISADSUNDANESE LETTER ASUNDANESE LETTER ISUNDANESE L" +
	"ETTER USUNDANESE LETTER AESUNDANESE LETTER OSUNDANESE LETTER ESUNDANESE " +
	"LETTER EUSUNDANESE LETTER KASUNDANESE LETTER QASUNDANESE LETTER GASUNDAN" +
	"ESE LETTER NGASUNDANESE LETTER CASUNDANESE LETTER JASUNDANESE LETTER ZAS" +
	"UNDANESE LETTER NYASUNDANESE LETTER TASUNDANESE LETTER DASUNDANESE LETTE" +
	"R NASUNDANESE LETTER PASUNDANESE LETTER FASUNDANESE LETTER VASUNDANESE L" +
	"ETTER BASUNDANESE LETTER MASUNDANESE LETTER YASUNDANESE LETTER RASUNDANE" +
	"SE LETTER LASUNDANESE LETTER WASUNDANESE LETTER SASUNDANESE LETTER XASUN" +
	"DANESE LETTER HASUNDANESE CONSONANT SIGN PAMINGKALSUNDANESE CONSONANT SI" +
	"GN PANYAKRASUNDANESE CONSONANT SIGN PANYIKUSUNDANESE VOWEL SIGN PANGHULU" +
	"SUNDANESE VOWEL SIGN PANYUKUSUNDANESE VOWEL SIGN PANAELAENGSUNDANESE VOW" +
	"EL SIGN PANOLONGSUNDANESE VOWEL SIGN PAMEPETSUNDANESE VOWEL SIGN PANEULE" +
	"UNGSUNDANESE SIGN PAMAAEHSUNDANESE SIGN VIRAMASUNDANESE CONSONANT SIGN P" +
	"ASANGAN MASUNDANESE CONSONANT SIGN PASANGAN WASUNDANESE LETTER KHASUNDAN" +
	"ESE LETTER SYASUNDANESE DIGIT ZEROSUNDANESE DIGIT ONESUNDANESE DIGIT TWO" +
	"SUNDANESE DIGIT THREESUNDANESE DIGIT FOURSUNDANESE DIGIT FIVESUNDANESE D" +
	"IGIT SIXSUNDANESE DIGIT SEVENSUNDANESE DIGIT EIGHTSUNDANESE DIGIT NINESU" +
	"NDANESE AVAGRAHASUNDANESE LETTER REUSUNDANESE LETTER LEUSUNDANESE LETTER" +
	" BHASUNDANESE LETTER FINAL KSUNDANESE LETTER FINAL MBATAK LETTER ABATAK " +
	"LETTER SIMALUNGUN ABATAK LETTER HABATAK LETTER SIMALUNGUN HABATAK LETTER" +
	" MANDAILING HABATAK LETTER BABATAK LETTER KARO BABATAK LETTER PABATAK LE" +
	"TTER SIMALUNGUN PABATAK LETTER NABATAK LETTER MANDAILING NABATAK LETTER " +
	"WABATAK LETTER SIMALUNGUN WABATAK LETTER PAKPAK WABATAK LETTER GABATAK L" +
	"ETTER SIMALUNGUN GABATAK LETTER JABATAK LETTER DABATAK LETTER RABATAK LE" +
	"TTER SIMALUNGUN RABATAK LETTER MABATAK LETTER SIMALUNGUN MABATAK LETTER " +
	"SOUTHERN TABATAK LETTER NORTHERN TABATAK LETTER SABATAK LETTER SIMALUNGU" +
	"N SABATAK LETTER MANDAILING SABATAK LETTER YABATAK LETTER SIMALUNGUN YAB" +
	"ATAK LETTER NGABATAK LETTER LABATAK LETTER SIMALUNGUN LABATAK LETTER NYA" +
	"BATAK LETTER CABATAK LETTER NDABATAK LETTER MBABATAK LETTER IBATAK LETTE") + ("" +
	"R UBATAK SIGN TOMPIBATAK VOWEL SIGN EBATAK VOWEL SIGN PAKPAK EBATAK VOWE" +
	"L SIGN EEBATAK VOWEL SIGN IBATAK VOWEL SIGN KARO IBATAK VOWEL SIGN OBATA" +
	"K VOWEL SIGN KARO OBATAK VOWEL SIGN UBATAK VOWEL SIGN U FOR SIMALUNGUN S" +
	"ABATAK CONSONANT SIGN NGBATAK CONSONANT SIGN HBATAK PANGOLATBATAK PANONG" +
	"ONANBATAK SYMBOL BINDU NA METEKBATAK SYMBOL BINDU PINARBORASBATAK SYMBOL" +
	" BINDU JUDULBATAK SYMBOL BINDU PANGOLATLEPCHA LETTER KALEPCHA LETTER KLA" +
	"LEPCHA LETTER KHALEPCHA LETTER GALEPCHA LETTER GLALEPCHA LETTER NGALEPCH" +
	"A LETTER CALEPCHA LETTER CHALEPCHA LETTER JALEPCHA LETTER NYALEPCHA LETT" +
	"ER TALEPCHA LETTER THALEPCHA LETTER DALEPCHA LETTER NALEPCHA LETTER PALE" +
	"PCHA LETTER PLALEPCHA LETTER PHALEPCHA LETTER FALEPCHA LETTER FLALEPCHA " +
	"LETTER BALEPCHA LETTER BLALEPCHA LETTER MALEPCHA LETTER MLALEPCHA LETTER" +
	" TSALEPCHA LETTER TSHALEPCHA LETTER DZALEPCHA LETTER YALEPCHA LETTER RAL" +
	"EPCHA LETTER LALEPCHA LETTER HALEPCHA LETTER HLALEPCHA LETTER VALEPCHA L" +
	"ETTER SALEPCHA LETTER SHALEPCHA LETTER WALEPCHA LETTER ALEPCHA SUBJOINED" +
	" LETTER YALEPCHA SUBJOINED LETTER RALEPCHA VOWEL SIGN AALEPCHA VOWEL SIG" +
	"N ILEPCHA VOWEL SIGN OLEPCHA VOWEL SIGN OOLEPCHA VOWEL SIGN ULEPCHA VOWE" +
	"L SIGN UULEPCHA VOWEL SIGN ELEPCHA CONSONANT SIGN KLEPCHA CONSONANT SIGN" +
	" MLEPCHA CONSONANT SIGN LLEPCHA CONSONANT SIGN NLEPCHA CONSONANT SIGN PL" +
	"EPCHA CONSONANT SIGN RLEPCHA CONSONANT SIGN TLEPCHA CONSONANT SIGN NYIN-" +
	"DOLEPCHA CONSONANT SIGN KANGLEPCHA SIGN RANLEPCHA SIGN NUKTALEPCHA PUNCT" +
	"UATION TA-ROLLEPCHA PUNCTUATION NYET THYOOM TA-ROLLEPCHA PUNCTUATION CER" +
	"-WALEPCHA PUNCTUATION TSHOOK CER-WALEPCHA PUNCTUATION TSHOOKLEPCHA DIGIT" +
	" ZEROLEPCHA DIGIT ONELEPCHA DIGIT TWOLEPCHA DIGIT THREELEPCHA DIGIT FOUR" +
	"LEPCHA DIGIT FIVELEPCHA DIGIT SIXLEPCHA DIGIT SEVENLEPCHA DIGIT EIGHTLEP" +
	"CHA DIGIT NINELEPCHA LETTER TTALEPCHA LETTER TTHALEPCHA LETTER DDAOL CHI" +
	"KI DIGIT ZEROOL CHIKI DIGIT ONEOL CHIKI DIGIT TWOOL CHIKI DIGIT THREEOL " +
	"CHIKI DIGIT FOUROL CHIKI DIGIT FIVEOL CHIKI DIGIT SIXOL CHIKI DIGIT SEVE" +
	"NOL CHIKI DIGIT EIGHTOL CHIKI DIGIT NINEOL CHIKI LETTER LAOL CHIKI LETTE" +
	"R ATOL CHIKI LETTER AGOL CHIKI LETTER ANGOL CHIKI LETTER ALOL CHIKI LETT" +
	"ER LAAOL CHIKI LETTER AAKOL CHIKI LETTER AAJOL CHIKI LETTER AAMOL CHIKI " +
	"LETTER AAWOL CHIKI LETTER LIOL CHIKI LETTER ISOL CHIKI LETTER IHOL CHIKI" +
	" LETTER INYOL CHIKI LETTER IROL CHIKI LETTER LUOL CHIKI LETTER UCOL CHIK" +
	"I LETTER UDOL CHIKI LETTER UNNOL CHIKI LETTER UYOL CHIKI LETTER LEOL CHI" +
	"KI LETTER EPOL CHIKI LETTER EDDOL CHIKI LETTER ENOL CHIKI LETTER ERROL C" +
	"HIKI LETTER LOOL CHIKI LETTER OTTOL CHIKI LETTER OBOL CHIKI LETTER OVOL " +
	"CHIKI LETTER OHOL CHIKI MU TTUDDAGOL CHIKI GAAHLAA TTUDDAAGOL CHIKI MU-G" +
	"AAHLAA TTUDDAAGOL CHIKI RELAAOL CHIKI PHAARKAAOL CHIKI AHADOL CHIKI PUNC" +
	"TUATION MUCAADOL CHIKI PUNCTUATION DOUBLE MUCAADCYRILLIC SMALL LETTER RO" +
	"UNDED VECYRILLIC SMALL LETTER LONG-LEGGED DECYRILLIC SMALL LETTER NARROW" +
	" OCYRILLIC SMALL LETTER WIDE ESCYRILLIC SMALL LETTER TALL TECYRILLIC SMA" +
	"LL LETTER THREE-LEGGED TECYRILLIC SMALL LETTER TALL HARD SIGNCYRILLIC SM" +
	"ALL LETTER TALL YATCYRILLIC SMALL LETTER UNBLENDED UKGEORGIAN MTAVRULI C" +
	"APITAL LETTER ANGEORGIAN MTAVRULI CAPITAL LETTER BANGEORGIAN MTAVRULI CA" +
	"PITAL LETTER GANGEORGIAN MTAVRULI CAPITAL LETTER DONGEORGIAN MTAVRULI CA" +
	"PITAL LETTER ENGEORGIAN MTAVRULI CAPITAL LETTER VINGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER ZENGEORGIAN MTAVRULI CAPITAL LETTER TANGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER INGEORGIAN MTAVRULI CAPITAL LETTER KANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER LASGEORGIAN MTAVRULI CAPITAL LETTER MANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER NARGEORGIAN MTAVRULI CAPITAL LETTER ONGEORGIAN MTAVRULI CAPIT" +
	"AL LETTER PARGEORGIAN MTAVRULI CAPITAL LETTER ZHARGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER RAEGEORGIAN MTAVRULI CAPITAL LETTER SANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER TARGEORGIAN MTAVRULI CAPITAL LETTER UNGEORGIAN MTAVRULI CAPIT" +
	"AL LETTER PHARGEORGIAN MTAVRULI CAPITAL LETTER KHARGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER GHANGEORGIAN MTAVRULI CAPITAL LETTER QARGEORGIAN MTAVRULI CA" +
	"PITAL LETTER SHINGEORGIAN MTAVRULI CAPITAL LETTER CHINGEORGIAN MTAVRULI " +
	"CAPITAL LETTER CANGEORGIAN MTAVRULI CAPITAL LETTER JILGEORGIAN MTAVRULI " +
	"CAPITAL LETTER CILGEORGIAN MTAVRULI CAPITAL LETTER CHARGEORGIAN MTAVRULI" +
	" CAPITAL LETTER XANGEORGIAN MTAVRULI CAPITAL LETTER JHANGEORGIAN MTAVRUL" +
	"I CAPITAL LETTER HAEGEORGIAN MTAVRULI CAPITAL LETTER HEGEORGIAN MTAVRULI" +
	" CAPITAL LETTER HIEGEORGIAN MTAVRULI CAPITAL LETTER WEGEORGIAN MTAVRULI " +
	"CAPITAL LETTER HARGEORGIAN MTAVRULI CAPITAL LETTER HOEGEORGIAN MTAVRULI " +
	"CAPITAL LETTER FIGEORGIAN MTAVRULI CAPITAL LETTER YNGEORGIAN MTAVRULI CA" +
	"PITAL LETTER ELIFIGEORGIAN MTAVRULI CAPITAL LETTER TURNED GANGEORGIAN MT" +
	"AVRULI CAPITAL LETTER AINGEORGIAN MTAVRULI CAPITAL LETTER AENGEORGIAN MT") + ("" +
	"AVRULI CAPITAL LETTER HARD SIGNGEORGIAN MTAVRULI CAPITAL LETTER LABIAL S" +
	"IGNSUNDANESE PUNCTUATION BINDU SURYASUNDANESE PUNCTUATION BINDU PANGLONG" +
	"SUNDANESE PUNCTUATION BINDU PURNAMASUNDANESE PUNCTUATION BINDU CAKRASUND" +
	"ANESE PUNCTUATION BINDU LEU SATANGASUNDANESE PUNCTUATION BINDU KA SATANG" +
	"ASUNDANESE PUNCTUATION BINDU DA SATANGASUNDANESE PUNCTUATION BINDU BA SA" +
	"TANGAVEDIC TONE KARSHANAVEDIC TONE SHARAVEDIC TONE PRENKHAVEDIC SIGN NIH" +
	"SHVASAVEDIC SIGN YAJURVEDIC MIDLINE SVARITAVEDIC TONE YAJURVEDIC AGGRAVA" +
	"TED INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC INDEPENDENT SVARITAVEDIC TO" +
	"NE YAJURVEDIC KATHAKA INDEPENDENT SVARITAVEDIC TONE CANDRA BELOWVEDIC TO" +
	"NE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDERVEDIC TONE DOUBLE SVA" +
	"RITAVEDIC TONE TRIPLE SVARITAVEDIC TONE KATHAKA ANUDATTAVEDIC TONE DOT B" +
	"ELOWVEDIC TONE TWO DOTS BELOWVEDIC TONE THREE DOTS BELOWVEDIC TONE RIGVE" +
	"DIC KASHMIRI INDEPENDENT SVARITAVEDIC TONE ATHARVAVEDIC INDEPENDENT SVAR" +
	"ITAVEDIC SIGN VISARGA SVARITAVEDIC SIGN VISARGA UDATTAVEDIC SIGN REVERSE" +
	"D VISARGA UDATTAVEDIC SIGN VISARGA ANUDATTAVEDIC SIGN REVERSED VISARGA A" +
	"NUDATTAVEDIC SIGN VISARGA UDATTA WITH TAILVEDIC SIGN VISARGA ANUDATTA WI" +
	"TH TAILVEDIC SIGN ANUSVARA ANTARGOMUKHAVEDIC SIGN ANUSVARA BAHIRGOMUKHAV" +
	"EDIC SIGN ANUSVARA VAMAGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAILV" +
	"EDIC SIGN TIRYAKVEDIC SIGN HEXIFORM LONG ANUSVARAVEDIC SIGN LONG ANUSVAR" +
	"AVEDIC SIGN RTHANG LONG ANUSVARAVEDIC SIGN ANUSVARA UBHAYATO MUKHAVEDIC " +
	"SIGN ARDHAVISARGAVEDIC SIGN ROTATED ARDHAVISARGAVEDIC TONE CANDRA ABOVEV" +
	"EDIC SIGN JIHVAMULIYAVEDIC SIGN UPADHMANIYAVEDIC SIGN ATIKRAMAVEDIC TONE" +
	" RING ABOVEVEDIC TONE DOUBLE RING ABOVEVEDIC SIGN DOUBLE ANUSVARA ANTARG" +
	"OMUKHALATIN LETTER SMALL CAPITAL ALATIN LETTER SMALL CAPITAL AELATIN SMA" +
	"LL LETTER TURNED AELATIN LETTER SMALL CAPITAL BARRED BLATIN LETTER SMALL" +
	" CAPITAL CLATIN LETTER SMALL CAPITAL DLATIN LETTER SMALL CAPITAL ETHLATI" +
	"N LETTER SMALL CAPITAL ELATIN SMALL LETTER TURNED OPEN ELATIN SMALL LETT" +
	"ER TURNED ILATIN LETTER SMALL CAPITAL JLATIN LETTER SMALL CAPITAL KLATIN" +
	" LETTER SMALL CAPITAL L WITH STROKELATIN LETTER SMALL CAPITAL MLATIN LET" +
	"TER SMALL CAPITAL REVERSED NLATIN LETTER SMALL CAPITAL OLATIN LETTER SMA" +
	"LL CAPITAL OPEN OLATIN SMALL LETTER SIDEWAYS OLATIN SMALL LETTER SIDEWAY" +
	"S OPEN OLATIN SMALL LETTER SIDEWAYS O WITH STROKELATIN SMALL LETTER TURN" +
	"ED OELATIN LETTER SMALL CAPITAL OULATIN SMALL LETTER TOP HALF OLATIN SMA" +
	"LL LETTER BOTTOM HALF OLATIN LETTER SMALL CAPITAL PLATIN LETTER SMALL CA" +
	"PITAL REVERSED RLATIN LETTER SMALL CAPITAL TURNED RLATIN LETTER SMALL CA" +
	"PITAL TLATIN LETTER SMALL CAPITAL ULATIN SMALL LETTER SIDEWAYS ULATIN SM" +
	"ALL LETTER SIDEWAYS DIAERESIZED ULATIN SMALL LETTER SIDEWAYS TURNED MLAT" +
	"IN LETTER SMALL CAPITAL VLATIN LETTER SMALL CAPITAL WLATIN LETTER SMALL " +
	"CAPITAL ZLATIN LETTER SMALL CAPITAL EZHLATIN LETTER VOICED LARYNGEAL SPI" +
	"RANTLATIN LETTER AINGREEK LETTER SMALL CAPITAL GAMMAGREEK LETTER SMALL C" +
	"APITAL LAMDAGREEK LETTER SMALL CAPITAL PIGREEK LETTER SMALL CAPITAL RHOG" +
	"REEK LETTER SMALL CAPITAL PSICYRILLIC LETTER SMALL CAPITAL ELMODIFIER LE" +
	"TTER CAPITAL AMODIFIER LETTER CAPITAL AEMODIFIER LETTER CAPITAL BMODIFIE" +
	"R LETTER CAPITAL BARRED BMODIFIER LETTER CAPITAL DMODIFIER LETTER CAPITA" +
	"L EMODIFIER LETTER CAPITAL REVERSED EMODIFIER LETTER CAPITAL GMODIFIER L" +
	"ETTER CAPITAL HMODIFIER LETTER CAPITAL IMODIFIER LETTER CAPITAL JMODIFIE" +
	"R LETTER CAPITAL KMODIFIER LETTER CAPITAL LMODIFIER LETTER CAPITAL MMODI" +
	"FIER LETTER CAPITAL NMODIFIER LETTER CAPITAL REVERSED NMODIFIER LETTER C" +
	"APITAL OMODIFIER LETTER CAPITAL OUMODIFIER LETTER CAPITAL PMODIFIER LETT" +
	"ER CAPITAL RMODIFIER LETTER CAPITAL TMODIFIER LETTER CAPITAL UMODIFIER L" +
	"ETTER CAPITAL WMODIFIER LETTER SMALL AMODIFIER LETTER SMALL TURNED AMODI" +
	"FIER LETTER SMALL ALPHAMODIFIER LETTER SMALL TURNED AEMODIFIER LETTER SM" +
	"ALL BMODIFIER LETTER SMALL DMODIFIER LETTER SMALL EMODIFIER LETTER SMALL" +
	" SCHWAMODIFIER LETTER SMALL OPEN EMODIFIER LETTER SMALL TURNED OPEN EMOD" +
	"IFIER LETTER SMALL GMODIFIER LETTER SMALL TURNED IMODIFIER LETTER SMALL " +
	"KMODIFIER LETTER SMALL MMODIFIER LETTER SMALL ENGMODIFIER LETTER SMALL O" +
	"MODIFIER LETTER SMALL OPEN OMODIFIER LETTER SMALL TOP HALF OMODIFIER LET" +
	"TER SMALL BOTTOM HALF OMODIFIER LETTER SMALL PMODIFIER LETTER SMALL TMOD" +
	"IFIER LETTER SMALL UMODIFIER LETTER SMALL SIDEWAYS UMODIFIER LETTER SMAL" +
	"L TURNED MMODIFIER LETTER SMALL VMODIFIER LETTER SMALL AINMODIFIER LETTE" +
	"R SMALL BETAMODIFIER LETTER SMALL GREEK GAMMAMODIFIER LETTER SMALL DELTA" +
	"MODIFIER LETTER SMALL GREEK PHIMODIFIER LETTER SMALL CHILATIN SUBSCRIPT " +
	"SMALL LETTER ILATIN SUBSCRIPT SMALL LETTER RLATIN SUBSCRIPT SMALL LETTER" +
	" ULATIN SUBSCRIPT SMALL LETTER VGREEK SUBSCRIPT SMALL LETTER BETAGREEK S") + ("" +
	"UBSCRIPT SMALL LETTER GAMMAGREEK SUBSCRIPT SMALL LETTER RHOGREEK SUBSCRI" +
	"PT SMALL LETTER PHIGREEK SUBSCRIPT SMALL LETTER CHILATIN SMALL LETTER UE" +
	"LATIN SMALL LETTER B WITH MIDDLE TILDELATIN SMALL LETTER D WITH MIDDLE T" +
	"ILDELATIN SMALL LETTER F WITH MIDDLE TILDELATIN SMALL LETTER M WITH MIDD" +
	"LE TILDELATIN SMALL LETTER N WITH MIDDLE TILDELATIN SMALL LETTER P WITH " +
	"MIDDLE TILDELATIN SMALL LETTER R WITH MIDDLE TILDELATIN SMALL LETTER R W" +
	"ITH FISHHOOK AND MIDDLE TILDELATIN SMALL LETTER S WITH MIDDLE TILDELATIN" +
	" SMALL LETTER T WITH MIDDLE TILDELATIN SMALL LETTER Z WITH MIDDLE TILDEL" +
	"ATIN SMALL LETTER TURNED GMODIFIER LETTER CYRILLIC ENLATIN SMALL LETTER " +
	"INSULAR GLATIN SMALL LETTER TH WITH STRIKETHROUGHLATIN SMALL CAPITAL LET" +
	"TER I WITH STROKELATIN SMALL LETTER IOTA WITH STROKELATIN SMALL LETTER P" +
	" WITH STROKELATIN SMALL CAPITAL LETTER U WITH STROKELATIN SMALL LETTER U" +
	"PSILON WITH STROKELATIN SMALL LETTER B WITH PALATAL HOOKLATIN SMALL LETT" +
	"ER D WITH PALATAL HOOKLATIN SMALL LETTER F WITH PALATAL HOOKLATIN SMALL " +
	"LETTER G WITH PALATAL HOOKLATIN SMALL LETTER K WITH PALATAL HOOKLATIN SM" +
	"ALL LETTER L WITH PALATAL HOOKLATIN SMALL LETTER M WITH PALATAL HOOKLATI" +
	"N SMALL LETTER N WITH PALATAL HOOKLATIN SMALL LETTER P WITH PALATAL HOOK" +
	"LATIN SMALL LETTER R WITH PALATAL HOOKLATIN SMALL LETTER S WITH PALATAL " +
	"HOOKLATIN SMALL LETTER ESH WITH PALATAL HOOKLATIN SMALL LETTER V WITH PA" +
	"LATAL HOOKLATIN SMALL LETTER X WITH PALATAL HOOKLATIN SMALL LETTER Z WIT" +
	"H PALATAL HOOKLATIN SMALL LETTER A WITH RETROFLEX HOOKLATIN SMALL LETTER" +
	" ALPHA WITH RETROFLEX HOOKLATIN SMALL LETTER D WITH HOOK AND TAILLATIN S" +
	"MALL LETTER E WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN E WITH RETROFLE" +
	"X HOOKLATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOKLATIN SMALL " +
	"LETTER SCHWA WITH RETROFLEX HOOKLATIN SMALL LETTER I WITH RETROFLEX HOOK" +
	"LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOKLATIN SMALL LETTER ESH WITH" +
	" RETROFLEX HOOKLATIN SMALL LETTER U WITH RETROFLEX HOOKLATIN SMALL LETTE" +
	"R EZH WITH RETROFLEX HOOKMODIFIER LETTER SMALL TURNED ALPHAMODIFIER LETT" +
	"ER SMALL CMODIFIER LETTER SMALL C WITH CURLMODIFIER LETTER SMALL ETHMODI" +
	"FIER LETTER SMALL REVERSED OPEN EMODIFIER LETTER SMALL FMODIFIER LETTER " +
	"SMALL DOTLESS J WITH STROKEMODIFIER LETTER SMALL SCRIPT GMODIFIER LETTER" +
	" SMALL TURNED HMODIFIER LETTER SMALL I WITH STROKEMODIFIER LETTER SMALL " +
	"IOTAMODIFIER LETTER SMALL CAPITAL IMODIFIER LETTER SMALL CAPITAL I WITH " +
	"STROKEMODIFIER LETTER SMALL J WITH CROSSED-TAILMODIFIER LETTER SMALL L W" +
	"ITH RETROFLEX HOOKMODIFIER LETTER SMALL L WITH PALATAL HOOKMODIFIER LETT" +
	"ER SMALL CAPITAL LMODIFIER LETTER SMALL M WITH HOOKMODIFIER LETTER SMALL" +
	" TURNED M WITH LONG LEGMODIFIER LETTER SMALL N WITH LEFT HOOKMODIFIER LE" +
	"TTER SMALL N WITH RETROFLEX HOOKMODIFIER LETTER SMALL CAPITAL NMODIFIER " +
	"LETTER SMALL BARRED OMODIFIER LETTER SMALL PHIMODIFIER LETTER SMALL S WI" +
	"TH HOOKMODIFIER LETTER SMALL ESHMODIFIER LETTER SMALL T WITH PALATAL HOO" +
	"KMODIFIER LETTER SMALL U BARMODIFIER LETTER SMALL UPSILONMODIFIER LETTER" +
	" SMALL CAPITAL UMODIFIER LETTER SMALL V WITH HOOKMODIFIER LETTER SMALL T" +
	"URNED VMODIFIER LETTER SMALL ZMODIFIER LETTER SMALL Z WITH RETROFLEX HOO" +
	"KMODIFIER LETTER SMALL Z WITH CURLMODIFIER LETTER SMALL EZHMODIFIER LETT" +
	"ER SMALL THETACOMBINING DOTTED GRAVE ACCENTCOMBINING DOTTED ACUTE ACCENT" +
	"COMBINING SNAKE BELOWCOMBINING SUSPENSION MARKCOMBINING MACRON-ACUTECOMB" +
	"INING GRAVE-MACRONCOMBINING MACRON-GRAVECOMBINING ACUTE-MACRONCOMBINING " +
	"GRAVE-ACUTE-GRAVECOMBINING ACUTE-GRAVE-ACUTECOMBINING LATIN SMALL LETTER" +
	" R BELOWCOMBINING BREVE-MACRONCOMBINING MACRON-BREVECOMBINING DOUBLE CIR" +
	"CUMFLEX ABOVECOMBINING OGONEK ABOVECOMBINING ZIGZAG BELOWCOMBINING IS BE" +
	"LOWCOMBINING UR ABOVECOMBINING US ABOVECOMBINING LATIN SMALL LETTER FLAT" +
	"TENED OPEN A ABOVECOMBINING LATIN SMALL LETTER AECOMBINING LATIN SMALL L" +
	"ETTER AOCOMBINING LATIN SMALL LETTER AVCOMBINING LATIN SMALL LETTER C CE" +
	"DILLACOMBINING LATIN SMALL LETTER INSULAR DCOMBINING LATIN SMALL LETTER " +
	"ETHCOMBINING LATIN SMALL LETTER GCOMBINING LATIN LETTER SMALL CAPITAL GC" +
	"OMBINING LATIN SMALL LETTER KCOMBINING LATIN SMALL LETTER LCOMBINING LAT" +
	"IN LETTER SMALL CAPITAL LCOMBINING LATIN LETTER SMALL CAPITAL MCOMBINING" +
	" LATIN SMALL LETTER NCOMBINING LATIN LETTER SMALL CAPITAL NCOMBINING LAT" +
	"IN LETTER SMALL CAPITAL RCOMBINING LATIN SMALL LETTER R ROTUNDACOMBINING" +
	" LATIN SMALL LETTER SCOMBINING LATIN SMALL LETTER LONG SCOMBINING LATIN " +
	"SMALL LETTER ZCOMBINING LATIN SMALL LETTER ALPHACOMBINING LATIN SMALL LE" +
	"TTER BCOMBINING LATIN SMALL LETTER BETACOMBINING LATIN SMALL LETTER SCHW" +
	"ACOMBINING LATIN SMALL LETTER FCOMBINING LATIN SMALL LETTER L WITH DOUBL" +
	"E MIDDLE TILDECOMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION S") + ("" +
	"TROKECOMBINING LATIN SMALL LETTER PCOMBINING LATIN SMALL LETTER ESHCOMBI" +
	"NING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKECOMBINING LATI" +
	"N SMALL LETTER WCOMBINING LATIN SMALL LETTER A WITH DIAERESISCOMBINING L" +
	"ATIN SMALL LETTER O WITH DIAERESISCOMBINING LATIN SMALL LETTER U WITH DI" +
	"AERESISCOMBINING UP TACK ABOVECOMBINING KAVYKA ABOVE RIGHTCOMBINING KAVY" +
	"KA ABOVE LEFTCOMBINING DOT ABOVE LEFTCOMBINING WIDE INVERTED BRIDGE BELO" +
	"WCOMBINING DOT BELOW LEFTCOMBINING DELETION MARKCOMBINING DOUBLE INVERTE" +
	"D BREVE BELOWCOMBINING ALMOST EQUAL TO BELOWCOMBINING LEFT ARROWHEAD ABO" +
	"VECOMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOWLATIN CAPITAL LETTER" +
	" A WITH RING BELOWLATIN SMALL LETTER A WITH RING BELOWLATIN CAPITAL LETT" +
	"ER B WITH DOT ABOVELATIN SMALL LETTER B WITH DOT ABOVELATIN CAPITAL LETT" +
	"ER B WITH DOT BELOWLATIN SMALL LETTER B WITH DOT BELOWLATIN CAPITAL LETT" +
	"ER B WITH LINE BELOWLATIN SMALL LETTER B WITH LINE BELOWLATIN CAPITAL LE" +
	"TTER C WITH CEDILLA AND ACUTELATIN SMALL LETTER C WITH CEDILLA AND ACUTE" +
	"LATIN CAPITAL LETTER D WITH DOT ABOVELATIN SMALL LETTER D WITH DOT ABOVE" +
	"LATIN CAPITAL LETTER D WITH DOT BELOWLATIN SMALL LETTER D WITH DOT BELOW" +
	"LATIN CAPITAL LETTER D WITH LINE BELOWLATIN SMALL LETTER D WITH LINE BEL" +
	"OWLATIN CAPITAL LETTER D WITH CEDILLALATIN SMALL LETTER D WITH CEDILLALA" +
	"TIN CAPITAL LETTER D WITH CIRCUMFLEX BELOWLATIN SMALL LETTER D WITH CIRC" +
	"UMFLEX BELOWLATIN CAPITAL LETTER E WITH MACRON AND GRAVELATIN SMALL LETT" +
	"ER E WITH MACRON AND GRAVELATIN CAPITAL LETTER E WITH MACRON AND ACUTELA" +
	"TIN SMALL LETTER E WITH MACRON AND ACUTELATIN CAPITAL LETTER E WITH CIRC" +
	"UMFLEX BELOWLATIN SMALL LETTER E WITH CIRCUMFLEX BELOWLATIN CAPITAL LETT" +
	"ER E WITH TILDE BELOWLATIN SMALL LETTER E WITH TILDE BELOWLATIN CAPITAL " +
	"LETTER E WITH CEDILLA AND BREVELATIN SMALL LETTER E WITH CEDILLA AND BRE" +
	"VELATIN CAPITAL LETTER F WITH DOT ABOVELATIN SMALL LETTER F WITH DOT ABO" +
	"VELATIN CAPITAL LETTER G WITH MACRONLATIN SMALL LETTER G WITH MACRONLATI" +
	"N CAPITAL LETTER H WITH DOT ABOVELATIN SMALL LETTER H WITH DOT ABOVELATI" +
	"N CAPITAL LETTER H WITH DOT BELOWLATIN SMALL LETTER H WITH DOT BELOWLATI" +
	"N CAPITAL LETTER H WITH DIAERESISLATIN SMALL LETTER H WITH DIAERESISLATI" +
	"N CAPITAL LETTER H WITH CEDILLALATIN SMALL LETTER H WITH CEDILLALATIN CA" +
	"PITAL LETTER H WITH BREVE BELOWLATIN SMALL LETTER H WITH BREVE BELOWLATI" +
	"N CAPITAL LETTER I WITH TILDE BELOWLATIN SMALL LETTER I WITH TILDE BELOW" +
	"LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTELATIN SMALL LETTER I WITH" +
	" DIAERESIS AND ACUTELATIN CAPITAL LETTER K WITH ACUTELATIN SMALL LETTER " +
	"K WITH ACUTELATIN CAPITAL LETTER K WITH DOT BELOWLATIN SMALL LETTER K WI" +
	"TH DOT BELOWLATIN CAPITAL LETTER K WITH LINE BELOWLATIN SMALL LETTER K W" +
	"ITH LINE BELOWLATIN CAPITAL LETTER L WITH DOT BELOWLATIN SMALL LETTER L " +
	"WITH DOT BELOWLATIN CAPITAL LETTER L WITH DOT BELOW AND MACRONLATIN SMAL" +
	"L LETTER L WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER L WITH LINE BEL" +
	"OWLATIN SMALL LETTER L WITH LINE BELOWLATIN CAPITAL LETTER L WITH CIRCUM" +
	"FLEX BELOWLATIN SMALL LETTER L WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER" +
	" M WITH ACUTELATIN SMALL LETTER M WITH ACUTELATIN CAPITAL LETTER M WITH " +
	"DOT ABOVELATIN SMALL LETTER M WITH DOT ABOVELATIN CAPITAL LETTER M WITH " +
	"DOT BELOWLATIN SMALL LETTER M WITH DOT BELOWLATIN CAPITAL LETTER N WITH " +
	"DOT ABOVELATIN SMALL LETTER N WITH DOT ABOVELATIN CAPITAL LETTER N WITH " +
	"DOT BELOWLATIN SMALL LETTER N WITH DOT BELOWLATIN CAPITAL LETTER N WITH " +
	"LINE BELOWLATIN SMALL LETTER N WITH LINE BELOWLATIN CAPITAL LETTER N WIT" +
	"H CIRCUMFLEX BELOWLATIN SMALL LETTER N WITH CIRCUMFLEX BELOWLATIN CAPITA" +
	"L LETTER O WITH TILDE AND ACUTELATIN SMALL LETTER O WITH TILDE AND ACUTE" +
	"LATIN CAPITAL LETTER O WITH TILDE AND DIAERESISLATIN SMALL LETTER O WITH" +
	" TILDE AND DIAERESISLATIN CAPITAL LETTER O WITH MACRON AND GRAVELATIN SM" +
	"ALL LETTER O WITH MACRON AND GRAVELATIN CAPITAL LETTER O WITH MACRON AND" +
	" ACUTELATIN SMALL LETTER O WITH MACRON AND ACUTELATIN CAPITAL LETTER P W" +
	"ITH ACUTELATIN SMALL LETTER P WITH ACUTELATIN CAPITAL LETTER P WITH DOT " +
	"ABOVELATIN SMALL LETTER P WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT " +
	"ABOVELATIN SMALL LETTER R WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT " +
	"BELOWLATIN SMALL LETTER R WITH DOT BELOWLATIN CAPITAL LETTER R WITH DOT " +
	"BELOW AND MACRONLATIN SMALL LETTER R WITH DOT BELOW AND MACRONLATIN CAPI" +
	"TAL LETTER R WITH LINE BELOWLATIN SMALL LETTER R WITH LINE BELOWLATIN CA" +
	"PITAL LETTER S WITH DOT ABOVELATIN SMALL LETTER S WITH DOT ABOVELATIN CA" +
	"PITAL LETTER S WITH DOT BELOWLATIN SMALL LETTER S WITH DOT BELOWLATIN CA" +
	"PITAL LETTER S WITH ACUTE AND DOT ABOVELATIN SMALL LETTER S WITH ACUTE A" +
	"ND DOT ABOVELATIN CAPITAL LETTER S WITH CARON AND DOT ABOVELATIN SMALL L") + ("" +
	"ETTER S WITH CARON AND DOT ABOVELATIN CAPITAL LETTER S WITH DOT BELOW AN" +
	"D DOT ABOVELATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVELATIN CAPITA" +
	"L LETTER T WITH DOT ABOVELATIN SMALL LETTER T WITH DOT ABOVELATIN CAPITA" +
	"L LETTER T WITH DOT BELOWLATIN SMALL LETTER T WITH DOT BELOWLATIN CAPITA" +
	"L LETTER T WITH LINE BELOWLATIN SMALL LETTER T WITH LINE BELOWLATIN CAPI" +
	"TAL LETTER T WITH CIRCUMFLEX BELOWLATIN SMALL LETTER T WITH CIRCUMFLEX B" +
	"ELOWLATIN CAPITAL LETTER U WITH DIAERESIS BELOWLATIN SMALL LETTER U WITH" +
	" DIAERESIS BELOWLATIN CAPITAL LETTER U WITH TILDE BELOWLATIN SMALL LETTE" +
	"R U WITH TILDE BELOWLATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOWLATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH TILDE AND " +
	"ACUTELATIN SMALL LETTER U WITH TILDE AND ACUTELATIN CAPITAL LETTER U WIT" +
	"H MACRON AND DIAERESISLATIN SMALL LETTER U WITH MACRON AND DIAERESISLATI" +
	"N CAPITAL LETTER V WITH TILDELATIN SMALL LETTER V WITH TILDELATIN CAPITA" +
	"L LETTER V WITH DOT BELOWLATIN SMALL LETTER V WITH DOT BELOWLATIN CAPITA" +
	"L LETTER W WITH GRAVELATIN SMALL LETTER W WITH GRAVELATIN CAPITAL LETTER" +
	" W WITH ACUTELATIN SMALL LETTER W WITH ACUTELATIN CAPITAL LETTER W WITH " +
	"DIAERESISLATIN SMALL LETTER W WITH DIAERESISLATIN CAPITAL LETTER W WITH " +
	"DOT ABOVELATIN SMALL LETTER W WITH DOT ABOVELATIN CAPITAL LETTER W WITH " +
	"DOT BELOWLATIN SMALL LETTER W WITH DOT BELOWLATIN CAPITAL LETTER X WITH " +
	"DOT ABOVELATIN SMALL LETTER X WITH DOT ABOVELATIN CAPITAL LETTER X WITH " +
	"DIAERESISLATIN SMALL LETTER X WITH DIAERESISLATIN CAPITAL LETTER Y WITH " +
	"DOT ABOVELATIN SMALL LETTER Y WITH DOT ABOVELATIN CAPITAL LETTER Z WITH " +
	"CIRCUMFLEXLATIN SMALL LETTER Z WITH CIRCUMFLEXLATIN CAPITAL LETTER Z WIT" +
	"H DOT BELOWLATIN SMALL LETTER Z WITH DOT BELOWLATIN CAPITAL LETTER Z WIT" +
	"H LINE BELOWLATIN SMALL LETTER Z WITH LINE BELOWLATIN SMALL LETTER H WIT" +
	"H LINE BELOWLATIN SMALL LETTER T WITH DIAERESISLATIN SMALL LETTER W WITH" +
	" RING ABOVELATIN SMALL LETTER Y WITH RING ABOVELATIN SMALL LETTER A WITH" +
	" RIGHT HALF RINGLATIN SMALL LETTER LONG S WITH DOT ABOVELATIN SMALL LETT" +
	"ER LONG S WITH DIAGONAL STROKELATIN SMALL LETTER LONG S WITH HIGH STROKE" +
	"LATIN CAPITAL LETTER SHARP SLATIN SMALL LETTER DELTALATIN CAPITAL LETTER" +
	" A WITH DOT BELOWLATIN SMALL LETTER A WITH DOT BELOWLATIN CAPITAL LETTER" +
	" A WITH HOOK ABOVELATIN SMALL LETTER A WITH HOOK ABOVELATIN CAPITAL LETT" +
	"ER A WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER A WITH CIRCUMFLEX AND A" +
	"CUTELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER A" +
	" WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOO" +
	"K ABOVELATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL " +
	"LETTER A WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER A WITH CIRCUMFLEX A" +
	"ND TILDELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL " +
	"LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER A WITH BREVE " +
	"AND ACUTELATIN SMALL LETTER A WITH BREVE AND ACUTELATIN CAPITAL LETTER A" +
	" WITH BREVE AND GRAVELATIN SMALL LETTER A WITH BREVE AND GRAVELATIN CAPI" +
	"TAL LETTER A WITH BREVE AND HOOK ABOVELATIN SMALL LETTER A WITH BREVE AN" +
	"D HOOK ABOVELATIN CAPITAL LETTER A WITH BREVE AND TILDELATIN SMALL LETTE" +
	"R A WITH BREVE AND TILDELATIN CAPITAL LETTER A WITH BREVE AND DOT BELOWL" +
	"ATIN SMALL LETTER A WITH BREVE AND DOT BELOWLATIN CAPITAL LETTER E WITH " +
	"DOT BELOWLATIN SMALL LETTER E WITH DOT BELOWLATIN CAPITAL LETTER E WITH " +
	"HOOK ABOVELATIN SMALL LETTER E WITH HOOK ABOVELATIN CAPITAL LETTER E WIT" +
	"H TILDELATIN SMALL LETTER E WITH TILDELATIN CAPITAL LETTER E WITH CIRCUM" +
	"FLEX AND ACUTELATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTELATIN CAPITA" +
	"L LETTER E WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER E WITH CIRCUMFLEX" +
	" AND GRAVELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN SMA" +
	"LL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER E WITH CI" +
	"RCUMFLEX AND TILDELATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDELATIN CA" +
	"PITAL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER E WITH CI" +
	"RCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER I WITH HOOK ABOVELATIN SMALL " +
	"LETTER I WITH HOOK ABOVELATIN CAPITAL LETTER I WITH DOT BELOWLATIN SMALL" +
	" LETTER I WITH DOT BELOWLATIN CAPITAL LETTER O WITH DOT BELOWLATIN SMALL" +
	" LETTER O WITH DOT BELOWLATIN CAPITAL LETTER O WITH HOOK ABOVELATIN SMAL" +
	"L LETTER O WITH HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACU" +
	"TELATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER O W" +
	"ITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVELA" +
	"TIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER O " +
	"WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND" +
	" TILDELATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER") + ("" +
	" O WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER O WITH CIRCUMFLEX AND" +
	" DOT BELOWLATIN CAPITAL LETTER O WITH HORN AND ACUTELATIN SMALL LETTER O" +
	" WITH HORN AND ACUTELATIN CAPITAL LETTER O WITH HORN AND GRAVELATIN SMAL" +
	"L LETTER O WITH HORN AND GRAVELATIN CAPITAL LETTER O WITH HORN AND HOOK " +
	"ABOVELATIN SMALL LETTER O WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER O" +
	" WITH HORN AND TILDELATIN SMALL LETTER O WITH HORN AND TILDELATIN CAPITA" +
	"L LETTER O WITH HORN AND DOT BELOWLATIN SMALL LETTER O WITH HORN AND DOT" +
	" BELOWLATIN CAPITAL LETTER U WITH DOT BELOWLATIN SMALL LETTER U WITH DOT" +
	" BELOWLATIN CAPITAL LETTER U WITH HOOK ABOVELATIN SMALL LETTER U WITH HO" +
	"OK ABOVELATIN CAPITAL LETTER U WITH HORN AND ACUTELATIN SMALL LETTER U W" +
	"ITH HORN AND ACUTELATIN CAPITAL LETTER U WITH HORN AND GRAVELATIN SMALL " +
	"LETTER U WITH HORN AND GRAVELATIN CAPITAL LETTER U WITH HORN AND HOOK AB" +
	"OVELATIN SMALL LETTER U WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER U W" +
	"ITH HORN AND TILDELATIN SMALL LETTER U WITH HORN AND TILDELATIN CAPITAL " +
	"LETTER U WITH HORN AND DOT BELOWLATIN SMALL LETTER U WITH HORN AND DOT B" +
	"ELOWLATIN CAPITAL LETTER Y WITH GRAVELATIN SMALL LETTER Y WITH GRAVELATI" +
	"N CAPITAL LETTER Y WITH DOT BELOWLATIN SMALL LETTER Y WITH DOT BELOWLATI" +
	"N CAPITAL LETTER Y WITH HOOK ABOVELATIN SMALL LETTER Y WITH HOOK ABOVELA" +
	"TIN CAPITAL LETTER Y WITH TILDELATIN SMALL LETTER Y WITH TILDELATIN CAPI" +
	"TAL LETTER MIDDLE-WELSH LLLATIN SMALL LETTER MIDDLE-WELSH LLLATIN CAPITA" +
	"L LETTER MIDDLE-WELSH VLATIN SMALL LETTER MIDDLE-WELSH VLATIN CAPITAL LE" +
	"TTER Y WITH LOOPLATIN SMALL LETTER Y WITH LOOPGREEK SMALL LETTER ALPHA W" +
	"ITH PSILIGREEK SMALL LETTER ALPHA WITH DASIAGREEK SMALL LETTER ALPHA WIT" +
	"H PSILI AND VARIAGREEK SMALL LETTER ALPHA WITH DASIA AND VARIAGREEK SMAL" +
	"L LETTER ALPHA WITH PSILI AND OXIAGREEK SMALL LETTER ALPHA WITH DASIA AN" +
	"D OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK SMALL LET" +
	"TER ALPHA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH PSIL" +
	"IGREEK CAPITAL LETTER ALPHA WITH DASIAGREEK CAPITAL LETTER ALPHA WITH PS" +
	"ILI AND VARIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIAGREEK CAPITA" +
	"L LETTER ALPHA WITH PSILI AND OXIAGREEK CAPITAL LETTER ALPHA WITH DASIA " +
	"AND OXIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK CAPIT" +
	"AL LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER EPSILON WIT" +
	"H PSILIGREEK SMALL LETTER EPSILON WITH DASIAGREEK SMALL LETTER EPSILON W" +
	"ITH PSILI AND VARIAGREEK SMALL LETTER EPSILON WITH DASIA AND VARIAGREEK " +
	"SMALL LETTER EPSILON WITH PSILI AND OXIAGREEK SMALL LETTER EPSILON WITH " +
	"DASIA AND OXIAGREEK CAPITAL LETTER EPSILON WITH PSILIGREEK CAPITAL LETTE" +
	"R EPSILON WITH DASIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIAGRE" +
	"EK CAPITAL LETTER EPSILON WITH DASIA AND VARIAGREEK CAPITAL LETTER EPSIL" +
	"ON WITH PSILI AND OXIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIAGR" +
	"EEK SMALL LETTER ETA WITH PSILIGREEK SMALL LETTER ETA WITH DASIAGREEK SM" +
	"ALL LETTER ETA WITH PSILI AND VARIAGREEK SMALL LETTER ETA WITH DASIA AND" +
	" VARIAGREEK SMALL LETTER ETA WITH PSILI AND OXIAGREEK SMALL LETTER ETA W" +
	"ITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENIGREEK" +
	" SMALL LETTER ETA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ETA WIT" +
	"H PSILIGREEK CAPITAL LETTER ETA WITH DASIAGREEK CAPITAL LETTER ETA WITH " +
	"PSILI AND VARIAGREEK CAPITAL LETTER ETA WITH DASIA AND VARIAGREEK CAPITA" +
	"L LETTER ETA WITH PSILI AND OXIAGREEK CAPITAL LETTER ETA WITH DASIA AND " +
	"OXIAGREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENIGREEK CAPITAL LET" +
	"TER ETA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER IOTA WITH PSILIGREE" +
	"K SMALL LETTER IOTA WITH DASIAGREEK SMALL LETTER IOTA WITH PSILI AND VAR" +
	"IAGREEK SMALL LETTER IOTA WITH DASIA AND VARIAGREEK SMALL LETTER IOTA WI" +
	"TH PSILI AND OXIAGREEK SMALL LETTER IOTA WITH DASIA AND OXIAGREEK SMALL " +
	"LETTER IOTA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA WITH DASIA" +
	" AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH PSILIGREEK CAPITAL LETTER" +
	" IOTA WITH DASIAGREEK CAPITAL LETTER IOTA WITH PSILI AND VARIAGREEK CAPI" +
	"TAL LETTER IOTA WITH DASIA AND VARIAGREEK CAPITAL LETTER IOTA WITH PSILI" +
	" AND OXIAGREEK CAPITAL LETTER IOTA WITH DASIA AND OXIAGREEK CAPITAL LETT" +
	"ER IOTA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH DASIA A" +
	"ND PERISPOMENIGREEK SMALL LETTER OMICRON WITH PSILIGREEK SMALL LETTER OM" +
	"ICRON WITH DASIAGREEK SMALL LETTER OMICRON WITH PSILI AND VARIAGREEK SMA" +
	"LL LETTER OMICRON WITH DASIA AND VARIAGREEK SMALL LETTER OMICRON WITH PS" +
	"ILI AND OXIAGREEK SMALL LETTER OMICRON WITH DASIA AND OXIAGREEK CAPITAL " +
	"LETTER OMICRON WITH PSILIGREEK CAPITAL LETTER OMICRON WITH DASIAGREEK CA" +
	"PITAL LETTER OMICRON WITH PSILI AND VARIAGREEK CAPITAL LETTER OMICRON WI") + ("" +
	"TH DASIA AND VARIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIAGREEK " +
	"CAPITAL LETTER OMICRON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON WIT" +
	"H PSILIGREEK SMALL LETTER UPSILON WITH DASIAGREEK SMALL LETTER UPSILON W" +
	"ITH PSILI AND VARIAGREEK SMALL LETTER UPSILON WITH DASIA AND VARIAGREEK " +
	"SMALL LETTER UPSILON WITH PSILI AND OXIAGREEK SMALL LETTER UPSILON WITH " +
	"DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENIGREEK" +
	" SMALL LETTER UPSILON WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER UPS" +
	"ILON WITH DASIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIAGREEK CA" +
	"PITAL LETTER UPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER UPSILON WIT" +
	"H DASIA AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH PSILIGREEK SMALL LE" +
	"TTER OMEGA WITH DASIAGREEK SMALL LETTER OMEGA WITH PSILI AND VARIAGREEK " +
	"SMALL LETTER OMEGA WITH DASIA AND VARIAGREEK SMALL LETTER OMEGA WITH PSI" +
	"LI AND OXIAGREEK SMALL LETTER OMEGA WITH DASIA AND OXIAGREEK SMALL LETTE" +
	"R OMEGA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH DASIA AN" +
	"D PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH PSILIGREEK CAPITAL LETTER O" +
	"MEGA WITH DASIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIAGREEK CAPI" +
	"TAL LETTER OMEGA WITH DASIA AND VARIAGREEK CAPITAL LETTER OMEGA WITH PSI" +
	"LI AND OXIAGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIAGREEK CAPITAL L" +
	"ETTER OMEGA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH DA" +
	"SIA AND PERISPOMENIGREEK SMALL LETTER ALPHA WITH VARIAGREEK SMALL LETTER" +
	" ALPHA WITH OXIAGREEK SMALL LETTER EPSILON WITH VARIAGREEK SMALL LETTER " +
	"EPSILON WITH OXIAGREEK SMALL LETTER ETA WITH VARIAGREEK SMALL LETTER ETA" +
	" WITH OXIAGREEK SMALL LETTER IOTA WITH VARIAGREEK SMALL LETTER IOTA WITH" +
	" OXIAGREEK SMALL LETTER OMICRON WITH VARIAGREEK SMALL LETTER OMICRON WIT" +
	"H OXIAGREEK SMALL LETTER UPSILON WITH VARIAGREEK SMALL LETTER UPSILON WI" +
	"TH OXIAGREEK SMALL LETTER OMEGA WITH VARIAGREEK SMALL LETTER OMEGA WITH " +
	"OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LET" +
	"TER ALPHA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSIL" +
	"I AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND VAR" +
	"IA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPO" +
	"GEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI" +
	"GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGRE" +
	"EK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK " +
	"CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER A" +
	"LPHA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI " +
	"AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND VA" +
	"RIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND" +
	" PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGE" +
	"GRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGE" +
	"GRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGE" +
	"GRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL L" +
	"ETTER ETA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI " +
	"AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND VARIA A" +
	"ND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAM" +
	"MENIGREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SM" +
	"ALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL L" +
	"ETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETT" +
	"ER ETA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA " +
	"AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROS" +
	"GEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMME" +
	"NIGREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK C" +
	"APITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LE" +
	"TTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETT" +
	"ER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER O" +
	"MEGA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND" +
	" YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRA" +
	"MMENIGREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREE" +
	"K SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LE" +
	"TTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA" +
	" WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WI" +
	"TH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMEGA WIT" +
	"H PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PROS" +
	"GEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAM" +
	"MENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENIGR") + ("" +
	"EEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAP" +
	"ITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LE" +
	"TTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LE" +
	"TTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETT" +
	"ER ALPHA WITH VRACHYGREEK SMALL LETTER ALPHA WITH MACRONGREEK SMALL LETT" +
	"ER ALPHA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH YPOGE" +
	"GRAMMENIGREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL " +
	"LETTER ALPHA WITH PERISPOMENIGREEK SMALL LETTER ALPHA WITH PERISPOMENI A" +
	"ND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH VRACHYGREEK CAPITAL LETT" +
	"ER ALPHA WITH MACRONGREEK CAPITAL LETTER ALPHA WITH VARIAGREEK CAPITAL L" +
	"ETTER ALPHA WITH OXIAGREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENIGREEK" +
	" KORONISGREEK PROSGEGRAMMENIGREEK PSILIGREEK PERISPOMENIGREEK DIALYTIKA " +
	"AND PERISPOMENIGREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENIGREEK " +
	"SMALL LETTER ETA WITH YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH OXIA AND " +
	"YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PERISPOMENIGREEK SMALL LETTER E" +
	"TA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER EPSILON WITH V" +
	"ARIAGREEK CAPITAL LETTER EPSILON WITH OXIAGREEK CAPITAL LETTER ETA WITH " +
	"VARIAGREEK CAPITAL LETTER ETA WITH OXIAGREEK CAPITAL LETTER ETA WITH PRO" +
	"SGEGRAMMENIGREEK PSILI AND VARIAGREEK PSILI AND OXIAGREEK PSILI AND PERI" +
	"SPOMENIGREEK SMALL LETTER IOTA WITH VRACHYGREEK SMALL LETTER IOTA WITH M" +
	"ACRONGREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIAGREEK SMALL LETTER " +
	"IOTA WITH DIALYTIKA AND OXIAGREEK SMALL LETTER IOTA WITH PERISPOMENIGREE" +
	"K SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER I" +
	"OTA WITH VRACHYGREEK CAPITAL LETTER IOTA WITH MACRONGREEK CAPITAL LETTER" +
	" IOTA WITH VARIAGREEK CAPITAL LETTER IOTA WITH OXIAGREEK DASIA AND VARIA" +
	"GREEK DASIA AND OXIAGREEK DASIA AND PERISPOMENIGREEK SMALL LETTER UPSILO" +
	"N WITH VRACHYGREEK SMALL LETTER UPSILON WITH MACRONGREEK SMALL LETTER UP" +
	"SILON WITH DIALYTIKA AND VARIAGREEK SMALL LETTER UPSILON WITH DIALYTIKA " +
	"AND OXIAGREEK SMALL LETTER RHO WITH PSILIGREEK SMALL LETTER RHO WITH DAS" +
	"IAGREEK SMALL LETTER UPSILON WITH PERISPOMENIGREEK SMALL LETTER UPSILON " +
	"WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH VRACHYGR" +
	"EEK CAPITAL LETTER UPSILON WITH MACRONGREEK CAPITAL LETTER UPSILON WITH " +
	"VARIAGREEK CAPITAL LETTER UPSILON WITH OXIAGREEK CAPITAL LETTER RHO WITH" +
	" DASIAGREEK DIALYTIKA AND VARIAGREEK DIALYTIKA AND OXIAGREEK VARIAGREEK " +
	"SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA " +
	"WITH YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENIGR" +
	"EEK SMALL LETTER OMEGA WITH PERISPOMENIGREEK SMALL LETTER OMEGA WITH PER" +
	"ISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMICRON WITH VARIAGREEK C" +
	"APITAL LETTER OMICRON WITH OXIAGREEK CAPITAL LETTER OMEGA WITH VARIAGREE" +
	"K CAPITAL LETTER OMEGA WITH OXIAGREEK CAPITAL LETTER OMEGA WITH PROSGEGR" +
	"AMMENIGREEK OXIAGREEK DASIAEN QUADEM QUADEN SPACEEM SPACETHREE-PER-EM SP" +
	"ACEFOUR-PER-EM SPACESIX-PER-EM SPACEFIGURE SPACEPUNCTUATION SPACETHIN SP" +
	"ACEHAIR SPACEZERO WIDTH SPACEZERO WIDTH NON-JOINERZERO WIDTH JOINERLEFT-" +
	"TO-RIGHT MARKRIGHT-TO-LEFT MARKHYPHENNON-BREAKING HYPHENFIGURE DASHEN DA" +
	"SHEM DASHHORIZONTAL BARDOUBLE VERTICAL LINEDOUBLE LOW LINELEFT SINGLE QU" +
	"OTATION MARKRIGHT SINGLE QUOTATION MARKSINGLE LOW-9 QUOTATION MARKSINGLE" +
	" HIGH-REVERSED-9 QUOTATION MARKLEFT DOUBLE QUOTATION MARKRIGHT DOUBLE QU" +
	"OTATION MARKDOUBLE LOW-9 QUOTATION MARKDOUBLE HIGH-REVERSED-9 QUOTATION " +
	"MARKDAGGERDOUBLE DAGGERBULLETTRIANGULAR BULLETONE DOT LEADERTWO DOT LEAD" +
	"ERHORIZONTAL ELLIPSISHYPHENATION POINTLINE SEPARATORPARAGRAPH SEPARATORL" +
	"EFT-TO-RIGHT EMBEDDINGRIGHT-TO-LEFT EMBEDDINGPOP DIRECTIONAL FORMATTINGL" +
	"EFT-TO-RIGHT OVERRIDERIGHT-TO-LEFT OVERRIDENARROW NO-BREAK SPACEPER MILL" +
	"E SIGNPER TEN THOUSAND SIGNPRIMEDOUBLE PRIMETRIPLE PRIMEREVERSED PRIMERE" +
	"VERSED DOUBLE PRIMEREVERSED TRIPLE PRIMECARETSINGLE LEFT-POINTING ANGLE " +
	"QUOTATION MARKSINGLE RIGHT-POINTING ANGLE QUOTATION MARKREFERENCE MARKDO" +
	"UBLE EXCLAMATION MARKINTERROBANGOVERLINEUNDERTIECHARACTER TIECARET INSER" +
	"TION POINTASTERISMHYPHEN BULLETFRACTION SLASHLEFT SQUARE BRACKET WITH QU" +
	"ILLRIGHT SQUARE BRACKET WITH QUILLDOUBLE QUESTION MARKQUESTION EXCLAMATI" +
	"ON MARKEXCLAMATION QUESTION MARKTIRONIAN SIGN ETREVERSED PILCROW SIGNBLA" +
	"CK LEFTWARDS BULLETBLACK RIGHTWARDS BULLETLOW ASTERISKREVERSED SEMICOLON" +
	"CLOSE UPTWO ASTERISKS ALIGNED VERTICALLYCOMMERCIAL MINUS SIGNSWUNG DASHI" +
	"NVERTED UNDERTIEFLOWER PUNCTUATION MARKTHREE DOT PUNCTUATIONQUADRUPLE PR" +
	"IMEFOUR DOT PUNCTUATIONFIVE DOT PUNCTUATIONTWO DOT PUNCTUATIONFOUR DOT M" +
	"ARKDOTTED CROSSTRICOLONVERTICAL FOUR DOTSMEDIUM MATHEMATICAL SPACEWORD J") + ("" +
	"OINERFUNCTION APPLICATIONINVISIBLE TIMESINVISIBLE SEPARATORINVISIBLE PLU" +
	"SLEFT-TO-RIGHT ISOLATERIGHT-TO-LEFT ISOLATEFIRST STRONG ISOLATEPOP DIREC" +
	"TIONAL ISOLATEINHIBIT SYMMETRIC SWAPPINGACTIVATE SYMMETRIC SWAPPINGINHIB" +
	"IT ARABIC FORM SHAPINGACTIVATE ARABIC FORM SHAPINGNATIONAL DIGIT SHAPESN" +
	"OMINAL DIGIT SHAPESSUPERSCRIPT ZEROSUPERSCRIPT LATIN SMALL LETTER ISUPER" +
	"SCRIPT FOURSUPERSCRIPT FIVESUPERSCRIPT SIXSUPERSCRIPT SEVENSUPERSCRIPT E" +
	"IGHTSUPERSCRIPT NINESUPERSCRIPT PLUS SIGNSUPERSCRIPT MINUSSUPERSCRIPT EQ" +
	"UALS SIGNSUPERSCRIPT LEFT PARENTHESISSUPERSCRIPT RIGHT PARENTHESISSUPERS" +
	"CRIPT LATIN SMALL LETTER NSUBSCRIPT ZEROSUBSCRIPT ONESUBSCRIPT TWOSUBSCR" +
	"IPT THREESUBSCRIPT FOURSUBSCRIPT FIVESUBSCRIPT SIXSUBSCRIPT SEVENSUBSCRI" +
	"PT EIGHTSUBSCRIPT NINESUBSCRIPT PLUS SIGNSUBSCRIPT MINUSSUBSCRIPT EQUALS" +
	" SIGNSUBSCRIPT LEFT PARENTHESISSUBSCRIPT RIGHT PARENTHESISLATIN SUBSCRIP" +
	"T SMALL LETTER ALATIN SUBSCRIPT SMALL LETTER ELATIN SUBSCRIPT SMALL LETT" +
	"ER OLATIN SUBSCRIPT SMALL LETTER XLATIN SUBSCRIPT SMALL LETTER SCHWALATI" +
	"N SUBSCRIPT SMALL LETTER HLATIN SUBSCRIPT SMALL LETTER KLATIN SUBSCRIPT " +
	"SMALL LETTER LLATIN SUBSCRIPT SMALL LETTER MLATIN SUBSCRIPT SMALL LETTER" +
	" NLATIN SUBSCRIPT SMALL LETTER PLATIN SUBSCRIPT SMALL LETTER SLATIN SUBS" +
	"CRIPT SMALL LETTER TEURO-CURRENCY SIGNCOLON SIGNCRUZEIRO SIGNFRENCH FRAN" +
	"C SIGNLIRA SIGNMILL SIGNNAIRA SIGNPESETA SIGNRUPEE SIGNWON SIGNNEW SHEQE" +
	"L SIGNDONG SIGNEURO SIGNKIP SIGNTUGRIK SIGNDRACHMA SIGNGERMAN PENNY SIGN" +
	"PESO SIGNGUARANI SIGNAUSTRAL SIGNHRYVNIA SIGNCEDI SIGNLIVRE TOURNOIS SIG" +
	"NSPESMILO SIGNTENGE SIGNINDIAN RUPEE SIGNTURKISH LIRA SIGNNORDIC MARK SI" +
	"GNMANAT SIGNRUBLE SIGNLARI SIGNBITCOIN SIGNSOM SIGNCOMBINING LEFT HARPOO" +
	"N ABOVECOMBINING RIGHT HARPOON ABOVECOMBINING LONG VERTICAL LINE OVERLAY" +
	"COMBINING SHORT VERTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE ARROW ABOVE" +
	"COMBINING CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW ABOVECOMBINING RIGHT" +
	" ARROW ABOVECOMBINING RING OVERLAYCOMBINING CLOCKWISE RING OVERLAYCOMBIN" +
	"ING ANTICLOCKWISE RING OVERLAYCOMBINING THREE DOTS ABOVECOMBINING FOUR D" +
	"OTS ABOVECOMBINING ENCLOSING CIRCLECOMBINING ENCLOSING SQUARECOMBINING E" +
	"NCLOSING DIAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHCOMBINING LEFT RIGHT" +
	" ARROW ABOVECOMBINING ENCLOSING SCREENCOMBINING ENCLOSING KEYCAPCOMBININ" +
	"G ENCLOSING UPWARD POINTING TRIANGLECOMBINING REVERSE SOLIDUS OVERLAYCOM" +
	"BINING DOUBLE VERTICAL STROKE OVERLAYCOMBINING ANNUITY SYMBOLCOMBINING T" +
	"RIPLE UNDERDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LEFTWARDS ARROW OVERL" +
	"AYCOMBINING LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS HARPOON WITH" +
	" BARB DOWNWARDSCOMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDSCOMBINING " +
	"LEFT ARROW BELOWCOMBINING RIGHT ARROW BELOWCOMBINING ASTERISK ABOVEACCOU" +
	"NT OFADDRESSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE CELSIUSCENTRE" +
	" LINE SYMBOLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRENHEITSCRIPT " +
	"SMALL GSCRIPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK CAPITAL HPLAN" +
	"CK CONSTANTPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-LETTER CAPIT" +
	"AL ISCRIPT CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUCK CAPITAL NN" +
	"UMERO SIGNSOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-STRUCK CAPITAL" +
	" PDOUBLE-STRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITAL RDOUBLE-ST" +
	"RUCK CAPITAL RPRESCRIPTION TAKERESPONSESERVICE MARKTELEPHONE SIGNTRADE M" +
	"ARK SIGNVERSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINVERTED OHM SI" +
	"GNBLACK-LETTER CAPITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN SIGNANGSTRO" +
	"M SIGNSCRIPT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED SYMBOLSCRIPT SMALL" +
	" ESCRIPT CAPITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAPITAL MSCRIPT" +
	" SMALL OALEF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMATION SOURCER" +
	"OTATED CAPITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-STRUCK SMALL " +
	"GAMMADOUBLE-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUBLE-STRUCK N-" +
	"ARY SUMMATIONTURNED SANS-SERIF CAPITAL GTURNED SANS-SERIF CAPITAL LREVER" +
	"SED SANS-SERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-STRUCK ITALIC " +
	"CAPITAL DDOUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SMALL EDOUBLE-" +
	"STRUCK ITALIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LINETURNED AMP" +
	"ERSANDPER SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN SOURCEVULGA" +
	"R FRACTION ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR FRACTION ONE TENTH" +
	"VULGAR FRACTION ONE THIRDVULGAR FRACTION TWO THIRDSVULGAR FRACTION ONE F" +
	"IFTHVULGAR FRACTION TWO FIFTHSVULGAR FRACTION THREE FIFTHSVULGAR FRACTIO" +
	"N FOUR FIFTHSVULGAR FRACTION ONE SIXTHVULGAR FRACTION FIVE SIXTHSVULGAR " +
	"FRACTION ONE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGAR FRACTION FIVE EIG" +
	"HTHSVULGAR FRACTION SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN NUMERAL ONE" +
	"ROMAN NUMERAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOURROMAN NUMERAL FIVE") + ("" +
	"ROMAN NUMERAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN NUMERAL NIN" +
	"EROMAN NUMERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL TWELVEROMAN NUMERAL " +
	"FIFTYROMAN NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMAN NUMERAL ON" +
	"E THOUSANDSMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMALL ROMAN NUME" +
	"RAL THREESMALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMALL ROMAN NUM" +
	"ERAL SIXSMALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSMALL ROMAN NU" +
	"MERAL NINESMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENSMALL ROMAN N" +
	"UMERAL TWELVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ONE HUNDREDSMA" +
	"LL ROMAN NUMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSANDROMAN NUMER" +
	"AL ONE THOUSAND C DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL TEN THOUSAND" +
	"ROMAN NUMERAL REVERSED ONE HUNDREDLATIN SMALL LETTER REVERSED CROMAN NUM" +
	"ERAL SIX LATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERAL FIFTY THOU" +
	"SANDROMAN NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION ZERO THIRDSTURNED " +
	"DIGIT TWOTURNED DIGIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHTWARDS ARROWD" +
	"OWNWARDS ARROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWNORTH EAST AR" +
	"ROWSOUTH EAST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WITH STROKERIGHTWARDS" +
	" ARROW WITH STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWLEFTWARDS TWO" +
	" HEADED ARROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO HEADED ARROWDOWNWARD" +
	"S TWO HEADED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW WITH TAILLEF" +
	"TWARDS ARROW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW FROM BARDOWN" +
	"WARDS ARROW FROM BARUP DOWN ARROW WITH BASELEFTWARDS ARROW WITH HOOKRIGH" +
	"TWARDS ARROW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS ARROW WITH LOO" +
	"PLEFT RIGHT WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS ZIGZAG ARROW" +
	"UPWARDS ARROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHTWARDSDOWNWAR" +
	"DS ARROW WITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWARDSRIGHTWARDS" +
	" ARROW WITH CORNER DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFTWARDSANTICLO" +
	"CKWISE TOP SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNORTH WEST ARRO" +
	"W TO LONG BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BARANTICLOC" +
	"KWISE OPEN CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS HARPOON WITH" +
	" BARB UPWARDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPWARDS HARPOON WITH B" +
	"ARB RIGHTWARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS HARPOON WITH" +
	" BARB UPWARDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS HARPOON WIT" +
	"H BARB RIGHTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS ARROW O" +
	"VER LEFTWARDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROWLEFTWARDS A" +
	"RROW OVER RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAIRED ARROWSRI" +
	"GHTWARDS PAIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPOON OVER RIGH" +
	"TWARDS HARPOONRIGHTWARDS HARPOON OVER LEFTWARDS HARPOONLEFTWARDS DOUBLE " +
	"ARROW WITH STROKELEFT RIGHT DOUBLE ARROW WITH STROKERIGHTWARDS DOUBLE AR" +
	"ROW WITH STROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIGHTWARDS DOUB" +
	"LE ARROWDOWNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN DOUBLE ARRO" +
	"WNORTH WEST DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DOUBLE ARROWSO" +
	"UTH WEST DOUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE ARROWLEFTWA" +
	"RDS SQUIGGLE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WITH DOUBLE STR" +
	"OKEDOWNWARDS ARROW WITH DOUBLE STROKELEFTWARDS DASHED ARROWUPWARDS DASHE" +
	"D ARROWRIGHTWARDS DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARDS ARROW TO B" +
	"ARRIGHTWARDS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE ARROWRIGHTWA" +
	"RDS WHITE ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARROW FROM BARUPWARDS " +
	"WHITE ARROW ON PEDESTALUPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL B" +
	"ARUPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BARUPWARDS WHITE DOUBLE " +
	"ARROWUPWARDS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE ARROW FROM W" +
	"ALLNORTH WEST ARROW TO CORNERSOUTH EAST ARROW TO CORNERUP DOWN WHITE ARR" +
	"OWRIGHT ARROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF UPWARDS ARRO" +
	"WTHREE RIGHTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL STROKERIGHTWARDS A" +
	"RROW WITH VERTICAL STROKELEFT RIGHT ARROW WITH VERTICAL STROKELEFTWARDS " +
	"ARROW WITH DOUBLE VERTICAL STROKERIGHTWARDS ARROW WITH DOUBLE VERTICAL S" +
	"TROKELEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS OPEN-HEADED A" +
	"RROWRIGHTWARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROWFOR ALLCOMPL" +
	"EMENTPARTIAL DIFFERENTIALTHERE EXISTSTHERE DOES NOT EXISTEMPTY SETINCREM" +
	"ENTNABLAELEMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS AS MEMBERDOE" +
	"S NOT CONTAIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF PROOFN-ARY PRODUCT" +
	"N-ARY COPRODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDOT PLUSDIVISI" +
	"ON SLASHSET MINUSASTERISK OPERATORRING OPERATORBULLET OPERATORSQUARE ROO" +
	"TCUBE ROOTFOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLEMEASURED ANG" +
	"LESPHERICAL ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT PARALLEL TOLOGICAL") + ("" +
	" ANDLOGICAL ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE INTEGRALCON" +
	"TOUR INTEGRALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGRALCLOCKWISE " +
	"CONTOUR INTEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAUSERATIOPROPO" +
	"RTIONDOT MINUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPERATORREVERSED" +
	" TILDEINVERTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDEMINUS TILDEASYMPTOT" +
	"ICALLY EQUAL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUAL TOAPPROXIM" +
	"ATELY BUT NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY NOR ACTUALLY EQUAL " +
	"TOALMOST EQUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TOTRIPLE TILDE" +
	"ALL EQUAL TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TODIFFERENCE BETWEENAP" +
	"PROACHES THE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL TO OR THE IM" +
	"AGE OFIMAGE OF OR APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS COLONRING IN " +
	"EQUAL TORING EQUAL TOCORRESPONDS TOESTIMATESEQUIANGULAR TOSTAR EQUALSDEL" +
	"TA EQUAL TOEQUAL TO BY DEFINITIONMEASURED BYQUESTIONED EQUAL TONOT EQUAL" +
	" TOIDENTICAL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-THAN OR EQUAL " +
	"TOGREATER-THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THAN OVER EQUAL" +
	" TOLESS-THAN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMUCH LESS-THAN" +
	"MUCH GREATER-THANBETWEENNOT EQUIVALENT TONOT LESS-THANNOT GREATER-THANNE" +
	"ITHER LESS-THAN NOR EQUAL TONEITHER GREATER-THAN NOR EQUAL TOLESS-THAN O" +
	"R EQUIVALENT TOGREATER-THAN OR EQUIVALENT TONEITHER LESS-THAN NOR EQUIVA" +
	"LENT TONEITHER GREATER-THAN NOR EQUIVALENT TOLESS-THAN OR GREATER-THANGR" +
	"EATER-THAN OR LESS-THANNEITHER LESS-THAN NOR GREATER-THANNEITHER GREATER" +
	"-THAN NOR LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCEEDS OR EQUAL" +
	" TOPRECEDES OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TODOES NOT PRECEDEDOE" +
	"S NOT SUCCEEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A SUPERSET OFSUBSET " +
	"OF OR EQUAL TOSUPERSET OF OR EQUAL TONEITHER A SUBSET OF NOR EQUAL TONEI" +
	"THER A SUPERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSUPERSET OF WI" +
	"TH NOT EQUAL TOMULTISETMULTISET MULTIPLICATIONMULTISET UNIONSQUARE IMAGE" +
	" OFSQUARE ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGINAL OF OR EQ" +
	"UAL TOSQUARE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED TIMESCIRCLED " +
	"DIVISION SLASHCIRCLED DOT OPERATORCIRCLED RING OPERATORCIRCLED ASTERISK " +
	"OPERATORCIRCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED MINUSSQUARED TIMES" +
	"SQUARED DOT OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSERTIONMODELSTR" +
	"UEFORCESTRIPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL BAR DOUBLE RI" +
	"GHT TURNSTILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGATED DOUBLE VERTICAL" +
	" BAR DOUBLE RIGHT TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS UNDER RELATIO" +
	"NNORMAL SUBGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROUP OF OR EQUA" +
	"L TOCONTAINS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE OFMULTIMAPHE" +
	"RMITIAN CONJUGATE MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WITH ARCRIGHT T" +
	"RIANGLEN-ARY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-ARY UNIONDIA" +
	"MOND OPERATORDOT OPERATORSTAR OPERATORDIVISION TIMESBOWTIELEFT NORMAL FA" +
	"CTOR SEMIDIRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUCTLEFT SEMIDI" +
	"RECT PRODUCTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCURLY LOGICAL O" +
	"RCURLY LOGICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSECTIONDOUBLE " +
	"UNIONPITCHFORKEQUAL AND PARALLEL TOLESS-THAN WITH DOTGREATER-THAN WITH D" +
	"OTVERY MUCH LESS-THANVERY MUCH GREATER-THANLESS-THAN EQUAL TO OR GREATER" +
	"-THANGREATER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LESS-THANEQUAL TO OR " +
	"GREATER-THANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT PRECEDE OR " +
	"EQUALDOES NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR EQUAL TONOT SQUARE " +
	"ORIGINAL OF OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE ORIGINAL OF" +
	" OR NOT EQUAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATER-THAN BUT NOT EQUI" +
	"VALENT TOPRECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUIVALENT TONOT" +
	" NORMAL SUBGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NORMAL SUBGROU" +
	"P OF OR EQUAL TODOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUALVERTICAL ELL" +
	"IPSISMIDLINE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDOWN RIGHT DIA" +
	"GONAL ELLIPSISELEMENT OF WITH LONG HORIZONTAL STROKEELEMENT OF WITH VERT" +
	"ICAL BAR AT END OF HORIZONTAL STROKESMALL ELEMENT OF WITH VERTICAL BAR A" +
	"T END OF HORIZONTAL STROKEELEMENT OF WITH DOT ABOVEELEMENT OF WITH OVERB" +
	"ARSMALL ELEMENT OF WITH OVERBARELEMENT OF WITH UNDERBARELEMENT OF WITH T" +
	"WO HORIZONTAL STROKESCONTAINS WITH LONG HORIZONTAL STROKECONTAINS WITH V" +
	"ERTICAL BAR AT END OF HORIZONTAL STROKESMALL CONTAINS WITH VERTICAL BAR " +
	"AT END OF HORIZONTAL STROKECONTAINS WITH OVERBARSMALL CONTAINS WITH OVER" +
	"BARZ NOTATION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSEUP ARROWHEAD" +
	"DOWN ARROWHEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGHT CEILINGLEF" +
	"T FLOORRIGHT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT CROPTOP LEF") + ("" +
	"T CROPREVERSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHONE RECORDERP" +
	"OSITION INDICATORVIEWDATA SQUAREPLACE OF INTEREST SIGNTURNED NOT SIGNWAT" +
	"CHHOURGLASSTOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT CORNERBOTTOM RIGHT" +
	" CORNERTOP HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARROWHEAD BETWE" +
	"EN TWO HORIZONTAL BARSOPTION KEYERASE TO THE RIGHTX IN A RECTANGLE BOXKE" +
	"YBOARDLEFT-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE BRACKETERASE TO TH" +
	"E LEFTBENZENE RINGCYLINDRICITYALL AROUND-PROFILESYMMETRYTOTAL RUNOUTDIME" +
	"NSION ORIGINCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNCTIONAL SYMBO" +
	"L I-BEAMAPL FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMBOL QUAD EQUA" +
	"LAPL FUNCTIONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD DIAMONDAPL " +
	"FUNCTIONAL SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEAPL FUNCTIONA" +
	"L SYMBOL CIRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUNCTIONAL SYMB" +
	"OL SLASH BARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONAL SYMBOL QUA" +
	"D SLASHAPL FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SYMBOL QUAD LE" +
	"SS-THANAPL FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL SYMBOL LEFT" +
	"WARDS VANEAPL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONAL SYMBOL QUA" +
	"D LEFTWARDS ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROWAPL FUNCTION" +
	"AL SYMBOL CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UNDERBARAPL FU" +
	"NCTIONAL SYMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN CARETAPL FUNC" +
	"TIONAL SYMBOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTAPL FUNCTIONA" +
	"L SYMBOL UPWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARROWAPL FUNCTIO" +
	"NAL SYMBOL UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL FUNCTIONAL " +
	"SYMBOL QUAD UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTIONAL SYMBOL " +
	"UP TACK JOTAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONAL SYMBOL QUA" +
	"D DOWNWARDS ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUNCTIONAL SYMB" +
	"OL DELTA UNDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL FUNCTIONAL SY" +
	"MBOL JOT UNDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FUNCTIONAL SYM" +
	"BOL UP SHOE JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONAL SYMBOL CIR" +
	"CLE STARAPL FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBOL UP TACK DI" +
	"AERESISAPL FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYMBOL STAR DIA" +
	"ERESISAPL FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMBOL CIRCLE DI" +
	"AERESISAPL FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL SYMBOL LEFT S" +
	"HOE STILEAPL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL SYMBOL GREA" +
	"TER-THAN DIAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIONAL SYMBOL D" +
	"EL TILDEAPL FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STILE TILDEAPL " +
	"FUNCTIONAL SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QUAD NOT EQUAL" +
	"APL FUNCTIONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOWN CARET TILD" +
	"EAPL FUNCTIONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL IOTAAPL FUNCT" +
	"IONAL SYMBOL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SYMBOL ALPHA U" +
	"NDERBARAPL FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL SYMBOL IOTA " +
	"UNDERBARAPL FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL SYMBOL ALPHAN" +
	"OT CHECK MARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDERED OPEN BOXB" +
	"ELL SYMBOLVERTICAL LINE WITH MIDDLE DOTINSERTION SYMBOLCONTINUOUS UNDERL" +
	"INE SYMBOLDISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPOSITION SYMBO" +
	"LWHITE SQUARE WITH CENTRE VERTICAL LINEENTER SYMBOLALTERNATIVE KEY SYMBO" +
	"LHELM SYMBOLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGLE DOWNBROKEN" +
	" CIRCLE WITH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYSTERESIS SYMBO" +
	"LOPEN-CIRCUIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE SYMBOLPASSI" +
	"VE-PULL-DOWN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIRECT CURRENT SY" +
	"MBOL FORM TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL QUADDECIMAL S" +
	"EPARATOR KEY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOLCLEAR SCREEN" +
	" SYMBOLLEFT PARENTHESIS UPPER HOOKLEFT PARENTHESIS EXTENSIONLEFT PARENTH" +
	"ESIS LOWER HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS EXTENSIONRI" +
	"GHT PARENTHESIS LOWER HOOKLEFT SQUARE BRACKET UPPER CORNERLEFT SQUARE BR" +
	"ACKET EXTENSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT SQUARE BRACKET UPPE" +
	"R CORNERRIGHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BRACKET LOWER CORNERL" +
	"EFT CURLY BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECELEFT CURLY BR" +
	"ACKET LOWER HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BRACKET UPPER HOOKRIG" +
	"HT CURLY BRACKET MIDDLE PIECERIGHT CURLY BRACKET LOWER HOOKINTEGRAL EXTE" +
	"NSIONHORIZONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIGHT CURLY BRACKET SE" +
	"CTIONUPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTIONSUMMATION TOPSUMMATI" +
	"ON BOTTOMTOP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUARE BRACKET OV" +
	"ER TOP SQUARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX LINERIGHT VE" +
	"RTICAL BOX LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3HORIZONTAL SC") + ("" +
	"AN LINE-7HORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTICAL AND TOP R" +
	"IGHTDENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTRY SYMBOL LIG" +
	"HT VERTICAL WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH C" +
	"IRCLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLEDENTISTRY SYMBO" +
	"L LIGHT VERTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL" +
	" WITH TRIANGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLEDENT" +
	"ISTRY SYMBOL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORI" +
	"ZONTAL WITH WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVEDENTIS" +
	"TRY SYMBOL LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL LIGHT UP AND HORIZO" +
	"NTALDENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTISTRY SYMBOL LIGHT V" +
	"ERTICAL AND BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLVERTICAL LINE" +
	" EXTENSIONMETRICAL BREVEMETRICAL LONG OVER SHORTMETRICAL SHORT OVER LONG" +
	"METRICAL LONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER LONGMETRICAL TWO S" +
	"HORTS JOINEDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICAL PENTASEMEEARTH GR" +
	"OUNDFUSETOP PARENTHESISBOTTOM PARENTHESISTOP CURLY BRACKETBOTTOM CURLY B" +
	"RACKETTOP TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL BRACKETWHITE TRAPE" +
	"ZIUMBENZENE RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTELECTRICAL INT" +
	"ERSECTIONDECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE TRIANGLEBLAC" +
	"K LEFT-POINTING DOUBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIANGLEBLACK DO" +
	"WN-POINTING DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VER" +
	"TICAL BARBLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK RIGH" +
	"T-POINTING TRIANGLE WITH DOUBLE VERTICAL BARALARM CLOCKSTOPWATCHTIMER CL" +
	"OCKHOURGLASS WITH FLOWING SANDBLACK MEDIUM LEFT-POINTING TRIANGLEBLACK M" +
	"EDIUM RIGHT-POINTING TRIANGLEBLACK MEDIUM UP-POINTING TRIANGLEBLACK MEDI" +
	"UM DOWN-POINTING TRIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR STOPBLACK C" +
	"IRCLE FOR RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMBOLPOWER SLEE" +
	"P SYMBOLOBSERVER EYE SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSYM" +
	"BOL FOR START OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSIO" +
	"NSYMBOL FOR ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACKS" +
	"PACESYMBOL FOR HORIZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERTI" +
	"CAL TABULATIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR S" +
	"HIFT OUTSYMBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE " +
	"CONTROL ONESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREES" +
	"YMBOL FOR DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR S" +
	"YNCHRONOUS IDLESYMBOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYMB" +
	"OL FOR END OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FIL" +
	"E SEPARATORSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL F" +
	"OR UNIT SEPARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXSY" +
	"MBOL FOR NEWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TWO" +
	"OCR HOOKOCR CHAIROCR FORKOCR INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR " +
	"BRANCH BANK IDENTIFICATIONOCR AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOUN" +
	"T NUMBEROCR DOUBLE BACKSLASHCIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED DI" +
	"GIT THREECIRCLED DIGIT FOURCIRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED DI" +
	"GIT SEVENCIRCLED DIGIT EIGHTCIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED " +
	"NUMBER ELEVENCIRCLED NUMBER TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER " +
	"FOURTEENCIRCLED NUMBER FIFTEENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVEN" +
	"TEENCIRCLED NUMBER EIGHTEENCIRCLED NUMBER NINETEENCIRCLED NUMBER TWENTYP" +
	"ARENTHESIZED DIGIT ONEPARENTHESIZED DIGIT TWOPARENTHESIZED DIGIT THREEPA" +
	"RENTHESIZED DIGIT FOURPARENTHESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPAR" +
	"ENTHESIZED DIGIT SEVENPARENTHESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINEP" +
	"ARENTHESIZED NUMBER TENPARENTHESIZED NUMBER ELEVENPARENTHESIZED NUMBER T" +
	"WELVEPARENTHESIZED NUMBER THIRTEENPARENTHESIZED NUMBER FOURTEENPARENTHES" +
	"IZED NUMBER FIFTEENPARENTHESIZED NUMBER SIXTEENPARENTHESIZED NUMBER SEVE" +
	"NTEENPARENTHESIZED NUMBER EIGHTEENPARENTHESIZED NUMBER NINETEENPARENTHES" +
	"IZED NUMBER TWENTYDIGIT ONE FULL STOPDIGIT TWO FULL STOPDIGIT THREE FULL" +
	" STOPDIGIT FOUR FULL STOPDIGIT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT SE" +
	"VEN FULL STOPDIGIT EIGHT FULL STOPDIGIT NINE FULL STOPNUMBER TEN FULL ST" +
	"OPNUMBER ELEVEN FULL STOPNUMBER TWELVE FULL STOPNUMBER THIRTEEN FULL STO" +
	"PNUMBER FOURTEEN FULL STOPNUMBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL ST" +
	"OPNUMBER SEVENTEEN FULL STOPNUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FUL" +
	"L STOPNUMBER TWENTY FULL STOPPARENTHESIZED LATIN SMALL LETTER APARENTHES" +
	"IZED LATIN SMALL LETTER BPARENTHESIZED LATIN SMALL LETTER CPARENTHESIZED" +
	" LATIN SMALL LETTER DPARENTHESIZED LATIN SMALL LETTER EPARENTHESIZED LAT" +
	"IN SMALL LETTER FPARENTHESIZED LATIN SMALL LETTER GPARENTHESIZED LATIN S") + ("" +
	"MALL LETTER HPARENTHESIZED LATIN SMALL LETTER IPARENTHESIZED LATIN SMALL" +
	" LETTER JPARENTHESIZED LATIN SMALL LETTER KPARENTHESIZED LATIN SMALL LET" +
	"TER LPARENTHESIZED LATIN SMALL LETTER MPARENTHESIZED LATIN SMALL LETTER " +
	"NPARENTHESIZED LATIN SMALL LETTER OPARENTHESIZED LATIN SMALL LETTER PPAR" +
	"ENTHESIZED LATIN SMALL LETTER QPARENTHESIZED LATIN SMALL LETTER RPARENTH" +
	"ESIZED LATIN SMALL LETTER SPARENTHESIZED LATIN SMALL LETTER TPARENTHESIZ" +
	"ED LATIN SMALL LETTER UPARENTHESIZED LATIN SMALL LETTER VPARENTHESIZED L" +
	"ATIN SMALL LETTER WPARENTHESIZED LATIN SMALL LETTER XPARENTHESIZED LATIN" +
	" SMALL LETTER YPARENTHESIZED LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL L" +
	"ETTER ACIRCLED LATIN CAPITAL LETTER BCIRCLED LATIN CAPITAL LETTER CCIRCL" +
	"ED LATIN CAPITAL LETTER DCIRCLED LATIN CAPITAL LETTER ECIRCLED LATIN CAP" +
	"ITAL LETTER FCIRCLED LATIN CAPITAL LETTER GCIRCLED LATIN CAPITAL LETTER " +
	"HCIRCLED LATIN CAPITAL LETTER ICIRCLED LATIN CAPITAL LETTER JCIRCLED LAT" +
	"IN CAPITAL LETTER KCIRCLED LATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL L" +
	"ETTER MCIRCLED LATIN CAPITAL LETTER NCIRCLED LATIN CAPITAL LETTER OCIRCL" +
	"ED LATIN CAPITAL LETTER PCIRCLED LATIN CAPITAL LETTER QCIRCLED LATIN CAP" +
	"ITAL LETTER RCIRCLED LATIN CAPITAL LETTER SCIRCLED LATIN CAPITAL LETTER " +
	"TCIRCLED LATIN CAPITAL LETTER UCIRCLED LATIN CAPITAL LETTER VCIRCLED LAT" +
	"IN CAPITAL LETTER WCIRCLED LATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL L" +
	"ETTER YCIRCLED LATIN CAPITAL LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLED" +
	" LATIN SMALL LETTER BCIRCLED LATIN SMALL LETTER CCIRCLED LATIN SMALL LET" +
	"TER DCIRCLED LATIN SMALL LETTER ECIRCLED LATIN SMALL LETTER FCIRCLED LAT" +
	"IN SMALL LETTER GCIRCLED LATIN SMALL LETTER HCIRCLED LATIN SMALL LETTER " +
	"ICIRCLED LATIN SMALL LETTER JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN S" +
	"MALL LETTER LCIRCLED LATIN SMALL LETTER MCIRCLED LATIN SMALL LETTER NCIR" +
	"CLED LATIN SMALL LETTER OCIRCLED LATIN SMALL LETTER PCIRCLED LATIN SMALL" +
	" LETTER QCIRCLED LATIN SMALL LETTER RCIRCLED LATIN SMALL LETTER SCIRCLED" +
	" LATIN SMALL LETTER TCIRCLED LATIN SMALL LETTER UCIRCLED LATIN SMALL LET" +
	"TER VCIRCLED LATIN SMALL LETTER WCIRCLED LATIN SMALL LETTER XCIRCLED LAT" +
	"IN SMALL LETTER YCIRCLED LATIN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE " +
	"CIRCLED NUMBER ELEVENNEGATIVE CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUMB" +
	"ER THIRTEENNEGATIVE CIRCLED NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFTE" +
	"ENNEGATIVE CIRCLED NUMBER SIXTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGATI" +
	"VE CIRCLED NUMBER EIGHTEENNEGATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRCL" +
	"ED NUMBER TWENTYDOUBLE CIRCLED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE C" +
	"IRCLED DIGIT THREEDOUBLE CIRCLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOUB" +
	"LE CIRCLED DIGIT SIXDOUBLE CIRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGHT" +
	"DOUBLE CIRCLED DIGIT NINEDOUBLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGIT" +
	" ZEROBOX DRAWINGS LIGHT HORIZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAWI" +
	"NGS LIGHT VERTICALBOX DRAWINGS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE D" +
	"ASH HORIZONTALBOX DRAWINGS HEAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIGH" +
	"T TRIPLE DASH VERTICALBOX DRAWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWING" +
	"S LIGHT QUADRUPLE DASH HORIZONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORIZ" +
	"ONTALBOX DRAWINGS LIGHT QUADRUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADRU" +
	"PLE DASH VERTICALBOX DRAWINGS LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIGH" +
	"T AND RIGHT HEAVYBOX DRAWINGS DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HEA" +
	"VY DOWN AND RIGHTBOX DRAWINGS LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGHT" +
	" AND LEFT HEAVYBOX DRAWINGS DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY " +
	"DOWN AND LEFTBOX DRAWINGS LIGHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND RI" +
	"GHT HEAVYBOX DRAWINGS UP HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND " +
	"RIGHTBOX DRAWINGS LIGHT UP AND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVYB" +
	"OX DRAWINGS UP HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DRA" +
	"WINGS LIGHT VERTICAL AND RIGHTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAV" +
	"YBOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND R" +
	"IGHT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DOW" +
	"N LIGHT AND RIGHT UP HEAVYBOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX " +
	"DRAWINGS HEAVY VERTICAL AND RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBOX" +
	" DRAWINGS VERTICAL LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT DO" +
	"WN LIGHTBOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL H" +
	"EAVY AND LEFT LIGHTBOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWINGS" +
	" UP LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DRA" +
	"WINGS LIGHT DOWN AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LI" +
	"GHTBOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT A" +
	"ND HORIZONTAL HEAVYBOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAWI") + ("" +
	"NGS RIGHT LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DOW" +
	"N HEAVYBOX DRAWINGS HEAVY DOWN AND HORIZONTALBOX DRAWINGS LIGHT UP AND H" +
	"ORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT HE" +
	"AVY AND LEFT UP LIGHTBOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAWI" +
	"NGS UP HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP HE" +
	"AVYBOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND H" +
	"ORIZONTALBOX DRAWINGS LIGHT VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HEA" +
	"VY AND RIGHT VERTICAL LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LI" +
	"GHTBOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY" +
	" AND DOWN HORIZONTAL LIGHTBOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGH" +
	"TBOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP HE" +
	"AVY AND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHTB" +
	"OX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN HE" +
	"AVY AND LEFT UP LIGHTBOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX " +
	"DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND " +
	"LEFT VERTICAL HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX D" +
	"RAWINGS HEAVY VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HORI" +
	"ZONTALBOX DRAWINGS HEAVY DOUBLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBLE" +
	" DASH VERTICALBOX DRAWINGS HEAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBLE" +
	" HORIZONTALBOX DRAWINGS DOUBLE VERTICALBOX DRAWINGS DOWN SINGLE AND RIGH" +
	"T DOUBLEBOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DOW" +
	"N AND RIGHTBOX DRAWINGS DOWN SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DOU" +
	"BLE AND LEFT SINGLEBOX DRAWINGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SING" +
	"LE AND RIGHT DOUBLEBOX DRAWINGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS D" +
	"OUBLE UP AND RIGHTBOX DRAWINGS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP " +
	"DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTIC" +
	"AL SINGLE AND RIGHT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLEB" +
	"OX DRAWINGS DOUBLE VERTICAL AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND LE" +
	"FT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE" +
	" VERTICAL AND LEFTBOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRAW" +
	"INGS DOWN DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORIZ" +
	"ONTALBOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE " +
	"AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS V" +
	"ERTICAL SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HOR" +
	"IZONTAL SINGLEBOX DRAWINGS DOUBLE VERTICAL AND HORIZONTALBOX DRAWINGS LI" +
	"GHT ARC DOWN AND RIGHTBOX DRAWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS L" +
	"IGHT ARC UP AND LEFTBOX DRAWINGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIGH" +
	"T DIAGONAL UPPER RIGHT TO LOWER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER LE" +
	"FT TO LOWER RIGHTBOX DRAWINGS LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LEF" +
	"TBOX DRAWINGS LIGHT UPBOX DRAWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBOX" +
	" DRAWINGS HEAVY LEFTBOX DRAWINGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DRA" +
	"WINGS HEAVY DOWNBOX DRAWINGS LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIGH" +
	"T UP AND HEAVY DOWNBOX DRAWINGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS H" +
	"EAVY UP AND LIGHT DOWNUPPER HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE QU" +
	"ARTER BLOCKLOWER THREE EIGHTHS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS B" +
	"LOCKLOWER THREE QUARTERS BLOCKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT SE" +
	"VEN EIGHTHS BLOCKLEFT THREE QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT HA" +
	"LF BLOCKLEFT THREE EIGHTHS BLOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH BL" +
	"OCKRIGHT HALF BLOCKLIGHT SHADEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BLO" +
	"CKRIGHT ONE EIGHTH BLOCKQUADRANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT " +
	"UPPER LEFTQUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHTQUADRANT UPP" +
	"ER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEF" +
	"TQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGHT" +
	"QUADRANT UPPER RIGHT AND LOWER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT A" +
	"ND LOWER RIGHTBLACK SQUAREWHITE SQUAREWHITE SQUARE WITH ROUNDED CORNERSW" +
	"HITE SQUARE CONTAINING BLACK SMALL SQUARESQUARE WITH HORIZONTAL FILLSQUA" +
	"RE WITH VERTICAL FILLSQUARE WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH U" +
	"PPER LEFT TO LOWER RIGHT FILLSQUARE WITH UPPER RIGHT TO LOWER LEFT FILLS" +
	"QUARE WITH DIAGONAL CROSSHATCH FILLBLACK SMALL SQUAREWHITE SMALL SQUAREB" +
	"LACK RECTANGLEWHITE RECTANGLEBLACK VERTICAL RECTANGLEWHITE VERTICAL RECT" +
	"ANGLEBLACK PARALLELOGRAMWHITE PARALLELOGRAMBLACK UP-POINTING TRIANGLEWHI" +
	"TE UP-POINTING TRIANGLEBLACK UP-POINTING SMALL TRIANGLEWHITE UP-POINTING" +
	" SMALL TRIANGLEBLACK RIGHT-POINTING TRIANGLEWHITE RIGHT-POINTING TRIANGL" +
	"EBLACK RIGHT-POINTING SMALL TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLEB") + ("" +
	"LACK RIGHT-POINTING POINTERWHITE RIGHT-POINTING POINTERBLACK DOWN-POINTI" +
	"NG TRIANGLEWHITE DOWN-POINTING TRIANGLEBLACK DOWN-POINTING SMALL TRIANGL" +
	"EWHITE DOWN-POINTING SMALL TRIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LEF" +
	"T-POINTING TRIANGLEBLACK LEFT-POINTING SMALL TRIANGLEWHITE LEFT-POINTING" +
	" SMALL TRIANGLEBLACK LEFT-POINTING POINTERWHITE LEFT-POINTING POINTERBLA" +
	"CK DIAMONDWHITE DIAMONDWHITE DIAMOND CONTAINING BLACK SMALL DIAMONDFISHE" +
	"YELOZENGEWHITE CIRCLEDOTTED CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLACK" +
	" CIRCLECIRCLE WITH LEFT HALF BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WIT" +
	"H LOWER HALF BLACKCIRCLE WITH UPPER HALF BLACKCIRCLE WITH UPPER RIGHT QU" +
	"ADRANT BLACKCIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLACK" +
	" CIRCLERIGHT HALF BLACK CIRCLEINVERSE BULLETINVERSE WHITE CIRCLEUPPER HA" +
	"LF INVERSE WHITE CIRCLELOWER HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRAN" +
	"T CIRCULAR ARCUPPER RIGHT QUADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIRC" +
	"ULAR ARCLOWER LEFT QUADRANT CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIRC" +
	"LEBLACK LOWER RIGHT TRIANGLEBLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT TR" +
	"IANGLEBLACK UPPER RIGHT TRIANGLEWHITE BULLETSQUARE WITH LEFT HALF BLACKS" +
	"QUARE WITH RIGHT HALF BLACKSQUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQU" +
	"ARE WITH LOWER RIGHT DIAGONAL HALF BLACKWHITE SQUARE WITH VERTICAL BISEC" +
	"TING LINEWHITE UP-POINTING TRIANGLE WITH DOTUP-POINTING TRIANGLE WITH LE" +
	"FT HALF BLACKUP-POINTING TRIANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHITE" +
	" SQUARE WITH UPPER LEFT QUADRANTWHITE SQUARE WITH LOWER LEFT QUADRANTWHI" +
	"TE SQUARE WITH LOWER RIGHT QUADRANTWHITE SQUARE WITH UPPER RIGHT QUADRAN" +
	"TWHITE CIRCLE WITH UPPER LEFT QUADRANTWHITE CIRCLE WITH LOWER LEFT QUADR" +
	"ANTWHITE CIRCLE WITH LOWER RIGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT Q" +
	"UADRANTUPPER LEFT TRIANGLEUPPER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE M" +
	"EDIUM SQUAREBLACK MEDIUM SQUAREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SMA" +
	"LL SQUARELOWER RIGHT TRIANGLEBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOME" +
	"TBLACK STARWHITE STARLIGHTNINGTHUNDERSTORMSUNASCENDING NODEDESCENDING NO" +
	"DECONJUNCTIONOPPOSITIONBLACK TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT BO" +
	"X WITH CHECKBALLOT BOX WITH XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAGE" +
	"WHITE SHOGI PIECEBLACK SHOGI PIECESHAMROCKREVERSED ROTATED FLORAL HEART " +
	"BULLETBLACK LEFT POINTING INDEXBLACK RIGHT POINTING INDEXWHITE LEFT POIN" +
	"TING INDEXWHITE UP POINTING INDEXWHITE RIGHT POINTING INDEXWHITE DOWN PO" +
	"INTING INDEXSKULL AND CROSSBONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD SI" +
	"GNCADUCEUSANKHORTHODOX CROSSCHI RHOCROSS OF LORRAINECROSS OF JERUSALEMST" +
	"AR AND CRESCENTFARSI SYMBOLADI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN YA" +
	"NGTRIGRAM FOR HEAVENTRIGRAM FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDERT" +
	"RIGRAM FOR WINDTRIGRAM FOR WATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWHE" +
	"EL OF DHARMAWHITE FROWNING FACEWHITE SMILING FACEBLACK SMILING FACEWHITE" +
	" SUN WITH RAYSFIRST QUARTER MOONLAST QUARTER MOONMERCURYFEMALE SIGNEARTH" +
	"MALE SIGNJUPITERSATURNURANUSNEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGOL" +
	"IBRASCORPIUSSAGITTARIUSCAPRICORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHES" +
	"S QUEENWHITE CHESS ROOKWHITE CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS P" +
	"AWNBLACK CHESS KINGBLACK CHESS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPBL" +
	"ACK CHESS KNIGHTBLACK CHESS PAWNBLACK SPADE SUITWHITE HEART SUITWHITE DI" +
	"AMOND SUITBLACK CLUB SUITWHITE SPADE SUITBLACK HEART SUITBLACK DIAMOND S" +
	"UITWHITE CLUB SUITHOT SPRINGSQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTESB" +
	"EAMED SIXTEENTH NOTESMUSIC FLAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNWE" +
	"ST SYRIAC CROSSEAST SYRIAC CROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYMB" +
	"OL FOR TYPE-1 PLASTICSRECYCLING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYMB" +
	"OL FOR TYPE-3 PLASTICSRECYCLING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYMB" +
	"OL FOR TYPE-5 PLASTICSRECYCLING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYMB" +
	"OL FOR TYPE-7 PLASTICSRECYCLING SYMBOL FOR GENERIC MATERIALSBLACK UNIVER" +
	"SAL RECYCLING SYMBOLRECYCLED PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBOL" +
	"PERMANENT PAPER SIGNWHEELCHAIR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE F" +
	"ACE-4DIE FACE-5DIE FACE-6WHITE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH TW" +
	"O DOTSBLACK CIRCLE WITH WHITE DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTSM" +
	"ONOGRAM FOR YANGMONOGRAM FOR YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSER" +
	" YINDIGRAM FOR LESSER YANGDIGRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAMM" +
	"ER AND PICKANCHORCROSSED SWORDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERGE" +
	"ARSTAFF OF HERMESATOM SYMBOLFLEUR-DE-LISOUTLINED WHITE STARTHREE LINES C" +
	"ONVERGING RIGHTTHREE LINES CONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGND" +
	"OUBLED FEMALE SIGNDOUBLED MALE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE " +
	"AND FEMALE SIGNMALE WITH STROKE SIGNMALE WITH STROKE AND MALE AND FEMALE") + ("" +
	" SIGNVERTICAL MALE WITH STROKE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDIU" +
	"M WHITE CIRCLEMEDIUM BLACK CIRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMBO" +
	"LDIVORCE SYMBOLUNMARRIED PARTNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERESP" +
	"ALLASJUNOVESTACHIRONBLACK MOON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQUA" +
	"DRATESOCCER BALLBASEBALLSQUARED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KING" +
	"BLACK DRAUGHTS MANBLACK DRAUGHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLOU" +
	"DRAINBLACK SNOWMANTHUNDER CLOUD AND RAINTURNED WHITE SHOGI PIECETURNED B" +
	"LACK SHOGI PIECEWHITE DIAMOND IN SQUARECROSSING LANESDISABLED CAROPHIUCH" +
	"USPICKCAR SLIDINGHELMET WITH WHITE CROSSCIRCLED CROSSING LANESCHAINSNO E" +
	"NTRYALTERNATE ONE-WAY LEFT WAY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHIT" +
	"E TWO-WAY LEFT WAY TRAFFICBLACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRIV" +
	"E SLOW SIGNHEAVY WHITE DOWN-POINTING TRIANGLELEFT CLOSED ENTRYSQUARED SA" +
	"LTIREFALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRICT" +
	"ED LEFT ENTRY-1RESTRICTED LEFT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEAV" +
	"Y CIRCLE WITH STROKE AND TWO DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED " +
	"PENTAGRAMLEFT-HANDED INTERLACED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS O" +
	"N SHIELDSHINTO SHRINECHURCHCASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH " +
	"HANDLESMAP SYMBOL FOR LIGHTHOUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG I" +
	"N HOLEFERRYSAILBOATSQUARE FOUR CORNERSSKIERICE SKATEPERSON WITH BALLTENT" +
	"JAPANESE BANK SYMBOLHEADSTONE GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQUA" +
	"REWHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUPP" +
	"ER BLADE SCISSORSBLACK SCISSORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE H" +
	"EAVY CHECK MARKTELEPHONE LOCATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED F" +
	"ISTRAISED HANDVICTORY HANDWRITING HANDLOWER RIGHT PENCILPENCILUPPER RIGH" +
	"T PENCILWHITE NIBBLACK NIBCHECK MARKHEAVY CHECK MARKMULTIPLICATION XHEAV" +
	"Y MULTIPLICATION XBALLOT XHEAVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK " +
	"CROSSOPEN CENTRE CROSSHEAVY OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE L" +
	"ATIN CROSSOUTLINED LATIN CROSSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-SP" +
	"OKED ASTERISKFOUR BALLOON-SPOKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTER" +
	"ISKFOUR CLUB-SPOKED ASTERISKBLACK FOUR POINTED STARWHITE FOUR POINTED ST" +
	"ARSPARKLESSTRESS OUTLINED WHITE STARCIRCLED WHITE STAROPEN CENTRE BLACK " +
	"STARBLACK CENTRE WHITE STAROUTLINED BLACK STARHEAVY OUTLINED BLACK STARP" +
	"INWHEEL STARSHADOWED WHITE STARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT S" +
	"POKED ASTERISKEIGHT POINTED BLACK STAREIGHT POINTED PINWHEEL STARSIX POI" +
	"NTED BLACK STAREIGHT POINTED RECTILINEAR BLACK STARHEAVY EIGHT POINTED R" +
	"ECTILINEAR BLACK STARTWELVE POINTED BLACK STARSIXTEEN POINTED ASTERISKTE" +
	"ARDROP-SPOKED ASTERISKOPEN CENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDROP" +
	"-SPOKED ASTERISKSIX PETALLED BLACK AND WHITE FLORETTEBLACK FLORETTEWHITE" +
	" FLORETTEEIGHT PETALLED OUTLINED BLACK FLORETTECIRCLED OPEN CENTRE EIGHT" +
	" POINTED STARHEAVY TEARDROP-SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIFO" +
	"LIATE SNOWFLAKEHEAVY CHEVRON SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKED" +
	" ASTERISKEIGHT TEARDROP-SPOKED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-SP" +
	"OKED PROPELLER ASTERISKCROSS MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED C" +
	"ROSS MARKLOWER RIGHT DROP-SHADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWED" +
	" WHITE SQUARELOWER RIGHT SHADOWED WHITE SQUAREUPPER RIGHT SHADOWED WHITE" +
	" SQUAREBLACK QUESTION MARK ORNAMENTWHITE QUESTION MARK ORNAMENTWHITE EXC" +
	"LAMATION MARK ORNAMENTBLACK DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK " +
	"SYMBOLLIGHT VERTICAL BARMEDIUM VERTICAL BARHEAVY VERTICAL BARHEAVY SINGL" +
	"E TURNED COMMA QUOTATION MARK ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK " +
	"ORNAMENTHEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE CO" +
	"MMA QUOTATION MARK ORNAMENTHEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMEN" +
	"THEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENTCURVED STEM PARAGRAPH SIG" +
	"N ORNAMENTHEAVY EXCLAMATION MARK ORNAMENTHEAVY HEART EXCLAMATION MARK OR" +
	"NAMENTHEAVY BLACK HEARTROTATED HEAVY BLACK HEART BULLETFLORAL HEARTROTAT" +
	"ED FLORAL HEART BULLETMEDIUM LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PAREN" +
	"THESIS ORNAMENTMEDIUM FLATTENED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTENE" +
	"D RIGHT PARENTHESIS ORNAMENTMEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENTM" +
	"EDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QUO" +
	"TATION MARK ORNAMENTHEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENTHE" +
	"AVY LEFT-POINTING ANGLE BRACKET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRACK" +
	"ET ORNAMENTLIGHT LEFT TORTOISE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOIS" +
	"E SHELL BRACKET ORNAMENTMEDIUM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT C" +
	"URLY BRACKET ORNAMENTDINGBAT NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE " +
	"CIRCLED DIGIT TWODINGBAT NEGATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE CI") + ("" +
	"RCLED DIGIT FOURDINGBAT NEGATIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIRC" +
	"LED DIGIT SIXDINGBAT NEGATIVE CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCLE" +
	"D DIGIT EIGHTDINGBAT NEGATIVE CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLED" +
	" NUMBER TENDINGBAT CIRCLED SANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SERI" +
	"F DIGIT TWODINGBAT CIRCLED SANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-SE" +
	"RIF DIGIT FOURDINGBAT CIRCLED SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS-" +
	"SERIF DIGIT SIXDINGBAT CIRCLED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SAN" +
	"S-SERIF DIGIT EIGHTDINGBAT CIRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED " +
	"SANS-SERIF NUMBER TENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGBA" +
	"T NEGATIVE CIRCLED SANS-SERIF DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SER" +
	"IF DIGIT THREEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEGA" +
	"TIVE CIRCLED SANS-SERIF DIGIT FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF DI" +
	"GIT SIXDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE C" +
	"IRCLED SANS-SERIF DIGIT EIGHTDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT N" +
	"INEDINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGHT" +
	"WARDS ARROWHEAVY PLUS SIGNHEAVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUTH" +
	" EAST ARROWHEAVY RIGHTWARDS ARROWHEAVY NORTH EAST ARROWDRAFTING POINT RI" +
	"GHTWARDS ARROWHEAVY ROUND-TIPPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTWA" +
	"RDS ARROWHEAVY TRIANGLE-HEADED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED RI" +
	"GHTWARDS ARROWHEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTWA" +
	"RDS ARROWTHREE-D TOP-LIGHTED RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED " +
	"RIGHTWARDS ARROWHEADBLACK RIGHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWAR" +
	"DS AND RIGHTWARDS ARROWHEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROWSQ" +
	"UAT BLACK RIGHTWARDS ARROWHEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWRI" +
	"GHT-SHADED WHITE RIGHTWARDS ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK-" +
	"TILTED SHADOWED WHITE RIGHTWARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHTW" +
	"ARDS ARROWHEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER R" +
	"IGHT-SHADOWED WHITE RIGHTWARDS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE R" +
	"IGHTWARDS ARROWCURLY LOOPNOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS A" +
	"RROWCIRCLED HEAVY WHITE RIGHTWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARROW" +
	"BLACK-FEATHERED SOUTH EAST ARROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-FE" +
	"ATHERED NORTH EAST ARROWHEAVY BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLAC" +
	"K-FEATHERED RIGHTWARDS ARROWHEAVY BLACK-FEATHERED NORTH EAST ARROWTEARDR" +
	"OP-BARBED RIGHTWARDS ARROWHEAVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-T" +
	"AILED RIGHTWARDS ARROWHEAVY WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED R" +
	"IGHTWARDS ARROWDOUBLE CURLY LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE CO" +
	"NTAINING SMALL WHITE TRIANGLEPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT S" +
	"-SHAPED BAG DELIMITERRIGHT S-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVER" +
	"SE SOLIDUS PRECEDING SUBSETSUPERSET PRECEDING SOLIDUSVERTICAL BAR WITH H" +
	"ORIZONTAL STROKEMATHEMATICAL RISING DIAGONALLONG DIVISIONMATHEMATICAL FA" +
	"LLING DIAGONALSQUARED LOGICAL ANDSQUARED LOGICAL ORWHITE DIAMOND WITH CE" +
	"NTRED DOTAND WITH DOTELEMENT OF OPENING UPWARDSLOWER RIGHT CORNER WITH D" +
	"OTUPPER LEFT CORNER WITH DOTLEFT OUTER JOINRIGHT OUTER JOINFULL OUTER JO" +
	"INLARGE UP TACKLARGE DOWN TACKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND RI" +
	"GHT TACKLEFT MULTIMAPLONG RIGHT TACKLONG LEFT TACKUP TACK WITH CIRCLE AB" +
	"OVELOZENGE DIVIDED BY HORIZONTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE CO" +
	"NCAVE-SIDED DIAMOND WITH LEFTWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH " +
	"RIGHTWARDS TICKWHITE SQUARE WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTWA" +
	"RDS TICKMATHEMATICAL LEFT WHITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE S" +
	"QUARE BRACKETMATHEMATICAL LEFT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BRA" +
	"CKETMATHEMATICAL LEFT DOUBLE ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANGL" +
	"E BRACKETMATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKETMATHEMATICAL RIGH" +
	"T WHITE TORTOISE SHELL BRACKETMATHEMATICAL LEFT FLATTENED PARENTHESISMAT" +
	"HEMATICAL RIGHT FLATTENED PARENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS QU" +
	"ADRUPLE ARROWANTICLOCKWISE GAPPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE AR" +
	"ROWRIGHT ARROW WITH CIRCLED PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARRO" +
	"WLONG LEFT RIGHT ARROWLONG LEFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE " +
	"ARROWLONG LEFT RIGHT DOUBLE ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGHT" +
	"WARDS ARROW FROM BARLONG LEFTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS " +
	"DOUBLE ARROW FROM BARLONG RIGHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLANK" +
	"BRAILLE PATTERN DOTS-1BRAILLE PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAIL" +
	"LE PATTERN DOTS-3BRAILLE PATTERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE P" +
	"ATTERN DOTS-123BRAILLE PATTERN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PATT" +
	"ERN DOTS-24BRAILLE PATTERN DOTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTER") + ("" +
	"N DOTS-134BRAILLE PATTERN DOTS-234BRAILLE PATTERN DOTS-1234BRAILLE PATTE" +
	"RN DOTS-5BRAILLE PATTERN DOTS-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN D" +
	"OTS-125BRAILLE PATTERN DOTS-35BRAILLE PATTERN DOTS-135BRAILLE PATTERN DO" +
	"TS-235BRAILLE PATTERN DOTS-1235BRAILLE PATTERN DOTS-45BRAILLE PATTERN DO" +
	"TS-145BRAILLE PATTERN DOTS-245BRAILLE PATTERN DOTS-1245BRAILLE PATTERN D" +
	"OTS-345BRAILLE PATTERN DOTS-1345BRAILLE PATTERN DOTS-2345BRAILLE PATTERN" +
	" DOTS-12345BRAILLE PATTERN DOTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN " +
	"DOTS-26BRAILLE PATTERN DOTS-126BRAILLE PATTERN DOTS-36BRAILLE PATTERN DO" +
	"TS-136BRAILLE PATTERN DOTS-236BRAILLE PATTERN DOTS-1236BRAILLE PATTERN D" +
	"OTS-46BRAILLE PATTERN DOTS-146BRAILLE PATTERN DOTS-246BRAILLE PATTERN DO" +
	"TS-1246BRAILLE PATTERN DOTS-346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN " +
	"DOTS-2346BRAILLE PATTERN DOTS-12346BRAILLE PATTERN DOTS-56BRAILLE PATTER" +
	"N DOTS-156BRAILLE PATTERN DOTS-256BRAILLE PATTERN DOTS-1256BRAILLE PATTE" +
	"RN DOTS-356BRAILLE PATTERN DOTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PAT" +
	"TERN DOTS-12356BRAILLE PATTERN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE " +
	"PATTERN DOTS-2456BRAILLE PATTERN DOTS-12456BRAILLE PATTERN DOTS-3456BRAI" +
	"LLE PATTERN DOTS-13456BRAILLE PATTERN DOTS-23456BRAILLE PATTERN DOTS-123" +
	"456BRAILLE PATTERN DOTS-7BRAILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27B" +
	"RAILLE PATTERN DOTS-127BRAILLE PATTERN DOTS-37BRAILLE PATTERN DOTS-137BR" +
	"AILLE PATTERN DOTS-237BRAILLE PATTERN DOTS-1237BRAILLE PATTERN DOTS-47BR" +
	"AILLE PATTERN DOTS-147BRAILLE PATTERN DOTS-247BRAILLE PATTERN DOTS-1247B" +
	"RAILLE PATTERN DOTS-347BRAILLE PATTERN DOTS-1347BRAILLE PATTERN DOTS-234" +
	"7BRAILLE PATTERN DOTS-12347BRAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-1" +
	"57BRAILLE PATTERN DOTS-257BRAILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS-" +
	"357BRAILLE PATTERN DOTS-1357BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DOT" +
	"S-12357BRAILLE PATTERN DOTS-457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN " +
	"DOTS-2457BRAILLE PATTERN DOTS-12457BRAILLE PATTERN DOTS-3457BRAILLE PATT" +
	"ERN DOTS-13457BRAILLE PATTERN DOTS-23457BRAILLE PATTERN DOTS-123457BRAIL" +
	"LE PATTERN DOTS-67BRAILLE PATTERN DOTS-167BRAILLE PATTERN DOTS-267BRAILL" +
	"E PATTERN DOTS-1267BRAILLE PATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRAI" +
	"LLE PATTERN DOTS-2367BRAILLE PATTERN DOTS-12367BRAILLE PATTERN DOTS-467B" +
	"RAILLE PATTERN DOTS-1467BRAILLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-12" +
	"467BRAILLE PATTERN DOTS-3467BRAILLE PATTERN DOTS-13467BRAILLE PATTERN DO" +
	"TS-23467BRAILLE PATTERN DOTS-123467BRAILLE PATTERN DOTS-567BRAILLE PATTE" +
	"RN DOTS-1567BRAILLE PATTERN DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE P" +
	"ATTERN DOTS-3567BRAILLE PATTERN DOTS-13567BRAILLE PATTERN DOTS-23567BRAI" +
	"LLE PATTERN DOTS-123567BRAILLE PATTERN DOTS-4567BRAILLE PATTERN DOTS-145" +
	"67BRAILLE PATTERN DOTS-24567BRAILLE PATTERN DOTS-124567BRAILLE PATTERN D" +
	"OTS-34567BRAILLE PATTERN DOTS-134567BRAILLE PATTERN DOTS-234567BRAILLE P" +
	"ATTERN DOTS-1234567BRAILLE PATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE " +
	"PATTERN DOTS-28BRAILLE PATTERN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE PA" +
	"TTERN DOTS-138BRAILLE PATTERN DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE P" +
	"ATTERN DOTS-48BRAILLE PATTERN DOTS-148BRAILLE PATTERN DOTS-248BRAILLE PA" +
	"TTERN DOTS-1248BRAILLE PATTERN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE " +
	"PATTERN DOTS-2348BRAILLE PATTERN DOTS-12348BRAILLE PATTERN DOTS-58BRAILL" +
	"E PATTERN DOTS-158BRAILLE PATTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAIL" +
	"LE PATTERN DOTS-358BRAILLE PATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BRA" +
	"ILLE PATTERN DOTS-12358BRAILLE PATTERN DOTS-458BRAILLE PATTERN DOTS-1458" +
	"BRAILLE PATTERN DOTS-2458BRAILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS-" +
	"3458BRAILLE PATTERN DOTS-13458BRAILLE PATTERN DOTS-23458BRAILLE PATTERN " +
	"DOTS-123458BRAILLE PATTERN DOTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTER" +
	"N DOTS-268BRAILLE PATTERN DOTS-1268BRAILLE PATTERN DOTS-368BRAILLE PATTE" +
	"RN DOTS-1368BRAILLE PATTERN DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE P" +
	"ATTERN DOTS-468BRAILLE PATTERN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILLE" +
	" PATTERN DOTS-12468BRAILLE PATTERN DOTS-3468BRAILLE PATTERN DOTS-13468BR" +
	"AILLE PATTERN DOTS-23468BRAILLE PATTERN DOTS-123468BRAILLE PATTERN DOTS-" +
	"568BRAILLE PATTERN DOTS-1568BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DOT" +
	"S-12568BRAILLE PATTERN DOTS-3568BRAILLE PATTERN DOTS-13568BRAILLE PATTER" +
	"N DOTS-23568BRAILLE PATTERN DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE " +
	"PATTERN DOTS-14568BRAILLE PATTERN DOTS-24568BRAILLE PATTERN DOTS-124568B" +
	"RAILLE PATTERN DOTS-34568BRAILLE PATTERN DOTS-134568BRAILLE PATTERN DOTS" +
	"-234568BRAILLE PATTERN DOTS-1234568BRAILLE PATTERN DOTS-78BRAILLE PATTER" +
	"N DOTS-178BRAILLE PATTERN DOTS-278BRAILLE PATTERN DOTS-1278BRAILLE PATTE" +
	"RN DOTS-378BRAILLE PATTERN DOTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PAT") + ("" +
	"TERN DOTS-12378BRAILLE PATTERN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE " +
	"PATTERN DOTS-2478BRAILLE PATTERN DOTS-12478BRAILLE PATTERN DOTS-3478BRAI" +
	"LLE PATTERN DOTS-13478BRAILLE PATTERN DOTS-23478BRAILLE PATTERN DOTS-123" +
	"478BRAILLE PATTERN DOTS-578BRAILLE PATTERN DOTS-1578BRAILLE PATTERN DOTS" +
	"-2578BRAILLE PATTERN DOTS-12578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN " +
	"DOTS-13578BRAILLE PATTERN DOTS-23578BRAILLE PATTERN DOTS-123578BRAILLE P" +
	"ATTERN DOTS-4578BRAILLE PATTERN DOTS-14578BRAILLE PATTERN DOTS-24578BRAI" +
	"LLE PATTERN DOTS-124578BRAILLE PATTERN DOTS-34578BRAILLE PATTERN DOTS-13" +
	"4578BRAILLE PATTERN DOTS-234578BRAILLE PATTERN DOTS-1234578BRAILLE PATTE" +
	"RN DOTS-678BRAILLE PATTERN DOTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PAT" +
	"TERN DOTS-12678BRAILLE PATTERN DOTS-3678BRAILLE PATTERN DOTS-13678BRAILL" +
	"E PATTERN DOTS-23678BRAILLE PATTERN DOTS-123678BRAILLE PATTERN DOTS-4678" +
	"BRAILLE PATTERN DOTS-14678BRAILLE PATTERN DOTS-24678BRAILLE PATTERN DOTS" +
	"-124678BRAILLE PATTERN DOTS-34678BRAILLE PATTERN DOTS-134678BRAILLE PATT" +
	"ERN DOTS-234678BRAILLE PATTERN DOTS-1234678BRAILLE PATTERN DOTS-5678BRAI" +
	"LLE PATTERN DOTS-15678BRAILLE PATTERN DOTS-25678BRAILLE PATTERN DOTS-125" +
	"678BRAILLE PATTERN DOTS-35678BRAILLE PATTERN DOTS-135678BRAILLE PATTERN " +
	"DOTS-235678BRAILLE PATTERN DOTS-1235678BRAILLE PATTERN DOTS-45678BRAILLE" +
	" PATTERN DOTS-145678BRAILLE PATTERN DOTS-245678BRAILLE PATTERN DOTS-1245" +
	"678BRAILLE PATTERN DOTS-345678BRAILLE PATTERN DOTS-1345678BRAILLE PATTER" +
	"N DOTS-2345678BRAILLE PATTERN DOTS-12345678RIGHTWARDS TWO-HEADED ARROW W" +
	"ITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STRO" +
	"KELEFTWARDS DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS DOUBLE ARROW WIT" +
	"H VERTICAL STROKELEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS " +
	"TWO-HEADED ARROW FROM BARLEFTWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUBL" +
	"E ARROW FROM BARDOWNWARDS ARROW WITH HORIZONTAL STROKEUPWARDS ARROW WITH" +
	" HORIZONTAL STROKEUPWARDS TRIPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS DO" +
	"UBLE DASH ARROWRIGHTWARDS DOUBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWRI" +
	"GHTWARDS TRIPLE DASH ARROWRIGHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTWA" +
	"RDS ARROW WITH DOTTED STEMUPWARDS ARROW TO BARDOWNWARDS ARROW TO BARRIGH" +
	"TWARDS ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS ARROW WITH TAIL WI" +
	"TH DOUBLE VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARDS" +
	" TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS TWO-HEADED AR" +
	"ROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS " +
	"ARROW-TAILLEFTWARDS DOUBLE ARROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWAR" +
	"DS ARROW TO BLACK DIAMONDRIGHTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARRO" +
	"W FROM BAR TO BLACK DIAMONDRIGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNOR" +
	"TH WEST AND SOUTH EAST ARROWNORTH EAST AND SOUTH WEST ARROWNORTH WEST AR" +
	"ROW WITH HOOKNORTH EAST ARROW WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH W" +
	"EST ARROW WITH HOOKNORTH WEST ARROW AND NORTH EAST ARROWNORTH EAST ARROW" +
	" AND SOUTH EAST ARROWSOUTH EAST ARROW AND SOUTH WEST ARROWSOUTH WEST ARR" +
	"OW AND NORTH WEST ARROWRISING DIAGONAL CROSSING FALLING DIAGONALFALLING " +
	"DIAGONAL CROSSING RISING DIAGONALSOUTH EAST ARROW CROSSING NORTH EAST AR" +
	"ROWNORTH EAST ARROW CROSSING SOUTH EAST ARROWFALLING DIAGONAL CROSSING N" +
	"ORTH EAST ARROWRISING DIAGONAL CROSSING SOUTH EAST ARROWNORTH EAST ARROW" +
	" CROSSING NORTH WEST ARROWNORTH WEST ARROW CROSSING NORTH EAST ARROWWAVE" +
	" ARROW POINTING DIRECTLY RIGHTARROW POINTING RIGHTWARDS THEN CURVING UPW" +
	"ARDSARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDSARROW POINTING DOWNW" +
	"ARDS THEN CURVING LEFTWARDSARROW POINTING DOWNWARDS THEN CURVING RIGHTWA" +
	"RDSRIGHT-SIDE ARC CLOCKWISE ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP AR" +
	"C ANTICLOCKWISE ARROWBOTTOM ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE ARR" +
	"OW WITH MINUSTOP ARC ANTICLOCKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCUL" +
	"AR CLOCKWISE ARROWLOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKWI" +
	"SE CLOSED CIRCLE ARROWCLOCKWISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABOV" +
	"E SHORT LEFTWARDS ARROWLEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHORT" +
	" RIGHTWARDS ARROW ABOVE LEFTWARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOWL" +
	"EFTWARDS ARROW WITH PLUS BELOWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARROW" +
	" THROUGH SMALL CIRCLEUPWARDS TWO-HEADED ARROW FROM SMALL CIRCLELEFT BARB" +
	" UP RIGHT BARB DOWN HARPOONLEFT BARB DOWN RIGHT BARB UP HARPOONUP BARB R" +
	"IGHT DOWN BARB LEFT HARPOONUP BARB LEFT DOWN BARB RIGHT HARPOONLEFT BARB" +
	" UP RIGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB " +
	"DOWN RIGHT BARB DOWN HARPOONUP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARDS" +
	" HARPOON WITH BARB UP TO BARRIGHTWARDS HARPOON WITH BARB UP TO BARUPWARD" +
	"S HARPOON WITH BARB RIGHT TO BARDOWNWARDS HARPOON WITH BARB RIGHT TO BAR") + ("" +
	"LEFTWARDS HARPOON WITH BARB DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOWN" +
	" TO BARUPWARDS HARPOON WITH BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB " +
	"LEFT TO BARLEFTWARDS HARPOON WITH BARB UP FROM BARRIGHTWARDS HARPOON WIT" +
	"H BARB UP FROM BARUPWARDS HARPOON WITH BARB RIGHT FROM BARDOWNWARDS HARP" +
	"OON WITH BARB RIGHT FROM BARLEFTWARDS HARPOON WITH BARB DOWN FROM BARRIG" +
	"HTWARDS HARPOON WITH BARB DOWN FROM BARUPWARDS HARPOON WITH BARB LEFT FR" +
	"OM BARDOWNWARDS HARPOON WITH BARB LEFT FROM BARLEFTWARDS HARPOON WITH BA" +
	"RB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWNUPWARDS HARPOON WITH BARB LE" +
	"FT BESIDE UPWARDS HARPOON WITH BARB RIGHTRIGHTWARDS HARPOON WITH BARB UP" +
	" ABOVE RIGHTWARDS HARPOON WITH BARB DOWNDOWNWARDS HARPOON WITH BARB LEFT" +
	" BESIDE DOWNWARDS HARPOON WITH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP " +
	"ABOVE RIGHTWARDS HARPOON WITH BARB UPLEFTWARDS HARPOON WITH BARB DOWN AB" +
	"OVE RIGHTWARDS HARPOON WITH BARB DOWNRIGHTWARDS HARPOON WITH BARB UP ABO" +
	"VE LEFTWARDS HARPOON WITH BARB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOVE" +
	" LEFTWARDS HARPOON WITH BARB DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE LO" +
	"NG DASHLEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHRIGHTWARDS HARPOO" +
	"N WITH BARB UP ABOVE LONG DASHRIGHTWARDS HARPOON WITH BARB DOWN BELOW LO" +
	"NG DASHUPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB" +
	" RIGHTDOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB " +
	"RIGHTRIGHT DOUBLE ARROW WITH ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS AR" +
	"ROWTILDE OPERATOR ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPER" +
	"ATORRIGHTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST E" +
	"QUAL TOLESS-THAN ABOVE LEFTWARDS ARROWLEFTWARDS ARROW THROUGH LESS-THANG" +
	"REATER-THAN ABOVE RIGHTWARDS ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARDS" +
	" ARROW THROUGH SUBSETSUPERSET ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT F" +
	"ISH TAILUP FISH TAILDOWN FISH TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATIO" +
	"N SPOTZ NOTATION TYPE COLONLEFT WHITE CURLY BRACKETRIGHT WHITE CURLY BRA" +
	"CKETLEFT WHITE PARENTHESISRIGHT WHITE PARENTHESISZ NOTATION LEFT IMAGE B" +
	"RACKETZ NOTATION RIGHT IMAGE BRACKETZ NOTATION LEFT BINDING BRACKETZ NOT" +
	"ATION RIGHT BINDING BRACKETLEFT SQUARE BRACKET WITH UNDERBARRIGHT SQUARE" +
	" BRACKET WITH UNDERBARLEFT SQUARE BRACKET WITH TICK IN TOP CORNERRIGHT S" +
	"QUARE BRACKET WITH TICK IN BOTTOM CORNERLEFT SQUARE BRACKET WITH TICK IN" +
	" BOTTOM CORNERRIGHT SQUARE BRACKET WITH TICK IN TOP CORNERLEFT ANGLE BRA" +
	"CKET WITH DOTRIGHT ANGLE BRACKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGHT" +
	" ARC GREATER-THAN BRACKETDOUBLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIGH" +
	"T ARC LESS-THAN BRACKETLEFT BLACK TORTOISE SHELL BRACKETRIGHT BLACK TORT" +
	"OISE SHELL BRACKETDOTTED FENCEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENING" +
	" LEFTRIGHT ANGLE VARIANT WITH SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE W" +
	"ITH S INSIDEACUTE ANGLESPHERICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPENI" +
	"NG UPTURNED ANGLEREVERSED ANGLEANGLE WITH UNDERBARREVERSED ANGLE WITH UN" +
	"DERBAROBLIQUE ANGLE OPENING UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE W" +
	"ITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHTMEASURED ANGLE WITH OP" +
	"EN ARM ENDING IN ARROW POINTING UP AND LEFTMEASURED ANGLE WITH OPEN ARM " +
	"ENDING IN ARROW POINTING DOWN AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDI" +
	"NG IN ARROW POINTING DOWN AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN" +
	" ARROW POINTING RIGHT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW" +
	" POINTING LEFT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTI" +
	"NG RIGHT AND DOWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING L" +
	"EFT AND DOWNREVERSED EMPTY SETEMPTY SET WITH OVERBAREMPTY SET WITH SMALL" +
	" CIRCLE ABOVEEMPTY SET WITH RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW A" +
	"BOVECIRCLE WITH HORIZONTAL BARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCLE" +
	"D REVERSE SOLIDUSCIRCLED PERPENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR A" +
	"ND TOP HALF DIVIDED BY VERTICAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED ANT" +
	"ICLOCKWISE-ROTATED DIVISION SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BUL" +
	"LETCIRCLED BULLETCIRCLED LESS-THANCIRCLED GREATER-THANCIRCLE WITH SMALL " +
	"CIRCLE TO THE RIGHTCIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHTSQUARE" +
	"D RISING DIAGONAL SLASHSQUARED FALLING DIAGONAL SLASHSQUARED ASTERISKSQU" +
	"ARED SMALL CIRCLESQUARED SQUARETWO JOINED SQUARESTRIANGLE WITH DOT ABOVE" +
	"TRIANGLE WITH UNDERBARS IN TRIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT T" +
	"RIANGLE ABOVE LEFT TRIANGLELEFT TRIANGLE BESIDE VERTICAL BARVERTICAL BAR" +
	" BESIDE RIGHT TRIANGLEBOWTIE WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF " +
	"BLACKBLACK BOWTIETIMES WITH LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKWH" +
	"ITE HOURGLASSBLACK HOURGLASSLEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOUB" +
	"LE WIGGLY FENCERIGHT DOUBLE WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INFI") + ("" +
	"NITYINFINITY NEGATED WITH VERTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH C" +
	"ONTOURED OUTLINEINCREASES ASSHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARAL" +
	"LELEQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVEIDENTICAL TO AND SLA" +
	"NTED PARALLELGLEICH STARKTHERMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT H" +
	"ALF BLACKDOWN-POINTING TRIANGLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH " +
	"DOWN ARROWBLACK LOZENGEWHITE CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DOW" +
	"N ARROWERROR-BARRED WHITE SQUAREERROR-BARRED BLACK SQUAREERROR-BARRED WH" +
	"ITE DIAMONDERROR-BARRED BLACK DIAMONDERROR-BARRED WHITE CIRCLEERROR-BARR" +
	"ED BLACK CIRCLERULE-DELAYEDREVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBARR" +
	"EVERSE SOLIDUS WITH HORIZONTAL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUBL" +
	"E PLUSTRIPLE PLUSLEFT-POINTING CURVED ANGLE BRACKETRIGHT-POINTING CURVED" +
	" ANGLE BRACKETTINYMINYN-ARY CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPERA" +
	"TORN-ARY CIRCLED TIMES OPERATORN-ARY UNION OPERATOR WITH DOTN-ARY UNION " +
	"OPERATOR WITH PLUSN-ARY SQUARE INTERSECTION OPERATORN-ARY SQUARE UNION O" +
	"PERATORTWO LOGICAL AND OPERATORTWO LOGICAL OR OPERATORN-ARY TIMES OPERAT" +
	"ORMODULO TWO SUMSUMMATION WITH INTEGRALQUADRUPLE INTEGRAL OPERATORFINITE" +
	" PART INTEGRALINTEGRAL WITH DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIRC" +
	"ULATION FUNCTIONANTICLOCKWISE INTEGRATIONLINE INTEGRATION WITH RECTANGUL" +
	"AR PATH AROUND POLELINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLELI" +
	"NE INTEGRATION NOT INCLUDING THE POLEINTEGRAL AROUND A POINT OPERATORQUA" +
	"TERNION INTEGRAL OPERATORINTEGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRAL" +
	" WITH TIMES SIGNINTEGRAL WITH INTERSECTIONINTEGRAL WITH UNIONINTEGRAL WI" +
	"TH OVERBARINTEGRAL WITH UNDERBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTATI" +
	"ON SCHEMA COMPOSITIONZ NOTATION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTIO" +
	"NPLUS SIGN WITH SMALL CIRCLE ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE" +
	"PLUS SIGN WITH TILDE ABOVEPLUS SIGN WITH DOT BELOWPLUS SIGN WITH TILDE B" +
	"ELOWPLUS SIGN WITH SUBSCRIPT TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN " +
	"WITH COMMA ABOVEMINUS SIGN WITH DOT BELOWMINUS SIGN WITH FALLING DOTSMIN" +
	"US SIGN WITH RISING DOTSPLUS SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT " +
	"HALF CIRCLEVECTOR OR CROSS PRODUCTMULTIPLICATION SIGN WITH DOT ABOVEMULT" +
	"IPLICATION SIGN WITH UNDERBARSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH " +
	"PRODUCTMULTIPLICATION SIGN IN LEFT HALF CIRCLEMULTIPLICATION SIGN IN RIG" +
	"HT HALF CIRCLECIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPLI" +
	"CATION SIGN IN DOUBLE CIRCLECIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEMI" +
	"NUS SIGN IN TRIANGLEMULTIPLICATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGHT" +
	"HAND INTERIOR PRODUCTZ NOTATION RELATIONAL COMPOSITIONAMALGAMATION OR CO" +
	"PRODUCTINTERSECTION WITH DOTUNION WITH MINUS SIGNUNION WITH OVERBARINTER" +
	"SECTION WITH OVERBARINTERSECTION WITH LOGICAL ANDUNION WITH LOGICAL ORUN" +
	"ION ABOVE INTERSECTIONINTERSECTION ABOVE UNIONUNION ABOVE BAR ABOVE INTE" +
	"RSECTIONINTERSECTION ABOVE BAR ABOVE UNIONUNION BESIDE AND JOINED WITH U" +
	"NIONINTERSECTION BESIDE AND JOINED WITH INTERSECTIONCLOSED UNION WITH SE" +
	"RIFSCLOSED INTERSECTION WITH SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQUA" +
	"RE UNIONCLOSED UNION WITH SERIFS AND SMASH PRODUCTLOGICAL AND WITH DOT A" +
	"BOVELOGICAL OR WITH DOT ABOVEDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INTE" +
	"RSECTING LOGICAL ANDTWO INTERSECTING LOGICAL ORSLOPING LARGE ORSLOPING L" +
	"ARGE ANDLOGICAL OR OVERLAPPING LOGICAL ANDLOGICAL AND WITH MIDDLE STEMLO" +
	"GICAL OR WITH MIDDLE STEMLOGICAL AND WITH HORIZONTAL DASHLOGICAL OR WITH" +
	" HORIZONTAL DASHLOGICAL AND WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBAR" +
	"LOGICAL AND WITH DOUBLE UNDERBARSMALL VEE WITH UNDERBARLOGICAL OR WITH D" +
	"OUBLE OVERBARLOGICAL OR WITH DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTRI" +
	"CTIONZ NOTATION RANGE ANTIRESTRICTIONEQUALS SIGN WITH DOT BELOWIDENTICAL" +
	" WITH DOT ABOVETRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE H" +
	"ORIZONTAL BAR WITH TRIPLE VERTICAL STROKETILDE OPERATOR WITH DOT ABOVETI" +
	"LDE OPERATOR WITH RISING DOTSSIMILAR MINUS SIMILARCONGRUENT WITH DOT ABO" +
	"VEEQUALS WITH ASTERISKALMOST EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATEL" +
	"Y EQUAL OR EQUAL TOEQUALS SIGN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SIG" +
	"NEQUALS SIGN ABOVE TILDE OPERATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUAL" +
	"S SIGNSTHREE CONSECUTIVE EQUALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AND" +
	" TWO DOTS BELOWEQUIVALENT WITH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INSI" +
	"DEGREATER-THAN WITH CIRCLE INSIDELESS-THAN WITH QUESTION MARK ABOVEGREAT" +
	"ER-THAN WITH QUESTION MARK ABOVELESS-THAN OR SLANTED EQUAL TOGREATER-THA" +
	"N OR SLANTED EQUAL TOLESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDEGREATE" +
	"R-THAN OR SLANTED EQUAL TO WITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO " +
	"WITH DOT ABOVEGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVELESS-THAN O") + ("" +
	"R SLANTED EQUAL TO WITH DOT ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO " +
	"WITH DOT ABOVE LEFTLESS-THAN OR APPROXIMATEGREATER-THAN OR APPROXIMATELE" +
	"SS-THAN AND SINGLE-LINE NOT EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQU" +
	"AL TOLESS-THAN AND NOT APPROXIMATEGREATER-THAN AND NOT APPROXIMATELESS-T" +
	"HAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE-" +
	"LINE EQUAL ABOVE LESS-THANLESS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN A" +
	"BOVE SIMILAR OR EQUALLESS-THAN ABOVE SIMILAR ABOVE GREATER-THANGREATER-T" +
	"HAN ABOVE SIMILAR ABOVE LESS-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOUB" +
	"LE-LINE EQUALGREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-TH" +
	"AN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUALGREATER-THA" +
	"N ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL T" +
	"O OR LESS-THANSLANTED EQUAL TO OR GREATER-THANSLANTED EQUAL TO OR LESS-T" +
	"HAN WITH DOT INSIDESLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDEDOUBL" +
	"E-LINE EQUAL TO OR LESS-THANDOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-L" +
	"INE SLANTED EQUAL TO OR LESS-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATER" +
	"-THANSIMILAR OR LESS-THANSIMILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN " +
	"ABOVE EQUALS SIGNSIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NEST" +
	"ED LESS-THANDOUBLE NESTED GREATER-THANDOUBLE NESTED LESS-THAN WITH UNDER" +
	"BARGREATER-THAN OVERLAPPING LESS-THANGREATER-THAN BESIDE LESS-THANLESS-T" +
	"HAN CLOSED BY CURVEGREATER-THAN CLOSED BY CURVELESS-THAN CLOSED BY CURVE" +
	" ABOVE SLANTED EQUALGREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMAL" +
	"LER THANLARGER THANSMALLER THAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUALS" +
	" SIGN WITH BUMPY ABOVEPRECEDES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS ABO" +
	"VE SINGLE-LINE EQUALS SIGNPRECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEED" +
	"S ABOVE SINGLE-LINE NOT EQUAL TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOVE" +
	" EQUALS SIGNPRECEDES ABOVE NOT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECED" +
	"ES ABOVE ALMOST EQUAL TOSUCCEEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NOT" +
	" ALMOST EQUAL TOSUCCEEDS ABOVE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE " +
	"SUCCEEDSSUBSET WITH DOTSUPERSET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPER" +
	"SET WITH PLUS SIGN BELOWSUBSET WITH MULTIPLICATION SIGN BELOWSUPERSET WI" +
	"TH MULTIPLICATION SIGN BELOWSUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSET" +
	" OF OR EQUAL TO WITH DOT ABOVESUBSET OF ABOVE EQUALS SIGNSUPERSET OF ABO" +
	"VE EQUALS SIGNSUBSET OF ABOVE TILDE OPERATORSUPERSET OF ABOVE TILDE OPER" +
	"ATORSUBSET OF ABOVE ALMOST EQUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUBS" +
	"ET OF ABOVE NOT EQUAL TOSUPERSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN B" +
	"OX OPERATORSQUARE RIGHT OPEN BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCLO" +
	"SED SUBSET OR EQUAL TOCLOSED SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETSU" +
	"PERSET ABOVE SUBSETSUBSET ABOVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET BE" +
	"SIDE SUBSETSUPERSET BESIDE AND JOINED BY DASH WITH SUBSETELEMENT OF OPEN" +
	"ING DOWNWARDSPITCHFORK WITH TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFOR" +
	"KINGSHORT LEFT TACKSHORT DOWN TACKSHORT UP TACKPERPENDICULAR WITH SVERTI" +
	"CAL BAR TRIPLE RIGHT TURNSTILEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICAL" +
	" BAR DOUBLE LEFT TURNSTILEDOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG " +
	"DASH FROM LEFT MEMBER OF DOUBLE VERTICALSHORT DOWN TACK WITH OVERBARSHOR" +
	"T UP TACK WITH UNDERBARSHORT UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN TA" +
	"CKDOUBLE UP TACKDOUBLE STROKE NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDOE" +
	"S NOT DIVIDE WITH REVERSED NEGATION SLASHVERTICAL LINE WITH CIRCLE ABOVE" +
	"VERTICAL LINE WITH CIRCLE BELOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH " +
	"HORIZONTAL STROKEPARALLEL WITH TILDE OPERATORTRIPLE VERTICAL BAR BINARY " +
	"RELATIONTRIPLE VERTICAL BAR WITH HORIZONTAL STROKETRIPLE COLON OPERATORT" +
	"RIPLE NESTED LESS-THANTRIPLE NESTED GREATER-THANDOUBLE-LINE SLANTED LESS" +
	"-THAN OR EQUAL TODOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOLI" +
	"DUS BINARY RELATIONLARGE TRIPLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPER" +
	"ATORWHITE VERTICAL BARN-ARY WHITE VERTICAL BARNORTH EAST WHITE ARROWNORT" +
	"H WEST WHITE ARROWSOUTH EAST WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGHT" +
	" WHITE ARROWLEFTWARDS BLACK ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARRO" +
	"WNORTH EAST BLACK ARROWNORTH WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUTH" +
	" WEST BLACK ARROWLEFT RIGHT BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS ARR" +
	"OW WITH TIP DOWNWARDSRIGHTWARDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW WI" +
	"TH TIP DOWNWARDSLEFTWARDS ARROW WITH TIP UPWARDSSQUARE WITH TOP HALF BLA" +
	"CKSQUARE WITH BOTTOM HALF BLACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BLA" +
	"CKSQUARE WITH LOWER LEFT DIAGONAL HALF BLACKDIAMOND WITH LEFT HALF BLACK" +
	"DIAMOND WITH RIGHT HALF BLACKDIAMOND WITH TOP HALF BLACKDIAMOND WITH BOT" +
	"TOM HALF BLACKDOTTED SQUAREBLACK LARGE SQUAREWHITE LARGE SQUAREBLACK VER") + ("" +
	"Y SMALL SQUAREWHITE VERY SMALL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE H" +
	"EXAGONBLACK HEXAGONHORIZONTAL BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDIU" +
	"M DIAMONDWHITE MEDIUM DIAMONDBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBLA" +
	"CK SMALL DIAMONDBLACK SMALL LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL E" +
	"LLIPSEWHITE HORIZONTAL ELLIPSEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLIP" +
	"SELEFT ARROW WITH SMALL CIRCLETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIRC" +
	"LED PLUSLONG LEFTWARDS SQUIGGLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VER" +
	"TICAL STROKELEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWA" +
	"RDS TWO-HEADED ARROW FROM BARLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFTW" +
	"ARDS ARROW WITH DOTTED STEMLEFTWARDS ARROW WITH TAIL WITH VERTICAL STROK" +
	"ELEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEAD" +
	"ED ARROW WITH TAILLEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STR" +
	"OKELEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTW" +
	"ARDS ARROW THROUGH XWAVE ARROW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE L" +
	"EFTWARDS ARROWREVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARRO" +
	"W ABOVE REVERSE ALMOST EQUAL TORIGHTWARDS ARROW THROUGH GREATER-THANRIGH" +
	"TWARDS ARROW THROUGH SUPERSETLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRUP" +
	"LE ARROWREVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW AB" +
	"OVE REVERSE ALMOST EQUAL TOTILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS" +
	" ARROW ABOVE ALMOST EQUAL TOLEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR" +
	"RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED Z" +
	"IGZAG ARROWSHORT SLANTED NORTH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE M" +
	"EDIUM STARBLACK SMALL STARWHITE SMALL STARBLACK RIGHT-POINTING PENTAGONW" +
	"HITE RIGHT-POINTING PENTAGONHEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSID" +
	"EHEAVY CIRCLE WITH CIRCLE INSIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTED" +
	" NORTH ARROW WITH HOOKED HEADBACKSLANTED SOUTH ARROW WITH HOOKED TAILSLA" +
	"NTED NORTH ARROW WITH HORIZONTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZO" +
	"NTAL TAILBENT ARROW POINTING DOWNWARDS THEN NORTH EASTSHORT BENT ARROW P" +
	"OINTING DOWNWARDS THEN NORTH EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS " +
	"TRIANGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-" +
	"HEADED ARROWLEFT RIGHT TRIANGLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARRO" +
	"WNORTH WEST TRIANGLE-HEADED ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH E" +
	"AST TRIANGLE-HEADED ARROWSOUTH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIAN" +
	"GLE-HEADED DASHED ARROWUPWARDS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS TR" +
	"IANGLE-HEADED DASHED ARROWDOWNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWIS" +
	"E TRIANGLE-HEADED OPEN CIRCLE ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN CI" +
	"RCLE ARROWLEFTWARDS TRIANGLE-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED " +
	"ARROW TO BARRIGHTWARDS TRIANGLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-HE" +
	"ADED ARROW TO BARNORTH WEST TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIAN" +
	"GLE-HEADED ARROW TO BARSOUTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH WEST" +
	" TRIANGLE-HEADED ARROW TO BARLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE" +
	" HORIZONTAL STROKEUPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL S" +
	"TROKERIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEDOWNW" +
	"ARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB K" +
	"EYVERTICAL TAB KEYLEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANG" +
	"LE-HEADED ARROWUPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIA" +
	"NGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGL" +
	"E-HEADED ARROWDOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIAN" +
	"GLE-HEADED ARROWLEFTWARDS TRIANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE-" +
	"HEADED PAIRED ARROWSRIGHTWARDS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS TR" +
	"IANGLE-HEADED PAIRED ARROWSLEFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS BL" +
	"ACK CIRCLED WHITE ARROWRIGHTWARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BLA" +
	"CK CIRCLED WHITE ARROWANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROW" +
	"ANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANGL" +
	"E-HEADED LEFT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED A" +
	"RROWRETURN LEFTRETURN RIGHTNEWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS C" +
	"IRCLING ANTICLOCKWISERIGHTWARDS BLACK ARROWSYMBOL FOR TYPE A ELECTRONICS" +
	"THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEADTHREE-D RIGHT-LIGHTED" +
	" UPWARDS EQUILATERAL ARROWHEADTHREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL" +
	" ARROWHEADTHREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEADBLACK LEFT" +
	"WARDS EQUILATERAL ARROWHEADBLACK UPWARDS EQUILATERAL ARROWHEADBLACK RIGH" +
	"TWARDS EQUILATERAL ARROWHEADBLACK DOWNWARDS EQUILATERAL ARROWHEADDOWNWAR" +
	"DS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSDOWNWARDS TRIANGLE-HEADE" +
	"D ARROW WITH LONG TIP RIGHTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH LONG ") + ("" +
	"TIP LEFTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSLEFTW" +
	"ARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSRIGHTWARDS TRIANGLE-HEAD" +
	"ED ARROW WITH LONG TIP UPWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LONG " +
	"TIP DOWNWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDSBLA" +
	"CK CURVED DOWNWARDS AND LEFTWARDS ARROWBLACK CURVED DOWNWARDS AND RIGHTW" +
	"ARDS ARROWBLACK CURVED UPWARDS AND LEFTWARDS ARROWBLACK CURVED UPWARDS A" +
	"ND RIGHTWARDS ARROWBLACK CURVED LEFTWARDS AND UPWARDS ARROWBLACK CURVED " +
	"RIGHTWARDS AND UPWARDS ARROWBLACK CURVED LEFTWARDS AND DOWNWARDS ARROWBL" +
	"ACK CURVED RIGHTWARDS AND DOWNWARDS ARROWRIBBON ARROW DOWN LEFTRIBBON AR" +
	"ROW DOWN RIGHTRIBBON ARROW UP LEFTRIBBON ARROW UP RIGHTRIBBON ARROW LEFT" +
	" UPRIBBON ARROW RIGHT UPRIBBON ARROW LEFT DOWNRIBBON ARROW RIGHT DOWNUPW" +
	"ARDS WHITE ARROW FROM BAR WITH HORIZONTAL BARUP ARROWHEAD IN A RECTANGLE" +
	" BOXOVERLAPPING WHITE SQUARESOVERLAPPING WHITE AND BLACK SQUARESOVERLAPP" +
	"ING BLACK SQUARESBALLOT BOX WITH LIGHT XCIRCLED XCIRCLED BOLD XBLACK SQU" +
	"ARE CENTREDBLACK DIAMOND CENTREDTURNED BLACK PENTAGONHORIZONTAL BLACK OC" +
	"TAGONBLACK OCTAGONBLACK MEDIUM UP-POINTING TRIANGLE CENTREDBLACK MEDIUM " +
	"DOWN-POINTING TRIANGLE CENTREDBLACK MEDIUM LEFT-POINTING TRIANGLE CENTRE" +
	"DBLACK MEDIUM RIGHT-POINTING TRIANGLE CENTREDNEPTUNE FORM TWOTOP HALF BL" +
	"ACK CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR POINTED BLACK CUSPROTATED L" +
	"IGHT FOUR POINTED BLACK CUSPWHITE FOUR POINTED CUSPROTATED WHITE FOUR PO" +
	"INTED CUSPSQUARE POSITION INDICATORUNCERTAINTY SIGNGROUP MARKPLUTO FORM " +
	"TWOPLUTO FORM THREEPLUTO FORM FOURPLUTO FORM FIVETRANSPLUTOPROSERPINAAST" +
	"RAEAHYGIEAPHOLUSNESSUSWHITE MOON SELENABLACK DIAMOND ON CROSSTRUE LIGHT " +
	"MOON ARTACUPIDOHADESZEUSKRONOSAPOLLONADMETOSVULCANUSPOSEIDONLEFT HALF BL" +
	"ACK STARRIGHT HALF BLACK STARSTAR WITH LEFT HALF BLACKSTAR WITH RIGHT HA" +
	"LF BLACKLEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSUPWARDS TWO-H" +
	"EADED ARROW WITH TRIANGLE ARROWHEADSRIGHTWARDS TWO-HEADED ARROW WITH TRI" +
	"ANGLE ARROWHEADSDOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSERIS " +
	"FORM ONEERIS FORM TWOSEDNARUSSIAN ASTROLOGICAL SYMBOL VIGINTILERUSSIAN A" +
	"STROLOGICAL SYMBOL NOVILERUSSIAN ASTROLOGICAL SYMBOL QUINTILERUSSIAN AST" +
	"ROLOGICAL SYMBOL BINOVILERUSSIAN ASTROLOGICAL SYMBOL SENTAGONRUSSIAN AST" +
	"ROLOGICAL SYMBOL TREDECILEEQUALS SIGN WITH INFINITY BELOWUNITED SYMBOLSE" +
	"PARATED SYMBOLDOUBLED SYMBOLPASSED SYMBOLREVERSED RIGHT ANGLEHELLSCHREIB" +
	"ER PAUSE SYMBOLGLAGOLITIC CAPITAL LETTER AZUGLAGOLITIC CAPITAL LETTER BU" +
	"KYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC CAPITAL LETTER GLAGOLIGLAGOLI" +
	"TIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL LETTER YESTUGLAGOLITIC CAPITA" +
	"L LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER DZELOGLAGOLITIC CAPITAL LETTER" +
	" ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGOLITIC CAPITAL LETTER INITIAL I" +
	"ZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC CAPITAL LETTER DJERVIGLAGOLITIC" +
	" CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LETTER LJUDIJEGLAGOLITIC CAPITAL " +
	"LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NASHIGLAGOLITIC CAPITAL LETTER O" +
	"NUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLITIC CAPITAL LETTER RITSIGLAGOLI" +
	"TIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL LETTER TVRIDOGLAGOLITIC CAPIT" +
	"AL LETTER UKUGLAGOLITIC CAPITAL LETTER FRITUGLAGOLITIC CAPITAL LETTER HE" +
	"RUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC CAPITAL LETTER PEGLAGOLITIC CA" +
	"PITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER TSIGLAGOLITIC CAPITAL LETTER " +
	"CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLITIC CAPITAL LETTER YERUGLAGOLI" +
	"TIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL LETTER YATIGLAGOLITIC CAPITAL " +
	"LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER YUGLAGOLITIC CAPITAL LETTER S" +
	"MALL YUSGLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAILGLAGOLITIC CAPITAL " +
	"LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED SMALL YUSGLAGOLITIC CAPITAL L" +
	"ETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOTATED BIG YUSGLAGOLITIC CAPITAL" +
	" LETTER FITAGLAGOLITIC CAPITAL LETTER IZHITSAGLAGOLITIC CAPITAL LETTER S" +
	"HTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI AGLAGOLITIC CAPITAL LETTER LA" +
	"TINATE MYSLITEGLAGOLITIC CAPITAL LETTER CAUDATE CHRIVIGLAGOLITIC SMALL L" +
	"ETTER AZUGLAGOLITIC SMALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAGOLI" +
	"TIC SMALL LETTER GLAGOLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL LE" +
	"TTER YESTUGLAGOLITIC SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZELOGL" +
	"AGOLITIC SMALL LETTER ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SMALL" +
	" LETTER INITIAL IZHEGLAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER DJE" +
	"RVIGLAGOLITIC SMALL LETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLITIC" +
	" SMALL LETTER MYSLITEGLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LETTE" +
	"R ONUGLAGOLITIC SMALL LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGOLIT" +
	"IC SMALL LETTER SLOVOGLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL LETT") + ("" +
	"ER UKUGLAGOLITIC SMALL LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOLITI" +
	"C SMALL LETTER OTUGLAGOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER SHTA" +
	"GLAGOLITIC SMALL LETTER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC SMAL" +
	"L LETTER SHAGLAGOLITIC SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIGLAG" +
	"OLITIC SMALL LETTER YATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC SMA" +
	"LL LETTER YUGLAGOLITIC SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER SMA" +
	"LL YUS WITH TAILGLAGOLITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOTATE" +
	"D SMALL YUSGLAGOLITIC SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOTATE" +
	"D BIG YUSGLAGOLITIC SMALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAGLAG" +
	"OLITIC SMALL LETTER SHTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOLITI" +
	"C SMALL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LETTER CAUDATE CHRIVILAT" +
	"IN CAPITAL LETTER L WITH DOUBLE BARLATIN SMALL LETTER L WITH DOUBLE BARL" +
	"ATIN CAPITAL LETTER L WITH MIDDLE TILDELATIN CAPITAL LETTER P WITH STROK" +
	"ELATIN CAPITAL LETTER R WITH TAILLATIN SMALL LETTER A WITH STROKELATIN S" +
	"MALL LETTER T WITH DIAGONAL STROKELATIN CAPITAL LETTER H WITH DESCENDERL" +
	"ATIN SMALL LETTER H WITH DESCENDERLATIN CAPITAL LETTER K WITH DESCENDERL" +
	"ATIN SMALL LETTER K WITH DESCENDERLATIN CAPITAL LETTER Z WITH DESCENDERL" +
	"ATIN SMALL LETTER Z WITH DESCENDERLATIN CAPITAL LETTER ALPHALATIN CAPITA" +
	"L LETTER M WITH HOOKLATIN CAPITAL LETTER TURNED ALATIN CAPITAL LETTER TU" +
	"RNED ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLATIN CAPITAL LETTER W WIT" +
	"H HOOKLATIN SMALL LETTER W WITH HOOKLATIN SMALL LETTER V WITH CURLLATIN " +
	"CAPITAL LETTER HALF HLATIN SMALL LETTER HALF HLATIN SMALL LETTER TAILLES" +
	"S PHILATIN SMALL LETTER E WITH NOTCHLATIN SMALL LETTER TURNED R WITH TAI" +
	"LLATIN SMALL LETTER O WITH LOW RING INSIDELATIN LETTER SMALL CAPITAL TUR" +
	"NED ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETTER CAPITAL VLATIN CAPITA" +
	"L LETTER S WITH SWASH TAILLATIN CAPITAL LETTER Z WITH SWASH TAILCOPTIC C" +
	"APITAL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC CAPITAL LETTER VIDACOPT" +
	"IC SMALL LETTER VIDACOPTIC CAPITAL LETTER GAMMACOPTIC SMALL LETTER GAMMA" +
	"COPTIC CAPITAL LETTER DALDACOPTIC SMALL LETTER DALDACOPTIC CAPITAL LETTE" +
	"R EIECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTER SOUCOPTIC SMALL LETTER" +
	" SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTER ZATACOPTIC CAPITAL LET" +
	"TER HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL LETTER THETHECOPTIC SMALL" +
	" LETTER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC SMALL LETTER IAUDACOPTIC" +
	" CAPITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPTIC CAPITAL LETTER LAULAC" +
	"OPTIC SMALL LETTER LAULACOPTIC CAPITAL LETTER MICOPTIC SMALL LETTER MICO" +
	"PTIC CAPITAL LETTER NICOPTIC SMALL LETTER NICOPTIC CAPITAL LETTER KSICOP" +
	"TIC SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTIC SMALL LETTER OCOPTIC C" +
	"APITAL LETTER PICOPTIC SMALL LETTER PICOPTIC CAPITAL LETTER ROCOPTIC SMA" +
	"LL LETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMALL LETTER SIMACOPTIC CAP" +
	"ITAL LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAPITAL LETTER UACOPTIC SMA" +
	"LL LETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL LETTER FICOPTIC CAPITAL" +
	" LETTER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL LETTER PSICOPTIC SMALL " +
	"LETTER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL LETTER OOUCOPTIC CAPITAL" +
	" LETTER DIALECT-P ALEFCOPTIC SMALL LETTER DIALECT-P ALEFCOPTIC CAPITAL L" +
	"ETTER OLD COPTIC AINCOPTIC SMALL LETTER OLD COPTIC AINCOPTIC CAPITAL LET" +
	"TER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOGRAMMIC EIECOPTIC CAPITAL" +
	" LETTER DIALECT-P KAPACOPTIC SMALL LETTER DIALECT-P KAPACOPTIC CAPITAL L" +
	"ETTER DIALECT-P NICOPTIC SMALL LETTER DIALECT-P NICOPTIC CAPITAL LETTER " +
	"CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMIC NICOPTIC CAPITAL LETTE" +
	"R OLD COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC OOUCOPTIC CAPITAL LETTER " +
	"SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LETTER CROSSED SHEICOPTIC S" +
	"MALL LETTER CROSSED SHEICOPTIC CAPITAL LETTER OLD COPTIC SHEICOPTIC SMAL" +
	"L LETTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OLD COPTIC ESHCOPTIC SMALL" +
	" LETTER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHMIMIC KHEICOPTIC SMALL LE" +
	"TTER AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-P HORICOPTIC SMALL LETTE" +
	"R DIALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC HORICOPTIC SMALL LETTER" +
	" OLD COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC HACOPTIC SMALL LETTER O" +
	"LD COPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOPTIC SMALL LETTER L-SHAPE" +
	"D HACOPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC SMALL LETTER OLD COPTIC H" +
	"EICOPTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMALL LETTER OLD COPTIC HAT" +
	"COPTIC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SMALL LETTER OLD COPTIC GA" +
	"NGIACOPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC SMALL LETTER OLD COPTIC D" +
	"JACOPTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC SMALL LETTER OLD COPTIC S" +
	"HIMACOPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC SMALL LETTER OLD NUBIAN") + ("" +
	" SHIMACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC SMALL LETTER OLD NUBIAN" +
	" NGICOPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC SMALL LETTER OLD NUBIAN N" +
	"YICOPTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMALL LETTER OLD NUBIAN WAU" +
	"COPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBOL PI ROCOPTIC SYMBOL STA" +
	"UROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPTIC SYMBOL SHIMA SIMACOPT" +
	"IC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL LETTER CRYPTOGRAMMIC SH" +
	"EICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPTIC SMALL LETTER CRYPTOGR" +
	"AMMIC GANGIACOPTIC COMBINING NI ABOVECOPTIC COMBINING SPIRITUS ASPERCOPT" +
	"IC COMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER BOHAIRIC KHEICOPTIC SMA" +
	"LL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL STOPCOPTIC OLD NUBIAN DIRE" +
	"CT QUESTION MARKCOPTIC OLD NUBIAN INDIRECT QUESTION MARKCOPTIC OLD NUBIA" +
	"N VERSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FULL STOPCOPTIC MORPHOLOGI" +
	"CAL DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMALL LETTER BANGEORGIAN SMA" +
	"LL LETTER GANGEORGIAN SMALL LETTER DONGEORGIAN SMALL LETTER ENGEORGIAN S" +
	"MALL LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN SMALL LETTER TANGEORGIA" +
	"N SMALL LETTER INGEORGIAN SMALL LETTER KANGEORGIAN SMALL LETTER LASGEORG" +
	"IAN SMALL LETTER MANGEORGIAN SMALL LETTER NARGEORGIAN SMALL LETTER ONGEO" +
	"RGIAN SMALL LETTER PARGEORGIAN SMALL LETTER ZHARGEORGIAN SMALL LETTER RA" +
	"EGEORGIAN SMALL LETTER SANGEORGIAN SMALL LETTER TARGEORGIAN SMALL LETTER" +
	" UNGEORGIAN SMALL LETTER PHARGEORGIAN SMALL LETTER KHARGEORGIAN SMALL LE" +
	"TTER GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL LETTER SHINGEORGIAN SMA" +
	"LL LETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN SMALL LETTER JILGEORGIAN" +
	" SMALL LETTER CILGEORGIAN SMALL LETTER CHARGEORGIAN SMALL LETTER XANGEOR" +
	"GIAN SMALL LETTER JHANGEORGIAN SMALL LETTER HAEGEORGIAN SMALL LETTER HEG" +
	"EORGIAN SMALL LETTER HIEGEORGIAN SMALL LETTER WEGEORGIAN SMALL LETTER HA" +
	"RGEORGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER YNGEORGIAN SMALL LETTER " +
	"AENTIFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH LETTER YABHTIFINAGH LET" +
	"TER YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERBER ACADEMY YAJTIFINAGH L" +
	"ETTER YAJTIFINAGH LETTER YADTIFINAGH LETTER YADHTIFINAGH LETTER YADDTIFI" +
	"NAGH LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LETTER YAFTIFINAGH LETTER Y" +
	"AKTIFINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKHHTIFINAGH LETTER YAHTIFI" +
	"NAGH LETTER BERBER ACADEMY YAHTIFINAGH LETTER TUAREG YAHTIFINAGH LETTER " +
	"YAHHTIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFINAGH LETTER TUAREG YAKHTI" +
	"FINAGH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFINAGH LETTER YITIFINAGH LE" +
	"TTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LETTER TUAREG YAZHTIFINAGH" +
	" LETTER YALTIFINAGH LETTER YAMTIFINAGH LETTER YANTIFINAGH LETTER TUAREG " +
	"YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH LETTER YAPTIFINAGH LETTER YUTIFI" +
	"NAGH LETTER YARTIFINAGH LETTER YARRTIFINAGH LETTER YAGHTIFINAGH LETTER T" +
	"UAREG YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETTER YASTIFINAGH LETTER YA" +
	"SSTIFINAGH LETTER YASHTIFINAGH LETTER YATTIFINAGH LETTER YATHTIFINAGH LE" +
	"TTER YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAVTIFINAGH LETTER YAWTIFIN" +
	"AGH LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER TAWELLEMET YAZTIFINAGH " +
	"LETTER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOTIFINAGH MODIFIER LETTER " +
	"LABIALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAGH CONSONANT JOINERETHIOP" +
	"IC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYLLABLE ROAETHIOPIC SYLLAB" +
	"LE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BOAETHIOPIC SYLLABLE TOAET" +
	"HIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC SYLLABLE NYOAETHIOPIC S" +
	"YLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC SYLLABLE DOAETHIOPIC SYL" +
	"LABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE THOAETHIOPIC SYLLABLE C" +
	"HOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAETHIOPIC SYLLABLE GGWAETHI" +
	"OPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPIC SYLLABLE GGWEETHIOPIC " +
	"SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLABLE SSIETHIOPIC SYLLABLE " +
	"SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEETHIOPIC SYLLABLE SSOETHI" +
	"OPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC SYLLABLE CCIETHIOPIC SYLL" +
	"ABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE CCEETHIOPIC SYLLABLE CC" +
	"OETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIOPIC SYLLABLE ZZIETHIOPIC" +
	" SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYLLABLE ZZEETHIOPIC SYLLAB" +
	"LE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CCHUETHIOPIC SYLLABLE CCHI" +
	"ETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEETHIOPIC SYLLABLE CCHEETHI" +
	"OPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC SYLLABLE QYUETHIOPIC SYL" +
	"LABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE QYEEETHIOPIC SYLLABLE Q" +
	"YEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHIOPIC SYLLABLE KYUETHIOPI" +
	"C SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYLLABLE KYEEETHIOPIC SYLLA" +
	"BLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XYAETHIOPIC SYLLABLE XYUET") + ("" +
	"HIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPIC SYLLABLE XYEEETHIOPIC " +
	"SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLABLE GYAETHIOPIC SYLLABLE " +
	"GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAETHIOPIC SYLLABLE GYEEETHI" +
	"OPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING CYRILLIC LETTER BECOMBIN" +
	"ING CYRILLIC LETTER VECOMBINING CYRILLIC LETTER GHECOMBINING CYRILLIC LE" +
	"TTER DECOMBINING CYRILLIC LETTER ZHECOMBINING CYRILLIC LETTER ZECOMBININ" +
	"G CYRILLIC LETTER KACOMBINING CYRILLIC LETTER ELCOMBINING CYRILLIC LETTE" +
	"R EMCOMBINING CYRILLIC LETTER ENCOMBINING CYRILLIC LETTER OCOMBINING CYR" +
	"ILLIC LETTER PECOMBINING CYRILLIC LETTER ERCOMBINING CYRILLIC LETTER ESC" +
	"OMBINING CYRILLIC LETTER TECOMBINING CYRILLIC LETTER HACOMBINING CYRILLI" +
	"C LETTER TSECOMBINING CYRILLIC LETTER CHECOMBINING CYRILLIC LETTER SHACO" +
	"MBINING CYRILLIC LETTER SHCHACOMBINING CYRILLIC LETTER FITACOMBINING CYR" +
	"ILLIC LETTER ES-TECOMBINING CYRILLIC LETTER ACOMBINING CYRILLIC LETTER I" +
	"ECOMBINING CYRILLIC LETTER DJERVCOMBINING CYRILLIC LETTER MONOGRAPH UKCO" +
	"MBINING CYRILLIC LETTER YATCOMBINING CYRILLIC LETTER YUCOMBINING CYRILLI" +
	"C LETTER IOTIFIED ACOMBINING CYRILLIC LETTER LITTLE YUSCOMBINING CYRILLI" +
	"C LETTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFIED BIG YUSRIGHT ANGLE SU" +
	"BSTITUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION MARKERLEFT SUBSTITUTION" +
	" BRACKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SUBSTITUTION BRACKETRIGHT " +
	"DOTTED SUBSTITUTION BRACKETRAISED INTERPOLATION MARKERRAISED DOTTED INTE" +
	"RPOLATION MARKERDOTTED TRANSPOSITION MARKERLEFT TRANSPOSITION BRACKETRIG" +
	"HT TRANSPOSITION BRACKETRAISED SQUARELEFT RAISED OMISSION BRACKETRIGHT R" +
	"AISED OMISSION BRACKETEDITORIAL CORONISPARAGRAPHOSFORKED PARAGRAPHOSREVE" +
	"RSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOSDOWNWARDS ANCORAUPWARDS " +
	"ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE HYPHENINVERTED INTERROBA" +
	"NGPALM BRANCHHYPHEN WITH DIAERESISTILDE WITH RING ABOVELEFT LOW PARAPHRA" +
	"SE BRACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH DOT ABOVETILDE WITH DOT" +
	" BELOWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL BAR WITH QUILLTOP LEFT " +
	"HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HALF BRACKETBOTTOM RIGHT H" +
	"ALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS U BRACKETLEFT DOUBLE PA" +
	"RENTHESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER ONE DOT PUNCTUATIONONE DO" +
	"T OVER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNCTUATIONFIVE DOT MARKREVE" +
	"RSED QUESTION MARKVERTICAL TILDERING POINTWORD SEPARATOR MIDDLE DOTTURNE" +
	"D COMMARAISED DOTRAISED COMMATURNED SEMICOLONDAGGER WITH LEFT GUARDDAGGE" +
	"R WITH RIGHT GUARDTURNED DAGGERTOP HALF SECTION SIGNTWO-EM DASHTHREE-EM " +
	"DASHSTENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGLY VERTICAL LINECAPITULUM" +
	"DOUBLE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9 QUOTATION MARKDASH WITH" +
	" LEFT UPTURNDOUBLE SUSPENSION MARKINVERTED LOW KAVYKAINVERTED LOW KAVYKA" +
	" WITH KAVYKA ABOVELOW KAVYKALOW KAVYKA WITH DOTDOUBLE STACKED COMMADOTTE" +
	"D SOLIDUSTRIPLE DAGGERMEDIEVAL COMMAPARAGRAPHUS MARKPUNCTUS ELEVATUS MAR" +
	"KCORNISH VERSE DIVIDERCROSS PATTY WITH RIGHT CROSSBARCROSS PATTY WITH LE" +
	"FT CROSSBARTIRONIAN SIGN CAPITAL ETMEDIEVAL EXCLAMATION MARKMEDIEVAL QUE" +
	"STION MARKLEFT SQUARE BRACKET WITH STROKERIGHT SQUARE BRACKET WITH STROK" +
	"ELEFT SQUARE BRACKET WITH DOUBLE STROKERIGHT SQUARE BRACKET WITH DOUBLE " +
	"STROKETOP HALF LEFT PARENTHESISTOP HALF RIGHT PARENTHESISBOTTOM HALF LEF" +
	"T PARENTHESISBOTTOM HALF RIGHT PARENTHESISOBLIQUE HYPHENCJK RADICAL REPE" +
	"ATCJK RADICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND TWOCJK RADIC" +
	"AL SECOND THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL TABLECJK RAD" +
	"ICAL KNIFE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJK RADICAL SEA" +
	"LCJK RADICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME ONECJK RADIC" +
	"AL LAME TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK RADICAL SNAKEC" +
	"JK RADICAL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWOCJK RADICAL H" +
	"EART ONECJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RAPCJK RADICAL " +
	"CHOKECJK RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RADICAL MOTHERC" +
	"JK RADICAL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER TWOCJK RADICAL" +
	" FIRECJK RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMPLIFIED HALF T" +
	"REE TRUNKCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK RADICAL BOLT " +
	"OF CLOTHCJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SPIRIT TWOCJK R" +
	"ADICAL BAMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKCJK RADICAL NE" +
	"T ONECJK RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NET FOURCJK RAD" +
	"ICAL MESHCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK RADICAL OLDC" +
	"JK RADICAL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJK RADICAL MOR" +
	"TARCJK RADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GRASS THREECJK " +
	"RADICAL TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RADICAL WEST TWO") + ("" +
	"CJK RADICAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK RADICAL HORNC" +
	"JK RADICAL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHELLCJK RADICAL " +
	"FOOTCJK RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WALKCJK RADICAL " +
	"WALK ONECJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-SIMPLIFIED GOL" +
	"DCJK RADICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMPLIFIED LONGCJ" +
	"K RADICAL C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL MOUND TWOCJK" +
	" RADICAL RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNED LEATHERCJK " +
	"RADICAL C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK RADICAL C-SIMP" +
	"LIFIED FLYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL EAT THREECJK" +
	" RADICAL C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMPLIFIED HORSEC" +
	"JK RADICAL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FISHCJK RADICAL" +
	" C-SIMPLIFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL SIMPLIFIED WH" +
	"EATCJK RADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FROGCJK RADICAL" +
	" J-SIMPLIFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL J-SIMPLIFIED " +
	"TOOTHCJK RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED DRAGONCJK RA" +
	"DICAL C-SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SIMPLIFIED TURT" +
	"LECJK RADICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI RADICAL LINEKA" +
	"NGXI RADICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKANGXI RADICAL " +
	"HOOKKANGXI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANKANGXI RADICAL" +
	" LEGSKANGXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL DOWN BOXKANG" +
	"XI RADICAL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGXI RADICAL OPE" +
	"N BOXKANGXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL WRAPKANGXI R" +
	"ADICAL SPOONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HIDING ENCLOSURE" +
	"KANGXI RADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL SEALKANGXI RAD" +
	"ICAL CLIFFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI RADICAL MOUTH" +
	"KANGXI RADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL SCHOLARKANGXI" +
	" RADICAL GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKANGXI RADICAL " +
	"BIGKANGXI RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL ROOFKANGXI RAD" +
	"ICAL INCHKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADICAL CORPSEKAN" +
	"GXI RADICAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIVERKANGXI RADI" +
	"CAL WORKKANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI RADICAL DRYKAN" +
	"GXI RADICAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI RADICAL LONG S" +
	"TRIDEKANGXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RADICAL BOWKANGX" +
	"I RADICAL SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKANGXI RADICAL H" +
	"EARTKANGXI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL HANDKANGXI R" +
	"ADICAL BRANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI RADICAL DIPPE" +
	"RKANGXI RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTKANGXI RADICAL" +
	" SUNKANGXI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TREEKANGXI RADIC" +
	"AL LACKKANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICAL WEAPONKANGX" +
	"I RADICAL DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKANGXI RADICAL C" +
	"LANKANGXI RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL FIREKANGXI RAD" +
	"ICAL CLAWKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI RADICAL HALF" +
	" TREE TRUNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RADICAL COWKANG" +
	"XI RADICAL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKANGXI RADICAL M" +
	"ELONKANGXI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL LIFEKANGXI RAD" +
	"ICAL USEKANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKANGXI RADICAL S" +
	"ICKNESSKANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI RADICAL SKIN" +
	"KANGXI RADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKANGXI RADICAL " +
	"ARROWKANGXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICAL TRACKKANGXI" +
	" RADICAL GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI RADICAL BAMB" +
	"OOKANGXI RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARKANGXI RADICAL" +
	" NETKANGXI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICAL OLDKANGXI R" +
	"ADICAL ANDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADICAL BRUSHKANGX" +
	"I RADICAL MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKANGXI RADICAL A" +
	"RRIVEKANGXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADICAL OPPOSEKANG" +
	"XI RADICAL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORKANGXI RADICAL" +
	" GRASSKANGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADICAL BLOODKANGX" +
	"I RADICAL WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICAL WESTKANGXI " +
	"RADICAL SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI RADICAL VALLEY" +
	"KANGXI RADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERKANGXI RADICAL" +
	" SHELLKANGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FOOTKANGXI RADI" +
	"CAL BODYKANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADICAL MORNINGKA" +
	"NGXI RADICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANGXI RADICAL DI" +
	"STINGUISHKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RADICAL LONGKAN") + ("" +
	"GXI RADICAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKANGXI RADICAL S" +
	"HORT TAILED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGXI RADICAL WRO" +
	"NGKANGXI RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL TANNED LEATHER" +
	"KANGXI RADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFKANGXI RADICAL" +
	" WINDKANGXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEADKANGXI RADIC" +
	"AL FRAGRANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RADICAL TALLKAN" +
	"GXI RADICAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFICIAL WINEKANGX" +
	"I RADICAL CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKANGXI RADICAL " +
	"BIRDKANGXI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WHEATKANGXI RAD" +
	"ICAL HEMPKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI RADICAL BLACKK" +
	"ANGXI RADICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL TRIPODKANGXI R" +
	"ADICAL DRUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADICAL EVENKANGX" +
	"I RADICAL TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKANGXI RADICAL " +
	"FLUTEIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRAPHIC DESCRIPT" +
	"ION CHARACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MI" +
	"DDLE AND RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELO" +
	"WIDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC DESCRIPTION " +
	"CHARACTER SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND " +
	"FROM BELOWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFTIDEOGRAPHI" +
	"C DESCRIPTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC DESCRIPTION " +
	"CHARACTER SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER SUR" +
	"ROUND FROM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVERLAIDIDEOGRAPH" +
	"IC SPACEIDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAPANESE INDUSTR" +
	"IAL STANDARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CLOSING MARKIDE" +
	"OGRAPHIC NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLEFT DOUBLE ANG" +
	"LE BRACKETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGHT CORNER BRAC" +
	"KETLEFT WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT BLACK LENTICU" +
	"LAR BRACKETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MARKLEFT TORTOI" +
	"SE SHELL BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENTICULAR BRACKE" +
	"TRIGHT WHITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BRACKETRIGHT WH" +
	"ITE TORTOISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WHITE SQUARE BR" +
	"ACKETWAVE DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PRIME QUOTATION" +
	" MARKLOW DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHOU NUMERAL ONE" +
	"HANGZHOU NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL FOURHANGZHOU " +
	"NUMERAL FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZHOU NUMERAL E" +
	"IGHTHANGZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRAPHIC RISING T" +
	"ONE MARKIDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING TONE MARKHAN" +
	"GUL SINGLE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DASHVERTICAL KAN" +
	"A REPEAT MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVERTICAL KANA RE" +
	"PEAT MARK UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HA" +
	"LFVERTICAL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKIDEOGRAPHIC TEL" +
	"EGRAPH LINE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZHOU NUMERAL TW" +
	"ENTYHANGZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION MARKMASU MARKP" +
	"ART ALTERNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAPHIC HALF FILL" +
	" SPACEHIRAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETTER SMALL IHIR" +
	"AGANA LETTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAGANA LETTER SM" +
	"ALL EHIRAGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTER OHIRAGANA L" +
	"ETTER KAHIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER GIHIRAGANA L" +
	"ETTER KUHIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER GEHIRAGANA L" +
	"ETTER KOHIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER ZAHIRAGANA L" +
	"ETTER SIHIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER ZUHIRAGANA L" +
	"ETTER SEHIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER ZOHIRAGANA L" +
	"ETTER TAHIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER DIHIRAGANA L" +
	"ETTER SMALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA LETTER TEHIRA" +
	"GANA LETTER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA LETTER NAHIRA" +
	"GANA LETTER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA LETTER NOHIRA" +
	"GANA LETTER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA LETTER HIHIRA" +
	"GANA LETTER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA LETTER BUHIRA" +
	"GANA LETTER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA LETTER PEHIRA" +
	"GANA LETTER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA LETTER MAHIRA" +
	"GANA LETTER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA LETTER MOHIRA" +
	"GANA LETTER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL YUHIRAGANA L" +
	"ETTER YUHIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA LETTER RAHIRA" +
	"GANA LETTER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA LETTER ROHIRA") + ("" +
	"GANA LETTER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIRAGANA LETTER " +
	"WEHIRAGANA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRAGANA LETTER S" +
	"MALL KAHIRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA VOICED SOUND " +
	"MARKCOMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAKANA-HIRAGANA " +
	"VOICED SOUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHIRAGANA ITERAT" +
	"ION MARKHIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORIKATAKANA-HIRA" +
	"GANA DOUBLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AKATAKANA LETTE" +
	"R SMALL IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA LETTER UKATAKA" +
	"NA LETTER SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKATAKANA LETTER" +
	" OKATAKANA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKATAKANA LETTER " +
	"GIKATAKANA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKATAKANA LETTER " +
	"GEKATAKANA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKATAKANA LETTER " +
	"ZAKATAKANA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKATAKANA LETTER " +
	"ZUKATAKANA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKATAKANA LETTER " +
	"ZOKATAKANA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKATAKANA LETTER " +
	"DIKATAKANA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER DUKATAKANA L" +
	"ETTER TEKATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER DOKATAKANA L" +
	"ETTER NAKATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER NEKATAKANA L" +
	"ETTER NOKATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER PAKATAKANA L" +
	"ETTER HIKATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER HUKATAKANA L" +
	"ETTER BUKATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER BEKATAKANA L" +
	"ETTER PEKATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER POKATAKANA L" +
	"ETTER MAKATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER MEKATAKANA L" +
	"ETTER MOKATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA LETTER SMALL " +
	"YUKATAKANA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER YOKATAKANA L" +
	"ETTER RAKATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER REKATAKANA L" +
	"ETTER ROKATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA LETTER WIKATA" +
	"KANA LETTER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA LETTER VUKATAK" +
	"ANA LETTER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER VAKATAKANA LE" +
	"TTER VIKATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE DOTKATAKANA-H" +
	"IRAGANA PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA VOICED ITERA" +
	"TION MARKKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LETTER PBOPOMOFO" +
	" LETTER MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER TBOPOMOFO LET" +
	"TER NBOPOMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOPOMOFO LETTER " +
	"HBOPOMOFO LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOFO LETTER ZHBO" +
	"POMOFO LETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO LETTER ZBOPO" +
	"MOFO LETTER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LETTER OBOPOMOFO" +
	" LETTER EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTER EIBOPOMOFO " +
	"LETTER AUBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTER ENBOPOMOFO " +
	"LETTER ANGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LETTER IBOPOMOFO" +
	" LETTER UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER NGBOPOMOFO L" +
	"ETTER GNBOPOMOFO LETTER IHBOPOMOFO LETTER O WITH DOT ABOVEBOPOMOFO LETTE" +
	"R NNHANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL LETTER KIYEOK-SI" +
	"OSHANGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LETTER NIEUN-HIEUHH" +
	"ANGUL LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTER RIEULHANGUL LE" +
	"TTER RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER RIEUL-PIEUPHANGU" +
	"L LETTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LETTER RIEUL-PHIEUP" +
	"HHANGUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETTER PIEUPHANGUL L" +
	"ETTER SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SIOSHANGUL LETTER " +
	"SSANGSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LETTER SSANGCIEUCH" +
	"ANGUL LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER THIEUTHHANGUL LET" +
	"TER PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETTER AEHANGUL LETT" +
	"ER YAHANGUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHANGUL LETTER YEOHA" +
	"NGUL LETTER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETTER WAEHANGUL LET" +
	"TER OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHANGUL LETTER WEHA" +
	"NGUL LETTER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LETTER YIHANGUL LET" +
	"TER IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER NIEUN-TIKEUTHANG" +
	"UL LETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LETTER RIEUL-KIYEO" +
	"K-SIOSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEUP-SIOSHANGUL LET" +
	"TER RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL LETTER MIEUM-PIEU" +
	"PHANGUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANGUL LETTER KAPYEO" +
	"UNMIEUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIKEUTHANGUL LETTER" +
	" PIEUP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL LETTER PIEUP-CIE" +
	"UCHANGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUPHANGUL LETTER KA") + ("" +
	"PYEOUNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER SIOS-NIEUNHANGUL " +
	"LETTER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER SIOS-CIEUCHANGUL" +
	" LETTER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YESIEUNGHANGUL LETT" +
	"ER YESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LETTER KAPYEOUNPHIE" +
	"UPHHANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANGUL LETTER YO-YAH" +
	"ANGUL LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YEOHANGUL LETTER Y" +
	"U-YEHANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER ARAEAEIDEOGRAPHIC" +
	" ANNOTATION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE MARKIDEOGRAPHIC A" +
	"NNOTATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRAPHIC ANNOTATION " +
	"THREE MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC ANNOTATION TOP MAR" +
	"KIDEOGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATION BOTTOM MARKIDE" +
	"OGRAPHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SECOND MARKIDEOGRAP" +
	"HIC ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH MARKIDEOGRAPHIC A" +
	"NNOTATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKIDEOGRAPHIC ANNOTA" +
	"TION MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOFO LETTER JIBOPOM" +
	"OFO LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMOFO LETTER OOBOPO" +
	"MOFO LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPOMOFO LETTER INNB" +
	"OPOMOFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGBOPOMOFO LETTER A" +
	"INNBOPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER OMBOPOMOFO LETT" +
	"ER ONGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOFO FINAL LETTER T" +
	"BOPOMOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO LETTER GHBOPOMOFO" +
	" LETTER LHBOPOMOFO LETTER ZYBOPOMOFO FINAL LETTER GBOPOMOFO LETTER GWBOP" +
	"OMOFO LETTER KWBOPOMOFO LETTER OEBOPOMOFO LETTER AHCJK STROKE TCJK STROK" +
	"E WGCJK STROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZG" +
	"CJK STROKE HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZP" +
	"CJK STROKE HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK " +
	"STROKE SCJK STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGC" +
	"JK STROKE SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STR" +
	"OKE PZCJK STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE" +
	" HZZZGCJK STROKE PGCJK STROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER S" +
	"MALL SIKATAKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER S" +
	"MALL NUKATAKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER S" +
	"MALL HUKATAKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER S" +
	"MALL MUKATAKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER S" +
	"MALL RUKATAKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HAN" +
	"GUL KIYEOKPARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHES" +
	"IZED HANGUL RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPAR" +
	"ENTHESIZED HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIE" +
	"UCPARENTHESIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED " +
	"HANGUL THIEUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARE" +
	"NTHESIZED HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGU" +
	"L TIKEUT APARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENT" +
	"HESIZED HANGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IE" +
	"UNG APARENTHESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHES" +
	"IZED HANGUL KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL " +
	"PHIEUPH APARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTH" +
	"ESIZED KOREAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHE" +
	"SIZED IDEOGRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH TH" +
	"REEPARENTHESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED" +
	" IDEOGRAPH SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHT" +
	"PARENTHESIZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDE" +
	"OGRAPH MOONPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARE" +
	"NTHESIZED IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOG" +
	"RAPH EARTHPARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENT" +
	"HESIZED IDEOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOG" +
	"RAPH NAMEPARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIA" +
	"LPARENTHESIZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARE" +
	"NTHESIZED IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED I" +
	"DEOGRAPH STUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH E" +
	"NTERPRISEPARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANC" +
	"EPARENTHESIZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZ" +
	"ED IDEOGRAPH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTION" +
	"CIRCLED IDEOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH " +
	"KOTOCIRCLED NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQU") + ("" +
	"ARECIRCLED NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQ" +
	"UARECIRCLED NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQ" +
	"UARECIRCLED NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK" +
	" SQUAREPARTNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TW" +
	"OCIRCLED NUMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWE" +
	"NTY FIVECIRCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMB" +
	"ER TWENTY EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NU" +
	"MBER THIRTY ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCL" +
	"ED NUMBER THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRC" +
	"LED HANGUL NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL " +
	"MIEUMCIRCLED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED " +
	"HANGUL CIEUCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL T" +
	"HIEUTHCIRCLED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK AC" +
	"IRCLED HANGUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLE" +
	"D HANGUL MIEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGU" +
	"L IEUNG ACIRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KH" +
	"IEUKH ACIRCLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HI" +
	"EUH ACIRCLED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLE" +
	"D HANGUL IEUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOG" +
	"RAPH TWOCIRCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH F" +
	"IVECIRCLED IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCI" +
	"RCLED IDEOGRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED I" +
	"DEOGRAPH FIRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGR" +
	"APH METALCIRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH S" +
	"TOCKCIRCLED IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAM" +
	"ECIRCLED IDEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH C" +
	"ONGRATULATIONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEO" +
	"GRAPH MALECIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEO" +
	"GRAPH EXCELLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED" +
	" IDEOGRAPH ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOG" +
	"RAPH CORRECTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGR" +
	"APH LOWCIRCLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH ME" +
	"DICINECIRCLED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH" +
	" SUPERVISECIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED " +
	"IDEOGRAPH ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLE" +
	"D NUMBER THIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NI" +
	"NECIRCLED NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCI" +
	"RCLED NUMBER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FI" +
	"VECIRCLED NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY" +
	" EIGHTCIRCLED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC " +
	"TELEGRAPH SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRA" +
	"PHIC TELEGRAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR " +
	"OCTOBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR DECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCL" +
	"ED KATAKANA ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCL" +
	"ED KATAKANA OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCI" +
	"RCLED KATAKANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA " +
	"SICIRCLED KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAK" +
	"ANA TACIRCLED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED K" +
	"ATAKANA TOCIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCL" +
	"ED KATAKANA NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HIC" +
	"IRCLED KATAKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA" +
	" MACIRCLED KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATA" +
	"KANA MOCIRCLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED " +
	"KATAKANA RACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRC" +
	"LED KATAKANA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WE" +
	"CIRCLED KATAKANA WOSQUARE ERA NAME REIWASQUARE APAATOSQUARE ARUHUASQUARE" +
	" ANPEASQUARE AARUSQUARE ININGUSQUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE" +
	" EEKAASQUARE ONSUSQUARE OOMUSQUARE KAIRISQUARE KARATTOSQUARE KARORIISQUA" +
	"RE GARONSQUARE GANMASQUARE GIGASQUARE GINIISQUARE KYURIISQUARE GIRUDAASQ" +
	"UARE KIROSQUARE KIROGURAMUSQUARE KIROMEETORUSQUARE KIROWATTOSQUARE GURAM") + ("" +
	"USQUARE GURAMUTONSQUARE KURUZEIROSQUARE KUROONESQUARE KEESUSQUARE KORUNA" +
	"SQUARE KOOPOSQUARE SAIKURUSQUARE SANTIIMUSQUARE SIRINGUSQUARE SENTISQUAR" +
	"E SENTOSQUARE DAASUSQUARE DESISQUARE DORUSQUARE TONSQUARE NANOSQUARE NOT" +
	"TOSQUARE HAITUSQUARE PAASENTOSQUARE PAATUSQUARE BAARERUSQUARE PIASUTORUS" +
	"QUARE PIKURUSQUARE PIKOSQUARE BIRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUS" +
	"SYERUSQUARE HURANSQUARE HEKUTAARUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQ" +
	"UARE PENSUSQUARE PEEZISQUARE BEETASQUARE POINTOSQUARE BORUTOSQUARE HONSQ" +
	"UARE PONDOSQUARE HOORUSQUARE HOONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHAS" +
	"QUARE MARUKUSQUARE MANSYONSQUARE MIKURONSQUARE MIRISQUARE MIRIBAARUSQUAR" +
	"E MEGASQUARE MEGATONSQUARE MEETORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQU" +
	"ARE RITTORUSQUARE RIRASQUARE RUPIISQUARE RUUBURUSQUARE REMUSQUARE RENTOG" +
	"ENSQUARE WATTOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR HOUR ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HO" +
	"UR FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR HOUR SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR HOUR EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NI" +
	"NEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR HOUR ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR F" +
	"OURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR HOUR SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" HOUR TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOURSQUARE HPASQUARE DASQUARE AUS" +
	"QUARE BARSQUARE OVSQUARE PCSQUARE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUA" +
	"RE IUSQUARE ERA NAME HEISEISQUARE ERA NAME SYOUWASQUARE ERA NAME TAISYOU" +
	"SQUARE ERA NAME MEIZISQUARE CORPORATIONSQUARE PA AMPSSQUARE NASQUARE MU " +
	"ASQUARE MASQUARE KASQUARE KBSQUARE MBSQUARE GBSQUARE CALSQUARE KCALSQUAR" +
	"E PFSQUARE NFSQUARE MU FSQUARE MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZ" +
	"SQUARE MHZSQUARE GHZSQUARE THZSQUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUA" +
	"RE FMSQUARE NMSQUARE MU MSQUARE MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQU" +
	"ARE CM SQUAREDSQUARE M SQUAREDSQUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM " +
	"CUBEDSQUARE M CUBEDSQUARE KM CUBEDSQUARE M OVER SSQUARE M OVER S SQUARED" +
	"SQUARE PASQUARE KPASQUARE MPASQUARE GPASQUARE RADSQUARE RAD OVER SSQUARE" +
	" RAD OVER S SQUAREDSQUARE PSSQUARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE" +
	" NVSQUARE MU VSQUARE MVSQUARE KVSQUARE MV MEGASQUARE PWSQUARE NWSQUARE M" +
	"U WSQUARE MWSQUARE KWSQUARE MW MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUA" +
	"RE BQSQUARE CCSQUARE CDSQUARE C OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE" +
	" HASQUARE HPSQUARE INSQUARE KKSQUARE KM CAPITALSQUARE KTSQUARE LMSQUARE " +
	"LNSQUARE LOGSQUARE LXSQUARE MB SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE " +
	"PMSQUARE PPMSQUARE PRSQUARE SRSQUARE SVSQUARE WBSQUARE V OVER MSQUARE A " +
	"OVER MIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR DAY FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY S" +
	"EVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEG" +
	"RAPH SYMBOL FOR DAY ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL F" +
	"OR DAY FOURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR DAY SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVE" +
	"NTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH " +
	"SYMBOL FOR DAY NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRA" +
	"PHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY TWENTY-FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY TWENTY-EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DA" +
	"Y THIRTY-ONESQUARE GALHEXAGRAM FOR THE CREATIVE HEAVENHEXAGRAM FOR THE R") + ("" +
	"ECEPTIVE EARTHHEXAGRAM FOR DIFFICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTH" +
	"FUL FOLLYHEXAGRAM FOR WAITINGHEXAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYH" +
	"EXAGRAM FOR HOLDING TOGETHERHEXAGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADI" +
	"NGHEXAGRAM FOR PEACEHEXAGRAM FOR STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGR" +
	"AM FOR GREAT POSSESSIONHEXAGRAM FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGR" +
	"AM FOR FOLLOWINGHEXAGRAM FOR WORK ON THE DECAYEDHEXAGRAM FOR APPROACHHEX" +
	"AGRAM FOR CONTEMPLATIONHEXAGRAM FOR BITING THROUGHHEXAGRAM FOR GRACEHEXA" +
	"GRAM FOR SPLITTING APARTHEXAGRAM FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRA" +
	"M FOR GREAT TAMINGHEXAGRAM FOR MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDER" +
	"ANCEHEXAGRAM FOR THE ABYSMAL WATERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM" +
	" FOR INFLUENCEHEXAGRAM FOR DURATIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREA" +
	"T POWERHEXAGRAM FOR PROGRESSHEXAGRAM FOR DARKENING OF THE LIGHTHEXAGRAM " +
	"FOR THE FAMILYHEXAGRAM FOR OPPOSITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FO" +
	"R DELIVERANCEHEXAGRAM FOR DECREASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREA" +
	"KTHROUGHHEXAGRAM FOR COMING TO MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGR" +
	"AM FOR PUSHING UPWARDHEXAGRAM FOR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRA" +
	"M FOR REVOLUTIONHEXAGRAM FOR THE CAULDRONHEXAGRAM FOR THE AROUSING THUND" +
	"ERHEXAGRAM FOR THE KEEPING STILL MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRA" +
	"M FOR THE MARRYING MAIDENHEXAGRAM FOR ABUNDANCEHEXAGRAM FOR THE WANDERER" +
	"HEXAGRAM FOR THE GENTLE WINDHEXAGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DIS" +
	"PERSIONHEXAGRAM FOR LIMITATIONHEXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL" +
	" PREPONDERANCEHEXAGRAM FOR AFTER COMPLETIONHEXAGRAM FOR BEFORE COMPLETIO" +
	"NYI SYLLABLE ITYI SYLLABLE IXYI SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETY" +
	"I SYLLABLE IEXYI SYLLABLE IEYI SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXY" +
	"I SYLLABLE AYI SYLLABLE APYI SYLLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI" +
	" SYLLABLE OTYI SYLLABLE OXYI SYLLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SY" +
	"LLABLE EYI SYLLABLE WUYI SYLLABLE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYL" +
	"LABLE BIPYI SYLLABLE BIETYI SYLLABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEP" +
	"YI SYLLABLE BATYI SYLLABLE BAXYI SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE B" +
	"UOXYI SYLLABLE BUOYI SYLLABLE BUOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLA" +
	"BLE BOYI SYLLABLE BOPYI SYLLABLE BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLL" +
	"ABLE BUTYI SYLLABLE BUXYI SYLLABLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI S" +
	"YLLABLE BURYI SYLLABLE BYTYI SYLLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI" +
	" SYLLABLE BYRXYI SYLLABLE BYRYI SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE P" +
	"IYI SYLLABLE PIPYI SYLLABLE PIEXYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLAB" +
	"LE PATYI SYLLABLE PAXYI SYLLABLE PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYL" +
	"LABLE PUOYI SYLLABLE PUOPYI SYLLABLE POTYI SYLLABLE POXYI SYLLABLE POYI " +
	"SYLLABLE POPYI SYLLABLE PUTYI SYLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPY" +
	"I SYLLABLE PURXYI SYLLABLE PURYI SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE " +
	"PYYI SYLLABLE PYPYI SYLLABLE PYRXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLA" +
	"BLE BBIXYI SYLLABLE BBIYI SYLLABLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIE" +
	"XYI SYLLABLE BBIEYI SYLLABLE BBIEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYL" +
	"LABLE BBAYI SYLLABLE BBAPYI SYLLABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BB" +
	"UOPYI SYLLABLE BBOTYI SYLLABLE BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYL" +
	"LABLE BBEXYI SYLLABLE BBEYI SYLLABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBU" +
	"XYI SYLLABLE BBUYI SYLLABLE BBUPYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLL" +
	"ABLE BBYTYI SYLLABLE BBYXYI SYLLABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBIT" +
	"YI SYLLABLE NBIXYI SYLLABLE NBIYI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLA" +
	"BLE NBIEYI SYLLABLE NBIEPYI SYLLABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBA" +
	"YI SYLLABLE NBAPYI SYLLABLE NBOTYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLAB" +
	"LE NBOPYI SYLLABLE NBUTYI SYLLABLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI" +
	" SYLLABLE NBURXYI SYLLABLE NBURYI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLAB" +
	"LE NBYYI SYLLABLE NBYPYI SYLLABLE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITY" +
	"I SYLLABLE HMIXYI SYLLABLE HMIYI SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLAB" +
	"LE HMIEYI SYLLABLE HMIEPYI SYLLABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAY" +
	"I SYLLABLE HMAPYI SYLLABLE HMUOXYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLL" +
	"ABLE HMOTYI SYLLABLE HMOXYI SYLLABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUT" +
	"YI SYLLABLE HMUXYI SYLLABLE HMUYI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLA" +
	"BLE HMURYI SYLLABLE HMYXYI SYLLABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRX" +
	"YI SYLLABLE HMYRYI SYLLABLE MITYI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE " +
	"MIPYI SYLLABLE MIEXYI SYLLABLE MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLL" +
	"ABLE MAXYI SYLLABLE MAYI SYLLABLE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI " +
	"SYLLABLE MUOYI SYLLABLE MUOPYI SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MO" +
	"YI SYLLABLE MOPYI SYLLABLE MEXYI SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE M") + ("" +
	"UXYI SYLLABLE MUYI SYLLABLE MUPYI SYLLABLE MURXYI SYLLABLE MURYI SYLLABL" +
	"E MYTYI SYLLABLE MYXYI SYLLABLE MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLA" +
	"BLE FIXYI SYLLABLE FIYI SYLLABLE FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYL" +
	"LABLE FAYI SYLLABLE FAPYI SYLLABLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SY" +
	"LLABLE FUTYI SYLLABLE FUXYI SYLLABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI" +
	" SYLLABLE FURYI SYLLABLE FYTYI SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYP" +
	"YI SYLLABLE VITYI SYLLABLE VIXYI SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE V" +
	"IETYI SYLLABLE VIEXYI SYLLABLE VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLL" +
	"ABLE VAXYI SYLLABLE VAYI SYLLABLE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SY" +
	"LLABLE VOYI SYLLABLE VOPYI SYLLABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI " +
	"SYLLABLE VUXYI SYLLABLE VUYI SYLLABLE VUPYI SYLLABLE VURXYI SYLLABLE VUR" +
	"YI SYLLABLE VYTYI SYLLABLE VYXYI SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE V" +
	"YRXYI SYLLABLE VYRYI SYLLABLE DITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABL" +
	"E DIPYI SYLLABLE DIEXYI SYLLABLE DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SY" +
	"LLABLE DAXYI SYLLABLE DAYI SYLLABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI" +
	" SYLLABLE DOTYI SYLLABLE DOXYI SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEX" +
	"YI SYLLABLE DEYI SYLLABLE DEPYI SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE D" +
	"UYI SYLLABLE DUPYI SYLLABLE DURXYI SYLLABLE DURYI SYLLABLE TITYI SYLLABL" +
	"E TIXYI SYLLABLE TIYI SYLLABLE TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLL" +
	"ABLE TIEPYI SYLLABLE TATYI SYLLABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI S" +
	"YLLABLE TUOTYI SYLLABLE TUOXYI SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE T" +
	"OTYI SYLLABLE TOXYI SYLLABLE TOYI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE" +
	" TEYI SYLLABLE TEPYI SYLLABLE TUTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABL" +
	"E TUPYI SYLLABLE TURXYI SYLLABLE TURYI SYLLABLE DDITYI SYLLABLE DDIXYI S" +
	"YLLABLE DDIYI SYLLABLE DDIPYI SYLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE " +
	"DDIEPYI SYLLABLE DDATYI SYLLABLE DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI S" +
	"YLLABLE DDUOXYI SYLLABLE DDUOYI SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABL" +
	"E DDOXYI SYLLABLE DDOYI SYLLABLE DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI S" +
	"YLLABLE DDEPYI SYLLABLE DDUTYI SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE D" +
	"DUPYI SYLLABLE DDURXYI SYLLABLE DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI S" +
	"YLLABLE NDIYI SYLLABLE NDIPYI SYLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE " +
	"NDATYI SYLLABLE NDAXYI SYLLABLE NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SY" +
	"LLABLE NDOXYI SYLLABLE NDOYI SYLLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE ND" +
	"EYI SYLLABLE NDEPYI SYLLABLE NDUTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLA" +
	"BLE NDUPYI SYLLABLE NDURXYI SYLLABLE NDURYI SYLLABLE HNITYI SYLLABLE HNI" +
	"XYI SYLLABLE HNIYI SYLLABLE HNIPYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYL" +
	"LABLE HNIEYI SYLLABLE HNIEPYI SYLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE H" +
	"NAYI SYLLABLE HNAPYI SYLLABLE HNUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SY" +
	"LLABLE HNOXYI SYLLABLE HNOPYI SYLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HN" +
	"EPYI SYLLABLE HNUTYI SYLLABLE NITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABL" +
	"E NIPYI SYLLABLE NIEXYI SYLLABLE NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SY" +
	"LLABLE NAYI SYLLABLE NAPYI SYLLABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPY" +
	"I SYLLABLE NOTYI SYLLABLE NOXYI SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NE" +
	"XYI SYLLABLE NEYI SYLLABLE NEPYI SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE " +
	"NUYI SYLLABLE NUPYI SYLLABLE NURXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLA" +
	"BLE HLIXYI SYLLABLE HLIYI SYLLABLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIE" +
	"YI SYLLABLE HLIEPYI SYLLABLE HLATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLA" +
	"BLE HLAPYI SYLLABLE HLUOXYI SYLLABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HL" +
	"OXYI SYLLABLE HLOYI SYLLABLE HLOPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLA" +
	"BLE HLEPYI SYLLABLE HLUTYI SYLLABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPY" +
	"I SYLLABLE HLURXYI SYLLABLE HLURYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLA" +
	"BLE HLYYI SYLLABLE HLYPYI SYLLABLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITY" +
	"I SYLLABLE LIXYI SYLLABLE LIYI SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE L" +
	"IEXYI SYLLABLE LIEYI SYLLABLE LIEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLA" +
	"BLE LAYI SYLLABLE LAPYI SYLLABLE LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI S" +
	"YLLABLE LUOPYI SYLLABLE LOTYI SYLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPY" +
	"I SYLLABLE LEXYI SYLLABLE LEYI SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LU" +
	"XYI SYLLABLE LUYI SYLLABLE LUPYI SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE" +
	" LYTYI SYLLABLE LYXYI SYLLABLE LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLA" +
	"BLE LYRYI SYLLABLE GITYI SYLLABLE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYL" +
	"LABLE GIETYI SYLLABLE GIEXYI SYLLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GAT" +
	"YI SYLLABLE GAXYI SYLLABLE GAYI SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE " +
	"GUOXYI SYLLABLE GUOYI SYLLABLE GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLL" +
	"ABLE GOYI SYLLABLE GOPYI SYLLABLE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYL") + ("" +
	"LABLE GEPYI SYLLABLE GUTYI SYLLABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI S" +
	"YLLABLE GURXYI SYLLABLE GURYI SYLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIY" +
	"I SYLLABLE KIPYI SYLLABLE KIEXYI SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE" +
	" KATYI SYLLABLE KAXYI SYLLABLE KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLA" +
	"BLE KUOYI SYLLABLE KUOPYI SYLLABLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SY" +
	"LLABLE KOPYI SYLLABLE KETYI SYLLABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI " +
	"SYLLABLE KUTYI SYLLABLE KUXYI SYLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURX" +
	"YI SYLLABLE KURYI SYLLABLE GGITYI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABL" +
	"E GGIEXYI SYLLABLE GGIEYI SYLLABLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAX" +
	"YI SYLLABLE GGAYI SYLLABLE GGAPYI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLL" +
	"ABLE GGUOYI SYLLABLE GGUOPYI SYLLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GG" +
	"OYI SYLLABLE GGOPYI SYLLABLE GGETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLA" +
	"BLE GGEPYI SYLLABLE GGUTYI SYLLABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPY" +
	"I SYLLABLE GGURXYI SYLLABLE GGURYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLL" +
	"ABLE MGATYI SYLLABLE MGAXYI SYLLABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUO" +
	"XYI SYLLABLE MGUOYI SYLLABLE MGUOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYL" +
	"LABLE MGOYI SYLLABLE MGOPYI SYLLABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEP" +
	"YI SYLLABLE MGUTYI SYLLABLE MGUXYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLAB" +
	"LE MGURXYI SYLLABLE MGURYI SYLLABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIY" +
	"I SYLLABLE HXIPYI SYLLABLE HXIETYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLL" +
	"ABLE HXIEPYI SYLLABLE HXATYI SYLLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXA" +
	"PYI SYLLABLE HXUOTYI SYLLABLE HXUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI S" +
	"YLLABLE HXOTYI SYLLABLE HXOXYI SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE H" +
	"XEXYI SYLLABLE HXEYI SYLLABLE HXEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SY" +
	"LLABLE NGIEPYI SYLLABLE NGATYI SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE N" +
	"GAPYI SYLLABLE NGUOTYI SYLLABLE NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI " +
	"SYLLABLE NGOXYI SYLLABLE NGOYI SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE " +
	"NGEYI SYLLABLE NGEPYI SYLLABLE HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLL" +
	"ABLE HATYI SYLLABLE HAXYI SYLLABLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI S" +
	"YLLABLE HUOXYI SYLLABLE HUOYI SYLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HO" +
	"XYI SYLLABLE HOYI SYLLABLE HOPYI SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE H" +
	"EPYI SYLLABLE WATYI SYLLABLE WAXYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE" +
	" WUOXYI SYLLABLE WUOYI SYLLABLE WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLL" +
	"ABLE WOPYI SYLLABLE WEXYI SYLLABLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SY" +
	"LLABLE ZIXYI SYLLABLE ZIYI SYLLABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI" +
	" SYLLABLE ZIEPYI SYLLABLE ZATYI SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZA" +
	"PYI SYLLABLE ZUOXYI SYLLABLE ZUOYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLAB" +
	"LE ZOXYI SYLLABLE ZOYI SYLLABLE ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLA" +
	"BLE ZEPYI SYLLABLE ZUTYI SYLLABLE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYL" +
	"LABLE ZURXYI SYLLABLE ZURYI SYLLABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI " +
	"SYLLABLE ZYPYI SYLLABLE ZYRXYI SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CI" +
	"XYI SYLLABLE CIYI SYLLABLE CIPYI SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABL" +
	"E CIEYI SYLLABLE CIEPYI SYLLABLE CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLL" +
	"ABLE CAPYI SYLLABLE CUOXYI SYLLABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI" +
	" SYLLABLE COXYI SYLLABLE COYI SYLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEY" +
	"I SYLLABLE CEPYI SYLLABLE CUTYI SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CU" +
	"PYI SYLLABLE CURXYI SYLLABLE CURYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABL" +
	"E CYYI SYLLABLE CYPYI SYLLABLE CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYL" +
	"LABLE ZZIXYI SYLLABLE ZZIYI SYLLABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZ" +
	"IEXYI SYLLABLE ZZIEYI SYLLABLE ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI S" +
	"YLLABLE ZZAYI SYLLABLE ZZAPYI SYLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZ" +
	"OPYI SYLLABLE ZZEXYI SYLLABLE ZZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLL" +
	"ABLE ZZUYI SYLLABLE ZZUPYI SYLLABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZY" +
	"TYI SYLLABLE ZZYXYI SYLLABLE ZZYYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLL" +
	"ABLE ZZYRYI SYLLABLE NZITYI SYLLABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIP" +
	"YI SYLLABLE NZIEXYI SYLLABLE NZIEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYL" +
	"LABLE NZAXYI SYLLABLE NZAYI SYLLABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZ" +
	"UOYI SYLLABLE NZOXYI SYLLABLE NZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLL" +
	"ABLE NZUXYI SYLLABLE NZUYI SYLLABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZU" +
	"RYI SYLLABLE NZYTYI SYLLABLE NZYXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLA" +
	"BLE NZYRXYI SYLLABLE NZYRYI SYLLABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI " +
	"SYLLABLE SIPYI SYLLABLE SIEXYI SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE S" +
	"ATYI SYLLABLE SAXYI SYLLABLE SAYI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABL" +
	"E SUOYI SYLLABLE SUOPYI SYLLABLE SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLL") + ("" +
	"ABLE SOPYI SYLLABLE SEXYI SYLLABLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SY" +
	"LLABLE SUXYI SYLLABLE SUYI SYLLABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI" +
	" SYLLABLE SYTYI SYLLABLE SYXYI SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYR" +
	"XYI SYLLABLE SYRYI SYLLABLE SSITYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLAB" +
	"LE SSIPYI SYLLABLE SSIEXYI SYLLABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSA" +
	"TYI SYLLABLE SSAXYI SYLLABLE SSAYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLA" +
	"BLE SSOXYI SYLLABLE SSOYI SYLLABLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI" +
	" SYLLABLE SSEPYI SYLLABLE SSUTYI SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE" +
	" SSUPYI SYLLABLE SSYTYI SYLLABLE SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI S" +
	"YLLABLE SSYRXYI SYLLABLE SSYRYI SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE" +
	" ZHAYI SYLLABLE ZHAPYI SYLLABLE ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI" +
	" SYLLABLE ZHOTYI SYLLABLE ZHOXYI SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE" +
	" ZHETYI SYLLABLE ZHEXYI SYLLABLE ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI S" +
	"YLLABLE ZHUXYI SYLLABLE ZHUYI SYLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE " +
	"ZHURYI SYLLABLE ZHYTYI SYLLABLE ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SY" +
	"LLABLE ZHYRXYI SYLLABLE ZHYRYI SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE " +
	"CHAYI SYLLABLE CHAPYI SYLLABLE CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI " +
	"SYLLABLE CHUOPYI SYLLABLE CHOTYI SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE" +
	" CHOPYI SYLLABLE CHETYI SYLLABLE CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI S" +
	"YLLABLE CHUXYI SYLLABLE CHUYI SYLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE " +
	"CHURYI SYLLABLE CHYTYI SYLLABLE CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SY" +
	"LLABLE CHYRXYI SYLLABLE CHYRYI SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE R" +
	"RUOXYI SYLLABLE RRUOYI SYLLABLE RROTYI SYLLABLE RROXYI SYLLABLE RROYI SY" +
	"LLABLE RROPYI SYLLABLE RRETYI SYLLABLE RREXYI SYLLABLE RREYI SYLLABLE RR" +
	"EPYI SYLLABLE RRUTYI SYLLABLE RRUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLL" +
	"ABLE RRURXYI SYLLABLE RRURYI SYLLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RR" +
	"YYI SYLLABLE RRYPYI SYLLABLE RRYRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYL" +
	"LABLE NRAXYI SYLLABLE NRAYI SYLLABLE NRAPYI SYLLABLE NROXYI SYLLABLE NRO" +
	"YI SYLLABLE NROPYI SYLLABLE NRETYI SYLLABLE NREXYI SYLLABLE NREYI SYLLAB" +
	"LE NREPYI SYLLABLE NRUTYI SYLLABLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI" +
	" SYLLABLE NRURXYI SYLLABLE NRURYI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLAB" +
	"LE NRYYI SYLLABLE NRYPYI SYLLABLE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATY" +
	"I SYLLABLE SHAXYI SYLLABLE SHAYI SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLAB" +
	"LE SHUOYI SYLLABLE SHUOPYI SYLLABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOY" +
	"I SYLLABLE SHOPYI SYLLABLE SHETYI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABL" +
	"E SHEPYI SYLLABLE SHUTYI SYLLABLE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI " +
	"SYLLABLE SHURXYI SYLLABLE SHURYI SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABL" +
	"E SHYYI SYLLABLE SHYPYI SYLLABLE SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI " +
	"SYLLABLE RAXYI SYLLABLE RAYI SYLLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUO" +
	"YI SYLLABLE RUOPYI SYLLABLE ROTYI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE " +
	"ROPYI SYLLABLE REXYI SYLLABLE REYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABL" +
	"E RUXYI SYLLABLE RUYI SYLLABLE RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLL" +
	"ABLE RYTYI SYLLABLE RYXYI SYLLABLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI S" +
	"YLLABLE RYRYI SYLLABLE JITYI SYLLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI" +
	" SYLLABLE JIETYI SYLLABLE JIEXYI SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE" +
	" JUOTYI SYLLABLE JUOXYI SYLLABLE JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SY" +
	"LLABLE JOXYI SYLLABLE JOYI SYLLABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI " +
	"SYLLABLE JUYI SYLLABLE JUPYI SYLLABLE JURXYI SYLLABLE JURYI SYLLABLE JYT" +
	"YI SYLLABLE JYXYI SYLLABLE JYYI SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE " +
	"JYRYI SYLLABLE QITYI SYLLABLE QIXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABL" +
	"E QIETYI SYLLABLE QIEXYI SYLLABLE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI " +
	"SYLLABLE QUOXYI SYLLABLE QUOYI SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE Q" +
	"OXYI SYLLABLE QOYI SYLLABLE QOPYI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE" +
	" QUYI SYLLABLE QUPYI SYLLABLE QURXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLA" +
	"BLE QYXYI SYLLABLE QYYI SYLLABLE QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SY" +
	"LLABLE JJITYI SYLLABLE JJIXYI SYLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJ" +
	"IETYI SYLLABLE JJIEXYI SYLLABLE JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI" +
	" SYLLABLE JJUOYI SYLLABLE JJUOPYI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLAB" +
	"LE JJOYI SYLLABLE JJOPYI SYLLABLE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI " +
	"SYLLABLE JJUPYI SYLLABLE JJURXYI SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABL" +
	"E JJYXYI SYLLABLE JJYYI SYLLABLE JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI " +
	"SYLLABLE NJIYI SYLLABLE NJIPYI SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABL" +
	"E NJIEYI SYLLABLE NJIEPYI SYLLABLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOT" +
	"YI SYLLABLE NJOXYI SYLLABLE NJOYI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLAB") + ("" +
	"LE NJUYI SYLLABLE NJUPYI SYLLABLE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTY" +
	"I SYLLABLE NJYXYI SYLLABLE NJYYI SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLAB" +
	"LE NJYRYI SYLLABLE NYITYI SYLLABLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI" +
	" SYLLABLE NYIETYI SYLLABLE NYIEXYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLL" +
	"ABLE NYUOXYI SYLLABLE NYUOYI SYLLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE N" +
	"YOXYI SYLLABLE NYOYI SYLLABLE NYOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYL" +
	"LABLE NYUYI SYLLABLE NYUPYI SYLLABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI " +
	"SYLLABLE XIPYI SYLLABLE XIETYI SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE X" +
	"IEPYI SYLLABLE XUOXYI SYLLABLE XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLA" +
	"BLE XOYI SYLLABLE XOPYI SYLLABLE XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLL" +
	"ABLE XYPYI SYLLABLE XYRXYI SYLLABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI " +
	"SYLLABLE YIYI SYLLABLE YIPYI SYLLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YI" +
	"EYI SYLLABLE YIEPYI SYLLABLE YUOTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLA" +
	"BLE YUOPYI SYLLABLE YOTYI SYLLABLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SY" +
	"LLABLE YUTYI SYLLABLE YUXYI SYLLABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI" +
	" SYLLABLE YURYI SYLLABLE YYTYI SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYP" +
	"YI SYLLABLE YYRXYI SYLLABLE YYRYI RADICAL QOTYI RADICAL LIYI RADICAL KIT" +
	"YI RADICAL NYIPYI RADICAL CYPYI RADICAL SSIYI RADICAL GGOPYI RADICAL GEP" +
	"YI RADICAL MIYI RADICAL HXITYI RADICAL LYRYI RADICAL BBUTYI RADICAL MOPY" +
	"I RADICAL YOYI RADICAL PUTYI RADICAL HXUOYI RADICAL TATYI RADICAL GAYI R" +
	"ADICAL ZUPYI RADICAL CYTYI RADICAL DDURYI RADICAL BURYI RADICAL GGUOYI R" +
	"ADICAL NYOPYI RADICAL TUYI RADICAL OPYI RADICAL JJUTYI RADICAL ZOTYI RAD" +
	"ICAL PYTYI RADICAL HMOYI RADICAL YITYI RADICAL VURYI RADICAL SHYYI RADIC" +
	"AL VEPYI RADICAL ZAYI RADICAL JOYI RADICAL NZUPYI RADICAL JJYYI RADICAL " +
	"GOTYI RADICAL JJIEYI RADICAL WOYI RADICAL DUYI RADICAL SHURYI RADICAL LI" +
	"EYI RADICAL CYYI RADICAL CUOPYI RADICAL CIPYI RADICAL HXOPYI RADICAL SHA" +
	"TYI RADICAL ZURYI RADICAL SHOPYI RADICAL CHEYI RADICAL ZZIETYI RADICAL N" +
	"BIEYI RADICAL KELISU LETTER BALISU LETTER PALISU LETTER PHALISU LETTER D" +
	"ALISU LETTER TALISU LETTER THALISU LETTER GALISU LETTER KALISU LETTER KH" +
	"ALISU LETTER JALISU LETTER CALISU LETTER CHALISU LETTER DZALISU LETTER T" +
	"SALISU LETTER TSHALISU LETTER MALISU LETTER NALISU LETTER LALISU LETTER " +
	"SALISU LETTER ZHALISU LETTER ZALISU LETTER NGALISU LETTER HALISU LETTER " +
	"XALISU LETTER HHALISU LETTER FALISU LETTER WALISU LETTER SHALISU LETTER " +
	"YALISU LETTER GHALISU LETTER ALISU LETTER AELISU LETTER ELISU LETTER EUL" +
	"ISU LETTER ILISU LETTER OLISU LETTER ULISU LETTER UELISU LETTER UHLISU L" +
	"ETTER OELISU LETTER TONE MYA TILISU LETTER TONE NA POLISU LETTER TONE MY" +
	"A CYALISU LETTER TONE MYA BOLISU LETTER TONE MYA NALISU LETTER TONE MYA " +
	"JEULISU PUNCTUATION COMMALISU PUNCTUATION FULL STOPVAI SYLLABLE EEVAI SY" +
	"LLABLE EENVAI SYLLABLE HEEVAI SYLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE " +
	"PEEVAI SYLLABLE BHEEVAI SYLLABLE BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVA" +
	"I SYLLABLE MGBEEVAI SYLLABLE GBEEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYL" +
	"LABLE TEEVAI SYLLABLE THEEVAI SYLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABL" +
	"E LEEVAI SYLLABLE REEVAI SYLLABLE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVA" +
	"I SYLLABLE SHEEVAI SYLLABLE ZEEVAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLL" +
	"ABLE JEEVAI SYLLABLE NJEEVAI SYLLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NG" +
	"GEEVAI SYLLABLE GEEVAI SYLLABLE MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI " +
	"SYLLABLE IVAI SYLLABLE INVAI SYLLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIV" +
	"AI SYLLABLE WINVAI SYLLABLE PIVAI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABL" +
	"E MBIVAI SYLLABLE KPIVAI SYLLABLE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI" +
	" SYLLABLE VIVAI SYLLABLE TIVAI SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE " +
	"DHHIVAI SYLLABLE LIVAI SYLLABLE RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYL" +
	"LABLE SIVAI SYLLABLE SHIVAI SYLLABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVA" +
	"I SYLLABLE JIVAI SYLLABLE NJIVAI SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE " +
	"NGGIVAI SYLLABLE GIVAI SYLLABLE MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYL" +
	"LABLE AVAI SYLLABLE ANVAI SYLLABLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVA" +
	"I SYLLABLE WAVAI SYLLABLE WANVAI SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE" +
	" BAVAI SYLLABLE MBAVAI SYLLABLE KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI" +
	" SYLLABLE GBAVAI SYLLABLE FAVAI SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE T" +
	"HAVAI SYLLABLE DHAVAI SYLLABLE DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYL" +
	"LABLE DAVAI SYLLABLE NDAVAI SYLLABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVA" +
	"I SYLLABLE ZHAVAI SYLLABLE CAVAI SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE" +
	" YAVAI SYLLABLE KAVAI SYLLABLE KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SY" +
	"LLABLE MAVAI SYLLABLE NAVAI SYLLABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONV" +
	"AI SYLLABLE HOOVAI SYLLABLE WOOVAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLL") + ("" +
	"ABLE BHOOVAI SYLLABLE BOOVAI SYLLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE " +
	"MGBOOVAI SYLLABLE GBOOVAI SYLLABLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVA" +
	"I SYLLABLE THOOVAI SYLLABLE DHOOVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SY" +
	"LLABLE ROOVAI SYLLABLE DOOVAI SYLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE " +
	"SHOOVAI SYLLABLE ZOOVAI SYLLABLE ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI" +
	" SYLLABLE NJOOVAI SYLLABLE YOOVAI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLL" +
	"ABLE GOOVAI SYLLABLE MOOVAI SYLLABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UV" +
	"AI SYLLABLE UNVAI SYLLABLE HUVAI SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE" +
	" WUNVAI SYLLABLE PUVAI SYLLABLE BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SY" +
	"LLABLE KPUVAI SYLLABLE MGBUVAI SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE V" +
	"UVAI SYLLABLE TUVAI SYLLABLE THUVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYL" +
	"LABLE LUVAI SYLLABLE RUVAI SYLLABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI" +
	" SYLLABLE SHUVAI SYLLABLE ZUVAI SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE " +
	"JUVAI SYLLABLE NJUVAI SYLLABLE YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYL" +
	"LABLE GUVAI SYLLABLE MUVAI SYLLABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI " +
	"SYLLABLE ONVAI SYLLABLE NGONVAI SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE " +
	"WOVAI SYLLABLE WONVAI SYLLABLE POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLL" +
	"ABLE MBOVAI SYLLABLE KPOVAI SYLLABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GB" +
	"ONVAI SYLLABLE FOVAI SYLLABLE VOVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLA" +
	"BLE DHOVAI SYLLABLE DHHOVAI SYLLABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI" +
	" SYLLABLE NDOVAI SYLLABLE SOVAI SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE " +
	"ZHOVAI SYLLABLE COVAI SYLLABLE JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLL" +
	"ABLE KOVAI SYLLABLE NGGOVAI SYLLABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI" +
	" SYLLABLE NYOVAI SYLLABLE EVAI SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE " +
	"HEVAI SYLLABLE HENVAI SYLLABLE WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLL" +
	"ABLE BHEVAI SYLLABLE BEVAI SYLLABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPEN" +
	"VAI SYLLABLE MGBEVAI SYLLABLE GBEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYL" +
	"LABLE VEVAI SYLLABLE TEVAI SYLLABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHE" +
	"VAI SYLLABLE LEVAI SYLLABLE REVAI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABL" +
	"E SEVAI SYLLABLE SHEVAI SYLLABLE ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SY" +
	"LLABLE JEVAI SYLLABLE NJEVAI SYLLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGE" +
	"VAI SYLLABLE NGGENVAI SYLLABLE GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLL" +
	"ABLE NEVAI SYLLABLE NYEVAI SYLLABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVA" +
	"I FULL STOPVAI QUESTION MARKVAI SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVA" +
	"I SYLLABLE NDOLE SOOVAI SYMBOL FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI S" +
	"YMBOL NIIVAI SYMBOL BANGVAI SYMBOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI S" +
	"YMBOL DOONGVAI SYMBOL KUNGVAI SYMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGV" +
	"AI DIGIT ZEROVAI DIGIT ONEVAI DIGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI " +
	"DIGIT FIVEVAI DIGIT SIXVAI DIGIT SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI S" +
	"YLLABLE NDOLE MAVAI SYLLABLE NDOLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRIL" +
	"LIC SMALL LETTER ZEMLYACYRILLIC CAPITAL LETTER DZELOCYRILLIC SMALL LETTE" +
	"R DZELOCYRILLIC CAPITAL LETTER REVERSED DZECYRILLIC SMALL LETTER REVERSE" +
	"D DZECYRILLIC CAPITAL LETTER IOTACYRILLIC SMALL LETTER IOTACYRILLIC CAPI" +
	"TAL LETTER DJERVCYRILLIC SMALL LETTER DJERVCYRILLIC CAPITAL LETTER MONOG" +
	"RAPH UKCYRILLIC SMALL LETTER MONOGRAPH UKCYRILLIC CAPITAL LETTER BROAD O" +
	"MEGACYRILLIC SMALL LETTER BROAD OMEGACYRILLIC CAPITAL LETTER NEUTRAL YER" +
	"CYRILLIC SMALL LETTER NEUTRAL YERCYRILLIC CAPITAL LETTER YERU WITH BACK " +
	"YERCYRILLIC SMALL LETTER YERU WITH BACK YERCYRILLIC CAPITAL LETTER IOTIF" +
	"IED YATCYRILLIC SMALL LETTER IOTIFIED YATCYRILLIC CAPITAL LETTER REVERSE" +
	"D YUCYRILLIC SMALL LETTER REVERSED YUCYRILLIC CAPITAL LETTER IOTIFIED AC" +
	"YRILLIC SMALL LETTER IOTIFIED ACYRILLIC CAPITAL LETTER CLOSED LITTLE YUS" +
	"CYRILLIC SMALL LETTER CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER BLENDED Y" +
	"USCYRILLIC SMALL LETTER BLENDED YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOS" +
	"ED LITTLE YUSCYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC CA" +
	"PITAL LETTER YNCYRILLIC SMALL LETTER YNCYRILLIC CAPITAL LETTER REVERSED " +
	"TSECYRILLIC SMALL LETTER REVERSED TSECYRILLIC CAPITAL LETTER SOFT DECYRI" +
	"LLIC SMALL LETTER SOFT DECYRILLIC CAPITAL LETTER SOFT ELCYRILLIC SMALL L" +
	"ETTER SOFT ELCYRILLIC CAPITAL LETTER SOFT EMCYRILLIC SMALL LETTER SOFT E" +
	"MCYRILLIC CAPITAL LETTER MONOCULAR OCYRILLIC SMALL LETTER MONOCULAR OCYR" +
	"ILLIC CAPITAL LETTER BINOCULAR OCYRILLIC SMALL LETTER BINOCULAR OCYRILLI" +
	"C CAPITAL LETTER DOUBLE MONOCULAR OCYRILLIC SMALL LETTER DOUBLE MONOCULA" +
	"R OCYRILLIC LETTER MULTIOCULAR OCOMBINING CYRILLIC VZMETCOMBINING CYRILL" +
	"IC TEN MILLIONS SIGNCOMBINING CYRILLIC HUNDRED MILLIONS SIGNCOMBINING CY" +
	"RILLIC THOUSAND MILLIONS SIGNSLAVONIC ASTERISKCOMBINING CYRILLIC LETTER ") + ("" +
	"UKRAINIAN IECOMBINING CYRILLIC LETTER ICOMBINING CYRILLIC LETTER YICOMBI" +
	"NING CYRILLIC LETTER UCOMBINING CYRILLIC LETTER HARD SIGNCOMBINING CYRIL" +
	"LIC LETTER YERUCOMBINING CYRILLIC LETTER SOFT SIGNCOMBINING CYRILLIC LET" +
	"TER OMEGACOMBINING CYRILLIC KAVYKACOMBINING CYRILLIC PAYEROKCYRILLIC KAV" +
	"YKACYRILLIC PAYEROKCYRILLIC CAPITAL LETTER DWECYRILLIC SMALL LETTER DWEC" +
	"YRILLIC CAPITAL LETTER DZWECYRILLIC SMALL LETTER DZWECYRILLIC CAPITAL LE" +
	"TTER ZHWECYRILLIC SMALL LETTER ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC " +
	"SMALL LETTER CCHECYRILLIC CAPITAL LETTER DZZECYRILLIC SMALL LETTER DZZEC" +
	"YRILLIC CAPITAL LETTER TE WITH MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER TWECYRILLIC SMALL LETTER TWECYRILLIC " +
	"CAPITAL LETTER TSWECYRILLIC SMALL LETTER TSWECYRILLIC CAPITAL LETTER TSS" +
	"ECYRILLIC SMALL LETTER TSSECYRILLIC CAPITAL LETTER TCHECYRILLIC SMALL LE" +
	"TTER TCHECYRILLIC CAPITAL LETTER HWECYRILLIC SMALL LETTER HWECYRILLIC CA" +
	"PITAL LETTER SHWECYRILLIC SMALL LETTER SHWECYRILLIC CAPITAL LETTER DOUBL" +
	"E OCYRILLIC SMALL LETTER DOUBLE OCYRILLIC CAPITAL LETTER CROSSED OCYRILL" +
	"IC SMALL LETTER CROSSED OMODIFIER LETTER CYRILLIC HARD SIGNMODIFIER LETT" +
	"ER CYRILLIC SOFT SIGNCOMBINING CYRILLIC LETTER EFCOMBINING CYRILLIC LETT" +
	"ER IOTIFIED EBAMUM LETTER ABAMUM LETTER KABAMUM LETTER UBAMUM LETTER KUB" +
	"AMUM LETTER EEBAMUM LETTER REEBAMUM LETTER TAEBAMUM LETTER OBAMUM LETTER" +
	" NYIBAMUM LETTER IBAMUM LETTER LABAMUM LETTER PABAMUM LETTER RIIBAMUM LE" +
	"TTER RIEEBAMUM LETTER LEEEEBAMUM LETTER MEEEEBAMUM LETTER TAABAMUM LETTE" +
	"R NDAABAMUM LETTER NJAEMBAMUM LETTER MBAMUM LETTER SUUBAMUM LETTER MUBAM" +
	"UM LETTER SHIIBAMUM LETTER SIBAMUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LE" +
	"TTER KYEEBAMUM LETTER KETBAMUM LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJ" +
	"UAEBAMUM LETTER YOQBAMUM LETTER SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM " +
	"LETTER NSHABAMUM LETTER KEUXBAMUM LETTER PEUXBAMUM LETTER NJEEBAMUM LETT" +
	"ER NTEEBAMUM LETTER PUEBAMUM LETTER WUEBAMUM LETTER PEEBAMUM LETTER FEEB" +
	"AMUM LETTER RUBAMUM LETTER LUBAMUM LETTER MIBAMUM LETTER NIBAMUM LETTER " +
	"REUXBAMUM LETTER RAEBAMUM LETTER KENBAMUM LETTER NGKWAENBAMUM LETTER NGG" +
	"ABAMUM LETTER NGABAMUM LETTER SHOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM L" +
	"ETTER FOMBAMUM LETTER WABAMUM LETTER NABAMUM LETTER LIBAMUM LETTER PIBAM" +
	"UM LETTER LOQBAMUM LETTER KOBAMUM LETTER MBENBAMUM LETTER RENBAMUM LETTE" +
	"R MENBAMUM LETTER MABAMUM LETTER TIBAMUM LETTER KIBAMUM LETTER MOBAMUM L" +
	"ETTER MBAABAMUM LETTER TETBAMUM LETTER KPABAMUM LETTER TENBAMUM LETTER N" +
	"TUUBAMUM LETTER SAMBABAMUM LETTER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER K" +
	"OGHOMBAMUM COMBINING MARK KOQNDONBAMUM COMBINING MARK TUKWENTISBAMUM NJA" +
	"EMLIBAMUM FULL STOPBAMUM COLONBAMUM COMMABAMUM SEMICOLONBAMUM QUESTION M" +
	"ARKMODIFIER LETTER CHINESE TONE YIN PINGMODIFIER LETTER CHINESE TONE YAN" +
	"G PINGMODIFIER LETTER CHINESE TONE YIN SHANGMODIFIER LETTER CHINESE TONE" +
	" YANG SHANGMODIFIER LETTER CHINESE TONE YIN QUMODIFIER LETTER CHINESE TO" +
	"NE YANG QUMODIFIER LETTER CHINESE TONE YIN RUMODIFIER LETTER CHINESE TON" +
	"E YANG RUMODIFIER LETTER EXTRA-HIGH DOTTED TONE BARMODIFIER LETTER HIGH " +
	"DOTTED TONE BARMODIFIER LETTER MID DOTTED TONE BARMODIFIER LETTER LOW DO" +
	"TTED TONE BARMODIFIER LETTER EXTRA-LOW DOTTED TONE BARMODIFIER LETTER EX" +
	"TRA-HIGH DOTTED LEFT-STEM TONE BARMODIFIER LETTER HIGH DOTTED LEFT-STEM " +
	"TONE BARMODIFIER LETTER MID DOTTED LEFT-STEM TONE BARMODIFIER LETTER LOW" +
	" DOTTED LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TON" +
	"E BARMODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BARMODIFIER LETTER HIGH L" +
	"EFT-STEM TONE BARMODIFIER LETTER MID LEFT-STEM TONE BARMODIFIER LETTER L" +
	"OW LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIE" +
	"R LETTER DOT VERTICAL BARMODIFIER LETTER DOT SLASHMODIFIER LETTER DOT HO" +
	"RIZONTAL BARMODIFIER LETTER LOWER RIGHT CORNER ANGLEMODIFIER LETTER RAIS" +
	"ED UP ARROWMODIFIER LETTER RAISED DOWN ARROWMODIFIER LETTER RAISED EXCLA" +
	"MATION MARKMODIFIER LETTER RAISED INVERTED EXCLAMATION MARKMODIFIER LETT" +
	"ER LOW INVERTED EXCLAMATION MARKMODIFIER LETTER STRESS AND HIGH TONEMODI" +
	"FIER LETTER STRESS AND LOW TONELATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLA" +
	"TIN SMALL LETTER EGYPTOLOGICAL ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AI" +
	"NLATIN SMALL LETTER EGYPTOLOGICAL AINLATIN CAPITAL LETTER HENGLATIN SMAL" +
	"L LETTER HENGLATIN CAPITAL LETTER TZLATIN SMALL LETTER TZLATIN CAPITAL L" +
	"ETTER TRESILLOLATIN SMALL LETTER TRESILLOLATIN CAPITAL LETTER CUATRILLOL" +
	"ATIN SMALL LETTER CUATRILLOLATIN CAPITAL LETTER CUATRILLO WITH COMMALATI" +
	"N SMALL LETTER CUATRILLO WITH COMMALATIN LETTER SMALL CAPITAL FLATIN LET" +
	"TER SMALL CAPITAL SLATIN CAPITAL LETTER AALATIN SMALL LETTER AALATIN CAP" +
	"ITAL LETTER AOLATIN SMALL LETTER AOLATIN CAPITAL LETTER AULATIN SMALL LE") + ("" +
	"TTER AULATIN CAPITAL LETTER AVLATIN SMALL LETTER AVLATIN CAPITAL LETTER " +
	"AV WITH HORIZONTAL BARLATIN SMALL LETTER AV WITH HORIZONTAL BARLATIN CAP" +
	"ITAL LETTER AYLATIN SMALL LETTER AYLATIN CAPITAL LETTER REVERSED C WITH " +
	"DOTLATIN SMALL LETTER REVERSED C WITH DOTLATIN CAPITAL LETTER K WITH STR" +
	"OKELATIN SMALL LETTER K WITH STROKELATIN CAPITAL LETTER K WITH DIAGONAL " +
	"STROKELATIN SMALL LETTER K WITH DIAGONAL STROKELATIN CAPITAL LETTER K WI" +
	"TH STROKE AND DIAGONAL STROKELATIN SMALL LETTER K WITH STROKE AND DIAGON" +
	"AL STROKELATIN CAPITAL LETTER BROKEN LLATIN SMALL LETTER BROKEN LLATIN C" +
	"APITAL LETTER L WITH HIGH STROKELATIN SMALL LETTER L WITH HIGH STROKELAT" +
	"IN CAPITAL LETTER O WITH LONG STROKE OVERLAYLATIN SMALL LETTER O WITH LO" +
	"NG STROKE OVERLAYLATIN CAPITAL LETTER O WITH LOOPLATIN SMALL LETTER O WI" +
	"TH LOOPLATIN CAPITAL LETTER OOLATIN SMALL LETTER OOLATIN CAPITAL LETTER " +
	"P WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER P WITH STROKE THROUGH " +
	"DESCENDERLATIN CAPITAL LETTER P WITH FLOURISHLATIN SMALL LETTER P WITH F" +
	"LOURISHLATIN CAPITAL LETTER P WITH SQUIRREL TAILLATIN SMALL LETTER P WIT" +
	"H SQUIRREL TAILLATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDERLATIN" +
	" SMALL LETTER Q WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER Q WITH" +
	" DIAGONAL STROKELATIN SMALL LETTER Q WITH DIAGONAL STROKELATIN CAPITAL L" +
	"ETTER R ROTUNDALATIN SMALL LETTER R ROTUNDALATIN CAPITAL LETTER RUM ROTU" +
	"NDALATIN SMALL LETTER RUM ROTUNDALATIN CAPITAL LETTER V WITH DIAGONAL ST" +
	"ROKELATIN SMALL LETTER V WITH DIAGONAL STROKELATIN CAPITAL LETTER VYLATI" +
	"N SMALL LETTER VYLATIN CAPITAL LETTER VISIGOTHIC ZLATIN SMALL LETTER VIS" +
	"IGOTHIC ZLATIN CAPITAL LETTER THORN WITH STROKELATIN SMALL LETTER THORN " +
	"WITH STROKELATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN" +
	" SMALL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER VE" +
	"NDLATIN SMALL LETTER VENDLATIN CAPITAL LETTER ETLATIN SMALL LETTER ETLAT" +
	"IN CAPITAL LETTER ISLATIN SMALL LETTER ISLATIN CAPITAL LETTER CONLATIN S" +
	"MALL LETTER CONMODIFIER LETTER USLATIN SMALL LETTER DUMLATIN SMALL LETTE" +
	"R LUMLATIN SMALL LETTER MUMLATIN SMALL LETTER NUMLATIN SMALL LETTER RUML" +
	"ATIN LETTER SMALL CAPITAL RUMLATIN SMALL LETTER TUMLATIN SMALL LETTER UM" +
	"LATIN CAPITAL LETTER INSULAR DLATIN SMALL LETTER INSULAR DLATIN CAPITAL " +
	"LETTER INSULAR FLATIN SMALL LETTER INSULAR FLATIN CAPITAL LETTER INSULAR" +
	" GLATIN CAPITAL LETTER TURNED INSULAR GLATIN SMALL LETTER TURNED INSULAR" +
	" GLATIN CAPITAL LETTER TURNED LLATIN SMALL LETTER TURNED LLATIN CAPITAL " +
	"LETTER INSULAR RLATIN SMALL LETTER INSULAR RLATIN CAPITAL LETTER INSULAR" +
	" SLATIN SMALL LETTER INSULAR SLATIN CAPITAL LETTER INSULAR TLATIN SMALL " +
	"LETTER INSULAR TMODIFIER LETTER LOW CIRCUMFLEX ACCENTMODIFIER LETTER COL" +
	"ONMODIFIER LETTER SHORT EQUALS SIGNLATIN CAPITAL LETTER SALTILLOLATIN SM" +
	"ALL LETTER SALTILLOLATIN CAPITAL LETTER TURNED HLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOK AND BELTLATIN LETTER SINOLOGICAL DOTLATIN CAPITAL LETTE" +
	"R N WITH DESCENDERLATIN SMALL LETTER N WITH DESCENDERLATIN CAPITAL LETTE" +
	"R C WITH BARLATIN SMALL LETTER C WITH BARLATIN SMALL LETTER C WITH PALAT" +
	"AL HOOKLATIN SMALL LETTER H WITH PALATAL HOOKLATIN CAPITAL LETTER B WITH" +
	" FLOURISHLATIN SMALL LETTER B WITH FLOURISHLATIN CAPITAL LETTER F WITH S" +
	"TROKELATIN SMALL LETTER F WITH STROKELATIN CAPITAL LETTER VOLAPUK AELATI" +
	"N SMALL LETTER VOLAPUK AELATIN CAPITAL LETTER VOLAPUK OELATIN SMALL LETT" +
	"ER VOLAPUK OELATIN CAPITAL LETTER VOLAPUK UELATIN SMALL LETTER VOLAPUK U" +
	"ELATIN CAPITAL LETTER G WITH OBLIQUE STROKELATIN SMALL LETTER G WITH OBL" +
	"IQUE STROKELATIN CAPITAL LETTER K WITH OBLIQUE STROKELATIN SMALL LETTER " +
	"K WITH OBLIQUE STROKELATIN CAPITAL LETTER N WITH OBLIQUE STROKELATIN SMA" +
	"LL LETTER N WITH OBLIQUE STROKELATIN CAPITAL LETTER R WITH OBLIQUE STROK" +
	"ELATIN SMALL LETTER R WITH OBLIQUE STROKELATIN CAPITAL LETTER S WITH OBL" +
	"IQUE STROKELATIN SMALL LETTER S WITH OBLIQUE STROKELATIN CAPITAL LETTER " +
	"H WITH HOOKLATIN CAPITAL LETTER REVERSED OPEN ELATIN CAPITAL LETTER SCRI" +
	"PT GLATIN CAPITAL LETTER L WITH BELTLATIN CAPITAL LETTER SMALL CAPITAL I" +
	"LATIN LETTER SMALL CAPITAL QLATIN CAPITAL LETTER TURNED KLATIN CAPITAL L" +
	"ETTER TURNED TLATIN CAPITAL LETTER J WITH CROSSED-TAILLATIN CAPITAL LETT" +
	"ER CHILATIN CAPITAL LETTER BETALATIN SMALL LETTER BETALATIN CAPITAL LETT" +
	"ER OMEGALATIN SMALL LETTER OMEGALATIN CAPITAL LETTER U WITH STROKELATIN " +
	"SMALL LETTER U WITH STROKELATIN CAPITAL LETTER GLOTTAL ALATIN SMALL LETT" +
	"ER GLOTTAL ALATIN CAPITAL LETTER GLOTTAL ILATIN SMALL LETTER GLOTTAL ILA" +
	"TIN CAPITAL LETTER GLOTTAL ULATIN SMALL LETTER GLOTTAL ULATIN CAPITAL LE" +
	"TTER OLD POLISH OLATIN SMALL LETTER OLD POLISH OLATIN CAPITAL LETTER ANG" +
	"LICANA WLATIN SMALL LETTER ANGLICANA WLATIN CAPITAL LETTER C WITH PALATA") + ("" +
	"L HOOKLATIN CAPITAL LETTER S WITH HOOKLATIN CAPITAL LETTER Z WITH PALATA" +
	"L HOOKLATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAYLATIN SMALL LETTER" +
	" D WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER S WITH SHORT STROKE OVE" +
	"RLAYLATIN SMALL LETTER S WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER C" +
	"LOSED INSULAR GLATIN SMALL LETTER CLOSED INSULAR GLATIN SMALL LETTER DOU" +
	"BLE THORNLATIN SMALL LETTER DOUBLE WYNNLATIN CAPITAL LETTER MIDDLE SCOTS" +
	" SLATIN SMALL LETTER MIDDLE SCOTS SLATIN CAPITAL LETTER SIGMOID SLATIN S" +
	"MALL LETTER SIGMOID SMODIFIER LETTER CAPITAL CMODIFIER LETTER CAPITAL FM" +
	"ODIFIER LETTER CAPITAL QLATIN CAPITAL LETTER REVERSED HALF HLATIN SMALL " +
	"LETTER REVERSED HALF HLATIN EPIGRAPHIC LETTER SIDEWAYS IMODIFIER LETTER " +
	"CAPITAL H WITH STROKEMODIFIER LETTER SMALL LIGATURE OELATIN LETTER SMALL" +
	" CAPITAL TURNED MLATIN EPIGRAPHIC LETTER REVERSED FLATIN EPIGRAPHIC LETT" +
	"ER REVERSED PLATIN EPIGRAPHIC LETTER INVERTED MLATIN EPIGRAPHIC LETTER I" +
	" LONGALATIN EPIGRAPHIC LETTER ARCHAIC MSYLOTI NAGRI LETTER ASYLOTI NAGRI" +
	" LETTER ISYLOTI NAGRI SIGN DVISVARASYLOTI NAGRI LETTER USYLOTI NAGRI LET" +
	"TER ESYLOTI NAGRI LETTER OSYLOTI NAGRI SIGN HASANTASYLOTI NAGRI LETTER K" +
	"OSYLOTI NAGRI LETTER KHOSYLOTI NAGRI LETTER GOSYLOTI NAGRI LETTER GHOSYL" +
	"OTI NAGRI SIGN ANUSVARASYLOTI NAGRI LETTER COSYLOTI NAGRI LETTER CHOSYLO" +
	"TI NAGRI LETTER JOSYLOTI NAGRI LETTER JHOSYLOTI NAGRI LETTER TTOSYLOTI N" +
	"AGRI LETTER TTHOSYLOTI NAGRI LETTER DDOSYLOTI NAGRI LETTER DDHOSYLOTI NA" +
	"GRI LETTER TOSYLOTI NAGRI LETTER THOSYLOTI NAGRI LETTER DOSYLOTI NAGRI L" +
	"ETTER DHOSYLOTI NAGRI LETTER NOSYLOTI NAGRI LETTER POSYLOTI NAGRI LETTER" +
	" PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI LETTER BHOSYLOTI NAGRI LETTER MOS" +
	"YLOTI NAGRI LETTER ROSYLOTI NAGRI LETTER LOSYLOTI NAGRI LETTER RROSYLOTI" +
	" NAGRI LETTER SOSYLOTI NAGRI LETTER HOSYLOTI NAGRI VOWEL SIGN ASYLOTI NA" +
	"GRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIGN USYLOTI NAGRI VOWEL SIGN ESYLOTI" +
	" NAGRI VOWEL SIGN OOSYLOTI NAGRI POETRY MARK-1SYLOTI NAGRI POETRY MARK-2" +
	"SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI POETRY MARK-4SYLOTI NAGRI SIGN AL" +
	"TERNATE HASANTANORTH INDIC FRACTION ONE QUARTERNORTH INDIC FRACTION ONE " +
	"HALFNORTH INDIC FRACTION THREE QUARTERSNORTH INDIC FRACTION ONE SIXTEENT" +
	"HNORTH INDIC FRACTION ONE EIGHTHNORTH INDIC FRACTION THREE SIXTEENTHSNOR" +
	"TH INDIC QUARTER MARKNORTH INDIC PLACEHOLDER MARKNORTH INDIC RUPEE MARKN" +
	"ORTH INDIC QUANTITY MARKPHAGS-PA LETTER KAPHAGS-PA LETTER KHAPHAGS-PA LE" +
	"TTER GAPHAGS-PA LETTER NGAPHAGS-PA LETTER CAPHAGS-PA LETTER CHAPHAGS-PA " +
	"LETTER JAPHAGS-PA LETTER NYAPHAGS-PA LETTER TAPHAGS-PA LETTER THAPHAGS-P" +
	"A LETTER DAPHAGS-PA LETTER NAPHAGS-PA LETTER PAPHAGS-PA LETTER PHAPHAGS-" +
	"PA LETTER BAPHAGS-PA LETTER MAPHAGS-PA LETTER TSAPHAGS-PA LETTER TSHAPHA" +
	"GS-PA LETTER DZAPHAGS-PA LETTER WAPHAGS-PA LETTER ZHAPHAGS-PA LETTER ZAP" +
	"HAGS-PA LETTER SMALL APHAGS-PA LETTER YAPHAGS-PA LETTER RAPHAGS-PA LETTE" +
	"R LAPHAGS-PA LETTER SHAPHAGS-PA LETTER SAPHAGS-PA LETTER HAPHAGS-PA LETT" +
	"ER APHAGS-PA LETTER IPHAGS-PA LETTER UPHAGS-PA LETTER EPHAGS-PA LETTER O" +
	"PHAGS-PA LETTER QAPHAGS-PA LETTER XAPHAGS-PA LETTER FAPHAGS-PA LETTER GG" +
	"APHAGS-PA LETTER EEPHAGS-PA SUBJOINED LETTER WAPHAGS-PA SUBJOINED LETTER" +
	" YAPHAGS-PA LETTER TTAPHAGS-PA LETTER TTHAPHAGS-PA LETTER DDAPHAGS-PA LE" +
	"TTER NNAPHAGS-PA LETTER ALTERNATE YAPHAGS-PA LETTER VOICELESS SHAPHAGS-P" +
	"A LETTER VOICED HAPHAGS-PA LETTER ASPIRATED FAPHAGS-PA SUBJOINED LETTER " +
	"RAPHAGS-PA SUPERFIXED LETTER RAPHAGS-PA LETTER CANDRABINDUPHAGS-PA SINGL" +
	"E HEAD MARKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA MARK SHADPHAGS-PA MARK DOUB" +
	"LE SHADSAURASHTRA SIGN ANUSVARASAURASHTRA SIGN VISARGASAURASHTRA LETTER " +
	"ASAURASHTRA LETTER AASAURASHTRA LETTER ISAURASHTRA LETTER IISAURASHTRA L" +
	"ETTER USAURASHTRA LETTER UUSAURASHTRA LETTER VOCALIC RSAURASHTRA LETTER " +
	"VOCALIC RRSAURASHTRA LETTER VOCALIC LSAURASHTRA LETTER VOCALIC LLSAURASH" +
	"TRA LETTER ESAURASHTRA LETTER EESAURASHTRA LETTER AISAURASHTRA LETTER OS" +
	"AURASHTRA LETTER OOSAURASHTRA LETTER AUSAURASHTRA LETTER KASAURASHTRA LE" +
	"TTER KHASAURASHTRA LETTER GASAURASHTRA LETTER GHASAURASHTRA LETTER NGASA" +
	"URASHTRA LETTER CASAURASHTRA LETTER CHASAURASHTRA LETTER JASAURASHTRA LE" +
	"TTER JHASAURASHTRA LETTER NYASAURASHTRA LETTER TTASAURASHTRA LETTER TTHA" +
	"SAURASHTRA LETTER DDASAURASHTRA LETTER DDHASAURASHTRA LETTER NNASAURASHT" +
	"RA LETTER TASAURASHTRA LETTER THASAURASHTRA LETTER DASAURASHTRA LETTER D" +
	"HASAURASHTRA LETTER NASAURASHTRA LETTER PASAURASHTRA LETTER PHASAURASHTR" +
	"A LETTER BASAURASHTRA LETTER BHASAURASHTRA LETTER MASAURASHTRA LETTER YA" +
	"SAURASHTRA LETTER RASAURASHTRA LETTER LASAURASHTRA LETTER VASAURASHTRA L" +
	"ETTER SHASAURASHTRA LETTER SSASAURASHTRA LETTER SASAURASHTRA LETTER HASA" +
	"URASHTRA LETTER LLASAURASHTRA CONSONANT SIGN HAARUSAURASHTRA VOWEL SIGN ") + ("" +
	"AASAURASHTRA VOWEL SIGN ISAURASHTRA VOWEL SIGN IISAURASHTRA VOWEL SIGN U" +
	"SAURASHTRA VOWEL SIGN UUSAURASHTRA VOWEL SIGN VOCALIC RSAURASHTRA VOWEL " +
	"SIGN VOCALIC RRSAURASHTRA VOWEL SIGN VOCALIC LSAURASHTRA VOWEL SIGN VOCA" +
	"LIC LLSAURASHTRA VOWEL SIGN ESAURASHTRA VOWEL SIGN EESAURASHTRA VOWEL SI" +
	"GN AISAURASHTRA VOWEL SIGN OSAURASHTRA VOWEL SIGN OOSAURASHTRA VOWEL SIG" +
	"N AUSAURASHTRA SIGN VIRAMASAURASHTRA SIGN CANDRABINDUSAURASHTRA DANDASAU" +
	"RASHTRA DOUBLE DANDASAURASHTRA DIGIT ZEROSAURASHTRA DIGIT ONESAURASHTRA " +
	"DIGIT TWOSAURASHTRA DIGIT THREESAURASHTRA DIGIT FOURSAURASHTRA DIGIT FIV" +
	"ESAURASHTRA DIGIT SIXSAURASHTRA DIGIT SEVENSAURASHTRA DIGIT EIGHTSAURASH" +
	"TRA DIGIT NINECOMBINING DEVANAGARI DIGIT ZEROCOMBINING DEVANAGARI DIGIT " +
	"ONECOMBINING DEVANAGARI DIGIT TWOCOMBINING DEVANAGARI DIGIT THREECOMBINI" +
	"NG DEVANAGARI DIGIT FOURCOMBINING DEVANAGARI DIGIT FIVECOMBINING DEVANAG" +
	"ARI DIGIT SIXCOMBINING DEVANAGARI DIGIT SEVENCOMBINING DEVANAGARI DIGIT " +
	"EIGHTCOMBINING DEVANAGARI DIGIT NINECOMBINING DEVANAGARI LETTER ACOMBINI" +
	"NG DEVANAGARI LETTER UCOMBINING DEVANAGARI LETTER KACOMBINING DEVANAGARI" +
	" LETTER NACOMBINING DEVANAGARI LETTER PACOMBINING DEVANAGARI LETTER RACO" +
	"MBINING DEVANAGARI LETTER VICOMBINING DEVANAGARI SIGN AVAGRAHADEVANAGARI" +
	" SIGN SPACING CANDRABINDUDEVANAGARI SIGN CANDRABINDU VIRAMADEVANAGARI SI" +
	"GN DOUBLE CANDRABINDU VIRAMADEVANAGARI SIGN CANDRABINDU TWODEVANAGARI SI" +
	"GN CANDRABINDU THREEDEVANAGARI SIGN CANDRABINDU AVAGRAHADEVANAGARI SIGN " +
	"PUSHPIKADEVANAGARI GAP FILLERDEVANAGARI CARETDEVANAGARI HEADSTROKEDEVANA" +
	"GARI SIGN SIDDHAMDEVANAGARI JAIN OMDEVANAGARI LETTER AYDEVANAGARI VOWEL " +
	"SIGN AYKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEKAYAH LI DIGIT TWOKAYAH LI D" +
	"IGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT FIVEKAYAH LI DIGIT SIXKAYAH " +
	"LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DIGIT NINEKAYAH LI LETTER KAK" +
	"AYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI LETTER NGAKAYAH LI LETTER S" +
	"AKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH LI LETTER NYAKAYAH LI LETTER" +
	" TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH LI LETTER PAKAYAH LI LETTE" +
	"R PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYAH LI LETTER BAKAYAH LI LETT" +
	"ER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYAH LI LETTER WAKAYAH LI LETT" +
	"ER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAYAH LI LETTER CAKAYAH LI LET" +
	"TER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH LI LETTER OOKAYAH LI VOWEL" +
	" UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI VOWEL EEKAYAH LI VOWEL OKAYA" +
	"H LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI TONE CALYA PLOPHUKAYAH LI SI" +
	"GN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJANG LETTER GAREJANG LETTER NG" +
	"AREJANG LETTER TAREJANG LETTER DAREJANG LETTER NAREJANG LETTER PAREJANG " +
	"LETTER BAREJANG LETTER MAREJANG LETTER CAREJANG LETTER JAREJANG LETTER N" +
	"YAREJANG LETTER SAREJANG LETTER RAREJANG LETTER LAREJANG LETTER YAREJANG" +
	" LETTER WAREJANG LETTER HAREJANG LETTER MBAREJANG LETTER NGGAREJANG LETT" +
	"ER NDAREJANG LETTER NYJAREJANG LETTER AREJANG VOWEL SIGN IREJANG VOWEL S" +
	"IGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIREJANG VOWEL SIGN OREJANG VO" +
	"WEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL SIGN EAREJANG CONSONANT SIGN" +
	" NGREJANG CONSONANT SIGN NREJANG CONSONANT SIGN RREJANG CONSONANT SIGN H" +
	"REJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEONG TIKEUT-MIEUMHANGUL CHOSE" +
	"ONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHANGUL CHOSEONG TIKEUT-CIEUCH" +
	"ANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RIEUL-SSANGKIYEOKHANGUL CHOSE" +
	"ONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTIKEUTHANGUL CHOSEONG RIEUL-M" +
	"IEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEONG RIEUL-SSANGPIEUPHANGUL CH" +
	"OSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIEUL-SIOSHANGUL CHOSEONG RIEU" +
	"L-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CHOSEONG MIEUM-KIYEOKHANGUL C" +
	"HOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIOSHANGUL CHOSEONG PIEUP-SIOS" +
	"-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL CHOSEONG PIEUP-HIEUHHANGUL C" +
	"HOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-RIEULHANGUL CHOSEONG IEUNG-" +
	"HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL CHOSEONG SSANGTHIEUTHHANGUL " +
	"CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-SIOSHANGUL CHOSEONG SSANGYEO" +
	"RINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN CECAKJAVANESE SIGN LAYARJAV" +
	"ANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE LETTER I KAWIJAVANESE LETTER" +
	" IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE LETTER PA CEREKJAVANESE LE" +
	"TTER NGA LELETJAVANESE LETTER NGA LELET RASWADIJAVANESE LETTER EJAVANESE" +
	" LETTER AIJAVANESE LETTER OJAVANESE LETTER KAJAVANESE LETTER KA SASAKJAV" +
	"ANESE LETTER KA MURDAJAVANESE LETTER GAJAVANESE LETTER GA MURDAJAVANESE " +
	"LETTER NGAJAVANESE LETTER CAJAVANESE LETTER CA MURDAJAVANESE LETTER JAJA" +
	"VANESE LETTER NYA MURDAJAVANESE LETTER JA MAHAPRANAJAVANESE LETTER NYAJA" +
	"VANESE LETTER TTAJAVANESE LETTER TTA MAHAPRANAJAVANESE LETTER DDAJAVANES") + ("" +
	"E LETTER DDA MAHAPRANAJAVANESE LETTER NA MURDAJAVANESE LETTER TAJAVANESE" +
	" LETTER TA MURDAJAVANESE LETTER DAJAVANESE LETTER DA MAHAPRANAJAVANESE L" +
	"ETTER NAJAVANESE LETTER PAJAVANESE LETTER PA MURDAJAVANESE LETTER BAJAVA" +
	"NESE LETTER BA MURDAJAVANESE LETTER MAJAVANESE LETTER YAJAVANESE LETTER " +
	"RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJAVANESE LETTER WAJAVANESE L" +
	"ETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAVANESE LETTER SAJAVANESE LET" +
	"TER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL SIGN TARUNGJAVANESE VOWEL S" +
	"IGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VOWEL SIGN WULU MELIKJAVANESE" +
	" VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MENDUTJAVANESE VOWEL SIGN TALIN" +
	"GJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL SIGN PEPETJAVANESE CONSONA" +
	"NT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJAVANESE CONSONANT SIGN CAKR" +
	"AJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVANESE RIGHT RERENGGANJAVANESE" +
	" PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA LUHURJAVANESE PADA WINDUJAVA" +
	"NESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE PADA LUNGSIJAVANESE PADA A" +
	"DEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISELEHJAVANESE TURNED PADA PISE" +
	"LEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAVANESE DIGIT ONEJAVANESE DIG" +
	"IT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOURJAVANESE DIGIT FIVEJAVANESE" +
	" DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT EIGHTJAVANESE DIGIT NINEJAV" +
	"ANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-ISENMYANMAR LETTER SHAN GHAMY" +
	"ANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAMYANMAR LETTER SHAN NNAMYANM" +
	"AR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMAR MODIFIER LETTER SHAN REDU" +
	"PLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR LETTER TAI LAING FAMYANMAR " +
	"LETTER TAI LAING GAMYANMAR LETTER TAI LAING GHAMYANMAR LETTER TAI LAING " +
	"JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER TAI LAING DDAMYANMAR LETTER" +
	" TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMYANMAR TAI LAING DIGIT ZEROM" +
	"YANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING DIGIT TWOMYANMAR TAI LAING D" +
	"IGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR TAI LAING DIGIT FIVEMYANMA" +
	"R TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT SEVENMYANMAR TAI LAING DIGI" +
	"T EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LETTER TAI LAING LLAMYANMAR L" +
	"ETTER TAI LAING DAMYANMAR LETTER TAI LAING DHAMYANMAR LETTER TAI LAING B" +
	"AMYANMAR LETTER TAI LAING BHACHAM LETTER ACHAM LETTER ICHAM LETTER UCHAM" +
	" LETTER ECHAM LETTER AICHAM LETTER OCHAM LETTER KACHAM LETTER KHACHAM LE" +
	"TTER GACHAM LETTER GHACHAM LETTER NGUECHAM LETTER NGACHAM LETTER CHACHAM" +
	" LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM LETTER NHUECHAM LETTER NHA" +
	"CHAM LETTER NHJACHAM LETTER TACHAM LETTER THACHAM LETTER DACHAM LETTER D" +
	"HACHAM LETTER NUECHAM LETTER NACHAM LETTER DDACHAM LETTER PACHAM LETTER " +
	"PPACHAM LETTER PHACHAM LETTER BACHAM LETTER BHACHAM LETTER MUECHAM LETTE" +
	"R MACHAM LETTER BBACHAM LETTER YACHAM LETTER RACHAM LETTER LACHAM LETTER" +
	" VACHAM LETTER SSACHAM LETTER SACHAM LETTER HACHAM VOWEL SIGN AACHAM VOW" +
	"EL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EICHAM VOWEL SIGN UCHAM VOWEL" +
	" SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICHAM VOWEL SIGN AUCHAM VOWEL " +
	"SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT SIGN RACHAM CONSONANT SIGN L" +
	"ACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHAM LETTER FINAL GCHAM LETTER" +
	" FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LETTER FINAL CHCHAM LETTER FIN" +
	"AL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHAM LETTER FINAL YCHAM LETTER" +
	" FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL SSCHAM CONSONANT SIGN FINAL" +
	" MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROCHAM DIGIT ONECHAM DIGIT TWO" +
	"CHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIVECHAM DIGIT SIXCHAM DIGIT S" +
	"EVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCTUATION SPIRALCHAM PUNCTUATI" +
	"ON DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUNCTUATION TRIPLE DANDAMYANMA" +
	"R LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYANMAR LETTER KHAMTI CHAMYANM" +
	"AR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAMYANMAR LETTER KHAMTI NYAMYA" +
	"NMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI TTHAMYANMAR LETTER KHAMTI DD" +
	"AMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHAMTI DHAMYANMAR LETTER KHAMT" +
	"I NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KHAMTI HAMYANMAR LETTER KHAMT" +
	"I HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER LETTER KHAMTI REDUPLICATIO" +
	"NMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMTI ZAMYANMAR LETTER KHAMTI R" +
	"AMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM KHAMTI QNMYANMAR LOGOGRAM K" +
	"HAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANMAR SYMBOL AITON ONEMYANMAR " +
	"SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMAR SIGN PAO KAREN TONEMYANMA" +
	"R SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING TONE-5MYANMAR LETTER SHWE " +
	"PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI VIET LETTER LOW KOTAI VIET" +
	" LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIET LETTER HIGH KHOTAI VIET L" +
	"ETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VIET LETTER LOW GOTAI VIET LE") + ("" +
	"TTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET LETTER HIGH NGOTAI VIET LETT" +
	"ER LOW COTAI VIET LETTER HIGH COTAI VIET LETTER LOW CHOTAI VIET LETTER H" +
	"IGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER HIGH SOTAI VIET LETTER LOW " +
	"NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LOW DOTAI VIET LETTER HIGH DO" +
	"TAI VIET LETTER LOW TOTAI VIET LETTER HIGH TOTAI VIET LETTER LOW THOTAI " +
	"VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI VIET LETTER HIGH NOTAI VIE" +
	"T LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIET LETTER LOW POTAI VIET LET" +
	"TER HIGH POTAI VIET LETTER LOW PHOTAI VIET LETTER HIGH PHOTAI VIET LETTE" +
	"R LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTER LOW MOTAI VIET LETTER HIG" +
	"H MOTAI VIET LETTER LOW YOTAI VIET LETTER HIGH YOTAI VIET LETTER LOW ROT" +
	"AI VIET LETTER HIGH ROTAI VIET LETTER LOW LOTAI VIET LETTER HIGH LOTAI V" +
	"IET LETTER LOW VOTAI VIET LETTER HIGH VOTAI VIET LETTER LOW HOTAI VIET L" +
	"ETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LETTER HIGH OTAI VIET MAI KAN" +
	"GTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VOWEL UETAI VIET VOWEL UTAI V" +
	"IET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITTAI VIET VOWEL IATAI VIET VO" +
	"WEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI VIET VOWEL AYTAI VIET VOWE" +
	"L ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI VIET TONE MAI NUENGTAI VIET" +
	" TONE MAI THOTAI VIET TONE MAI SONGTAI VIET SYMBOL KONTAI VIET SYMBOL NU" +
	"ENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOITAI VIET SYMBOL KOI KOIMEETE" +
	"I MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI MAYEK LETTER CHAMEETEI MAYEK" +
	" LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYEK LETTER TTHAMEETEI MAYEK L" +
	"ETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK LETTER NNAMEETEI MAYEK LET" +
	"TER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VOWEL SIGN IIMEETEI MAYEK VOW" +
	"EL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI MAYEK VOWEL SIGN AUMEETEI MA" +
	"YEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI MAYEK AHANG KHUDAMMEETEI M" +
	"AYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MARKMEETEI MAYEK WORD REPETITI" +
	"ON MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI MAYEK VIRAMAETHIOPIC SYLLAB" +
	"LE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABLE TTHAAETHIOPIC SYLLABLE TT" +
	"HEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TTHOETHIOPIC SYLLABLE DDHUETH" +
	"IOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETHIOPIC SYLLABLE DDHEEETHIOPI" +
	"C SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC SYLLABLE DZUETHIOPIC SYLLA" +
	"BLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABLE DZEEETHIOPIC SYLLABLE DZE" +
	"ETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAETHIOPIC SYLLABLE CCHHUETHIO" +
	"PIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETHIOPIC SYLLABLE CCHHEEETHIOP" +
	"IC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIOPIC SYLLABLE BBAETHIOPIC SY" +
	"LLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLABLE BBAAETHIOPIC SYLLABLE B" +
	"BEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBOLATIN SMALL LETTER BARRED A" +
	"LPHALATIN SMALL LETTER A REVERSED-SCHWALATIN SMALL LETTER BLACKLETTER EL" +
	"ATIN SMALL LETTER BARRED ELATIN SMALL LETTER E WITH FLOURISHLATIN SMALL " +
	"LETTER LENIS FLATIN SMALL LETTER SCRIPT G WITH CROSSED-TAILLATIN SMALL L" +
	"ETTER L WITH INVERTED LAZY SLATIN SMALL LETTER L WITH DOUBLE MIDDLE TILD" +
	"ELATIN SMALL LETTER L WITH MIDDLE RINGLATIN SMALL LETTER M WITH CROSSED-" +
	"TAILLATIN SMALL LETTER N WITH CROSSED-TAILLATIN SMALL LETTER ENG WITH CR" +
	"OSSED-TAILLATIN SMALL LETTER BLACKLETTER OLATIN SMALL LETTER BLACKLETTER" +
	" O WITH STROKELATIN SMALL LETTER OPEN O WITH STROKELATIN SMALL LETTER IN" +
	"VERTED OELATIN SMALL LETTER TURNED OE WITH STROKELATIN SMALL LETTER TURN" +
	"ED OE WITH HORIZONTAL STROKELATIN SMALL LETTER TURNED O OPEN-OLATIN SMAL" +
	"L LETTER TURNED O OPEN-O WITH STROKELATIN SMALL LETTER STIRRUP RLATIN LE" +
	"TTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMALL LETTER R WITHOUT HANDLELA" +
	"TIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R WITH CROSSED-TAILLATIN SMA" +
	"LL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMALL LETTER SCRIPT RLATIN SMA" +
	"LL LETTER SCRIPT R WITH RINGLATIN SMALL LETTER BASELINE ESHLATIN SMALL L" +
	"ETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTER U BAR WITH SHORT RIGHT LE" +
	"GLATIN SMALL LETTER UILATIN SMALL LETTER TURNED UILATIN SMALL LETTER U W" +
	"ITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMALL LETTER CHI WITH LOW RIGHT" +
	" RINGLATIN SMALL LETTER CHI WITH LOW LEFT SERIFLATIN SMALL LETTER X WITH" +
	" LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG LEFT LEGLATIN SMALL LETTER" +
	" X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG L" +
	"EFT LEG WITH SERIFLATIN SMALL LETTER Y WITH SHORT RIGHT LEGMODIFIER BREV" +
	"E WITH INVERTED BREVEMODIFIER LETTER SMALL HENGMODIFIER LETTER SMALL L W" +
	"ITH INVERTED LAZY SMODIFIER LETTER SMALL L WITH MIDDLE TILDEMODIFIER LET" +
	"TER SMALL U WITH LEFT HOOKLATIN SMALL LETTER SAKHA YATLATIN SMALL LETTER" +
	" IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SMALL LETTER UOLATIN SMALL LE" +
	"TTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL OMEGALATIN SMALL LETTER DZ") + ("" +
	" DIGRAPH WITH RETROFLEX HOOKLATIN SMALL LETTER TS DIGRAPH WITH RETROFLEX" +
	" HOOKLATIN SMALL LETTER TURNED R WITH MIDDLE TILDEMODIFIER LETTER SMALL " +
	"TURNED WMODIFIER LETTER LEFT TACKMODIFIER LETTER RIGHT TACKCHEROKEE SMAL" +
	"L LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMALL LETTER ICHEROKEE SMALL L" +
	"ETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL LETTER VCHEROKEE SMALL LETT" +
	"ER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LETTER GECHEROKEE SMALL LETT" +
	"ER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LETTER GUCHEROKEE SMALL LETT" +
	"ER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LETTER HECHEROKEE SMALL LETT" +
	"ER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LETTER HUCHEROKEE SMALL LETT" +
	"ER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LETTER LECHEROKEE SMALL LETT" +
	"ER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LETTER LUCHEROKEE SMALL LETT" +
	"ER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LETTER MECHEROKEE SMALL LETT" +
	"ER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LETTER MUCHEROKEE SMALL LETT" +
	"ER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL LETTER NAHCHEROKEE SMALL LE" +
	"TTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL LETTER NOCHEROKEE SMALL LE" +
	"TTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL LETTER QUACHEROKEE SMALL L" +
	"ETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMALL LETTER QUOCHEROKEE SMAL" +
	"L LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE SMALL LETTER SACHEROKEE SM" +
	"ALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE SMALL LETTER SICHEROKEE SMA" +
	"LL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE SMALL LETTER SVCHEROKEE SMA" +
	"LL LETTER DACHEROKEE SMALL LETTER TACHEROKEE SMALL LETTER DECHEROKEE SMA" +
	"LL LETTER TECHEROKEE SMALL LETTER DICHEROKEE SMALL LETTER TICHEROKEE SMA" +
	"LL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE SMALL LETTER DVCHEROKEE SMA" +
	"LL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE SMALL LETTER TLECHEROKEE " +
	"SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHEROKEE SMALL LETTER TLUCHEROK" +
	"EE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACHEROKEE SMALL LETTER TSECHE" +
	"ROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TSOCHEROKEE SMALL LETTER TSU" +
	"CHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER WACHEROKEE SMALL LETTER W" +
	"ECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER WOCHEROKEE SMALL LETTER W" +
	"UCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER YAMEETEI MAYEK LETTER KOK" +
	"MEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAIMEETEI MAYEK LETTER MITMEE" +
	"TEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETEI MAYEK LETTER CHILMEETEI " +
	"MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI MAYEK LETTER NGOUMEETEI M" +
	"AYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI MAYEK LETTER YANGMEETEI MA" +
	"YEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAYEK LETTER IMEETEI MAYEK LE" +
	"TTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK LETTER GOKMEETEI MAYEK LE" +
	"TTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK LETTER BAMEETEI MAYEK LETTE" +
	"R JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTER GHOUMEETEI MAYEK LETTER " +
	"DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTER KOK LONSUMMEETEI MAYEK L" +
	"ETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUMMEETEI MAYEK LETTER PA LON" +
	"SUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK LETTER TIL LONSUMMEETEI MAY" +
	"EK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LONSUMMEETEI MAYEK VOWEL SIGN" +
	" ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK VOWEL SIGN ANAPMEETEI MAYE" +
	"K VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUNAPMEETEI MAYEK VOWEL SIGN " +
	"UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYEK VOWEL SIGN NUNGMEETEI MA" +
	"YEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK APUN IYEKMEETEI MAYEK DIGI" +
	"T ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT TWOMEETEI MAYEK DIGIT THR" +
	"EEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FIVEMEETEI MAYEK DIGIT SIXME" +
	"ETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHTMEETEI MAYEK DIGIT NINEHAN" +
	"GUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGUL JUNGSEONG YO-AHANGUL JUN" +
	"GSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGSEONG U-YEOHANGUL JUNGSEONG" +
	" U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG YU-OHANGUL JUNGSEONG EU-AHA" +
	"NGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGUL JUNGSEONG EU-OHANGUL JUN" +
	"GSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNGSEONG I-YEOHANGUL JUNGSEON" +
	"G I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I-YOHANGUL JUNGSEONG I-YUHA" +
	"NGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANGUL JUNGSEONG ARAEA-EHANGUL" +
	" JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-CHIEUCHHANGUL JONGSEONG SSA" +
	"NGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-PIEUPH" +
	"ANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TIKEUT-SIOS-KIYEOKHANGUL JON" +
	"GSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHIEUCHHANGUL JONGSEONG TIKEU" +
	"T-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHANGUL JONGSEONG RIEUL-KIYEOK" +
	"-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-MIEUM-HI" +
	"EUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL JONGSEONG RIEUL-PIEUP-PHIEU" +
	"PHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEU") + ("" +
	"HHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEONG MIEUM-NIEUNHANGUL JONGSE" +
	"ONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEUMHANGUL JONGSEONG MIEUM-PI" +
	"EUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JONGSEONG PIEUP-TIKEUTHANGUL " +
	"JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG PIEUP-MIEUMHANGUL JONGSEON" +
	"G SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUTHANGUL JONGSEONG PIEUP-CIE" +
	"UCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEONG SIOS-MIEUMHANGUL JONGSE" +
	"ONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSIOS-KIYEOKHANGUL JONGSEONG " +
	"SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSHANGUL JONGSEONG SIOS-CIEUC" +
	"HANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG SIOS-THIEUTHHANGUL JONGSEO" +
	"NG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHANGUL JONGSEONG PANSIOS-KAPY" +
	"EOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL JONGSEONG YESIEUNG-HIEUHH" +
	"ANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CIEUC-SSANGPIEUPHANGUL JONGS" +
	"EONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHANGUL JONGSEONG PHIEUPH-THI" +
	"EUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPATIBILITY IDEOGRAPH-F901CJK " +
	"COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY IDEOGRAPH-F903CJK COMPATIB" +
	"ILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAPH-F905CJK COMPATIBILITY ID" +
	"EOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJK COMPATIBILITY IDEOGRAPH-" +
	"F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPATIBILITY IDEOGRAPH-F90ACJK " +
	"COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY IDEOGRAPH-F90CCJK COMPATIB" +
	"ILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAPH-F90ECJK COMPATIBILITY ID" +
	"EOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJK COMPATIBILITY IDEOGRAPH-" +
	"F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPATIBILITY IDEOGRAPH-F913CJK " +
	"COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY IDEOGRAPH-F915CJK COMPATIB" +
	"ILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAPH-F917CJK COMPATIBILITY ID" +
	"EOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJK COMPATIBILITY IDEOGRAPH-" +
	"F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPATIBILITY IDEOGRAPH-F91CCJK " +
	"COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY IDEOGRAPH-F91ECJK COMPATIB" +
	"ILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAPH-F920CJK COMPATIBILITY ID" +
	"EOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJK COMPATIBILITY IDEOGRAPH-" +
	"F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPATIBILITY IDEOGRAPH-F925CJK " +
	"COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY IDEOGRAPH-F927CJK COMPATIB" +
	"ILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAPH-F929CJK COMPATIBILITY ID" +
	"EOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJK COMPATIBILITY IDEOGRAPH-" +
	"F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPATIBILITY IDEOGRAPH-F92ECJK " +
	"COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY IDEOGRAPH-F930CJK COMPATIB" +
	"ILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAPH-F932CJK COMPATIBILITY ID" +
	"EOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJK COMPATIBILITY IDEOGRAPH-" +
	"F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPATIBILITY IDEOGRAPH-F937CJK " +
	"COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY IDEOGRAPH-F939CJK COMPATIB" +
	"ILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAPH-F93BCJK COMPATIBILITY ID" +
	"EOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJK COMPATIBILITY IDEOGRAPH-" +
	"F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPATIBILITY IDEOGRAPH-F940CJK " +
	"COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY IDEOGRAPH-F942CJK COMPATIB" +
	"ILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAPH-F944CJK COMPATIBILITY ID" +
	"EOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJK COMPATIBILITY IDEOGRAPH-" +
	"F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPATIBILITY IDEOGRAPH-F949CJK " +
	"COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY IDEOGRAPH-F94BCJK COMPATIB" +
	"ILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAPH-F94DCJK COMPATIBILITY ID" +
	"EOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJK COMPATIBILITY IDEOGRAPH-" +
	"F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPATIBILITY IDEOGRAPH-F952CJK " +
	"COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY IDEOGRAPH-F954CJK COMPATIB" +
	"ILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAPH-F956CJK COMPATIBILITY ID" +
	"EOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJK COMPATIBILITY IDEOGRAPH-" +
	"F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPATIBILITY IDEOGRAPH-F95BCJK " +
	"COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY IDEOGRAPH-F95DCJK COMPATIB" +
	"ILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAPH-F95FCJK COMPATIBILITY ID" +
	"EOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJK COMPATIBILITY IDEOGRAPH-" +
	"F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPATIBILITY IDEOGRAPH-F964CJK " +
	"COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY IDEOGRAPH-F966CJK COMPATIB" +
	"ILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAPH-F968CJK COMPATIBILITY ID" +
	"EOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJK COMPATIBILITY IDEOGRAPH-" +
	"F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPATIBILITY IDEOGRAPH-F96DCJK " +
	"COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY IDEOGRAPH-F96FCJK COMPATIB" +
	"ILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAPH-F971CJK COMPATIBILITY ID") + ("" +
	"EOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJK COMPATIBILITY IDEOGRAPH-" +
	"F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPATIBILITY IDEOGRAPH-F976CJK " +
	"COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY IDEOGRAPH-F978CJK COMPATIB" +
	"ILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAPH-F97ACJK COMPATIBILITY ID" +
	"EOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJK COMPATIBILITY IDEOGRAPH-" +
	"F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPATIBILITY IDEOGRAPH-F97FCJK " +
	"COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY IDEOGRAPH-F981CJK COMPATIB" +
	"ILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAPH-F983CJK COMPATIBILITY ID" +
	"EOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJK COMPATIBILITY IDEOGRAPH-" +
	"F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPATIBILITY IDEOGRAPH-F988CJK " +
	"COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY IDEOGRAPH-F98ACJK COMPATIB" +
	"ILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAPH-F98CCJK COMPATIBILITY ID" +
	"EOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJK COMPATIBILITY IDEOGRAPH-" +
	"F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPATIBILITY IDEOGRAPH-F991CJK " +
	"COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY IDEOGRAPH-F993CJK COMPATIB" +
	"ILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAPH-F995CJK COMPATIBILITY ID" +
	"EOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJK COMPATIBILITY IDEOGRAPH-" +
	"F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPATIBILITY IDEOGRAPH-F99ACJK " +
	"COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY IDEOGRAPH-F99CCJK COMPATIB" +
	"ILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAPH-F99ECJK COMPATIBILITY ID" +
	"EOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJK COMPATIBILITY IDEOGRAPH-" +
	"F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPATIBILITY IDEOGRAPH-F9A3CJK " +
	"COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY IDEOGRAPH-F9A5CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAPH-F9A7CJK COMPATIBILITY ID" +
	"EOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJK COMPATIBILITY IDEOGRAPH-" +
	"F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPATIBILITY IDEOGRAPH-F9ACCJK " +
	"COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY IDEOGRAPH-F9AECJK COMPATIB" +
	"ILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAPH-F9B0CJK COMPATIBILITY ID" +
	"EOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJK COMPATIBILITY IDEOGRAPH-" +
	"F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPATIBILITY IDEOGRAPH-F9B5CJK " +
	"COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY IDEOGRAPH-F9B7CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAPH-F9B9CJK COMPATIBILITY ID" +
	"EOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJK COMPATIBILITY IDEOGRAPH-" +
	"F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPATIBILITY IDEOGRAPH-F9BECJK " +
	"COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY IDEOGRAPH-F9C0CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAPH-F9C2CJK COMPATIBILITY ID" +
	"EOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJK COMPATIBILITY IDEOGRAPH-" +
	"F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPATIBILITY IDEOGRAPH-F9C7CJK " +
	"COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY IDEOGRAPH-F9C9CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAPH-F9CBCJK COMPATIBILITY ID" +
	"EOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJK COMPATIBILITY IDEOGRAPH-" +
	"F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPATIBILITY IDEOGRAPH-F9D0CJK " +
	"COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY IDEOGRAPH-F9D2CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAPH-F9D4CJK COMPATIBILITY ID" +
	"EOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJK COMPATIBILITY IDEOGRAPH-" +
	"F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPATIBILITY IDEOGRAPH-F9D9CJK " +
	"COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY IDEOGRAPH-F9DBCJK COMPATIB" +
	"ILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAPH-F9DDCJK COMPATIBILITY ID" +
	"EOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJK COMPATIBILITY IDEOGRAPH-" +
	"F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPATIBILITY IDEOGRAPH-F9E2CJK " +
	"COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY IDEOGRAPH-F9E4CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAPH-F9E6CJK COMPATIBILITY ID" +
	"EOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJK COMPATIBILITY IDEOGRAPH-" +
	"F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPATIBILITY IDEOGRAPH-F9EBCJK " +
	"COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY IDEOGRAPH-F9EDCJK COMPATIB" +
	"ILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAPH-F9EFCJK COMPATIBILITY ID" +
	"EOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJK COMPATIBILITY IDEOGRAPH-" +
	"F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPATIBILITY IDEOGRAPH-F9F4CJK " +
	"COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY IDEOGRAPH-F9F6CJK COMPATIB" +
	"ILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAPH-F9F8CJK COMPATIBILITY ID" +
	"EOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJK COMPATIBILITY IDEOGRAPH-" +
	"F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPATIBILITY IDEOGRAPH-F9FDCJK " +
	"COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY IDEOGRAPH-F9FFCJK COMPATIB" +
	"ILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAPH-FA01CJK COMPATIBILITY ID") + ("" +
	"EOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJK COMPATIBILITY IDEOGRAPH-" +
	"FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPATIBILITY IDEOGRAPH-FA06CJK " +
	"COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY IDEOGRAPH-FA08CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAPH-FA0ACJK COMPATIBILITY ID" +
	"EOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJK COMPATIBILITY IDEOGRAPH-" +
	"FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPATIBILITY IDEOGRAPH-FA0FCJK " +
	"COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY IDEOGRAPH-FA11CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAPH-FA13CJK COMPATIBILITY ID" +
	"EOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJK COMPATIBILITY IDEOGRAPH-" +
	"FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPATIBILITY IDEOGRAPH-FA18CJK " +
	"COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY IDEOGRAPH-FA1ACJK COMPATIB" +
	"ILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAPH-FA1CCJK COMPATIBILITY ID" +
	"EOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJK COMPATIBILITY IDEOGRAPH-" +
	"FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPATIBILITY IDEOGRAPH-FA21CJK " +
	"COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY IDEOGRAPH-FA23CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAPH-FA25CJK COMPATIBILITY ID" +
	"EOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJK COMPATIBILITY IDEOGRAPH-" +
	"FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPATIBILITY IDEOGRAPH-FA2ACJK " +
	"COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY IDEOGRAPH-FA2CCJK COMPATIB" +
	"ILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAPH-FA2ECJK COMPATIBILITY ID" +
	"EOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJK COMPATIBILITY IDEOGRAPH-" +
	"FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPATIBILITY IDEOGRAPH-FA33CJK " +
	"COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY IDEOGRAPH-FA35CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAPH-FA37CJK COMPATIBILITY ID" +
	"EOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJK COMPATIBILITY IDEOGRAPH-" +
	"FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPATIBILITY IDEOGRAPH-FA3CCJK " +
	"COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY IDEOGRAPH-FA3ECJK COMPATIB" +
	"ILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAPH-FA40CJK COMPATIBILITY ID" +
	"EOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJK COMPATIBILITY IDEOGRAPH-" +
	"FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPATIBILITY IDEOGRAPH-FA45CJK " +
	"COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY IDEOGRAPH-FA47CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAPH-FA49CJK COMPATIBILITY ID" +
	"EOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJK COMPATIBILITY IDEOGRAPH-" +
	"FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPATIBILITY IDEOGRAPH-FA4ECJK " +
	"COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY IDEOGRAPH-FA50CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAPH-FA52CJK COMPATIBILITY ID" +
	"EOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJK COMPATIBILITY IDEOGRAPH-" +
	"FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPATIBILITY IDEOGRAPH-FA57CJK " +
	"COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY IDEOGRAPH-FA59CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAPH-FA5BCJK COMPATIBILITY ID" +
	"EOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJK COMPATIBILITY IDEOGRAPH-" +
	"FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPATIBILITY IDEOGRAPH-FA60CJK " +
	"COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY IDEOGRAPH-FA62CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAPH-FA64CJK COMPATIBILITY ID" +
	"EOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJK COMPATIBILITY IDEOGRAPH-" +
	"FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPATIBILITY IDEOGRAPH-FA69CJK " +
	"COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY IDEOGRAPH-FA6BCJK COMPATIB" +
	"ILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAPH-FA6DCJK COMPATIBILITY ID" +
	"EOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJK COMPATIBILITY IDEOGRAPH-" +
	"FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPATIBILITY IDEOGRAPH-FA74CJK " +
	"COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY IDEOGRAPH-FA76CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAPH-FA78CJK COMPATIBILITY ID" +
	"EOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJK COMPATIBILITY IDEOGRAPH-" +
	"FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPATIBILITY IDEOGRAPH-FA7DCJK " +
	"COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY IDEOGRAPH-FA7FCJK COMPATIB" +
	"ILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAPH-FA81CJK COMPATIBILITY ID" +
	"EOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJK COMPATIBILITY IDEOGRAPH-" +
	"FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPATIBILITY IDEOGRAPH-FA86CJK " +
	"COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY IDEOGRAPH-FA88CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAPH-FA8ACJK COMPATIBILITY ID" +
	"EOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJK COMPATIBILITY IDEOGRAPH-" +
	"FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPATIBILITY IDEOGRAPH-FA8FCJK " +
	"COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY IDEOGRAPH-FA91CJK COMPATIB" +
	"ILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAPH-FA93CJK COMPATIBILITY ID") + ("" +
	"EOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJK COMPATIBILITY IDEOGRAPH-" +
	"FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPATIBILITY IDEOGRAPH-FA98CJK " +
	"COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY IDEOGRAPH-FA9ACJK COMPATIB" +
	"ILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAPH-FA9CCJK COMPATIBILITY ID" +
	"EOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJK COMPATIBILITY IDEOGRAPH-" +
	"FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPATIBILITY IDEOGRAPH-FAA1CJK " +
	"COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY IDEOGRAPH-FAA3CJK COMPATIB" +
	"ILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAPH-FAA5CJK COMPATIBILITY ID" +
	"EOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJK COMPATIBILITY IDEOGRAPH-" +
	"FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPATIBILITY IDEOGRAPH-FAAACJK " +
	"COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY IDEOGRAPH-FAACCJK COMPATIB" +
	"ILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAPH-FAAECJK COMPATIBILITY ID" +
	"EOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJK COMPATIBILITY IDEOGRAPH-" +
	"FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPATIBILITY IDEOGRAPH-FAB3CJK " +
	"COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY IDEOGRAPH-FAB5CJK COMPATIB" +
	"ILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAPH-FAB7CJK COMPATIBILITY ID" +
	"EOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJK COMPATIBILITY IDEOGRAPH-" +
	"FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPATIBILITY IDEOGRAPH-FABCCJK " +
	"COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY IDEOGRAPH-FABECJK COMPATIB" +
	"ILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAPH-FAC0CJK COMPATIBILITY ID" +
	"EOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJK COMPATIBILITY IDEOGRAPH-" +
	"FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPATIBILITY IDEOGRAPH-FAC5CJK " +
	"COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY IDEOGRAPH-FAC7CJK COMPATIB" +
	"ILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAPH-FAC9CJK COMPATIBILITY ID" +
	"EOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJK COMPATIBILITY IDEOGRAPH-" +
	"FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPATIBILITY IDEOGRAPH-FACECJK " +
	"COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY IDEOGRAPH-FAD0CJK COMPATIB" +
	"ILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAPH-FAD2CJK COMPATIBILITY ID" +
	"EOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJK COMPATIBILITY IDEOGRAPH-" +
	"FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPATIBILITY IDEOGRAPH-FAD7CJK " +
	"COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY IDEOGRAPH-FAD9LATIN SMALL " +
	"LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL LIGATURE FLLATIN SMALL LIG" +
	"ATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL LIGATURE LONG S TLATIN SMAL" +
	"L LIGATURE STARMENIAN SMALL LIGATURE MEN NOWARMENIAN SMALL LIGATURE MEN " +
	"ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMALL LIGATURE VEW NOWARMENIA" +
	"N SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH HIRIQHEBREW POINT JUDEO-S" +
	"PANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD PATAHHEBREW LETTER ALTERNAT" +
	"IVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER WIDE DALETHEBREW LETTER WID" +
	"E HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE LAMEDHEBREW LETTER WIDE FIN" +
	"AL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WIDE TAVHEBREW LETTER ALTERNA" +
	"TIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOTHEBREW LETTER SHIN WITH SI" +
	"N DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN DOTHEBREW LETTER SHIN WITH " +
	"DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATAHHEBREW LETTER ALEF WITH Q" +
	"AMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTER BET WITH DAGESHHEBREW LE" +
	"TTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH DAGESHHEBREW LETTER HE WI" +
	"TH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LETTER ZAYIN WITH DAGESHHEBR" +
	"EW LETTER TET WITH DAGESHHEBREW LETTER YOD WITH DAGESHHEBREW LETTER FINA" +
	"L KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESHHEBREW LETTER LAMED WITH D" +
	"AGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTER NUN WITH DAGESHHEBREW LE" +
	"TTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE WITH DAGESHHEBREW LETTER P" +
	"E WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHEBREW LETTER QOF WITH DAGES" +
	"HHEBREW LETTER RESH WITH DAGESHHEBREW LETTER SHIN WITH DAGESHHEBREW LETT" +
	"ER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAMHEBREW LETTER BET WITH RAF" +
	"EHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE WITH RAFEHEBREW LIGATURE AL" +
	"EF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORMARABIC LETTER ALEF WASLA F" +
	"INAL FORMARABIC LETTER BEEH ISOLATED FORMARABIC LETTER BEEH FINAL FORMAR" +
	"ABIC LETTER BEEH INITIAL FORMARABIC LETTER BEEH MEDIAL FORMARABIC LETTER" +
	" PEH ISOLATED FORMARABIC LETTER PEH FINAL FORMARABIC LETTER PEH INITIAL " +
	"FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER BEHEH ISOLATED FORMARABIC" +
	" LETTER BEHEH FINAL FORMARABIC LETTER BEHEH INITIAL FORMARABIC LETTER BE" +
	"HEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED FORMARABIC LETTER TTEHEH FI" +
	"NAL FORMARABIC LETTER TTEHEH INITIAL FORMARABIC LETTER TTEHEH MEDIAL FOR" +
	"MARABIC LETTER TEHEH ISOLATED FORMARABIC LETTER TEHEH FINAL FORMARABIC L" +
	"ETTER TEHEH INITIAL FORMARABIC LETTER TEHEH MEDIAL FORMARABIC LETTER TTE") + ("" +
	"H ISOLATED FORMARABIC LETTER TTEH FINAL FORMARABIC LETTER TTEH INITIAL F" +
	"ORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER VEH ISOLATED FORMARABIC L" +
	"ETTER VEH FINAL FORMARABIC LETTER VEH INITIAL FORMARABIC LETTER VEH MEDI" +
	"AL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC LETTER PEHEH FINAL FORMAR" +
	"ABIC LETTER PEHEH INITIAL FORMARABIC LETTER PEHEH MEDIAL FORMARABIC LETT" +
	"ER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL FORMARABIC LETTER DYEH INI" +
	"TIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC LETTER NYEH ISOLATED FORMA" +
	"RABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH INITIAL FORMARABIC LETTER" +
	" NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED FORMARABIC LETTER TCHEH FI" +
	"NAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC LETTER TCHEH MEDIAL FORMA" +
	"RABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTER TCHEHEH FINAL FORMARABIC" +
	" LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHEHEH MEDIAL FORMARABIC LETT" +
	"ER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FINAL FORMARABIC LETTER DAHA" +
	"L ISOLATED FORMARABIC LETTER DAHAL FINAL FORMARABIC LETTER DUL ISOLATED " +
	"FORMARABIC LETTER DUL FINAL FORMARABIC LETTER DDAL ISOLATED FORMARABIC L" +
	"ETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATED FORMARABIC LETTER JEH FI" +
	"NAL FORMARABIC LETTER RREH ISOLATED FORMARABIC LETTER RREH FINAL FORMARA" +
	"BIC LETTER KEHEH ISOLATED FORMARABIC LETTER KEHEH FINAL FORMARABIC LETTE" +
	"R KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL FORMARABIC LETTER GAF ISO" +
	"LATED FORMARABIC LETTER GAF FINAL FORMARABIC LETTER GAF INITIAL FORMARAB" +
	"IC LETTER GAF MEDIAL FORMARABIC LETTER GUEH ISOLATED FORMARABIC LETTER G" +
	"UEH FINAL FORMARABIC LETTER GUEH INITIAL FORMARABIC LETTER GUEH MEDIAL F" +
	"ORMARABIC LETTER NGOEH ISOLATED FORMARABIC LETTER NGOEH FINAL FORMARABIC" +
	" LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH MEDIAL FORMARABIC LETTER N" +
	"OON GHUNNA ISOLATED FORMARABIC LETTER NOON GHUNNA FINAL FORMARABIC LETTE" +
	"R RNOON ISOLATED FORMARABIC LETTER RNOON FINAL FORMARABIC LETTER RNOON I" +
	"NITIAL FORMARABIC LETTER RNOON MEDIAL FORMARABIC LETTER HEH WITH YEH ABO" +
	"VE ISOLATED FORMARABIC LETTER HEH WITH YEH ABOVE FINAL FORMARABIC LETTER" +
	" HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL FINAL FORMARABIC LETTER HE" +
	"H GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDIAL FORMARABIC LETTER HEH D" +
	"OACHASHMEE ISOLATED FORMARABIC LETTER HEH DOACHASHMEE FINAL FORMARABIC L" +
	"ETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTER HEH DOACHASHMEE MEDIAL F" +
	"ORMARABIC LETTER YEH BARREE ISOLATED FORMARABIC LETTER YEH BARREE FINAL " +
	"FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER" +
	" YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC SYMBOL DOT ABOVEARABIC SYM" +
	"BOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABIC SYMBOL TWO DOTS BELOWARA" +
	"BIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE DOTS BELOWARABIC SYMBOL T" +
	"HREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBOL THREE DOTS POINTING DOWN" +
	"WARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC SYMBOL FOUR DOTS BELOWARA" +
	"BIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYMBOL TWO DOTS VERTICALLY AB" +
	"OVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARABIC SYMBOL RINGARABIC SYMBO" +
	"L SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOWARABIC SYMBOL WASLA ABOVEA" +
	"RABIC LETTER NG ISOLATED FORMARABIC LETTER NG FINAL FORMARABIC LETTER NG" +
	" INITIAL FORMARABIC LETTER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMAR" +
	"ABIC LETTER U FINAL FORMARABIC LETTER OE ISOLATED FORMARABIC LETTER OE F" +
	"INAL FORMARABIC LETTER YU ISOLATED FORMARABIC LETTER YU FINAL FORMARABIC" +
	" LETTER U WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER VE ISOLATED FORMAR" +
	"ABIC LETTER VE FINAL FORMARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC LE" +
	"TTER KIRGHIZ OE FINAL FORMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC L" +
	"ETTER KIRGHIZ YU FINAL FORMARABIC LETTER E ISOLATED FORMARABIC LETTER E " +
	"FINAL FORMARABIC LETTER E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC " +
	"LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIGH" +
	"UR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA" +
	" ABOVE WITH ALEF ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH " +
	"ALEF FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FOR" +
	"MARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE " +
	"YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH WAW FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U I" +
	"SOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABIC" +
	" LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH " +
	"WITH HAMZA ABOVE WITH OE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE " +
	"WITH YU ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL " +
	"FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIGA" +
	"TURE YEH WITH HAMZA ABOVE WITH E FINAL FORMARABIC LIGATURE YEH WITH HAMZ") + ("" +
	"A ABOVE WITH E INITIAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA" +
	" ABOVE WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH" +
	" WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KIR" +
	"GHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORMARABIC LETTER FA" +
	"RSI YEH ISOLATED FORMARABIC LETTER FARSI YEH FINAL FORMARABIC LETTER FAR" +
	"SI YEH INITIAL FORMARABIC LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE YE" +
	"H WITH HAMZA ABOVE WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA" +
	" ABOVE WITH HAH ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH M" +
	"EEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA " +
	"ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM" +
	"ARABIC LIGATURE BEH WITH JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH " +
	"ISOLATED FORMARABIC LIGATURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE " +
	"BEH WITH MEEM ISOLATED FORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATE" +
	"D FORMARABIC LIGATURE BEH WITH YEH ISOLATED FORMARABIC LIGATURE TEH WITH" +
	" JEEM ISOLATED FORMARABIC LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIGA" +
	"TURE TEH WITH KHAH ISOLATED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED F" +
	"ORMARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TE" +
	"H WITH YEH ISOLATED FORMARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARAB" +
	"IC LIGATURE THEH WITH MEEM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF M" +
	"AKSURA ISOLATED FORMARABIC LIGATURE THEH WITH YEH ISOLATED FORMARABIC LI" +
	"GATURE JEEM WITH HAH ISOLATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLATE" +
	"D FORMARABIC LIGATURE HAH WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WIT" +
	"H MEEM ISOLATED FORMARABIC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC L" +
	"IGATURE KHAH WITH HAH ISOLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLAT" +
	"ED FORMARABIC LIGATURE SEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN " +
	"WITH HAH ISOLATED FORMARABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABIC" +
	" LIGATURE SEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOLA" +
	"TED FORMARABIC LIGATURE SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD W" +
	"ITH JEEM ISOLATED FORMARABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC L" +
	"IGATURE DAD WITH KHAH ISOLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLATE" +
	"D FORMARABIC LIGATURE TAH WITH HAH ISOLATED FORMARABIC LIGATURE TAH WITH" +
	" MEEM ISOLATED FORMARABIC LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LIG" +
	"ATURE AIN WITH JEEM ISOLATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED " +
	"FORMARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN W" +
	"ITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC " +
	"LIGATURE FEH WITH HAH ISOLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLATE" +
	"D FORMARABIC LIGATURE FEH WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WIT" +
	"H ALEF MAKSURA ISOLATED FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMAR" +
	"ABIC LIGATURE QAF WITH HAH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM IS" +
	"OLATED FORMARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIG" +
	"ATURE QAF WITH YEH ISOLATED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED F" +
	"ORMARABIC LIGATURE KAF WITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH H" +
	"AH ISOLATED FORMARABIC LIGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGATU" +
	"RE KAF WITH LAM ISOLATED FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FORM" +
	"ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF W" +
	"ITH YEH ISOLATED FORMARABIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC L" +
	"IGATURE LAM WITH HAH ISOLATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATED" +
	" FORMARABIC LIGATURE LAM WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WITH" +
	" ALEF MAKSURA ISOLATED FORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMARA" +
	"BIC LIGATURE MEEM WITH JEEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH I" +
	"SOLATED FORMARABIC LIGATURE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE " +
	"MEEM WITH MEEM ISOLATED FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLA" +
	"TED FORMARABIC LIGATURE MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON " +
	"WITH JEEM ISOLATED FORMARABIC LIGATURE NOON WITH HAH ISOLATED FORMARABIC" +
	" LIGATURE NOON WITH KHAH ISOLATED FORMARABIC LIGATURE NOON WITH MEEM ISO" +
	"LATED FORMARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LIG" +
	"ATURE NOON WITH YEH ISOLATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED " +
	"FORMARABIC LIGATURE HEH WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH " +
	"ALEF MAKSURA ISOLATED FORMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARAB" +
	"IC LIGATURE YEH WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISOL" +
	"ATED FORMARABIC LIGATURE YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH " +
	"WITH MEEM ISOLATED FORMARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FO" +
	"RMARABIC LIGATURE YEH WITH YEH ISOLATED FORMARABIC LIGATURE THAL WITH SU" +
	"PERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF IS") + ("" +
	"OLATED FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED F" +
	"ORMARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SHA" +
	"DDA WITH KASRATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLATE" +
	"D FORMARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SHA" +
	"DDA WITH KASRA ISOLATED FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF" +
	" ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE Y" +
	"EH WITH HAMZA ABOVE WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA A" +
	"BOVE WITH NOON FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FO" +
	"RMARABIC LIGATURE BEH WITH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN F" +
	"INAL FORMARABIC LIGATURE BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WIT" +
	"H NOON FINAL FORMARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE BEH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH REH FINAL FORMA" +
	"RABIC LIGATURE TEH WITH ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FIN" +
	"AL FORMARABIC LIGATURE TEH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH " +
	"ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LIG" +
	"ATURE THEH WITH REH FINAL FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORMA" +
	"RABIC LIGATURE THEH WITH MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON F" +
	"INAL FORMARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATUR" +
	"E THEH WITH YEH FINAL FORMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FO" +
	"RMARABIC LIGATURE FEH WITH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF M" +
	"AKSURA FINAL FORMARABIC LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE " +
	"KAF WITH ALEF FINAL FORMARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC LI" +
	"GATURE KAF WITH MEEM FINAL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FIN" +
	"AL FORMARABIC LIGATURE KAF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH M" +
	"EEM FINAL FORMARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LIG" +
	"ATURE LAM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMAR" +
	"ABIC LIGATURE MEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FIN" +
	"AL FORMARABIC LIGATURE NOON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WIT" +
	"H MEEM FINAL FORMARABIC LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATUR" +
	"E NOON WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL F" +
	"ORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC L" +
	"IGATURE YEH WITH REH FINAL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORMA" +
	"RABIC LIGATURE YEH WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FIN" +
	"AL FORMARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE Y" +
	"EH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INI" +
	"TIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARABI" +
	"C LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE YE" +
	"H WITH HAMZA ABOVE WITH MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA " +
	"ABOVE WITH HEH INITIAL FORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMARA" +
	"BIC LIGATURE BEH WITH HAH INITIAL FORMARABIC LIGATURE BEH WITH KHAH INIT" +
	"IAL FORMARABIC LIGATURE BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH WI" +
	"TH HEH INITIAL FORMARABIC LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIGA" +
	"TURE TEH WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH KHAH INITIAL FORM" +
	"ARABIC LIGATURE TEH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH I" +
	"NITIAL FORMARABIC LIGATURE THEH WITH MEEM INITIAL FORMARABIC LIGATURE JE" +
	"EM WITH HAH INITIAL FORMARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE HAH WITH JEEM INITIAL FORMARABIC LIGATURE HAH WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE KHAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH W" +
	"ITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC L" +
	"IGATURE SEEN WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIAL" +
	" FORMARABIC LIGATURE SEEN WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH" +
	" HAH INITIAL FORMARABIC LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGATU" +
	"RE SAD WITH MEEM INITIAL FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORMA" +
	"RABIC LIGATURE DAD WITH HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH IN" +
	"ITIAL FORMARABIC LIGATURE DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH " +
	"WITH HAH INITIAL FORMARABIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC LI" +
	"GATURE AIN WITH JEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL F" +
	"ORMARABIC LIGATURE GHAIN WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIGA" +
	"TURE FEH WITH HAH INITIAL FORMARABIC LIGATURE FEH WITH KHAH INITIAL FORM" +
	"ARABIC LIGATURE FEH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH I" +
	"NITIAL FORMARABIC LIGATURE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KAF") + ("" +
	" WITH JEEM INITIAL FORMARABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC L" +
	"IGATURE KAF WITH KHAH INITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL F" +
	"ORMARABIC LIGATURE KAF WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH JE" +
	"EM INITIAL FORMARABIC LIGATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE " +
	"LAM WITH KHAH INITIAL FORMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE LAM WITH HEH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INIT" +
	"IAL FORMARABIC LIGATURE MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM W" +
	"ITH KHAH INITIAL FORMARABIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE NOON WITH JEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH INITIAL" +
	" FORMARABIC LIGATURE NOON WITH KHAH INITIAL FORMARABIC LIGATURE NOON WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE NOON WITH HEH INITIAL FORMARABIC LIGA" +
	"TURE HEH WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FOR" +
	"MARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE Y" +
	"EH WITH JEEM INITIAL FORMARABIC LIGATURE YEH WITH HAH INITIAL FORMARABIC" +
	" LIGATURE YEH WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITIA" +
	"L FORMARABIC LIGATURE YEH WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH " +
	"HAMZA ABOVE WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WI" +
	"TH HEH MEDIAL FORMARABIC LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGATU" +
	"RE BEH WITH HEH MEDIAL FORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARAB" +
	"IC LIGATURE TEH WITH HEH MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDIA" +
	"L FORMARABIC LIGATURE THEH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WITH" +
	" MEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATUR" +
	"E SHEEN WITH MEEM MEDIAL FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORMA" +
	"RABIC LIGATURE KAF WITH LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM MED" +
	"IAL FORMARABIC LIGATURE LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WI" +
	"TH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGAT" +
	"URE YEH WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMARA" +
	"BIC LIGATURE SHADDA WITH FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH DA" +
	"MMA MEDIAL FORMARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGAT" +
	"URE TAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISOL" +
	"ATED FORMARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGAT" +
	"URE AIN WITH YEH ISOLATED FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA IS" +
	"OLATED FORMARABIC LIGATURE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE S" +
	"EEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLATE" +
	"D FORMARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATU" +
	"RE SHEEN WITH YEH ISOLATED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA ISO" +
	"LATED FORMARABIC LIGATURE HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM" +
	" WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED F" +
	"ORMARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE K" +
	"HAH WITH YEH ISOLATED FORMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED" +
	" FORMARABIC LIGATURE SAD WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH " +
	"ALEF MAKSURA ISOLATED FORMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARAB" +
	"IC LIGATURE SHEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH " +
	"ISOLATED FORMARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATUR" +
	"E SHEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED F" +
	"ORMARABIC LIGATURE SEEN WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH R" +
	"EH ISOLATED FORMARABIC LIGATURE DAD WITH REH ISOLATED FORMARABIC LIGATUR" +
	"E TAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FOR" +
	"MARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WIT" +
	"H YEH FINAL FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE GHAIN WITH YEH FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSUR" +
	"A FINAL FORMARABIC LIGATURE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHEE" +
	"N WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORMA" +
	"RABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH " +
	"YEH FINAL FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC LI" +
	"GATURE JEEM WITH YEH FINAL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA FI" +
	"NAL FORMARABIC LIGATURE KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WITH" +
	" ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC LI" +
	"GATURE DAD WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH YEH FINA" +
	"L FORMARABIC LIGATURE SHEEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN WI" +
	"TH HAH FINAL FORMARABIC LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGATU" +
	"RE SHEEN WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMAR" +
	"ABIC LIGATURE SEEN WITH REH FINAL FORMARABIC LIGATURE SAD WITH REH FINAL" +
	" FORMARABIC LIGATURE DAD WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH J") + ("" +
	"EEM INITIAL FORMARABIC LIGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGATU" +
	"RE SHEEN WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL F" +
	"ORMARABIC LIGATURE SEEN WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH " +
	"HEH INITIAL FORMARABIC LIGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E SEEN WITH JEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMARA" +
	"BIC LIGATURE SEEN WITH KHAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM M" +
	"EDIAL FORMARABIC LIGATURE SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHEE" +
	"N WITH KHAH MEDIAL FORMARABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC L" +
	"IGATURE ZAH WITH MEEM MEDIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FINA" +
	"L FORMARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORMORNATE LEFT PARENT" +
	"HESISORNATE RIGHT PARENTHESISARABIC LIGATURE RAHIMAHU ALLAAHARABIC LIGAT" +
	"URE RADI ALLAAHU ANHARABIC LIGATURE RADI ALLAAHU ANHAAARABIC LIGATURE RA" +
	"DI ALLAAHU ANHUMARABIC LIGATURE RADI ALLAAHU ANHUMAAARABIC LIGATURE RADI" +
	" ALLAAHU ANHUNNAARABIC LIGATURE SALLALLAAHU ALAYHI WA-AALIHARABIC LIGATU" +
	"RE ALAYHI AS-SALAAMARABIC LIGATURE ALAYHIM AS-SALAAMARABIC LIGATURE ALAY" +
	"HIMAA AS-SALAAMARABIC LIGATURE ALAYHI AS-SALAATU WAS-SALAAMARABIC LIGATU" +
	"RE QUDDISA SIRRAHARABIC LIGATURE SALLALLAHU ALAYHI WAAALIHEE WA-SALLAMAR" +
	"ABIC LIGATURE ALAYHAA AS-SALAAMARABIC LIGATURE TABAARAKA WA-TAAALAAARABI" +
	"C LIGATURE RAHIMAHUM ALLAAHARABIC LIGATURE TEH WITH JEEM WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATURE " +
	"TEH WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH MEE" +
	"M INITIAL FORMARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARABIC" +
	" LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH M" +
	"EEM WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL" +
	" FORMARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE J" +
	"EEM WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH YE" +
	"H FINAL FORMARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORMAR" +
	"ABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEEN W" +
	"ITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALEF M" +
	"AKSURA FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMARABI" +
	"C LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH" +
	" MEEM WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM FIN" +
	"AL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGAT" +
	"URE SAD WITH HAH WITH HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH HA" +
	"H INITIAL FORMARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABIC L" +
	"IGATURE SHEEN WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HA" +
	"H WITH MEEM INITIAL FORMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL F" +
	"ORMARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATURE S" +
	"HEEN WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM WIT" +
	"H MEEM FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"DAD WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEE" +
	"M INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC LI" +
	"GATURE TAH WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE TAH WITH MEEM " +
	"WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WIT" +
	"H MEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WITH " +
	"MEEM WITH YEH FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSUR" +
	"A FINAL FORMARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC LIG" +
	"ATURE FEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH MEEM " +
	"WITH HAH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORMARA" +
	"BIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH H" +
	"AH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FIN" +
	"AL FORMARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIGATU" +
	"RE LAM WITH JEEM WITH JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH " +
	"MEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE LAM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH MEE" +
	"M WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL F" +
	"ORMARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE M" +
	"EEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH HAH " +
	"INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARABIC " +
	"LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH ") + ("" +
	"KHAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH INIT" +
	"IAL FORMARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGAT" +
	"URE HEH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINA" +
	"L FORMARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE" +
	" NOON WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM WIT" +
	"H ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL F" +
	"ORMARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIG" +
	"ATURE YEH WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORMARA" +
	"BIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH J" +
	"EEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YEH F" +
	"INAL FORMARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMARABI" +
	"C LIGATURE TEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH MEE" +
	"M WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH FI" +
	"NAL FORMARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEE" +
	"N WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH WIT" +
	"H YEH FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARABIC" +
	" LIGATURE DAD WITH HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM " +
	"WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMARAB" +
	"IC LIGATURE YEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH JEE" +
	"M WITH YEH FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORMAR" +
	"ABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF WITH" +
	" MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FO" +
	"RMARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE LAM" +
	" WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YEH F" +
	"INAL FORMARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATUR" +
	"E NOON WITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WIT" +
	"H YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH J" +
	"EEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FO" +
	"RMARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HAH W" +
	"ITH JEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH FINA" +
	"L FORMARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE B" +
	"EH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM I" +
	"NITIAL FORMARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC LI" +
	"GATURE SAD WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH KHA" +
	"H WITH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE SALAAMUHU ALAYNAAARABIC LIGATURE SALLA USED AS KORANIC ST" +
	"OP SIGN ISOLATED FORMARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOL" +
	"ATED FORMARABIC LIGATURE ALLAH ISOLATED FORMARABIC LIGATURE AKBAR ISOLAT" +
	"ED FORMARABIC LIGATURE MOHAMMAD ISOLATED FORMARABIC LIGATURE SALAM ISOLA" +
	"TED FORMARABIC LIGATURE RASOUL ISOLATED FORMARABIC LIGATURE ALAYHE ISOLA" +
	"TED FORMARABIC LIGATURE WASALLAM ISOLATED FORMARABIC LIGATURE SALLA ISOL" +
	"ATED FORMARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAMARABIC LIGATURE JALL" +
	"AJALALOUHOURIAL SIGNARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEMARABIC " +
	"LIGATURE SUBHAANAHU WA TAAALAAARABIC LIGATURE AZZA WA JALLVARIATION SELE" +
	"CTOR-1VARIATION SELECTOR-2VARIATION SELECTOR-3VARIATION SELECTOR-4VARIAT" +
	"ION SELECTOR-5VARIATION SELECTOR-6VARIATION SELECTOR-7VARIATION SELECTOR" +
	"-8VARIATION SELECTOR-9VARIATION SELECTOR-10VARIATION SELECTOR-11VARIATIO" +
	"N SELECTOR-12VARIATION SELECTOR-13VARIATION SELECTOR-14VARIATION SELECTO" +
	"R-15VARIATION SELECTOR-16PRESENTATION FORM FOR VERTICAL COMMAPRESENTATIO" +
	"N FORM FOR VERTICAL IDEOGRAPHIC COMMAPRESENTATION FORM FOR VERTICAL IDEO" +
	"GRAPHIC FULL STOPPRESENTATION FORM FOR VERTICAL COLONPRESENTATION FORM F" +
	"OR VERTICAL SEMICOLONPRESENTATION FORM FOR VERTICAL EXCLAMATION MARKPRES" +
	"ENTATION FORM FOR VERTICAL QUESTION MARKPRESENTATION FORM FOR VERTICAL L" +
	"EFT WHITE LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE L" +
	"ENTICULAR BRAKCETPRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSISCOMBI" +
	"NING LIGATURE LEFT HALFCOMBINING LIGATURE RIGHT HALFCOMBINING DOUBLE TIL" +
	"DE LEFT HALFCOMBINING DOUBLE TILDE RIGHT HALFCOMBINING MACRON LEFT HALFC" +
	"OMBINING MACRON RIGHT HALFCOMBINING CONJOINING MACRONCOMBINING LIGATURE " +
	"LEFT HALF BELOWCOMBINING LIGATURE RIGHT HALF BELOWCOMBINING TILDE LEFT H" +
	"ALF BELOWCOMBINING TILDE RIGHT HALF BELOWCOMBINING MACRON LEFT HALF BELO") + ("" +
	"WCOMBINING MACRON RIGHT HALF BELOWCOMBINING CONJOINING MACRON BELOWCOMBI" +
	"NING CYRILLIC TITLO LEFT HALFCOMBINING CYRILLIC TITLO RIGHT HALFPRESENTA" +
	"TION FORM FOR VERTICAL TWO DOT LEADERPRESENTATION FORM FOR VERTICAL EM D" +
	"ASHPRESENTATION FORM FOR VERTICAL EN DASHPRESENTATION FORM FOR VERTICAL " +
	"LOW LINEPRESENTATION FORM FOR VERTICAL WAVY LOW LINEPRESENTATION FORM FO" +
	"R VERTICAL LEFT PARENTHESISPRESENTATION FORM FOR VERTICAL RIGHT PARENTHE" +
	"SISPRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKETPRESENTATION FORM FO" +
	"R VERTICAL RIGHT CURLY BRACKETPRESENTATION FORM FOR VERTICAL LEFT TORTOI" +
	"SE SHELL BRACKETPRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRAC" +
	"KETPRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKETPRESENTAT" +
	"ION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKETPRESENTATION FORM FO" +
	"R VERTICAL LEFT DOUBLE ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT" +
	" DOUBLE ANGLE BRACKETPRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKETPR" +
	"ESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKETPRESENTATION FORM FOR VE" +
	"RTICAL LEFT CORNER BRACKETPRESENTATION FORM FOR VERTICAL RIGHT CORNER BR" +
	"ACKETPRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKETPRESENTATIO" +
	"N FORM FOR VERTICAL RIGHT WHITE CORNER BRACKETSESAME DOTWHITE SESAME DOT" +
	"PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKETPRESENTATION FORM FOR " +
	"VERTICAL RIGHT SQUARE BRACKETDASHED OVERLINECENTRELINE OVERLINEWAVY OVER" +
	"LINEDOUBLE WAVY OVERLINEDASHED LOW LINECENTRELINE LOW LINEWAVY LOW LINES" +
	"MALL COMMASMALL IDEOGRAPHIC COMMASMALL FULL STOPSMALL SEMICOLONSMALL COL" +
	"ONSMALL QUESTION MARKSMALL EXCLAMATION MARKSMALL EM DASHSMALL LEFT PAREN" +
	"THESISSMALL RIGHT PARENTHESISSMALL LEFT CURLY BRACKETSMALL RIGHT CURLY B" +
	"RACKETSMALL LEFT TORTOISE SHELL BRACKETSMALL RIGHT TORTOISE SHELL BRACKE" +
	"TSMALL NUMBER SIGNSMALL AMPERSANDSMALL ASTERISKSMALL PLUS SIGNSMALL HYPH" +
	"EN-MINUSSMALL LESS-THAN SIGNSMALL GREATER-THAN SIGNSMALL EQUALS SIGNSMAL" +
	"L REVERSE SOLIDUSSMALL DOLLAR SIGNSMALL PERCENT SIGNSMALL COMMERCIAL ATA" +
	"RABIC FATHATAN ISOLATED FORMARABIC TATWEEL WITH FATHATAN ABOVEARABIC DAM" +
	"MATAN ISOLATED FORMARABIC TAIL FRAGMENTARABIC KASRATAN ISOLATED FORMARAB" +
	"IC FATHA ISOLATED FORMARABIC FATHA MEDIAL FORMARABIC DAMMA ISOLATED FORM" +
	"ARABIC DAMMA MEDIAL FORMARABIC KASRA ISOLATED FORMARABIC KASRA MEDIAL FO" +
	"RMARABIC SHADDA ISOLATED FORMARABIC SHADDA MEDIAL FORMARABIC SUKUN ISOLA" +
	"TED FORMARABIC SUKUN MEDIAL FORMARABIC LETTER HAMZA ISOLATED FORMARABIC " +
	"LETTER ALEF WITH MADDA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH MADDA " +
	"ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC " +
	"LETTER ALEF WITH HAMZA ABOVE FINAL FORMARABIC LETTER WAW WITH HAMZA ABOV" +
	"E ISOLATED FORMARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORMARABIC LETTE" +
	"R ALEF WITH HAMZA BELOW ISOLATED FORMARABIC LETTER ALEF WITH HAMZA BELOW" +
	" FINAL FORMARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER" +
	" YEH WITH HAMZA ABOVE FINAL FORMARABIC LETTER YEH WITH HAMZA ABOVE INITI" +
	"AL FORMARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORMARABIC LETTER ALEF " +
	"ISOLATED FORMARABIC LETTER ALEF FINAL FORMARABIC LETTER BEH ISOLATED FOR" +
	"MARABIC LETTER BEH FINAL FORMARABIC LETTER BEH INITIAL FORMARABIC LETTER" +
	" BEH MEDIAL FORMARABIC LETTER TEH MARBUTA ISOLATED FORMARABIC LETTER TEH" +
	" MARBUTA FINAL FORMARABIC LETTER TEH ISOLATED FORMARABIC LETTER TEH FINA" +
	"L FORMARABIC LETTER TEH INITIAL FORMARABIC LETTER TEH MEDIAL FORMARABIC " +
	"LETTER THEH ISOLATED FORMARABIC LETTER THEH FINAL FORMARABIC LETTER THEH" +
	" INITIAL FORMARABIC LETTER THEH MEDIAL FORMARABIC LETTER JEEM ISOLATED F" +
	"ORMARABIC LETTER JEEM FINAL FORMARABIC LETTER JEEM INITIAL FORMARABIC LE" +
	"TTER JEEM MEDIAL FORMARABIC LETTER HAH ISOLATED FORMARABIC LETTER HAH FI" +
	"NAL FORMARABIC LETTER HAH INITIAL FORMARABIC LETTER HAH MEDIAL FORMARABI" +
	"C LETTER KHAH ISOLATED FORMARABIC LETTER KHAH FINAL FORMARABIC LETTER KH" +
	"AH INITIAL FORMARABIC LETTER KHAH MEDIAL FORMARABIC LETTER DAL ISOLATED " +
	"FORMARABIC LETTER DAL FINAL FORMARABIC LETTER THAL ISOLATED FORMARABIC L" +
	"ETTER THAL FINAL FORMARABIC LETTER REH ISOLATED FORMARABIC LETTER REH FI" +
	"NAL FORMARABIC LETTER ZAIN ISOLATED FORMARABIC LETTER ZAIN FINAL FORMARA" +
	"BIC LETTER SEEN ISOLATED FORMARABIC LETTER SEEN FINAL FORMARABIC LETTER " +
	"SEEN INITIAL FORMARABIC LETTER SEEN MEDIAL FORMARABIC LETTER SHEEN ISOLA" +
	"TED FORMARABIC LETTER SHEEN FINAL FORMARABIC LETTER SHEEN INITIAL FORMAR" +
	"ABIC LETTER SHEEN MEDIAL FORMARABIC LETTER SAD ISOLATED FORMARABIC LETTE" +
	"R SAD FINAL FORMARABIC LETTER SAD INITIAL FORMARABIC LETTER SAD MEDIAL F" +
	"ORMARABIC LETTER DAD ISOLATED FORMARABIC LETTER DAD FINAL FORMARABIC LET" +
	"TER DAD INITIAL FORMARABIC LETTER DAD MEDIAL FORMARABIC LETTER TAH ISOLA" +
	"TED FORMARABIC LETTER TAH FINAL FORMARABIC LETTER TAH INITIAL FORMARABIC") + ("" +
	" LETTER TAH MEDIAL FORMARABIC LETTER ZAH ISOLATED FORMARABIC LETTER ZAH " +
	"FINAL FORMARABIC LETTER ZAH INITIAL FORMARABIC LETTER ZAH MEDIAL FORMARA" +
	"BIC LETTER AIN ISOLATED FORMARABIC LETTER AIN FINAL FORMARABIC LETTER AI" +
	"N INITIAL FORMARABIC LETTER AIN MEDIAL FORMARABIC LETTER GHAIN ISOLATED " +
	"FORMARABIC LETTER GHAIN FINAL FORMARABIC LETTER GHAIN INITIAL FORMARABIC" +
	" LETTER GHAIN MEDIAL FORMARABIC LETTER FEH ISOLATED FORMARABIC LETTER FE" +
	"H FINAL FORMARABIC LETTER FEH INITIAL FORMARABIC LETTER FEH MEDIAL FORMA" +
	"RABIC LETTER QAF ISOLATED FORMARABIC LETTER QAF FINAL FORMARABIC LETTER " +
	"QAF INITIAL FORMARABIC LETTER QAF MEDIAL FORMARABIC LETTER KAF ISOLATED " +
	"FORMARABIC LETTER KAF FINAL FORMARABIC LETTER KAF INITIAL FORMARABIC LET" +
	"TER KAF MEDIAL FORMARABIC LETTER LAM ISOLATED FORMARABIC LETTER LAM FINA" +
	"L FORMARABIC LETTER LAM INITIAL FORMARABIC LETTER LAM MEDIAL FORMARABIC " +
	"LETTER MEEM ISOLATED FORMARABIC LETTER MEEM FINAL FORMARABIC LETTER MEEM" +
	" INITIAL FORMARABIC LETTER MEEM MEDIAL FORMARABIC LETTER NOON ISOLATED F" +
	"ORMARABIC LETTER NOON FINAL FORMARABIC LETTER NOON INITIAL FORMARABIC LE" +
	"TTER NOON MEDIAL FORMARABIC LETTER HEH ISOLATED FORMARABIC LETTER HEH FI" +
	"NAL FORMARABIC LETTER HEH INITIAL FORMARABIC LETTER HEH MEDIAL FORMARABI" +
	"C LETTER WAW ISOLATED FORMARABIC LETTER WAW FINAL FORMARABIC LETTER ALEF" +
	" MAKSURA ISOLATED FORMARABIC LETTER ALEF MAKSURA FINAL FORMARABIC LETTER" +
	" YEH ISOLATED FORMARABIC LETTER YEH FINAL FORMARABIC LETTER YEH INITIAL " +
	"FORMARABIC LETTER YEH MEDIAL FORMARABIC LIGATURE LAM WITH ALEF WITH MADD" +
	"A ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINA" +
	"L FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC" +
	" LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORMARABIC LIGATURE LAM W" +
	"ITH ALEF WITH HAMZA BELOW ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WIT" +
	"H HAMZA BELOW FINAL FORMARABIC LIGATURE LAM WITH ALEF ISOLATED FORMARABI" +
	"C LIGATURE LAM WITH ALEF FINAL FORMZERO WIDTH NO-BREAK SPACEFULLWIDTH EX" +
	"CLAMATION MARKFULLWIDTH QUOTATION MARKFULLWIDTH NUMBER SIGNFULLWIDTH DOL" +
	"LAR SIGNFULLWIDTH PERCENT SIGNFULLWIDTH AMPERSANDFULLWIDTH APOSTROPHEFUL" +
	"LWIDTH LEFT PARENTHESISFULLWIDTH RIGHT PARENTHESISFULLWIDTH ASTERISKFULL" +
	"WIDTH PLUS SIGNFULLWIDTH COMMAFULLWIDTH HYPHEN-MINUSFULLWIDTH FULL STOPF" +
	"ULLWIDTH SOLIDUSFULLWIDTH DIGIT ZEROFULLWIDTH DIGIT ONEFULLWIDTH DIGIT T" +
	"WOFULLWIDTH DIGIT THREEFULLWIDTH DIGIT FOURFULLWIDTH DIGIT FIVEFULLWIDTH" +
	" DIGIT SIXFULLWIDTH DIGIT SEVENFULLWIDTH DIGIT EIGHTFULLWIDTH DIGIT NINE" +
	"FULLWIDTH COLONFULLWIDTH SEMICOLONFULLWIDTH LESS-THAN SIGNFULLWIDTH EQUA" +
	"LS SIGNFULLWIDTH GREATER-THAN SIGNFULLWIDTH QUESTION MARKFULLWIDTH COMME" +
	"RCIAL ATFULLWIDTH LATIN CAPITAL LETTER AFULLWIDTH LATIN CAPITAL LETTER B" +
	"FULLWIDTH LATIN CAPITAL LETTER CFULLWIDTH LATIN CAPITAL LETTER DFULLWIDT" +
	"H LATIN CAPITAL LETTER EFULLWIDTH LATIN CAPITAL LETTER FFULLWIDTH LATIN " +
	"CAPITAL LETTER GFULLWIDTH LATIN CAPITAL LETTER HFULLWIDTH LATIN CAPITAL " +
	"LETTER IFULLWIDTH LATIN CAPITAL LETTER JFULLWIDTH LATIN CAPITAL LETTER K" +
	"FULLWIDTH LATIN CAPITAL LETTER LFULLWIDTH LATIN CAPITAL LETTER MFULLWIDT" +
	"H LATIN CAPITAL LETTER NFULLWIDTH LATIN CAPITAL LETTER OFULLWIDTH LATIN " +
	"CAPITAL LETTER PFULLWIDTH LATIN CAPITAL LETTER QFULLWIDTH LATIN CAPITAL " +
	"LETTER RFULLWIDTH LATIN CAPITAL LETTER SFULLWIDTH LATIN CAPITAL LETTER T" +
	"FULLWIDTH LATIN CAPITAL LETTER UFULLWIDTH LATIN CAPITAL LETTER VFULLWIDT" +
	"H LATIN CAPITAL LETTER WFULLWIDTH LATIN CAPITAL LETTER XFULLWIDTH LATIN " +
	"CAPITAL LETTER YFULLWIDTH LATIN CAPITAL LETTER ZFULLWIDTH LEFT SQUARE BR" +
	"ACKETFULLWIDTH REVERSE SOLIDUSFULLWIDTH RIGHT SQUARE BRACKETFULLWIDTH CI" +
	"RCUMFLEX ACCENTFULLWIDTH LOW LINEFULLWIDTH GRAVE ACCENTFULLWIDTH LATIN S" +
	"MALL LETTER AFULLWIDTH LATIN SMALL LETTER BFULLWIDTH LATIN SMALL LETTER " +
	"CFULLWIDTH LATIN SMALL LETTER DFULLWIDTH LATIN SMALL LETTER EFULLWIDTH L" +
	"ATIN SMALL LETTER FFULLWIDTH LATIN SMALL LETTER GFULLWIDTH LATIN SMALL L" +
	"ETTER HFULLWIDTH LATIN SMALL LETTER IFULLWIDTH LATIN SMALL LETTER JFULLW" +
	"IDTH LATIN SMALL LETTER KFULLWIDTH LATIN SMALL LETTER LFULLWIDTH LATIN S" +
	"MALL LETTER MFULLWIDTH LATIN SMALL LETTER NFULLWIDTH LATIN SMALL LETTER " +
	"OFULLWIDTH LATIN SMALL LETTER PFULLWIDTH LATIN SMALL LETTER QFULLWIDTH L" +
	"ATIN SMALL LETTER RFULLWIDTH LATIN SMALL LETTER SFULLWIDTH LATIN SMALL L" +
	"ETTER TFULLWIDTH LATIN SMALL LETTER UFULLWIDTH LATIN SMALL LETTER VFULLW" +
	"IDTH LATIN SMALL LETTER WFULLWIDTH LATIN SMALL LETTER XFULLWIDTH LATIN S" +
	"MALL LETTER YFULLWIDTH LATIN SMALL LETTER ZFULLWIDTH LEFT CURLY BRACKETF" +
	"ULLWIDTH VERTICAL LINEFULLWIDTH RIGHT CURLY BRACKETFULLWIDTH TILDEFULLWI" +
	"DTH LEFT WHITE PARENTHESISFULLWIDTH RIGHT WHITE PARENTHESISHALFWIDTH IDE" +
	"OGRAPHIC FULL STOPHALFWIDTH LEFT CORNER BRACKETHALFWIDTH RIGHT CORNER BR") + ("" +
	"ACKETHALFWIDTH IDEOGRAPHIC COMMAHALFWIDTH KATAKANA MIDDLE DOTHALFWIDTH K" +
	"ATAKANA LETTER WOHALFWIDTH KATAKANA LETTER SMALL AHALFWIDTH KATAKANA LET" +
	"TER SMALL IHALFWIDTH KATAKANA LETTER SMALL UHALFWIDTH KATAKANA LETTER SM" +
	"ALL EHALFWIDTH KATAKANA LETTER SMALL OHALFWIDTH KATAKANA LETTER SMALL YA" +
	"HALFWIDTH KATAKANA LETTER SMALL YUHALFWIDTH KATAKANA LETTER SMALL YOHALF" +
	"WIDTH KATAKANA LETTER SMALL TUHALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUN" +
	"D MARKHALFWIDTH KATAKANA LETTER AHALFWIDTH KATAKANA LETTER IHALFWIDTH KA" +
	"TAKANA LETTER UHALFWIDTH KATAKANA LETTER EHALFWIDTH KATAKANA LETTER OHAL" +
	"FWIDTH KATAKANA LETTER KAHALFWIDTH KATAKANA LETTER KIHALFWIDTH KATAKANA " +
	"LETTER KUHALFWIDTH KATAKANA LETTER KEHALFWIDTH KATAKANA LETTER KOHALFWID" +
	"TH KATAKANA LETTER SAHALFWIDTH KATAKANA LETTER SIHALFWIDTH KATAKANA LETT" +
	"ER SUHALFWIDTH KATAKANA LETTER SEHALFWIDTH KATAKANA LETTER SOHALFWIDTH K" +
	"ATAKANA LETTER TAHALFWIDTH KATAKANA LETTER TIHALFWIDTH KATAKANA LETTER T" +
	"UHALFWIDTH KATAKANA LETTER TEHALFWIDTH KATAKANA LETTER TOHALFWIDTH KATAK" +
	"ANA LETTER NAHALFWIDTH KATAKANA LETTER NIHALFWIDTH KATAKANA LETTER NUHAL" +
	"FWIDTH KATAKANA LETTER NEHALFWIDTH KATAKANA LETTER NOHALFWIDTH KATAKANA " +
	"LETTER HAHALFWIDTH KATAKANA LETTER HIHALFWIDTH KATAKANA LETTER HUHALFWID" +
	"TH KATAKANA LETTER HEHALFWIDTH KATAKANA LETTER HOHALFWIDTH KATAKANA LETT" +
	"ER MAHALFWIDTH KATAKANA LETTER MIHALFWIDTH KATAKANA LETTER MUHALFWIDTH K" +
	"ATAKANA LETTER MEHALFWIDTH KATAKANA LETTER MOHALFWIDTH KATAKANA LETTER Y" +
	"AHALFWIDTH KATAKANA LETTER YUHALFWIDTH KATAKANA LETTER YOHALFWIDTH KATAK" +
	"ANA LETTER RAHALFWIDTH KATAKANA LETTER RIHALFWIDTH KATAKANA LETTER RUHAL" +
	"FWIDTH KATAKANA LETTER REHALFWIDTH KATAKANA LETTER ROHALFWIDTH KATAKANA " +
	"LETTER WAHALFWIDTH KATAKANA LETTER NHALFWIDTH KATAKANA VOICED SOUND MARK" +
	"HALFWIDTH KATAKANA SEMI-VOICED SOUND MARKHALFWIDTH HANGUL FILLERHALFWIDT" +
	"H HANGUL LETTER KIYEOKHALFWIDTH HANGUL LETTER SSANGKIYEOKHALFWIDTH HANGU" +
	"L LETTER KIYEOK-SIOSHALFWIDTH HANGUL LETTER NIEUNHALFWIDTH HANGUL LETTER" +
	" NIEUN-CIEUCHALFWIDTH HANGUL LETTER NIEUN-HIEUHHALFWIDTH HANGUL LETTER T" +
	"IKEUTHALFWIDTH HANGUL LETTER SSANGTIKEUTHALFWIDTH HANGUL LETTER RIEULHAL" +
	"FWIDTH HANGUL LETTER RIEUL-KIYEOKHALFWIDTH HANGUL LETTER RIEUL-MIEUMHALF" +
	"WIDTH HANGUL LETTER RIEUL-PIEUPHALFWIDTH HANGUL LETTER RIEUL-SIOSHALFWID" +
	"TH HANGUL LETTER RIEUL-THIEUTHHALFWIDTH HANGUL LETTER RIEUL-PHIEUPHHALFW" +
	"IDTH HANGUL LETTER RIEUL-HIEUHHALFWIDTH HANGUL LETTER MIEUMHALFWIDTH HAN" +
	"GUL LETTER PIEUPHALFWIDTH HANGUL LETTER SSANGPIEUPHALFWIDTH HANGUL LETTE" +
	"R PIEUP-SIOSHALFWIDTH HANGUL LETTER SIOSHALFWIDTH HANGUL LETTER SSANGSIO" +
	"SHALFWIDTH HANGUL LETTER IEUNGHALFWIDTH HANGUL LETTER CIEUCHALFWIDTH HAN" +
	"GUL LETTER SSANGCIEUCHALFWIDTH HANGUL LETTER CHIEUCHHALFWIDTH HANGUL LET" +
	"TER KHIEUKHHALFWIDTH HANGUL LETTER THIEUTHHALFWIDTH HANGUL LETTER PHIEUP" +
	"HHALFWIDTH HANGUL LETTER HIEUHHALFWIDTH HANGUL LETTER AHALFWIDTH HANGUL " +
	"LETTER AEHALFWIDTH HANGUL LETTER YAHALFWIDTH HANGUL LETTER YAEHALFWIDTH " +
	"HANGUL LETTER EOHALFWIDTH HANGUL LETTER EHALFWIDTH HANGUL LETTER YEOHALF" +
	"WIDTH HANGUL LETTER YEHALFWIDTH HANGUL LETTER OHALFWIDTH HANGUL LETTER W" +
	"AHALFWIDTH HANGUL LETTER WAEHALFWIDTH HANGUL LETTER OEHALFWIDTH HANGUL L" +
	"ETTER YOHALFWIDTH HANGUL LETTER UHALFWIDTH HANGUL LETTER WEOHALFWIDTH HA" +
	"NGUL LETTER WEHALFWIDTH HANGUL LETTER WIHALFWIDTH HANGUL LETTER YUHALFWI" +
	"DTH HANGUL LETTER EUHALFWIDTH HANGUL LETTER YIHALFWIDTH HANGUL LETTER IF" +
	"ULLWIDTH CENT SIGNFULLWIDTH POUND SIGNFULLWIDTH NOT SIGNFULLWIDTH MACRON" +
	"FULLWIDTH BROKEN BARFULLWIDTH YEN SIGNFULLWIDTH WON SIGNHALFWIDTH FORMS " +
	"LIGHT VERTICALHALFWIDTH LEFTWARDS ARROWHALFWIDTH UPWARDS ARROWHALFWIDTH " +
	"RIGHTWARDS ARROWHALFWIDTH DOWNWARDS ARROWHALFWIDTH BLACK SQUAREHALFWIDTH" +
	" WHITE CIRCLEINTERLINEAR ANNOTATION ANCHORINTERLINEAR ANNOTATION SEPARAT" +
	"ORINTERLINEAR ANNOTATION TERMINATOROBJECT REPLACEMENT CHARACTERREPLACEME" +
	"NT CHARACTERLINEAR B SYLLABLE B008 ALINEAR B SYLLABLE B038 ELINEAR B SYL" +
	"LABLE B028 ILINEAR B SYLLABLE B061 OLINEAR B SYLLABLE B010 ULINEAR B SYL" +
	"LABLE B001 DALINEAR B SYLLABLE B045 DELINEAR B SYLLABLE B007 DILINEAR B " +
	"SYLLABLE B014 DOLINEAR B SYLLABLE B051 DULINEAR B SYLLABLE B057 JALINEAR" +
	" B SYLLABLE B046 JELINEAR B SYLLABLE B036 JOLINEAR B SYLLABLE B065 JULIN" +
	"EAR B SYLLABLE B077 KALINEAR B SYLLABLE B044 KELINEAR B SYLLABLE B067 KI" +
	"LINEAR B SYLLABLE B070 KOLINEAR B SYLLABLE B081 KULINEAR B SYLLABLE B080" +
	" MALINEAR B SYLLABLE B013 MELINEAR B SYLLABLE B073 MILINEAR B SYLLABLE B" +
	"015 MOLINEAR B SYLLABLE B023 MULINEAR B SYLLABLE B006 NALINEAR B SYLLABL" +
	"E B024 NELINEAR B SYLLABLE B030 NILINEAR B SYLLABLE B052 NOLINEAR B SYLL" +
	"ABLE B055 NULINEAR B SYLLABLE B003 PALINEAR B SYLLABLE B072 PELINEAR B S" +
	"YLLABLE B039 PILINEAR B SYLLABLE B011 POLINEAR B SYLLABLE B050 PULINEAR ") + ("" +
	"B SYLLABLE B016 QALINEAR B SYLLABLE B078 QELINEAR B SYLLABLE B021 QILINE" +
	"AR B SYLLABLE B032 QOLINEAR B SYLLABLE B060 RALINEAR B SYLLABLE B027 REL" +
	"INEAR B SYLLABLE B053 RILINEAR B SYLLABLE B002 ROLINEAR B SYLLABLE B026 " +
	"RULINEAR B SYLLABLE B031 SALINEAR B SYLLABLE B009 SELINEAR B SYLLABLE B0" +
	"41 SILINEAR B SYLLABLE B012 SOLINEAR B SYLLABLE B058 SULINEAR B SYLLABLE" +
	" B059 TALINEAR B SYLLABLE B004 TELINEAR B SYLLABLE B037 TILINEAR B SYLLA" +
	"BLE B005 TOLINEAR B SYLLABLE B069 TULINEAR B SYLLABLE B054 WALINEAR B SY" +
	"LLABLE B075 WELINEAR B SYLLABLE B040 WILINEAR B SYLLABLE B042 WOLINEAR B" +
	" SYLLABLE B017 ZALINEAR B SYLLABLE B074 ZELINEAR B SYLLABLE B020 ZOLINEA" +
	"R B SYLLABLE B025 A2LINEAR B SYLLABLE B043 A3LINEAR B SYLLABLE B085 AULI" +
	"NEAR B SYLLABLE B071 DWELINEAR B SYLLABLE B090 DWOLINEAR B SYLLABLE B048" +
	" NWALINEAR B SYLLABLE B029 PU2LINEAR B SYLLABLE B062 PTELINEAR B SYLLABL" +
	"E B076 RA2LINEAR B SYLLABLE B033 RA3LINEAR B SYLLABLE B068 RO2LINEAR B S" +
	"YLLABLE B066 TA2LINEAR B SYLLABLE B087 TWELINEAR B SYLLABLE B091 TWOLINE" +
	"AR B SYMBOL B018LINEAR B SYMBOL B019LINEAR B SYMBOL B022LINEAR B SYMBOL " +
	"B034LINEAR B SYMBOL B047LINEAR B SYMBOL B049LINEAR B SYMBOL B056LINEAR B" +
	" SYMBOL B063LINEAR B SYMBOL B064LINEAR B SYMBOL B079LINEAR B SYMBOL B082" +
	"LINEAR B SYMBOL B083LINEAR B SYMBOL B086LINEAR B SYMBOL B089LINEAR B IDE" +
	"OGRAM B100 MANLINEAR B IDEOGRAM B102 WOMANLINEAR B IDEOGRAM B104 DEERLIN" +
	"EAR B IDEOGRAM B105 EQUIDLINEAR B IDEOGRAM B105F MARELINEAR B IDEOGRAM B" +
	"105M STALLIONLINEAR B IDEOGRAM B106F EWELINEAR B IDEOGRAM B106M RAMLINEA" +
	"R B IDEOGRAM B107F SHE-GOATLINEAR B IDEOGRAM B107M HE-GOATLINEAR B IDEOG" +
	"RAM B108F SOWLINEAR B IDEOGRAM B108M BOARLINEAR B IDEOGRAM B109F COWLINE" +
	"AR B IDEOGRAM B109M BULLLINEAR B IDEOGRAM B120 WHEATLINEAR B IDEOGRAM B1" +
	"21 BARLEYLINEAR B IDEOGRAM B122 OLIVELINEAR B IDEOGRAM B123 SPICELINEAR " +
	"B IDEOGRAM B125 CYPERUSLINEAR B MONOGRAM B127 KAPOLINEAR B MONOGRAM B128" +
	" KANAKOLINEAR B IDEOGRAM B130 OILLINEAR B IDEOGRAM B131 WINELINEAR B IDE" +
	"OGRAM B132LINEAR B MONOGRAM B133 AREPALINEAR B MONOGRAM B135 MERILINEAR " +
	"B IDEOGRAM B140 BRONZELINEAR B IDEOGRAM B141 GOLDLINEAR B IDEOGRAM B142L" +
	"INEAR B IDEOGRAM B145 WOOLLINEAR B IDEOGRAM B146LINEAR B IDEOGRAM B150LI" +
	"NEAR B IDEOGRAM B151 HORNLINEAR B IDEOGRAM B152LINEAR B IDEOGRAM B153LIN" +
	"EAR B IDEOGRAM B154LINEAR B MONOGRAM B156 TURO2LINEAR B IDEOGRAM B157LIN" +
	"EAR B IDEOGRAM B158LINEAR B IDEOGRAM B159 CLOTHLINEAR B IDEOGRAM B160LIN" +
	"EAR B IDEOGRAM B161LINEAR B IDEOGRAM B162 GARMENTLINEAR B IDEOGRAM B163 " +
	"ARMOURLINEAR B IDEOGRAM B164LINEAR B IDEOGRAM B165LINEAR B IDEOGRAM B166" +
	"LINEAR B IDEOGRAM B167LINEAR B IDEOGRAM B168LINEAR B IDEOGRAM B169LINEAR" +
	" B IDEOGRAM B170LINEAR B IDEOGRAM B171LINEAR B IDEOGRAM B172LINEAR B IDE" +
	"OGRAM B173 MONTHLINEAR B IDEOGRAM B174LINEAR B IDEOGRAM B176 TREELINEAR " +
	"B IDEOGRAM B177LINEAR B IDEOGRAM B178LINEAR B IDEOGRAM B179LINEAR B IDEO" +
	"GRAM B180LINEAR B IDEOGRAM B181LINEAR B IDEOGRAM B182LINEAR B IDEOGRAM B" +
	"183LINEAR B IDEOGRAM B184LINEAR B IDEOGRAM B185LINEAR B IDEOGRAM B189LIN" +
	"EAR B IDEOGRAM B190LINEAR B IDEOGRAM B191 HELMETLINEAR B IDEOGRAM B220 F" +
	"OOTSTOOLLINEAR B IDEOGRAM B225 BATHTUBLINEAR B IDEOGRAM B230 SPEARLINEAR" +
	" B IDEOGRAM B231 ARROWLINEAR B IDEOGRAM B232LINEAR B IDEOGRAM B233 SWORD" +
	"LINEAR B IDEOGRAM B234LINEAR B IDEOGRAM B236LINEAR B IDEOGRAM B240 WHEEL" +
	"ED CHARIOTLINEAR B IDEOGRAM B241 CHARIOTLINEAR B IDEOGRAM B242 CHARIOT F" +
	"RAMELINEAR B IDEOGRAM B243 WHEELLINEAR B IDEOGRAM B245LINEAR B IDEOGRAM " +
	"B246LINEAR B MONOGRAM B247 DIPTELINEAR B IDEOGRAM B248LINEAR B IDEOGRAM " +
	"B249LINEAR B IDEOGRAM B251LINEAR B IDEOGRAM B252LINEAR B IDEOGRAM B253LI" +
	"NEAR B IDEOGRAM B254 DARTLINEAR B IDEOGRAM B255LINEAR B IDEOGRAM B256LIN" +
	"EAR B IDEOGRAM B257LINEAR B IDEOGRAM B258LINEAR B IDEOGRAM B259LINEAR B " +
	"IDEOGRAM VESSEL B155LINEAR B IDEOGRAM VESSEL B200LINEAR B IDEOGRAM VESSE" +
	"L B201LINEAR B IDEOGRAM VESSEL B202LINEAR B IDEOGRAM VESSEL B203LINEAR B" +
	" IDEOGRAM VESSEL B204LINEAR B IDEOGRAM VESSEL B205LINEAR B IDEOGRAM VESS" +
	"EL B206LINEAR B IDEOGRAM VESSEL B207LINEAR B IDEOGRAM VESSEL B208LINEAR " +
	"B IDEOGRAM VESSEL B209LINEAR B IDEOGRAM VESSEL B210LINEAR B IDEOGRAM VES" +
	"SEL B211LINEAR B IDEOGRAM VESSEL B212LINEAR B IDEOGRAM VESSEL B213LINEAR" +
	" B IDEOGRAM VESSEL B214LINEAR B IDEOGRAM VESSEL B215LINEAR B IDEOGRAM VE" +
	"SSEL B216LINEAR B IDEOGRAM VESSEL B217LINEAR B IDEOGRAM VESSEL B218LINEA" +
	"R B IDEOGRAM VESSEL B219LINEAR B IDEOGRAM VESSEL B221LINEAR B IDEOGRAM V" +
	"ESSEL B222LINEAR B IDEOGRAM VESSEL B226LINEAR B IDEOGRAM VESSEL B227LINE" +
	"AR B IDEOGRAM VESSEL B228LINEAR B IDEOGRAM VESSEL B229LINEAR B IDEOGRAM " +
	"VESSEL B250LINEAR B IDEOGRAM VESSEL B305AEGEAN WORD SEPARATOR LINEAEGEAN" +
	" WORD SEPARATOR DOTAEGEAN CHECK MARKAEGEAN NUMBER ONEAEGEAN NUMBER TWOAE") + ("" +
	"GEAN NUMBER THREEAEGEAN NUMBER FOURAEGEAN NUMBER FIVEAEGEAN NUMBER SIXAE" +
	"GEAN NUMBER SEVENAEGEAN NUMBER EIGHTAEGEAN NUMBER NINEAEGEAN NUMBER TENA" +
	"EGEAN NUMBER TWENTYAEGEAN NUMBER THIRTYAEGEAN NUMBER FORTYAEGEAN NUMBER " +
	"FIFTYAEGEAN NUMBER SIXTYAEGEAN NUMBER SEVENTYAEGEAN NUMBER EIGHTYAEGEAN " +
	"NUMBER NINETYAEGEAN NUMBER ONE HUNDREDAEGEAN NUMBER TWO HUNDREDAEGEAN NU" +
	"MBER THREE HUNDREDAEGEAN NUMBER FOUR HUNDREDAEGEAN NUMBER FIVE HUNDREDAE" +
	"GEAN NUMBER SIX HUNDREDAEGEAN NUMBER SEVEN HUNDREDAEGEAN NUMBER EIGHT HU" +
	"NDREDAEGEAN NUMBER NINE HUNDREDAEGEAN NUMBER ONE THOUSANDAEGEAN NUMBER T" +
	"WO THOUSANDAEGEAN NUMBER THREE THOUSANDAEGEAN NUMBER FOUR THOUSANDAEGEAN" +
	" NUMBER FIVE THOUSANDAEGEAN NUMBER SIX THOUSANDAEGEAN NUMBER SEVEN THOUS" +
	"ANDAEGEAN NUMBER EIGHT THOUSANDAEGEAN NUMBER NINE THOUSANDAEGEAN NUMBER " +
	"TEN THOUSANDAEGEAN NUMBER TWENTY THOUSANDAEGEAN NUMBER THIRTY THOUSANDAE" +
	"GEAN NUMBER FORTY THOUSANDAEGEAN NUMBER FIFTY THOUSANDAEGEAN NUMBER SIXT" +
	"Y THOUSANDAEGEAN NUMBER SEVENTY THOUSANDAEGEAN NUMBER EIGHTY THOUSANDAEG" +
	"EAN NUMBER NINETY THOUSANDAEGEAN WEIGHT BASE UNITAEGEAN WEIGHT FIRST SUB" +
	"UNITAEGEAN WEIGHT SECOND SUBUNITAEGEAN WEIGHT THIRD SUBUNITAEGEAN WEIGHT" +
	" FOURTH SUBUNITAEGEAN DRY MEASURE FIRST SUBUNITAEGEAN LIQUID MEASURE FIR" +
	"ST SUBUNITAEGEAN MEASURE SECOND SUBUNITAEGEAN MEASURE THIRD SUBUNITGREEK" +
	" ACROPHONIC ATTIC ONE QUARTERGREEK ACROPHONIC ATTIC ONE HALFGREEK ACROPH" +
	"ONIC ATTIC ONE DRACHMAGREEK ACROPHONIC ATTIC FIVEGREEK ACROPHONIC ATTIC " +
	"FIFTYGREEK ACROPHONIC ATTIC FIVE HUNDREDGREEK ACROPHONIC ATTIC FIVE THOU" +
	"SANDGREEK ACROPHONIC ATTIC FIFTY THOUSANDGREEK ACROPHONIC ATTIC FIVE TAL" +
	"ENTSGREEK ACROPHONIC ATTIC TEN TALENTSGREEK ACROPHONIC ATTIC FIFTY TALEN" +
	"TSGREEK ACROPHONIC ATTIC ONE HUNDRED TALENTSGREEK ACROPHONIC ATTIC FIVE " +
	"HUNDRED TALENTSGREEK ACROPHONIC ATTIC ONE THOUSAND TALENTSGREEK ACROPHON" +
	"IC ATTIC FIVE THOUSAND TALENTSGREEK ACROPHONIC ATTIC FIVE STATERSGREEK A" +
	"CROPHONIC ATTIC TEN STATERSGREEK ACROPHONIC ATTIC FIFTY STATERSGREEK ACR" +
	"OPHONIC ATTIC ONE HUNDRED STATERSGREEK ACROPHONIC ATTIC FIVE HUNDRED STA" +
	"TERSGREEK ACROPHONIC ATTIC ONE THOUSAND STATERSGREEK ACROPHONIC ATTIC TE" +
	"N THOUSAND STATERSGREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERSGREEK ACR" +
	"OPHONIC ATTIC TEN MNASGREEK ACROPHONIC HERAEUM ONE PLETHRONGREEK ACROPHO" +
	"NIC THESPIAN ONEGREEK ACROPHONIC HERMIONIAN ONEGREEK ACROPHONIC EPIDAURE" +
	"AN TWOGREEK ACROPHONIC THESPIAN TWOGREEK ACROPHONIC CYRENAIC TWO DRACHMA" +
	"SGREEK ACROPHONIC EPIDAUREAN TWO DRACHMASGREEK ACROPHONIC TROEZENIAN FIV" +
	"EGREEK ACROPHONIC TROEZENIAN TENGREEK ACROPHONIC TROEZENIAN TEN ALTERNAT" +
	"E FORMGREEK ACROPHONIC HERMIONIAN TENGREEK ACROPHONIC MESSENIAN TENGREEK" +
	" ACROPHONIC THESPIAN TENGREEK ACROPHONIC THESPIAN THIRTYGREEK ACROPHONIC" +
	" TROEZENIAN FIFTYGREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORMGREEK A" +
	"CROPHONIC HERMIONIAN FIFTYGREEK ACROPHONIC THESPIAN FIFTYGREEK ACROPHONI" +
	"C THESPIAN ONE HUNDREDGREEK ACROPHONIC THESPIAN THREE HUNDREDGREEK ACROP" +
	"HONIC EPIDAUREAN FIVE HUNDREDGREEK ACROPHONIC TROEZENIAN FIVE HUNDREDGRE" +
	"EK ACROPHONIC THESPIAN FIVE HUNDREDGREEK ACROPHONIC CARYSTIAN FIVE HUNDR" +
	"EDGREEK ACROPHONIC NAXIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN ONE THOU" +
	"SANDGREEK ACROPHONIC THESPIAN FIVE THOUSANDGREEK ACROPHONIC DELPHIC FIVE" +
	" MNASGREEK ACROPHONIC STRATIAN FIFTY MNASGREEK ONE HALF SIGNGREEK ONE HA" +
	"LF SIGN ALTERNATE FORMGREEK TWO THIRDS SIGNGREEK THREE QUARTERS SIGNGREE" +
	"K YEAR SIGNGREEK TALENT SIGNGREEK DRACHMA SIGNGREEK OBOL SIGNGREEK TWO O" +
	"BOLS SIGNGREEK THREE OBOLS SIGNGREEK FOUR OBOLS SIGNGREEK FIVE OBOLS SIG" +
	"NGREEK METRETES SIGNGREEK KYATHOS BASE SIGNGREEK LITRA SIGNGREEK OUNKIA " +
	"SIGNGREEK XESTES SIGNGREEK ARTABE SIGNGREEK AROURA SIGNGREEK GRAMMA SIGN" +
	"GREEK TRYBLION BASE SIGNGREEK ZERO SIGNGREEK ONE QUARTER SIGNGREEK SINUS" +
	"OID SIGNGREEK INDICTION SIGNNOMISMA SIGNROMAN SEXTANS SIGNROMAN UNCIA SI" +
	"GNROMAN SEMUNCIA SIGNROMAN SEXTULA SIGNROMAN DIMIDIA SEXTULA SIGNROMAN S" +
	"ILIQUA SIGNROMAN DENARIUS SIGNROMAN QUINARIUS SIGNROMAN SESTERTIUS SIGNR" +
	"OMAN DUPONDIUS SIGNROMAN AS SIGNROMAN CENTURIAL SIGNASCIA SYMBOLGREEK SY" +
	"MBOL TAU RHOPHAISTOS DISC SIGN PEDESTRIANPHAISTOS DISC SIGN PLUMED HEADP" +
	"HAISTOS DISC SIGN TATTOOED HEADPHAISTOS DISC SIGN CAPTIVEPHAISTOS DISC S" +
	"IGN CHILDPHAISTOS DISC SIGN WOMANPHAISTOS DISC SIGN HELMETPHAISTOS DISC " +
	"SIGN GAUNTLETPHAISTOS DISC SIGN TIARAPHAISTOS DISC SIGN ARROWPHAISTOS DI" +
	"SC SIGN BOWPHAISTOS DISC SIGN SHIELDPHAISTOS DISC SIGN CLUBPHAISTOS DISC" +
	" SIGN MANACLESPHAISTOS DISC SIGN MATTOCKPHAISTOS DISC SIGN SAWPHAISTOS D" +
	"ISC SIGN LIDPHAISTOS DISC SIGN BOOMERANGPHAISTOS DISC SIGN CARPENTRY PLA" +
	"NEPHAISTOS DISC SIGN DOLIUMPHAISTOS DISC SIGN COMBPHAISTOS DISC SIGN SLI" +
	"NGPHAISTOS DISC SIGN COLUMNPHAISTOS DISC SIGN BEEHIVEPHAISTOS DISC SIGN ") + ("" +
	"SHIPPHAISTOS DISC SIGN HORNPHAISTOS DISC SIGN HIDEPHAISTOS DISC SIGN BUL" +
	"LS LEGPHAISTOS DISC SIGN CATPHAISTOS DISC SIGN RAMPHAISTOS DISC SIGN EAG" +
	"LEPHAISTOS DISC SIGN DOVEPHAISTOS DISC SIGN TUNNYPHAISTOS DISC SIGN BEEP" +
	"HAISTOS DISC SIGN PLANE TREEPHAISTOS DISC SIGN VINEPHAISTOS DISC SIGN PA" +
	"PYRUSPHAISTOS DISC SIGN ROSETTEPHAISTOS DISC SIGN LILYPHAISTOS DISC SIGN" +
	" OX BACKPHAISTOS DISC SIGN FLUTEPHAISTOS DISC SIGN GRATERPHAISTOS DISC S" +
	"IGN STRAINERPHAISTOS DISC SIGN SMALL AXEPHAISTOS DISC SIGN WAVY BANDPHAI" +
	"STOS DISC SIGN COMBINING OBLIQUE STROKELYCIAN LETTER ALYCIAN LETTER ELYC" +
	"IAN LETTER BLYCIAN LETTER BHLYCIAN LETTER GLYCIAN LETTER DLYCIAN LETTER " +
	"ILYCIAN LETTER WLYCIAN LETTER ZLYCIAN LETTER THLYCIAN LETTER JLYCIAN LET" +
	"TER KLYCIAN LETTER QLYCIAN LETTER LLYCIAN LETTER MLYCIAN LETTER NLYCIAN " +
	"LETTER MMLYCIAN LETTER NNLYCIAN LETTER ULYCIAN LETTER PLYCIAN LETTER KKL" +
	"YCIAN LETTER RLYCIAN LETTER SLYCIAN LETTER TLYCIAN LETTER TTLYCIAN LETTE" +
	"R ANLYCIAN LETTER ENLYCIAN LETTER HLYCIAN LETTER XCARIAN LETTER ACARIAN " +
	"LETTER P2CARIAN LETTER DCARIAN LETTER LCARIAN LETTER UUUCARIAN LETTER RC" +
	"ARIAN LETTER LDCARIAN LETTER A2CARIAN LETTER QCARIAN LETTER BCARIAN LETT" +
	"ER MCARIAN LETTER OCARIAN LETTER D2CARIAN LETTER TCARIAN LETTER SHCARIAN" +
	" LETTER SH2CARIAN LETTER SCARIAN LETTER C-18CARIAN LETTER UCARIAN LETTER" +
	" NNCARIAN LETTER XCARIAN LETTER NCARIAN LETTER TT2CARIAN LETTER PCARIAN " +
	"LETTER SSCARIAN LETTER ICARIAN LETTER ECARIAN LETTER UUUUCARIAN LETTER K" +
	"CARIAN LETTER K2CARIAN LETTER NDCARIAN LETTER UUCARIAN LETTER GCARIAN LE" +
	"TTER G2CARIAN LETTER STCARIAN LETTER ST2CARIAN LETTER NGCARIAN LETTER II" +
	"CARIAN LETTER C-39CARIAN LETTER TTCARIAN LETTER UUU2CARIAN LETTER RRCARI" +
	"AN LETTER MBCARIAN LETTER MB2CARIAN LETTER MB3CARIAN LETTER MB4CARIAN LE" +
	"TTER LD2CARIAN LETTER E2CARIAN LETTER UUU3COPTIC EPACT THOUSANDS MARKCOP" +
	"TIC EPACT DIGIT ONECOPTIC EPACT DIGIT TWOCOPTIC EPACT DIGIT THREECOPTIC " +
	"EPACT DIGIT FOURCOPTIC EPACT DIGIT FIVECOPTIC EPACT DIGIT SIXCOPTIC EPAC" +
	"T DIGIT SEVENCOPTIC EPACT DIGIT EIGHTCOPTIC EPACT DIGIT NINECOPTIC EPACT" +
	" NUMBER TENCOPTIC EPACT NUMBER TWENTYCOPTIC EPACT NUMBER THIRTYCOPTIC EP" +
	"ACT NUMBER FORTYCOPTIC EPACT NUMBER FIFTYCOPTIC EPACT NUMBER SIXTYCOPTIC" +
	" EPACT NUMBER SEVENTYCOPTIC EPACT NUMBER EIGHTYCOPTIC EPACT NUMBER NINET" +
	"YCOPTIC EPACT NUMBER ONE HUNDREDCOPTIC EPACT NUMBER TWO HUNDREDCOPTIC EP" +
	"ACT NUMBER THREE HUNDREDCOPTIC EPACT NUMBER FOUR HUNDREDCOPTIC EPACT NUM" +
	"BER FIVE HUNDREDCOPTIC EPACT NUMBER SIX HUNDREDCOPTIC EPACT NUMBER SEVEN" +
	" HUNDREDCOPTIC EPACT NUMBER EIGHT HUNDREDCOPTIC EPACT NUMBER NINE HUNDRE" +
	"DOLD ITALIC LETTER AOLD ITALIC LETTER BEOLD ITALIC LETTER KEOLD ITALIC L" +
	"ETTER DEOLD ITALIC LETTER EOLD ITALIC LETTER VEOLD ITALIC LETTER ZEOLD I" +
	"TALIC LETTER HEOLD ITALIC LETTER THEOLD ITALIC LETTER IOLD ITALIC LETTER" +
	" KAOLD ITALIC LETTER ELOLD ITALIC LETTER EMOLD ITALIC LETTER ENOLD ITALI" +
	"C LETTER ESHOLD ITALIC LETTER OOLD ITALIC LETTER PEOLD ITALIC LETTER SHE" +
	"OLD ITALIC LETTER KUOLD ITALIC LETTER EROLD ITALIC LETTER ESOLD ITALIC L" +
	"ETTER TEOLD ITALIC LETTER UOLD ITALIC LETTER EKSOLD ITALIC LETTER PHEOLD" +
	" ITALIC LETTER KHEOLD ITALIC LETTER EFOLD ITALIC LETTER ERSOLD ITALIC LE" +
	"TTER CHEOLD ITALIC LETTER IIOLD ITALIC LETTER UUOLD ITALIC LETTER ESSOLD" +
	" ITALIC NUMERAL ONEOLD ITALIC NUMERAL FIVEOLD ITALIC NUMERAL TENOLD ITAL" +
	"IC NUMERAL FIFTYOLD ITALIC LETTER YEOLD ITALIC LETTER NORTHERN TSEOLD IT" +
	"ALIC LETTER SOUTHERN TSEGOTHIC LETTER AHSAGOTHIC LETTER BAIRKANGOTHIC LE" +
	"TTER GIBAGOTHIC LETTER DAGSGOTHIC LETTER AIHVUSGOTHIC LETTER QAIRTHRAGOT" +
	"HIC LETTER IUJAGOTHIC LETTER HAGLGOTHIC LETTER THIUTHGOTHIC LETTER EISGO" +
	"THIC LETTER KUSMAGOTHIC LETTER LAGUSGOTHIC LETTER MANNAGOTHIC LETTER NAU" +
	"THSGOTHIC LETTER JERGOTHIC LETTER URUSGOTHIC LETTER PAIRTHRAGOTHIC LETTE" +
	"R NINETYGOTHIC LETTER RAIDAGOTHIC LETTER SAUILGOTHIC LETTER TEIWSGOTHIC " +
	"LETTER WINJAGOTHIC LETTER FAIHUGOTHIC LETTER IGGWSGOTHIC LETTER HWAIRGOT" +
	"HIC LETTER OTHALGOTHIC LETTER NINE HUNDREDOLD PERMIC LETTER ANOLD PERMIC" +
	" LETTER BUROLD PERMIC LETTER GAIOLD PERMIC LETTER DOIOLD PERMIC LETTER E" +
	"OLD PERMIC LETTER ZHOIOLD PERMIC LETTER DZHOIOLD PERMIC LETTER ZATAOLD P" +
	"ERMIC LETTER DZITAOLD PERMIC LETTER IOLD PERMIC LETTER KOKEOLD PERMIC LE" +
	"TTER LEIOLD PERMIC LETTER MENOEOLD PERMIC LETTER NENOEOLD PERMIC LETTER " +
	"VOOIOLD PERMIC LETTER PEEIOLD PERMIC LETTER REIOLD PERMIC LETTER SIIOLD " +
	"PERMIC LETTER TAIOLD PERMIC LETTER UOLD PERMIC LETTER CHERYOLD PERMIC LE" +
	"TTER SHOOIOLD PERMIC LETTER SHCHOOIOLD PERMIC LETTER YRYOLD PERMIC LETTE" +
	"R YERUOLD PERMIC LETTER OOLD PERMIC LETTER OOOLD PERMIC LETTER EFOLD PER" +
	"MIC LETTER HAOLD PERMIC LETTER TSIUOLD PERMIC LETTER VEROLD PERMIC LETTE" +
	"R YEROLD PERMIC LETTER YERIOLD PERMIC LETTER YATOLD PERMIC LETTER IEOLD ") + ("" +
	"PERMIC LETTER YUOLD PERMIC LETTER YAOLD PERMIC LETTER IACOMBINING OLD PE" +
	"RMIC LETTER ANCOMBINING OLD PERMIC LETTER DOICOMBINING OLD PERMIC LETTER" +
	" ZATACOMBINING OLD PERMIC LETTER NENOECOMBINING OLD PERMIC LETTER SIIUGA" +
	"RITIC LETTER ALPAUGARITIC LETTER BETAUGARITIC LETTER GAMLAUGARITIC LETTE" +
	"R KHAUGARITIC LETTER DELTAUGARITIC LETTER HOUGARITIC LETTER WOUGARITIC L" +
	"ETTER ZETAUGARITIC LETTER HOTAUGARITIC LETTER TETUGARITIC LETTER YODUGAR" +
	"ITIC LETTER KAFUGARITIC LETTER SHINUGARITIC LETTER LAMDAUGARITIC LETTER " +
	"MEMUGARITIC LETTER DHALUGARITIC LETTER NUNUGARITIC LETTER ZUUGARITIC LET" +
	"TER SAMKAUGARITIC LETTER AINUGARITIC LETTER PUUGARITIC LETTER SADEUGARIT" +
	"IC LETTER QOPAUGARITIC LETTER RASHAUGARITIC LETTER THANNAUGARITIC LETTER" +
	" GHAINUGARITIC LETTER TOUGARITIC LETTER IUGARITIC LETTER UUGARITIC LETTE" +
	"R SSUUGARITIC WORD DIVIDEROLD PERSIAN SIGN AOLD PERSIAN SIGN IOLD PERSIA" +
	"N SIGN UOLD PERSIAN SIGN KAOLD PERSIAN SIGN KUOLD PERSIAN SIGN GAOLD PER" +
	"SIAN SIGN GUOLD PERSIAN SIGN XAOLD PERSIAN SIGN CAOLD PERSIAN SIGN JAOLD" +
	" PERSIAN SIGN JIOLD PERSIAN SIGN TAOLD PERSIAN SIGN TUOLD PERSIAN SIGN D" +
	"AOLD PERSIAN SIGN DIOLD PERSIAN SIGN DUOLD PERSIAN SIGN THAOLD PERSIAN S" +
	"IGN PAOLD PERSIAN SIGN BAOLD PERSIAN SIGN FAOLD PERSIAN SIGN NAOLD PERSI" +
	"AN SIGN NUOLD PERSIAN SIGN MAOLD PERSIAN SIGN MIOLD PERSIAN SIGN MUOLD P" +
	"ERSIAN SIGN YAOLD PERSIAN SIGN VAOLD PERSIAN SIGN VIOLD PERSIAN SIGN RAO" +
	"LD PERSIAN SIGN RUOLD PERSIAN SIGN LAOLD PERSIAN SIGN SAOLD PERSIAN SIGN" +
	" ZAOLD PERSIAN SIGN SHAOLD PERSIAN SIGN SSAOLD PERSIAN SIGN HAOLD PERSIA" +
	"N SIGN AURAMAZDAAOLD PERSIAN SIGN AURAMAZDAA-2OLD PERSIAN SIGN AURAMAZDA" +
	"AHAOLD PERSIAN SIGN XSHAAYATHIYAOLD PERSIAN SIGN DAHYAAUSHOLD PERSIAN SI" +
	"GN DAHYAAUSH-2OLD PERSIAN SIGN BAGAOLD PERSIAN SIGN BUUMISHOLD PERSIAN W" +
	"ORD DIVIDEROLD PERSIAN NUMBER ONEOLD PERSIAN NUMBER TWOOLD PERSIAN NUMBE" +
	"R TENOLD PERSIAN NUMBER TWENTYOLD PERSIAN NUMBER HUNDREDDESERET CAPITAL " +
	"LETTER LONG IDESERET CAPITAL LETTER LONG EDESERET CAPITAL LETTER LONG AD" +
	"ESERET CAPITAL LETTER LONG AHDESERET CAPITAL LETTER LONG ODESERET CAPITA" +
	"L LETTER LONG OODESERET CAPITAL LETTER SHORT IDESERET CAPITAL LETTER SHO" +
	"RT EDESERET CAPITAL LETTER SHORT ADESERET CAPITAL LETTER SHORT AHDESERET" +
	" CAPITAL LETTER SHORT ODESERET CAPITAL LETTER SHORT OODESERET CAPITAL LE" +
	"TTER AYDESERET CAPITAL LETTER OWDESERET CAPITAL LETTER WUDESERET CAPITAL" +
	" LETTER YEEDESERET CAPITAL LETTER HDESERET CAPITAL LETTER PEEDESERET CAP" +
	"ITAL LETTER BEEDESERET CAPITAL LETTER TEEDESERET CAPITAL LETTER DEEDESER" +
	"ET CAPITAL LETTER CHEEDESERET CAPITAL LETTER JEEDESERET CAPITAL LETTER K" +
	"AYDESERET CAPITAL LETTER GAYDESERET CAPITAL LETTER EFDESERET CAPITAL LET" +
	"TER VEEDESERET CAPITAL LETTER ETHDESERET CAPITAL LETTER THEEDESERET CAPI" +
	"TAL LETTER ESDESERET CAPITAL LETTER ZEEDESERET CAPITAL LETTER ESHDESERET" +
	" CAPITAL LETTER ZHEEDESERET CAPITAL LETTER ERDESERET CAPITAL LETTER ELDE" +
	"SERET CAPITAL LETTER EMDESERET CAPITAL LETTER ENDESERET CAPITAL LETTER E" +
	"NGDESERET CAPITAL LETTER OIDESERET CAPITAL LETTER EWDESERET SMALL LETTER" +
	" LONG IDESERET SMALL LETTER LONG EDESERET SMALL LETTER LONG ADESERET SMA" +
	"LL LETTER LONG AHDESERET SMALL LETTER LONG ODESERET SMALL LETTER LONG OO" +
	"DESERET SMALL LETTER SHORT IDESERET SMALL LETTER SHORT EDESERET SMALL LE" +
	"TTER SHORT ADESERET SMALL LETTER SHORT AHDESERET SMALL LETTER SHORT ODES" +
	"ERET SMALL LETTER SHORT OODESERET SMALL LETTER AYDESERET SMALL LETTER OW" +
	"DESERET SMALL LETTER WUDESERET SMALL LETTER YEEDESERET SMALL LETTER HDES" +
	"ERET SMALL LETTER PEEDESERET SMALL LETTER BEEDESERET SMALL LETTER TEEDES" +
	"ERET SMALL LETTER DEEDESERET SMALL LETTER CHEEDESERET SMALL LETTER JEEDE" +
	"SERET SMALL LETTER KAYDESERET SMALL LETTER GAYDESERET SMALL LETTER EFDES" +
	"ERET SMALL LETTER VEEDESERET SMALL LETTER ETHDESERET SMALL LETTER THEEDE" +
	"SERET SMALL LETTER ESDESERET SMALL LETTER ZEEDESERET SMALL LETTER ESHDES" +
	"ERET SMALL LETTER ZHEEDESERET SMALL LETTER ERDESERET SMALL LETTER ELDESE" +
	"RET SMALL LETTER EMDESERET SMALL LETTER ENDESERET SMALL LETTER ENGDESERE" +
	"T SMALL LETTER OIDESERET SMALL LETTER EWSHAVIAN LETTER PEEPSHAVIAN LETTE" +
	"R TOTSHAVIAN LETTER KICKSHAVIAN LETTER FEESHAVIAN LETTER THIGHSHAVIAN LE" +
	"TTER SOSHAVIAN LETTER SURESHAVIAN LETTER CHURCHSHAVIAN LETTER YEASHAVIAN" +
	" LETTER HUNGSHAVIAN LETTER BIBSHAVIAN LETTER DEADSHAVIAN LETTER GAGSHAVI" +
	"AN LETTER VOWSHAVIAN LETTER THEYSHAVIAN LETTER ZOOSHAVIAN LETTER MEASURE" +
	"SHAVIAN LETTER JUDGESHAVIAN LETTER WOESHAVIAN LETTER HA-HASHAVIAN LETTER" +
	" LOLLSHAVIAN LETTER MIMESHAVIAN LETTER IFSHAVIAN LETTER EGGSHAVIAN LETTE" +
	"R ASHSHAVIAN LETTER ADOSHAVIAN LETTER ONSHAVIAN LETTER WOOLSHAVIAN LETTE" +
	"R OUTSHAVIAN LETTER AHSHAVIAN LETTER ROARSHAVIAN LETTER NUNSHAVIAN LETTE" +
	"R EATSHAVIAN LETTER AGESHAVIAN LETTER ICESHAVIAN LETTER UPSHAVIAN LETTER") + ("" +
	" OAKSHAVIAN LETTER OOZESHAVIAN LETTER OILSHAVIAN LETTER AWESHAVIAN LETTE" +
	"R ARESHAVIAN LETTER ORSHAVIAN LETTER AIRSHAVIAN LETTER ERRSHAVIAN LETTER" +
	" ARRAYSHAVIAN LETTER EARSHAVIAN LETTER IANSHAVIAN LETTER YEWOSMANYA LETT" +
	"ER ALEFOSMANYA LETTER BAOSMANYA LETTER TAOSMANYA LETTER JAOSMANYA LETTER" +
	" XAOSMANYA LETTER KHAOSMANYA LETTER DEELOSMANYA LETTER RAOSMANYA LETTER " +
	"SAOSMANYA LETTER SHIINOSMANYA LETTER DHAOSMANYA LETTER CAYNOSMANYA LETTE" +
	"R GAOSMANYA LETTER FAOSMANYA LETTER QAAFOSMANYA LETTER KAAFOSMANYA LETTE" +
	"R LAANOSMANYA LETTER MIINOSMANYA LETTER NUUNOSMANYA LETTER WAWOSMANYA LE" +
	"TTER HAOSMANYA LETTER YAOSMANYA LETTER AOSMANYA LETTER EOSMANYA LETTER I" +
	"OSMANYA LETTER OOSMANYA LETTER UOSMANYA LETTER AAOSMANYA LETTER EEOSMANY" +
	"A LETTER OOOSMANYA DIGIT ZEROOSMANYA DIGIT ONEOSMANYA DIGIT TWOOSMANYA D" +
	"IGIT THREEOSMANYA DIGIT FOUROSMANYA DIGIT FIVEOSMANYA DIGIT SIXOSMANYA D" +
	"IGIT SEVENOSMANYA DIGIT EIGHTOSMANYA DIGIT NINEOSAGE CAPITAL LETTER AOSA" +
	"GE CAPITAL LETTER AIOSAGE CAPITAL LETTER AINOSAGE CAPITAL LETTER AHOSAGE" +
	" CAPITAL LETTER BRAOSAGE CAPITAL LETTER CHAOSAGE CAPITAL LETTER EHCHAOSA" +
	"GE CAPITAL LETTER EOSAGE CAPITAL LETTER EINOSAGE CAPITAL LETTER HAOSAGE " +
	"CAPITAL LETTER HYAOSAGE CAPITAL LETTER IOSAGE CAPITAL LETTER KAOSAGE CAP" +
	"ITAL LETTER EHKAOSAGE CAPITAL LETTER KYAOSAGE CAPITAL LETTER LAOSAGE CAP" +
	"ITAL LETTER MAOSAGE CAPITAL LETTER NAOSAGE CAPITAL LETTER OOSAGE CAPITAL" +
	" LETTER OINOSAGE CAPITAL LETTER PAOSAGE CAPITAL LETTER EHPAOSAGE CAPITAL" +
	" LETTER SAOSAGE CAPITAL LETTER SHAOSAGE CAPITAL LETTER TAOSAGE CAPITAL L" +
	"ETTER EHTAOSAGE CAPITAL LETTER TSAOSAGE CAPITAL LETTER EHTSAOSAGE CAPITA" +
	"L LETTER TSHAOSAGE CAPITAL LETTER DHAOSAGE CAPITAL LETTER UOSAGE CAPITAL" +
	" LETTER WAOSAGE CAPITAL LETTER KHAOSAGE CAPITAL LETTER GHAOSAGE CAPITAL " +
	"LETTER ZAOSAGE CAPITAL LETTER ZHAOSAGE SMALL LETTER AOSAGE SMALL LETTER " +
	"AIOSAGE SMALL LETTER AINOSAGE SMALL LETTER AHOSAGE SMALL LETTER BRAOSAGE" +
	" SMALL LETTER CHAOSAGE SMALL LETTER EHCHAOSAGE SMALL LETTER EOSAGE SMALL" +
	" LETTER EINOSAGE SMALL LETTER HAOSAGE SMALL LETTER HYAOSAGE SMALL LETTER" +
	" IOSAGE SMALL LETTER KAOSAGE SMALL LETTER EHKAOSAGE SMALL LETTER KYAOSAG" +
	"E SMALL LETTER LAOSAGE SMALL LETTER MAOSAGE SMALL LETTER NAOSAGE SMALL L" +
	"ETTER OOSAGE SMALL LETTER OINOSAGE SMALL LETTER PAOSAGE SMALL LETTER EHP" +
	"AOSAGE SMALL LETTER SAOSAGE SMALL LETTER SHAOSAGE SMALL LETTER TAOSAGE S" +
	"MALL LETTER EHTAOSAGE SMALL LETTER TSAOSAGE SMALL LETTER EHTSAOSAGE SMAL" +
	"L LETTER TSHAOSAGE SMALL LETTER DHAOSAGE SMALL LETTER UOSAGE SMALL LETTE" +
	"R WAOSAGE SMALL LETTER KHAOSAGE SMALL LETTER GHAOSAGE SMALL LETTER ZAOSA" +
	"GE SMALL LETTER ZHAELBASAN LETTER AELBASAN LETTER BEELBASAN LETTER CEELB" +
	"ASAN LETTER CHEELBASAN LETTER DEELBASAN LETTER NDEELBASAN LETTER DHEELBA" +
	"SAN LETTER EIELBASAN LETTER EELBASAN LETTER FEELBASAN LETTER GEELBASAN L" +
	"ETTER GJEELBASAN LETTER HEELBASAN LETTER IELBASAN LETTER JEELBASAN LETTE" +
	"R KEELBASAN LETTER LEELBASAN LETTER LLEELBASAN LETTER MEELBASAN LETTER N" +
	"EELBASAN LETTER NAELBASAN LETTER NJEELBASAN LETTER OELBASAN LETTER PEELB" +
	"ASAN LETTER QEELBASAN LETTER REELBASAN LETTER RREELBASAN LETTER SEELBASA" +
	"N LETTER SHEELBASAN LETTER TEELBASAN LETTER THEELBASAN LETTER UELBASAN L" +
	"ETTER VEELBASAN LETTER XEELBASAN LETTER YELBASAN LETTER ZEELBASAN LETTER" +
	" ZHEELBASAN LETTER GHEELBASAN LETTER GHAMMAELBASAN LETTER KHECAUCASIAN A" +
	"LBANIAN LETTER ALTCAUCASIAN ALBANIAN LETTER BETCAUCASIAN ALBANIAN LETTER" +
	" GIMCAUCASIAN ALBANIAN LETTER DATCAUCASIAN ALBANIAN LETTER EBCAUCASIAN A" +
	"LBANIAN LETTER ZARLCAUCASIAN ALBANIAN LETTER EYNCAUCASIAN ALBANIAN LETTE" +
	"R ZHILCAUCASIAN ALBANIAN LETTER TASCAUCASIAN ALBANIAN LETTER CHACAUCASIA" +
	"N ALBANIAN LETTER YOWDCAUCASIAN ALBANIAN LETTER ZHACAUCASIAN ALBANIAN LE" +
	"TTER IRBCAUCASIAN ALBANIAN LETTER SHACAUCASIAN ALBANIAN LETTER LANCAUCAS" +
	"IAN ALBANIAN LETTER INYACAUCASIAN ALBANIAN LETTER XEYNCAUCASIAN ALBANIAN" +
	" LETTER DYANCAUCASIAN ALBANIAN LETTER CARCAUCASIAN ALBANIAN LETTER JHOXC" +
	"AUCASIAN ALBANIAN LETTER KARCAUCASIAN ALBANIAN LETTER LYITCAUCASIAN ALBA" +
	"NIAN LETTER HEYTCAUCASIAN ALBANIAN LETTER QAYCAUCASIAN ALBANIAN LETTER A" +
	"ORCAUCASIAN ALBANIAN LETTER CHOYCAUCASIAN ALBANIAN LETTER CHICAUCASIAN A" +
	"LBANIAN LETTER CYAYCAUCASIAN ALBANIAN LETTER MAQCAUCASIAN ALBANIAN LETTE" +
	"R QARCAUCASIAN ALBANIAN LETTER NOWCCAUCASIAN ALBANIAN LETTER DZYAYCAUCAS" +
	"IAN ALBANIAN LETTER SHAKCAUCASIAN ALBANIAN LETTER JAYNCAUCASIAN ALBANIAN" +
	" LETTER ONCAUCASIAN ALBANIAN LETTER TYAYCAUCASIAN ALBANIAN LETTER FAMCAU" +
	"CASIAN ALBANIAN LETTER DZAYCAUCASIAN ALBANIAN LETTER CHATCAUCASIAN ALBAN" +
	"IAN LETTER PENCAUCASIAN ALBANIAN LETTER GHEYSCAUCASIAN ALBANIAN LETTER R" +
	"ATCAUCASIAN ALBANIAN LETTER SEYKCAUCASIAN ALBANIAN LETTER VEYZCAUCASIAN " +
	"ALBANIAN LETTER TIWRCAUCASIAN ALBANIAN LETTER SHOYCAUCASIAN ALBANIAN LET") + ("" +
	"TER IWNCAUCASIAN ALBANIAN LETTER CYAWCAUCASIAN ALBANIAN LETTER CAYNCAUCA" +
	"SIAN ALBANIAN LETTER YAYDCAUCASIAN ALBANIAN LETTER PIWRCAUCASIAN ALBANIA" +
	"N LETTER KIWCAUCASIAN ALBANIAN CITATION MARKVITHKUQI CAPITAL LETTER AVIT" +
	"HKUQI CAPITAL LETTER BBEVITHKUQI CAPITAL LETTER BEVITHKUQI CAPITAL LETTE" +
	"R CEVITHKUQI CAPITAL LETTER CHEVITHKUQI CAPITAL LETTER DEVITHKUQI CAPITA" +
	"L LETTER DHEVITHKUQI CAPITAL LETTER EIVITHKUQI CAPITAL LETTER EVITHKUQI " +
	"CAPITAL LETTER FEVITHKUQI CAPITAL LETTER GAVITHKUQI CAPITAL LETTER HAVIT" +
	"HKUQI CAPITAL LETTER HHAVITHKUQI CAPITAL LETTER IVITHKUQI CAPITAL LETTER" +
	" IJEVITHKUQI CAPITAL LETTER JEVITHKUQI CAPITAL LETTER KAVITHKUQI CAPITAL" +
	" LETTER LAVITHKUQI CAPITAL LETTER LLAVITHKUQI CAPITAL LETTER MEVITHKUQI " +
	"CAPITAL LETTER NEVITHKUQI CAPITAL LETTER NJEVITHKUQI CAPITAL LETTER OVIT" +
	"HKUQI CAPITAL LETTER PEVITHKUQI CAPITAL LETTER QAVITHKUQI CAPITAL LETTER" +
	" REVITHKUQI CAPITAL LETTER SEVITHKUQI CAPITAL LETTER SHEVITHKUQI CAPITAL" +
	" LETTER TEVITHKUQI CAPITAL LETTER THEVITHKUQI CAPITAL LETTER UVITHKUQI C" +
	"APITAL LETTER VEVITHKUQI CAPITAL LETTER XEVITHKUQI CAPITAL LETTER YVITHK" +
	"UQI CAPITAL LETTER ZEVITHKUQI SMALL LETTER AVITHKUQI SMALL LETTER BBEVIT" +
	"HKUQI SMALL LETTER BEVITHKUQI SMALL LETTER CEVITHKUQI SMALL LETTER CHEVI" +
	"THKUQI SMALL LETTER DEVITHKUQI SMALL LETTER DHEVITHKUQI SMALL LETTER EIV" +
	"ITHKUQI SMALL LETTER EVITHKUQI SMALL LETTER FEVITHKUQI SMALL LETTER GAVI" +
	"THKUQI SMALL LETTER HAVITHKUQI SMALL LETTER HHAVITHKUQI SMALL LETTER IVI" +
	"THKUQI SMALL LETTER IJEVITHKUQI SMALL LETTER JEVITHKUQI SMALL LETTER KAV" +
	"ITHKUQI SMALL LETTER LAVITHKUQI SMALL LETTER LLAVITHKUQI SMALL LETTER ME" +
	"VITHKUQI SMALL LETTER NEVITHKUQI SMALL LETTER NJEVITHKUQI SMALL LETTER O" +
	"VITHKUQI SMALL LETTER PEVITHKUQI SMALL LETTER QAVITHKUQI SMALL LETTER RE" +
	"VITHKUQI SMALL LETTER SEVITHKUQI SMALL LETTER SHEVITHKUQI SMALL LETTER T" +
	"EVITHKUQI SMALL LETTER THEVITHKUQI SMALL LETTER UVITHKUQI SMALL LETTER V" +
	"EVITHKUQI SMALL LETTER XEVITHKUQI SMALL LETTER YVITHKUQI SMALL LETTER ZE" +
	"LINEAR A SIGN AB001LINEAR A SIGN AB002LINEAR A SIGN AB003LINEAR A SIGN A" +
	"B004LINEAR A SIGN AB005LINEAR A SIGN AB006LINEAR A SIGN AB007LINEAR A SI" +
	"GN AB008LINEAR A SIGN AB009LINEAR A SIGN AB010LINEAR A SIGN AB011LINEAR " +
	"A SIGN AB013LINEAR A SIGN AB016LINEAR A SIGN AB017LINEAR A SIGN AB020LIN" +
	"EAR A SIGN AB021LINEAR A SIGN AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB" +
	"022LINEAR A SIGN AB022FLINEAR A SIGN AB022MLINEAR A SIGN AB023LINEAR A S" +
	"IGN AB023MLINEAR A SIGN AB024LINEAR A SIGN AB026LINEAR A SIGN AB027LINEA" +
	"R A SIGN AB028LINEAR A SIGN A028BLINEAR A SIGN AB029LINEAR A SIGN AB030L" +
	"INEAR A SIGN AB031LINEAR A SIGN AB034LINEAR A SIGN AB037LINEAR A SIGN AB" +
	"038LINEAR A SIGN AB039LINEAR A SIGN AB040LINEAR A SIGN AB041LINEAR A SIG" +
	"N AB044LINEAR A SIGN AB045LINEAR A SIGN AB046LINEAR A SIGN AB047LINEAR A" +
	" SIGN AB048LINEAR A SIGN AB049LINEAR A SIGN AB050LINEAR A SIGN AB051LINE" +
	"AR A SIGN AB053LINEAR A SIGN AB054LINEAR A SIGN AB055LINEAR A SIGN AB056" +
	"LINEAR A SIGN AB057LINEAR A SIGN AB058LINEAR A SIGN AB059LINEAR A SIGN A" +
	"B060LINEAR A SIGN AB061LINEAR A SIGN AB065LINEAR A SIGN AB066LINEAR A SI" +
	"GN AB067LINEAR A SIGN AB069LINEAR A SIGN AB070LINEAR A SIGN AB073LINEAR " +
	"A SIGN AB074LINEAR A SIGN AB076LINEAR A SIGN AB077LINEAR A SIGN AB078LIN" +
	"EAR A SIGN AB079LINEAR A SIGN AB080LINEAR A SIGN AB081LINEAR A SIGN AB08" +
	"2LINEAR A SIGN AB085LINEAR A SIGN AB086LINEAR A SIGN AB087LINEAR A SIGN " +
	"A100-102LINEAR A SIGN AB118LINEAR A SIGN AB120LINEAR A SIGN A120BLINEAR " +
	"A SIGN AB122LINEAR A SIGN AB123LINEAR A SIGN AB131ALINEAR A SIGN AB131BL" +
	"INEAR A SIGN A131CLINEAR A SIGN AB164LINEAR A SIGN AB171LINEAR A SIGN AB" +
	"180LINEAR A SIGN AB188LINEAR A SIGN AB191LINEAR A SIGN A301LINEAR A SIGN" +
	" A302LINEAR A SIGN A303LINEAR A SIGN A304LINEAR A SIGN A305LINEAR A SIGN" +
	" A306LINEAR A SIGN A307LINEAR A SIGN A308LINEAR A SIGN A309ALINEAR A SIG" +
	"N A309BLINEAR A SIGN A309CLINEAR A SIGN A310LINEAR A SIGN A311LINEAR A S" +
	"IGN A312LINEAR A SIGN A313ALINEAR A SIGN A313BLINEAR A SIGN A313CLINEAR " +
	"A SIGN A314LINEAR A SIGN A315LINEAR A SIGN A316LINEAR A SIGN A317LINEAR " +
	"A SIGN A318LINEAR A SIGN A319LINEAR A SIGN A320LINEAR A SIGN A321LINEAR " +
	"A SIGN A322LINEAR A SIGN A323LINEAR A SIGN A324LINEAR A SIGN A325LINEAR " +
	"A SIGN A326LINEAR A SIGN A327LINEAR A SIGN A328LINEAR A SIGN A329LINEAR " +
	"A SIGN A330LINEAR A SIGN A331LINEAR A SIGN A332LINEAR A SIGN A333LINEAR " +
	"A SIGN A334LINEAR A SIGN A335LINEAR A SIGN A336LINEAR A SIGN A337LINEAR " +
	"A SIGN A338LINEAR A SIGN A339LINEAR A SIGN A340LINEAR A SIGN A341LINEAR " +
	"A SIGN A342LINEAR A SIGN A343LINEAR A SIGN A344LINEAR A SIGN A345LINEAR " +
	"A SIGN A346LINEAR A SIGN A347LINEAR A SIGN A348LINEAR A SIGN A349LINEAR " +
	"A SIGN A350LINEAR A SIGN A351LINEAR A SIGN A352LINEAR A SIGN A353LINEAR ") + ("" +
	"A SIGN A354LINEAR A SIGN A355LINEAR A SIGN A356LINEAR A SIGN A357LINEAR " +
	"A SIGN A358LINEAR A SIGN A359LINEAR A SIGN A360LINEAR A SIGN A361LINEAR " +
	"A SIGN A362LINEAR A SIGN A363LINEAR A SIGN A364LINEAR A SIGN A365LINEAR " +
	"A SIGN A366LINEAR A SIGN A367LINEAR A SIGN A368LINEAR A SIGN A369LINEAR " +
	"A SIGN A370LINEAR A SIGN A371LINEAR A SIGN A400-VASLINEAR A SIGN A401-VA" +
	"SLINEAR A SIGN A402-VASLINEAR A SIGN A403-VASLINEAR A SIGN A404-VASLINEA" +
	"R A SIGN A405-VASLINEAR A SIGN A406-VASLINEAR A SIGN A407-VASLINEAR A SI" +
	"GN A408-VASLINEAR A SIGN A409-VASLINEAR A SIGN A410-VASLINEAR A SIGN A41" +
	"1-VASLINEAR A SIGN A412-VASLINEAR A SIGN A413-VASLINEAR A SIGN A414-VASL" +
	"INEAR A SIGN A415-VASLINEAR A SIGN A416-VASLINEAR A SIGN A417-VASLINEAR " +
	"A SIGN A418-VASLINEAR A SIGN A501LINEAR A SIGN A502LINEAR A SIGN A503LIN" +
	"EAR A SIGN A504LINEAR A SIGN A505LINEAR A SIGN A506LINEAR A SIGN A508LIN" +
	"EAR A SIGN A509LINEAR A SIGN A510LINEAR A SIGN A511LINEAR A SIGN A512LIN" +
	"EAR A SIGN A513LINEAR A SIGN A515LINEAR A SIGN A516LINEAR A SIGN A520LIN" +
	"EAR A SIGN A521LINEAR A SIGN A523LINEAR A SIGN A524LINEAR A SIGN A525LIN" +
	"EAR A SIGN A526LINEAR A SIGN A527LINEAR A SIGN A528LINEAR A SIGN A529LIN" +
	"EAR A SIGN A530LINEAR A SIGN A531LINEAR A SIGN A532LINEAR A SIGN A534LIN" +
	"EAR A SIGN A535LINEAR A SIGN A536LINEAR A SIGN A537LINEAR A SIGN A538LIN" +
	"EAR A SIGN A539LINEAR A SIGN A540LINEAR A SIGN A541LINEAR A SIGN A542LIN" +
	"EAR A SIGN A545LINEAR A SIGN A547LINEAR A SIGN A548LINEAR A SIGN A549LIN" +
	"EAR A SIGN A550LINEAR A SIGN A551LINEAR A SIGN A552LINEAR A SIGN A553LIN" +
	"EAR A SIGN A554LINEAR A SIGN A555LINEAR A SIGN A556LINEAR A SIGN A557LIN" +
	"EAR A SIGN A559LINEAR A SIGN A563LINEAR A SIGN A564LINEAR A SIGN A565LIN" +
	"EAR A SIGN A566LINEAR A SIGN A568LINEAR A SIGN A569LINEAR A SIGN A570LIN" +
	"EAR A SIGN A571LINEAR A SIGN A572LINEAR A SIGN A573LINEAR A SIGN A574LIN" +
	"EAR A SIGN A575LINEAR A SIGN A576LINEAR A SIGN A577LINEAR A SIGN A578LIN" +
	"EAR A SIGN A579LINEAR A SIGN A580LINEAR A SIGN A581LINEAR A SIGN A582LIN" +
	"EAR A SIGN A583LINEAR A SIGN A584LINEAR A SIGN A585LINEAR A SIGN A586LIN" +
	"EAR A SIGN A587LINEAR A SIGN A588LINEAR A SIGN A589LINEAR A SIGN A591LIN" +
	"EAR A SIGN A592LINEAR A SIGN A594LINEAR A SIGN A595LINEAR A SIGN A596LIN" +
	"EAR A SIGN A598LINEAR A SIGN A600LINEAR A SIGN A601LINEAR A SIGN A602LIN" +
	"EAR A SIGN A603LINEAR A SIGN A604LINEAR A SIGN A606LINEAR A SIGN A608LIN" +
	"EAR A SIGN A609LINEAR A SIGN A610LINEAR A SIGN A611LINEAR A SIGN A612LIN" +
	"EAR A SIGN A613LINEAR A SIGN A614LINEAR A SIGN A615LINEAR A SIGN A616LIN" +
	"EAR A SIGN A617LINEAR A SIGN A618LINEAR A SIGN A619LINEAR A SIGN A620LIN" +
	"EAR A SIGN A621LINEAR A SIGN A622LINEAR A SIGN A623LINEAR A SIGN A624LIN" +
	"EAR A SIGN A626LINEAR A SIGN A627LINEAR A SIGN A628LINEAR A SIGN A629LIN" +
	"EAR A SIGN A634LINEAR A SIGN A637LINEAR A SIGN A638LINEAR A SIGN A640LIN" +
	"EAR A SIGN A642LINEAR A SIGN A643LINEAR A SIGN A644LINEAR A SIGN A645LIN" +
	"EAR A SIGN A646LINEAR A SIGN A648LINEAR A SIGN A649LINEAR A SIGN A651LIN" +
	"EAR A SIGN A652LINEAR A SIGN A653LINEAR A SIGN A654LINEAR A SIGN A655LIN" +
	"EAR A SIGN A656LINEAR A SIGN A657LINEAR A SIGN A658LINEAR A SIGN A659LIN" +
	"EAR A SIGN A660LINEAR A SIGN A661LINEAR A SIGN A662LINEAR A SIGN A663LIN" +
	"EAR A SIGN A664LINEAR A SIGN A701 ALINEAR A SIGN A702 BLINEAR A SIGN A70" +
	"3 DLINEAR A SIGN A704 ELINEAR A SIGN A705 FLINEAR A SIGN A706 HLINEAR A " +
	"SIGN A707 JLINEAR A SIGN A708 KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 " +
	"L2LINEAR A SIGN A709-3 L3LINEAR A SIGN A709-4 L4LINEAR A SIGN A709-6 L6L" +
	"INEAR A SIGN A710 WLINEAR A SIGN A711 XLINEAR A SIGN A712 YLINEAR A SIGN" +
	" A713 OMEGALINEAR A SIGN A714 ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717" +
	" DDLINEAR A SIGN A726 EYYYLINEAR A SIGN A732 JELINEAR A SIGN A800LINEAR " +
	"A SIGN A801LINEAR A SIGN A802LINEAR A SIGN A803LINEAR A SIGN A804LINEAR " +
	"A SIGN A805LINEAR A SIGN A806LINEAR A SIGN A807MODIFIER LETTER SMALL CAP" +
	"ITAL AAMODIFIER LETTER SUPERSCRIPT TRIANGULAR COLONMODIFIER LETTER SUPER" +
	"SCRIPT HALF TRIANGULAR COLONMODIFIER LETTER SMALL AEMODIFIER LETTER SMAL" +
	"L CAPITAL BMODIFIER LETTER SMALL B WITH HOOKMODIFIER LETTER SMALL DZ DIG" +
	"RAPHMODIFIER LETTER SMALL DZ DIGRAPH WITH RETROFLEX HOOKMODIFIER LETTER " +
	"SMALL DZ DIGRAPH WITH CURLMODIFIER LETTER SMALL DEZH DIGRAPHMODIFIER LET" +
	"TER SMALL D WITH TAILMODIFIER LETTER SMALL D WITH HOOKMODIFIER LETTER SM" +
	"ALL D WITH HOOK AND TAILMODIFIER LETTER SMALL REVERSED EMODIFIER LETTER " +
	"SMALL CLOSED REVERSED OPEN EMODIFIER LETTER SMALL FENG DIGRAPHMODIFIER L" +
	"ETTER SMALL RAMS HORNMODIFIER LETTER SMALL CAPITAL GMODIFIER LETTER SMAL" +
	"L G WITH HOOKMODIFIER LETTER SMALL CAPITAL G WITH HOOKMODIFIER LETTER SM" +
	"ALL H WITH STROKEMODIFIER LETTER SMALL CAPITAL HMODIFIER LETTER SMALL HE" +
	"NG WITH HOOKMODIFIER LETTER SMALL DOTLESS J WITH STROKE AND HOOKMODIFIER") + ("" +
	" LETTER SMALL LS DIGRAPHMODIFIER LETTER SMALL LZ DIGRAPHMODIFIER LETTER " +
	"SMALL L WITH BELTMODIFIER LETTER SMALL CAPITAL L WITH BELTMODIFIER LETTE" +
	"R SMALL L WITH RETROFLEX HOOK AND BELTMODIFIER LETTER SMALL LEZHMODIFIER" +
	" LETTER SMALL LEZH WITH RETROFLEX HOOKMODIFIER LETTER SMALL TURNED YMODI" +
	"FIER LETTER SMALL TURNED Y WITH BELTMODIFIER LETTER SMALL O WITH STROKEM" +
	"ODIFIER LETTER SMALL CAPITAL OEMODIFIER LETTER SMALL CLOSED OMEGAMODIFIE" +
	"R LETTER SMALL QMODIFIER LETTER SMALL TURNED R WITH LONG LEGMODIFIER LET" +
	"TER SMALL TURNED R WITH LONG LEG AND RETROFLEX HOOKMODIFIER LETTER SMALL" +
	" R WITH TAILMODIFIER LETTER SMALL R WITH FISHHOOKMODIFIER LETTER SMALL C" +
	"APITAL RMODIFIER LETTER SMALL TC DIGRAPH WITH CURLMODIFIER LETTER SMALL " +
	"TS DIGRAPHMODIFIER LETTER SMALL TS DIGRAPH WITH RETROFLEX HOOKMODIFIER L" +
	"ETTER SMALL TESH DIGRAPHMODIFIER LETTER SMALL T WITH RETROFLEX HOOKMODIF" +
	"IER LETTER SMALL V WITH RIGHT HOOKMODIFIER LETTER SMALL CAPITAL YMODIFIE" +
	"R LETTER GLOTTAL STOP WITH STROKEMODIFIER LETTER REVERSED GLOTTAL STOP W" +
	"ITH STROKEMODIFIER LETTER BILABIAL CLICKMODIFIER LETTER DENTAL CLICKMODI" +
	"FIER LETTER LATERAL CLICKMODIFIER LETTER ALVEOLAR CLICKMODIFIER LETTER R" +
	"ETROFLEX CLICK WITH RETROFLEX HOOKMODIFIER LETTER SMALL S WITH CURLCYPRI" +
	"OT SYLLABLE ACYPRIOT SYLLABLE ECYPRIOT SYLLABLE ICYPRIOT SYLLABLE OCYPRI" +
	"OT SYLLABLE UCYPRIOT SYLLABLE JACYPRIOT SYLLABLE JOCYPRIOT SYLLABLE KACY" +
	"PRIOT SYLLABLE KECYPRIOT SYLLABLE KICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE " +
	"KUCYPRIOT SYLLABLE LACYPRIOT SYLLABLE LECYPRIOT SYLLABLE LICYPRIOT SYLLA" +
	"BLE LOCYPRIOT SYLLABLE LUCYPRIOT SYLLABLE MACYPRIOT SYLLABLE MECYPRIOT S" +
	"YLLABLE MICYPRIOT SYLLABLE MOCYPRIOT SYLLABLE MUCYPRIOT SYLLABLE NACYPRI" +
	"OT SYLLABLE NECYPRIOT SYLLABLE NICYPRIOT SYLLABLE NOCYPRIOT SYLLABLE NUC" +
	"YPRIOT SYLLABLE PACYPRIOT SYLLABLE PECYPRIOT SYLLABLE PICYPRIOT SYLLABLE" +
	" POCYPRIOT SYLLABLE PUCYPRIOT SYLLABLE RACYPRIOT SYLLABLE RECYPRIOT SYLL" +
	"ABLE RICYPRIOT SYLLABLE ROCYPRIOT SYLLABLE RUCYPRIOT SYLLABLE SACYPRIOT " +
	"SYLLABLE SECYPRIOT SYLLABLE SICYPRIOT SYLLABLE SOCYPRIOT SYLLABLE SUCYPR" +
	"IOT SYLLABLE TACYPRIOT SYLLABLE TECYPRIOT SYLLABLE TICYPRIOT SYLLABLE TO" +
	"CYPRIOT SYLLABLE TUCYPRIOT SYLLABLE WACYPRIOT SYLLABLE WECYPRIOT SYLLABL" +
	"E WICYPRIOT SYLLABLE WOCYPRIOT SYLLABLE XACYPRIOT SYLLABLE XECYPRIOT SYL" +
	"LABLE ZACYPRIOT SYLLABLE ZOIMPERIAL ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC" +
	" LETTER BETHIMPERIAL ARAMAIC LETTER GIMELIMPERIAL ARAMAIC LETTER DALETHI" +
	"MPERIAL ARAMAIC LETTER HEIMPERIAL ARAMAIC LETTER WAWIMPERIAL ARAMAIC LET" +
	"TER ZAYINIMPERIAL ARAMAIC LETTER HETHIMPERIAL ARAMAIC LETTER TETHIMPERIA" +
	"L ARAMAIC LETTER YODHIMPERIAL ARAMAIC LETTER KAPHIMPERIAL ARAMAIC LETTER" +
	" LAMEDHIMPERIAL ARAMAIC LETTER MEMIMPERIAL ARAMAIC LETTER NUNIMPERIAL AR" +
	"AMAIC LETTER SAMEKHIMPERIAL ARAMAIC LETTER AYINIMPERIAL ARAMAIC LETTER P" +
	"EIMPERIAL ARAMAIC LETTER SADHEIMPERIAL ARAMAIC LETTER QOPHIMPERIAL ARAMA" +
	"IC LETTER RESHIMPERIAL ARAMAIC LETTER SHINIMPERIAL ARAMAIC LETTER TAWIMP" +
	"ERIAL ARAMAIC SECTION SIGNIMPERIAL ARAMAIC NUMBER ONEIMPERIAL ARAMAIC NU" +
	"MBER TWOIMPERIAL ARAMAIC NUMBER THREEIMPERIAL ARAMAIC NUMBER TENIMPERIAL" +
	" ARAMAIC NUMBER TWENTYIMPERIAL ARAMAIC NUMBER ONE HUNDREDIMPERIAL ARAMAI" +
	"C NUMBER ONE THOUSANDIMPERIAL ARAMAIC NUMBER TEN THOUSANDPALMYRENE LETTE" +
	"R ALEPHPALMYRENE LETTER BETHPALMYRENE LETTER GIMELPALMYRENE LETTER DALET" +
	"HPALMYRENE LETTER HEPALMYRENE LETTER WAWPALMYRENE LETTER ZAYINPALMYRENE " +
	"LETTER HETHPALMYRENE LETTER TETHPALMYRENE LETTER YODHPALMYRENE LETTER KA" +
	"PHPALMYRENE LETTER LAMEDHPALMYRENE LETTER MEMPALMYRENE LETTER FINAL NUNP" +
	"ALMYRENE LETTER NUNPALMYRENE LETTER SAMEKHPALMYRENE LETTER AYINPALMYRENE" +
	" LETTER PEPALMYRENE LETTER SADHEPALMYRENE LETTER QOPHPALMYRENE LETTER RE" +
	"SHPALMYRENE LETTER SHINPALMYRENE LETTER TAWPALMYRENE LEFT-POINTING FLEUR" +
	"ONPALMYRENE RIGHT-POINTING FLEURONPALMYRENE NUMBER ONEPALMYRENE NUMBER T" +
	"WOPALMYRENE NUMBER THREEPALMYRENE NUMBER FOURPALMYRENE NUMBER FIVEPALMYR" +
	"ENE NUMBER TENPALMYRENE NUMBER TWENTYNABATAEAN LETTER FINAL ALEPHNABATAE" +
	"AN LETTER ALEPHNABATAEAN LETTER FINAL BETHNABATAEAN LETTER BETHNABATAEAN" +
	" LETTER GIMELNABATAEAN LETTER DALETHNABATAEAN LETTER FINAL HENABATAEAN L" +
	"ETTER HENABATAEAN LETTER WAWNABATAEAN LETTER ZAYINNABATAEAN LETTER HETHN" +
	"ABATAEAN LETTER TETHNABATAEAN LETTER FINAL YODHNABATAEAN LETTER YODHNABA" +
	"TAEAN LETTER FINAL KAPHNABATAEAN LETTER KAPHNABATAEAN LETTER FINAL LAMED" +
	"HNABATAEAN LETTER LAMEDHNABATAEAN LETTER FINAL MEMNABATAEAN LETTER MEMNA" +
	"BATAEAN LETTER FINAL NUNNABATAEAN LETTER NUNNABATAEAN LETTER SAMEKHNABAT" +
	"AEAN LETTER AYINNABATAEAN LETTER PENABATAEAN LETTER SADHENABATAEAN LETTE" +
	"R QOPHNABATAEAN LETTER RESHNABATAEAN LETTER FINAL SHINNABATAEAN LETTER S" +
	"HINNABATAEAN LETTER TAWNABATAEAN NUMBER ONENABATAEAN NUMBER TWONABATAEAN") + ("" +
	" NUMBER THREENABATAEAN NUMBER FOURNABATAEAN CRUCIFORM NUMBER FOURNABATAE" +
	"AN NUMBER FIVENABATAEAN NUMBER TENNABATAEAN NUMBER TWENTYNABATAEAN NUMBE" +
	"R ONE HUNDREDHATRAN LETTER ALEPHHATRAN LETTER BETHHATRAN LETTER GIMELHAT" +
	"RAN LETTER DALETH-RESHHATRAN LETTER HEHATRAN LETTER WAWHATRAN LETTER ZAY" +
	"NHATRAN LETTER HETHHATRAN LETTER TETHHATRAN LETTER YODHHATRAN LETTER KAP" +
	"HHATRAN LETTER LAMEDHHATRAN LETTER MEMHATRAN LETTER NUNHATRAN LETTER SAM" +
	"EKHHATRAN LETTER AYNHATRAN LETTER PEHATRAN LETTER SADHEHATRAN LETTER QOP" +
	"HHATRAN LETTER SHINHATRAN LETTER TAWHATRAN NUMBER ONEHATRAN NUMBER FIVEH" +
	"ATRAN NUMBER TENHATRAN NUMBER TWENTYHATRAN NUMBER ONE HUNDREDPHOENICIAN " +
	"LETTER ALFPHOENICIAN LETTER BETPHOENICIAN LETTER GAMLPHOENICIAN LETTER D" +
	"ELTPHOENICIAN LETTER HEPHOENICIAN LETTER WAUPHOENICIAN LETTER ZAIPHOENIC" +
	"IAN LETTER HETPHOENICIAN LETTER TETPHOENICIAN LETTER YODPHOENICIAN LETTE" +
	"R KAFPHOENICIAN LETTER LAMDPHOENICIAN LETTER MEMPHOENICIAN LETTER NUNPHO" +
	"ENICIAN LETTER SEMKPHOENICIAN LETTER AINPHOENICIAN LETTER PEPHOENICIAN L" +
	"ETTER SADEPHOENICIAN LETTER QOFPHOENICIAN LETTER ROSHPHOENICIAN LETTER S" +
	"HINPHOENICIAN LETTER TAUPHOENICIAN NUMBER ONEPHOENICIAN NUMBER TENPHOENI" +
	"CIAN NUMBER TWENTYPHOENICIAN NUMBER ONE HUNDREDPHOENICIAN NUMBER TWOPHOE" +
	"NICIAN NUMBER THREEPHOENICIAN WORD SEPARATORLYDIAN LETTER ALYDIAN LETTER" +
	" BLYDIAN LETTER GLYDIAN LETTER DLYDIAN LETTER ELYDIAN LETTER VLYDIAN LET" +
	"TER ILYDIAN LETTER YLYDIAN LETTER KLYDIAN LETTER LLYDIAN LETTER MLYDIAN " +
	"LETTER NLYDIAN LETTER OLYDIAN LETTER RLYDIAN LETTER SSLYDIAN LETTER TLYD" +
	"IAN LETTER ULYDIAN LETTER FLYDIAN LETTER QLYDIAN LETTER SLYDIAN LETTER T" +
	"TLYDIAN LETTER ANLYDIAN LETTER ENLYDIAN LETTER LYLYDIAN LETTER NNLYDIAN " +
	"LETTER CLYDIAN TRIANGULAR MARKMEROITIC HIEROGLYPHIC LETTER AMEROITIC HIE" +
	"ROGLYPHIC LETTER EMEROITIC HIEROGLYPHIC LETTER IMEROITIC HIEROGLYPHIC LE" +
	"TTER OMEROITIC HIEROGLYPHIC LETTER YAMEROITIC HIEROGLYPHIC LETTER WAMERO" +
	"ITIC HIEROGLYPHIC LETTER BAMEROITIC HIEROGLYPHIC LETTER BA-2MEROITIC HIE" +
	"ROGLYPHIC LETTER PAMEROITIC HIEROGLYPHIC LETTER MAMEROITIC HIEROGLYPHIC " +
	"LETTER NAMEROITIC HIEROGLYPHIC LETTER NA-2MEROITIC HIEROGLYPHIC LETTER N" +
	"EMEROITIC HIEROGLYPHIC LETTER NE-2MEROITIC HIEROGLYPHIC LETTER RAMEROITI" +
	"C HIEROGLYPHIC LETTER RA-2MEROITIC HIEROGLYPHIC LETTER LAMEROITIC HIEROG" +
	"LYPHIC LETTER KHAMEROITIC HIEROGLYPHIC LETTER HHAMEROITIC HIEROGLYPHIC L" +
	"ETTER SAMEROITIC HIEROGLYPHIC LETTER SA-2MEROITIC HIEROGLYPHIC LETTER SE" +
	"MEROITIC HIEROGLYPHIC LETTER KAMEROITIC HIEROGLYPHIC LETTER QAMEROITIC H" +
	"IEROGLYPHIC LETTER TAMEROITIC HIEROGLYPHIC LETTER TA-2MEROITIC HIEROGLYP" +
	"HIC LETTER TEMEROITIC HIEROGLYPHIC LETTER TE-2MEROITIC HIEROGLYPHIC LETT" +
	"ER TOMEROITIC HIEROGLYPHIC LETTER DAMEROITIC HIEROGLYPHIC SYMBOL VIDJMER" +
	"OITIC HIEROGLYPHIC SYMBOL VIDJ-2MEROITIC CURSIVE LETTER AMEROITIC CURSIV" +
	"E LETTER EMEROITIC CURSIVE LETTER IMEROITIC CURSIVE LETTER OMEROITIC CUR" +
	"SIVE LETTER YAMEROITIC CURSIVE LETTER WAMEROITIC CURSIVE LETTER BAMEROIT" +
	"IC CURSIVE LETTER PAMEROITIC CURSIVE LETTER MAMEROITIC CURSIVE LETTER NA" +
	"MEROITIC CURSIVE LETTER NEMEROITIC CURSIVE LETTER RAMEROITIC CURSIVE LET" +
	"TER LAMEROITIC CURSIVE LETTER KHAMEROITIC CURSIVE LETTER HHAMEROITIC CUR" +
	"SIVE LETTER SAMEROITIC CURSIVE LETTER ARCHAIC SAMEROITIC CURSIVE LETTER " +
	"SEMEROITIC CURSIVE LETTER KAMEROITIC CURSIVE LETTER QAMEROITIC CURSIVE L" +
	"ETTER TAMEROITIC CURSIVE LETTER TEMEROITIC CURSIVE LETTER TOMEROITIC CUR" +
	"SIVE LETTER DAMEROITIC CURSIVE FRACTION ELEVEN TWELFTHSMEROITIC CURSIVE " +
	"FRACTION ONE HALFMEROITIC CURSIVE LOGOGRAM RMTMEROITIC CURSIVE LOGOGRAM " +
	"IMNMEROITIC CURSIVE NUMBER ONEMEROITIC CURSIVE NUMBER TWOMEROITIC CURSIV" +
	"E NUMBER THREEMEROITIC CURSIVE NUMBER FOURMEROITIC CURSIVE NUMBER FIVEME" +
	"ROITIC CURSIVE NUMBER SIXMEROITIC CURSIVE NUMBER SEVENMEROITIC CURSIVE N" +
	"UMBER EIGHTMEROITIC CURSIVE NUMBER NINEMEROITIC CURSIVE NUMBER TENMEROIT" +
	"IC CURSIVE NUMBER TWENTYMEROITIC CURSIVE NUMBER THIRTYMEROITIC CURSIVE N" +
	"UMBER FORTYMEROITIC CURSIVE NUMBER FIFTYMEROITIC CURSIVE NUMBER SIXTYMER" +
	"OITIC CURSIVE NUMBER SEVENTYMEROITIC CURSIVE NUMBER ONE HUNDREDMEROITIC " +
	"CURSIVE NUMBER TWO HUNDREDMEROITIC CURSIVE NUMBER THREE HUNDREDMEROITIC " +
	"CURSIVE NUMBER FOUR HUNDREDMEROITIC CURSIVE NUMBER FIVE HUNDREDMEROITIC " +
	"CURSIVE NUMBER SIX HUNDREDMEROITIC CURSIVE NUMBER SEVEN HUNDREDMEROITIC " +
	"CURSIVE NUMBER EIGHT HUNDREDMEROITIC CURSIVE NUMBER NINE HUNDREDMEROITIC" +
	" CURSIVE NUMBER ONE THOUSANDMEROITIC CURSIVE NUMBER TWO THOUSANDMEROITIC" +
	" CURSIVE NUMBER THREE THOUSANDMEROITIC CURSIVE NUMBER FOUR THOUSANDMEROI" +
	"TIC CURSIVE NUMBER FIVE THOUSANDMEROITIC CURSIVE NUMBER SIX THOUSANDMERO" +
	"ITIC CURSIVE NUMBER SEVEN THOUSANDMEROITIC CURSIVE NUMBER EIGHT THOUSAND" +
	"MEROITIC CURSIVE NUMBER NINE THOUSANDMEROITIC CURSIVE NUMBER TEN THOUSAN") + ("" +
	"DMEROITIC CURSIVE NUMBER TWENTY THOUSANDMEROITIC CURSIVE NUMBER THIRTY T" +
	"HOUSANDMEROITIC CURSIVE NUMBER FORTY THOUSANDMEROITIC CURSIVE NUMBER FIF" +
	"TY THOUSANDMEROITIC CURSIVE NUMBER SIXTY THOUSANDMEROITIC CURSIVE NUMBER" +
	" SEVENTY THOUSANDMEROITIC CURSIVE NUMBER EIGHTY THOUSANDMEROITIC CURSIVE" +
	" NUMBER NINETY THOUSANDMEROITIC CURSIVE NUMBER ONE HUNDRED THOUSANDMEROI" +
	"TIC CURSIVE NUMBER TWO HUNDRED THOUSANDMEROITIC CURSIVE NUMBER THREE HUN" +
	"DRED THOUSANDMEROITIC CURSIVE NUMBER FOUR HUNDRED THOUSANDMEROITIC CURSI" +
	"VE NUMBER FIVE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER SIX HUNDRED THOUS" +
	"ANDMEROITIC CURSIVE NUMBER SEVEN HUNDRED THOUSANDMEROITIC CURSIVE NUMBER" +
	" EIGHT HUNDRED THOUSANDMEROITIC CURSIVE NUMBER NINE HUNDRED THOUSANDMERO" +
	"ITIC CURSIVE FRACTION ONE TWELFTHMEROITIC CURSIVE FRACTION TWO TWELFTHSM" +
	"EROITIC CURSIVE FRACTION THREE TWELFTHSMEROITIC CURSIVE FRACTION FOUR TW" +
	"ELFTHSMEROITIC CURSIVE FRACTION FIVE TWELFTHSMEROITIC CURSIVE FRACTION S" +
	"IX TWELFTHSMEROITIC CURSIVE FRACTION SEVEN TWELFTHSMEROITIC CURSIVE FRAC" +
	"TION EIGHT TWELFTHSMEROITIC CURSIVE FRACTION NINE TWELFTHSMEROITIC CURSI" +
	"VE FRACTION TEN TWELFTHSKHAROSHTHI LETTER AKHAROSHTHI VOWEL SIGN IKHAROS" +
	"HTHI VOWEL SIGN UKHAROSHTHI VOWEL SIGN VOCALIC RKHAROSHTHI VOWEL SIGN EK" +
	"HAROSHTHI VOWEL SIGN OKHAROSHTHI VOWEL LENGTH MARKKHAROSHTHI SIGN DOUBLE" +
	" RING BELOWKHAROSHTHI SIGN ANUSVARAKHAROSHTHI SIGN VISARGAKHAROSHTHI LET" +
	"TER KAKHAROSHTHI LETTER KHAKHAROSHTHI LETTER GAKHAROSHTHI LETTER GHAKHAR" +
	"OSHTHI LETTER CAKHAROSHTHI LETTER CHAKHAROSHTHI LETTER JAKHAROSHTHI LETT" +
	"ER NYAKHAROSHTHI LETTER TTAKHAROSHTHI LETTER TTHAKHAROSHTHI LETTER DDAKH" +
	"AROSHTHI LETTER DDHAKHAROSHTHI LETTER NNAKHAROSHTHI LETTER TAKHAROSHTHI " +
	"LETTER THAKHAROSHTHI LETTER DAKHAROSHTHI LETTER DHAKHAROSHTHI LETTER NAK" +
	"HAROSHTHI LETTER PAKHAROSHTHI LETTER PHAKHAROSHTHI LETTER BAKHAROSHTHI L" +
	"ETTER BHAKHAROSHTHI LETTER MAKHAROSHTHI LETTER YAKHAROSHTHI LETTER RAKHA" +
	"ROSHTHI LETTER LAKHAROSHTHI LETTER VAKHAROSHTHI LETTER SHAKHAROSHTHI LET" +
	"TER SSAKHAROSHTHI LETTER SAKHAROSHTHI LETTER ZAKHAROSHTHI LETTER HAKHARO" +
	"SHTHI LETTER KKAKHAROSHTHI LETTER TTTHAKHAROSHTHI LETTER TTTAKHAROSHTHI " +
	"LETTER VHAKHAROSHTHI SIGN BAR ABOVEKHAROSHTHI SIGN CAUDAKHAROSHTHI SIGN " +
	"DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI DIGIT ONEKHAROSHTHI DIGIT TWOKHAROS" +
	"HTHI DIGIT THREEKHAROSHTHI DIGIT FOURKHAROSHTHI NUMBER TENKHAROSHTHI NUM" +
	"BER TWENTYKHAROSHTHI NUMBER ONE HUNDREDKHAROSHTHI NUMBER ONE THOUSANDKHA" +
	"ROSHTHI FRACTION ONE HALFKHAROSHTHI PUNCTUATION DOTKHAROSHTHI PUNCTUATIO" +
	"N SMALL CIRCLEKHAROSHTHI PUNCTUATION CIRCLEKHAROSHTHI PUNCTUATION CRESCE" +
	"NT BARKHAROSHTHI PUNCTUATION MANGALAMKHAROSHTHI PUNCTUATION LOTUSKHAROSH" +
	"THI PUNCTUATION DANDAKHAROSHTHI PUNCTUATION DOUBLE DANDAKHAROSHTHI PUNCT" +
	"UATION LINESOLD SOUTH ARABIAN LETTER HEOLD SOUTH ARABIAN LETTER LAMEDHOL" +
	"D SOUTH ARABIAN LETTER HETHOLD SOUTH ARABIAN LETTER MEMOLD SOUTH ARABIAN" +
	" LETTER QOPHOLD SOUTH ARABIAN LETTER WAWOLD SOUTH ARABIAN LETTER SHINOLD" +
	" SOUTH ARABIAN LETTER RESHOLD SOUTH ARABIAN LETTER BETHOLD SOUTH ARABIAN" +
	" LETTER TAWOLD SOUTH ARABIAN LETTER SATOLD SOUTH ARABIAN LETTER KAPHOLD " +
	"SOUTH ARABIAN LETTER NUNOLD SOUTH ARABIAN LETTER KHETHOLD SOUTH ARABIAN " +
	"LETTER SADHEOLD SOUTH ARABIAN LETTER SAMEKHOLD SOUTH ARABIAN LETTER FEOL" +
	"D SOUTH ARABIAN LETTER ALEFOLD SOUTH ARABIAN LETTER AYNOLD SOUTH ARABIAN" +
	" LETTER DHADHEOLD SOUTH ARABIAN LETTER GIMELOLD SOUTH ARABIAN LETTER DAL" +
	"ETHOLD SOUTH ARABIAN LETTER GHAYNOLD SOUTH ARABIAN LETTER TETHOLD SOUTH " +
	"ARABIAN LETTER ZAYNOLD SOUTH ARABIAN LETTER DHALETHOLD SOUTH ARABIAN LET" +
	"TER YODHOLD SOUTH ARABIAN LETTER THAWOLD SOUTH ARABIAN LETTER THETHOLD S" +
	"OUTH ARABIAN NUMBER ONEOLD SOUTH ARABIAN NUMBER FIFTYOLD SOUTH ARABIAN N" +
	"UMERIC INDICATOROLD NORTH ARABIAN LETTER HEHOLD NORTH ARABIAN LETTER LAM" +
	"OLD NORTH ARABIAN LETTER HAHOLD NORTH ARABIAN LETTER MEEMOLD NORTH ARABI" +
	"AN LETTER QAFOLD NORTH ARABIAN LETTER WAWOLD NORTH ARABIAN LETTER ES-2OL" +
	"D NORTH ARABIAN LETTER REHOLD NORTH ARABIAN LETTER BEHOLD NORTH ARABIAN " +
	"LETTER TEHOLD NORTH ARABIAN LETTER ES-1OLD NORTH ARABIAN LETTER KAFOLD N" +
	"ORTH ARABIAN LETTER NOONOLD NORTH ARABIAN LETTER KHAHOLD NORTH ARABIAN L" +
	"ETTER SADOLD NORTH ARABIAN LETTER ES-3OLD NORTH ARABIAN LETTER FEHOLD NO" +
	"RTH ARABIAN LETTER ALEFOLD NORTH ARABIAN LETTER AINOLD NORTH ARABIAN LET" +
	"TER DADOLD NORTH ARABIAN LETTER GEEMOLD NORTH ARABIAN LETTER DALOLD NORT" +
	"H ARABIAN LETTER GHAINOLD NORTH ARABIAN LETTER TAHOLD NORTH ARABIAN LETT" +
	"ER ZAINOLD NORTH ARABIAN LETTER THALOLD NORTH ARABIAN LETTER YEHOLD NORT" +
	"H ARABIAN LETTER THEHOLD NORTH ARABIAN LETTER ZAHOLD NORTH ARABIAN NUMBE" +
	"R ONEOLD NORTH ARABIAN NUMBER TENOLD NORTH ARABIAN NUMBER TWENTYMANICHAE" +
	"AN LETTER ALEPHMANICHAEAN LETTER BETHMANICHAEAN LETTER BHETHMANICHAEAN L") + ("" +
	"ETTER GIMELMANICHAEAN LETTER GHIMELMANICHAEAN LETTER DALETHMANICHAEAN LE" +
	"TTER HEMANICHAEAN LETTER WAWMANICHAEAN SIGN UDMANICHAEAN LETTER ZAYINMAN" +
	"ICHAEAN LETTER ZHAYINMANICHAEAN LETTER JAYINMANICHAEAN LETTER JHAYINMANI" +
	"CHAEAN LETTER HETHMANICHAEAN LETTER TETHMANICHAEAN LETTER YODHMANICHAEAN" +
	" LETTER KAPHMANICHAEAN LETTER XAPHMANICHAEAN LETTER KHAPHMANICHAEAN LETT" +
	"ER LAMEDHMANICHAEAN LETTER DHAMEDHMANICHAEAN LETTER THAMEDHMANICHAEAN LE" +
	"TTER MEMMANICHAEAN LETTER NUNMANICHAEAN LETTER SAMEKHMANICHAEAN LETTER A" +
	"YINMANICHAEAN LETTER AAYINMANICHAEAN LETTER PEMANICHAEAN LETTER FEMANICH" +
	"AEAN LETTER SADHEMANICHAEAN LETTER QOPHMANICHAEAN LETTER XOPHMANICHAEAN " +
	"LETTER QHOPHMANICHAEAN LETTER RESHMANICHAEAN LETTER SHINMANICHAEAN LETTE" +
	"R SSHINMANICHAEAN LETTER TAWMANICHAEAN ABBREVIATION MARK ABOVEMANICHAEAN" +
	" ABBREVIATION MARK BELOWMANICHAEAN NUMBER ONEMANICHAEAN NUMBER FIVEMANIC" +
	"HAEAN NUMBER TENMANICHAEAN NUMBER TWENTYMANICHAEAN NUMBER ONE HUNDREDMAN" +
	"ICHAEAN PUNCTUATION STARMANICHAEAN PUNCTUATION FLEURONMANICHAEAN PUNCTUA" +
	"TION DOUBLE DOT WITHIN DOTMANICHAEAN PUNCTUATION DOT WITHIN DOTMANICHAEA" +
	"N PUNCTUATION DOTMANICHAEAN PUNCTUATION TWO DOTSMANICHAEAN PUNCTUATION L" +
	"INE FILLERAVESTAN LETTER AAVESTAN LETTER AAAVESTAN LETTER AOAVESTAN LETT" +
	"ER AAOAVESTAN LETTER ANAVESTAN LETTER AANAVESTAN LETTER AEAVESTAN LETTER" +
	" AEEAVESTAN LETTER EAVESTAN LETTER EEAVESTAN LETTER OAVESTAN LETTER OOAV" +
	"ESTAN LETTER IAVESTAN LETTER IIAVESTAN LETTER UAVESTAN LETTER UUAVESTAN " +
	"LETTER KEAVESTAN LETTER XEAVESTAN LETTER XYEAVESTAN LETTER XVEAVESTAN LE" +
	"TTER GEAVESTAN LETTER GGEAVESTAN LETTER GHEAVESTAN LETTER CEAVESTAN LETT" +
	"ER JEAVESTAN LETTER TEAVESTAN LETTER THEAVESTAN LETTER DEAVESTAN LETTER " +
	"DHEAVESTAN LETTER TTEAVESTAN LETTER PEAVESTAN LETTER FEAVESTAN LETTER BE" +
	"AVESTAN LETTER BHEAVESTAN LETTER NGEAVESTAN LETTER NGYEAVESTAN LETTER NG" +
	"VEAVESTAN LETTER NEAVESTAN LETTER NYEAVESTAN LETTER NNEAVESTAN LETTER ME" +
	"AVESTAN LETTER HMEAVESTAN LETTER YYEAVESTAN LETTER YEAVESTAN LETTER VEAV" +
	"ESTAN LETTER REAVESTAN LETTER LEAVESTAN LETTER SEAVESTAN LETTER ZEAVESTA" +
	"N LETTER SHEAVESTAN LETTER ZHEAVESTAN LETTER SHYEAVESTAN LETTER SSHEAVES" +
	"TAN LETTER HEAVESTAN ABBREVIATION MARKTINY TWO DOTS OVER ONE DOT PUNCTUA" +
	"TIONSMALL TWO DOTS OVER ONE DOT PUNCTUATIONLARGE TWO DOTS OVER ONE DOT P" +
	"UNCTUATIONLARGE ONE DOT OVER TWO DOTS PUNCTUATIONLARGE TWO RINGS OVER ON" +
	"E RING PUNCTUATIONLARGE ONE RING OVER TWO RINGS PUNCTUATIONINSCRIPTIONAL" +
	" PARTHIAN LETTER ALEPHINSCRIPTIONAL PARTHIAN LETTER BETHINSCRIPTIONAL PA" +
	"RTHIAN LETTER GIMELINSCRIPTIONAL PARTHIAN LETTER DALETHINSCRIPTIONAL PAR" +
	"THIAN LETTER HEINSCRIPTIONAL PARTHIAN LETTER WAWINSCRIPTIONAL PARTHIAN L" +
	"ETTER ZAYININSCRIPTIONAL PARTHIAN LETTER HETHINSCRIPTIONAL PARTHIAN LETT" +
	"ER TETHINSCRIPTIONAL PARTHIAN LETTER YODHINSCRIPTIONAL PARTHIAN LETTER K" +
	"APHINSCRIPTIONAL PARTHIAN LETTER LAMEDHINSCRIPTIONAL PARTHIAN LETTER MEM" +
	"INSCRIPTIONAL PARTHIAN LETTER NUNINSCRIPTIONAL PARTHIAN LETTER SAMEKHINS" +
	"CRIPTIONAL PARTHIAN LETTER AYININSCRIPTIONAL PARTHIAN LETTER PEINSCRIPTI" +
	"ONAL PARTHIAN LETTER SADHEINSCRIPTIONAL PARTHIAN LETTER QOPHINSCRIPTIONA" +
	"L PARTHIAN LETTER RESHINSCRIPTIONAL PARTHIAN LETTER SHININSCRIPTIONAL PA" +
	"RTHIAN LETTER TAWINSCRIPTIONAL PARTHIAN NUMBER ONEINSCRIPTIONAL PARTHIAN" +
	" NUMBER TWOINSCRIPTIONAL PARTHIAN NUMBER THREEINSCRIPTIONAL PARTHIAN NUM" +
	"BER FOURINSCRIPTIONAL PARTHIAN NUMBER TENINSCRIPTIONAL PARTHIAN NUMBER T" +
	"WENTYINSCRIPTIONAL PARTHIAN NUMBER ONE HUNDREDINSCRIPTIONAL PARTHIAN NUM" +
	"BER ONE THOUSANDINSCRIPTIONAL PAHLAVI LETTER ALEPHINSCRIPTIONAL PAHLAVI " +
	"LETTER BETHINSCRIPTIONAL PAHLAVI LETTER GIMELINSCRIPTIONAL PAHLAVI LETTE" +
	"R DALETHINSCRIPTIONAL PAHLAVI LETTER HEINSCRIPTIONAL PAHLAVI LETTER WAW-" +
	"AYIN-RESHINSCRIPTIONAL PAHLAVI LETTER ZAYININSCRIPTIONAL PAHLAVI LETTER " +
	"HETHINSCRIPTIONAL PAHLAVI LETTER TETHINSCRIPTIONAL PAHLAVI LETTER YODHIN" +
	"SCRIPTIONAL PAHLAVI LETTER KAPHINSCRIPTIONAL PAHLAVI LETTER LAMEDHINSCRI" +
	"PTIONAL PAHLAVI LETTER MEM-QOPHINSCRIPTIONAL PAHLAVI LETTER NUNINSCRIPTI" +
	"ONAL PAHLAVI LETTER SAMEKHINSCRIPTIONAL PAHLAVI LETTER PEINSCRIPTIONAL P" +
	"AHLAVI LETTER SADHEINSCRIPTIONAL PAHLAVI LETTER SHININSCRIPTIONAL PAHLAV" +
	"I LETTER TAWINSCRIPTIONAL PAHLAVI NUMBER ONEINSCRIPTIONAL PAHLAVI NUMBER" +
	" TWOINSCRIPTIONAL PAHLAVI NUMBER THREEINSCRIPTIONAL PAHLAVI NUMBER FOURI" +
	"NSCRIPTIONAL PAHLAVI NUMBER TENINSCRIPTIONAL PAHLAVI NUMBER TWENTYINSCRI" +
	"PTIONAL PAHLAVI NUMBER ONE HUNDREDINSCRIPTIONAL PAHLAVI NUMBER ONE THOUS" +
	"ANDPSALTER PAHLAVI LETTER ALEPHPSALTER PAHLAVI LETTER BETHPSALTER PAHLAV" +
	"I LETTER GIMELPSALTER PAHLAVI LETTER DALETHPSALTER PAHLAVI LETTER HEPSAL" +
	"TER PAHLAVI LETTER WAW-AYIN-RESHPSALTER PAHLAVI LETTER ZAYINPSALTER PAHL" +
	"AVI LETTER HETHPSALTER PAHLAVI LETTER YODHPSALTER PAHLAVI LETTER KAPHPSA") + ("" +
	"LTER PAHLAVI LETTER LAMEDHPSALTER PAHLAVI LETTER MEM-QOPHPSALTER PAHLAVI" +
	" LETTER NUNPSALTER PAHLAVI LETTER SAMEKHPSALTER PAHLAVI LETTER PEPSALTER" +
	" PAHLAVI LETTER SADHEPSALTER PAHLAVI LETTER SHINPSALTER PAHLAVI LETTER T" +
	"AWPSALTER PAHLAVI SECTION MARKPSALTER PAHLAVI TURNED SECTION MARKPSALTER" +
	" PAHLAVI FOUR DOTS WITH CROSSPSALTER PAHLAVI FOUR DOTS WITH DOTPSALTER P" +
	"AHLAVI NUMBER ONEPSALTER PAHLAVI NUMBER TWOPSALTER PAHLAVI NUMBER THREEP" +
	"SALTER PAHLAVI NUMBER FOURPSALTER PAHLAVI NUMBER TENPSALTER PAHLAVI NUMB" +
	"ER TWENTYPSALTER PAHLAVI NUMBER ONE HUNDREDOLD TURKIC LETTER ORKHON AOLD" +
	" TURKIC LETTER YENISEI AOLD TURKIC LETTER YENISEI AEOLD TURKIC LETTER OR" +
	"KHON IOLD TURKIC LETTER YENISEI IOLD TURKIC LETTER YENISEI EOLD TURKIC L" +
	"ETTER ORKHON OOLD TURKIC LETTER ORKHON OEOLD TURKIC LETTER YENISEI OEOLD" +
	" TURKIC LETTER ORKHON ABOLD TURKIC LETTER YENISEI ABOLD TURKIC LETTER OR" +
	"KHON AEBOLD TURKIC LETTER YENISEI AEBOLD TURKIC LETTER ORKHON AGOLD TURK" +
	"IC LETTER YENISEI AGOLD TURKIC LETTER ORKHON AEGOLD TURKIC LETTER YENISE" +
	"I AEGOLD TURKIC LETTER ORKHON ADOLD TURKIC LETTER YENISEI ADOLD TURKIC L" +
	"ETTER ORKHON AEDOLD TURKIC LETTER ORKHON EZOLD TURKIC LETTER YENISEI EZO" +
	"LD TURKIC LETTER ORKHON AYOLD TURKIC LETTER YENISEI AYOLD TURKIC LETTER " +
	"ORKHON AEYOLD TURKIC LETTER YENISEI AEYOLD TURKIC LETTER ORKHON AEKOLD T" +
	"URKIC LETTER YENISEI AEKOLD TURKIC LETTER ORKHON OEKOLD TURKIC LETTER YE" +
	"NISEI OEKOLD TURKIC LETTER ORKHON ALOLD TURKIC LETTER YENISEI ALOLD TURK" +
	"IC LETTER ORKHON AELOLD TURKIC LETTER ORKHON ELTOLD TURKIC LETTER ORKHON" +
	" EMOLD TURKIC LETTER ORKHON ANOLD TURKIC LETTER ORKHON AENOLD TURKIC LET" +
	"TER YENISEI AENOLD TURKIC LETTER ORKHON ENTOLD TURKIC LETTER YENISEI ENT" +
	"OLD TURKIC LETTER ORKHON ENCOLD TURKIC LETTER YENISEI ENCOLD TURKIC LETT" +
	"ER ORKHON ENYOLD TURKIC LETTER YENISEI ENYOLD TURKIC LETTER YENISEI ANGO" +
	"LD TURKIC LETTER ORKHON ENGOLD TURKIC LETTER YENISEI AENGOLD TURKIC LETT" +
	"ER ORKHON EPOLD TURKIC LETTER ORKHON OPOLD TURKIC LETTER ORKHON ICOLD TU" +
	"RKIC LETTER ORKHON ECOLD TURKIC LETTER YENISEI ECOLD TURKIC LETTER ORKHO" +
	"N AQOLD TURKIC LETTER YENISEI AQOLD TURKIC LETTER ORKHON IQOLD TURKIC LE" +
	"TTER YENISEI IQOLD TURKIC LETTER ORKHON OQOLD TURKIC LETTER YENISEI OQOL" +
	"D TURKIC LETTER ORKHON AROLD TURKIC LETTER YENISEI AROLD TURKIC LETTER O" +
	"RKHON AEROLD TURKIC LETTER ORKHON ASOLD TURKIC LETTER ORKHON AESOLD TURK" +
	"IC LETTER ORKHON ASHOLD TURKIC LETTER YENISEI ASHOLD TURKIC LETTER ORKHO" +
	"N ESHOLD TURKIC LETTER YENISEI ESHOLD TURKIC LETTER ORKHON ATOLD TURKIC " +
	"LETTER YENISEI ATOLD TURKIC LETTER ORKHON AETOLD TURKIC LETTER YENISEI A" +
	"ETOLD TURKIC LETTER ORKHON OTOLD TURKIC LETTER ORKHON BASHOLD HUNGARIAN " +
	"CAPITAL LETTER AOLD HUNGARIAN CAPITAL LETTER AAOLD HUNGARIAN CAPITAL LET" +
	"TER EBOLD HUNGARIAN CAPITAL LETTER AMBOLD HUNGARIAN CAPITAL LETTER ECOLD" +
	" HUNGARIAN CAPITAL LETTER ENCOLD HUNGARIAN CAPITAL LETTER ECSOLD HUNGARI" +
	"AN CAPITAL LETTER EDOLD HUNGARIAN CAPITAL LETTER ANDOLD HUNGARIAN CAPITA" +
	"L LETTER EOLD HUNGARIAN CAPITAL LETTER CLOSE EOLD HUNGARIAN CAPITAL LETT" +
	"ER EEOLD HUNGARIAN CAPITAL LETTER EFOLD HUNGARIAN CAPITAL LETTER EGOLD H" +
	"UNGARIAN CAPITAL LETTER EGYOLD HUNGARIAN CAPITAL LETTER EHOLD HUNGARIAN " +
	"CAPITAL LETTER IOLD HUNGARIAN CAPITAL LETTER IIOLD HUNGARIAN CAPITAL LET" +
	"TER EJOLD HUNGARIAN CAPITAL LETTER EKOLD HUNGARIAN CAPITAL LETTER AKOLD " +
	"HUNGARIAN CAPITAL LETTER UNKOLD HUNGARIAN CAPITAL LETTER ELOLD HUNGARIAN" +
	" CAPITAL LETTER ELYOLD HUNGARIAN CAPITAL LETTER EMOLD HUNGARIAN CAPITAL " +
	"LETTER ENOLD HUNGARIAN CAPITAL LETTER ENYOLD HUNGARIAN CAPITAL LETTER OO" +
	"LD HUNGARIAN CAPITAL LETTER OOOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE" +
	"OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OEOLD HUNGARIAN CAPITAL LETTER OE" +
	"EOLD HUNGARIAN CAPITAL LETTER EPOLD HUNGARIAN CAPITAL LETTER EMPOLD HUNG" +
	"ARIAN CAPITAL LETTER EROLD HUNGARIAN CAPITAL LETTER SHORT EROLD HUNGARIA" +
	"N CAPITAL LETTER ESOLD HUNGARIAN CAPITAL LETTER ESZOLD HUNGARIAN CAPITAL" +
	" LETTER ETOLD HUNGARIAN CAPITAL LETTER ENTOLD HUNGARIAN CAPITAL LETTER E" +
	"TYOLD HUNGARIAN CAPITAL LETTER ECHOLD HUNGARIAN CAPITAL LETTER UOLD HUNG" +
	"ARIAN CAPITAL LETTER UUOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UEOLD HUN" +
	"GARIAN CAPITAL LETTER RUDIMENTA UEOLD HUNGARIAN CAPITAL LETTER EVOLD HUN" +
	"GARIAN CAPITAL LETTER EZOLD HUNGARIAN CAPITAL LETTER EZSOLD HUNGARIAN CA" +
	"PITAL LETTER ENT-SHAPED SIGNOLD HUNGARIAN CAPITAL LETTER USOLD HUNGARIAN" +
	" SMALL LETTER AOLD HUNGARIAN SMALL LETTER AAOLD HUNGARIAN SMALL LETTER E" +
	"BOLD HUNGARIAN SMALL LETTER AMBOLD HUNGARIAN SMALL LETTER ECOLD HUNGARIA" +
	"N SMALL LETTER ENCOLD HUNGARIAN SMALL LETTER ECSOLD HUNGARIAN SMALL LETT" +
	"ER EDOLD HUNGARIAN SMALL LETTER ANDOLD HUNGARIAN SMALL LETTER EOLD HUNGA" +
	"RIAN SMALL LETTER CLOSE EOLD HUNGARIAN SMALL LETTER EEOLD HUNGARIAN SMAL") + ("" +
	"L LETTER EFOLD HUNGARIAN SMALL LETTER EGOLD HUNGARIAN SMALL LETTER EGYOL" +
	"D HUNGARIAN SMALL LETTER EHOLD HUNGARIAN SMALL LETTER IOLD HUNGARIAN SMA" +
	"LL LETTER IIOLD HUNGARIAN SMALL LETTER EJOLD HUNGARIAN SMALL LETTER EKOL" +
	"D HUNGARIAN SMALL LETTER AKOLD HUNGARIAN SMALL LETTER UNKOLD HUNGARIAN S" +
	"MALL LETTER ELOLD HUNGARIAN SMALL LETTER ELYOLD HUNGARIAN SMALL LETTER E" +
	"MOLD HUNGARIAN SMALL LETTER ENOLD HUNGARIAN SMALL LETTER ENYOLD HUNGARIA" +
	"N SMALL LETTER OOLD HUNGARIAN SMALL LETTER OOOLD HUNGARIAN SMALL LETTER " +
	"NIKOLSBURG OEOLD HUNGARIAN SMALL LETTER RUDIMENTA OEOLD HUNGARIAN SMALL " +
	"LETTER OEEOLD HUNGARIAN SMALL LETTER EPOLD HUNGARIAN SMALL LETTER EMPOLD" +
	" HUNGARIAN SMALL LETTER EROLD HUNGARIAN SMALL LETTER SHORT EROLD HUNGARI" +
	"AN SMALL LETTER ESOLD HUNGARIAN SMALL LETTER ESZOLD HUNGARIAN SMALL LETT" +
	"ER ETOLD HUNGARIAN SMALL LETTER ENTOLD HUNGARIAN SMALL LETTER ETYOLD HUN" +
	"GARIAN SMALL LETTER ECHOLD HUNGARIAN SMALL LETTER UOLD HUNGARIAN SMALL L" +
	"ETTER UUOLD HUNGARIAN SMALL LETTER NIKOLSBURG UEOLD HUNGARIAN SMALL LETT" +
	"ER RUDIMENTA UEOLD HUNGARIAN SMALL LETTER EVOLD HUNGARIAN SMALL LETTER E" +
	"ZOLD HUNGARIAN SMALL LETTER EZSOLD HUNGARIAN SMALL LETTER ENT-SHAPED SIG" +
	"NOLD HUNGARIAN SMALL LETTER USOLD HUNGARIAN NUMBER ONEOLD HUNGARIAN NUMB" +
	"ER FIVEOLD HUNGARIAN NUMBER TENOLD HUNGARIAN NUMBER FIFTYOLD HUNGARIAN N" +
	"UMBER ONE HUNDREDOLD HUNGARIAN NUMBER ONE THOUSANDHANIFI ROHINGYA LETTER" +
	" AHANIFI ROHINGYA LETTER BAHANIFI ROHINGYA LETTER PAHANIFI ROHINGYA LETT" +
	"ER TAHANIFI ROHINGYA LETTER TTAHANIFI ROHINGYA LETTER JAHANIFI ROHINGYA " +
	"LETTER CAHANIFI ROHINGYA LETTER HAHANIFI ROHINGYA LETTER KHAHANIFI ROHIN" +
	"GYA LETTER FAHANIFI ROHINGYA LETTER DAHANIFI ROHINGYA LETTER DDAHANIFI R" +
	"OHINGYA LETTER RAHANIFI ROHINGYA LETTER RRAHANIFI ROHINGYA LETTER ZAHANI" +
	"FI ROHINGYA LETTER SAHANIFI ROHINGYA LETTER SHAHANIFI ROHINGYA LETTER KA" +
	"HANIFI ROHINGYA LETTER GAHANIFI ROHINGYA LETTER LAHANIFI ROHINGYA LETTER" +
	" MAHANIFI ROHINGYA LETTER NAHANIFI ROHINGYA LETTER WAHANIFI ROHINGYA LET" +
	"TER KINNA WAHANIFI ROHINGYA LETTER YAHANIFI ROHINGYA LETTER KINNA YAHANI" +
	"FI ROHINGYA LETTER NGAHANIFI ROHINGYA LETTER NYAHANIFI ROHINGYA LETTER V" +
	"AHANIFI ROHINGYA VOWEL AHANIFI ROHINGYA VOWEL IHANIFI ROHINGYA VOWEL UHA" +
	"NIFI ROHINGYA VOWEL EHANIFI ROHINGYA VOWEL OHANIFI ROHINGYA MARK SAKINHA" +
	"NIFI ROHINGYA MARK NA KHONNAHANIFI ROHINGYA SIGN HARBAHAYHANIFI ROHINGYA" +
	" SIGN TAHALAHANIFI ROHINGYA SIGN TANAHANIFI ROHINGYA SIGN TASSIHANIFI RO" +
	"HINGYA DIGIT ZEROHANIFI ROHINGYA DIGIT ONEHANIFI ROHINGYA DIGIT TWOHANIF" +
	"I ROHINGYA DIGIT THREEHANIFI ROHINGYA DIGIT FOURHANIFI ROHINGYA DIGIT FI" +
	"VEHANIFI ROHINGYA DIGIT SIXHANIFI ROHINGYA DIGIT SEVENHANIFI ROHINGYA DI" +
	"GIT EIGHTHANIFI ROHINGYA DIGIT NINERUMI DIGIT ONERUMI DIGIT TWORUMI DIGI" +
	"T THREERUMI DIGIT FOURRUMI DIGIT FIVERUMI DIGIT SIXRUMI DIGIT SEVENRUMI " +
	"DIGIT EIGHTRUMI DIGIT NINERUMI NUMBER TENRUMI NUMBER TWENTYRUMI NUMBER T" +
	"HIRTYRUMI NUMBER FORTYRUMI NUMBER FIFTYRUMI NUMBER SIXTYRUMI NUMBER SEVE" +
	"NTYRUMI NUMBER EIGHTYRUMI NUMBER NINETYRUMI NUMBER ONE HUNDREDRUMI NUMBE" +
	"R TWO HUNDREDRUMI NUMBER THREE HUNDREDRUMI NUMBER FOUR HUNDREDRUMI NUMBE" +
	"R FIVE HUNDREDRUMI NUMBER SIX HUNDREDRUMI NUMBER SEVEN HUNDREDRUMI NUMBE" +
	"R EIGHT HUNDREDRUMI NUMBER NINE HUNDREDRUMI FRACTION ONE HALFRUMI FRACTI" +
	"ON ONE QUARTERRUMI FRACTION ONE THIRDRUMI FRACTION TWO THIRDSYEZIDI LETT" +
	"ER ELIFYEZIDI LETTER BEYEZIDI LETTER PEYEZIDI LETTER PHEYEZIDI LETTER TH" +
	"EYEZIDI LETTER SEYEZIDI LETTER CIMYEZIDI LETTER CHIMYEZIDI LETTER CHHIMY" +
	"EZIDI LETTER HHAYEZIDI LETTER XAYEZIDI LETTER DALYEZIDI LETTER ZALYEZIDI" +
	" LETTER RAYEZIDI LETTER RHAYEZIDI LETTER ZAYEZIDI LETTER JAYEZIDI LETTER" +
	" SINYEZIDI LETTER SHINYEZIDI LETTER SADYEZIDI LETTER DADYEZIDI LETTER TA" +
	"YEZIDI LETTER ZEYEZIDI LETTER EYNYEZIDI LETTER XHEYNYEZIDI LETTER FAYEZI" +
	"DI LETTER VAYEZIDI LETTER VA ALTERNATE FORMYEZIDI LETTER QAFYEZIDI LETTE" +
	"R KAFYEZIDI LETTER KHAFYEZIDI LETTER GAFYEZIDI LETTER LAMYEZIDI LETTER M" +
	"IMYEZIDI LETTER NUNYEZIDI LETTER UMYEZIDI LETTER WAWYEZIDI LETTER OWYEZI" +
	"DI LETTER EWYEZIDI LETTER HAYYEZIDI LETTER YOTYEZIDI LETTER ETYEZIDI COM" +
	"BINING HAMZA MARKYEZIDI COMBINING MADDA MARKYEZIDI HYPHENATION MARKYEZID" +
	"I LETTER LAM WITH DOT ABOVEYEZIDI LETTER YOT WITH CIRCUMFLEX ABOVEARABIC" +
	" SMALL LOW WORD SAKTAARABIC SMALL LOW WORD QASRARABIC SMALL LOW WORD MAD" +
	"DAOLD SOGDIAN LETTER ALEPHOLD SOGDIAN LETTER FINAL ALEPHOLD SOGDIAN LETT" +
	"ER BETHOLD SOGDIAN LETTER FINAL BETHOLD SOGDIAN LETTER GIMELOLD SOGDIAN " +
	"LETTER HEOLD SOGDIAN LETTER FINAL HEOLD SOGDIAN LETTER WAWOLD SOGDIAN LE" +
	"TTER ZAYINOLD SOGDIAN LETTER HETHOLD SOGDIAN LETTER YODHOLD SOGDIAN LETT" +
	"ER KAPHOLD SOGDIAN LETTER LAMEDHOLD SOGDIAN LETTER MEMOLD SOGDIAN LETTER" +
	" NUNOLD SOGDIAN LETTER FINAL NUNOLD SOGDIAN LETTER FINAL NUN WITH VERTIC") + ("" +
	"AL TAILOLD SOGDIAN LETTER SAMEKHOLD SOGDIAN LETTER AYINOLD SOGDIAN LETTE" +
	"R ALTERNATE AYINOLD SOGDIAN LETTER PEOLD SOGDIAN LETTER SADHEOLD SOGDIAN" +
	" LETTER FINAL SADHEOLD SOGDIAN LETTER FINAL SADHE WITH VERTICAL TAILOLD " +
	"SOGDIAN LETTER RESH-AYIN-DALETHOLD SOGDIAN LETTER SHINOLD SOGDIAN LETTER" +
	" TAWOLD SOGDIAN LETTER FINAL TAWOLD SOGDIAN LETTER FINAL TAW WITH VERTIC" +
	"AL TAILOLD SOGDIAN NUMBER ONEOLD SOGDIAN NUMBER TWOOLD SOGDIAN NUMBER TH" +
	"REEOLD SOGDIAN NUMBER FOUROLD SOGDIAN NUMBER FIVEOLD SOGDIAN NUMBER TENO" +
	"LD SOGDIAN NUMBER TWENTYOLD SOGDIAN NUMBER THIRTYOLD SOGDIAN NUMBER ONE " +
	"HUNDREDOLD SOGDIAN FRACTION ONE HALFOLD SOGDIAN LIGATURE AYIN-DALETHSOGD" +
	"IAN LETTER ALEPHSOGDIAN LETTER BETHSOGDIAN LETTER GIMELSOGDIAN LETTER HE" +
	"SOGDIAN LETTER WAWSOGDIAN LETTER ZAYINSOGDIAN LETTER HETHSOGDIAN LETTER " +
	"YODHSOGDIAN LETTER KAPHSOGDIAN LETTER LAMEDHSOGDIAN LETTER MEMSOGDIAN LE" +
	"TTER NUNSOGDIAN LETTER SAMEKHSOGDIAN LETTER AYINSOGDIAN LETTER PESOGDIAN" +
	" LETTER SADHESOGDIAN LETTER RESH-AYINSOGDIAN LETTER SHINSOGDIAN LETTER T" +
	"AWSOGDIAN LETTER FETHSOGDIAN LETTER LESHSOGDIAN INDEPENDENT SHINSOGDIAN " +
	"COMBINING DOT BELOWSOGDIAN COMBINING TWO DOTS BELOWSOGDIAN COMBINING DOT" +
	" ABOVESOGDIAN COMBINING TWO DOTS ABOVESOGDIAN COMBINING CURVE ABOVESOGDI" +
	"AN COMBINING CURVE BELOWSOGDIAN COMBINING HOOK ABOVESOGDIAN COMBINING HO" +
	"OK BELOWSOGDIAN COMBINING LONG HOOK BELOWSOGDIAN COMBINING RESH BELOWSOG" +
	"DIAN COMBINING STROKE BELOWSOGDIAN NUMBER ONESOGDIAN NUMBER TENSOGDIAN N" +
	"UMBER TWENTYSOGDIAN NUMBER ONE HUNDREDSOGDIAN PUNCTUATION TWO VERTICAL B" +
	"ARSSOGDIAN PUNCTUATION TWO VERTICAL BARS WITH DOTSSOGDIAN PUNCTUATION CI" +
	"RCLE WITH DOTSOGDIAN PUNCTUATION TWO CIRCLES WITH DOTSSOGDIAN PUNCTUATIO" +
	"N HALF CIRCLE WITH DOTOLD UYGHUR LETTER ALEPHOLD UYGHUR LETTER BETHOLD U" +
	"YGHUR LETTER GIMEL-HETHOLD UYGHUR LETTER WAWOLD UYGHUR LETTER ZAYINOLD U" +
	"YGHUR LETTER FINAL HETHOLD UYGHUR LETTER YODHOLD UYGHUR LETTER KAPHOLD U" +
	"YGHUR LETTER LAMEDHOLD UYGHUR LETTER MEMOLD UYGHUR LETTER NUNOLD UYGHUR " +
	"LETTER SAMEKHOLD UYGHUR LETTER PEOLD UYGHUR LETTER SADHEOLD UYGHUR LETTE" +
	"R RESHOLD UYGHUR LETTER SHINOLD UYGHUR LETTER TAWOLD UYGHUR LETTER LESHO" +
	"LD UYGHUR COMBINING DOT ABOVEOLD UYGHUR COMBINING DOT BELOWOLD UYGHUR CO" +
	"MBINING TWO DOTS ABOVEOLD UYGHUR COMBINING TWO DOTS BELOWOLD UYGHUR PUNC" +
	"TUATION BAROLD UYGHUR PUNCTUATION TWO BARSOLD UYGHUR PUNCTUATION TWO DOT" +
	"SOLD UYGHUR PUNCTUATION FOUR DOTSCHORASMIAN LETTER ALEPHCHORASMIAN LETTE" +
	"R SMALL ALEPHCHORASMIAN LETTER BETHCHORASMIAN LETTER GIMELCHORASMIAN LET" +
	"TER DALETHCHORASMIAN LETTER HECHORASMIAN LETTER WAWCHORASMIAN LETTER CUR" +
	"LED WAWCHORASMIAN LETTER ZAYINCHORASMIAN LETTER HETHCHORASMIAN LETTER YO" +
	"DHCHORASMIAN LETTER KAPHCHORASMIAN LETTER LAMEDHCHORASMIAN LETTER MEMCHO" +
	"RASMIAN LETTER NUNCHORASMIAN LETTER SAMEKHCHORASMIAN LETTER AYINCHORASMI" +
	"AN LETTER PECHORASMIAN LETTER RESHCHORASMIAN LETTER SHINCHORASMIAN LETTE" +
	"R TAWCHORASMIAN NUMBER ONECHORASMIAN NUMBER TWOCHORASMIAN NUMBER THREECH" +
	"ORASMIAN NUMBER FOURCHORASMIAN NUMBER TENCHORASMIAN NUMBER TWENTYCHORASM" +
	"IAN NUMBER ONE HUNDREDELYMAIC LETTER ALEPHELYMAIC LETTER BETHELYMAIC LET" +
	"TER GIMELELYMAIC LETTER DALETHELYMAIC LETTER HEELYMAIC LETTER WAWELYMAIC" +
	" LETTER ZAYINELYMAIC LETTER HETHELYMAIC LETTER TETHELYMAIC LETTER YODHEL" +
	"YMAIC LETTER KAPHELYMAIC LETTER LAMEDHELYMAIC LETTER MEMELYMAIC LETTER N" +
	"UNELYMAIC LETTER SAMEKHELYMAIC LETTER AYINELYMAIC LETTER PEELYMAIC LETTE" +
	"R SADHEELYMAIC LETTER QOPHELYMAIC LETTER RESHELYMAIC LETTER SHINELYMAIC " +
	"LETTER TAWELYMAIC LIGATURE ZAYIN-YODHBRAHMI SIGN CANDRABINDUBRAHMI SIGN " +
	"ANUSVARABRAHMI SIGN VISARGABRAHMI SIGN JIHVAMULIYABRAHMI SIGN UPADHMANIY" +
	"ABRAHMI LETTER ABRAHMI LETTER AABRAHMI LETTER IBRAHMI LETTER IIBRAHMI LE" +
	"TTER UBRAHMI LETTER UUBRAHMI LETTER VOCALIC RBRAHMI LETTER VOCALIC RRBRA" +
	"HMI LETTER VOCALIC LBRAHMI LETTER VOCALIC LLBRAHMI LETTER EBRAHMI LETTER" +
	" AIBRAHMI LETTER OBRAHMI LETTER AUBRAHMI LETTER KABRAHMI LETTER KHABRAHM" +
	"I LETTER GABRAHMI LETTER GHABRAHMI LETTER NGABRAHMI LETTER CABRAHMI LETT" +
	"ER CHABRAHMI LETTER JABRAHMI LETTER JHABRAHMI LETTER NYABRAHMI LETTER TT" +
	"ABRAHMI LETTER TTHABRAHMI LETTER DDABRAHMI LETTER DDHABRAHMI LETTER NNAB" +
	"RAHMI LETTER TABRAHMI LETTER THABRAHMI LETTER DABRAHMI LETTER DHABRAHMI " +
	"LETTER NABRAHMI LETTER PABRAHMI LETTER PHABRAHMI LETTER BABRAHMI LETTER " +
	"BHABRAHMI LETTER MABRAHMI LETTER YABRAHMI LETTER RABRAHMI LETTER LABRAHM" +
	"I LETTER VABRAHMI LETTER SHABRAHMI LETTER SSABRAHMI LETTER SABRAHMI LETT" +
	"ER HABRAHMI LETTER LLABRAHMI LETTER OLD TAMIL LLLABRAHMI LETTER OLD TAMI" +
	"L RRABRAHMI LETTER OLD TAMIL NNNABRAHMI VOWEL SIGN AABRAHMI VOWEL SIGN B" +
	"HATTIPROLU AABRAHMI VOWEL SIGN IBRAHMI VOWEL SIGN IIBRAHMI VOWEL SIGN UB" +
	"RAHMI VOWEL SIGN UUBRAHMI VOWEL SIGN VOCALIC RBRAHMI VOWEL SIGN VOCALIC ") + ("" +
	"RRBRAHMI VOWEL SIGN VOCALIC LBRAHMI VOWEL SIGN VOCALIC LLBRAHMI VOWEL SI" +
	"GN EBRAHMI VOWEL SIGN AIBRAHMI VOWEL SIGN OBRAHMI VOWEL SIGN AUBRAHMI VI" +
	"RAMABRAHMI DANDABRAHMI DOUBLE DANDABRAHMI PUNCTUATION DOTBRAHMI PUNCTUAT" +
	"ION DOUBLE DOTBRAHMI PUNCTUATION LINEBRAHMI PUNCTUATION CRESCENT BARBRAH" +
	"MI PUNCTUATION LOTUSBRAHMI NUMBER ONEBRAHMI NUMBER TWOBRAHMI NUMBER THRE" +
	"EBRAHMI NUMBER FOURBRAHMI NUMBER FIVEBRAHMI NUMBER SIXBRAHMI NUMBER SEVE" +
	"NBRAHMI NUMBER EIGHTBRAHMI NUMBER NINEBRAHMI NUMBER TENBRAHMI NUMBER TWE" +
	"NTYBRAHMI NUMBER THIRTYBRAHMI NUMBER FORTYBRAHMI NUMBER FIFTYBRAHMI NUMB" +
	"ER SIXTYBRAHMI NUMBER SEVENTYBRAHMI NUMBER EIGHTYBRAHMI NUMBER NINETYBRA" +
	"HMI NUMBER ONE HUNDREDBRAHMI NUMBER ONE THOUSANDBRAHMI DIGIT ZEROBRAHMI " +
	"DIGIT ONEBRAHMI DIGIT TWOBRAHMI DIGIT THREEBRAHMI DIGIT FOURBRAHMI DIGIT" +
	" FIVEBRAHMI DIGIT SIXBRAHMI DIGIT SEVENBRAHMI DIGIT EIGHTBRAHMI DIGIT NI" +
	"NEBRAHMI SIGN OLD TAMIL VIRAMABRAHMI LETTER OLD TAMIL SHORT EBRAHMI LETT" +
	"ER OLD TAMIL SHORT OBRAHMI VOWEL SIGN OLD TAMIL SHORT EBRAHMI VOWEL SIGN" +
	" OLD TAMIL SHORT OBRAHMI LETTER OLD TAMIL LLABRAHMI NUMBER JOINERKAITHI " +
	"SIGN CANDRABINDUKAITHI SIGN ANUSVARAKAITHI SIGN VISARGAKAITHI LETTER AKA" +
	"ITHI LETTER AAKAITHI LETTER IKAITHI LETTER IIKAITHI LETTER UKAITHI LETTE" +
	"R UUKAITHI LETTER EKAITHI LETTER AIKAITHI LETTER OKAITHI LETTER AUKAITHI" +
	" LETTER KAKAITHI LETTER KHAKAITHI LETTER GAKAITHI LETTER GHAKAITHI LETTE" +
	"R NGAKAITHI LETTER CAKAITHI LETTER CHAKAITHI LETTER JAKAITHI LETTER JHAK" +
	"AITHI LETTER NYAKAITHI LETTER TTAKAITHI LETTER TTHAKAITHI LETTER DDAKAIT" +
	"HI LETTER DDDHAKAITHI LETTER DDHAKAITHI LETTER RHAKAITHI LETTER NNAKAITH" +
	"I LETTER TAKAITHI LETTER THAKAITHI LETTER DAKAITHI LETTER DHAKAITHI LETT" +
	"ER NAKAITHI LETTER PAKAITHI LETTER PHAKAITHI LETTER BAKAITHI LETTER BHAK" +
	"AITHI LETTER MAKAITHI LETTER YAKAITHI LETTER RAKAITHI LETTER LAKAITHI LE" +
	"TTER VAKAITHI LETTER SHAKAITHI LETTER SSAKAITHI LETTER SAKAITHI LETTER H" +
	"AKAITHI VOWEL SIGN AAKAITHI VOWEL SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL" +
	" SIGN UKAITHI VOWEL SIGN UUKAITHI VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI" +
	" VOWEL SIGN OKAITHI VOWEL SIGN AUKAITHI SIGN VIRAMAKAITHI SIGN NUKTAKAIT" +
	"HI ABBREVIATION SIGNKAITHI ENUMERATION SIGNKAITHI NUMBER SIGNKAITHI SECT" +
	"ION MARKKAITHI DOUBLE SECTION MARKKAITHI DANDAKAITHI DOUBLE DANDAKAITHI " +
	"VOWEL SIGN VOCALIC RKAITHI NUMBER SIGN ABOVESORA SOMPENG LETTER SAHSORA " +
	"SOMPENG LETTER TAHSORA SOMPENG LETTER BAHSORA SOMPENG LETTER CAHSORA SOM" +
	"PENG LETTER DAHSORA SOMPENG LETTER GAHSORA SOMPENG LETTER MAHSORA SOMPEN" +
	"G LETTER NGAHSORA SOMPENG LETTER LAHSORA SOMPENG LETTER NAHSORA SOMPENG " +
	"LETTER VAHSORA SOMPENG LETTER PAHSORA SOMPENG LETTER YAHSORA SOMPENG LET" +
	"TER RAHSORA SOMPENG LETTER HAHSORA SOMPENG LETTER KAHSORA SOMPENG LETTER" +
	" JAHSORA SOMPENG LETTER NYAHSORA SOMPENG LETTER AHSORA SOMPENG LETTER EE" +
	"HSORA SOMPENG LETTER IHSORA SOMPENG LETTER UHSORA SOMPENG LETTER OHSORA " +
	"SOMPENG LETTER EHSORA SOMPENG LETTER MAESORA SOMPENG DIGIT ZEROSORA SOMP" +
	"ENG DIGIT ONESORA SOMPENG DIGIT TWOSORA SOMPENG DIGIT THREESORA SOMPENG " +
	"DIGIT FOURSORA SOMPENG DIGIT FIVESORA SOMPENG DIGIT SIXSORA SOMPENG DIGI" +
	"T SEVENSORA SOMPENG DIGIT EIGHTSORA SOMPENG DIGIT NINECHAKMA SIGN CANDRA" +
	"BINDUCHAKMA SIGN ANUSVARACHAKMA SIGN VISARGACHAKMA LETTER AACHAKMA LETTE" +
	"R ICHAKMA LETTER UCHAKMA LETTER ECHAKMA LETTER KAACHAKMA LETTER KHAACHAK" +
	"MA LETTER GAACHAKMA LETTER GHAACHAKMA LETTER NGAACHAKMA LETTER CAACHAKMA" +
	" LETTER CHAACHAKMA LETTER JAACHAKMA LETTER JHAACHAKMA LETTER NYAACHAKMA " +
	"LETTER TTAACHAKMA LETTER TTHAACHAKMA LETTER DDAACHAKMA LETTER DDHAACHAKM" +
	"A LETTER NNAACHAKMA LETTER TAACHAKMA LETTER THAACHAKMA LETTER DAACHAKMA " +
	"LETTER DHAACHAKMA LETTER NAACHAKMA LETTER PAACHAKMA LETTER PHAACHAKMA LE" +
	"TTER BAACHAKMA LETTER BHAACHAKMA LETTER MAACHAKMA LETTER YYAACHAKMA LETT" +
	"ER YAACHAKMA LETTER RAACHAKMA LETTER LAACHAKMA LETTER WAACHAKMA LETTER S" +
	"AACHAKMA LETTER HAACHAKMA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAKMA VOWEL SI" +
	"GN IICHAKMA VOWEL SIGN UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN ECHAKMA VO" +
	"WEL SIGN AICHAKMA VOWEL SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWEL SIGN OICH" +
	"AKMA O MARKCHAKMA AU MARKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DIGIT ZEROCHA" +
	"KMA DIGIT ONECHAKMA DIGIT TWOCHAKMA DIGIT THREECHAKMA DIGIT FOURCHAKMA D" +
	"IGIT FIVECHAKMA DIGIT SIXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHTCHAKMA DIGI" +
	"T NINECHAKMA SECTION MARKCHAKMA DANDACHAKMA DOUBLE DANDACHAKMA QUESTION " +
	"MARKCHAKMA LETTER LHAACHAKMA VOWEL SIGN AACHAKMA VOWEL SIGN EICHAKMA LET" +
	"TER VAAMAHAJANI LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTE" +
	"R EMAHAJANI LETTER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER" +
	" GAMAHAJANI LETTER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETT" +
	"ER JAMAHAJANI LETTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI L") + ("" +
	"ETTER TTHAMAHAJANI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHA" +
	"JANI LETTER TAMAHAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMA" +
	"HAJANI LETTER NAMAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAM" +
	"AHAJANI LETTER BHAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LA" +
	"MAHAJANI LETTER VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RR" +
	"AMAHAJANI SIGN NUKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJ" +
	"ANI LIGATURE SHRISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SI" +
	"GN VISARGASHARADA LETTER ASHARADA LETTER AASHARADA LETTER ISHARADA LETTE" +
	"R IISHARADA LETTER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LET" +
	"TER VOCALIC RRSHARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA L" +
	"ETTER ESHARADA LETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER " +
	"KASHARADA LETTER KHASHARADA LETTER GASHARADA LETTER GHASHARADA LETTER NG" +
	"ASHARADA LETTER CASHARADA LETTER CHASHARADA LETTER JASHARADA LETTER JHAS" +
	"HARADA LETTER NYASHARADA LETTER TTASHARADA LETTER TTHASHARADA LETTER DDA" +
	"SHARADA LETTER DDHASHARADA LETTER NNASHARADA LETTER TASHARADA LETTER THA" +
	"SHARADA LETTER DASHARADA LETTER DHASHARADA LETTER NASHARADA LETTER PASHA" +
	"RADA LETTER PHASHARADA LETTER BASHARADA LETTER BHASHARADA LETTER MASHARA" +
	"DA LETTER YASHARADA LETTER RASHARADA LETTER LASHARADA LETTER LLASHARADA " +
	"LETTER VASHARADA LETTER SHASHARADA LETTER SSASHARADA LETTER SASHARADA LE" +
	"TTER HASHARADA VOWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHA" +
	"RADA VOWEL SIGN USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARAD" +
	"A VOWEL SIGN VOCALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VO" +
	"CALIC LLSHARADA VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHA" +
	"RADA VOWEL SIGN AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN J" +
	"IHVAMULIYASHARADA SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE " +
	"DANDASHARADA ABBREVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARAD" +
	"A SIGN NUKTASHARADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHA" +
	"RADA SUTRA MARKSHARADA VOWEL SIGN PRISHTHAMATRA ESHARADA SIGN INVERTED C" +
	"ANDRABINDUSHARADA DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DI" +
	"GIT THREESHARADA DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DI" +
	"GIT SEVENSHARADA DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN S" +
	"IDDHAMSHARADA HEADSTROKESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1S" +
	"HARADA SECTION MARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOS" +
	"INHALA ARCHAIC DIGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGI" +
	"T FIVESINHALA ARCHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAI" +
	"C DIGIT EIGHTSINHALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA" +
	" ARCHAIC NUMBER TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBE" +
	"R FORTYSINHALA ARCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA A" +
	"RCHAIC NUMBER SEVENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER" +
	" NINETYSINHALA ARCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOU" +
	"SANDKHOJKI LETTER AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI " +
	"LETTER EKHOJKI LETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAK" +
	"HOJKI LETTER KHAKHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI" +
	" LETTER NGAKHOJKI LETTER CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTE" +
	"R JJAKHOJKI LETTER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER D" +
	"DAKHOJKI LETTER DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKH" +
	"OJKI LETTER DAKHOJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI " +
	"LETTER PAKHOJKI LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER" +
	" BHAKHOJKI LETTER MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJ" +
	"KI LETTER VAKHOJKI LETTER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWE" +
	"L SIGN AAKHOJKI VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJK" +
	"I VOWEL SIGN EKHOJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN A" +
	"UKHOJKI SIGN ANUSVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHAD" +
	"DAKHOJKI DANDAKHOJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MAR" +
	"KKHOJKI DOUBLE SECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNKHOJ" +
	"KI LETTER QAKHOJKI LETTER SHORT IKHOJKI VOWEL SIGN VOCALIC RMULTANI LETT" +
	"ER AMULTANI LETTER IMULTANI LETTER UMULTANI LETTER EMULTANI LETTER KAMUL" +
	"TANI LETTER KHAMULTANI LETTER GAMULTANI LETTER GHAMULTANI LETTER CAMULTA" +
	"NI LETTER CHAMULTANI LETTER JAMULTANI LETTER JJAMULTANI LETTER NYAMULTAN" +
	"I LETTER TTAMULTANI LETTER TTHAMULTANI LETTER DDAMULTANI LETTER DDDAMULT" +
	"ANI LETTER DDHAMULTANI LETTER NNAMULTANI LETTER TAMULTANI LETTER THAMULT" +
	"ANI LETTER DAMULTANI LETTER DHAMULTANI LETTER NAMULTANI LETTER PAMULTANI" +
	" LETTER PHAMULTANI LETTER BAMULTANI LETTER BHAMULTANI LETTER MAMULTANI L" +
	"ETTER YAMULTANI LETTER RAMULTANI LETTER LAMULTANI LETTER VAMULTANI LETTE") + ("" +
	"R SAMULTANI LETTER HAMULTANI LETTER RRAMULTANI LETTER RHAMULTANI SECTION" +
	" MARKKHUDAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDAWADI LE" +
	"TTER IIKHUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHUDAWADI " +
	"LETTER AIKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDAWADI LETTER KAKHUDAWA" +
	"DI LETTER KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LETTER GHA" +
	"KHUDAWADI LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAWADI LET" +
	"TER JAKHUDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NYAKHUDAW" +
	"ADI LETTER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI LETTER " +
	"DDDAKHUDAWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNAKHUDAWA" +
	"DI LETTER TAKHUDAWADI LETTER THAKHUDAWADI LETTER DAKHUDAWADI LETTER DHAK" +
	"HUDAWADI LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETTER PHAKHUDAWADI LETTE" +
	"R BAKHUDAWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKHUDAWADI" +
	" LETTER YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHUDAWADI LETTER VAKHUDA" +
	"WADI LETTER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER HAKHUDAWADI SIGN ANUS" +
	"VARAKHUDAWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL SIGN II" +
	"KHUDAWADI VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN EKHUDA" +
	"WADI VOWEL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKHUDAWADI" +
	" SIGN NUKTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIGIT ONEK" +
	"HUDAWADI DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAWADI DIG" +
	"IT FIVEKHUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EIGHTKHUD" +
	"AWADI DIGIT NINEGRANTHA SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN CANDRA" +
	"BINDUGRANTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRANTHA LE" +
	"TTER AAGRANTHA LETTER IGRANTHA LETTER IIGRANTHA LETTER UGRANTHA LETTER U" +
	"UGRANTHA LETTER VOCALIC RGRANTHA LETTER VOCALIC LGRANTHA LETTER EEGRANTH" +
	"A LETTER AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTHA LETTER KAGRANTHA LE" +
	"TTER KHAGRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRANTHA LET" +
	"TER CAGRANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LETTER JHAGRANTHA LETTE" +
	"R NYAGRANTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA LETTER DDAGRANTHA LETT" +
	"ER DDHAGRANTHA LETTER NNAGRANTHA LETTER TAGRANTHA LETTER THAGRANTHA LETT" +
	"ER DAGRANTHA LETTER DHAGRANTHA LETTER NAGRANTHA LETTER PAGRANTHA LETTER " +
	"PHAGRANTHA LETTER BAGRANTHA LETTER BHAGRANTHA LETTER MAGRANTHA LETTER YA" +
	"GRANTHA LETTER RAGRANTHA LETTER LAGRANTHA LETTER LLAGRANTHA LETTER VAGRA" +
	"NTHA LETTER SHAGRANTHA LETTER SSAGRANTHA LETTER SAGRANTHA LETTER HACOMBI" +
	"NING BINDU BELOWGRANTHA SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VOWEL SIG" +
	"N AAGRANTHA VOWEL SIGN IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN UGRANTHA" +
	" VOWEL SIGN UUGRANTHA VOWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCALIC RRG" +
	"RANTHA VOWEL SIGN EEGRANTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRANTHA VO" +
	"WEL SIGN AUGRANTHA SIGN VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRANTHA SI" +
	"GN PLUTAGRANTHA LETTER VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE ANUSVAR" +
	"AGRANTHA LETTER VOCALIC RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL SIGN VO" +
	"CALIC LGRANTHA VOWEL SIGN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROCOMBININ" +
	"G GRANTHA DIGIT ONECOMBINING GRANTHA DIGIT TWOCOMBINING GRANTHA DIGIT TH" +
	"REECOMBINING GRANTHA DIGIT FOURCOMBINING GRANTHA DIGIT FIVECOMBINING GRA" +
	"NTHA DIGIT SIXCOMBINING GRANTHA LETTER ACOMBINING GRANTHA LETTER KACOMBI" +
	"NING GRANTHA LETTER NACOMBINING GRANTHA LETTER VICOMBINING GRANTHA LETTE" +
	"R PANEWA LETTER ANEWA LETTER AANEWA LETTER INEWA LETTER IINEWA LETTER UN" +
	"EWA LETTER UUNEWA LETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LETTER VOCA" +
	"LIC LNEWA LETTER VOCALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTER ONEWA " +
	"LETTER AUNEWA LETTER KANEWA LETTER KHANEWA LETTER GANEWA LETTER GHANEWA " +
	"LETTER NGANEWA LETTER NGHANEWA LETTER CANEWA LETTER CHANEWA LETTER JANEW" +
	"A LETTER JHANEWA LETTER NYANEWA LETTER NYHANEWA LETTER TTANEWA LETTER TT" +
	"HANEWA LETTER DDANEWA LETTER DDHANEWA LETTER NNANEWA LETTER TANEWA LETTE" +
	"R THANEWA LETTER DANEWA LETTER DHANEWA LETTER NANEWA LETTER NHANEWA LETT" +
	"ER PANEWA LETTER PHANEWA LETTER BANEWA LETTER BHANEWA LETTER MANEWA LETT" +
	"ER MHANEWA LETTER YANEWA LETTER RANEWA LETTER RHANEWA LETTER LANEWA LETT" +
	"ER LHANEWA LETTER WANEWA LETTER SHANEWA LETTER SSANEWA LETTER SANEWA LET" +
	"TER HANEWA VOWEL SIGN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA VOWEL SI" +
	"GN UNEWA VOWEL SIGN UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN VOCALIC R" +
	"RNEWA VOWEL SIGN VOCALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL SIGN ENEW" +
	"A VOWEL SIGN AINEWA VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRAMANEWA S" +
	"IGN CANDRABINDUNEWA SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKTANEWA SI" +
	"GN AVAGRAHANEWA SIGN FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDANEWA DOUB" +
	"LE DANDANEWA COMMANEWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGIT ZERONE" +
	"WA DIGIT ONENEWA DIGIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DIGIT FIVE") + ("" +
	"NEWA DIGIT SIXNEWA DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEWA DOUBLE" +
	" COMMANEWA PLACEHOLDER MARKNEWA INSERTION SIGNNEWA SANDHI MARKNEWA LETTE" +
	"R VEDIC ANUSVARANEWA SIGN JIHVAMULIYANEWA SIGN UPADHMANIYATIRHUTA ANJITI" +
	"RHUTA LETTER ATIRHUTA LETTER AATIRHUTA LETTER ITIRHUTA LETTER IITIRHUTA " +
	"LETTER UTIRHUTA LETTER UUTIRHUTA LETTER VOCALIC RTIRHUTA LETTER VOCALIC " +
	"RRTIRHUTA LETTER VOCALIC LTIRHUTA LETTER VOCALIC LLTIRHUTA LETTER ETIRHU" +
	"TA LETTER AITIRHUTA LETTER OTIRHUTA LETTER AUTIRHUTA LETTER KATIRHUTA LE" +
	"TTER KHATIRHUTA LETTER GATIRHUTA LETTER GHATIRHUTA LETTER NGATIRHUTA LET" +
	"TER CATIRHUTA LETTER CHATIRHUTA LETTER JATIRHUTA LETTER JHATIRHUTA LETTE" +
	"R NYATIRHUTA LETTER TTATIRHUTA LETTER TTHATIRHUTA LETTER DDATIRHUTA LETT" +
	"ER DDHATIRHUTA LETTER NNATIRHUTA LETTER TATIRHUTA LETTER THATIRHUTA LETT" +
	"ER DATIRHUTA LETTER DHATIRHUTA LETTER NATIRHUTA LETTER PATIRHUTA LETTER " +
	"PHATIRHUTA LETTER BATIRHUTA LETTER BHATIRHUTA LETTER MATIRHUTA LETTER YA" +
	"TIRHUTA LETTER RATIRHUTA LETTER LATIRHUTA LETTER VATIRHUTA LETTER SHATIR" +
	"HUTA LETTER SSATIRHUTA LETTER SATIRHUTA LETTER HATIRHUTA VOWEL SIGN AATI" +
	"RHUTA VOWEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA VOWEL SIGN UTIRHUTA VOWEL" +
	" SIGN UUTIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWEL SIGN VOCALIC RRTIRHUTA" +
	" VOWEL SIGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC LLTIRHUTA VOWEL SIGN ETI" +
	"RHUTA VOWEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIRHUTA VOWEL SIGN OTIRHUTA" +
	" VOWEL SIGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA SIGN CANDRABINDUTIRHUTA " +
	"SIGN ANUSVARATIRHUTA SIGN VISARGATIRHUTA SIGN VIRAMATIRHUTA SIGN NUKTATI" +
	"RHUTA SIGN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIATION SIGNTIRHUTA OMTIRHU" +
	"TA DIGIT ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOTIRHUTA DIGIT THREETIRHUT" +
	"A DIGIT FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXTIRHUTA DIGIT SEVENTIRHUT" +
	"A DIGIT EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER ASIDDHAM LETTER AASIDDHAM " +
	"LETTER ISIDDHAM LETTER IISIDDHAM LETTER USIDDHAM LETTER UUSIDDHAM LETTER" +
	" VOCALIC RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTER VOCALIC LSIDDHAM LETTE" +
	"R VOCALIC LLSIDDHAM LETTER ESIDDHAM LETTER AISIDDHAM LETTER OSIDDHAM LET" +
	"TER AUSIDDHAM LETTER KASIDDHAM LETTER KHASIDDHAM LETTER GASIDDHAM LETTER" +
	" GHASIDDHAM LETTER NGASIDDHAM LETTER CASIDDHAM LETTER CHASIDDHAM LETTER " +
	"JASIDDHAM LETTER JHASIDDHAM LETTER NYASIDDHAM LETTER TTASIDDHAM LETTER T" +
	"THASIDDHAM LETTER DDASIDDHAM LETTER DDHASIDDHAM LETTER NNASIDDHAM LETTER" +
	" TASIDDHAM LETTER THASIDDHAM LETTER DASIDDHAM LETTER DHASIDDHAM LETTER N" +
	"ASIDDHAM LETTER PASIDDHAM LETTER PHASIDDHAM LETTER BASIDDHAM LETTER BHAS" +
	"IDDHAM LETTER MASIDDHAM LETTER YASIDDHAM LETTER RASIDDHAM LETTER LASIDDH" +
	"AM LETTER VASIDDHAM LETTER SHASIDDHAM LETTER SSASIDDHAM LETTER SASIDDHAM" +
	" LETTER HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIGN ISIDDHAM VOWEL SIGN II" +
	"SIDDHAM VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM VOWEL SIGN VOCALIC RSID" +
	"DHAM VOWEL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESIDDHAM VOWEL SIGN AISIDDH" +
	"AM VOWEL SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN CANDRABINDUSIDDHAM SIGN" +
	" ANUSVARASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMASIDDHAM SIGN NUKTASIDDHA" +
	"M SIGN SIDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDASIDDHAM SEPARATOR DOTSIDD" +
	"HAM SEPARATOR BARSIDDHAM REPETITION MARK-1SIDDHAM REPETITION MARK-2SIDDH" +
	"AM REPETITION MARK-3SIDDHAM END OF TEXT MARKSIDDHAM SECTION MARK WITH TR" +
	"IDENT AND U-SHAPED ORNAMENTSSIDDHAM SECTION MARK WITH TRIDENT AND DOTTED" +
	" CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTSSIDDHAM SEC" +
	"TION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH" +
	" RAYS AND DOTTED TRIPLE CRESCENTSSIDDHAM SECTION MARK DOUBLE RINGSIDDHAM" +
	" SECTION MARK DOUBLE RING WITH RAYSSIDDHAM SECTION MARK WITH DOUBLE CRES" +
	"CENTSSIDDHAM SECTION MARK WITH TRIPLE CRESCENTSSIDDHAM SECTION MARK WITH" +
	" QUADRUPLE CRESCENTSSIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTSSIDDHAM " +
	"SECTION MARK WITH CIRCLES AND RAYSSIDDHAM SECTION MARK WITH CIRCLES AND " +
	"TWO ENCLOSURESSIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURESSIDDH" +
	"AM LETTER THREE-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE IS" +
	"IDDHAM LETTER TWO-CIRCLE ALTERNATE IISIDDHAM LETTER ALTERNATE USIDDHAM V" +
	"OWEL SIGN ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE UUMODI LETTER AMODI LE" +
	"TTER AAMODI LETTER IMODI LETTER IIMODI LETTER UMODI LETTER UUMODI LETTER" +
	" VOCALIC RMODI LETTER VOCALIC RRMODI LETTER VOCALIC LMODI LETTER VOCALIC" +
	" LLMODI LETTER EMODI LETTER AIMODI LETTER OMODI LETTER AUMODI LETTER KAM" +
	"ODI LETTER KHAMODI LETTER GAMODI LETTER GHAMODI LETTER NGAMODI LETTER CA" +
	"MODI LETTER CHAMODI LETTER JAMODI LETTER JHAMODI LETTER NYAMODI LETTER T" +
	"TAMODI LETTER TTHAMODI LETTER DDAMODI LETTER DDHAMODI LETTER NNAMODI LET" +
	"TER TAMODI LETTER THAMODI LETTER DAMODI LETTER DHAMODI LETTER NAMODI LET" +
	"TER PAMODI LETTER PHAMODI LETTER BAMODI LETTER BHAMODI LETTER MAMODI LET") + ("" +
	"TER YAMODI LETTER RAMODI LETTER LAMODI LETTER VAMODI LETTER SHAMODI LETT" +
	"ER SSAMODI LETTER SAMODI LETTER HAMODI LETTER LLAMODI VOWEL SIGN AAMODI " +
	"VOWEL SIGN IMODI VOWEL SIGN IIMODI VOWEL SIGN UMODI VOWEL SIGN UUMODI VO" +
	"WEL SIGN VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI VOWEL SIGN VOCALIC LMOD" +
	"I VOWEL SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOWEL SIGN AIMODI VOWEL SIG" +
	"N OMODI VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN VISARGAMODI SIGN VIRAMA" +
	"MODI SIGN ARDHACANDRAMODI DANDAMODI DOUBLE DANDAMODI ABBREVIATION SIGNMO" +
	"DI SIGN HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DIGIT TWOMODI DIGIT THREEM" +
	"ODI DIGIT FOURMODI DIGIT FIVEMODI DIGIT SIXMODI DIGIT SEVENMODI DIGIT EI" +
	"GHTMODI DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGAMO" +
	"NGOLIAN DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIPLE BIRGA WITH ORNAMENTMO" +
	"NGOLIAN BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTATED BIRGA WITH ORNAMENTM" +
	"ONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN INVERTED BIRGAMONGO" +
	"LIAN INVERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN SWIRL BIRGAMONGOLIAN S" +
	"WIRL BIRGA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAMENTMONGOL" +
	"IAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI LETTER ATAKRI LETTER AA" +
	"TAKRI LETTER ITAKRI LETTER IITAKRI LETTER UTAKRI LETTER UUTAKRI LETTER E" +
	"TAKRI LETTER AITAKRI LETTER OTAKRI LETTER AUTAKRI LETTER KATAKRI LETTER " +
	"KHATAKRI LETTER GATAKRI LETTER GHATAKRI LETTER NGATAKRI LETTER CATAKRI L" +
	"ETTER CHATAKRI LETTER JATAKRI LETTER JHATAKRI LETTER NYATAKRI LETTER TTA" +
	"TAKRI LETTER TTHATAKRI LETTER DDATAKRI LETTER DDHATAKRI LETTER NNATAKRI " +
	"LETTER TATAKRI LETTER THATAKRI LETTER DATAKRI LETTER DHATAKRI LETTER NAT" +
	"AKRI LETTER PATAKRI LETTER PHATAKRI LETTER BATAKRI LETTER BHATAKRI LETTE" +
	"R MATAKRI LETTER YATAKRI LETTER RATAKRI LETTER LATAKRI LETTER VATAKRI LE" +
	"TTER SHATAKRI LETTER SATAKRI LETTER HATAKRI LETTER RRATAKRI SIGN ANUSVAR" +
	"ATAKRI SIGN VISARGATAKRI VOWEL SIGN AATAKRI VOWEL SIGN ITAKRI VOWEL SIGN" +
	" IITAKRI VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VOWEL SIGN ETAKRI VOWEL SI" +
	"GN AITAKRI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI SIGN VIRAMATAKRI SIGN NU" +
	"KTATAKRI LETTER ARCHAIC KHATAKRI ABBREVIATION SIGNTAKRI DIGIT ZEROTAKRI " +
	"DIGIT ONETAKRI DIGIT TWOTAKRI DIGIT THREETAKRI DIGIT FOURTAKRI DIGIT FIV" +
	"ETAKRI DIGIT SIXTAKRI DIGIT SEVENTAKRI DIGIT EIGHTTAKRI DIGIT NINEAHOM L" +
	"ETTER KAAHOM LETTER KHAAHOM LETTER NGAAHOM LETTER NAAHOM LETTER TAAHOM L" +
	"ETTER ALTERNATE TAAHOM LETTER PAAHOM LETTER PHAAHOM LETTER BAAHOM LETTER" +
	" MAAHOM LETTER JAAHOM LETTER CHAAHOM LETTER THAAHOM LETTER RAAHOM LETTER" +
	" LAAHOM LETTER SAAHOM LETTER NYAAHOM LETTER HAAHOM LETTER AAHOM LETTER D" +
	"AAHOM LETTER DHAAHOM LETTER GAAHOM LETTER ALTERNATE GAAHOM LETTER GHAAHO" +
	"M LETTER BHAAHOM LETTER JHAAHOM LETTER ALTERNATE BAAHOM CONSONANT SIGN M" +
	"EDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSONANT SIGN MEDIAL LIGATING" +
	" RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWEL SIGN IAHOM VOWEL SIGN I" +
	"IAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL SIGN EAHOM VOWEL SIGN AWA" +
	"HOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SIGN AMAHOM SIGN KILLERAHOM" +
	" DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIGIT THREEAHOM DIGIT FOURAH" +
	"OM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM DIGIT EIGHTAHOM DIGIT NI" +
	"NEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SMALL SECTIONAHOM SIGN SECT" +
	"IONAHOM SIGN RULAIAHOM SYMBOL VIAHOM LETTER CAAHOM LETTER TTAAHOM LETTER" +
	" TTHAAHOM LETTER DDAAHOM LETTER DDHAAHOM LETTER NNAAHOM LETTER LLADOGRA " +
	"LETTER ADOGRA LETTER AADOGRA LETTER IDOGRA LETTER IIDOGRA LETTER UDOGRA " +
	"LETTER UUDOGRA LETTER EDOGRA LETTER AIDOGRA LETTER ODOGRA LETTER AUDOGRA" +
	" LETTER KADOGRA LETTER KHADOGRA LETTER GADOGRA LETTER GHADOGRA LETTER NG" +
	"ADOGRA LETTER CADOGRA LETTER CHADOGRA LETTER JADOGRA LETTER JHADOGRA LET" +
	"TER NYADOGRA LETTER TTADOGRA LETTER TTHADOGRA LETTER DDADOGRA LETTER DDH" +
	"ADOGRA LETTER NNADOGRA LETTER TADOGRA LETTER THADOGRA LETTER DADOGRA LET" +
	"TER DHADOGRA LETTER NADOGRA LETTER PADOGRA LETTER PHADOGRA LETTER BADOGR" +
	"A LETTER BHADOGRA LETTER MADOGRA LETTER YADOGRA LETTER RADOGRA LETTER LA" +
	"DOGRA LETTER VADOGRA LETTER SHADOGRA LETTER SSADOGRA LETTER SADOGRA LETT" +
	"ER HADOGRA LETTER RRADOGRA VOWEL SIGN AADOGRA VOWEL SIGN IDOGRA VOWEL SI" +
	"GN IIDOGRA VOWEL SIGN UDOGRA VOWEL SIGN UUDOGRA VOWEL SIGN VOCALIC RDOGR" +
	"A VOWEL SIGN VOCALIC RRDOGRA VOWEL SIGN EDOGRA VOWEL SIGN AIDOGRA VOWEL " +
	"SIGN ODOGRA VOWEL SIGN AUDOGRA SIGN ANUSVARADOGRA SIGN VISARGADOGRA SIGN" +
	" VIRAMADOGRA SIGN NUKTADOGRA ABBREVIATION SIGNWARANG CITI CAPITAL LETTER" +
	" NGAAWARANG CITI CAPITAL LETTER AWARANG CITI CAPITAL LETTER WIWARANG CIT" +
	"I CAPITAL LETTER YUWARANG CITI CAPITAL LETTER YAWARANG CITI CAPITAL LETT" +
	"ER YOWARANG CITI CAPITAL LETTER IIWARANG CITI CAPITAL LETTER UUWARANG CI" +
	"TI CAPITAL LETTER EWARANG CITI CAPITAL LETTER OWARANG CITI CAPITAL LETTE") + ("" +
	"R ANGWARANG CITI CAPITAL LETTER GAWARANG CITI CAPITAL LETTER KOWARANG CI" +
	"TI CAPITAL LETTER ENYWARANG CITI CAPITAL LETTER YUJWARANG CITI CAPITAL L" +
	"ETTER UCWARANG CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LETTER ODDWARA" +
	"NG CITI CAPITAL LETTER TTEWARANG CITI CAPITAL LETTER NUNGWARANG CITI CAP" +
	"ITAL LETTER DAWARANG CITI CAPITAL LETTER ATWARANG CITI CAPITAL LETTER AM" +
	"WARANG CITI CAPITAL LETTER BUWARANG CITI CAPITAL LETTER PUWARANG CITI CA" +
	"PITAL LETTER HIYOWARANG CITI CAPITAL LETTER HOLOWARANG CITI CAPITAL LETT" +
	"ER HORRWARANG CITI CAPITAL LETTER HARWARANG CITI CAPITAL LETTER SSUUWARA" +
	"NG CITI CAPITAL LETTER SIIWARANG CITI CAPITAL LETTER VIYOWARANG CITI SMA" +
	"LL LETTER NGAAWARANG CITI SMALL LETTER AWARANG CITI SMALL LETTER WIWARAN" +
	"G CITI SMALL LETTER YUWARANG CITI SMALL LETTER YAWARANG CITI SMALL LETTE" +
	"R YOWARANG CITI SMALL LETTER IIWARANG CITI SMALL LETTER UUWARANG CITI SM" +
	"ALL LETTER EWARANG CITI SMALL LETTER OWARANG CITI SMALL LETTER ANGWARANG" +
	" CITI SMALL LETTER GAWARANG CITI SMALL LETTER KOWARANG CITI SMALL LETTER" +
	" ENYWARANG CITI SMALL LETTER YUJWARANG CITI SMALL LETTER UCWARANG CITI S" +
	"MALL LETTER ENNWARANG CITI SMALL LETTER ODDWARANG CITI SMALL LETTER TTEW" +
	"ARANG CITI SMALL LETTER NUNGWARANG CITI SMALL LETTER DAWARANG CITI SMALL" +
	" LETTER ATWARANG CITI SMALL LETTER AMWARANG CITI SMALL LETTER BUWARANG C" +
	"ITI SMALL LETTER PUWARANG CITI SMALL LETTER HIYOWARANG CITI SMALL LETTER" +
	" HOLOWARANG CITI SMALL LETTER HORRWARANG CITI SMALL LETTER HARWARANG CIT" +
	"I SMALL LETTER SSUUWARANG CITI SMALL LETTER SIIWARANG CITI SMALL LETTER " +
	"VIYOWARANG CITI DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI DIGIT TWOWARA" +
	"NG CITI DIGIT THREEWARANG CITI DIGIT FOURWARANG CITI DIGIT FIVEWARANG CI" +
	"TI DIGIT SIXWARANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWARANG CITI DI" +
	"GIT NINEWARANG CITI NUMBER TENWARANG CITI NUMBER TWENTYWARANG CITI NUMBE" +
	"R THIRTYWARANG CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARANG CITI NUMB" +
	"ER SIXTYWARANG CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYWARANG CITI N" +
	"UMBER NINETYWARANG CITI OMDIVES AKURU LETTER ADIVES AKURU LETTER AADIVES" +
	" AKURU LETTER IDIVES AKURU LETTER IIDIVES AKURU LETTER UDIVES AKURU LETT" +
	"ER UUDIVES AKURU LETTER EDIVES AKURU LETTER ODIVES AKURU LETTER KADIVES " +
	"AKURU LETTER KHADIVES AKURU LETTER GADIVES AKURU LETTER GHADIVES AKURU L" +
	"ETTER NGADIVES AKURU LETTER CADIVES AKURU LETTER CHADIVES AKURU LETTER J" +
	"ADIVES AKURU LETTER NYADIVES AKURU LETTER TTADIVES AKURU LETTER DDADIVES" +
	" AKURU LETTER DDHADIVES AKURU LETTER NNADIVES AKURU LETTER TADIVES AKURU" +
	" LETTER THADIVES AKURU LETTER DADIVES AKURU LETTER DHADIVES AKURU LETTER" +
	" NADIVES AKURU LETTER PADIVES AKURU LETTER PHADIVES AKURU LETTER BADIVES" +
	" AKURU LETTER BHADIVES AKURU LETTER MADIVES AKURU LETTER YADIVES AKURU L" +
	"ETTER YYADIVES AKURU LETTER RADIVES AKURU LETTER LADIVES AKURU LETTER VA" +
	"DIVES AKURU LETTER SHADIVES AKURU LETTER SSADIVES AKURU LETTER SADIVES A" +
	"KURU LETTER HADIVES AKURU LETTER LLADIVES AKURU LETTER ZADIVES AKURU VOW" +
	"EL SIGN AADIVES AKURU VOWEL SIGN IDIVES AKURU VOWEL SIGN IIDIVES AKURU V" +
	"OWEL SIGN UDIVES AKURU VOWEL SIGN UUDIVES AKURU VOWEL SIGN EDIVES AKURU " +
	"VOWEL SIGN AIDIVES AKURU VOWEL SIGN ODIVES AKURU SIGN ANUSVARADIVES AKUR" +
	"U SIGN CANDRABINDUDIVES AKURU SIGN HALANTADIVES AKURU VIRAMADIVES AKURU " +
	"PREFIXED NASAL SIGNDIVES AKURU MEDIAL YADIVES AKURU INITIAL RADIVES AKUR" +
	"U MEDIAL RADIVES AKURU SIGN NUKTADIVES AKURU DOUBLE DANDADIVES AKURU GAP" +
	" FILLERDIVES AKURU END OF TEXT MARKDIVES AKURU DIGIT ZERODIVES AKURU DIG" +
	"IT ONEDIVES AKURU DIGIT TWODIVES AKURU DIGIT THREEDIVES AKURU DIGIT FOUR" +
	"DIVES AKURU DIGIT FIVEDIVES AKURU DIGIT SIXDIVES AKURU DIGIT SEVENDIVES " +
	"AKURU DIGIT EIGHTDIVES AKURU DIGIT NINENANDINAGARI LETTER ANANDINAGARI L" +
	"ETTER AANANDINAGARI LETTER INANDINAGARI LETTER IINANDINAGARI LETTER UNAN" +
	"DINAGARI LETTER UUNANDINAGARI LETTER VOCALIC RNANDINAGARI LETTER VOCALIC" +
	" RRNANDINAGARI LETTER ENANDINAGARI LETTER AINANDINAGARI LETTER ONANDINAG" +
	"ARI LETTER AUNANDINAGARI LETTER KANANDINAGARI LETTER KHANANDINAGARI LETT" +
	"ER GANANDINAGARI LETTER GHANANDINAGARI LETTER NGANANDINAGARI LETTER CANA" +
	"NDINAGARI LETTER CHANANDINAGARI LETTER JANANDINAGARI LETTER JHANANDINAGA" +
	"RI LETTER NYANANDINAGARI LETTER TTANANDINAGARI LETTER TTHANANDINAGARI LE" +
	"TTER DDANANDINAGARI LETTER DDHANANDINAGARI LETTER NNANANDINAGARI LETTER " +
	"TANANDINAGARI LETTER THANANDINAGARI LETTER DANANDINAGARI LETTER DHANANDI" +
	"NAGARI LETTER NANANDINAGARI LETTER PANANDINAGARI LETTER PHANANDINAGARI L" +
	"ETTER BANANDINAGARI LETTER BHANANDINAGARI LETTER MANANDINAGARI LETTER YA" +
	"NANDINAGARI LETTER RANANDINAGARI LETTER LANANDINAGARI LETTER VANANDINAGA" +
	"RI LETTER SHANANDINAGARI LETTER SSANANDINAGARI LETTER SANANDINAGARI LETT" +
	"ER HANANDINAGARI LETTER LLANANDINAGARI LETTER RRANANDINAGARI VOWEL SIGN ") + ("" +
	"AANANDINAGARI VOWEL SIGN INANDINAGARI VOWEL SIGN IINANDINAGARI VOWEL SIG" +
	"N UNANDINAGARI VOWEL SIGN UUNANDINAGARI VOWEL SIGN VOCALIC RNANDINAGARI " +
	"VOWEL SIGN VOCALIC RRNANDINAGARI VOWEL SIGN ENANDINAGARI VOWEL SIGN AINA" +
	"NDINAGARI VOWEL SIGN ONANDINAGARI VOWEL SIGN AUNANDINAGARI SIGN ANUSVARA" +
	"NANDINAGARI SIGN VISARGANANDINAGARI SIGN VIRAMANANDINAGARI SIGN AVAGRAHA" +
	"NANDINAGARI SIGN SIDDHAMNANDINAGARI HEADSTROKENANDINAGARI VOWEL SIGN PRI" +
	"SHTHAMATRA EZANABAZAR SQUARE LETTER AZANABAZAR SQUARE VOWEL SIGN IZANABA" +
	"ZAR SQUARE VOWEL SIGN UEZANABAZAR SQUARE VOWEL SIGN UZANABAZAR SQUARE VO" +
	"WEL SIGN EZANABAZAR SQUARE VOWEL SIGN OEZANABAZAR SQUARE VOWEL SIGN OZAN" +
	"ABAZAR SQUARE VOWEL SIGN AIZANABAZAR SQUARE VOWEL SIGN AUZANABAZAR SQUAR" +
	"E VOWEL SIGN REVERSED IZANABAZAR SQUARE VOWEL LENGTH MARKZANABAZAR SQUAR" +
	"E LETTER KAZANABAZAR SQUARE LETTER KHAZANABAZAR SQUARE LETTER GAZANABAZA" +
	"R SQUARE LETTER GHAZANABAZAR SQUARE LETTER NGAZANABAZAR SQUARE LETTER CA" +
	"ZANABAZAR SQUARE LETTER CHAZANABAZAR SQUARE LETTER JAZANABAZAR SQUARE LE" +
	"TTER NYAZANABAZAR SQUARE LETTER TTAZANABAZAR SQUARE LETTER TTHAZANABAZAR" +
	" SQUARE LETTER DDAZANABAZAR SQUARE LETTER DDHAZANABAZAR SQUARE LETTER NN" +
	"AZANABAZAR SQUARE LETTER TAZANABAZAR SQUARE LETTER THAZANABAZAR SQUARE L" +
	"ETTER DAZANABAZAR SQUARE LETTER DHAZANABAZAR SQUARE LETTER NAZANABAZAR S" +
	"QUARE LETTER PAZANABAZAR SQUARE LETTER PHAZANABAZAR SQUARE LETTER BAZANA" +
	"BAZAR SQUARE LETTER BHAZANABAZAR SQUARE LETTER MAZANABAZAR SQUARE LETTER" +
	" TSAZANABAZAR SQUARE LETTER TSHAZANABAZAR SQUARE LETTER DZAZANABAZAR SQU" +
	"ARE LETTER DZHAZANABAZAR SQUARE LETTER ZHAZANABAZAR SQUARE LETTER ZAZANA" +
	"BAZAR SQUARE LETTER -AZANABAZAR SQUARE LETTER YAZANABAZAR SQUARE LETTER " +
	"RAZANABAZAR SQUARE LETTER LAZANABAZAR SQUARE LETTER VAZANABAZAR SQUARE L" +
	"ETTER SHAZANABAZAR SQUARE LETTER SSAZANABAZAR SQUARE LETTER SAZANABAZAR " +
	"SQUARE LETTER HAZANABAZAR SQUARE LETTER KSSAZANABAZAR SQUARE FINAL CONSO" +
	"NANT MARKZANABAZAR SQUARE SIGN VIRAMAZANABAZAR SQUARE SIGN CANDRABINDUZA" +
	"NABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENTZANABAZAR SQUARE SIGN CANDR" +
	"A WITH ORNAMENTZANABAZAR SQUARE SIGN ANUSVARAZANABAZAR SQUARE SIGN VISAR" +
	"GAZANABAZAR SQUARE CLUSTER-INITIAL LETTER RAZANABAZAR SQUARE CLUSTER-FIN" +
	"AL LETTER YAZANABAZAR SQUARE CLUSTER-FINAL LETTER RAZANABAZAR SQUARE CLU" +
	"STER-FINAL LETTER LAZANABAZAR SQUARE CLUSTER-FINAL LETTER VAZANABAZAR SQ" +
	"UARE INITIAL HEAD MARKZANABAZAR SQUARE CLOSING HEAD MARKZANABAZAR SQUARE" +
	" MARK TSHEGZANABAZAR SQUARE MARK SHADZANABAZAR SQUARE MARK DOUBLE SHADZA" +
	"NABAZAR SQUARE MARK LONG TSHEGZANABAZAR SQUARE INITIAL DOUBLE-LINED HEAD" +
	" MARKZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARKZANABAZAR SQUARE SUB" +
	"JOINERSOYOMBO LETTER ASOYOMBO VOWEL SIGN ISOYOMBO VOWEL SIGN UESOYOMBO V" +
	"OWEL SIGN USOYOMBO VOWEL SIGN ESOYOMBO VOWEL SIGN OSOYOMBO VOWEL SIGN OE" +
	"SOYOMBO VOWEL SIGN AISOYOMBO VOWEL SIGN AUSOYOMBO VOWEL SIGN VOCALIC RSO" +
	"YOMBO VOWEL SIGN VOCALIC LSOYOMBO VOWEL LENGTH MARKSOYOMBO LETTER KASOYO" +
	"MBO LETTER KHASOYOMBO LETTER GASOYOMBO LETTER GHASOYOMBO LETTER NGASOYOM" +
	"BO LETTER CASOYOMBO LETTER CHASOYOMBO LETTER JASOYOMBO LETTER JHASOYOMBO" +
	" LETTER NYASOYOMBO LETTER TTASOYOMBO LETTER TTHASOYOMBO LETTER DDASOYOMB" +
	"O LETTER DDHASOYOMBO LETTER NNASOYOMBO LETTER TASOYOMBO LETTER THASOYOMB" +
	"O LETTER DASOYOMBO LETTER DHASOYOMBO LETTER NASOYOMBO LETTER PASOYOMBO L" +
	"ETTER PHASOYOMBO LETTER BASOYOMBO LETTER BHASOYOMBO LETTER MASOYOMBO LET" +
	"TER TSASOYOMBO LETTER TSHASOYOMBO LETTER DZASOYOMBO LETTER ZHASOYOMBO LE" +
	"TTER ZASOYOMBO LETTER -ASOYOMBO LETTER YASOYOMBO LETTER RASOYOMBO LETTER" +
	" LASOYOMBO LETTER VASOYOMBO LETTER SHASOYOMBO LETTER SSASOYOMBO LETTER S" +
	"ASOYOMBO LETTER HASOYOMBO LETTER KSSASOYOMBO SIGN JIHVAMULIYASOYOMBO SIG" +
	"N UPADHMANIYASOYOMBO CLUSTER-INITIAL LETTER RASOYOMBO CLUSTER-INITIAL LE" +
	"TTER LASOYOMBO CLUSTER-INITIAL LETTER SHASOYOMBO CLUSTER-INITIAL LETTER " +
	"SASOYOMBO FINAL CONSONANT SIGN GSOYOMBO FINAL CONSONANT SIGN KSOYOMBO FI" +
	"NAL CONSONANT SIGN NGSOYOMBO FINAL CONSONANT SIGN DSOYOMBO FINAL CONSONA" +
	"NT SIGN NSOYOMBO FINAL CONSONANT SIGN BSOYOMBO FINAL CONSONANT SIGN MSOY" +
	"OMBO FINAL CONSONANT SIGN RSOYOMBO FINAL CONSONANT SIGN LSOYOMBO FINAL C" +
	"ONSONANT SIGN SHSOYOMBO FINAL CONSONANT SIGN SSOYOMBO FINAL CONSONANT SI" +
	"GN -ASOYOMBO SIGN ANUSVARASOYOMBO SIGN VISARGASOYOMBO GEMINATION MARKSOY" +
	"OMBO SUBJOINERSOYOMBO MARK TSHEGSOYOMBO MARK SHADSOYOMBO MARK DOUBLE SHA" +
	"DSOYOMBO MARK PLUTASOYOMBO HEAD MARK WITH MOON AND SUN AND TRIPLE FLAMES" +
	"OYOMBO HEAD MARK WITH MOON AND SUN AND FLAMESOYOMBO HEAD MARK WITH MOON " +
	"AND SUNSOYOMBO TERMINAL MARK-1SOYOMBO TERMINAL MARK-2CANADIAN SYLLABICS " +
	"NATTILIK HICANADIAN SYLLABICS NATTILIK HIICANADIAN SYLLABICS NATTILIK HO" +
	"CANADIAN SYLLABICS NATTILIK HOOCANADIAN SYLLABICS NATTILIK HACANADIAN SY") + ("" +
	"LLABICS NATTILIK HAACANADIAN SYLLABICS NATTILIK SHRICANADIAN SYLLABICS N" +
	"ATTILIK SHRIICANADIAN SYLLABICS NATTILIK SHROCANADIAN SYLLABICS NATTILIK" +
	" SHROOCANADIAN SYLLABICS NATTILIK SHRACANADIAN SYLLABICS NATTILIK SHRAAC" +
	"ANADIAN SYLLABICS SPECANADIAN SYLLABICS SPICANADIAN SYLLABICS SPOCANADIA" +
	"N SYLLABICS SPAPAU CIN HAU LETTER PAPAU CIN HAU LETTER KAPAU CIN HAU LET" +
	"TER LAPAU CIN HAU LETTER MAPAU CIN HAU LETTER DAPAU CIN HAU LETTER ZAPAU" +
	" CIN HAU LETTER VAPAU CIN HAU LETTER NGAPAU CIN HAU LETTER HAPAU CIN HAU" +
	" LETTER GAPAU CIN HAU LETTER KHAPAU CIN HAU LETTER SAPAU CIN HAU LETTER " +
	"BAPAU CIN HAU LETTER CAPAU CIN HAU LETTER TAPAU CIN HAU LETTER THAPAU CI" +
	"N HAU LETTER NAPAU CIN HAU LETTER PHAPAU CIN HAU LETTER RAPAU CIN HAU LE" +
	"TTER FAPAU CIN HAU LETTER CHAPAU CIN HAU LETTER APAU CIN HAU LETTER EPAU" +
	" CIN HAU LETTER IPAU CIN HAU LETTER OPAU CIN HAU LETTER UPAU CIN HAU LET" +
	"TER UAPAU CIN HAU LETTER IAPAU CIN HAU LETTER FINAL PPAU CIN HAU LETTER " +
	"FINAL KPAU CIN HAU LETTER FINAL TPAU CIN HAU LETTER FINAL MPAU CIN HAU L" +
	"ETTER FINAL NPAU CIN HAU LETTER FINAL LPAU CIN HAU LETTER FINAL WPAU CIN" +
	" HAU LETTER FINAL NGPAU CIN HAU LETTER FINAL YPAU CIN HAU RISING TONE LO" +
	"NGPAU CIN HAU RISING TONEPAU CIN HAU SANDHI GLOTTAL STOPPAU CIN HAU RISI" +
	"NG TONE LONG FINALPAU CIN HAU RISING TONE FINALPAU CIN HAU SANDHI GLOTTA" +
	"L STOP FINALPAU CIN HAU SANDHI TONE LONGPAU CIN HAU SANDHI TONEPAU CIN H" +
	"AU SANDHI TONE LONG FINALPAU CIN HAU SANDHI TONE FINALPAU CIN HAU MID-LE" +
	"VEL TONEPAU CIN HAU GLOTTAL STOP VARIANTPAU CIN HAU MID-LEVEL TONE LONG " +
	"FINALPAU CIN HAU MID-LEVEL TONE FINALPAU CIN HAU LOW-FALLING TONE LONGPA" +
	"U CIN HAU LOW-FALLING TONEPAU CIN HAU GLOTTAL STOPPAU CIN HAU LOW-FALLIN" +
	"G TONE LONG FINALPAU CIN HAU LOW-FALLING TONE FINALPAU CIN HAU GLOTTAL S" +
	"TOP FINALDEVANAGARI HEAD MARKDEVANAGARI HEAD MARK WITH HEADSTROKEDEVANAG" +
	"ARI SIGN BHALEDEVANAGARI SIGN BHALE WITH HOOKDEVANAGARI SIGN EXTENDED BH" +
	"ALEDEVANAGARI SIGN EXTENDED BHALE WITH HOOKDEVANAGARI SIGN WESTERN FIVE-" +
	"LIKE BHALEDEVANAGARI SIGN WESTERN NINE-LIKE BHALEDEVANAGARI SIGN REVERSE" +
	"D NINE-LIKE BHALEDEVANAGARI SIGN MINDUBHAIKSUKI LETTER ABHAIKSUKI LETTER" +
	" AABHAIKSUKI LETTER IBHAIKSUKI LETTER IIBHAIKSUKI LETTER UBHAIKSUKI LETT" +
	"ER UUBHAIKSUKI LETTER VOCALIC RBHAIKSUKI LETTER VOCALIC RRBHAIKSUKI LETT" +
	"ER VOCALIC LBHAIKSUKI LETTER EBHAIKSUKI LETTER AIBHAIKSUKI LETTER OBHAIK" +
	"SUKI LETTER AUBHAIKSUKI LETTER KABHAIKSUKI LETTER KHABHAIKSUKI LETTER GA" +
	"BHAIKSUKI LETTER GHABHAIKSUKI LETTER NGABHAIKSUKI LETTER CABHAIKSUKI LET" +
	"TER CHABHAIKSUKI LETTER JABHAIKSUKI LETTER JHABHAIKSUKI LETTER NYABHAIKS" +
	"UKI LETTER TTABHAIKSUKI LETTER TTHABHAIKSUKI LETTER DDABHAIKSUKI LETTER " +
	"DDHABHAIKSUKI LETTER NNABHAIKSUKI LETTER TABHAIKSUKI LETTER THABHAIKSUKI" +
	" LETTER DABHAIKSUKI LETTER DHABHAIKSUKI LETTER NABHAIKSUKI LETTER PABHAI" +
	"KSUKI LETTER PHABHAIKSUKI LETTER BABHAIKSUKI LETTER BHABHAIKSUKI LETTER " +
	"MABHAIKSUKI LETTER YABHAIKSUKI LETTER RABHAIKSUKI LETTER LABHAIKSUKI LET" +
	"TER VABHAIKSUKI LETTER SHABHAIKSUKI LETTER SSABHAIKSUKI LETTER SABHAIKSU" +
	"KI LETTER HABHAIKSUKI VOWEL SIGN AABHAIKSUKI VOWEL SIGN IBHAIKSUKI VOWEL" +
	" SIGN IIBHAIKSUKI VOWEL SIGN UBHAIKSUKI VOWEL SIGN UUBHAIKSUKI VOWEL SIG" +
	"N VOCALIC RBHAIKSUKI VOWEL SIGN VOCALIC RRBHAIKSUKI VOWEL SIGN VOCALIC L" +
	"BHAIKSUKI VOWEL SIGN EBHAIKSUKI VOWEL SIGN AIBHAIKSUKI VOWEL SIGN OBHAIK" +
	"SUKI VOWEL SIGN AUBHAIKSUKI SIGN CANDRABINDUBHAIKSUKI SIGN ANUSVARABHAIK" +
	"SUKI SIGN VISARGABHAIKSUKI SIGN VIRAMABHAIKSUKI SIGN AVAGRAHABHAIKSUKI D" +
	"ANDABHAIKSUKI DOUBLE DANDABHAIKSUKI WORD SEPARATORBHAIKSUKI GAP FILLER-1" +
	"BHAIKSUKI GAP FILLER-2BHAIKSUKI DIGIT ZEROBHAIKSUKI DIGIT ONEBHAIKSUKI D" +
	"IGIT TWOBHAIKSUKI DIGIT THREEBHAIKSUKI DIGIT FOURBHAIKSUKI DIGIT FIVEBHA" +
	"IKSUKI DIGIT SIXBHAIKSUKI DIGIT SEVENBHAIKSUKI DIGIT EIGHTBHAIKSUKI DIGI" +
	"T NINEBHAIKSUKI NUMBER ONEBHAIKSUKI NUMBER TWOBHAIKSUKI NUMBER THREEBHAI" +
	"KSUKI NUMBER FOURBHAIKSUKI NUMBER FIVEBHAIKSUKI NUMBER SIXBHAIKSUKI NUMB" +
	"ER SEVENBHAIKSUKI NUMBER EIGHTBHAIKSUKI NUMBER NINEBHAIKSUKI NUMBER TENB" +
	"HAIKSUKI NUMBER TWENTYBHAIKSUKI NUMBER THIRTYBHAIKSUKI NUMBER FORTYBHAIK" +
	"SUKI NUMBER FIFTYBHAIKSUKI NUMBER SIXTYBHAIKSUKI NUMBER SEVENTYBHAIKSUKI" +
	" NUMBER EIGHTYBHAIKSUKI NUMBER NINETYBHAIKSUKI HUNDREDS UNIT MARKMARCHEN" +
	" HEAD MARKMARCHEN MARK SHADMARCHEN LETTER KAMARCHEN LETTER KHAMARCHEN LE" +
	"TTER GAMARCHEN LETTER NGAMARCHEN LETTER CAMARCHEN LETTER CHAMARCHEN LETT" +
	"ER JAMARCHEN LETTER NYAMARCHEN LETTER TAMARCHEN LETTER THAMARCHEN LETTER" +
	" DAMARCHEN LETTER NAMARCHEN LETTER PAMARCHEN LETTER PHAMARCHEN LETTER BA" +
	"MARCHEN LETTER MAMARCHEN LETTER TSAMARCHEN LETTER TSHAMARCHEN LETTER DZA" +
	"MARCHEN LETTER WAMARCHEN LETTER ZHAMARCHEN LETTER ZAMARCHEN LETTER -AMAR" +
	"CHEN LETTER YAMARCHEN LETTER RAMARCHEN LETTER LAMARCHEN LETTER SHAMARCHE") + ("" +
	"N LETTER SAMARCHEN LETTER HAMARCHEN LETTER AMARCHEN SUBJOINED LETTER KAM" +
	"ARCHEN SUBJOINED LETTER KHAMARCHEN SUBJOINED LETTER GAMARCHEN SUBJOINED " +
	"LETTER NGAMARCHEN SUBJOINED LETTER CAMARCHEN SUBJOINED LETTER CHAMARCHEN" +
	" SUBJOINED LETTER JAMARCHEN SUBJOINED LETTER NYAMARCHEN SUBJOINED LETTER" +
	" TAMARCHEN SUBJOINED LETTER THAMARCHEN SUBJOINED LETTER DAMARCHEN SUBJOI" +
	"NED LETTER NAMARCHEN SUBJOINED LETTER PAMARCHEN SUBJOINED LETTER PHAMARC" +
	"HEN SUBJOINED LETTER BAMARCHEN SUBJOINED LETTER MAMARCHEN SUBJOINED LETT" +
	"ER TSAMARCHEN SUBJOINED LETTER TSHAMARCHEN SUBJOINED LETTER DZAMARCHEN S" +
	"UBJOINED LETTER WAMARCHEN SUBJOINED LETTER ZHAMARCHEN SUBJOINED LETTER Z" +
	"AMARCHEN SUBJOINED LETTER YAMARCHEN SUBJOINED LETTER RAMARCHEN SUBJOINED" +
	" LETTER LAMARCHEN SUBJOINED LETTER SHAMARCHEN SUBJOINED LETTER SAMARCHEN" +
	" SUBJOINED LETTER HAMARCHEN SUBJOINED LETTER AMARCHEN VOWEL SIGN AAMARCH" +
	"EN VOWEL SIGN IMARCHEN VOWEL SIGN UMARCHEN VOWEL SIGN EMARCHEN VOWEL SIG" +
	"N OMARCHEN SIGN ANUSVARAMARCHEN SIGN CANDRABINDUMASARAM GONDI LETTER AMA" +
	"SARAM GONDI LETTER AAMASARAM GONDI LETTER IMASARAM GONDI LETTER IIMASARA" +
	"M GONDI LETTER UMASARAM GONDI LETTER UUMASARAM GONDI LETTER EMASARAM GON" +
	"DI LETTER AIMASARAM GONDI LETTER OMASARAM GONDI LETTER AUMASARAM GONDI L" +
	"ETTER KAMASARAM GONDI LETTER KHAMASARAM GONDI LETTER GAMASARAM GONDI LET" +
	"TER GHAMASARAM GONDI LETTER NGAMASARAM GONDI LETTER CAMASARAM GONDI LETT" +
	"ER CHAMASARAM GONDI LETTER JAMASARAM GONDI LETTER JHAMASARAM GONDI LETTE" +
	"R NYAMASARAM GONDI LETTER TTAMASARAM GONDI LETTER TTHAMASARAM GONDI LETT" +
	"ER DDAMASARAM GONDI LETTER DDHAMASARAM GONDI LETTER NNAMASARAM GONDI LET" +
	"TER TAMASARAM GONDI LETTER THAMASARAM GONDI LETTER DAMASARAM GONDI LETTE" +
	"R DHAMASARAM GONDI LETTER NAMASARAM GONDI LETTER PAMASARAM GONDI LETTER " +
	"PHAMASARAM GONDI LETTER BAMASARAM GONDI LETTER BHAMASARAM GONDI LETTER M" +
	"AMASARAM GONDI LETTER YAMASARAM GONDI LETTER RAMASARAM GONDI LETTER LAMA" +
	"SARAM GONDI LETTER VAMASARAM GONDI LETTER SHAMASARAM GONDI LETTER SSAMAS" +
	"ARAM GONDI LETTER SAMASARAM GONDI LETTER HAMASARAM GONDI LETTER LLAMASAR" +
	"AM GONDI LETTER KSSAMASARAM GONDI LETTER JNYAMASARAM GONDI LETTER TRAMAS" +
	"ARAM GONDI VOWEL SIGN AAMASARAM GONDI VOWEL SIGN IMASARAM GONDI VOWEL SI" +
	"GN IIMASARAM GONDI VOWEL SIGN UMASARAM GONDI VOWEL SIGN UUMASARAM GONDI " +
	"VOWEL SIGN VOCALIC RMASARAM GONDI VOWEL SIGN EMASARAM GONDI VOWEL SIGN A" +
	"IMASARAM GONDI VOWEL SIGN OMASARAM GONDI VOWEL SIGN AUMASARAM GONDI SIGN" +
	" ANUSVARAMASARAM GONDI SIGN VISARGAMASARAM GONDI SIGN NUKTAMASARAM GONDI" +
	" SIGN CANDRAMASARAM GONDI SIGN HALANTAMASARAM GONDI VIRAMAMASARAM GONDI " +
	"REPHAMASARAM GONDI RA-KARAMASARAM GONDI DIGIT ZEROMASARAM GONDI DIGIT ON" +
	"EMASARAM GONDI DIGIT TWOMASARAM GONDI DIGIT THREEMASARAM GONDI DIGIT FOU" +
	"RMASARAM GONDI DIGIT FIVEMASARAM GONDI DIGIT SIXMASARAM GONDI DIGIT SEVE" +
	"NMASARAM GONDI DIGIT EIGHTMASARAM GONDI DIGIT NINEGUNJALA GONDI LETTER A" +
	"GUNJALA GONDI LETTER AAGUNJALA GONDI LETTER IGUNJALA GONDI LETTER IIGUNJ" +
	"ALA GONDI LETTER UGUNJALA GONDI LETTER UUGUNJALA GONDI LETTER EEGUNJALA " +
	"GONDI LETTER AIGUNJALA GONDI LETTER OOGUNJALA GONDI LETTER AUGUNJALA GON" +
	"DI LETTER YAGUNJALA GONDI LETTER VAGUNJALA GONDI LETTER BAGUNJALA GONDI " +
	"LETTER BHAGUNJALA GONDI LETTER MAGUNJALA GONDI LETTER KAGUNJALA GONDI LE" +
	"TTER KHAGUNJALA GONDI LETTER TAGUNJALA GONDI LETTER THAGUNJALA GONDI LET" +
	"TER LAGUNJALA GONDI LETTER GAGUNJALA GONDI LETTER GHAGUNJALA GONDI LETTE" +
	"R DAGUNJALA GONDI LETTER DHAGUNJALA GONDI LETTER NAGUNJALA GONDI LETTER " +
	"CAGUNJALA GONDI LETTER CHAGUNJALA GONDI LETTER TTAGUNJALA GONDI LETTER T" +
	"THAGUNJALA GONDI LETTER LLAGUNJALA GONDI LETTER JAGUNJALA GONDI LETTER J" +
	"HAGUNJALA GONDI LETTER DDAGUNJALA GONDI LETTER DDHAGUNJALA GONDI LETTER " +
	"NGAGUNJALA GONDI LETTER PAGUNJALA GONDI LETTER PHAGUNJALA GONDI LETTER H" +
	"AGUNJALA GONDI LETTER RAGUNJALA GONDI LETTER SAGUNJALA GONDI VOWEL SIGN " +
	"AAGUNJALA GONDI VOWEL SIGN IGUNJALA GONDI VOWEL SIGN IIGUNJALA GONDI VOW" +
	"EL SIGN UGUNJALA GONDI VOWEL SIGN UUGUNJALA GONDI VOWEL SIGN EEGUNJALA G" +
	"ONDI VOWEL SIGN AIGUNJALA GONDI VOWEL SIGN OOGUNJALA GONDI VOWEL SIGN AU" +
	"GUNJALA GONDI SIGN ANUSVARAGUNJALA GONDI SIGN VISARGAGUNJALA GONDI VIRAM" +
	"AGUNJALA GONDI OMGUNJALA GONDI DIGIT ZEROGUNJALA GONDI DIGIT ONEGUNJALA " +
	"GONDI DIGIT TWOGUNJALA GONDI DIGIT THREEGUNJALA GONDI DIGIT FOURGUNJALA " +
	"GONDI DIGIT FIVEGUNJALA GONDI DIGIT SIXGUNJALA GONDI DIGIT SEVENGUNJALA " +
	"GONDI DIGIT EIGHTGUNJALA GONDI DIGIT NINEMAKASAR LETTER KAMAKASAR LETTER" +
	" GAMAKASAR LETTER NGAMAKASAR LETTER PAMAKASAR LETTER BAMAKASAR LETTER MA" +
	"MAKASAR LETTER TAMAKASAR LETTER DAMAKASAR LETTER NAMAKASAR LETTER CAMAKA" +
	"SAR LETTER JAMAKASAR LETTER NYAMAKASAR LETTER YAMAKASAR LETTER RAMAKASAR" +
	" LETTER LAMAKASAR LETTER VAMAKASAR LETTER SAMAKASAR LETTER AMAKASAR ANGK") + ("" +
	"AMAKASAR VOWEL SIGN IMAKASAR VOWEL SIGN UMAKASAR VOWEL SIGN EMAKASAR VOW" +
	"EL SIGN OMAKASAR PASSIMBANGMAKASAR END OF SECTIONKAWI SIGN CANDRABINDUKA" +
	"WI SIGN ANUSVARAKAWI SIGN REPHAKAWI SIGN VISARGAKAWI LETTER AKAWI LETTER" +
	" AAKAWI LETTER IKAWI LETTER IIKAWI LETTER UKAWI LETTER UUKAWI LETTER VOC" +
	"ALIC RKAWI LETTER VOCALIC RRKAWI LETTER VOCALIC LKAWI LETTER VOCALIC LLK" +
	"AWI LETTER EKAWI LETTER AIKAWI LETTER OKAWI LETTER KAKAWI LETTER KHAKAWI" +
	" LETTER GAKAWI LETTER GHAKAWI LETTER NGAKAWI LETTER CAKAWI LETTER CHAKAW" +
	"I LETTER JAKAWI LETTER JHAKAWI LETTER NYAKAWI LETTER TTAKAWI LETTER TTHA" +
	"KAWI LETTER DDAKAWI LETTER DDHAKAWI LETTER NNAKAWI LETTER TAKAWI LETTER " +
	"THAKAWI LETTER DAKAWI LETTER DHAKAWI LETTER NAKAWI LETTER PAKAWI LETTER " +
	"PHAKAWI LETTER BAKAWI LETTER BHAKAWI LETTER MAKAWI LETTER YAKAWI LETTER " +
	"RAKAWI LETTER LAKAWI LETTER WAKAWI LETTER SHAKAWI LETTER SSAKAWI LETTER " +
	"SAKAWI LETTER HAKAWI LETTER JNYAKAWI VOWEL SIGN AAKAWI VOWEL SIGN ALTERN" +
	"ATE AAKAWI VOWEL SIGN IKAWI VOWEL SIGN IIKAWI VOWEL SIGN UKAWI VOWEL SIG" +
	"N UUKAWI VOWEL SIGN VOCALIC RKAWI VOWEL SIGN EKAWI VOWEL SIGN AIKAWI VOW" +
	"EL SIGN EUKAWI SIGN KILLERKAWI CONJOINERKAWI DANDAKAWI DOUBLE DANDAKAWI " +
	"PUNCTUATION SECTION MARKERKAWI PUNCTUATION ALTERNATE SECTION MARKERKAWI " +
	"PUNCTUATION FLOWERKAWI PUNCTUATION SPACE FILLERKAWI PUNCTUATION DOTKAWI " +
	"PUNCTUATION DOUBLE DOTKAWI PUNCTUATION TRIPLE DOTKAWI PUNCTUATION CIRCLE" +
	"KAWI PUNCTUATION FILLED CIRCLEKAWI PUNCTUATION SPIRALKAWI PUNCTUATION CL" +
	"OSING SPIRALKAWI DIGIT ZEROKAWI DIGIT ONEKAWI DIGIT TWOKAWI DIGIT THREEK" +
	"AWI DIGIT FOURKAWI DIGIT FIVEKAWI DIGIT SIXKAWI DIGIT SEVENKAWI DIGIT EI" +
	"GHTKAWI DIGIT NINELISU LETTER YHATAMIL FRACTION ONE THREE-HUNDRED-AND-TW" +
	"ENTIETHTAMIL FRACTION ONE ONE-HUNDRED-AND-SIXTIETHTAMIL FRACTION ONE EIG" +
	"HTIETHTAMIL FRACTION ONE SIXTY-FOURTHTAMIL FRACTION ONE FORTIETHTAMIL FR" +
	"ACTION ONE THIRTY-SECONDTAMIL FRACTION THREE EIGHTIETHSTAMIL FRACTION TH" +
	"REE SIXTY-FOURTHSTAMIL FRACTION ONE TWENTIETHTAMIL FRACTION ONE SIXTEENT" +
	"H-1TAMIL FRACTION ONE SIXTEENTH-2TAMIL FRACTION ONE TENTHTAMIL FRACTION " +
	"ONE EIGHTHTAMIL FRACTION THREE TWENTIETHSTAMIL FRACTION THREE SIXTEENTHS" +
	"TAMIL FRACTION ONE FIFTHTAMIL FRACTION ONE QUARTERTAMIL FRACTION ONE HAL" +
	"F-1TAMIL FRACTION ONE HALF-2TAMIL FRACTION THREE QUARTERSTAMIL FRACTION " +
	"DOWNSCALING FACTOR KIIZHTAMIL SIGN NELTAMIL SIGN CEVITUTAMIL SIGN AAZHAA" +
	"KKUTAMIL SIGN UZHAKKUTAMIL SIGN MUUVUZHAKKUTAMIL SIGN KURUNITAMIL SIGN P" +
	"ATHAKKUTAMIL SIGN MUKKURUNITAMIL SIGN KAACUTAMIL SIGN PANAMTAMIL SIGN PO" +
	"NTAMIL SIGN VARAAKANTAMIL SIGN PAARAMTAMIL SIGN KUZHITAMIL SIGN VELITAMI" +
	"L WET CULTIVATION SIGNTAMIL DRY CULTIVATION SIGNTAMIL LAND SIGNTAMIL SAL" +
	"T PAN SIGNTAMIL TRADITIONAL CREDIT SIGNTAMIL TRADITIONAL NUMBER SIGNTAMI" +
	"L CURRENT SIGNTAMIL AND ODD SIGNTAMIL SPENT SIGNTAMIL TOTAL SIGNTAMIL IN" +
	" POSSESSION SIGNTAMIL STARTING FROM SIGNTAMIL SIGN MUTHALIYATAMIL SIGN V" +
	"AKAIYARAATAMIL PUNCTUATION END OF TEXTCUNEIFORM SIGN ACUNEIFORM SIGN A T" +
	"IMES ACUNEIFORM SIGN A TIMES BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEIFOR" +
	"M SIGN A TIMES HACUNEIFORM SIGN A TIMES IGICUNEIFORM SIGN A TIMES LAGAR " +
	"GUNUCUNEIFORM SIGN A TIMES MUSHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SIGN " +
	"A2CUNEIFORM SIGN ABCUNEIFORM SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIMES D" +
	"UN3 GUNUCUNEIFORM SIGN AB TIMES GALCUNEIFORM SIGN AB TIMES GAN2 TENUCUNE" +
	"IFORM SIGN AB TIMES HACUNEIFORM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN AB " +
	"TIMES IMINCUNEIFORM SIGN AB TIMES LAGABCUNEIFORM SIGN AB TIMES SHESHCUNE" +
	"IFORM SIGN AB TIMES U PLUS U PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SIGN " +
	"AB2CUNEIFORM SIGN AB2 TIMES BALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCUNEI" +
	"FORM SIGN AB2 TIMES ME PLUS ENCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM SIG" +
	"N AB2 TIMES TAK4CUNEIFORM SIGN ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK TIME" +
	"S ERIN2CUNEIFORM SIGN AK TIMES SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIFORM" +
	" SIGN AL TIMES ALCUNEIFORM SIGN AL TIMES DIM2CUNEIFORM SIGN AL TIMES GIS" +
	"HCUNEIFORM SIGN AL TIMES HACUNEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN AL" +
	" TIMES KICUNEIFORM SIGN AL TIMES SHECUNEIFORM SIGN AL TIMES USHCUNEIFORM" +
	" SIGN ALANCUNEIFORM SIGN ALEPHCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR TIM" +
	"ES SHECUNEIFORM SIGN ANCUNEIFORM SIGN AN OVER ANCUNEIFORM SIGN AN THREE " +
	"TIMESCUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGACUNEIFORM SIGN AN " +
	"PLUS NAGA SQUAREDCUNEIFORM SIGN ANSHECUNEIFORM SIGN APINCUNEIFORM SIGN A" +
	"RADCUNEIFORM SIGN ARAD TIMES KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN ASAL2" +
	"CUNEIFORM SIGN ASHCUNEIFORM SIGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA TE" +
	"NUCUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIFORM" +
	" SIGN ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING" +
	" ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFORM ") + ("" +
	"SIGN BACUNEIFORM SIGN BADCUNEIFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNEIFO" +
	"RM SIGN BALCUNEIFORM SIGN BAL OVER BALCUNEIFORM SIGN BALAGCUNEIFORM SIGN" +
	" BARCUNEIFORM SIGN BARA2CUNEIFORM SIGN BICUNEIFORM SIGN BI TIMES ACUNEIF" +
	"ORM SIGN BI TIMES GARCUNEIFORM SIGN BI TIMES IGI GUNUCUNEIFORM SIGN BUCU" +
	"NEIFORM SIGN BU OVER BU ABCUNEIFORM SIGN BU OVER BU UNCUNEIFORM SIGN BU " +
	"CROSSING BUCUNEIFORM SIGN BULUGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFORM " +
	"SIGN BURCUNEIFORM SIGN BUR2CUNEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFORM " +
	"SIGN DAG KISIM5 TIMES A PLUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMARCUN" +
	"EIFORM SIGN DAG KISIM5 TIMES BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BICUNE" +
	"IFORM SIGN DAG KISIM5 TIMES GACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MA" +
	"SHCUNEIFORM SIGN DAG KISIM5 TIMES GICUNEIFORM SIGN DAG KISIM5 TIMES GIR2" +
	"CUNEIFORM SIGN DAG KISIM5 TIMES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HACUN" +
	"EIFORM SIGN DAG KISIM5 TIMES IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS L" +
	"UCUNEIFORM SIGN DAG KISIM5 TIMES KAKCUNEIFORM SIGN DAG KISIM5 TIMES LACU" +
	"NEIFORM SIGN DAG KISIM5 TIMES LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS " +
	"MASH2CUNEIFORM SIGN DAG KISIM5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIMES " +
	"NECUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAPCUNEIFORM SIGN DAG KISIM5 " +
	"TIMES SICUNEIFORM SIGN DAG KISIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5 TI" +
	"MES U2 PLUS GIR2CUNEIFORM SIGN DAG KISIM5 TIMES USHCUNEIFORM SIGN DAMCUN" +
	"EIFORM SIGN DARCUNEIFORM SIGN DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN DI" +
	"CUNEIFORM SIGN DIBCUNEIFORM SIGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEIFOR" +
	"M SIGN DIM2CUNEIFORM SIGN DINCUNEIFORM SIGN DIN KASKAL U GUNU DISHCUNEIF" +
	"ORM SIGN DISHCUNEIFORM SIGN DUCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN DU" +
	" GUNUCUNEIFORM SIGN DU SHESHIGCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TIMES" +
	" ESH2CUNEIFORM SIGN DUB2CUNEIFORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFORM " +
	"SIGN DUHCUNEIFORM SIGN DUNCUNEIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNUCUN" +
	"EIFORM SIGN DUN3 GUNU GUNUCUNEIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEIFOR" +
	"M SIGN ECUNEIFORM SIGN E TIMES PAPCUNEIFORM SIGN E OVER E NUN OVER NUNCU" +
	"NEIFORM SIGN E2CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DACUNEIFORM SIGN E" +
	"2 TIMES GARCUNEIFORM SIGN E2 TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEIFOR" +
	"M SIGN E2 TIMES SHECUNEIFORM SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIFORM" +
	" SIGN EGIRCUNEIFORM SIGN ELCUNEIFORM SIGN ENCUNEIFORM SIGN EN TIMES GAN2" +
	"CUNEIFORM SIGN EN TIMES GAN2 TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM SIG" +
	"N EN CROSSING ENCUNEIFORM SIGN EN OPPOSING ENCUNEIFORM SIGN EN SQUAREDCU" +
	"NEIFORM SIGN ERENCUNEIFORM SIGN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIGN E" +
	"ZENCUNEIFORM SIGN EZEN TIMES ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUNEIF" +
	"ORM SIGN EZEN TIMES A PLUS LAL TIMES LALCUNEIFORM SIGN EZEN TIMES ANCUNE" +
	"IFORM SIGN EZEN TIMES BADCUNEIFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM SI" +
	"GN EZEN TIMES DUN3 GUNU GUNUCUNEIFORM SIGN EZEN TIMES HACUNEIFORM SIGN E" +
	"ZEN TIMES HA GUNUCUNEIFORM SIGN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZEN T" +
	"IMES KASKALCUNEIFORM SIGN EZEN TIMES KASKAL SQUAREDCUNEIFORM SIGN EZEN T" +
	"IMES KU3CUNEIFORM SIGN EZEN TIMES LACUNEIFORM SIGN EZEN TIMES LAL TIMES " +
	"LALCUNEIFORM SIGN EZEN TIMES LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM SIG" +
	"N EZEN TIMES U2CUNEIFORM SIGN EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM SI" +
	"GN GA GUNUCUNEIFORM SIGN GA2CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HACU" +
	"NEIFORM SIGN GA2 TIMES A PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS IGICUNEI" +
	"FORM SIGN GA2 TIMES AB2 TENU PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEIFOR" +
	"M SIGN GA2 TIMES ASHCUNEIFORM SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM SIGN" +
	" GA2 TIMES BADCUNEIFORM SIGN GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 TIM" +
	"ES BURCUNEIFORM SIGN GA2 TIMES BUR PLUS RACUNEIFORM SIGN GA2 TIMES DACUN" +
	"EIFORM SIGN GA2 TIMES DICUNEIFORM SIGN GA2 TIMES DIM TIMES SHECUNEIFORM " +
	"SIGN GA2 TIMES DUBCUNEIFORM SIGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES EL" +
	" PLUS LACUNEIFORM SIGN GA2 TIMES ENCUNEIFORM SIGN GA2 TIMES EN TIMES GAN" +
	"2 TENUCUNEIFORM SIGN GA2 TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARCUNE" +
	"IFORM SIGN GA2 TIMES GICUNEIFORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2 TI" +
	"MES GI4 PLUS ACUNEIFORM SIGN GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2 TI" +
	"MES HA PLUS LU PLUS ESH2CUNEIFORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA2 T" +
	"IMES HAL PLUS LACUNEIFORM SIGN GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2 TI" +
	"MES HUB2CUNEIFORM SIGN GA2 TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH PL" +
	"US HU PLUS ASHCUNEIFORM SIGN GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KASKA" +
	"LCUNEIFORM SIGN GA2 TIMES KIDCUNEIFORM SIGN GA2 TIMES KID PLUS LALCUNEIF" +
	"ORM SIGN GA2 TIMES KU3 PLUS ANCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SIGN " +
	"GA2 TIMES ME PLUS ENCUNEIFORM SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIMES " +
	"NUNCUNEIFORM SIGN GA2 TIMES NUN OVER NUNCUNEIFORM SIGN GA2 TIMES PACUNEI") + ("" +
	"FORM SIGN GA2 TIMES SALCUNEIFORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2 TI" +
	"MES SHECUNEIFORM SIGN GA2 TIMES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES SHI" +
	"DCUNEIFORM SIGN GA2 TIMES SUMCUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM SIGN" +
	" GA2 TIMES UCUNEIFORM SIGN GA2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PLUS " +
	"DUCUNEIFORM SIGN GA2 OVER GA2CUNEIFORM SIGN GABACUNEIFORM SIGN GABA CROS" +
	"SING GABACUNEIFORM SIGN GADCUNEIFORM SIGN GAD OVER GAD GAR OVER GARCUNEI" +
	"FORM SIGN GALCUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GARCUNEIFORM SIGN " +
	"GALAMCUNEIFORM SIGN GAMCUNEIFORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM SI" +
	"GN GAN2 TENUCUNEIFORM SIGN GAN2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING GA" +
	"N2CUNEIFORM SIGN GARCUNEIFORM SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM SI" +
	"GN GESHTINCUNEIFORM SIGN GESHTIN TIMES KURCUNEIFORM SIGN GICUNEIFORM SIG" +
	"N GI TIMES ECUNEIFORM SIGN GI TIMES UCUNEIFORM SIGN GI CROSSING GICUNEIF" +
	"ORM SIGN GI4CUNEIFORM SIGN GI4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI4CU" +
	"NEIFORM SIGN GIDIMCUNEIFORM SIGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFORM S" +
	"IGN GIR3CUNEIFORM SIGN GIR3 TIMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES GA" +
	"N2 TENUCUNEIFORM SIGN GIR3 TIMES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS IG" +
	"ICUNEIFORM SIGN GIR3 TIMES PACUNEIFORM SIGN GISALCUNEIFORM SIGN GISHCUNE" +
	"IFORM SIGN GISH CROSSING GISHCUNEIFORM SIGN GISH TIMES BADCUNEIFORM SIGN" +
	" GISH TIMES TAK4CUNEIFORM SIGN GISH TENUCUNEIFORM SIGN GUCUNEIFORM SIGN " +
	"GU CROSSING GUCUNEIFORM SIGN GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM SI" +
	"GN GU2 TIMES KAK TIMES IGI GUNUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM SIG" +
	"N GU2 TIMES SAL PLUS TUG2CUNEIFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUNEIF" +
	"ORM SIGN GUD TIMES A PLUS KURCUNEIFORM SIGN GUD TIMES KURCUNEIFORM SIGN " +
	"GUD OVER GUD LUGALCUNEIFORM SIGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN GUM" +
	" TIMES SHECUNEIFORM SIGN GURCUNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCUNEI" +
	"FORM SIGN GURUSHCUNEIFORM SIGN HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN HA" +
	" GUNUCUNEIFORM SIGN HALCUNEIFORM SIGN HICUNEIFORM SIGN HI TIMES ASHCUNEI" +
	"FORM SIGN HI TIMES ASH2CUNEIFORM SIGN HI TIMES BADCUNEIFORM SIGN HI TIME" +
	"S DISHCUNEIFORM SIGN HI TIMES GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM SI" +
	"GN HI TIMES NUNCUNEIFORM SIGN HI TIMES SHECUNEIFORM SIGN HI TIMES UCUNEI" +
	"FORM SIGN HUCUNEIFORM SIGN HUB2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM SIG" +
	"N HUB2 TIMES HALCUNEIFORM SIGN HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 TIME" +
	"S LISHCUNEIFORM SIGN HUB2 TIMES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN ICUN" +
	"EIFORM SIGN I ACUNEIFORM SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDIM O" +
	"VER IDIM BURCUNEIFORM SIGN IDIM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUNEIF" +
	"ORM SIGN IGICUNEIFORM SIGN IGI DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN IG" +
	"I OVER IGI SHIR OVER SHIR UD OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM SIG" +
	"N ILCUNEIFORM SIGN IL TIMES GAN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN IM" +
	"CUNEIFORM SIGN IM TIMES TAK4CUNEIFORM SIGN IM CROSSING IMCUNEIFORM SIGN " +
	"IM OPPOSING IMCUNEIFORM SIGN IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM SIGN" +
	" INCUNEIFORM SIGN IRCUNEIFORM SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN KA" +
	" TIMES ACUNEIFORM SIGN KA TIMES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3CUN" +
	"EIFORM SIGN KA TIMES ASH2CUNEIFORM SIGN KA TIMES BADCUNEIFORM SIGN KA TI" +
	"MES BALAGCUNEIFORM SIGN KA TIMES BARCUNEIFORM SIGN KA TIMES BICUNEIFORM " +
	"SIGN KA TIMES ERIN2CUNEIFORM SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIMES G" +
	"ACUNEIFORM SIGN KA TIMES GALCUNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFORM S" +
	"IGN KA TIMES GARCUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM SI" +
	"GN KA TIMES GICUNEIFORM SIGN KA TIMES GIR2CUNEIFORM SIGN KA TIMES GISH P" +
	"LUS SARCUNEIFORM SIGN KA TIMES GISH CROSSING GISHCUNEIFORM SIGN KA TIMES" +
	" GUCUNEIFORM SIGN KA TIMES GUR7CUNEIFORM SIGN KA TIMES IGICUNEIFORM SIGN" +
	" KA TIMES IMCUNEIFORM SIGN KA TIMES KAKCUNEIFORM SIGN KA TIMES KICUNEIFO" +
	"RM SIGN KA TIMES KIDCUNEIFORM SIGN KA TIMES LICUNEIFORM SIGN KA TIMES LU" +
	"CUNEIFORM SIGN KA TIMES MECUNEIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM SI" +
	"GN KA TIMES ME PLUS GICUNEIFORM SIGN KA TIMES ME PLUS TECUNEIFORM SIGN K" +
	"A TIMES MICUNEIFORM SIGN KA TIMES MI PLUS NUNUZCUNEIFORM SIGN KA TIMES N" +
	"ECUNEIFORM SIGN KA TIMES NUNCUNEIFORM SIGN KA TIMES PICUNEIFORM SIGN KA " +
	"TIMES RUCUNEIFORM SIGN KA TIMES SACUNEIFORM SIGN KA TIMES SARCUNEIFORM S" +
	"IGN KA TIMES SHACUNEIFORM SIGN KA TIMES SHECUNEIFORM SIGN KA TIMES SHIDC" +
	"UNEIFORM SIGN KA TIMES SHUCUNEIFORM SIGN KA TIMES SIGCUNEIFORM SIGN KA T" +
	"IMES SUHURCUNEIFORM SIGN KA TIMES TARCUNEIFORM SIGN KA TIMES UCUNEIFORM " +
	"SIGN KA TIMES U2CUNEIFORM SIGN KA TIMES UDCUNEIFORM SIGN KA TIMES UMUM T" +
	"IMES PACUNEIFORM SIGN KA TIMES USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM SI" +
	"GN KA2CUNEIFORM SIGN KA2 CROSSING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN KA" +
	"D2CUNEIFORM SIGN KAD3CUNEIFORM SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM SIG") + ("" +
	"N KAD5 OVER KAD5CUNEIFORM SIGN KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCUNEI" +
	"FORM SIGN KALCUNEIFORM SIGN KAL TIMES BADCUNEIFORM SIGN KAL CROSSING KAL" +
	"CUNEIFORM SIGN KAM2CUNEIFORM SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM SIG" +
	"N KASKAL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KASKAL OVER KASK" +
	"AL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN KI" +
	"CUNEIFORM SIGN KI TIMES BADCUNEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI TI" +
	"MES UDCUNEIFORM SIGN KIDCUNEIFORM SIGN KINCUNEIFORM SIGN KISALCUNEIFORM " +
	"SIGN KISHCUNEIFORM SIGN KISIM5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIFORM" +
	" SIGN KUCUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2CUNEIF" +
	"ORM SIGN KU3CUNEIFORM SIGN KU4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFORM S" +
	"IGN KU7CUNEIFORM SIGN KULCUNEIFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUNEIF" +
	"ORM SIGN KURCUNEIFORM SIGN KUR OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEIFOR" +
	"M SIGN KWU318CUNEIFORM SIGN LACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGAB T" +
	"IMES ACUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HACUNEIFORM SIGN LAGAB T" +
	"IMES A PLUS GARCUNEIFORM SIGN LAGAB TIMES A PLUS LALCUNEIFORM SIGN LAGAB" +
	" TIMES ALCUNEIFORM SIGN LAGAB TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH ZID" +
	"A TENUCUNEIFORM SIGN LAGAB TIMES BADCUNEIFORM SIGN LAGAB TIMES BICUNEIFO" +
	"RM SIGN LAGAB TIMES DARCUNEIFORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LAGAB" +
	" TIMES GACUNEIFORM SIGN LAGAB TIMES GARCUNEIFORM SIGN LAGAB TIMES GUDCUN" +
	"EIFORM SIGN LAGAB TIMES GUD PLUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNEIFO" +
	"RM SIGN LAGAB TIMES HALCUNEIFORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFORM " +
	"SIGN LAGAB TIMES IGI GUNUCUNEIFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN LAG" +
	"AB TIMES IM PLUS HACUNEIFORM SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIGN L" +
	"AGAB TIMES KICUNEIFORM SIGN LAGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES KU" +
	"3CUNEIFORM SIGN LAGAB TIMES KULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PL" +
	"US ACUNEIFORM SIGN LAGAB TIMES LAGABCUNEIFORM SIGN LAGAB TIMES LISHCUNEI" +
	"FORM SIGN LAGAB TIMES LUCUNEIFORM SIGN LAGAB TIMES LULCUNEIFORM SIGN LAG" +
	"AB TIMES MECUNEIFORM SIGN LAGAB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB TIM" +
	"ES MUSHCUNEIFORM SIGN LAGAB TIMES NECUNEIFORM SIGN LAGAB TIMES SHE PLUS " +
	"SUMCUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIGN L" +
	"AGAB TIMES SHITA PLUS GISH TENUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFORM " +
	"SIGN LAGAB TIMES SHU2 PLUS SHU2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFORM S" +
	"IGN LAGAB TIMES TAGCUNEIFORM SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGAB T" +
	"IMES TE PLUS A PLUS SU PLUS NACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM SIGN" +
	" LAGAB TIMES U PLUS ACUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS UCUNEIFORM" +
	" SIGN LAGAB TIMES U2 PLUS ASHCUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM SIGN" +
	" LAGAB TIMES USHCUNEIFORM SIGN LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEIFOR" +
	"M SIGN LAGAR TIMES SHECUNEIFORM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFORM S" +
	"IGN LAGAR GUNUCUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM SIG" +
	"N LAHSHUCUNEIFORM SIGN LALCUNEIFORM SIGN LAL TIMES LALCUNEIFORM SIGN LAM" +
	"CUNEIFORM SIGN LAM TIMES KURCUNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEIFOR" +
	"M SIGN LICUNEIFORM SIGN LILCUNEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCUNEI" +
	"FORM SIGN LUCUNEIFORM SIGN LU TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SIGN " +
	"LU2 TIMES ALCUNEIFORM SIGN LU2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2CUN" +
	"EIFORM SIGN LU2 TIMES ESH2 TENUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNEIFO" +
	"RM SIGN LU2 TIMES HI TIMES BADCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SIGN " +
	"LU2 TIMES KAD2CUNEIFORM SIGN LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES KAD3" +
	" PLUS ASHCUNEIFORM SIGN LU2 TIMES KICUNEIFORM SIGN LU2 TIMES LA PLUS ASH" +
	"CUNEIFORM SIGN LU2 TIMES LAGABCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNEIFO" +
	"RM SIGN LU2 TIMES NECUNEIFORM SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIMES " +
	"SI PLUS ASHCUNEIFORM SIGN LU2 TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TIMES" +
	" TUG2CUNEIFORM SIGN LU2 TENUCUNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM SIG" +
	"N LU2 OPPOSING LU2CUNEIFORM SIGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHIGCU" +
	"NEIFORM SIGN LU3CUNEIFORM SIGN LUGALCUNEIFORM SIGN LUGAL OVER LUGALCUNEI" +
	"FORM SIGN LUGAL OPPOSING LUGALCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM SIGN" +
	" LUHCUNEIFORM SIGN LULCUNEIFORM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCUNEI" +
	"FORM SIGN LUM OVER LUM GAR OVER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA TI" +
	"MES TAK4CUNEIFORM SIGN MA GUNUCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUNEIF" +
	"ORM SIGN MARCUNEIFORM SIGN MASHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MECUNE" +
	"IFORM SIGN MESCUNEIFORM SIGN MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUNEIF" +
	"ORM SIGN MU OVER MUCUNEIFORM SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM SI" +
	"GN MUNSUBCUNEIFORM SIGN MURGU2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH TIM" +
	"ES ACUNEIFORM SIGN MUSH TIMES KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFORM S" +
	"IGN MUSH OVER MUSHCUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NACUNEIFORM") + ("" +
	" SIGN MUSH CROSSING MUSHCUNEIFORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIMES A" +
	"CUNEIFORM SIGN MUSH3 TIMES A PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNEIFO" +
	"RM SIGN MUSH3 GUNUCUNEIFORM SIGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN NAGA" +
	"CUNEIFORM SIGN NAGA INVERTEDCUNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFORM " +
	"SIGN NAGA OPPOSING NAGACUNEIFORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLUCUN" +
	"EIFORM SIGN NAMCUNEIFORM SIGN NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE TIM" +
	"ES ACUNEIFORM SIGN NE TIMES UDCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN NI" +
	"CUNEIFORM SIGN NI TIMES ECUNEIFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFORM S" +
	"IGN NIM TIMES GAN2 TENUCUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUNEIF" +
	"ORM SIGN NINDA2CUNEIFORM SIGN NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TIMES" +
	" ASHCUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES " +
	"GUDCUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2 TI" +
	"MES NECUNEIFORM SIGN NINDA2 TIMES NUNCUNEIFORM SIGN NINDA2 TIMES SHECUNE" +
	"IFORM SIGN NINDA2 TIMES SHE PLUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE PLU" +
	"S ASHCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN NIN" +
	"DA2 TIMES U2 PLUS ASHCUNEIFORM SIGN NINDA2 TIMES USHCUNEIFORM SIGN NISAG" +
	"CUNEIFORM SIGN NUCUNEIFORM SIGN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN NUN" +
	" LAGAR TIMES GARCUNEIFORM SIGN NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN LA" +
	"GAR TIMES SALCUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL" +
	"CUNEIFORM SIGN NUN LAGAR TIMES USHCUNEIFORM SIGN NUN TENUCUNEIFORM SIGN " +
	"NUN OVER NUNCUNEIFORM SIGN NUN CROSSING NUNCUNEIFORM SIGN NUN CROSSING N" +
	"UN LAGAR OVER LAGARCUNEIFORM SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES AS" +
	"HGABCUNEIFORM SIGN NUNUZ AB2 TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES DUGC" +
	"UNEIFORM SIGN NUNUZ AB2 TIMES GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU" +
	"CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LACUNE" +
	"IFORM SIGN NUNUZ AB2 TIMES NECUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNEIFO" +
	"RM SIGN NUNUZ AB2 TIMES U2CUNEIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFORM " +
	"SIGN NUNUZ KISIM5 TIMES BI UCUNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIFORM" +
	" SIGN PANCUNEIFORM SIGN PAPCUNEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEIFOR" +
	"M SIGN PI TIMES ACUNEIFORM SIGN PI TIMES ABCUNEIFORM SIGN PI TIMES BICUN" +
	"EIFORM SIGN PI TIMES BUCUNEIFORM SIGN PI TIMES ECUNEIFORM SIGN PI TIMES " +
	"ICUNEIFORM SIGN PI TIMES IBCUNEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI TI" +
	"MES U2CUNEIFORM SIGN PI CROSSING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN PI" +
	"RIG TIMES KALCUNEIFORM SIGN PIRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES ZAC" +
	"UNEIFORM SIGN PIRIG OPPOSING PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RABCUN" +
	"EIFORM SIGN RICUNEIFORM SIGN RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NUTIL" +
	"LUCUNEIFORM SIGN SAGCUNEIFORM SIGN SAG TIMES ACUNEIFORM SIGN SAG TIMES D" +
	"UCUNEIFORM SIGN SAG TIMES DUBCUNEIFORM SIGN SAG TIMES HACUNEIFORM SIGN S" +
	"AG TIMES KAKCUNEIFORM SIGN SAG TIMES KURCUNEIFORM SIGN SAG TIMES LUMCUNE" +
	"IFORM SIGN SAG TIMES MICUNEIFORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG TI" +
	"MES SALCUNEIFORM SIGN SAG TIMES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEIFOR" +
	"M SIGN SAG TIMES U2CUNEIFORM SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIMES U" +
	"MCUNEIFORM SIGN SAG TIMES URCUNEIFORM SIGN SAG TIMES USHCUNEIFORM SIGN S" +
	"AG OVER SAGCUNEIFORM SIGN SAG GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SAL L" +
	"AGAB TIMES ASH2CUNEIFORM SIGN SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN SHA" +
	"CUNEIFORM SIGN SHA3CUNEIFORM SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIMES " +
	"BADCUNEIFORM SIGN SHA3 TIMES GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFORM S" +
	"IGN SHA3 TIMES SHU2CUNEIFORM SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 TIME" +
	"S UCUNEIFORM SIGN SHA3 TIMES U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIGN S" +
	"HAB6CUNEIFORM SIGN SHAR2CUNEIFORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIFORM" +
	" SIGN SHE OVER SHE GAD OVER GAD GAR OVER GARCUNEIFORM SIGN SHE OVER SHE " +
	"TAB OVER TAB GAR OVER GARCUNEIFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEIFOR" +
	"M SIGN SHESHCUNEIFORM SIGN SHESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIGN S" +
	"HIDCUNEIFORM SIGN SHID TIMES ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM SIGN" +
	" SHIMCUNEIFORM SIGN SHIM TIMES ACUNEIFORM SIGN SHIM TIMES BALCUNEIFORM S" +
	"IGN SHIM TIMES BULUGCUNEIFORM SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM TIM" +
	"ES GARCUNEIFORM SIGN SHIM TIMES IGICUNEIFORM SIGN SHIM TIMES IGI GUNUCUN" +
	"EIFORM SIGN SHIM TIMES KUSHU2CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM SIGN" +
	" SHIM TIMES MUGCUNEIFORM SIGN SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNEIFO" +
	"RM SIGN SHIRCUNEIFORM SIGN SHIR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR OV" +
	"ER BURCUNEIFORM SIGN SHITACUNEIFORM SIGN SHUCUNEIFORM SIGN SHU OVER INVE" +
	"RTED SHUCUNEIFORM SIGN SHU2CUNEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNEIFO" +
	"RM SIGN SI GUNUCUNEIFORM SIGN SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SIG4 " +
	"OVER SIG4 SHU2CUNEIFORM SIGN SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN SUCU") + ("" +
	"NEIFORM SIGN SU OVER SUCUNEIFORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM SI" +
	"GN SUHURCUNEIFORM SIGN SUMCUNEIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNEIFO" +
	"RM SIGN SUR9CUNEIFORM SIGN TACUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN TA" +
	" TIMES HICUNEIFORM SIGN TA TIMES MICUNEIFORM SIGN TA GUNUCUNEIFORM SIGN " +
	"TABCUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISHCUNEIFORM SIGN T" +
	"AB SQUAREDCUNEIFORM SIGN TAGCUNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN TA" +
	"G TIMES GUDCUNEIFORM SIGN TAG TIMES SHECUNEIFORM SIGN TAG TIMES SHUCUNEI" +
	"FORM SIGN TAG TIMES TUG2CUNEIFORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK4CU" +
	"NEIFORM SIGN TARCUNEIFORM SIGN TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN TI" +
	"CUNEIFORM SIGN TI TENUCUNEIFORM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM SIGN" +
	" TIR TIMES TAK4CUNEIFORM SIGN TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR GA" +
	"D OVER GAD GAR OVER GARCUNEIFORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM SIG" +
	"N TUKCUNEIFORM SIGN TUMCUNEIFORM SIGN TURCUNEIFORM SIGN TUR OVER TUR ZA " +
	"OVER ZACUNEIFORM SIGN UCUNEIFORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIFORM" +
	" SIGN U OVER U PA OVER PA GAR OVER GARCUNEIFORM SIGN U OVER U SUR OVER S" +
	"URCUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSEDCUNEIFORM SIGN U2CUN" +
	"EIFORM SIGN UBCUNEIFORM SIGN UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN UD" +
	" TIMES BADCUNEIFORM SIGN UD TIMES MICUNEIFORM SIGN UD TIMES U PLUS U PLU" +
	"S UCUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNUCUN" +
	"EIFORM SIGN UD SHESHIGCUNEIFORM SIGN UD SHESHIG TIMES BADCUNEIFORM SIGN " +
	"UDUGCUNEIFORM SIGN UMCUNEIFORM SIGN UM TIMES LAGABCUNEIFORM SIGN UM TIME" +
	"S ME PLUS DACUNEIFORM SIGN UM TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNEIFO" +
	"RM SIGN UMBINCUNEIFORM SIGN UMUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEIFOR" +
	"M SIGN UMUM TIMES PACUNEIFORM SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM SIG" +
	"N URCUNEIFORM SIGN UR CROSSING URCUNEIFORM SIGN UR SHESHIGCUNEIFORM SIGN" +
	" UR2CUNEIFORM SIGN UR2 TIMES A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS NA" +
	"CUNEIFORM SIGN UR2 TIMES ALCUNEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN UR2" +
	" TIMES NUNCUNEIFORM SIGN UR2 TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS AS" +
	"HCUNEIFORM SIGN UR2 TIMES U2 PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN URI" +
	"CUNEIFORM SIGN URI3CUNEIFORM SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIFORM" +
	" SIGN URU TIMES ASHGABCUNEIFORM SIGN URU TIMES BARCUNEIFORM SIGN URU TIM" +
	"ES DUNCUNEIFORM SIGN URU TIMES GACUNEIFORM SIGN URU TIMES GALCUNEIFORM S" +
	"IGN URU TIMES GAN2 TENUCUNEIFORM SIGN URU TIMES GARCUNEIFORM SIGN URU TI" +
	"MES GUCUNEIFORM SIGN URU TIMES HACUNEIFORM SIGN URU TIMES IGICUNEIFORM S" +
	"IGN URU TIMES IMCUNEIFORM SIGN URU TIMES ISHCUNEIFORM SIGN URU TIMES KIC" +
	"UNEIFORM SIGN URU TIMES LUMCUNEIFORM SIGN URU TIMES MINCUNEIFORM SIGN UR" +
	"U TIMES PACUNEIFORM SIGN URU TIMES SHECUNEIFORM SIGN URU TIMES SIG4CUNEI" +
	"FORM SIGN URU TIMES TUCUNEIFORM SIGN URU TIMES U PLUS GUDCUNEIFORM SIGN " +
	"URU TIMES UDCUNEIFORM SIGN URU TIMES URUDACUNEIFORM SIGN URUDACUNEIFORM " +
	"SIGN URUDA TIMES UCUNEIFORM SIGN USHCUNEIFORM SIGN USH TIMES ACUNEIFORM " +
	"SIGN USH TIMES KUCUNEIFORM SIGN USH TIMES KURCUNEIFORM SIGN USH TIMES TA" +
	"K4CUNEIFORM SIGN USHXCUNEIFORM SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFORM S" +
	"IGN UTUKICUNEIFORM SIGN UZ3CUNEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM SIGN" +
	" UZUCUNEIFORM SIGN ZACUNEIFORM SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED TIM" +
	"ES KURCUNEIFORM SIGN ZAGCUNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFORM S" +
	"IGN ZICUNEIFORM SIGN ZI OVER ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCUNEI" +
	"FORM SIGN ZIB KABA TENUCUNEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM SI" +
	"GN ZUCUNEIFORM SIGN ZU5CUNEIFORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBURCUN" +
	"EIFORM SIGN ZUMCUNEIFORM SIGN KAP ELAMITECUNEIFORM SIGN AB TIMES NUNCUNE" +
	"IFORM SIGN AB2 TIMES ACUNEIFORM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG KI" +
	"SIM5 TIMES U2 PLUS MASHCUNEIFORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SHUCU" +
	"NEIFORM SIGN DUB TIMES SHECUNEIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN EZ" +
	"EN TIMES SHECUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN GA" +
	"2 TIMES ASH2CUNEIFORM SIGN GE22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHCUNE" +
	"IFORM SIGN KA TIMES ANSHECUNEIFORM SIGN KA TIMES ASH3CUNEIFORM SIGN KA T" +
	"IMES GISHCUNEIFORM SIGN KA TIMES GUDCUNEIFORM SIGN KA TIMES HI TIMES ASH" +
	"2CUNEIFORM SIGN KA TIMES LUMCUNEIFORM SIGN KA TIMES PACUNEIFORM SIGN KA " +
	"TIMES SHULCUNEIFORM SIGN KA TIMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIFORM" +
	" SIGN LAGAB TIMES GICUNEIFORM SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIGN L" +
	"U2 TIMES ESH2 PLUS LALCUNEIFORM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESHCUN" +
	"EIFORM SIGN MUSH3 TIMES ZACUNEIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFORM " +
	"SIGN NIN9CUNEIFORM SIGN NINDA2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES GICU" +
	"NEIFORM SIGN NU11 ROTATED NINETY DEGREESCUNEIFORM SIGN PESH2 ASTERISKCUN" +
	"EIFORM SIGN PIR2CUNEIFORM SIGN SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CUNEI") + ("" +
	"FORM SIGN UM TIMES MECUNEIFORM SIGN U UCUNEIFORM NUMERIC SIGN TWO ASHCUN" +
	"EIFORM NUMERIC SIGN THREE ASHCUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM NU" +
	"MERIC SIGN FIVE ASHCUNEIFORM NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SIGN " +
	"SEVEN ASHCUNEIFORM NUMERIC SIGN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE ASH" +
	"CUNEIFORM NUMERIC SIGN THREE DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNEIFO" +
	"RM NUMERIC SIGN FIVE DISHCUNEIFORM NUMERIC SIGN SIX DISHCUNEIFORM NUMERI" +
	"C SIGN SEVEN DISHCUNEIFORM NUMERIC SIGN EIGHT DISHCUNEIFORM NUMERIC SIGN" +
	" NINE DISHCUNEIFORM NUMERIC SIGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UCUNE" +
	"IFORM NUMERIC SIGN SIX UCUNEIFORM NUMERIC SIGN SEVEN UCUNEIFORM NUMERIC " +
	"SIGN EIGHT UCUNEIFORM NUMERIC SIGN NINE UCUNEIFORM NUMERIC SIGN ONE GESH" +
	"2CUNEIFORM NUMERIC SIGN TWO GESH2CUNEIFORM NUMERIC SIGN THREE GESH2CUNEI" +
	"FORM NUMERIC SIGN FOUR GESH2CUNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFORM N" +
	"UMERIC SIGN SIX GESH2CUNEIFORM NUMERIC SIGN SEVEN GESH2CUNEIFORM NUMERIC" +
	" SIGN EIGHT GESH2CUNEIFORM NUMERIC SIGN NINE GESH2CUNEIFORM NUMERIC SIGN" +
	" ONE GESHUCUNEIFORM NUMERIC SIGN TWO GESHUCUNEIFORM NUMERIC SIGN THREE G" +
	"ESHUCUNEIFORM NUMERIC SIGN FOUR GESHUCUNEIFORM NUMERIC SIGN FIVE GESHUCU" +
	"NEIFORM NUMERIC SIGN TWO SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEIFOR" +
	"M NUMERIC SIGN THREE SHAR2 VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHAR2" +
	"CUNEIFORM NUMERIC SIGN FIVE SHAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNEIFO" +
	"RM NUMERIC SIGN SEVEN SHAR2CUNEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFORM N" +
	"UMERIC SIGN NINE SHAR2CUNEIFORM NUMERIC SIGN ONE SHARUCUNEIFORM NUMERIC " +
	"SIGN TWO SHARUCUNEIFORM NUMERIC SIGN THREE SHARUCUNEIFORM NUMERIC SIGN T" +
	"HREE SHARU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUMERI" +
	"C SIGN FIVE SHARUCUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNEIFO" +
	"RM NUMERIC SIGN SHAR2 TIMES GAL PLUS MINCUNEIFORM NUMERIC SIGN ONE BURUC" +
	"UNEIFORM NUMERIC SIGN TWO BURUCUNEIFORM NUMERIC SIGN THREE BURUCUNEIFORM" +
	" NUMERIC SIGN THREE BURU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR BURUCUN" +
	"EIFORM NUMERIC SIGN FIVE BURUCUNEIFORM NUMERIC SIGN THREE VARIANT FORM E" +
	"SH16CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21CUNEIFORM NUMERIC SIG" +
	"N FOUR VARIANT FORM LIMMUCUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4" +
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU ACUNEIFORM NUMERIC SIGN F" +
	"OUR VARIANT FORM LIMMU BCUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9CUNE" +
	"IFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEVEN " +
	"VARIANT FORM IMIN ACUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN BCUNEI" +
	"FORM NUMERIC SIGN EIGHT VARIANT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT VA" +
	"RIANT FORM USSU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMUCUNEIFORM" +
	" NUMERIC SIGN NINE VARIANT FORM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VARIA" +
	"NT FORM ILIMMU4CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU ACUNEIFOR" +
	"M NUMERIC SIGN TWO ASH TENUCUNEIFORM NUMERIC SIGN THREE ASH TENUCUNEIFOR" +
	"M NUMERIC SIGN FOUR ASH TENUCUNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEIFOR" +
	"M NUMERIC SIGN SIX ASH TENUCUNEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM NUME" +
	"RIC SIGN TWO BAN2CUNEIFORM NUMERIC SIGN THREE BAN2CUNEIFORM NUMERIC SIGN" +
	" FOUR BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORMCUNEIFORM NUMERIC" +
	" SIGN FIVE BAN2CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM NU" +
	"MERIC SIGN NIGIDAMINCUNEIFORM NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC SI" +
	"GN ONE ESHE3CUNEIFORM NUMERIC SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ONE T" +
	"HIRD DISHCUNEIFORM NUMERIC SIGN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN FI" +
	"VE SIXTHS DISHCUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM ACUNEIFORM N" +
	"UMERIC SIGN TWO THIRDS VARIANT FORM ACUNEIFORM NUMERIC SIGN ONE EIGHTH A" +
	"SHCUNEIFORM NUMERIC SIGN ONE QUARTER ASHCUNEIFORM NUMERIC SIGN OLD ASSYR" +
	"IAN ONE SIXTHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM NU" +
	"MERIC SIGN ONE QUARTER GURCUNEIFORM NUMERIC SIGN ONE HALF GURCUNEIFORM N" +
	"UMERIC SIGN ELAMITE ONE THIRDCUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDSCU" +
	"NEIFORM NUMERIC SIGN ELAMITE FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFTYCU" +
	"NEIFORM NUMERIC SIGN FOUR U VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U VA" +
	"RIANT FORMCUNEIFORM NUMERIC SIGN SIX U VARIANT FORMCUNEIFORM NUMERIC SIG" +
	"N SEVEN U VARIANT FORMCUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORMCUNEIFO" +
	"RM NUMERIC SIGN NINE U VARIANT FORMCUNEIFORM PUNCTUATION SIGN OLD ASSYRI" +
	"AN WORD DIVIDERCUNEIFORM PUNCTUATION SIGN VERTICAL COLONCUNEIFORM PUNCTU" +
	"ATION SIGN DIAGONAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLONCUN" +
	"EIFORM PUNCTUATION SIGN DIAGONAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN TE" +
	"NUCUNEIFORM SIGN AB TIMES SHU2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM SIGN" +
	" BAD TIMES DISH TENUCUNEIFORM SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAHAR2" +
	" TIMES NICUNEIFORM SIGN BAHAR2 TIMES ZACUNEIFORM SIGN BU OVER BU TIMES N") + ("" +
	"A2CUNEIFORM SIGN DA TIMES TAK4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM SIGN" +
	" DIM TIMES IGICUNEIFORM SIGN DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES UD" +
	"CUNEIFORM SIGN DUG TIMES ANSHECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM SIGN" +
	" DUG TIMES ASH AT LEFTCUNEIFORM SIGN DUG TIMES DINCUNEIFORM SIGN DUG TIM" +
	"ES DUNCUNEIFORM SIGN DUG TIMES ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIFORM" +
	" SIGN DUG TIMES GICUNEIFORM SIGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DUG T" +
	"IMES GISHCUNEIFORM SIGN DUG TIMES HACUNEIFORM SIGN DUG TIMES HICUNEIFORM" +
	" SIGN DUG TIMES IGI GUNUCUNEIFORM SIGN DUG TIMES KASKALCUNEIFORM SIGN DU" +
	"G TIMES KURCUNEIFORM SIGN DUG TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KUSHU" +
	"2 PLUS KASKALCUNEIFORM SIGN DUG TIMES LAK-020CUNEIFORM SIGN DUG TIMES LA" +
	"MCUNEIFORM SIGN DUG TIMES LAM TIMES KURCUNEIFORM SIGN DUG TIMES LUH PLUS" +
	" GISHCUNEIFORM SIGN DUG TIMES MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFORM " +
	"SIGN DUG TIMES MICUNEIFORM SIGN DUG TIMES NICUNEIFORM SIGN DUG TIMES PIC" +
	"UNEIFORM SIGN DUG TIMES SHECUNEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM SIG" +
	"N E2 TIMES KURCUNEIFORM SIGN E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIFORM" +
	" SIGN ESH2 CROSSING ESH2CUNEIFORM SIGN EZEN SHESHIG TIMES ASHCUNEIFORM S" +
	"IGN EZEN SHESHIG TIMES HICUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNUCUNEI" +
	"FORM SIGN EZEN SHESHIG TIMES LACUNEIFORM SIGN EZEN SHESHIG TIMES LALCUNE" +
	"IFORM SIGN EZEN SHESHIG TIMES MECUNEIFORM SIGN EZEN SHESHIG TIMES MESCUN" +
	"EIFORM SIGN EZEN SHESHIG TIMES SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFORM S" +
	"IGN GA2 TIMES BAHAR2CUNEIFORM SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN GA2 " +
	"TIMES DUG TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES KASKALCUNEIFO" +
	"RM SIGN GA2 TIMES ERENCUNEIFORM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 TIME" +
	"S GAR PLUS DICUNEIFORM SIGN GA2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 TIME" +
	"S HA PLUS ACUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN GA2" +
	" TIMES LAMCUNEIFORM SIGN GA2 TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TIMES" +
	" LUHCUNEIFORM SIGN GA2 TIMES MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM SI" +
	"GN GA2 TIMES NE PLUS E2CUNEIFORM SIGN GA2 TIMES NE PLUS GICUNEIFORM SIGN" +
	" GA2 TIMES SHIMCUNEIFORM SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTATED " +
	"NINETY DEGREESCUNEIFORM SIGN GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES GI" +
	"SH CROSSING GISHCUNEIFORM SIGN GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD PLUS" +
	" GISH TIMES TAK4CUNEIFORM SIGN HA TENU GUNUCUNEIFORM SIGN HI TIMES ASH O" +
	"VER HI TIMES ASHCUNEIFORM SIGN KA TIMES BUCUNEIFORM SIGN KA TIMES KACUNE" +
	"IFORM SIGN KA TIMES U U UCUNEIFORM SIGN KA TIMES URCUNEIFORM SIGN LAGAB " +
	"TIMES ZU OVER ZUCUNEIFORM SIGN LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM SI" +
	"GN LAK-025CUNEIFORM SIGN LAK-030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN LAK" +
	"-051CUNEIFORM SIGN LAK-062CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNUCUNEIF" +
	"ORM SIGN LAK-080CUNEIFORM SIGN LAK-081 OVER LAK-081CUNEIFORM SIGN LAK-09" +
	"2CUNEIFORM SIGN LAK-130CUNEIFORM SIGN LAK-142CUNEIFORM SIGN LAK-210CUNEI" +
	"FORM SIGN LAK-219CUNEIFORM SIGN LAK-220CUNEIFORM SIGN LAK-225CUNEIFORM S" +
	"IGN LAK-228CUNEIFORM SIGN LAK-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN LA" +
	"K-266CUNEIFORM SIGN LAK-343CUNEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-348C" +
	"UNEIFORM SIGN LAK-383CUNEIFORM SIGN LAK-384CUNEIFORM SIGN LAK-390CUNEIFO" +
	"RM SIGN LAK-441CUNEIFORM SIGN LAK-449CUNEIFORM SIGN LAK-449 TIMES GUCUNE" +
	"IFORM SIGN LAK-449 TIMES IGICUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3CUN" +
	"EIFORM SIGN LAK-449 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449 TI" +
	"MES U2 PLUS BACUNEIFORM SIGN LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM SIGN" +
	" LAK-470CUNEIFORM SIGN LAK-483CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LAK-4" +
	"92CUNEIFORM SIGN LAK-493CUNEIFORM SIGN LAK-495CUNEIFORM SIGN LAK-550CUNE" +
	"IFORM SIGN LAK-608CUNEIFORM SIGN LAK-617CUNEIFORM SIGN LAK-617 TIMES ASH" +
	"CUNEIFORM SIGN LAK-617 TIMES BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU G" +
	"UNUCUNEIFORM SIGN LAK-617 TIMES KU3CUNEIFORM SIGN LAK-617 TIMES LACUNEIF" +
	"ORM SIGN LAK-617 TIMES TARCUNEIFORM SIGN LAK-617 TIMES TECUNEIFORM SIGN " +
	"LAK-617 TIMES U2CUNEIFORM SIGN LAK-617 TIMES UDCUNEIFORM SIGN LAK-617 TI" +
	"MES URUDACUNEIFORM SIGN LAK-636CUNEIFORM SIGN LAK-648CUNEIFORM SIGN LAK-" +
	"648 TIMES DUBCUNEIFORM SIGN LAK-648 TIMES GACUNEIFORM SIGN LAK-648 TIMES" +
	" IGICUNEIFORM SIGN LAK-648 TIMES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES NI" +
	"CUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-648" +
	" TIMES SHESH PLUS KICUNEIFORM SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK-64" +
	"8 TIMES URUDACUNEIFORM SIGN LAK-724CUNEIFORM SIGN LAK-749CUNEIFORM SIGN " +
	"LU2 GUNU TIMES ASHCUNEIFORM SIGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIMES " +
	"HALCUNEIFORM SIGN LU2 TIMES PAPCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLU" +
	"S LU3CUNEIFORM SIGN LU2 TIMES TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM SI" +
	"GN MUSH OVER MUSH TIMES GACUNEIFORM SIGN MUSH OVER MUSH TIMES KAKCUNEIFO") + ("" +
	"RM SIGN NINDA2 TIMES DIM GUNUCUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFORM S" +
	"IGN NINDA2 TIMES GULCUNEIFORM SIGN NINDA2 TIMES HICUNEIFORM SIGN NINDA2 " +
	"TIMES KESH2CUNEIFORM SIGN NINDA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 TIME" +
	"S MASHCUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 TIME" +
	"S UCUNEIFORM SIGN NINDA2 TIMES U PLUS UCUNEIFORM SIGN NINDA2 TIMES URUDA" +
	"CUNEIFORM SIGN SAG GUNU TIMES HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM SIG" +
	"N SAG TIMES SHE AT LEFTCUNEIFORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SHA6 " +
	"TENUCUNEIFORM SIGN SHE OVER SHECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM SIG" +
	"N SHE PLUS NAM2CUNEIFORM SIGN SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DUG T" +
	"IMES NICUNEIFORM SIGN SHU2 PLUS E2 TIMES ANCUNEIFORM SIGN SI TIMES TAK4C" +
	"UNEIFORM SIGN TAK4 PLUS SAGCUNEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFORM S" +
	"IGN TUM TIMES THREE DISHCUNEIFORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2 TI" +
	"MES UDCUNEIFORM SIGN URU TIMES DARA3CUNEIFORM SIGN URU TIMES LAK-668CUNE" +
	"IFORM SIGN URU TIMES LU3CUNEIFORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU PLUS" +
	" SARCUNEIFORM SIGN ZU5 TIMES THREE DISH TENUCYPRO-MINOAN SIGN CM001CYPRO" +
	"-MINOAN SIGN CM002CYPRO-MINOAN SIGN CM004CYPRO-MINOAN SIGN CM005CYPRO-MI" +
	"NOAN SIGN CM006CYPRO-MINOAN SIGN CM007CYPRO-MINOAN SIGN CM008CYPRO-MINOA" +
	"N SIGN CM009CYPRO-MINOAN SIGN CM010CYPRO-MINOAN SIGN CM011CYPRO-MINOAN S" +
	"IGN CM012CYPRO-MINOAN SIGN CM012BCYPRO-MINOAN SIGN CM013CYPRO-MINOAN SIG" +
	"N CM015CYPRO-MINOAN SIGN CM017CYPRO-MINOAN SIGN CM019CYPRO-MINOAN SIGN C" +
	"M021CYPRO-MINOAN SIGN CM023CYPRO-MINOAN SIGN CM024CYPRO-MINOAN SIGN CM02" +
	"5CYPRO-MINOAN SIGN CM026CYPRO-MINOAN SIGN CM027CYPRO-MINOAN SIGN CM028CY" +
	"PRO-MINOAN SIGN CM029CYPRO-MINOAN SIGN CM030CYPRO-MINOAN SIGN CM033CYPRO" +
	"-MINOAN SIGN CM034CYPRO-MINOAN SIGN CM035CYPRO-MINOAN SIGN CM036CYPRO-MI" +
	"NOAN SIGN CM037CYPRO-MINOAN SIGN CM038CYPRO-MINOAN SIGN CM039CYPRO-MINOA" +
	"N SIGN CM040CYPRO-MINOAN SIGN CM041CYPRO-MINOAN SIGN CM044CYPRO-MINOAN S" +
	"IGN CM046CYPRO-MINOAN SIGN CM047CYPRO-MINOAN SIGN CM049CYPRO-MINOAN SIGN" +
	" CM050CYPRO-MINOAN SIGN CM051CYPRO-MINOAN SIGN CM052CYPRO-MINOAN SIGN CM" +
	"053CYPRO-MINOAN SIGN CM054CYPRO-MINOAN SIGN CM055CYPRO-MINOAN SIGN CM056" +
	"CYPRO-MINOAN SIGN CM058CYPRO-MINOAN SIGN CM059CYPRO-MINOAN SIGN CM060CYP" +
	"RO-MINOAN SIGN CM061CYPRO-MINOAN SIGN CM062CYPRO-MINOAN SIGN CM063CYPRO-" +
	"MINOAN SIGN CM064CYPRO-MINOAN SIGN CM066CYPRO-MINOAN SIGN CM067CYPRO-MIN" +
	"OAN SIGN CM068CYPRO-MINOAN SIGN CM069CYPRO-MINOAN SIGN CM070CYPRO-MINOAN" +
	" SIGN CM071CYPRO-MINOAN SIGN CM072CYPRO-MINOAN SIGN CM073CYPRO-MINOAN SI" +
	"GN CM074CYPRO-MINOAN SIGN CM075CYPRO-MINOAN SIGN CM075BCYPRO-MINOAN SIGN" +
	" CM076CYPRO-MINOAN SIGN CM078CYPRO-MINOAN SIGN CM079CYPRO-MINOAN SIGN CM" +
	"080CYPRO-MINOAN SIGN CM081CYPRO-MINOAN SIGN CM082CYPRO-MINOAN SIGN CM083" +
	"CYPRO-MINOAN SIGN CM084CYPRO-MINOAN SIGN CM085CYPRO-MINOAN SIGN CM086CYP" +
	"RO-MINOAN SIGN CM087CYPRO-MINOAN SIGN CM088CYPRO-MINOAN SIGN CM089CYPRO-" +
	"MINOAN SIGN CM090CYPRO-MINOAN SIGN CM091CYPRO-MINOAN SIGN CM092CYPRO-MIN" +
	"OAN SIGN CM094CYPRO-MINOAN SIGN CM095CYPRO-MINOAN SIGN CM096CYPRO-MINOAN" +
	" SIGN CM097CYPRO-MINOAN SIGN CM098CYPRO-MINOAN SIGN CM099CYPRO-MINOAN SI" +
	"GN CM100CYPRO-MINOAN SIGN CM101CYPRO-MINOAN SIGN CM102CYPRO-MINOAN SIGN " +
	"CM103CYPRO-MINOAN SIGN CM104CYPRO-MINOAN SIGN CM105CYPRO-MINOAN SIGN CM1" +
	"07CYPRO-MINOAN SIGN CM108CYPRO-MINOAN SIGN CM109CYPRO-MINOAN SIGN CM110C" +
	"YPRO-MINOAN SIGN CM112CYPRO-MINOAN SIGN CM114CYPRO-MINOAN SIGN CM301CYPR" +
	"O-MINOAN SIGN CM302EGYPTIAN HIEROGLYPH A001EGYPTIAN HIEROGLYPH A002EGYPT" +
	"IAN HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004EGYPTIAN HIEROGLYPH A005EGYPT" +
	"IAN HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006EGYPTIAN HIEROGLYPH A006AEGY" +
	"PTIAN HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A007EGYPTIAN HIEROGLYPH A008EG" +
	"YPTIAN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A010EGYPTIAN HIEROGLYPH A011EG" +
	"YPTIAN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A013EGYPTIAN HIEROGLYPH A014EG" +
	"YPTIAN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A015EGYPTIAN HIEROGLYPH A016E" +
	"GYPTIAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A017AEGYPTIAN HIEROGLYPH A018" +
	"EGYPTIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH A020EGYPTIAN HIEROGLYPH A021" +
	"EGYPTIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH A023EGYPTIAN HIEROGLYPH A024" +
	"EGYPTIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH A026EGYPTIAN HIEROGLYPH A027" +
	"EGYPTIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH A029EGYPTIAN HIEROGLYPH A030" +
	"EGYPTIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH A032EGYPTIAN HIEROGLYPH A032" +
	"AEGYPTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH A034EGYPTIAN HIEROGLYPH A03" +
	"5EGYPTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH A037EGYPTIAN HIEROGLYPH A03" +
	"8EGYPTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH A040EGYPTIAN HIEROGLYPH A04" +
	"0AEGYPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYPH A042EGYPTIAN HIEROGLYPH A0" +
	"42AEGYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLYPH A043AEGYPTIAN HIEROGLYPH ") + ("" +
	"A044EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGLYPH A045AEGYPTIAN HIEROGLYPH" +
	" A046EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROGLYPH A048EGYPTIAN HIEROGLYPH" +
	" A049EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROGLYPH A051EGYPTIAN HIEROGLYPH" +
	" A052EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROGLYPH A054EGYPTIAN HIEROGLYPH" +
	" A055EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROGLYPH A057EGYPTIAN HIEROGLYPH" +
	" A058EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROGLYPH A060EGYPTIAN HIEROGLYPH" +
	" A061EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROGLYPH A063EGYPTIAN HIEROGLYPH" +
	" A064EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROGLYPH A066EGYPTIAN HIEROGLYPH" +
	" A067EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROGLYPH A069EGYPTIAN HIEROGLYPH" +
	" A070EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROGLYPH B002EGYPTIAN HIEROGLYPH" +
	" B003EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROGLYPH B005EGYPTIAN HIEROGLYPH" +
	" B005AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIEROGLYPH B007EGYPTIAN HIEROGLYP" +
	"H B008EGYPTIAN HIEROGLYPH B009EGYPTIAN HIEROGLYPH C001EGYPTIAN HIEROGLYP" +
	"H C002EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIEROGLYPH C002BEGYPTIAN HIEROGL" +
	"YPH C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HIEROGLYPH C004EGYPTIAN HIEROG" +
	"LYPH C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HIEROGLYPH C007EGYPTIAN HIEROG" +
	"LYPH C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HIEROGLYPH C010EGYPTIAN HIEROG" +
	"LYPH C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN HIEROGLYPH C012EGYPTIAN HIERO" +
	"GLYPH C013EGYPTIAN HIEROGLYPH C014EGYPTIAN HIEROGLYPH C015EGYPTIAN HIERO" +
	"GLYPH C016EGYPTIAN HIEROGLYPH C017EGYPTIAN HIEROGLYPH C018EGYPTIAN HIERO" +
	"GLYPH C019EGYPTIAN HIEROGLYPH C020EGYPTIAN HIEROGLYPH C021EGYPTIAN HIERO" +
	"GLYPH C022EGYPTIAN HIEROGLYPH C023EGYPTIAN HIEROGLYPH C024EGYPTIAN HIERO" +
	"GLYPH D001EGYPTIAN HIEROGLYPH D002EGYPTIAN HIEROGLYPH D003EGYPTIAN HIERO" +
	"GLYPH D004EGYPTIAN HIEROGLYPH D005EGYPTIAN HIEROGLYPH D006EGYPTIAN HIERO" +
	"GLYPH D007EGYPTIAN HIEROGLYPH D008EGYPTIAN HIEROGLYPH D008AEGYPTIAN HIER" +
	"OGLYPH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN HIEROGLYPH D011EGYPTIAN HIER" +
	"OGLYPH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN HIEROGLYPH D014EGYPTIAN HIER" +
	"OGLYPH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN HIEROGLYPH D017EGYPTIAN HIER" +
	"OGLYPH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN HIEROGLYPH D020EGYPTIAN HIER" +
	"OGLYPH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN HIEROGLYPH D023EGYPTIAN HIER" +
	"OGLYPH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN HIEROGLYPH D026EGYPTIAN HIER" +
	"OGLYPH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN HIEROGLYPH D028EGYPTIAN HIE" +
	"ROGLYPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN HIEROGLYPH D031EGYPTIAN HIE" +
	"ROGLYPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIAN HIEROGLYPH D033EGYPTIAN HI" +
	"EROGLYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTIAN HIEROGLYPH D035EGYPTIAN H" +
	"IEROGLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTIAN HIEROGLYPH D038EGYPTIAN H" +
	"IEROGLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTIAN HIEROGLYPH D041EGYPTIAN H" +
	"IEROGLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTIAN HIEROGLYPH D044EGYPTIAN H" +
	"IEROGLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTIAN HIEROGLYPH D046AEGYPTIAN " +
	"HIEROGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPTIAN HIEROGLYPH D048AEGYPTIAN" +
	" HIEROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYPTIAN HIEROGLYPH D050AEGYPTIA" +
	"N HIEROGLYPH D050BEGYPTIAN HIEROGLYPH D050CEGYPTIAN HIEROGLYPH D050DEGYP" +
	"TIAN HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D050FEGYPTIAN HIEROGLYPH D050GE" +
	"GYPTIAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH D050IEGYPTIAN HIEROGLYPH D05" +
	"1EGYPTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH D052AEGYPTIAN HIEROGLYPH D0" +
	"53EGYPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYPH D054AEGYPTIAN HIEROGLYPH D" +
	"055EGYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLYPH D057EGYPTIAN HIEROGLYPH D" +
	"058EGYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLYPH D060EGYPTIAN HIEROGLYPH D" +
	"061EGYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLYPH D063EGYPTIAN HIEROGLYPH D" +
	"064EGYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLYPH D066EGYPTIAN HIEROGLYPH D" +
	"067EGYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGLYPH D067BEGYPTIAN HIEROGLYPH" +
	" D067CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIEROGLYPH D067EEGYPTIAN HIEROGL" +
	"YPH D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN HIEROGLYPH D067HEGYPTIAN HIER" +
	"OGLYPH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN HIEROGLYPH E003EGYPTIAN HIER" +
	"OGLYPH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN HIEROGLYPH E006EGYPTIAN HIER" +
	"OGLYPH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN HIEROGLYPH E008AEGYPTIAN HIE" +
	"ROGLYPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIAN HIEROGLYPH E010EGYPTIAN HI" +
	"EROGLYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIAN HIEROGLYPH E013EGYPTIAN HI" +
	"EROGLYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIAN HIEROGLYPH E016EGYPTIAN HI" +
	"EROGLYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTIAN HIEROGLYPH E017AEGYPTIAN " +
	"HIEROGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPTIAN HIEROGLYPH E020EGYPTIAN " +
	"HIEROGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYPTIAN HIEROGLYPH E022EGYPTIAN" +
	" HIEROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYPTIAN HIEROGLYPH E025EGYPTIAN" +
	" HIEROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYPTIAN HIEROGLYPH E028EGYPTIAN") + ("" +
	" HIEROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGYPTIAN HIEROGLYPH E030EGYPTIA" +
	"N HIEROGLYPH E031EGYPTIAN HIEROGLYPH E032EGYPTIAN HIEROGLYPH E033EGYPTIA" +
	"N HIEROGLYPH E034EGYPTIAN HIEROGLYPH E034AEGYPTIAN HIEROGLYPH E036EGYPTI" +
	"AN HIEROGLYPH E037EGYPTIAN HIEROGLYPH E038EGYPTIAN HIEROGLYPH F001EGYPTI" +
	"AN HIEROGLYPH F001AEGYPTIAN HIEROGLYPH F002EGYPTIAN HIEROGLYPH F003EGYPT" +
	"IAN HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005EGYPTIAN HIEROGLYPH F006EGYPT" +
	"IAN HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008EGYPTIAN HIEROGLYPH F009EGYPT" +
	"IAN HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011EGYPTIAN HIEROGLYPH F012EGYPT" +
	"IAN HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013AEGYPTIAN HIEROGLYPH F014EGYP" +
	"TIAN HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016EGYPTIAN HIEROGLYPH F017EGYP" +
	"TIAN HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019EGYPTIAN HIEROGLYPH F020EGYP" +
	"TIAN HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021AEGYPTIAN HIEROGLYPH F022EGY" +
	"PTIAN HIEROGLYPH F023EGYPTIAN HIEROGLYPH F024EGYPTIAN HIEROGLYPH F025EGY" +
	"PTIAN HIEROGLYPH F026EGYPTIAN HIEROGLYPH F027EGYPTIAN HIEROGLYPH F028EGY" +
	"PTIAN HIEROGLYPH F029EGYPTIAN HIEROGLYPH F030EGYPTIAN HIEROGLYPH F031EGY" +
	"PTIAN HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F032EGYPTIAN HIEROGLYPH F033EG" +
	"YPTIAN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F035EGYPTIAN HIEROGLYPH F036EG" +
	"YPTIAN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F037AEGYPTIAN HIEROGLYPH F038E" +
	"GYPTIAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH F039EGYPTIAN HIEROGLYPH F040" +
	"EGYPTIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH F042EGYPTIAN HIEROGLYPH F043" +
	"EGYPTIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH F045EGYPTIAN HIEROGLYPH F045" +
	"AEGYPTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH F046AEGYPTIAN HIEROGLYPH F0" +
	"47EGYPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLYPH F048EGYPTIAN HIEROGLYPH F" +
	"049EGYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLYPH F051EGYPTIAN HIEROGLYPH F" +
	"051AEGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROGLYPH F051CEGYPTIAN HIEROGLYP" +
	"H F052EGYPTIAN HIEROGLYPH F053EGYPTIAN HIEROGLYPH G001EGYPTIAN HIEROGLYP" +
	"H G002EGYPTIAN HIEROGLYPH G003EGYPTIAN HIEROGLYPH G004EGYPTIAN HIEROGLYP" +
	"H G005EGYPTIAN HIEROGLYPH G006EGYPTIAN HIEROGLYPH G006AEGYPTIAN HIEROGLY" +
	"PH G007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIEROGLYPH G007BEGYPTIAN HIEROG" +
	"LYPH G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HIEROGLYPH G010EGYPTIAN HIEROG" +
	"LYPH G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN HIEROGLYPH G012EGYPTIAN HIERO" +
	"GLYPH G013EGYPTIAN HIEROGLYPH G014EGYPTIAN HIEROGLYPH G015EGYPTIAN HIERO" +
	"GLYPH G016EGYPTIAN HIEROGLYPH G017EGYPTIAN HIEROGLYPH G018EGYPTIAN HIERO" +
	"GLYPH G019EGYPTIAN HIEROGLYPH G020EGYPTIAN HIEROGLYPH G020AEGYPTIAN HIER" +
	"OGLYPH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN HIEROGLYPH G023EGYPTIAN HIER" +
	"OGLYPH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN HIEROGLYPH G026EGYPTIAN HIER" +
	"OGLYPH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN HIEROGLYPH G028EGYPTIAN HIE" +
	"ROGLYPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN HIEROGLYPH G031EGYPTIAN HIE" +
	"ROGLYPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN HIEROGLYPH G034EGYPTIAN HIE" +
	"ROGLYPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN HIEROGLYPH G036AEGYPTIAN HI" +
	"EROGLYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTIAN HIEROGLYPH G038EGYPTIAN H" +
	"IEROGLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTIAN HIEROGLYPH G041EGYPTIAN H" +
	"IEROGLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTIAN HIEROGLYPH G043AEGYPTIAN " +
	"HIEROGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPTIAN HIEROGLYPH G045AEGYPTIAN" +
	" HIEROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYPTIAN HIEROGLYPH G048EGYPTIAN" +
	" HIEROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYPTIAN HIEROGLYPH G051EGYPTIAN" +
	" HIEROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYPTIAN HIEROGLYPH G054EGYPTIAN" +
	" HIEROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYPTIAN HIEROGLYPH H003EGYPTIAN" +
	" HIEROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYPTIAN HIEROGLYPH H006EGYPTIAN" +
	" HIEROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGYPTIAN HIEROGLYPH H008EGYPTIA" +
	"N HIEROGLYPH I001EGYPTIAN HIEROGLYPH I002EGYPTIAN HIEROGLYPH I003EGYPTIA" +
	"N HIEROGLYPH I004EGYPTIAN HIEROGLYPH I005EGYPTIAN HIEROGLYPH I005AEGYPTI" +
	"AN HIEROGLYPH I006EGYPTIAN HIEROGLYPH I007EGYPTIAN HIEROGLYPH I008EGYPTI" +
	"AN HIEROGLYPH I009EGYPTIAN HIEROGLYPH I009AEGYPTIAN HIEROGLYPH I010EGYPT" +
	"IAN HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011EGYPTIAN HIEROGLYPH I011AEGY" +
	"PTIAN HIEROGLYPH I012EGYPTIAN HIEROGLYPH I013EGYPTIAN HIEROGLYPH I014EGY" +
	"PTIAN HIEROGLYPH I015EGYPTIAN HIEROGLYPH K001EGYPTIAN HIEROGLYPH K002EGY" +
	"PTIAN HIEROGLYPH K003EGYPTIAN HIEROGLYPH K004EGYPTIAN HIEROGLYPH K005EGY" +
	"PTIAN HIEROGLYPH K006EGYPTIAN HIEROGLYPH K007EGYPTIAN HIEROGLYPH K008EGY" +
	"PTIAN HIEROGLYPH L001EGYPTIAN HIEROGLYPH L002EGYPTIAN HIEROGLYPH L002AEG" +
	"YPTIAN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L004EGYPTIAN HIEROGLYPH L005EG" +
	"YPTIAN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L006AEGYPTIAN HIEROGLYPH L007E" +
	"GYPTIAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M001EGYPTIAN HIEROGLYPH M001A" +
	"EGYPTIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH M002EGYPTIAN HIEROGLYPH M00") + ("" +
	"3EGYPTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYPH M004EGYPTIAN HIEROGLYPH M0" +
	"05EGYPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYPH M007EGYPTIAN HIEROGLYPH M0" +
	"08EGYPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYPH M010EGYPTIAN HIEROGLYPH M0" +
	"10AEGYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLYPH M012EGYPTIAN HIEROGLYPH M" +
	"012AEGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROGLYPH M012CEGYPTIAN HIEROGLYP" +
	"H M012DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIEROGLYPH M012FEGYPTIAN HIEROG" +
	"LYPH M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN HIEROGLYPH M013EGYPTIAN HIER" +
	"OGLYPH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN HIEROGLYPH M015AEGYPTIAN HIE" +
	"ROGLYPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIAN HIEROGLYPH M017EGYPTIAN HI" +
	"EROGLYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTIAN HIEROGLYPH M019EGYPTIAN H" +
	"IEROGLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTIAN HIEROGLYPH M022EGYPTIAN H" +
	"IEROGLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPTIAN HIEROGLYPH M024EGYPTIAN " +
	"HIEROGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYPTIAN HIEROGLYPH M026EGYPTIAN" +
	" HIEROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYPTIAN HIEROGLYPH M028AEGYPTIA" +
	"N HIEROGLYPH M029EGYPTIAN HIEROGLYPH M030EGYPTIAN HIEROGLYPH M031EGYPTIA" +
	"N HIEROGLYPH M031AEGYPTIAN HIEROGLYPH M032EGYPTIAN HIEROGLYPH M033EGYPTI" +
	"AN HIEROGLYPH M033AEGYPTIAN HIEROGLYPH M033BEGYPTIAN HIEROGLYPH M034EGYP" +
	"TIAN HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036EGYPTIAN HIEROGLYPH M037EGYP" +
	"TIAN HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039EGYPTIAN HIEROGLYPH M040EGYP" +
	"TIAN HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M041EGYPTIAN HIEROGLYPH M042EGY" +
	"PTIAN HIEROGLYPH M043EGYPTIAN HIEROGLYPH M044EGYPTIAN HIEROGLYPH N001EGY" +
	"PTIAN HIEROGLYPH N002EGYPTIAN HIEROGLYPH N003EGYPTIAN HIEROGLYPH N004EGY" +
	"PTIAN HIEROGLYPH N005EGYPTIAN HIEROGLYPH N006EGYPTIAN HIEROGLYPH N007EGY" +
	"PTIAN HIEROGLYPH N008EGYPTIAN HIEROGLYPH N009EGYPTIAN HIEROGLYPH N010EGY" +
	"PTIAN HIEROGLYPH N011EGYPTIAN HIEROGLYPH N012EGYPTIAN HIEROGLYPH N013EGY" +
	"PTIAN HIEROGLYPH N014EGYPTIAN HIEROGLYPH N015EGYPTIAN HIEROGLYPH N016EGY" +
	"PTIAN HIEROGLYPH N017EGYPTIAN HIEROGLYPH N018EGYPTIAN HIEROGLYPH N018AEG" +
	"YPTIAN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N019EGYPTIAN HIEROGLYPH N020E" +
	"GYPTIAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N022EGYPTIAN HIEROGLYPH N023E" +
	"GYPTIAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N025EGYPTIAN HIEROGLYPH N025A" +
	"EGYPTIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH N027EGYPTIAN HIEROGLYPH N028" +
	"EGYPTIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH N030EGYPTIAN HIEROGLYPH N031" +
	"EGYPTIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH N033EGYPTIAN HIEROGLYPH N033" +
	"AEGYPTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH N034AEGYPTIAN HIEROGLYPH N0" +
	"35EGYPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLYPH N036EGYPTIAN HIEROGLYPH N" +
	"037EGYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGLYPH N038EGYPTIAN HIEROGLYPH " +
	"N039EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGLYPH N041EGYPTIAN HIEROGLYPH " +
	"N042EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROGLYPH NL002EGYPTIAN HIEROGLYP" +
	"H NL003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIEROGLYPH NL005EGYPTIAN HIEROG" +
	"LYPH NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN HIEROGLYPH NL007EGYPTIAN HI" +
	"EROGLYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPTIAN HIEROGLYPH NL010EGYPTIAN" +
	" HIEROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EGYPTIAN HIEROGLYPH NL013EGYPT" +
	"IAN HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL015EGYPTIAN HIEROGLYPH NL016EG" +
	"YPTIAN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH NL017AEGYPTIAN HIEROGLYPH NL0" +
	"18EGYPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLYPH NL020EGYPTIAN HIEROGLYPH " +
	"NU001EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIEROGLYPH NU003EGYPTIAN HIEROGLY" +
	"PH NU004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HIEROGLYPH NU006EGYPTIAN HIERO" +
	"GLYPH NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN HIEROGLYPH NU009EGYPTIAN HI" +
	"EROGLYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYPTIAN HIEROGLYPH NU011EGYPTIA" +
	"N HIEROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012EGYPTIAN HIEROGLYPH NU013EGY" +
	"PTIAN HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU015EGYPTIAN HIEROGLYPH NU016" +
	"EGYPTIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH NU018EGYPTIAN HIEROGLYPH NU" +
	"018AEGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROGLYPH NU020EGYPTIAN HIEROGLYP" +
	"H NU021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIEROGLYPH NU022AEGYPTIAN HIERO" +
	"GLYPH O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN HIEROGLYPH O002EGYPTIAN HIER" +
	"OGLYPH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN HIEROGLYPH O005EGYPTIAN HIER" +
	"OGLYPH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN HIEROGLYPH O006AEGYPTIAN HI" +
	"EROGLYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPTIAN HIEROGLYPH O006DEGYPTIAN" +
	" HIEROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEGYPTIAN HIEROGLYPH O007EGYPTI" +
	"AN HIEROGLYPH O008EGYPTIAN HIEROGLYPH O009EGYPTIAN HIEROGLYPH O010EGYPTI" +
	"AN HIEROGLYPH O010AEGYPTIAN HIEROGLYPH O010BEGYPTIAN HIEROGLYPH O010CEGY" +
	"PTIAN HIEROGLYPH O011EGYPTIAN HIEROGLYPH O012EGYPTIAN HIEROGLYPH O013EGY" +
	"PTIAN HIEROGLYPH O014EGYPTIAN HIEROGLYPH O015EGYPTIAN HIEROGLYPH O016EGY" +
	"PTIAN HIEROGLYPH O017EGYPTIAN HIEROGLYPH O018EGYPTIAN HIEROGLYPH O019EGY") + ("" +
	"PTIAN HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O020EGYPTIAN HIEROGLYPH O020AE" +
	"GYPTIAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O022EGYPTIAN HIEROGLYPH O023E" +
	"GYPTIAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O024AEGYPTIAN HIEROGLYPH O025" +
	"EGYPTIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH O026EGYPTIAN HIEROGLYPH O02" +
	"7EGYPTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH O029EGYPTIAN HIEROGLYPH O02" +
	"9AEGYPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYPH O030AEGYPTIAN HIEROGLYPH O" +
	"031EGYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLYPH O033EGYPTIAN HIEROGLYPH O" +
	"033AEGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGLYPH O035EGYPTIAN HIEROGLYPH " +
	"O036EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROGLYPH O036BEGYPTIAN HIEROGLYP" +
	"H O036CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIEROGLYPH O037EGYPTIAN HIEROGL" +
	"YPH O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIEROGLYPH O040EGYPTIAN HIEROGL" +
	"YPH O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIEROGLYPH O043EGYPTIAN HIEROGL" +
	"YPH O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIEROGLYPH O046EGYPTIAN HIEROGL" +
	"YPH O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIEROGLYPH O049EGYPTIAN HIEROGL" +
	"YPH O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HIEROGLYPH O050BEGYPTIAN HIERO" +
	"GLYPH O051EGYPTIAN HIEROGLYPH P001EGYPTIAN HIEROGLYPH P001AEGYPTIAN HIER" +
	"OGLYPH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN HIEROGLYPH P003AEGYPTIAN HIE" +
	"ROGLYPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN HIEROGLYPH P006EGYPTIAN HIE" +
	"ROGLYPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN HIEROGLYPH P009EGYPTIAN HIE" +
	"ROGLYPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN HIEROGLYPH Q001EGYPTIAN HIE" +
	"ROGLYPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN HIEROGLYPH Q004EGYPTIAN HIE" +
	"ROGLYPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN HIEROGLYPH Q007EGYPTIAN HIE" +
	"ROGLYPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN HIEROGLYPH R002AEGYPTIAN HI" +
	"EROGLYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTIAN HIEROGLYPH R003BEGYPTIAN " +
	"HIEROGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPTIAN HIEROGLYPH R006EGYPTIAN " +
	"HIEROGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPTIAN HIEROGLYPH R009EGYPTIAN " +
	"HIEROGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYPTIAN HIEROGLYPH R011EGYPTIAN" +
	" HIEROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYPTIAN HIEROGLYPH R014EGYPTIAN" +
	" HIEROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYPTIAN HIEROGLYPH R016AEGYPTIA" +
	"N HIEROGLYPH R017EGYPTIAN HIEROGLYPH R018EGYPTIAN HIEROGLYPH R019EGYPTIA" +
	"N HIEROGLYPH R020EGYPTIAN HIEROGLYPH R021EGYPTIAN HIEROGLYPH R022EGYPTIA" +
	"N HIEROGLYPH R023EGYPTIAN HIEROGLYPH R024EGYPTIAN HIEROGLYPH R025EGYPTIA" +
	"N HIEROGLYPH R026EGYPTIAN HIEROGLYPH R027EGYPTIAN HIEROGLYPH R028EGYPTIA" +
	"N HIEROGLYPH R029EGYPTIAN HIEROGLYPH S001EGYPTIAN HIEROGLYPH S002EGYPTIA" +
	"N HIEROGLYPH S002AEGYPTIAN HIEROGLYPH S003EGYPTIAN HIEROGLYPH S004EGYPTI" +
	"AN HIEROGLYPH S005EGYPTIAN HIEROGLYPH S006EGYPTIAN HIEROGLYPH S006AEGYPT" +
	"IAN HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008EGYPTIAN HIEROGLYPH S009EGYPT" +
	"IAN HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011EGYPTIAN HIEROGLYPH S012EGYPT" +
	"IAN HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014EGYPTIAN HIEROGLYPH S014AEGYP" +
	"TIAN HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S015EGYPTIAN HIEROGLYPH S016EGY" +
	"PTIAN HIEROGLYPH S017EGYPTIAN HIEROGLYPH S017AEGYPTIAN HIEROGLYPH S018EG" +
	"YPTIAN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S020EGYPTIAN HIEROGLYPH S021EG" +
	"YPTIAN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S023EGYPTIAN HIEROGLYPH S024EG" +
	"YPTIAN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S026EGYPTIAN HIEROGLYPH S026AE" +
	"GYPTIAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH S027EGYPTIAN HIEROGLYPH S028" +
	"EGYPTIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH S030EGYPTIAN HIEROGLYPH S031" +
	"EGYPTIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH S033EGYPTIAN HIEROGLYPH S034" +
	"EGYPTIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH S035AEGYPTIAN HIEROGLYPH S03" +
	"6EGYPTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH S038EGYPTIAN HIEROGLYPH S03" +
	"9EGYPTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH S041EGYPTIAN HIEROGLYPH S04" +
	"2EGYPTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH S044EGYPTIAN HIEROGLYPH S04" +
	"5EGYPTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH T001EGYPTIAN HIEROGLYPH T00" +
	"2EGYPTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH T003AEGYPTIAN HIEROGLYPH T0" +
	"04EGYPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYPH T006EGYPTIAN HIEROGLYPH T0" +
	"07EGYPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLYPH T008EGYPTIAN HIEROGLYPH T" +
	"008AEGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGLYPH T009AEGYPTIAN HIEROGLYPH" +
	" T010EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROGLYPH T011AEGYPTIAN HIEROGLYP" +
	"H T012EGYPTIAN HIEROGLYPH T013EGYPTIAN HIEROGLYPH T014EGYPTIAN HIEROGLYP" +
	"H T015EGYPTIAN HIEROGLYPH T016EGYPTIAN HIEROGLYPH T016AEGYPTIAN HIEROGLY" +
	"PH T017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIEROGLYPH T019EGYPTIAN HIEROGLY" +
	"PH T020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIEROGLYPH T022EGYPTIAN HIEROGLY" +
	"PH T023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIEROGLYPH T025EGYPTIAN HIEROGLY" +
	"PH T026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIEROGLYPH T028EGYPTIAN HIEROGLY" +
	"PH T029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIEROGLYPH T031EGYPTIAN HIEROGLY") + ("" +
	"PH T032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIEROGLYPH T033EGYPTIAN HIEROGL" +
	"YPH T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HIEROGLYPH T035EGYPTIAN HIEROG" +
	"LYPH T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HIEROGLYPH U002EGYPTIAN HIEROG" +
	"LYPH U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HIEROGLYPH U005EGYPTIAN HIEROG" +
	"LYPH U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN HIEROGLYPH U006BEGYPTIAN HIER" +
	"OGLYPH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN HIEROGLYPH U009EGYPTIAN HIER" +
	"OGLYPH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN HIEROGLYPH U012EGYPTIAN HIER" +
	"OGLYPH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN HIEROGLYPH U015EGYPTIAN HIER" +
	"OGLYPH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN HIEROGLYPH U018EGYPTIAN HIER" +
	"OGLYPH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN HIEROGLYPH U021EGYPTIAN HIER" +
	"OGLYPH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN HIEROGLYPH U023AEGYPTIAN HIE" +
	"ROGLYPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN HIEROGLYPH U026EGYPTIAN HIE" +
	"ROGLYPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN HIEROGLYPH U029EGYPTIAN HIE" +
	"ROGLYPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIAN HIEROGLYPH U031EGYPTIAN HI" +
	"EROGLYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTIAN HIEROGLYPH U033EGYPTIAN H" +
	"IEROGLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTIAN HIEROGLYPH U036EGYPTIAN H" +
	"IEROGLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTIAN HIEROGLYPH U039EGYPTIAN H" +
	"IEROGLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTIAN HIEROGLYPH U042EGYPTIAN H" +
	"IEROGLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPTIAN HIEROGLYPH V001BEGYPTIAN" +
	" HIEROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEGYPTIAN HIEROGLYPH V001EEGYPT" +
	"IAN HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001GEGYPTIAN HIEROGLYPH V001HEG" +
	"YPTIAN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V002EGYPTIAN HIEROGLYPH V002A" +
	"EGYPTIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH V004EGYPTIAN HIEROGLYPH V005" +
	"EGYPTIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH V007EGYPTIAN HIEROGLYPH V007" +
	"AEGYPTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYPH V008EGYPTIAN HIEROGLYPH V0" +
	"09EGYPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYPH V011EGYPTIAN HIEROGLYPH V0" +
	"11AEGYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGLYPH V011CEGYPTIAN HIEROGLYPH" +
	" V012EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIEROGLYPH V012BEGYPTIAN HIEROGLY" +
	"PH V013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIEROGLYPH V015EGYPTIAN HIEROGLY" +
	"PH V016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIEROGLYPH V018EGYPTIAN HIEROGLY" +
	"PH V019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIEROGLYPH V020AEGYPTIAN HIEROGL" +
	"YPH V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN HIEROGLYPH V020DEGYPTIAN HIER" +
	"OGLYPH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIAN HIEROGLYPH V020GEGYPTIAN H" +
	"IEROGLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYPTIAN HIEROGLYPH V020JEGYPTIA" +
	"N HIEROGLYPH V020KEGYPTIAN HIEROGLYPH V020LEGYPTIAN HIEROGLYPH V021EGYPT" +
	"IAN HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023EGYPTIAN HIEROGLYPH V023AEGYP" +
	"TIAN HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025EGYPTIAN HIEROGLYPH V026EGYP" +
	"TIAN HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028EGYPTIAN HIEROGLYPH V028AEGY" +
	"PTIAN HIEROGLYPH V029EGYPTIAN HIEROGLYPH V029AEGYPTIAN HIEROGLYPH V030EG" +
	"YPTIAN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V031EGYPTIAN HIEROGLYPH V031A" +
	"EGYPTIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH V033EGYPTIAN HIEROGLYPH V033" +
	"AEGYPTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH V035EGYPTIAN HIEROGLYPH V03" +
	"6EGYPTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH V037AEGYPTIAN HIEROGLYPH V0" +
	"38EGYPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYPH V040EGYPTIAN HIEROGLYPH V0" +
	"40AEGYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLYPH W002EGYPTIAN HIEROGLYPH W" +
	"003EGYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGLYPH W004EGYPTIAN HIEROGLYPH " +
	"W005EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGLYPH W007EGYPTIAN HIEROGLYPH " +
	"W008EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGLYPH W009AEGYPTIAN HIEROGLYPH" +
	" W010EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIEROGLYPH W011EGYPTIAN HIEROGLYP" +
	"H W012EGYPTIAN HIEROGLYPH W013EGYPTIAN HIEROGLYPH W014EGYPTIAN HIEROGLYP" +
	"H W014AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIEROGLYPH W016EGYPTIAN HIEROGLY" +
	"PH W017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIEROGLYPH W018EGYPTIAN HIEROGL" +
	"YPH W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HIEROGLYPH W020EGYPTIAN HIEROG" +
	"LYPH W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HIEROGLYPH W023EGYPTIAN HIEROG" +
	"LYPH W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN HIEROGLYPH W025EGYPTIAN HIERO" +
	"GLYPH X001EGYPTIAN HIEROGLYPH X002EGYPTIAN HIEROGLYPH X003EGYPTIAN HIERO" +
	"GLYPH X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN HIEROGLYPH X004BEGYPTIAN HIE" +
	"ROGLYPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN HIEROGLYPH X006AEGYPTIAN HI" +
	"EROGLYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIAN HIEROGLYPH X008AEGYPTIAN H" +
	"IEROGLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPTIAN HIEROGLYPH Y002EGYPTIAN " +
	"HIEROGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPTIAN HIEROGLYPH Y005EGYPTIAN " +
	"HIEROGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPTIAN HIEROGLYPH Y008EGYPTIAN " +
	"HIEROGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPTIAN HIEROGLYPH Z002AEGYPTIAN" +
	" HIEROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEGYPTIAN HIEROGLYPH Z002DEGYPT") + ("" +
	"IAN HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003AEGYPTIAN HIEROGLYPH Z003BEGY" +
	"PTIAN HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z004AEGYPTIAN HIEROGLYPH Z005EG" +
	"YPTIAN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z006EGYPTIAN HIEROGLYPH Z007E" +
	"GYPTIAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z009EGYPTIAN HIEROGLYPH Z010E" +
	"GYPTIAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z012EGYPTIAN HIEROGLYPH Z013E" +
	"GYPTIAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z015EGYPTIAN HIEROGLYPH Z015A" +
	"EGYPTIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH Z015CEGYPTIAN HIEROGLYPH Z0" +
	"15DEGYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGLYPH Z015FEGYPTIAN HIEROGLYPH" +
	" Z015GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIEROGLYPH Z015IEGYPTIAN HIEROGL" +
	"YPH Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HIEROGLYPH Z016BEGYPTIAN HIERO" +
	"GLYPH Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN HIEROGLYPH Z016EEGYPTIAN HI" +
	"EROGLYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPTIAN HIEROGLYPH Z016HEGYPTIAN" +
	" HIEROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EGYPTIAN HIEROGLYPH AA003EGYPT" +
	"IAN HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA005EGYPTIAN HIEROGLYPH AA006EG" +
	"YPTIAN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH AA007AEGYPTIAN HIEROGLYPH AA0" +
	"07BEGYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGLYPH AA009EGYPTIAN HIEROGLYPH" +
	" AA010EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIEROGLYPH AA012EGYPTIAN HIEROGL" +
	"YPH AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN HIEROGLYPH AA015EGYPTIAN HIER" +
	"OGLYPH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIAN HIEROGLYPH AA018EGYPTIAN H" +
	"IEROGLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYPTIAN HIEROGLYPH AA021EGYPTIA" +
	"N HIEROGLYPH AA022EGYPTIAN HIEROGLYPH AA023EGYPTIAN HIEROGLYPH AA024EGYP" +
	"TIAN HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA026EGYPTIAN HIEROGLYPH AA027E" +
	"GYPTIAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH AA029EGYPTIAN HIEROGLYPH AA0" +
	"30EGYPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLYPH AA032EGYPTIAN HIEROGLYPH " +
	"V011DEGYPTIAN HIEROGLYPH VERTICAL JOINEREGYPTIAN HIEROGLYPH HORIZONTAL J" +
	"OINEREGYPTIAN HIEROGLYPH INSERT AT TOP STARTEGYPTIAN HIEROGLYPH INSERT A" +
	"T BOTTOM STARTEGYPTIAN HIEROGLYPH INSERT AT TOP ENDEGYPTIAN HIEROGLYPH I" +
	"NSERT AT BOTTOM ENDEGYPTIAN HIEROGLYPH OVERLAY MIDDLEEGYPTIAN HIEROGLYPH" +
	" BEGIN SEGMENTEGYPTIAN HIEROGLYPH END SEGMENTEGYPTIAN HIEROGLYPH INSERT " +
	"AT MIDDLEEGYPTIAN HIEROGLYPH INSERT AT TOPEGYPTIAN HIEROGLYPH INSERT AT " +
	"BOTTOMEGYPTIAN HIEROGLYPH BEGIN ENCLOSUREEGYPTIAN HIEROGLYPH END ENCLOSU" +
	"REEGYPTIAN HIEROGLYPH BEGIN WALLED ENCLOSUREEGYPTIAN HIEROGLYPH END WALL" +
	"ED ENCLOSUREEGYPTIAN HIEROGLYPH MIRROR HORIZONTALLYEGYPTIAN HIEROGLYPH F" +
	"ULL BLANKEGYPTIAN HIEROGLYPH HALF BLANKEGYPTIAN HIEROGLYPH LOST SIGNEGYP" +
	"TIAN HIEROGLYPH HALF LOST SIGNEGYPTIAN HIEROGLYPH TALL LOST SIGNEGYPTIAN" +
	" HIEROGLYPH WIDE LOST SIGNEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP ST" +
	"ARTEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM STARTEGYPTIAN HIEROGLY" +
	"PH MODIFIER DAMAGED AT STARTEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP " +
	"ENDEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOPEGYPTIAN HIEROGLYPH MODIFI" +
	"ER DAMAGED AT BOTTOM START AND TOP ENDEGYPTIAN HIEROGLYPH MODIFIER DAMAG" +
	"ED AT START AND TOPEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT BOTTOM ENDEGY" +
	"PTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START AND BOTTOM ENDEGYPTIAN HI" +
	"EROGLYPH MODIFIER DAMAGED AT BOTTOMEGYPTIAN HIEROGLYPH MODIFIER DAMAGED " +
	"AT START AND BOTTOMEGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT ENDEGYPTIAN H" +
	"IEROGLYPH MODIFIER DAMAGED AT TOP AND ENDEGYPTIAN HIEROGLYPH MODIFIER DA" +
	"MAGED AT BOTTOM AND ENDEGYPTIAN HIEROGLYPH MODIFIER DAMAGEDANATOLIAN HIE" +
	"ROGLYPH A001ANATOLIAN HIEROGLYPH A002ANATOLIAN HIEROGLYPH A003ANATOLIAN " +
	"HIEROGLYPH A004ANATOLIAN HIEROGLYPH A005ANATOLIAN HIEROGLYPH A006ANATOLI" +
	"AN HIEROGLYPH A007ANATOLIAN HIEROGLYPH A008ANATOLIAN HIEROGLYPH A009ANAT" +
	"OLIAN HIEROGLYPH A010ANATOLIAN HIEROGLYPH A010AANATOLIAN HIEROGLYPH A011" +
	"ANATOLIAN HIEROGLYPH A012ANATOLIAN HIEROGLYPH A013ANATOLIAN HIEROGLYPH A" +
	"014ANATOLIAN HIEROGLYPH A015ANATOLIAN HIEROGLYPH A016ANATOLIAN HIEROGLYP" +
	"H A017ANATOLIAN HIEROGLYPH A018ANATOLIAN HIEROGLYPH A019ANATOLIAN HIEROG" +
	"LYPH A020ANATOLIAN HIEROGLYPH A021ANATOLIAN HIEROGLYPH A022ANATOLIAN HIE" +
	"ROGLYPH A023ANATOLIAN HIEROGLYPH A024ANATOLIAN HIEROGLYPH A025ANATOLIAN " +
	"HIEROGLYPH A026ANATOLIAN HIEROGLYPH A026AANATOLIAN HIEROGLYPH A027ANATOL" +
	"IAN HIEROGLYPH A028ANATOLIAN HIEROGLYPH A029ANATOLIAN HIEROGLYPH A030ANA" +
	"TOLIAN HIEROGLYPH A031ANATOLIAN HIEROGLYPH A032ANATOLIAN HIEROGLYPH A033" +
	"ANATOLIAN HIEROGLYPH A034ANATOLIAN HIEROGLYPH A035ANATOLIAN HIEROGLYPH A" +
	"036ANATOLIAN HIEROGLYPH A037ANATOLIAN HIEROGLYPH A038ANATOLIAN HIEROGLYP" +
	"H A039ANATOLIAN HIEROGLYPH A039AANATOLIAN HIEROGLYPH A040ANATOLIAN HIERO" +
	"GLYPH A041ANATOLIAN HIEROGLYPH A041AANATOLIAN HIEROGLYPH A042ANATOLIAN H" +
	"IEROGLYPH A043ANATOLIAN HIEROGLYPH A044ANATOLIAN HIEROGLYPH A045ANATOLIA" +
	"N HIEROGLYPH A045AANATOLIAN HIEROGLYPH A046ANATOLIAN HIEROGLYPH A046AANA") + ("" +
	"TOLIAN HIEROGLYPH A046BANATOLIAN HIEROGLYPH A047ANATOLIAN HIEROGLYPH A04" +
	"8ANATOLIAN HIEROGLYPH A049ANATOLIAN HIEROGLYPH A050ANATOLIAN HIEROGLYPH " +
	"A051ANATOLIAN HIEROGLYPH A052ANATOLIAN HIEROGLYPH A053ANATOLIAN HIEROGLY" +
	"PH A054ANATOLIAN HIEROGLYPH A055ANATOLIAN HIEROGLYPH A056ANATOLIAN HIERO" +
	"GLYPH A057ANATOLIAN HIEROGLYPH A058ANATOLIAN HIEROGLYPH A059ANATOLIAN HI" +
	"EROGLYPH A060ANATOLIAN HIEROGLYPH A061ANATOLIAN HIEROGLYPH A062ANATOLIAN" +
	" HIEROGLYPH A063ANATOLIAN HIEROGLYPH A064ANATOLIAN HIEROGLYPH A065ANATOL" +
	"IAN HIEROGLYPH A066ANATOLIAN HIEROGLYPH A066AANATOLIAN HIEROGLYPH A066BA" +
	"NATOLIAN HIEROGLYPH A066CANATOLIAN HIEROGLYPH A067ANATOLIAN HIEROGLYPH A" +
	"068ANATOLIAN HIEROGLYPH A069ANATOLIAN HIEROGLYPH A070ANATOLIAN HIEROGLYP" +
	"H A071ANATOLIAN HIEROGLYPH A072ANATOLIAN HIEROGLYPH A073ANATOLIAN HIEROG" +
	"LYPH A074ANATOLIAN HIEROGLYPH A075ANATOLIAN HIEROGLYPH A076ANATOLIAN HIE" +
	"ROGLYPH A077ANATOLIAN HIEROGLYPH A078ANATOLIAN HIEROGLYPH A079ANATOLIAN " +
	"HIEROGLYPH A080ANATOLIAN HIEROGLYPH A081ANATOLIAN HIEROGLYPH A082ANATOLI" +
	"AN HIEROGLYPH A083ANATOLIAN HIEROGLYPH A084ANATOLIAN HIEROGLYPH A085ANAT" +
	"OLIAN HIEROGLYPH A086ANATOLIAN HIEROGLYPH A087ANATOLIAN HIEROGLYPH A088A" +
	"NATOLIAN HIEROGLYPH A089ANATOLIAN HIEROGLYPH A090ANATOLIAN HIEROGLYPH A0" +
	"91ANATOLIAN HIEROGLYPH A092ANATOLIAN HIEROGLYPH A093ANATOLIAN HIEROGLYPH" +
	" A094ANATOLIAN HIEROGLYPH A095ANATOLIAN HIEROGLYPH A096ANATOLIAN HIEROGL" +
	"YPH A097ANATOLIAN HIEROGLYPH A097AANATOLIAN HIEROGLYPH A098ANATOLIAN HIE" +
	"ROGLYPH A098AANATOLIAN HIEROGLYPH A099ANATOLIAN HIEROGLYPH A100ANATOLIAN" +
	" HIEROGLYPH A100AANATOLIAN HIEROGLYPH A101ANATOLIAN HIEROGLYPH A101AANAT" +
	"OLIAN HIEROGLYPH A102ANATOLIAN HIEROGLYPH A102AANATOLIAN HIEROGLYPH A103" +
	"ANATOLIAN HIEROGLYPH A104ANATOLIAN HIEROGLYPH A104AANATOLIAN HIEROGLYPH " +
	"A104BANATOLIAN HIEROGLYPH A104CANATOLIAN HIEROGLYPH A105ANATOLIAN HIEROG" +
	"LYPH A105AANATOLIAN HIEROGLYPH A105BANATOLIAN HIEROGLYPH A106ANATOLIAN H" +
	"IEROGLYPH A107ANATOLIAN HIEROGLYPH A107AANATOLIAN HIEROGLYPH A107BANATOL" +
	"IAN HIEROGLYPH A107CANATOLIAN HIEROGLYPH A108ANATOLIAN HIEROGLYPH A109AN" +
	"ATOLIAN HIEROGLYPH A110ANATOLIAN HIEROGLYPH A110AANATOLIAN HIEROGLYPH A1" +
	"10BANATOLIAN HIEROGLYPH A111ANATOLIAN HIEROGLYPH A112ANATOLIAN HIEROGLYP" +
	"H A113ANATOLIAN HIEROGLYPH A114ANATOLIAN HIEROGLYPH A115ANATOLIAN HIEROG" +
	"LYPH A115AANATOLIAN HIEROGLYPH A116ANATOLIAN HIEROGLYPH A117ANATOLIAN HI" +
	"EROGLYPH A118ANATOLIAN HIEROGLYPH A119ANATOLIAN HIEROGLYPH A120ANATOLIAN" +
	" HIEROGLYPH A121ANATOLIAN HIEROGLYPH A122ANATOLIAN HIEROGLYPH A123ANATOL" +
	"IAN HIEROGLYPH A124ANATOLIAN HIEROGLYPH A125ANATOLIAN HIEROGLYPH A125AAN" +
	"ATOLIAN HIEROGLYPH A126ANATOLIAN HIEROGLYPH A127ANATOLIAN HIEROGLYPH A12" +
	"8ANATOLIAN HIEROGLYPH A129ANATOLIAN HIEROGLYPH A130ANATOLIAN HIEROGLYPH " +
	"A131ANATOLIAN HIEROGLYPH A132ANATOLIAN HIEROGLYPH A133ANATOLIAN HIEROGLY" +
	"PH A134ANATOLIAN HIEROGLYPH A135ANATOLIAN HIEROGLYPH A135AANATOLIAN HIER" +
	"OGLYPH A136ANATOLIAN HIEROGLYPH A137ANATOLIAN HIEROGLYPH A138ANATOLIAN H" +
	"IEROGLYPH A139ANATOLIAN HIEROGLYPH A140ANATOLIAN HIEROGLYPH A141ANATOLIA" +
	"N HIEROGLYPH A142ANATOLIAN HIEROGLYPH A143ANATOLIAN HIEROGLYPH A144ANATO" +
	"LIAN HIEROGLYPH A145ANATOLIAN HIEROGLYPH A146ANATOLIAN HIEROGLYPH A147AN" +
	"ATOLIAN HIEROGLYPH A148ANATOLIAN HIEROGLYPH A149ANATOLIAN HIEROGLYPH A15" +
	"0ANATOLIAN HIEROGLYPH A151ANATOLIAN HIEROGLYPH A152ANATOLIAN HIEROGLYPH " +
	"A153ANATOLIAN HIEROGLYPH A154ANATOLIAN HIEROGLYPH A155ANATOLIAN HIEROGLY" +
	"PH A156ANATOLIAN HIEROGLYPH A157ANATOLIAN HIEROGLYPH A158ANATOLIAN HIERO" +
	"GLYPH A159ANATOLIAN HIEROGLYPH A160ANATOLIAN HIEROGLYPH A161ANATOLIAN HI" +
	"EROGLYPH A162ANATOLIAN HIEROGLYPH A163ANATOLIAN HIEROGLYPH A164ANATOLIAN" +
	" HIEROGLYPH A165ANATOLIAN HIEROGLYPH A166ANATOLIAN HIEROGLYPH A167ANATOL" +
	"IAN HIEROGLYPH A168ANATOLIAN HIEROGLYPH A169ANATOLIAN HIEROGLYPH A170ANA" +
	"TOLIAN HIEROGLYPH A171ANATOLIAN HIEROGLYPH A172ANATOLIAN HIEROGLYPH A173" +
	"ANATOLIAN HIEROGLYPH A174ANATOLIAN HIEROGLYPH A175ANATOLIAN HIEROGLYPH A" +
	"176ANATOLIAN HIEROGLYPH A177ANATOLIAN HIEROGLYPH A178ANATOLIAN HIEROGLYP" +
	"H A179ANATOLIAN HIEROGLYPH A180ANATOLIAN HIEROGLYPH A181ANATOLIAN HIEROG" +
	"LYPH A182ANATOLIAN HIEROGLYPH A183ANATOLIAN HIEROGLYPH A184ANATOLIAN HIE" +
	"ROGLYPH A185ANATOLIAN HIEROGLYPH A186ANATOLIAN HIEROGLYPH A187ANATOLIAN " +
	"HIEROGLYPH A188ANATOLIAN HIEROGLYPH A189ANATOLIAN HIEROGLYPH A190ANATOLI" +
	"AN HIEROGLYPH A191ANATOLIAN HIEROGLYPH A192ANATOLIAN HIEROGLYPH A193ANAT" +
	"OLIAN HIEROGLYPH A194ANATOLIAN HIEROGLYPH A195ANATOLIAN HIEROGLYPH A196A" +
	"NATOLIAN HIEROGLYPH A197ANATOLIAN HIEROGLYPH A198ANATOLIAN HIEROGLYPH A1" +
	"99ANATOLIAN HIEROGLYPH A200ANATOLIAN HIEROGLYPH A201ANATOLIAN HIEROGLYPH" +
	" A202ANATOLIAN HIEROGLYPH A202AANATOLIAN HIEROGLYPH A202BANATOLIAN HIERO" +
	"GLYPH A203ANATOLIAN HIEROGLYPH A204ANATOLIAN HIEROGLYPH A205ANATOLIAN HI") + ("" +
	"EROGLYPH A206ANATOLIAN HIEROGLYPH A207ANATOLIAN HIEROGLYPH A207AANATOLIA" +
	"N HIEROGLYPH A208ANATOLIAN HIEROGLYPH A209ANATOLIAN HIEROGLYPH A209AANAT" +
	"OLIAN HIEROGLYPH A210ANATOLIAN HIEROGLYPH A211ANATOLIAN HIEROGLYPH A212A" +
	"NATOLIAN HIEROGLYPH A213ANATOLIAN HIEROGLYPH A214ANATOLIAN HIEROGLYPH A2" +
	"15ANATOLIAN HIEROGLYPH A215AANATOLIAN HIEROGLYPH A216ANATOLIAN HIEROGLYP" +
	"H A216AANATOLIAN HIEROGLYPH A217ANATOLIAN HIEROGLYPH A218ANATOLIAN HIERO" +
	"GLYPH A219ANATOLIAN HIEROGLYPH A220ANATOLIAN HIEROGLYPH A221ANATOLIAN HI" +
	"EROGLYPH A222ANATOLIAN HIEROGLYPH A223ANATOLIAN HIEROGLYPH A224ANATOLIAN" +
	" HIEROGLYPH A225ANATOLIAN HIEROGLYPH A226ANATOLIAN HIEROGLYPH A227ANATOL" +
	"IAN HIEROGLYPH A227AANATOLIAN HIEROGLYPH A228ANATOLIAN HIEROGLYPH A229AN" +
	"ATOLIAN HIEROGLYPH A230ANATOLIAN HIEROGLYPH A231ANATOLIAN HIEROGLYPH A23" +
	"2ANATOLIAN HIEROGLYPH A233ANATOLIAN HIEROGLYPH A234ANATOLIAN HIEROGLYPH " +
	"A235ANATOLIAN HIEROGLYPH A236ANATOLIAN HIEROGLYPH A237ANATOLIAN HIEROGLY" +
	"PH A238ANATOLIAN HIEROGLYPH A239ANATOLIAN HIEROGLYPH A240ANATOLIAN HIERO" +
	"GLYPH A241ANATOLIAN HIEROGLYPH A242ANATOLIAN HIEROGLYPH A243ANATOLIAN HI" +
	"EROGLYPH A244ANATOLIAN HIEROGLYPH A245ANATOLIAN HIEROGLYPH A246ANATOLIAN" +
	" HIEROGLYPH A247ANATOLIAN HIEROGLYPH A248ANATOLIAN HIEROGLYPH A249ANATOL" +
	"IAN HIEROGLYPH A250ANATOLIAN HIEROGLYPH A251ANATOLIAN HIEROGLYPH A252ANA" +
	"TOLIAN HIEROGLYPH A253ANATOLIAN HIEROGLYPH A254ANATOLIAN HIEROGLYPH A255" +
	"ANATOLIAN HIEROGLYPH A256ANATOLIAN HIEROGLYPH A257ANATOLIAN HIEROGLYPH A" +
	"258ANATOLIAN HIEROGLYPH A259ANATOLIAN HIEROGLYPH A260ANATOLIAN HIEROGLYP" +
	"H A261ANATOLIAN HIEROGLYPH A262ANATOLIAN HIEROGLYPH A263ANATOLIAN HIEROG" +
	"LYPH A264ANATOLIAN HIEROGLYPH A265ANATOLIAN HIEROGLYPH A266ANATOLIAN HIE" +
	"ROGLYPH A267ANATOLIAN HIEROGLYPH A267AANATOLIAN HIEROGLYPH A268ANATOLIAN" +
	" HIEROGLYPH A269ANATOLIAN HIEROGLYPH A270ANATOLIAN HIEROGLYPH A271ANATOL" +
	"IAN HIEROGLYPH A272ANATOLIAN HIEROGLYPH A273ANATOLIAN HIEROGLYPH A274ANA" +
	"TOLIAN HIEROGLYPH A275ANATOLIAN HIEROGLYPH A276ANATOLIAN HIEROGLYPH A277" +
	"ANATOLIAN HIEROGLYPH A278ANATOLIAN HIEROGLYPH A279ANATOLIAN HIEROGLYPH A" +
	"280ANATOLIAN HIEROGLYPH A281ANATOLIAN HIEROGLYPH A282ANATOLIAN HIEROGLYP" +
	"H A283ANATOLIAN HIEROGLYPH A284ANATOLIAN HIEROGLYPH A285ANATOLIAN HIEROG" +
	"LYPH A286ANATOLIAN HIEROGLYPH A287ANATOLIAN HIEROGLYPH A288ANATOLIAN HIE" +
	"ROGLYPH A289ANATOLIAN HIEROGLYPH A289AANATOLIAN HIEROGLYPH A290ANATOLIAN" +
	" HIEROGLYPH A291ANATOLIAN HIEROGLYPH A292ANATOLIAN HIEROGLYPH A293ANATOL" +
	"IAN HIEROGLYPH A294ANATOLIAN HIEROGLYPH A294AANATOLIAN HIEROGLYPH A295AN" +
	"ATOLIAN HIEROGLYPH A296ANATOLIAN HIEROGLYPH A297ANATOLIAN HIEROGLYPH A29" +
	"8ANATOLIAN HIEROGLYPH A299ANATOLIAN HIEROGLYPH A299AANATOLIAN HIEROGLYPH" +
	" A300ANATOLIAN HIEROGLYPH A301ANATOLIAN HIEROGLYPH A302ANATOLIAN HIEROGL" +
	"YPH A303ANATOLIAN HIEROGLYPH A304ANATOLIAN HIEROGLYPH A305ANATOLIAN HIER" +
	"OGLYPH A306ANATOLIAN HIEROGLYPH A307ANATOLIAN HIEROGLYPH A308ANATOLIAN H" +
	"IEROGLYPH A309ANATOLIAN HIEROGLYPH A309AANATOLIAN HIEROGLYPH A310ANATOLI" +
	"AN HIEROGLYPH A311ANATOLIAN HIEROGLYPH A312ANATOLIAN HIEROGLYPH A313ANAT" +
	"OLIAN HIEROGLYPH A314ANATOLIAN HIEROGLYPH A315ANATOLIAN HIEROGLYPH A316A" +
	"NATOLIAN HIEROGLYPH A317ANATOLIAN HIEROGLYPH A318ANATOLIAN HIEROGLYPH A3" +
	"19ANATOLIAN HIEROGLYPH A320ANATOLIAN HIEROGLYPH A321ANATOLIAN HIEROGLYPH" +
	" A322ANATOLIAN HIEROGLYPH A323ANATOLIAN HIEROGLYPH A324ANATOLIAN HIEROGL" +
	"YPH A325ANATOLIAN HIEROGLYPH A326ANATOLIAN HIEROGLYPH A327ANATOLIAN HIER" +
	"OGLYPH A328ANATOLIAN HIEROGLYPH A329ANATOLIAN HIEROGLYPH A329AANATOLIAN " +
	"HIEROGLYPH A330ANATOLIAN HIEROGLYPH A331ANATOLIAN HIEROGLYPH A332AANATOL" +
	"IAN HIEROGLYPH A332BANATOLIAN HIEROGLYPH A332CANATOLIAN HIEROGLYPH A333A" +
	"NATOLIAN HIEROGLYPH A334ANATOLIAN HIEROGLYPH A335ANATOLIAN HIEROGLYPH A3" +
	"36ANATOLIAN HIEROGLYPH A336AANATOLIAN HIEROGLYPH A336BANATOLIAN HIEROGLY" +
	"PH A336CANATOLIAN HIEROGLYPH A337ANATOLIAN HIEROGLYPH A338ANATOLIAN HIER" +
	"OGLYPH A339ANATOLIAN HIEROGLYPH A340ANATOLIAN HIEROGLYPH A341ANATOLIAN H" +
	"IEROGLYPH A342ANATOLIAN HIEROGLYPH A343ANATOLIAN HIEROGLYPH A344ANATOLIA" +
	"N HIEROGLYPH A345ANATOLIAN HIEROGLYPH A346ANATOLIAN HIEROGLYPH A347ANATO" +
	"LIAN HIEROGLYPH A348ANATOLIAN HIEROGLYPH A349ANATOLIAN HIEROGLYPH A350AN" +
	"ATOLIAN HIEROGLYPH A351ANATOLIAN HIEROGLYPH A352ANATOLIAN HIEROGLYPH A35" +
	"3ANATOLIAN HIEROGLYPH A354ANATOLIAN HIEROGLYPH A355ANATOLIAN HIEROGLYPH " +
	"A356ANATOLIAN HIEROGLYPH A357ANATOLIAN HIEROGLYPH A358ANATOLIAN HIEROGLY" +
	"PH A359ANATOLIAN HIEROGLYPH A359AANATOLIAN HIEROGLYPH A360ANATOLIAN HIER" +
	"OGLYPH A361ANATOLIAN HIEROGLYPH A362ANATOLIAN HIEROGLYPH A363ANATOLIAN H" +
	"IEROGLYPH A364ANATOLIAN HIEROGLYPH A364AANATOLIAN HIEROGLYPH A365ANATOLI" +
	"AN HIEROGLYPH A366ANATOLIAN HIEROGLYPH A367ANATOLIAN HIEROGLYPH A368ANAT" +
	"OLIAN HIEROGLYPH A368AANATOLIAN HIEROGLYPH A369ANATOLIAN HIEROGLYPH A370") + ("" +
	"ANATOLIAN HIEROGLYPH A371ANATOLIAN HIEROGLYPH A371AANATOLIAN HIEROGLYPH " +
	"A372ANATOLIAN HIEROGLYPH A373ANATOLIAN HIEROGLYPH A374ANATOLIAN HIEROGLY" +
	"PH A375ANATOLIAN HIEROGLYPH A376ANATOLIAN HIEROGLYPH A377ANATOLIAN HIERO" +
	"GLYPH A378ANATOLIAN HIEROGLYPH A379ANATOLIAN HIEROGLYPH A380ANATOLIAN HI" +
	"EROGLYPH A381ANATOLIAN HIEROGLYPH A381AANATOLIAN HIEROGLYPH A382ANATOLIA" +
	"N HIEROGLYPH A383 RA OR RIANATOLIAN HIEROGLYPH A383AANATOLIAN HIEROGLYPH" +
	" A384ANATOLIAN HIEROGLYPH A385ANATOLIAN HIEROGLYPH A386ANATOLIAN HIEROGL" +
	"YPH A386AANATOLIAN HIEROGLYPH A387ANATOLIAN HIEROGLYPH A388ANATOLIAN HIE" +
	"ROGLYPH A389ANATOLIAN HIEROGLYPH A390ANATOLIAN HIEROGLYPH A391ANATOLIAN " +
	"HIEROGLYPH A392ANATOLIAN HIEROGLYPH A393 EIGHTANATOLIAN HIEROGLYPH A394A" +
	"NATOLIAN HIEROGLYPH A395ANATOLIAN HIEROGLYPH A396ANATOLIAN HIEROGLYPH A3" +
	"97ANATOLIAN HIEROGLYPH A398ANATOLIAN HIEROGLYPH A399ANATOLIAN HIEROGLYPH" +
	" A400ANATOLIAN HIEROGLYPH A401ANATOLIAN HIEROGLYPH A402ANATOLIAN HIEROGL" +
	"YPH A403ANATOLIAN HIEROGLYPH A404ANATOLIAN HIEROGLYPH A405ANATOLIAN HIER" +
	"OGLYPH A406ANATOLIAN HIEROGLYPH A407ANATOLIAN HIEROGLYPH A408ANATOLIAN H" +
	"IEROGLYPH A409ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARKANATOLIAN HIE" +
	"ROGLYPH A410A END LOGOGRAM MARKANATOLIAN HIEROGLYPH A411ANATOLIAN HIEROG" +
	"LYPH A412ANATOLIAN HIEROGLYPH A413ANATOLIAN HIEROGLYPH A414ANATOLIAN HIE" +
	"ROGLYPH A415ANATOLIAN HIEROGLYPH A416ANATOLIAN HIEROGLYPH A417ANATOLIAN " +
	"HIEROGLYPH A418ANATOLIAN HIEROGLYPH A419ANATOLIAN HIEROGLYPH A420ANATOLI" +
	"AN HIEROGLYPH A421ANATOLIAN HIEROGLYPH A422ANATOLIAN HIEROGLYPH A423ANAT" +
	"OLIAN HIEROGLYPH A424ANATOLIAN HIEROGLYPH A425ANATOLIAN HIEROGLYPH A426A" +
	"NATOLIAN HIEROGLYPH A427ANATOLIAN HIEROGLYPH A428ANATOLIAN HIEROGLYPH A4" +
	"29ANATOLIAN HIEROGLYPH A430ANATOLIAN HIEROGLYPH A431ANATOLIAN HIEROGLYPH" +
	" A432ANATOLIAN HIEROGLYPH A433ANATOLIAN HIEROGLYPH A434ANATOLIAN HIEROGL" +
	"YPH A435ANATOLIAN HIEROGLYPH A436ANATOLIAN HIEROGLYPH A437ANATOLIAN HIER" +
	"OGLYPH A438ANATOLIAN HIEROGLYPH A439ANATOLIAN HIEROGLYPH A440ANATOLIAN H" +
	"IEROGLYPH A441ANATOLIAN HIEROGLYPH A442ANATOLIAN HIEROGLYPH A443ANATOLIA" +
	"N HIEROGLYPH A444ANATOLIAN HIEROGLYPH A445ANATOLIAN HIEROGLYPH A446ANATO" +
	"LIAN HIEROGLYPH A447ANATOLIAN HIEROGLYPH A448ANATOLIAN HIEROGLYPH A449AN" +
	"ATOLIAN HIEROGLYPH A450ANATOLIAN HIEROGLYPH A450AANATOLIAN HIEROGLYPH A4" +
	"51ANATOLIAN HIEROGLYPH A452ANATOLIAN HIEROGLYPH A453ANATOLIAN HIEROGLYPH" +
	" A454ANATOLIAN HIEROGLYPH A455ANATOLIAN HIEROGLYPH A456ANATOLIAN HIEROGL" +
	"YPH A457ANATOLIAN HIEROGLYPH A457AANATOLIAN HIEROGLYPH A458ANATOLIAN HIE" +
	"ROGLYPH A459ANATOLIAN HIEROGLYPH A460ANATOLIAN HIEROGLYPH A461ANATOLIAN " +
	"HIEROGLYPH A462ANATOLIAN HIEROGLYPH A463ANATOLIAN HIEROGLYPH A464ANATOLI" +
	"AN HIEROGLYPH A465ANATOLIAN HIEROGLYPH A466ANATOLIAN HIEROGLYPH A467ANAT" +
	"OLIAN HIEROGLYPH A468ANATOLIAN HIEROGLYPH A469ANATOLIAN HIEROGLYPH A470A" +
	"NATOLIAN HIEROGLYPH A471ANATOLIAN HIEROGLYPH A472ANATOLIAN HIEROGLYPH A4" +
	"73ANATOLIAN HIEROGLYPH A474ANATOLIAN HIEROGLYPH A475ANATOLIAN HIEROGLYPH" +
	" A476ANATOLIAN HIEROGLYPH A477ANATOLIAN HIEROGLYPH A478ANATOLIAN HIEROGL" +
	"YPH A479ANATOLIAN HIEROGLYPH A480ANATOLIAN HIEROGLYPH A481ANATOLIAN HIER" +
	"OGLYPH A482ANATOLIAN HIEROGLYPH A483ANATOLIAN HIEROGLYPH A484ANATOLIAN H" +
	"IEROGLYPH A485ANATOLIAN HIEROGLYPH A486ANATOLIAN HIEROGLYPH A487ANATOLIA" +
	"N HIEROGLYPH A488ANATOLIAN HIEROGLYPH A489ANATOLIAN HIEROGLYPH A490ANATO" +
	"LIAN HIEROGLYPH A491ANATOLIAN HIEROGLYPH A492ANATOLIAN HIEROGLYPH A493AN" +
	"ATOLIAN HIEROGLYPH A494ANATOLIAN HIEROGLYPH A495ANATOLIAN HIEROGLYPH A49" +
	"6ANATOLIAN HIEROGLYPH A497ANATOLIAN HIEROGLYPH A501ANATOLIAN HIEROGLYPH " +
	"A502ANATOLIAN HIEROGLYPH A503ANATOLIAN HIEROGLYPH A504ANATOLIAN HIEROGLY" +
	"PH A505ANATOLIAN HIEROGLYPH A506ANATOLIAN HIEROGLYPH A507ANATOLIAN HIERO" +
	"GLYPH A508ANATOLIAN HIEROGLYPH A509ANATOLIAN HIEROGLYPH A510ANATOLIAN HI" +
	"EROGLYPH A511ANATOLIAN HIEROGLYPH A512ANATOLIAN HIEROGLYPH A513ANATOLIAN" +
	" HIEROGLYPH A514ANATOLIAN HIEROGLYPH A515ANATOLIAN HIEROGLYPH A516ANATOL" +
	"IAN HIEROGLYPH A517ANATOLIAN HIEROGLYPH A518ANATOLIAN HIEROGLYPH A519ANA" +
	"TOLIAN HIEROGLYPH A520ANATOLIAN HIEROGLYPH A521ANATOLIAN HIEROGLYPH A522" +
	"ANATOLIAN HIEROGLYPH A523ANATOLIAN HIEROGLYPH A524ANATOLIAN HIEROGLYPH A" +
	"525ANATOLIAN HIEROGLYPH A526ANATOLIAN HIEROGLYPH A527ANATOLIAN HIEROGLYP" +
	"H A528ANATOLIAN HIEROGLYPH A529ANATOLIAN HIEROGLYPH A530BAMUM LETTER PHA" +
	"SE-A NGKUE MFONBAMUM LETTER PHASE-A GBIEE FONBAMUM LETTER PHASE-A PON MF" +
	"ON PIPAEMGBIEEBAMUM LETTER PHASE-A PON MFON PIPAEMBABAMUM LETTER PHASE-A" +
	" NAA MFONBAMUM LETTER PHASE-A SHUENSHUETBAMUM LETTER PHASE-A TITA MFONBA" +
	"MUM LETTER PHASE-A NZA MFONBAMUM LETTER PHASE-A SHINDA PA NJIBAMUM LETTE" +
	"R PHASE-A PON PA NJI PIPAEMGBIEEBAMUM LETTER PHASE-A PON PA NJI PIPAEMBA" +
	"BAMUM LETTER PHASE-A MAEMBGBIEEBAMUM LETTER PHASE-A TU MAEMBABAMUM LETTE") + ("" +
	"R PHASE-A NGANGUBAMUM LETTER PHASE-A MAEMVEUXBAMUM LETTER PHASE-A MANSUA" +
	"EBAMUM LETTER PHASE-A MVEUAENGAMBAMUM LETTER PHASE-A SEUNYAMBAMUM LETTER" +
	" PHASE-A NTOQPENBAMUM LETTER PHASE-A KEUKEUTNDABAMUM LETTER PHASE-A NKIN" +
	"DIBAMUM LETTER PHASE-A SUUBAMUM LETTER PHASE-A NGKUENZEUMBAMUM LETTER PH" +
	"ASE-A LAPAQBAMUM LETTER PHASE-A LET KUTBAMUM LETTER PHASE-A NTAP MFAABAM" +
	"UM LETTER PHASE-A MAEKEUPBAMUM LETTER PHASE-A PASHAEBAMUM LETTER PHASE-A" +
	" GHEUAERAEBAMUM LETTER PHASE-A PAMSHAEBAMUM LETTER PHASE-A MON NGGEUAETB" +
	"AMUM LETTER PHASE-A NZUN MEUTBAMUM LETTER PHASE-A U YUQ NAEBAMUM LETTER " +
	"PHASE-A GHEUAEGHEUAEBAMUM LETTER PHASE-A NTAP NTAABAMUM LETTER PHASE-A S" +
	"ISABAMUM LETTER PHASE-A MGBASABAMUM LETTER PHASE-A MEUNJOMNDEUQBAMUM LET" +
	"TER PHASE-A MOOMPUQBAMUM LETTER PHASE-A KAFABAMUM LETTER PHASE-A PA LEER" +
	"AEWABAMUM LETTER PHASE-A NDA LEERAEWABAMUM LETTER PHASE-A PETBAMUM LETTE" +
	"R PHASE-A MAEMKPENBAMUM LETTER PHASE-A NIKABAMUM LETTER PHASE-A PUPBAMUM" +
	" LETTER PHASE-A TUAEPBAMUM LETTER PHASE-A LUAEPBAMUM LETTER PHASE-A SONJ" +
	"AMBAMUM LETTER PHASE-A TEUTEUWENBAMUM LETTER PHASE-A MAENYIBAMUM LETTER " +
	"PHASE-A KETBAMUM LETTER PHASE-A NDAANGGEUAETBAMUM LETTER PHASE-A KUOQBAM" +
	"UM LETTER PHASE-A MOOMEUTBAMUM LETTER PHASE-A SHUMBAMUM LETTER PHASE-A L" +
	"OMMAEBAMUM LETTER PHASE-A FIRIBAMUM LETTER PHASE-A ROMBAMUM LETTER PHASE" +
	"-A KPOQBAMUM LETTER PHASE-A SOQBAMUM LETTER PHASE-A MAP PIEETBAMUM LETTE" +
	"R PHASE-A SHIRAEBAMUM LETTER PHASE-A NTAPBAMUM LETTER PHASE-A SHOQ NSHUT" +
	" YUMBAMUM LETTER PHASE-A NYIT MONGKEUAEQBAMUM LETTER PHASE-A PAARAEBAMUM" +
	" LETTER PHASE-A NKAARAEBAMUM LETTER PHASE-A UNKNOWNBAMUM LETTER PHASE-A " +
	"NGGENBAMUM LETTER PHASE-A MAESIBAMUM LETTER PHASE-A NJAMBAMUM LETTER PHA" +
	"SE-A MBANYIBAMUM LETTER PHASE-A NYETBAMUM LETTER PHASE-A TEUAENBAMUM LET" +
	"TER PHASE-A SOTBAMUM LETTER PHASE-A PAAMBAMUM LETTER PHASE-A NSHIEEBAMUM" +
	" LETTER PHASE-A MAEMBAMUM LETTER PHASE-A NYIBAMUM LETTER PHASE-A KAQBAMU" +
	"M LETTER PHASE-A NSHABAMUM LETTER PHASE-A VEEBAMUM LETTER PHASE-A LUBAMU" +
	"M LETTER PHASE-A NENBAMUM LETTER PHASE-A NAQBAMUM LETTER PHASE-A MBAQBAM" +
	"UM LETTER PHASE-B NSHUETBAMUM LETTER PHASE-B TU MAEMGBIEEBAMUM LETTER PH" +
	"ASE-B SIEEBAMUM LETTER PHASE-B SET TUBAMUM LETTER PHASE-B LOM NTEUMBAMUM" +
	" LETTER PHASE-B MBA MAELEEBAMUM LETTER PHASE-B KIEEMBAMUM LETTER PHASE-B" +
	" YEURAEBAMUM LETTER PHASE-B MBAARAEBAMUM LETTER PHASE-B KAMBAMUM LETTER " +
	"PHASE-B PEESHIBAMUM LETTER PHASE-B YAFU LEERAEWABAMUM LETTER PHASE-B LAM" +
	" NSHUT NYAMBAMUM LETTER PHASE-B NTIEE SHEUOQBAMUM LETTER PHASE-B NDU NJA" +
	"ABAMUM LETTER PHASE-B GHEUGHEUAEMBAMUM LETTER PHASE-B PITBAMUM LETTER PH" +
	"ASE-B TU NSIEEBAMUM LETTER PHASE-B SHET NJAQBAMUM LETTER PHASE-B SHEUAEQ" +
	"TUBAMUM LETTER PHASE-B MFON TEUAEQBAMUM LETTER PHASE-B MBIT MBAAKETBAMUM" +
	" LETTER PHASE-B NYI NTEUMBAMUM LETTER PHASE-B KEUPUQBAMUM LETTER PHASE-B" +
	" GHEUGHENBAMUM LETTER PHASE-B KEUYEUXBAMUM LETTER PHASE-B LAANAEBAMUM LE" +
	"TTER PHASE-B PARUMBAMUM LETTER PHASE-B VEUMBAMUM LETTER PHASE-B NGKINDI " +
	"MVOPBAMUM LETTER PHASE-B NGGEU MBUBAMUM LETTER PHASE-B WUAETBAMUM LETTER" +
	" PHASE-B SAKEUAEBAMUM LETTER PHASE-B TAAMBAMUM LETTER PHASE-B MEUQBAMUM " +
	"LETTER PHASE-B NGGUOQBAMUM LETTER PHASE-B NGGUOQ LARGEBAMUM LETTER PHASE" +
	"-B MFIYAQBAMUM LETTER PHASE-B SUEBAMUM LETTER PHASE-B MBEURIBAMUM LETTER" +
	" PHASE-B MONTIEENBAMUM LETTER PHASE-B NYAEMAEBAMUM LETTER PHASE-B PUNGAA" +
	"MBAMUM LETTER PHASE-B MEUT NGGEETBAMUM LETTER PHASE-B FEUXBAMUM LETTER P" +
	"HASE-B MBUOQBAMUM LETTER PHASE-B FEEBAMUM LETTER PHASE-B KEUAEMBAMUM LET" +
	"TER PHASE-B MA NJEUAENABAMUM LETTER PHASE-B MA NJUQABAMUM LETTER PHASE-B" +
	" LETBAMUM LETTER PHASE-B NGGAAMBAMUM LETTER PHASE-B NSENBAMUM LETTER PHA" +
	"SE-B MABAMUM LETTER PHASE-B KIQBAMUM LETTER PHASE-B NGOMBAMUM LETTER PHA" +
	"SE-C NGKUE MAEMBABAMUM LETTER PHASE-C NZABAMUM LETTER PHASE-C YUMBAMUM L" +
	"ETTER PHASE-C WANGKUOQBAMUM LETTER PHASE-C NGGENBAMUM LETTER PHASE-C NDE" +
	"UAEREEBAMUM LETTER PHASE-C NGKAQBAMUM LETTER PHASE-C GHARAEBAMUM LETTER " +
	"PHASE-C MBEEKEETBAMUM LETTER PHASE-C GBAYIBAMUM LETTER PHASE-C NYIR MKPA" +
	"RAQ MEUNBAMUM LETTER PHASE-C NTU MBITBAMUM LETTER PHASE-C MBEUMBAMUM LET" +
	"TER PHASE-C PIRIEENBAMUM LETTER PHASE-C NDOMBUBAMUM LETTER PHASE-C MBAA " +
	"CABBAGE-TREEBAMUM LETTER PHASE-C KEUSHEUAEPBAMUM LETTER PHASE-C GHAPBAMU" +
	"M LETTER PHASE-C KEUKAQBAMUM LETTER PHASE-C YU MUOMAEBAMUM LETTER PHASE-" +
	"C NZEUMBAMUM LETTER PHASE-C MBUEBAMUM LETTER PHASE-C NSEUAENBAMUM LETTER" +
	" PHASE-C MBITBAMUM LETTER PHASE-C YEUQBAMUM LETTER PHASE-C KPARAQBAMUM L" +
	"ETTER PHASE-C KAABAMUM LETTER PHASE-C SEUXBAMUM LETTER PHASE-C NDIDABAMU" +
	"M LETTER PHASE-C TAASHAEBAMUM LETTER PHASE-C NJUEQBAMUM LETTER PHASE-C T" +
	"ITA YUEBAMUM LETTER PHASE-C SUAETBAMUM LETTER PHASE-C NGGUAEN NYAMBAMUM " +
	"LETTER PHASE-C VEUXBAMUM LETTER PHASE-C NANSANAQBAMUM LETTER PHASE-C MA ") + ("" +
	"KEUAERIBAMUM LETTER PHASE-C NTAABAMUM LETTER PHASE-C NGGUONBAMUM LETTER " +
	"PHASE-C LAPBAMUM LETTER PHASE-C MBIRIEENBAMUM LETTER PHASE-C MGBASAQBAMU" +
	"M LETTER PHASE-C NTEUNGBABAMUM LETTER PHASE-C TEUTEUXBAMUM LETTER PHASE-" +
	"C NGGUMBAMUM LETTER PHASE-C FUEBAMUM LETTER PHASE-C NDEUTBAMUM LETTER PH" +
	"ASE-C NSABAMUM LETTER PHASE-C NSHAQBAMUM LETTER PHASE-C BUNGBAMUM LETTER" +
	" PHASE-C VEUAEPENBAMUM LETTER PHASE-C MBERAEBAMUM LETTER PHASE-C RUBAMUM" +
	" LETTER PHASE-C NJAEMBAMUM LETTER PHASE-C LAMBAMUM LETTER PHASE-C TITUAE" +
	"PBAMUM LETTER PHASE-C NSUOT NGOMBAMUM LETTER PHASE-C NJEEEEBAMUM LETTER " +
	"PHASE-C KETBAMUM LETTER PHASE-C NGGUBAMUM LETTER PHASE-C MAESIBAMUM LETT" +
	"ER PHASE-C MBUAEMBAMUM LETTER PHASE-C LUBAMUM LETTER PHASE-C KUTBAMUM LE" +
	"TTER PHASE-C NJAMBAMUM LETTER PHASE-C NGOMBAMUM LETTER PHASE-C WUPBAMUM " +
	"LETTER PHASE-C NGGUEETBAMUM LETTER PHASE-C NSOMBAMUM LETTER PHASE-C NTEN" +
	"BAMUM LETTER PHASE-C KUOP NKAARAEBAMUM LETTER PHASE-C NSUNBAMUM LETTER P" +
	"HASE-C NDAMBAMUM LETTER PHASE-C MA NSIEEBAMUM LETTER PHASE-C YAABAMUM LE" +
	"TTER PHASE-C NDAPBAMUM LETTER PHASE-C SHUEQBAMUM LETTER PHASE-C SETFONBA" +
	"MUM LETTER PHASE-C MBIBAMUM LETTER PHASE-C MAEMBABAMUM LETTER PHASE-C MB" +
	"ANYIBAMUM LETTER PHASE-C KEUSEUXBAMUM LETTER PHASE-C MBEUXBAMUM LETTER P" +
	"HASE-C KEUMBAMUM LETTER PHASE-C MBAA PICKETBAMUM LETTER PHASE-C YUWOQBAM" +
	"UM LETTER PHASE-C NJEUXBAMUM LETTER PHASE-C MIEEBAMUM LETTER PHASE-C MUA" +
	"EBAMUM LETTER PHASE-C SHIQBAMUM LETTER PHASE-C KEN LAWBAMUM LETTER PHASE" +
	"-C KEN FATIGUEBAMUM LETTER PHASE-C NGAQBAMUM LETTER PHASE-C NAQBAMUM LET" +
	"TER PHASE-C LIQBAMUM LETTER PHASE-C PINBAMUM LETTER PHASE-C PENBAMUM LET" +
	"TER PHASE-C TETBAMUM LETTER PHASE-D MBUOBAMUM LETTER PHASE-D WAPBAMUM LE" +
	"TTER PHASE-D NJIBAMUM LETTER PHASE-D MFONBAMUM LETTER PHASE-D NJIEEBAMUM" +
	" LETTER PHASE-D LIEEBAMUM LETTER PHASE-D NJEUTBAMUM LETTER PHASE-D NSHEE" +
	"BAMUM LETTER PHASE-D NGGAAMAEBAMUM LETTER PHASE-D NYAMBAMUM LETTER PHASE" +
	"-D WUAENBAMUM LETTER PHASE-D NGKUNBAMUM LETTER PHASE-D SHEEBAMUM LETTER " +
	"PHASE-D NGKAPBAMUM LETTER PHASE-D KEUAETMEUNBAMUM LETTER PHASE-D TEUTBAM" +
	"UM LETTER PHASE-D SHEUAEBAMUM LETTER PHASE-D NJAPBAMUM LETTER PHASE-D SU" +
	"EBAMUM LETTER PHASE-D KETBAMUM LETTER PHASE-D YAEMMAEBAMUM LETTER PHASE-" +
	"D KUOMBAMUM LETTER PHASE-D SAPBAMUM LETTER PHASE-D MFEUTBAMUM LETTER PHA" +
	"SE-D NDEUXBAMUM LETTER PHASE-D MALEERIBAMUM LETTER PHASE-D MEUTBAMUM LET" +
	"TER PHASE-D SEUAEQBAMUM LETTER PHASE-D YENBAMUM LETTER PHASE-D NJEUAEMBA" +
	"MUM LETTER PHASE-D KEUOT MBUAEBAMUM LETTER PHASE-D NGKEURIBAMUM LETTER P" +
	"HASE-D TUBAMUM LETTER PHASE-D GHAABAMUM LETTER PHASE-D NGKYEEBAMUM LETTE" +
	"R PHASE-D FEUFEUAETBAMUM LETTER PHASE-D NDEEBAMUM LETTER PHASE-D MGBOFUM" +
	"BAMUM LETTER PHASE-D LEUAEPBAMUM LETTER PHASE-D NDONBAMUM LETTER PHASE-D" +
	" MONIBAMUM LETTER PHASE-D MGBEUNBAMUM LETTER PHASE-D PUUTBAMUM LETTER PH" +
	"ASE-D MGBIEEBAMUM LETTER PHASE-D MFOBAMUM LETTER PHASE-D LUMBAMUM LETTER" +
	" PHASE-D NSIEEPBAMUM LETTER PHASE-D MBAABAMUM LETTER PHASE-D KWAETBAMUM " +
	"LETTER PHASE-D NYETBAMUM LETTER PHASE-D TEUAENBAMUM LETTER PHASE-D SOTBA" +
	"MUM LETTER PHASE-D YUWOQBAMUM LETTER PHASE-D KEUMBAMUM LETTER PHASE-D RA" +
	"EMBAMUM LETTER PHASE-D TEEEEBAMUM LETTER PHASE-D NGKEUAEQBAMUM LETTER PH" +
	"ASE-D MFEUAEBAMUM LETTER PHASE-D NSIEETBAMUM LETTER PHASE-D KEUPBAMUM LE" +
	"TTER PHASE-D PIPBAMUM LETTER PHASE-D PEUTAEBAMUM LETTER PHASE-D NYUEBAMU" +
	"M LETTER PHASE-D LETBAMUM LETTER PHASE-D NGGAAMBAMUM LETTER PHASE-D MFIE" +
	"EBAMUM LETTER PHASE-D NGGWAENBAMUM LETTER PHASE-D YUOMBAMUM LETTER PHASE" +
	"-D PAPBAMUM LETTER PHASE-D YUOPBAMUM LETTER PHASE-D NDAMBAMUM LETTER PHA" +
	"SE-D NTEUMBAMUM LETTER PHASE-D SUAEBAMUM LETTER PHASE-D KUNBAMUM LETTER " +
	"PHASE-D NGGEUXBAMUM LETTER PHASE-D NGKIEEBAMUM LETTER PHASE-D TUOTBAMUM " +
	"LETTER PHASE-D MEUNBAMUM LETTER PHASE-D KUQBAMUM LETTER PHASE-D NSUMBAMU" +
	"M LETTER PHASE-D TEUNBAMUM LETTER PHASE-D MAENJETBAMUM LETTER PHASE-D NG" +
	"GAPBAMUM LETTER PHASE-D LEUMBAMUM LETTER PHASE-D NGGUOMBAMUM LETTER PHAS" +
	"E-D NSHUTBAMUM LETTER PHASE-D NJUEQBAMUM LETTER PHASE-D GHEUAEBAMUM LETT" +
	"ER PHASE-D KUBAMUM LETTER PHASE-D REN OLDBAMUM LETTER PHASE-D TAEBAMUM L" +
	"ETTER PHASE-D TOQBAMUM LETTER PHASE-D NYIBAMUM LETTER PHASE-D RIIBAMUM L" +
	"ETTER PHASE-D LEEEEBAMUM LETTER PHASE-D MEEEEBAMUM LETTER PHASE-D MBAMUM" +
	" LETTER PHASE-D SUUBAMUM LETTER PHASE-D MUBAMUM LETTER PHASE-D SHIIBAMUM" +
	" LETTER PHASE-D SHEUXBAMUM LETTER PHASE-D KYEEBAMUM LETTER PHASE-D NUBAM" +
	"UM LETTER PHASE-D SHUBAMUM LETTER PHASE-D NTEEBAMUM LETTER PHASE-D PEEBA" +
	"MUM LETTER PHASE-D NIBAMUM LETTER PHASE-D SHOQBAMUM LETTER PHASE-D PUQBA" +
	"MUM LETTER PHASE-D MVOPBAMUM LETTER PHASE-D LOQBAMUM LETTER PHASE-D REN " +
	"MUCHBAMUM LETTER PHASE-D TIBAMUM LETTER PHASE-D NTUUBAMUM LETTER PHASE-D" +
	" MBAA SEVENBAMUM LETTER PHASE-D SAQBAMUM LETTER PHASE-D FAABAMUM LETTER ") + ("" +
	"PHASE-E NDAPBAMUM LETTER PHASE-E TOONBAMUM LETTER PHASE-E MBEUMBAMUM LET" +
	"TER PHASE-E LAPBAMUM LETTER PHASE-E VOMBAMUM LETTER PHASE-E LOONBAMUM LE" +
	"TTER PHASE-E PAABAMUM LETTER PHASE-E SOMBAMUM LETTER PHASE-E RAQBAMUM LE" +
	"TTER PHASE-E NSHUOPBAMUM LETTER PHASE-E NDUNBAMUM LETTER PHASE-E PUAEBAM" +
	"UM LETTER PHASE-E TAMBAMUM LETTER PHASE-E NGKABAMUM LETTER PHASE-E KPEUX" +
	"BAMUM LETTER PHASE-E WUOBAMUM LETTER PHASE-E SEEBAMUM LETTER PHASE-E NGG" +
	"EUAETBAMUM LETTER PHASE-E PAAMBAMUM LETTER PHASE-E TOOBAMUM LETTER PHASE" +
	"-E KUOPBAMUM LETTER PHASE-E LOMBAMUM LETTER PHASE-E NSHIEEBAMUM LETTER P" +
	"HASE-E NGOPBAMUM LETTER PHASE-E MAEMBAMUM LETTER PHASE-E NGKEUXBAMUM LET" +
	"TER PHASE-E NGOQBAMUM LETTER PHASE-E NSHUEBAMUM LETTER PHASE-E RIMGBABAM" +
	"UM LETTER PHASE-E NJEUXBAMUM LETTER PHASE-E PEEMBAMUM LETTER PHASE-E SAA" +
	"BAMUM LETTER PHASE-E NGGURAEBAMUM LETTER PHASE-E MGBABAMUM LETTER PHASE-" +
	"E GHEUXBAMUM LETTER PHASE-E NGKEUAEMBAMUM LETTER PHASE-E NJAEMLIBAMUM LE" +
	"TTER PHASE-E MAPBAMUM LETTER PHASE-E LOOTBAMUM LETTER PHASE-E NGGEEEEBAM" +
	"UM LETTER PHASE-E NDIQBAMUM LETTER PHASE-E TAEN NTEUMBAMUM LETTER PHASE-" +
	"E SETBAMUM LETTER PHASE-E PUMBAMUM LETTER PHASE-E NDAA SOFTNESSBAMUM LET" +
	"TER PHASE-E NGGUAESHAE NYAMBAMUM LETTER PHASE-E YIEEBAMUM LETTER PHASE-E" +
	" GHEUNBAMUM LETTER PHASE-E TUAEBAMUM LETTER PHASE-E YEUAEBAMUM LETTER PH" +
	"ASE-E POBAMUM LETTER PHASE-E TUMAEBAMUM LETTER PHASE-E KEUAEBAMUM LETTER" +
	" PHASE-E SUAENBAMUM LETTER PHASE-E TEUAEQBAMUM LETTER PHASE-E VEUAEBAMUM" +
	" LETTER PHASE-E WEUXBAMUM LETTER PHASE-E LAAMBAMUM LETTER PHASE-E PUBAMU" +
	"M LETTER PHASE-E TAAQBAMUM LETTER PHASE-E GHAAMAEBAMUM LETTER PHASE-E NG" +
	"EUREUTBAMUM LETTER PHASE-E SHEUAEQBAMUM LETTER PHASE-E MGBENBAMUM LETTER" +
	" PHASE-E MBEEBAMUM LETTER PHASE-E NZAQBAMUM LETTER PHASE-E NKOMBAMUM LET" +
	"TER PHASE-E GBETBAMUM LETTER PHASE-E TUMBAMUM LETTER PHASE-E KUETBAMUM L" +
	"ETTER PHASE-E YAPBAMUM LETTER PHASE-E NYI CLEAVERBAMUM LETTER PHASE-E YI" +
	"TBAMUM LETTER PHASE-E MFEUQBAMUM LETTER PHASE-E NDIAQBAMUM LETTER PHASE-" +
	"E PIEEQBAMUM LETTER PHASE-E YUEQBAMUM LETTER PHASE-E LEUAEMBAMUM LETTER " +
	"PHASE-E FUEBAMUM LETTER PHASE-E GBEUXBAMUM LETTER PHASE-E NGKUPBAMUM LET" +
	"TER PHASE-E KETBAMUM LETTER PHASE-E MAEBAMUM LETTER PHASE-E NGKAAMIBAMUM" +
	" LETTER PHASE-E GHETBAMUM LETTER PHASE-E FABAMUM LETTER PHASE-E NTUMBAMU" +
	"M LETTER PHASE-E PEUTBAMUM LETTER PHASE-E YEUMBAMUM LETTER PHASE-E NGGEU" +
	"AEBAMUM LETTER PHASE-E NYI BETWEENBAMUM LETTER PHASE-E NZUQBAMUM LETTER " +
	"PHASE-E POONBAMUM LETTER PHASE-E MIEEBAMUM LETTER PHASE-E FUETBAMUM LETT" +
	"ER PHASE-E NAEBAMUM LETTER PHASE-E MUAEBAMUM LETTER PHASE-E GHEUAEBAMUM " +
	"LETTER PHASE-E FU IBAMUM LETTER PHASE-E MVIBAMUM LETTER PHASE-E PUAQBAMU" +
	"M LETTER PHASE-E NGKUMBAMUM LETTER PHASE-E KUTBAMUM LETTER PHASE-E PIETB" +
	"AMUM LETTER PHASE-E NTAPBAMUM LETTER PHASE-E YEUAETBAMUM LETTER PHASE-E " +
	"NGGUPBAMUM LETTER PHASE-E PA PEOPLEBAMUM LETTER PHASE-E FU CALLBAMUM LET" +
	"TER PHASE-E FOMBAMUM LETTER PHASE-E NJEEBAMUM LETTER PHASE-E ABAMUM LETT" +
	"ER PHASE-E TOQBAMUM LETTER PHASE-E OBAMUM LETTER PHASE-E IBAMUM LETTER P" +
	"HASE-E LAQBAMUM LETTER PHASE-E PA PLURALBAMUM LETTER PHASE-E TAABAMUM LE" +
	"TTER PHASE-E TAQBAMUM LETTER PHASE-E NDAA MY HOUSEBAMUM LETTER PHASE-E S" +
	"HIQBAMUM LETTER PHASE-E YEUXBAMUM LETTER PHASE-E NGUAEBAMUM LETTER PHASE" +
	"-E YUAENBAMUM LETTER PHASE-E YOQ SWIMMINGBAMUM LETTER PHASE-E YOQ COVERB" +
	"AMUM LETTER PHASE-E YUQBAMUM LETTER PHASE-E YUNBAMUM LETTER PHASE-E KEUX" +
	"BAMUM LETTER PHASE-E PEUXBAMUM LETTER PHASE-E NJEE EPOCHBAMUM LETTER PHA" +
	"SE-E PUEBAMUM LETTER PHASE-E WUEBAMUM LETTER PHASE-E FEEBAMUM LETTER PHA" +
	"SE-E VEEBAMUM LETTER PHASE-E LUBAMUM LETTER P