// Copyright 2019 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file incorporates work covered by the following copyright and
// permission notice:
//
// Copyright 2016 Attic Labs, Inc. All rights reserved.
// Licensed under the Apache License, version 2.0:
// http://www.apache.org/licenses/LICENSE-2.0

package types

import (
	"github.com/dolthub/dolt/go/store/chunks"
	"github.com/dolthub/dolt/go/store/d"
)

type ValidatingDecoder struct {
	vs *ValueStore
}

func NewValidatingDecoder(cs chunks.ChunkStore) *ValidatingDecoder {
	return &ValidatingDecoder{NewValueStore(cs)}
}

// DecodedChunk holds a pointer to a Chunk and the Value that results from
// calling DecodeFromBytes(c.Data()).
type DecodedChunk struct {
	Chunk *chunks.Chunk
	Value *Value
}

// Decode decodes c and checks that the hash of the resulting value
// matches c.Hash(). It returns a DecodedChunk holding both c and a pointer to
// the decoded Value.
func (vbs *ValidatingDecoder) Decode(c *chunks.Chunk) (DecodedChunk, error) {
	h := c.Hash()
	v, err := decodeFromBytesWithValidation(c.Data(), vbs.vs)

	if err != nil {
		return DecodedChunk{}, err
	}

	vh, err := getHash(v, vbs.vs.Format())

	if err != nil {
		return DecodedChunk{}, err
	}

	if vh != h {
		d.Panic("Invalid hash found")
	}
	return DecodedChunk{c, &v}, nil
}
