// Copyright 2024 The Carvel Authors.
// SPDX-License-Identifier: Apache-2.0

package app

const (
	AppChangesMaxToKeepDefault = 200
)

func (a *RecordedApp) GCChanges(maxValue int, reviewFunc func(changesToDelete []Change) error) (int, int, error) {
	if reviewFunc == nil {
		reviewFunc = func(_ []Change) error { return nil }
	}

	changes, err := a.Changes()
	if err != nil {
		return 0, 0, err
	}

	if len(changes) < maxValue {
		return len(changes), 0, reviewFunc(nil)
	}

	// First change is oldest
	changes = changes[0 : len(changes)-maxValue]

	err = reviewFunc(changes)
	if err != nil {
		return 0, 0, err
	}

	for _, change := range changes {
		err := change.Delete()
		if err != nil {
			return 0, 0, err
		}
	}

	return maxValue, len(changes), nil
}
