package env

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace-bin/pkg/actions/os"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/bat"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/brew"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/gh"
	"github.com/carapace-sh/carapace-bin/pkg/conditions"
	"github.com/carapace-sh/carapace/pkg/style"
)

func init() {
	knownVariables["brew"] = func() variables {
		_bool := carapace.ActionValues("true").StyleF(style.ForKeyword) // brew bool variables are true just by being set
		return variables{
			Condition: conditions.ConditionPath("brew"),
			Variables: map[string]string{
				"HOMEBREW_ALLOWED_TAPS":                     "A space-separated list of taps",
				"HOMEBREW_API_AUTO_UPDATE_SECS":             "Check Homebrew's API for new formulae or cask data automatically",
				"HOMEBREW_API_DOMAIN":                       "Use this URL as the download mirror for Homebrew JSON API",
				"HOMEBREW_ARCH":                             "Linux only: Pass this value to the compiler's `-march` option",
				"HOMEBREW_ARTIFACT_DOMAIN":                  "Prefix all download URLs, including those for bottles, with this value",
				"HOMEBREW_ARTIFACT_DOMAIN_NO_FALLBACK":      "Error rather than trying any other/default URLs",
				"HOMEBREW_ASK":                              "Pass `--ask`to all formulae install commands",
				"HOMEBREW_AUTO_UPDATE_SECS":                 "Run `brew update` once every configured seconds before some commands",
				"HOMEBREW_BAT":                              "Use `bat` for the `brew cat` command",
				"HOMEBREW_BAT_CONFIG_PATH":                  "Use this as the `bat` configuration file",
				"HOMEBREW_BAT_THEME":                        "Use this as the `bat` theme for syntax highlighting",
				"HOMEBREW_BOTTLE_DOMAIN":                    "Use this URL as the download mirror for bottles",
				"HOMEBREW_BREW_GIT_REMOTE":                  "Use this URL as the Homebrew/brew `git` remote",
				"HOMEBREW_BREW_WRAPPER":                     "Use wrapper to call `brew` rather than auto-detecting it",
				"HOMEBREW_BROWSER":                          "Use this as the browser when opening project homepages",
				"HOMEBREW_BUNDLE_USER_CACHE":                "Use this directory as the `bundle` user cache",
				"HOMEBREW_CACHE":                            "Use this directory as the download cache",
				"HOMEBREW_CASK_OPTS":                        "Append these options to all `cask` commands",
				"HOMEBREW_CLEANUP_MAX_AGE_DAYS":             "Cleanup all cached files older than this many days",
				"HOMEBREW_CLEANUP_PERIODIC_FULL_DAYS":       "Cleanup all formulae when this number of days has passed",
				"HOMEBREW_COLOR":                            "Force colour output on non-TTY outputs",
				"HOMEBREW_CORE_GIT_REMOTE":                  "Use this URL as the Homebrew/homebrew-core `git` remote",
				"HOMEBREW_CURLRC":                           "If set to an absolute path, pass it with `--config` when invoking `curl`",
				"HOMEBREW_CURL_PATH":                        "Linux only: Set this value to a new enough `curl` executable to use",
				"HOMEBREW_CURL_RETRIES":                     "Pass the given retry count to `--retry` when invoking `curl`",
				"HOMEBREW_CURL_VERBOSE":                     "Pass `--verbose` when invoking `curl`",
				"HOMEBREW_DEBUG":                            "Always assume `--debug` when running commands",
				"HOMEBREW_DEVELOPER":                        "Tweak behaviour to be more relevant for Homebrew developers",
				"HOMEBREW_DISABLE_DEBREW":                   "Disable the interactive formula debugger",
				"HOMEBREW_DISABLE_LOAD_FORMULA":             "Refuse to load formulae",
				"HOMEBREW_DISPLAY":                          "Use this X11 display when opening a page in a browser",
				"HOMEBREW_DISPLAY_INSTALL_TIMES":            "Print install times for each formula at the end of the run",
				"HOMEBREW_DOCKER_REGISTRY_BASIC_AUTH_TOKEN": "Use this base64 encoded username and password for docker authentication",
				"HOMEBREW_DOCKER_REGISTRY_TOKEN":            "Use this bearer token for docker authentication",
				"HOMEBREW_EDITOR":                           "Use this editor when editing a formula",
				"HOMEBREW_ENV_SYNC_STRICT":                  "Sync only the exact installed versions of formulae",
				"HOMEBREW_EVAL_ALL":                         "Evaluate all formulae and casks by default",
				"HOMEBREW_FAIL_LOG_LINES":                   "Output this many lines of output on formula `system` failures",
				"HOMEBREW_FORBIDDEN_CASKS":                  "A space-separated list of forbidden casks",
				"HOMEBREW_FORBIDDEN_FORMULAE":               "A space-separated list of forbidden formulae",
				"HOMEBREW_FORBIDDEN_LICENSES":               "A space-separated list of forbidden SPDX license identifiers",
				"HOMEBREW_FORBIDDEN_OWNER":                  "The person who has set any `$HOMEBREW_FORBIDDEN_*` variables",
				"HOMEBREW_FORBIDDEN_OWNER_CONTACT":          "How to contact the `$HOMEBREW_FORBIDDEN_OWNER`",
				"HOMEBREW_FORBIDDEN_TAPS":                   "A space-separated list of forbidden taps",
				"HOMEBREW_FORBID_CASKS":                     "Refuse to install any casks",
				"HOMEBREW_FORBID_PACKAGES_FROM_PATHS":       "Refuse to read formulae or casks provided from file paths",
				"HOMEBREW_FORCE_API_AUTO_UPDATE":            "Update the Homebrew API formula or cask data by force",
				"HOMEBREW_FORCE_BREWED_CA_CERTIFICATES":     "Always use a Homebrew-installed `ca-certificates`",
				"HOMEBREW_FORCE_BREWED_CURL":                "Always use a Homebrew-installed `curl`",
				"HOMEBREW_FORCE_BREWED_GIT":                 "Always use a Homebrew-installed `git`",
				"HOMEBREW_FORCE_BREW_WRAPPER":               "Require `$HOMEBREW_BREW_WRAPPER` to be set to the same value as `$HOMEBREW_FORCE_BREW_WRAPPER`",
				"HOMEBREW_FORCE_VENDOR_RUBY":                "Always use Homebrew's vendored, relocatable Ruby version",
				"HOMEBREW_FORMULA_BUILD_NETWORK":            "Controls network access to the sandbox for formulae builds",
				"HOMEBREW_FORMULA_POSTINSTALL_NETWORK":      "Controls network access to the sandbox for formulae postinstall",
				"HOMEBREW_FORMULA_TEST_NETWORK":             "Controls network access to the sandbox for formulae test",
				"HOMEBREW_GITHUB_API_TOKEN":                 "Use this personal access token for the GitHub API",
				"HOMEBREW_GITHUB_PACKAGES_TOKEN":            "Use this GitHub personal access token",
				"HOMEBREW_GITHUB_PACKAGES_USER":             "Use this username when accessing the GitHub Packages Registry",
				"HOMEBREW_GIT_COMMITTER_EMAIL":              "Set the Git committer email",
				"HOMEBREW_GIT_COMMITTER_NAME":               "Set the Git committer name",
				"HOMEBREW_GIT_EMAIL":                        "Set the Git author name and committer email",
				"HOMEBREW_GIT_NAME":                         "Set the Git author and committer name",
				"HOMEBREW_GIT_PATH":                         "Linux only: Set this value to a new enough `git` executable",
				"HOMEBREW_INSTALL_BADGE":                    "Print this text before the installation summary",
				"HOMEBREW_LIVECHECK_AUTOBUMP":               "Include data for packages that are autobumped by BrewTestBot",
				"HOMEBREW_LIVECHECK_WATCHLIST":              "Consult this file for the list of formulae to check by default",
				"HOMEBREW_LOCK_CONTEXT":                     "Add this output as additional context for locking errors",
				"HOMEBREW_LOGS":                             "Use this directory to store log files",
				"HOMEBREW_MAKE_JOBS":                        "Use this value as the number of parallel jobs to run",
				"HOMEBREW_NO_ANALYTICS":                     "Do not send analytics",
				"HOMEBREW_NO_AUTOREMOVE":                    "Do not automatically remove unused formula dependents",
				"HOMEBREW_NO_AUTO_UPDATE":                   "Do not automatically update before running some commands",
				"HOMEBREW_NO_BOOTSNAP":                      "Do not use Bootsnap to speed up repeated `brew` calls",
				"HOMEBREW_NO_CLEANUP_FORMULAE":              "A comma-separated list of formulae",
				"HOMEBREW_NO_COLOR":                         "Do not print text with colour added",
				"HOMEBREW_NO_EMOJI":                         "Do not print `$HOMEBREW_INSTALL_BADGE` on a successful build",
				"HOMEBREW_NO_ENV_HINTS":                     "Do not print any hints about changing Homebrew's behaviour",
				"HOMEBREW_NO_FORCE_BREW_WRAPPER":            "Disables `$HOMEBREW_FORCE_BREW_WRAPPER` behaviour",
				"HOMEBREW_NO_GITHUB_API":                    "Do not use the GitHub API",
				"HOMEBREW_NO_INSECURE_REDIRECT":             "Forbid redirects from secure HTTPS to insecure HTTP",
				"HOMEBREW_NO_INSTALLED_DEPENDENTS_CHECK":    "Do not check for broken linkage of or outdated dependents",
				"HOMEBREW_NO_INSTALL_CLEANUP":               "Never automatically cleanup installed formulae",
				"HOMEBREW_NO_INSTALL_FROM_API":              "Do not install formulae and casks using Homebrew's API",
				"HOMEBREW_NO_INSTALL_UPGRADE":               "Do not upgrade formula/cask if it is installed but outdated",
				"HOMEBREW_NO_UPDATE_REPORT_NEW":             "Do not show the list of newly added formulae/casks",
				"HOMEBREW_NO_VERIFY_ATTESTATIONS":           "Do not verify cryptographic attestations of build provenance",
				"HOMEBREW_PIP_INDEX_URL":                    "Use this URL to download PyPI package resources",
				"HOMEBREW_PRY":                              "Use Pry for the `brew irb` command",
				"HOMEBREW_SIMULATE_MACOS_ON_LINUX":          "Running Homebrew on Linux will simulate certain macOS code paths",
				"HOMEBREW_SKIP_OR_LATER_BOTTLES":            "Do not use bottles from older versions of macOS",
				"HOMEBREW_SORBET_RUNTIME":                   "Enable runtime typechecking using Sorbet",
				"HOMEBREW_SSH_CONFIG_PATH":                  "Use the given ssh config file",
				"HOMEBREW_SUDO_THROUGH_SUDO_USER":           "Use the `SUDO_USER` environment variable",
				"HOMEBREW_SVN":                              "Use this as the `svn` binary",
				"HOMEBREW_SYSTEM_ENV_TAKES_PRIORITY":        "Load the system-wide environment file last",
				"HOMEBREW_TEMP":                             "Use this path as the temporary directory for building packages",
				"HOMEBREW_UPDATE_TO_TAG":                    "Always use the latest stable tag",
				"HOMEBREW_UPGRADE_GREEDY":                   "Pass `--greedy` to all cask upgrade commands",
				"HOMEBREW_UPGRADE_GREEDY_CASKS":             "A space-separated list of greedy casks",
				"HOMEBREW_VERBOSE":                          "Always assume `--verbose` when running commands",
				"HOMEBREW_VERBOSE_USING_DOTS":               "Verbose output will print a `.` no more than once a minute",
				"HOMEBREW_VERIFY_ATTESTATIONS":              "Use the `gh` tool to verify cryptographic attestations",
			},
			VariableCompletion: map[string]carapace.Action{
				"HOMEBREW_ALLOWED_TAPS":                carapace.ActionValues(),
				"HOMEBREW_API_AUTO_UPDATE_SECS":        carapace.ActionValues(),
				"HOMEBREW_API_DOMAIN":                  carapace.ActionValues(),
				"HOMEBREW_ARCH":                        carapace.ActionValues(),
				"HOMEBREW_ARTIFACT_DOMAIN":             carapace.ActionValues(),
				"HOMEBREW_ARTIFACT_DOMAIN_NO_FALLBACK": _bool,
				"HOMEBREW_ASK":                         _bool,
				"HOMEBREW_AUTO_UPDATE_SECS":            carapace.ActionValues(),
				"HOMEBREW_BAT":                         _bool,
				"HOMEBREW_BAT_CONFIG_PATH":             carapace.ActionFiles(),
				"HOMEBREW_BAT_THEME":                   bat.ActionThemes(),
				"HOMEBREW_BOTTLE_DOMAIN":               carapace.ActionValues(),
				"HOMEBREW_BREW_GIT_REMOTE":             carapace.ActionValues(),
				"HOMEBREW_BREW_WRAPPER": carapace.Batch(
					carapace.ActionExecutables(),
					carapace.ActionFiles(),
				).ToA(),
				"HOMEBREW_BROWSER": carapace.Batch(
					carapace.ActionExecutables(),
					carapace.ActionFiles(),
				).ToA(),
				"HOMEBREW_BUNDLE_USER_CACHE":          carapace.ActionDirectories(),
				"HOMEBREW_CACHE":                      carapace.ActionDirectories(),
				"HOMEBREW_CASK_OPTS":                  carapace.ActionValues(), // TODO
				"HOMEBREW_CLEANUP_MAX_AGE_DAYS":       carapace.ActionValues(),
				"HOMEBREW_CLEANUP_PERIODIC_FULL_DAYS": carapace.ActionValues(),
				"HOMEBREW_COLOR":                      _bool,
				"HOMEBREW_CORE_GIT_REMOTE":            carapace.ActionValues(),
				"HOMEBREW_CURLRC":                     carapace.ActionFiles(),
				"HOMEBREW_CURL_PATH": carapace.Batch(
					carapace.ActionExecutables(),
					carapace.ActionFiles(),
				).ToA(),
				"HOMEBREW_CURL_RETRIES":                     carapace.ActionValues(),
				"HOMEBREW_CURL_VERBOSE":                     _bool,
				"HOMEBREW_DEBUG":                            _bool,
				"HOMEBREW_DEVELOPER":                        _bool,
				"HOMEBREW_DISABLE_DEBREW":                   _bool,
				"HOMEBREW_DISABLE_LOAD_FORMULA":             _bool,
				"HOMEBREW_DISPLAY":                          os.ActionDisplays(),
				"HOMEBREW_DISPLAY_INSTALL_TIMES":            _bool,
				"HOMEBREW_DOCKER_REGISTRY_BASIC_AUTH_TOKEN": carapace.ActionValues(),
				"HOMEBREW_DOCKER_REGISTRY_TOKEN":            carapace.ActionValues(),
				"HOMEBREW_EDITOR": carapace.Batch(
					carapace.ActionExecutables(),
					carapace.ActionFiles(),
				).ToA(),
				"HOMEBREW_ENV_SYNC_STRICT":               _bool,
				"HOMEBREW_EVAL_ALL":                      _bool,
				"HOMEBREW_FAIL_LOG_LINES":                carapace.ActionValues(),
				"HOMEBREW_FORBIDDEN_CASKS":               brew.ActionAllCasks().UniqueList(" "),
				"HOMEBREW_FORBIDDEN_FORMULAE":            brew.ActionAllFormulae().UniqueList(" "),
				"HOMEBREW_FORBIDDEN_LICENSES":            gh.ActionLicenses(gh.HostOpts{}).UniqueList(" "),
				"HOMEBREW_FORBIDDEN_OWNER":               carapace.ActionValues(),
				"HOMEBREW_FORBIDDEN_OWNER_CONTACT":       carapace.ActionValues(),
				"HOMEBREW_FORBIDDEN_TAPS":                carapace.ActionValues(),
				"HOMEBREW_FORBID_CASKS":                  _bool,
				"HOMEBREW_FORBID_PACKAGES_FROM_PATHS":    _bool,
				"HOMEBREW_FORCE_API_AUTO_UPDATE":         _bool,
				"HOMEBREW_FORCE_BREWED_CA_CERTIFICATES":  _bool,
				"HOMEBREW_FORCE_BREWED_CURL":             _bool,
				"HOMEBREW_FORCE_BREWED_GIT":              _bool,
				"HOMEBREW_FORCE_BREW_WRAPPER":            _bool,
				"HOMEBREW_FORCE_VENDOR_RUBY":             _bool,
				"HOMEBREW_FORMULA_BUILD_NETWORK":         carapace.ActionValues("allow", "deny").StyleF(style.ForKeyword),
				"HOMEBREW_FORMULA_POSTINSTALL_NETWORK":   carapace.ActionValues("allow", "deny").StyleF(style.ForKeyword),
				"HOMEBREW_FORMULA_TEST_NETWORK":          carapace.ActionValues("allow", "deny").StyleF(style.ForKeyword),
				"HOMEBREW_GITHUB_API_TOKEN":              carapace.ActionValues(),
				"HOMEBREW_GITHUB_PACKAGES_TOKEN":         carapace.ActionValues(),
				"HOMEBREW_GITHUB_PACKAGES_USER":          carapace.ActionValues(),
				"HOMEBREW_GIT_COMMITTER_EMAIL":           carapace.ActionValues(),
				"HOMEBREW_GIT_COMMITTER_NAME":            carapace.ActionValues(),
				"HOMEBREW_GIT_EMAIL":                     carapace.ActionValues(),
				"HOMEBREW_GIT_NAME":                      carapace.ActionValues(),
				"HOMEBREW_GIT_PATH":                      carapace.ActionValues(),
				"HOMEBREW_INSTALL_BADGE":                 carapace.ActionValues(),
				"HOMEBREW_LIVECHECK_AUTOBUMP":            _bool,
				"HOMEBREW_LIVECHECK_WATCHLIST":           carapace.ActionFiles(),
				"HOMEBREW_LOCK_CONTEXT":                  carapace.ActionValues(),
				"HOMEBREW_LOGS":                          carapace.ActionDirectories(),
				"HOMEBREW_MAKE_JOBS":                     carapace.ActionValues(),
				"HOMEBREW_NO_ANALYTICS":                  _bool,
				"HOMEBREW_NO_AUTOREMOVE":                 _bool,
				"HOMEBREW_NO_AUTO_UPDATE":                _bool,
				"HOMEBREW_NO_BOOTSNAP":                   _bool,
				"HOMEBREW_NO_CLEANUP_FORMULAE":           brew.ActionAllFormulae().UniqueList(" "),
				"HOMEBREW_NO_COLOR":                      _bool,
				"HOMEBREW_NO_EMOJI":                      _bool,
				"HOMEBREW_NO_ENV_HINTS":                  _bool,
				"HOMEBREW_NO_FORCE_BREW_WRAPPER":         _bool,
				"HOMEBREW_NO_GITHUB_API":                 _bool,
				"HOMEBREW_NO_INSECURE_REDIRECT":          _bool,
				"HOMEBREW_NO_INSTALLED_DEPENDENTS_CHECK": _bool,
				"HOMEBREW_NO_INSTALL_CLEANUP":            _bool,
				"HOMEBREW_NO_INSTALL_FROM_API":           _bool,
				"HOMEBREW_NO_INSTALL_UPGRADE":            _bool,
				"HOMEBREW_NO_UPDATE_REPORT_NEW":          _bool,
				"HOMEBREW_NO_VERIFY_ATTESTATIONS":        _bool,
				"HOMEBREW_PIP_INDEX_URL":                 carapace.ActionValues(),
				"HOMEBREW_PRY":                           _bool,
				"HOMEBREW_SIMULATE_MACOS_ON_LINUX":       _bool,
				"HOMEBREW_SKIP_OR_LATER_BOTTLES":         _bool,
				"HOMEBREW_SORBET_RUNTIME":                _bool,
				"HOMEBREW_SSH_CONFIG_PATH":               carapace.ActionFiles(),
				"HOMEBREW_SUDO_THROUGH_SUDO_USER":        _bool,
				"HOMEBREW_SVN": carapace.Batch(
					carapace.ActionExecutables(),
					carapace.ActionFiles(),
				).ToA(),
				"HOMEBREW_SYSTEM_ENV_TAKES_PRIORITY": _bool,
				"HOMEBREW_TEMP":                      carapace.ActionDirectories(),
				"HOMEBREW_UPDATE_TO_TAG":             _bool,
				"HOMEBREW_UPGRADE_GREEDY":            _bool,
				"HOMEBREW_UPGRADE_GREEDY_CASKS":      brew.ActionAllCasks().UniqueList(" "),
				"HOMEBREW_VERBOSE":                   _bool,
				"HOMEBREW_VERBOSE_USING_DOTS":        _bool,
				"HOMEBREW_VERIFY_ATTESTATIONS":       _bool,
			},
		}
	}
}
