// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an agreement. An agreement is a bilateral trading partner agreement, or
// partnership, between an Transfer Family server and an AS2 process. The agreement
// defines the file and message transfer relationship between the server and the
// AS2 process. To define an agreement, Transfer Family combines a server, local
// profile, partner profile, certificate, and other attributes.
//
// The partner is identified with the PartnerProfileId , and the AS2 process is
// identified with the LocalProfileId .
//
// Specify either BaseDirectory or CustomDirectories , but not both. Specifying
// both causes the command to fail.
func (c *Client) CreateAgreement(ctx context.Context, params *CreateAgreementInput, optFns ...func(*Options)) (*CreateAgreementOutput, error) {
	if params == nil {
		params = &CreateAgreementInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAgreement", params, optFns, c.addOperationCreateAgreementMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAgreementOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAgreementInput struct {

	// Connectors are used to send files using either the AS2 or SFTP protocol. For
	// the access role, provide the Amazon Resource Name (ARN) of the Identity and
	// Access Management role to use.
	//
	// For AS2 connectors
	//
	// With AS2, you can send files by calling StartFileTransfer and specifying the
	// file paths in the request parameter, SendFilePaths . We use the file’s parent
	// directory (for example, for --send-file-paths /bucket/dir/file.txt , parent
	// directory is /bucket/dir/ ) to temporarily store a processed AS2 message file,
	// store the MDN when we receive them from the partner, and write a final JSON file
	// containing relevant metadata of the transmission. So, the AccessRole needs to
	// provide read and write access to the parent directory of the file location used
	// in the StartFileTransfer request. Additionally, you need to provide read and
	// write access to the parent directory of the files that you intend to send with
	// StartFileTransfer .
	//
	// If you are using Basic authentication for your AS2 connector, the access role
	// requires the secretsmanager:GetSecretValue permission for the secret. If the
	// secret is encrypted using a customer-managed key instead of the Amazon Web
	// Services managed key in Secrets Manager, then the role also needs the
	// kms:Decrypt permission for that key.
	//
	// For SFTP connectors
	//
	// Make sure that the access role provides read and write access to the parent
	// directory of the file location that's used in the StartFileTransfer request.
	// Additionally, make sure that the role provides secretsmanager:GetSecretValue
	// permission to Secrets Manager.
	//
	// This member is required.
	AccessRole *string

	// A unique identifier for the AS2 local profile.
	//
	// This member is required.
	LocalProfileId *string

	// A unique identifier for the partner profile used in the agreement.
	//
	// This member is required.
	PartnerProfileId *string

	// A system-assigned unique identifier for a server instance. This is the specific
	// server that the agreement uses.
	//
	// This member is required.
	ServerId *string

	// The landing directory (folder) for files transferred by using the AS2 protocol.
	//
	// A BaseDirectory example is /amzn-s3-demo-bucket/home/mydirectory .
	BaseDirectory *string

	// A CustomDirectoriesType structure. This structure specifies custom directories
	// for storing various AS2 message files. You can specify directories for the
	// following types of files.
	//
	//   - Failed files
	//
	//   - MDN files
	//
	//   - Payload files
	//
	//   - Status files
	//
	//   - Temporary files
	CustomDirectories *types.CustomDirectoriesType

	// A name or short description to identify the agreement.
	Description *string

	//  Determines whether or not unsigned messages from your trading partners will be
	// accepted.
	//
	//   - ENABLED : Transfer Family rejects unsigned messages from your trading
	//   partner.
	//
	//   - DISABLED (default value): Transfer Family accepts unsigned messages from
	//   your trading partner.
	EnforceMessageSigning types.EnforceMessageSigningType

	//  Determines whether or not Transfer Family appends a unique string of
	// characters to the end of the AS2 message payload filename when saving it.
	//
	//   - ENABLED : the filename provided by your trading parter is preserved when the
	//   file is saved.
	//
	//   - DISABLED (default value): when Transfer Family saves the file, the filename
	//   is adjusted, as described in [File names and locations].
	//
	// [File names and locations]: https://docs.aws.amazon.com/transfer/latest/userguide/send-as2-messages.html#file-names-as2
	PreserveFilename types.PreserveFilenameType

	// The status of the agreement. The agreement can be either ACTIVE or INACTIVE .
	Status types.AgreementStatusType

	// Key-value pairs that can be used to group and search for agreements.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAgreementOutput struct {

	// The unique identifier for the agreement. Use this ID for deleting, or updating
	// an agreement, as well as in any other API calls that require that you specify
	// the agreement ID.
	//
	// This member is required.
	AgreementId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAgreementMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateAgreement{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateAgreement{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAgreement"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAgreementValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAgreement(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateAgreement(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAgreement",
	}
}
