// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmguiconnect

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/ssmguiconnect/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpUpdateConnectionRecordingPreferences struct {
}

func (*validateOpUpdateConnectionRecordingPreferences) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConnectionRecordingPreferences) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConnectionRecordingPreferencesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConnectionRecordingPreferencesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpUpdateConnectionRecordingPreferencesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConnectionRecordingPreferences{}, middleware.After)
}

func validateConnectionRecordingPreferences(v *types.ConnectionRecordingPreferences) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectionRecordingPreferences"}
	if v.RecordingDestinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RecordingDestinations"))
	} else if v.RecordingDestinations != nil {
		if err := validateRecordingDestinations(v.RecordingDestinations); err != nil {
			invalidParams.AddNested("RecordingDestinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.KMSKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KMSKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecordingDestinations(v *types.RecordingDestinations) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecordingDestinations"}
	if v.S3Buckets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Buckets"))
	} else if v.S3Buckets != nil {
		if err := validateS3Buckets(v.S3Buckets); err != nil {
			invalidParams.AddNested("S3Buckets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Bucket(v *types.S3Bucket) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Bucket"}
	if v.BucketOwner == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketOwner"))
	}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Buckets(v []types.S3Bucket) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Buckets"}
	for i := range v {
		if err := validateS3Bucket(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConnectionRecordingPreferencesInput(v *UpdateConnectionRecordingPreferencesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConnectionRecordingPreferencesInput"}
	if v.ConnectionRecordingPreferences == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectionRecordingPreferences"))
	} else if v.ConnectionRecordingPreferences != nil {
		if err := validateConnectionRecordingPreferences(v.ConnectionRecordingPreferences); err != nil {
			invalidParams.AddNested("ConnectionRecordingPreferences", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
