// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update the customer-managed sending status for a reputation entity. This allows
// you to enable, disable, or reinstate sending for the entity.
//
// The customer-managed status works in conjunction with the Amazon Web Services
// Amazon SES-managed status to determine the overall sending capability. When you
// update the customer-managed status, the Amazon Web Services Amazon SES-managed
// status remains unchanged. If Amazon Web Services Amazon SES has disabled the
// entity, it will not be allowed to send regardless of the customer-managed status
// setting. When you reinstate an entity through the customer-managed status, it
// can continue sending only if the Amazon Web Services Amazon SES-managed status
// also permits sending, even if there are active reputation findings, until the
// findings are resolved or new violations occur.
func (c *Client) UpdateReputationEntityCustomerManagedStatus(ctx context.Context, params *UpdateReputationEntityCustomerManagedStatusInput, optFns ...func(*Options)) (*UpdateReputationEntityCustomerManagedStatusOutput, error) {
	if params == nil {
		params = &UpdateReputationEntityCustomerManagedStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateReputationEntityCustomerManagedStatus", params, optFns, c.addOperationUpdateReputationEntityCustomerManagedStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateReputationEntityCustomerManagedStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to update the customer-managed sending status for a
// reputation entity.
type UpdateReputationEntityCustomerManagedStatusInput struct {

	// The unique identifier for the reputation entity. For resource-type entities,
	// this is the Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	ReputationEntityReference *string

	// The type of reputation entity. Currently, only RESOURCE type entities are
	// supported.
	//
	// This member is required.
	ReputationEntityType types.ReputationEntityType

	// The new customer-managed sending status for the reputation entity. This can be
	// one of the following:
	//
	//   - ENABLED – Allow sending for this entity.
	//
	//   - DISABLED – Prevent sending for this entity.
	//
	//   - REINSTATED – Allow sending even if there are active reputation findings.
	//
	// This member is required.
	SendingStatus types.SendingStatus

	noSmithyDocumentSerde
}

// If the action is successful, the service sends back an HTTP 200 response with
// an empty HTTP body.
type UpdateReputationEntityCustomerManagedStatusOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateReputationEntityCustomerManagedStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateReputationEntityCustomerManagedStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateReputationEntityCustomerManagedStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateReputationEntityCustomerManagedStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateReputationEntityCustomerManagedStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateReputationEntityCustomerManagedStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateReputationEntityCustomerManagedStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateReputationEntityCustomerManagedStatus",
	}
}
