// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Creates a monitor probe.
type CreateMonitorProbeInput struct {

	// The destination IP address. This must be either IPV4 or IPV6 .
	//
	// This member is required.
	Destination *string

	// The protocol used for the network traffic between the source and destination .
	// This must be either TCP or ICMP .
	//
	// This member is required.
	Protocol Protocol

	// The ARN of the subnet.
	//
	// This member is required.
	SourceArn *string

	// The port associated with the destination . This is required only if the protocol
	// is TCP and must be a number between 1 and 65536 .
	DestinationPort *int32

	// The size of the packets sent between the source and destination. This must be a
	// number between 56 and 8500 .
	PacketSize *int32

	// The list of key-value pairs created and assigned to the monitor.
	ProbeTags map[string]string

	noSmithyDocumentSerde
}

// Displays summary information about a monitor.
type MonitorSummary struct {

	// The ARN of the monitor.
	//
	// This member is required.
	MonitorArn *string

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The state of the monitor.
	//
	// This member is required.
	State MonitorState

	// The time, in seconds, that metrics are collected and sent to Amazon CloudWatch.
	// Valid values are either 30 or 60 .
	AggregationPeriod *int64

	// The list of key-value pairs assigned to the monitor.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Describes information about a network monitor probe.
type Probe struct {

	// The destination for the probe. This should be either an IPV4 or IPV6 .
	//
	// This member is required.
	Destination *string

	// The network protocol for the destination. This can be either TCP or ICMP . If
	// the protocol is TCP , then port is also required.
	//
	// This member is required.
	Protocol Protocol

	// The ARN of the probe source subnet.
	//
	// This member is required.
	SourceArn *string

	// The IPv4 or IPv6 address for the probe.
	AddressFamily AddressFamily

	// The time and date the probe was created.
	CreatedAt *time.Time

	// The destination port for the probe. This is required only if the protocol is TCP
	// and must be a number between 1 and 65536 .
	DestinationPort *int32

	// The time and date that the probe was last modified.
	ModifiedAt *time.Time

	// The size of the packets traveling between the source and destination . This must
	// be a number between 56 and
	PacketSize *int32

	// The ARN of the probe.
	ProbeArn *string

	// The ID of the probe.
	ProbeId *string

	// The state of the probe.
	State ProbeState

	// The list of key-value pairs created and assigned to the probe.
	Tags map[string]string

	// The ID of the source VPC subnet.
	VpcId *string

	noSmithyDocumentSerde
}

// Defines a probe when creating a probe or monitor.
type ProbeInput struct {

	// The destination IP address. This must be either IPV4 or IPV6 .
	//
	// This member is required.
	Destination *string

	// The protocol used for the network traffic between the source and destination .
	// This must be either TCP or ICMP .
	//
	// This member is required.
	Protocol Protocol

	// The ARN of the subnet.
	//
	// This member is required.
	SourceArn *string

	// The port associated with the destination . This is required only if the protocol
	// is TCP and must be a number between 1 and 65536 .
	DestinationPort *int32

	// The size of the packets sent between the source and destination. This must be a
	// number between 56 and 8500 .
	PacketSize *int32

	// The list of key-value pairs created and assigned to the monitor.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
