// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns the results of a specific flow operation.
//
// Flow operations let you manage the flows tracked in the flow table, also known
// as the firewall table.
//
// A flow is network traffic that is monitored by a firewall, either by stateful
// or stateless rules. For traffic to be considered part of a flow, it must share
// Destination, DestinationPort, Direction, Protocol, Source, and SourcePort.
func (c *Client) ListFlowOperationResults(ctx context.Context, params *ListFlowOperationResultsInput, optFns ...func(*Options)) (*ListFlowOperationResultsOutput, error) {
	if params == nil {
		params = &ListFlowOperationResultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFlowOperationResults", params, optFns, c.addOperationListFlowOperationResultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFlowOperationResultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFlowOperationResultsInput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	//
	// This member is required.
	FlowOperationId *string

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The maximum number of objects that you want Network Firewall to return for this
	// request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int32

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	// A unique identifier for the primary endpoint associated with a firewall.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

type ListFlowOperationResultsOutput struct {

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	FlowOperationId *string

	// Returns the status of the flow operation. This string is returned in the
	// responses to start, list, and describe commands.
	//
	// If the status is COMPLETED_WITH_ERRORS , results may be returned with any number
	// of Flows missing from the response. If the status is FAILED , Flows returned
	// will be empty.
	FlowOperationStatus types.FlowOperationStatus

	// A timestamp indicating when the Suricata engine identified flows impacted by an
	// operation.
	FlowRequestTimestamp *time.Time

	// Any number of arrays, where each array is a single flow identified in the scope
	// of the operation. If multiple flows were in the scope of the operation, multiple
	// Flows arrays are returned.
	Flows []types.Flow

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	// If the asynchronous operation fails, Network Firewall populates this with the
	// reason for the error or failure. Options include Flow operation error and Flow
	// timeout .
	StatusMessage *string

	//
	VpcEndpointAssociationArn *string

	//
	VpcEndpointId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFlowOperationResultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListFlowOperationResults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListFlowOperationResults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFlowOperationResults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFlowOperationResultsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFlowOperationResults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFlowOperationResultsPaginatorOptions is the paginator options for
// ListFlowOperationResults
type ListFlowOperationResultsPaginatorOptions struct {
	// The maximum number of objects that you want Network Firewall to return for this
	// request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFlowOperationResultsPaginator is a paginator for ListFlowOperationResults
type ListFlowOperationResultsPaginator struct {
	options   ListFlowOperationResultsPaginatorOptions
	client    ListFlowOperationResultsAPIClient
	params    *ListFlowOperationResultsInput
	nextToken *string
	firstPage bool
}

// NewListFlowOperationResultsPaginator returns a new
// ListFlowOperationResultsPaginator
func NewListFlowOperationResultsPaginator(client ListFlowOperationResultsAPIClient, params *ListFlowOperationResultsInput, optFns ...func(*ListFlowOperationResultsPaginatorOptions)) *ListFlowOperationResultsPaginator {
	if params == nil {
		params = &ListFlowOperationResultsInput{}
	}

	options := ListFlowOperationResultsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFlowOperationResultsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFlowOperationResultsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFlowOperationResults page.
func (p *ListFlowOperationResultsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFlowOperationResultsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFlowOperationResults(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFlowOperationResultsAPIClient is a client that implements the
// ListFlowOperationResults operation.
type ListFlowOperationResultsAPIClient interface {
	ListFlowOperationResults(context.Context, *ListFlowOperationResultsInput, ...func(*Options)) (*ListFlowOperationResultsOutput, error)
}

var _ ListFlowOperationResultsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFlowOperationResults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFlowOperationResults",
	}
}
