// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Strategy for how an approval team grants approval.
//
// The following types satisfy this interface:
//
//	ApprovalStrategyMemberMofN
type ApprovalStrategy interface {
	isApprovalStrategy()
}

// Minimum number of approvals (M) required for a total number of approvers (N).
type ApprovalStrategyMemberMofN struct {
	Value MofNApprovalStrategy

	noSmithyDocumentSerde
}

func (*ApprovalStrategyMemberMofN) isApprovalStrategy() {}

// Contains details for how an approval team grants approval.
//
// The following types satisfy this interface:
//
//	ApprovalStrategyResponseMemberMofN
type ApprovalStrategyResponse interface {
	isApprovalStrategyResponse()
}

// Minimum number of approvals (M) required for a total number of approvers (N).
type ApprovalStrategyResponseMemberMofN struct {
	Value MofNApprovalStrategy

	noSmithyDocumentSerde
}

func (*ApprovalStrategyResponseMemberMofN) isApprovalStrategyResponse() {}

// Contains details for an approver.
type ApprovalTeamRequestApprover struct {

	// ID for the user.
	//
	// This member is required.
	PrimaryIdentityId *string

	// Amazon Resource Name (ARN) for the identity source. The identity source manages
	// the user authentication for approvers.
	//
	// This member is required.
	PrimaryIdentitySourceArn *string

	noSmithyDocumentSerde
}

// Contains the filter to apply to requests. You can specify up to 10 filters for
// a request.
type Filter struct {

	// Name of the filter to use.
	//
	// Supported filters
	//
	// The supported filters for ListSessions are: ActionName , SessionStatus , and InitationTime .
	FieldName FilterField

	// Operator to use for filtering.
	//
	//   - EQ : Equal to the specified value
	//
	//   - NE : Not equal to the specified value
	//
	//   - GT : Greater than the specified value
	//
	//   - LT : Less than the specified value
	//
	//   - GTE : Greater than or equal to the specified value
	//
	//   - LTE : Less than or equal to the specified value
	//
	//   - CONTAINS : Contains the specified value
	//
	//   - NOT_CONTAINS : Does not contain the specified value
	//
	//   - BETWEEN : Between two values, inclusive of the specified values.
	//
	// Supported operators for each filter:
	//
	//   - ActionName : EQ | NE | CONTAINS | NOT_CONTAINS
	//
	//   - SessionStatus : EQ | NE
	//
	//   - InitiationTime : GT | LT | GTE | LTE | BETWEEN
	Operator Operator

	// Value to use for filtering. For the BETWEEN operator, specify values in the
	// format a AND b ( AND is case-insensitive).
	Value *string

	noSmithyDocumentSerde
}

// Contains details for an approver.
type GetApprovalTeamResponseApprover struct {

	// ID for the approver.
	ApproverId *string

	// ID for the user.
	PrimaryIdentityId *string

	// Amazon Resource Name (ARN) for the identity source. The identity source manages
	// the user authentication for approvers.
	PrimaryIdentitySourceArn *string

	// Status for the identity source. For example, if an approver has accepted a team
	// invitation with a user authentication method managed by the identity source.
	PrimaryIdentityStatus IdentityStatus

	// Timestamp when the approver responded to an approval team invitation.
	ResponseTime *time.Time

	noSmithyDocumentSerde
}

// Contains details for an approver response in an approval session.
type GetSessionResponseApproverResponse struct {

	// ID for the approver.
	ApproverId *string

	// ID for the identity source. The identity source manages the user authentication
	// for approvers.
	IdentityId *string

	// Amazon Resource Name (ARN) for the identity source. The identity source manages
	// the user authentication for approvers.
	IdentitySourceArn *string

	// Response to the operation request.
	Response SessionResponse

	// Timestamp when a approver responded to the operation request.
	ResponseTime *time.Time

	noSmithyDocumentSerde
}

// IAM Identity Center credentials. For more information see, [IAM Identity Center] .
//
// [IAM Identity Center]: http://aws.amazon.com/identity-center/
type IamIdentityCenter struct {

	// Amazon Resource Name (ARN) for the IAM Identity Center instance.
	//
	// This member is required.
	InstanceArn *string

	// Amazon Web Services Region where the IAM Identity Center instance is located.
	//
	// This member is required.
	Region *string

	noSmithyDocumentSerde
}

// IAM Identity Center credentials. For more information see, [IAM Identity Center] .
//
// [IAM Identity Center]: http://aws.amazon.com/identity-center/
type IamIdentityCenterForGet struct {

	// URL for the approval portal associated with the IAM Identity Center instance.
	ApprovalPortalUrl *string

	// Amazon Resource Name (ARN) for the IAM Identity Center instance.
	InstanceArn *string

	// Amazon Web Services Region where the IAM Identity Center instance is located.
	Region *string

	noSmithyDocumentSerde
}

// IAM Identity Center credentials. For more information see, [IAM Identity Center] .
//
// [IAM Identity Center]: http://aws.amazon.com/identity-center/
type IamIdentityCenterForList struct {

	// URL for the approval portal associated with the IAM Identity Center instance.
	ApprovalPortalUrl *string

	// Amazon Resource Name (ARN) for the IAM Identity Center instance.
	InstanceArn *string

	// Amazon Web Services Region where the IAM Identity Center instance is located.
	Region *string

	noSmithyDocumentSerde
}

// Contains details for an identity source. For more information, see [Identity source] in the
// Multi-party approval User Guide.
//
// [Identity source]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
type IdentitySourceForList struct {

	// Timestamp when the identity source was created.
	CreationTime *time.Time

	// Amazon Resource Name (ARN) for the identity source.
	IdentitySourceArn *string

	// A IdentitySourceParametersForList object. Contains details for the resource
	// that provides identities to the identity source. For example, an IAM Identity
	// Center instance.
	IdentitySourceParameters IdentitySourceParametersForList

	// The type of resource that provided identities to the identity source. For
	// example, an IAM Identity Center instance.
	IdentitySourceType IdentitySourceType

	// Status for the identity source. For example, if the identity source is ACTIVE .
	Status IdentitySourceStatus

	// Status code of the identity source.
	StatusCode IdentitySourceStatusCode

	// Message describing the status for the identity source.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains details for the resource that provides identities to the identity
// source. For example, an IAM Identity Center instance.
type IdentitySourceParameters struct {

	// IAM Identity Center credentials.
	IamIdentityCenter *IamIdentityCenter

	noSmithyDocumentSerde
}

// Contains details for the resource that provides identities to the identity
// source. For example, an IAM Identity Center instance. For more information, see [Identity source]
// in the Multi-party approval User Guide.
//
// The following types satisfy this interface:
//
//	IdentitySourceParametersForGetMemberIamIdentityCenter
//
// [Identity source]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
type IdentitySourceParametersForGet interface {
	isIdentitySourceParametersForGet()
}

// IAM Identity Center credentials.
type IdentitySourceParametersForGetMemberIamIdentityCenter struct {
	Value IamIdentityCenterForGet

	noSmithyDocumentSerde
}

func (*IdentitySourceParametersForGetMemberIamIdentityCenter) isIdentitySourceParametersForGet() {}

// Contains details for the resource that provides identities to the identity
// source. For example, an IAM Identity Center instance. For more information, see [Identity source]
// in the Multi-party approval User Guide.
//
// The following types satisfy this interface:
//
//	IdentitySourceParametersForListMemberIamIdentityCenter
//
// [Identity source]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
type IdentitySourceParametersForList interface {
	isIdentitySourceParametersForList()
}

// IAM Identity Center credentials.
type IdentitySourceParametersForListMemberIamIdentityCenter struct {
	Value IamIdentityCenterForList

	noSmithyDocumentSerde
}

func (*IdentitySourceParametersForListMemberIamIdentityCenter) isIdentitySourceParametersForList() {}

// Contains details for an approval team
type ListApprovalTeamsResponseApprovalTeam struct {

	// An ApprovalStrategyResponse object. Contains details for how an approval team
	// grants approval.
	ApprovalStrategy ApprovalStrategyResponse

	// Amazon Resource Name (ARN) for the team.
	Arn *string

	// Timestamp when the team was created.
	CreationTime *time.Time

	// Description for the team.
	Description *string

	// Name of the team.
	Name *string

	// Total number of approvers in the team.
	NumberOfApprovers *int32

	// Status for the team. For more information, see [Team health] in the Multi-party approval
	// User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	Status ApprovalTeamStatus

	// Status code for the team. For more information, see [Team health] in the Multi-party
	// approval User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	StatusCode ApprovalTeamStatusCode

	// Message describing the status for the team.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains details about a policy for a resource.
type ListResourcePoliciesResponseResourcePolicy struct {

	// Amazon Resource Name (ARN) for policy.
	PolicyArn *string

	// Name of the policy.
	PolicyName *string

	// The type of policy.
	PolicyType PolicyType

	noSmithyDocumentSerde
}

// Contains details for an approval session. For more information, see [Session] in the
// Multi-party approval User Guide
//
// [Session]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
type ListSessionsResponseSession struct {

	// Strategy for executing the protected operation. AUTO_COMPLETION_UPON_APPROVAL
	// means the operation is executed automatically using the requester's permissions,
	// if approved.
	ActionCompletionStrategy ActionCompletionStrategy

	// Name of the protected operation.
	ActionName *string

	// Amazon Resource Name (ARN) for the approval team.
	ApprovalTeamArn *string

	// Name of the approval team.
	ApprovalTeamName *string

	// Timestamp when the session was completed.
	CompletionTime *time.Time

	// Description for the team.
	Description *string

	// Timestamp when the session was expire.
	ExpirationTime *time.Time

	// Timestamp when the session was initiated.
	InitiationTime *time.Time

	// Amazon Resource Name (ARN) for the protected operation.
	ProtectedResourceArn *string

	// ID for the account that made the operation request.
	RequesterAccountId *string

	// [IAM principal] that made the operation request.
	//
	// [IAM principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request
	RequesterPrincipalArn *string

	// Amazon Web Services Region where the operation request originated.
	RequesterRegion *string

	// [Service principal] for the service associated with the protected operation.
	//
	// [Service principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services
	RequesterServicePrincipal *string

	// Amazon Resource Name (ARN) for the session.
	SessionArn *string

	// Status for the protected operation. For example, if the operation is PENDING .
	Status SessionStatus

	// Status code of the session.
	StatusCode SessionStatusCode

	// Message describing the status for session.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Strategy for how an approval team grants approval.
type MofNApprovalStrategy struct {

	// Minimum number of approvals (M) required for a total number of approvers (N).
	//
	// This member is required.
	MinApprovalsRequired *int32

	noSmithyDocumentSerde
}

// Contains details for the pending updates for an approval team, if applicable.
type PendingUpdate struct {

	// An ApprovalStrategyResponse object. Contains details for how the team grants
	// approval.
	ApprovalStrategy ApprovalStrategyResponse

	// An array of GetApprovalTeamResponseApprover  objects. Contains details for the
	// approvers in the team.
	Approvers []GetApprovalTeamResponseApprover

	// Description for the team.
	Description *string

	// Total number of approvers in the team.
	NumberOfApprovers *int32

	// Status for the team. For more information, see [Team health] in the Multi-party approval
	// User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	Status ApprovalTeamStatus

	// Status code for the update. For more information, see [Team health] in the Multi-party
	// approval User Guide.
	//
	// [Team health]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html
	StatusCode ApprovalTeamStatusCode

	// Message describing the status for the team.
	StatusMessage *string

	// Timestamp when the update request was initiated.
	UpdateInitiationTime *time.Time

	// Version ID for the team.
	VersionId *string

	noSmithyDocumentSerde
}

// Contains details for a policy. Policies define what operations a team that
// define the permissions for team resources.
//
// The protected operation for a service integration might require specific
// permissions. For more information, see [How other services work with Multi-party approval]in the Multi-party approval User Guide.
//
// [How other services work with Multi-party approval]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html
type Policy struct {

	// Amazon Resource Name (ARN) for the policy.
	//
	// This member is required.
	Arn *string

	// Determines if the specified policy is the default for the team.
	//
	// This member is required.
	DefaultVersion *int32

	// Name of the policy.
	//
	// This member is required.
	Name *string

	// The type of policy.
	//
	// This member is required.
	PolicyType PolicyType

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) for a policy. Policies define what
// operations a team that define the permissions for team resources.
//
// The protected operation for a service integration might require specific
// permissions. For more information, see [How other services work with Multi-party approval]in the Multi-party approval User Guide.
//
// [How other services work with Multi-party approval]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html
type PolicyReference struct {

	// Amazon Resource Name (ARN) for the policy.
	//
	// This member is required.
	PolicyArn *string

	noSmithyDocumentSerde
}

// Contains details for the version of a policy. Policies define what operations a
// team that define the permissions for team resources.
//
// The protected operation for a service integration might require specific
// permissions. For more information, see [How other services work with Multi-party approval]in the Multi-party approval User Guide.
//
// [How other services work with Multi-party approval]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html
type PolicyVersion struct {

	// Amazon Resource Name (ARN) for the team.
	//
	// This member is required.
	Arn *string

	// Timestamp when the policy was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Document that contains the policy contents.
	//
	// This member is required.
	Document *string

	// Determines if the specified policy is the default for the team.
	//
	// This member is required.
	IsDefault *bool

	// Timestamp when the policy was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// Name of the policy.
	//
	// This member is required.
	Name *string

	// Amazon Resource Name (ARN) for the policy.
	//
	// This member is required.
	PolicyArn *string

	// The type of policy.
	//
	// This member is required.
	PolicyType PolicyType

	// Status for the policy. For example, if the policy is [attachable] or [deprecated].
	//
	// [deprecated]: https://docs.aws.amazon.com/access_policies_managed-deprecated.html
	// [attachable]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html
	//
	// This member is required.
	Status PolicyStatus

	// Verison ID
	//
	// This member is required.
	VersionId *int32

	noSmithyDocumentSerde
}

// Contains details for the version of a policy. Policies define what operations a
// team that define the permissions for team resources.
//
// The protected operation for a service integration might require specific
// permissions. For more information, see [How other services work with Multi-party approval]in the Multi-party approval User Guide.
//
// [How other services work with Multi-party approval]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html
type PolicyVersionSummary struct {

	// Amazon Resource Name (ARN) for the team.
	//
	// This member is required.
	Arn *string

	// Timestamp when the policy was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Determines if the specified policy is the default for the team.
	//
	// This member is required.
	IsDefault *bool

	// Timestamp when the policy was last updated.
	//
	// This member is required.
	LastUpdatedTime *time.Time

	// Name of the policy
	//
	// This member is required.
	Name *string

	// Amazon Resource Name (ARN) for the policy.
	//
	// This member is required.
	PolicyArn *string

	// The type of policy.
	//
	// This member is required.
	PolicyType PolicyType

	// Status for the policy. For example, if the policy is [attachable] or [deprecated].
	//
	// [deprecated]: https://docs.aws.amazon.com/access_policies_managed-deprecated.html
	// [attachable]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html
	//
	// This member is required.
	Status PolicyStatus

	// Version ID for the policy.
	//
	// This member is required.
	VersionId *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isApprovalStrategy()                {}
func (*UnknownUnionMember) isApprovalStrategyResponse()        {}
func (*UnknownUnionMember) isIdentitySourceParametersForGet()  {}
func (*UnknownUnionMember) isIdentitySourceParametersForList() {}
