// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing flow output.
func (c *Client) UpdateFlowOutput(ctx context.Context, params *UpdateFlowOutputInput, optFns ...func(*Options)) (*UpdateFlowOutputOutput, error) {
	if params == nil {
		params = &UpdateFlowOutputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFlowOutput", params, optFns, c.addOperationUpdateFlowOutputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFlowOutputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFlowOutputInput struct {

	//  The Amazon Resource Name (ARN) of the flow that is associated with the output
	// that you want to update.
	//
	// This member is required.
	FlowArn *string

	//  The ARN of the output that you want to update.
	//
	// This member is required.
	OutputArn *string

	//  The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless
	// Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []string

	//  A description of the output. This description appears only on the MediaConnect
	// console and will not be seen by the end user.
	Description *string

	//  The IP address where you want to send the output.
	Destination *string

	//  The type of key used for the encryption. If no keyType is provided, the
	// service will use the default setting (static-key). Allowable encryption types:
	// static-key.
	Encryption *types.UpdateEncryption

	//  The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int32

	//  The media streams that are associated with the output, and the parameters for
	// those associations.
	MediaStreamOutputConfigurations []types.MediaStreamOutputConfigurationRequest

	//  The minimum latency in milliseconds for SRT-based streams. In streams that use
	// the SRT protocol, this value that you set on your MediaConnect source or output
	// represents the minimal potential latency of that connection. The latency of the
	// stream is set to the highest number between the sender’s minimum latency and the
	// receiver’s minimum latency.
	MinLatency *int32

	//  A suffix for the names of the NDI sources that the flow creates. If a custom
	// name isn't specified, MediaConnect uses the output name.
	NdiProgramName *string

	// A quality setting for the NDI Speed HQ encoder.
	NdiSpeedHqQuality *int32

	//  An indication of whether the output should transmit data or not. If you don't
	// specify the outputStatus field in your request, MediaConnect leaves the value
	// unchanged.
	OutputStatus types.OutputStatus

	//  The port to use when content is distributed to this output.
	Port *int32

	//  The protocol to use for the output.
	//
	// Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This
	// reference is maintained for legacy purposes only.
	Protocol types.Protocol

	//  The remote ID for the Zixi-pull stream.
	RemoteId *string

	//  The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int32

	//  The IP address that the flow communicates with to initiate connection with the
	// sender.
	SenderIpAddress *string

	//  The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int32

	//  The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string

	//  The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *types.VpcInterfaceAttachment

	noSmithyDocumentSerde
}

type UpdateFlowOutputOutput struct {

	//  The ARN of the flow that is associated with the updated output.
	FlowArn *string

	//  The new settings of the output that you updated.
	Output *types.Output

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFlowOutputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateFlowOutput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateFlowOutput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateFlowOutput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateFlowOutputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFlowOutput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFlowOutput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateFlowOutput",
	}
}
