// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a state template. State templates contain state properties, which are
// signals that belong to a signal catalog that is synchronized between the Amazon
// Web Services IoT FleetWise Edge and the Amazon Web Services Cloud.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
func (c *Client) CreateStateTemplate(ctx context.Context, params *CreateStateTemplateInput, optFns ...func(*Options)) (*CreateStateTemplateOutput, error) {
	if params == nil {
		params = &CreateStateTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateStateTemplate", params, optFns, c.addOperationCreateStateTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateStateTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateStateTemplateInput struct {

	// The name of the state template.
	//
	// This member is required.
	Name *string

	// The ARN of the signal catalog associated with the state template.
	//
	// This member is required.
	SignalCatalogArn *string

	// A list of signals from which data is collected. The state template properties
	// contain the fully qualified names of the signals.
	//
	// This member is required.
	StateTemplateProperties []string

	// A list of vehicle attributes to associate with the payload published on the
	// state template's MQTT topic. (See [Processing last known state vehicle data using MQTT messaging]). For example, if you add
	// Vehicle.Attributes.Make and Vehicle.Attributes.Model attributes, Amazon Web
	// Services IoT FleetWise will enrich the protobuf encoded payload with those
	// attributes in the extraDimensions field.
	//
	// [Processing last known state vehicle data using MQTT messaging]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data
	DataExtraDimensions []string

	// A brief description of the state template.
	Description *string

	// A list of vehicle attributes to associate with user properties of the messages
	// published on the state template's MQTT topic. (See [Processing last known state vehicle data using MQTT messaging]). For example, if you add
	// Vehicle.Attributes.Make and Vehicle.Attributes.Model attributes, Amazon Web
	// Services IoT FleetWise will include these attributes as User Properties with the
	// MQTT message.
	//
	// Default: An empty array
	//
	// [Processing last known state vehicle data using MQTT messaging]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data
	MetadataExtraDimensions []string

	// Metadata that can be used to manage the state template.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateStateTemplateOutput struct {

	// The Amazon Resource Name (ARN) of the state template.
	Arn *string

	// The unique ID of the state template.
	Id *string

	// The name of the state template.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateStateTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateStateTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateStateTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateStateTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateStateTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateStateTemplate",
	}
}
